import { NpmConfig } from "projen/lib/javascript";
import { TypeScriptProject, TypeScriptProjectOptions } from "projen/lib/typescript";
/**
 * Configuration for the generated typescript client project
 */
export interface GeneratedTypescriptClientProjectOptions extends TypeScriptProjectOptions {
    /**
     * The absolute path to the OpenAPI specification (spec.yaml) from which to generate code
     */
    readonly specPath: string;
}
/**
 * Typescript project containing a typescript client (and lambda handler wrappers) generated using OpenAPI Generator CLI
 */
export declare class GeneratedTypescriptClientProject extends TypeScriptProject {
    /**
     * A reference to the npm config (generated for PNPM projects)
     */
    readonly npmConfig?: NpmConfig;
    private synthed;
    constructor(options: GeneratedTypescriptClientProjectOptions);
    /**
     * @inheritDoc
     */
    synth(): void;
}
