# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class ShipmentItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'seller_sku': 'str',
        'order_item_id': 'str',
        'order_adjustment_item_id': 'str',
        'quantity_shipped': 'int',
        'item_charge_list': 'ChargeComponentList',
        'item_charge_adjustment_list': 'ChargeComponentList',
        'item_fee_list': 'FeeComponentList',
        'item_fee_adjustment_list': 'FeeComponentList',
        'item_tax_withheld_list': 'TaxWithheldComponentList',
        'promotion_list': 'PromotionList',
        'promotion_adjustment_list': 'PromotionList',
        'cost_of_points_granted': 'Currency',
        'cost_of_points_returned': 'Currency'
    }

    attribute_map = {
        'seller_sku': 'SellerSKU',
        'order_item_id': 'OrderItemId',
        'order_adjustment_item_id': 'OrderAdjustmentItemId',
        'quantity_shipped': 'QuantityShipped',
        'item_charge_list': 'ItemChargeList',
        'item_charge_adjustment_list': 'ItemChargeAdjustmentList',
        'item_fee_list': 'ItemFeeList',
        'item_fee_adjustment_list': 'ItemFeeAdjustmentList',
        'item_tax_withheld_list': 'ItemTaxWithheldList',
        'promotion_list': 'PromotionList',
        'promotion_adjustment_list': 'PromotionAdjustmentList',
        'cost_of_points_granted': 'CostOfPointsGranted',
        'cost_of_points_returned': 'CostOfPointsReturned'
    }

    def __init__(self, seller_sku=None, order_item_id=None, order_adjustment_item_id=None, quantity_shipped=None, item_charge_list=None, item_charge_adjustment_list=None, item_fee_list=None, item_fee_adjustment_list=None, item_tax_withheld_list=None, promotion_list=None, promotion_adjustment_list=None, cost_of_points_granted=None, cost_of_points_returned=None):  # noqa: E501
        """ShipmentItem - a model defined in Swagger"""  # noqa: E501
        self._seller_sku = None
        self._order_item_id = None
        self._order_adjustment_item_id = None
        self._quantity_shipped = None
        self._item_charge_list = None
        self._item_charge_adjustment_list = None
        self._item_fee_list = None
        self._item_fee_adjustment_list = None
        self._item_tax_withheld_list = None
        self._promotion_list = None
        self._promotion_adjustment_list = None
        self._cost_of_points_granted = None
        self._cost_of_points_returned = None
        self.discriminator = None
        if seller_sku is not None:
            self.seller_sku = seller_sku
        if order_item_id is not None:
            self.order_item_id = order_item_id
        if order_adjustment_item_id is not None:
            self.order_adjustment_item_id = order_adjustment_item_id
        if quantity_shipped is not None:
            self.quantity_shipped = quantity_shipped
        if item_charge_list is not None:
            self.item_charge_list = item_charge_list
        if item_charge_adjustment_list is not None:
            self.item_charge_adjustment_list = item_charge_adjustment_list
        if item_fee_list is not None:
            self.item_fee_list = item_fee_list
        if item_fee_adjustment_list is not None:
            self.item_fee_adjustment_list = item_fee_adjustment_list
        if item_tax_withheld_list is not None:
            self.item_tax_withheld_list = item_tax_withheld_list
        if promotion_list is not None:
            self.promotion_list = promotion_list
        if promotion_adjustment_list is not None:
            self.promotion_adjustment_list = promotion_adjustment_list
        if cost_of_points_granted is not None:
            self.cost_of_points_granted = cost_of_points_granted
        if cost_of_points_returned is not None:
            self.cost_of_points_returned = cost_of_points_returned

    @property
    def seller_sku(self):
        """Gets the seller_sku of this ShipmentItem.  # noqa: E501

        The seller SKU of the item. The seller SKU is qualified by the seller's seller ID, which is included with every call to the Selling Partner API.  # noqa: E501

        :return: The seller_sku of this ShipmentItem.  # noqa: E501
        :rtype: str
        """
        return self._seller_sku

    @seller_sku.setter
    def seller_sku(self, seller_sku):
        """Sets the seller_sku of this ShipmentItem.

        The seller SKU of the item. The seller SKU is qualified by the seller's seller ID, which is included with every call to the Selling Partner API.  # noqa: E501

        :param seller_sku: The seller_sku of this ShipmentItem.  # noqa: E501
        :type: str
        """

        self._seller_sku = seller_sku

    @property
    def order_item_id(self):
        """Gets the order_item_id of this ShipmentItem.  # noqa: E501

        An Amazon-defined order item identifier.  # noqa: E501

        :return: The order_item_id of this ShipmentItem.  # noqa: E501
        :rtype: str
        """
        return self._order_item_id

    @order_item_id.setter
    def order_item_id(self, order_item_id):
        """Sets the order_item_id of this ShipmentItem.

        An Amazon-defined order item identifier.  # noqa: E501

        :param order_item_id: The order_item_id of this ShipmentItem.  # noqa: E501
        :type: str
        """

        self._order_item_id = order_item_id

    @property
    def order_adjustment_item_id(self):
        """Gets the order_adjustment_item_id of this ShipmentItem.  # noqa: E501

        An Amazon-defined order adjustment identifier defined for refunds, guarantee claims, and chargeback events.  # noqa: E501

        :return: The order_adjustment_item_id of this ShipmentItem.  # noqa: E501
        :rtype: str
        """
        return self._order_adjustment_item_id

    @order_adjustment_item_id.setter
    def order_adjustment_item_id(self, order_adjustment_item_id):
        """Sets the order_adjustment_item_id of this ShipmentItem.

        An Amazon-defined order adjustment identifier defined for refunds, guarantee claims, and chargeback events.  # noqa: E501

        :param order_adjustment_item_id: The order_adjustment_item_id of this ShipmentItem.  # noqa: E501
        :type: str
        """

        self._order_adjustment_item_id = order_adjustment_item_id

    @property
    def quantity_shipped(self):
        """Gets the quantity_shipped of this ShipmentItem.  # noqa: E501

        The number of items shipped.  # noqa: E501

        :return: The quantity_shipped of this ShipmentItem.  # noqa: E501
        :rtype: int
        """
        return self._quantity_shipped

    @quantity_shipped.setter
    def quantity_shipped(self, quantity_shipped):
        """Sets the quantity_shipped of this ShipmentItem.

        The number of items shipped.  # noqa: E501

        :param quantity_shipped: The quantity_shipped of this ShipmentItem.  # noqa: E501
        :type: int
        """

        self._quantity_shipped = quantity_shipped

    @property
    def item_charge_list(self):
        """Gets the item_charge_list of this ShipmentItem.  # noqa: E501


        :return: The item_charge_list of this ShipmentItem.  # noqa: E501
        :rtype: ChargeComponentList
        """
        return self._item_charge_list

    @item_charge_list.setter
    def item_charge_list(self, item_charge_list):
        """Sets the item_charge_list of this ShipmentItem.


        :param item_charge_list: The item_charge_list of this ShipmentItem.  # noqa: E501
        :type: ChargeComponentList
        """

        self._item_charge_list = item_charge_list

    @property
    def item_charge_adjustment_list(self):
        """Gets the item_charge_adjustment_list of this ShipmentItem.  # noqa: E501


        :return: The item_charge_adjustment_list of this ShipmentItem.  # noqa: E501
        :rtype: ChargeComponentList
        """
        return self._item_charge_adjustment_list

    @item_charge_adjustment_list.setter
    def item_charge_adjustment_list(self, item_charge_adjustment_list):
        """Sets the item_charge_adjustment_list of this ShipmentItem.


        :param item_charge_adjustment_list: The item_charge_adjustment_list of this ShipmentItem.  # noqa: E501
        :type: ChargeComponentList
        """

        self._item_charge_adjustment_list = item_charge_adjustment_list

    @property
    def item_fee_list(self):
        """Gets the item_fee_list of this ShipmentItem.  # noqa: E501


        :return: The item_fee_list of this ShipmentItem.  # noqa: E501
        :rtype: FeeComponentList
        """
        return self._item_fee_list

    @item_fee_list.setter
    def item_fee_list(self, item_fee_list):
        """Sets the item_fee_list of this ShipmentItem.


        :param item_fee_list: The item_fee_list of this ShipmentItem.  # noqa: E501
        :type: FeeComponentList
        """

        self._item_fee_list = item_fee_list

    @property
    def item_fee_adjustment_list(self):
        """Gets the item_fee_adjustment_list of this ShipmentItem.  # noqa: E501


        :return: The item_fee_adjustment_list of this ShipmentItem.  # noqa: E501
        :rtype: FeeComponentList
        """
        return self._item_fee_adjustment_list

    @item_fee_adjustment_list.setter
    def item_fee_adjustment_list(self, item_fee_adjustment_list):
        """Sets the item_fee_adjustment_list of this ShipmentItem.


        :param item_fee_adjustment_list: The item_fee_adjustment_list of this ShipmentItem.  # noqa: E501
        :type: FeeComponentList
        """

        self._item_fee_adjustment_list = item_fee_adjustment_list

    @property
    def item_tax_withheld_list(self):
        """Gets the item_tax_withheld_list of this ShipmentItem.  # noqa: E501


        :return: The item_tax_withheld_list of this ShipmentItem.  # noqa: E501
        :rtype: TaxWithheldComponentList
        """
        return self._item_tax_withheld_list

    @item_tax_withheld_list.setter
    def item_tax_withheld_list(self, item_tax_withheld_list):
        """Sets the item_tax_withheld_list of this ShipmentItem.


        :param item_tax_withheld_list: The item_tax_withheld_list of this ShipmentItem.  # noqa: E501
        :type: TaxWithheldComponentList
        """

        self._item_tax_withheld_list = item_tax_withheld_list

    @property
    def promotion_list(self):
        """Gets the promotion_list of this ShipmentItem.  # noqa: E501


        :return: The promotion_list of this ShipmentItem.  # noqa: E501
        :rtype: PromotionList
        """
        return self._promotion_list

    @promotion_list.setter
    def promotion_list(self, promotion_list):
        """Sets the promotion_list of this ShipmentItem.


        :param promotion_list: The promotion_list of this ShipmentItem.  # noqa: E501
        :type: PromotionList
        """

        self._promotion_list = promotion_list

    @property
    def promotion_adjustment_list(self):
        """Gets the promotion_adjustment_list of this ShipmentItem.  # noqa: E501


        :return: The promotion_adjustment_list of this ShipmentItem.  # noqa: E501
        :rtype: PromotionList
        """
        return self._promotion_adjustment_list

    @promotion_adjustment_list.setter
    def promotion_adjustment_list(self, promotion_adjustment_list):
        """Sets the promotion_adjustment_list of this ShipmentItem.


        :param promotion_adjustment_list: The promotion_adjustment_list of this ShipmentItem.  # noqa: E501
        :type: PromotionList
        """

        self._promotion_adjustment_list = promotion_adjustment_list

    @property
    def cost_of_points_granted(self):
        """Gets the cost_of_points_granted of this ShipmentItem.  # noqa: E501


        :return: The cost_of_points_granted of this ShipmentItem.  # noqa: E501
        :rtype: Currency
        """
        return self._cost_of_points_granted

    @cost_of_points_granted.setter
    def cost_of_points_granted(self, cost_of_points_granted):
        """Sets the cost_of_points_granted of this ShipmentItem.


        :param cost_of_points_granted: The cost_of_points_granted of this ShipmentItem.  # noqa: E501
        :type: Currency
        """

        self._cost_of_points_granted = cost_of_points_granted

    @property
    def cost_of_points_returned(self):
        """Gets the cost_of_points_returned of this ShipmentItem.  # noqa: E501


        :return: The cost_of_points_returned of this ShipmentItem.  # noqa: E501
        :rtype: Currency
        """
        return self._cost_of_points_returned

    @cost_of_points_returned.setter
    def cost_of_points_returned(self, cost_of_points_returned):
        """Sets the cost_of_points_returned of this ShipmentItem.


        :param cost_of_points_returned: The cost_of_points_returned of this ShipmentItem.  # noqa: E501
        :type: Currency
        """

        self._cost_of_points_returned = cost_of_points_returned

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ShipmentItem, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ShipmentItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
