"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.targetToTargetString = exports.parseTargetString = void 0;
const project_graph_1 = require("nx/src/project-graph/project-graph");
const split_target_1 = require("nx/src/utils/split-target");
function parseTargetString(targetString, projectGraph = (0, project_graph_1.readCachedProjectGraph)()) {
    const [project, target, configuration] = (0, split_target_1.splitTarget)(targetString, projectGraph);
    if (!project || !target) {
        throw new Error(`Invalid Target String: ${targetString}`);
    }
    return {
        project,
        target,
        configuration,
    };
}
exports.parseTargetString = parseTargetString;
/**
 * Returns a string in the format "project:target[:configuration]" for the target
 *
 * @param target - target object
 *
 * Examples:
 *
 * ```typescript
 * targetToTargetString({ project: "proj", target: "test" }) // returns "proj:test"
 * targetToTargetString({ project: "proj", target: "test", configuration: "production" }) // returns "proj:test:production"
 * ```
 */
function targetToTargetString({ project, target, configuration, }) {
    return `${project}:${target.indexOf(':') > -1 ? `"${target}"` : target}${configuration !== undefined ? ':' + configuration : ''}`;
}
exports.targetToTargetString = targetToTargetString;
//# sourceMappingURL=parse-target-string.js.map