"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionEnvironmentSecret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const action_environment_secrets_1 = require("../handler/secrets/action-environment-secrets");
class ActionEnvironmentSecret extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { githubTokenSecret, repositorySecretName, repositoryName, repositoryOwner, sourceSecret, sourceSecretJsonField, environment } = props;
        const awsRegion = aws_cdk_lib_1.Stack.of(this).region;
        const shortId = aws_cdk_lib_1.Names.uniqueId(this).slice(-8);
        const handler = new action_environment_secrets_1.ActionEnvironmentSecretHandlerFunction(this, 'CustomResourceHandler', {
            functionName: 'GitHubActionEnvironmentSecretCustomResourceHandler' + shortId,
            description: 'Handles the creation/deletion of a GitHub Action environment secret - created by cdk-github',
            architecture: aws_lambda_1.Architecture.ARM_64,
            timeout: aws_cdk_lib_1.Duration.minutes(10),
        });
        githubTokenSecret.grantRead(handler);
        sourceSecret.grantRead(handler);
        const provider = new custom_resources_1.Provider(this, 'CustomResourceProvider', {
            onEventHandler: handler,
            logRetention: aws_logs_1.RetentionDays.ONE_WEEK,
        });
        const githubRepositorySecretEventProps = {
            environment,
            githubTokenSecret: githubTokenSecret.secretArn,
            repositoryOwner,
            repositoryName,
            sourceSecretArn: sourceSecret.secretArn,
            sourceSecretJsonField,
            repositorySecretName,
            awsRegion,
        };
        new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::GitHubActionEnvironmentSecret',
            properties: githubRepositorySecretEventProps,
        });
    }
}
exports.ActionEnvironmentSecret = ActionEnvironmentSecret;
_a = JSII_RTTI_SYMBOL_1;
ActionEnvironmentSecret[_a] = { fqn: "cdk-github.ActionEnvironmentSecret", version: "0.0.35" };
//# sourceMappingURL=data:application/json;base64,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