import { ISecret } from 'aws-cdk-lib/aws-secretsmanager';
import { Construct } from 'constructs';
export interface ActionSecretProps {
    /**
     * The AWS secret in which the OAuth GitHub (personal) access token is stored
     */
    readonly githubTokenSecret: ISecret;
    /**
     * The GitHub repository name
     */
    readonly repositoryName: string;
    /**
     * The GitHub repository owner
     * @default - user account which owns the token
     */
    readonly repositoryOwner?: string;
    /**
     * The GitHub secret name to be stored
     */
    readonly repositorySecretName: string;
    /**
     * This AWS secret value will be stored in GitHub as a secret (under the name of repositorySecretName)
     */
    readonly sourceSecret: ISecret;
    /**
     * The key of a JSON field to retrieve in sourceSecret.
     * This can only be used if the secret stores a JSON object.
     *
     * @default - returns all the content stored in the Secrets Manager secret.
     */
    readonly sourceSecretJsonField?: string;
}
export declare class ActionSecret extends Construct {
    constructor(scope: Construct, id: string, props: ActionSecretProps);
}
