"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitHubResourceIssueStack = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_secretsmanager_1 = require("aws-cdk-lib/aws-secretsmanager");
const aws_ssm_1 = require("aws-cdk-lib/aws-ssm");
const constructs_1 = require("../../constructs");
class GitHubResourceIssueStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const githubTokenSecret = aws_secretsmanager_1.Secret.fromSecretNameV2(this, 'ghSecret', 'GITHUB_TOKEN');
        const createRequestResultParameter = 'number';
        const writeResponseToSSMParameter = aws_ssm_1.StringParameter.fromSecureStringParameterAttributes(this, 'responseBody', { parameterName: '/cdk-github/encrypted-response' });
        new constructs_1.GitHubResource(this, 'GitHubIssue', {
            githubTokenSecret,
            createRequestEndpoint: 'POST /repos/WtfJoke/dummytest/issues',
            createRequestPayload: JSON.stringify({ title: 'Testing cdk-github', body: "I'm opening an issue by using aws cdk 🎉", labels: ['bug'] }),
            createRequestResultParameter,
            deleteRequestEndpoint: `PATCH /repos/WtfJoke/dummytest/issues/:${createRequestResultParameter}`,
            deleteRequestPayload: JSON.stringify({ state: 'closed' }),
            writeResponseToSSMParameter,
        });
    }
}
exports.GitHubResourceIssueStack = GitHubResourceIssueStack;
//# sourceMappingURL=data:application/json;base64,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