"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateSecretName = exports.isValidSecretName = void 0;
exports.isValidSecretName = (secretName) => {
    if (secretName.startsWith('GITHUB_')) {
        return false;
    }
    const secretNameRegex = /^[a-zA-Z0-9_]+$/;
    return secretNameRegex.test(secretName);
};
exports.validateSecretName = (secretName) => {
    if (!exports.isValidSecretName(secretName)) {
        throw new Error(`Invalid GitHub secret name: ${secretName}`);
    }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2l0aHViLXNlY3JldC1uYW1lLXZhbGlkYXRvci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9oYW5kbGVyL3NlY3JldHMvZ2l0aHViLXNlY3JldC1uYW1lLXZhbGlkYXRvci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBYSxRQUFBLGlCQUFpQixHQUFHLENBQUMsVUFBa0IsRUFBVyxFQUFFO0lBQy9ELElBQUksVUFBVSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsRUFBRTtRQUNwQyxPQUFPLEtBQUssQ0FBQztLQUNkO0lBQ0QsTUFBTSxlQUFlLEdBQUcsaUJBQWlCLENBQUM7SUFDMUMsT0FBTyxlQUFlLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO0FBQzFDLENBQUMsQ0FBQztBQUVXLFFBQUEsa0JBQWtCLEdBQUcsQ0FBQyxVQUFrQixFQUFFLEVBQUU7SUFDdkQsSUFBSSxDQUFDLHlCQUFpQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsK0JBQStCLFVBQVUsRUFBRSxDQUFDLENBQUM7S0FDOUQ7QUFDSCxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgY29uc3QgaXNWYWxpZFNlY3JldE5hbWUgPSAoc2VjcmV0TmFtZTogc3RyaW5nKTogYm9vbGVhbiA9PiB7XG4gIGlmIChzZWNyZXROYW1lLnN0YXJ0c1dpdGgoJ0dJVEhVQl8nKSkge1xuICAgIHJldHVybiBmYWxzZTtcbiAgfVxuICBjb25zdCBzZWNyZXROYW1lUmVnZXggPSAvXlthLXpBLVowLTlfXSskLztcbiAgcmV0dXJuIHNlY3JldE5hbWVSZWdleC50ZXN0KHNlY3JldE5hbWUpO1xufTtcblxuZXhwb3J0IGNvbnN0IHZhbGlkYXRlU2VjcmV0TmFtZSA9IChzZWNyZXROYW1lOiBzdHJpbmcpID0+IHtcbiAgaWYgKCFpc1ZhbGlkU2VjcmV0TmFtZShzZWNyZXROYW1lKSkge1xuICAgIHRocm93IG5ldyBFcnJvcihgSW52YWxpZCBHaXRIdWIgc2VjcmV0IG5hbWU6ICR7c2VjcmV0TmFtZX1gKTtcbiAgfVxufTtcbiJdfQ==