import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ReplicateSecretToRegionsRequest, ReplicateSecretToRegionsResponse } from "../models/models_0";
import { deserializeAws_json1_1ReplicateSecretToRegionsCommand, serializeAws_json1_1ReplicateSecretToRegionsCommand, } from "../protocols/Aws_json1_1";
var ReplicateSecretToRegionsCommand = (function (_super) {
    __extends(ReplicateSecretToRegionsCommand, _super);
    function ReplicateSecretToRegionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ReplicateSecretToRegionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SecretsManagerClient";
        var commandName = "ReplicateSecretToRegionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ReplicateSecretToRegionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ReplicateSecretToRegionsResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ReplicateSecretToRegionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1ReplicateSecretToRegionsCommand(input, context);
    };
    ReplicateSecretToRegionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1ReplicateSecretToRegionsCommand(output, context);
    };
    return ReplicateSecretToRegionsCommand;
}($Command));
export { ReplicateSecretToRegionsCommand };
