import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { StopReplicationToReplicaRequest, StopReplicationToReplicaResponse } from "../models/models_0";
import { deserializeAws_json1_1StopReplicationToReplicaCommand, serializeAws_json1_1StopReplicationToReplicaCommand, } from "../protocols/Aws_json1_1";
var StopReplicationToReplicaCommand = (function (_super) {
    __extends(StopReplicationToReplicaCommand, _super);
    function StopReplicationToReplicaCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    StopReplicationToReplicaCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SecretsManagerClient";
        var commandName = "StopReplicationToReplicaCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: StopReplicationToReplicaRequest.filterSensitiveLog,
            outputFilterSensitiveLog: StopReplicationToReplicaResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    StopReplicationToReplicaCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1StopReplicationToReplicaCommand(input, context);
    };
    StopReplicationToReplicaCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1StopReplicationToReplicaCommand(output, context);
    };
    return StopReplicationToReplicaCommand;
}($Command));
export { StopReplicationToReplicaCommand };
