import { __assign, __extends } from "tslib";
import { SENSITIVE_STRING } from "@aws-sdk/smithy-client";
import { SecretsManagerServiceException as __BaseException } from "./SecretsManagerServiceException";
export var ReplicaRegionType;
(function (ReplicaRegionType) {
    ReplicaRegionType.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ReplicaRegionType || (ReplicaRegionType = {}));
export var CancelRotateSecretRequest;
(function (CancelRotateSecretRequest) {
    CancelRotateSecretRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(CancelRotateSecretRequest || (CancelRotateSecretRequest = {}));
export var CancelRotateSecretResponse;
(function (CancelRotateSecretResponse) {
    CancelRotateSecretResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(CancelRotateSecretResponse || (CancelRotateSecretResponse = {}));
var InternalServiceError = (function (_super) {
    __extends(InternalServiceError, _super);
    function InternalServiceError(opts) {
        var _this = _super.call(this, __assign({ name: "InternalServiceError", $fault: "server" }, opts)) || this;
        _this.name = "InternalServiceError";
        _this.$fault = "server";
        Object.setPrototypeOf(_this, InternalServiceError.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InternalServiceError;
}(__BaseException));
export { InternalServiceError };
var InvalidParameterException = (function (_super) {
    __extends(InvalidParameterException, _super);
    function InvalidParameterException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidParameterException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidParameterException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidParameterException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidParameterException;
}(__BaseException));
export { InvalidParameterException };
var InvalidRequestException = (function (_super) {
    __extends(InvalidRequestException, _super);
    function InvalidRequestException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidRequestException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidRequestException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidRequestException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidRequestException;
}(__BaseException));
export { InvalidRequestException };
var ResourceNotFoundException = (function (_super) {
    __extends(ResourceNotFoundException, _super);
    function ResourceNotFoundException(opts) {
        var _this = _super.call(this, __assign({ name: "ResourceNotFoundException", $fault: "client" }, opts)) || this;
        _this.name = "ResourceNotFoundException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ResourceNotFoundException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return ResourceNotFoundException;
}(__BaseException));
export { ResourceNotFoundException };
export var Tag;
(function (Tag) {
    Tag.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(Tag || (Tag = {}));
export var CreateSecretRequest;
(function (CreateSecretRequest) {
    CreateSecretRequest.filterSensitiveLog = function (obj) { return (__assign(__assign(__assign({}, obj), (obj.SecretBinary && { SecretBinary: SENSITIVE_STRING })), (obj.SecretString && { SecretString: SENSITIVE_STRING }))); };
})(CreateSecretRequest || (CreateSecretRequest = {}));
export var StatusType;
(function (StatusType) {
    StatusType["Failed"] = "Failed";
    StatusType["InProgress"] = "InProgress";
    StatusType["InSync"] = "InSync";
})(StatusType || (StatusType = {}));
export var ReplicationStatusType;
(function (ReplicationStatusType) {
    ReplicationStatusType.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ReplicationStatusType || (ReplicationStatusType = {}));
export var CreateSecretResponse;
(function (CreateSecretResponse) {
    CreateSecretResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(CreateSecretResponse || (CreateSecretResponse = {}));
var DecryptionFailure = (function (_super) {
    __extends(DecryptionFailure, _super);
    function DecryptionFailure(opts) {
        var _this = _super.call(this, __assign({ name: "DecryptionFailure", $fault: "client" }, opts)) || this;
        _this.name = "DecryptionFailure";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, DecryptionFailure.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return DecryptionFailure;
}(__BaseException));
export { DecryptionFailure };
var EncryptionFailure = (function (_super) {
    __extends(EncryptionFailure, _super);
    function EncryptionFailure(opts) {
        var _this = _super.call(this, __assign({ name: "EncryptionFailure", $fault: "client" }, opts)) || this;
        _this.name = "EncryptionFailure";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, EncryptionFailure.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return EncryptionFailure;
}(__BaseException));
export { EncryptionFailure };
var LimitExceededException = (function (_super) {
    __extends(LimitExceededException, _super);
    function LimitExceededException(opts) {
        var _this = _super.call(this, __assign({ name: "LimitExceededException", $fault: "client" }, opts)) || this;
        _this.name = "LimitExceededException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, LimitExceededException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return LimitExceededException;
}(__BaseException));
export { LimitExceededException };
var MalformedPolicyDocumentException = (function (_super) {
    __extends(MalformedPolicyDocumentException, _super);
    function MalformedPolicyDocumentException(opts) {
        var _this = _super.call(this, __assign({ name: "MalformedPolicyDocumentException", $fault: "client" }, opts)) || this;
        _this.name = "MalformedPolicyDocumentException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, MalformedPolicyDocumentException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return MalformedPolicyDocumentException;
}(__BaseException));
export { MalformedPolicyDocumentException };
var PreconditionNotMetException = (function (_super) {
    __extends(PreconditionNotMetException, _super);
    function PreconditionNotMetException(opts) {
        var _this = _super.call(this, __assign({ name: "PreconditionNotMetException", $fault: "client" }, opts)) || this;
        _this.name = "PreconditionNotMetException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, PreconditionNotMetException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return PreconditionNotMetException;
}(__BaseException));
export { PreconditionNotMetException };
var ResourceExistsException = (function (_super) {
    __extends(ResourceExistsException, _super);
    function ResourceExistsException(opts) {
        var _this = _super.call(this, __assign({ name: "ResourceExistsException", $fault: "client" }, opts)) || this;
        _this.name = "ResourceExistsException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ResourceExistsException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return ResourceExistsException;
}(__BaseException));
export { ResourceExistsException };
export var DeleteResourcePolicyRequest;
(function (DeleteResourcePolicyRequest) {
    DeleteResourcePolicyRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteResourcePolicyRequest || (DeleteResourcePolicyRequest = {}));
export var DeleteResourcePolicyResponse;
(function (DeleteResourcePolicyResponse) {
    DeleteResourcePolicyResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteResourcePolicyResponse || (DeleteResourcePolicyResponse = {}));
export var DeleteSecretRequest;
(function (DeleteSecretRequest) {
    DeleteSecretRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteSecretRequest || (DeleteSecretRequest = {}));
export var DeleteSecretResponse;
(function (DeleteSecretResponse) {
    DeleteSecretResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteSecretResponse || (DeleteSecretResponse = {}));
export var DescribeSecretRequest;
(function (DescribeSecretRequest) {
    DescribeSecretRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeSecretRequest || (DescribeSecretRequest = {}));
export var RotationRulesType;
(function (RotationRulesType) {
    RotationRulesType.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(RotationRulesType || (RotationRulesType = {}));
export var DescribeSecretResponse;
(function (DescribeSecretResponse) {
    DescribeSecretResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeSecretResponse || (DescribeSecretResponse = {}));
export var Filter;
(function (Filter) {
    Filter.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(Filter || (Filter = {}));
export var GetRandomPasswordRequest;
(function (GetRandomPasswordRequest) {
    GetRandomPasswordRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(GetRandomPasswordRequest || (GetRandomPasswordRequest = {}));
export var GetRandomPasswordResponse;
(function (GetRandomPasswordResponse) {
    GetRandomPasswordResponse.filterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.RandomPassword && { RandomPassword: SENSITIVE_STRING }))); };
})(GetRandomPasswordResponse || (GetRandomPasswordResponse = {}));
export var GetResourcePolicyRequest;
(function (GetResourcePolicyRequest) {
    GetResourcePolicyRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(GetResourcePolicyRequest || (GetResourcePolicyRequest = {}));
export var GetResourcePolicyResponse;
(function (GetResourcePolicyResponse) {
    GetResourcePolicyResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(GetResourcePolicyResponse || (GetResourcePolicyResponse = {}));
export var GetSecretValueRequest;
(function (GetSecretValueRequest) {
    GetSecretValueRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(GetSecretValueRequest || (GetSecretValueRequest = {}));
export var GetSecretValueResponse;
(function (GetSecretValueResponse) {
    GetSecretValueResponse.filterSensitiveLog = function (obj) { return (__assign(__assign(__assign({}, obj), (obj.SecretBinary && { SecretBinary: SENSITIVE_STRING })), (obj.SecretString && { SecretString: SENSITIVE_STRING }))); };
})(GetSecretValueResponse || (GetSecretValueResponse = {}));
var InvalidNextTokenException = (function (_super) {
    __extends(InvalidNextTokenException, _super);
    function InvalidNextTokenException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidNextTokenException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidNextTokenException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidNextTokenException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidNextTokenException;
}(__BaseException));
export { InvalidNextTokenException };
export var SortOrderType;
(function (SortOrderType) {
    SortOrderType["asc"] = "asc";
    SortOrderType["desc"] = "desc";
})(SortOrderType || (SortOrderType = {}));
export var ListSecretsRequest;
(function (ListSecretsRequest) {
    ListSecretsRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ListSecretsRequest || (ListSecretsRequest = {}));
export var SecretListEntry;
(function (SecretListEntry) {
    SecretListEntry.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(SecretListEntry || (SecretListEntry = {}));
export var ListSecretsResponse;
(function (ListSecretsResponse) {
    ListSecretsResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ListSecretsResponse || (ListSecretsResponse = {}));
export var ListSecretVersionIdsRequest;
(function (ListSecretVersionIdsRequest) {
    ListSecretVersionIdsRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ListSecretVersionIdsRequest || (ListSecretVersionIdsRequest = {}));
export var SecretVersionsListEntry;
(function (SecretVersionsListEntry) {
    SecretVersionsListEntry.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(SecretVersionsListEntry || (SecretVersionsListEntry = {}));
export var ListSecretVersionIdsResponse;
(function (ListSecretVersionIdsResponse) {
    ListSecretVersionIdsResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ListSecretVersionIdsResponse || (ListSecretVersionIdsResponse = {}));
var PublicPolicyException = (function (_super) {
    __extends(PublicPolicyException, _super);
    function PublicPolicyException(opts) {
        var _this = _super.call(this, __assign({ name: "PublicPolicyException", $fault: "client" }, opts)) || this;
        _this.name = "PublicPolicyException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, PublicPolicyException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return PublicPolicyException;
}(__BaseException));
export { PublicPolicyException };
export var PutResourcePolicyRequest;
(function (PutResourcePolicyRequest) {
    PutResourcePolicyRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(PutResourcePolicyRequest || (PutResourcePolicyRequest = {}));
export var PutResourcePolicyResponse;
(function (PutResourcePolicyResponse) {
    PutResourcePolicyResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(PutResourcePolicyResponse || (PutResourcePolicyResponse = {}));
export var PutSecretValueRequest;
(function (PutSecretValueRequest) {
    PutSecretValueRequest.filterSensitiveLog = function (obj) { return (__assign(__assign(__assign({}, obj), (obj.SecretBinary && { SecretBinary: SENSITIVE_STRING })), (obj.SecretString && { SecretString: SENSITIVE_STRING }))); };
})(PutSecretValueRequest || (PutSecretValueRequest = {}));
export var PutSecretValueResponse;
(function (PutSecretValueResponse) {
    PutSecretValueResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(PutSecretValueResponse || (PutSecretValueResponse = {}));
export var RemoveRegionsFromReplicationRequest;
(function (RemoveRegionsFromReplicationRequest) {
    RemoveRegionsFromReplicationRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(RemoveRegionsFromReplicationRequest || (RemoveRegionsFromReplicationRequest = {}));
export var RemoveRegionsFromReplicationResponse;
(function (RemoveRegionsFromReplicationResponse) {
    RemoveRegionsFromReplicationResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(RemoveRegionsFromReplicationResponse || (RemoveRegionsFromReplicationResponse = {}));
export var ReplicateSecretToRegionsRequest;
(function (ReplicateSecretToRegionsRequest) {
    ReplicateSecretToRegionsRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ReplicateSecretToRegionsRequest || (ReplicateSecretToRegionsRequest = {}));
export var ReplicateSecretToRegionsResponse;
(function (ReplicateSecretToRegionsResponse) {
    ReplicateSecretToRegionsResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ReplicateSecretToRegionsResponse || (ReplicateSecretToRegionsResponse = {}));
export var RestoreSecretRequest;
(function (RestoreSecretRequest) {
    RestoreSecretRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(RestoreSecretRequest || (RestoreSecretRequest = {}));
export var RestoreSecretResponse;
(function (RestoreSecretResponse) {
    RestoreSecretResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(RestoreSecretResponse || (RestoreSecretResponse = {}));
export var RotateSecretRequest;
(function (RotateSecretRequest) {
    RotateSecretRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(RotateSecretRequest || (RotateSecretRequest = {}));
export var RotateSecretResponse;
(function (RotateSecretResponse) {
    RotateSecretResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(RotateSecretResponse || (RotateSecretResponse = {}));
export var StopReplicationToReplicaRequest;
(function (StopReplicationToReplicaRequest) {
    StopReplicationToReplicaRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(StopReplicationToReplicaRequest || (StopReplicationToReplicaRequest = {}));
export var StopReplicationToReplicaResponse;
(function (StopReplicationToReplicaResponse) {
    StopReplicationToReplicaResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(StopReplicationToReplicaResponse || (StopReplicationToReplicaResponse = {}));
export var TagResourceRequest;
(function (TagResourceRequest) {
    TagResourceRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(TagResourceRequest || (TagResourceRequest = {}));
export var UntagResourceRequest;
(function (UntagResourceRequest) {
    UntagResourceRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(UntagResourceRequest || (UntagResourceRequest = {}));
export var UpdateSecretRequest;
(function (UpdateSecretRequest) {
    UpdateSecretRequest.filterSensitiveLog = function (obj) { return (__assign(__assign(__assign({}, obj), (obj.SecretBinary && { SecretBinary: SENSITIVE_STRING })), (obj.SecretString && { SecretString: SENSITIVE_STRING }))); };
})(UpdateSecretRequest || (UpdateSecretRequest = {}));
export var UpdateSecretResponse;
(function (UpdateSecretResponse) {
    UpdateSecretResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(UpdateSecretResponse || (UpdateSecretResponse = {}));
export var UpdateSecretVersionStageRequest;
(function (UpdateSecretVersionStageRequest) {
    UpdateSecretVersionStageRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(UpdateSecretVersionStageRequest || (UpdateSecretVersionStageRequest = {}));
export var UpdateSecretVersionStageResponse;
(function (UpdateSecretVersionStageResponse) {
    UpdateSecretVersionStageResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(UpdateSecretVersionStageResponse || (UpdateSecretVersionStageResponse = {}));
export var ValidateResourcePolicyRequest;
(function (ValidateResourcePolicyRequest) {
    ValidateResourcePolicyRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ValidateResourcePolicyRequest || (ValidateResourcePolicyRequest = {}));
export var ValidationErrorsEntry;
(function (ValidationErrorsEntry) {
    ValidationErrorsEntry.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ValidationErrorsEntry || (ValidationErrorsEntry = {}));
export var ValidateResourcePolicyResponse;
(function (ValidateResourcePolicyResponse) {
    ValidateResourcePolicyResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ValidateResourcePolicyResponse || (ValidateResourcePolicyResponse = {}));
