import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { SecretsManagerServiceException as __BaseException } from "./SecretsManagerServiceException";

export interface ReplicaRegionType {
    
    Region?: string;
    
    KmsKeyId?: string;
}
export declare namespace ReplicaRegionType {
    
    const filterSensitiveLog: (obj: ReplicaRegionType) => any;
}
export interface CancelRotateSecretRequest {
    
    SecretId: string | undefined;
}
export declare namespace CancelRotateSecretRequest {
    
    const filterSensitiveLog: (obj: CancelRotateSecretRequest) => any;
}
export interface CancelRotateSecretResponse {
    
    ARN?: string;
    
    Name?: string;
    
    VersionId?: string;
}
export declare namespace CancelRotateSecretResponse {
    
    const filterSensitiveLog: (obj: CancelRotateSecretResponse) => any;
}

export declare class InternalServiceError extends __BaseException {
    readonly name: "InternalServiceError";
    readonly $fault: "server";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InternalServiceError, __BaseException>);
}

export declare class InvalidParameterException extends __BaseException {
    readonly name: "InvalidParameterException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidParameterException, __BaseException>);
}

export declare class InvalidRequestException extends __BaseException {
    readonly name: "InvalidRequestException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidRequestException, __BaseException>);
}

export declare class ResourceNotFoundException extends __BaseException {
    readonly name: "ResourceNotFoundException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ResourceNotFoundException, __BaseException>);
}

export interface Tag {
    
    Key?: string;
    
    Value?: string;
}
export declare namespace Tag {
    
    const filterSensitiveLog: (obj: Tag) => any;
}
export interface CreateSecretRequest {
    
    Name: string | undefined;
    
    ClientRequestToken?: string;
    
    Description?: string;
    
    KmsKeyId?: string;
    
    SecretBinary?: Uint8Array;
    
    SecretString?: string;
    
    Tags?: Tag[];
    
    AddReplicaRegions?: ReplicaRegionType[];
    
    ForceOverwriteReplicaSecret?: boolean;
}
export declare namespace CreateSecretRequest {
    
    const filterSensitiveLog: (obj: CreateSecretRequest) => any;
}
export declare enum StatusType {
    Failed = "Failed",
    InProgress = "InProgress",
    InSync = "InSync"
}

export interface ReplicationStatusType {
    
    Region?: string;
    
    KmsKeyId?: string;
    
    Status?: StatusType | string;
    
    StatusMessage?: string;
    
    LastAccessedDate?: Date;
}
export declare namespace ReplicationStatusType {
    
    const filterSensitiveLog: (obj: ReplicationStatusType) => any;
}
export interface CreateSecretResponse {
    
    ARN?: string;
    
    Name?: string;
    
    VersionId?: string;
    
    ReplicationStatus?: ReplicationStatusType[];
}
export declare namespace CreateSecretResponse {
    
    const filterSensitiveLog: (obj: CreateSecretResponse) => any;
}

export declare class DecryptionFailure extends __BaseException {
    readonly name: "DecryptionFailure";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<DecryptionFailure, __BaseException>);
}

export declare class EncryptionFailure extends __BaseException {
    readonly name: "EncryptionFailure";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<EncryptionFailure, __BaseException>);
}

export declare class LimitExceededException extends __BaseException {
    readonly name: "LimitExceededException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<LimitExceededException, __BaseException>);
}

export declare class MalformedPolicyDocumentException extends __BaseException {
    readonly name: "MalformedPolicyDocumentException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<MalformedPolicyDocumentException, __BaseException>);
}

export declare class PreconditionNotMetException extends __BaseException {
    readonly name: "PreconditionNotMetException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<PreconditionNotMetException, __BaseException>);
}

export declare class ResourceExistsException extends __BaseException {
    readonly name: "ResourceExistsException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ResourceExistsException, __BaseException>);
}
export interface DeleteResourcePolicyRequest {
    
    SecretId: string | undefined;
}
export declare namespace DeleteResourcePolicyRequest {
    
    const filterSensitiveLog: (obj: DeleteResourcePolicyRequest) => any;
}
export interface DeleteResourcePolicyResponse {
    
    ARN?: string;
    
    Name?: string;
}
export declare namespace DeleteResourcePolicyResponse {
    
    const filterSensitiveLog: (obj: DeleteResourcePolicyResponse) => any;
}
export interface DeleteSecretRequest {
    
    SecretId: string | undefined;
    
    RecoveryWindowInDays?: number;
    
    ForceDeleteWithoutRecovery?: boolean;
}
export declare namespace DeleteSecretRequest {
    
    const filterSensitiveLog: (obj: DeleteSecretRequest) => any;
}
export interface DeleteSecretResponse {
    
    ARN?: string;
    
    Name?: string;
    
    DeletionDate?: Date;
}
export declare namespace DeleteSecretResponse {
    
    const filterSensitiveLog: (obj: DeleteSecretResponse) => any;
}
export interface DescribeSecretRequest {
    
    SecretId: string | undefined;
}
export declare namespace DescribeSecretRequest {
    
    const filterSensitiveLog: (obj: DescribeSecretRequest) => any;
}

export interface RotationRulesType {
    
    AutomaticallyAfterDays?: number;
    
    Duration?: string;
    
    ScheduleExpression?: string;
}
export declare namespace RotationRulesType {
    
    const filterSensitiveLog: (obj: RotationRulesType) => any;
}
export interface DescribeSecretResponse {
    
    ARN?: string;
    
    Name?: string;
    
    Description?: string;
    
    KmsKeyId?: string;
    
    RotationEnabled?: boolean;
    
    RotationLambdaARN?: string;
    
    RotationRules?: RotationRulesType;
    
    LastRotatedDate?: Date;
    
    LastChangedDate?: Date;
    
    LastAccessedDate?: Date;
    
    DeletedDate?: Date;
    
    Tags?: Tag[];
    
    VersionIdsToStages?: Record<string, string[]>;
    
    OwningService?: string;
    
    CreatedDate?: Date;
    
    PrimaryRegion?: string;
    
    ReplicationStatus?: ReplicationStatusType[];
}
export declare namespace DescribeSecretResponse {
    
    const filterSensitiveLog: (obj: DescribeSecretResponse) => any;
}
export declare type FilterNameStringType = "all" | "description" | "name" | "primary-region" | "tag-key" | "tag-value";

export interface Filter {
    
    Key?: FilterNameStringType | string;
    
    Values?: string[];
}
export declare namespace Filter {
    
    const filterSensitiveLog: (obj: Filter) => any;
}
export interface GetRandomPasswordRequest {
    
    PasswordLength?: number;
    
    ExcludeCharacters?: string;
    
    ExcludeNumbers?: boolean;
    
    ExcludePunctuation?: boolean;
    
    ExcludeUppercase?: boolean;
    
    ExcludeLowercase?: boolean;
    
    IncludeSpace?: boolean;
    
    RequireEachIncludedType?: boolean;
}
export declare namespace GetRandomPasswordRequest {
    
    const filterSensitiveLog: (obj: GetRandomPasswordRequest) => any;
}
export interface GetRandomPasswordResponse {
    
    RandomPassword?: string;
}
export declare namespace GetRandomPasswordResponse {
    
    const filterSensitiveLog: (obj: GetRandomPasswordResponse) => any;
}
export interface GetResourcePolicyRequest {
    
    SecretId: string | undefined;
}
export declare namespace GetResourcePolicyRequest {
    
    const filterSensitiveLog: (obj: GetResourcePolicyRequest) => any;
}
export interface GetResourcePolicyResponse {
    
    ARN?: string;
    
    Name?: string;
    
    ResourcePolicy?: string;
}
export declare namespace GetResourcePolicyResponse {
    
    const filterSensitiveLog: (obj: GetResourcePolicyResponse) => any;
}
export interface GetSecretValueRequest {
    
    SecretId: string | undefined;
    
    VersionId?: string;
    
    VersionStage?: string;
}
export declare namespace GetSecretValueRequest {
    
    const filterSensitiveLog: (obj: GetSecretValueRequest) => any;
}
export interface GetSecretValueResponse {
    
    ARN?: string;
    
    Name?: string;
    
    VersionId?: string;
    
    SecretBinary?: Uint8Array;
    
    SecretString?: string;
    
    VersionStages?: string[];
    
    CreatedDate?: Date;
}
export declare namespace GetSecretValueResponse {
    
    const filterSensitiveLog: (obj: GetSecretValueResponse) => any;
}

export declare class InvalidNextTokenException extends __BaseException {
    readonly name: "InvalidNextTokenException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidNextTokenException, __BaseException>);
}
export declare enum SortOrderType {
    asc = "asc",
    desc = "desc"
}
export interface ListSecretsRequest {
    
    MaxResults?: number;
    
    NextToken?: string;
    
    Filters?: Filter[];
    
    SortOrder?: SortOrderType | string;
}
export declare namespace ListSecretsRequest {
    
    const filterSensitiveLog: (obj: ListSecretsRequest) => any;
}

export interface SecretListEntry {
    
    ARN?: string;
    
    Name?: string;
    
    Description?: string;
    
    KmsKeyId?: string;
    
    RotationEnabled?: boolean;
    
    RotationLambdaARN?: string;
    
    RotationRules?: RotationRulesType;
    
    LastRotatedDate?: Date;
    
    LastChangedDate?: Date;
    
    LastAccessedDate?: Date;
    
    DeletedDate?: Date;
    
    Tags?: Tag[];
    
    SecretVersionsToStages?: Record<string, string[]>;
    
    OwningService?: string;
    
    CreatedDate?: Date;
    
    PrimaryRegion?: string;
}
export declare namespace SecretListEntry {
    
    const filterSensitiveLog: (obj: SecretListEntry) => any;
}
export interface ListSecretsResponse {
    
    SecretList?: SecretListEntry[];
    
    NextToken?: string;
}
export declare namespace ListSecretsResponse {
    
    const filterSensitiveLog: (obj: ListSecretsResponse) => any;
}
export interface ListSecretVersionIdsRequest {
    
    SecretId: string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
    
    IncludeDeprecated?: boolean;
}
export declare namespace ListSecretVersionIdsRequest {
    
    const filterSensitiveLog: (obj: ListSecretVersionIdsRequest) => any;
}

export interface SecretVersionsListEntry {
    
    VersionId?: string;
    
    VersionStages?: string[];
    
    LastAccessedDate?: Date;
    
    CreatedDate?: Date;
    
    KmsKeyIds?: string[];
}
export declare namespace SecretVersionsListEntry {
    
    const filterSensitiveLog: (obj: SecretVersionsListEntry) => any;
}
export interface ListSecretVersionIdsResponse {
    
    Versions?: SecretVersionsListEntry[];
    
    NextToken?: string;
    
    ARN?: string;
    
    Name?: string;
}
export declare namespace ListSecretVersionIdsResponse {
    
    const filterSensitiveLog: (obj: ListSecretVersionIdsResponse) => any;
}

export declare class PublicPolicyException extends __BaseException {
    readonly name: "PublicPolicyException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<PublicPolicyException, __BaseException>);
}
export interface PutResourcePolicyRequest {
    
    SecretId: string | undefined;
    
    ResourcePolicy: string | undefined;
    
    BlockPublicPolicy?: boolean;
}
export declare namespace PutResourcePolicyRequest {
    
    const filterSensitiveLog: (obj: PutResourcePolicyRequest) => any;
}
export interface PutResourcePolicyResponse {
    
    ARN?: string;
    
    Name?: string;
}
export declare namespace PutResourcePolicyResponse {
    
    const filterSensitiveLog: (obj: PutResourcePolicyResponse) => any;
}
export interface PutSecretValueRequest {
    
    SecretId: string | undefined;
    
    ClientRequestToken?: string;
    
    SecretBinary?: Uint8Array;
    
    SecretString?: string;
    
    VersionStages?: string[];
}
export declare namespace PutSecretValueRequest {
    
    const filterSensitiveLog: (obj: PutSecretValueRequest) => any;
}
export interface PutSecretValueResponse {
    
    ARN?: string;
    
    Name?: string;
    
    VersionId?: string;
    
    VersionStages?: string[];
}
export declare namespace PutSecretValueResponse {
    
    const filterSensitiveLog: (obj: PutSecretValueResponse) => any;
}
export interface RemoveRegionsFromReplicationRequest {
    
    SecretId: string | undefined;
    
    RemoveReplicaRegions: string[] | undefined;
}
export declare namespace RemoveRegionsFromReplicationRequest {
    
    const filterSensitiveLog: (obj: RemoveRegionsFromReplicationRequest) => any;
}
export interface RemoveRegionsFromReplicationResponse {
    
    ARN?: string;
    
    ReplicationStatus?: ReplicationStatusType[];
}
export declare namespace RemoveRegionsFromReplicationResponse {
    
    const filterSensitiveLog: (obj: RemoveRegionsFromReplicationResponse) => any;
}
export interface ReplicateSecretToRegionsRequest {
    
    SecretId: string | undefined;
    
    AddReplicaRegions: ReplicaRegionType[] | undefined;
    
    ForceOverwriteReplicaSecret?: boolean;
}
export declare namespace ReplicateSecretToRegionsRequest {
    
    const filterSensitiveLog: (obj: ReplicateSecretToRegionsRequest) => any;
}
export interface ReplicateSecretToRegionsResponse {
    
    ARN?: string;
    
    ReplicationStatus?: ReplicationStatusType[];
}
export declare namespace ReplicateSecretToRegionsResponse {
    
    const filterSensitiveLog: (obj: ReplicateSecretToRegionsResponse) => any;
}
export interface RestoreSecretRequest {
    
    SecretId: string | undefined;
}
export declare namespace RestoreSecretRequest {
    
    const filterSensitiveLog: (obj: RestoreSecretRequest) => any;
}
export interface RestoreSecretResponse {
    
    ARN?: string;
    
    Name?: string;
}
export declare namespace RestoreSecretResponse {
    
    const filterSensitiveLog: (obj: RestoreSecretResponse) => any;
}
export interface RotateSecretRequest {
    
    SecretId: string | undefined;
    
    ClientRequestToken?: string;
    
    RotationLambdaARN?: string;
    
    RotationRules?: RotationRulesType;
    
    RotateImmediately?: boolean;
}
export declare namespace RotateSecretRequest {
    
    const filterSensitiveLog: (obj: RotateSecretRequest) => any;
}
export interface RotateSecretResponse {
    
    ARN?: string;
    
    Name?: string;
    
    VersionId?: string;
}
export declare namespace RotateSecretResponse {
    
    const filterSensitiveLog: (obj: RotateSecretResponse) => any;
}
export interface StopReplicationToReplicaRequest {
    
    SecretId: string | undefined;
}
export declare namespace StopReplicationToReplicaRequest {
    
    const filterSensitiveLog: (obj: StopReplicationToReplicaRequest) => any;
}
export interface StopReplicationToReplicaResponse {
    
    ARN?: string;
}
export declare namespace StopReplicationToReplicaResponse {
    
    const filterSensitiveLog: (obj: StopReplicationToReplicaResponse) => any;
}
export interface TagResourceRequest {
    
    SecretId: string | undefined;
    
    Tags: Tag[] | undefined;
}
export declare namespace TagResourceRequest {
    
    const filterSensitiveLog: (obj: TagResourceRequest) => any;
}
export interface UntagResourceRequest {
    
    SecretId: string | undefined;
    
    TagKeys: string[] | undefined;
}
export declare namespace UntagResourceRequest {
    
    const filterSensitiveLog: (obj: UntagResourceRequest) => any;
}
export interface UpdateSecretRequest {
    
    SecretId: string | undefined;
    
    ClientRequestToken?: string;
    
    Description?: string;
    
    KmsKeyId?: string;
    
    SecretBinary?: Uint8Array;
    
    SecretString?: string;
}
export declare namespace UpdateSecretRequest {
    
    const filterSensitiveLog: (obj: UpdateSecretRequest) => any;
}
export interface UpdateSecretResponse {
    
    ARN?: string;
    
    Name?: string;
    
    VersionId?: string;
}
export declare namespace UpdateSecretResponse {
    
    const filterSensitiveLog: (obj: UpdateSecretResponse) => any;
}
export interface UpdateSecretVersionStageRequest {
    
    SecretId: string | undefined;
    
    VersionStage: string | undefined;
    
    RemoveFromVersionId?: string;
    
    MoveToVersionId?: string;
}
export declare namespace UpdateSecretVersionStageRequest {
    
    const filterSensitiveLog: (obj: UpdateSecretVersionStageRequest) => any;
}
export interface UpdateSecretVersionStageResponse {
    
    ARN?: string;
    
    Name?: string;
}
export declare namespace UpdateSecretVersionStageResponse {
    
    const filterSensitiveLog: (obj: UpdateSecretVersionStageResponse) => any;
}
export interface ValidateResourcePolicyRequest {
    
    SecretId?: string;
    
    ResourcePolicy: string | undefined;
}
export declare namespace ValidateResourcePolicyRequest {
    
    const filterSensitiveLog: (obj: ValidateResourcePolicyRequest) => any;
}

export interface ValidationErrorsEntry {
    
    CheckName?: string;
    
    ErrorMessage?: string;
}
export declare namespace ValidationErrorsEntry {
    
    const filterSensitiveLog: (obj: ValidationErrorsEntry) => any;
}
export interface ValidateResourcePolicyResponse {
    
    PolicyValidationPassed?: boolean;
    
    ValidationErrors?: ValidationErrorsEntry[];
}
export declare namespace ValidateResourcePolicyResponse {
    
    const filterSensitiveLog: (obj: ValidateResourcePolicyResponse) => any;
}
