"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidTargetMaps = exports.InvalidTarget = exports.InvalidSchedule = exports.InvalidOutputLocation = exports.InvalidDocumentVersion = exports.InvalidDocument = exports.CreateAssociationResult = exports.AssociationDescription = exports.AssociationStatus = exports.AssociationStatusName = exports.AssociationOverview = exports.CreateAssociationRequest = exports.Target = exports.TargetLocation = exports.AssociationSyncCompliance = exports.InstanceAssociationOutputLocation = exports.S3OutputLocation = exports.AssociationComplianceSeverity = exports.AssociationLimitExceeded = exports.AssociationAlreadyExists = exports.InvalidParameters = exports.CreateActivationResult = exports.CreateActivationRequest = exports.RegistrationMetadataItem = exports.DoesNotExistException = exports.CancelMaintenanceWindowExecutionResult = exports.CancelMaintenanceWindowExecutionRequest = exports.InvalidInstanceId = exports.InvalidCommandId = exports.DuplicateInstanceId = exports.CancelCommandResult = exports.CancelCommandRequest = exports.OpsItemRelatedItemAlreadyExistsException = exports.OpsItemNotFoundException = exports.OpsItemLimitExceededException = exports.OpsItemInvalidParameterException = exports.AssociateOpsItemRelatedItemResponse = exports.AssociateOpsItemRelatedItemRequest = exports.AlreadyExistsException = exports.TooManyUpdates = exports.TooManyTagsError = exports.InvalidResourceType = exports.InvalidResourceId = exports.InternalServerError = exports.AddTagsToResourceResult = exports.AddTagsToResourceRequest = exports.ResourceTypeForTagging = exports.Activation = exports.Tag = exports.AccountSharingInfo = void 0;
exports.OperatingSystem = exports.PatchRuleGroup = exports.PatchRule = exports.PatchFilterGroup = exports.PatchFilter = exports.PatchFilterKey = exports.PatchComplianceLevel = exports.OpsMetadataTooManyUpdatesException = exports.OpsMetadataLimitExceededException = exports.OpsMetadataInvalidArgumentException = exports.OpsMetadataAlreadyExistsException = exports.CreateOpsMetadataResult = exports.CreateOpsMetadataRequest = exports.MetadataValue = exports.OpsItemAlreadyExistsException = exports.CreateOpsItemResponse = exports.CreateOpsItemRequest = exports.RelatedOpsItem = exports.OpsItemDataValue = exports.OpsItemDataType = exports.OpsItemNotification = exports.ResourceLimitExceededException = exports.IdempotentParameterMismatch = exports.CreateMaintenanceWindowResult = exports.CreateMaintenanceWindowRequest = exports.MaxDocumentSizeExceeded = exports.InvalidDocumentSchemaVersion = exports.InvalidDocumentContent = exports.DocumentLimitExceeded = exports.DocumentAlreadyExists = exports.CreateDocumentResult = exports.DocumentDescription = exports.DocumentStatus = exports.ReviewInformation = exports.ReviewStatus = exports.PlatformType = exports.DocumentParameter = exports.DocumentHashType = exports.AttachmentInformation = exports.CreateDocumentRequest = exports.DocumentRequires = exports.DocumentType = exports.DocumentFormat = exports.AttachmentsSource = exports.AttachmentsSourceKey = exports.CreateAssociationBatchResult = exports.FailedCreateAssociation = exports.CreateAssociationBatchRequest = exports.CreateAssociationBatchRequestEntry = exports.UnsupportedPlatformType = void 0;
exports.DeleteResourceDataSyncResult = exports.DeleteResourceDataSyncRequest = exports.ResourceInUseException = exports.DeletePatchBaselineResult = exports.DeletePatchBaselineRequest = exports.DeleteParametersResult = exports.DeleteParametersRequest = exports.ParameterNotFound = exports.DeleteParameterResult = exports.DeleteParameterRequest = exports.OpsMetadataNotFoundException = exports.DeleteOpsMetadataResult = exports.DeleteOpsMetadataRequest = exports.DeleteMaintenanceWindowResult = exports.DeleteMaintenanceWindowRequest = exports.InvalidTypeNameException = exports.InvalidOptionException = exports.InvalidInventoryRequestException = exports.InvalidDeleteInventoryParametersException = exports.DeleteInventoryResult = exports.InventoryDeletionSummary = exports.InventoryDeletionSummaryItem = exports.DeleteInventoryRequest = exports.InventorySchemaDeleteOption = exports.InvalidDocumentOperation = exports.DeleteDocumentResult = exports.DeleteDocumentRequest = exports.AssociatedInstances = exports.DeleteAssociationResult = exports.DeleteAssociationRequest = exports.AssociationDoesNotExist = exports.InvalidActivationId = exports.InvalidActivation = exports.DeleteActivationResult = exports.DeleteActivationRequest = exports.ResourceDataSyncInvalidConfigurationException = exports.ResourceDataSyncCountExceededException = exports.ResourceDataSyncAlreadyExistsException = exports.CreateResourceDataSyncResult = exports.CreateResourceDataSyncRequest = exports.ResourceDataSyncSource = exports.ResourceDataSyncAwsOrganizationsSource = exports.ResourceDataSyncOrganizationalUnit = exports.ResourceDataSyncS3Destination = exports.ResourceDataSyncS3Format = exports.ResourceDataSyncDestinationDataSharing = exports.CreatePatchBaselineResult = exports.CreatePatchBaselineRequest = exports.PatchSource = exports.PatchAction = void 0;
exports.FailureDetails = exports.DescribeAutomationStepExecutionsRequest = exports.StepExecutionFilter = exports.StepExecutionFilterKey = exports.AutomationExecutionNotFoundException = exports.InvalidFilterValue = exports.InvalidFilterKey = exports.DescribeAutomationExecutionsResult = exports.AutomationExecutionMetadata = exports.Runbook = exports.ResolvedTargets = exports.ExecutionMode = exports.AutomationType = exports.AutomationSubtype = exports.AutomationExecutionStatus = exports.DescribeAutomationExecutionsRequest = exports.AutomationExecutionFilter = exports.AutomationExecutionFilterKey = exports.DescribeAssociationExecutionTargetsResult = exports.AssociationExecutionTarget = exports.OutputSource = exports.DescribeAssociationExecutionTargetsRequest = exports.AssociationExecutionTargetsFilter = exports.AssociationExecutionTargetsFilterKey = exports.AssociationExecutionDoesNotExist = exports.DescribeAssociationExecutionsResult = exports.AssociationExecution = exports.DescribeAssociationExecutionsRequest = exports.AssociationExecutionFilter = exports.AssociationFilterOperatorType = exports.AssociationExecutionFilterKey = exports.InvalidAssociationVersion = exports.DescribeAssociationResult = exports.DescribeAssociationRequest = exports.InvalidNextToken = exports.InvalidFilter = exports.DescribeActivationsResult = exports.DescribeActivationsRequest = exports.DescribeActivationsFilter = exports.DescribeActivationsFilterKeys = exports.DeregisterTaskFromMaintenanceWindowResult = exports.DeregisterTaskFromMaintenanceWindowRequest = exports.TargetInUseException = exports.DeregisterTargetFromMaintenanceWindowResult = exports.DeregisterTargetFromMaintenanceWindowRequest = exports.DeregisterPatchBaselineForPatchGroupResult = exports.DeregisterPatchBaselineForPatchGroupRequest = exports.DeregisterManagedInstanceResult = exports.DeregisterManagedInstanceRequest = exports.ResourceDataSyncNotFoundException = void 0;
exports.DescribeInstancePatchStatesForPatchGroupResult = exports.DescribeInstancePatchStatesForPatchGroupRequest = exports.InstancePatchStateFilter = exports.InstancePatchStateOperatorType = exports.DescribeInstancePatchStatesResult = exports.InstancePatchState = exports.RebootOption = exports.PatchOperationType = exports.DescribeInstancePatchStatesRequest = exports.DescribeInstancePatchesResult = exports.PatchComplianceData = exports.PatchComplianceDataState = exports.DescribeInstancePatchesRequest = exports.InvalidInstanceInformationFilterValue = exports.DescribeInstanceInformationResult = exports.InstanceInformation = exports.SourceType = exports.ResourceType = exports.PingStatus = exports.InstanceAggregatedAssociationOverview = exports.DescribeInstanceInformationRequest = exports.InstanceInformationFilter = exports.InstanceInformationFilterKey = exports.InstanceInformationStringFilter = exports.DescribeInstanceAssociationsStatusResult = exports.InstanceAssociationStatusInfo = exports.InstanceAssociationOutputUrl = exports.S3OutputUrl = exports.DescribeInstanceAssociationsStatusRequest = exports.UnsupportedOperatingSystem = exports.DescribeEffectivePatchesForPatchBaselineResult = exports.EffectivePatch = exports.PatchStatus = exports.PatchDeploymentStatus = exports.DescribeEffectivePatchesForPatchBaselineRequest = exports.DescribeEffectiveInstanceAssociationsResult = exports.InstanceAssociation = exports.DescribeEffectiveInstanceAssociationsRequest = exports.InvalidPermissionType = exports.DescribeDocumentPermissionResponse = exports.DescribeDocumentPermissionRequest = exports.DocumentPermissionType = exports.DescribeDocumentResult = exports.DescribeDocumentRequest = exports.DescribeAvailablePatchesResult = exports.Patch = exports.DescribeAvailablePatchesRequest = exports.PatchOrchestratorFilter = exports.DescribeAutomationStepExecutionsResult = exports.StepExecution = void 0;
exports.ParameterInlinePolicy = exports.DescribeParametersRequest = exports.ParameterStringFilter = exports.ParametersFilter = exports.ParametersFilterKey = exports.DescribeOpsItemsResponse = exports.OpsItemSummary = exports.OpsItemStatus = exports.DescribeOpsItemsRequest = exports.OpsItemFilter = exports.OpsItemFilterOperator = exports.OpsItemFilterKey = exports.DescribeMaintenanceWindowTasksResult = exports.MaintenanceWindowTask = exports.MaintenanceWindowTaskParameterValueExpression = exports.LoggingInfo = exports.MaintenanceWindowTaskCutoffBehavior = exports.DescribeMaintenanceWindowTasksRequest = exports.DescribeMaintenanceWindowTargetsResult = exports.MaintenanceWindowTarget = exports.DescribeMaintenanceWindowTargetsRequest = exports.DescribeMaintenanceWindowsForTargetResult = exports.MaintenanceWindowIdentityForTarget = exports.DescribeMaintenanceWindowsForTargetRequest = exports.DescribeMaintenanceWindowScheduleResult = exports.ScheduledWindowExecution = exports.DescribeMaintenanceWindowScheduleRequest = exports.MaintenanceWindowResourceType = exports.DescribeMaintenanceWindowsResult = exports.MaintenanceWindowIdentity = exports.DescribeMaintenanceWindowsRequest = exports.DescribeMaintenanceWindowExecutionTasksResult = exports.MaintenanceWindowExecutionTaskIdentity = exports.DescribeMaintenanceWindowExecutionTasksRequest = exports.DescribeMaintenanceWindowExecutionTaskInvocationsResult = exports.MaintenanceWindowExecutionTaskInvocationIdentity = exports.MaintenanceWindowTaskType = exports.DescribeMaintenanceWindowExecutionTaskInvocationsRequest = exports.DescribeMaintenanceWindowExecutionsResult = exports.MaintenanceWindowExecution = exports.MaintenanceWindowExecutionStatus = exports.DescribeMaintenanceWindowExecutionsRequest = exports.MaintenanceWindowFilter = exports.InvalidDeletionIdException = exports.DescribeInventoryDeletionsResult = exports.InventoryDeletionStatusItem = exports.InventoryDeletionStatus = exports.DescribeInventoryDeletionsRequest = void 0;
const smithy_client_1 = require("@aws-sdk/smithy-client");
const SSMServiceException_1 = require("./SSMServiceException");
var AccountSharingInfo;
(function (AccountSharingInfo) {
    AccountSharingInfo.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(AccountSharingInfo = exports.AccountSharingInfo || (exports.AccountSharingInfo = {}));
var Tag;
(function (Tag) {
    Tag.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(Tag = exports.Tag || (exports.Tag = {}));
var Activation;
(function (Activation) {
    Activation.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(Activation = exports.Activation || (exports.Activation = {}));
var ResourceTypeForTagging;
(function (ResourceTypeForTagging) {
    ResourceTypeForTagging["AUTOMATION"] = "Automation";
    ResourceTypeForTagging["DOCUMENT"] = "Document";
    ResourceTypeForTagging["MAINTENANCE_WINDOW"] = "MaintenanceWindow";
    ResourceTypeForTagging["MANAGED_INSTANCE"] = "ManagedInstance";
    ResourceTypeForTagging["OPSMETADATA"] = "OpsMetadata";
    ResourceTypeForTagging["OPS_ITEM"] = "OpsItem";
    ResourceTypeForTagging["PARAMETER"] = "Parameter";
    ResourceTypeForTagging["PATCH_BASELINE"] = "PatchBaseline";
})(ResourceTypeForTagging = exports.ResourceTypeForTagging || (exports.ResourceTypeForTagging = {}));
var AddTagsToResourceRequest;
(function (AddTagsToResourceRequest) {
    AddTagsToResourceRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(AddTagsToResourceRequest = exports.AddTagsToResourceRequest || (exports.AddTagsToResourceRequest = {}));
var AddTagsToResourceResult;
(function (AddTagsToResourceResult) {
    AddTagsToResourceResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(AddTagsToResourceResult = exports.AddTagsToResourceResult || (exports.AddTagsToResourceResult = {}));
class InternalServerError extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InternalServerError",
            $fault: "server",
            ...opts,
        });
        this.name = "InternalServerError";
        this.$fault = "server";
        Object.setPrototypeOf(this, InternalServerError.prototype);
        this.Message = opts.Message;
    }
}
exports.InternalServerError = InternalServerError;
class InvalidResourceId extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidResourceId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidResourceId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidResourceId.prototype);
    }
}
exports.InvalidResourceId = InvalidResourceId;
class InvalidResourceType extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidResourceType",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidResourceType";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidResourceType.prototype);
    }
}
exports.InvalidResourceType = InvalidResourceType;
class TooManyTagsError extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "TooManyTagsError",
            $fault: "client",
            ...opts,
        });
        this.name = "TooManyTagsError";
        this.$fault = "client";
        Object.setPrototypeOf(this, TooManyTagsError.prototype);
    }
}
exports.TooManyTagsError = TooManyTagsError;
class TooManyUpdates extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "TooManyUpdates",
            $fault: "client",
            ...opts,
        });
        this.name = "TooManyUpdates";
        this.$fault = "client";
        Object.setPrototypeOf(this, TooManyUpdates.prototype);
        this.Message = opts.Message;
    }
}
exports.TooManyUpdates = TooManyUpdates;
class AlreadyExistsException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "AlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AlreadyExistsException.prototype);
        this.Message = opts.Message;
    }
}
exports.AlreadyExistsException = AlreadyExistsException;
var AssociateOpsItemRelatedItemRequest;
(function (AssociateOpsItemRelatedItemRequest) {
    AssociateOpsItemRelatedItemRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(AssociateOpsItemRelatedItemRequest = exports.AssociateOpsItemRelatedItemRequest || (exports.AssociateOpsItemRelatedItemRequest = {}));
var AssociateOpsItemRelatedItemResponse;
(function (AssociateOpsItemRelatedItemResponse) {
    AssociateOpsItemRelatedItemResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(AssociateOpsItemRelatedItemResponse = exports.AssociateOpsItemRelatedItemResponse || (exports.AssociateOpsItemRelatedItemResponse = {}));
class OpsItemInvalidParameterException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsItemInvalidParameterException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemInvalidParameterException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemInvalidParameterException.prototype);
        this.ParameterNames = opts.ParameterNames;
        this.Message = opts.Message;
    }
}
exports.OpsItemInvalidParameterException = OpsItemInvalidParameterException;
class OpsItemLimitExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsItemLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemLimitExceededException.prototype);
        this.ResourceTypes = opts.ResourceTypes;
        this.Limit = opts.Limit;
        this.LimitType = opts.LimitType;
        this.Message = opts.Message;
    }
}
exports.OpsItemLimitExceededException = OpsItemLimitExceededException;
class OpsItemNotFoundException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsItemNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
exports.OpsItemNotFoundException = OpsItemNotFoundException;
class OpsItemRelatedItemAlreadyExistsException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsItemRelatedItemAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemRelatedItemAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemRelatedItemAlreadyExistsException.prototype);
        this.Message = opts.Message;
        this.ResourceUri = opts.ResourceUri;
        this.OpsItemId = opts.OpsItemId;
    }
}
exports.OpsItemRelatedItemAlreadyExistsException = OpsItemRelatedItemAlreadyExistsException;
var CancelCommandRequest;
(function (CancelCommandRequest) {
    CancelCommandRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(CancelCommandRequest = exports.CancelCommandRequest || (exports.CancelCommandRequest = {}));
var CancelCommandResult;
(function (CancelCommandResult) {
    CancelCommandResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(CancelCommandResult = exports.CancelCommandResult || (exports.CancelCommandResult = {}));
class DuplicateInstanceId extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "DuplicateInstanceId",
            $fault: "client",
            ...opts,
        });
        this.name = "DuplicateInstanceId";
        this.$fault = "client";
        Object.setPrototypeOf(this, DuplicateInstanceId.prototype);
    }
}
exports.DuplicateInstanceId = DuplicateInstanceId;
class InvalidCommandId extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidCommandId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidCommandId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidCommandId.prototype);
    }
}
exports.InvalidCommandId = InvalidCommandId;
class InvalidInstanceId extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidInstanceId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInstanceId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInstanceId.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidInstanceId = InvalidInstanceId;
var CancelMaintenanceWindowExecutionRequest;
(function (CancelMaintenanceWindowExecutionRequest) {
    CancelMaintenanceWindowExecutionRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(CancelMaintenanceWindowExecutionRequest = exports.CancelMaintenanceWindowExecutionRequest || (exports.CancelMaintenanceWindowExecutionRequest = {}));
var CancelMaintenanceWindowExecutionResult;
(function (CancelMaintenanceWindowExecutionResult) {
    CancelMaintenanceWindowExecutionResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(CancelMaintenanceWindowExecutionResult = exports.CancelMaintenanceWindowExecutionResult || (exports.CancelMaintenanceWindowExecutionResult = {}));
class DoesNotExistException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "DoesNotExistException",
            $fault: "client",
            ...opts,
        });
        this.name = "DoesNotExistException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DoesNotExistException.prototype);
        this.Message = opts.Message;
    }
}
exports.DoesNotExistException = DoesNotExistException;
var RegistrationMetadataItem;
(function (RegistrationMetadataItem) {
    RegistrationMetadataItem.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(RegistrationMetadataItem = exports.RegistrationMetadataItem || (exports.RegistrationMetadataItem = {}));
var CreateActivationRequest;
(function (CreateActivationRequest) {
    CreateActivationRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(CreateActivationRequest = exports.CreateActivationRequest || (exports.CreateActivationRequest = {}));
var CreateActivationResult;
(function (CreateActivationResult) {
    CreateActivationResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(CreateActivationResult = exports.CreateActivationResult || (exports.CreateActivationResult = {}));
class InvalidParameters extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidParameters",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidParameters";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidParameters.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidParameters = InvalidParameters;
class AssociationAlreadyExists extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AssociationAlreadyExists",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationAlreadyExists";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationAlreadyExists.prototype);
    }
}
exports.AssociationAlreadyExists = AssociationAlreadyExists;
class AssociationLimitExceeded extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AssociationLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationLimitExceeded.prototype);
    }
}
exports.AssociationLimitExceeded = AssociationLimitExceeded;
var AssociationComplianceSeverity;
(function (AssociationComplianceSeverity) {
    AssociationComplianceSeverity["Critical"] = "CRITICAL";
    AssociationComplianceSeverity["High"] = "HIGH";
    AssociationComplianceSeverity["Low"] = "LOW";
    AssociationComplianceSeverity["Medium"] = "MEDIUM";
    AssociationComplianceSeverity["Unspecified"] = "UNSPECIFIED";
})(AssociationComplianceSeverity = exports.AssociationComplianceSeverity || (exports.AssociationComplianceSeverity = {}));
var S3OutputLocation;
(function (S3OutputLocation) {
    S3OutputLocation.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(S3OutputLocation = exports.S3OutputLocation || (exports.S3OutputLocation = {}));
var InstanceAssociationOutputLocation;
(function (InstanceAssociationOutputLocation) {
    InstanceAssociationOutputLocation.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(InstanceAssociationOutputLocation = exports.InstanceAssociationOutputLocation || (exports.InstanceAssociationOutputLocation = {}));
var AssociationSyncCompliance;
(function (AssociationSyncCompliance) {
    AssociationSyncCompliance["Auto"] = "AUTO";
    AssociationSyncCompliance["Manual"] = "MANUAL";
})(AssociationSyncCompliance = exports.AssociationSyncCompliance || (exports.AssociationSyncCompliance = {}));
var TargetLocation;
(function (TargetLocation) {
    TargetLocation.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(TargetLocation = exports.TargetLocation || (exports.TargetLocation = {}));
var Target;
(function (Target) {
    Target.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(Target = exports.Target || (exports.Target = {}));
var CreateAssociationRequest;
(function (CreateAssociationRequest) {
    CreateAssociationRequest.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.Parameters && { Parameters: smithy_client_1.SENSITIVE_STRING }),
    });
})(CreateAssociationRequest = exports.CreateAssociationRequest || (exports.CreateAssociationRequest = {}));
var AssociationOverview;
(function (AssociationOverview) {
    AssociationOverview.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(AssociationOverview = exports.AssociationOverview || (exports.AssociationOverview = {}));
var AssociationStatusName;
(function (AssociationStatusName) {
    AssociationStatusName["Failed"] = "Failed";
    AssociationStatusName["Pending"] = "Pending";
    AssociationStatusName["Success"] = "Success";
})(AssociationStatusName = exports.AssociationStatusName || (exports.AssociationStatusName = {}));
var AssociationStatus;
(function (AssociationStatus) {
    AssociationStatus.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(AssociationStatus = exports.AssociationStatus || (exports.AssociationStatus = {}));
var AssociationDescription;
(function (AssociationDescription) {
    AssociationDescription.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.Parameters && { Parameters: smithy_client_1.SENSITIVE_STRING }),
    });
})(AssociationDescription = exports.AssociationDescription || (exports.AssociationDescription = {}));
var CreateAssociationResult;
(function (CreateAssociationResult) {
    CreateAssociationResult.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.AssociationDescription && {
            AssociationDescription: AssociationDescription.filterSensitiveLog(obj.AssociationDescription),
        }),
    });
})(CreateAssociationResult = exports.CreateAssociationResult || (exports.CreateAssociationResult = {}));
class InvalidDocument extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDocument",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocument";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocument.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDocument = InvalidDocument;
class InvalidDocumentVersion extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDocumentVersion",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentVersion";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentVersion.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDocumentVersion = InvalidDocumentVersion;
class InvalidOutputLocation extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidOutputLocation",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidOutputLocation";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidOutputLocation.prototype);
    }
}
exports.InvalidOutputLocation = InvalidOutputLocation;
class InvalidSchedule extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidSchedule",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidSchedule";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidSchedule.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidSchedule = InvalidSchedule;
class InvalidTarget extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidTarget",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTarget";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTarget.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidTarget = InvalidTarget;
class InvalidTargetMaps extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidTargetMaps",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTargetMaps";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTargetMaps.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidTargetMaps = InvalidTargetMaps;
class UnsupportedPlatformType extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "UnsupportedPlatformType",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedPlatformType";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedPlatformType.prototype);
        this.Message = opts.Message;
    }
}
exports.UnsupportedPlatformType = UnsupportedPlatformType;
var CreateAssociationBatchRequestEntry;
(function (CreateAssociationBatchRequestEntry) {
    CreateAssociationBatchRequestEntry.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.Parameters && { Parameters: smithy_client_1.SENSITIVE_STRING }),
    });
})(CreateAssociationBatchRequestEntry = exports.CreateAssociationBatchRequestEntry || (exports.CreateAssociationBatchRequestEntry = {}));
var CreateAssociationBatchRequest;
(function (CreateAssociationBatchRequest) {
    CreateAssociationBatchRequest.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.Entries && {
            Entries: obj.Entries.map((item) => CreateAssociationBatchRequestEntry.filterSensitiveLog(item)),
        }),
    });
})(CreateAssociationBatchRequest = exports.CreateAssociationBatchRequest || (exports.CreateAssociationBatchRequest = {}));
var FailedCreateAssociation;
(function (FailedCreateAssociation) {
    FailedCreateAssociation.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.Entry && { Entry: CreateAssociationBatchRequestEntry.filterSensitiveLog(obj.Entry) }),
    });
})(FailedCreateAssociation = exports.FailedCreateAssociation || (exports.FailedCreateAssociation = {}));
var CreateAssociationBatchResult;
(function (CreateAssociationBatchResult) {
    CreateAssociationBatchResult.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.Successful && {
            Successful: obj.Successful.map((item) => AssociationDescription.filterSensitiveLog(item)),
        }),
        ...(obj.Failed && { Failed: obj.Failed.map((item) => FailedCreateAssociation.filterSensitiveLog(item)) }),
    });
})(CreateAssociationBatchResult = exports.CreateAssociationBatchResult || (exports.CreateAssociationBatchResult = {}));
var AttachmentsSourceKey;
(function (AttachmentsSourceKey) {
    AttachmentsSourceKey["AttachmentReference"] = "AttachmentReference";
    AttachmentsSourceKey["S3FileUrl"] = "S3FileUrl";
    AttachmentsSourceKey["SourceUrl"] = "SourceUrl";
})(AttachmentsSourceKey = exports.AttachmentsSourceKey || (exports.AttachmentsSourceKey = {}));
var AttachmentsSource;
(function (AttachmentsSource) {
    AttachmentsSource.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(AttachmentsSource = exports.AttachmentsSource || (exports.AttachmentsSource = {}));
var DocumentFormat;
(function (DocumentFormat) {
    DocumentFormat["JSON"] = "JSON";
    DocumentFormat["TEXT"] = "TEXT";
    DocumentFormat["YAML"] = "YAML";
})(DocumentFormat = exports.DocumentFormat || (exports.DocumentFormat = {}));
var DocumentType;
(function (DocumentType) {
    DocumentType["ApplicationConfiguration"] = "ApplicationConfiguration";
    DocumentType["ApplicationConfigurationSchema"] = "ApplicationConfigurationSchema";
    DocumentType["Automation"] = "Automation";
    DocumentType["ChangeCalendar"] = "ChangeCalendar";
    DocumentType["ChangeTemplate"] = "Automation.ChangeTemplate";
    DocumentType["Command"] = "Command";
    DocumentType["DeploymentStrategy"] = "DeploymentStrategy";
    DocumentType["Package"] = "Package";
    DocumentType["Policy"] = "Policy";
    DocumentType["ProblemAnalysis"] = "ProblemAnalysis";
    DocumentType["ProblemAnalysisTemplate"] = "ProblemAnalysisTemplate";
    DocumentType["Session"] = "Session";
})(DocumentType = exports.DocumentType || (exports.DocumentType = {}));
var DocumentRequires;
(function (DocumentRequires) {
    DocumentRequires.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DocumentRequires = exports.DocumentRequires || (exports.DocumentRequires = {}));
var CreateDocumentRequest;
(function (CreateDocumentRequest) {
    CreateDocumentRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(CreateDocumentRequest = exports.CreateDocumentRequest || (exports.CreateDocumentRequest = {}));
var AttachmentInformation;
(function (AttachmentInformation) {
    AttachmentInformation.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(AttachmentInformation = exports.AttachmentInformation || (exports.AttachmentInformation = {}));
var DocumentHashType;
(function (DocumentHashType) {
    DocumentHashType["SHA1"] = "Sha1";
    DocumentHashType["SHA256"] = "Sha256";
})(DocumentHashType = exports.DocumentHashType || (exports.DocumentHashType = {}));
var DocumentParameter;
(function (DocumentParameter) {
    DocumentParameter.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DocumentParameter = exports.DocumentParameter || (exports.DocumentParameter = {}));
var PlatformType;
(function (PlatformType) {
    PlatformType["LINUX"] = "Linux";
    PlatformType["MACOS"] = "MacOS";
    PlatformType["WINDOWS"] = "Windows";
})(PlatformType = exports.PlatformType || (exports.PlatformType = {}));
var ReviewStatus;
(function (ReviewStatus) {
    ReviewStatus["APPROVED"] = "APPROVED";
    ReviewStatus["NOT_REVIEWED"] = "NOT_REVIEWED";
    ReviewStatus["PENDING"] = "PENDING";
    ReviewStatus["REJECTED"] = "REJECTED";
})(ReviewStatus = exports.ReviewStatus || (exports.ReviewStatus = {}));
var ReviewInformation;
(function (ReviewInformation) {
    ReviewInformation.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ReviewInformation = exports.ReviewInformation || (exports.ReviewInformation = {}));
var DocumentStatus;
(function (DocumentStatus) {
    DocumentStatus["Active"] = "Active";
    DocumentStatus["Creating"] = "Creating";
    DocumentStatus["Deleting"] = "Deleting";
    DocumentStatus["Failed"] = "Failed";
    DocumentStatus["Updating"] = "Updating";
})(DocumentStatus = exports.DocumentStatus || (exports.DocumentStatus = {}));
var DocumentDescription;
(function (DocumentDescription) {
    DocumentDescription.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DocumentDescription = exports.DocumentDescription || (exports.DocumentDescription = {}));
var CreateDocumentResult;
(function (CreateDocumentResult) {
    CreateDocumentResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(CreateDocumentResult = exports.CreateDocumentResult || (exports.CreateDocumentResult = {}));
class DocumentAlreadyExists extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "DocumentAlreadyExists",
            $fault: "client",
            ...opts,
        });
        this.name = "DocumentAlreadyExists";
        this.$fault = "client";
        Object.setPrototypeOf(this, DocumentAlreadyExists.prototype);
        this.Message = opts.Message;
    }
}
exports.DocumentAlreadyExists = DocumentAlreadyExists;
class DocumentLimitExceeded extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "DocumentLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "DocumentLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, DocumentLimitExceeded.prototype);
        this.Message = opts.Message;
    }
}
exports.DocumentLimitExceeded = DocumentLimitExceeded;
class InvalidDocumentContent extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDocumentContent",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentContent";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentContent.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDocumentContent = InvalidDocumentContent;
class InvalidDocumentSchemaVersion extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDocumentSchemaVersion",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentSchemaVersion";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentSchemaVersion.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDocumentSchemaVersion = InvalidDocumentSchemaVersion;
class MaxDocumentSizeExceeded extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "MaxDocumentSizeExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "MaxDocumentSizeExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, MaxDocumentSizeExceeded.prototype);
        this.Message = opts.Message;
    }
}
exports.MaxDocumentSizeExceeded = MaxDocumentSizeExceeded;
var CreateMaintenanceWindowRequest;
(function (CreateMaintenanceWindowRequest) {
    CreateMaintenanceWindowRequest.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
    });
})(CreateMaintenanceWindowRequest = exports.CreateMaintenanceWindowRequest || (exports.CreateMaintenanceWindowRequest = {}));
var CreateMaintenanceWindowResult;
(function (CreateMaintenanceWindowResult) {
    CreateMaintenanceWindowResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(CreateMaintenanceWindowResult = exports.CreateMaintenanceWindowResult || (exports.CreateMaintenanceWindowResult = {}));
class IdempotentParameterMismatch extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "IdempotentParameterMismatch",
            $fault: "client",
            ...opts,
        });
        this.name = "IdempotentParameterMismatch";
        this.$fault = "client";
        Object.setPrototypeOf(this, IdempotentParameterMismatch.prototype);
        this.Message = opts.Message;
    }
}
exports.IdempotentParameterMismatch = IdempotentParameterMismatch;
class ResourceLimitExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourceLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
exports.ResourceLimitExceededException = ResourceLimitExceededException;
var OpsItemNotification;
(function (OpsItemNotification) {
    OpsItemNotification.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(OpsItemNotification = exports.OpsItemNotification || (exports.OpsItemNotification = {}));
var OpsItemDataType;
(function (OpsItemDataType) {
    OpsItemDataType["SEARCHABLE_STRING"] = "SearchableString";
    OpsItemDataType["STRING"] = "String";
})(OpsItemDataType = exports.OpsItemDataType || (exports.OpsItemDataType = {}));
var OpsItemDataValue;
(function (OpsItemDataValue) {
    OpsItemDataValue.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(OpsItemDataValue = exports.OpsItemDataValue || (exports.OpsItemDataValue = {}));
var RelatedOpsItem;
(function (RelatedOpsItem) {
    RelatedOpsItem.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(RelatedOpsItem = exports.RelatedOpsItem || (exports.RelatedOpsItem = {}));
var CreateOpsItemRequest;
(function (CreateOpsItemRequest) {
    CreateOpsItemRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(CreateOpsItemRequest = exports.CreateOpsItemRequest || (exports.CreateOpsItemRequest = {}));
var CreateOpsItemResponse;
(function (CreateOpsItemResponse) {
    CreateOpsItemResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(CreateOpsItemResponse = exports.CreateOpsItemResponse || (exports.CreateOpsItemResponse = {}));
class OpsItemAlreadyExistsException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsItemAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemAlreadyExistsException.prototype);
        this.Message = opts.Message;
        this.OpsItemId = opts.OpsItemId;
    }
}
exports.OpsItemAlreadyExistsException = OpsItemAlreadyExistsException;
var MetadataValue;
(function (MetadataValue) {
    MetadataValue.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(MetadataValue = exports.MetadataValue || (exports.MetadataValue = {}));
var CreateOpsMetadataRequest;
(function (CreateOpsMetadataRequest) {
    CreateOpsMetadataRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(CreateOpsMetadataRequest = exports.CreateOpsMetadataRequest || (exports.CreateOpsMetadataRequest = {}));
var CreateOpsMetadataResult;
(function (CreateOpsMetadataResult) {
    CreateOpsMetadataResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(CreateOpsMetadataResult = exports.CreateOpsMetadataResult || (exports.CreateOpsMetadataResult = {}));
class OpsMetadataAlreadyExistsException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsMetadataAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataAlreadyExistsException.prototype);
    }
}
exports.OpsMetadataAlreadyExistsException = OpsMetadataAlreadyExistsException;
class OpsMetadataInvalidArgumentException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsMetadataInvalidArgumentException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataInvalidArgumentException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataInvalidArgumentException.prototype);
    }
}
exports.OpsMetadataInvalidArgumentException = OpsMetadataInvalidArgumentException;
class OpsMetadataLimitExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsMetadataLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataLimitExceededException.prototype);
    }
}
exports.OpsMetadataLimitExceededException = OpsMetadataLimitExceededException;
class OpsMetadataTooManyUpdatesException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsMetadataTooManyUpdatesException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataTooManyUpdatesException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataTooManyUpdatesException.prototype);
    }
}
exports.OpsMetadataTooManyUpdatesException = OpsMetadataTooManyUpdatesException;
var PatchComplianceLevel;
(function (PatchComplianceLevel) {
    PatchComplianceLevel["Critical"] = "CRITICAL";
    PatchComplianceLevel["High"] = "HIGH";
    PatchComplianceLevel["Informational"] = "INFORMATIONAL";
    PatchComplianceLevel["Low"] = "LOW";
    PatchComplianceLevel["Medium"] = "MEDIUM";
    PatchComplianceLevel["Unspecified"] = "UNSPECIFIED";
})(PatchComplianceLevel = exports.PatchComplianceLevel || (exports.PatchComplianceLevel = {}));
var PatchFilterKey;
(function (PatchFilterKey) {
    PatchFilterKey["AdvisoryId"] = "ADVISORY_ID";
    PatchFilterKey["Arch"] = "ARCH";
    PatchFilterKey["BugzillaId"] = "BUGZILLA_ID";
    PatchFilterKey["CVEId"] = "CVE_ID";
    PatchFilterKey["Classification"] = "CLASSIFICATION";
    PatchFilterKey["Epoch"] = "EPOCH";
    PatchFilterKey["MsrcSeverity"] = "MSRC_SEVERITY";
    PatchFilterKey["Name"] = "NAME";
    PatchFilterKey["PatchId"] = "PATCH_ID";
    PatchFilterKey["PatchSet"] = "PATCH_SET";
    PatchFilterKey["Priority"] = "PRIORITY";
    PatchFilterKey["Product"] = "PRODUCT";
    PatchFilterKey["ProductFamily"] = "PRODUCT_FAMILY";
    PatchFilterKey["Release"] = "RELEASE";
    PatchFilterKey["Repository"] = "REPOSITORY";
    PatchFilterKey["Section"] = "SECTION";
    PatchFilterKey["Security"] = "SECURITY";
    PatchFilterKey["Severity"] = "SEVERITY";
    PatchFilterKey["Version"] = "VERSION";
})(PatchFilterKey = exports.PatchFilterKey || (exports.PatchFilterKey = {}));
var PatchFilter;
(function (PatchFilter) {
    PatchFilter.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(PatchFilter = exports.PatchFilter || (exports.PatchFilter = {}));
var PatchFilterGroup;
(function (PatchFilterGroup) {
    PatchFilterGroup.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(PatchFilterGroup = exports.PatchFilterGroup || (exports.PatchFilterGroup = {}));
var PatchRule;
(function (PatchRule) {
    PatchRule.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(PatchRule = exports.PatchRule || (exports.PatchRule = {}));
var PatchRuleGroup;
(function (PatchRuleGroup) {
    PatchRuleGroup.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(PatchRuleGroup = exports.PatchRuleGroup || (exports.PatchRuleGroup = {}));
var OperatingSystem;
(function (OperatingSystem) {
    OperatingSystem["AmazonLinux"] = "AMAZON_LINUX";
    OperatingSystem["AmazonLinux2"] = "AMAZON_LINUX_2";
    OperatingSystem["CentOS"] = "CENTOS";
    OperatingSystem["Debian"] = "DEBIAN";
    OperatingSystem["MacOS"] = "MACOS";
    OperatingSystem["OracleLinux"] = "ORACLE_LINUX";
    OperatingSystem["Raspbian"] = "RASPBIAN";
    OperatingSystem["RedhatEnterpriseLinux"] = "REDHAT_ENTERPRISE_LINUX";
    OperatingSystem["Rocky_Linux"] = "ROCKY_LINUX";
    OperatingSystem["Suse"] = "SUSE";
    OperatingSystem["Ubuntu"] = "UBUNTU";
    OperatingSystem["Windows"] = "WINDOWS";
})(OperatingSystem = exports.OperatingSystem || (exports.OperatingSystem = {}));
var PatchAction;
(function (PatchAction) {
    PatchAction["AllowAsDependency"] = "ALLOW_AS_DEPENDENCY";
    PatchAction["Block"] = "BLOCK";
})(PatchAction = exports.PatchAction || (exports.PatchAction = {}));
var PatchSource;
(function (PatchSource) {
    PatchSource.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.Configuration && { Configuration: smithy_client_1.SENSITIVE_STRING }),
    });
})(PatchSource = exports.PatchSource || (exports.PatchSource = {}));
var CreatePatchBaselineRequest;
(function (CreatePatchBaselineRequest) {
    CreatePatchBaselineRequest.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.Sources && { Sources: obj.Sources.map((item) => PatchSource.filterSensitiveLog(item)) }),
    });
})(CreatePatchBaselineRequest = exports.CreatePatchBaselineRequest || (exports.CreatePatchBaselineRequest = {}));
var CreatePatchBaselineResult;
(function (CreatePatchBaselineResult) {
    CreatePatchBaselineResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(CreatePatchBaselineResult = exports.CreatePatchBaselineResult || (exports.CreatePatchBaselineResult = {}));
var ResourceDataSyncDestinationDataSharing;
(function (ResourceDataSyncDestinationDataSharing) {
    ResourceDataSyncDestinationDataSharing.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ResourceDataSyncDestinationDataSharing = exports.ResourceDataSyncDestinationDataSharing || (exports.ResourceDataSyncDestinationDataSharing = {}));
var ResourceDataSyncS3Format;
(function (ResourceDataSyncS3Format) {
    ResourceDataSyncS3Format["JSON_SERDE"] = "JsonSerDe";
})(ResourceDataSyncS3Format = exports.ResourceDataSyncS3Format || (exports.ResourceDataSyncS3Format = {}));
var ResourceDataSyncS3Destination;
(function (ResourceDataSyncS3Destination) {
    ResourceDataSyncS3Destination.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ResourceDataSyncS3Destination = exports.ResourceDataSyncS3Destination || (exports.ResourceDataSyncS3Destination = {}));
var ResourceDataSyncOrganizationalUnit;
(function (ResourceDataSyncOrganizationalUnit) {
    ResourceDataSyncOrganizationalUnit.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ResourceDataSyncOrganizationalUnit = exports.ResourceDataSyncOrganizationalUnit || (exports.ResourceDataSyncOrganizationalUnit = {}));
var ResourceDataSyncAwsOrganizationsSource;
(function (ResourceDataSyncAwsOrganizationsSource) {
    ResourceDataSyncAwsOrganizationsSource.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ResourceDataSyncAwsOrganizationsSource = exports.ResourceDataSyncAwsOrganizationsSource || (exports.ResourceDataSyncAwsOrganizationsSource = {}));
var ResourceDataSyncSource;
(function (ResourceDataSyncSource) {
    ResourceDataSyncSource.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ResourceDataSyncSource = exports.ResourceDataSyncSource || (exports.ResourceDataSyncSource = {}));
var CreateResourceDataSyncRequest;
(function (CreateResourceDataSyncRequest) {
    CreateResourceDataSyncRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(CreateResourceDataSyncRequest = exports.CreateResourceDataSyncRequest || (exports.CreateResourceDataSyncRequest = {}));
var CreateResourceDataSyncResult;
(function (CreateResourceDataSyncResult) {
    CreateResourceDataSyncResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(CreateResourceDataSyncResult = exports.CreateResourceDataSyncResult || (exports.CreateResourceDataSyncResult = {}));
class ResourceDataSyncAlreadyExistsException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncAlreadyExistsException.prototype);
        this.SyncName = opts.SyncName;
    }
}
exports.ResourceDataSyncAlreadyExistsException = ResourceDataSyncAlreadyExistsException;
class ResourceDataSyncCountExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncCountExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncCountExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncCountExceededException.prototype);
        this.Message = opts.Message;
    }
}
exports.ResourceDataSyncCountExceededException = ResourceDataSyncCountExceededException;
class ResourceDataSyncInvalidConfigurationException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncInvalidConfigurationException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncInvalidConfigurationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncInvalidConfigurationException.prototype);
        this.Message = opts.Message;
    }
}
exports.ResourceDataSyncInvalidConfigurationException = ResourceDataSyncInvalidConfigurationException;
var DeleteActivationRequest;
(function (DeleteActivationRequest) {
    DeleteActivationRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteActivationRequest = exports.DeleteActivationRequest || (exports.DeleteActivationRequest = {}));
var DeleteActivationResult;
(function (DeleteActivationResult) {
    DeleteActivationResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteActivationResult = exports.DeleteActivationResult || (exports.DeleteActivationResult = {}));
class InvalidActivation extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidActivation",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidActivation";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidActivation.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidActivation = InvalidActivation;
class InvalidActivationId extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidActivationId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidActivationId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidActivationId.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidActivationId = InvalidActivationId;
class AssociationDoesNotExist extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AssociationDoesNotExist",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationDoesNotExist";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationDoesNotExist.prototype);
        this.Message = opts.Message;
    }
}
exports.AssociationDoesNotExist = AssociationDoesNotExist;
var DeleteAssociationRequest;
(function (DeleteAssociationRequest) {
    DeleteAssociationRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteAssociationRequest = exports.DeleteAssociationRequest || (exports.DeleteAssociationRequest = {}));
var DeleteAssociationResult;
(function (DeleteAssociationResult) {
    DeleteAssociationResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteAssociationResult = exports.DeleteAssociationResult || (exports.DeleteAssociationResult = {}));
class AssociatedInstances extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AssociatedInstances",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociatedInstances";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociatedInstances.prototype);
    }
}
exports.AssociatedInstances = AssociatedInstances;
var DeleteDocumentRequest;
(function (DeleteDocumentRequest) {
    DeleteDocumentRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteDocumentRequest = exports.DeleteDocumentRequest || (exports.DeleteDocumentRequest = {}));
var DeleteDocumentResult;
(function (DeleteDocumentResult) {
    DeleteDocumentResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteDocumentResult = exports.DeleteDocumentResult || (exports.DeleteDocumentResult = {}));
class InvalidDocumentOperation extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDocumentOperation",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentOperation";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentOperation.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDocumentOperation = InvalidDocumentOperation;
var InventorySchemaDeleteOption;
(function (InventorySchemaDeleteOption) {
    InventorySchemaDeleteOption["DELETE_SCHEMA"] = "DeleteSchema";
    InventorySchemaDeleteOption["DISABLE_SCHEMA"] = "DisableSchema";
})(InventorySchemaDeleteOption = exports.InventorySchemaDeleteOption || (exports.InventorySchemaDeleteOption = {}));
var DeleteInventoryRequest;
(function (DeleteInventoryRequest) {
    DeleteInventoryRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteInventoryRequest = exports.DeleteInventoryRequest || (exports.DeleteInventoryRequest = {}));
var InventoryDeletionSummaryItem;
(function (InventoryDeletionSummaryItem) {
    InventoryDeletionSummaryItem.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(InventoryDeletionSummaryItem = exports.InventoryDeletionSummaryItem || (exports.InventoryDeletionSummaryItem = {}));
var InventoryDeletionSummary;
(function (InventoryDeletionSummary) {
    InventoryDeletionSummary.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(InventoryDeletionSummary = exports.InventoryDeletionSummary || (exports.InventoryDeletionSummary = {}));
var DeleteInventoryResult;
(function (DeleteInventoryResult) {
    DeleteInventoryResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteInventoryResult = exports.DeleteInventoryResult || (exports.DeleteInventoryResult = {}));
class InvalidDeleteInventoryParametersException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDeleteInventoryParametersException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDeleteInventoryParametersException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDeleteInventoryParametersException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDeleteInventoryParametersException = InvalidDeleteInventoryParametersException;
class InvalidInventoryRequestException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidInventoryRequestException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInventoryRequestException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInventoryRequestException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidInventoryRequestException = InvalidInventoryRequestException;
class InvalidOptionException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidOptionException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidOptionException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidOptionException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidOptionException = InvalidOptionException;
class InvalidTypeNameException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidTypeNameException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTypeNameException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTypeNameException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidTypeNameException = InvalidTypeNameException;
var DeleteMaintenanceWindowRequest;
(function (DeleteMaintenanceWindowRequest) {
    DeleteMaintenanceWindowRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteMaintenanceWindowRequest = exports.DeleteMaintenanceWindowRequest || (exports.DeleteMaintenanceWindowRequest = {}));
var DeleteMaintenanceWindowResult;
(function (DeleteMaintenanceWindowResult) {
    DeleteMaintenanceWindowResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteMaintenanceWindowResult = exports.DeleteMaintenanceWindowResult || (exports.DeleteMaintenanceWindowResult = {}));
var DeleteOpsMetadataRequest;
(function (DeleteOpsMetadataRequest) {
    DeleteOpsMetadataRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteOpsMetadataRequest = exports.DeleteOpsMetadataRequest || (exports.DeleteOpsMetadataRequest = {}));
var DeleteOpsMetadataResult;
(function (DeleteOpsMetadataResult) {
    DeleteOpsMetadataResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteOpsMetadataResult = exports.DeleteOpsMetadataResult || (exports.DeleteOpsMetadataResult = {}));
class OpsMetadataNotFoundException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsMetadataNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataNotFoundException.prototype);
    }
}
exports.OpsMetadataNotFoundException = OpsMetadataNotFoundException;
var DeleteParameterRequest;
(function (DeleteParameterRequest) {
    DeleteParameterRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteParameterRequest = exports.DeleteParameterRequest || (exports.DeleteParameterRequest = {}));
var DeleteParameterResult;
(function (DeleteParameterResult) {
    DeleteParameterResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteParameterResult = exports.DeleteParameterResult || (exports.DeleteParameterResult = {}));
class ParameterNotFound extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ParameterNotFound",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterNotFound";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterNotFound.prototype);
    }
}
exports.ParameterNotFound = ParameterNotFound;
var DeleteParametersRequest;
(function (DeleteParametersRequest) {
    DeleteParametersRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteParametersRequest = exports.DeleteParametersRequest || (exports.DeleteParametersRequest = {}));
var DeleteParametersResult;
(function (DeleteParametersResult) {
    DeleteParametersResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteParametersResult = exports.DeleteParametersResult || (exports.DeleteParametersResult = {}));
var DeletePatchBaselineRequest;
(function (DeletePatchBaselineRequest) {
    DeletePatchBaselineRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeletePatchBaselineRequest = exports.DeletePatchBaselineRequest || (exports.DeletePatchBaselineRequest = {}));
var DeletePatchBaselineResult;
(function (DeletePatchBaselineResult) {
    DeletePatchBaselineResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeletePatchBaselineResult = exports.DeletePatchBaselineResult || (exports.DeletePatchBaselineResult = {}));
class ResourceInUseException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourceInUseException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceInUseException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceInUseException.prototype);
        this.Message = opts.Message;
    }
}
exports.ResourceInUseException = ResourceInUseException;
var DeleteResourceDataSyncRequest;
(function (DeleteResourceDataSyncRequest) {
    DeleteResourceDataSyncRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteResourceDataSyncRequest = exports.DeleteResourceDataSyncRequest || (exports.DeleteResourceDataSyncRequest = {}));
var DeleteResourceDataSyncResult;
(function (DeleteResourceDataSyncResult) {
    DeleteResourceDataSyncResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeleteResourceDataSyncResult = exports.DeleteResourceDataSyncResult || (exports.DeleteResourceDataSyncResult = {}));
class ResourceDataSyncNotFoundException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncNotFoundException.prototype);
        this.SyncName = opts.SyncName;
        this.SyncType = opts.SyncType;
        this.Message = opts.Message;
    }
}
exports.ResourceDataSyncNotFoundException = ResourceDataSyncNotFoundException;
var DeregisterManagedInstanceRequest;
(function (DeregisterManagedInstanceRequest) {
    DeregisterManagedInstanceRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeregisterManagedInstanceRequest = exports.DeregisterManagedInstanceRequest || (exports.DeregisterManagedInstanceRequest = {}));
var DeregisterManagedInstanceResult;
(function (DeregisterManagedInstanceResult) {
    DeregisterManagedInstanceResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeregisterManagedInstanceResult = exports.DeregisterManagedInstanceResult || (exports.DeregisterManagedInstanceResult = {}));
var DeregisterPatchBaselineForPatchGroupRequest;
(function (DeregisterPatchBaselineForPatchGroupRequest) {
    DeregisterPatchBaselineForPatchGroupRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeregisterPatchBaselineForPatchGroupRequest = exports.DeregisterPatchBaselineForPatchGroupRequest || (exports.DeregisterPatchBaselineForPatchGroupRequest = {}));
var DeregisterPatchBaselineForPatchGroupResult;
(function (DeregisterPatchBaselineForPatchGroupResult) {
    DeregisterPatchBaselineForPatchGroupResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeregisterPatchBaselineForPatchGroupResult = exports.DeregisterPatchBaselineForPatchGroupResult || (exports.DeregisterPatchBaselineForPatchGroupResult = {}));
var DeregisterTargetFromMaintenanceWindowRequest;
(function (DeregisterTargetFromMaintenanceWindowRequest) {
    DeregisterTargetFromMaintenanceWindowRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeregisterTargetFromMaintenanceWindowRequest = exports.DeregisterTargetFromMaintenanceWindowRequest || (exports.DeregisterTargetFromMaintenanceWindowRequest = {}));
var DeregisterTargetFromMaintenanceWindowResult;
(function (DeregisterTargetFromMaintenanceWindowResult) {
    DeregisterTargetFromMaintenanceWindowResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeregisterTargetFromMaintenanceWindowResult = exports.DeregisterTargetFromMaintenanceWindowResult || (exports.DeregisterTargetFromMaintenanceWindowResult = {}));
class TargetInUseException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "TargetInUseException",
            $fault: "client",
            ...opts,
        });
        this.name = "TargetInUseException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TargetInUseException.prototype);
        this.Message = opts.Message;
    }
}
exports.TargetInUseException = TargetInUseException;
var DeregisterTaskFromMaintenanceWindowRequest;
(function (DeregisterTaskFromMaintenanceWindowRequest) {
    DeregisterTaskFromMaintenanceWindowRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeregisterTaskFromMaintenanceWindowRequest = exports.DeregisterTaskFromMaintenanceWindowRequest || (exports.DeregisterTaskFromMaintenanceWindowRequest = {}));
var DeregisterTaskFromMaintenanceWindowResult;
(function (DeregisterTaskFromMaintenanceWindowResult) {
    DeregisterTaskFromMaintenanceWindowResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DeregisterTaskFromMaintenanceWindowResult = exports.DeregisterTaskFromMaintenanceWindowResult || (exports.DeregisterTaskFromMaintenanceWindowResult = {}));
var DescribeActivationsFilterKeys;
(function (DescribeActivationsFilterKeys) {
    DescribeActivationsFilterKeys["ACTIVATION_IDS"] = "ActivationIds";
    DescribeActivationsFilterKeys["DEFAULT_INSTANCE_NAME"] = "DefaultInstanceName";
    DescribeActivationsFilterKeys["IAM_ROLE"] = "IamRole";
})(DescribeActivationsFilterKeys = exports.DescribeActivationsFilterKeys || (exports.DescribeActivationsFilterKeys = {}));
var DescribeActivationsFilter;
(function (DescribeActivationsFilter) {
    DescribeActivationsFilter.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeActivationsFilter = exports.DescribeActivationsFilter || (exports.DescribeActivationsFilter = {}));
var DescribeActivationsRequest;
(function (DescribeActivationsRequest) {
    DescribeActivationsRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeActivationsRequest = exports.DescribeActivationsRequest || (exports.DescribeActivationsRequest = {}));
var DescribeActivationsResult;
(function (DescribeActivationsResult) {
    DescribeActivationsResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeActivationsResult = exports.DescribeActivationsResult || (exports.DescribeActivationsResult = {}));
class InvalidFilter extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidFilter",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidFilter";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidFilter.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidFilter = InvalidFilter;
class InvalidNextToken extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidNextToken",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidNextToken";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidNextToken.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidNextToken = InvalidNextToken;
var DescribeAssociationRequest;
(function (DescribeAssociationRequest) {
    DescribeAssociationRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeAssociationRequest = exports.DescribeAssociationRequest || (exports.DescribeAssociationRequest = {}));
var DescribeAssociationResult;
(function (DescribeAssociationResult) {
    DescribeAssociationResult.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.AssociationDescription && {
            AssociationDescription: AssociationDescription.filterSensitiveLog(obj.AssociationDescription),
        }),
    });
})(DescribeAssociationResult = exports.DescribeAssociationResult || (exports.DescribeAssociationResult = {}));
class InvalidAssociationVersion extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidAssociationVersion",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAssociationVersion";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAssociationVersion.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidAssociationVersion = InvalidAssociationVersion;
var AssociationExecutionFilterKey;
(function (AssociationExecutionFilterKey) {
    AssociationExecutionFilterKey["CreatedTime"] = "CreatedTime";
    AssociationExecutionFilterKey["ExecutionId"] = "ExecutionId";
    AssociationExecutionFilterKey["Status"] = "Status";
})(AssociationExecutionFilterKey = exports.AssociationExecutionFilterKey || (exports.AssociationExecutionFilterKey = {}));
var AssociationFilterOperatorType;
(function (AssociationFilterOperatorType) {
    AssociationFilterOperatorType["Equal"] = "EQUAL";
    AssociationFilterOperatorType["GreaterThan"] = "GREATER_THAN";
    AssociationFilterOperatorType["LessThan"] = "LESS_THAN";
})(AssociationFilterOperatorType = exports.AssociationFilterOperatorType || (exports.AssociationFilterOperatorType = {}));
var AssociationExecutionFilter;
(function (AssociationExecutionFilter) {
    AssociationExecutionFilter.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(AssociationExecutionFilter = exports.AssociationExecutionFilter || (exports.AssociationExecutionFilter = {}));
var DescribeAssociationExecutionsRequest;
(function (DescribeAssociationExecutionsRequest) {
    DescribeAssociationExecutionsRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeAssociationExecutionsRequest = exports.DescribeAssociationExecutionsRequest || (exports.DescribeAssociationExecutionsRequest = {}));
var AssociationExecution;
(function (AssociationExecution) {
    AssociationExecution.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(AssociationExecution = exports.AssociationExecution || (exports.AssociationExecution = {}));
var DescribeAssociationExecutionsResult;
(function (DescribeAssociationExecutionsResult) {
    DescribeAssociationExecutionsResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeAssociationExecutionsResult = exports.DescribeAssociationExecutionsResult || (exports.DescribeAssociationExecutionsResult = {}));
class AssociationExecutionDoesNotExist extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AssociationExecutionDoesNotExist",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationExecutionDoesNotExist";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationExecutionDoesNotExist.prototype);
        this.Message = opts.Message;
    }
}
exports.AssociationExecutionDoesNotExist = AssociationExecutionDoesNotExist;
var AssociationExecutionTargetsFilterKey;
(function (AssociationExecutionTargetsFilterKey) {
    AssociationExecutionTargetsFilterKey["ResourceId"] = "ResourceId";
    AssociationExecutionTargetsFilterKey["ResourceType"] = "ResourceType";
    AssociationExecutionTargetsFilterKey["Status"] = "Status";
})(AssociationExecutionTargetsFilterKey = exports.AssociationExecutionTargetsFilterKey || (exports.AssociationExecutionTargetsFilterKey = {}));
var AssociationExecutionTargetsFilter;
(function (AssociationExecutionTargetsFilter) {
    AssociationExecutionTargetsFilter.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(AssociationExecutionTargetsFilter = exports.AssociationExecutionTargetsFilter || (exports.AssociationExecutionTargetsFilter = {}));
var DescribeAssociationExecutionTargetsRequest;
(function (DescribeAssociationExecutionTargetsRequest) {
    DescribeAssociationExecutionTargetsRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeAssociationExecutionTargetsRequest = exports.DescribeAssociationExecutionTargetsRequest || (exports.DescribeAssociationExecutionTargetsRequest = {}));
var OutputSource;
(function (OutputSource) {
    OutputSource.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(OutputSource = exports.OutputSource || (exports.OutputSource = {}));
var AssociationExecutionTarget;
(function (AssociationExecutionTarget) {
    AssociationExecutionTarget.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(AssociationExecutionTarget = exports.AssociationExecutionTarget || (exports.AssociationExecutionTarget = {}));
var DescribeAssociationExecutionTargetsResult;
(function (DescribeAssociationExecutionTargetsResult) {
    DescribeAssociationExecutionTargetsResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeAssociationExecutionTargetsResult = exports.DescribeAssociationExecutionTargetsResult || (exports.DescribeAssociationExecutionTargetsResult = {}));
var AutomationExecutionFilterKey;
(function (AutomationExecutionFilterKey) {
    AutomationExecutionFilterKey["AUTOMATION_SUBTYPE"] = "AutomationSubtype";
    AutomationExecutionFilterKey["AUTOMATION_TYPE"] = "AutomationType";
    AutomationExecutionFilterKey["CURRENT_ACTION"] = "CurrentAction";
    AutomationExecutionFilterKey["DOCUMENT_NAME_PREFIX"] = "DocumentNamePrefix";
    AutomationExecutionFilterKey["EXECUTION_ID"] = "ExecutionId";
    AutomationExecutionFilterKey["EXECUTION_STATUS"] = "ExecutionStatus";
    AutomationExecutionFilterKey["OPS_ITEM_ID"] = "OpsItemId";
    AutomationExecutionFilterKey["PARENT_EXECUTION_ID"] = "ParentExecutionId";
    AutomationExecutionFilterKey["START_TIME_AFTER"] = "StartTimeAfter";
    AutomationExecutionFilterKey["START_TIME_BEFORE"] = "StartTimeBefore";
    AutomationExecutionFilterKey["TAG_KEY"] = "TagKey";
    AutomationExecutionFilterKey["TARGET_RESOURCE_GROUP"] = "TargetResourceGroup";
})(AutomationExecutionFilterKey = exports.AutomationExecutionFilterKey || (exports.AutomationExecutionFilterKey = {}));
var AutomationExecutionFilter;
(function (AutomationExecutionFilter) {
    AutomationExecutionFilter.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(AutomationExecutionFilter = exports.AutomationExecutionFilter || (exports.AutomationExecutionFilter = {}));
var DescribeAutomationExecutionsRequest;
(function (DescribeAutomationExecutionsRequest) {
    DescribeAutomationExecutionsRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeAutomationExecutionsRequest = exports.DescribeAutomationExecutionsRequest || (exports.DescribeAutomationExecutionsRequest = {}));
var AutomationExecutionStatus;
(function (AutomationExecutionStatus) {
    AutomationExecutionStatus["APPROVED"] = "Approved";
    AutomationExecutionStatus["CANCELLED"] = "Cancelled";
    AutomationExecutionStatus["CANCELLING"] = "Cancelling";
    AutomationExecutionStatus["CHANGE_CALENDAR_OVERRIDE_APPROVED"] = "ChangeCalendarOverrideApproved";
    AutomationExecutionStatus["CHANGE_CALENDAR_OVERRIDE_REJECTED"] = "ChangeCalendarOverrideRejected";
    AutomationExecutionStatus["COMPLETED_WITH_FAILURE"] = "CompletedWithFailure";
    AutomationExecutionStatus["COMPLETED_WITH_SUCCESS"] = "CompletedWithSuccess";
    AutomationExecutionStatus["FAILED"] = "Failed";
    AutomationExecutionStatus["INPROGRESS"] = "InProgress";
    AutomationExecutionStatus["PENDING"] = "Pending";
    AutomationExecutionStatus["PENDING_APPROVAL"] = "PendingApproval";
    AutomationExecutionStatus["PENDING_CHANGE_CALENDAR_OVERRIDE"] = "PendingChangeCalendarOverride";
    AutomationExecutionStatus["REJECTED"] = "Rejected";
    AutomationExecutionStatus["RUNBOOK_INPROGRESS"] = "RunbookInProgress";
    AutomationExecutionStatus["SCHEDULED"] = "Scheduled";
    AutomationExecutionStatus["SUCCESS"] = "Success";
    AutomationExecutionStatus["TIMEDOUT"] = "TimedOut";
    AutomationExecutionStatus["WAITING"] = "Waiting";
})(AutomationExecutionStatus = exports.AutomationExecutionStatus || (exports.AutomationExecutionStatus = {}));
var AutomationSubtype;
(function (AutomationSubtype) {
    AutomationSubtype["ChangeRequest"] = "ChangeRequest";
})(AutomationSubtype = exports.AutomationSubtype || (exports.AutomationSubtype = {}));
var AutomationType;
(function (AutomationType) {
    AutomationType["CrossAccount"] = "CrossAccount";
    AutomationType["Local"] = "Local";
})(AutomationType = exports.AutomationType || (exports.AutomationType = {}));
var ExecutionMode;
(function (ExecutionMode) {
    ExecutionMode["Auto"] = "Auto";
    ExecutionMode["Interactive"] = "Interactive";
})(ExecutionMode = exports.ExecutionMode || (exports.ExecutionMode = {}));
var ResolvedTargets;
(function (ResolvedTargets) {
    ResolvedTargets.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ResolvedTargets = exports.ResolvedTargets || (exports.ResolvedTargets = {}));
var Runbook;
(function (Runbook) {
    Runbook.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(Runbook = exports.Runbook || (exports.Runbook = {}));
var AutomationExecutionMetadata;
(function (AutomationExecutionMetadata) {
    AutomationExecutionMetadata.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(AutomationExecutionMetadata = exports.AutomationExecutionMetadata || (exports.AutomationExecutionMetadata = {}));
var DescribeAutomationExecutionsResult;
(function (DescribeAutomationExecutionsResult) {
    DescribeAutomationExecutionsResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeAutomationExecutionsResult = exports.DescribeAutomationExecutionsResult || (exports.DescribeAutomationExecutionsResult = {}));
class InvalidFilterKey extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidFilterKey",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidFilterKey";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidFilterKey.prototype);
    }
}
exports.InvalidFilterKey = InvalidFilterKey;
class InvalidFilterValue extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidFilterValue",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidFilterValue";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidFilterValue.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidFilterValue = InvalidFilterValue;
class AutomationExecutionNotFoundException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "AutomationExecutionNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "AutomationExecutionNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AutomationExecutionNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
exports.AutomationExecutionNotFoundException = AutomationExecutionNotFoundException;
var StepExecutionFilterKey;
(function (StepExecutionFilterKey) {
    StepExecutionFilterKey["ACTION"] = "Action";
    StepExecutionFilterKey["START_TIME_AFTER"] = "StartTimeAfter";
    StepExecutionFilterKey["START_TIME_BEFORE"] = "StartTimeBefore";
    StepExecutionFilterKey["STEP_EXECUTION_ID"] = "StepExecutionId";
    StepExecutionFilterKey["STEP_EXECUTION_STATUS"] = "StepExecutionStatus";
    StepExecutionFilterKey["STEP_NAME"] = "StepName";
})(StepExecutionFilterKey = exports.StepExecutionFilterKey || (exports.StepExecutionFilterKey = {}));
var StepExecutionFilter;
(function (StepExecutionFilter) {
    StepExecutionFilter.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(StepExecutionFilter = exports.StepExecutionFilter || (exports.StepExecutionFilter = {}));
var DescribeAutomationStepExecutionsRequest;
(function (DescribeAutomationStepExecutionsRequest) {
    DescribeAutomationStepExecutionsRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeAutomationStepExecutionsRequest = exports.DescribeAutomationStepExecutionsRequest || (exports.DescribeAutomationStepExecutionsRequest = {}));
var FailureDetails;
(function (FailureDetails) {
    FailureDetails.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(FailureDetails = exports.FailureDetails || (exports.FailureDetails = {}));
var StepExecution;
(function (StepExecution) {
    StepExecution.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(StepExecution = exports.StepExecution || (exports.StepExecution = {}));
var DescribeAutomationStepExecutionsResult;
(function (DescribeAutomationStepExecutionsResult) {
    DescribeAutomationStepExecutionsResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeAutomationStepExecutionsResult = exports.DescribeAutomationStepExecutionsResult || (exports.DescribeAutomationStepExecutionsResult = {}));
var PatchOrchestratorFilter;
(function (PatchOrchestratorFilter) {
    PatchOrchestratorFilter.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(PatchOrchestratorFilter = exports.PatchOrchestratorFilter || (exports.PatchOrchestratorFilter = {}));
var DescribeAvailablePatchesRequest;
(function (DescribeAvailablePatchesRequest) {
    DescribeAvailablePatchesRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeAvailablePatchesRequest = exports.DescribeAvailablePatchesRequest || (exports.DescribeAvailablePatchesRequest = {}));
var Patch;
(function (Patch) {
    Patch.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(Patch = exports.Patch || (exports.Patch = {}));
var DescribeAvailablePatchesResult;
(function (DescribeAvailablePatchesResult) {
    DescribeAvailablePatchesResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeAvailablePatchesResult = exports.DescribeAvailablePatchesResult || (exports.DescribeAvailablePatchesResult = {}));
var DescribeDocumentRequest;
(function (DescribeDocumentRequest) {
    DescribeDocumentRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeDocumentRequest = exports.DescribeDocumentRequest || (exports.DescribeDocumentRequest = {}));
var DescribeDocumentResult;
(function (DescribeDocumentResult) {
    DescribeDocumentResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeDocumentResult = exports.DescribeDocumentResult || (exports.DescribeDocumentResult = {}));
var DocumentPermissionType;
(function (DocumentPermissionType) {
    DocumentPermissionType["SHARE"] = "Share";
})(DocumentPermissionType = exports.DocumentPermissionType || (exports.DocumentPermissionType = {}));
var DescribeDocumentPermissionRequest;
(function (DescribeDocumentPermissionRequest) {
    DescribeDocumentPermissionRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeDocumentPermissionRequest = exports.DescribeDocumentPermissionRequest || (exports.DescribeDocumentPermissionRequest = {}));
var DescribeDocumentPermissionResponse;
(function (DescribeDocumentPermissionResponse) {
    DescribeDocumentPermissionResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeDocumentPermissionResponse = exports.DescribeDocumentPermissionResponse || (exports.DescribeDocumentPermissionResponse = {}));
class InvalidPermissionType extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidPermissionType",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidPermissionType";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidPermissionType.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidPermissionType = InvalidPermissionType;
var DescribeEffectiveInstanceAssociationsRequest;
(function (DescribeEffectiveInstanceAssociationsRequest) {
    DescribeEffectiveInstanceAssociationsRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeEffectiveInstanceAssociationsRequest = exports.DescribeEffectiveInstanceAssociationsRequest || (exports.DescribeEffectiveInstanceAssociationsRequest = {}));
var InstanceAssociation;
(function (InstanceAssociation) {
    InstanceAssociation.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(InstanceAssociation = exports.InstanceAssociation || (exports.InstanceAssociation = {}));
var DescribeEffectiveInstanceAssociationsResult;
(function (DescribeEffectiveInstanceAssociationsResult) {
    DescribeEffectiveInstanceAssociationsResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeEffectiveInstanceAssociationsResult = exports.DescribeEffectiveInstanceAssociationsResult || (exports.DescribeEffectiveInstanceAssociationsResult = {}));
var DescribeEffectivePatchesForPatchBaselineRequest;
(function (DescribeEffectivePatchesForPatchBaselineRequest) {
    DescribeEffectivePatchesForPatchBaselineRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeEffectivePatchesForPatchBaselineRequest = exports.DescribeEffectivePatchesForPatchBaselineRequest || (exports.DescribeEffectivePatchesForPatchBaselineRequest = {}));
var PatchDeploymentStatus;
(function (PatchDeploymentStatus) {
    PatchDeploymentStatus["Approved"] = "APPROVED";
    PatchDeploymentStatus["ExplicitApproved"] = "EXPLICIT_APPROVED";
    PatchDeploymentStatus["ExplicitRejected"] = "EXPLICIT_REJECTED";
    PatchDeploymentStatus["PendingApproval"] = "PENDING_APPROVAL";
})(PatchDeploymentStatus = exports.PatchDeploymentStatus || (exports.PatchDeploymentStatus = {}));
var PatchStatus;
(function (PatchStatus) {
    PatchStatus.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(PatchStatus = exports.PatchStatus || (exports.PatchStatus = {}));
var EffectivePatch;
(function (EffectivePatch) {
    EffectivePatch.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(EffectivePatch = exports.EffectivePatch || (exports.EffectivePatch = {}));
var DescribeEffectivePatchesForPatchBaselineResult;
(function (DescribeEffectivePatchesForPatchBaselineResult) {
    DescribeEffectivePatchesForPatchBaselineResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeEffectivePatchesForPatchBaselineResult = exports.DescribeEffectivePatchesForPatchBaselineResult || (exports.DescribeEffectivePatchesForPatchBaselineResult = {}));
class UnsupportedOperatingSystem extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "UnsupportedOperatingSystem",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedOperatingSystem";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedOperatingSystem.prototype);
        this.Message = opts.Message;
    }
}
exports.UnsupportedOperatingSystem = UnsupportedOperatingSystem;
var DescribeInstanceAssociationsStatusRequest;
(function (DescribeInstanceAssociationsStatusRequest) {
    DescribeInstanceAssociationsStatusRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeInstanceAssociationsStatusRequest = exports.DescribeInstanceAssociationsStatusRequest || (exports.DescribeInstanceAssociationsStatusRequest = {}));
var S3OutputUrl;
(function (S3OutputUrl) {
    S3OutputUrl.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(S3OutputUrl = exports.S3OutputUrl || (exports.S3OutputUrl = {}));
var InstanceAssociationOutputUrl;
(function (InstanceAssociationOutputUrl) {
    InstanceAssociationOutputUrl.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(InstanceAssociationOutputUrl = exports.InstanceAssociationOutputUrl || (exports.InstanceAssociationOutputUrl = {}));
var InstanceAssociationStatusInfo;
(function (InstanceAssociationStatusInfo) {
    InstanceAssociationStatusInfo.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(InstanceAssociationStatusInfo = exports.InstanceAssociationStatusInfo || (exports.InstanceAssociationStatusInfo = {}));
var DescribeInstanceAssociationsStatusResult;
(function (DescribeInstanceAssociationsStatusResult) {
    DescribeInstanceAssociationsStatusResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeInstanceAssociationsStatusResult = exports.DescribeInstanceAssociationsStatusResult || (exports.DescribeInstanceAssociationsStatusResult = {}));
var InstanceInformationStringFilter;
(function (InstanceInformationStringFilter) {
    InstanceInformationStringFilter.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(InstanceInformationStringFilter = exports.InstanceInformationStringFilter || (exports.InstanceInformationStringFilter = {}));
var InstanceInformationFilterKey;
(function (InstanceInformationFilterKey) {
    InstanceInformationFilterKey["ACTIVATION_IDS"] = "ActivationIds";
    InstanceInformationFilterKey["AGENT_VERSION"] = "AgentVersion";
    InstanceInformationFilterKey["ASSOCIATION_STATUS"] = "AssociationStatus";
    InstanceInformationFilterKey["IAM_ROLE"] = "IamRole";
    InstanceInformationFilterKey["INSTANCE_IDS"] = "InstanceIds";
    InstanceInformationFilterKey["PING_STATUS"] = "PingStatus";
    InstanceInformationFilterKey["PLATFORM_TYPES"] = "PlatformTypes";
    InstanceInformationFilterKey["RESOURCE_TYPE"] = "ResourceType";
})(InstanceInformationFilterKey = exports.InstanceInformationFilterKey || (exports.InstanceInformationFilterKey = {}));
var InstanceInformationFilter;
(function (InstanceInformationFilter) {
    InstanceInformationFilter.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(InstanceInformationFilter = exports.InstanceInformationFilter || (exports.InstanceInformationFilter = {}));
var DescribeInstanceInformationRequest;
(function (DescribeInstanceInformationRequest) {
    DescribeInstanceInformationRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeInstanceInformationRequest = exports.DescribeInstanceInformationRequest || (exports.DescribeInstanceInformationRequest = {}));
var InstanceAggregatedAssociationOverview;
(function (InstanceAggregatedAssociationOverview) {
    InstanceAggregatedAssociationOverview.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(InstanceAggregatedAssociationOverview = exports.InstanceAggregatedAssociationOverview || (exports.InstanceAggregatedAssociationOverview = {}));
var PingStatus;
(function (PingStatus) {
    PingStatus["CONNECTION_LOST"] = "ConnectionLost";
    PingStatus["INACTIVE"] = "Inactive";
    PingStatus["ONLINE"] = "Online";
})(PingStatus = exports.PingStatus || (exports.PingStatus = {}));
var ResourceType;
(function (ResourceType) {
    ResourceType["DOCUMENT"] = "Document";
    ResourceType["EC2_INSTANCE"] = "EC2Instance";
    ResourceType["MANAGED_INSTANCE"] = "ManagedInstance";
})(ResourceType = exports.ResourceType || (exports.ResourceType = {}));
var SourceType;
(function (SourceType) {
    SourceType["AWS_EC2_INSTANCE"] = "AWS::EC2::Instance";
    SourceType["AWS_IOT_THING"] = "AWS::IoT::Thing";
    SourceType["AWS_SSM_MANAGEDINSTANCE"] = "AWS::SSM::ManagedInstance";
})(SourceType = exports.SourceType || (exports.SourceType = {}));
var InstanceInformation;
(function (InstanceInformation) {
    InstanceInformation.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(InstanceInformation = exports.InstanceInformation || (exports.InstanceInformation = {}));
var DescribeInstanceInformationResult;
(function (DescribeInstanceInformationResult) {
    DescribeInstanceInformationResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeInstanceInformationResult = exports.DescribeInstanceInformationResult || (exports.DescribeInstanceInformationResult = {}));
class InvalidInstanceInformationFilterValue extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidInstanceInformationFilterValue",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInstanceInformationFilterValue";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInstanceInformationFilterValue.prototype);
    }
}
exports.InvalidInstanceInformationFilterValue = InvalidInstanceInformationFilterValue;
var DescribeInstancePatchesRequest;
(function (DescribeInstancePatchesRequest) {
    DescribeInstancePatchesRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeInstancePatchesRequest = exports.DescribeInstancePatchesRequest || (exports.DescribeInstancePatchesRequest = {}));
var PatchComplianceDataState;
(function (PatchComplianceDataState) {
    PatchComplianceDataState["Failed"] = "FAILED";
    PatchComplianceDataState["Installed"] = "INSTALLED";
    PatchComplianceDataState["InstalledOther"] = "INSTALLED_OTHER";
    PatchComplianceDataState["InstalledPendingReboot"] = "INSTALLED_PENDING_REBOOT";
    PatchComplianceDataState["InstalledRejected"] = "INSTALLED_REJECTED";
    PatchComplianceDataState["Missing"] = "MISSING";
    PatchComplianceDataState["NotApplicable"] = "NOT_APPLICABLE";
})(PatchComplianceDataState = exports.PatchComplianceDataState || (exports.PatchComplianceDataState = {}));
var PatchComplianceData;
(function (PatchComplianceData) {
    PatchComplianceData.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(PatchComplianceData = exports.PatchComplianceData || (exports.PatchComplianceData = {}));
var DescribeInstancePatchesResult;
(function (DescribeInstancePatchesResult) {
    DescribeInstancePatchesResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeInstancePatchesResult = exports.DescribeInstancePatchesResult || (exports.DescribeInstancePatchesResult = {}));
var DescribeInstancePatchStatesRequest;
(function (DescribeInstancePatchStatesRequest) {
    DescribeInstancePatchStatesRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeInstancePatchStatesRequest = exports.DescribeInstancePatchStatesRequest || (exports.DescribeInstancePatchStatesRequest = {}));
var PatchOperationType;
(function (PatchOperationType) {
    PatchOperationType["INSTALL"] = "Install";
    PatchOperationType["SCAN"] = "Scan";
})(PatchOperationType = exports.PatchOperationType || (exports.PatchOperationType = {}));
var RebootOption;
(function (RebootOption) {
    RebootOption["NO_REBOOT"] = "NoReboot";
    RebootOption["REBOOT_IF_NEEDED"] = "RebootIfNeeded";
})(RebootOption = exports.RebootOption || (exports.RebootOption = {}));
var InstancePatchState;
(function (InstancePatchState) {
    InstancePatchState.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.OwnerInformation && { OwnerInformation: smithy_client_1.SENSITIVE_STRING }),
    });
})(InstancePatchState = exports.InstancePatchState || (exports.InstancePatchState = {}));
var DescribeInstancePatchStatesResult;
(function (DescribeInstancePatchStatesResult) {
    DescribeInstancePatchStatesResult.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.InstancePatchStates && {
            InstancePatchStates: obj.InstancePatchStates.map((item) => InstancePatchState.filterSensitiveLog(item)),
        }),
    });
})(DescribeInstancePatchStatesResult = exports.DescribeInstancePatchStatesResult || (exports.DescribeInstancePatchStatesResult = {}));
var InstancePatchStateOperatorType;
(function (InstancePatchStateOperatorType) {
    InstancePatchStateOperatorType["EQUAL"] = "Equal";
    InstancePatchStateOperatorType["GREATER_THAN"] = "GreaterThan";
    InstancePatchStateOperatorType["LESS_THAN"] = "LessThan";
    InstancePatchStateOperatorType["NOT_EQUAL"] = "NotEqual";
})(InstancePatchStateOperatorType = exports.InstancePatchStateOperatorType || (exports.InstancePatchStateOperatorType = {}));
var InstancePatchStateFilter;
(function (InstancePatchStateFilter) {
    InstancePatchStateFilter.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(InstancePatchStateFilter = exports.InstancePatchStateFilter || (exports.InstancePatchStateFilter = {}));
var DescribeInstancePatchStatesForPatchGroupRequest;
(function (DescribeInstancePatchStatesForPatchGroupRequest) {
    DescribeInstancePatchStatesForPatchGroupRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeInstancePatchStatesForPatchGroupRequest = exports.DescribeInstancePatchStatesForPatchGroupRequest || (exports.DescribeInstancePatchStatesForPatchGroupRequest = {}));
var DescribeInstancePatchStatesForPatchGroupResult;
(function (DescribeInstancePatchStatesForPatchGroupResult) {
    DescribeInstancePatchStatesForPatchGroupResult.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.InstancePatchStates && {
            InstancePatchStates: obj.InstancePatchStates.map((item) => InstancePatchState.filterSensitiveLog(item)),
        }),
    });
})(DescribeInstancePatchStatesForPatchGroupResult = exports.DescribeInstancePatchStatesForPatchGroupResult || (exports.DescribeInstancePatchStatesForPatchGroupResult = {}));
var DescribeInventoryDeletionsRequest;
(function (DescribeInventoryDeletionsRequest) {
    DescribeInventoryDeletionsRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeInventoryDeletionsRequest = exports.DescribeInventoryDeletionsRequest || (exports.DescribeInventoryDeletionsRequest = {}));
var InventoryDeletionStatus;
(function (InventoryDeletionStatus) {
    InventoryDeletionStatus["COMPLETE"] = "Complete";
    InventoryDeletionStatus["IN_PROGRESS"] = "InProgress";
})(InventoryDeletionStatus = exports.InventoryDeletionStatus || (exports.InventoryDeletionStatus = {}));
var InventoryDeletionStatusItem;
(function (InventoryDeletionStatusItem) {
    InventoryDeletionStatusItem.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(InventoryDeletionStatusItem = exports.InventoryDeletionStatusItem || (exports.InventoryDeletionStatusItem = {}));
var DescribeInventoryDeletionsResult;
(function (DescribeInventoryDeletionsResult) {
    DescribeInventoryDeletionsResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeInventoryDeletionsResult = exports.DescribeInventoryDeletionsResult || (exports.DescribeInventoryDeletionsResult = {}));
class InvalidDeletionIdException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "InvalidDeletionIdException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDeletionIdException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDeletionIdException.prototype);
        this.Message = opts.Message;
    }
}
exports.InvalidDeletionIdException = InvalidDeletionIdException;
var MaintenanceWindowFilter;
(function (MaintenanceWindowFilter) {
    MaintenanceWindowFilter.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(MaintenanceWindowFilter = exports.MaintenanceWindowFilter || (exports.MaintenanceWindowFilter = {}));
var DescribeMaintenanceWindowExecutionsRequest;
(function (DescribeMaintenanceWindowExecutionsRequest) {
    DescribeMaintenanceWindowExecutionsRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeMaintenanceWindowExecutionsRequest = exports.DescribeMaintenanceWindowExecutionsRequest || (exports.DescribeMaintenanceWindowExecutionsRequest = {}));
var MaintenanceWindowExecutionStatus;
(function (MaintenanceWindowExecutionStatus) {
    MaintenanceWindowExecutionStatus["Cancelled"] = "CANCELLED";
    MaintenanceWindowExecutionStatus["Cancelling"] = "CANCELLING";
    MaintenanceWindowExecutionStatus["Failed"] = "FAILED";
    MaintenanceWindowExecutionStatus["InProgress"] = "IN_PROGRESS";
    MaintenanceWindowExecutionStatus["Pending"] = "PENDING";
    MaintenanceWindowExecutionStatus["SkippedOverlapping"] = "SKIPPED_OVERLAPPING";
    MaintenanceWindowExecutionStatus["Success"] = "SUCCESS";
    MaintenanceWindowExecutionStatus["TimedOut"] = "TIMED_OUT";
})(MaintenanceWindowExecutionStatus = exports.MaintenanceWindowExecutionStatus || (exports.MaintenanceWindowExecutionStatus = {}));
var MaintenanceWindowExecution;
(function (MaintenanceWindowExecution) {
    MaintenanceWindowExecution.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(MaintenanceWindowExecution = exports.MaintenanceWindowExecution || (exports.MaintenanceWindowExecution = {}));
var DescribeMaintenanceWindowExecutionsResult;
(function (DescribeMaintenanceWindowExecutionsResult) {
    DescribeMaintenanceWindowExecutionsResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeMaintenanceWindowExecutionsResult = exports.DescribeMaintenanceWindowExecutionsResult || (exports.DescribeMaintenanceWindowExecutionsResult = {}));
var DescribeMaintenanceWindowExecutionTaskInvocationsRequest;
(function (DescribeMaintenanceWindowExecutionTaskInvocationsRequest) {
    DescribeMaintenanceWindowExecutionTaskInvocationsRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeMaintenanceWindowExecutionTaskInvocationsRequest = exports.DescribeMaintenanceWindowExecutionTaskInvocationsRequest || (exports.DescribeMaintenanceWindowExecutionTaskInvocationsRequest = {}));
var MaintenanceWindowTaskType;
(function (MaintenanceWindowTaskType) {
    MaintenanceWindowTaskType["Automation"] = "AUTOMATION";
    MaintenanceWindowTaskType["Lambda"] = "LAMBDA";
    MaintenanceWindowTaskType["RunCommand"] = "RUN_COMMAND";
    MaintenanceWindowTaskType["StepFunctions"] = "STEP_FUNCTIONS";
})(MaintenanceWindowTaskType = exports.MaintenanceWindowTaskType || (exports.MaintenanceWindowTaskType = {}));
var MaintenanceWindowExecutionTaskInvocationIdentity;
(function (MaintenanceWindowExecutionTaskInvocationIdentity) {
    MaintenanceWindowExecutionTaskInvocationIdentity.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.Parameters && { Parameters: smithy_client_1.SENSITIVE_STRING }),
        ...(obj.OwnerInformation && { OwnerInformation: smithy_client_1.SENSITIVE_STRING }),
    });
})(MaintenanceWindowExecutionTaskInvocationIdentity = exports.MaintenanceWindowExecutionTaskInvocationIdentity || (exports.MaintenanceWindowExecutionTaskInvocationIdentity = {}));
var DescribeMaintenanceWindowExecutionTaskInvocationsResult;
(function (DescribeMaintenanceWindowExecutionTaskInvocationsResult) {
    DescribeMaintenanceWindowExecutionTaskInvocationsResult.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.WindowExecutionTaskInvocationIdentities && {
            WindowExecutionTaskInvocationIdentities: obj.WindowExecutionTaskInvocationIdentities.map((item) => MaintenanceWindowExecutionTaskInvocationIdentity.filterSensitiveLog(item)),
        }),
    });
})(DescribeMaintenanceWindowExecutionTaskInvocationsResult = exports.DescribeMaintenanceWindowExecutionTaskInvocationsResult || (exports.DescribeMaintenanceWindowExecutionTaskInvocationsResult = {}));
var DescribeMaintenanceWindowExecutionTasksRequest;
(function (DescribeMaintenanceWindowExecutionTasksRequest) {
    DescribeMaintenanceWindowExecutionTasksRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeMaintenanceWindowExecutionTasksRequest = exports.DescribeMaintenanceWindowExecutionTasksRequest || (exports.DescribeMaintenanceWindowExecutionTasksRequest = {}));
var MaintenanceWindowExecutionTaskIdentity;
(function (MaintenanceWindowExecutionTaskIdentity) {
    MaintenanceWindowExecutionTaskIdentity.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(MaintenanceWindowExecutionTaskIdentity = exports.MaintenanceWindowExecutionTaskIdentity || (exports.MaintenanceWindowExecutionTaskIdentity = {}));
var DescribeMaintenanceWindowExecutionTasksResult;
(function (DescribeMaintenanceWindowExecutionTasksResult) {
    DescribeMaintenanceWindowExecutionTasksResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeMaintenanceWindowExecutionTasksResult = exports.DescribeMaintenanceWindowExecutionTasksResult || (exports.DescribeMaintenanceWindowExecutionTasksResult = {}));
var DescribeMaintenanceWindowsRequest;
(function (DescribeMaintenanceWindowsRequest) {
    DescribeMaintenanceWindowsRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeMaintenanceWindowsRequest = exports.DescribeMaintenanceWindowsRequest || (exports.DescribeMaintenanceWindowsRequest = {}));
var MaintenanceWindowIdentity;
(function (MaintenanceWindowIdentity) {
    MaintenanceWindowIdentity.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
    });
})(MaintenanceWindowIdentity = exports.MaintenanceWindowIdentity || (exports.MaintenanceWindowIdentity = {}));
var DescribeMaintenanceWindowsResult;
(function (DescribeMaintenanceWindowsResult) {
    DescribeMaintenanceWindowsResult.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.WindowIdentities && {
            WindowIdentities: obj.WindowIdentities.map((item) => MaintenanceWindowIdentity.filterSensitiveLog(item)),
        }),
    });
})(DescribeMaintenanceWindowsResult = exports.DescribeMaintenanceWindowsResult || (exports.DescribeMaintenanceWindowsResult = {}));
var MaintenanceWindowResourceType;
(function (MaintenanceWindowResourceType) {
    MaintenanceWindowResourceType["Instance"] = "INSTANCE";
    MaintenanceWindowResourceType["ResourceGroup"] = "RESOURCE_GROUP";
})(MaintenanceWindowResourceType = exports.MaintenanceWindowResourceType || (exports.MaintenanceWindowResourceType = {}));
var DescribeMaintenanceWindowScheduleRequest;
(function (DescribeMaintenanceWindowScheduleRequest) {
    DescribeMaintenanceWindowScheduleRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeMaintenanceWindowScheduleRequest = exports.DescribeMaintenanceWindowScheduleRequest || (exports.DescribeMaintenanceWindowScheduleRequest = {}));
var ScheduledWindowExecution;
(function (ScheduledWindowExecution) {
    ScheduledWindowExecution.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ScheduledWindowExecution = exports.ScheduledWindowExecution || (exports.ScheduledWindowExecution = {}));
var DescribeMaintenanceWindowScheduleResult;
(function (DescribeMaintenanceWindowScheduleResult) {
    DescribeMaintenanceWindowScheduleResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeMaintenanceWindowScheduleResult = exports.DescribeMaintenanceWindowScheduleResult || (exports.DescribeMaintenanceWindowScheduleResult = {}));
var DescribeMaintenanceWindowsForTargetRequest;
(function (DescribeMaintenanceWindowsForTargetRequest) {
    DescribeMaintenanceWindowsForTargetRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeMaintenanceWindowsForTargetRequest = exports.DescribeMaintenanceWindowsForTargetRequest || (exports.DescribeMaintenanceWindowsForTargetRequest = {}));
var MaintenanceWindowIdentityForTarget;
(function (MaintenanceWindowIdentityForTarget) {
    MaintenanceWindowIdentityForTarget.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(MaintenanceWindowIdentityForTarget = exports.MaintenanceWindowIdentityForTarget || (exports.MaintenanceWindowIdentityForTarget = {}));
var DescribeMaintenanceWindowsForTargetResult;
(function (DescribeMaintenanceWindowsForTargetResult) {
    DescribeMaintenanceWindowsForTargetResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeMaintenanceWindowsForTargetResult = exports.DescribeMaintenanceWindowsForTargetResult || (exports.DescribeMaintenanceWindowsForTargetResult = {}));
var DescribeMaintenanceWindowTargetsRequest;
(function (DescribeMaintenanceWindowTargetsRequest) {
    DescribeMaintenanceWindowTargetsRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeMaintenanceWindowTargetsRequest = exports.DescribeMaintenanceWindowTargetsRequest || (exports.DescribeMaintenanceWindowTargetsRequest = {}));
var MaintenanceWindowTarget;
(function (MaintenanceWindowTarget) {
    MaintenanceWindowTarget.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.OwnerInformation && { OwnerInformation: smithy_client_1.SENSITIVE_STRING }),
        ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
    });
})(MaintenanceWindowTarget = exports.MaintenanceWindowTarget || (exports.MaintenanceWindowTarget = {}));
var DescribeMaintenanceWindowTargetsResult;
(function (DescribeMaintenanceWindowTargetsResult) {
    DescribeMaintenanceWindowTargetsResult.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.Targets && { Targets: obj.Targets.map((item) => MaintenanceWindowTarget.filterSensitiveLog(item)) }),
    });
})(DescribeMaintenanceWindowTargetsResult = exports.DescribeMaintenanceWindowTargetsResult || (exports.DescribeMaintenanceWindowTargetsResult = {}));
var DescribeMaintenanceWindowTasksRequest;
(function (DescribeMaintenanceWindowTasksRequest) {
    DescribeMaintenanceWindowTasksRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeMaintenanceWindowTasksRequest = exports.DescribeMaintenanceWindowTasksRequest || (exports.DescribeMaintenanceWindowTasksRequest = {}));
var MaintenanceWindowTaskCutoffBehavior;
(function (MaintenanceWindowTaskCutoffBehavior) {
    MaintenanceWindowTaskCutoffBehavior["CancelTask"] = "CANCEL_TASK";
    MaintenanceWindowTaskCutoffBehavior["ContinueTask"] = "CONTINUE_TASK";
})(MaintenanceWindowTaskCutoffBehavior = exports.MaintenanceWindowTaskCutoffBehavior || (exports.MaintenanceWindowTaskCutoffBehavior = {}));
var LoggingInfo;
(function (LoggingInfo) {
    LoggingInfo.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(LoggingInfo = exports.LoggingInfo || (exports.LoggingInfo = {}));
var MaintenanceWindowTaskParameterValueExpression;
(function (MaintenanceWindowTaskParameterValueExpression) {
    MaintenanceWindowTaskParameterValueExpression.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.Values && { Values: smithy_client_1.SENSITIVE_STRING }),
    });
})(MaintenanceWindowTaskParameterValueExpression = exports.MaintenanceWindowTaskParameterValueExpression || (exports.MaintenanceWindowTaskParameterValueExpression = {}));
var MaintenanceWindowTask;
(function (MaintenanceWindowTask) {
    MaintenanceWindowTask.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.TaskParameters && { TaskParameters: smithy_client_1.SENSITIVE_STRING }),
        ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
    });
})(MaintenanceWindowTask = exports.MaintenanceWindowTask || (exports.MaintenanceWindowTask = {}));
var DescribeMaintenanceWindowTasksResult;
(function (DescribeMaintenanceWindowTasksResult) {
    DescribeMaintenanceWindowTasksResult.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.Tasks && { Tasks: obj.Tasks.map((item) => MaintenanceWindowTask.filterSensitiveLog(item)) }),
    });
})(DescribeMaintenanceWindowTasksResult = exports.DescribeMaintenanceWindowTasksResult || (exports.DescribeMaintenanceWindowTasksResult = {}));
var OpsItemFilterKey;
(function (OpsItemFilterKey) {
    OpsItemFilterKey["ACTUAL_END_TIME"] = "ActualEndTime";
    OpsItemFilterKey["ACTUAL_START_TIME"] = "ActualStartTime";
    OpsItemFilterKey["AUTOMATION_ID"] = "AutomationId";
    OpsItemFilterKey["CATEGORY"] = "Category";
    OpsItemFilterKey["CHANGE_REQUEST_APPROVER_ARN"] = "ChangeRequestByApproverArn";
    OpsItemFilterKey["CHANGE_REQUEST_APPROVER_NAME"] = "ChangeRequestByApproverName";
    OpsItemFilterKey["CHANGE_REQUEST_REQUESTER_ARN"] = "ChangeRequestByRequesterArn";
    OpsItemFilterKey["CHANGE_REQUEST_REQUESTER_NAME"] = "ChangeRequestByRequesterName";
    OpsItemFilterKey["CHANGE_REQUEST_TARGETS_RESOURCE_GROUP"] = "ChangeRequestByTargetsResourceGroup";
    OpsItemFilterKey["CHANGE_REQUEST_TEMPLATE"] = "ChangeRequestByTemplate";
    OpsItemFilterKey["CREATED_BY"] = "CreatedBy";
    OpsItemFilterKey["CREATED_TIME"] = "CreatedTime";
    OpsItemFilterKey["INSIGHT_TYPE"] = "InsightByType";
    OpsItemFilterKey["LAST_MODIFIED_TIME"] = "LastModifiedTime";
    OpsItemFilterKey["OPERATIONAL_DATA"] = "OperationalData";
    OpsItemFilterKey["OPERATIONAL_DATA_KEY"] = "OperationalDataKey";
    OpsItemFilterKey["OPERATIONAL_DATA_VALUE"] = "OperationalDataValue";
    OpsItemFilterKey["OPSITEM_ID"] = "OpsItemId";
    OpsItemFilterKey["OPSITEM_TYPE"] = "OpsItemType";
    OpsItemFilterKey["PLANNED_END_TIME"] = "PlannedEndTime";
    OpsItemFilterKey["PLANNED_START_TIME"] = "PlannedStartTime";
    OpsItemFilterKey["PRIORITY"] = "Priority";
    OpsItemFilterKey["RESOURCE_ID"] = "ResourceId";
    OpsItemFilterKey["SEVERITY"] = "Severity";
    OpsItemFilterKey["SOURCE"] = "Source";
    OpsItemFilterKey["STATUS"] = "Status";
    OpsItemFilterKey["TITLE"] = "Title";
})(OpsItemFilterKey = exports.OpsItemFilterKey || (exports.OpsItemFilterKey = {}));
var OpsItemFilterOperator;
(function (OpsItemFilterOperator) {
    OpsItemFilterOperator["CONTAINS"] = "Contains";
    OpsItemFilterOperator["EQUAL"] = "Equal";
    OpsItemFilterOperator["GREATER_THAN"] = "GreaterThan";
    OpsItemFilterOperator["LESS_THAN"] = "LessThan";
})(OpsItemFilterOperator = exports.OpsItemFilterOperator || (exports.OpsItemFilterOperator = {}));
var OpsItemFilter;
(function (OpsItemFilter) {
    OpsItemFilter.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(OpsItemFilter = exports.OpsItemFilter || (exports.OpsItemFilter = {}));
var DescribeOpsItemsRequest;
(function (DescribeOpsItemsRequest) {
    DescribeOpsItemsRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeOpsItemsRequest = exports.DescribeOpsItemsRequest || (exports.DescribeOpsItemsRequest = {}));
var OpsItemStatus;
(function (OpsItemStatus) {
    OpsItemStatus["APPROVED"] = "Approved";
    OpsItemStatus["CANCELLED"] = "Cancelled";
    OpsItemStatus["CANCELLING"] = "Cancelling";
    OpsItemStatus["CHANGE_CALENDAR_OVERRIDE_APPROVED"] = "ChangeCalendarOverrideApproved";
    OpsItemStatus["CHANGE_CALENDAR_OVERRIDE_REJECTED"] = "ChangeCalendarOverrideRejected";
    OpsItemStatus["CLOSED"] = "Closed";
    OpsItemStatus["COMPLETED_WITH_FAILURE"] = "CompletedWithFailure";
    OpsItemStatus["COMPLETED_WITH_SUCCESS"] = "CompletedWithSuccess";
    OpsItemStatus["FAILED"] = "Failed";
    OpsItemStatus["IN_PROGRESS"] = "InProgress";
    OpsItemStatus["OPEN"] = "Open";
    OpsItemStatus["PENDING"] = "Pending";
    OpsItemStatus["PENDING_APPROVAL"] = "PendingApproval";
    OpsItemStatus["PENDING_CHANGE_CALENDAR_OVERRIDE"] = "PendingChangeCalendarOverride";
    OpsItemStatus["REJECTED"] = "Rejected";
    OpsItemStatus["RESOLVED"] = "Resolved";
    OpsItemStatus["RUNBOOK_IN_PROGRESS"] = "RunbookInProgress";
    OpsItemStatus["SCHEDULED"] = "Scheduled";
    OpsItemStatus["TIMED_OUT"] = "TimedOut";
})(OpsItemStatus = exports.OpsItemStatus || (exports.OpsItemStatus = {}));
var OpsItemSummary;
(function (OpsItemSummary) {
    OpsItemSummary.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(OpsItemSummary = exports.OpsItemSummary || (exports.OpsItemSummary = {}));
var DescribeOpsItemsResponse;
(function (DescribeOpsItemsResponse) {
    DescribeOpsItemsResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeOpsItemsResponse = exports.DescribeOpsItemsResponse || (exports.DescribeOpsItemsResponse = {}));
var ParametersFilterKey;
(function (ParametersFilterKey) {
    ParametersFilterKey["KEY_ID"] = "KeyId";
    ParametersFilterKey["NAME"] = "Name";
    ParametersFilterKey["TYPE"] = "Type";
})(ParametersFilterKey = exports.ParametersFilterKey || (exports.ParametersFilterKey = {}));
var ParametersFilter;
(function (ParametersFilter) {
    ParametersFilter.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ParametersFilter = exports.ParametersFilter || (exports.ParametersFilter = {}));
var ParameterStringFilter;
(function (ParameterStringFilter) {
    ParameterStringFilter.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ParameterStringFilter = exports.ParameterStringFilter || (exports.ParameterStringFilter = {}));
var DescribeParametersRequest;
(function (DescribeParametersRequest) {
    DescribeParametersRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(DescribeParametersRequest = exports.DescribeParametersRequest || (exports.DescribeParametersRequest = {}));
var ParameterInlinePolicy;
(function (ParameterInlinePolicy) {
    ParameterInlinePolicy.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(ParameterInlinePolicy = exports.ParameterInlinePolicy || (exports.ParameterInlinePolicy = {}));
