"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetOpsSummaryRequest = exports.GetInventoryRequest = exports.OpsAggregator = exports.InventoryAggregator = exports.UpdateServiceSettingResult = exports.UpdateServiceSettingRequest = exports.UpdateResourceDataSyncResult = exports.UpdateResourceDataSyncRequest = exports.ResourceDataSyncConflictException = exports.UpdatePatchBaselineResult = exports.UpdatePatchBaselineRequest = exports.UpdateOpsMetadataResult = exports.UpdateOpsMetadataRequest = exports.OpsMetadataKeyLimitExceededException = exports.UpdateOpsItemResponse = exports.UpdateOpsItemRequest = exports.UpdateManagedInstanceRoleResult = exports.UpdateManagedInstanceRoleRequest = exports.UpdateMaintenanceWindowTaskResult = exports.UpdateMaintenanceWindowTaskRequest = exports.UpdateMaintenanceWindowTargetResult = exports.UpdateMaintenanceWindowTargetRequest = exports.UpdateMaintenanceWindowResult = exports.UpdateMaintenanceWindowRequest = exports.UpdateDocumentMetadataResponse = exports.UpdateDocumentMetadataRequest = void 0;
const smithy_client_1 = require("@aws-sdk/smithy-client");
const models_0_1 = require("./models_0");
const models_1_1 = require("./models_1");
const SSMServiceException_1 = require("./SSMServiceException");
var UpdateDocumentMetadataRequest;
(function (UpdateDocumentMetadataRequest) {
    UpdateDocumentMetadataRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(UpdateDocumentMetadataRequest = exports.UpdateDocumentMetadataRequest || (exports.UpdateDocumentMetadataRequest = {}));
var UpdateDocumentMetadataResponse;
(function (UpdateDocumentMetadataResponse) {
    UpdateDocumentMetadataResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(UpdateDocumentMetadataResponse = exports.UpdateDocumentMetadataResponse || (exports.UpdateDocumentMetadataResponse = {}));
var UpdateMaintenanceWindowRequest;
(function (UpdateMaintenanceWindowRequest) {
    UpdateMaintenanceWindowRequest.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
    });
})(UpdateMaintenanceWindowRequest = exports.UpdateMaintenanceWindowRequest || (exports.UpdateMaintenanceWindowRequest = {}));
var UpdateMaintenanceWindowResult;
(function (UpdateMaintenanceWindowResult) {
    UpdateMaintenanceWindowResult.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
    });
})(UpdateMaintenanceWindowResult = exports.UpdateMaintenanceWindowResult || (exports.UpdateMaintenanceWindowResult = {}));
var UpdateMaintenanceWindowTargetRequest;
(function (UpdateMaintenanceWindowTargetRequest) {
    UpdateMaintenanceWindowTargetRequest.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.OwnerInformation && { OwnerInformation: smithy_client_1.SENSITIVE_STRING }),
        ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
    });
})(UpdateMaintenanceWindowTargetRequest = exports.UpdateMaintenanceWindowTargetRequest || (exports.UpdateMaintenanceWindowTargetRequest = {}));
var UpdateMaintenanceWindowTargetResult;
(function (UpdateMaintenanceWindowTargetResult) {
    UpdateMaintenanceWindowTargetResult.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.OwnerInformation && { OwnerInformation: smithy_client_1.SENSITIVE_STRING }),
        ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
    });
})(UpdateMaintenanceWindowTargetResult = exports.UpdateMaintenanceWindowTargetResult || (exports.UpdateMaintenanceWindowTargetResult = {}));
var UpdateMaintenanceWindowTaskRequest;
(function (UpdateMaintenanceWindowTaskRequest) {
    UpdateMaintenanceWindowTaskRequest.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.TaskParameters && { TaskParameters: smithy_client_1.SENSITIVE_STRING }),
        ...(obj.TaskInvocationParameters && {
            TaskInvocationParameters: models_1_1.MaintenanceWindowTaskInvocationParameters.filterSensitiveLog(obj.TaskInvocationParameters),
        }),
        ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
    });
})(UpdateMaintenanceWindowTaskRequest = exports.UpdateMaintenanceWindowTaskRequest || (exports.UpdateMaintenanceWindowTaskRequest = {}));
var UpdateMaintenanceWindowTaskResult;
(function (UpdateMaintenanceWindowTaskResult) {
    UpdateMaintenanceWindowTaskResult.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.TaskParameters && { TaskParameters: smithy_client_1.SENSITIVE_STRING }),
        ...(obj.TaskInvocationParameters && {
            TaskInvocationParameters: models_1_1.MaintenanceWindowTaskInvocationParameters.filterSensitiveLog(obj.TaskInvocationParameters),
        }),
        ...(obj.Description && { Description: smithy_client_1.SENSITIVE_STRING }),
    });
})(UpdateMaintenanceWindowTaskResult = exports.UpdateMaintenanceWindowTaskResult || (exports.UpdateMaintenanceWindowTaskResult = {}));
var UpdateManagedInstanceRoleRequest;
(function (UpdateManagedInstanceRoleRequest) {
    UpdateManagedInstanceRoleRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(UpdateManagedInstanceRoleRequest = exports.UpdateManagedInstanceRoleRequest || (exports.UpdateManagedInstanceRoleRequest = {}));
var UpdateManagedInstanceRoleResult;
(function (UpdateManagedInstanceRoleResult) {
    UpdateManagedInstanceRoleResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(UpdateManagedInstanceRoleResult = exports.UpdateManagedInstanceRoleResult || (exports.UpdateManagedInstanceRoleResult = {}));
var UpdateOpsItemRequest;
(function (UpdateOpsItemRequest) {
    UpdateOpsItemRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(UpdateOpsItemRequest = exports.UpdateOpsItemRequest || (exports.UpdateOpsItemRequest = {}));
var UpdateOpsItemResponse;
(function (UpdateOpsItemResponse) {
    UpdateOpsItemResponse.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(UpdateOpsItemResponse = exports.UpdateOpsItemResponse || (exports.UpdateOpsItemResponse = {}));
class OpsMetadataKeyLimitExceededException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "OpsMetadataKeyLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataKeyLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataKeyLimitExceededException.prototype);
    }
}
exports.OpsMetadataKeyLimitExceededException = OpsMetadataKeyLimitExceededException;
var UpdateOpsMetadataRequest;
(function (UpdateOpsMetadataRequest) {
    UpdateOpsMetadataRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(UpdateOpsMetadataRequest = exports.UpdateOpsMetadataRequest || (exports.UpdateOpsMetadataRequest = {}));
var UpdateOpsMetadataResult;
(function (UpdateOpsMetadataResult) {
    UpdateOpsMetadataResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(UpdateOpsMetadataResult = exports.UpdateOpsMetadataResult || (exports.UpdateOpsMetadataResult = {}));
var UpdatePatchBaselineRequest;
(function (UpdatePatchBaselineRequest) {
    UpdatePatchBaselineRequest.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.Sources && { Sources: obj.Sources.map((item) => models_0_1.PatchSource.filterSensitiveLog(item)) }),
    });
})(UpdatePatchBaselineRequest = exports.UpdatePatchBaselineRequest || (exports.UpdatePatchBaselineRequest = {}));
var UpdatePatchBaselineResult;
(function (UpdatePatchBaselineResult) {
    UpdatePatchBaselineResult.filterSensitiveLog = (obj) => ({
        ...obj,
        ...(obj.Sources && { Sources: obj.Sources.map((item) => models_0_1.PatchSource.filterSensitiveLog(item)) }),
    });
})(UpdatePatchBaselineResult = exports.UpdatePatchBaselineResult || (exports.UpdatePatchBaselineResult = {}));
class ResourceDataSyncConflictException extends SSMServiceException_1.SSMServiceException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncConflictException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncConflictException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncConflictException.prototype);
        this.Message = opts.Message;
    }
}
exports.ResourceDataSyncConflictException = ResourceDataSyncConflictException;
var UpdateResourceDataSyncRequest;
(function (UpdateResourceDataSyncRequest) {
    UpdateResourceDataSyncRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(UpdateResourceDataSyncRequest = exports.UpdateResourceDataSyncRequest || (exports.UpdateResourceDataSyncRequest = {}));
var UpdateResourceDataSyncResult;
(function (UpdateResourceDataSyncResult) {
    UpdateResourceDataSyncResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(UpdateResourceDataSyncResult = exports.UpdateResourceDataSyncResult || (exports.UpdateResourceDataSyncResult = {}));
var UpdateServiceSettingRequest;
(function (UpdateServiceSettingRequest) {
    UpdateServiceSettingRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(UpdateServiceSettingRequest = exports.UpdateServiceSettingRequest || (exports.UpdateServiceSettingRequest = {}));
var UpdateServiceSettingResult;
(function (UpdateServiceSettingResult) {
    UpdateServiceSettingResult.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(UpdateServiceSettingResult = exports.UpdateServiceSettingResult || (exports.UpdateServiceSettingResult = {}));
var InventoryAggregator;
(function (InventoryAggregator) {
    InventoryAggregator.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(InventoryAggregator = exports.InventoryAggregator || (exports.InventoryAggregator = {}));
var OpsAggregator;
(function (OpsAggregator) {
    OpsAggregator.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(OpsAggregator = exports.OpsAggregator || (exports.OpsAggregator = {}));
var GetInventoryRequest;
(function (GetInventoryRequest) {
    GetInventoryRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(GetInventoryRequest = exports.GetInventoryRequest || (exports.GetInventoryRequest = {}));
var GetOpsSummaryRequest;
(function (GetOpsSummaryRequest) {
    GetOpsSummaryRequest.filterSensitiveLog = (obj) => ({
        ...obj,
    });
})(GetOpsSummaryRequest = exports.GetOpsSummaryRequest || (exports.GetOpsSummaryRequest = {}));
