import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeInventoryDeletionsRequest, DescribeInventoryDeletionsResult } from "../models/models_0";
import { deserializeAws_json1_1DescribeInventoryDeletionsCommand, serializeAws_json1_1DescribeInventoryDeletionsCommand, } from "../protocols/Aws_json1_1";
var DescribeInventoryDeletionsCommand = (function (_super) {
    __extends(DescribeInventoryDeletionsCommand, _super);
    function DescribeInventoryDeletionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    DescribeInventoryDeletionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "SSMClient";
        var commandName = "DescribeInventoryDeletionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: DescribeInventoryDeletionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: DescribeInventoryDeletionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    DescribeInventoryDeletionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_json1_1DescribeInventoryDeletionsCommand(input, context);
    };
    DescribeInventoryDeletionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_json1_1DescribeInventoryDeletionsCommand(output, context);
    };
    return DescribeInventoryDeletionsCommand;
}($Command));
export { DescribeInventoryDeletionsCommand };
