import { __assign, __extends } from "tslib";
import { SENSITIVE_STRING } from "@aws-sdk/smithy-client";
import { SSMServiceException as __BaseException } from "./SSMServiceException";
export var AccountSharingInfo;
(function (AccountSharingInfo) {
    AccountSharingInfo.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(AccountSharingInfo || (AccountSharingInfo = {}));
export var Tag;
(function (Tag) {
    Tag.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(Tag || (Tag = {}));
export var Activation;
(function (Activation) {
    Activation.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(Activation || (Activation = {}));
export var ResourceTypeForTagging;
(function (ResourceTypeForTagging) {
    ResourceTypeForTagging["AUTOMATION"] = "Automation";
    ResourceTypeForTagging["DOCUMENT"] = "Document";
    ResourceTypeForTagging["MAINTENANCE_WINDOW"] = "MaintenanceWindow";
    ResourceTypeForTagging["MANAGED_INSTANCE"] = "ManagedInstance";
    ResourceTypeForTagging["OPSMETADATA"] = "OpsMetadata";
    ResourceTypeForTagging["OPS_ITEM"] = "OpsItem";
    ResourceTypeForTagging["PARAMETER"] = "Parameter";
    ResourceTypeForTagging["PATCH_BASELINE"] = "PatchBaseline";
})(ResourceTypeForTagging || (ResourceTypeForTagging = {}));
export var AddTagsToResourceRequest;
(function (AddTagsToResourceRequest) {
    AddTagsToResourceRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(AddTagsToResourceRequest || (AddTagsToResourceRequest = {}));
export var AddTagsToResourceResult;
(function (AddTagsToResourceResult) {
    AddTagsToResourceResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(AddTagsToResourceResult || (AddTagsToResourceResult = {}));
var InternalServerError = (function (_super) {
    __extends(InternalServerError, _super);
    function InternalServerError(opts) {
        var _this = _super.call(this, __assign({ name: "InternalServerError", $fault: "server" }, opts)) || this;
        _this.name = "InternalServerError";
        _this.$fault = "server";
        Object.setPrototypeOf(_this, InternalServerError.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InternalServerError;
}(__BaseException));
export { InternalServerError };
var InvalidResourceId = (function (_super) {
    __extends(InvalidResourceId, _super);
    function InvalidResourceId(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidResourceId", $fault: "client" }, opts)) || this;
        _this.name = "InvalidResourceId";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidResourceId.prototype);
        return _this;
    }
    return InvalidResourceId;
}(__BaseException));
export { InvalidResourceId };
var InvalidResourceType = (function (_super) {
    __extends(InvalidResourceType, _super);
    function InvalidResourceType(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidResourceType", $fault: "client" }, opts)) || this;
        _this.name = "InvalidResourceType";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidResourceType.prototype);
        return _this;
    }
    return InvalidResourceType;
}(__BaseException));
export { InvalidResourceType };
var TooManyTagsError = (function (_super) {
    __extends(TooManyTagsError, _super);
    function TooManyTagsError(opts) {
        var _this = _super.call(this, __assign({ name: "TooManyTagsError", $fault: "client" }, opts)) || this;
        _this.name = "TooManyTagsError";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, TooManyTagsError.prototype);
        return _this;
    }
    return TooManyTagsError;
}(__BaseException));
export { TooManyTagsError };
var TooManyUpdates = (function (_super) {
    __extends(TooManyUpdates, _super);
    function TooManyUpdates(opts) {
        var _this = _super.call(this, __assign({ name: "TooManyUpdates", $fault: "client" }, opts)) || this;
        _this.name = "TooManyUpdates";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, TooManyUpdates.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return TooManyUpdates;
}(__BaseException));
export { TooManyUpdates };
var AlreadyExistsException = (function (_super) {
    __extends(AlreadyExistsException, _super);
    function AlreadyExistsException(opts) {
        var _this = _super.call(this, __assign({ name: "AlreadyExistsException", $fault: "client" }, opts)) || this;
        _this.name = "AlreadyExistsException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, AlreadyExistsException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return AlreadyExistsException;
}(__BaseException));
export { AlreadyExistsException };
export var AssociateOpsItemRelatedItemRequest;
(function (AssociateOpsItemRelatedItemRequest) {
    AssociateOpsItemRelatedItemRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(AssociateOpsItemRelatedItemRequest || (AssociateOpsItemRelatedItemRequest = {}));
export var AssociateOpsItemRelatedItemResponse;
(function (AssociateOpsItemRelatedItemResponse) {
    AssociateOpsItemRelatedItemResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(AssociateOpsItemRelatedItemResponse || (AssociateOpsItemRelatedItemResponse = {}));
var OpsItemInvalidParameterException = (function (_super) {
    __extends(OpsItemInvalidParameterException, _super);
    function OpsItemInvalidParameterException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsItemInvalidParameterException", $fault: "client" }, opts)) || this;
        _this.name = "OpsItemInvalidParameterException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsItemInvalidParameterException.prototype);
        _this.ParameterNames = opts.ParameterNames;
        _this.Message = opts.Message;
        return _this;
    }
    return OpsItemInvalidParameterException;
}(__BaseException));
export { OpsItemInvalidParameterException };
var OpsItemLimitExceededException = (function (_super) {
    __extends(OpsItemLimitExceededException, _super);
    function OpsItemLimitExceededException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsItemLimitExceededException", $fault: "client" }, opts)) || this;
        _this.name = "OpsItemLimitExceededException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsItemLimitExceededException.prototype);
        _this.ResourceTypes = opts.ResourceTypes;
        _this.Limit = opts.Limit;
        _this.LimitType = opts.LimitType;
        _this.Message = opts.Message;
        return _this;
    }
    return OpsItemLimitExceededException;
}(__BaseException));
export { OpsItemLimitExceededException };
var OpsItemNotFoundException = (function (_super) {
    __extends(OpsItemNotFoundException, _super);
    function OpsItemNotFoundException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsItemNotFoundException", $fault: "client" }, opts)) || this;
        _this.name = "OpsItemNotFoundException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsItemNotFoundException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return OpsItemNotFoundException;
}(__BaseException));
export { OpsItemNotFoundException };
var OpsItemRelatedItemAlreadyExistsException = (function (_super) {
    __extends(OpsItemRelatedItemAlreadyExistsException, _super);
    function OpsItemRelatedItemAlreadyExistsException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsItemRelatedItemAlreadyExistsException", $fault: "client" }, opts)) || this;
        _this.name = "OpsItemRelatedItemAlreadyExistsException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsItemRelatedItemAlreadyExistsException.prototype);
        _this.Message = opts.Message;
        _this.ResourceUri = opts.ResourceUri;
        _this.OpsItemId = opts.OpsItemId;
        return _this;
    }
    return OpsItemRelatedItemAlreadyExistsException;
}(__BaseException));
export { OpsItemRelatedItemAlreadyExistsException };
export var CancelCommandRequest;
(function (CancelCommandRequest) {
    CancelCommandRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(CancelCommandRequest || (CancelCommandRequest = {}));
export var CancelCommandResult;
(function (CancelCommandResult) {
    CancelCommandResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(CancelCommandResult || (CancelCommandResult = {}));
var DuplicateInstanceId = (function (_super) {
    __extends(DuplicateInstanceId, _super);
    function DuplicateInstanceId(opts) {
        var _this = _super.call(this, __assign({ name: "DuplicateInstanceId", $fault: "client" }, opts)) || this;
        _this.name = "DuplicateInstanceId";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, DuplicateInstanceId.prototype);
        return _this;
    }
    return DuplicateInstanceId;
}(__BaseException));
export { DuplicateInstanceId };
var InvalidCommandId = (function (_super) {
    __extends(InvalidCommandId, _super);
    function InvalidCommandId(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidCommandId", $fault: "client" }, opts)) || this;
        _this.name = "InvalidCommandId";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidCommandId.prototype);
        return _this;
    }
    return InvalidCommandId;
}(__BaseException));
export { InvalidCommandId };
var InvalidInstanceId = (function (_super) {
    __extends(InvalidInstanceId, _super);
    function InvalidInstanceId(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidInstanceId", $fault: "client" }, opts)) || this;
        _this.name = "InvalidInstanceId";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidInstanceId.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidInstanceId;
}(__BaseException));
export { InvalidInstanceId };
export var CancelMaintenanceWindowExecutionRequest;
(function (CancelMaintenanceWindowExecutionRequest) {
    CancelMaintenanceWindowExecutionRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(CancelMaintenanceWindowExecutionRequest || (CancelMaintenanceWindowExecutionRequest = {}));
export var CancelMaintenanceWindowExecutionResult;
(function (CancelMaintenanceWindowExecutionResult) {
    CancelMaintenanceWindowExecutionResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(CancelMaintenanceWindowExecutionResult || (CancelMaintenanceWindowExecutionResult = {}));
var DoesNotExistException = (function (_super) {
    __extends(DoesNotExistException, _super);
    function DoesNotExistException(opts) {
        var _this = _super.call(this, __assign({ name: "DoesNotExistException", $fault: "client" }, opts)) || this;
        _this.name = "DoesNotExistException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, DoesNotExistException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return DoesNotExistException;
}(__BaseException));
export { DoesNotExistException };
export var RegistrationMetadataItem;
(function (RegistrationMetadataItem) {
    RegistrationMetadataItem.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(RegistrationMetadataItem || (RegistrationMetadataItem = {}));
export var CreateActivationRequest;
(function (CreateActivationRequest) {
    CreateActivationRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(CreateActivationRequest || (CreateActivationRequest = {}));
export var CreateActivationResult;
(function (CreateActivationResult) {
    CreateActivationResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(CreateActivationResult || (CreateActivationResult = {}));
var InvalidParameters = (function (_super) {
    __extends(InvalidParameters, _super);
    function InvalidParameters(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidParameters", $fault: "client" }, opts)) || this;
        _this.name = "InvalidParameters";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidParameters.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidParameters;
}(__BaseException));
export { InvalidParameters };
var AssociationAlreadyExists = (function (_super) {
    __extends(AssociationAlreadyExists, _super);
    function AssociationAlreadyExists(opts) {
        var _this = _super.call(this, __assign({ name: "AssociationAlreadyExists", $fault: "client" }, opts)) || this;
        _this.name = "AssociationAlreadyExists";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, AssociationAlreadyExists.prototype);
        return _this;
    }
    return AssociationAlreadyExists;
}(__BaseException));
export { AssociationAlreadyExists };
var AssociationLimitExceeded = (function (_super) {
    __extends(AssociationLimitExceeded, _super);
    function AssociationLimitExceeded(opts) {
        var _this = _super.call(this, __assign({ name: "AssociationLimitExceeded", $fault: "client" }, opts)) || this;
        _this.name = "AssociationLimitExceeded";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, AssociationLimitExceeded.prototype);
        return _this;
    }
    return AssociationLimitExceeded;
}(__BaseException));
export { AssociationLimitExceeded };
export var AssociationComplianceSeverity;
(function (AssociationComplianceSeverity) {
    AssociationComplianceSeverity["Critical"] = "CRITICAL";
    AssociationComplianceSeverity["High"] = "HIGH";
    AssociationComplianceSeverity["Low"] = "LOW";
    AssociationComplianceSeverity["Medium"] = "MEDIUM";
    AssociationComplianceSeverity["Unspecified"] = "UNSPECIFIED";
})(AssociationComplianceSeverity || (AssociationComplianceSeverity = {}));
export var S3OutputLocation;
(function (S3OutputLocation) {
    S3OutputLocation.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(S3OutputLocation || (S3OutputLocation = {}));
export var InstanceAssociationOutputLocation;
(function (InstanceAssociationOutputLocation) {
    InstanceAssociationOutputLocation.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(InstanceAssociationOutputLocation || (InstanceAssociationOutputLocation = {}));
export var AssociationSyncCompliance;
(function (AssociationSyncCompliance) {
    AssociationSyncCompliance["Auto"] = "AUTO";
    AssociationSyncCompliance["Manual"] = "MANUAL";
})(AssociationSyncCompliance || (AssociationSyncCompliance = {}));
export var TargetLocation;
(function (TargetLocation) {
    TargetLocation.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(TargetLocation || (TargetLocation = {}));
export var Target;
(function (Target) {
    Target.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(Target || (Target = {}));
export var CreateAssociationRequest;
(function (CreateAssociationRequest) {
    CreateAssociationRequest.filterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Parameters && { Parameters: SENSITIVE_STRING }))); };
})(CreateAssociationRequest || (CreateAssociationRequest = {}));
export var AssociationOverview;
(function (AssociationOverview) {
    AssociationOverview.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(AssociationOverview || (AssociationOverview = {}));
export var AssociationStatusName;
(function (AssociationStatusName) {
    AssociationStatusName["Failed"] = "Failed";
    AssociationStatusName["Pending"] = "Pending";
    AssociationStatusName["Success"] = "Success";
})(AssociationStatusName || (AssociationStatusName = {}));
export var AssociationStatus;
(function (AssociationStatus) {
    AssociationStatus.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(AssociationStatus || (AssociationStatus = {}));
export var AssociationDescription;
(function (AssociationDescription) {
    AssociationDescription.filterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Parameters && { Parameters: SENSITIVE_STRING }))); };
})(AssociationDescription || (AssociationDescription = {}));
export var CreateAssociationResult;
(function (CreateAssociationResult) {
    CreateAssociationResult.filterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.AssociationDescription && {
        AssociationDescription: AssociationDescription.filterSensitiveLog(obj.AssociationDescription),
    }))); };
})(CreateAssociationResult || (CreateAssociationResult = {}));
var InvalidDocument = (function (_super) {
    __extends(InvalidDocument, _super);
    function InvalidDocument(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidDocument", $fault: "client" }, opts)) || this;
        _this.name = "InvalidDocument";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidDocument.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidDocument;
}(__BaseException));
export { InvalidDocument };
var InvalidDocumentVersion = (function (_super) {
    __extends(InvalidDocumentVersion, _super);
    function InvalidDocumentVersion(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidDocumentVersion", $fault: "client" }, opts)) || this;
        _this.name = "InvalidDocumentVersion";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidDocumentVersion.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidDocumentVersion;
}(__BaseException));
export { InvalidDocumentVersion };
var InvalidOutputLocation = (function (_super) {
    __extends(InvalidOutputLocation, _super);
    function InvalidOutputLocation(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidOutputLocation", $fault: "client" }, opts)) || this;
        _this.name = "InvalidOutputLocation";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidOutputLocation.prototype);
        return _this;
    }
    return InvalidOutputLocation;
}(__BaseException));
export { InvalidOutputLocation };
var InvalidSchedule = (function (_super) {
    __extends(InvalidSchedule, _super);
    function InvalidSchedule(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidSchedule", $fault: "client" }, opts)) || this;
        _this.name = "InvalidSchedule";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidSchedule.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidSchedule;
}(__BaseException));
export { InvalidSchedule };
var InvalidTarget = (function (_super) {
    __extends(InvalidTarget, _super);
    function InvalidTarget(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidTarget", $fault: "client" }, opts)) || this;
        _this.name = "InvalidTarget";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidTarget.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidTarget;
}(__BaseException));
export { InvalidTarget };
var InvalidTargetMaps = (function (_super) {
    __extends(InvalidTargetMaps, _super);
    function InvalidTargetMaps(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidTargetMaps", $fault: "client" }, opts)) || this;
        _this.name = "InvalidTargetMaps";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidTargetMaps.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidTargetMaps;
}(__BaseException));
export { InvalidTargetMaps };
var UnsupportedPlatformType = (function (_super) {
    __extends(UnsupportedPlatformType, _super);
    function UnsupportedPlatformType(opts) {
        var _this = _super.call(this, __assign({ name: "UnsupportedPlatformType", $fault: "client" }, opts)) || this;
        _this.name = "UnsupportedPlatformType";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, UnsupportedPlatformType.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return UnsupportedPlatformType;
}(__BaseException));
export { UnsupportedPlatformType };
export var CreateAssociationBatchRequestEntry;
(function (CreateAssociationBatchRequestEntry) {
    CreateAssociationBatchRequestEntry.filterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Parameters && { Parameters: SENSITIVE_STRING }))); };
})(CreateAssociationBatchRequestEntry || (CreateAssociationBatchRequestEntry = {}));
export var CreateAssociationBatchRequest;
(function (CreateAssociationBatchRequest) {
    CreateAssociationBatchRequest.filterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Entries && {
        Entries: obj.Entries.map(function (item) { return CreateAssociationBatchRequestEntry.filterSensitiveLog(item); }),
    }))); };
})(CreateAssociationBatchRequest || (CreateAssociationBatchRequest = {}));
export var FailedCreateAssociation;
(function (FailedCreateAssociation) {
    FailedCreateAssociation.filterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Entry && { Entry: CreateAssociationBatchRequestEntry.filterSensitiveLog(obj.Entry) }))); };
})(FailedCreateAssociation || (FailedCreateAssociation = {}));
export var CreateAssociationBatchResult;
(function (CreateAssociationBatchResult) {
    CreateAssociationBatchResult.filterSensitiveLog = function (obj) { return (__assign(__assign(__assign({}, obj), (obj.Successful && {
        Successful: obj.Successful.map(function (item) { return AssociationDescription.filterSensitiveLog(item); }),
    })), (obj.Failed && { Failed: obj.Failed.map(function (item) { return FailedCreateAssociation.filterSensitiveLog(item); }) }))); };
})(CreateAssociationBatchResult || (CreateAssociationBatchResult = {}));
export var AttachmentsSourceKey;
(function (AttachmentsSourceKey) {
    AttachmentsSourceKey["AttachmentReference"] = "AttachmentReference";
    AttachmentsSourceKey["S3FileUrl"] = "S3FileUrl";
    AttachmentsSourceKey["SourceUrl"] = "SourceUrl";
})(AttachmentsSourceKey || (AttachmentsSourceKey = {}));
export var AttachmentsSource;
(function (AttachmentsSource) {
    AttachmentsSource.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(AttachmentsSource || (AttachmentsSource = {}));
export var DocumentFormat;
(function (DocumentFormat) {
    DocumentFormat["JSON"] = "JSON";
    DocumentFormat["TEXT"] = "TEXT";
    DocumentFormat["YAML"] = "YAML";
})(DocumentFormat || (DocumentFormat = {}));
export var DocumentType;
(function (DocumentType) {
    DocumentType["ApplicationConfiguration"] = "ApplicationConfiguration";
    DocumentType["ApplicationConfigurationSchema"] = "ApplicationConfigurationSchema";
    DocumentType["Automation"] = "Automation";
    DocumentType["ChangeCalendar"] = "ChangeCalendar";
    DocumentType["ChangeTemplate"] = "Automation.ChangeTemplate";
    DocumentType["Command"] = "Command";
    DocumentType["DeploymentStrategy"] = "DeploymentStrategy";
    DocumentType["Package"] = "Package";
    DocumentType["Policy"] = "Policy";
    DocumentType["ProblemAnalysis"] = "ProblemAnalysis";
    DocumentType["ProblemAnalysisTemplate"] = "ProblemAnalysisTemplate";
    DocumentType["Session"] = "Session";
})(DocumentType || (DocumentType = {}));
export var DocumentRequires;
(function (DocumentRequires) {
    DocumentRequires.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DocumentRequires || (DocumentRequires = {}));
export var CreateDocumentRequest;
(function (CreateDocumentRequest) {
    CreateDocumentRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(CreateDocumentRequest || (CreateDocumentRequest = {}));
export var AttachmentInformation;
(function (AttachmentInformation) {
    AttachmentInformation.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(AttachmentInformation || (AttachmentInformation = {}));
export var DocumentHashType;
(function (DocumentHashType) {
    DocumentHashType["SHA1"] = "Sha1";
    DocumentHashType["SHA256"] = "Sha256";
})(DocumentHashType || (DocumentHashType = {}));
export var DocumentParameter;
(function (DocumentParameter) {
    DocumentParameter.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DocumentParameter || (DocumentParameter = {}));
export var PlatformType;
(function (PlatformType) {
    PlatformType["LINUX"] = "Linux";
    PlatformType["MACOS"] = "MacOS";
    PlatformType["WINDOWS"] = "Windows";
})(PlatformType || (PlatformType = {}));
export var ReviewStatus;
(function (ReviewStatus) {
    ReviewStatus["APPROVED"] = "APPROVED";
    ReviewStatus["NOT_REVIEWED"] = "NOT_REVIEWED";
    ReviewStatus["PENDING"] = "PENDING";
    ReviewStatus["REJECTED"] = "REJECTED";
})(ReviewStatus || (ReviewStatus = {}));
export var ReviewInformation;
(function (ReviewInformation) {
    ReviewInformation.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ReviewInformation || (ReviewInformation = {}));
export var DocumentStatus;
(function (DocumentStatus) {
    DocumentStatus["Active"] = "Active";
    DocumentStatus["Creating"] = "Creating";
    DocumentStatus["Deleting"] = "Deleting";
    DocumentStatus["Failed"] = "Failed";
    DocumentStatus["Updating"] = "Updating";
})(DocumentStatus || (DocumentStatus = {}));
export var DocumentDescription;
(function (DocumentDescription) {
    DocumentDescription.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DocumentDescription || (DocumentDescription = {}));
export var CreateDocumentResult;
(function (CreateDocumentResult) {
    CreateDocumentResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(CreateDocumentResult || (CreateDocumentResult = {}));
var DocumentAlreadyExists = (function (_super) {
    __extends(DocumentAlreadyExists, _super);
    function DocumentAlreadyExists(opts) {
        var _this = _super.call(this, __assign({ name: "DocumentAlreadyExists", $fault: "client" }, opts)) || this;
        _this.name = "DocumentAlreadyExists";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, DocumentAlreadyExists.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return DocumentAlreadyExists;
}(__BaseException));
export { DocumentAlreadyExists };
var DocumentLimitExceeded = (function (_super) {
    __extends(DocumentLimitExceeded, _super);
    function DocumentLimitExceeded(opts) {
        var _this = _super.call(this, __assign({ name: "DocumentLimitExceeded", $fault: "client" }, opts)) || this;
        _this.name = "DocumentLimitExceeded";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, DocumentLimitExceeded.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return DocumentLimitExceeded;
}(__BaseException));
export { DocumentLimitExceeded };
var InvalidDocumentContent = (function (_super) {
    __extends(InvalidDocumentContent, _super);
    function InvalidDocumentContent(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidDocumentContent", $fault: "client" }, opts)) || this;
        _this.name = "InvalidDocumentContent";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidDocumentContent.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidDocumentContent;
}(__BaseException));
export { InvalidDocumentContent };
var InvalidDocumentSchemaVersion = (function (_super) {
    __extends(InvalidDocumentSchemaVersion, _super);
    function InvalidDocumentSchemaVersion(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidDocumentSchemaVersion", $fault: "client" }, opts)) || this;
        _this.name = "InvalidDocumentSchemaVersion";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidDocumentSchemaVersion.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidDocumentSchemaVersion;
}(__BaseException));
export { InvalidDocumentSchemaVersion };
var MaxDocumentSizeExceeded = (function (_super) {
    __extends(MaxDocumentSizeExceeded, _super);
    function MaxDocumentSizeExceeded(opts) {
        var _this = _super.call(this, __assign({ name: "MaxDocumentSizeExceeded", $fault: "client" }, opts)) || this;
        _this.name = "MaxDocumentSizeExceeded";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, MaxDocumentSizeExceeded.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return MaxDocumentSizeExceeded;
}(__BaseException));
export { MaxDocumentSizeExceeded };
export var CreateMaintenanceWindowRequest;
(function (CreateMaintenanceWindowRequest) {
    CreateMaintenanceWindowRequest.filterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Description && { Description: SENSITIVE_STRING }))); };
})(CreateMaintenanceWindowRequest || (CreateMaintenanceWindowRequest = {}));
export var CreateMaintenanceWindowResult;
(function (CreateMaintenanceWindowResult) {
    CreateMaintenanceWindowResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(CreateMaintenanceWindowResult || (CreateMaintenanceWindowResult = {}));
var IdempotentParameterMismatch = (function (_super) {
    __extends(IdempotentParameterMismatch, _super);
    function IdempotentParameterMismatch(opts) {
        var _this = _super.call(this, __assign({ name: "IdempotentParameterMismatch", $fault: "client" }, opts)) || this;
        _this.name = "IdempotentParameterMismatch";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, IdempotentParameterMismatch.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return IdempotentParameterMismatch;
}(__BaseException));
export { IdempotentParameterMismatch };
var ResourceLimitExceededException = (function (_super) {
    __extends(ResourceLimitExceededException, _super);
    function ResourceLimitExceededException(opts) {
        var _this = _super.call(this, __assign({ name: "ResourceLimitExceededException", $fault: "client" }, opts)) || this;
        _this.name = "ResourceLimitExceededException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ResourceLimitExceededException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return ResourceLimitExceededException;
}(__BaseException));
export { ResourceLimitExceededException };
export var OpsItemNotification;
(function (OpsItemNotification) {
    OpsItemNotification.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(OpsItemNotification || (OpsItemNotification = {}));
export var OpsItemDataType;
(function (OpsItemDataType) {
    OpsItemDataType["SEARCHABLE_STRING"] = "SearchableString";
    OpsItemDataType["STRING"] = "String";
})(OpsItemDataType || (OpsItemDataType = {}));
export var OpsItemDataValue;
(function (OpsItemDataValue) {
    OpsItemDataValue.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(OpsItemDataValue || (OpsItemDataValue = {}));
export var RelatedOpsItem;
(function (RelatedOpsItem) {
    RelatedOpsItem.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(RelatedOpsItem || (RelatedOpsItem = {}));
export var CreateOpsItemRequest;
(function (CreateOpsItemRequest) {
    CreateOpsItemRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(CreateOpsItemRequest || (CreateOpsItemRequest = {}));
export var CreateOpsItemResponse;
(function (CreateOpsItemResponse) {
    CreateOpsItemResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(CreateOpsItemResponse || (CreateOpsItemResponse = {}));
var OpsItemAlreadyExistsException = (function (_super) {
    __extends(OpsItemAlreadyExistsException, _super);
    function OpsItemAlreadyExistsException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsItemAlreadyExistsException", $fault: "client" }, opts)) || this;
        _this.name = "OpsItemAlreadyExistsException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsItemAlreadyExistsException.prototype);
        _this.Message = opts.Message;
        _this.OpsItemId = opts.OpsItemId;
        return _this;
    }
    return OpsItemAlreadyExistsException;
}(__BaseException));
export { OpsItemAlreadyExistsException };
export var MetadataValue;
(function (MetadataValue) {
    MetadataValue.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(MetadataValue || (MetadataValue = {}));
export var CreateOpsMetadataRequest;
(function (CreateOpsMetadataRequest) {
    CreateOpsMetadataRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(CreateOpsMetadataRequest || (CreateOpsMetadataRequest = {}));
export var CreateOpsMetadataResult;
(function (CreateOpsMetadataResult) {
    CreateOpsMetadataResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(CreateOpsMetadataResult || (CreateOpsMetadataResult = {}));
var OpsMetadataAlreadyExistsException = (function (_super) {
    __extends(OpsMetadataAlreadyExistsException, _super);
    function OpsMetadataAlreadyExistsException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsMetadataAlreadyExistsException", $fault: "client" }, opts)) || this;
        _this.name = "OpsMetadataAlreadyExistsException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsMetadataAlreadyExistsException.prototype);
        return _this;
    }
    return OpsMetadataAlreadyExistsException;
}(__BaseException));
export { OpsMetadataAlreadyExistsException };
var OpsMetadataInvalidArgumentException = (function (_super) {
    __extends(OpsMetadataInvalidArgumentException, _super);
    function OpsMetadataInvalidArgumentException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsMetadataInvalidArgumentException", $fault: "client" }, opts)) || this;
        _this.name = "OpsMetadataInvalidArgumentException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsMetadataInvalidArgumentException.prototype);
        return _this;
    }
    return OpsMetadataInvalidArgumentException;
}(__BaseException));
export { OpsMetadataInvalidArgumentException };
var OpsMetadataLimitExceededException = (function (_super) {
    __extends(OpsMetadataLimitExceededException, _super);
    function OpsMetadataLimitExceededException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsMetadataLimitExceededException", $fault: "client" }, opts)) || this;
        _this.name = "OpsMetadataLimitExceededException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsMetadataLimitExceededException.prototype);
        return _this;
    }
    return OpsMetadataLimitExceededException;
}(__BaseException));
export { OpsMetadataLimitExceededException };
var OpsMetadataTooManyUpdatesException = (function (_super) {
    __extends(OpsMetadataTooManyUpdatesException, _super);
    function OpsMetadataTooManyUpdatesException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsMetadataTooManyUpdatesException", $fault: "client" }, opts)) || this;
        _this.name = "OpsMetadataTooManyUpdatesException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsMetadataTooManyUpdatesException.prototype);
        return _this;
    }
    return OpsMetadataTooManyUpdatesException;
}(__BaseException));
export { OpsMetadataTooManyUpdatesException };
export var PatchComplianceLevel;
(function (PatchComplianceLevel) {
    PatchComplianceLevel["Critical"] = "CRITICAL";
    PatchComplianceLevel["High"] = "HIGH";
    PatchComplianceLevel["Informational"] = "INFORMATIONAL";
    PatchComplianceLevel["Low"] = "LOW";
    PatchComplianceLevel["Medium"] = "MEDIUM";
    PatchComplianceLevel["Unspecified"] = "UNSPECIFIED";
})(PatchComplianceLevel || (PatchComplianceLevel = {}));
export var PatchFilterKey;
(function (PatchFilterKey) {
    PatchFilterKey["AdvisoryId"] = "ADVISORY_ID";
    PatchFilterKey["Arch"] = "ARCH";
    PatchFilterKey["BugzillaId"] = "BUGZILLA_ID";
    PatchFilterKey["CVEId"] = "CVE_ID";
    PatchFilterKey["Classification"] = "CLASSIFICATION";
    PatchFilterKey["Epoch"] = "EPOCH";
    PatchFilterKey["MsrcSeverity"] = "MSRC_SEVERITY";
    PatchFilterKey["Name"] = "NAME";
    PatchFilterKey["PatchId"] = "PATCH_ID";
    PatchFilterKey["PatchSet"] = "PATCH_SET";
    PatchFilterKey["Priority"] = "PRIORITY";
    PatchFilterKey["Product"] = "PRODUCT";
    PatchFilterKey["ProductFamily"] = "PRODUCT_FAMILY";
    PatchFilterKey["Release"] = "RELEASE";
    PatchFilterKey["Repository"] = "REPOSITORY";
    PatchFilterKey["Section"] = "SECTION";
    PatchFilterKey["Security"] = "SECURITY";
    PatchFilterKey["Severity"] = "SEVERITY";
    PatchFilterKey["Version"] = "VERSION";
})(PatchFilterKey || (PatchFilterKey = {}));
export var PatchFilter;
(function (PatchFilter) {
    PatchFilter.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(PatchFilter || (PatchFilter = {}));
export var PatchFilterGroup;
(function (PatchFilterGroup) {
    PatchFilterGroup.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(PatchFilterGroup || (PatchFilterGroup = {}));
export var PatchRule;
(function (PatchRule) {
    PatchRule.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(PatchRule || (PatchRule = {}));
export var PatchRuleGroup;
(function (PatchRuleGroup) {
    PatchRuleGroup.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(PatchRuleGroup || (PatchRuleGroup = {}));
export var OperatingSystem;
(function (OperatingSystem) {
    OperatingSystem["AmazonLinux"] = "AMAZON_LINUX";
    OperatingSystem["AmazonLinux2"] = "AMAZON_LINUX_2";
    OperatingSystem["CentOS"] = "CENTOS";
    OperatingSystem["Debian"] = "DEBIAN";
    OperatingSystem["MacOS"] = "MACOS";
    OperatingSystem["OracleLinux"] = "ORACLE_LINUX";
    OperatingSystem["Raspbian"] = "RASPBIAN";
    OperatingSystem["RedhatEnterpriseLinux"] = "REDHAT_ENTERPRISE_LINUX";
    OperatingSystem["Rocky_Linux"] = "ROCKY_LINUX";
    OperatingSystem["Suse"] = "SUSE";
    OperatingSystem["Ubuntu"] = "UBUNTU";
    OperatingSystem["Windows"] = "WINDOWS";
})(OperatingSystem || (OperatingSystem = {}));
export var PatchAction;
(function (PatchAction) {
    PatchAction["AllowAsDependency"] = "ALLOW_AS_DEPENDENCY";
    PatchAction["Block"] = "BLOCK";
})(PatchAction || (PatchAction = {}));
export var PatchSource;
(function (PatchSource) {
    PatchSource.filterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Configuration && { Configuration: SENSITIVE_STRING }))); };
})(PatchSource || (PatchSource = {}));
export var CreatePatchBaselineRequest;
(function (CreatePatchBaselineRequest) {
    CreatePatchBaselineRequest.filterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Sources && { Sources: obj.Sources.map(function (item) { return PatchSource.filterSensitiveLog(item); }) }))); };
})(CreatePatchBaselineRequest || (CreatePatchBaselineRequest = {}));
export var CreatePatchBaselineResult;
(function (CreatePatchBaselineResult) {
    CreatePatchBaselineResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(CreatePatchBaselineResult || (CreatePatchBaselineResult = {}));
export var ResourceDataSyncDestinationDataSharing;
(function (ResourceDataSyncDestinationDataSharing) {
    ResourceDataSyncDestinationDataSharing.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ResourceDataSyncDestinationDataSharing || (ResourceDataSyncDestinationDataSharing = {}));
export var ResourceDataSyncS3Format;
(function (ResourceDataSyncS3Format) {
    ResourceDataSyncS3Format["JSON_SERDE"] = "JsonSerDe";
})(ResourceDataSyncS3Format || (ResourceDataSyncS3Format = {}));
export var ResourceDataSyncS3Destination;
(function (ResourceDataSyncS3Destination) {
    ResourceDataSyncS3Destination.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ResourceDataSyncS3Destination || (ResourceDataSyncS3Destination = {}));
export var ResourceDataSyncOrganizationalUnit;
(function (ResourceDataSyncOrganizationalUnit) {
    ResourceDataSyncOrganizationalUnit.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ResourceDataSyncOrganizationalUnit || (ResourceDataSyncOrganizationalUnit = {}));
export var ResourceDataSyncAwsOrganizationsSource;
(function (ResourceDataSyncAwsOrganizationsSource) {
    ResourceDataSyncAwsOrganizationsSource.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ResourceDataSyncAwsOrganizationsSource || (ResourceDataSyncAwsOrganizationsSource = {}));
export var ResourceDataSyncSource;
(function (ResourceDataSyncSource) {
    ResourceDataSyncSource.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ResourceDataSyncSource || (ResourceDataSyncSource = {}));
export var CreateResourceDataSyncRequest;
(function (CreateResourceDataSyncRequest) {
    CreateResourceDataSyncRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(CreateResourceDataSyncRequest || (CreateResourceDataSyncRequest = {}));
export var CreateResourceDataSyncResult;
(function (CreateResourceDataSyncResult) {
    CreateResourceDataSyncResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(CreateResourceDataSyncResult || (CreateResourceDataSyncResult = {}));
var ResourceDataSyncAlreadyExistsException = (function (_super) {
    __extends(ResourceDataSyncAlreadyExistsException, _super);
    function ResourceDataSyncAlreadyExistsException(opts) {
        var _this = _super.call(this, __assign({ name: "ResourceDataSyncAlreadyExistsException", $fault: "client" }, opts)) || this;
        _this.name = "ResourceDataSyncAlreadyExistsException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ResourceDataSyncAlreadyExistsException.prototype);
        _this.SyncName = opts.SyncName;
        return _this;
    }
    return ResourceDataSyncAlreadyExistsException;
}(__BaseException));
export { ResourceDataSyncAlreadyExistsException };
var ResourceDataSyncCountExceededException = (function (_super) {
    __extends(ResourceDataSyncCountExceededException, _super);
    function ResourceDataSyncCountExceededException(opts) {
        var _this = _super.call(this, __assign({ name: "ResourceDataSyncCountExceededException", $fault: "client" }, opts)) || this;
        _this.name = "ResourceDataSyncCountExceededException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ResourceDataSyncCountExceededException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return ResourceDataSyncCountExceededException;
}(__BaseException));
export { ResourceDataSyncCountExceededException };
var ResourceDataSyncInvalidConfigurationException = (function (_super) {
    __extends(ResourceDataSyncInvalidConfigurationException, _super);
    function ResourceDataSyncInvalidConfigurationException(opts) {
        var _this = _super.call(this, __assign({ name: "ResourceDataSyncInvalidConfigurationException", $fault: "client" }, opts)) || this;
        _this.name = "ResourceDataSyncInvalidConfigurationException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ResourceDataSyncInvalidConfigurationException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return ResourceDataSyncInvalidConfigurationException;
}(__BaseException));
export { ResourceDataSyncInvalidConfigurationException };
export var DeleteActivationRequest;
(function (DeleteActivationRequest) {
    DeleteActivationRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteActivationRequest || (DeleteActivationRequest = {}));
export var DeleteActivationResult;
(function (DeleteActivationResult) {
    DeleteActivationResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteActivationResult || (DeleteActivationResult = {}));
var InvalidActivation = (function (_super) {
    __extends(InvalidActivation, _super);
    function InvalidActivation(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidActivation", $fault: "client" }, opts)) || this;
        _this.name = "InvalidActivation";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidActivation.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidActivation;
}(__BaseException));
export { InvalidActivation };
var InvalidActivationId = (function (_super) {
    __extends(InvalidActivationId, _super);
    function InvalidActivationId(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidActivationId", $fault: "client" }, opts)) || this;
        _this.name = "InvalidActivationId";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidActivationId.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidActivationId;
}(__BaseException));
export { InvalidActivationId };
var AssociationDoesNotExist = (function (_super) {
    __extends(AssociationDoesNotExist, _super);
    function AssociationDoesNotExist(opts) {
        var _this = _super.call(this, __assign({ name: "AssociationDoesNotExist", $fault: "client" }, opts)) || this;
        _this.name = "AssociationDoesNotExist";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, AssociationDoesNotExist.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return AssociationDoesNotExist;
}(__BaseException));
export { AssociationDoesNotExist };
export var DeleteAssociationRequest;
(function (DeleteAssociationRequest) {
    DeleteAssociationRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteAssociationRequest || (DeleteAssociationRequest = {}));
export var DeleteAssociationResult;
(function (DeleteAssociationResult) {
    DeleteAssociationResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteAssociationResult || (DeleteAssociationResult = {}));
var AssociatedInstances = (function (_super) {
    __extends(AssociatedInstances, _super);
    function AssociatedInstances(opts) {
        var _this = _super.call(this, __assign({ name: "AssociatedInstances", $fault: "client" }, opts)) || this;
        _this.name = "AssociatedInstances";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, AssociatedInstances.prototype);
        return _this;
    }
    return AssociatedInstances;
}(__BaseException));
export { AssociatedInstances };
export var DeleteDocumentRequest;
(function (DeleteDocumentRequest) {
    DeleteDocumentRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteDocumentRequest || (DeleteDocumentRequest = {}));
export var DeleteDocumentResult;
(function (DeleteDocumentResult) {
    DeleteDocumentResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteDocumentResult || (DeleteDocumentResult = {}));
var InvalidDocumentOperation = (function (_super) {
    __extends(InvalidDocumentOperation, _super);
    function InvalidDocumentOperation(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidDocumentOperation", $fault: "client" }, opts)) || this;
        _this.name = "InvalidDocumentOperation";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidDocumentOperation.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidDocumentOperation;
}(__BaseException));
export { InvalidDocumentOperation };
export var InventorySchemaDeleteOption;
(function (InventorySchemaDeleteOption) {
    InventorySchemaDeleteOption["DELETE_SCHEMA"] = "DeleteSchema";
    InventorySchemaDeleteOption["DISABLE_SCHEMA"] = "DisableSchema";
})(InventorySchemaDeleteOption || (InventorySchemaDeleteOption = {}));
export var DeleteInventoryRequest;
(function (DeleteInventoryRequest) {
    DeleteInventoryRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteInventoryRequest || (DeleteInventoryRequest = {}));
export var InventoryDeletionSummaryItem;
(function (InventoryDeletionSummaryItem) {
    InventoryDeletionSummaryItem.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(InventoryDeletionSummaryItem || (InventoryDeletionSummaryItem = {}));
export var InventoryDeletionSummary;
(function (InventoryDeletionSummary) {
    InventoryDeletionSummary.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(InventoryDeletionSummary || (InventoryDeletionSummary = {}));
export var DeleteInventoryResult;
(function (DeleteInventoryResult) {
    DeleteInventoryResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteInventoryResult || (DeleteInventoryResult = {}));
var InvalidDeleteInventoryParametersException = (function (_super) {
    __extends(InvalidDeleteInventoryParametersException, _super);
    function InvalidDeleteInventoryParametersException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidDeleteInventoryParametersException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidDeleteInventoryParametersException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidDeleteInventoryParametersException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidDeleteInventoryParametersException;
}(__BaseException));
export { InvalidDeleteInventoryParametersException };
var InvalidInventoryRequestException = (function (_super) {
    __extends(InvalidInventoryRequestException, _super);
    function InvalidInventoryRequestException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidInventoryRequestException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidInventoryRequestException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidInventoryRequestException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidInventoryRequestException;
}(__BaseException));
export { InvalidInventoryRequestException };
var InvalidOptionException = (function (_super) {
    __extends(InvalidOptionException, _super);
    function InvalidOptionException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidOptionException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidOptionException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidOptionException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidOptionException;
}(__BaseException));
export { InvalidOptionException };
var InvalidTypeNameException = (function (_super) {
    __extends(InvalidTypeNameException, _super);
    function InvalidTypeNameException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidTypeNameException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidTypeNameException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidTypeNameException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidTypeNameException;
}(__BaseException));
export { InvalidTypeNameException };
export var DeleteMaintenanceWindowRequest;
(function (DeleteMaintenanceWindowRequest) {
    DeleteMaintenanceWindowRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteMaintenanceWindowRequest || (DeleteMaintenanceWindowRequest = {}));
export var DeleteMaintenanceWindowResult;
(function (DeleteMaintenanceWindowResult) {
    DeleteMaintenanceWindowResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteMaintenanceWindowResult || (DeleteMaintenanceWindowResult = {}));
export var DeleteOpsMetadataRequest;
(function (DeleteOpsMetadataRequest) {
    DeleteOpsMetadataRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteOpsMetadataRequest || (DeleteOpsMetadataRequest = {}));
export var DeleteOpsMetadataResult;
(function (DeleteOpsMetadataResult) {
    DeleteOpsMetadataResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteOpsMetadataResult || (DeleteOpsMetadataResult = {}));
var OpsMetadataNotFoundException = (function (_super) {
    __extends(OpsMetadataNotFoundException, _super);
    function OpsMetadataNotFoundException(opts) {
        var _this = _super.call(this, __assign({ name: "OpsMetadataNotFoundException", $fault: "client" }, opts)) || this;
        _this.name = "OpsMetadataNotFoundException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, OpsMetadataNotFoundException.prototype);
        return _this;
    }
    return OpsMetadataNotFoundException;
}(__BaseException));
export { OpsMetadataNotFoundException };
export var DeleteParameterRequest;
(function (DeleteParameterRequest) {
    DeleteParameterRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteParameterRequest || (DeleteParameterRequest = {}));
export var DeleteParameterResult;
(function (DeleteParameterResult) {
    DeleteParameterResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteParameterResult || (DeleteParameterResult = {}));
var ParameterNotFound = (function (_super) {
    __extends(ParameterNotFound, _super);
    function ParameterNotFound(opts) {
        var _this = _super.call(this, __assign({ name: "ParameterNotFound", $fault: "client" }, opts)) || this;
        _this.name = "ParameterNotFound";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ParameterNotFound.prototype);
        return _this;
    }
    return ParameterNotFound;
}(__BaseException));
export { ParameterNotFound };
export var DeleteParametersRequest;
(function (DeleteParametersRequest) {
    DeleteParametersRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteParametersRequest || (DeleteParametersRequest = {}));
export var DeleteParametersResult;
(function (DeleteParametersResult) {
    DeleteParametersResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteParametersResult || (DeleteParametersResult = {}));
export var DeletePatchBaselineRequest;
(function (DeletePatchBaselineRequest) {
    DeletePatchBaselineRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeletePatchBaselineRequest || (DeletePatchBaselineRequest = {}));
export var DeletePatchBaselineResult;
(function (DeletePatchBaselineResult) {
    DeletePatchBaselineResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeletePatchBaselineResult || (DeletePatchBaselineResult = {}));
var ResourceInUseException = (function (_super) {
    __extends(ResourceInUseException, _super);
    function ResourceInUseException(opts) {
        var _this = _super.call(this, __assign({ name: "ResourceInUseException", $fault: "client" }, opts)) || this;
        _this.name = "ResourceInUseException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ResourceInUseException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return ResourceInUseException;
}(__BaseException));
export { ResourceInUseException };
export var DeleteResourceDataSyncRequest;
(function (DeleteResourceDataSyncRequest) {
    DeleteResourceDataSyncRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteResourceDataSyncRequest || (DeleteResourceDataSyncRequest = {}));
export var DeleteResourceDataSyncResult;
(function (DeleteResourceDataSyncResult) {
    DeleteResourceDataSyncResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeleteResourceDataSyncResult || (DeleteResourceDataSyncResult = {}));
var ResourceDataSyncNotFoundException = (function (_super) {
    __extends(ResourceDataSyncNotFoundException, _super);
    function ResourceDataSyncNotFoundException(opts) {
        var _this = _super.call(this, __assign({ name: "ResourceDataSyncNotFoundException", $fault: "client" }, opts)) || this;
        _this.name = "ResourceDataSyncNotFoundException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, ResourceDataSyncNotFoundException.prototype);
        _this.SyncName = opts.SyncName;
        _this.SyncType = opts.SyncType;
        _this.Message = opts.Message;
        return _this;
    }
    return ResourceDataSyncNotFoundException;
}(__BaseException));
export { ResourceDataSyncNotFoundException };
export var DeregisterManagedInstanceRequest;
(function (DeregisterManagedInstanceRequest) {
    DeregisterManagedInstanceRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeregisterManagedInstanceRequest || (DeregisterManagedInstanceRequest = {}));
export var DeregisterManagedInstanceResult;
(function (DeregisterManagedInstanceResult) {
    DeregisterManagedInstanceResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeregisterManagedInstanceResult || (DeregisterManagedInstanceResult = {}));
export var DeregisterPatchBaselineForPatchGroupRequest;
(function (DeregisterPatchBaselineForPatchGroupRequest) {
    DeregisterPatchBaselineForPatchGroupRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeregisterPatchBaselineForPatchGroupRequest || (DeregisterPatchBaselineForPatchGroupRequest = {}));
export var DeregisterPatchBaselineForPatchGroupResult;
(function (DeregisterPatchBaselineForPatchGroupResult) {
    DeregisterPatchBaselineForPatchGroupResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeregisterPatchBaselineForPatchGroupResult || (DeregisterPatchBaselineForPatchGroupResult = {}));
export var DeregisterTargetFromMaintenanceWindowRequest;
(function (DeregisterTargetFromMaintenanceWindowRequest) {
    DeregisterTargetFromMaintenanceWindowRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeregisterTargetFromMaintenanceWindowRequest || (DeregisterTargetFromMaintenanceWindowRequest = {}));
export var DeregisterTargetFromMaintenanceWindowResult;
(function (DeregisterTargetFromMaintenanceWindowResult) {
    DeregisterTargetFromMaintenanceWindowResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeregisterTargetFromMaintenanceWindowResult || (DeregisterTargetFromMaintenanceWindowResult = {}));
var TargetInUseException = (function (_super) {
    __extends(TargetInUseException, _super);
    function TargetInUseException(opts) {
        var _this = _super.call(this, __assign({ name: "TargetInUseException", $fault: "client" }, opts)) || this;
        _this.name = "TargetInUseException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, TargetInUseException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return TargetInUseException;
}(__BaseException));
export { TargetInUseException };
export var DeregisterTaskFromMaintenanceWindowRequest;
(function (DeregisterTaskFromMaintenanceWindowRequest) {
    DeregisterTaskFromMaintenanceWindowRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeregisterTaskFromMaintenanceWindowRequest || (DeregisterTaskFromMaintenanceWindowRequest = {}));
export var DeregisterTaskFromMaintenanceWindowResult;
(function (DeregisterTaskFromMaintenanceWindowResult) {
    DeregisterTaskFromMaintenanceWindowResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DeregisterTaskFromMaintenanceWindowResult || (DeregisterTaskFromMaintenanceWindowResult = {}));
export var DescribeActivationsFilterKeys;
(function (DescribeActivationsFilterKeys) {
    DescribeActivationsFilterKeys["ACTIVATION_IDS"] = "ActivationIds";
    DescribeActivationsFilterKeys["DEFAULT_INSTANCE_NAME"] = "DefaultInstanceName";
    DescribeActivationsFilterKeys["IAM_ROLE"] = "IamRole";
})(DescribeActivationsFilterKeys || (DescribeActivationsFilterKeys = {}));
export var DescribeActivationsFilter;
(function (DescribeActivationsFilter) {
    DescribeActivationsFilter.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeActivationsFilter || (DescribeActivationsFilter = {}));
export var DescribeActivationsRequest;
(function (DescribeActivationsRequest) {
    DescribeActivationsRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeActivationsRequest || (DescribeActivationsRequest = {}));
export var DescribeActivationsResult;
(function (DescribeActivationsResult) {
    DescribeActivationsResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeActivationsResult || (DescribeActivationsResult = {}));
var InvalidFilter = (function (_super) {
    __extends(InvalidFilter, _super);
    function InvalidFilter(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidFilter", $fault: "client" }, opts)) || this;
        _this.name = "InvalidFilter";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidFilter.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidFilter;
}(__BaseException));
export { InvalidFilter };
var InvalidNextToken = (function (_super) {
    __extends(InvalidNextToken, _super);
    function InvalidNextToken(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidNextToken", $fault: "client" }, opts)) || this;
        _this.name = "InvalidNextToken";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidNextToken.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidNextToken;
}(__BaseException));
export { InvalidNextToken };
export var DescribeAssociationRequest;
(function (DescribeAssociationRequest) {
    DescribeAssociationRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeAssociationRequest || (DescribeAssociationRequest = {}));
export var DescribeAssociationResult;
(function (DescribeAssociationResult) {
    DescribeAssociationResult.filterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.AssociationDescription && {
        AssociationDescription: AssociationDescription.filterSensitiveLog(obj.AssociationDescription),
    }))); };
})(DescribeAssociationResult || (DescribeAssociationResult = {}));
var InvalidAssociationVersion = (function (_super) {
    __extends(InvalidAssociationVersion, _super);
    function InvalidAssociationVersion(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidAssociationVersion", $fault: "client" }, opts)) || this;
        _this.name = "InvalidAssociationVersion";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidAssociationVersion.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidAssociationVersion;
}(__BaseException));
export { InvalidAssociationVersion };
export var AssociationExecutionFilterKey;
(function (AssociationExecutionFilterKey) {
    AssociationExecutionFilterKey["CreatedTime"] = "CreatedTime";
    AssociationExecutionFilterKey["ExecutionId"] = "ExecutionId";
    AssociationExecutionFilterKey["Status"] = "Status";
})(AssociationExecutionFilterKey || (AssociationExecutionFilterKey = {}));
export var AssociationFilterOperatorType;
(function (AssociationFilterOperatorType) {
    AssociationFilterOperatorType["Equal"] = "EQUAL";
    AssociationFilterOperatorType["GreaterThan"] = "GREATER_THAN";
    AssociationFilterOperatorType["LessThan"] = "LESS_THAN";
})(AssociationFilterOperatorType || (AssociationFilterOperatorType = {}));
export var AssociationExecutionFilter;
(function (AssociationExecutionFilter) {
    AssociationExecutionFilter.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(AssociationExecutionFilter || (AssociationExecutionFilter = {}));
export var DescribeAssociationExecutionsRequest;
(function (DescribeAssociationExecutionsRequest) {
    DescribeAssociationExecutionsRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeAssociationExecutionsRequest || (DescribeAssociationExecutionsRequest = {}));
export var AssociationExecution;
(function (AssociationExecution) {
    AssociationExecution.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(AssociationExecution || (AssociationExecution = {}));
export var DescribeAssociationExecutionsResult;
(function (DescribeAssociationExecutionsResult) {
    DescribeAssociationExecutionsResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeAssociationExecutionsResult || (DescribeAssociationExecutionsResult = {}));
var AssociationExecutionDoesNotExist = (function (_super) {
    __extends(AssociationExecutionDoesNotExist, _super);
    function AssociationExecutionDoesNotExist(opts) {
        var _this = _super.call(this, __assign({ name: "AssociationExecutionDoesNotExist", $fault: "client" }, opts)) || this;
        _this.name = "AssociationExecutionDoesNotExist";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, AssociationExecutionDoesNotExist.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return AssociationExecutionDoesNotExist;
}(__BaseException));
export { AssociationExecutionDoesNotExist };
export var AssociationExecutionTargetsFilterKey;
(function (AssociationExecutionTargetsFilterKey) {
    AssociationExecutionTargetsFilterKey["ResourceId"] = "ResourceId";
    AssociationExecutionTargetsFilterKey["ResourceType"] = "ResourceType";
    AssociationExecutionTargetsFilterKey["Status"] = "Status";
})(AssociationExecutionTargetsFilterKey || (AssociationExecutionTargetsFilterKey = {}));
export var AssociationExecutionTargetsFilter;
(function (AssociationExecutionTargetsFilter) {
    AssociationExecutionTargetsFilter.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(AssociationExecutionTargetsFilter || (AssociationExecutionTargetsFilter = {}));
export var DescribeAssociationExecutionTargetsRequest;
(function (DescribeAssociationExecutionTargetsRequest) {
    DescribeAssociationExecutionTargetsRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeAssociationExecutionTargetsRequest || (DescribeAssociationExecutionTargetsRequest = {}));
export var OutputSource;
(function (OutputSource) {
    OutputSource.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(OutputSource || (OutputSource = {}));
export var AssociationExecutionTarget;
(function (AssociationExecutionTarget) {
    AssociationExecutionTarget.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(AssociationExecutionTarget || (AssociationExecutionTarget = {}));
export var DescribeAssociationExecutionTargetsResult;
(function (DescribeAssociationExecutionTargetsResult) {
    DescribeAssociationExecutionTargetsResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeAssociationExecutionTargetsResult || (DescribeAssociationExecutionTargetsResult = {}));
export var AutomationExecutionFilterKey;
(function (AutomationExecutionFilterKey) {
    AutomationExecutionFilterKey["AUTOMATION_SUBTYPE"] = "AutomationSubtype";
    AutomationExecutionFilterKey["AUTOMATION_TYPE"] = "AutomationType";
    AutomationExecutionFilterKey["CURRENT_ACTION"] = "CurrentAction";
    AutomationExecutionFilterKey["DOCUMENT_NAME_PREFIX"] = "DocumentNamePrefix";
    AutomationExecutionFilterKey["EXECUTION_ID"] = "ExecutionId";
    AutomationExecutionFilterKey["EXECUTION_STATUS"] = "ExecutionStatus";
    AutomationExecutionFilterKey["OPS_ITEM_ID"] = "OpsItemId";
    AutomationExecutionFilterKey["PARENT_EXECUTION_ID"] = "ParentExecutionId";
    AutomationExecutionFilterKey["START_TIME_AFTER"] = "StartTimeAfter";
    AutomationExecutionFilterKey["START_TIME_BEFORE"] = "StartTimeBefore";
    AutomationExecutionFilterKey["TAG_KEY"] = "TagKey";
    AutomationExecutionFilterKey["TARGET_RESOURCE_GROUP"] = "TargetResourceGroup";
})(AutomationExecutionFilterKey || (AutomationExecutionFilterKey = {}));
export var AutomationExecutionFilter;
(function (AutomationExecutionFilter) {
    AutomationExecutionFilter.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(AutomationExecutionFilter || (AutomationExecutionFilter = {}));
export var DescribeAutomationExecutionsRequest;
(function (DescribeAutomationExecutionsRequest) {
    DescribeAutomationExecutionsRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeAutomationExecutionsRequest || (DescribeAutomationExecutionsRequest = {}));
export var AutomationExecutionStatus;
(function (AutomationExecutionStatus) {
    AutomationExecutionStatus["APPROVED"] = "Approved";
    AutomationExecutionStatus["CANCELLED"] = "Cancelled";
    AutomationExecutionStatus["CANCELLING"] = "Cancelling";
    AutomationExecutionStatus["CHANGE_CALENDAR_OVERRIDE_APPROVED"] = "ChangeCalendarOverrideApproved";
    AutomationExecutionStatus["CHANGE_CALENDAR_OVERRIDE_REJECTED"] = "ChangeCalendarOverrideRejected";
    AutomationExecutionStatus["COMPLETED_WITH_FAILURE"] = "CompletedWithFailure";
    AutomationExecutionStatus["COMPLETED_WITH_SUCCESS"] = "CompletedWithSuccess";
    AutomationExecutionStatus["FAILED"] = "Failed";
    AutomationExecutionStatus["INPROGRESS"] = "InProgress";
    AutomationExecutionStatus["PENDING"] = "Pending";
    AutomationExecutionStatus["PENDING_APPROVAL"] = "PendingApproval";
    AutomationExecutionStatus["PENDING_CHANGE_CALENDAR_OVERRIDE"] = "PendingChangeCalendarOverride";
    AutomationExecutionStatus["REJECTED"] = "Rejected";
    AutomationExecutionStatus["RUNBOOK_INPROGRESS"] = "RunbookInProgress";
    AutomationExecutionStatus["SCHEDULED"] = "Scheduled";
    AutomationExecutionStatus["SUCCESS"] = "Success";
    AutomationExecutionStatus["TIMEDOUT"] = "TimedOut";
    AutomationExecutionStatus["WAITING"] = "Waiting";
})(AutomationExecutionStatus || (AutomationExecutionStatus = {}));
export var AutomationSubtype;
(function (AutomationSubtype) {
    AutomationSubtype["ChangeRequest"] = "ChangeRequest";
})(AutomationSubtype || (AutomationSubtype = {}));
export var AutomationType;
(function (AutomationType) {
    AutomationType["CrossAccount"] = "CrossAccount";
    AutomationType["Local"] = "Local";
})(AutomationType || (AutomationType = {}));
export var ExecutionMode;
(function (ExecutionMode) {
    ExecutionMode["Auto"] = "Auto";
    ExecutionMode["Interactive"] = "Interactive";
})(ExecutionMode || (ExecutionMode = {}));
export var ResolvedTargets;
(function (ResolvedTargets) {
    ResolvedTargets.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ResolvedTargets || (ResolvedTargets = {}));
export var Runbook;
(function (Runbook) {
    Runbook.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(Runbook || (Runbook = {}));
export var AutomationExecutionMetadata;
(function (AutomationExecutionMetadata) {
    AutomationExecutionMetadata.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(AutomationExecutionMetadata || (AutomationExecutionMetadata = {}));
export var DescribeAutomationExecutionsResult;
(function (DescribeAutomationExecutionsResult) {
    DescribeAutomationExecutionsResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeAutomationExecutionsResult || (DescribeAutomationExecutionsResult = {}));
var InvalidFilterKey = (function (_super) {
    __extends(InvalidFilterKey, _super);
    function InvalidFilterKey(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidFilterKey", $fault: "client" }, opts)) || this;
        _this.name = "InvalidFilterKey";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidFilterKey.prototype);
        return _this;
    }
    return InvalidFilterKey;
}(__BaseException));
export { InvalidFilterKey };
var InvalidFilterValue = (function (_super) {
    __extends(InvalidFilterValue, _super);
    function InvalidFilterValue(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidFilterValue", $fault: "client" }, opts)) || this;
        _this.name = "InvalidFilterValue";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidFilterValue.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidFilterValue;
}(__BaseException));
export { InvalidFilterValue };
var AutomationExecutionNotFoundException = (function (_super) {
    __extends(AutomationExecutionNotFoundException, _super);
    function AutomationExecutionNotFoundException(opts) {
        var _this = _super.call(this, __assign({ name: "AutomationExecutionNotFoundException", $fault: "client" }, opts)) || this;
        _this.name = "AutomationExecutionNotFoundException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, AutomationExecutionNotFoundException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return AutomationExecutionNotFoundException;
}(__BaseException));
export { AutomationExecutionNotFoundException };
export var StepExecutionFilterKey;
(function (StepExecutionFilterKey) {
    StepExecutionFilterKey["ACTION"] = "Action";
    StepExecutionFilterKey["START_TIME_AFTER"] = "StartTimeAfter";
    StepExecutionFilterKey["START_TIME_BEFORE"] = "StartTimeBefore";
    StepExecutionFilterKey["STEP_EXECUTION_ID"] = "StepExecutionId";
    StepExecutionFilterKey["STEP_EXECUTION_STATUS"] = "StepExecutionStatus";
    StepExecutionFilterKey["STEP_NAME"] = "StepName";
})(StepExecutionFilterKey || (StepExecutionFilterKey = {}));
export var StepExecutionFilter;
(function (StepExecutionFilter) {
    StepExecutionFilter.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(StepExecutionFilter || (StepExecutionFilter = {}));
export var DescribeAutomationStepExecutionsRequest;
(function (DescribeAutomationStepExecutionsRequest) {
    DescribeAutomationStepExecutionsRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeAutomationStepExecutionsRequest || (DescribeAutomationStepExecutionsRequest = {}));
export var FailureDetails;
(function (FailureDetails) {
    FailureDetails.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(FailureDetails || (FailureDetails = {}));
export var StepExecution;
(function (StepExecution) {
    StepExecution.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(StepExecution || (StepExecution = {}));
export var DescribeAutomationStepExecutionsResult;
(function (DescribeAutomationStepExecutionsResult) {
    DescribeAutomationStepExecutionsResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeAutomationStepExecutionsResult || (DescribeAutomationStepExecutionsResult = {}));
export var PatchOrchestratorFilter;
(function (PatchOrchestratorFilter) {
    PatchOrchestratorFilter.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(PatchOrchestratorFilter || (PatchOrchestratorFilter = {}));
export var DescribeAvailablePatchesRequest;
(function (DescribeAvailablePatchesRequest) {
    DescribeAvailablePatchesRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeAvailablePatchesRequest || (DescribeAvailablePatchesRequest = {}));
export var Patch;
(function (Patch) {
    Patch.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(Patch || (Patch = {}));
export var DescribeAvailablePatchesResult;
(function (DescribeAvailablePatchesResult) {
    DescribeAvailablePatchesResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeAvailablePatchesResult || (DescribeAvailablePatchesResult = {}));
export var DescribeDocumentRequest;
(function (DescribeDocumentRequest) {
    DescribeDocumentRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeDocumentRequest || (DescribeDocumentRequest = {}));
export var DescribeDocumentResult;
(function (DescribeDocumentResult) {
    DescribeDocumentResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeDocumentResult || (DescribeDocumentResult = {}));
export var DocumentPermissionType;
(function (DocumentPermissionType) {
    DocumentPermissionType["SHARE"] = "Share";
})(DocumentPermissionType || (DocumentPermissionType = {}));
export var DescribeDocumentPermissionRequest;
(function (DescribeDocumentPermissionRequest) {
    DescribeDocumentPermissionRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeDocumentPermissionRequest || (DescribeDocumentPermissionRequest = {}));
export var DescribeDocumentPermissionResponse;
(function (DescribeDocumentPermissionResponse) {
    DescribeDocumentPermissionResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeDocumentPermissionResponse || (DescribeDocumentPermissionResponse = {}));
var InvalidPermissionType = (function (_super) {
    __extends(InvalidPermissionType, _super);
    function InvalidPermissionType(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidPermissionType", $fault: "client" }, opts)) || this;
        _this.name = "InvalidPermissionType";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidPermissionType.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidPermissionType;
}(__BaseException));
export { InvalidPermissionType };
export var DescribeEffectiveInstanceAssociationsRequest;
(function (DescribeEffectiveInstanceAssociationsRequest) {
    DescribeEffectiveInstanceAssociationsRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeEffectiveInstanceAssociationsRequest || (DescribeEffectiveInstanceAssociationsRequest = {}));
export var InstanceAssociation;
(function (InstanceAssociation) {
    InstanceAssociation.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(InstanceAssociation || (InstanceAssociation = {}));
export var DescribeEffectiveInstanceAssociationsResult;
(function (DescribeEffectiveInstanceAssociationsResult) {
    DescribeEffectiveInstanceAssociationsResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeEffectiveInstanceAssociationsResult || (DescribeEffectiveInstanceAssociationsResult = {}));
export var DescribeEffectivePatchesForPatchBaselineRequest;
(function (DescribeEffectivePatchesForPatchBaselineRequest) {
    DescribeEffectivePatchesForPatchBaselineRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeEffectivePatchesForPatchBaselineRequest || (DescribeEffectivePatchesForPatchBaselineRequest = {}));
export var PatchDeploymentStatus;
(function (PatchDeploymentStatus) {
    PatchDeploymentStatus["Approved"] = "APPROVED";
    PatchDeploymentStatus["ExplicitApproved"] = "EXPLICIT_APPROVED";
    PatchDeploymentStatus["ExplicitRejected"] = "EXPLICIT_REJECTED";
    PatchDeploymentStatus["PendingApproval"] = "PENDING_APPROVAL";
})(PatchDeploymentStatus || (PatchDeploymentStatus = {}));
export var PatchStatus;
(function (PatchStatus) {
    PatchStatus.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(PatchStatus || (PatchStatus = {}));
export var EffectivePatch;
(function (EffectivePatch) {
    EffectivePatch.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(EffectivePatch || (EffectivePatch = {}));
export var DescribeEffectivePatchesForPatchBaselineResult;
(function (DescribeEffectivePatchesForPatchBaselineResult) {
    DescribeEffectivePatchesForPatchBaselineResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeEffectivePatchesForPatchBaselineResult || (DescribeEffectivePatchesForPatchBaselineResult = {}));
var UnsupportedOperatingSystem = (function (_super) {
    __extends(UnsupportedOperatingSystem, _super);
    function UnsupportedOperatingSystem(opts) {
        var _this = _super.call(this, __assign({ name: "UnsupportedOperatingSystem", $fault: "client" }, opts)) || this;
        _this.name = "UnsupportedOperatingSystem";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, UnsupportedOperatingSystem.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return UnsupportedOperatingSystem;
}(__BaseException));
export { UnsupportedOperatingSystem };
export var DescribeInstanceAssociationsStatusRequest;
(function (DescribeInstanceAssociationsStatusRequest) {
    DescribeInstanceAssociationsStatusRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeInstanceAssociationsStatusRequest || (DescribeInstanceAssociationsStatusRequest = {}));
export var S3OutputUrl;
(function (S3OutputUrl) {
    S3OutputUrl.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(S3OutputUrl || (S3OutputUrl = {}));
export var InstanceAssociationOutputUrl;
(function (InstanceAssociationOutputUrl) {
    InstanceAssociationOutputUrl.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(InstanceAssociationOutputUrl || (InstanceAssociationOutputUrl = {}));
export var InstanceAssociationStatusInfo;
(function (InstanceAssociationStatusInfo) {
    InstanceAssociationStatusInfo.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(InstanceAssociationStatusInfo || (InstanceAssociationStatusInfo = {}));
export var DescribeInstanceAssociationsStatusResult;
(function (DescribeInstanceAssociationsStatusResult) {
    DescribeInstanceAssociationsStatusResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeInstanceAssociationsStatusResult || (DescribeInstanceAssociationsStatusResult = {}));
export var InstanceInformationStringFilter;
(function (InstanceInformationStringFilter) {
    InstanceInformationStringFilter.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(InstanceInformationStringFilter || (InstanceInformationStringFilter = {}));
export var InstanceInformationFilterKey;
(function (InstanceInformationFilterKey) {
    InstanceInformationFilterKey["ACTIVATION_IDS"] = "ActivationIds";
    InstanceInformationFilterKey["AGENT_VERSION"] = "AgentVersion";
    InstanceInformationFilterKey["ASSOCIATION_STATUS"] = "AssociationStatus";
    InstanceInformationFilterKey["IAM_ROLE"] = "IamRole";
    InstanceInformationFilterKey["INSTANCE_IDS"] = "InstanceIds";
    InstanceInformationFilterKey["PING_STATUS"] = "PingStatus";
    InstanceInformationFilterKey["PLATFORM_TYPES"] = "PlatformTypes";
    InstanceInformationFilterKey["RESOURCE_TYPE"] = "ResourceType";
})(InstanceInformationFilterKey || (InstanceInformationFilterKey = {}));
export var InstanceInformationFilter;
(function (InstanceInformationFilter) {
    InstanceInformationFilter.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(InstanceInformationFilter || (InstanceInformationFilter = {}));
export var DescribeInstanceInformationRequest;
(function (DescribeInstanceInformationRequest) {
    DescribeInstanceInformationRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeInstanceInformationRequest || (DescribeInstanceInformationRequest = {}));
export var InstanceAggregatedAssociationOverview;
(function (InstanceAggregatedAssociationOverview) {
    InstanceAggregatedAssociationOverview.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(InstanceAggregatedAssociationOverview || (InstanceAggregatedAssociationOverview = {}));
export var PingStatus;
(function (PingStatus) {
    PingStatus["CONNECTION_LOST"] = "ConnectionLost";
    PingStatus["INACTIVE"] = "Inactive";
    PingStatus["ONLINE"] = "Online";
})(PingStatus || (PingStatus = {}));
export var ResourceType;
(function (ResourceType) {
    ResourceType["DOCUMENT"] = "Document";
    ResourceType["EC2_INSTANCE"] = "EC2Instance";
    ResourceType["MANAGED_INSTANCE"] = "ManagedInstance";
})(ResourceType || (ResourceType = {}));
export var SourceType;
(function (SourceType) {
    SourceType["AWS_EC2_INSTANCE"] = "AWS::EC2::Instance";
    SourceType["AWS_IOT_THING"] = "AWS::IoT::Thing";
    SourceType["AWS_SSM_MANAGEDINSTANCE"] = "AWS::SSM::ManagedInstance";
})(SourceType || (SourceType = {}));
export var InstanceInformation;
(function (InstanceInformation) {
    InstanceInformation.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(InstanceInformation || (InstanceInformation = {}));
export var DescribeInstanceInformationResult;
(function (DescribeInstanceInformationResult) {
    DescribeInstanceInformationResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeInstanceInformationResult || (DescribeInstanceInformationResult = {}));
var InvalidInstanceInformationFilterValue = (function (_super) {
    __extends(InvalidInstanceInformationFilterValue, _super);
    function InvalidInstanceInformationFilterValue(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidInstanceInformationFilterValue", $fault: "client" }, opts)) || this;
        _this.name = "InvalidInstanceInformationFilterValue";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidInstanceInformationFilterValue.prototype);
        return _this;
    }
    return InvalidInstanceInformationFilterValue;
}(__BaseException));
export { InvalidInstanceInformationFilterValue };
export var DescribeInstancePatchesRequest;
(function (DescribeInstancePatchesRequest) {
    DescribeInstancePatchesRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeInstancePatchesRequest || (DescribeInstancePatchesRequest = {}));
export var PatchComplianceDataState;
(function (PatchComplianceDataState) {
    PatchComplianceDataState["Failed"] = "FAILED";
    PatchComplianceDataState["Installed"] = "INSTALLED";
    PatchComplianceDataState["InstalledOther"] = "INSTALLED_OTHER";
    PatchComplianceDataState["InstalledPendingReboot"] = "INSTALLED_PENDING_REBOOT";
    PatchComplianceDataState["InstalledRejected"] = "INSTALLED_REJECTED";
    PatchComplianceDataState["Missing"] = "MISSING";
    PatchComplianceDataState["NotApplicable"] = "NOT_APPLICABLE";
})(PatchComplianceDataState || (PatchComplianceDataState = {}));
export var PatchComplianceData;
(function (PatchComplianceData) {
    PatchComplianceData.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(PatchComplianceData || (PatchComplianceData = {}));
export var DescribeInstancePatchesResult;
(function (DescribeInstancePatchesResult) {
    DescribeInstancePatchesResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeInstancePatchesResult || (DescribeInstancePatchesResult = {}));
export var DescribeInstancePatchStatesRequest;
(function (DescribeInstancePatchStatesRequest) {
    DescribeInstancePatchStatesRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeInstancePatchStatesRequest || (DescribeInstancePatchStatesRequest = {}));
export var PatchOperationType;
(function (PatchOperationType) {
    PatchOperationType["INSTALL"] = "Install";
    PatchOperationType["SCAN"] = "Scan";
})(PatchOperationType || (PatchOperationType = {}));
export var RebootOption;
(function (RebootOption) {
    RebootOption["NO_REBOOT"] = "NoReboot";
    RebootOption["REBOOT_IF_NEEDED"] = "RebootIfNeeded";
})(RebootOption || (RebootOption = {}));
export var InstancePatchState;
(function (InstancePatchState) {
    InstancePatchState.filterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.OwnerInformation && { OwnerInformation: SENSITIVE_STRING }))); };
})(InstancePatchState || (InstancePatchState = {}));
export var DescribeInstancePatchStatesResult;
(function (DescribeInstancePatchStatesResult) {
    DescribeInstancePatchStatesResult.filterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.InstancePatchStates && {
        InstancePatchStates: obj.InstancePatchStates.map(function (item) { return InstancePatchState.filterSensitiveLog(item); }),
    }))); };
})(DescribeInstancePatchStatesResult || (DescribeInstancePatchStatesResult = {}));
export var InstancePatchStateOperatorType;
(function (InstancePatchStateOperatorType) {
    InstancePatchStateOperatorType["EQUAL"] = "Equal";
    InstancePatchStateOperatorType["GREATER_THAN"] = "GreaterThan";
    InstancePatchStateOperatorType["LESS_THAN"] = "LessThan";
    InstancePatchStateOperatorType["NOT_EQUAL"] = "NotEqual";
})(InstancePatchStateOperatorType || (InstancePatchStateOperatorType = {}));
export var InstancePatchStateFilter;
(function (InstancePatchStateFilter) {
    InstancePatchStateFilter.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(InstancePatchStateFilter || (InstancePatchStateFilter = {}));
export var DescribeInstancePatchStatesForPatchGroupRequest;
(function (DescribeInstancePatchStatesForPatchGroupRequest) {
    DescribeInstancePatchStatesForPatchGroupRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeInstancePatchStatesForPatchGroupRequest || (DescribeInstancePatchStatesForPatchGroupRequest = {}));
export var DescribeInstancePatchStatesForPatchGroupResult;
(function (DescribeInstancePatchStatesForPatchGroupResult) {
    DescribeInstancePatchStatesForPatchGroupResult.filterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.InstancePatchStates && {
        InstancePatchStates: obj.InstancePatchStates.map(function (item) { return InstancePatchState.filterSensitiveLog(item); }),
    }))); };
})(DescribeInstancePatchStatesForPatchGroupResult || (DescribeInstancePatchStatesForPatchGroupResult = {}));
export var DescribeInventoryDeletionsRequest;
(function (DescribeInventoryDeletionsRequest) {
    DescribeInventoryDeletionsRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeInventoryDeletionsRequest || (DescribeInventoryDeletionsRequest = {}));
export var InventoryDeletionStatus;
(function (InventoryDeletionStatus) {
    InventoryDeletionStatus["COMPLETE"] = "Complete";
    InventoryDeletionStatus["IN_PROGRESS"] = "InProgress";
})(InventoryDeletionStatus || (InventoryDeletionStatus = {}));
export var InventoryDeletionStatusItem;
(function (InventoryDeletionStatusItem) {
    InventoryDeletionStatusItem.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(InventoryDeletionStatusItem || (InventoryDeletionStatusItem = {}));
export var DescribeInventoryDeletionsResult;
(function (DescribeInventoryDeletionsResult) {
    DescribeInventoryDeletionsResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeInventoryDeletionsResult || (DescribeInventoryDeletionsResult = {}));
var InvalidDeletionIdException = (function (_super) {
    __extends(InvalidDeletionIdException, _super);
    function InvalidDeletionIdException(opts) {
        var _this = _super.call(this, __assign({ name: "InvalidDeletionIdException", $fault: "client" }, opts)) || this;
        _this.name = "InvalidDeletionIdException";
        _this.$fault = "client";
        Object.setPrototypeOf(_this, InvalidDeletionIdException.prototype);
        _this.Message = opts.Message;
        return _this;
    }
    return InvalidDeletionIdException;
}(__BaseException));
export { InvalidDeletionIdException };
export var MaintenanceWindowFilter;
(function (MaintenanceWindowFilter) {
    MaintenanceWindowFilter.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(MaintenanceWindowFilter || (MaintenanceWindowFilter = {}));
export var DescribeMaintenanceWindowExecutionsRequest;
(function (DescribeMaintenanceWindowExecutionsRequest) {
    DescribeMaintenanceWindowExecutionsRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeMaintenanceWindowExecutionsRequest || (DescribeMaintenanceWindowExecutionsRequest = {}));
export var MaintenanceWindowExecutionStatus;
(function (MaintenanceWindowExecutionStatus) {
    MaintenanceWindowExecutionStatus["Cancelled"] = "CANCELLED";
    MaintenanceWindowExecutionStatus["Cancelling"] = "CANCELLING";
    MaintenanceWindowExecutionStatus["Failed"] = "FAILED";
    MaintenanceWindowExecutionStatus["InProgress"] = "IN_PROGRESS";
    MaintenanceWindowExecutionStatus["Pending"] = "PENDING";
    MaintenanceWindowExecutionStatus["SkippedOverlapping"] = "SKIPPED_OVERLAPPING";
    MaintenanceWindowExecutionStatus["Success"] = "SUCCESS";
    MaintenanceWindowExecutionStatus["TimedOut"] = "TIMED_OUT";
})(MaintenanceWindowExecutionStatus || (MaintenanceWindowExecutionStatus = {}));
export var MaintenanceWindowExecution;
(function (MaintenanceWindowExecution) {
    MaintenanceWindowExecution.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(MaintenanceWindowExecution || (MaintenanceWindowExecution = {}));
export var DescribeMaintenanceWindowExecutionsResult;
(function (DescribeMaintenanceWindowExecutionsResult) {
    DescribeMaintenanceWindowExecutionsResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeMaintenanceWindowExecutionsResult || (DescribeMaintenanceWindowExecutionsResult = {}));
export var DescribeMaintenanceWindowExecutionTaskInvocationsRequest;
(function (DescribeMaintenanceWindowExecutionTaskInvocationsRequest) {
    DescribeMaintenanceWindowExecutionTaskInvocationsRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeMaintenanceWindowExecutionTaskInvocationsRequest || (DescribeMaintenanceWindowExecutionTaskInvocationsRequest = {}));
export var MaintenanceWindowTaskType;
(function (MaintenanceWindowTaskType) {
    MaintenanceWindowTaskType["Automation"] = "AUTOMATION";
    MaintenanceWindowTaskType["Lambda"] = "LAMBDA";
    MaintenanceWindowTaskType["RunCommand"] = "RUN_COMMAND";
    MaintenanceWindowTaskType["StepFunctions"] = "STEP_FUNCTIONS";
})(MaintenanceWindowTaskType || (MaintenanceWindowTaskType = {}));
export var MaintenanceWindowExecutionTaskInvocationIdentity;
(function (MaintenanceWindowExecutionTaskInvocationIdentity) {
    MaintenanceWindowExecutionTaskInvocationIdentity.filterSensitiveLog = function (obj) { return (__assign(__assign(__assign({}, obj), (obj.Parameters && { Parameters: SENSITIVE_STRING })), (obj.OwnerInformation && { OwnerInformation: SENSITIVE_STRING }))); };
})(MaintenanceWindowExecutionTaskInvocationIdentity || (MaintenanceWindowExecutionTaskInvocationIdentity = {}));
export var DescribeMaintenanceWindowExecutionTaskInvocationsResult;
(function (DescribeMaintenanceWindowExecutionTaskInvocationsResult) {
    DescribeMaintenanceWindowExecutionTaskInvocationsResult.filterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.WindowExecutionTaskInvocationIdentities && {
        WindowExecutionTaskInvocationIdentities: obj.WindowExecutionTaskInvocationIdentities.map(function (item) {
            return MaintenanceWindowExecutionTaskInvocationIdentity.filterSensitiveLog(item);
        }),
    }))); };
})(DescribeMaintenanceWindowExecutionTaskInvocationsResult || (DescribeMaintenanceWindowExecutionTaskInvocationsResult = {}));
export var DescribeMaintenanceWindowExecutionTasksRequest;
(function (DescribeMaintenanceWindowExecutionTasksRequest) {
    DescribeMaintenanceWindowExecutionTasksRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeMaintenanceWindowExecutionTasksRequest || (DescribeMaintenanceWindowExecutionTasksRequest = {}));
export var MaintenanceWindowExecutionTaskIdentity;
(function (MaintenanceWindowExecutionTaskIdentity) {
    MaintenanceWindowExecutionTaskIdentity.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(MaintenanceWindowExecutionTaskIdentity || (MaintenanceWindowExecutionTaskIdentity = {}));
export var DescribeMaintenanceWindowExecutionTasksResult;
(function (DescribeMaintenanceWindowExecutionTasksResult) {
    DescribeMaintenanceWindowExecutionTasksResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeMaintenanceWindowExecutionTasksResult || (DescribeMaintenanceWindowExecutionTasksResult = {}));
export var DescribeMaintenanceWindowsRequest;
(function (DescribeMaintenanceWindowsRequest) {
    DescribeMaintenanceWindowsRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeMaintenanceWindowsRequest || (DescribeMaintenanceWindowsRequest = {}));
export var MaintenanceWindowIdentity;
(function (MaintenanceWindowIdentity) {
    MaintenanceWindowIdentity.filterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Description && { Description: SENSITIVE_STRING }))); };
})(MaintenanceWindowIdentity || (MaintenanceWindowIdentity = {}));
export var DescribeMaintenanceWindowsResult;
(function (DescribeMaintenanceWindowsResult) {
    DescribeMaintenanceWindowsResult.filterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.WindowIdentities && {
        WindowIdentities: obj.WindowIdentities.map(function (item) { return MaintenanceWindowIdentity.filterSensitiveLog(item); }),
    }))); };
})(DescribeMaintenanceWindowsResult || (DescribeMaintenanceWindowsResult = {}));
export var MaintenanceWindowResourceType;
(function (MaintenanceWindowResourceType) {
    MaintenanceWindowResourceType["Instance"] = "INSTANCE";
    MaintenanceWindowResourceType["ResourceGroup"] = "RESOURCE_GROUP";
})(MaintenanceWindowResourceType || (MaintenanceWindowResourceType = {}));
export var DescribeMaintenanceWindowScheduleRequest;
(function (DescribeMaintenanceWindowScheduleRequest) {
    DescribeMaintenanceWindowScheduleRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeMaintenanceWindowScheduleRequest || (DescribeMaintenanceWindowScheduleRequest = {}));
export var ScheduledWindowExecution;
(function (ScheduledWindowExecution) {
    ScheduledWindowExecution.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ScheduledWindowExecution || (ScheduledWindowExecution = {}));
export var DescribeMaintenanceWindowScheduleResult;
(function (DescribeMaintenanceWindowScheduleResult) {
    DescribeMaintenanceWindowScheduleResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeMaintenanceWindowScheduleResult || (DescribeMaintenanceWindowScheduleResult = {}));
export var DescribeMaintenanceWindowsForTargetRequest;
(function (DescribeMaintenanceWindowsForTargetRequest) {
    DescribeMaintenanceWindowsForTargetRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeMaintenanceWindowsForTargetRequest || (DescribeMaintenanceWindowsForTargetRequest = {}));
export var MaintenanceWindowIdentityForTarget;
(function (MaintenanceWindowIdentityForTarget) {
    MaintenanceWindowIdentityForTarget.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(MaintenanceWindowIdentityForTarget || (MaintenanceWindowIdentityForTarget = {}));
export var DescribeMaintenanceWindowsForTargetResult;
(function (DescribeMaintenanceWindowsForTargetResult) {
    DescribeMaintenanceWindowsForTargetResult.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeMaintenanceWindowsForTargetResult || (DescribeMaintenanceWindowsForTargetResult = {}));
export var DescribeMaintenanceWindowTargetsRequest;
(function (DescribeMaintenanceWindowTargetsRequest) {
    DescribeMaintenanceWindowTargetsRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeMaintenanceWindowTargetsRequest || (DescribeMaintenanceWindowTargetsRequest = {}));
export var MaintenanceWindowTarget;
(function (MaintenanceWindowTarget) {
    MaintenanceWindowTarget.filterSensitiveLog = function (obj) { return (__assign(__assign(__assign({}, obj), (obj.OwnerInformation && { OwnerInformation: SENSITIVE_STRING })), (obj.Description && { Description: SENSITIVE_STRING }))); };
})(MaintenanceWindowTarget || (MaintenanceWindowTarget = {}));
export var DescribeMaintenanceWindowTargetsResult;
(function (DescribeMaintenanceWindowTargetsResult) {
    DescribeMaintenanceWindowTargetsResult.filterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Targets && { Targets: obj.Targets.map(function (item) { return MaintenanceWindowTarget.filterSensitiveLog(item); }) }))); };
})(DescribeMaintenanceWindowTargetsResult || (DescribeMaintenanceWindowTargetsResult = {}));
export var DescribeMaintenanceWindowTasksRequest;
(function (DescribeMaintenanceWindowTasksRequest) {
    DescribeMaintenanceWindowTasksRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeMaintenanceWindowTasksRequest || (DescribeMaintenanceWindowTasksRequest = {}));
export var MaintenanceWindowTaskCutoffBehavior;
(function (MaintenanceWindowTaskCutoffBehavior) {
    MaintenanceWindowTaskCutoffBehavior["CancelTask"] = "CANCEL_TASK";
    MaintenanceWindowTaskCutoffBehavior["ContinueTask"] = "CONTINUE_TASK";
})(MaintenanceWindowTaskCutoffBehavior || (MaintenanceWindowTaskCutoffBehavior = {}));
export var LoggingInfo;
(function (LoggingInfo) {
    LoggingInfo.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(LoggingInfo || (LoggingInfo = {}));
export var MaintenanceWindowTaskParameterValueExpression;
(function (MaintenanceWindowTaskParameterValueExpression) {
    MaintenanceWindowTaskParameterValueExpression.filterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Values && { Values: SENSITIVE_STRING }))); };
})(MaintenanceWindowTaskParameterValueExpression || (MaintenanceWindowTaskParameterValueExpression = {}));
export var MaintenanceWindowTask;
(function (MaintenanceWindowTask) {
    MaintenanceWindowTask.filterSensitiveLog = function (obj) { return (__assign(__assign(__assign({}, obj), (obj.TaskParameters && { TaskParameters: SENSITIVE_STRING })), (obj.Description && { Description: SENSITIVE_STRING }))); };
})(MaintenanceWindowTask || (MaintenanceWindowTask = {}));
export var DescribeMaintenanceWindowTasksResult;
(function (DescribeMaintenanceWindowTasksResult) {
    DescribeMaintenanceWindowTasksResult.filterSensitiveLog = function (obj) { return (__assign(__assign({}, obj), (obj.Tasks && { Tasks: obj.Tasks.map(function (item) { return MaintenanceWindowTask.filterSensitiveLog(item); }) }))); };
})(DescribeMaintenanceWindowTasksResult || (DescribeMaintenanceWindowTasksResult = {}));
export var OpsItemFilterKey;
(function (OpsItemFilterKey) {
    OpsItemFilterKey["ACTUAL_END_TIME"] = "ActualEndTime";
    OpsItemFilterKey["ACTUAL_START_TIME"] = "ActualStartTime";
    OpsItemFilterKey["AUTOMATION_ID"] = "AutomationId";
    OpsItemFilterKey["CATEGORY"] = "Category";
    OpsItemFilterKey["CHANGE_REQUEST_APPROVER_ARN"] = "ChangeRequestByApproverArn";
    OpsItemFilterKey["CHANGE_REQUEST_APPROVER_NAME"] = "ChangeRequestByApproverName";
    OpsItemFilterKey["CHANGE_REQUEST_REQUESTER_ARN"] = "ChangeRequestByRequesterArn";
    OpsItemFilterKey["CHANGE_REQUEST_REQUESTER_NAME"] = "ChangeRequestByRequesterName";
    OpsItemFilterKey["CHANGE_REQUEST_TARGETS_RESOURCE_GROUP"] = "ChangeRequestByTargetsResourceGroup";
    OpsItemFilterKey["CHANGE_REQUEST_TEMPLATE"] = "ChangeRequestByTemplate";
    OpsItemFilterKey["CREATED_BY"] = "CreatedBy";
    OpsItemFilterKey["CREATED_TIME"] = "CreatedTime";
    OpsItemFilterKey["INSIGHT_TYPE"] = "InsightByType";
    OpsItemFilterKey["LAST_MODIFIED_TIME"] = "LastModifiedTime";
    OpsItemFilterKey["OPERATIONAL_DATA"] = "OperationalData";
    OpsItemFilterKey["OPERATIONAL_DATA_KEY"] = "OperationalDataKey";
    OpsItemFilterKey["OPERATIONAL_DATA_VALUE"] = "OperationalDataValue";
    OpsItemFilterKey["OPSITEM_ID"] = "OpsItemId";
    OpsItemFilterKey["OPSITEM_TYPE"] = "OpsItemType";
    OpsItemFilterKey["PLANNED_END_TIME"] = "PlannedEndTime";
    OpsItemFilterKey["PLANNED_START_TIME"] = "PlannedStartTime";
    OpsItemFilterKey["PRIORITY"] = "Priority";
    OpsItemFilterKey["RESOURCE_ID"] = "ResourceId";
    OpsItemFilterKey["SEVERITY"] = "Severity";
    OpsItemFilterKey["SOURCE"] = "Source";
    OpsItemFilterKey["STATUS"] = "Status";
    OpsItemFilterKey["TITLE"] = "Title";
})(OpsItemFilterKey || (OpsItemFilterKey = {}));
export var OpsItemFilterOperator;
(function (OpsItemFilterOperator) {
    OpsItemFilterOperator["CONTAINS"] = "Contains";
    OpsItemFilterOperator["EQUAL"] = "Equal";
    OpsItemFilterOperator["GREATER_THAN"] = "GreaterThan";
    OpsItemFilterOperator["LESS_THAN"] = "LessThan";
})(OpsItemFilterOperator || (OpsItemFilterOperator = {}));
export var OpsItemFilter;
(function (OpsItemFilter) {
    OpsItemFilter.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(OpsItemFilter || (OpsItemFilter = {}));
export var DescribeOpsItemsRequest;
(function (DescribeOpsItemsRequest) {
    DescribeOpsItemsRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeOpsItemsRequest || (DescribeOpsItemsRequest = {}));
export var OpsItemStatus;
(function (OpsItemStatus) {
    OpsItemStatus["APPROVED"] = "Approved";
    OpsItemStatus["CANCELLED"] = "Cancelled";
    OpsItemStatus["CANCELLING"] = "Cancelling";
    OpsItemStatus["CHANGE_CALENDAR_OVERRIDE_APPROVED"] = "ChangeCalendarOverrideApproved";
    OpsItemStatus["CHANGE_CALENDAR_OVERRIDE_REJECTED"] = "ChangeCalendarOverrideRejected";
    OpsItemStatus["CLOSED"] = "Closed";
    OpsItemStatus["COMPLETED_WITH_FAILURE"] = "CompletedWithFailure";
    OpsItemStatus["COMPLETED_WITH_SUCCESS"] = "CompletedWithSuccess";
    OpsItemStatus["FAILED"] = "Failed";
    OpsItemStatus["IN_PROGRESS"] = "InProgress";
    OpsItemStatus["OPEN"] = "Open";
    OpsItemStatus["PENDING"] = "Pending";
    OpsItemStatus["PENDING_APPROVAL"] = "PendingApproval";
    OpsItemStatus["PENDING_CHANGE_CALENDAR_OVERRIDE"] = "PendingChangeCalendarOverride";
    OpsItemStatus["REJECTED"] = "Rejected";
    OpsItemStatus["RESOLVED"] = "Resolved";
    OpsItemStatus["RUNBOOK_IN_PROGRESS"] = "RunbookInProgress";
    OpsItemStatus["SCHEDULED"] = "Scheduled";
    OpsItemStatus["TIMED_OUT"] = "TimedOut";
})(OpsItemStatus || (OpsItemStatus = {}));
export var OpsItemSummary;
(function (OpsItemSummary) {
    OpsItemSummary.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(OpsItemSummary || (OpsItemSummary = {}));
export var DescribeOpsItemsResponse;
(function (DescribeOpsItemsResponse) {
    DescribeOpsItemsResponse.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeOpsItemsResponse || (DescribeOpsItemsResponse = {}));
export var ParametersFilterKey;
(function (ParametersFilterKey) {
    ParametersFilterKey["KEY_ID"] = "KeyId";
    ParametersFilterKey["NAME"] = "Name";
    ParametersFilterKey["TYPE"] = "Type";
})(ParametersFilterKey || (ParametersFilterKey = {}));
export var ParametersFilter;
(function (ParametersFilter) {
    ParametersFilter.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ParametersFilter || (ParametersFilter = {}));
export var ParameterStringFilter;
(function (ParameterStringFilter) {
    ParameterStringFilter.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ParameterStringFilter || (ParameterStringFilter = {}));
export var DescribeParametersRequest;
(function (DescribeParametersRequest) {
    DescribeParametersRequest.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(DescribeParametersRequest || (DescribeParametersRequest = {}));
export var ParameterInlinePolicy;
(function (ParameterInlinePolicy) {
    ParameterInlinePolicy.filterSensitiveLog = function (obj) { return (__assign({}, obj)); };
})(ParameterInlinePolicy || (ParameterInlinePolicy = {}));
