import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { PutParameterRequest, PutParameterResult } from "../models/models_1";
import { ServiceInputTypes, ServiceOutputTypes, SSMClientResolvedConfig } from "../SSMClient";
export interface PutParameterCommandInput extends PutParameterRequest {
}
export interface PutParameterCommandOutput extends PutParameterResult, __MetadataBearer {
}

export declare class PutParameterCommand extends $Command<PutParameterCommandInput, PutParameterCommandOutput, SSMClientResolvedConfig> {
    readonly input: PutParameterCommandInput;
    constructor(input: PutParameterCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: SSMClientResolvedConfig, options?: __HttpHandlerOptions): Handler<PutParameterCommandInput, PutParameterCommandOutput>;
    private serialize;
    private deserialize;
}
