import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { SSMServiceException as __BaseException } from "./SSMServiceException";

export interface AccountSharingInfo {
    
    AccountId?: string;
    
    SharedDocumentVersion?: string;
}
export declare namespace AccountSharingInfo {
    
    const filterSensitiveLog: (obj: AccountSharingInfo) => any;
}

export interface Tag {
    
    Key: string | undefined;
    
    Value: string | undefined;
}
export declare namespace Tag {
    
    const filterSensitiveLog: (obj: Tag) => any;
}

export interface Activation {
    
    ActivationId?: string;
    
    Description?: string;
    
    DefaultInstanceName?: string;
    
    IamRole?: string;
    
    RegistrationLimit?: number;
    
    RegistrationsCount?: number;
    
    ExpirationDate?: Date;
    
    Expired?: boolean;
    
    CreatedDate?: Date;
    
    Tags?: Tag[];
}
export declare namespace Activation {
    
    const filterSensitiveLog: (obj: Activation) => any;
}
export declare enum ResourceTypeForTagging {
    AUTOMATION = "Automation",
    DOCUMENT = "Document",
    MAINTENANCE_WINDOW = "MaintenanceWindow",
    MANAGED_INSTANCE = "ManagedInstance",
    OPSMETADATA = "OpsMetadata",
    OPS_ITEM = "OpsItem",
    PARAMETER = "Parameter",
    PATCH_BASELINE = "PatchBaseline"
}
export interface AddTagsToResourceRequest {
    
    ResourceType: ResourceTypeForTagging | string | undefined;
    
    ResourceId: string | undefined;
    
    Tags: Tag[] | undefined;
}
export declare namespace AddTagsToResourceRequest {
    
    const filterSensitiveLog: (obj: AddTagsToResourceRequest) => any;
}
export interface AddTagsToResourceResult {
}
export declare namespace AddTagsToResourceResult {
    
    const filterSensitiveLog: (obj: AddTagsToResourceResult) => any;
}

export declare class InternalServerError extends __BaseException {
    readonly name: "InternalServerError";
    readonly $fault: "server";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InternalServerError, __BaseException>);
}

export declare class InvalidResourceId extends __BaseException {
    readonly name: "InvalidResourceId";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidResourceId, __BaseException>);
}

export declare class InvalidResourceType extends __BaseException {
    readonly name: "InvalidResourceType";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidResourceType, __BaseException>);
}

export declare class TooManyTagsError extends __BaseException {
    readonly name: "TooManyTagsError";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<TooManyTagsError, __BaseException>);
}

export declare class TooManyUpdates extends __BaseException {
    readonly name: "TooManyUpdates";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<TooManyUpdates, __BaseException>);
}

export declare class AlreadyExistsException extends __BaseException {
    readonly name: "AlreadyExistsException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<AlreadyExistsException, __BaseException>);
}
export interface AssociateOpsItemRelatedItemRequest {
    
    OpsItemId: string | undefined;
    
    AssociationType: string | undefined;
    
    ResourceType: string | undefined;
    
    ResourceUri: string | undefined;
}
export declare namespace AssociateOpsItemRelatedItemRequest {
    
    const filterSensitiveLog: (obj: AssociateOpsItemRelatedItemRequest) => any;
}
export interface AssociateOpsItemRelatedItemResponse {
    
    AssociationId?: string;
}
export declare namespace AssociateOpsItemRelatedItemResponse {
    
    const filterSensitiveLog: (obj: AssociateOpsItemRelatedItemResponse) => any;
}

export declare class OpsItemInvalidParameterException extends __BaseException {
    readonly name: "OpsItemInvalidParameterException";
    readonly $fault: "client";
    ParameterNames?: string[];
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<OpsItemInvalidParameterException, __BaseException>);
}

export declare class OpsItemLimitExceededException extends __BaseException {
    readonly name: "OpsItemLimitExceededException";
    readonly $fault: "client";
    ResourceTypes?: string[];
    Limit?: number;
    LimitType?: string;
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<OpsItemLimitExceededException, __BaseException>);
}

export declare class OpsItemNotFoundException extends __BaseException {
    readonly name: "OpsItemNotFoundException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<OpsItemNotFoundException, __BaseException>);
}

export declare class OpsItemRelatedItemAlreadyExistsException extends __BaseException {
    readonly name: "OpsItemRelatedItemAlreadyExistsException";
    readonly $fault: "client";
    Message?: string;
    ResourceUri?: string;
    OpsItemId?: string;
    
    constructor(opts: __ExceptionOptionType<OpsItemRelatedItemAlreadyExistsException, __BaseException>);
}

export interface CancelCommandRequest {
    
    CommandId: string | undefined;
    
    InstanceIds?: string[];
}
export declare namespace CancelCommandRequest {
    
    const filterSensitiveLog: (obj: CancelCommandRequest) => any;
}

export interface CancelCommandResult {
}
export declare namespace CancelCommandResult {
    
    const filterSensitiveLog: (obj: CancelCommandResult) => any;
}

export declare class DuplicateInstanceId extends __BaseException {
    readonly name: "DuplicateInstanceId";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<DuplicateInstanceId, __BaseException>);
}

export declare class InvalidCommandId extends __BaseException {
    readonly name: "InvalidCommandId";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidCommandId, __BaseException>);
}

export declare class InvalidInstanceId extends __BaseException {
    readonly name: "InvalidInstanceId";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidInstanceId, __BaseException>);
}
export interface CancelMaintenanceWindowExecutionRequest {
    
    WindowExecutionId: string | undefined;
}
export declare namespace CancelMaintenanceWindowExecutionRequest {
    
    const filterSensitiveLog: (obj: CancelMaintenanceWindowExecutionRequest) => any;
}
export interface CancelMaintenanceWindowExecutionResult {
    
    WindowExecutionId?: string;
}
export declare namespace CancelMaintenanceWindowExecutionResult {
    
    const filterSensitiveLog: (obj: CancelMaintenanceWindowExecutionResult) => any;
}

export declare class DoesNotExistException extends __BaseException {
    readonly name: "DoesNotExistException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<DoesNotExistException, __BaseException>);
}

export interface RegistrationMetadataItem {
    
    Key: string | undefined;
    
    Value: string | undefined;
}
export declare namespace RegistrationMetadataItem {
    
    const filterSensitiveLog: (obj: RegistrationMetadataItem) => any;
}
export interface CreateActivationRequest {
    
    Description?: string;
    
    DefaultInstanceName?: string;
    
    IamRole: string | undefined;
    
    RegistrationLimit?: number;
    
    ExpirationDate?: Date;
    
    Tags?: Tag[];
    
    RegistrationMetadata?: RegistrationMetadataItem[];
}
export declare namespace CreateActivationRequest {
    
    const filterSensitiveLog: (obj: CreateActivationRequest) => any;
}
export interface CreateActivationResult {
    
    ActivationId?: string;
    
    ActivationCode?: string;
}
export declare namespace CreateActivationResult {
    
    const filterSensitiveLog: (obj: CreateActivationResult) => any;
}

export declare class InvalidParameters extends __BaseException {
    readonly name: "InvalidParameters";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidParameters, __BaseException>);
}

export declare class AssociationAlreadyExists extends __BaseException {
    readonly name: "AssociationAlreadyExists";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<AssociationAlreadyExists, __BaseException>);
}

export declare class AssociationLimitExceeded extends __BaseException {
    readonly name: "AssociationLimitExceeded";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<AssociationLimitExceeded, __BaseException>);
}
export declare enum AssociationComplianceSeverity {
    Critical = "CRITICAL",
    High = "HIGH",
    Low = "LOW",
    Medium = "MEDIUM",
    Unspecified = "UNSPECIFIED"
}

export interface S3OutputLocation {
    
    OutputS3Region?: string;
    
    OutputS3BucketName?: string;
    
    OutputS3KeyPrefix?: string;
}
export declare namespace S3OutputLocation {
    
    const filterSensitiveLog: (obj: S3OutputLocation) => any;
}

export interface InstanceAssociationOutputLocation {
    
    S3Location?: S3OutputLocation;
}
export declare namespace InstanceAssociationOutputLocation {
    
    const filterSensitiveLog: (obj: InstanceAssociationOutputLocation) => any;
}
export declare enum AssociationSyncCompliance {
    Auto = "AUTO",
    Manual = "MANUAL"
}

export interface TargetLocation {
    
    Accounts?: string[];
    
    Regions?: string[];
    
    TargetLocationMaxConcurrency?: string;
    
    TargetLocationMaxErrors?: string;
    
    ExecutionRoleName?: string;
}
export declare namespace TargetLocation {
    
    const filterSensitiveLog: (obj: TargetLocation) => any;
}

export interface Target {
    
    Key?: string;
    
    Values?: string[];
}
export declare namespace Target {
    
    const filterSensitiveLog: (obj: Target) => any;
}
export interface CreateAssociationRequest {
    
    Name: string | undefined;
    
    DocumentVersion?: string;
    
    InstanceId?: string;
    
    Parameters?: Record<string, string[]>;
    
    Targets?: Target[];
    
    ScheduleExpression?: string;
    
    OutputLocation?: InstanceAssociationOutputLocation;
    
    AssociationName?: string;
    
    AutomationTargetParameterName?: string;
    
    MaxErrors?: string;
    
    MaxConcurrency?: string;
    
    ComplianceSeverity?: AssociationComplianceSeverity | string;
    
    SyncCompliance?: AssociationSyncCompliance | string;
    
    ApplyOnlyAtCronInterval?: boolean;
    
    CalendarNames?: string[];
    
    TargetLocations?: TargetLocation[];
    
    ScheduleOffset?: number;
    
    TargetMaps?: Record<string, string[]>[];
}
export declare namespace CreateAssociationRequest {
    
    const filterSensitiveLog: (obj: CreateAssociationRequest) => any;
}

export interface AssociationOverview {
    
    Status?: string;
    
    DetailedStatus?: string;
    
    AssociationStatusAggregatedCount?: Record<string, number>;
}
export declare namespace AssociationOverview {
    
    const filterSensitiveLog: (obj: AssociationOverview) => any;
}
export declare enum AssociationStatusName {
    Failed = "Failed",
    Pending = "Pending",
    Success = "Success"
}

export interface AssociationStatus {
    
    Date: Date | undefined;
    
    Name: AssociationStatusName | string | undefined;
    
    Message: string | undefined;
    
    AdditionalInfo?: string;
}
export declare namespace AssociationStatus {
    
    const filterSensitiveLog: (obj: AssociationStatus) => any;
}

export interface AssociationDescription {
    
    Name?: string;
    
    InstanceId?: string;
    
    AssociationVersion?: string;
    
    Date?: Date;
    
    LastUpdateAssociationDate?: Date;
    
    Status?: AssociationStatus;
    
    Overview?: AssociationOverview;
    
    DocumentVersion?: string;
    
    AutomationTargetParameterName?: string;
    
    Parameters?: Record<string, string[]>;
    
    AssociationId?: string;
    
    Targets?: Target[];
    
    ScheduleExpression?: string;
    
    OutputLocation?: InstanceAssociationOutputLocation;
    
    LastExecutionDate?: Date;
    
    LastSuccessfulExecutionDate?: Date;
    
    AssociationName?: string;
    
    MaxErrors?: string;
    
    MaxConcurrency?: string;
    
    ComplianceSeverity?: AssociationComplianceSeverity | string;
    
    SyncCompliance?: AssociationSyncCompliance | string;
    
    ApplyOnlyAtCronInterval?: boolean;
    
    CalendarNames?: string[];
    
    TargetLocations?: TargetLocation[];
    
    ScheduleOffset?: number;
    
    TargetMaps?: Record<string, string[]>[];
}
export declare namespace AssociationDescription {
    
    const filterSensitiveLog: (obj: AssociationDescription) => any;
}
export interface CreateAssociationResult {
    
    AssociationDescription?: AssociationDescription;
}
export declare namespace CreateAssociationResult {
    
    const filterSensitiveLog: (obj: CreateAssociationResult) => any;
}

export declare class InvalidDocument extends __BaseException {
    readonly name: "InvalidDocument";
    readonly $fault: "client";
    
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidDocument, __BaseException>);
}

export declare class InvalidDocumentVersion extends __BaseException {
    readonly name: "InvalidDocumentVersion";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidDocumentVersion, __BaseException>);
}

export declare class InvalidOutputLocation extends __BaseException {
    readonly name: "InvalidOutputLocation";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidOutputLocation, __BaseException>);
}

export declare class InvalidSchedule extends __BaseException {
    readonly name: "InvalidSchedule";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidSchedule, __BaseException>);
}

export declare class InvalidTarget extends __BaseException {
    readonly name: "InvalidTarget";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidTarget, __BaseException>);
}

export declare class InvalidTargetMaps extends __BaseException {
    readonly name: "InvalidTargetMaps";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidTargetMaps, __BaseException>);
}

export declare class UnsupportedPlatformType extends __BaseException {
    readonly name: "UnsupportedPlatformType";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<UnsupportedPlatformType, __BaseException>);
}

export interface CreateAssociationBatchRequestEntry {
    
    Name: string | undefined;
    
    InstanceId?: string;
    
    Parameters?: Record<string, string[]>;
    
    AutomationTargetParameterName?: string;
    
    DocumentVersion?: string;
    
    Targets?: Target[];
    
    ScheduleExpression?: string;
    
    OutputLocation?: InstanceAssociationOutputLocation;
    
    AssociationName?: string;
    
    MaxErrors?: string;
    
    MaxConcurrency?: string;
    
    ComplianceSeverity?: AssociationComplianceSeverity | string;
    
    SyncCompliance?: AssociationSyncCompliance | string;
    
    ApplyOnlyAtCronInterval?: boolean;
    
    CalendarNames?: string[];
    
    TargetLocations?: TargetLocation[];
    
    ScheduleOffset?: number;
    
    TargetMaps?: Record<string, string[]>[];
}
export declare namespace CreateAssociationBatchRequestEntry {
    
    const filterSensitiveLog: (obj: CreateAssociationBatchRequestEntry) => any;
}
export interface CreateAssociationBatchRequest {
    
    Entries: CreateAssociationBatchRequestEntry[] | undefined;
}
export declare namespace CreateAssociationBatchRequest {
    
    const filterSensitiveLog: (obj: CreateAssociationBatchRequest) => any;
}
export declare type Fault = "Client" | "Server" | "Unknown";

export interface FailedCreateAssociation {
    
    Entry?: CreateAssociationBatchRequestEntry;
    
    Message?: string;
    
    Fault?: Fault | string;
}
export declare namespace FailedCreateAssociation {
    
    const filterSensitiveLog: (obj: FailedCreateAssociation) => any;
}
export interface CreateAssociationBatchResult {
    
    Successful?: AssociationDescription[];
    
    Failed?: FailedCreateAssociation[];
}
export declare namespace CreateAssociationBatchResult {
    
    const filterSensitiveLog: (obj: CreateAssociationBatchResult) => any;
}
export declare enum AttachmentsSourceKey {
    AttachmentReference = "AttachmentReference",
    S3FileUrl = "S3FileUrl",
    SourceUrl = "SourceUrl"
}

export interface AttachmentsSource {
    
    Key?: AttachmentsSourceKey | string;
    
    Values?: string[];
    
    Name?: string;
}
export declare namespace AttachmentsSource {
    
    const filterSensitiveLog: (obj: AttachmentsSource) => any;
}
export declare enum DocumentFormat {
    JSON = "JSON",
    TEXT = "TEXT",
    YAML = "YAML"
}
export declare enum DocumentType {
    ApplicationConfiguration = "ApplicationConfiguration",
    ApplicationConfigurationSchema = "ApplicationConfigurationSchema",
    Automation = "Automation",
    ChangeCalendar = "ChangeCalendar",
    ChangeTemplate = "Automation.ChangeTemplate",
    Command = "Command",
    DeploymentStrategy = "DeploymentStrategy",
    Package = "Package",
    Policy = "Policy",
    ProblemAnalysis = "ProblemAnalysis",
    ProblemAnalysisTemplate = "ProblemAnalysisTemplate",
    Session = "Session"
}

export interface DocumentRequires {
    
    Name: string | undefined;
    
    Version?: string;
}
export declare namespace DocumentRequires {
    
    const filterSensitiveLog: (obj: DocumentRequires) => any;
}
export interface CreateDocumentRequest {
    
    Content: string | undefined;
    
    Requires?: DocumentRequires[];
    
    Attachments?: AttachmentsSource[];
    
    Name: string | undefined;
    
    DisplayName?: string;
    
    VersionName?: string;
    
    DocumentType?: DocumentType | string;
    
    DocumentFormat?: DocumentFormat | string;
    
    TargetType?: string;
    
    Tags?: Tag[];
}
export declare namespace CreateDocumentRequest {
    
    const filterSensitiveLog: (obj: CreateDocumentRequest) => any;
}

export interface AttachmentInformation {
    
    Name?: string;
}
export declare namespace AttachmentInformation {
    
    const filterSensitiveLog: (obj: AttachmentInformation) => any;
}
export declare enum DocumentHashType {
    SHA1 = "Sha1",
    SHA256 = "Sha256"
}
export declare type DocumentParameterType = "String" | "StringList";

export interface DocumentParameter {
    
    Name?: string;
    
    Type?: DocumentParameterType | string;
    
    Description?: string;
    
    DefaultValue?: string;
}
export declare namespace DocumentParameter {
    
    const filterSensitiveLog: (obj: DocumentParameter) => any;
}
export declare enum PlatformType {
    LINUX = "Linux",
    MACOS = "MacOS",
    WINDOWS = "Windows"
}
export declare enum ReviewStatus {
    APPROVED = "APPROVED",
    NOT_REVIEWED = "NOT_REVIEWED",
    PENDING = "PENDING",
    REJECTED = "REJECTED"
}

export interface ReviewInformation {
    
    ReviewedTime?: Date;
    
    Status?: ReviewStatus | string;
    
    Reviewer?: string;
}
export declare namespace ReviewInformation {
    
    const filterSensitiveLog: (obj: ReviewInformation) => any;
}
export declare enum DocumentStatus {
    Active = "Active",
    Creating = "Creating",
    Deleting = "Deleting",
    Failed = "Failed",
    Updating = "Updating"
}

export interface DocumentDescription {
    
    Sha1?: string;
    
    Hash?: string;
    
    HashType?: DocumentHashType | string;
    
    Name?: string;
    
    DisplayName?: string;
    
    VersionName?: string;
    
    Owner?: string;
    
    CreatedDate?: Date;
    
    Status?: DocumentStatus | string;
    
    StatusInformation?: string;
    
    DocumentVersion?: string;
    
    Description?: string;
    
    Parameters?: DocumentParameter[];
    
    PlatformTypes?: (PlatformType | string)[];
    
    DocumentType?: DocumentType | string;
    
    SchemaVersion?: string;
    
    LatestVersion?: string;
    
    DefaultVersion?: string;
    
    DocumentFormat?: DocumentFormat | string;
    
    TargetType?: string;
    
    Tags?: Tag[];
    
    AttachmentsInformation?: AttachmentInformation[];
    
    Requires?: DocumentRequires[];
    
    Author?: string;
    
    ReviewInformation?: ReviewInformation[];
    
    ApprovedVersion?: string;
    
    PendingReviewVersion?: string;
    
    ReviewStatus?: ReviewStatus | string;
    
    Category?: string[];
    
    CategoryEnum?: string[];
}
export declare namespace DocumentDescription {
    
    const filterSensitiveLog: (obj: DocumentDescription) => any;
}
export interface CreateDocumentResult {
    
    DocumentDescription?: DocumentDescription;
}
export declare namespace CreateDocumentResult {
    
    const filterSensitiveLog: (obj: CreateDocumentResult) => any;
}

export declare class DocumentAlreadyExists extends __BaseException {
    readonly name: "DocumentAlreadyExists";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<DocumentAlreadyExists, __BaseException>);
}

export declare class DocumentLimitExceeded extends __BaseException {
    readonly name: "DocumentLimitExceeded";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<DocumentLimitExceeded, __BaseException>);
}

export declare class InvalidDocumentContent extends __BaseException {
    readonly name: "InvalidDocumentContent";
    readonly $fault: "client";
    
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidDocumentContent, __BaseException>);
}

export declare class InvalidDocumentSchemaVersion extends __BaseException {
    readonly name: "InvalidDocumentSchemaVersion";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidDocumentSchemaVersion, __BaseException>);
}

export declare class MaxDocumentSizeExceeded extends __BaseException {
    readonly name: "MaxDocumentSizeExceeded";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<MaxDocumentSizeExceeded, __BaseException>);
}
export interface CreateMaintenanceWindowRequest {
    
    Name: string | undefined;
    
    Description?: string;
    
    StartDate?: string;
    
    EndDate?: string;
    
    Schedule: string | undefined;
    
    ScheduleTimezone?: string;
    
    ScheduleOffset?: number;
    
    Duration: number | undefined;
    
    Cutoff: number | undefined;
    
    AllowUnassociatedTargets: boolean | undefined;
    
    ClientToken?: string;
    
    Tags?: Tag[];
}
export declare namespace CreateMaintenanceWindowRequest {
    
    const filterSensitiveLog: (obj: CreateMaintenanceWindowRequest) => any;
}
export interface CreateMaintenanceWindowResult {
    
    WindowId?: string;
}
export declare namespace CreateMaintenanceWindowResult {
    
    const filterSensitiveLog: (obj: CreateMaintenanceWindowResult) => any;
}

export declare class IdempotentParameterMismatch extends __BaseException {
    readonly name: "IdempotentParameterMismatch";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<IdempotentParameterMismatch, __BaseException>);
}

export declare class ResourceLimitExceededException extends __BaseException {
    readonly name: "ResourceLimitExceededException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ResourceLimitExceededException, __BaseException>);
}

export interface OpsItemNotification {
    
    Arn?: string;
}
export declare namespace OpsItemNotification {
    
    const filterSensitiveLog: (obj: OpsItemNotification) => any;
}
export declare enum OpsItemDataType {
    SEARCHABLE_STRING = "SearchableString",
    STRING = "String"
}

export interface OpsItemDataValue {
    
    Value?: string;
    
    Type?: OpsItemDataType | string;
}
export declare namespace OpsItemDataValue {
    
    const filterSensitiveLog: (obj: OpsItemDataValue) => any;
}

export interface RelatedOpsItem {
    
    OpsItemId: string | undefined;
}
export declare namespace RelatedOpsItem {
    
    const filterSensitiveLog: (obj: RelatedOpsItem) => any;
}
export interface CreateOpsItemRequest {
    
    Description: string | undefined;
    
    OpsItemType?: string;
    
    OperationalData?: Record<string, OpsItemDataValue>;
    
    Notifications?: OpsItemNotification[];
    
    Priority?: number;
    
    RelatedOpsItems?: RelatedOpsItem[];
    
    Source: string | undefined;
    
    Title: string | undefined;
    
    Tags?: Tag[];
    
    Category?: string;
    
    Severity?: string;
    
    ActualStartTime?: Date;
    
    ActualEndTime?: Date;
    
    PlannedStartTime?: Date;
    
    PlannedEndTime?: Date;
}
export declare namespace CreateOpsItemRequest {
    
    const filterSensitiveLog: (obj: CreateOpsItemRequest) => any;
}
export interface CreateOpsItemResponse {
    
    OpsItemId?: string;
}
export declare namespace CreateOpsItemResponse {
    
    const filterSensitiveLog: (obj: CreateOpsItemResponse) => any;
}

export declare class OpsItemAlreadyExistsException extends __BaseException {
    readonly name: "OpsItemAlreadyExistsException";
    readonly $fault: "client";
    Message?: string;
    OpsItemId?: string;
    
    constructor(opts: __ExceptionOptionType<OpsItemAlreadyExistsException, __BaseException>);
}

export interface MetadataValue {
    
    Value?: string;
}
export declare namespace MetadataValue {
    
    const filterSensitiveLog: (obj: MetadataValue) => any;
}
export interface CreateOpsMetadataRequest {
    
    ResourceId: string | undefined;
    
    Metadata?: Record<string, MetadataValue>;
    
    Tags?: Tag[];
}
export declare namespace CreateOpsMetadataRequest {
    
    const filterSensitiveLog: (obj: CreateOpsMetadataRequest) => any;
}
export interface CreateOpsMetadataResult {
    
    OpsMetadataArn?: string;
}
export declare namespace CreateOpsMetadataResult {
    
    const filterSensitiveLog: (obj: CreateOpsMetadataResult) => any;
}

export declare class OpsMetadataAlreadyExistsException extends __BaseException {
    readonly name: "OpsMetadataAlreadyExistsException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<OpsMetadataAlreadyExistsException, __BaseException>);
}

export declare class OpsMetadataInvalidArgumentException extends __BaseException {
    readonly name: "OpsMetadataInvalidArgumentException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<OpsMetadataInvalidArgumentException, __BaseException>);
}

export declare class OpsMetadataLimitExceededException extends __BaseException {
    readonly name: "OpsMetadataLimitExceededException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<OpsMetadataLimitExceededException, __BaseException>);
}

export declare class OpsMetadataTooManyUpdatesException extends __BaseException {
    readonly name: "OpsMetadataTooManyUpdatesException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<OpsMetadataTooManyUpdatesException, __BaseException>);
}
export declare enum PatchComplianceLevel {
    Critical = "CRITICAL",
    High = "HIGH",
    Informational = "INFORMATIONAL",
    Low = "LOW",
    Medium = "MEDIUM",
    Unspecified = "UNSPECIFIED"
}
export declare enum PatchFilterKey {
    AdvisoryId = "ADVISORY_ID",
    Arch = "ARCH",
    BugzillaId = "BUGZILLA_ID",
    CVEId = "CVE_ID",
    Classification = "CLASSIFICATION",
    Epoch = "EPOCH",
    MsrcSeverity = "MSRC_SEVERITY",
    Name = "NAME",
    PatchId = "PATCH_ID",
    PatchSet = "PATCH_SET",
    Priority = "PRIORITY",
    Product = "PRODUCT",
    ProductFamily = "PRODUCT_FAMILY",
    Release = "RELEASE",
    Repository = "REPOSITORY",
    Section = "SECTION",
    Security = "SECURITY",
    Severity = "SEVERITY",
    Version = "VERSION"
}

export interface PatchFilter {
    
    Key: PatchFilterKey | string | undefined;
    
    Values: string[] | undefined;
}
export declare namespace PatchFilter {
    
    const filterSensitiveLog: (obj: PatchFilter) => any;
}

export interface PatchFilterGroup {
    
    PatchFilters: PatchFilter[] | undefined;
}
export declare namespace PatchFilterGroup {
    
    const filterSensitiveLog: (obj: PatchFilterGroup) => any;
}

export interface PatchRule {
    
    PatchFilterGroup: PatchFilterGroup | undefined;
    
    ComplianceLevel?: PatchComplianceLevel | string;
    
    ApproveAfterDays?: number;
    
    ApproveUntilDate?: string;
    
    EnableNonSecurity?: boolean;
}
export declare namespace PatchRule {
    
    const filterSensitiveLog: (obj: PatchRule) => any;
}

export interface PatchRuleGroup {
    
    PatchRules: PatchRule[] | undefined;
}
export declare namespace PatchRuleGroup {
    
    const filterSensitiveLog: (obj: PatchRuleGroup) => any;
}
export declare enum OperatingSystem {
    AmazonLinux = "AMAZON_LINUX",
    AmazonLinux2 = "AMAZON_LINUX_2",
    CentOS = "CENTOS",
    Debian = "DEBIAN",
    MacOS = "MACOS",
    OracleLinux = "ORACLE_LINUX",
    Raspbian = "RASPBIAN",
    RedhatEnterpriseLinux = "REDHAT_ENTERPRISE_LINUX",
    Rocky_Linux = "ROCKY_LINUX",
    Suse = "SUSE",
    Ubuntu = "UBUNTU",
    Windows = "WINDOWS"
}
export declare enum PatchAction {
    AllowAsDependency = "ALLOW_AS_DEPENDENCY",
    Block = "BLOCK"
}

export interface PatchSource {
    
    Name: string | undefined;
    
    Products: string[] | undefined;
    
    Configuration: string | undefined;
}
export declare namespace PatchSource {
    
    const filterSensitiveLog: (obj: PatchSource) => any;
}
export interface CreatePatchBaselineRequest {
    
    OperatingSystem?: OperatingSystem | string;
    
    Name: string | undefined;
    
    GlobalFilters?: PatchFilterGroup;
    
    ApprovalRules?: PatchRuleGroup;
    
    ApprovedPatches?: string[];
    
    ApprovedPatchesComplianceLevel?: PatchComplianceLevel | string;
    
    ApprovedPatchesEnableNonSecurity?: boolean;
    
    RejectedPatches?: string[];
    
    RejectedPatchesAction?: PatchAction | string;
    
    Description?: string;
    
    Sources?: PatchSource[];
    
    ClientToken?: string;
    
    Tags?: Tag[];
}
export declare namespace CreatePatchBaselineRequest {
    
    const filterSensitiveLog: (obj: CreatePatchBaselineRequest) => any;
}
export interface CreatePatchBaselineResult {
    
    BaselineId?: string;
}
export declare namespace CreatePatchBaselineResult {
    
    const filterSensitiveLog: (obj: CreatePatchBaselineResult) => any;
}

export interface ResourceDataSyncDestinationDataSharing {
    
    DestinationDataSharingType?: string;
}
export declare namespace ResourceDataSyncDestinationDataSharing {
    
    const filterSensitiveLog: (obj: ResourceDataSyncDestinationDataSharing) => any;
}
export declare enum ResourceDataSyncS3Format {
    JSON_SERDE = "JsonSerDe"
}

export interface ResourceDataSyncS3Destination {
    
    BucketName: string | undefined;
    
    Prefix?: string;
    
    SyncFormat: ResourceDataSyncS3Format | string | undefined;
    
    Region: string | undefined;
    
    AWSKMSKeyARN?: string;
    
    DestinationDataSharing?: ResourceDataSyncDestinationDataSharing;
}
export declare namespace ResourceDataSyncS3Destination {
    
    const filterSensitiveLog: (obj: ResourceDataSyncS3Destination) => any;
}

export interface ResourceDataSyncOrganizationalUnit {
    
    OrganizationalUnitId?: string;
}
export declare namespace ResourceDataSyncOrganizationalUnit {
    
    const filterSensitiveLog: (obj: ResourceDataSyncOrganizationalUnit) => any;
}

export interface ResourceDataSyncAwsOrganizationsSource {
    
    OrganizationSourceType: string | undefined;
    
    OrganizationalUnits?: ResourceDataSyncOrganizationalUnit[];
}
export declare namespace ResourceDataSyncAwsOrganizationsSource {
    
    const filterSensitiveLog: (obj: ResourceDataSyncAwsOrganizationsSource) => any;
}

export interface ResourceDataSyncSource {
    
    SourceType: string | undefined;
    
    AwsOrganizationsSource?: ResourceDataSyncAwsOrganizationsSource;
    
    SourceRegions: string[] | undefined;
    
    IncludeFutureRegions?: boolean;
    
    EnableAllOpsDataSources?: boolean;
}
export declare namespace ResourceDataSyncSource {
    
    const filterSensitiveLog: (obj: ResourceDataSyncSource) => any;
}
export interface CreateResourceDataSyncRequest {
    
    SyncName: string | undefined;
    
    S3Destination?: ResourceDataSyncS3Destination;
    
    SyncType?: string;
    
    SyncSource?: ResourceDataSyncSource;
}
export declare namespace CreateResourceDataSyncRequest {
    
    const filterSensitiveLog: (obj: CreateResourceDataSyncRequest) => any;
}
export interface CreateResourceDataSyncResult {
}
export declare namespace CreateResourceDataSyncResult {
    
    const filterSensitiveLog: (obj: CreateResourceDataSyncResult) => any;
}

export declare class ResourceDataSyncAlreadyExistsException extends __BaseException {
    readonly name: "ResourceDataSyncAlreadyExistsException";
    readonly $fault: "client";
    SyncName?: string;
    
    constructor(opts: __ExceptionOptionType<ResourceDataSyncAlreadyExistsException, __BaseException>);
}

export declare class ResourceDataSyncCountExceededException extends __BaseException {
    readonly name: "ResourceDataSyncCountExceededException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ResourceDataSyncCountExceededException, __BaseException>);
}

export declare class ResourceDataSyncInvalidConfigurationException extends __BaseException {
    readonly name: "ResourceDataSyncInvalidConfigurationException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ResourceDataSyncInvalidConfigurationException, __BaseException>);
}
export interface DeleteActivationRequest {
    
    ActivationId: string | undefined;
}
export declare namespace DeleteActivationRequest {
    
    const filterSensitiveLog: (obj: DeleteActivationRequest) => any;
}
export interface DeleteActivationResult {
}
export declare namespace DeleteActivationResult {
    
    const filterSensitiveLog: (obj: DeleteActivationResult) => any;
}

export declare class InvalidActivation extends __BaseException {
    readonly name: "InvalidActivation";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidActivation, __BaseException>);
}

export declare class InvalidActivationId extends __BaseException {
    readonly name: "InvalidActivationId";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidActivationId, __BaseException>);
}

export declare class AssociationDoesNotExist extends __BaseException {
    readonly name: "AssociationDoesNotExist";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<AssociationDoesNotExist, __BaseException>);
}
export interface DeleteAssociationRequest {
    
    Name?: string;
    
    InstanceId?: string;
    
    AssociationId?: string;
}
export declare namespace DeleteAssociationRequest {
    
    const filterSensitiveLog: (obj: DeleteAssociationRequest) => any;
}
export interface DeleteAssociationResult {
}
export declare namespace DeleteAssociationResult {
    
    const filterSensitiveLog: (obj: DeleteAssociationResult) => any;
}

export declare class AssociatedInstances extends __BaseException {
    readonly name: "AssociatedInstances";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<AssociatedInstances, __BaseException>);
}
export interface DeleteDocumentRequest {
    
    Name: string | undefined;
    
    DocumentVersion?: string;
    
    VersionName?: string;
    
    Force?: boolean;
}
export declare namespace DeleteDocumentRequest {
    
    const filterSensitiveLog: (obj: DeleteDocumentRequest) => any;
}
export interface DeleteDocumentResult {
}
export declare namespace DeleteDocumentResult {
    
    const filterSensitiveLog: (obj: DeleteDocumentResult) => any;
}

export declare class InvalidDocumentOperation extends __BaseException {
    readonly name: "InvalidDocumentOperation";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidDocumentOperation, __BaseException>);
}
export declare enum InventorySchemaDeleteOption {
    DELETE_SCHEMA = "DeleteSchema",
    DISABLE_SCHEMA = "DisableSchema"
}
export interface DeleteInventoryRequest {
    
    TypeName: string | undefined;
    
    SchemaDeleteOption?: InventorySchemaDeleteOption | string;
    
    DryRun?: boolean;
    
    ClientToken?: string;
}
export declare namespace DeleteInventoryRequest {
    
    const filterSensitiveLog: (obj: DeleteInventoryRequest) => any;
}

export interface InventoryDeletionSummaryItem {
    
    Version?: string;
    
    Count?: number;
    
    RemainingCount?: number;
}
export declare namespace InventoryDeletionSummaryItem {
    
    const filterSensitiveLog: (obj: InventoryDeletionSummaryItem) => any;
}

export interface InventoryDeletionSummary {
    
    TotalCount?: number;
    
    RemainingCount?: number;
    
    SummaryItems?: InventoryDeletionSummaryItem[];
}
export declare namespace InventoryDeletionSummary {
    
    const filterSensitiveLog: (obj: InventoryDeletionSummary) => any;
}
export interface DeleteInventoryResult {
    
    DeletionId?: string;
    
    TypeName?: string;
    
    DeletionSummary?: InventoryDeletionSummary;
}
export declare namespace DeleteInventoryResult {
    
    const filterSensitiveLog: (obj: DeleteInventoryResult) => any;
}

export declare class InvalidDeleteInventoryParametersException extends __BaseException {
    readonly name: "InvalidDeleteInventoryParametersException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidDeleteInventoryParametersException, __BaseException>);
}

export declare class InvalidInventoryRequestException extends __BaseException {
    readonly name: "InvalidInventoryRequestException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidInventoryRequestException, __BaseException>);
}

export declare class InvalidOptionException extends __BaseException {
    readonly name: "InvalidOptionException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidOptionException, __BaseException>);
}

export declare class InvalidTypeNameException extends __BaseException {
    readonly name: "InvalidTypeNameException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidTypeNameException, __BaseException>);
}
export interface DeleteMaintenanceWindowRequest {
    
    WindowId: string | undefined;
}
export declare namespace DeleteMaintenanceWindowRequest {
    
    const filterSensitiveLog: (obj: DeleteMaintenanceWindowRequest) => any;
}
export interface DeleteMaintenanceWindowResult {
    
    WindowId?: string;
}
export declare namespace DeleteMaintenanceWindowResult {
    
    const filterSensitiveLog: (obj: DeleteMaintenanceWindowResult) => any;
}
export interface DeleteOpsMetadataRequest {
    
    OpsMetadataArn: string | undefined;
}
export declare namespace DeleteOpsMetadataRequest {
    
    const filterSensitiveLog: (obj: DeleteOpsMetadataRequest) => any;
}
export interface DeleteOpsMetadataResult {
}
export declare namespace DeleteOpsMetadataResult {
    
    const filterSensitiveLog: (obj: DeleteOpsMetadataResult) => any;
}

export declare class OpsMetadataNotFoundException extends __BaseException {
    readonly name: "OpsMetadataNotFoundException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<OpsMetadataNotFoundException, __BaseException>);
}
export interface DeleteParameterRequest {
    
    Name: string | undefined;
}
export declare namespace DeleteParameterRequest {
    
    const filterSensitiveLog: (obj: DeleteParameterRequest) => any;
}
export interface DeleteParameterResult {
}
export declare namespace DeleteParameterResult {
    
    const filterSensitiveLog: (obj: DeleteParameterResult) => any;
}

export declare class ParameterNotFound extends __BaseException {
    readonly name: "ParameterNotFound";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<ParameterNotFound, __BaseException>);
}
export interface DeleteParametersRequest {
    
    Names: string[] | undefined;
}
export declare namespace DeleteParametersRequest {
    
    const filterSensitiveLog: (obj: DeleteParametersRequest) => any;
}
export interface DeleteParametersResult {
    
    DeletedParameters?: string[];
    
    InvalidParameters?: string[];
}
export declare namespace DeleteParametersResult {
    
    const filterSensitiveLog: (obj: DeleteParametersResult) => any;
}
export interface DeletePatchBaselineRequest {
    
    BaselineId: string | undefined;
}
export declare namespace DeletePatchBaselineRequest {
    
    const filterSensitiveLog: (obj: DeletePatchBaselineRequest) => any;
}
export interface DeletePatchBaselineResult {
    
    BaselineId?: string;
}
export declare namespace DeletePatchBaselineResult {
    
    const filterSensitiveLog: (obj: DeletePatchBaselineResult) => any;
}

export declare class ResourceInUseException extends __BaseException {
    readonly name: "ResourceInUseException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ResourceInUseException, __BaseException>);
}
export interface DeleteResourceDataSyncRequest {
    
    SyncName: string | undefined;
    
    SyncType?: string;
}
export declare namespace DeleteResourceDataSyncRequest {
    
    const filterSensitiveLog: (obj: DeleteResourceDataSyncRequest) => any;
}
export interface DeleteResourceDataSyncResult {
}
export declare namespace DeleteResourceDataSyncResult {
    
    const filterSensitiveLog: (obj: DeleteResourceDataSyncResult) => any;
}

export declare class ResourceDataSyncNotFoundException extends __BaseException {
    readonly name: "ResourceDataSyncNotFoundException";
    readonly $fault: "client";
    SyncName?: string;
    SyncType?: string;
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ResourceDataSyncNotFoundException, __BaseException>);
}
export interface DeregisterManagedInstanceRequest {
    
    InstanceId: string | undefined;
}
export declare namespace DeregisterManagedInstanceRequest {
    
    const filterSensitiveLog: (obj: DeregisterManagedInstanceRequest) => any;
}
export interface DeregisterManagedInstanceResult {
}
export declare namespace DeregisterManagedInstanceResult {
    
    const filterSensitiveLog: (obj: DeregisterManagedInstanceResult) => any;
}
export interface DeregisterPatchBaselineForPatchGroupRequest {
    
    BaselineId: string | undefined;
    
    PatchGroup: string | undefined;
}
export declare namespace DeregisterPatchBaselineForPatchGroupRequest {
    
    const filterSensitiveLog: (obj: DeregisterPatchBaselineForPatchGroupRequest) => any;
}
export interface DeregisterPatchBaselineForPatchGroupResult {
    
    BaselineId?: string;
    
    PatchGroup?: string;
}
export declare namespace DeregisterPatchBaselineForPatchGroupResult {
    
    const filterSensitiveLog: (obj: DeregisterPatchBaselineForPatchGroupResult) => any;
}
export interface DeregisterTargetFromMaintenanceWindowRequest {
    
    WindowId: string | undefined;
    
    WindowTargetId: string | undefined;
    
    Safe?: boolean;
}
export declare namespace DeregisterTargetFromMaintenanceWindowRequest {
    
    const filterSensitiveLog: (obj: DeregisterTargetFromMaintenanceWindowRequest) => any;
}
export interface DeregisterTargetFromMaintenanceWindowResult {
    
    WindowId?: string;
    
    WindowTargetId?: string;
}
export declare namespace DeregisterTargetFromMaintenanceWindowResult {
    
    const filterSensitiveLog: (obj: DeregisterTargetFromMaintenanceWindowResult) => any;
}

export declare class TargetInUseException extends __BaseException {
    readonly name: "TargetInUseException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<TargetInUseException, __BaseException>);
}
export interface DeregisterTaskFromMaintenanceWindowRequest {
    
    WindowId: string | undefined;
    
    WindowTaskId: string | undefined;
}
export declare namespace DeregisterTaskFromMaintenanceWindowRequest {
    
    const filterSensitiveLog: (obj: DeregisterTaskFromMaintenanceWindowRequest) => any;
}
export interface DeregisterTaskFromMaintenanceWindowResult {
    
    WindowId?: string;
    
    WindowTaskId?: string;
}
export declare namespace DeregisterTaskFromMaintenanceWindowResult {
    
    const filterSensitiveLog: (obj: DeregisterTaskFromMaintenanceWindowResult) => any;
}
export declare enum DescribeActivationsFilterKeys {
    ACTIVATION_IDS = "ActivationIds",
    DEFAULT_INSTANCE_NAME = "DefaultInstanceName",
    IAM_ROLE = "IamRole"
}

export interface DescribeActivationsFilter {
    
    FilterKey?: DescribeActivationsFilterKeys | string;
    
    FilterValues?: string[];
}
export declare namespace DescribeActivationsFilter {
    
    const filterSensitiveLog: (obj: DescribeActivationsFilter) => any;
}
export interface DescribeActivationsRequest {
    
    Filters?: DescribeActivationsFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeActivationsRequest {
    
    const filterSensitiveLog: (obj: DescribeActivationsRequest) => any;
}
export interface DescribeActivationsResult {
    
    ActivationList?: Activation[];
    
    NextToken?: string;
}
export declare namespace DescribeActivationsResult {
    
    const filterSensitiveLog: (obj: DescribeActivationsResult) => any;
}

export declare class InvalidFilter extends __BaseException {
    readonly name: "InvalidFilter";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidFilter, __BaseException>);
}

export declare class InvalidNextToken extends __BaseException {
    readonly name: "InvalidNextToken";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidNextToken, __BaseException>);
}
export interface DescribeAssociationRequest {
    
    Name?: string;
    
    InstanceId?: string;
    
    AssociationId?: string;
    
    AssociationVersion?: string;
}
export declare namespace DescribeAssociationRequest {
    
    const filterSensitiveLog: (obj: DescribeAssociationRequest) => any;
}
export interface DescribeAssociationResult {
    
    AssociationDescription?: AssociationDescription;
}
export declare namespace DescribeAssociationResult {
    
    const filterSensitiveLog: (obj: DescribeAssociationResult) => any;
}

export declare class InvalidAssociationVersion extends __BaseException {
    readonly name: "InvalidAssociationVersion";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidAssociationVersion, __BaseException>);
}
export declare enum AssociationExecutionFilterKey {
    CreatedTime = "CreatedTime",
    ExecutionId = "ExecutionId",
    Status = "Status"
}
export declare enum AssociationFilterOperatorType {
    Equal = "EQUAL",
    GreaterThan = "GREATER_THAN",
    LessThan = "LESS_THAN"
}

export interface AssociationExecutionFilter {
    
    Key: AssociationExecutionFilterKey | string | undefined;
    
    Value: string | undefined;
    
    Type: AssociationFilterOperatorType | string | undefined;
}
export declare namespace AssociationExecutionFilter {
    
    const filterSensitiveLog: (obj: AssociationExecutionFilter) => any;
}
export interface DescribeAssociationExecutionsRequest {
    
    AssociationId: string | undefined;
    
    Filters?: AssociationExecutionFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeAssociationExecutionsRequest {
    
    const filterSensitiveLog: (obj: DescribeAssociationExecutionsRequest) => any;
}

export interface AssociationExecution {
    
    AssociationId?: string;
    
    AssociationVersion?: string;
    
    ExecutionId?: string;
    
    Status?: string;
    
    DetailedStatus?: string;
    
    CreatedTime?: Date;
    
    LastExecutionDate?: Date;
    
    ResourceCountByStatus?: string;
}
export declare namespace AssociationExecution {
    
    const filterSensitiveLog: (obj: AssociationExecution) => any;
}
export interface DescribeAssociationExecutionsResult {
    
    AssociationExecutions?: AssociationExecution[];
    
    NextToken?: string;
}
export declare namespace DescribeAssociationExecutionsResult {
    
    const filterSensitiveLog: (obj: DescribeAssociationExecutionsResult) => any;
}

export declare class AssociationExecutionDoesNotExist extends __BaseException {
    readonly name: "AssociationExecutionDoesNotExist";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<AssociationExecutionDoesNotExist, __BaseException>);
}
export declare enum AssociationExecutionTargetsFilterKey {
    ResourceId = "ResourceId",
    ResourceType = "ResourceType",
    Status = "Status"
}

export interface AssociationExecutionTargetsFilter {
    
    Key: AssociationExecutionTargetsFilterKey | string | undefined;
    
    Value: string | undefined;
}
export declare namespace AssociationExecutionTargetsFilter {
    
    const filterSensitiveLog: (obj: AssociationExecutionTargetsFilter) => any;
}
export interface DescribeAssociationExecutionTargetsRequest {
    
    AssociationId: string | undefined;
    
    ExecutionId: string | undefined;
    
    Filters?: AssociationExecutionTargetsFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeAssociationExecutionTargetsRequest {
    
    const filterSensitiveLog: (obj: DescribeAssociationExecutionTargetsRequest) => any;
}

export interface OutputSource {
    
    OutputSourceId?: string;
    
    OutputSourceType?: string;
}
export declare namespace OutputSource {
    
    const filterSensitiveLog: (obj: OutputSource) => any;
}

export interface AssociationExecutionTarget {
    
    AssociationId?: string;
    
    AssociationVersion?: string;
    
    ExecutionId?: string;
    
    ResourceId?: string;
    
    ResourceType?: string;
    
    Status?: string;
    
    DetailedStatus?: string;
    
    LastExecutionDate?: Date;
    
    OutputSource?: OutputSource;
}
export declare namespace AssociationExecutionTarget {
    
    const filterSensitiveLog: (obj: AssociationExecutionTarget) => any;
}
export interface DescribeAssociationExecutionTargetsResult {
    
    AssociationExecutionTargets?: AssociationExecutionTarget[];
    
    NextToken?: string;
}
export declare namespace DescribeAssociationExecutionTargetsResult {
    
    const filterSensitiveLog: (obj: DescribeAssociationExecutionTargetsResult) => any;
}
export declare enum AutomationExecutionFilterKey {
    AUTOMATION_SUBTYPE = "AutomationSubtype",
    AUTOMATION_TYPE = "AutomationType",
    CURRENT_ACTION = "CurrentAction",
    DOCUMENT_NAME_PREFIX = "DocumentNamePrefix",
    EXECUTION_ID = "ExecutionId",
    EXECUTION_STATUS = "ExecutionStatus",
    OPS_ITEM_ID = "OpsItemId",
    PARENT_EXECUTION_ID = "ParentExecutionId",
    START_TIME_AFTER = "StartTimeAfter",
    START_TIME_BEFORE = "StartTimeBefore",
    TAG_KEY = "TagKey",
    TARGET_RESOURCE_GROUP = "TargetResourceGroup"
}

export interface AutomationExecutionFilter {
    
    Key: AutomationExecutionFilterKey | string | undefined;
    
    Values: string[] | undefined;
}
export declare namespace AutomationExecutionFilter {
    
    const filterSensitiveLog: (obj: AutomationExecutionFilter) => any;
}
export interface DescribeAutomationExecutionsRequest {
    
    Filters?: AutomationExecutionFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeAutomationExecutionsRequest {
    
    const filterSensitiveLog: (obj: DescribeAutomationExecutionsRequest) => any;
}
export declare enum AutomationExecutionStatus {
    APPROVED = "Approved",
    CANCELLED = "Cancelled",
    CANCELLING = "Cancelling",
    CHANGE_CALENDAR_OVERRIDE_APPROVED = "ChangeCalendarOverrideApproved",
    CHANGE_CALENDAR_OVERRIDE_REJECTED = "ChangeCalendarOverrideRejected",
    COMPLETED_WITH_FAILURE = "CompletedWithFailure",
    COMPLETED_WITH_SUCCESS = "CompletedWithSuccess",
    FAILED = "Failed",
    INPROGRESS = "InProgress",
    PENDING = "Pending",
    PENDING_APPROVAL = "PendingApproval",
    PENDING_CHANGE_CALENDAR_OVERRIDE = "PendingChangeCalendarOverride",
    REJECTED = "Rejected",
    RUNBOOK_INPROGRESS = "RunbookInProgress",
    SCHEDULED = "Scheduled",
    SUCCESS = "Success",
    TIMEDOUT = "TimedOut",
    WAITING = "Waiting"
}
export declare enum AutomationSubtype {
    ChangeRequest = "ChangeRequest"
}
export declare enum AutomationType {
    CrossAccount = "CrossAccount",
    Local = "Local"
}
export declare enum ExecutionMode {
    Auto = "Auto",
    Interactive = "Interactive"
}

export interface ResolvedTargets {
    
    ParameterValues?: string[];
    
    Truncated?: boolean;
}
export declare namespace ResolvedTargets {
    
    const filterSensitiveLog: (obj: ResolvedTargets) => any;
}

export interface Runbook {
    
    DocumentName: string | undefined;
    
    DocumentVersion?: string;
    
    Parameters?: Record<string, string[]>;
    
    TargetParameterName?: string;
    
    Targets?: Target[];
    
    TargetMaps?: Record<string, string[]>[];
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    TargetLocations?: TargetLocation[];
}
export declare namespace Runbook {
    
    const filterSensitiveLog: (obj: Runbook) => any;
}

export interface AutomationExecutionMetadata {
    
    AutomationExecutionId?: string;
    
    DocumentName?: string;
    
    DocumentVersion?: string;
    
    AutomationExecutionStatus?: AutomationExecutionStatus | string;
    
    ExecutionStartTime?: Date;
    
    ExecutionEndTime?: Date;
    
    ExecutedBy?: string;
    
    LogFile?: string;
    
    Outputs?: Record<string, string[]>;
    
    Mode?: ExecutionMode | string;
    
    ParentAutomationExecutionId?: string;
    
    CurrentStepName?: string;
    
    CurrentAction?: string;
    
    FailureMessage?: string;
    
    TargetParameterName?: string;
    
    Targets?: Target[];
    
    TargetMaps?: Record<string, string[]>[];
    
    ResolvedTargets?: ResolvedTargets;
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    Target?: string;
    
    AutomationType?: AutomationType | string;
    
    AutomationSubtype?: AutomationSubtype | string;
    
    ScheduledTime?: Date;
    
    Runbooks?: Runbook[];
    
    OpsItemId?: string;
    
    AssociationId?: string;
    
    ChangeRequestName?: string;
}
export declare namespace AutomationExecutionMetadata {
    
    const filterSensitiveLog: (obj: AutomationExecutionMetadata) => any;
}
export interface DescribeAutomationExecutionsResult {
    
    AutomationExecutionMetadataList?: AutomationExecutionMetadata[];
    
    NextToken?: string;
}
export declare namespace DescribeAutomationExecutionsResult {
    
    const filterSensitiveLog: (obj: DescribeAutomationExecutionsResult) => any;
}

export declare class InvalidFilterKey extends __BaseException {
    readonly name: "InvalidFilterKey";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidFilterKey, __BaseException>);
}

export declare class InvalidFilterValue extends __BaseException {
    readonly name: "InvalidFilterValue";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidFilterValue, __BaseException>);
}

export declare class AutomationExecutionNotFoundException extends __BaseException {
    readonly name: "AutomationExecutionNotFoundException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<AutomationExecutionNotFoundException, __BaseException>);
}
export declare enum StepExecutionFilterKey {
    ACTION = "Action",
    START_TIME_AFTER = "StartTimeAfter",
    START_TIME_BEFORE = "StartTimeBefore",
    STEP_EXECUTION_ID = "StepExecutionId",
    STEP_EXECUTION_STATUS = "StepExecutionStatus",
    STEP_NAME = "StepName"
}

export interface StepExecutionFilter {
    
    Key: StepExecutionFilterKey | string | undefined;
    
    Values: string[] | undefined;
}
export declare namespace StepExecutionFilter {
    
    const filterSensitiveLog: (obj: StepExecutionFilter) => any;
}
export interface DescribeAutomationStepExecutionsRequest {
    
    AutomationExecutionId: string | undefined;
    
    Filters?: StepExecutionFilter[];
    
    NextToken?: string;
    
    MaxResults?: number;
    
    ReverseOrder?: boolean;
}
export declare namespace DescribeAutomationStepExecutionsRequest {
    
    const filterSensitiveLog: (obj: DescribeAutomationStepExecutionsRequest) => any;
}

export interface FailureDetails {
    
    FailureStage?: string;
    
    FailureType?: string;
    
    Details?: Record<string, string[]>;
}
export declare namespace FailureDetails {
    
    const filterSensitiveLog: (obj: FailureDetails) => any;
}

export interface StepExecution {
    
    StepName?: string;
    
    Action?: string;
    
    TimeoutSeconds?: number;
    
    OnFailure?: string;
    
    MaxAttempts?: number;
    
    ExecutionStartTime?: Date;
    
    ExecutionEndTime?: Date;
    
    StepStatus?: AutomationExecutionStatus | string;
    
    ResponseCode?: string;
    
    Inputs?: Record<string, string>;
    
    Outputs?: Record<string, string[]>;
    
    Response?: string;
    
    FailureMessage?: string;
    
    FailureDetails?: FailureDetails;
    
    StepExecutionId?: string;
    
    OverriddenParameters?: Record<string, string[]>;
    
    IsEnd?: boolean;
    
    NextStep?: string;
    
    IsCritical?: boolean;
    
    ValidNextSteps?: string[];
    
    Targets?: Target[];
    
    TargetLocation?: TargetLocation;
}
export declare namespace StepExecution {
    
    const filterSensitiveLog: (obj: StepExecution) => any;
}
export interface DescribeAutomationStepExecutionsResult {
    
    StepExecutions?: StepExecution[];
    
    NextToken?: string;
}
export declare namespace DescribeAutomationStepExecutionsResult {
    
    const filterSensitiveLog: (obj: DescribeAutomationStepExecutionsResult) => any;
}

export interface PatchOrchestratorFilter {
    
    Key?: string;
    
    Values?: string[];
}
export declare namespace PatchOrchestratorFilter {
    
    const filterSensitiveLog: (obj: PatchOrchestratorFilter) => any;
}
export interface DescribeAvailablePatchesRequest {
    
    Filters?: PatchOrchestratorFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeAvailablePatchesRequest {
    
    const filterSensitiveLog: (obj: DescribeAvailablePatchesRequest) => any;
}

export interface Patch {
    
    Id?: string;
    
    ReleaseDate?: Date;
    
    Title?: string;
    
    Description?: string;
    
    ContentUrl?: string;
    
    Vendor?: string;
    
    ProductFamily?: string;
    
    Product?: string;
    
    Classification?: string;
    
    MsrcSeverity?: string;
    
    KbNumber?: string;
    
    MsrcNumber?: string;
    
    Language?: string;
    
    AdvisoryIds?: string[];
    
    BugzillaIds?: string[];
    
    CVEIds?: string[];
    
    Name?: string;
    
    Epoch?: number;
    
    Version?: string;
    
    Release?: string;
    
    Arch?: string;
    
    Severity?: string;
    
    Repository?: string;
}
export declare namespace Patch {
    
    const filterSensitiveLog: (obj: Patch) => any;
}
export interface DescribeAvailablePatchesResult {
    
    Patches?: Patch[];
    
    NextToken?: string;
}
export declare namespace DescribeAvailablePatchesResult {
    
    const filterSensitiveLog: (obj: DescribeAvailablePatchesResult) => any;
}
export interface DescribeDocumentRequest {
    
    Name: string | undefined;
    
    DocumentVersion?: string;
    
    VersionName?: string;
}
export declare namespace DescribeDocumentRequest {
    
    const filterSensitiveLog: (obj: DescribeDocumentRequest) => any;
}
export interface DescribeDocumentResult {
    
    Document?: DocumentDescription;
}
export declare namespace DescribeDocumentResult {
    
    const filterSensitiveLog: (obj: DescribeDocumentResult) => any;
}
export declare enum DocumentPermissionType {
    SHARE = "Share"
}
export interface DescribeDocumentPermissionRequest {
    
    Name: string | undefined;
    
    PermissionType: DocumentPermissionType | string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeDocumentPermissionRequest {
    
    const filterSensitiveLog: (obj: DescribeDocumentPermissionRequest) => any;
}
export interface DescribeDocumentPermissionResponse {
    
    AccountIds?: string[];
    
    AccountSharingInfoList?: AccountSharingInfo[];
    
    NextToken?: string;
}
export declare namespace DescribeDocumentPermissionResponse {
    
    const filterSensitiveLog: (obj: DescribeDocumentPermissionResponse) => any;
}

export declare class InvalidPermissionType extends __BaseException {
    readonly name: "InvalidPermissionType";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidPermissionType, __BaseException>);
}
export interface DescribeEffectiveInstanceAssociationsRequest {
    
    InstanceId: string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeEffectiveInstanceAssociationsRequest {
    
    const filterSensitiveLog: (obj: DescribeEffectiveInstanceAssociationsRequest) => any;
}

export interface InstanceAssociation {
    
    AssociationId?: string;
    
    InstanceId?: string;
    
    Content?: string;
    
    AssociationVersion?: string;
}
export declare namespace InstanceAssociation {
    
    const filterSensitiveLog: (obj: InstanceAssociation) => any;
}
export interface DescribeEffectiveInstanceAssociationsResult {
    
    Associations?: InstanceAssociation[];
    
    NextToken?: string;
}
export declare namespace DescribeEffectiveInstanceAssociationsResult {
    
    const filterSensitiveLog: (obj: DescribeEffectiveInstanceAssociationsResult) => any;
}
export interface DescribeEffectivePatchesForPatchBaselineRequest {
    
    BaselineId: string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeEffectivePatchesForPatchBaselineRequest {
    
    const filterSensitiveLog: (obj: DescribeEffectivePatchesForPatchBaselineRequest) => any;
}
export declare enum PatchDeploymentStatus {
    Approved = "APPROVED",
    ExplicitApproved = "EXPLICIT_APPROVED",
    ExplicitRejected = "EXPLICIT_REJECTED",
    PendingApproval = "PENDING_APPROVAL"
}

export interface PatchStatus {
    
    DeploymentStatus?: PatchDeploymentStatus | string;
    
    ComplianceLevel?: PatchComplianceLevel | string;
    
    ApprovalDate?: Date;
}
export declare namespace PatchStatus {
    
    const filterSensitiveLog: (obj: PatchStatus) => any;
}

export interface EffectivePatch {
    
    Patch?: Patch;
    
    PatchStatus?: PatchStatus;
}
export declare namespace EffectivePatch {
    
    const filterSensitiveLog: (obj: EffectivePatch) => any;
}
export interface DescribeEffectivePatchesForPatchBaselineResult {
    
    EffectivePatches?: EffectivePatch[];
    
    NextToken?: string;
}
export declare namespace DescribeEffectivePatchesForPatchBaselineResult {
    
    const filterSensitiveLog: (obj: DescribeEffectivePatchesForPatchBaselineResult) => any;
}

export declare class UnsupportedOperatingSystem extends __BaseException {
    readonly name: "UnsupportedOperatingSystem";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<UnsupportedOperatingSystem, __BaseException>);
}
export interface DescribeInstanceAssociationsStatusRequest {
    
    InstanceId: string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeInstanceAssociationsStatusRequest {
    
    const filterSensitiveLog: (obj: DescribeInstanceAssociationsStatusRequest) => any;
}

export interface S3OutputUrl {
    
    OutputUrl?: string;
}
export declare namespace S3OutputUrl {
    
    const filterSensitiveLog: (obj: S3OutputUrl) => any;
}

export interface InstanceAssociationOutputUrl {
    
    S3OutputUrl?: S3OutputUrl;
}
export declare namespace InstanceAssociationOutputUrl {
    
    const filterSensitiveLog: (obj: InstanceAssociationOutputUrl) => any;
}

export interface InstanceAssociationStatusInfo {
    
    AssociationId?: string;
    
    Name?: string;
    
    DocumentVersion?: string;
    
    AssociationVersion?: string;
    
    InstanceId?: string;
    
    ExecutionDate?: Date;
    
    Status?: string;
    
    DetailedStatus?: string;
    
    ExecutionSummary?: string;
    
    ErrorCode?: string;
    
    OutputUrl?: InstanceAssociationOutputUrl;
    
    AssociationName?: string;
}
export declare namespace InstanceAssociationStatusInfo {
    
    const filterSensitiveLog: (obj: InstanceAssociationStatusInfo) => any;
}
export interface DescribeInstanceAssociationsStatusResult {
    
    InstanceAssociationStatusInfos?: InstanceAssociationStatusInfo[];
    
    NextToken?: string;
}
export declare namespace DescribeInstanceAssociationsStatusResult {
    
    const filterSensitiveLog: (obj: DescribeInstanceAssociationsStatusResult) => any;
}

export interface InstanceInformationStringFilter {
    
    Key: string | undefined;
    
    Values: string[] | undefined;
}
export declare namespace InstanceInformationStringFilter {
    
    const filterSensitiveLog: (obj: InstanceInformationStringFilter) => any;
}
export declare enum InstanceInformationFilterKey {
    ACTIVATION_IDS = "ActivationIds",
    AGENT_VERSION = "AgentVersion",
    ASSOCIATION_STATUS = "AssociationStatus",
    IAM_ROLE = "IamRole",
    INSTANCE_IDS = "InstanceIds",
    PING_STATUS = "PingStatus",
    PLATFORM_TYPES = "PlatformTypes",
    RESOURCE_TYPE = "ResourceType"
}

export interface InstanceInformationFilter {
    
    key: InstanceInformationFilterKey | string | undefined;
    
    valueSet: string[] | undefined;
}
export declare namespace InstanceInformationFilter {
    
    const filterSensitiveLog: (obj: InstanceInformationFilter) => any;
}
export interface DescribeInstanceInformationRequest {
    
    InstanceInformationFilterList?: InstanceInformationFilter[];
    
    Filters?: InstanceInformationStringFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeInstanceInformationRequest {
    
    const filterSensitiveLog: (obj: DescribeInstanceInformationRequest) => any;
}

export interface InstanceAggregatedAssociationOverview {
    
    DetailedStatus?: string;
    
    InstanceAssociationStatusAggregatedCount?: Record<string, number>;
}
export declare namespace InstanceAggregatedAssociationOverview {
    
    const filterSensitiveLog: (obj: InstanceAggregatedAssociationOverview) => any;
}
export declare enum PingStatus {
    CONNECTION_LOST = "ConnectionLost",
    INACTIVE = "Inactive",
    ONLINE = "Online"
}
export declare enum ResourceType {
    DOCUMENT = "Document",
    EC2_INSTANCE = "EC2Instance",
    MANAGED_INSTANCE = "ManagedInstance"
}
export declare enum SourceType {
    AWS_EC2_INSTANCE = "AWS::EC2::Instance",
    AWS_IOT_THING = "AWS::IoT::Thing",
    AWS_SSM_MANAGEDINSTANCE = "AWS::SSM::ManagedInstance"
}

export interface InstanceInformation {
    
    InstanceId?: string;
    
    PingStatus?: PingStatus | string;
    
    LastPingDateTime?: Date;
    
    AgentVersion?: string;
    
    IsLatestVersion?: boolean;
    
    PlatformType?: PlatformType | string;
    
    PlatformName?: string;
    
    PlatformVersion?: string;
    
    ActivationId?: string;
    
    IamRole?: string;
    
    RegistrationDate?: Date;
    
    ResourceType?: ResourceType | string;
    
    Name?: string;
    
    IPAddress?: string;
    
    ComputerName?: string;
    
    AssociationStatus?: string;
    
    LastAssociationExecutionDate?: Date;
    
    LastSuccessfulAssociationExecutionDate?: Date;
    
    AssociationOverview?: InstanceAggregatedAssociationOverview;
    
    SourceId?: string;
    
    SourceType?: SourceType | string;
}
export declare namespace InstanceInformation {
    
    const filterSensitiveLog: (obj: InstanceInformation) => any;
}
export interface DescribeInstanceInformationResult {
    
    InstanceInformationList?: InstanceInformation[];
    
    NextToken?: string;
}
export declare namespace DescribeInstanceInformationResult {
    
    const filterSensitiveLog: (obj: DescribeInstanceInformationResult) => any;
}

export declare class InvalidInstanceInformationFilterValue extends __BaseException {
    readonly name: "InvalidInstanceInformationFilterValue";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidInstanceInformationFilterValue, __BaseException>);
}
export interface DescribeInstancePatchesRequest {
    
    InstanceId: string | undefined;
    
    Filters?: PatchOrchestratorFilter[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeInstancePatchesRequest {
    
    const filterSensitiveLog: (obj: DescribeInstancePatchesRequest) => any;
}
export declare enum PatchComplianceDataState {
    Failed = "FAILED",
    Installed = "INSTALLED",
    InstalledOther = "INSTALLED_OTHER",
    InstalledPendingReboot = "INSTALLED_PENDING_REBOOT",
    InstalledRejected = "INSTALLED_REJECTED",
    Missing = "MISSING",
    NotApplicable = "NOT_APPLICABLE"
}

export interface PatchComplianceData {
    
    Title: string | undefined;
    
    KBId: string | undefined;
    
    Classification: string | undefined;
    
    Severity: string | undefined;
    
    State: PatchComplianceDataState | string | undefined;
    
    InstalledTime: Date | undefined;
    
    CVEIds?: string;
}
export declare namespace PatchComplianceData {
    
    const filterSensitiveLog: (obj: PatchComplianceData) => any;
}
export interface DescribeInstancePatchesResult {
    
    Patches?: PatchComplianceData[];
    
    NextToken?: string;
}
export declare namespace DescribeInstancePatchesResult {
    
    const filterSensitiveLog: (obj: DescribeInstancePatchesResult) => any;
}
export interface DescribeInstancePatchStatesRequest {
    
    InstanceIds: string[] | undefined;
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeInstancePatchStatesRequest {
    
    const filterSensitiveLog: (obj: DescribeInstancePatchStatesRequest) => any;
}
export declare enum PatchOperationType {
    INSTALL = "Install",
    SCAN = "Scan"
}
export declare enum RebootOption {
    NO_REBOOT = "NoReboot",
    REBOOT_IF_NEEDED = "RebootIfNeeded"
}

export interface InstancePatchState {
    
    InstanceId: string | undefined;
    
    PatchGroup: string | undefined;
    
    BaselineId: string | undefined;
    
    SnapshotId?: string;
    
    InstallOverrideList?: string;
    
    OwnerInformation?: string;
    
    InstalledCount?: number;
    
    InstalledOtherCount?: number;
    
    InstalledPendingRebootCount?: number;
    
    InstalledRejectedCount?: number;
    
    MissingCount?: number;
    
    FailedCount?: number;
    
    UnreportedNotApplicableCount?: number;
    
    NotApplicableCount?: number;
    
    OperationStartTime: Date | undefined;
    
    OperationEndTime: Date | undefined;
    
    Operation: PatchOperationType | string | undefined;
    
    LastNoRebootInstallOperationTime?: Date;
    
    RebootOption?: RebootOption | string;
    
    CriticalNonCompliantCount?: number;
    
    SecurityNonCompliantCount?: number;
    
    OtherNonCompliantCount?: number;
}
export declare namespace InstancePatchState {
    
    const filterSensitiveLog: (obj: InstancePatchState) => any;
}
export interface DescribeInstancePatchStatesResult {
    
    InstancePatchStates?: InstancePatchState[];
    
    NextToken?: string;
}
export declare namespace DescribeInstancePatchStatesResult {
    
    const filterSensitiveLog: (obj: DescribeInstancePatchStatesResult) => any;
}
export declare enum InstancePatchStateOperatorType {
    EQUAL = "Equal",
    GREATER_THAN = "GreaterThan",
    LESS_THAN = "LessThan",
    NOT_EQUAL = "NotEqual"
}

export interface InstancePatchStateFilter {
    
    Key: string | undefined;
    
    Values: string[] | undefined;
    
    Type: InstancePatchStateOperatorType | string | undefined;
}
export declare namespace InstancePatchStateFilter {
    
    const filterSensitiveLog: (obj: InstancePatchStateFilter) => any;
}
export interface DescribeInstancePatchStatesForPatchGroupRequest {
    
    PatchGroup: string | undefined;
    
    Filters?: InstancePatchStateFilter[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeInstancePatchStatesForPatchGroupRequest {
    
    const filterSensitiveLog: (obj: DescribeInstancePatchStatesForPatchGroupRequest) => any;
}
export interface DescribeInstancePatchStatesForPatchGroupResult {
    
    InstancePatchStates?: InstancePatchState[];
    
    NextToken?: string;
}
export declare namespace DescribeInstancePatchStatesForPatchGroupResult {
    
    const filterSensitiveLog: (obj: DescribeInstancePatchStatesForPatchGroupResult) => any;
}
export interface DescribeInventoryDeletionsRequest {
    
    DeletionId?: string;
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace DescribeInventoryDeletionsRequest {
    
    const filterSensitiveLog: (obj: DescribeInventoryDeletionsRequest) => any;
}
export declare enum InventoryDeletionStatus {
    COMPLETE = "Complete",
    IN_PROGRESS = "InProgress"
}

export interface InventoryDeletionStatusItem {
    
    DeletionId?: string;
    
    TypeName?: string;
    
    DeletionStartTime?: Date;
    
    LastStatus?: InventoryDeletionStatus | string;
    
    LastStatusMessage?: string;
    
    DeletionSummary?: InventoryDeletionSummary;
    
    LastStatusUpdateTime?: Date;
}
export declare namespace InventoryDeletionStatusItem {
    
    const filterSensitiveLog: (obj: InventoryDeletionStatusItem) => any;
}
export interface DescribeInventoryDeletionsResult {
    
    InventoryDeletions?: InventoryDeletionStatusItem[];
    
    NextToken?: string;
}
export declare namespace DescribeInventoryDeletionsResult {
    
    const filterSensitiveLog: (obj: DescribeInventoryDeletionsResult) => any;
}

export declare class InvalidDeletionIdException extends __BaseException {
    readonly name: "InvalidDeletionIdException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidDeletionIdException, __BaseException>);
}

export interface MaintenanceWindowFilter {
    
    Key?: string;
    
    Values?: string[];
}
export declare namespace MaintenanceWindowFilter {
    
    const filterSensitiveLog: (obj: MaintenanceWindowFilter) => any;
}
export interface DescribeMaintenanceWindowExecutionsRequest {
    
    WindowId: string | undefined;
    
    Filters?: MaintenanceWindowFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeMaintenanceWindowExecutionsRequest {
    
    const filterSensitiveLog: (obj: DescribeMaintenanceWindowExecutionsRequest) => any;
}
export declare enum MaintenanceWindowExecutionStatus {
    Cancelled = "CANCELLED",
    Cancelling = "CANCELLING",
    Failed = "FAILED",
    InProgress = "IN_PROGRESS",
    Pending = "PENDING",
    SkippedOverlapping = "SKIPPED_OVERLAPPING",
    Success = "SUCCESS",
    TimedOut = "TIMED_OUT"
}

export interface MaintenanceWindowExecution {
    
    WindowId?: string;
    
    WindowExecutionId?: string;
    
    Status?: MaintenanceWindowExecutionStatus | string;
    
    StatusDetails?: string;
    
    StartTime?: Date;
    
    EndTime?: Date;
}
export declare namespace MaintenanceWindowExecution {
    
    const filterSensitiveLog: (obj: MaintenanceWindowExecution) => any;
}
export interface DescribeMaintenanceWindowExecutionsResult {
    
    WindowExecutions?: MaintenanceWindowExecution[];
    
    NextToken?: string;
}
export declare namespace DescribeMaintenanceWindowExecutionsResult {
    
    const filterSensitiveLog: (obj: DescribeMaintenanceWindowExecutionsResult) => any;
}
export interface DescribeMaintenanceWindowExecutionTaskInvocationsRequest {
    
    WindowExecutionId: string | undefined;
    
    TaskId: string | undefined;
    
    Filters?: MaintenanceWindowFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeMaintenanceWindowExecutionTaskInvocationsRequest {
    
    const filterSensitiveLog: (obj: DescribeMaintenanceWindowExecutionTaskInvocationsRequest) => any;
}
export declare enum MaintenanceWindowTaskType {
    Automation = "AUTOMATION",
    Lambda = "LAMBDA",
    RunCommand = "RUN_COMMAND",
    StepFunctions = "STEP_FUNCTIONS"
}

export interface MaintenanceWindowExecutionTaskInvocationIdentity {
    
    WindowExecutionId?: string;
    
    TaskExecutionId?: string;
    
    InvocationId?: string;
    
    ExecutionId?: string;
    
    TaskType?: MaintenanceWindowTaskType | string;
    
    Parameters?: string;
    
    Status?: MaintenanceWindowExecutionStatus | string;
    
    StatusDetails?: string;
    
    StartTime?: Date;
    
    EndTime?: Date;
    
    OwnerInformation?: string;
    
    WindowTargetId?: string;
}
export declare namespace MaintenanceWindowExecutionTaskInvocationIdentity {
    
    const filterSensitiveLog: (obj: MaintenanceWindowExecutionTaskInvocationIdentity) => any;
}
export interface DescribeMaintenanceWindowExecutionTaskInvocationsResult {
    
    WindowExecutionTaskInvocationIdentities?: MaintenanceWindowExecutionTaskInvocationIdentity[];
    
    NextToken?: string;
}
export declare namespace DescribeMaintenanceWindowExecutionTaskInvocationsResult {
    
    const filterSensitiveLog: (obj: DescribeMaintenanceWindowExecutionTaskInvocationsResult) => any;
}
export interface DescribeMaintenanceWindowExecutionTasksRequest {
    
    WindowExecutionId: string | undefined;
    
    Filters?: MaintenanceWindowFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeMaintenanceWindowExecutionTasksRequest {
    
    const filterSensitiveLog: (obj: DescribeMaintenanceWindowExecutionTasksRequest) => any;
}

export interface MaintenanceWindowExecutionTaskIdentity {
    
    WindowExecutionId?: string;
    
    TaskExecutionId?: string;
    
    Status?: MaintenanceWindowExecutionStatus | string;
    
    StatusDetails?: string;
    
    StartTime?: Date;
    
    EndTime?: Date;
    
    TaskArn?: string;
    
    TaskType?: MaintenanceWindowTaskType | string;
}
export declare namespace MaintenanceWindowExecutionTaskIdentity {
    
    const filterSensitiveLog: (obj: MaintenanceWindowExecutionTaskIdentity) => any;
}
export interface DescribeMaintenanceWindowExecutionTasksResult {
    
    WindowExecutionTaskIdentities?: MaintenanceWindowExecutionTaskIdentity[];
    
    NextToken?: string;
}
export declare namespace DescribeMaintenanceWindowExecutionTasksResult {
    
    const filterSensitiveLog: (obj: DescribeMaintenanceWindowExecutionTasksResult) => any;
}
export interface DescribeMaintenanceWindowsRequest {
    
    Filters?: MaintenanceWindowFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeMaintenanceWindowsRequest {
    
    const filterSensitiveLog: (obj: DescribeMaintenanceWindowsRequest) => any;
}

export interface MaintenanceWindowIdentity {
    
    WindowId?: string;
    
    Name?: string;
    
    Description?: string;
    
    Enabled?: boolean;
    
    Duration?: number;
    
    Cutoff?: number;
    
    Schedule?: string;
    
    ScheduleTimezone?: string;
    
    ScheduleOffset?: number;
    
    EndDate?: string;
    
    StartDate?: string;
    
    NextExecutionTime?: string;
}
export declare namespace MaintenanceWindowIdentity {
    
    const filterSensitiveLog: (obj: MaintenanceWindowIdentity) => any;
}
export interface DescribeMaintenanceWindowsResult {
    
    WindowIdentities?: MaintenanceWindowIdentity[];
    
    NextToken?: string;
}
export declare namespace DescribeMaintenanceWindowsResult {
    
    const filterSensitiveLog: (obj: DescribeMaintenanceWindowsResult) => any;
}
export declare enum MaintenanceWindowResourceType {
    Instance = "INSTANCE",
    ResourceGroup = "RESOURCE_GROUP"
}
export interface DescribeMaintenanceWindowScheduleRequest {
    
    WindowId?: string;
    
    Targets?: Target[];
    
    ResourceType?: MaintenanceWindowResourceType | string;
    
    Filters?: PatchOrchestratorFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeMaintenanceWindowScheduleRequest {
    
    const filterSensitiveLog: (obj: DescribeMaintenanceWindowScheduleRequest) => any;
}

export interface ScheduledWindowExecution {
    
    WindowId?: string;
    
    Name?: string;
    
    ExecutionTime?: string;
}
export declare namespace ScheduledWindowExecution {
    
    const filterSensitiveLog: (obj: ScheduledWindowExecution) => any;
}
export interface DescribeMaintenanceWindowScheduleResult {
    
    ScheduledWindowExecutions?: ScheduledWindowExecution[];
    
    NextToken?: string;
}
export declare namespace DescribeMaintenanceWindowScheduleResult {
    
    const filterSensitiveLog: (obj: DescribeMaintenanceWindowScheduleResult) => any;
}
export interface DescribeMaintenanceWindowsForTargetRequest {
    
    Targets: Target[] | undefined;
    
    ResourceType: MaintenanceWindowResourceType | string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeMaintenanceWindowsForTargetRequest {
    
    const filterSensitiveLog: (obj: DescribeMaintenanceWindowsForTargetRequest) => any;
}

export interface MaintenanceWindowIdentityForTarget {
    
    WindowId?: string;
    
    Name?: string;
}
export declare namespace MaintenanceWindowIdentityForTarget {
    
    const filterSensitiveLog: (obj: MaintenanceWindowIdentityForTarget) => any;
}
export interface DescribeMaintenanceWindowsForTargetResult {
    
    WindowIdentities?: MaintenanceWindowIdentityForTarget[];
    
    NextToken?: string;
}
export declare namespace DescribeMaintenanceWindowsForTargetResult {
    
    const filterSensitiveLog: (obj: DescribeMaintenanceWindowsForTargetResult) => any;
}
export interface DescribeMaintenanceWindowTargetsRequest {
    
    WindowId: string | undefined;
    
    Filters?: MaintenanceWindowFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeMaintenanceWindowTargetsRequest {
    
    const filterSensitiveLog: (obj: DescribeMaintenanceWindowTargetsRequest) => any;
}

export interface MaintenanceWindowTarget {
    
    WindowId?: string;
    
    WindowTargetId?: string;
    
    ResourceType?: MaintenanceWindowResourceType | string;
    
    Targets?: Target[];
    
    OwnerInformation?: string;
    
    Name?: string;
    
    Description?: string;
}
export declare namespace MaintenanceWindowTarget {
    
    const filterSensitiveLog: (obj: MaintenanceWindowTarget) => any;
}
export interface DescribeMaintenanceWindowTargetsResult {
    
    Targets?: MaintenanceWindowTarget[];
    
    NextToken?: string;
}
export declare namespace DescribeMaintenanceWindowTargetsResult {
    
    const filterSensitiveLog: (obj: DescribeMaintenanceWindowTargetsResult) => any;
}
export interface DescribeMaintenanceWindowTasksRequest {
    
    WindowId: string | undefined;
    
    Filters?: MaintenanceWindowFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeMaintenanceWindowTasksRequest {
    
    const filterSensitiveLog: (obj: DescribeMaintenanceWindowTasksRequest) => any;
}
export declare enum MaintenanceWindowTaskCutoffBehavior {
    CancelTask = "CANCEL_TASK",
    ContinueTask = "CONTINUE_TASK"
}

export interface LoggingInfo {
    
    S3BucketName: string | undefined;
    
    S3KeyPrefix?: string;
    
    S3Region: string | undefined;
}
export declare namespace LoggingInfo {
    
    const filterSensitiveLog: (obj: LoggingInfo) => any;
}

export interface MaintenanceWindowTaskParameterValueExpression {
    
    Values?: string[];
}
export declare namespace MaintenanceWindowTaskParameterValueExpression {
    
    const filterSensitiveLog: (obj: MaintenanceWindowTaskParameterValueExpression) => any;
}

export interface MaintenanceWindowTask {
    
    WindowId?: string;
    
    WindowTaskId?: string;
    
    TaskArn?: string;
    
    Type?: MaintenanceWindowTaskType | string;
    
    Targets?: Target[];
    
    TaskParameters?: Record<string, MaintenanceWindowTaskParameterValueExpression>;
    
    Priority?: number;
    
    LoggingInfo?: LoggingInfo;
    
    ServiceRoleArn?: string;
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    Name?: string;
    
    Description?: string;
    
    CutoffBehavior?: MaintenanceWindowTaskCutoffBehavior | string;
}
export declare namespace MaintenanceWindowTask {
    
    const filterSensitiveLog: (obj: MaintenanceWindowTask) => any;
}
export interface DescribeMaintenanceWindowTasksResult {
    
    Tasks?: MaintenanceWindowTask[];
    
    NextToken?: string;
}
export declare namespace DescribeMaintenanceWindowTasksResult {
    
    const filterSensitiveLog: (obj: DescribeMaintenanceWindowTasksResult) => any;
}
export declare enum OpsItemFilterKey {
    ACTUAL_END_TIME = "ActualEndTime",
    ACTUAL_START_TIME = "ActualStartTime",
    AUTOMATION_ID = "AutomationId",
    CATEGORY = "Category",
    CHANGE_REQUEST_APPROVER_ARN = "ChangeRequestByApproverArn",
    CHANGE_REQUEST_APPROVER_NAME = "ChangeRequestByApproverName",
    CHANGE_REQUEST_REQUESTER_ARN = "ChangeRequestByRequesterArn",
    CHANGE_REQUEST_REQUESTER_NAME = "ChangeRequestByRequesterName",
    CHANGE_REQUEST_TARGETS_RESOURCE_GROUP = "ChangeRequestByTargetsResourceGroup",
    CHANGE_REQUEST_TEMPLATE = "ChangeRequestByTemplate",
    CREATED_BY = "CreatedBy",
    CREATED_TIME = "CreatedTime",
    INSIGHT_TYPE = "InsightByType",
    LAST_MODIFIED_TIME = "LastModifiedTime",
    OPERATIONAL_DATA = "OperationalData",
    OPERATIONAL_DATA_KEY = "OperationalDataKey",
    OPERATIONAL_DATA_VALUE = "OperationalDataValue",
    OPSITEM_ID = "OpsItemId",
    OPSITEM_TYPE = "OpsItemType",
    PLANNED_END_TIME = "PlannedEndTime",
    PLANNED_START_TIME = "PlannedStartTime",
    PRIORITY = "Priority",
    RESOURCE_ID = "ResourceId",
    SEVERITY = "Severity",
    SOURCE = "Source",
    STATUS = "Status",
    TITLE = "Title"
}
export declare enum OpsItemFilterOperator {
    CONTAINS = "Contains",
    EQUAL = "Equal",
    GREATER_THAN = "GreaterThan",
    LESS_THAN = "LessThan"
}

export interface OpsItemFilter {
    
    Key: OpsItemFilterKey | string | undefined;
    
    Values: string[] | undefined;
    
    Operator: OpsItemFilterOperator | string | undefined;
}
export declare namespace OpsItemFilter {
    
    const filterSensitiveLog: (obj: OpsItemFilter) => any;
}
export interface DescribeOpsItemsRequest {
    
    OpsItemFilters?: OpsItemFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeOpsItemsRequest {
    
    const filterSensitiveLog: (obj: DescribeOpsItemsRequest) => any;
}
export declare enum OpsItemStatus {
    APPROVED = "Approved",
    CANCELLED = "Cancelled",
    CANCELLING = "Cancelling",
    CHANGE_CALENDAR_OVERRIDE_APPROVED = "ChangeCalendarOverrideApproved",
    CHANGE_CALENDAR_OVERRIDE_REJECTED = "ChangeCalendarOverrideRejected",
    CLOSED = "Closed",
    COMPLETED_WITH_FAILURE = "CompletedWithFailure",
    COMPLETED_WITH_SUCCESS = "CompletedWithSuccess",
    FAILED = "Failed",
    IN_PROGRESS = "InProgress",
    OPEN = "Open",
    PENDING = "Pending",
    PENDING_APPROVAL = "PendingApproval",
    PENDING_CHANGE_CALENDAR_OVERRIDE = "PendingChangeCalendarOverride",
    REJECTED = "Rejected",
    RESOLVED = "Resolved",
    RUNBOOK_IN_PROGRESS = "RunbookInProgress",
    SCHEDULED = "Scheduled",
    TIMED_OUT = "TimedOut"
}

export interface OpsItemSummary {
    
    CreatedBy?: string;
    
    CreatedTime?: Date;
    
    LastModifiedBy?: string;
    
    LastModifiedTime?: Date;
    
    Priority?: number;
    
    Source?: string;
    
    Status?: OpsItemStatus | string;
    
    OpsItemId?: string;
    
    Title?: string;
    
    OperationalData?: Record<string, OpsItemDataValue>;
    
    Category?: string;
    
    Severity?: string;
    
    OpsItemType?: string;
    
    ActualStartTime?: Date;
    
    ActualEndTime?: Date;
    
    PlannedStartTime?: Date;
    
    PlannedEndTime?: Date;
}
export declare namespace OpsItemSummary {
    
    const filterSensitiveLog: (obj: OpsItemSummary) => any;
}
export interface DescribeOpsItemsResponse {
    
    NextToken?: string;
    
    OpsItemSummaries?: OpsItemSummary[];
}
export declare namespace DescribeOpsItemsResponse {
    
    const filterSensitiveLog: (obj: DescribeOpsItemsResponse) => any;
}
export declare enum ParametersFilterKey {
    KEY_ID = "KeyId",
    NAME = "Name",
    TYPE = "Type"
}

export interface ParametersFilter {
    
    Key: ParametersFilterKey | string | undefined;
    
    Values: string[] | undefined;
}
export declare namespace ParametersFilter {
    
    const filterSensitiveLog: (obj: ParametersFilter) => any;
}

export interface ParameterStringFilter {
    
    Key: string | undefined;
    
    Option?: string;
    
    Values?: string[];
}
export declare namespace ParameterStringFilter {
    
    const filterSensitiveLog: (obj: ParameterStringFilter) => any;
}
export interface DescribeParametersRequest {
    
    Filters?: ParametersFilter[];
    
    ParameterFilters?: ParameterStringFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribeParametersRequest {
    
    const filterSensitiveLog: (obj: DescribeParametersRequest) => any;
}

export interface ParameterInlinePolicy {
    
    PolicyText?: string;
    
    PolicyType?: string;
    
    PolicyStatus?: string;
}
export declare namespace ParameterInlinePolicy {
    
    const filterSensitiveLog: (obj: ParameterInlinePolicy) => any;
}
