import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { AssociationComplianceSeverity, AssociationDescription, AssociationOverview, AssociationStatus, AssociationSyncCompliance, AttachmentsSource, AutomationExecutionStatus, AutomationSubtype, DocumentDescription, DocumentFormat, DocumentHashType, DocumentPermissionType, DocumentRequires, DocumentStatus, DocumentType, ExecutionMode, InstanceAssociationOutputLocation, LoggingInfo, MaintenanceWindowExecutionStatus, MaintenanceWindowResourceType, MaintenanceWindowTaskCutoffBehavior, MaintenanceWindowTaskParameterValueExpression, MaintenanceWindowTaskType, MetadataValue, OperatingSystem, OpsItemDataValue, OpsItemNotification, OpsItemStatus, ParameterInlinePolicy, ParameterStringFilter, PatchAction, PatchComplianceLevel, PatchFilterGroup, PatchOrchestratorFilter, PatchRuleGroup, PatchSource, PlatformType, RelatedOpsItem, ResolvedTargets, ResourceDataSyncAwsOrganizationsSource, ResourceDataSyncS3Destination, ResourceTypeForTagging, ReviewStatus, Runbook, StepExecution, Tag, Target, TargetLocation } from "./models_0";
import { SSMServiceException as __BaseException } from "./SSMServiceException";
export declare enum ParameterTier {
    ADVANCED = "Advanced",
    INTELLIGENT_TIERING = "Intelligent-Tiering",
    STANDARD = "Standard"
}
export declare enum ParameterType {
    SECURE_STRING = "SecureString",
    STRING = "String",
    STRING_LIST = "StringList"
}

export interface ParameterMetadata {
    
    Name?: string;
    
    Type?: ParameterType | string;
    
    KeyId?: string;
    
    LastModifiedDate?: Date;
    
    LastModifiedUser?: string;
    
    Description?: string;
    
    AllowedPattern?: string;
    
    Version?: number;
    
    Tier?: ParameterTier | string;
    
    Policies?: ParameterInlinePolicy[];
    
    DataType?: string;
}
export declare namespace ParameterMetadata {
    
    const filterSensitiveLog: (obj: ParameterMetadata) => any;
}
export interface DescribeParametersResult {
    
    Parameters?: ParameterMetadata[];
    
    NextToken?: string;
}
export declare namespace DescribeParametersResult {
    
    const filterSensitiveLog: (obj: DescribeParametersResult) => any;
}

export declare class InvalidFilterOption extends __BaseException {
    readonly name: "InvalidFilterOption";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidFilterOption, __BaseException>);
}
export interface DescribePatchBaselinesRequest {
    
    Filters?: PatchOrchestratorFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribePatchBaselinesRequest {
    
    const filterSensitiveLog: (obj: DescribePatchBaselinesRequest) => any;
}

export interface PatchBaselineIdentity {
    
    BaselineId?: string;
    
    BaselineName?: string;
    
    OperatingSystem?: OperatingSystem | string;
    
    BaselineDescription?: string;
    
    DefaultBaseline?: boolean;
}
export declare namespace PatchBaselineIdentity {
    
    const filterSensitiveLog: (obj: PatchBaselineIdentity) => any;
}
export interface DescribePatchBaselinesResult {
    
    BaselineIdentities?: PatchBaselineIdentity[];
    
    NextToken?: string;
}
export declare namespace DescribePatchBaselinesResult {
    
    const filterSensitiveLog: (obj: DescribePatchBaselinesResult) => any;
}
export interface DescribePatchGroupsRequest {
    
    MaxResults?: number;
    
    Filters?: PatchOrchestratorFilter[];
    
    NextToken?: string;
}
export declare namespace DescribePatchGroupsRequest {
    
    const filterSensitiveLog: (obj: DescribePatchGroupsRequest) => any;
}

export interface PatchGroupPatchBaselineMapping {
    
    PatchGroup?: string;
    
    BaselineIdentity?: PatchBaselineIdentity;
}
export declare namespace PatchGroupPatchBaselineMapping {
    
    const filterSensitiveLog: (obj: PatchGroupPatchBaselineMapping) => any;
}
export interface DescribePatchGroupsResult {
    
    Mappings?: PatchGroupPatchBaselineMapping[];
    
    NextToken?: string;
}
export declare namespace DescribePatchGroupsResult {
    
    const filterSensitiveLog: (obj: DescribePatchGroupsResult) => any;
}
export interface DescribePatchGroupStateRequest {
    
    PatchGroup: string | undefined;
}
export declare namespace DescribePatchGroupStateRequest {
    
    const filterSensitiveLog: (obj: DescribePatchGroupStateRequest) => any;
}
export interface DescribePatchGroupStateResult {
    
    Instances?: number;
    
    InstancesWithInstalledPatches?: number;
    
    InstancesWithInstalledOtherPatches?: number;
    
    InstancesWithInstalledPendingRebootPatches?: number;
    
    InstancesWithInstalledRejectedPatches?: number;
    
    InstancesWithMissingPatches?: number;
    
    InstancesWithFailedPatches?: number;
    
    InstancesWithNotApplicablePatches?: number;
    
    InstancesWithUnreportedNotApplicablePatches?: number;
    
    InstancesWithCriticalNonCompliantPatches?: number;
    
    InstancesWithSecurityNonCompliantPatches?: number;
    
    InstancesWithOtherNonCompliantPatches?: number;
}
export declare namespace DescribePatchGroupStateResult {
    
    const filterSensitiveLog: (obj: DescribePatchGroupStateResult) => any;
}
export declare enum PatchSet {
    Application = "APPLICATION",
    Os = "OS"
}
export declare enum PatchProperty {
    PatchClassification = "CLASSIFICATION",
    PatchMsrcSeverity = "MSRC_SEVERITY",
    PatchPriority = "PRIORITY",
    PatchProductFamily = "PRODUCT_FAMILY",
    PatchSeverity = "SEVERITY",
    Product = "PRODUCT"
}
export interface DescribePatchPropertiesRequest {
    
    OperatingSystem: OperatingSystem | string | undefined;
    
    Property: PatchProperty | string | undefined;
    
    PatchSet?: PatchSet | string;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace DescribePatchPropertiesRequest {
    
    const filterSensitiveLog: (obj: DescribePatchPropertiesRequest) => any;
}
export interface DescribePatchPropertiesResult {
    
    Properties?: Record<string, string>[];
    
    NextToken?: string;
}
export declare namespace DescribePatchPropertiesResult {
    
    const filterSensitiveLog: (obj: DescribePatchPropertiesResult) => any;
}
export declare enum SessionFilterKey {
    INVOKED_AFTER = "InvokedAfter",
    INVOKED_BEFORE = "InvokedBefore",
    OWNER = "Owner",
    SESSION_ID = "SessionId",
    STATUS = "Status",
    TARGET_ID = "Target"
}

export interface SessionFilter {
    
    key: SessionFilterKey | string | undefined;
    
    value: string | undefined;
}
export declare namespace SessionFilter {
    
    const filterSensitiveLog: (obj: SessionFilter) => any;
}
export declare enum SessionState {
    ACTIVE = "Active",
    HISTORY = "History"
}
export interface DescribeSessionsRequest {
    
    State: SessionState | string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
    
    Filters?: SessionFilter[];
}
export declare namespace DescribeSessionsRequest {
    
    const filterSensitiveLog: (obj: DescribeSessionsRequest) => any;
}

export interface SessionManagerOutputUrl {
    
    S3OutputUrl?: string;
    
    CloudWatchOutputUrl?: string;
}
export declare namespace SessionManagerOutputUrl {
    
    const filterSensitiveLog: (obj: SessionManagerOutputUrl) => any;
}
export declare enum SessionStatus {
    CONNECTED = "Connected",
    CONNECTING = "Connecting",
    DISCONNECTED = "Disconnected",
    FAILED = "Failed",
    TERMINATED = "Terminated",
    TERMINATING = "Terminating"
}

export interface Session {
    
    SessionId?: string;
    
    Target?: string;
    
    Status?: SessionStatus | string;
    
    StartDate?: Date;
    
    EndDate?: Date;
    
    DocumentName?: string;
    
    Owner?: string;
    
    Reason?: string;
    
    Details?: string;
    
    OutputUrl?: SessionManagerOutputUrl;
    
    MaxSessionDuration?: string;
}
export declare namespace Session {
    
    const filterSensitiveLog: (obj: Session) => any;
}
export interface DescribeSessionsResponse {
    
    Sessions?: Session[];
    
    NextToken?: string;
}
export declare namespace DescribeSessionsResponse {
    
    const filterSensitiveLog: (obj: DescribeSessionsResponse) => any;
}
export interface DisassociateOpsItemRelatedItemRequest {
    
    OpsItemId: string | undefined;
    
    AssociationId: string | undefined;
}
export declare namespace DisassociateOpsItemRelatedItemRequest {
    
    const filterSensitiveLog: (obj: DisassociateOpsItemRelatedItemRequest) => any;
}
export interface DisassociateOpsItemRelatedItemResponse {
}
export declare namespace DisassociateOpsItemRelatedItemResponse {
    
    const filterSensitiveLog: (obj: DisassociateOpsItemRelatedItemResponse) => any;
}

export declare class OpsItemRelatedItemAssociationNotFoundException extends __BaseException {
    readonly name: "OpsItemRelatedItemAssociationNotFoundException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<OpsItemRelatedItemAssociationNotFoundException, __BaseException>);
}
export interface GetAutomationExecutionRequest {
    
    AutomationExecutionId: string | undefined;
}
export declare namespace GetAutomationExecutionRequest {
    
    const filterSensitiveLog: (obj: GetAutomationExecutionRequest) => any;
}

export interface ProgressCounters {
    
    TotalSteps?: number;
    
    SuccessSteps?: number;
    
    FailedSteps?: number;
    
    CancelledSteps?: number;
    
    TimedOutSteps?: number;
}
export declare namespace ProgressCounters {
    
    const filterSensitiveLog: (obj: ProgressCounters) => any;
}

export interface AutomationExecution {
    
    AutomationExecutionId?: string;
    
    DocumentName?: string;
    
    DocumentVersion?: string;
    
    ExecutionStartTime?: Date;
    
    ExecutionEndTime?: Date;
    
    AutomationExecutionStatus?: AutomationExecutionStatus | string;
    
    StepExecutions?: StepExecution[];
    
    StepExecutionsTruncated?: boolean;
    
    Parameters?: Record<string, string[]>;
    
    Outputs?: Record<string, string[]>;
    
    FailureMessage?: string;
    
    Mode?: ExecutionMode | string;
    
    ParentAutomationExecutionId?: string;
    
    ExecutedBy?: string;
    
    CurrentStepName?: string;
    
    CurrentAction?: string;
    
    TargetParameterName?: string;
    
    Targets?: Target[];
    
    TargetMaps?: Record<string, string[]>[];
    
    ResolvedTargets?: ResolvedTargets;
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    Target?: string;
    
    TargetLocations?: TargetLocation[];
    
    ProgressCounters?: ProgressCounters;
    
    AutomationSubtype?: AutomationSubtype | string;
    
    ScheduledTime?: Date;
    
    Runbooks?: Runbook[];
    
    OpsItemId?: string;
    
    AssociationId?: string;
    
    ChangeRequestName?: string;
}
export declare namespace AutomationExecution {
    
    const filterSensitiveLog: (obj: AutomationExecution) => any;
}
export interface GetAutomationExecutionResult {
    
    AutomationExecution?: AutomationExecution;
}
export declare namespace GetAutomationExecutionResult {
    
    const filterSensitiveLog: (obj: GetAutomationExecutionResult) => any;
}
export interface GetCalendarStateRequest {
    
    CalendarNames: string[] | undefined;
    
    AtTime?: string;
}
export declare namespace GetCalendarStateRequest {
    
    const filterSensitiveLog: (obj: GetCalendarStateRequest) => any;
}
export declare enum CalendarState {
    CLOSED = "CLOSED",
    OPEN = "OPEN"
}
export interface GetCalendarStateResponse {
    
    State?: CalendarState | string;
    
    AtTime?: string;
    
    NextTransitionTime?: string;
}
export declare namespace GetCalendarStateResponse {
    
    const filterSensitiveLog: (obj: GetCalendarStateResponse) => any;
}

export declare class InvalidDocumentType extends __BaseException {
    readonly name: "InvalidDocumentType";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidDocumentType, __BaseException>);
}

export declare class UnsupportedCalendarException extends __BaseException {
    readonly name: "UnsupportedCalendarException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<UnsupportedCalendarException, __BaseException>);
}
export interface GetCommandInvocationRequest {
    
    CommandId: string | undefined;
    
    InstanceId: string | undefined;
    
    PluginName?: string;
}
export declare namespace GetCommandInvocationRequest {
    
    const filterSensitiveLog: (obj: GetCommandInvocationRequest) => any;
}

export interface CloudWatchOutputConfig {
    
    CloudWatchLogGroupName?: string;
    
    CloudWatchOutputEnabled?: boolean;
}
export declare namespace CloudWatchOutputConfig {
    
    const filterSensitiveLog: (obj: CloudWatchOutputConfig) => any;
}
export declare enum CommandInvocationStatus {
    CANCELLED = "Cancelled",
    CANCELLING = "Cancelling",
    DELAYED = "Delayed",
    FAILED = "Failed",
    IN_PROGRESS = "InProgress",
    PENDING = "Pending",
    SUCCESS = "Success",
    TIMED_OUT = "TimedOut"
}
export interface GetCommandInvocationResult {
    
    CommandId?: string;
    
    InstanceId?: string;
    
    Comment?: string;
    
    DocumentName?: string;
    
    DocumentVersion?: string;
    
    PluginName?: string;
    
    ResponseCode?: number;
    
    ExecutionStartDateTime?: string;
    
    ExecutionElapsedTime?: string;
    
    ExecutionEndDateTime?: string;
    
    Status?: CommandInvocationStatus | string;
    
    StatusDetails?: string;
    
    StandardOutputContent?: string;
    
    StandardOutputUrl?: string;
    
    StandardErrorContent?: string;
    
    StandardErrorUrl?: string;
    
    CloudWatchOutputConfig?: CloudWatchOutputConfig;
}
export declare namespace GetCommandInvocationResult {
    
    const filterSensitiveLog: (obj: GetCommandInvocationResult) => any;
}

export declare class InvalidPluginName extends __BaseException {
    readonly name: "InvalidPluginName";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidPluginName, __BaseException>);
}

export declare class InvocationDoesNotExist extends __BaseException {
    readonly name: "InvocationDoesNotExist";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvocationDoesNotExist, __BaseException>);
}
export interface GetConnectionStatusRequest {
    
    Target: string | undefined;
}
export declare namespace GetConnectionStatusRequest {
    
    const filterSensitiveLog: (obj: GetConnectionStatusRequest) => any;
}
export declare enum ConnectionStatus {
    CONNECTED = "Connected",
    NOT_CONNECTED = "NotConnected"
}
export interface GetConnectionStatusResponse {
    
    Target?: string;
    
    Status?: ConnectionStatus | string;
}
export declare namespace GetConnectionStatusResponse {
    
    const filterSensitiveLog: (obj: GetConnectionStatusResponse) => any;
}
export interface GetDefaultPatchBaselineRequest {
    
    OperatingSystem?: OperatingSystem | string;
}
export declare namespace GetDefaultPatchBaselineRequest {
    
    const filterSensitiveLog: (obj: GetDefaultPatchBaselineRequest) => any;
}
export interface GetDefaultPatchBaselineResult {
    
    BaselineId?: string;
    
    OperatingSystem?: OperatingSystem | string;
}
export declare namespace GetDefaultPatchBaselineResult {
    
    const filterSensitiveLog: (obj: GetDefaultPatchBaselineResult) => any;
}

export interface BaselineOverride {
    
    OperatingSystem?: OperatingSystem | string;
    
    GlobalFilters?: PatchFilterGroup;
    
    ApprovalRules?: PatchRuleGroup;
    
    ApprovedPatches?: string[];
    
    ApprovedPatchesComplianceLevel?: PatchComplianceLevel | string;
    
    RejectedPatches?: string[];
    
    RejectedPatchesAction?: PatchAction | string;
    
    ApprovedPatchesEnableNonSecurity?: boolean;
    
    Sources?: PatchSource[];
}
export declare namespace BaselineOverride {
    
    const filterSensitiveLog: (obj: BaselineOverride) => any;
}
export interface GetDeployablePatchSnapshotForInstanceRequest {
    
    InstanceId: string | undefined;
    
    SnapshotId: string | undefined;
    
    BaselineOverride?: BaselineOverride;
}
export declare namespace GetDeployablePatchSnapshotForInstanceRequest {
    
    const filterSensitiveLog: (obj: GetDeployablePatchSnapshotForInstanceRequest) => any;
}
export interface GetDeployablePatchSnapshotForInstanceResult {
    
    InstanceId?: string;
    
    SnapshotId?: string;
    
    SnapshotDownloadUrl?: string;
    
    Product?: string;
}
export declare namespace GetDeployablePatchSnapshotForInstanceResult {
    
    const filterSensitiveLog: (obj: GetDeployablePatchSnapshotForInstanceResult) => any;
}

export declare class UnsupportedFeatureRequiredException extends __BaseException {
    readonly name: "UnsupportedFeatureRequiredException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<UnsupportedFeatureRequiredException, __BaseException>);
}
export interface GetDocumentRequest {
    
    Name: string | undefined;
    
    VersionName?: string;
    
    DocumentVersion?: string;
    
    DocumentFormat?: DocumentFormat | string;
}
export declare namespace GetDocumentRequest {
    
    const filterSensitiveLog: (obj: GetDocumentRequest) => any;
}
export declare enum AttachmentHashType {
    SHA256 = "Sha256"
}

export interface AttachmentContent {
    
    Name?: string;
    
    Size?: number;
    
    Hash?: string;
    
    HashType?: AttachmentHashType | string;
    
    Url?: string;
}
export declare namespace AttachmentContent {
    
    const filterSensitiveLog: (obj: AttachmentContent) => any;
}
export interface GetDocumentResult {
    
    Name?: string;
    
    CreatedDate?: Date;
    
    DisplayName?: string;
    
    VersionName?: string;
    
    DocumentVersion?: string;
    
    Status?: DocumentStatus | string;
    
    StatusInformation?: string;
    
    Content?: string;
    
    DocumentType?: DocumentType | string;
    
    DocumentFormat?: DocumentFormat | string;
    
    Requires?: DocumentRequires[];
    
    AttachmentsContent?: AttachmentContent[];
    
    ReviewStatus?: ReviewStatus | string;
}
export declare namespace GetDocumentResult {
    
    const filterSensitiveLog: (obj: GetDocumentResult) => any;
}
export declare enum InventoryQueryOperatorType {
    BEGIN_WITH = "BeginWith",
    EQUAL = "Equal",
    EXISTS = "Exists",
    GREATER_THAN = "GreaterThan",
    LESS_THAN = "LessThan",
    NOT_EQUAL = "NotEqual"
}

export interface InventoryFilter {
    
    Key: string | undefined;
    
    Values: string[] | undefined;
    
    Type?: InventoryQueryOperatorType | string;
}
export declare namespace InventoryFilter {
    
    const filterSensitiveLog: (obj: InventoryFilter) => any;
}

export interface InventoryGroup {
    
    Name: string | undefined;
    
    Filters: InventoryFilter[] | undefined;
}
export declare namespace InventoryGroup {
    
    const filterSensitiveLog: (obj: InventoryGroup) => any;
}

export interface ResultAttribute {
    
    TypeName: string | undefined;
}
export declare namespace ResultAttribute {
    
    const filterSensitiveLog: (obj: ResultAttribute) => any;
}

export interface InventoryResultItem {
    
    TypeName: string | undefined;
    
    SchemaVersion: string | undefined;
    
    CaptureTime?: string;
    
    ContentHash?: string;
    
    Content: Record<string, string>[] | undefined;
}
export declare namespace InventoryResultItem {
    
    const filterSensitiveLog: (obj: InventoryResultItem) => any;
}

export interface InventoryResultEntity {
    
    Id?: string;
    
    Data?: Record<string, InventoryResultItem>;
}
export declare namespace InventoryResultEntity {
    
    const filterSensitiveLog: (obj: InventoryResultEntity) => any;
}
export interface GetInventoryResult {
    
    Entities?: InventoryResultEntity[];
    
    NextToken?: string;
}
export declare namespace GetInventoryResult {
    
    const filterSensitiveLog: (obj: GetInventoryResult) => any;
}

export declare class InvalidAggregatorException extends __BaseException {
    readonly name: "InvalidAggregatorException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidAggregatorException, __BaseException>);
}

export declare class InvalidInventoryGroupException extends __BaseException {
    readonly name: "InvalidInventoryGroupException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidInventoryGroupException, __BaseException>);
}

export declare class InvalidResultAttributeException extends __BaseException {
    readonly name: "InvalidResultAttributeException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidResultAttributeException, __BaseException>);
}
export interface GetInventorySchemaRequest {
    
    TypeName?: string;
    
    NextToken?: string;
    
    MaxResults?: number;
    
    Aggregator?: boolean;
    
    SubType?: boolean;
}
export declare namespace GetInventorySchemaRequest {
    
    const filterSensitiveLog: (obj: GetInventorySchemaRequest) => any;
}
export declare enum InventoryAttributeDataType {
    NUMBER = "number",
    STRING = "string"
}

export interface InventoryItemAttribute {
    
    Name: string | undefined;
    
    DataType: InventoryAttributeDataType | string | undefined;
}
export declare namespace InventoryItemAttribute {
    
    const filterSensitiveLog: (obj: InventoryItemAttribute) => any;
}

export interface InventoryItemSchema {
    
    TypeName: string | undefined;
    
    Version?: string;
    
    Attributes: InventoryItemAttribute[] | undefined;
    
    DisplayName?: string;
}
export declare namespace InventoryItemSchema {
    
    const filterSensitiveLog: (obj: InventoryItemSchema) => any;
}
export interface GetInventorySchemaResult {
    
    Schemas?: InventoryItemSchema[];
    
    NextToken?: string;
}
export declare namespace GetInventorySchemaResult {
    
    const filterSensitiveLog: (obj: GetInventorySchemaResult) => any;
}
export interface GetMaintenanceWindowRequest {
    
    WindowId: string | undefined;
}
export declare namespace GetMaintenanceWindowRequest {
    
    const filterSensitiveLog: (obj: GetMaintenanceWindowRequest) => any;
}
export interface GetMaintenanceWindowResult {
    
    WindowId?: string;
    
    Name?: string;
    
    Description?: string;
    
    StartDate?: string;
    
    EndDate?: string;
    
    Schedule?: string;
    
    ScheduleTimezone?: string;
    
    ScheduleOffset?: number;
    
    NextExecutionTime?: string;
    
    Duration?: number;
    
    Cutoff?: number;
    
    AllowUnassociatedTargets?: boolean;
    
    Enabled?: boolean;
    
    CreatedDate?: Date;
    
    ModifiedDate?: Date;
}
export declare namespace GetMaintenanceWindowResult {
    
    const filterSensitiveLog: (obj: GetMaintenanceWindowResult) => any;
}
export interface GetMaintenanceWindowExecutionRequest {
    
    WindowExecutionId: string | undefined;
}
export declare namespace GetMaintenanceWindowExecutionRequest {
    
    const filterSensitiveLog: (obj: GetMaintenanceWindowExecutionRequest) => any;
}
export interface GetMaintenanceWindowExecutionResult {
    
    WindowExecutionId?: string;
    
    TaskIds?: string[];
    
    Status?: MaintenanceWindowExecutionStatus | string;
    
    StatusDetails?: string;
    
    StartTime?: Date;
    
    EndTime?: Date;
}
export declare namespace GetMaintenanceWindowExecutionResult {
    
    const filterSensitiveLog: (obj: GetMaintenanceWindowExecutionResult) => any;
}
export interface GetMaintenanceWindowExecutionTaskRequest {
    
    WindowExecutionId: string | undefined;
    
    TaskId: string | undefined;
}
export declare namespace GetMaintenanceWindowExecutionTaskRequest {
    
    const filterSensitiveLog: (obj: GetMaintenanceWindowExecutionTaskRequest) => any;
}
export interface GetMaintenanceWindowExecutionTaskResult {
    
    WindowExecutionId?: string;
    
    TaskExecutionId?: string;
    
    TaskArn?: string;
    
    ServiceRole?: string;
    
    Type?: MaintenanceWindowTaskType | string;
    
    TaskParameters?: Record<string, MaintenanceWindowTaskParameterValueExpression>[];
    
    Priority?: number;
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    Status?: MaintenanceWindowExecutionStatus | string;
    
    StatusDetails?: string;
    
    StartTime?: Date;
    
    EndTime?: Date;
}
export declare namespace GetMaintenanceWindowExecutionTaskResult {
    
    const filterSensitiveLog: (obj: GetMaintenanceWindowExecutionTaskResult) => any;
}
export interface GetMaintenanceWindowExecutionTaskInvocationRequest {
    
    WindowExecutionId: string | undefined;
    
    TaskId: string | undefined;
    
    InvocationId: string | undefined;
}
export declare namespace GetMaintenanceWindowExecutionTaskInvocationRequest {
    
    const filterSensitiveLog: (obj: GetMaintenanceWindowExecutionTaskInvocationRequest) => any;
}
export interface GetMaintenanceWindowExecutionTaskInvocationResult {
    
    WindowExecutionId?: string;
    
    TaskExecutionId?: string;
    
    InvocationId?: string;
    
    ExecutionId?: string;
    
    TaskType?: MaintenanceWindowTaskType | string;
    
    Parameters?: string;
    
    Status?: MaintenanceWindowExecutionStatus | string;
    
    StatusDetails?: string;
    
    StartTime?: Date;
    
    EndTime?: Date;
    
    OwnerInformation?: string;
    
    WindowTargetId?: string;
}
export declare namespace GetMaintenanceWindowExecutionTaskInvocationResult {
    
    const filterSensitiveLog: (obj: GetMaintenanceWindowExecutionTaskInvocationResult) => any;
}
export interface GetMaintenanceWindowTaskRequest {
    
    WindowId: string | undefined;
    
    WindowTaskId: string | undefined;
}
export declare namespace GetMaintenanceWindowTaskRequest {
    
    const filterSensitiveLog: (obj: GetMaintenanceWindowTaskRequest) => any;
}

export interface MaintenanceWindowAutomationParameters {
    
    DocumentVersion?: string;
    
    Parameters?: Record<string, string[]>;
}
export declare namespace MaintenanceWindowAutomationParameters {
    
    const filterSensitiveLog: (obj: MaintenanceWindowAutomationParameters) => any;
}

export interface MaintenanceWindowLambdaParameters {
    
    ClientContext?: string;
    
    Qualifier?: string;
    
    Payload?: Uint8Array;
}
export declare namespace MaintenanceWindowLambdaParameters {
    
    const filterSensitiveLog: (obj: MaintenanceWindowLambdaParameters) => any;
}
export declare enum NotificationEvent {
    ALL = "All",
    CANCELLED = "Cancelled",
    FAILED = "Failed",
    IN_PROGRESS = "InProgress",
    SUCCESS = "Success",
    TIMED_OUT = "TimedOut"
}
export declare enum NotificationType {
    Command = "Command",
    Invocation = "Invocation"
}

export interface NotificationConfig {
    
    NotificationArn?: string;
    
    NotificationEvents?: (NotificationEvent | string)[];
    
    NotificationType?: NotificationType | string;
}
export declare namespace NotificationConfig {
    
    const filterSensitiveLog: (obj: NotificationConfig) => any;
}

export interface MaintenanceWindowRunCommandParameters {
    
    Comment?: string;
    
    CloudWatchOutputConfig?: CloudWatchOutputConfig;
    
    DocumentHash?: string;
    
    DocumentHashType?: DocumentHashType | string;
    
    DocumentVersion?: string;
    
    NotificationConfig?: NotificationConfig;
    
    OutputS3BucketName?: string;
    
    OutputS3KeyPrefix?: string;
    
    Parameters?: Record<string, string[]>;
    
    ServiceRoleArn?: string;
    
    TimeoutSeconds?: number;
}
export declare namespace MaintenanceWindowRunCommandParameters {
    
    const filterSensitiveLog: (obj: MaintenanceWindowRunCommandParameters) => any;
}

export interface MaintenanceWindowStepFunctionsParameters {
    
    Input?: string;
    
    Name?: string;
}
export declare namespace MaintenanceWindowStepFunctionsParameters {
    
    const filterSensitiveLog: (obj: MaintenanceWindowStepFunctionsParameters) => any;
}

export interface MaintenanceWindowTaskInvocationParameters {
    
    RunCommand?: MaintenanceWindowRunCommandParameters;
    
    Automation?: MaintenanceWindowAutomationParameters;
    
    StepFunctions?: MaintenanceWindowStepFunctionsParameters;
    
    Lambda?: MaintenanceWindowLambdaParameters;
}
export declare namespace MaintenanceWindowTaskInvocationParameters {
    
    const filterSensitiveLog: (obj: MaintenanceWindowTaskInvocationParameters) => any;
}
export interface GetMaintenanceWindowTaskResult {
    
    WindowId?: string;
    
    WindowTaskId?: string;
    
    Targets?: Target[];
    
    TaskArn?: string;
    
    ServiceRoleArn?: string;
    
    TaskType?: MaintenanceWindowTaskType | string;
    
    TaskParameters?: Record<string, MaintenanceWindowTaskParameterValueExpression>;
    
    TaskInvocationParameters?: MaintenanceWindowTaskInvocationParameters;
    
    Priority?: number;
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    LoggingInfo?: LoggingInfo;
    
    Name?: string;
    
    Description?: string;
    
    CutoffBehavior?: MaintenanceWindowTaskCutoffBehavior | string;
}
export declare namespace GetMaintenanceWindowTaskResult {
    
    const filterSensitiveLog: (obj: GetMaintenanceWindowTaskResult) => any;
}
export interface GetOpsItemRequest {
    
    OpsItemId: string | undefined;
}
export declare namespace GetOpsItemRequest {
    
    const filterSensitiveLog: (obj: GetOpsItemRequest) => any;
}

export interface OpsItem {
    
    CreatedBy?: string;
    
    OpsItemType?: string;
    
    CreatedTime?: Date;
    
    Description?: string;
    
    LastModifiedBy?: string;
    
    LastModifiedTime?: Date;
    
    Notifications?: OpsItemNotification[];
    
    Priority?: number;
    
    RelatedOpsItems?: RelatedOpsItem[];
    
    Status?: OpsItemStatus | string;
    
    OpsItemId?: string;
    
    Version?: string;
    
    Title?: string;
    
    Source?: string;
    
    OperationalData?: Record<string, OpsItemDataValue>;
    
    Category?: string;
    
    Severity?: string;
    
    ActualStartTime?: Date;
    
    ActualEndTime?: Date;
    
    PlannedStartTime?: Date;
    
    PlannedEndTime?: Date;
}
export declare namespace OpsItem {
    
    const filterSensitiveLog: (obj: OpsItem) => any;
}
export interface GetOpsItemResponse {
    
    OpsItem?: OpsItem;
}
export declare namespace GetOpsItemResponse {
    
    const filterSensitiveLog: (obj: GetOpsItemResponse) => any;
}
export interface GetOpsMetadataRequest {
    
    OpsMetadataArn: string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace GetOpsMetadataRequest {
    
    const filterSensitiveLog: (obj: GetOpsMetadataRequest) => any;
}
export interface GetOpsMetadataResult {
    
    ResourceId?: string;
    
    Metadata?: Record<string, MetadataValue>;
    
    NextToken?: string;
}
export declare namespace GetOpsMetadataResult {
    
    const filterSensitiveLog: (obj: GetOpsMetadataResult) => any;
}
export declare enum OpsFilterOperatorType {
    BEGIN_WITH = "BeginWith",
    EQUAL = "Equal",
    EXISTS = "Exists",
    GREATER_THAN = "GreaterThan",
    LESS_THAN = "LessThan",
    NOT_EQUAL = "NotEqual"
}

export interface OpsFilter {
    
    Key: string | undefined;
    
    Values: string[] | undefined;
    
    Type?: OpsFilterOperatorType | string;
}
export declare namespace OpsFilter {
    
    const filterSensitiveLog: (obj: OpsFilter) => any;
}

export interface OpsResultAttribute {
    
    TypeName: string | undefined;
}
export declare namespace OpsResultAttribute {
    
    const filterSensitiveLog: (obj: OpsResultAttribute) => any;
}

export interface OpsEntityItem {
    
    CaptureTime?: string;
    
    Content?: Record<string, string>[];
}
export declare namespace OpsEntityItem {
    
    const filterSensitiveLog: (obj: OpsEntityItem) => any;
}

export interface OpsEntity {
    
    Id?: string;
    
    Data?: Record<string, OpsEntityItem>;
}
export declare namespace OpsEntity {
    
    const filterSensitiveLog: (obj: OpsEntity) => any;
}
export interface GetOpsSummaryResult {
    
    Entities?: OpsEntity[];
    
    NextToken?: string;
}
export declare namespace GetOpsSummaryResult {
    
    const filterSensitiveLog: (obj: GetOpsSummaryResult) => any;
}
export interface GetParameterRequest {
    
    Name: string | undefined;
    
    WithDecryption?: boolean;
}
export declare namespace GetParameterRequest {
    
    const filterSensitiveLog: (obj: GetParameterRequest) => any;
}

export interface Parameter {
    
    Name?: string;
    
    Type?: ParameterType | string;
    
    Value?: string;
    
    Version?: number;
    
    Selector?: string;
    
    SourceResult?: string;
    
    LastModifiedDate?: Date;
    
    ARN?: string;
    
    DataType?: string;
}
export declare namespace Parameter {
    
    const filterSensitiveLog: (obj: Parameter) => any;
}
export interface GetParameterResult {
    
    Parameter?: Parameter;
}
export declare namespace GetParameterResult {
    
    const filterSensitiveLog: (obj: GetParameterResult) => any;
}

export declare class InvalidKeyId extends __BaseException {
    readonly name: "InvalidKeyId";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidKeyId, __BaseException>);
}

export declare class ParameterVersionNotFound extends __BaseException {
    readonly name: "ParameterVersionNotFound";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<ParameterVersionNotFound, __BaseException>);
}
export interface GetParameterHistoryRequest {
    
    Name: string | undefined;
    
    WithDecryption?: boolean;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace GetParameterHistoryRequest {
    
    const filterSensitiveLog: (obj: GetParameterHistoryRequest) => any;
}

export interface ParameterHistory {
    
    Name?: string;
    
    Type?: ParameterType | string;
    
    KeyId?: string;
    
    LastModifiedDate?: Date;
    
    LastModifiedUser?: string;
    
    Description?: string;
    
    Value?: string;
    
    AllowedPattern?: string;
    
    Version?: number;
    
    Labels?: string[];
    
    Tier?: ParameterTier | string;
    
    Policies?: ParameterInlinePolicy[];
    
    DataType?: string;
}
export declare namespace ParameterHistory {
    
    const filterSensitiveLog: (obj: ParameterHistory) => any;
}
export interface GetParameterHistoryResult {
    
    Parameters?: ParameterHistory[];
    
    NextToken?: string;
}
export declare namespace GetParameterHistoryResult {
    
    const filterSensitiveLog: (obj: GetParameterHistoryResult) => any;
}
export interface GetParametersRequest {
    
    Names: string[] | undefined;
    
    WithDecryption?: boolean;
}
export declare namespace GetParametersRequest {
    
    const filterSensitiveLog: (obj: GetParametersRequest) => any;
}
export interface GetParametersResult {
    
    Parameters?: Parameter[];
    
    InvalidParameters?: string[];
}
export declare namespace GetParametersResult {
    
    const filterSensitiveLog: (obj: GetParametersResult) => any;
}
export interface GetParametersByPathRequest {
    
    Path: string | undefined;
    
    Recursive?: boolean;
    
    ParameterFilters?: ParameterStringFilter[];
    
    WithDecryption?: boolean;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace GetParametersByPathRequest {
    
    const filterSensitiveLog: (obj: GetParametersByPathRequest) => any;
}
export interface GetParametersByPathResult {
    
    Parameters?: Parameter[];
    
    NextToken?: string;
}
export declare namespace GetParametersByPathResult {
    
    const filterSensitiveLog: (obj: GetParametersByPathResult) => any;
}
export interface GetPatchBaselineRequest {
    
    BaselineId: string | undefined;
}
export declare namespace GetPatchBaselineRequest {
    
    const filterSensitiveLog: (obj: GetPatchBaselineRequest) => any;
}
export interface GetPatchBaselineResult {
    
    BaselineId?: string;
    
    Name?: string;
    
    OperatingSystem?: OperatingSystem | string;
    
    GlobalFilters?: PatchFilterGroup;
    
    ApprovalRules?: PatchRuleGroup;
    
    ApprovedPatches?: string[];
    
    ApprovedPatchesComplianceLevel?: PatchComplianceLevel | string;
    
    ApprovedPatchesEnableNonSecurity?: boolean;
    
    RejectedPatches?: string[];
    
    RejectedPatchesAction?: PatchAction | string;
    
    PatchGroups?: string[];
    
    CreatedDate?: Date;
    
    ModifiedDate?: Date;
    
    Description?: string;
    
    Sources?: PatchSource[];
}
export declare namespace GetPatchBaselineResult {
    
    const filterSensitiveLog: (obj: GetPatchBaselineResult) => any;
}
export interface GetPatchBaselineForPatchGroupRequest {
    
    PatchGroup: string | undefined;
    
    OperatingSystem?: OperatingSystem | string;
}
export declare namespace GetPatchBaselineForPatchGroupRequest {
    
    const filterSensitiveLog: (obj: GetPatchBaselineForPatchGroupRequest) => any;
}
export interface GetPatchBaselineForPatchGroupResult {
    
    BaselineId?: string;
    
    PatchGroup?: string;
    
    OperatingSystem?: OperatingSystem | string;
}
export declare namespace GetPatchBaselineForPatchGroupResult {
    
    const filterSensitiveLog: (obj: GetPatchBaselineForPatchGroupResult) => any;
}

export interface GetServiceSettingRequest {
    
    SettingId: string | undefined;
}
export declare namespace GetServiceSettingRequest {
    
    const filterSensitiveLog: (obj: GetServiceSettingRequest) => any;
}

export interface ServiceSetting {
    
    SettingId?: string;
    
    SettingValue?: string;
    
    LastModifiedDate?: Date;
    
    LastModifiedUser?: string;
    
    ARN?: string;
    
    Status?: string;
}
export declare namespace ServiceSetting {
    
    const filterSensitiveLog: (obj: ServiceSetting) => any;
}

export interface GetServiceSettingResult {
    
    ServiceSetting?: ServiceSetting;
}
export declare namespace GetServiceSettingResult {
    
    const filterSensitiveLog: (obj: GetServiceSettingResult) => any;
}

export declare class ServiceSettingNotFound extends __BaseException {
    readonly name: "ServiceSettingNotFound";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ServiceSettingNotFound, __BaseException>);
}
export interface LabelParameterVersionRequest {
    
    Name: string | undefined;
    
    ParameterVersion?: number;
    
    Labels: string[] | undefined;
}
export declare namespace LabelParameterVersionRequest {
    
    const filterSensitiveLog: (obj: LabelParameterVersionRequest) => any;
}
export interface LabelParameterVersionResult {
    
    InvalidLabels?: string[];
    
    ParameterVersion?: number;
}
export declare namespace LabelParameterVersionResult {
    
    const filterSensitiveLog: (obj: LabelParameterVersionResult) => any;
}

export declare class ParameterVersionLabelLimitExceeded extends __BaseException {
    readonly name: "ParameterVersionLabelLimitExceeded";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<ParameterVersionLabelLimitExceeded, __BaseException>);
}
export declare enum AssociationFilterKey {
    AssociationId = "AssociationId",
    AssociationName = "AssociationName",
    InstanceId = "InstanceId",
    LastExecutedAfter = "LastExecutedAfter",
    LastExecutedBefore = "LastExecutedBefore",
    Name = "Name",
    ResourceGroupName = "ResourceGroupName",
    Status = "AssociationStatusName"
}

export interface AssociationFilter {
    
    key: AssociationFilterKey | string | undefined;
    
    value: string | undefined;
}
export declare namespace AssociationFilter {
    
    const filterSensitiveLog: (obj: AssociationFilter) => any;
}
export interface ListAssociationsRequest {
    
    AssociationFilterList?: AssociationFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace ListAssociationsRequest {
    
    const filterSensitiveLog: (obj: ListAssociationsRequest) => any;
}

export interface Association {
    
    Name?: string;
    
    InstanceId?: string;
    
    AssociationId?: string;
    
    AssociationVersion?: string;
    
    DocumentVersion?: string;
    
    Targets?: Target[];
    
    LastExecutionDate?: Date;
    
    Overview?: AssociationOverview;
    
    ScheduleExpression?: string;
    
    AssociationName?: string;
    
    ScheduleOffset?: number;
    
    TargetMaps?: Record<string, string[]>[];
}
export declare namespace Association {
    
    const filterSensitiveLog: (obj: Association) => any;
}
export interface ListAssociationsResult {
    
    Associations?: Association[];
    
    NextToken?: string;
}
export declare namespace ListAssociationsResult {
    
    const filterSensitiveLog: (obj: ListAssociationsResult) => any;
}
export interface ListAssociationVersionsRequest {
    
    AssociationId: string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace ListAssociationVersionsRequest {
    
    const filterSensitiveLog: (obj: ListAssociationVersionsRequest) => any;
}

export interface AssociationVersionInfo {
    
    AssociationId?: string;
    
    AssociationVersion?: string;
    
    CreatedDate?: Date;
    
    Name?: string;
    
    DocumentVersion?: string;
    
    Parameters?: Record<string, string[]>;
    
    Targets?: Target[];
    
    ScheduleExpression?: string;
    
    OutputLocation?: InstanceAssociationOutputLocation;
    
    AssociationName?: string;
    
    MaxErrors?: string;
    
    MaxConcurrency?: string;
    
    ComplianceSeverity?: AssociationComplianceSeverity | string;
    
    SyncCompliance?: AssociationSyncCompliance | string;
    
    ApplyOnlyAtCronInterval?: boolean;
    
    CalendarNames?: string[];
    
    TargetLocations?: TargetLocation[];
    
    ScheduleOffset?: number;
    
    TargetMaps?: Record<string, string[]>[];
}
export declare namespace AssociationVersionInfo {
    
    const filterSensitiveLog: (obj: AssociationVersionInfo) => any;
}
export interface ListAssociationVersionsResult {
    
    AssociationVersions?: AssociationVersionInfo[];
    
    NextToken?: string;
}
export declare namespace ListAssociationVersionsResult {
    
    const filterSensitiveLog: (obj: ListAssociationVersionsResult) => any;
}
export declare enum CommandFilterKey {
    DOCUMENT_NAME = "DocumentName",
    EXECUTION_STAGE = "ExecutionStage",
    INVOKED_AFTER = "InvokedAfter",
    INVOKED_BEFORE = "InvokedBefore",
    STATUS = "Status"
}

export interface CommandFilter {
    
    key: CommandFilterKey | string | undefined;
    
    value: string | undefined;
}
export declare namespace CommandFilter {
    
    const filterSensitiveLog: (obj: CommandFilter) => any;
}
export interface ListCommandInvocationsRequest {
    
    CommandId?: string;
    
    InstanceId?: string;
    
    MaxResults?: number;
    
    NextToken?: string;
    
    Filters?: CommandFilter[];
    
    Details?: boolean;
}
export declare namespace ListCommandInvocationsRequest {
    
    const filterSensitiveLog: (obj: ListCommandInvocationsRequest) => any;
}
export declare enum CommandPluginStatus {
    CANCELLED = "Cancelled",
    FAILED = "Failed",
    IN_PROGRESS = "InProgress",
    PENDING = "Pending",
    SUCCESS = "Success",
    TIMED_OUT = "TimedOut"
}

export interface CommandPlugin {
    
    Name?: string;
    
    Status?: CommandPluginStatus | string;
    
    StatusDetails?: string;
    
    ResponseCode?: number;
    
    ResponseStartDateTime?: Date;
    
    ResponseFinishDateTime?: Date;
    
    Output?: string;
    
    StandardOutputUrl?: string;
    
    StandardErrorUrl?: string;
    
    OutputS3Region?: string;
    
    OutputS3BucketName?: string;
    
    OutputS3KeyPrefix?: string;
}
export declare namespace CommandPlugin {
    
    const filterSensitiveLog: (obj: CommandPlugin) => any;
}

export interface CommandInvocation {
    
    CommandId?: string;
    
    InstanceId?: string;
    
    InstanceName?: string;
    
    Comment?: string;
    
    DocumentName?: string;
    
    DocumentVersion?: string;
    
    RequestedDateTime?: Date;
    
    Status?: CommandInvocationStatus | string;
    
    StatusDetails?: string;
    
    TraceOutput?: string;
    
    StandardOutputUrl?: string;
    
    StandardErrorUrl?: string;
    
    CommandPlugins?: CommandPlugin[];
    
    ServiceRole?: string;
    
    NotificationConfig?: NotificationConfig;
    
    CloudWatchOutputConfig?: CloudWatchOutputConfig;
}
export declare namespace CommandInvocation {
    
    const filterSensitiveLog: (obj: CommandInvocation) => any;
}
export interface ListCommandInvocationsResult {
    
    CommandInvocations?: CommandInvocation[];
    
    NextToken?: string;
}
export declare namespace ListCommandInvocationsResult {
    
    const filterSensitiveLog: (obj: ListCommandInvocationsResult) => any;
}
export interface ListCommandsRequest {
    
    CommandId?: string;
    
    InstanceId?: string;
    
    MaxResults?: number;
    
    NextToken?: string;
    
    Filters?: CommandFilter[];
}
export declare namespace ListCommandsRequest {
    
    const filterSensitiveLog: (obj: ListCommandsRequest) => any;
}
export declare enum CommandStatus {
    CANCELLED = "Cancelled",
    CANCELLING = "Cancelling",
    FAILED = "Failed",
    IN_PROGRESS = "InProgress",
    PENDING = "Pending",
    SUCCESS = "Success",
    TIMED_OUT = "TimedOut"
}

export interface Command {
    
    CommandId?: string;
    
    DocumentName?: string;
    
    DocumentVersion?: string;
    
    Comment?: string;
    
    ExpiresAfter?: Date;
    
    Parameters?: Record<string, string[]>;
    
    InstanceIds?: string[];
    
    Targets?: Target[];
    
    RequestedDateTime?: Date;
    
    Status?: CommandStatus | string;
    
    StatusDetails?: string;
    
    OutputS3Region?: string;
    
    OutputS3BucketName?: string;
    
    OutputS3KeyPrefix?: string;
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    TargetCount?: number;
    
    CompletedCount?: number;
    
    ErrorCount?: number;
    
    DeliveryTimedOutCount?: number;
    
    ServiceRole?: string;
    
    NotificationConfig?: NotificationConfig;
    
    CloudWatchOutputConfig?: CloudWatchOutputConfig;
    
    TimeoutSeconds?: number;
}
export declare namespace Command {
    
    const filterSensitiveLog: (obj: Command) => any;
}
export interface ListCommandsResult {
    
    Commands?: Command[];
    
    NextToken?: string;
}
export declare namespace ListCommandsResult {
    
    const filterSensitiveLog: (obj: ListCommandsResult) => any;
}
export declare enum ComplianceQueryOperatorType {
    BeginWith = "BEGIN_WITH",
    Equal = "EQUAL",
    GreaterThan = "GREATER_THAN",
    LessThan = "LESS_THAN",
    NotEqual = "NOT_EQUAL"
}

export interface ComplianceStringFilter {
    
    Key?: string;
    
    Values?: string[];
    
    Type?: ComplianceQueryOperatorType | string;
}
export declare namespace ComplianceStringFilter {
    
    const filterSensitiveLog: (obj: ComplianceStringFilter) => any;
}
export interface ListComplianceItemsRequest {
    
    Filters?: ComplianceStringFilter[];
    
    ResourceIds?: string[];
    
    ResourceTypes?: string[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace ListComplianceItemsRequest {
    
    const filterSensitiveLog: (obj: ListComplianceItemsRequest) => any;
}

export interface ComplianceExecutionSummary {
    
    ExecutionTime: Date | undefined;
    
    ExecutionId?: string;
    
    ExecutionType?: string;
}
export declare namespace ComplianceExecutionSummary {
    
    const filterSensitiveLog: (obj: ComplianceExecutionSummary) => any;
}
export declare enum ComplianceSeverity {
    Critical = "CRITICAL",
    High = "HIGH",
    Informational = "INFORMATIONAL",
    Low = "LOW",
    Medium = "MEDIUM",
    Unspecified = "UNSPECIFIED"
}
export declare enum ComplianceStatus {
    Compliant = "COMPLIANT",
    NonCompliant = "NON_COMPLIANT"
}

export interface ComplianceItem {
    
    ComplianceType?: string;
    
    ResourceType?: string;
    
    ResourceId?: string;
    
    Id?: string;
    
    Title?: string;
    
    Status?: ComplianceStatus | string;
    
    Severity?: ComplianceSeverity | string;
    
    ExecutionSummary?: ComplianceExecutionSummary;
    
    Details?: Record<string, string>;
}
export declare namespace ComplianceItem {
    
    const filterSensitiveLog: (obj: ComplianceItem) => any;
}
export interface ListComplianceItemsResult {
    
    ComplianceItems?: ComplianceItem[];
    
    NextToken?: string;
}
export declare namespace ListComplianceItemsResult {
    
    const filterSensitiveLog: (obj: ListComplianceItemsResult) => any;
}
export interface ListComplianceSummariesRequest {
    
    Filters?: ComplianceStringFilter[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace ListComplianceSummariesRequest {
    
    const filterSensitiveLog: (obj: ListComplianceSummariesRequest) => any;
}

export interface SeveritySummary {
    
    CriticalCount?: number;
    
    HighCount?: number;
    
    MediumCount?: number;
    
    LowCount?: number;
    
    InformationalCount?: number;
    
    UnspecifiedCount?: number;
}
export declare namespace SeveritySummary {
    
    const filterSensitiveLog: (obj: SeveritySummary) => any;
}

export interface CompliantSummary {
    
    CompliantCount?: number;
    
    SeveritySummary?: SeveritySummary;
}
export declare namespace CompliantSummary {
    
    const filterSensitiveLog: (obj: CompliantSummary) => any;
}

export interface NonCompliantSummary {
    
    NonCompliantCount?: number;
    
    SeveritySummary?: SeveritySummary;
}
export declare namespace NonCompliantSummary {
    
    const filterSensitiveLog: (obj: NonCompliantSummary) => any;
}

export interface ComplianceSummaryItem {
    
    ComplianceType?: string;
    
    CompliantSummary?: CompliantSummary;
    
    NonCompliantSummary?: NonCompliantSummary;
}
export declare namespace ComplianceSummaryItem {
    
    const filterSensitiveLog: (obj: ComplianceSummaryItem) => any;
}
export interface ListComplianceSummariesResult {
    
    ComplianceSummaryItems?: ComplianceSummaryItem[];
    
    NextToken?: string;
}
export declare namespace ListComplianceSummariesResult {
    
    const filterSensitiveLog: (obj: ListComplianceSummariesResult) => any;
}
export declare enum DocumentMetadataEnum {
    DocumentReviews = "DocumentReviews"
}
export interface ListDocumentMetadataHistoryRequest {
    
    Name: string | undefined;
    
    DocumentVersion?: string;
    
    Metadata: DocumentMetadataEnum | string | undefined;
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace ListDocumentMetadataHistoryRequest {
    
    const filterSensitiveLog: (obj: ListDocumentMetadataHistoryRequest) => any;
}
export declare enum DocumentReviewCommentType {
    Comment = "Comment"
}

export interface DocumentReviewCommentSource {
    
    Type?: DocumentReviewCommentType | string;
    
    Content?: string;
}
export declare namespace DocumentReviewCommentSource {
    
    const filterSensitiveLog: (obj: DocumentReviewCommentSource) => any;
}

export interface DocumentReviewerResponseSource {
    
    CreateTime?: Date;
    
    UpdatedTime?: Date;
    
    ReviewStatus?: ReviewStatus | string;
    
    Comment?: DocumentReviewCommentSource[];
    
    Reviewer?: string;
}
export declare namespace DocumentReviewerResponseSource {
    
    const filterSensitiveLog: (obj: DocumentReviewerResponseSource) => any;
}

export interface DocumentMetadataResponseInfo {
    
    ReviewerResponse?: DocumentReviewerResponseSource[];
}
export declare namespace DocumentMetadataResponseInfo {
    
    const filterSensitiveLog: (obj: DocumentMetadataResponseInfo) => any;
}
export interface ListDocumentMetadataHistoryResponse {
    
    Name?: string;
    
    DocumentVersion?: string;
    
    Author?: string;
    
    Metadata?: DocumentMetadataResponseInfo;
    
    NextToken?: string;
}
export declare namespace ListDocumentMetadataHistoryResponse {
    
    const filterSensitiveLog: (obj: ListDocumentMetadataHistoryResponse) => any;
}
export declare enum DocumentFilterKey {
    DocumentType = "DocumentType",
    Name = "Name",
    Owner = "Owner",
    PlatformTypes = "PlatformTypes"
}

export interface DocumentFilter {
    
    key: DocumentFilterKey | string | undefined;
    
    value: string | undefined;
}
export declare namespace DocumentFilter {
    
    const filterSensitiveLog: (obj: DocumentFilter) => any;
}

export interface DocumentKeyValuesFilter {
    
    Key?: string;
    
    Values?: string[];
}
export declare namespace DocumentKeyValuesFilter {
    
    const filterSensitiveLog: (obj: DocumentKeyValuesFilter) => any;
}
export interface ListDocumentsRequest {
    
    DocumentFilterList?: DocumentFilter[];
    
    Filters?: DocumentKeyValuesFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace ListDocumentsRequest {
    
    const filterSensitiveLog: (obj: ListDocumentsRequest) => any;
}

export interface DocumentIdentifier {
    
    Name?: string;
    
    CreatedDate?: Date;
    
    DisplayName?: string;
    
    Owner?: string;
    
    VersionName?: string;
    
    PlatformTypes?: (PlatformType | string)[];
    
    DocumentVersion?: string;
    
    DocumentType?: DocumentType | string;
    
    SchemaVersion?: string;
    
    DocumentFormat?: DocumentFormat | string;
    
    TargetType?: string;
    
    Tags?: Tag[];
    
    Requires?: DocumentRequires[];
    
    ReviewStatus?: ReviewStatus | string;
    
    Author?: string;
}
export declare namespace DocumentIdentifier {
    
    const filterSensitiveLog: (obj: DocumentIdentifier) => any;
}
export interface ListDocumentsResult {
    
    DocumentIdentifiers?: DocumentIdentifier[];
    
    NextToken?: string;
}
export declare namespace ListDocumentsResult {
    
    const filterSensitiveLog: (obj: ListDocumentsResult) => any;
}
export interface ListDocumentVersionsRequest {
    
    Name: string | undefined;
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace ListDocumentVersionsRequest {
    
    const filterSensitiveLog: (obj: ListDocumentVersionsRequest) => any;
}

export interface DocumentVersionInfo {
    
    Name?: string;
    
    DisplayName?: string;
    
    DocumentVersion?: string;
    
    VersionName?: string;
    
    CreatedDate?: Date;
    
    IsDefaultVersion?: boolean;
    
    DocumentFormat?: DocumentFormat | string;
    
    Status?: DocumentStatus | string;
    
    StatusInformation?: string;
    
    ReviewStatus?: ReviewStatus | string;
}
export declare namespace DocumentVersionInfo {
    
    const filterSensitiveLog: (obj: DocumentVersionInfo) => any;
}
export interface ListDocumentVersionsResult {
    
    DocumentVersions?: DocumentVersionInfo[];
    
    NextToken?: string;
}
export declare namespace ListDocumentVersionsResult {
    
    const filterSensitiveLog: (obj: ListDocumentVersionsResult) => any;
}
export interface ListInventoryEntriesRequest {
    
    InstanceId: string | undefined;
    
    TypeName: string | undefined;
    
    Filters?: InventoryFilter[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace ListInventoryEntriesRequest {
    
    const filterSensitiveLog: (obj: ListInventoryEntriesRequest) => any;
}
export interface ListInventoryEntriesResult {
    
    TypeName?: string;
    
    InstanceId?: string;
    
    SchemaVersion?: string;
    
    CaptureTime?: string;
    
    Entries?: Record<string, string>[];
    
    NextToken?: string;
}
export declare namespace ListInventoryEntriesResult {
    
    const filterSensitiveLog: (obj: ListInventoryEntriesResult) => any;
}
export declare enum OpsItemEventFilterKey {
    OPSITEM_ID = "OpsItemId"
}
export declare enum OpsItemEventFilterOperator {
    EQUAL = "Equal"
}

export interface OpsItemEventFilter {
    
    Key: OpsItemEventFilterKey | string | undefined;
    
    Values: string[] | undefined;
    
    Operator: OpsItemEventFilterOperator | string | undefined;
}
export declare namespace OpsItemEventFilter {
    
    const filterSensitiveLog: (obj: OpsItemEventFilter) => any;
}
export interface ListOpsItemEventsRequest {
    
    Filters?: OpsItemEventFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace ListOpsItemEventsRequest {
    
    const filterSensitiveLog: (obj: ListOpsItemEventsRequest) => any;
}

export interface OpsItemIdentity {
    
    Arn?: string;
}
export declare namespace OpsItemIdentity {
    
    const filterSensitiveLog: (obj: OpsItemIdentity) => any;
}

export interface OpsItemEventSummary {
    
    OpsItemId?: string;
    
    EventId?: string;
    
    Source?: string;
    
    DetailType?: string;
    
    Detail?: string;
    
    CreatedBy?: OpsItemIdentity;
    
    CreatedTime?: Date;
}
export declare namespace OpsItemEventSummary {
    
    const filterSensitiveLog: (obj: OpsItemEventSummary) => any;
}
export interface ListOpsItemEventsResponse {
    
    NextToken?: string;
    
    Summaries?: OpsItemEventSummary[];
}
export declare namespace ListOpsItemEventsResponse {
    
    const filterSensitiveLog: (obj: ListOpsItemEventsResponse) => any;
}
export declare enum OpsItemRelatedItemsFilterKey {
    ASSOCIATION_ID = "AssociationId",
    RESOURCE_TYPE = "ResourceType",
    RESOURCE_URI = "ResourceUri"
}
export declare enum OpsItemRelatedItemsFilterOperator {
    EQUAL = "Equal"
}

export interface OpsItemRelatedItemsFilter {
    
    Key: OpsItemRelatedItemsFilterKey | string | undefined;
    
    Values: string[] | undefined;
    
    Operator: OpsItemRelatedItemsFilterOperator | string | undefined;
}
export declare namespace OpsItemRelatedItemsFilter {
    
    const filterSensitiveLog: (obj: OpsItemRelatedItemsFilter) => any;
}
export interface ListOpsItemRelatedItemsRequest {
    
    OpsItemId?: string;
    
    Filters?: OpsItemRelatedItemsFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace ListOpsItemRelatedItemsRequest {
    
    const filterSensitiveLog: (obj: ListOpsItemRelatedItemsRequest) => any;
}

export interface OpsItemRelatedItemSummary {
    
    OpsItemId?: string;
    
    AssociationId?: string;
    
    ResourceType?: string;
    
    AssociationType?: string;
    
    ResourceUri?: string;
    
    CreatedBy?: OpsItemIdentity;
    
    CreatedTime?: Date;
    
    LastModifiedBy?: OpsItemIdentity;
    
    LastModifiedTime?: Date;
}
export declare namespace OpsItemRelatedItemSummary {
    
    const filterSensitiveLog: (obj: OpsItemRelatedItemSummary) => any;
}
export interface ListOpsItemRelatedItemsResponse {
    
    NextToken?: string;
    
    Summaries?: OpsItemRelatedItemSummary[];
}
export declare namespace ListOpsItemRelatedItemsResponse {
    
    const filterSensitiveLog: (obj: ListOpsItemRelatedItemsResponse) => any;
}

export interface OpsMetadataFilter {
    
    Key: string | undefined;
    
    Values: string[] | undefined;
}
export declare namespace OpsMetadataFilter {
    
    const filterSensitiveLog: (obj: OpsMetadataFilter) => any;
}
export interface ListOpsMetadataRequest {
    
    Filters?: OpsMetadataFilter[];
    
    MaxResults?: number;
    
    NextToken?: string;
}
export declare namespace ListOpsMetadataRequest {
    
    const filterSensitiveLog: (obj: ListOpsMetadataRequest) => any;
}

export interface OpsMetadata {
    
    ResourceId?: string;
    
    OpsMetadataArn?: string;
    
    LastModifiedDate?: Date;
    
    LastModifiedUser?: string;
    
    CreationDate?: Date;
}
export declare namespace OpsMetadata {
    
    const filterSensitiveLog: (obj: OpsMetadata) => any;
}
export interface ListOpsMetadataResult {
    
    OpsMetadataList?: OpsMetadata[];
    
    NextToken?: string;
}
export declare namespace ListOpsMetadataResult {
    
    const filterSensitiveLog: (obj: ListOpsMetadataResult) => any;
}
export interface ListResourceComplianceSummariesRequest {
    
    Filters?: ComplianceStringFilter[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace ListResourceComplianceSummariesRequest {
    
    const filterSensitiveLog: (obj: ListResourceComplianceSummariesRequest) => any;
}

export interface ResourceComplianceSummaryItem {
    
    ComplianceType?: string;
    
    ResourceType?: string;
    
    ResourceId?: string;
    
    Status?: ComplianceStatus | string;
    
    OverallSeverity?: ComplianceSeverity | string;
    
    ExecutionSummary?: ComplianceExecutionSummary;
    
    CompliantSummary?: CompliantSummary;
    
    NonCompliantSummary?: NonCompliantSummary;
}
export declare namespace ResourceComplianceSummaryItem {
    
    const filterSensitiveLog: (obj: ResourceComplianceSummaryItem) => any;
}
export interface ListResourceComplianceSummariesResult {
    
    ResourceComplianceSummaryItems?: ResourceComplianceSummaryItem[];
    
    NextToken?: string;
}
export declare namespace ListResourceComplianceSummariesResult {
    
    const filterSensitiveLog: (obj: ListResourceComplianceSummariesResult) => any;
}
export interface ListResourceDataSyncRequest {
    
    SyncType?: string;
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace ListResourceDataSyncRequest {
    
    const filterSensitiveLog: (obj: ListResourceDataSyncRequest) => any;
}
export declare enum LastResourceDataSyncStatus {
    FAILED = "Failed",
    INPROGRESS = "InProgress",
    SUCCESSFUL = "Successful"
}

export interface ResourceDataSyncSourceWithState {
    
    SourceType?: string;
    
    AwsOrganizationsSource?: ResourceDataSyncAwsOrganizationsSource;
    
    SourceRegions?: string[];
    
    IncludeFutureRegions?: boolean;
    
    State?: string;
    
    EnableAllOpsDataSources?: boolean;
}
export declare namespace ResourceDataSyncSourceWithState {
    
    const filterSensitiveLog: (obj: ResourceDataSyncSourceWithState) => any;
}

export interface ResourceDataSyncItem {
    
    SyncName?: string;
    
    SyncType?: string;
    
    SyncSource?: ResourceDataSyncSourceWithState;
    
    S3Destination?: ResourceDataSyncS3Destination;
    
    LastSyncTime?: Date;
    
    LastSuccessfulSyncTime?: Date;
    
    SyncLastModifiedTime?: Date;
    
    LastStatus?: LastResourceDataSyncStatus | string;
    
    SyncCreatedTime?: Date;
    
    LastSyncStatusMessage?: string;
}
export declare namespace ResourceDataSyncItem {
    
    const filterSensitiveLog: (obj: ResourceDataSyncItem) => any;
}
export interface ListResourceDataSyncResult {
    
    ResourceDataSyncItems?: ResourceDataSyncItem[];
    
    NextToken?: string;
}
export declare namespace ListResourceDataSyncResult {
    
    const filterSensitiveLog: (obj: ListResourceDataSyncResult) => any;
}
export interface ListTagsForResourceRequest {
    
    ResourceType: ResourceTypeForTagging | string | undefined;
    
    ResourceId: string | undefined;
}
export declare namespace ListTagsForResourceRequest {
    
    const filterSensitiveLog: (obj: ListTagsForResourceRequest) => any;
}
export interface ListTagsForResourceResult {
    
    TagList?: Tag[];
}
export declare namespace ListTagsForResourceResult {
    
    const filterSensitiveLog: (obj: ListTagsForResourceResult) => any;
}

export declare class DocumentPermissionLimit extends __BaseException {
    readonly name: "DocumentPermissionLimit";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<DocumentPermissionLimit, __BaseException>);
}
export interface ModifyDocumentPermissionRequest {
    
    Name: string | undefined;
    
    PermissionType: DocumentPermissionType | string | undefined;
    
    AccountIdsToAdd?: string[];
    
    AccountIdsToRemove?: string[];
    
    SharedDocumentVersion?: string;
}
export declare namespace ModifyDocumentPermissionRequest {
    
    const filterSensitiveLog: (obj: ModifyDocumentPermissionRequest) => any;
}
export interface ModifyDocumentPermissionResponse {
}
export declare namespace ModifyDocumentPermissionResponse {
    
    const filterSensitiveLog: (obj: ModifyDocumentPermissionResponse) => any;
}

export declare class ComplianceTypeCountLimitExceededException extends __BaseException {
    readonly name: "ComplianceTypeCountLimitExceededException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ComplianceTypeCountLimitExceededException, __BaseException>);
}

export declare class InvalidItemContentException extends __BaseException {
    readonly name: "InvalidItemContentException";
    readonly $fault: "client";
    TypeName?: string;
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidItemContentException, __BaseException>);
}

export declare class ItemSizeLimitExceededException extends __BaseException {
    readonly name: "ItemSizeLimitExceededException";
    readonly $fault: "client";
    TypeName?: string;
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ItemSizeLimitExceededException, __BaseException>);
}

export interface ComplianceItemEntry {
    
    Id?: string;
    
    Title?: string;
    
    Severity: ComplianceSeverity | string | undefined;
    
    Status: ComplianceStatus | string | undefined;
    
    Details?: Record<string, string>;
}
export declare namespace ComplianceItemEntry {
    
    const filterSensitiveLog: (obj: ComplianceItemEntry) => any;
}
export declare enum ComplianceUploadType {
    Complete = "COMPLETE",
    Partial = "PARTIAL"
}
export interface PutComplianceItemsRequest {
    
    ResourceId: string | undefined;
    
    ResourceType: string | undefined;
    
    ComplianceType: string | undefined;
    
    ExecutionSummary: ComplianceExecutionSummary | undefined;
    
    Items: ComplianceItemEntry[] | undefined;
    
    ItemContentHash?: string;
    
    UploadType?: ComplianceUploadType | string;
}
export declare namespace PutComplianceItemsRequest {
    
    const filterSensitiveLog: (obj: PutComplianceItemsRequest) => any;
}
export interface PutComplianceItemsResult {
}
export declare namespace PutComplianceItemsResult {
    
    const filterSensitiveLog: (obj: PutComplianceItemsResult) => any;
}

export declare class TotalSizeLimitExceededException extends __BaseException {
    readonly name: "TotalSizeLimitExceededException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<TotalSizeLimitExceededException, __BaseException>);
}

export declare class CustomSchemaCountLimitExceededException extends __BaseException {
    readonly name: "CustomSchemaCountLimitExceededException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<CustomSchemaCountLimitExceededException, __BaseException>);
}

export declare class InvalidInventoryItemContextException extends __BaseException {
    readonly name: "InvalidInventoryItemContextException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidInventoryItemContextException, __BaseException>);
}

export declare class ItemContentMismatchException extends __BaseException {
    readonly name: "ItemContentMismatchException";
    readonly $fault: "client";
    TypeName?: string;
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ItemContentMismatchException, __BaseException>);
}

export interface InventoryItem {
    
    TypeName: string | undefined;
    
    SchemaVersion: string | undefined;
    
    CaptureTime: string | undefined;
    
    ContentHash?: string;
    
    Content?: Record<string, string>[];
    
    Context?: Record<string, string>;
}
export declare namespace InventoryItem {
    
    const filterSensitiveLog: (obj: InventoryItem) => any;
}
export interface PutInventoryRequest {
    
    InstanceId: string | undefined;
    
    Items: InventoryItem[] | undefined;
}
export declare namespace PutInventoryRequest {
    
    const filterSensitiveLog: (obj: PutInventoryRequest) => any;
}
export interface PutInventoryResult {
    
    Message?: string;
}
export declare namespace PutInventoryResult {
    
    const filterSensitiveLog: (obj: PutInventoryResult) => any;
}

export declare class SubTypeCountLimitExceededException extends __BaseException {
    readonly name: "SubTypeCountLimitExceededException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<SubTypeCountLimitExceededException, __BaseException>);
}

export declare class UnsupportedInventoryItemContextException extends __BaseException {
    readonly name: "UnsupportedInventoryItemContextException";
    readonly $fault: "client";
    TypeName?: string;
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<UnsupportedInventoryItemContextException, __BaseException>);
}

export declare class UnsupportedInventorySchemaVersionException extends __BaseException {
    readonly name: "UnsupportedInventorySchemaVersionException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<UnsupportedInventorySchemaVersionException, __BaseException>);
}

export declare class HierarchyLevelLimitExceededException extends __BaseException {
    readonly name: "HierarchyLevelLimitExceededException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<HierarchyLevelLimitExceededException, __BaseException>);
}

export declare class HierarchyTypeMismatchException extends __BaseException {
    readonly name: "HierarchyTypeMismatchException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<HierarchyTypeMismatchException, __BaseException>);
}

export declare class IncompatiblePolicyException extends __BaseException {
    readonly name: "IncompatiblePolicyException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<IncompatiblePolicyException, __BaseException>);
}

export declare class InvalidAllowedPatternException extends __BaseException {
    readonly name: "InvalidAllowedPatternException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidAllowedPatternException, __BaseException>);
}

export declare class InvalidPolicyAttributeException extends __BaseException {
    readonly name: "InvalidPolicyAttributeException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidPolicyAttributeException, __BaseException>);
}

export declare class InvalidPolicyTypeException extends __BaseException {
    readonly name: "InvalidPolicyTypeException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidPolicyTypeException, __BaseException>);
}

export declare class ParameterAlreadyExists extends __BaseException {
    readonly name: "ParameterAlreadyExists";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<ParameterAlreadyExists, __BaseException>);
}

export declare class ParameterLimitExceeded extends __BaseException {
    readonly name: "ParameterLimitExceeded";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<ParameterLimitExceeded, __BaseException>);
}

export declare class ParameterMaxVersionLimitExceeded extends __BaseException {
    readonly name: "ParameterMaxVersionLimitExceeded";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<ParameterMaxVersionLimitExceeded, __BaseException>);
}

export declare class ParameterPatternMismatchException extends __BaseException {
    readonly name: "ParameterPatternMismatchException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<ParameterPatternMismatchException, __BaseException>);
}

export declare class PoliciesLimitExceededException extends __BaseException {
    readonly name: "PoliciesLimitExceededException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<PoliciesLimitExceededException, __BaseException>);
}
export interface PutParameterRequest {
    
    Name: string | undefined;
    
    Description?: string;
    
    Value: string | undefined;
    
    Type?: ParameterType | string;
    
    KeyId?: string;
    
    Overwrite?: boolean;
    
    AllowedPattern?: string;
    
    Tags?: Tag[];
    
    Tier?: ParameterTier | string;
    
    Policies?: string;
    
    DataType?: string;
}
export declare namespace PutParameterRequest {
    
    const filterSensitiveLog: (obj: PutParameterRequest) => any;
}
export interface PutParameterResult {
    
    Version?: number;
    
    Tier?: ParameterTier | string;
}
export declare namespace PutParameterResult {
    
    const filterSensitiveLog: (obj: PutParameterResult) => any;
}

export declare class UnsupportedParameterType extends __BaseException {
    readonly name: "UnsupportedParameterType";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<UnsupportedParameterType, __BaseException>);
}
export interface RegisterDefaultPatchBaselineRequest {
    
    BaselineId: string | undefined;
}
export declare namespace RegisterDefaultPatchBaselineRequest {
    
    const filterSensitiveLog: (obj: RegisterDefaultPatchBaselineRequest) => any;
}
export interface RegisterDefaultPatchBaselineResult {
    
    BaselineId?: string;
}
export declare namespace RegisterDefaultPatchBaselineResult {
    
    const filterSensitiveLog: (obj: RegisterDefaultPatchBaselineResult) => any;
}
export interface RegisterPatchBaselineForPatchGroupRequest {
    
    BaselineId: string | undefined;
    
    PatchGroup: string | undefined;
}
export declare namespace RegisterPatchBaselineForPatchGroupRequest {
    
    const filterSensitiveLog: (obj: RegisterPatchBaselineForPatchGroupRequest) => any;
}
export interface RegisterPatchBaselineForPatchGroupResult {
    
    BaselineId?: string;
    
    PatchGroup?: string;
}
export declare namespace RegisterPatchBaselineForPatchGroupResult {
    
    const filterSensitiveLog: (obj: RegisterPatchBaselineForPatchGroupResult) => any;
}
export interface RegisterTargetWithMaintenanceWindowRequest {
    
    WindowId: string | undefined;
    
    ResourceType: MaintenanceWindowResourceType | string | undefined;
    
    Targets: Target[] | undefined;
    
    OwnerInformation?: string;
    
    Name?: string;
    
    Description?: string;
    
    ClientToken?: string;
}
export declare namespace RegisterTargetWithMaintenanceWindowRequest {
    
    const filterSensitiveLog: (obj: RegisterTargetWithMaintenanceWindowRequest) => any;
}
export interface RegisterTargetWithMaintenanceWindowResult {
    
    WindowTargetId?: string;
}
export declare namespace RegisterTargetWithMaintenanceWindowResult {
    
    const filterSensitiveLog: (obj: RegisterTargetWithMaintenanceWindowResult) => any;
}

export declare class FeatureNotAvailableException extends __BaseException {
    readonly name: "FeatureNotAvailableException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<FeatureNotAvailableException, __BaseException>);
}
export interface RegisterTaskWithMaintenanceWindowRequest {
    
    WindowId: string | undefined;
    
    Targets?: Target[];
    
    TaskArn: string | undefined;
    
    ServiceRoleArn?: string;
    
    TaskType: MaintenanceWindowTaskType | string | undefined;
    
    TaskParameters?: Record<string, MaintenanceWindowTaskParameterValueExpression>;
    
    TaskInvocationParameters?: MaintenanceWindowTaskInvocationParameters;
    
    Priority?: number;
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    LoggingInfo?: LoggingInfo;
    
    Name?: string;
    
    Description?: string;
    
    ClientToken?: string;
    
    CutoffBehavior?: MaintenanceWindowTaskCutoffBehavior | string;
}
export declare namespace RegisterTaskWithMaintenanceWindowRequest {
    
    const filterSensitiveLog: (obj: RegisterTaskWithMaintenanceWindowRequest) => any;
}
export interface RegisterTaskWithMaintenanceWindowResult {
    
    WindowTaskId?: string;
}
export declare namespace RegisterTaskWithMaintenanceWindowResult {
    
    const filterSensitiveLog: (obj: RegisterTaskWithMaintenanceWindowResult) => any;
}
export interface RemoveTagsFromResourceRequest {
    
    ResourceType: ResourceTypeForTagging | string | undefined;
    
    ResourceId: string | undefined;
    
    TagKeys: string[] | undefined;
}
export declare namespace RemoveTagsFromResourceRequest {
    
    const filterSensitiveLog: (obj: RemoveTagsFromResourceRequest) => any;
}
export interface RemoveTagsFromResourceResult {
}
export declare namespace RemoveTagsFromResourceResult {
    
    const filterSensitiveLog: (obj: RemoveTagsFromResourceResult) => any;
}

export interface ResetServiceSettingRequest {
    
    SettingId: string | undefined;
}
export declare namespace ResetServiceSettingRequest {
    
    const filterSensitiveLog: (obj: ResetServiceSettingRequest) => any;
}

export interface ResetServiceSettingResult {
    
    ServiceSetting?: ServiceSetting;
}
export declare namespace ResetServiceSettingResult {
    
    const filterSensitiveLog: (obj: ResetServiceSettingResult) => any;
}
export interface ResumeSessionRequest {
    
    SessionId: string | undefined;
}
export declare namespace ResumeSessionRequest {
    
    const filterSensitiveLog: (obj: ResumeSessionRequest) => any;
}
export interface ResumeSessionResponse {
    
    SessionId?: string;
    
    TokenValue?: string;
    
    StreamUrl?: string;
}
export declare namespace ResumeSessionResponse {
    
    const filterSensitiveLog: (obj: ResumeSessionResponse) => any;
}

export declare class AutomationStepNotFoundException extends __BaseException {
    readonly name: "AutomationStepNotFoundException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<AutomationStepNotFoundException, __BaseException>);
}

export declare class InvalidAutomationSignalException extends __BaseException {
    readonly name: "InvalidAutomationSignalException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidAutomationSignalException, __BaseException>);
}
export declare enum SignalType {
    APPROVE = "Approve",
    REJECT = "Reject",
    RESUME = "Resume",
    START_STEP = "StartStep",
    STOP_STEP = "StopStep"
}
export interface SendAutomationSignalRequest {
    
    AutomationExecutionId: string | undefined;
    
    SignalType: SignalType | string | undefined;
    
    Payload?: Record<string, string[]>;
}
export declare namespace SendAutomationSignalRequest {
    
    const filterSensitiveLog: (obj: SendAutomationSignalRequest) => any;
}
export interface SendAutomationSignalResult {
}
export declare namespace SendAutomationSignalResult {
    
    const filterSensitiveLog: (obj: SendAutomationSignalResult) => any;
}

export declare class InvalidNotificationConfig extends __BaseException {
    readonly name: "InvalidNotificationConfig";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidNotificationConfig, __BaseException>);
}

export declare class InvalidOutputFolder extends __BaseException {
    readonly name: "InvalidOutputFolder";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<InvalidOutputFolder, __BaseException>);
}

export declare class InvalidRole extends __BaseException {
    readonly name: "InvalidRole";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidRole, __BaseException>);
}
export interface SendCommandRequest {
    
    InstanceIds?: string[];
    
    Targets?: Target[];
    
    DocumentName: string | undefined;
    
    DocumentVersion?: string;
    
    DocumentHash?: string;
    
    DocumentHashType?: DocumentHashType | string;
    
    TimeoutSeconds?: number;
    
    Comment?: string;
    
    Parameters?: Record<string, string[]>;
    
    OutputS3Region?: string;
    
    OutputS3BucketName?: string;
    
    OutputS3KeyPrefix?: string;
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    ServiceRoleArn?: string;
    
    NotificationConfig?: NotificationConfig;
    
    CloudWatchOutputConfig?: CloudWatchOutputConfig;
}
export declare namespace SendCommandRequest {
    
    const filterSensitiveLog: (obj: SendCommandRequest) => any;
}
export interface SendCommandResult {
    
    Command?: Command;
}
export declare namespace SendCommandResult {
    
    const filterSensitiveLog: (obj: SendCommandResult) => any;
}

export declare class InvalidAssociation extends __BaseException {
    readonly name: "InvalidAssociation";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidAssociation, __BaseException>);
}
export interface StartAssociationsOnceRequest {
    
    AssociationIds: string[] | undefined;
}
export declare namespace StartAssociationsOnceRequest {
    
    const filterSensitiveLog: (obj: StartAssociationsOnceRequest) => any;
}
export interface StartAssociationsOnceResult {
}
export declare namespace StartAssociationsOnceResult {
    
    const filterSensitiveLog: (obj: StartAssociationsOnceResult) => any;
}

export declare class AutomationDefinitionNotFoundException extends __BaseException {
    readonly name: "AutomationDefinitionNotFoundException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<AutomationDefinitionNotFoundException, __BaseException>);
}

export declare class AutomationDefinitionVersionNotFoundException extends __BaseException {
    readonly name: "AutomationDefinitionVersionNotFoundException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<AutomationDefinitionVersionNotFoundException, __BaseException>);
}

export declare class AutomationExecutionLimitExceededException extends __BaseException {
    readonly name: "AutomationExecutionLimitExceededException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<AutomationExecutionLimitExceededException, __BaseException>);
}

export declare class InvalidAutomationExecutionParametersException extends __BaseException {
    readonly name: "InvalidAutomationExecutionParametersException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidAutomationExecutionParametersException, __BaseException>);
}
export interface StartAutomationExecutionRequest {
    
    DocumentName: string | undefined;
    
    DocumentVersion?: string;
    
    Parameters?: Record<string, string[]>;
    
    ClientToken?: string;
    
    Mode?: ExecutionMode | string;
    
    TargetParameterName?: string;
    
    Targets?: Target[];
    
    TargetMaps?: Record<string, string[]>[];
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    TargetLocations?: TargetLocation[];
    
    Tags?: Tag[];
}
export declare namespace StartAutomationExecutionRequest {
    
    const filterSensitiveLog: (obj: StartAutomationExecutionRequest) => any;
}
export interface StartAutomationExecutionResult {
    
    AutomationExecutionId?: string;
}
export declare namespace StartAutomationExecutionResult {
    
    const filterSensitiveLog: (obj: StartAutomationExecutionResult) => any;
}

export declare class AutomationDefinitionNotApprovedException extends __BaseException {
    readonly name: "AutomationDefinitionNotApprovedException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<AutomationDefinitionNotApprovedException, __BaseException>);
}
export interface StartChangeRequestExecutionRequest {
    
    ScheduledTime?: Date;
    
    DocumentName: string | undefined;
    
    DocumentVersion?: string;
    
    Parameters?: Record<string, string[]>;
    
    ChangeRequestName?: string;
    
    ClientToken?: string;
    
    AutoApprove?: boolean;
    
    Runbooks: Runbook[] | undefined;
    
    Tags?: Tag[];
    
    ScheduledEndTime?: Date;
    
    ChangeDetails?: string;
}
export declare namespace StartChangeRequestExecutionRequest {
    
    const filterSensitiveLog: (obj: StartChangeRequestExecutionRequest) => any;
}
export interface StartChangeRequestExecutionResult {
    
    AutomationExecutionId?: string;
}
export declare namespace StartChangeRequestExecutionResult {
    
    const filterSensitiveLog: (obj: StartChangeRequestExecutionResult) => any;
}
export interface StartSessionRequest {
    
    Target: string | undefined;
    
    DocumentName?: string;
    
    Reason?: string;
    
    Parameters?: Record<string, string[]>;
}
export declare namespace StartSessionRequest {
    
    const filterSensitiveLog: (obj: StartSessionRequest) => any;
}
export interface StartSessionResponse {
    
    SessionId?: string;
    
    TokenValue?: string;
    
    StreamUrl?: string;
}
export declare namespace StartSessionResponse {
    
    const filterSensitiveLog: (obj: StartSessionResponse) => any;
}

export declare class TargetNotConnected extends __BaseException {
    readonly name: "TargetNotConnected";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<TargetNotConnected, __BaseException>);
}

export declare class InvalidAutomationStatusUpdateException extends __BaseException {
    readonly name: "InvalidAutomationStatusUpdateException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidAutomationStatusUpdateException, __BaseException>);
}
export declare enum StopType {
    CANCEL = "Cancel",
    COMPLETE = "Complete"
}
export interface StopAutomationExecutionRequest {
    
    AutomationExecutionId: string | undefined;
    
    Type?: StopType | string;
}
export declare namespace StopAutomationExecutionRequest {
    
    const filterSensitiveLog: (obj: StopAutomationExecutionRequest) => any;
}
export interface StopAutomationExecutionResult {
}
export declare namespace StopAutomationExecutionResult {
    
    const filterSensitiveLog: (obj: StopAutomationExecutionResult) => any;
}
export interface TerminateSessionRequest {
    
    SessionId: string | undefined;
}
export declare namespace TerminateSessionRequest {
    
    const filterSensitiveLog: (obj: TerminateSessionRequest) => any;
}
export interface TerminateSessionResponse {
    
    SessionId?: string;
}
export declare namespace TerminateSessionResponse {
    
    const filterSensitiveLog: (obj: TerminateSessionResponse) => any;
}
export interface UnlabelParameterVersionRequest {
    
    Name: string | undefined;
    
    ParameterVersion: number | undefined;
    
    Labels: string[] | undefined;
}
export declare namespace UnlabelParameterVersionRequest {
    
    const filterSensitiveLog: (obj: UnlabelParameterVersionRequest) => any;
}
export interface UnlabelParameterVersionResult {
    
    RemovedLabels?: string[];
    
    InvalidLabels?: string[];
}
export declare namespace UnlabelParameterVersionResult {
    
    const filterSensitiveLog: (obj: UnlabelParameterVersionResult) => any;
}

export declare class AssociationVersionLimitExceeded extends __BaseException {
    readonly name: "AssociationVersionLimitExceeded";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<AssociationVersionLimitExceeded, __BaseException>);
}

export declare class InvalidUpdate extends __BaseException {
    readonly name: "InvalidUpdate";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<InvalidUpdate, __BaseException>);
}
export interface UpdateAssociationRequest {
    
    AssociationId: string | undefined;
    
    Parameters?: Record<string, string[]>;
    
    DocumentVersion?: string;
    
    ScheduleExpression?: string;
    
    OutputLocation?: InstanceAssociationOutputLocation;
    
    Name?: string;
    
    Targets?: Target[];
    
    AssociationName?: string;
    
    AssociationVersion?: string;
    
    AutomationTargetParameterName?: string;
    
    MaxErrors?: string;
    
    MaxConcurrency?: string;
    
    ComplianceSeverity?: AssociationComplianceSeverity | string;
    
    SyncCompliance?: AssociationSyncCompliance | string;
    
    ApplyOnlyAtCronInterval?: boolean;
    
    CalendarNames?: string[];
    
    TargetLocations?: TargetLocation[];
    
    ScheduleOffset?: number;
    
    TargetMaps?: Record<string, string[]>[];
}
export declare namespace UpdateAssociationRequest {
    
    const filterSensitiveLog: (obj: UpdateAssociationRequest) => any;
}
export interface UpdateAssociationResult {
    
    AssociationDescription?: AssociationDescription;
}
export declare namespace UpdateAssociationResult {
    
    const filterSensitiveLog: (obj: UpdateAssociationResult) => any;
}

export declare class StatusUnchanged extends __BaseException {
    readonly name: "StatusUnchanged";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<StatusUnchanged, __BaseException>);
}
export interface UpdateAssociationStatusRequest {
    
    Name: string | undefined;
    
    InstanceId: string | undefined;
    
    AssociationStatus: AssociationStatus | undefined;
}
export declare namespace UpdateAssociationStatusRequest {
    
    const filterSensitiveLog: (obj: UpdateAssociationStatusRequest) => any;
}
export interface UpdateAssociationStatusResult {
    
    AssociationDescription?: AssociationDescription;
}
export declare namespace UpdateAssociationStatusResult {
    
    const filterSensitiveLog: (obj: UpdateAssociationStatusResult) => any;
}

export declare class DocumentVersionLimitExceeded extends __BaseException {
    readonly name: "DocumentVersionLimitExceeded";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<DocumentVersionLimitExceeded, __BaseException>);
}

export declare class DuplicateDocumentContent extends __BaseException {
    readonly name: "DuplicateDocumentContent";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<DuplicateDocumentContent, __BaseException>);
}

export declare class DuplicateDocumentVersionName extends __BaseException {
    readonly name: "DuplicateDocumentVersionName";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<DuplicateDocumentVersionName, __BaseException>);
}
export interface UpdateDocumentRequest {
    
    Content: string | undefined;
    
    Attachments?: AttachmentsSource[];
    
    Name: string | undefined;
    
    DisplayName?: string;
    
    VersionName?: string;
    
    DocumentVersion?: string;
    
    DocumentFormat?: DocumentFormat | string;
    
    TargetType?: string;
}
export declare namespace UpdateDocumentRequest {
    
    const filterSensitiveLog: (obj: UpdateDocumentRequest) => any;
}
export interface UpdateDocumentResult {
    
    DocumentDescription?: DocumentDescription;
}
export declare namespace UpdateDocumentResult {
    
    const filterSensitiveLog: (obj: UpdateDocumentResult) => any;
}
export interface UpdateDocumentDefaultVersionRequest {
    
    Name: string | undefined;
    
    DocumentVersion: string | undefined;
}
export declare namespace UpdateDocumentDefaultVersionRequest {
    
    const filterSensitiveLog: (obj: UpdateDocumentDefaultVersionRequest) => any;
}

export interface DocumentDefaultVersionDescription {
    
    Name?: string;
    
    DefaultVersion?: string;
    
    DefaultVersionName?: string;
}
export declare namespace DocumentDefaultVersionDescription {
    
    const filterSensitiveLog: (obj: DocumentDefaultVersionDescription) => any;
}
export interface UpdateDocumentDefaultVersionResult {
    
    Description?: DocumentDefaultVersionDescription;
}
export declare namespace UpdateDocumentDefaultVersionResult {
    
    const filterSensitiveLog: (obj: UpdateDocumentDefaultVersionResult) => any;
}
export declare enum DocumentReviewAction {
    Approve = "Approve",
    Reject = "Reject",
    SendForReview = "SendForReview",
    UpdateReview = "UpdateReview"
}

export interface DocumentReviews {
    
    Action: DocumentReviewAction | string | undefined;
    
    Comment?: DocumentReviewCommentSource[];
}
export declare namespace DocumentReviews {
    
    const filterSensitiveLog: (obj: DocumentReviews) => any;
}
