import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { LoggingInfo, MaintenanceWindowTaskCutoffBehavior, MaintenanceWindowTaskParameterValueExpression, MetadataValue, OperatingSystem, OpsItemDataValue, OpsItemNotification, OpsItemStatus, PatchAction, PatchComplianceLevel, PatchFilterGroup, PatchRuleGroup, PatchSource, RelatedOpsItem, ResourceDataSyncSource, Target } from "./models_0";
import { DocumentReviews, InventoryFilter, InventoryGroup, MaintenanceWindowTaskInvocationParameters, OpsFilter, OpsResultAttribute, ResultAttribute } from "./models_1";
import { SSMServiceException as __BaseException } from "./SSMServiceException";
export interface UpdateDocumentMetadataRequest {
    
    Name: string | undefined;
    
    DocumentVersion?: string;
    
    DocumentReviews: DocumentReviews | undefined;
}
export declare namespace UpdateDocumentMetadataRequest {
    
    const filterSensitiveLog: (obj: UpdateDocumentMetadataRequest) => any;
}
export interface UpdateDocumentMetadataResponse {
}
export declare namespace UpdateDocumentMetadataResponse {
    
    const filterSensitiveLog: (obj: UpdateDocumentMetadataResponse) => any;
}
export interface UpdateMaintenanceWindowRequest {
    
    WindowId: string | undefined;
    
    Name?: string;
    
    Description?: string;
    
    StartDate?: string;
    
    EndDate?: string;
    
    Schedule?: string;
    
    ScheduleTimezone?: string;
    
    ScheduleOffset?: number;
    
    Duration?: number;
    
    Cutoff?: number;
    
    AllowUnassociatedTargets?: boolean;
    
    Enabled?: boolean;
    
    Replace?: boolean;
}
export declare namespace UpdateMaintenanceWindowRequest {
    
    const filterSensitiveLog: (obj: UpdateMaintenanceWindowRequest) => any;
}
export interface UpdateMaintenanceWindowResult {
    
    WindowId?: string;
    
    Name?: string;
    
    Description?: string;
    
    StartDate?: string;
    
    EndDate?: string;
    
    Schedule?: string;
    
    ScheduleTimezone?: string;
    
    ScheduleOffset?: number;
    
    Duration?: number;
    
    Cutoff?: number;
    
    AllowUnassociatedTargets?: boolean;
    
    Enabled?: boolean;
}
export declare namespace UpdateMaintenanceWindowResult {
    
    const filterSensitiveLog: (obj: UpdateMaintenanceWindowResult) => any;
}
export interface UpdateMaintenanceWindowTargetRequest {
    
    WindowId: string | undefined;
    
    WindowTargetId: string | undefined;
    
    Targets?: Target[];
    
    OwnerInformation?: string;
    
    Name?: string;
    
    Description?: string;
    
    Replace?: boolean;
}
export declare namespace UpdateMaintenanceWindowTargetRequest {
    
    const filterSensitiveLog: (obj: UpdateMaintenanceWindowTargetRequest) => any;
}
export interface UpdateMaintenanceWindowTargetResult {
    
    WindowId?: string;
    
    WindowTargetId?: string;
    
    Targets?: Target[];
    
    OwnerInformation?: string;
    
    Name?: string;
    
    Description?: string;
}
export declare namespace UpdateMaintenanceWindowTargetResult {
    
    const filterSensitiveLog: (obj: UpdateMaintenanceWindowTargetResult) => any;
}
export interface UpdateMaintenanceWindowTaskRequest {
    
    WindowId: string | undefined;
    
    WindowTaskId: string | undefined;
    
    Targets?: Target[];
    
    TaskArn?: string;
    
    ServiceRoleArn?: string;
    
    TaskParameters?: Record<string, MaintenanceWindowTaskParameterValueExpression>;
    
    TaskInvocationParameters?: MaintenanceWindowTaskInvocationParameters;
    
    Priority?: number;
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    LoggingInfo?: LoggingInfo;
    
    Name?: string;
    
    Description?: string;
    
    Replace?: boolean;
    
    CutoffBehavior?: MaintenanceWindowTaskCutoffBehavior | string;
}
export declare namespace UpdateMaintenanceWindowTaskRequest {
    
    const filterSensitiveLog: (obj: UpdateMaintenanceWindowTaskRequest) => any;
}
export interface UpdateMaintenanceWindowTaskResult {
    
    WindowId?: string;
    
    WindowTaskId?: string;
    
    Targets?: Target[];
    
    TaskArn?: string;
    
    ServiceRoleArn?: string;
    
    TaskParameters?: Record<string, MaintenanceWindowTaskParameterValueExpression>;
    
    TaskInvocationParameters?: MaintenanceWindowTaskInvocationParameters;
    
    Priority?: number;
    
    MaxConcurrency?: string;
    
    MaxErrors?: string;
    
    LoggingInfo?: LoggingInfo;
    
    Name?: string;
    
    Description?: string;
    
    CutoffBehavior?: MaintenanceWindowTaskCutoffBehavior | string;
}
export declare namespace UpdateMaintenanceWindowTaskResult {
    
    const filterSensitiveLog: (obj: UpdateMaintenanceWindowTaskResult) => any;
}
export interface UpdateManagedInstanceRoleRequest {
    
    InstanceId: string | undefined;
    
    IamRole: string | undefined;
}
export declare namespace UpdateManagedInstanceRoleRequest {
    
    const filterSensitiveLog: (obj: UpdateManagedInstanceRoleRequest) => any;
}
export interface UpdateManagedInstanceRoleResult {
}
export declare namespace UpdateManagedInstanceRoleResult {
    
    const filterSensitiveLog: (obj: UpdateManagedInstanceRoleResult) => any;
}
export interface UpdateOpsItemRequest {
    
    Description?: string;
    
    OperationalData?: Record<string, OpsItemDataValue>;
    
    OperationalDataToDelete?: string[];
    
    Notifications?: OpsItemNotification[];
    
    Priority?: number;
    
    RelatedOpsItems?: RelatedOpsItem[];
    
    Status?: OpsItemStatus | string;
    
    OpsItemId: string | undefined;
    
    Title?: string;
    
    Category?: string;
    
    Severity?: string;
    
    ActualStartTime?: Date;
    
    ActualEndTime?: Date;
    
    PlannedStartTime?: Date;
    
    PlannedEndTime?: Date;
}
export declare namespace UpdateOpsItemRequest {
    
    const filterSensitiveLog: (obj: UpdateOpsItemRequest) => any;
}
export interface UpdateOpsItemResponse {
}
export declare namespace UpdateOpsItemResponse {
    
    const filterSensitiveLog: (obj: UpdateOpsItemResponse) => any;
}

export declare class OpsMetadataKeyLimitExceededException extends __BaseException {
    readonly name: "OpsMetadataKeyLimitExceededException";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<OpsMetadataKeyLimitExceededException, __BaseException>);
}
export interface UpdateOpsMetadataRequest {
    
    OpsMetadataArn: string | undefined;
    
    MetadataToUpdate?: Record<string, MetadataValue>;
    
    KeysToDelete?: string[];
}
export declare namespace UpdateOpsMetadataRequest {
    
    const filterSensitiveLog: (obj: UpdateOpsMetadataRequest) => any;
}
export interface UpdateOpsMetadataResult {
    
    OpsMetadataArn?: string;
}
export declare namespace UpdateOpsMetadataResult {
    
    const filterSensitiveLog: (obj: UpdateOpsMetadataResult) => any;
}
export interface UpdatePatchBaselineRequest {
    
    BaselineId: string | undefined;
    
    Name?: string;
    
    GlobalFilters?: PatchFilterGroup;
    
    ApprovalRules?: PatchRuleGroup;
    
    ApprovedPatches?: string[];
    
    ApprovedPatchesComplianceLevel?: PatchComplianceLevel | string;
    
    ApprovedPatchesEnableNonSecurity?: boolean;
    
    RejectedPatches?: string[];
    
    RejectedPatchesAction?: PatchAction | string;
    
    Description?: string;
    
    Sources?: PatchSource[];
    
    Replace?: boolean;
}
export declare namespace UpdatePatchBaselineRequest {
    
    const filterSensitiveLog: (obj: UpdatePatchBaselineRequest) => any;
}
export interface UpdatePatchBaselineResult {
    
    BaselineId?: string;
    
    Name?: string;
    
    OperatingSystem?: OperatingSystem | string;
    
    GlobalFilters?: PatchFilterGroup;
    
    ApprovalRules?: PatchRuleGroup;
    
    ApprovedPatches?: string[];
    
    ApprovedPatchesComplianceLevel?: PatchComplianceLevel | string;
    
    ApprovedPatchesEnableNonSecurity?: boolean;
    
    RejectedPatches?: string[];
    
    RejectedPatchesAction?: PatchAction | string;
    
    CreatedDate?: Date;
    
    ModifiedDate?: Date;
    
    Description?: string;
    
    Sources?: PatchSource[];
}
export declare namespace UpdatePatchBaselineResult {
    
    const filterSensitiveLog: (obj: UpdatePatchBaselineResult) => any;
}

export declare class ResourceDataSyncConflictException extends __BaseException {
    readonly name: "ResourceDataSyncConflictException";
    readonly $fault: "client";
    Message?: string;
    
    constructor(opts: __ExceptionOptionType<ResourceDataSyncConflictException, __BaseException>);
}
export interface UpdateResourceDataSyncRequest {
    
    SyncName: string | undefined;
    
    SyncType: string | undefined;
    
    SyncSource: ResourceDataSyncSource | undefined;
}
export declare namespace UpdateResourceDataSyncRequest {
    
    const filterSensitiveLog: (obj: UpdateResourceDataSyncRequest) => any;
}
export interface UpdateResourceDataSyncResult {
}
export declare namespace UpdateResourceDataSyncResult {
    
    const filterSensitiveLog: (obj: UpdateResourceDataSyncResult) => any;
}

export interface UpdateServiceSettingRequest {
    
    SettingId: string | undefined;
    
    SettingValue: string | undefined;
}
export declare namespace UpdateServiceSettingRequest {
    
    const filterSensitiveLog: (obj: UpdateServiceSettingRequest) => any;
}

export interface UpdateServiceSettingResult {
}
export declare namespace UpdateServiceSettingResult {
    
    const filterSensitiveLog: (obj: UpdateServiceSettingResult) => any;
}

export interface InventoryAggregator {
    
    Expression?: string;
    
    Aggregators?: InventoryAggregator[];
    
    Groups?: InventoryGroup[];
}
export declare namespace InventoryAggregator {
    
    const filterSensitiveLog: (obj: InventoryAggregator) => any;
}

export interface OpsAggregator {
    
    AggregatorType?: string;
    
    TypeName?: string;
    
    AttributeName?: string;
    
    Values?: Record<string, string>;
    
    Filters?: OpsFilter[];
    
    Aggregators?: OpsAggregator[];
}
export declare namespace OpsAggregator {
    
    const filterSensitiveLog: (obj: OpsAggregator) => any;
}
export interface GetInventoryRequest {
    
    Filters?: InventoryFilter[];
    
    Aggregators?: InventoryAggregator[];
    
    ResultAttributes?: ResultAttribute[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace GetInventoryRequest {
    
    const filterSensitiveLog: (obj: GetInventoryRequest) => any;
}
export interface GetOpsSummaryRequest {
    
    SyncName?: string;
    
    Filters?: OpsFilter[];
    
    Aggregators?: OpsAggregator[];
    
    ResultAttributes?: OpsResultAttribute[];
    
    NextToken?: string;
    
    MaxResults?: number;
}
export declare namespace GetOpsSummaryRequest {
    
    const filterSensitiveLog: (obj: GetOpsSummaryRequest) => any;
}
