import sys
from setuptools import setup, find_packages
import codecs
import os

here = os.path.abspath(os.path.dirname(__file__))

with codecs.open(os.path.join(here, "README.md"), encoding="utf-8") as fh:
    long_description = "\n" + fh.read()

if sys.argv[-1] == 'publish':
    if os.system("pip freeze | grep twine"):
        print("twine not installed.\nUse `pip install twine`.\nExiting.")
        sys.exit()
    os.system("python setup.py sdist bdist_wheel")
    if os.system("twine check dist/*"):
        print("twine check failed. Packages might be outdated.")
        print("Try using `pip install -U twine wheel`.\nExiting.")
        sys.exit()
    os.system("twine upload dist/*")
    sys.exit()

PACKAGE = "pyclick"
PACKAGE_NAME = "python-click"
VERSION = '0.1.4'
DESCRIPTION = 'Этот пакет позволяет легко интегрировать платежную систему Click через фреймворк Django в Python'

setup(
    name=PACKAGE_NAME,
    version=VERSION,
    author="Sirojiddin Yakubov",
    author_email="yakubov9791999@gmail.com",
    description=DESCRIPTION,
    long_description_content_type="text/markdown",
    long_description=long_description,
    python_requires=">=3.6",
    packages=find_packages(),
    install_requires=['django', 'djangorestframework', 'requests'],
    keywords=['python', 'click', 'django', 'django rest framework', 'requests', 'python-click', 'pyclick',
              'yakubov9791999', "Sirojiddin Yakubov", "Yakubov Developer"],
    url="https://github.com/yakubov9791999/python-click",
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: Web Environment',
        'Framework :: Django',
        'Framework :: Django :: 3.0',
        'Framework :: Django :: 3.1',
        'Framework :: Django :: 3.2',
        'Framework :: Django :: 4.0',
        'Framework :: Django :: 4.1',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3.10',
        'Programming Language :: Python :: 3 :: Only',
        'Topic :: Internet :: WWW/HTTP',
    ],
    project_urls={
        'Source': 'https://github.com/yakubov9791999/python-click',
    },
)
