"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const core_1 = require("@aws-solutions-constructs/core");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-apigateway-dynamodb';
// Definitions
const props = {
    allowReadOperation: true,
    allowCreateOperation: true,
    allowDeleteOperation: true,
    allowUpdateOperation: true,
    createRequestTemplate: "{\r\n  \"TableName\": \"${Table}\",\r\n  \"Item\": {\r\n    \"id\": {\r\n      \"S\": \"$input.path('$.id')\"\r\n    },\r\n    \"EventCount\": {\r\n      \"N\": \"$input.path('$.EventCount')\"\r\n    },\r\n    \"Message\": {\r\n      \"S\": \"$input.path('$.Message')\"\r\n    }\r\n  }\r\n}",
    updateRequestTemplate: "{\r\n  \"TableName\": \"${Table}\",\r\n  \"Key\": {\r\n    \"id\": {\r\n      \"S\": \"$input.path('$.id')\"\r\n    }\r\n  },\r\n  \"ExpressionAttributeValues\": {\r\n    \":event_count\": {\r\n      \"N\": \"$input.path('$.EventCount')\"\r\n    },\r\n    \":message\": {\r\n      \"S\": \"$input.path('$.Message')\"\r\n    }\r\n  },\r\n  \"UpdateExpression\": \"ADD EventCount :event_count SET Message = :message\",\r\n  \"ReturnValues\": \"ALL_NEW\"\r\n}"
};
new lib_1.ApiGatewayToDynamoDB(stack, 'test-api-gateway-dynamodb', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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