"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAuthorizerFunctions = void 0;
const predicates_1 = require("../authorizers/predicates");
const api_gateway_auth_1 = require("./api-gateway-auth");
/**
 * Return all lambda functions used as authorizers, labelled by authorizer id
 */
exports.getAuthorizerFunctions = (options) => api_gateway_auth_1.getAllAuthorizers(options.integrations, options.defaultAuthorizer)
    .filter((authorizer) => predicates_1.isCustomAuthorizer(authorizer))
    .map((authorizer) => ({
    label: authorizer.authorizerId,
    function: authorizer.function,
}));
//# sourceMappingURL=data:application/json;base64,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