# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class AddTagsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTagsRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AddTagsRequest(TeaModel):
    def __init__(self, group_ids=None, region_id=None, tag=None):
        self.group_ids = group_ids  # type: list[str]
        self.region_id = region_id  # type: str
        self.tag = tag  # type: list[AddTagsRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddTagsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = AddTagsRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class AddTagsResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTagsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddTagsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyMetricRuleTemplateRequest(TeaModel):
    def __init__(self, apply_mode=None, enable_end_time=None, enable_start_time=None, group_id=None,
                 notify_level=None, silence_time=None, template_ids=None, webhook=None):
        self.apply_mode = apply_mode  # type: str
        self.enable_end_time = enable_end_time  # type: long
        self.enable_start_time = enable_start_time  # type: long
        self.group_id = group_id  # type: long
        self.notify_level = notify_level  # type: long
        self.silence_time = silence_time  # type: long
        self.template_ids = template_ids  # type: str
        self.webhook = webhook  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyMetricRuleTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_mode is not None:
            result['ApplyMode'] = self.apply_mode
        if self.enable_end_time is not None:
            result['EnableEndTime'] = self.enable_end_time
        if self.enable_start_time is not None:
            result['EnableStartTime'] = self.enable_start_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.notify_level is not None:
            result['NotifyLevel'] = self.notify_level
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.template_ids is not None:
            result['TemplateIds'] = self.template_ids
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyMode') is not None:
            self.apply_mode = m.get('ApplyMode')
        if m.get('EnableEndTime') is not None:
            self.enable_end_time = m.get('EnableEndTime')
        if m.get('EnableStartTime') is not None:
            self.enable_start_time = m.get('EnableStartTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('NotifyLevel') is not None:
            self.notify_level = m.get('NotifyLevel')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('TemplateIds') is not None:
            self.template_ids = m.get('TemplateIds')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class ApplyMetricRuleTemplateResponseBodyResourceAlertResults(TeaModel):
    def __init__(self, code=None, message=None, rule_id=None, rule_name=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.rule_id = rule_id  # type: str
        self.rule_name = rule_name  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyMetricRuleTemplateResponseBodyResourceAlertResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ApplyMetricRuleTemplateResponseBodyResource(TeaModel):
    def __init__(self, alert_results=None, group_id=None):
        self.alert_results = alert_results  # type: list[ApplyMetricRuleTemplateResponseBodyResourceAlertResults]
        self.group_id = group_id  # type: long

    def validate(self):
        if self.alert_results:
            for k in self.alert_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ApplyMetricRuleTemplateResponseBodyResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertResults'] = []
        if self.alert_results is not None:
            for k in self.alert_results:
                result['AlertResults'].append(k.to_map() if k else None)
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alert_results = []
        if m.get('AlertResults') is not None:
            for k in m.get('AlertResults'):
                temp_model = ApplyMetricRuleTemplateResponseBodyResourceAlertResults()
                self.alert_results.append(temp_model.from_map(k))
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class ApplyMetricRuleTemplateResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, resource=None, success=None):
        self.code = code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.resource = resource  # type: ApplyMetricRuleTemplateResponseBodyResource
        self.success = success  # type: bool

    def validate(self):
        if self.resource:
            self.resource.validate()

    def to_map(self):
        _map = super(ApplyMetricRuleTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource is not None:
            result['Resource'] = self.resource.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resource') is not None:
            temp_model = ApplyMetricRuleTemplateResponseBodyResource()
            self.resource = temp_model.from_map(m['Resource'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ApplyMetricRuleTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ApplyMetricRuleTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ApplyMetricRuleTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyMetricRuleTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCreateIntantSiteMonitorRequestTaskList(TeaModel):
    def __init__(self, address=None, isp_cities=None, options_json=None, task_name=None, task_type=None):
        self.address = address  # type: str
        self.isp_cities = isp_cities  # type: str
        self.options_json = options_json  # type: str
        self.task_name = task_name  # type: str
        self.task_type = task_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCreateIntantSiteMonitorRequestTaskList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.isp_cities is not None:
            result['IspCities'] = self.isp_cities
        if self.options_json is not None:
            result['OptionsJson'] = self.options_json
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('IspCities') is not None:
            self.isp_cities = m.get('IspCities')
        if m.get('OptionsJson') is not None:
            self.options_json = m.get('OptionsJson')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class BatchCreateIntantSiteMonitorRequest(TeaModel):
    def __init__(self, region_id=None, task_list=None):
        self.region_id = region_id  # type: str
        self.task_list = task_list  # type: list[BatchCreateIntantSiteMonitorRequestTaskList]

    def validate(self):
        if self.task_list:
            for k in self.task_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchCreateIntantSiteMonitorRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['TaskList'] = []
        if self.task_list is not None:
            for k in self.task_list:
                result['TaskList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.task_list = []
        if m.get('TaskList') is not None:
            for k in m.get('TaskList'):
                temp_model = BatchCreateIntantSiteMonitorRequestTaskList()
                self.task_list.append(temp_model.from_map(k))
        return self


class BatchCreateIntantSiteMonitorResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        # Id of the request
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCreateIntantSiteMonitorResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchCreateIntantSiteMonitorResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchCreateIntantSiteMonitorResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchCreateIntantSiteMonitorResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchCreateIntantSiteMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCmsCallNumOrderRequest(TeaModel):
    def __init__(self, auto_pay=None, auto_renew_period=None, auto_use_coupon=None, period=None, period_unit=None,
                 phone_count=None):
        self.auto_pay = auto_pay  # type: bool
        self.auto_renew_period = auto_renew_period  # type: int
        self.auto_use_coupon = auto_use_coupon  # type: bool
        self.period = period  # type: int
        self.period_unit = period_unit  # type: str
        self.phone_count = phone_count  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCmsCallNumOrderRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.auto_renew_period is not None:
            result['AutoRenewPeriod'] = self.auto_renew_period
        if self.auto_use_coupon is not None:
            result['AutoUseCoupon'] = self.auto_use_coupon
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.phone_count is not None:
            result['PhoneCount'] = self.phone_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('AutoRenewPeriod') is not None:
            self.auto_renew_period = m.get('AutoRenewPeriod')
        if m.get('AutoUseCoupon') is not None:
            self.auto_use_coupon = m.get('AutoUseCoupon')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PhoneCount') is not None:
            self.phone_count = m.get('PhoneCount')
        return self


class CreateCmsCallNumOrderResponseBody(TeaModel):
    def __init__(self, order_id=None, request_id=None):
        self.order_id = order_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCmsCallNumOrderResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCmsCallNumOrderResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCmsCallNumOrderResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCmsCallNumOrderResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCmsCallNumOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCmsOrderRequest(TeaModel):
    def __init__(self, api_count=None, auto_pay=None, auto_renew_period=None, auto_use_coupon=None,
                 custom_time_series=None, event_store_num=None, event_store_time=None, log_monitor_stream=None, pay_type=None,
                 period=None, period_unit=None, phone_count=None, site_ecs_num=None, site_operator_num=None,
                 site_task_num=None, sms_count=None, suggest_type=None):
        self.api_count = api_count  # type: str
        self.auto_pay = auto_pay  # type: bool
        self.auto_renew_period = auto_renew_period  # type: int
        self.auto_use_coupon = auto_use_coupon  # type: bool
        self.custom_time_series = custom_time_series  # type: str
        self.event_store_num = event_store_num  # type: str
        self.event_store_time = event_store_time  # type: str
        self.log_monitor_stream = log_monitor_stream  # type: str
        self.pay_type = pay_type  # type: str
        self.period = period  # type: int
        self.period_unit = period_unit  # type: str
        self.phone_count = phone_count  # type: str
        self.site_ecs_num = site_ecs_num  # type: str
        self.site_operator_num = site_operator_num  # type: str
        self.site_task_num = site_task_num  # type: str
        self.sms_count = sms_count  # type: str
        self.suggest_type = suggest_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCmsOrderRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_count is not None:
            result['ApiCount'] = self.api_count
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.auto_renew_period is not None:
            result['AutoRenewPeriod'] = self.auto_renew_period
        if self.auto_use_coupon is not None:
            result['AutoUseCoupon'] = self.auto_use_coupon
        if self.custom_time_series is not None:
            result['CustomTimeSeries'] = self.custom_time_series
        if self.event_store_num is not None:
            result['EventStoreNum'] = self.event_store_num
        if self.event_store_time is not None:
            result['EventStoreTime'] = self.event_store_time
        if self.log_monitor_stream is not None:
            result['LogMonitorStream'] = self.log_monitor_stream
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.phone_count is not None:
            result['PhoneCount'] = self.phone_count
        if self.site_ecs_num is not None:
            result['SiteEcsNum'] = self.site_ecs_num
        if self.site_operator_num is not None:
            result['SiteOperatorNum'] = self.site_operator_num
        if self.site_task_num is not None:
            result['SiteTaskNum'] = self.site_task_num
        if self.sms_count is not None:
            result['SmsCount'] = self.sms_count
        if self.suggest_type is not None:
            result['SuggestType'] = self.suggest_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiCount') is not None:
            self.api_count = m.get('ApiCount')
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('AutoRenewPeriod') is not None:
            self.auto_renew_period = m.get('AutoRenewPeriod')
        if m.get('AutoUseCoupon') is not None:
            self.auto_use_coupon = m.get('AutoUseCoupon')
        if m.get('CustomTimeSeries') is not None:
            self.custom_time_series = m.get('CustomTimeSeries')
        if m.get('EventStoreNum') is not None:
            self.event_store_num = m.get('EventStoreNum')
        if m.get('EventStoreTime') is not None:
            self.event_store_time = m.get('EventStoreTime')
        if m.get('LogMonitorStream') is not None:
            self.log_monitor_stream = m.get('LogMonitorStream')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PhoneCount') is not None:
            self.phone_count = m.get('PhoneCount')
        if m.get('SiteEcsNum') is not None:
            self.site_ecs_num = m.get('SiteEcsNum')
        if m.get('SiteOperatorNum') is not None:
            self.site_operator_num = m.get('SiteOperatorNum')
        if m.get('SiteTaskNum') is not None:
            self.site_task_num = m.get('SiteTaskNum')
        if m.get('SmsCount') is not None:
            self.sms_count = m.get('SmsCount')
        if m.get('SuggestType') is not None:
            self.suggest_type = m.get('SuggestType')
        return self


class CreateCmsOrderResponseBody(TeaModel):
    def __init__(self, order_id=None, request_id=None):
        self.order_id = order_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCmsOrderResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCmsOrderResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCmsOrderResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCmsOrderResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCmsOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCmsSmspackageOrderRequest(TeaModel):
    def __init__(self, auto_pay=None, auto_renew_period=None, auto_use_coupon=None, period=None, period_unit=None,
                 sms_count=None):
        self.auto_pay = auto_pay  # type: bool
        self.auto_renew_period = auto_renew_period  # type: int
        self.auto_use_coupon = auto_use_coupon  # type: bool
        self.period = period  # type: int
        self.period_unit = period_unit  # type: str
        self.sms_count = sms_count  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCmsSmspackageOrderRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.auto_renew_period is not None:
            result['AutoRenewPeriod'] = self.auto_renew_period
        if self.auto_use_coupon is not None:
            result['AutoUseCoupon'] = self.auto_use_coupon
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.sms_count is not None:
            result['SmsCount'] = self.sms_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('AutoRenewPeriod') is not None:
            self.auto_renew_period = m.get('AutoRenewPeriod')
        if m.get('AutoUseCoupon') is not None:
            self.auto_use_coupon = m.get('AutoUseCoupon')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('SmsCount') is not None:
            self.sms_count = m.get('SmsCount')
        return self


class CreateCmsSmspackageOrderResponseBody(TeaModel):
    def __init__(self, order_id=None, request_id=None):
        self.order_id = order_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCmsSmspackageOrderResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCmsSmspackageOrderResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCmsSmspackageOrderResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCmsSmspackageOrderResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCmsSmspackageOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDynamicTagGroupRequestMatchExpress(TeaModel):
    def __init__(self, tag_value=None, tag_value_match_function=None):
        self.tag_value = tag_value  # type: str
        self.tag_value_match_function = tag_value_match_function  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDynamicTagGroupRequestMatchExpress, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_value_match_function is not None:
            result['TagValueMatchFunction'] = self.tag_value_match_function
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagValueMatchFunction') is not None:
            self.tag_value_match_function = m.get('TagValueMatchFunction')
        return self


class CreateDynamicTagGroupRequest(TeaModel):
    def __init__(self, contact_group_list=None, enable_install_agent=None, enable_subscribe_event=None,
                 match_express=None, match_express_filter_relation=None, region_id=None, tag_key=None, tag_region_id=None,
                 template_id_list=None):
        self.contact_group_list = contact_group_list  # type: list[str]
        self.enable_install_agent = enable_install_agent  # type: bool
        self.enable_subscribe_event = enable_subscribe_event  # type: bool
        self.match_express = match_express  # type: list[CreateDynamicTagGroupRequestMatchExpress]
        self.match_express_filter_relation = match_express_filter_relation  # type: str
        self.region_id = region_id  # type: str
        self.tag_key = tag_key  # type: str
        self.tag_region_id = tag_region_id  # type: str
        self.template_id_list = template_id_list  # type: list[str]

    def validate(self):
        if self.match_express:
            for k in self.match_express:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDynamicTagGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_list is not None:
            result['ContactGroupList'] = self.contact_group_list
        if self.enable_install_agent is not None:
            result['EnableInstallAgent'] = self.enable_install_agent
        if self.enable_subscribe_event is not None:
            result['EnableSubscribeEvent'] = self.enable_subscribe_event
        result['MatchExpress'] = []
        if self.match_express is not None:
            for k in self.match_express:
                result['MatchExpress'].append(k.to_map() if k else None)
        if self.match_express_filter_relation is not None:
            result['MatchExpressFilterRelation'] = self.match_express_filter_relation
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_region_id is not None:
            result['TagRegionId'] = self.tag_region_id
        if self.template_id_list is not None:
            result['TemplateIdList'] = self.template_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroupList') is not None:
            self.contact_group_list = m.get('ContactGroupList')
        if m.get('EnableInstallAgent') is not None:
            self.enable_install_agent = m.get('EnableInstallAgent')
        if m.get('EnableSubscribeEvent') is not None:
            self.enable_subscribe_event = m.get('EnableSubscribeEvent')
        self.match_express = []
        if m.get('MatchExpress') is not None:
            for k in m.get('MatchExpress'):
                temp_model = CreateDynamicTagGroupRequestMatchExpress()
                self.match_express.append(temp_model.from_map(k))
        if m.get('MatchExpressFilterRelation') is not None:
            self.match_express_filter_relation = m.get('MatchExpressFilterRelation')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagRegionId') is not None:
            self.tag_region_id = m.get('TagRegionId')
        if m.get('TemplateIdList') is not None:
            self.template_id_list = m.get('TemplateIdList')
        return self


class CreateDynamicTagGroupResponseBody(TeaModel):
    def __init__(self, code=None, id=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.id = id  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDynamicTagGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDynamicTagGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDynamicTagGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDynamicTagGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDynamicTagGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateGroupMetricRulesRequestGroupMetricRulesEscalationsCritical(TeaModel):
    def __init__(self, comparison_operator=None, pre_condition=None, statistics=None, threshold=None, times=None):
        self.comparison_operator = comparison_operator  # type: str
        self.pre_condition = pre_condition  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str
        self.times = times  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateGroupMetricRulesRequestGroupMetricRulesEscalationsCritical, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.pre_condition is not None:
            result['PreCondition'] = self.pre_condition
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('PreCondition') is not None:
            self.pre_condition = m.get('PreCondition')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class CreateGroupMetricRulesRequestGroupMetricRulesEscalationsInfo(TeaModel):
    def __init__(self, comparison_operator=None, pre_condition=None, statistics=None, threshold=None, times=None):
        self.comparison_operator = comparison_operator  # type: str
        self.pre_condition = pre_condition  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str
        self.times = times  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateGroupMetricRulesRequestGroupMetricRulesEscalationsInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.pre_condition is not None:
            result['PreCondition'] = self.pre_condition
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('PreCondition') is not None:
            self.pre_condition = m.get('PreCondition')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class CreateGroupMetricRulesRequestGroupMetricRulesEscalationsWarn(TeaModel):
    def __init__(self, comparison_operator=None, pre_condition=None, statistics=None, threshold=None, times=None):
        self.comparison_operator = comparison_operator  # type: str
        self.pre_condition = pre_condition  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str
        self.times = times  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateGroupMetricRulesRequestGroupMetricRulesEscalationsWarn, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.pre_condition is not None:
            result['PreCondition'] = self.pre_condition
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('PreCondition') is not None:
            self.pre_condition = m.get('PreCondition')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class CreateGroupMetricRulesRequestGroupMetricRulesEscalations(TeaModel):
    def __init__(self, critical=None, info=None, warn=None):
        self.critical = critical  # type: CreateGroupMetricRulesRequestGroupMetricRulesEscalationsCritical
        self.info = info  # type: CreateGroupMetricRulesRequestGroupMetricRulesEscalationsInfo
        self.warn = warn  # type: CreateGroupMetricRulesRequestGroupMetricRulesEscalationsWarn

    def validate(self):
        self.validate_required(self.critical, 'critical')
        if self.critical:
            self.critical.validate()
        self.validate_required(self.info, 'info')
        if self.info:
            self.info.validate()
        self.validate_required(self.warn, 'warn')
        if self.warn:
            self.warn.validate()

    def to_map(self):
        _map = super(CreateGroupMetricRulesRequestGroupMetricRulesEscalations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.critical is not None:
            result['Critical'] = self.critical.to_map()
        if self.info is not None:
            result['Info'] = self.info.to_map()
        if self.warn is not None:
            result['Warn'] = self.warn.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Critical') is not None:
            temp_model = CreateGroupMetricRulesRequestGroupMetricRulesEscalationsCritical()
            self.critical = temp_model.from_map(m['Critical'])
        if m.get('Info') is not None:
            temp_model = CreateGroupMetricRulesRequestGroupMetricRulesEscalationsInfo()
            self.info = temp_model.from_map(m['Info'])
        if m.get('Warn') is not None:
            temp_model = CreateGroupMetricRulesRequestGroupMetricRulesEscalationsWarn()
            self.warn = temp_model.from_map(m['Warn'])
        return self


class CreateGroupMetricRulesRequestGroupMetricRulesLabels(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateGroupMetricRulesRequestGroupMetricRulesLabels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateGroupMetricRulesRequestGroupMetricRules(TeaModel):
    def __init__(self, escalations=None, category=None, contact_groups=None, dimensions=None,
                 effective_interval=None, email_subject=None, interval=None, labels=None, metric_name=None, namespace=None,
                 no_data_policy=None, no_effective_interval=None, period=None, rule_id=None, rule_name=None, silence_time=None,
                 webhook=None):
        self.escalations = escalations  # type: CreateGroupMetricRulesRequestGroupMetricRulesEscalations
        self.category = category  # type: str
        self.contact_groups = contact_groups  # type: str
        self.dimensions = dimensions  # type: str
        self.effective_interval = effective_interval  # type: str
        self.email_subject = email_subject  # type: str
        self.interval = interval  # type: str
        self.labels = labels  # type: list[CreateGroupMetricRulesRequestGroupMetricRulesLabels]
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.no_data_policy = no_data_policy  # type: str
        self.no_effective_interval = no_effective_interval  # type: str
        self.period = period  # type: str
        self.rule_id = rule_id  # type: str
        self.rule_name = rule_name  # type: str
        self.silence_time = silence_time  # type: int
        self.webhook = webhook  # type: str

    def validate(self):
        self.validate_required(self.escalations, 'escalations')
        if self.escalations:
            self.escalations.validate()
        if self.labels:
            for k in self.labels:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateGroupMetricRulesRequestGroupMetricRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.escalations is not None:
            result['Escalations'] = self.escalations.to_map()
        if self.category is not None:
            result['Category'] = self.category
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.effective_interval is not None:
            result['EffectiveInterval'] = self.effective_interval
        if self.email_subject is not None:
            result['EmailSubject'] = self.email_subject
        if self.interval is not None:
            result['Interval'] = self.interval
        result['Labels'] = []
        if self.labels is not None:
            for k in self.labels:
                result['Labels'].append(k.to_map() if k else None)
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.no_data_policy is not None:
            result['NoDataPolicy'] = self.no_data_policy
        if self.no_effective_interval is not None:
            result['NoEffectiveInterval'] = self.no_effective_interval
        if self.period is not None:
            result['Period'] = self.period
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Escalations') is not None:
            temp_model = CreateGroupMetricRulesRequestGroupMetricRulesEscalations()
            self.escalations = temp_model.from_map(m['Escalations'])
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('ContactGroups') is not None:
            self.contact_groups = m.get('ContactGroups')
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EffectiveInterval') is not None:
            self.effective_interval = m.get('EffectiveInterval')
        if m.get('EmailSubject') is not None:
            self.email_subject = m.get('EmailSubject')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        self.labels = []
        if m.get('Labels') is not None:
            for k in m.get('Labels'):
                temp_model = CreateGroupMetricRulesRequestGroupMetricRulesLabels()
                self.labels.append(temp_model.from_map(k))
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NoDataPolicy') is not None:
            self.no_data_policy = m.get('NoDataPolicy')
        if m.get('NoEffectiveInterval') is not None:
            self.no_effective_interval = m.get('NoEffectiveInterval')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class CreateGroupMetricRulesRequest(TeaModel):
    def __init__(self, group_id=None, group_metric_rules=None, region_id=None):
        self.group_id = group_id  # type: long
        self.group_metric_rules = group_metric_rules  # type: list[CreateGroupMetricRulesRequestGroupMetricRules]
        self.region_id = region_id  # type: str

    def validate(self):
        if self.group_metric_rules:
            for k in self.group_metric_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateGroupMetricRulesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        result['GroupMetricRules'] = []
        if self.group_metric_rules is not None:
            for k in self.group_metric_rules:
                result['GroupMetricRules'].append(k.to_map() if k else None)
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        self.group_metric_rules = []
        if m.get('GroupMetricRules') is not None:
            for k in m.get('GroupMetricRules'):
                temp_model = CreateGroupMetricRulesRequestGroupMetricRules()
                self.group_metric_rules.append(temp_model.from_map(k))
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateGroupMetricRulesResponseBodyResourcesAlertResult(TeaModel):
    def __init__(self, code=None, message=None, rule_id=None, rule_name=None, success=None):
        self.code = code  # type: int
        self.message = message  # type: str
        self.rule_id = rule_id  # type: str
        self.rule_name = rule_name  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateGroupMetricRulesResponseBodyResourcesAlertResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateGroupMetricRulesResponseBodyResources(TeaModel):
    def __init__(self, alert_result=None):
        self.alert_result = alert_result  # type: list[CreateGroupMetricRulesResponseBodyResourcesAlertResult]

    def validate(self):
        if self.alert_result:
            for k in self.alert_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateGroupMetricRulesResponseBodyResources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertResult'] = []
        if self.alert_result is not None:
            for k in self.alert_result:
                result['AlertResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alert_result = []
        if m.get('AlertResult') is not None:
            for k in m.get('AlertResult'):
                temp_model = CreateGroupMetricRulesResponseBodyResourcesAlertResult()
                self.alert_result.append(temp_model.from_map(k))
        return self


class CreateGroupMetricRulesResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, resources=None, success=None):
        self.code = code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.resources = resources  # type: CreateGroupMetricRulesResponseBodyResources
        self.success = success  # type: bool

    def validate(self):
        if self.resources:
            self.resources.validate()

    def to_map(self):
        _map = super(CreateGroupMetricRulesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resources') is not None:
            temp_model = CreateGroupMetricRulesResponseBodyResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateGroupMetricRulesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateGroupMetricRulesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateGroupMetricRulesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateGroupMetricRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateGroupMonitoringAgentProcessRequestAlertConfig(TeaModel):
    def __init__(self, comparison_operator=None, effective_interval=None, escalations_level=None,
                 no_effective_interval=None, silence_time=None, statistics=None, threshold=None, times=None, webhook=None):
        self.comparison_operator = comparison_operator  # type: str
        self.effective_interval = effective_interval  # type: str
        self.escalations_level = escalations_level  # type: str
        self.no_effective_interval = no_effective_interval  # type: str
        self.silence_time = silence_time  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str
        self.times = times  # type: str
        self.webhook = webhook  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateGroupMonitoringAgentProcessRequestAlertConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.effective_interval is not None:
            result['EffectiveInterval'] = self.effective_interval
        if self.escalations_level is not None:
            result['EscalationsLevel'] = self.escalations_level
        if self.no_effective_interval is not None:
            result['NoEffectiveInterval'] = self.no_effective_interval
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('EffectiveInterval') is not None:
            self.effective_interval = m.get('EffectiveInterval')
        if m.get('EscalationsLevel') is not None:
            self.escalations_level = m.get('EscalationsLevel')
        if m.get('NoEffectiveInterval') is not None:
            self.no_effective_interval = m.get('NoEffectiveInterval')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class CreateGroupMonitoringAgentProcessRequestMatchExpress(TeaModel):
    def __init__(self, function=None, name=None, value=None):
        self.function = function  # type: str
        self.name = name  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateGroupMonitoringAgentProcessRequestMatchExpress, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function is not None:
            result['Function'] = self.function
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Function') is not None:
            self.function = m.get('Function')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateGroupMonitoringAgentProcessRequest(TeaModel):
    def __init__(self, alert_config=None, group_id=None, match_express=None, match_express_filter_relation=None,
                 process_name=None, region_id=None):
        self.alert_config = alert_config  # type: list[CreateGroupMonitoringAgentProcessRequestAlertConfig]
        self.group_id = group_id  # type: str
        self.match_express = match_express  # type: list[CreateGroupMonitoringAgentProcessRequestMatchExpress]
        self.match_express_filter_relation = match_express_filter_relation  # type: str
        self.process_name = process_name  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        if self.alert_config:
            for k in self.alert_config:
                if k:
                    k.validate()
        if self.match_express:
            for k in self.match_express:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateGroupMonitoringAgentProcessRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertConfig'] = []
        if self.alert_config is not None:
            for k in self.alert_config:
                result['AlertConfig'].append(k.to_map() if k else None)
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        result['MatchExpress'] = []
        if self.match_express is not None:
            for k in self.match_express:
                result['MatchExpress'].append(k.to_map() if k else None)
        if self.match_express_filter_relation is not None:
            result['MatchExpressFilterRelation'] = self.match_express_filter_relation
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alert_config = []
        if m.get('AlertConfig') is not None:
            for k in m.get('AlertConfig'):
                temp_model = CreateGroupMonitoringAgentProcessRequestAlertConfig()
                self.alert_config.append(temp_model.from_map(k))
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        self.match_express = []
        if m.get('MatchExpress') is not None:
            for k in m.get('MatchExpress'):
                temp_model = CreateGroupMonitoringAgentProcessRequestMatchExpress()
                self.match_express.append(temp_model.from_map(k))
        if m.get('MatchExpressFilterRelation') is not None:
            self.match_express_filter_relation = m.get('MatchExpressFilterRelation')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateGroupMonitoringAgentProcessResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateGroupMonitoringAgentProcessResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateGroupMonitoringAgentProcessResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateGroupMonitoringAgentProcessResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateGroupMonitoringAgentProcessResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateGroupMonitoringAgentProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHostAvailabilityRequestAlertConfig(TeaModel):
    def __init__(self, end_time=None, notify_type=None, silence_time=None, start_time=None, web_hook=None):
        self.end_time = end_time  # type: int
        self.notify_type = notify_type  # type: int
        self.silence_time = silence_time  # type: int
        self.start_time = start_time  # type: int
        self.web_hook = web_hook  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHostAvailabilityRequestAlertConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.notify_type is not None:
            result['NotifyType'] = self.notify_type
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.web_hook is not None:
            result['WebHook'] = self.web_hook
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('NotifyType') is not None:
            self.notify_type = m.get('NotifyType')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('WebHook') is not None:
            self.web_hook = m.get('WebHook')
        return self


class CreateHostAvailabilityRequestTaskOption(TeaModel):
    def __init__(self, http_header=None, http_method=None, http_negative=None, http_post_content=None,
                 http_response_charset=None, http_response_match_content=None, http_uri=None, interval=None, telnet_or_ping_host=None):
        self.http_header = http_header  # type: str
        self.http_method = http_method  # type: str
        self.http_negative = http_negative  # type: bool
        self.http_post_content = http_post_content  # type: str
        self.http_response_charset = http_response_charset  # type: str
        self.http_response_match_content = http_response_match_content  # type: str
        self.http_uri = http_uri  # type: str
        self.interval = interval  # type: int
        self.telnet_or_ping_host = telnet_or_ping_host  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHostAvailabilityRequestTaskOption, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_header is not None:
            result['HttpHeader'] = self.http_header
        if self.http_method is not None:
            result['HttpMethod'] = self.http_method
        if self.http_negative is not None:
            result['HttpNegative'] = self.http_negative
        if self.http_post_content is not None:
            result['HttpPostContent'] = self.http_post_content
        if self.http_response_charset is not None:
            result['HttpResponseCharset'] = self.http_response_charset
        if self.http_response_match_content is not None:
            result['HttpResponseMatchContent'] = self.http_response_match_content
        if self.http_uri is not None:
            result['HttpURI'] = self.http_uri
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.telnet_or_ping_host is not None:
            result['TelnetOrPingHost'] = self.telnet_or_ping_host
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpHeader') is not None:
            self.http_header = m.get('HttpHeader')
        if m.get('HttpMethod') is not None:
            self.http_method = m.get('HttpMethod')
        if m.get('HttpNegative') is not None:
            self.http_negative = m.get('HttpNegative')
        if m.get('HttpPostContent') is not None:
            self.http_post_content = m.get('HttpPostContent')
        if m.get('HttpResponseCharset') is not None:
            self.http_response_charset = m.get('HttpResponseCharset')
        if m.get('HttpResponseMatchContent') is not None:
            self.http_response_match_content = m.get('HttpResponseMatchContent')
        if m.get('HttpURI') is not None:
            self.http_uri = m.get('HttpURI')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('TelnetOrPingHost') is not None:
            self.telnet_or_ping_host = m.get('TelnetOrPingHost')
        return self


class CreateHostAvailabilityRequestAlertConfigEscalationList(TeaModel):
    def __init__(self, aggregate=None, metric_name=None, operator=None, times=None, value=None):
        self.aggregate = aggregate  # type: str
        self.metric_name = metric_name  # type: str
        self.operator = operator  # type: str
        self.times = times  # type: int
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHostAvailabilityRequestAlertConfigEscalationList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate is not None:
            result['Aggregate'] = self.aggregate
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.times is not None:
            result['Times'] = self.times
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Aggregate') is not None:
            self.aggregate = m.get('Aggregate')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateHostAvailabilityRequest(TeaModel):
    def __init__(self, alert_config=None, task_option=None, alert_config_escalation_list=None, group_id=None,
                 instance_list=None, region_id=None, task_name=None, task_scope=None, task_type=None):
        self.alert_config = alert_config  # type: CreateHostAvailabilityRequestAlertConfig
        self.task_option = task_option  # type: CreateHostAvailabilityRequestTaskOption
        self.alert_config_escalation_list = alert_config_escalation_list  # type: list[CreateHostAvailabilityRequestAlertConfigEscalationList]
        self.group_id = group_id  # type: long
        self.instance_list = instance_list  # type: list[str]
        self.region_id = region_id  # type: str
        self.task_name = task_name  # type: str
        self.task_scope = task_scope  # type: str
        self.task_type = task_type  # type: str

    def validate(self):
        if self.alert_config:
            self.alert_config.validate()
        if self.task_option:
            self.task_option.validate()
        if self.alert_config_escalation_list:
            for k in self.alert_config_escalation_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateHostAvailabilityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_config is not None:
            result['AlertConfig'] = self.alert_config.to_map()
        if self.task_option is not None:
            result['TaskOption'] = self.task_option.to_map()
        result['AlertConfigEscalationList'] = []
        if self.alert_config_escalation_list is not None:
            for k in self.alert_config_escalation_list:
                result['AlertConfigEscalationList'].append(k.to_map() if k else None)
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_list is not None:
            result['InstanceList'] = self.instance_list
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_scope is not None:
            result['TaskScope'] = self.task_scope
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertConfig') is not None:
            temp_model = CreateHostAvailabilityRequestAlertConfig()
            self.alert_config = temp_model.from_map(m['AlertConfig'])
        if m.get('TaskOption') is not None:
            temp_model = CreateHostAvailabilityRequestTaskOption()
            self.task_option = temp_model.from_map(m['TaskOption'])
        self.alert_config_escalation_list = []
        if m.get('AlertConfigEscalationList') is not None:
            for k in m.get('AlertConfigEscalationList'):
                temp_model = CreateHostAvailabilityRequestAlertConfigEscalationList()
                self.alert_config_escalation_list.append(temp_model.from_map(k))
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceList') is not None:
            self.instance_list = m.get('InstanceList')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskScope') is not None:
            self.task_scope = m.get('TaskScope')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class CreateHostAvailabilityResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None, task_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHostAvailabilityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateHostAvailabilityResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateHostAvailabilityResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateHostAvailabilityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHostAvailabilityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHybridMonitorNamespaceRequest(TeaModel):
    def __init__(self, description=None, namespace=None, region_id=None, spec=None):
        self.description = description  # type: str
        self.namespace = namespace  # type: str
        self.region_id = region_id  # type: str
        self.spec = spec  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHybridMonitorNamespaceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.spec is not None:
            result['Spec'] = self.spec
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        return self


class CreateHybridMonitorNamespaceResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHybridMonitorNamespaceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHybridMonitorNamespaceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateHybridMonitorNamespaceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateHybridMonitorNamespaceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHybridMonitorNamespaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHybridMonitorSLSGroupRequestSLSGroupConfig(TeaModel):
    def __init__(self, slslogstore=None, slsproject=None, slsregion=None, slsuser_id=None):
        self.slslogstore = slslogstore  # type: str
        self.slsproject = slsproject  # type: str
        self.slsregion = slsregion  # type: str
        self.slsuser_id = slsuser_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHybridMonitorSLSGroupRequestSLSGroupConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.slslogstore is not None:
            result['SLSLogstore'] = self.slslogstore
        if self.slsproject is not None:
            result['SLSProject'] = self.slsproject
        if self.slsregion is not None:
            result['SLSRegion'] = self.slsregion
        if self.slsuser_id is not None:
            result['SLSUserId'] = self.slsuser_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SLSLogstore') is not None:
            self.slslogstore = m.get('SLSLogstore')
        if m.get('SLSProject') is not None:
            self.slsproject = m.get('SLSProject')
        if m.get('SLSRegion') is not None:
            self.slsregion = m.get('SLSRegion')
        if m.get('SLSUserId') is not None:
            self.slsuser_id = m.get('SLSUserId')
        return self


class CreateHybridMonitorSLSGroupRequest(TeaModel):
    def __init__(self, region_id=None, slsgroup_config=None, slsgroup_description=None, slsgroup_name=None):
        self.region_id = region_id  # type: str
        self.slsgroup_config = slsgroup_config  # type: list[CreateHybridMonitorSLSGroupRequestSLSGroupConfig]
        self.slsgroup_description = slsgroup_description  # type: str
        self.slsgroup_name = slsgroup_name  # type: str

    def validate(self):
        if self.slsgroup_config:
            for k in self.slsgroup_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateHybridMonitorSLSGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        result['SLSGroupConfig'] = []
        if self.slsgroup_config is not None:
            for k in self.slsgroup_config:
                result['SLSGroupConfig'].append(k.to_map() if k else None)
        if self.slsgroup_description is not None:
            result['SLSGroupDescription'] = self.slsgroup_description
        if self.slsgroup_name is not None:
            result['SLSGroupName'] = self.slsgroup_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        self.slsgroup_config = []
        if m.get('SLSGroupConfig') is not None:
            for k in m.get('SLSGroupConfig'):
                temp_model = CreateHybridMonitorSLSGroupRequestSLSGroupConfig()
                self.slsgroup_config.append(temp_model.from_map(k))
        if m.get('SLSGroupDescription') is not None:
            self.slsgroup_description = m.get('SLSGroupDescription')
        if m.get('SLSGroupName') is not None:
            self.slsgroup_name = m.get('SLSGroupName')
        return self


class CreateHybridMonitorSLSGroupResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHybridMonitorSLSGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHybridMonitorSLSGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateHybridMonitorSLSGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateHybridMonitorSLSGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHybridMonitorSLSGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHybridMonitorTaskRequestAttachLabels(TeaModel):
    def __init__(self, name=None, value=None):
        self.name = name  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHybridMonitorTaskRequestAttachLabels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateHybridMonitorTaskRequestSLSProcessConfigExpress(TeaModel):
    def __init__(self, alias=None, express=None):
        self.alias = alias  # type: str
        self.express = express  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHybridMonitorTaskRequestSLSProcessConfigExpress, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.express is not None:
            result['Express'] = self.express
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('Express') is not None:
            self.express = m.get('Express')
        return self


class CreateHybridMonitorTaskRequestSLSProcessConfigFilterFilters(TeaModel):
    def __init__(self, operator=None, slskey_name=None, value=None):
        self.operator = operator  # type: str
        self.slskey_name = slskey_name  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHybridMonitorTaskRequestSLSProcessConfigFilterFilters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.slskey_name is not None:
            result['SLSKeyName'] = self.slskey_name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('SLSKeyName') is not None:
            self.slskey_name = m.get('SLSKeyName')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateHybridMonitorTaskRequestSLSProcessConfigFilter(TeaModel):
    def __init__(self, filters=None, relation=None):
        self.filters = filters  # type: list[CreateHybridMonitorTaskRequestSLSProcessConfigFilterFilters]
        self.relation = relation  # type: str

    def validate(self):
        if self.filters:
            for k in self.filters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateHybridMonitorTaskRequestSLSProcessConfigFilter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Filters'] = []
        if self.filters is not None:
            for k in self.filters:
                result['Filters'].append(k.to_map() if k else None)
        if self.relation is not None:
            result['Relation'] = self.relation
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.filters = []
        if m.get('Filters') is not None:
            for k in m.get('Filters'):
                temp_model = CreateHybridMonitorTaskRequestSLSProcessConfigFilterFilters()
                self.filters.append(temp_model.from_map(k))
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        return self


class CreateHybridMonitorTaskRequestSLSProcessConfigGroupBy(TeaModel):
    def __init__(self, alias=None, slskey_name=None):
        self.alias = alias  # type: str
        self.slskey_name = slskey_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHybridMonitorTaskRequestSLSProcessConfigGroupBy, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.slskey_name is not None:
            result['SLSKeyName'] = self.slskey_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('SLSKeyName') is not None:
            self.slskey_name = m.get('SLSKeyName')
        return self


class CreateHybridMonitorTaskRequestSLSProcessConfigStatistics(TeaModel):
    def __init__(self, alias=None, function=None, parameter_1=None, parameter_2=None, slskey_name=None):
        self.alias = alias  # type: str
        self.function = function  # type: str
        self.parameter_1 = parameter_1  # type: str
        self.parameter_2 = parameter_2  # type: str
        self.slskey_name = slskey_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHybridMonitorTaskRequestSLSProcessConfigStatistics, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.function is not None:
            result['Function'] = self.function
        if self.parameter_1 is not None:
            result['Parameter1'] = self.parameter_1
        if self.parameter_2 is not None:
            result['Parameter2'] = self.parameter_2
        if self.slskey_name is not None:
            result['SLSKeyName'] = self.slskey_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('Function') is not None:
            self.function = m.get('Function')
        if m.get('Parameter1') is not None:
            self.parameter_1 = m.get('Parameter1')
        if m.get('Parameter2') is not None:
            self.parameter_2 = m.get('Parameter2')
        if m.get('SLSKeyName') is not None:
            self.slskey_name = m.get('SLSKeyName')
        return self


class CreateHybridMonitorTaskRequestSLSProcessConfig(TeaModel):
    def __init__(self, express=None, filter=None, group_by=None, statistics=None):
        self.express = express  # type: list[CreateHybridMonitorTaskRequestSLSProcessConfigExpress]
        self.filter = filter  # type: CreateHybridMonitorTaskRequestSLSProcessConfigFilter
        self.group_by = group_by  # type: list[CreateHybridMonitorTaskRequestSLSProcessConfigGroupBy]
        self.statistics = statistics  # type: list[CreateHybridMonitorTaskRequestSLSProcessConfigStatistics]

    def validate(self):
        if self.express:
            for k in self.express:
                if k:
                    k.validate()
        if self.filter:
            self.filter.validate()
        if self.group_by:
            for k in self.group_by:
                if k:
                    k.validate()
        if self.statistics:
            for k in self.statistics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateHybridMonitorTaskRequestSLSProcessConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Express'] = []
        if self.express is not None:
            for k in self.express:
                result['Express'].append(k.to_map() if k else None)
        if self.filter is not None:
            result['Filter'] = self.filter.to_map()
        result['GroupBy'] = []
        if self.group_by is not None:
            for k in self.group_by:
                result['GroupBy'].append(k.to_map() if k else None)
        result['Statistics'] = []
        if self.statistics is not None:
            for k in self.statistics:
                result['Statistics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.express = []
        if m.get('Express') is not None:
            for k in m.get('Express'):
                temp_model = CreateHybridMonitorTaskRequestSLSProcessConfigExpress()
                self.express.append(temp_model.from_map(k))
        if m.get('Filter') is not None:
            temp_model = CreateHybridMonitorTaskRequestSLSProcessConfigFilter()
            self.filter = temp_model.from_map(m['Filter'])
        self.group_by = []
        if m.get('GroupBy') is not None:
            for k in m.get('GroupBy'):
                temp_model = CreateHybridMonitorTaskRequestSLSProcessConfigGroupBy()
                self.group_by.append(temp_model.from_map(k))
        self.statistics = []
        if m.get('Statistics') is not None:
            for k in m.get('Statistics'):
                temp_model = CreateHybridMonitorTaskRequestSLSProcessConfigStatistics()
                self.statistics.append(temp_model.from_map(k))
        return self


class CreateHybridMonitorTaskRequest(TeaModel):
    def __init__(self, attach_labels=None, collect_interval=None, collect_target_type=None, description=None,
                 group_id=None, namespace=None, region_id=None, slsprocess_config=None, target_user_id=None,
                 target_user_id_list=None, task_name=None, task_type=None, yarmconfig=None):
        self.attach_labels = attach_labels  # type: list[CreateHybridMonitorTaskRequestAttachLabels]
        self.collect_interval = collect_interval  # type: str
        self.collect_target_type = collect_target_type  # type: str
        self.description = description  # type: str
        self.group_id = group_id  # type: str
        self.namespace = namespace  # type: str
        self.region_id = region_id  # type: str
        self.slsprocess_config = slsprocess_config  # type: CreateHybridMonitorTaskRequestSLSProcessConfig
        self.target_user_id = target_user_id  # type: str
        self.target_user_id_list = target_user_id_list  # type: str
        self.task_name = task_name  # type: str
        self.task_type = task_type  # type: str
        self.yarmconfig = yarmconfig  # type: str

    def validate(self):
        if self.attach_labels:
            for k in self.attach_labels:
                if k:
                    k.validate()
        if self.slsprocess_config:
            self.slsprocess_config.validate()

    def to_map(self):
        _map = super(CreateHybridMonitorTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AttachLabels'] = []
        if self.attach_labels is not None:
            for k in self.attach_labels:
                result['AttachLabels'].append(k.to_map() if k else None)
        if self.collect_interval is not None:
            result['CollectInterval'] = self.collect_interval
        if self.collect_target_type is not None:
            result['CollectTargetType'] = self.collect_target_type
        if self.description is not None:
            result['Description'] = self.description
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.slsprocess_config is not None:
            result['SLSProcessConfig'] = self.slsprocess_config.to_map()
        if self.target_user_id is not None:
            result['TargetUserId'] = self.target_user_id
        if self.target_user_id_list is not None:
            result['TargetUserIdList'] = self.target_user_id_list
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.yarmconfig is not None:
            result['YARMConfig'] = self.yarmconfig
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.attach_labels = []
        if m.get('AttachLabels') is not None:
            for k in m.get('AttachLabels'):
                temp_model = CreateHybridMonitorTaskRequestAttachLabels()
                self.attach_labels.append(temp_model.from_map(k))
        if m.get('CollectInterval') is not None:
            self.collect_interval = m.get('CollectInterval')
        if m.get('CollectTargetType') is not None:
            self.collect_target_type = m.get('CollectTargetType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SLSProcessConfig') is not None:
            temp_model = CreateHybridMonitorTaskRequestSLSProcessConfig()
            self.slsprocess_config = temp_model.from_map(m['SLSProcessConfig'])
        if m.get('TargetUserId') is not None:
            self.target_user_id = m.get('TargetUserId')
        if m.get('TargetUserIdList') is not None:
            self.target_user_id_list = m.get('TargetUserIdList')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('YARMConfig') is not None:
            self.yarmconfig = m.get('YARMConfig')
        return self


class CreateHybridMonitorTaskResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHybridMonitorTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHybridMonitorTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateHybridMonitorTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateHybridMonitorTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHybridMonitorTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInstantSiteMonitorRequest(TeaModel):
    def __init__(self, address=None, isp_cities=None, options_json=None, random_isp_city=None, region_id=None,
                 task_name=None, task_type=None):
        self.address = address  # type: str
        self.isp_cities = isp_cities  # type: str
        self.options_json = options_json  # type: str
        self.random_isp_city = random_isp_city  # type: int
        self.region_id = region_id  # type: str
        self.task_name = task_name  # type: str
        self.task_type = task_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInstantSiteMonitorRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.isp_cities is not None:
            result['IspCities'] = self.isp_cities
        if self.options_json is not None:
            result['OptionsJson'] = self.options_json
        if self.random_isp_city is not None:
            result['RandomIspCity'] = self.random_isp_city
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('IspCities') is not None:
            self.isp_cities = m.get('IspCities')
        if m.get('OptionsJson') is not None:
            self.options_json = m.get('OptionsJson')
        if m.get('RandomIspCity') is not None:
            self.random_isp_city = m.get('RandomIspCity')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class CreateInstantSiteMonitorResponseBodyCreateResultList(TeaModel):
    def __init__(self, task_id=None, task_name=None):
        self.task_id = task_id  # type: str
        self.task_name = task_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInstantSiteMonitorResponseBodyCreateResultList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateInstantSiteMonitorResponseBody(TeaModel):
    def __init__(self, code=None, create_result_list=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.create_result_list = create_result_list  # type: list[CreateInstantSiteMonitorResponseBodyCreateResultList]
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.create_result_list:
            for k in self.create_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateInstantSiteMonitorResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['CreateResultList'] = []
        if self.create_result_list is not None:
            for k in self.create_result_list:
                result['CreateResultList'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.create_result_list = []
        if m.get('CreateResultList') is not None:
            for k in m.get('CreateResultList'):
                temp_model = CreateInstantSiteMonitorResponseBodyCreateResultList()
                self.create_result_list.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateInstantSiteMonitorResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateInstantSiteMonitorResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateInstantSiteMonitorResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateInstantSiteMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMetricRuleResourcesRequest(TeaModel):
    def __init__(self, overwrite=None, resources=None, rule_id=None):
        self.overwrite = overwrite  # type: str
        self.resources = resources  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMetricRuleResourcesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overwrite is not None:
            result['Overwrite'] = self.overwrite
        if self.resources is not None:
            result['Resources'] = self.resources
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Overwrite') is not None:
            self.overwrite = m.get('Overwrite')
        if m.get('Resources') is not None:
            self.resources = m.get('Resources')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class CreateMetricRuleResourcesResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMetricRuleResourcesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMetricRuleResourcesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateMetricRuleResourcesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateMetricRuleResourcesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMetricRuleResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMetricRuleTemplateRequestAlertTemplatesEscalationsCritical(TeaModel):
    def __init__(self, comparison_operator=None, statistics=None, threshold=None, times=None):
        self.comparison_operator = comparison_operator  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str
        self.times = times  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMetricRuleTemplateRequestAlertTemplatesEscalationsCritical, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class CreateMetricRuleTemplateRequestAlertTemplatesEscalationsInfo(TeaModel):
    def __init__(self, comparison_operator=None, statistics=None, threshold=None, times=None):
        self.comparison_operator = comparison_operator  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str
        self.times = times  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMetricRuleTemplateRequestAlertTemplatesEscalationsInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class CreateMetricRuleTemplateRequestAlertTemplatesEscalationsWarn(TeaModel):
    def __init__(self, comparison_operator=None, statistics=None, threshold=None, times=None):
        self.comparison_operator = comparison_operator  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str
        self.times = times  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMetricRuleTemplateRequestAlertTemplatesEscalationsWarn, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class CreateMetricRuleTemplateRequestAlertTemplatesEscalations(TeaModel):
    def __init__(self, critical=None, info=None, warn=None):
        self.critical = critical  # type: CreateMetricRuleTemplateRequestAlertTemplatesEscalationsCritical
        self.info = info  # type: CreateMetricRuleTemplateRequestAlertTemplatesEscalationsInfo
        self.warn = warn  # type: CreateMetricRuleTemplateRequestAlertTemplatesEscalationsWarn

    def validate(self):
        self.validate_required(self.critical, 'critical')
        if self.critical:
            self.critical.validate()
        self.validate_required(self.info, 'info')
        if self.info:
            self.info.validate()
        self.validate_required(self.warn, 'warn')
        if self.warn:
            self.warn.validate()

    def to_map(self):
        _map = super(CreateMetricRuleTemplateRequestAlertTemplatesEscalations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.critical is not None:
            result['Critical'] = self.critical.to_map()
        if self.info is not None:
            result['Info'] = self.info.to_map()
        if self.warn is not None:
            result['Warn'] = self.warn.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Critical') is not None:
            temp_model = CreateMetricRuleTemplateRequestAlertTemplatesEscalationsCritical()
            self.critical = temp_model.from_map(m['Critical'])
        if m.get('Info') is not None:
            temp_model = CreateMetricRuleTemplateRequestAlertTemplatesEscalationsInfo()
            self.info = temp_model.from_map(m['Info'])
        if m.get('Warn') is not None:
            temp_model = CreateMetricRuleTemplateRequestAlertTemplatesEscalationsWarn()
            self.warn = temp_model.from_map(m['Warn'])
        return self


class CreateMetricRuleTemplateRequestAlertTemplates(TeaModel):
    def __init__(self, escalations=None, category=None, metric_name=None, namespace=None, period=None,
                 rule_name=None, selector=None, webhook=None):
        self.escalations = escalations  # type: CreateMetricRuleTemplateRequestAlertTemplatesEscalations
        self.category = category  # type: str
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.period = period  # type: int
        self.rule_name = rule_name  # type: str
        self.selector = selector  # type: str
        self.webhook = webhook  # type: str

    def validate(self):
        self.validate_required(self.escalations, 'escalations')
        if self.escalations:
            self.escalations.validate()

    def to_map(self):
        _map = super(CreateMetricRuleTemplateRequestAlertTemplates, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.escalations is not None:
            result['Escalations'] = self.escalations.to_map()
        if self.category is not None:
            result['Category'] = self.category
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.period is not None:
            result['Period'] = self.period
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.selector is not None:
            result['Selector'] = self.selector
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Escalations') is not None:
            temp_model = CreateMetricRuleTemplateRequestAlertTemplatesEscalations()
            self.escalations = temp_model.from_map(m['Escalations'])
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('Selector') is not None:
            self.selector = m.get('Selector')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class CreateMetricRuleTemplateRequest(TeaModel):
    def __init__(self, alert_templates=None, description=None, name=None, region_id=None):
        self.alert_templates = alert_templates  # type: list[CreateMetricRuleTemplateRequestAlertTemplates]
        self.description = description  # type: str
        self.name = name  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        if self.alert_templates:
            for k in self.alert_templates:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateMetricRuleTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertTemplates'] = []
        if self.alert_templates is not None:
            for k in self.alert_templates:
                result['AlertTemplates'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alert_templates = []
        if m.get('AlertTemplates') is not None:
            for k in m.get('AlertTemplates'):
                temp_model = CreateMetricRuleTemplateRequestAlertTemplates()
                self.alert_templates.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateMetricRuleTemplateResponseBody(TeaModel):
    def __init__(self, code=None, id=None, message=None, request_id=None, success=None):
        self.code = code  # type: int
        self.id = id  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMetricRuleTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMetricRuleTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateMetricRuleTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateMetricRuleTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMetricRuleTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitorAgentProcessRequest(TeaModel):
    def __init__(self, instance_id=None, process_name=None, process_user=None, region_id=None):
        self.instance_id = instance_id  # type: str
        self.process_name = process_name  # type: str
        self.process_user = process_user  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMonitorAgentProcessRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.process_user is not None:
            result['ProcessUser'] = self.process_user
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('ProcessUser') is not None:
            self.process_user = m.get('ProcessUser')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateMonitorAgentProcessResponseBody(TeaModel):
    def __init__(self, code=None, id=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.id = id  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMonitorAgentProcessResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMonitorAgentProcessResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateMonitorAgentProcessResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateMonitorAgentProcessResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMonitorAgentProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitorGroupRequest(TeaModel):
    def __init__(self, contact_groups=None, group_name=None, region_id=None):
        self.contact_groups = contact_groups  # type: str
        self.group_name = group_name  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMonitorGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroups') is not None:
            self.contact_groups = m.get('ContactGroups')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateMonitorGroupResponseBody(TeaModel):
    def __init__(self, code=None, group_id=None, message=None, request_id=None, success=None):
        self.code = code  # type: int
        self.group_id = group_id  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMonitorGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMonitorGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateMonitorGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateMonitorGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMonitorGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitorGroupByResourceGroupIdRequest(TeaModel):
    def __init__(self, contact_group_list=None, enable_install_agent=None, enable_subscribe_event=None,
                 region_id=None, resource_group_id=None, resource_group_name=None):
        self.contact_group_list = contact_group_list  # type: list[str]
        self.enable_install_agent = enable_install_agent  # type: bool
        self.enable_subscribe_event = enable_subscribe_event  # type: bool
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_group_name = resource_group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMonitorGroupByResourceGroupIdRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_list is not None:
            result['ContactGroupList'] = self.contact_group_list
        if self.enable_install_agent is not None:
            result['EnableInstallAgent'] = self.enable_install_agent
        if self.enable_subscribe_event is not None:
            result['EnableSubscribeEvent'] = self.enable_subscribe_event
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_group_name is not None:
            result['ResourceGroupName'] = self.resource_group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroupList') is not None:
            self.contact_group_list = m.get('ContactGroupList')
        if m.get('EnableInstallAgent') is not None:
            self.enable_install_agent = m.get('EnableInstallAgent')
        if m.get('EnableSubscribeEvent') is not None:
            self.enable_subscribe_event = m.get('EnableSubscribeEvent')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceGroupName') is not None:
            self.resource_group_name = m.get('ResourceGroupName')
        return self


class CreateMonitorGroupByResourceGroupIdResponseBody(TeaModel):
    def __init__(self, code=None, id=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.id = id  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMonitorGroupByResourceGroupIdResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMonitorGroupByResourceGroupIdResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateMonitorGroupByResourceGroupIdResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateMonitorGroupByResourceGroupIdResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMonitorGroupByResourceGroupIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitorGroupInstancesRequestInstances(TeaModel):
    def __init__(self, category=None, instance_id=None, instance_name=None, region_id=None):
        self.category = category  # type: str
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMonitorGroupInstancesRequestInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateMonitorGroupInstancesRequest(TeaModel):
    def __init__(self, group_id=None, instances=None, region_id=None):
        self.group_id = group_id  # type: str
        self.instances = instances  # type: list[CreateMonitorGroupInstancesRequestInstances]
        self.region_id = region_id  # type: str

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateMonitorGroupInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = CreateMonitorGroupInstancesRequestInstances()
                self.instances.append(temp_model.from_map(k))
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateMonitorGroupInstancesResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMonitorGroupInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMonitorGroupInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateMonitorGroupInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateMonitorGroupInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMonitorGroupInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitorGroupNotifyPolicyRequest(TeaModel):
    def __init__(self, end_time=None, group_id=None, policy_type=None, region_id=None, start_time=None):
        self.end_time = end_time  # type: long
        self.group_id = group_id  # type: str
        self.policy_type = policy_type  # type: str
        self.region_id = region_id  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMonitorGroupNotifyPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class CreateMonitorGroupNotifyPolicyResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, result=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.result = result  # type: int
        self.success = success  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMonitorGroupNotifyPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMonitorGroupNotifyPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateMonitorGroupNotifyPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateMonitorGroupNotifyPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMonitorGroupNotifyPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMonitoringAgentProcessRequest(TeaModel):
    def __init__(self, instance_id=None, process_name=None, process_user=None, region_id=None):
        self.instance_id = instance_id  # type: str
        self.process_name = process_name  # type: str
        self.process_user = process_user  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMonitoringAgentProcessRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.process_user is not None:
            result['ProcessUser'] = self.process_user
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('ProcessUser') is not None:
            self.process_user = m.get('ProcessUser')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateMonitoringAgentProcessResponseBody(TeaModel):
    def __init__(self, code=None, id=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.id = id  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMonitoringAgentProcessResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateMonitoringAgentProcessResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateMonitoringAgentProcessResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateMonitoringAgentProcessResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMonitoringAgentProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSiteMonitorRequest(TeaModel):
    def __init__(self, address=None, alert_ids=None, interval=None, isp_cities=None, options_json=None,
                 region_id=None, task_name=None, task_type=None):
        self.address = address  # type: str
        self.alert_ids = alert_ids  # type: str
        self.interval = interval  # type: str
        self.isp_cities = isp_cities  # type: str
        self.options_json = options_json  # type: str
        self.region_id = region_id  # type: str
        self.task_name = task_name  # type: str
        self.task_type = task_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSiteMonitorRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.alert_ids is not None:
            result['AlertIds'] = self.alert_ids
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_cities is not None:
            result['IspCities'] = self.isp_cities
        if self.options_json is not None:
            result['OptionsJson'] = self.options_json
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('AlertIds') is not None:
            self.alert_ids = m.get('AlertIds')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspCities') is not None:
            self.isp_cities = m.get('IspCities')
        if m.get('OptionsJson') is not None:
            self.options_json = m.get('OptionsJson')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class CreateSiteMonitorResponseBodyCreateResultListCreateResultList(TeaModel):
    def __init__(self, task_id=None, task_name=None):
        self.task_id = task_id  # type: str
        self.task_name = task_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSiteMonitorResponseBodyCreateResultListCreateResultList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateSiteMonitorResponseBodyCreateResultList(TeaModel):
    def __init__(self, create_result_list=None):
        self.create_result_list = create_result_list  # type: list[CreateSiteMonitorResponseBodyCreateResultListCreateResultList]

    def validate(self):
        if self.create_result_list:
            for k in self.create_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateSiteMonitorResponseBodyCreateResultList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CreateResultList'] = []
        if self.create_result_list is not None:
            for k in self.create_result_list:
                result['CreateResultList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.create_result_list = []
        if m.get('CreateResultList') is not None:
            for k in m.get('CreateResultList'):
                temp_model = CreateSiteMonitorResponseBodyCreateResultListCreateResultList()
                self.create_result_list.append(temp_model.from_map(k))
        return self


class CreateSiteMonitorResponseBodyDataAttachAlertResultContact(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, rule_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.rule_id = rule_id  # type: str
        self.success = success  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSiteMonitorResponseBodyDataAttachAlertResultContact, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSiteMonitorResponseBodyDataAttachAlertResult(TeaModel):
    def __init__(self, contact=None):
        self.contact = contact  # type: list[CreateSiteMonitorResponseBodyDataAttachAlertResultContact]

    def validate(self):
        if self.contact:
            for k in self.contact:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateSiteMonitorResponseBodyDataAttachAlertResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Contact'] = []
        if self.contact is not None:
            for k in self.contact:
                result['Contact'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.contact = []
        if m.get('Contact') is not None:
            for k in m.get('Contact'):
                temp_model = CreateSiteMonitorResponseBodyDataAttachAlertResultContact()
                self.contact.append(temp_model.from_map(k))
        return self


class CreateSiteMonitorResponseBodyData(TeaModel):
    def __init__(self, attach_alert_result=None):
        self.attach_alert_result = attach_alert_result  # type: CreateSiteMonitorResponseBodyDataAttachAlertResult

    def validate(self):
        if self.attach_alert_result:
            self.attach_alert_result.validate()

    def to_map(self):
        _map = super(CreateSiteMonitorResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attach_alert_result is not None:
            result['AttachAlertResult'] = self.attach_alert_result.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AttachAlertResult') is not None:
            temp_model = CreateSiteMonitorResponseBodyDataAttachAlertResult()
            self.attach_alert_result = temp_model.from_map(m['AttachAlertResult'])
        return self


class CreateSiteMonitorResponseBody(TeaModel):
    def __init__(self, code=None, create_result_list=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.create_result_list = create_result_list  # type: CreateSiteMonitorResponseBodyCreateResultList
        self.data = data  # type: CreateSiteMonitorResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.create_result_list:
            self.create_result_list.validate()
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateSiteMonitorResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.create_result_list is not None:
            result['CreateResultList'] = self.create_result_list.to_map()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreateResultList') is not None:
            temp_model = CreateSiteMonitorResponseBodyCreateResultList()
            self.create_result_list = temp_model.from_map(m['CreateResultList'])
        if m.get('Data') is not None:
            temp_model = CreateSiteMonitorResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSiteMonitorResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSiteMonitorResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSiteMonitorResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSiteMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteContactRequest(TeaModel):
    def __init__(self, contact_name=None):
        self.contact_name = contact_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteContactRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        return self


class DeleteContactResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteContactResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteContactResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteContactResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteContactResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteContactResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteContactGroupRequest(TeaModel):
    def __init__(self, contact_group_name=None):
        self.contact_group_name = contact_group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteContactGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_name is not None:
            result['ContactGroupName'] = self.contact_group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroupName') is not None:
            self.contact_group_name = m.get('ContactGroupName')
        return self


class DeleteContactGroupResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteContactGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteContactGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteContactGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteContactGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteContactGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomMetricRequest(TeaModel):
    def __init__(self, group_id=None, md_5=None, metric_name=None, region_id=None, uuid=None):
        self.group_id = group_id  # type: str
        self.md_5 = md_5  # type: str
        self.metric_name = metric_name  # type: str
        self.region_id = region_id  # type: str
        self.uuid = uuid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCustomMetricRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.uuid is not None:
            result['UUID'] = self.uuid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('UUID') is not None:
            self.uuid = m.get('UUID')
        return self


class DeleteCustomMetricResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCustomMetricResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCustomMetricResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCustomMetricResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCustomMetricResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomMetricResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDynamicTagGroupRequest(TeaModel):
    def __init__(self, dynamic_tag_rule_id=None, region_id=None):
        self.dynamic_tag_rule_id = dynamic_tag_rule_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDynamicTagGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_tag_rule_id is not None:
            result['DynamicTagRuleId'] = self.dynamic_tag_rule_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DynamicTagRuleId') is not None:
            self.dynamic_tag_rule_id = m.get('DynamicTagRuleId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteDynamicTagGroupResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDynamicTagGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDynamicTagGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDynamicTagGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDynamicTagGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDynamicTagGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEventRuleTargetsRequest(TeaModel):
    def __init__(self, ids=None, region_id=None, rule_name=None):
        self.ids = ids  # type: list[str]
        self.region_id = region_id  # type: str
        self.rule_name = rule_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEventRuleTargetsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['Ids'] = self.ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class DeleteEventRuleTargetsResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEventRuleTargetsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEventRuleTargetsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteEventRuleTargetsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteEventRuleTargetsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEventRuleTargetsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEventRulesRequest(TeaModel):
    def __init__(self, rule_names=None):
        self.rule_names = rule_names  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEventRulesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_names is not None:
            result['RuleNames'] = self.rule_names
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RuleNames') is not None:
            self.rule_names = m.get('RuleNames')
        return self


class DeleteEventRulesResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEventRulesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEventRulesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteEventRulesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteEventRulesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEventRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteExporterOutputRequest(TeaModel):
    def __init__(self, dest_name=None, region_id=None):
        self.dest_name = dest_name  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteExporterOutputRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dest_name is not None:
            result['DestName'] = self.dest_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestName') is not None:
            self.dest_name = m.get('DestName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteExporterOutputResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteExporterOutputResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteExporterOutputResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteExporterOutputResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteExporterOutputResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteExporterOutputResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteExporterRuleRequest(TeaModel):
    def __init__(self, region_id=None, rule_name=None):
        self.region_id = region_id  # type: str
        self.rule_name = rule_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteExporterRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class DeleteExporterRuleResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteExporterRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteExporterRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteExporterRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteExporterRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteExporterRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGroupMonitoringAgentProcessRequest(TeaModel):
    def __init__(self, group_id=None, id=None, region_id=None):
        self.group_id = group_id  # type: str
        self.id = id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteGroupMonitoringAgentProcessRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteGroupMonitoringAgentProcessResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteGroupMonitoringAgentProcessResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteGroupMonitoringAgentProcessResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteGroupMonitoringAgentProcessResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteGroupMonitoringAgentProcessResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGroupMonitoringAgentProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHostAvailabilityRequest(TeaModel):
    def __init__(self, id=None, region_id=None):
        self.id = id  # type: list[long]
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHostAvailabilityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteHostAvailabilityResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHostAvailabilityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHostAvailabilityResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteHostAvailabilityResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteHostAvailabilityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHostAvailabilityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHybridMonitorNamespaceRequest(TeaModel):
    def __init__(self, namespace=None, region_id=None):
        self.namespace = namespace  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHybridMonitorNamespaceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteHybridMonitorNamespaceResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHybridMonitorNamespaceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHybridMonitorNamespaceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteHybridMonitorNamespaceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteHybridMonitorNamespaceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHybridMonitorNamespaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHybridMonitorSLSGroupRequest(TeaModel):
    def __init__(self, region_id=None, slsgroup_name=None):
        self.region_id = region_id  # type: str
        self.slsgroup_name = slsgroup_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHybridMonitorSLSGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.slsgroup_name is not None:
            result['SLSGroupName'] = self.slsgroup_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SLSGroupName') is not None:
            self.slsgroup_name = m.get('SLSGroupName')
        return self


class DeleteHybridMonitorSLSGroupResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHybridMonitorSLSGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHybridMonitorSLSGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteHybridMonitorSLSGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteHybridMonitorSLSGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHybridMonitorSLSGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHybridMonitorTaskRequest(TeaModel):
    def __init__(self, namespace=None, region_id=None, target_user_id=None, task_id=None):
        self.namespace = namespace  # type: str
        self.region_id = region_id  # type: str
        self.target_user_id = target_user_id  # type: str
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHybridMonitorTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.target_user_id is not None:
            result['TargetUserId'] = self.target_user_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TargetUserId') is not None:
            self.target_user_id = m.get('TargetUserId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DeleteHybridMonitorTaskResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHybridMonitorTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHybridMonitorTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteHybridMonitorTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteHybridMonitorTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHybridMonitorTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLogMonitorRequest(TeaModel):
    def __init__(self, log_id=None, region_id=None):
        self.log_id = log_id  # type: long
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLogMonitorRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_id is not None:
            result['LogId'] = self.log_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LogId') is not None:
            self.log_id = m.get('LogId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteLogMonitorResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLogMonitorResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteLogMonitorResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLogMonitorResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLogMonitorResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLogMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMetricRuleResourcesRequest(TeaModel):
    def __init__(self, resources=None, rule_id=None):
        self.resources = resources  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMetricRuleResourcesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resources is not None:
            result['Resources'] = self.resources
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Resources') is not None:
            self.resources = m.get('Resources')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteMetricRuleResourcesResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMetricRuleResourcesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMetricRuleResourcesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteMetricRuleResourcesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMetricRuleResourcesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMetricRuleResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMetricRuleTargetsRequest(TeaModel):
    def __init__(self, region_id=None, rule_id=None, target_ids=None):
        self.region_id = region_id  # type: str
        self.rule_id = rule_id  # type: str
        self.target_ids = target_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMetricRuleTargetsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.target_ids is not None:
            result['TargetIds'] = self.target_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('TargetIds') is not None:
            self.target_ids = m.get('TargetIds')
        return self


class DeleteMetricRuleTargetsResponseBodyFailIdsTargetIds(TeaModel):
    def __init__(self, target_id=None):
        self.target_id = target_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMetricRuleTargetsResponseBodyFailIdsTargetIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_id is not None:
            result['TargetId'] = self.target_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetId') is not None:
            self.target_id = m.get('TargetId')
        return self


class DeleteMetricRuleTargetsResponseBodyFailIds(TeaModel):
    def __init__(self, target_ids=None):
        self.target_ids = target_ids  # type: DeleteMetricRuleTargetsResponseBodyFailIdsTargetIds

    def validate(self):
        if self.target_ids:
            self.target_ids.validate()

    def to_map(self):
        _map = super(DeleteMetricRuleTargetsResponseBodyFailIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_ids is not None:
            result['TargetIds'] = self.target_ids.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetIds') is not None:
            temp_model = DeleteMetricRuleTargetsResponseBodyFailIdsTargetIds()
            self.target_ids = temp_model.from_map(m['TargetIds'])
        return self


class DeleteMetricRuleTargetsResponseBody(TeaModel):
    def __init__(self, code=None, fail_ids=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.fail_ids = fail_ids  # type: DeleteMetricRuleTargetsResponseBodyFailIds
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.fail_ids:
            self.fail_ids.validate()

    def to_map(self):
        _map = super(DeleteMetricRuleTargetsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.fail_ids is not None:
            result['FailIds'] = self.fail_ids.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('FailIds') is not None:
            temp_model = DeleteMetricRuleTargetsResponseBodyFailIds()
            self.fail_ids = temp_model.from_map(m['FailIds'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMetricRuleTargetsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteMetricRuleTargetsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMetricRuleTargetsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMetricRuleTargetsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMetricRuleTemplateRequest(TeaModel):
    def __init__(self, region_id=None, template_id=None):
        self.region_id = region_id  # type: str
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMetricRuleTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteMetricRuleTemplateResponseBodyResource(TeaModel):
    def __init__(self, template_id=None):
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMetricRuleTemplateResponseBodyResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteMetricRuleTemplateResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, resource=None, success=None):
        self.code = code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.resource = resource  # type: DeleteMetricRuleTemplateResponseBodyResource
        self.success = success  # type: bool

    def validate(self):
        if self.resource:
            self.resource.validate()

    def to_map(self):
        _map = super(DeleteMetricRuleTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource is not None:
            result['Resource'] = self.resource.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resource') is not None:
            temp_model = DeleteMetricRuleTemplateResponseBodyResource()
            self.resource = temp_model.from_map(m['Resource'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMetricRuleTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteMetricRuleTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMetricRuleTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMetricRuleTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMetricRulesRequest(TeaModel):
    def __init__(self, id=None, region_id=None):
        self.id = id  # type: list[str]
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMetricRulesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteMetricRulesResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMetricRulesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMetricRulesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteMetricRulesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMetricRulesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMetricRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMonitorGroupRequest(TeaModel):
    def __init__(self, group_id=None, region_id=None):
        self.group_id = group_id  # type: long
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMonitorGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteMonitorGroupResponseBodyGroupContactGroupsContactGroup(TeaModel):
    def __init__(self, name=None):
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMonitorGroupResponseBodyGroupContactGroupsContactGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DeleteMonitorGroupResponseBodyGroupContactGroups(TeaModel):
    def __init__(self, contact_group=None):
        self.contact_group = contact_group  # type: list[DeleteMonitorGroupResponseBodyGroupContactGroupsContactGroup]

    def validate(self):
        if self.contact_group:
            for k in self.contact_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DeleteMonitorGroupResponseBodyGroupContactGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ContactGroup'] = []
        if self.contact_group is not None:
            for k in self.contact_group:
                result['ContactGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.contact_group = []
        if m.get('ContactGroup') is not None:
            for k in m.get('ContactGroup'):
                temp_model = DeleteMonitorGroupResponseBodyGroupContactGroupsContactGroup()
                self.contact_group.append(temp_model.from_map(k))
        return self


class DeleteMonitorGroupResponseBodyGroup(TeaModel):
    def __init__(self, contact_groups=None, group_name=None):
        self.contact_groups = contact_groups  # type: DeleteMonitorGroupResponseBodyGroupContactGroups
        self.group_name = group_name  # type: str

    def validate(self):
        if self.contact_groups:
            self.contact_groups.validate()

    def to_map(self):
        _map = super(DeleteMonitorGroupResponseBodyGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups.to_map()
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroups') is not None:
            temp_model = DeleteMonitorGroupResponseBodyGroupContactGroups()
            self.contact_groups = temp_model.from_map(m['ContactGroups'])
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class DeleteMonitorGroupResponseBody(TeaModel):
    def __init__(self, code=None, group=None, message=None, request_id=None, success=None):
        self.code = code  # type: int
        self.group = group  # type: DeleteMonitorGroupResponseBodyGroup
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.group:
            self.group.validate()

    def to_map(self):
        _map = super(DeleteMonitorGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.group is not None:
            result['Group'] = self.group.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Group') is not None:
            temp_model = DeleteMonitorGroupResponseBodyGroup()
            self.group = temp_model.from_map(m['Group'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMonitorGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteMonitorGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMonitorGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMonitorGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMonitorGroupDynamicRuleRequest(TeaModel):
    def __init__(self, category=None, group_id=None, region_id=None):
        self.category = category  # type: str
        self.group_id = group_id  # type: long
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMonitorGroupDynamicRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteMonitorGroupDynamicRuleResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMonitorGroupDynamicRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMonitorGroupDynamicRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteMonitorGroupDynamicRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMonitorGroupDynamicRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMonitorGroupDynamicRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMonitorGroupInstancesRequest(TeaModel):
    def __init__(self, category=None, group_id=None, instance_id_list=None, region_id=None):
        self.category = category  # type: str
        self.group_id = group_id  # type: long
        self.instance_id_list = instance_id_list  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMonitorGroupInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_id_list is not None:
            result['InstanceIdList'] = self.instance_id_list
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceIdList') is not None:
            self.instance_id_list = m.get('InstanceIdList')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteMonitorGroupInstancesResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMonitorGroupInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMonitorGroupInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteMonitorGroupInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMonitorGroupInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMonitorGroupInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMonitorGroupNotifyPolicyRequest(TeaModel):
    def __init__(self, group_id=None, policy_type=None, region_id=None):
        self.group_id = group_id  # type: str
        self.policy_type = policy_type  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMonitorGroupNotifyPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteMonitorGroupNotifyPolicyResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, result=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.result = result  # type: int
        self.success = success  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMonitorGroupNotifyPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMonitorGroupNotifyPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteMonitorGroupNotifyPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMonitorGroupNotifyPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMonitorGroupNotifyPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMonitoringAgentProcessRequest(TeaModel):
    def __init__(self, instance_id=None, process_id=None, process_name=None, region_id=None):
        self.instance_id = instance_id  # type: str
        self.process_id = process_id  # type: str
        self.process_name = process_name  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMonitoringAgentProcessRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteMonitoringAgentProcessResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMonitoringAgentProcessResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMonitoringAgentProcessResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteMonitoringAgentProcessResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMonitoringAgentProcessResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMonitoringAgentProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSiteMonitorsRequest(TeaModel):
    def __init__(self, is_delete_alarms=None, region_id=None, task_ids=None):
        self.is_delete_alarms = is_delete_alarms  # type: bool
        self.region_id = region_id  # type: str
        self.task_ids = task_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSiteMonitorsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_delete_alarms is not None:
            result['IsDeleteAlarms'] = self.is_delete_alarms
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_ids is not None:
            result['TaskIds'] = self.task_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsDeleteAlarms') is not None:
            self.is_delete_alarms = m.get('IsDeleteAlarms')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskIds') is not None:
            self.task_ids = m.get('TaskIds')
        return self


class DeleteSiteMonitorsResponseBodyData(TeaModel):
    def __init__(self, count=None):
        self.count = count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSiteMonitorsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['count'] = self.count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('count') is not None:
            self.count = m.get('count')
        return self


class DeleteSiteMonitorsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: DeleteSiteMonitorsResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DeleteSiteMonitorsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DeleteSiteMonitorsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSiteMonitorsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSiteMonitorsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSiteMonitorsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSiteMonitorsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeActiveMetricRuleListRequest(TeaModel):
    def __init__(self, product=None):
        self.product = product  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeActiveMetricRuleListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product is not None:
            result['Product'] = self.product
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Product') is not None:
            self.product = m.get('Product')
        return self


class DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsCritical(TeaModel):
    def __init__(self, comparison_operator=None, statistics=None, threshold=None, times=None):
        self.comparison_operator = comparison_operator  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str
        self.times = times  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsCritical, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsInfo(TeaModel):
    def __init__(self, comparison_operator=None, statistics=None, threshold=None, times=None):
        self.comparison_operator = comparison_operator  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str
        self.times = times  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsWarn(TeaModel):
    def __init__(self, comparison_operator=None, statistics=None, threshold=None, times=None):
        self.comparison_operator = comparison_operator  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str
        self.times = times  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsWarn, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalations(TeaModel):
    def __init__(self, critical=None, info=None, warn=None):
        self.critical = critical  # type: DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsCritical
        self.info = info  # type: DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsInfo
        self.warn = warn  # type: DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsWarn

    def validate(self):
        if self.critical:
            self.critical.validate()
        if self.info:
            self.info.validate()
        if self.warn:
            self.warn.validate()

    def to_map(self):
        _map = super(DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.critical is not None:
            result['Critical'] = self.critical.to_map()
        if self.info is not None:
            result['Info'] = self.info.to_map()
        if self.warn is not None:
            result['Warn'] = self.warn.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Critical') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsCritical()
            self.critical = temp_model.from_map(m['Critical'])
        if m.get('Info') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsInfo()
            self.info = temp_model.from_map(m['Info'])
        if m.get('Warn') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalationsWarn()
            self.warn = temp_model.from_map(m['Warn'])
        return self


class DescribeActiveMetricRuleListResponseBodyAlertListAlert(TeaModel):
    def __init__(self, alert_state=None, contact_groups=None, dimensions=None, effective_interval=None,
                 enable_state=None, escalations=None, mail_subject=None, metric_name=None, namespace=None,
                 no_effective_interval=None, period=None, resources=None, rule_id=None, rule_name=None, silence_time=None, webhook=None):
        self.alert_state = alert_state  # type: str
        self.contact_groups = contact_groups  # type: str
        self.dimensions = dimensions  # type: str
        self.effective_interval = effective_interval  # type: str
        self.enable_state = enable_state  # type: bool
        self.escalations = escalations  # type: DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalations
        self.mail_subject = mail_subject  # type: str
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.no_effective_interval = no_effective_interval  # type: str
        self.period = period  # type: str
        self.resources = resources  # type: str
        self.rule_id = rule_id  # type: str
        self.rule_name = rule_name  # type: str
        self.silence_time = silence_time  # type: str
        self.webhook = webhook  # type: str

    def validate(self):
        if self.escalations:
            self.escalations.validate()

    def to_map(self):
        _map = super(DescribeActiveMetricRuleListResponseBodyAlertListAlert, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_state is not None:
            result['AlertState'] = self.alert_state
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.effective_interval is not None:
            result['EffectiveInterval'] = self.effective_interval
        if self.enable_state is not None:
            result['EnableState'] = self.enable_state
        if self.escalations is not None:
            result['Escalations'] = self.escalations.to_map()
        if self.mail_subject is not None:
            result['MailSubject'] = self.mail_subject
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.no_effective_interval is not None:
            result['NoEffectiveInterval'] = self.no_effective_interval
        if self.period is not None:
            result['Period'] = self.period
        if self.resources is not None:
            result['Resources'] = self.resources
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertState') is not None:
            self.alert_state = m.get('AlertState')
        if m.get('ContactGroups') is not None:
            self.contact_groups = m.get('ContactGroups')
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EffectiveInterval') is not None:
            self.effective_interval = m.get('EffectiveInterval')
        if m.get('EnableState') is not None:
            self.enable_state = m.get('EnableState')
        if m.get('Escalations') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBodyAlertListAlertEscalations()
            self.escalations = temp_model.from_map(m['Escalations'])
        if m.get('MailSubject') is not None:
            self.mail_subject = m.get('MailSubject')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NoEffectiveInterval') is not None:
            self.no_effective_interval = m.get('NoEffectiveInterval')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Resources') is not None:
            self.resources = m.get('Resources')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class DescribeActiveMetricRuleListResponseBodyAlertList(TeaModel):
    def __init__(self, alert=None):
        self.alert = alert  # type: list[DescribeActiveMetricRuleListResponseBodyAlertListAlert]

    def validate(self):
        if self.alert:
            for k in self.alert:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeActiveMetricRuleListResponseBodyAlertList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Alert'] = []
        if self.alert is not None:
            for k in self.alert:
                result['Alert'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alert = []
        if m.get('Alert') is not None:
            for k in m.get('Alert'):
                temp_model = DescribeActiveMetricRuleListResponseBodyAlertListAlert()
                self.alert.append(temp_model.from_map(k))
        return self


class DescribeActiveMetricRuleListResponseBodyDatapointsAlarm(TeaModel):
    def __init__(self, comparison_operator=None, contact_groups=None, enable=None, end_time=None,
                 evaluation_count=None, metric_name=None, namespace=None, period=None, rule_id=None, rule_name=None,
                 silence_time=None, start_time=None, state=None, statistics=None, threshold=None, webhook=None):
        self.comparison_operator = comparison_operator  # type: str
        self.contact_groups = contact_groups  # type: str
        self.enable = enable  # type: str
        self.end_time = end_time  # type: str
        self.evaluation_count = evaluation_count  # type: str
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.period = period  # type: str
        self.rule_id = rule_id  # type: str
        self.rule_name = rule_name  # type: str
        self.silence_time = silence_time  # type: str
        self.start_time = start_time  # type: str
        self.state = state  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str
        self.webhook = webhook  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeActiveMetricRuleListResponseBodyDatapointsAlarm, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.period is not None:
            result['Period'] = self.period
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.state is not None:
            result['State'] = self.state
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('ContactGroups') is not None:
            self.contact_groups = m.get('ContactGroups')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class DescribeActiveMetricRuleListResponseBodyDatapoints(TeaModel):
    def __init__(self, alarm=None):
        self.alarm = alarm  # type: list[DescribeActiveMetricRuleListResponseBodyDatapointsAlarm]

    def validate(self):
        if self.alarm:
            for k in self.alarm:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeActiveMetricRuleListResponseBodyDatapoints, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Alarm'] = []
        if self.alarm is not None:
            for k in self.alarm:
                result['Alarm'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alarm = []
        if m.get('Alarm') is not None:
            for k in m.get('Alarm'):
                temp_model = DescribeActiveMetricRuleListResponseBodyDatapointsAlarm()
                self.alarm.append(temp_model.from_map(k))
        return self


class DescribeActiveMetricRuleListResponseBody(TeaModel):
    def __init__(self, alert_list=None, code=None, datapoints=None, message=None, request_id=None, success=None):
        self.alert_list = alert_list  # type: DescribeActiveMetricRuleListResponseBodyAlertList
        self.code = code  # type: str
        self.datapoints = datapoints  # type: DescribeActiveMetricRuleListResponseBodyDatapoints
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.alert_list:
            self.alert_list.validate()
        if self.datapoints:
            self.datapoints.validate()

    def to_map(self):
        _map = super(DescribeActiveMetricRuleListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_list is not None:
            result['AlertList'] = self.alert_list.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertList') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBodyAlertList()
            self.alert_list = temp_model.from_map(m['AlertList'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBodyDatapoints()
            self.datapoints = temp_model.from_map(m['Datapoints'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeActiveMetricRuleListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeActiveMetricRuleListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeActiveMetricRuleListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeActiveMetricRuleListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlertHistoryListRequest(TeaModel):
    def __init__(self, ascending=None, end_time=None, group_id=None, metric_name=None, namespace=None, page=None,
                 page_size=None, region_id=None, rule_id=None, rule_name=None, start_time=None, state=None, status=None):
        self.ascending = ascending  # type: bool
        self.end_time = end_time  # type: str
        self.group_id = group_id  # type: str
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.rule_id = rule_id  # type: str
        self.rule_name = rule_name  # type: str
        self.start_time = start_time  # type: str
        self.state = state  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlertHistoryListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ascending is not None:
            result['Ascending'] = self.ascending
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.state is not None:
            result['State'] = self.state
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ascending') is not None:
            self.ascending = m.get('Ascending')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactALIIMs(TeaModel):
    def __init__(self, contact_aliim=None):
        self.contact_aliim = contact_aliim  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactALIIMs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_aliim is not None:
            result['ContactALIIM'] = self.contact_aliim
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactALIIM') is not None:
            self.contact_aliim = m.get('ContactALIIM')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactGroups(TeaModel):
    def __init__(self, contact_group=None):
        self.contact_group = contact_group  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group is not None:
            result['ContactGroup'] = self.contact_group
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroup') is not None:
            self.contact_group = m.get('ContactGroup')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactMails(TeaModel):
    def __init__(self, contact_mail=None):
        self.contact_mail = contact_mail  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactMails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_mail is not None:
            result['ContactMail'] = self.contact_mail
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactMail') is not None:
            self.contact_mail = m.get('ContactMail')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactSmses(TeaModel):
    def __init__(self, contact_sms=None):
        self.contact_sms = contact_sms  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactSmses, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_sms is not None:
            result['ContactSms'] = self.contact_sms
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactSms') is not None:
            self.contact_sms = m.get('ContactSms')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContacts(TeaModel):
    def __init__(self, contact=None):
        self.contact = contact  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContacts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact is not None:
            result['Contact'] = self.contact
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Contact') is not None:
            self.contact = m.get('Contact')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistory(TeaModel):
    def __init__(self, alert_time=None, contact_aliims=None, contact_groups=None, contact_mails=None,
                 contact_smses=None, contacts=None, dimensions=None, evaluation_count=None, expression=None, group_id=None,
                 instance_name=None, last_time=None, level=None, metric_name=None, namespace=None, rule_id=None, rule_name=None,
                 state=None, status=None, value=None, webhooks=None):
        self.alert_time = alert_time  # type: long
        self.contact_aliims = contact_aliims  # type: DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactALIIMs
        self.contact_groups = contact_groups  # type: DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactGroups
        self.contact_mails = contact_mails  # type: DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactMails
        self.contact_smses = contact_smses  # type: DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactSmses
        self.contacts = contacts  # type: DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContacts
        self.dimensions = dimensions  # type: str
        self.evaluation_count = evaluation_count  # type: int
        self.expression = expression  # type: str
        self.group_id = group_id  # type: str
        self.instance_name = instance_name  # type: str
        self.last_time = last_time  # type: long
        self.level = level  # type: str
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.rule_id = rule_id  # type: str
        self.rule_name = rule_name  # type: str
        self.state = state  # type: str
        self.status = status  # type: int
        self.value = value  # type: str
        self.webhooks = webhooks  # type: str

    def validate(self):
        if self.contact_aliims:
            self.contact_aliims.validate()
        if self.contact_groups:
            self.contact_groups.validate()
        if self.contact_mails:
            self.contact_mails.validate()
        if self.contact_smses:
            self.contact_smses.validate()
        if self.contacts:
            self.contacts.validate()

    def to_map(self):
        _map = super(DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistory, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_time is not None:
            result['AlertTime'] = self.alert_time
        if self.contact_aliims is not None:
            result['ContactALIIMs'] = self.contact_aliims.to_map()
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups.to_map()
        if self.contact_mails is not None:
            result['ContactMails'] = self.contact_mails.to_map()
        if self.contact_smses is not None:
            result['ContactSmses'] = self.contact_smses.to_map()
        if self.contacts is not None:
            result['Contacts'] = self.contacts.to_map()
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        if self.level is not None:
            result['Level'] = self.level
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.state is not None:
            result['State'] = self.state
        if self.status is not None:
            result['Status'] = self.status
        if self.value is not None:
            result['Value'] = self.value
        if self.webhooks is not None:
            result['Webhooks'] = self.webhooks
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertTime') is not None:
            self.alert_time = m.get('AlertTime')
        if m.get('ContactALIIMs') is not None:
            temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactALIIMs()
            self.contact_aliims = temp_model.from_map(m['ContactALIIMs'])
        if m.get('ContactGroups') is not None:
            temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactGroups()
            self.contact_groups = temp_model.from_map(m['ContactGroups'])
        if m.get('ContactMails') is not None:
            temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactMails()
            self.contact_mails = temp_model.from_map(m['ContactMails'])
        if m.get('ContactSmses') is not None:
            temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContactSmses()
            self.contact_smses = temp_model.from_map(m['ContactSmses'])
        if m.get('Contacts') is not None:
            temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistoryContacts()
            self.contacts = temp_model.from_map(m['Contacts'])
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Webhooks') is not None:
            self.webhooks = m.get('Webhooks')
        return self


class DescribeAlertHistoryListResponseBodyAlarmHistoryList(TeaModel):
    def __init__(self, alarm_history=None):
        self.alarm_history = alarm_history  # type: list[DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistory]

    def validate(self):
        if self.alarm_history:
            for k in self.alarm_history:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAlertHistoryListResponseBodyAlarmHistoryList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlarmHistory'] = []
        if self.alarm_history is not None:
            for k in self.alarm_history:
                result['AlarmHistory'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alarm_history = []
        if m.get('AlarmHistory') is not None:
            for k in m.get('AlarmHistory'):
                temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryListAlarmHistory()
                self.alarm_history.append(temp_model.from_map(k))
        return self


class DescribeAlertHistoryListResponseBody(TeaModel):
    def __init__(self, alarm_history_list=None, code=None, message=None, request_id=None, success=None, total=None):
        self.alarm_history_list = alarm_history_list  # type: DescribeAlertHistoryListResponseBodyAlarmHistoryList
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: str

    def validate(self):
        if self.alarm_history_list:
            self.alarm_history_list.validate()

    def to_map(self):
        _map = super(DescribeAlertHistoryListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_history_list is not None:
            result['AlarmHistoryList'] = self.alarm_history_list.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlarmHistoryList') is not None:
            temp_model = DescribeAlertHistoryListResponseBodyAlarmHistoryList()
            self.alarm_history_list = temp_model.from_map(m['AlarmHistoryList'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeAlertHistoryListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAlertHistoryListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAlertHistoryListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlertHistoryListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlertLogCountRequest(TeaModel):
    def __init__(self, contact_group=None, end_time=None, group_by=None, group_id=None, last_min=None, level=None,
                 metric_name=None, namespace=None, page_number=None, page_size=None, product=None, region_id=None,
                 rule_name=None, search_key=None, send_status=None, start_time=None):
        self.contact_group = contact_group  # type: str
        self.end_time = end_time  # type: long
        self.group_by = group_by  # type: str
        self.group_id = group_id  # type: str
        self.last_min = last_min  # type: str
        self.level = level  # type: str
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.product = product  # type: str
        self.region_id = region_id  # type: str
        self.rule_name = rule_name  # type: str
        self.search_key = search_key  # type: str
        self.send_status = send_status  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlertLogCountRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group is not None:
            result['ContactGroup'] = self.contact_group
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_by is not None:
            result['GroupBy'] = self.group_by
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.last_min is not None:
            result['LastMin'] = self.last_min
        if self.level is not None:
            result['Level'] = self.level
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.search_key is not None:
            result['SearchKey'] = self.search_key
        if self.send_status is not None:
            result['SendStatus'] = self.send_status
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroup') is not None:
            self.contact_group = m.get('ContactGroup')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupBy') is not None:
            self.group_by = m.get('GroupBy')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('LastMin') is not None:
            self.last_min = m.get('LastMin')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SearchKey') is not None:
            self.search_key = m.get('SearchKey')
        if m.get('SendStatus') is not None:
            self.send_status = m.get('SendStatus')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeAlertLogCountResponseBodyAlertLogCountLogs(TeaModel):
    def __init__(self, name=None, value=None):
        self.name = name  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlertLogCountResponseBodyAlertLogCountLogs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAlertLogCountResponseBodyAlertLogCount(TeaModel):
    def __init__(self, count=None, logs=None):
        self.count = count  # type: int
        self.logs = logs  # type: list[DescribeAlertLogCountResponseBodyAlertLogCountLogs]

    def validate(self):
        if self.logs:
            for k in self.logs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAlertLogCountResponseBodyAlertLogCount, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        result['Logs'] = []
        if self.logs is not None:
            for k in self.logs:
                result['Logs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.logs = []
        if m.get('Logs') is not None:
            for k in m.get('Logs'):
                temp_model = DescribeAlertLogCountResponseBodyAlertLogCountLogs()
                self.logs.append(temp_model.from_map(k))
        return self


class DescribeAlertLogCountResponseBody(TeaModel):
    def __init__(self, alert_log_count=None, code=None, message=None, request_id=None, success=None):
        self.alert_log_count = alert_log_count  # type: list[DescribeAlertLogCountResponseBodyAlertLogCount]
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.alert_log_count:
            for k in self.alert_log_count:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAlertLogCountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertLogCount'] = []
        if self.alert_log_count is not None:
            for k in self.alert_log_count:
                result['AlertLogCount'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alert_log_count = []
        if m.get('AlertLogCount') is not None:
            for k in m.get('AlertLogCount'):
                temp_model = DescribeAlertLogCountResponseBodyAlertLogCount()
                self.alert_log_count.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeAlertLogCountResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAlertLogCountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAlertLogCountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlertLogCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlertLogHistogramRequest(TeaModel):
    def __init__(self, contact_group=None, end_time=None, group_by=None, group_id=None, last_min=None, level=None,
                 metric_name=None, namespace=None, page_number=None, page_size=None, product=None, region_id=None,
                 rule_name=None, search_key=None, send_status=None, start_time=None):
        self.contact_group = contact_group  # type: str
        self.end_time = end_time  # type: long
        self.group_by = group_by  # type: str
        self.group_id = group_id  # type: str
        self.last_min = last_min  # type: str
        self.level = level  # type: str
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.product = product  # type: str
        self.region_id = region_id  # type: str
        self.rule_name = rule_name  # type: str
        self.search_key = search_key  # type: str
        self.send_status = send_status  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlertLogHistogramRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group is not None:
            result['ContactGroup'] = self.contact_group
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_by is not None:
            result['GroupBy'] = self.group_by
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.last_min is not None:
            result['LastMin'] = self.last_min
        if self.level is not None:
            result['Level'] = self.level
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.search_key is not None:
            result['SearchKey'] = self.search_key
        if self.send_status is not None:
            result['SendStatus'] = self.send_status
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroup') is not None:
            self.contact_group = m.get('ContactGroup')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupBy') is not None:
            self.group_by = m.get('GroupBy')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('LastMin') is not None:
            self.last_min = m.get('LastMin')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SearchKey') is not None:
            self.search_key = m.get('SearchKey')
        if m.get('SendStatus') is not None:
            self.send_status = m.get('SendStatus')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeAlertLogHistogramResponseBodyAlertLogHistogramList(TeaModel):
    def __init__(self, count=None, from_=None, to=None):
        self.count = count  # type: int
        self.from_ = from_  # type: long
        self.to = to  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlertLogHistogramResponseBodyAlertLogHistogramList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.from_ is not None:
            result['From'] = self.from_
        if self.to is not None:
            result['To'] = self.to
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('To') is not None:
            self.to = m.get('To')
        return self


class DescribeAlertLogHistogramResponseBody(TeaModel):
    def __init__(self, alert_log_histogram_list=None, code=None, message=None, request_id=None, success=None):
        self.alert_log_histogram_list = alert_log_histogram_list  # type: list[DescribeAlertLogHistogramResponseBodyAlertLogHistogramList]
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.alert_log_histogram_list:
            for k in self.alert_log_histogram_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAlertLogHistogramResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertLogHistogramList'] = []
        if self.alert_log_histogram_list is not None:
            for k in self.alert_log_histogram_list:
                result['AlertLogHistogramList'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alert_log_histogram_list = []
        if m.get('AlertLogHistogramList') is not None:
            for k in m.get('AlertLogHistogramList'):
                temp_model = DescribeAlertLogHistogramResponseBodyAlertLogHistogramList()
                self.alert_log_histogram_list.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeAlertLogHistogramResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAlertLogHistogramResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAlertLogHistogramResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlertLogHistogramResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlertLogListRequest(TeaModel):
    def __init__(self, contact_group=None, end_time=None, group_by=None, group_id=None, last_min=None, level=None,
                 metric_name=None, namespace=None, page_number=None, page_size=None, product=None, region_id=None, rule_id=None,
                 rule_name=None, search_key=None, send_status=None, start_time=None):
        self.contact_group = contact_group  # type: str
        self.end_time = end_time  # type: long
        self.group_by = group_by  # type: str
        self.group_id = group_id  # type: str
        self.last_min = last_min  # type: str
        self.level = level  # type: str
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.product = product  # type: str
        self.region_id = region_id  # type: str
        self.rule_id = rule_id  # type: str
        self.rule_name = rule_name  # type: str
        self.search_key = search_key  # type: str
        self.send_status = send_status  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlertLogListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group is not None:
            result['ContactGroup'] = self.contact_group
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_by is not None:
            result['GroupBy'] = self.group_by
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.last_min is not None:
            result['LastMin'] = self.last_min
        if self.level is not None:
            result['Level'] = self.level
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.search_key is not None:
            result['SearchKey'] = self.search_key
        if self.send_status is not None:
            result['SendStatus'] = self.send_status
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroup') is not None:
            self.contact_group = m.get('ContactGroup')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupBy') is not None:
            self.group_by = m.get('GroupBy')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('LastMin') is not None:
            self.last_min = m.get('LastMin')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SearchKey') is not None:
            self.search_key = m.get('SearchKey')
        if m.get('SendStatus') is not None:
            self.send_status = m.get('SendStatus')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeAlertLogListResponseBodyAlertLogListDimensions(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlertLogListResponseBodyAlertLogListDimensions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAlertLogListResponseBodyAlertLogListEscalation(TeaModel):
    def __init__(self, expression=None, level=None, times=None):
        self.expression = expression  # type: str
        self.level = level  # type: str
        self.times = times  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlertLogListResponseBodyAlertLogListEscalation, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.level is not None:
            result['Level'] = self.level
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeAlertLogListResponseBodyAlertLogListExtendedInfo(TeaModel):
    def __init__(self, name=None, value=None):
        self.name = name  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlertLogListResponseBodyAlertLogListExtendedInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAlertLogListResponseBodyAlertLogListSendDetailChannelResultListResultList(TeaModel):
    def __init__(self, code=None, detail=None, request_id=None, success=None, notify_target_list=None):
        self.code = code  # type: str
        self.detail = detail  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.notify_target_list = notify_target_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlertLogListResponseBodyAlertLogListSendDetailChannelResultListResultList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.notify_target_list is not None:
            result['notifyTargetList'] = self.notify_target_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('notifyTargetList') is not None:
            self.notify_target_list = m.get('notifyTargetList')
        return self


class DescribeAlertLogListResponseBodyAlertLogListSendDetailChannelResultList(TeaModel):
    def __init__(self, channel=None, result_list=None):
        self.channel = channel  # type: str
        self.result_list = result_list  # type: list[DescribeAlertLogListResponseBodyAlertLogListSendDetailChannelResultListResultList]

    def validate(self):
        if self.result_list:
            for k in self.result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAlertLogListResponseBodyAlertLogListSendDetailChannelResultList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel is not None:
            result['Channel'] = self.channel
        result['ResultList'] = []
        if self.result_list is not None:
            for k in self.result_list:
                result['ResultList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Channel') is not None:
            self.channel = m.get('Channel')
        self.result_list = []
        if m.get('ResultList') is not None:
            for k in m.get('ResultList'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogListSendDetailChannelResultListResultList()
                self.result_list.append(temp_model.from_map(k))
        return self


class DescribeAlertLogListResponseBodyAlertLogListSendDetail(TeaModel):
    def __init__(self, channel_result_list=None, result_code=None):
        self.channel_result_list = channel_result_list  # type: list[DescribeAlertLogListResponseBodyAlertLogListSendDetailChannelResultList]
        self.result_code = result_code  # type: str

    def validate(self):
        if self.channel_result_list:
            for k in self.channel_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAlertLogListResponseBodyAlertLogListSendDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ChannelResultList'] = []
        if self.channel_result_list is not None:
            for k in self.channel_result_list:
                result['ChannelResultList'].append(k.to_map() if k else None)
        if self.result_code is not None:
            result['ResultCode'] = self.result_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.channel_result_list = []
        if m.get('ChannelResultList') is not None:
            for k in m.get('ChannelResultList'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogListSendDetailChannelResultList()
                self.channel_result_list.append(temp_model.from_map(k))
        if m.get('ResultCode') is not None:
            self.result_code = m.get('ResultCode')
        return self


class DescribeAlertLogListResponseBodyAlertLogListSendResultList(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlertLogListResponseBodyAlertLogListSendResultList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAlertLogListResponseBodyAlertLogListWebhookList(TeaModel):
    def __init__(self, code=None, message=None, url=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlertLogListResponseBodyAlertLogListWebhookList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.url is not None:
            result['url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('url') is not None:
            self.url = m.get('url')
        return self


class DescribeAlertLogListResponseBodyAlertLogList(TeaModel):
    def __init__(self, alert_time=None, black_list_detail=None, black_list_name=None, black_list_uuid=None,
                 contact_aliiwwlist=None, contact_ding_list=None, contact_groups=None, contact_mail_list=None,
                 contact_on_call_list=None, contact_smslist=None, dimensions=None, dingding_webhook_list=None, escalation=None,
                 event_name=None, extended_info=None, group_id=None, group_name=None, instance_id=None, instance_name=None,
                 level=None, level_change=None, message=None, metric_name=None, namespace=None, product=None, rule_id=None,
                 rule_name=None, send_detail=None, send_result_list=None, send_status=None, webhook_list=None):
        self.alert_time = alert_time  # type: str
        self.black_list_detail = black_list_detail  # type: str
        self.black_list_name = black_list_name  # type: str
        self.black_list_uuid = black_list_uuid  # type: str
        self.contact_aliiwwlist = contact_aliiwwlist  # type: list[str]
        self.contact_ding_list = contact_ding_list  # type: list[str]
        self.contact_groups = contact_groups  # type: list[str]
        self.contact_mail_list = contact_mail_list  # type: list[str]
        self.contact_on_call_list = contact_on_call_list  # type: list[str]
        self.contact_smslist = contact_smslist  # type: list[str]
        self.dimensions = dimensions  # type: list[DescribeAlertLogListResponseBodyAlertLogListDimensions]
        self.dingding_webhook_list = dingding_webhook_list  # type: list[str]
        self.escalation = escalation  # type: DescribeAlertLogListResponseBodyAlertLogListEscalation
        self.event_name = event_name  # type: str
        self.extended_info = extended_info  # type: list[DescribeAlertLogListResponseBodyAlertLogListExtendedInfo]
        self.group_id = group_id  # type: str
        self.group_name = group_name  # type: str
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.level = level  # type: str
        self.level_change = level_change  # type: str
        self.message = message  # type: str
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.product = product  # type: str
        self.rule_id = rule_id  # type: str
        self.rule_name = rule_name  # type: str
        self.send_detail = send_detail  # type: DescribeAlertLogListResponseBodyAlertLogListSendDetail
        self.send_result_list = send_result_list  # type: list[DescribeAlertLogListResponseBodyAlertLogListSendResultList]
        self.send_status = send_status  # type: str
        self.webhook_list = webhook_list  # type: list[DescribeAlertLogListResponseBodyAlertLogListWebhookList]

    def validate(self):
        if self.dimensions:
            for k in self.dimensions:
                if k:
                    k.validate()
        if self.escalation:
            self.escalation.validate()
        if self.extended_info:
            for k in self.extended_info:
                if k:
                    k.validate()
        if self.send_detail:
            self.send_detail.validate()
        if self.send_result_list:
            for k in self.send_result_list:
                if k:
                    k.validate()
        if self.webhook_list:
            for k in self.webhook_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAlertLogListResponseBodyAlertLogList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_time is not None:
            result['AlertTime'] = self.alert_time
        if self.black_list_detail is not None:
            result['BlackListDetail'] = self.black_list_detail
        if self.black_list_name is not None:
            result['BlackListName'] = self.black_list_name
        if self.black_list_uuid is not None:
            result['BlackListUUID'] = self.black_list_uuid
        if self.contact_aliiwwlist is not None:
            result['ContactALIIWWList'] = self.contact_aliiwwlist
        if self.contact_ding_list is not None:
            result['ContactDingList'] = self.contact_ding_list
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups
        if self.contact_mail_list is not None:
            result['ContactMailList'] = self.contact_mail_list
        if self.contact_on_call_list is not None:
            result['ContactOnCallList'] = self.contact_on_call_list
        if self.contact_smslist is not None:
            result['ContactSMSList'] = self.contact_smslist
        result['Dimensions'] = []
        if self.dimensions is not None:
            for k in self.dimensions:
                result['Dimensions'].append(k.to_map() if k else None)
        if self.dingding_webhook_list is not None:
            result['DingdingWebhookList'] = self.dingding_webhook_list
        if self.escalation is not None:
            result['Escalation'] = self.escalation.to_map()
        if self.event_name is not None:
            result['EventName'] = self.event_name
        result['ExtendedInfo'] = []
        if self.extended_info is not None:
            for k in self.extended_info:
                result['ExtendedInfo'].append(k.to_map() if k else None)
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.level is not None:
            result['Level'] = self.level
        if self.level_change is not None:
            result['LevelChange'] = self.level_change
        if self.message is not None:
            result['Message'] = self.message
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.product is not None:
            result['Product'] = self.product
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.send_detail is not None:
            result['SendDetail'] = self.send_detail.to_map()
        result['SendResultList'] = []
        if self.send_result_list is not None:
            for k in self.send_result_list:
                result['SendResultList'].append(k.to_map() if k else None)
        if self.send_status is not None:
            result['SendStatus'] = self.send_status
        result['WebhookList'] = []
        if self.webhook_list is not None:
            for k in self.webhook_list:
                result['WebhookList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertTime') is not None:
            self.alert_time = m.get('AlertTime')
        if m.get('BlackListDetail') is not None:
            self.black_list_detail = m.get('BlackListDetail')
        if m.get('BlackListName') is not None:
            self.black_list_name = m.get('BlackListName')
        if m.get('BlackListUUID') is not None:
            self.black_list_uuid = m.get('BlackListUUID')
        if m.get('ContactALIIWWList') is not None:
            self.contact_aliiwwlist = m.get('ContactALIIWWList')
        if m.get('ContactDingList') is not None:
            self.contact_ding_list = m.get('ContactDingList')
        if m.get('ContactGroups') is not None:
            self.contact_groups = m.get('ContactGroups')
        if m.get('ContactMailList') is not None:
            self.contact_mail_list = m.get('ContactMailList')
        if m.get('ContactOnCallList') is not None:
            self.contact_on_call_list = m.get('ContactOnCallList')
        if m.get('ContactSMSList') is not None:
            self.contact_smslist = m.get('ContactSMSList')
        self.dimensions = []
        if m.get('Dimensions') is not None:
            for k in m.get('Dimensions'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogListDimensions()
                self.dimensions.append(temp_model.from_map(k))
        if m.get('DingdingWebhookList') is not None:
            self.dingding_webhook_list = m.get('DingdingWebhookList')
        if m.get('Escalation') is not None:
            temp_model = DescribeAlertLogListResponseBodyAlertLogListEscalation()
            self.escalation = temp_model.from_map(m['Escalation'])
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        self.extended_info = []
        if m.get('ExtendedInfo') is not None:
            for k in m.get('ExtendedInfo'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogListExtendedInfo()
                self.extended_info.append(temp_model.from_map(k))
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('LevelChange') is not None:
            self.level_change = m.get('LevelChange')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SendDetail') is not None:
            temp_model = DescribeAlertLogListResponseBodyAlertLogListSendDetail()
            self.send_detail = temp_model.from_map(m['SendDetail'])
        self.send_result_list = []
        if m.get('SendResultList') is not None:
            for k in m.get('SendResultList'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogListSendResultList()
                self.send_result_list.append(temp_model.from_map(k))
        if m.get('SendStatus') is not None:
            self.send_status = m.get('SendStatus')
        self.webhook_list = []
        if m.get('WebhookList') is not None:
            for k in m.get('WebhookList'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogListWebhookList()
                self.webhook_list.append(temp_model.from_map(k))
        return self


class DescribeAlertLogListResponseBody(TeaModel):
    def __init__(self, alert_log_list=None, code=None, message=None, page_number=None, page_size=None,
                 request_id=None, success=None):
        self.alert_log_list = alert_log_list  # type: list[DescribeAlertLogListResponseBodyAlertLogList]
        self.code = code  # type: str
        self.message = message  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.alert_log_list:
            for k in self.alert_log_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAlertLogListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertLogList'] = []
        if self.alert_log_list is not None:
            for k in self.alert_log_list:
                result['AlertLogList'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alert_log_list = []
        if m.get('AlertLogList') is not None:
            for k in m.get('AlertLogList'):
                temp_model = DescribeAlertLogListResponseBodyAlertLogList()
                self.alert_log_list.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeAlertLogListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAlertLogListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAlertLogListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlertLogListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlertingMetricRuleResourcesRequest(TeaModel):
    def __init__(self, dimensions=None, group_id=None, namespace=None, page=None, page_size=None, region_id=None,
                 rule_id=None):
        self.dimensions = dimensions  # type: str
        self.group_id = group_id  # type: str
        self.namespace = namespace  # type: str
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlertingMetricRuleResourcesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResourceExpressionListExpressionList(TeaModel):
    def __init__(self, comparison_operator=None, metric_name=None, period=None, statistics=None, threshold=None):
        self.comparison_operator = comparison_operator  # type: str
        self.metric_name = metric_name  # type: str
        self.period = period  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResourceExpressionListExpressionList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.period is not None:
            result['Period'] = self.period
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResourceExpressionList(TeaModel):
    def __init__(self, expression_list=None):
        self.expression_list = expression_list  # type: list[DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResourceExpressionListExpressionList]

    def validate(self):
        if self.expression_list:
            for k in self.expression_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResourceExpressionList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExpressionList'] = []
        if self.expression_list is not None:
            for k in self.expression_list:
                result['ExpressionList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.expression_list = []
        if m.get('ExpressionList') is not None:
            for k in m.get('ExpressionList'):
                temp_model = DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResourceExpressionListExpressionList()
                self.expression_list.append(temp_model.from_map(k))
        return self


class DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResource(TeaModel):
    def __init__(self, comparison_operator=None, expression=None, expression_list=None, expression_list_join=None,
                 level=None, pre_condition=None, tag=None, threshold=None, times=None):
        self.comparison_operator = comparison_operator  # type: str
        self.expression = expression  # type: str
        self.expression_list = expression_list  # type: DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResourceExpressionList
        self.expression_list_join = expression_list_join  # type: str
        self.level = level  # type: int
        self.pre_condition = pre_condition  # type: str
        self.tag = tag  # type: str
        self.threshold = threshold  # type: str
        self.times = times  # type: int

    def validate(self):
        if self.expression_list:
            self.expression_list.validate()

    def to_map(self):
        _map = super(DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.expression_list is not None:
            result['ExpressionList'] = self.expression_list.to_map()
        if self.expression_list_join is not None:
            result['ExpressionListJoin'] = self.expression_list_join
        if self.level is not None:
            result['Level'] = self.level
        if self.pre_condition is not None:
            result['PreCondition'] = self.pre_condition
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('ExpressionList') is not None:
            temp_model = DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResourceExpressionList()
            self.expression_list = temp_model.from_map(m['ExpressionList'])
        if m.get('ExpressionListJoin') is not None:
            self.expression_list_join = m.get('ExpressionListJoin')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('PreCondition') is not None:
            self.pre_condition = m.get('PreCondition')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalation(TeaModel):
    def __init__(self, resource=None):
        self.resource = resource  # type: list[DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResource]

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalation, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalationResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeAlertingMetricRuleResourcesResponseBodyResourcesResource(TeaModel):
    def __init__(self, dimensions=None, enable=None, escalation=None, group_id=None, last_alert_time=None,
                 last_modify_time=None, level=None, metric_name=None, metric_values=None, namespace=None, product_category=None,
                 resource=None, retry_times=None, rule_id=None, rule_name=None, start_time=None, statistics=None,
                 threshold=None):
        self.dimensions = dimensions  # type: str
        self.enable = enable  # type: str
        self.escalation = escalation  # type: DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalation
        self.group_id = group_id  # type: str
        self.last_alert_time = last_alert_time  # type: str
        self.last_modify_time = last_modify_time  # type: str
        self.level = level  # type: int
        self.metric_name = metric_name  # type: str
        self.metric_values = metric_values  # type: str
        self.namespace = namespace  # type: str
        self.product_category = product_category  # type: str
        self.resource = resource  # type: str
        self.retry_times = retry_times  # type: str
        self.rule_id = rule_id  # type: str
        self.rule_name = rule_name  # type: str
        self.start_time = start_time  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str

    def validate(self):
        if self.escalation:
            self.escalation.validate()

    def to_map(self):
        _map = super(DescribeAlertingMetricRuleResourcesResponseBodyResourcesResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.escalation is not None:
            result['Escalation'] = self.escalation.to_map()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.last_alert_time is not None:
            result['LastAlertTime'] = self.last_alert_time
        if self.last_modify_time is not None:
            result['LastModifyTime'] = self.last_modify_time
        if self.level is not None:
            result['Level'] = self.level
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.metric_values is not None:
            result['MetricValues'] = self.metric_values
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.product_category is not None:
            result['ProductCategory'] = self.product_category
        if self.resource is not None:
            result['Resource'] = self.resource
        if self.retry_times is not None:
            result['RetryTimes'] = self.retry_times
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('Escalation') is not None:
            temp_model = DescribeAlertingMetricRuleResourcesResponseBodyResourcesResourceEscalation()
            self.escalation = temp_model.from_map(m['Escalation'])
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('LastAlertTime') is not None:
            self.last_alert_time = m.get('LastAlertTime')
        if m.get('LastModifyTime') is not None:
            self.last_modify_time = m.get('LastModifyTime')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('MetricValues') is not None:
            self.metric_values = m.get('MetricValues')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('ProductCategory') is not None:
            self.product_category = m.get('ProductCategory')
        if m.get('Resource') is not None:
            self.resource = m.get('Resource')
        if m.get('RetryTimes') is not None:
            self.retry_times = m.get('RetryTimes')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class DescribeAlertingMetricRuleResourcesResponseBodyResources(TeaModel):
    def __init__(self, resource=None):
        self.resource = resource  # type: list[DescribeAlertingMetricRuleResourcesResponseBodyResourcesResource]

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAlertingMetricRuleResourcesResponseBodyResources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeAlertingMetricRuleResourcesResponseBodyResourcesResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeAlertingMetricRuleResourcesResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, resources=None, success=None, total=None):
        self.code = code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.resources = resources  # type: DescribeAlertingMetricRuleResourcesResponseBodyResources
        self.success = success  # type: bool
        self.total = total  # type: int

    def validate(self):
        if self.resources:
            self.resources.validate()

    def to_map(self):
        _map = super(DescribeAlertingMetricRuleResourcesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resources') is not None:
            temp_model = DescribeAlertingMetricRuleResourcesResponseBodyResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeAlertingMetricRuleResourcesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAlertingMetricRuleResourcesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAlertingMetricRuleResourcesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlertingMetricRuleResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContactGroupListRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, region_id=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContactGroupListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeContactGroupListResponseBodyContactGroupListContactGroupContacts(TeaModel):
    def __init__(self, contact=None):
        self.contact = contact  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContactGroupListResponseBodyContactGroupListContactGroupContacts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact is not None:
            result['Contact'] = self.contact
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Contact') is not None:
            self.contact = m.get('Contact')
        return self


class DescribeContactGroupListResponseBodyContactGroupListContactGroup(TeaModel):
    def __init__(self, contacts=None, create_time=None, describe=None, enable_subscribed=None,
                 enabled_weekly_report=None, name=None, update_time=None):
        self.contacts = contacts  # type: DescribeContactGroupListResponseBodyContactGroupListContactGroupContacts
        self.create_time = create_time  # type: long
        self.describe = describe  # type: str
        self.enable_subscribed = enable_subscribed  # type: bool
        self.enabled_weekly_report = enabled_weekly_report  # type: bool
        self.name = name  # type: str
        self.update_time = update_time  # type: long

    def validate(self):
        if self.contacts:
            self.contacts.validate()

    def to_map(self):
        _map = super(DescribeContactGroupListResponseBodyContactGroupListContactGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contacts is not None:
            result['Contacts'] = self.contacts.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.describe is not None:
            result['Describe'] = self.describe
        if self.enable_subscribed is not None:
            result['EnableSubscribed'] = self.enable_subscribed
        if self.enabled_weekly_report is not None:
            result['EnabledWeeklyReport'] = self.enabled_weekly_report
        if self.name is not None:
            result['Name'] = self.name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Contacts') is not None:
            temp_model = DescribeContactGroupListResponseBodyContactGroupListContactGroupContacts()
            self.contacts = temp_model.from_map(m['Contacts'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Describe') is not None:
            self.describe = m.get('Describe')
        if m.get('EnableSubscribed') is not None:
            self.enable_subscribed = m.get('EnableSubscribed')
        if m.get('EnabledWeeklyReport') is not None:
            self.enabled_weekly_report = m.get('EnabledWeeklyReport')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeContactGroupListResponseBodyContactGroupList(TeaModel):
    def __init__(self, contact_group=None):
        self.contact_group = contact_group  # type: list[DescribeContactGroupListResponseBodyContactGroupListContactGroup]

    def validate(self):
        if self.contact_group:
            for k in self.contact_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeContactGroupListResponseBodyContactGroupList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ContactGroup'] = []
        if self.contact_group is not None:
            for k in self.contact_group:
                result['ContactGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.contact_group = []
        if m.get('ContactGroup') is not None:
            for k in m.get('ContactGroup'):
                temp_model = DescribeContactGroupListResponseBodyContactGroupListContactGroup()
                self.contact_group.append(temp_model.from_map(k))
        return self


class DescribeContactGroupListResponseBodyContactGroups(TeaModel):
    def __init__(self, contact_group=None):
        self.contact_group = contact_group  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContactGroupListResponseBodyContactGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group is not None:
            result['ContactGroup'] = self.contact_group
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroup') is not None:
            self.contact_group = m.get('ContactGroup')
        return self


class DescribeContactGroupListResponseBody(TeaModel):
    def __init__(self, code=None, contact_group_list=None, contact_groups=None, message=None, request_id=None,
                 success=None, total=None):
        self.code = code  # type: str
        self.contact_group_list = contact_group_list  # type: DescribeContactGroupListResponseBodyContactGroupList
        self.contact_groups = contact_groups  # type: DescribeContactGroupListResponseBodyContactGroups
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: int

    def validate(self):
        if self.contact_group_list:
            self.contact_group_list.validate()
        if self.contact_groups:
            self.contact_groups.validate()

    def to_map(self):
        _map = super(DescribeContactGroupListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.contact_group_list is not None:
            result['ContactGroupList'] = self.contact_group_list.to_map()
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ContactGroupList') is not None:
            temp_model = DescribeContactGroupListResponseBodyContactGroupList()
            self.contact_group_list = temp_model.from_map(m['ContactGroupList'])
        if m.get('ContactGroups') is not None:
            temp_model = DescribeContactGroupListResponseBodyContactGroups()
            self.contact_groups = temp_model.from_map(m['ContactGroups'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeContactGroupListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeContactGroupListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeContactGroupListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeContactGroupListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContactListRequest(TeaModel):
    def __init__(self, chanel_type=None, chanel_value=None, contact_name=None, page_number=None, page_size=None,
                 region_id=None):
        self.chanel_type = chanel_type  # type: str
        self.chanel_value = chanel_value  # type: str
        self.contact_name = contact_name  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContactListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.chanel_type is not None:
            result['ChanelType'] = self.chanel_type
        if self.chanel_value is not None:
            result['ChanelValue'] = self.chanel_value
        if self.contact_name is not None:
            result['ContactName'] = self.contact_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChanelType') is not None:
            self.chanel_type = m.get('ChanelType')
        if m.get('ChanelValue') is not None:
            self.chanel_value = m.get('ChanelValue')
        if m.get('ContactName') is not None:
            self.contact_name = m.get('ContactName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeContactListResponseBodyContactsContactChannels(TeaModel):
    def __init__(self, ali_im=None, ding_web_hook=None, mail=None, sms=None):
        self.ali_im = ali_im  # type: str
        self.ding_web_hook = ding_web_hook  # type: str
        self.mail = mail  # type: str
        self.sms = sms  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContactListResponseBodyContactsContactChannels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_im is not None:
            result['AliIM'] = self.ali_im
        if self.ding_web_hook is not None:
            result['DingWebHook'] = self.ding_web_hook
        if self.mail is not None:
            result['Mail'] = self.mail
        if self.sms is not None:
            result['SMS'] = self.sms
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliIM') is not None:
            self.ali_im = m.get('AliIM')
        if m.get('DingWebHook') is not None:
            self.ding_web_hook = m.get('DingWebHook')
        if m.get('Mail') is not None:
            self.mail = m.get('Mail')
        if m.get('SMS') is not None:
            self.sms = m.get('SMS')
        return self


class DescribeContactListResponseBodyContactsContactChannelsState(TeaModel):
    def __init__(self, ali_im=None, ding_web_hook=None, mail=None, sms=None):
        self.ali_im = ali_im  # type: str
        self.ding_web_hook = ding_web_hook  # type: str
        self.mail = mail  # type: str
        self.sms = sms  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContactListResponseBodyContactsContactChannelsState, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_im is not None:
            result['AliIM'] = self.ali_im
        if self.ding_web_hook is not None:
            result['DingWebHook'] = self.ding_web_hook
        if self.mail is not None:
            result['Mail'] = self.mail
        if self.sms is not None:
            result['SMS'] = self.sms
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliIM') is not None:
            self.ali_im = m.get('AliIM')
        if m.get('DingWebHook') is not None:
            self.ding_web_hook = m.get('DingWebHook')
        if m.get('Mail') is not None:
            self.mail = m.get('Mail')
        if m.get('SMS') is not None:
            self.sms = m.get('SMS')
        return self


class DescribeContactListResponseBodyContactsContactContactGroups(TeaModel):
    def __init__(self, contact_group=None):
        self.contact_group = contact_group  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContactListResponseBodyContactsContactContactGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group is not None:
            result['ContactGroup'] = self.contact_group
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroup') is not None:
            self.contact_group = m.get('ContactGroup')
        return self


class DescribeContactListResponseBodyContactsContact(TeaModel):
    def __init__(self, channels=None, channels_state=None, contact_groups=None, create_time=None, desc=None,
                 lang=None, name=None, update_time=None):
        self.channels = channels  # type: DescribeContactListResponseBodyContactsContactChannels
        self.channels_state = channels_state  # type: DescribeContactListResponseBodyContactsContactChannelsState
        self.contact_groups = contact_groups  # type: DescribeContactListResponseBodyContactsContactContactGroups
        self.create_time = create_time  # type: long
        self.desc = desc  # type: str
        self.lang = lang  # type: str
        self.name = name  # type: str
        self.update_time = update_time  # type: long

    def validate(self):
        if self.channels:
            self.channels.validate()
        if self.channels_state:
            self.channels_state.validate()
        if self.contact_groups:
            self.contact_groups.validate()

    def to_map(self):
        _map = super(DescribeContactListResponseBodyContactsContact, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channels is not None:
            result['Channels'] = self.channels.to_map()
        if self.channels_state is not None:
            result['ChannelsState'] = self.channels_state.to_map()
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.name is not None:
            result['Name'] = self.name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Channels') is not None:
            temp_model = DescribeContactListResponseBodyContactsContactChannels()
            self.channels = temp_model.from_map(m['Channels'])
        if m.get('ChannelsState') is not None:
            temp_model = DescribeContactListResponseBodyContactsContactChannelsState()
            self.channels_state = temp_model.from_map(m['ChannelsState'])
        if m.get('ContactGroups') is not None:
            temp_model = DescribeContactListResponseBodyContactsContactContactGroups()
            self.contact_groups = temp_model.from_map(m['ContactGroups'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeContactListResponseBodyContacts(TeaModel):
    def __init__(self, contact=None):
        self.contact = contact  # type: list[DescribeContactListResponseBodyContactsContact]

    def validate(self):
        if self.contact:
            for k in self.contact:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeContactListResponseBodyContacts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Contact'] = []
        if self.contact is not None:
            for k in self.contact:
                result['Contact'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.contact = []
        if m.get('Contact') is not None:
            for k in m.get('Contact'):
                temp_model = DescribeContactListResponseBodyContactsContact()
                self.contact.append(temp_model.from_map(k))
        return self


class DescribeContactListResponseBody(TeaModel):
    def __init__(self, code=None, contacts=None, message=None, request_id=None, success=None, total=None):
        self.code = code  # type: str
        self.contacts = contacts  # type: DescribeContactListResponseBodyContacts
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: int

    def validate(self):
        if self.contacts:
            self.contacts.validate()

    def to_map(self):
        _map = super(DescribeContactListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.contacts is not None:
            result['Contacts'] = self.contacts.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Contacts') is not None:
            temp_model = DescribeContactListResponseBodyContacts()
            self.contacts = temp_model.from_map(m['Contacts'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeContactListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeContactListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeContactListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeContactListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContactListByContactGroupRequest(TeaModel):
    def __init__(self, contact_group_name=None, region_id=None):
        self.contact_group_name = contact_group_name  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContactListByContactGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_name is not None:
            result['ContactGroupName'] = self.contact_group_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroupName') is not None:
            self.contact_group_name = m.get('ContactGroupName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeContactListByContactGroupResponseBodyContactsContactChannels(TeaModel):
    def __init__(self, ali_im=None, ding_web_hook=None, mail=None, sms=None):
        self.ali_im = ali_im  # type: str
        self.ding_web_hook = ding_web_hook  # type: str
        self.mail = mail  # type: str
        self.sms = sms  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeContactListByContactGroupResponseBodyContactsContactChannels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_im is not None:
            result['AliIM'] = self.ali_im
        if self.ding_web_hook is not None:
            result['DingWebHook'] = self.ding_web_hook
        if self.mail is not None:
            result['Mail'] = self.mail
        if self.sms is not None:
            result['SMS'] = self.sms
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliIM') is not None:
            self.ali_im = m.get('AliIM')
        if m.get('DingWebHook') is not None:
            self.ding_web_hook = m.get('DingWebHook')
        if m.get('Mail') is not None:
            self.mail = m.get('Mail')
        if m.get('SMS') is not None:
            self.sms = m.get('SMS')
        return self


class DescribeContactListByContactGroupResponseBodyContactsContact(TeaModel):
    def __init__(self, channels=None, create_time=None, desc=None, name=None, update_time=None):
        self.channels = channels  # type: DescribeContactListByContactGroupResponseBodyContactsContactChannels
        self.create_time = create_time  # type: long
        self.desc = desc  # type: str
        self.name = name  # type: str
        self.update_time = update_time  # type: long

    def validate(self):
        if self.channels:
            self.channels.validate()

    def to_map(self):
        _map = super(DescribeContactListByContactGroupResponseBodyContactsContact, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channels is not None:
            result['Channels'] = self.channels.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.name is not None:
            result['Name'] = self.name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Channels') is not None:
            temp_model = DescribeContactListByContactGroupResponseBodyContactsContactChannels()
            self.channels = temp_model.from_map(m['Channels'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeContactListByContactGroupResponseBodyContacts(TeaModel):
    def __init__(self, contact=None):
        self.contact = contact  # type: list[DescribeContactListByContactGroupResponseBodyContactsContact]

    def validate(self):
        if self.contact:
            for k in self.contact:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeContactListByContactGroupResponseBodyContacts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Contact'] = []
        if self.contact is not None:
            for k in self.contact:
                result['Contact'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.contact = []
        if m.get('Contact') is not None:
            for k in m.get('Contact'):
                temp_model = DescribeContactListByContactGroupResponseBodyContactsContact()
                self.contact.append(temp_model.from_map(k))
        return self


class DescribeContactListByContactGroupResponseBody(TeaModel):
    def __init__(self, code=None, contacts=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.contacts = contacts  # type: DescribeContactListByContactGroupResponseBodyContacts
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.contacts:
            self.contacts.validate()

    def to_map(self):
        _map = super(DescribeContactListByContactGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.contacts is not None:
            result['Contacts'] = self.contacts.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Contacts') is not None:
            temp_model = DescribeContactListByContactGroupResponseBodyContacts()
            self.contacts = temp_model.from_map(m['Contacts'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeContactListByContactGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeContactListByContactGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeContactListByContactGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeContactListByContactGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomEventAttributeRequest(TeaModel):
    def __init__(self, end_time=None, event_id=None, group_id=None, name=None, page_number=None, page_size=None,
                 region_id=None, search_keywords=None, start_time=None):
        self.end_time = end_time  # type: str
        self.event_id = event_id  # type: str
        self.group_id = group_id  # type: str
        self.name = name  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.search_keywords = search_keywords  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomEventAttributeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.search_keywords is not None:
            result['SearchKeywords'] = self.search_keywords
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SearchKeywords') is not None:
            self.search_keywords = m.get('SearchKeywords')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeCustomEventAttributeResponseBodyCustomEventsCustomEvent(TeaModel):
    def __init__(self, content=None, group_id=None, id=None, name=None, time=None):
        self.content = content  # type: str
        self.group_id = group_id  # type: str
        self.id = id  # type: str
        self.name = name  # type: str
        self.time = time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomEventAttributeResponseBodyCustomEventsCustomEvent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeCustomEventAttributeResponseBodyCustomEvents(TeaModel):
    def __init__(self, custom_event=None):
        self.custom_event = custom_event  # type: list[DescribeCustomEventAttributeResponseBodyCustomEventsCustomEvent]

    def validate(self):
        if self.custom_event:
            for k in self.custom_event:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCustomEventAttributeResponseBodyCustomEvents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CustomEvent'] = []
        if self.custom_event is not None:
            for k in self.custom_event:
                result['CustomEvent'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.custom_event = []
        if m.get('CustomEvent') is not None:
            for k in m.get('CustomEvent'):
                temp_model = DescribeCustomEventAttributeResponseBodyCustomEventsCustomEvent()
                self.custom_event.append(temp_model.from_map(k))
        return self


class DescribeCustomEventAttributeResponseBody(TeaModel):
    def __init__(self, code=None, custom_events=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.custom_events = custom_events  # type: DescribeCustomEventAttributeResponseBodyCustomEvents
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.custom_events:
            self.custom_events.validate()

    def to_map(self):
        _map = super(DescribeCustomEventAttributeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.custom_events is not None:
            result['CustomEvents'] = self.custom_events.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CustomEvents') is not None:
            temp_model = DescribeCustomEventAttributeResponseBodyCustomEvents()
            self.custom_events = temp_model.from_map(m['CustomEvents'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCustomEventAttributeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCustomEventAttributeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCustomEventAttributeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCustomEventAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomEventCountRequest(TeaModel):
    def __init__(self, end_time=None, event_id=None, group_id=None, name=None, region_id=None, search_keywords=None,
                 start_time=None):
        self.end_time = end_time  # type: str
        self.event_id = event_id  # type: str
        self.group_id = group_id  # type: str
        self.name = name  # type: str
        self.region_id = region_id  # type: str
        self.search_keywords = search_keywords  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomEventCountRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.search_keywords is not None:
            result['SearchKeywords'] = self.search_keywords
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SearchKeywords') is not None:
            self.search_keywords = m.get('SearchKeywords')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeCustomEventCountResponseBodyCustomEventCountsCustomEventCount(TeaModel):
    def __init__(self, name=None, num=None, time=None):
        self.name = name  # type: str
        self.num = num  # type: int
        self.time = time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomEventCountResponseBodyCustomEventCountsCustomEventCount, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.num is not None:
            result['Num'] = self.num
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Num') is not None:
            self.num = m.get('Num')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeCustomEventCountResponseBodyCustomEventCounts(TeaModel):
    def __init__(self, custom_event_count=None):
        self.custom_event_count = custom_event_count  # type: list[DescribeCustomEventCountResponseBodyCustomEventCountsCustomEventCount]

    def validate(self):
        if self.custom_event_count:
            for k in self.custom_event_count:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCustomEventCountResponseBodyCustomEventCounts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CustomEventCount'] = []
        if self.custom_event_count is not None:
            for k in self.custom_event_count:
                result['CustomEventCount'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.custom_event_count = []
        if m.get('CustomEventCount') is not None:
            for k in m.get('CustomEventCount'):
                temp_model = DescribeCustomEventCountResponseBodyCustomEventCountsCustomEventCount()
                self.custom_event_count.append(temp_model.from_map(k))
        return self


class DescribeCustomEventCountResponseBody(TeaModel):
    def __init__(self, code=None, custom_event_counts=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.custom_event_counts = custom_event_counts  # type: DescribeCustomEventCountResponseBodyCustomEventCounts
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.custom_event_counts:
            self.custom_event_counts.validate()

    def to_map(self):
        _map = super(DescribeCustomEventCountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.custom_event_counts is not None:
            result['CustomEventCounts'] = self.custom_event_counts.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CustomEventCounts') is not None:
            temp_model = DescribeCustomEventCountResponseBodyCustomEventCounts()
            self.custom_event_counts = temp_model.from_map(m['CustomEventCounts'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCustomEventCountResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCustomEventCountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCustomEventCountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCustomEventCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomEventHistogramRequest(TeaModel):
    def __init__(self, end_time=None, event_id=None, group_id=None, level=None, name=None, region_id=None,
                 search_keywords=None, start_time=None):
        self.end_time = end_time  # type: str
        self.event_id = event_id  # type: str
        self.group_id = group_id  # type: str
        self.level = level  # type: str
        self.name = name  # type: str
        self.region_id = region_id  # type: str
        self.search_keywords = search_keywords  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomEventHistogramRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.search_keywords is not None:
            result['SearchKeywords'] = self.search_keywords
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SearchKeywords') is not None:
            self.search_keywords = m.get('SearchKeywords')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeCustomEventHistogramResponseBodyEventHistogramsEventHistogram(TeaModel):
    def __init__(self, count=None, end_time=None, start_time=None):
        self.count = count  # type: long
        self.end_time = end_time  # type: long
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomEventHistogramResponseBodyEventHistogramsEventHistogram, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeCustomEventHistogramResponseBodyEventHistograms(TeaModel):
    def __init__(self, event_histogram=None):
        self.event_histogram = event_histogram  # type: list[DescribeCustomEventHistogramResponseBodyEventHistogramsEventHistogram]

    def validate(self):
        if self.event_histogram:
            for k in self.event_histogram:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCustomEventHistogramResponseBodyEventHistograms, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventHistogram'] = []
        if self.event_histogram is not None:
            for k in self.event_histogram:
                result['EventHistogram'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.event_histogram = []
        if m.get('EventHistogram') is not None:
            for k in m.get('EventHistogram'):
                temp_model = DescribeCustomEventHistogramResponseBodyEventHistogramsEventHistogram()
                self.event_histogram.append(temp_model.from_map(k))
        return self


class DescribeCustomEventHistogramResponseBody(TeaModel):
    def __init__(self, code=None, event_histograms=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.event_histograms = event_histograms  # type: DescribeCustomEventHistogramResponseBodyEventHistograms
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.event_histograms:
            self.event_histograms.validate()

    def to_map(self):
        _map = super(DescribeCustomEventHistogramResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.event_histograms is not None:
            result['EventHistograms'] = self.event_histograms.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EventHistograms') is not None:
            temp_model = DescribeCustomEventHistogramResponseBodyEventHistograms()
            self.event_histograms = temp_model.from_map(m['EventHistograms'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCustomEventHistogramResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCustomEventHistogramResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCustomEventHistogramResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCustomEventHistogramResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomMetricListRequest(TeaModel):
    def __init__(self, dimension=None, group_id=None, md_5=None, metric_name=None, page_number=None, page_size=None,
                 region_id=None):
        self.dimension = dimension  # type: str
        self.group_id = group_id  # type: str
        self.md_5 = md_5  # type: str
        self.metric_name = metric_name  # type: str
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomMetricListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCustomMetricListResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, result=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.result = result  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomMetricListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class DescribeCustomMetricListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCustomMetricListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCustomMetricListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCustomMetricListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDynamicTagRuleListRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, tag_key=None, tag_region_id=None, tag_value=None):
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.tag_key = tag_key  # type: str
        self.tag_region_id = tag_region_id  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDynamicTagRuleListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_region_id is not None:
            result['TagRegionId'] = self.tag_region_id
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagRegionId') is not None:
            self.tag_region_id = m.get('TagRegionId')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupContactGroupList(TeaModel):
    def __init__(self, contact_group_list=None):
        self.contact_group_list = contact_group_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupContactGroupList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_list is not None:
            result['ContactGroupList'] = self.contact_group_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroupList') is not None:
            self.contact_group_list = m.get('ContactGroupList')
        return self


class DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupMatchExpressMatchExpress(TeaModel):
    def __init__(self, tag_value=None, tag_value_match_function=None):
        self.tag_value = tag_value  # type: str
        self.tag_value_match_function = tag_value_match_function  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupMatchExpressMatchExpress, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_value_match_function is not None:
            result['TagValueMatchFunction'] = self.tag_value_match_function
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagValueMatchFunction') is not None:
            self.tag_value_match_function = m.get('TagValueMatchFunction')
        return self


class DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupMatchExpress(TeaModel):
    def __init__(self, match_express=None):
        self.match_express = match_express  # type: list[DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupMatchExpressMatchExpress]

    def validate(self):
        if self.match_express:
            for k in self.match_express:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupMatchExpress, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MatchExpress'] = []
        if self.match_express is not None:
            for k in self.match_express:
                result['MatchExpress'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.match_express = []
        if m.get('MatchExpress') is not None:
            for k in m.get('MatchExpress'):
                temp_model = DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupMatchExpressMatchExpress()
                self.match_express.append(temp_model.from_map(k))
        return self


class DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupTemplateIdList(TeaModel):
    def __init__(self, template_id_list=None):
        self.template_id_list = template_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupTemplateIdList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id_list is not None:
            result['TemplateIdList'] = self.template_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TemplateIdList') is not None:
            self.template_id_list = m.get('TemplateIdList')
        return self


class DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroup(TeaModel):
    def __init__(self, contact_group_list=None, dynamic_tag_rule_id=None, match_express=None,
                 match_express_filter_relation=None, region_id=None, status=None, tag_key=None, template_id_list=None):
        self.contact_group_list = contact_group_list  # type: DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupContactGroupList
        self.dynamic_tag_rule_id = dynamic_tag_rule_id  # type: str
        self.match_express = match_express  # type: DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupMatchExpress
        self.match_express_filter_relation = match_express_filter_relation  # type: str
        self.region_id = region_id  # type: str
        self.status = status  # type: str
        self.tag_key = tag_key  # type: str
        self.template_id_list = template_id_list  # type: DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupTemplateIdList

    def validate(self):
        if self.contact_group_list:
            self.contact_group_list.validate()
        if self.match_express:
            self.match_express.validate()
        if self.template_id_list:
            self.template_id_list.validate()

    def to_map(self):
        _map = super(DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_list is not None:
            result['ContactGroupList'] = self.contact_group_list.to_map()
        if self.dynamic_tag_rule_id is not None:
            result['DynamicTagRuleId'] = self.dynamic_tag_rule_id
        if self.match_express is not None:
            result['MatchExpress'] = self.match_express.to_map()
        if self.match_express_filter_relation is not None:
            result['MatchExpressFilterRelation'] = self.match_express_filter_relation
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.template_id_list is not None:
            result['TemplateIdList'] = self.template_id_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroupList') is not None:
            temp_model = DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupContactGroupList()
            self.contact_group_list = temp_model.from_map(m['ContactGroupList'])
        if m.get('DynamicTagRuleId') is not None:
            self.dynamic_tag_rule_id = m.get('DynamicTagRuleId')
        if m.get('MatchExpress') is not None:
            temp_model = DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupMatchExpress()
            self.match_express = temp_model.from_map(m['MatchExpress'])
        if m.get('MatchExpressFilterRelation') is not None:
            self.match_express_filter_relation = m.get('MatchExpressFilterRelation')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TemplateIdList') is not None:
            temp_model = DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroupTemplateIdList()
            self.template_id_list = temp_model.from_map(m['TemplateIdList'])
        return self


class DescribeDynamicTagRuleListResponseBodyTagGroupList(TeaModel):
    def __init__(self, tag_group=None):
        self.tag_group = tag_group  # type: list[DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroup]

    def validate(self):
        if self.tag_group:
            for k in self.tag_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDynamicTagRuleListResponseBodyTagGroupList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TagGroup'] = []
        if self.tag_group is not None:
            for k in self.tag_group:
                result['TagGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag_group = []
        if m.get('TagGroup') is not None:
            for k in m.get('TagGroup'):
                temp_model = DescribeDynamicTagRuleListResponseBodyTagGroupListTagGroup()
                self.tag_group.append(temp_model.from_map(k))
        return self


class DescribeDynamicTagRuleListResponseBody(TeaModel):
    def __init__(self, code=None, message=None, page_number=None, page_size=None, request_id=None, success=None,
                 tag_group_list=None, total=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.tag_group_list = tag_group_list  # type: DescribeDynamicTagRuleListResponseBodyTagGroupList
        self.total = total  # type: int

    def validate(self):
        if self.tag_group_list:
            self.tag_group_list.validate()

    def to_map(self):
        _map = super(DescribeDynamicTagRuleListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.tag_group_list is not None:
            result['TagGroupList'] = self.tag_group_list.to_map()
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TagGroupList') is not None:
            temp_model = DescribeDynamicTagRuleListResponseBodyTagGroupList()
            self.tag_group_list = temp_model.from_map(m['TagGroupList'])
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeDynamicTagRuleListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDynamicTagRuleListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDynamicTagRuleListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDynamicTagRuleListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEventRuleAttributeRequest(TeaModel):
    def __init__(self, region_id=None, rule_name=None, silence_time=None):
        self.region_id = region_id  # type: str
        self.rule_name = rule_name  # type: str
        self.silence_time = silence_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEventRuleAttributeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        return self


class DescribeEventRuleAttributeResponseBodyResultEventPatternLevelList(TeaModel):
    def __init__(self, level_list=None):
        self.level_list = level_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEventRuleAttributeResponseBodyResultEventPatternLevelList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level_list is not None:
            result['LevelList'] = self.level_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LevelList') is not None:
            self.level_list = m.get('LevelList')
        return self


class DescribeEventRuleAttributeResponseBodyResultEventPatternNameList(TeaModel):
    def __init__(self, name_list=None):
        self.name_list = name_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEventRuleAttributeResponseBodyResultEventPatternNameList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name_list is not None:
            result['NameList'] = self.name_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NameList') is not None:
            self.name_list = m.get('NameList')
        return self


class DescribeEventRuleAttributeResponseBodyResultEventPatternStatusList(TeaModel):
    def __init__(self, status_list=None):
        self.status_list = status_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEventRuleAttributeResponseBodyResultEventPatternStatusList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        return self


class DescribeEventRuleAttributeResponseBodyResultEventPattern(TeaModel):
    def __init__(self, level_list=None, name_list=None, product=None, status_list=None):
        self.level_list = level_list  # type: DescribeEventRuleAttributeResponseBodyResultEventPatternLevelList
        self.name_list = name_list  # type: DescribeEventRuleAttributeResponseBodyResultEventPatternNameList
        self.product = product  # type: str
        self.status_list = status_list  # type: DescribeEventRuleAttributeResponseBodyResultEventPatternStatusList

    def validate(self):
        if self.level_list:
            self.level_list.validate()
        if self.name_list:
            self.name_list.validate()
        if self.status_list:
            self.status_list.validate()

    def to_map(self):
        _map = super(DescribeEventRuleAttributeResponseBodyResultEventPattern, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level_list is not None:
            result['LevelList'] = self.level_list.to_map()
        if self.name_list is not None:
            result['NameList'] = self.name_list.to_map()
        if self.product is not None:
            result['Product'] = self.product
        if self.status_list is not None:
            result['StatusList'] = self.status_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LevelList') is not None:
            temp_model = DescribeEventRuleAttributeResponseBodyResultEventPatternLevelList()
            self.level_list = temp_model.from_map(m['LevelList'])
        if m.get('NameList') is not None:
            temp_model = DescribeEventRuleAttributeResponseBodyResultEventPatternNameList()
            self.name_list = temp_model.from_map(m['NameList'])
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('StatusList') is not None:
            temp_model = DescribeEventRuleAttributeResponseBodyResultEventPatternStatusList()
            self.status_list = temp_model.from_map(m['StatusList'])
        return self


class DescribeEventRuleAttributeResponseBodyResult(TeaModel):
    def __init__(self, description=None, event_pattern=None, event_type=None, group_id=None, name=None, state=None):
        self.description = description  # type: str
        self.event_pattern = event_pattern  # type: DescribeEventRuleAttributeResponseBodyResultEventPattern
        self.event_type = event_type  # type: str
        self.group_id = group_id  # type: str
        self.name = name  # type: str
        self.state = state  # type: str

    def validate(self):
        if self.event_pattern:
            self.event_pattern.validate()

    def to_map(self):
        _map = super(DescribeEventRuleAttributeResponseBodyResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.event_pattern is not None:
            result['EventPattern'] = self.event_pattern.to_map()
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EventPattern') is not None:
            temp_model = DescribeEventRuleAttributeResponseBodyResultEventPattern()
            self.event_pattern = temp_model.from_map(m['EventPattern'])
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeEventRuleAttributeResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, result=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.result = result  # type: DescribeEventRuleAttributeResponseBodyResult
        self.success = success  # type: bool

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super(DescribeEventRuleAttributeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            temp_model = DescribeEventRuleAttributeResponseBodyResult()
            self.result = temp_model.from_map(m['Result'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeEventRuleAttributeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeEventRuleAttributeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeEventRuleAttributeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEventRuleAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEventRuleListRequest(TeaModel):
    def __init__(self, group_id=None, name_prefix=None, page_number=None, page_size=None, region_id=None):
        self.group_id = group_id  # type: str
        self.name_prefix = name_prefix  # type: str
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEventRuleListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.name_prefix is not None:
            result['NamePrefix'] = self.name_prefix
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('NamePrefix') is not None:
            self.name_prefix = m.get('NamePrefix')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternEventTypeList(TeaModel):
    def __init__(self, event_type_list=None):
        self.event_type_list = event_type_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternEventTypeList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_type_list is not None:
            result['EventTypeList'] = self.event_type_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EventTypeList') is not None:
            self.event_type_list = m.get('EventTypeList')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternKeywordFilterKeywords(TeaModel):
    def __init__(self, keywords=None):
        self.keywords = keywords  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternKeywordFilterKeywords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keywords is not None:
            result['Keywords'] = self.keywords
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Keywords') is not None:
            self.keywords = m.get('Keywords')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternKeywordFilter(TeaModel):
    def __init__(self, keywords=None, relation=None):
        self.keywords = keywords  # type: DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternKeywordFilterKeywords
        self.relation = relation  # type: str

    def validate(self):
        if self.keywords:
            self.keywords.validate()

    def to_map(self):
        _map = super(DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternKeywordFilter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keywords is not None:
            result['Keywords'] = self.keywords.to_map()
        if self.relation is not None:
            result['Relation'] = self.relation
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Keywords') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternKeywordFilterKeywords()
            self.keywords = temp_model.from_map(m['Keywords'])
        if m.get('Relation') is not None:
            self.relation = m.get('Relation')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternLevelList(TeaModel):
    def __init__(self, level_list=None):
        self.level_list = level_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternLevelList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level_list is not None:
            result['LevelList'] = self.level_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LevelList') is not None:
            self.level_list = m.get('LevelList')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternNameList(TeaModel):
    def __init__(self, name_list=None):
        self.name_list = name_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternNameList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name_list is not None:
            result['NameList'] = self.name_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NameList') is not None:
            self.name_list = m.get('NameList')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPattern(TeaModel):
    def __init__(self, custom_filters=None, event_type_list=None, keyword_filter=None, level_list=None,
                 name_list=None, product=None, sqlfilter=None):
        self.custom_filters = custom_filters  # type: str
        self.event_type_list = event_type_list  # type: DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternEventTypeList
        self.keyword_filter = keyword_filter  # type: DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternKeywordFilter
        self.level_list = level_list  # type: DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternLevelList
        self.name_list = name_list  # type: DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternNameList
        self.product = product  # type: str
        self.sqlfilter = sqlfilter  # type: str

    def validate(self):
        if self.event_type_list:
            self.event_type_list.validate()
        if self.keyword_filter:
            self.keyword_filter.validate()
        if self.level_list:
            self.level_list.validate()
        if self.name_list:
            self.name_list.validate()

    def to_map(self):
        _map = super(DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPattern, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_filters is not None:
            result['CustomFilters'] = self.custom_filters
        if self.event_type_list is not None:
            result['EventTypeList'] = self.event_type_list.to_map()
        if self.keyword_filter is not None:
            result['KeywordFilter'] = self.keyword_filter.to_map()
        if self.level_list is not None:
            result['LevelList'] = self.level_list.to_map()
        if self.name_list is not None:
            result['NameList'] = self.name_list.to_map()
        if self.product is not None:
            result['Product'] = self.product
        if self.sqlfilter is not None:
            result['SQLFilter'] = self.sqlfilter
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomFilters') is not None:
            self.custom_filters = m.get('CustomFilters')
        if m.get('EventTypeList') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternEventTypeList()
            self.event_type_list = temp_model.from_map(m['EventTypeList'])
        if m.get('KeywordFilter') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternKeywordFilter()
            self.keyword_filter = temp_model.from_map(m['KeywordFilter'])
        if m.get('LevelList') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternLevelList()
            self.level_list = temp_model.from_map(m['LevelList'])
        if m.get('NameList') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPatternNameList()
            self.name_list = temp_model.from_map(m['NameList'])
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('SQLFilter') is not None:
            self.sqlfilter = m.get('SQLFilter')
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRuleEventPattern(TeaModel):
    def __init__(self, event_pattern=None):
        self.event_pattern = event_pattern  # type: list[DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPattern]

    def validate(self):
        if self.event_pattern:
            for k in self.event_pattern:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeEventRuleListResponseBodyEventRulesEventRuleEventPattern, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventPattern'] = []
        if self.event_pattern is not None:
            for k in self.event_pattern:
                result['EventPattern'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.event_pattern = []
        if m.get('EventPattern') is not None:
            for k in m.get('EventPattern'):
                temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPatternEventPattern()
                self.event_pattern.append(temp_model.from_map(k))
        return self


class DescribeEventRuleListResponseBodyEventRulesEventRule(TeaModel):
    def __init__(self, description=None, event_pattern=None, event_type=None, group_id=None, name=None,
                 silence_time=None, state=None):
        self.description = description  # type: str
        self.event_pattern = event_pattern  # type: DescribeEventRuleListResponseBodyEventRulesEventRuleEventPattern
        self.event_type = event_type  # type: str
        self.group_id = group_id  # type: str
        self.name = name  # type: str
        self.silence_time = silence_time  # type: long
        self.state = state  # type: str

    def validate(self):
        if self.event_pattern:
            self.event_pattern.validate()

    def to_map(self):
        _map = super(DescribeEventRuleListResponseBodyEventRulesEventRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.event_pattern is not None:
            result['EventPattern'] = self.event_pattern.to_map()
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EventPattern') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRulesEventRuleEventPattern()
            self.event_pattern = temp_model.from_map(m['EventPattern'])
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeEventRuleListResponseBodyEventRules(TeaModel):
    def __init__(self, event_rule=None):
        self.event_rule = event_rule  # type: list[DescribeEventRuleListResponseBodyEventRulesEventRule]

    def validate(self):
        if self.event_rule:
            for k in self.event_rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeEventRuleListResponseBodyEventRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventRule'] = []
        if self.event_rule is not None:
            for k in self.event_rule:
                result['EventRule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.event_rule = []
        if m.get('EventRule') is not None:
            for k in m.get('EventRule'):
                temp_model = DescribeEventRuleListResponseBodyEventRulesEventRule()
                self.event_rule.append(temp_model.from_map(k))
        return self


class DescribeEventRuleListResponseBody(TeaModel):
    def __init__(self, code=None, event_rules=None, message=None, request_id=None, success=None, total=None):
        self.code = code  # type: str
        self.event_rules = event_rules  # type: DescribeEventRuleListResponseBodyEventRules
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: int

    def validate(self):
        if self.event_rules:
            self.event_rules.validate()

    def to_map(self):
        _map = super(DescribeEventRuleListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.event_rules is not None:
            result['EventRules'] = self.event_rules.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EventRules') is not None:
            temp_model = DescribeEventRuleListResponseBodyEventRules()
            self.event_rules = temp_model.from_map(m['EventRules'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeEventRuleListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeEventRuleListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeEventRuleListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEventRuleListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEventRuleTargetListRequest(TeaModel):
    def __init__(self, region_id=None, rule_name=None):
        self.region_id = region_id  # type: str
        self.rule_name = rule_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEventRuleTargetListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class DescribeEventRuleTargetListResponseBodyContactParametersContactParameter(TeaModel):
    def __init__(self, contact_group_name=None, id=None, level=None):
        self.contact_group_name = contact_group_name  # type: str
        self.id = id  # type: str
        self.level = level  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEventRuleTargetListResponseBodyContactParametersContactParameter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_group_name is not None:
            result['ContactGroupName'] = self.contact_group_name
        if self.id is not None:
            result['Id'] = self.id
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ContactGroupName') is not None:
            self.contact_group_name = m.get('ContactGroupName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class DescribeEventRuleTargetListResponseBodyContactParameters(TeaModel):
    def __init__(self, contact_parameter=None):
        self.contact_parameter = contact_parameter  # type: list[DescribeEventRuleTargetListResponseBodyContactParametersContactParameter]

    def validate(self):
        if self.contact_parameter:
            for k in self.contact_parameter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeEventRuleTargetListResponseBodyContactParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ContactParameter'] = []
        if self.contact_parameter is not None:
            for k in self.contact_parameter:
                result['ContactParameter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.contact_parameter = []
        if m.get('ContactParameter') is not None:
            for k in m.get('ContactParameter'):
                temp_model = DescribeEventRuleTargetListResponseBodyContactParametersContactParameter()
                self.contact_parameter.append(temp_model.from_map(k))
        return self


class DescribeEventRuleTargetListResponseBodyFcParametersFCParameter(TeaModel):
    def __init__(self, arn=None, function_name=None, id=None, region=None, service_name=None):
        self.arn = arn  # type: str
        self.function_name = function_name  # type: str
        self.id = id  # type: str
        self.region = region  # type: str
        self.service_name = service_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEventRuleTargetListResponseBodyFcParametersFCParameter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        if self.id is not None:
            result['Id'] = self.id
        if self.region is not None:
            result['Region'] = self.region
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class DescribeEventRuleTargetListResponseBodyFcParameters(TeaModel):
    def __init__(self, fcparameter=None):
        self.fcparameter = fcparameter  # type: list[DescribeEventRuleTargetListResponseBodyFcParametersFCParameter]

    def validate(self):
        if self.fcparameter:
            for k in self.fcparameter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeEventRuleTargetListResponseBodyFcParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FCParameter'] = []
        if self.fcparameter is not None:
            for k in self.fcparameter:
                result['FCParameter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.fcparameter = []
        if m.get('FCParameter') is not None:
            for k in m.get('FCParameter'):
                temp_model = DescribeEventRuleTargetListResponseBodyFcParametersFCParameter()
                self.fcparameter.append(temp_model.from_map(k))
        return self


class DescribeEventRuleTargetListResponseBodyMnsParametersMnsParameter(TeaModel):
    def __init__(self, arn=None, id=None, queue=None, region=None, topic=None):
        self.arn = arn  # type: str
        self.id = id  # type: str
        self.queue = queue  # type: str
        self.region = region  # type: str
        self.topic = topic  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEventRuleTargetListResponseBodyMnsParametersMnsParameter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.id is not None:
            result['Id'] = self.id
        if self.queue is not None:
            result['Queue'] = self.queue
        if self.region is not None:
            result['Region'] = self.region
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class DescribeEventRuleTargetListResponseBodyMnsParameters(TeaModel):
    def __init__(self, mns_parameter=None):
        self.mns_parameter = mns_parameter  # type: list[DescribeEventRuleTargetListResponseBodyMnsParametersMnsParameter]

    def validate(self):
        if self.mns_parameter:
            for k in self.mns_parameter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeEventRuleTargetListResponseBodyMnsParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MnsParameter'] = []
        if self.mns_parameter is not None:
            for k in self.mns_parameter:
                result['MnsParameter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.mns_parameter = []
        if m.get('MnsParameter') is not None:
            for k in m.get('MnsParameter'):
                temp_model = DescribeEventRuleTargetListResponseBodyMnsParametersMnsParameter()
                self.mns_parameter.append(temp_model.from_map(k))
        return self


class DescribeEventRuleTargetListResponseBodyOpenApiParametersOpenApiParameters(TeaModel):
    def __init__(self, action=None, arn=None, id=None, product=None, region=None, role=None, version=None):
        self.action = action  # type: str
        self.arn = arn  # type: str
        self.id = id  # type: str
        self.product = product  # type: str
        self.region = region  # type: str
        self.role = role  # type: str
        self.version = version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEventRuleTargetListResponseBodyOpenApiParametersOpenApiParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.id is not None:
            result['Id'] = self.id
        if self.product is not None:
            result['Product'] = self.product
        if self.region is not None:
            result['Region'] = self.region
        if self.role is not None:
            result['Role'] = self.role
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class DescribeEventRuleTargetListResponseBodyOpenApiParameters(TeaModel):
    def __init__(self, open_api_parameters=None):
        self.open_api_parameters = open_api_parameters  # type: list[DescribeEventRuleTargetListResponseBodyOpenApiParametersOpenApiParameters]

    def validate(self):
        if self.open_api_parameters:
            for k in self.open_api_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeEventRuleTargetListResponseBodyOpenApiParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OpenApiParameters'] = []
        if self.open_api_parameters is not None:
            for k in self.open_api_parameters:
                result['OpenApiParameters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.open_api_parameters = []
        if m.get('OpenApiParameters') is not None:
            for k in m.get('OpenApiParameters'):
                temp_model = DescribeEventRuleTargetListResponseBodyOpenApiParametersOpenApiParameters()
                self.open_api_parameters.append(temp_model.from_map(k))
        return self


class DescribeEventRuleTargetListResponseBodySlsParametersSlsParameter(TeaModel):
    def __init__(self, arn=None, id=None, log_store=None, project=None, region=None):
        self.arn = arn  # type: str
        self.id = id  # type: str
        self.log_store = log_store  # type: str
        self.project = project  # type: str
        self.region = region  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEventRuleTargetListResponseBodySlsParametersSlsParameter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.id is not None:
            result['Id'] = self.id
        if self.log_store is not None:
            result['LogStore'] = self.log_store
        if self.project is not None:
            result['Project'] = self.project
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('LogStore') is not None:
            self.log_store = m.get('LogStore')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class DescribeEventRuleTargetListResponseBodySlsParameters(TeaModel):
    def __init__(self, sls_parameter=None):
        self.sls_parameter = sls_parameter  # type: list[DescribeEventRuleTargetListResponseBodySlsParametersSlsParameter]

    def validate(self):
        if self.sls_parameter:
            for k in self.sls_parameter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeEventRuleTargetListResponseBodySlsParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SlsParameter'] = []
        if self.sls_parameter is not None:
            for k in self.sls_parameter:
                result['SlsParameter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.sls_parameter = []
        if m.get('SlsParameter') is not None:
            for k in m.get('SlsParameter'):
                temp_model = DescribeEventRuleTargetListResponseBodySlsParametersSlsParameter()
                self.sls_parameter.append(temp_model.from_map(k))
        return self


class DescribeEventRuleTargetListResponseBodyWebhookParametersWebhookParameter(TeaModel):
    def __init__(self, id=None, method=None, protocol=None, url=None):
        self.id = id  # type: str
        self.method = method  # type: str
        self.protocol = protocol  # type: str
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEventRuleTargetListResponseBodyWebhookParametersWebhookParameter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.method is not None:
            result['Method'] = self.method
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class DescribeEventRuleTargetListResponseBodyWebhookParameters(TeaModel):
    def __init__(self, webhook_parameter=None):
        self.webhook_parameter = webhook_parameter  # type: list[DescribeEventRuleTargetListResponseBodyWebhookParametersWebhookParameter]

    def validate(self):
        if self.webhook_parameter:
            for k in self.webhook_parameter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeEventRuleTargetListResponseBodyWebhookParameters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['WebhookParameter'] = []
        if self.webhook_parameter is not None:
            for k in self.webhook_parameter:
                result['WebhookParameter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.webhook_parameter = []
        if m.get('WebhookParameter') is not None:
            for k in m.get('WebhookParameter'):
                temp_model = DescribeEventRuleTargetListResponseBodyWebhookParametersWebhookParameter()
                self.webhook_parameter.append(temp_model.from_map(k))
        return self


class DescribeEventRuleTargetListResponseBody(TeaModel):
    def __init__(self, code=None, contact_parameters=None, fc_parameters=None, message=None, mns_parameters=None,
                 open_api_parameters=None, request_id=None, sls_parameters=None, webhook_parameters=None):
        self.code = code  # type: str
        self.contact_parameters = contact_parameters  # type: DescribeEventRuleTargetListResponseBodyContactParameters
        self.fc_parameters = fc_parameters  # type: DescribeEventRuleTargetListResponseBodyFcParameters
        self.message = message  # type: str
        self.mns_parameters = mns_parameters  # type: DescribeEventRuleTargetListResponseBodyMnsParameters
        self.open_api_parameters = open_api_parameters  # type: DescribeEventRuleTargetListResponseBodyOpenApiParameters
        self.request_id = request_id  # type: str
        self.sls_parameters = sls_parameters  # type: DescribeEventRuleTargetListResponseBodySlsParameters
        self.webhook_parameters = webhook_parameters  # type: DescribeEventRuleTargetListResponseBodyWebhookParameters

    def validate(self):
        if self.contact_parameters:
            self.contact_parameters.validate()
        if self.fc_parameters:
            self.fc_parameters.validate()
        if self.mns_parameters:
            self.mns_parameters.validate()
        if self.open_api_parameters:
            self.open_api_parameters.validate()
        if self.sls_parameters:
            self.sls_parameters.validate()
        if self.webhook_parameters:
            self.webhook_parameters.validate()

    def to_map(self):
        _map = super(DescribeEventRuleTargetListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.contact_parameters is not None:
            result['ContactParameters'] = self.contact_parameters.to_map()
        if self.fc_parameters is not None:
            result['FcParameters'] = self.fc_parameters.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.mns_parameters is not None:
            result['MnsParameters'] = self.mns_parameters.to_map()
        if self.open_api_parameters is not None:
            result['OpenApiParameters'] = self.open_api_parameters.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sls_parameters is not None:
            result['SlsParameters'] = self.sls_parameters.to_map()
        if self.webhook_parameters is not None:
            result['WebhookParameters'] = self.webhook_parameters.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ContactParameters') is not None:
            temp_model = DescribeEventRuleTargetListResponseBodyContactParameters()
            self.contact_parameters = temp_model.from_map(m['ContactParameters'])
        if m.get('FcParameters') is not None:
            temp_model = DescribeEventRuleTargetListResponseBodyFcParameters()
            self.fc_parameters = temp_model.from_map(m['FcParameters'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MnsParameters') is not None:
            temp_model = DescribeEventRuleTargetListResponseBodyMnsParameters()
            self.mns_parameters = temp_model.from_map(m['MnsParameters'])
        if m.get('OpenApiParameters') is not None:
            temp_model = DescribeEventRuleTargetListResponseBodyOpenApiParameters()
            self.open_api_parameters = temp_model.from_map(m['OpenApiParameters'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SlsParameters') is not None:
            temp_model = DescribeEventRuleTargetListResponseBodySlsParameters()
            self.sls_parameters = temp_model.from_map(m['SlsParameters'])
        if m.get('WebhookParameters') is not None:
            temp_model = DescribeEventRuleTargetListResponseBodyWebhookParameters()
            self.webhook_parameters = temp_model.from_map(m['WebhookParameters'])
        return self


class DescribeEventRuleTargetListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeEventRuleTargetListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeEventRuleTargetListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEventRuleTargetListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExporterOutputListRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, region_id=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExporterOutputListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeExporterOutputListResponseBodyDatapointsDatapointConfigJson(TeaModel):
    def __init__(self, ak=None, endpoint=None, logstore=None, project=None):
        self.ak = ak  # type: str
        self.endpoint = endpoint  # type: str
        self.logstore = logstore  # type: str
        self.project = project  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExporterOutputListResponseBodyDatapointsDatapointConfigJson, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ak is not None:
            result['ak'] = self.ak
        if self.endpoint is not None:
            result['endpoint'] = self.endpoint
        if self.logstore is not None:
            result['logstore'] = self.logstore
        if self.project is not None:
            result['project'] = self.project
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ak') is not None:
            self.ak = m.get('ak')
        if m.get('endpoint') is not None:
            self.endpoint = m.get('endpoint')
        if m.get('logstore') is not None:
            self.logstore = m.get('logstore')
        if m.get('project') is not None:
            self.project = m.get('project')
        return self


class DescribeExporterOutputListResponseBodyDatapointsDatapoint(TeaModel):
    def __init__(self, config_json=None, create_time=None, dest_name=None, dest_type=None):
        self.config_json = config_json  # type: DescribeExporterOutputListResponseBodyDatapointsDatapointConfigJson
        self.create_time = create_time  # type: long
        self.dest_name = dest_name  # type: str
        self.dest_type = dest_type  # type: str

    def validate(self):
        if self.config_json:
            self.config_json.validate()

    def to_map(self):
        _map = super(DescribeExporterOutputListResponseBodyDatapointsDatapoint, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_json is not None:
            result['ConfigJson'] = self.config_json.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dest_name is not None:
            result['DestName'] = self.dest_name
        if self.dest_type is not None:
            result['DestType'] = self.dest_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigJson') is not None:
            temp_model = DescribeExporterOutputListResponseBodyDatapointsDatapointConfigJson()
            self.config_json = temp_model.from_map(m['ConfigJson'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DestName') is not None:
            self.dest_name = m.get('DestName')
        if m.get('DestType') is not None:
            self.dest_type = m.get('DestType')
        return self


class DescribeExporterOutputListResponseBodyDatapoints(TeaModel):
    def __init__(self, datapoint=None):
        self.datapoint = datapoint  # type: list[DescribeExporterOutputListResponseBodyDatapointsDatapoint]

    def validate(self):
        if self.datapoint:
            for k in self.datapoint:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeExporterOutputListResponseBodyDatapoints, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Datapoint'] = []
        if self.datapoint is not None:
            for k in self.datapoint:
                result['Datapoint'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.datapoint = []
        if m.get('Datapoint') is not None:
            for k in m.get('Datapoint'):
                temp_model = DescribeExporterOutputListResponseBodyDatapointsDatapoint()
                self.datapoint.append(temp_model.from_map(k))
        return self


class DescribeExporterOutputListResponseBody(TeaModel):
    def __init__(self, code=None, datapoints=None, message=None, page_number=None, request_id=None, success=None,
                 total=None):
        self.code = code  # type: str
        self.datapoints = datapoints  # type: DescribeExporterOutputListResponseBodyDatapoints
        self.message = message  # type: str
        self.page_number = page_number  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: int

    def validate(self):
        if self.datapoints:
            self.datapoints.validate()

    def to_map(self):
        _map = super(DescribeExporterOutputListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            temp_model = DescribeExporterOutputListResponseBodyDatapoints()
            self.datapoints = temp_model.from_map(m['Datapoints'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeExporterOutputListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeExporterOutputListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeExporterOutputListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExporterOutputListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExporterRuleListRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, region_id=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExporterRuleListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeExporterRuleListResponseBodyDatapointsDatapointDstName(TeaModel):
    def __init__(self, dst_name=None):
        self.dst_name = dst_name  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExporterRuleListResponseBodyDatapointsDatapointDstName, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_name is not None:
            result['DstName'] = self.dst_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DstName') is not None:
            self.dst_name = m.get('DstName')
        return self


class DescribeExporterRuleListResponseBodyDatapointsDatapoint(TeaModel):
    def __init__(self, create_time=None, describe=None, dimension=None, dst_name=None, enabled=None,
                 metric_name=None, namespace=None, rule_name=None, target_windows=None):
        self.create_time = create_time  # type: long
        self.describe = describe  # type: str
        self.dimension = dimension  # type: str
        self.dst_name = dst_name  # type: DescribeExporterRuleListResponseBodyDatapointsDatapointDstName
        self.enabled = enabled  # type: bool
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.rule_name = rule_name  # type: str
        self.target_windows = target_windows  # type: str

    def validate(self):
        if self.dst_name:
            self.dst_name.validate()

    def to_map(self):
        _map = super(DescribeExporterRuleListResponseBodyDatapointsDatapoint, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.describe is not None:
            result['Describe'] = self.describe
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.dst_name is not None:
            result['DstName'] = self.dst_name.to_map()
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.target_windows is not None:
            result['TargetWindows'] = self.target_windows
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Describe') is not None:
            self.describe = m.get('Describe')
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('DstName') is not None:
            temp_model = DescribeExporterRuleListResponseBodyDatapointsDatapointDstName()
            self.dst_name = temp_model.from_map(m['DstName'])
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('TargetWindows') is not None:
            self.target_windows = m.get('TargetWindows')
        return self


class DescribeExporterRuleListResponseBodyDatapoints(TeaModel):
    def __init__(self, datapoint=None):
        self.datapoint = datapoint  # type: list[DescribeExporterRuleListResponseBodyDatapointsDatapoint]

    def validate(self):
        if self.datapoint:
            for k in self.datapoint:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeExporterRuleListResponseBodyDatapoints, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Datapoint'] = []
        if self.datapoint is not None:
            for k in self.datapoint:
                result['Datapoint'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.datapoint = []
        if m.get('Datapoint') is not None:
            for k in m.get('Datapoint'):
                temp_model = DescribeExporterRuleListResponseBodyDatapointsDatapoint()
                self.datapoint.append(temp_model.from_map(k))
        return self


class DescribeExporterRuleListResponseBody(TeaModel):
    def __init__(self, code=None, datapoints=None, message=None, page_number=None, request_id=None, success=None,
                 total=None):
        self.code = code  # type: str
        self.datapoints = datapoints  # type: DescribeExporterRuleListResponseBodyDatapoints
        self.message = message  # type: str
        self.page_number = page_number  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: int

    def validate(self):
        if self.datapoints:
            self.datapoints.validate()

    def to_map(self):
        _map = super(DescribeExporterRuleListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            temp_model = DescribeExporterRuleListResponseBodyDatapoints()
            self.datapoints = temp_model.from_map(m['Datapoints'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeExporterRuleListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeExporterRuleListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeExporterRuleListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExporterRuleListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupMonitoringAgentProcessRequest(TeaModel):
    def __init__(self, group_id=None, page_number=None, page_size=None, process_name=None, region_id=None):
        self.group_id = group_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.process_name = process_name  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupMonitoringAgentProcessRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfigAlertConfig(TeaModel):
    def __init__(self, comparison_operator=None, effective_interval=None, escalations_level=None,
                 no_effective_interval=None, silence_time=None, statistics=None, threshold=None, times=None, webhook=None):
        self.comparison_operator = comparison_operator  # type: str
        self.effective_interval = effective_interval  # type: str
        self.escalations_level = escalations_level  # type: str
        self.no_effective_interval = no_effective_interval  # type: str
        self.silence_time = silence_time  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str
        self.times = times  # type: str
        self.webhook = webhook  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfigAlertConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.effective_interval is not None:
            result['EffectiveInterval'] = self.effective_interval
        if self.escalations_level is not None:
            result['EscalationsLevel'] = self.escalations_level
        if self.no_effective_interval is not None:
            result['NoEffectiveInterval'] = self.no_effective_interval
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('EffectiveInterval') is not None:
            self.effective_interval = m.get('EffectiveInterval')
        if m.get('EscalationsLevel') is not None:
            self.escalations_level = m.get('EscalationsLevel')
        if m.get('NoEffectiveInterval') is not None:
            self.no_effective_interval = m.get('NoEffectiveInterval')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfig(TeaModel):
    def __init__(self, alert_config=None):
        self.alert_config = alert_config  # type: list[DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfigAlertConfig]

    def validate(self):
        if self.alert_config:
            for k in self.alert_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertConfig'] = []
        if self.alert_config is not None:
            for k in self.alert_config:
                result['AlertConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alert_config = []
        if m.get('AlertConfig') is not None:
            for k in m.get('AlertConfig'):
                temp_model = DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfigAlertConfig()
                self.alert_config.append(temp_model.from_map(k))
        return self


class DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessMatchExpressMatchExpress(TeaModel):
    def __init__(self, function=None, name=None, value=None):
        self.function = function  # type: str
        self.name = name  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessMatchExpressMatchExpress, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function is not None:
            result['Function'] = self.function
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Function') is not None:
            self.function = m.get('Function')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessMatchExpress(TeaModel):
    def __init__(self, match_express=None):
        self.match_express = match_express  # type: list[DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessMatchExpressMatchExpress]

    def validate(self):
        if self.match_express:
            for k in self.match_express:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessMatchExpress, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MatchExpress'] = []
        if self.match_express is not None:
            for k in self.match_express:
                result['MatchExpress'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.match_express = []
        if m.get('MatchExpress') is not None:
            for k in m.get('MatchExpress'):
                temp_model = DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessMatchExpressMatchExpress()
                self.match_express.append(temp_model.from_map(k))
        return self


class DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcess(TeaModel):
    def __init__(self, alert_config=None, group_id=None, id=None, match_express=None,
                 match_express_filter_relation=None, process_name=None):
        self.alert_config = alert_config  # type: DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfig
        self.group_id = group_id  # type: str
        self.id = id  # type: str
        self.match_express = match_express  # type: DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessMatchExpress
        self.match_express_filter_relation = match_express_filter_relation  # type: str
        self.process_name = process_name  # type: str

    def validate(self):
        if self.alert_config:
            self.alert_config.validate()
        if self.match_express:
            self.match_express.validate()

    def to_map(self):
        _map = super(DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcess, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_config is not None:
            result['AlertConfig'] = self.alert_config.to_map()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.id is not None:
            result['Id'] = self.id
        if self.match_express is not None:
            result['MatchExpress'] = self.match_express.to_map()
        if self.match_express_filter_relation is not None:
            result['MatchExpressFilterRelation'] = self.match_express_filter_relation
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertConfig') is not None:
            temp_model = DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessAlertConfig()
            self.alert_config = temp_model.from_map(m['AlertConfig'])
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MatchExpress') is not None:
            temp_model = DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcessMatchExpress()
            self.match_express = temp_model.from_map(m['MatchExpress'])
        if m.get('MatchExpressFilterRelation') is not None:
            self.match_express_filter_relation = m.get('MatchExpressFilterRelation')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        return self


class DescribeGroupMonitoringAgentProcessResponseBodyProcesses(TeaModel):
    def __init__(self, process=None):
        self.process = process  # type: list[DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcess]

    def validate(self):
        if self.process:
            for k in self.process:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeGroupMonitoringAgentProcessResponseBodyProcesses, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Process'] = []
        if self.process is not None:
            for k in self.process:
                result['Process'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.process = []
        if m.get('Process') is not None:
            for k in m.get('Process'):
                temp_model = DescribeGroupMonitoringAgentProcessResponseBodyProcessesProcess()
                self.process.append(temp_model.from_map(k))
        return self


class DescribeGroupMonitoringAgentProcessResponseBody(TeaModel):
    def __init__(self, code=None, message=None, page_number=None, page_size=None, processes=None, request_id=None,
                 success=None, total=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.processes = processes  # type: DescribeGroupMonitoringAgentProcessResponseBodyProcesses
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: str

    def validate(self):
        if self.processes:
            self.processes.validate()

    def to_map(self):
        _map = super(DescribeGroupMonitoringAgentProcessResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.processes is not None:
            result['Processes'] = self.processes.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Processes') is not None:
            temp_model = DescribeGroupMonitoringAgentProcessResponseBodyProcesses()
            self.processes = temp_model.from_map(m['Processes'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeGroupMonitoringAgentProcessResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeGroupMonitoringAgentProcessResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeGroupMonitoringAgentProcessResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGroupMonitoringAgentProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHostAvailabilityListRequest(TeaModel):
    def __init__(self, group_id=None, id=None, ids=None, page_number=None, page_size=None, region_id=None,
                 task_name=None):
        self.group_id = group_id  # type: long
        self.id = id  # type: long
        self.ids = ids  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.task_name = task_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHostAvailabilityListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.id is not None:
            result['Id'] = self.id
        if self.ids is not None:
            result['Ids'] = self.ids
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigEscalationListEscalationList(TeaModel):
    def __init__(self, aggregate=None, metric_name=None, operator=None, times=None, value=None):
        self.aggregate = aggregate  # type: str
        self.metric_name = metric_name  # type: str
        self.operator = operator  # type: str
        self.times = times  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigEscalationListEscalationList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aggregate is not None:
            result['Aggregate'] = self.aggregate
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.times is not None:
            result['Times'] = self.times
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Aggregate') is not None:
            self.aggregate = m.get('Aggregate')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigEscalationList(TeaModel):
    def __init__(self, escalation_list=None):
        self.escalation_list = escalation_list  # type: list[DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigEscalationListEscalationList]

    def validate(self):
        if self.escalation_list:
            for k in self.escalation_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigEscalationList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['escalationList'] = []
        if self.escalation_list is not None:
            for k in self.escalation_list:
                result['escalationList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.escalation_list = []
        if m.get('escalationList') is not None:
            for k in m.get('escalationList'):
                temp_model = DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigEscalationListEscalationList()
                self.escalation_list.append(temp_model.from_map(k))
        return self


class DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfig(TeaModel):
    def __init__(self, end_time=None, escalation_list=None, notify_type=None, silence_time=None, start_time=None,
                 web_hook=None):
        self.end_time = end_time  # type: int
        self.escalation_list = escalation_list  # type: DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigEscalationList
        self.notify_type = notify_type  # type: int
        self.silence_time = silence_time  # type: int
        self.start_time = start_time  # type: int
        self.web_hook = web_hook  # type: str

    def validate(self):
        if self.escalation_list:
            self.escalation_list.validate()

    def to_map(self):
        _map = super(DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.escalation_list is not None:
            result['EscalationList'] = self.escalation_list.to_map()
        if self.notify_type is not None:
            result['NotifyType'] = self.notify_type
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.web_hook is not None:
            result['WebHook'] = self.web_hook
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EscalationList') is not None:
            temp_model = DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfigEscalationList()
            self.escalation_list = temp_model.from_map(m['EscalationList'])
        if m.get('NotifyType') is not None:
            self.notify_type = m.get('NotifyType')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('WebHook') is not None:
            self.web_hook = m.get('WebHook')
        return self


class DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigInstances(TeaModel):
    def __init__(self, instance=None):
        self.instance = instance  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance is not None:
            result['Instance'] = self.instance
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Instance') is not None:
            self.instance = m.get('Instance')
        return self


class DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigTaskOption(TeaModel):
    def __init__(self, http_keyword=None, http_method=None, http_negative=None, http_post_content=None,
                 http_response_charset=None, http_uri=None, interval=None, telnet_or_ping_host=None):
        self.http_keyword = http_keyword  # type: str
        self.http_method = http_method  # type: str
        self.http_negative = http_negative  # type: bool
        self.http_post_content = http_post_content  # type: str
        self.http_response_charset = http_response_charset  # type: str
        self.http_uri = http_uri  # type: str
        self.interval = interval  # type: int
        self.telnet_or_ping_host = telnet_or_ping_host  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigTaskOption, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_keyword is not None:
            result['HttpKeyword'] = self.http_keyword
        if self.http_method is not None:
            result['HttpMethod'] = self.http_method
        if self.http_negative is not None:
            result['HttpNegative'] = self.http_negative
        if self.http_post_content is not None:
            result['HttpPostContent'] = self.http_post_content
        if self.http_response_charset is not None:
            result['HttpResponseCharset'] = self.http_response_charset
        if self.http_uri is not None:
            result['HttpURI'] = self.http_uri
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.telnet_or_ping_host is not None:
            result['TelnetOrPingHost'] = self.telnet_or_ping_host
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpKeyword') is not None:
            self.http_keyword = m.get('HttpKeyword')
        if m.get('HttpMethod') is not None:
            self.http_method = m.get('HttpMethod')
        if m.get('HttpNegative') is not None:
            self.http_negative = m.get('HttpNegative')
        if m.get('HttpPostContent') is not None:
            self.http_post_content = m.get('HttpPostContent')
        if m.get('HttpResponseCharset') is not None:
            self.http_response_charset = m.get('HttpResponseCharset')
        if m.get('HttpURI') is not None:
            self.http_uri = m.get('HttpURI')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('TelnetOrPingHost') is not None:
            self.telnet_or_ping_host = m.get('TelnetOrPingHost')
        return self


class DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfig(TeaModel):
    def __init__(self, alert_config=None, disabled=None, group_id=None, group_name=None, id=None, instances=None,
                 task_name=None, task_option=None, task_scope=None, task_type=None):
        self.alert_config = alert_config  # type: DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfig
        self.disabled = disabled  # type: bool
        self.group_id = group_id  # type: long
        self.group_name = group_name  # type: str
        self.id = id  # type: long
        self.instances = instances  # type: DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigInstances
        self.task_name = task_name  # type: str
        self.task_option = task_option  # type: DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigTaskOption
        self.task_scope = task_scope  # type: str
        self.task_type = task_type  # type: str

    def validate(self):
        if self.alert_config:
            self.alert_config.validate()
        if self.instances:
            self.instances.validate()
        if self.task_option:
            self.task_option.validate()

    def to_map(self):
        _map = super(DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_config is not None:
            result['AlertConfig'] = self.alert_config.to_map()
        if self.disabled is not None:
            result['Disabled'] = self.disabled
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.id is not None:
            result['Id'] = self.id
        if self.instances is not None:
            result['Instances'] = self.instances.to_map()
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_option is not None:
            result['TaskOption'] = self.task_option.to_map()
        if self.task_scope is not None:
            result['TaskScope'] = self.task_scope
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertConfig') is not None:
            temp_model = DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigAlertConfig()
            self.alert_config = temp_model.from_map(m['AlertConfig'])
        if m.get('Disabled') is not None:
            self.disabled = m.get('Disabled')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Instances') is not None:
            temp_model = DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigInstances()
            self.instances = temp_model.from_map(m['Instances'])
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskOption') is not None:
            temp_model = DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfigTaskOption()
            self.task_option = temp_model.from_map(m['TaskOption'])
        if m.get('TaskScope') is not None:
            self.task_scope = m.get('TaskScope')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeHostAvailabilityListResponseBodyTaskList(TeaModel):
    def __init__(self, node_task_config=None):
        self.node_task_config = node_task_config  # type: list[DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfig]

    def validate(self):
        if self.node_task_config:
            for k in self.node_task_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeHostAvailabilityListResponseBodyTaskList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NodeTaskConfig'] = []
        if self.node_task_config is not None:
            for k in self.node_task_config:
                result['NodeTaskConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.node_task_config = []
        if m.get('NodeTaskConfig') is not None:
            for k in m.get('NodeTaskConfig'):
                temp_model = DescribeHostAvailabilityListResponseBodyTaskListNodeTaskConfig()
                self.node_task_config.append(temp_model.from_map(k))
        return self


class DescribeHostAvailabilityListResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None, task_list=None, total=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_list = task_list  # type: DescribeHostAvailabilityListResponseBodyTaskList
        self.total = total  # type: int

    def validate(self):
        if self.task_list:
            self.task_list.validate()

    def to_map(self):
        _map = super(DescribeHostAvailabilityListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_list is not None:
            result['TaskList'] = self.task_list.to_map()
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskList') is not None:
            temp_model = DescribeHostAvailabilityListResponseBodyTaskList()
            self.task_list = temp_model.from_map(m['TaskList'])
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeHostAvailabilityListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeHostAvailabilityListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeHostAvailabilityListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHostAvailabilityListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHybridMonitorDataListRequest(TeaModel):
    def __init__(self, end=None, namespace=None, period=None, prom_sql=None, region_id=None, start=None):
        self.end = end  # type: long
        self.namespace = namespace  # type: str
        self.period = period  # type: str
        self.prom_sql = prom_sql  # type: str
        self.region_id = region_id  # type: str
        self.start = start  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHybridMonitorDataListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['End'] = self.end
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.period is not None:
            result['Period'] = self.period
        if self.prom_sql is not None:
            result['PromSQL'] = self.prom_sql
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PromSQL') is not None:
            self.prom_sql = m.get('PromSQL')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class DescribeHybridMonitorDataListResponseBodyTimeSeriesLabels(TeaModel):
    def __init__(self, k=None, v=None):
        self.k = k  # type: str
        self.v = v  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHybridMonitorDataListResponseBodyTimeSeriesLabels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.k is not None:
            result['K'] = self.k
        if self.v is not None:
            result['V'] = self.v
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('K') is not None:
            self.k = m.get('K')
        if m.get('V') is not None:
            self.v = m.get('V')
        return self


class DescribeHybridMonitorDataListResponseBodyTimeSeriesValues(TeaModel):
    def __init__(self, ts=None, v=None):
        self.ts = ts  # type: str
        self.v = v  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHybridMonitorDataListResponseBodyTimeSeriesValues, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ts is not None:
            result['Ts'] = self.ts
        if self.v is not None:
            result['V'] = self.v
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ts') is not None:
            self.ts = m.get('Ts')
        if m.get('V') is not None:
            self.v = m.get('V')
        return self


class DescribeHybridMonitorDataListResponseBodyTimeSeries(TeaModel):
    def __init__(self, labels=None, metric_name=None, values=None):
        self.labels = labels  # type: list[DescribeHybridMonitorDataListResponseBodyTimeSeriesLabels]
        self.metric_name = metric_name  # type: str
        self.values = values  # type: list[DescribeHybridMonitorDataListResponseBodyTimeSeriesValues]

    def validate(self):
        if self.labels:
            for k in self.labels:
                if k:
                    k.validate()
        if self.values:
            for k in self.values:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeHybridMonitorDataListResponseBodyTimeSeries, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Labels'] = []
        if self.labels is not None:
            for k in self.labels:
                result['Labels'].append(k.to_map() if k else None)
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        result['Values'] = []
        if self.values is not None:
            for k in self.values:
                result['Values'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.labels = []
        if m.get('Labels') is not None:
            for k in m.get('Labels'):
                temp_model = DescribeHybridMonitorDataListResponseBodyTimeSeriesLabels()
                self.labels.append(temp_model.from_map(k))
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        self.values = []
        if m.get('Values') is not None:
            for k in m.get('Values'):
                temp_model = DescribeHybridMonitorDataListResponseBodyTimeSeriesValues()
                self.values.append(temp_model.from_map(k))
        return self


class DescribeHybridMonitorDataListResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None, time_series=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str
        self.time_series = time_series  # type: list[DescribeHybridMonitorDataListResponseBodyTimeSeries]

    def validate(self):
        if self.time_series:
            for k in self.time_series:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeHybridMonitorDataListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        result['TimeSeries'] = []
        if self.time_series is not None:
            for k in self.time_series:
                result['TimeSeries'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.time_series = []
        if m.get('TimeSeries') is not None:
            for k in m.get('TimeSeries'):
                temp_model = DescribeHybridMonitorDataListResponseBodyTimeSeries()
                self.time_series.append(temp_model.from_map(k))
        return self


class DescribeHybridMonitorDataListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeHybridMonitorDataListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeHybridMonitorDataListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHybridMonitorDataListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHybridMonitorNamespaceListRequest(TeaModel):
    def __init__(self, keyword=None, namespace=None, page_number=None, page_size=None, region_id=None,
                 show_task_statistic=None):
        self.keyword = keyword  # type: str
        self.namespace = namespace  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.show_task_statistic = show_task_statistic  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHybridMonitorNamespaceListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.show_task_statistic is not None:
            result['ShowTaskStatistic'] = self.show_task_statistic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ShowTaskStatistic') is not None:
            self.show_task_statistic = m.get('ShowTaskStatistic')
        return self


class DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricListNamespaceListMetricList(TeaModel):
    def __init__(self, list=None, period=None):
        self.list = list  # type: list[str]
        self.period = period  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricListNamespaceListMetricList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list is not None:
            result['List'] = self.list
        if self.period is not None:
            result['Period'] = self.period
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('List') is not None:
            self.list = m.get('List')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        return self


class DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricListNamespaceList(TeaModel):
    def __init__(self, metric_list=None, namespace=None):
        self.metric_list = metric_list  # type: list[DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricListNamespaceListMetricList]
        self.namespace = namespace  # type: str

    def validate(self):
        if self.metric_list:
            for k in self.metric_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricListNamespaceList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MetricList'] = []
        if self.metric_list is not None:
            for k in self.metric_list:
                result['MetricList'].append(k.to_map() if k else None)
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.metric_list = []
        if m.get('MetricList') is not None:
            for k in m.get('MetricList'):
                temp_model = DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricListNamespaceListMetricList()
                self.metric_list.append(temp_model.from_map(k))
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricList(TeaModel):
    def __init__(self, namespace_list=None, user_id=None, yamlconfig=None):
        self.namespace_list = namespace_list  # type: list[DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricListNamespaceList]
        self.user_id = user_id  # type: long
        self.yamlconfig = yamlconfig  # type: str

    def validate(self):
        if self.namespace_list:
            for k in self.namespace_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NamespaceList'] = []
        if self.namespace_list is not None:
            for k in self.namespace_list:
                result['NamespaceList'].append(k.to_map() if k else None)
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.yamlconfig is not None:
            result['YAMLConfig'] = self.yamlconfig
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.namespace_list = []
        if m.get('NamespaceList') is not None:
            for k in m.get('NamespaceList'):
                temp_model = DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricListNamespaceList()
                self.namespace_list.append(temp_model.from_map(k))
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('YAMLConfig') is not None:
            self.yamlconfig = m.get('YAMLConfig')
        return self


class DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceDetail(TeaModel):
    def __init__(self, spec=None):
        self.spec = spec  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.spec is not None:
            result['Spec'] = self.spec
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        return self


class DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespace(TeaModel):
    def __init__(self, aliyun_product_metric_list=None, create_time=None, description=None, detail=None, id=None,
                 is_delete=None, modify_time=None, namespace=None, not_aliyun_task_number=None):
        self.aliyun_product_metric_list = aliyun_product_metric_list  # type: list[DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricList]
        self.create_time = create_time  # type: str
        self.description = description  # type: str
        self.detail = detail  # type: DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceDetail
        self.id = id  # type: str
        self.is_delete = is_delete  # type: int
        self.modify_time = modify_time  # type: str
        self.namespace = namespace  # type: str
        self.not_aliyun_task_number = not_aliyun_task_number  # type: long

    def validate(self):
        if self.aliyun_product_metric_list:
            for k in self.aliyun_product_metric_list:
                if k:
                    k.validate()
        if self.detail:
            self.detail.validate()

    def to_map(self):
        _map = super(DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespace, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AliyunProductMetricList'] = []
        if self.aliyun_product_metric_list is not None:
            for k in self.aliyun_product_metric_list:
                result['AliyunProductMetricList'].append(k.to_map() if k else None)
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.detail is not None:
            result['Detail'] = self.detail.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.is_delete is not None:
            result['IsDelete'] = self.is_delete
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.not_aliyun_task_number is not None:
            result['NotAliyunTaskNumber'] = self.not_aliyun_task_number
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.aliyun_product_metric_list = []
        if m.get('AliyunProductMetricList') is not None:
            for k in m.get('AliyunProductMetricList'):
                temp_model = DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceAliyunProductMetricList()
                self.aliyun_product_metric_list.append(temp_model.from_map(k))
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Detail') is not None:
            temp_model = DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespaceDetail()
            self.detail = temp_model.from_map(m['Detail'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IsDelete') is not None:
            self.is_delete = m.get('IsDelete')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NotAliyunTaskNumber') is not None:
            self.not_aliyun_task_number = m.get('NotAliyunTaskNumber')
        return self


class DescribeHybridMonitorNamespaceListResponseBody(TeaModel):
    def __init__(self, code=None, describe_hybrid_monitor_namespace=None, message=None, page_number=None,
                 page_size=None, request_id=None, success=None, total=None):
        self.code = code  # type: str
        self.describe_hybrid_monitor_namespace = describe_hybrid_monitor_namespace  # type: list[DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespace]
        self.message = message  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: str
        self.total = total  # type: int

    def validate(self):
        if self.describe_hybrid_monitor_namespace:
            for k in self.describe_hybrid_monitor_namespace:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeHybridMonitorNamespaceListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['DescribeHybridMonitorNamespace'] = []
        if self.describe_hybrid_monitor_namespace is not None:
            for k in self.describe_hybrid_monitor_namespace:
                result['DescribeHybridMonitorNamespace'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.describe_hybrid_monitor_namespace = []
        if m.get('DescribeHybridMonitorNamespace') is not None:
            for k in m.get('DescribeHybridMonitorNamespace'):
                temp_model = DescribeHybridMonitorNamespaceListResponseBodyDescribeHybridMonitorNamespace()
                self.describe_hybrid_monitor_namespace.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeHybridMonitorNamespaceListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeHybridMonitorNamespaceListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeHybridMonitorNamespaceListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHybridMonitorNamespaceListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHybridMonitorSLSGroupRequest(TeaModel):
    def __init__(self, keyword=None, page_number=None, page_size=None, region_id=None, slsgroup_name=None):
        self.keyword = keyword  # type: str
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.region_id = region_id  # type: str
        self.slsgroup_name = slsgroup_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHybridMonitorSLSGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.slsgroup_name is not None:
            result['SLSGroupName'] = self.slsgroup_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SLSGroupName') is not None:
            self.slsgroup_name = m.get('SLSGroupName')
        return self


class DescribeHybridMonitorSLSGroupResponseBodyListSLSGroupConfig(TeaModel):
    def __init__(self, slslogstore=None, slsproject=None, slsregion=None, slsuser_id=None):
        self.slslogstore = slslogstore  # type: str
        self.slsproject = slsproject  # type: str
        self.slsregion = slsregion  # type: str
        self.slsuser_id = slsuser_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHybridMonitorSLSGroupResponseBodyListSLSGroupConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.slslogstore is not None:
            result['SLSLogstore'] = self.slslogstore
        if self.slsproject is not None:
            result['SLSProject'] = self.slsproject
        if self.slsregion is not None:
            result['SLSRegion'] = self.slsregion
        if self.slsuser_id is not None:
            result['SLSUserId'] = self.slsuser_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SLSLogstore') is not None:
            self.slslogstore = m.get('SLSLogstore')
        if m.get('SLSProject') is not None:
            self.slsproject = m.get('SLSProject')
        if m.get('SLSRegion') is not None:
            self.slsregion = m.get('SLSRegion')
        if m.get('SLSUserId') is not None:
            self.slsuser_id = m.get('SLSUserId')
        return self


class DescribeHybridMonitorSLSGroupResponseBodyList(TeaModel):
    def __init__(self, create_time=None, slsgroup_config=None, slsgroup_description=None, slsgroup_name=None,
                 update_time=None):
        self.create_time = create_time  # type: str
        self.slsgroup_config = slsgroup_config  # type: list[DescribeHybridMonitorSLSGroupResponseBodyListSLSGroupConfig]
        self.slsgroup_description = slsgroup_description  # type: str
        self.slsgroup_name = slsgroup_name  # type: long
        self.update_time = update_time  # type: str

    def validate(self):
        if self.slsgroup_config:
            for k in self.slsgroup_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeHybridMonitorSLSGroupResponseBodyList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        result['SLSGroupConfig'] = []
        if self.slsgroup_config is not None:
            for k in self.slsgroup_config:
                result['SLSGroupConfig'].append(k.to_map() if k else None)
        if self.slsgroup_description is not None:
            result['SLSGroupDescription'] = self.slsgroup_description
        if self.slsgroup_name is not None:
            result['SLSGroupName'] = self.slsgroup_name
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        self.slsgroup_config = []
        if m.get('SLSGroupConfig') is not None:
            for k in m.get('SLSGroupConfig'):
                temp_model = DescribeHybridMonitorSLSGroupResponseBodyListSLSGroupConfig()
                self.slsgroup_config.append(temp_model.from_map(k))
        if m.get('SLSGroupDescription') is not None:
            self.slsgroup_description = m.get('SLSGroupDescription')
        if m.get('SLSGroupName') is not None:
            self.slsgroup_name = m.get('SLSGroupName')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeHybridMonitorSLSGroupResponseBody(TeaModel):
    def __init__(self, code=None, list=None, message=None, page_number=None, page_size=None, request_id=None,
                 success=None, total=None):
        self.code = code  # type: str
        self.list = list  # type: list[DescribeHybridMonitorSLSGroupResponseBodyList]
        self.message = message  # type: str
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.request_id = request_id  # type: str
        self.success = success  # type: str
        self.total = total  # type: long

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeHybridMonitorSLSGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = DescribeHybridMonitorSLSGroupResponseBodyList()
                self.list.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeHybridMonitorSLSGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeHybridMonitorSLSGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeHybridMonitorSLSGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHybridMonitorSLSGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHybridMonitorTaskListRequest(TeaModel):
    def __init__(self, group_id=None, include_aliyun_task=None, keyword=None, namespace=None, page_number=None,
                 page_size=None, region_id=None, task_id=None, task_type=None):
        self.group_id = group_id  # type: str
        self.include_aliyun_task = include_aliyun_task  # type: bool
        self.keyword = keyword  # type: str
        self.namespace = namespace  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.task_id = task_id  # type: str
        self.task_type = task_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHybridMonitorTaskListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.include_aliyun_task is not None:
            result['IncludeAliyunTask'] = self.include_aliyun_task
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('IncludeAliyunTask') is not None:
            self.include_aliyun_task = m.get('IncludeAliyunTask')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeHybridMonitorTaskListResponseBodyTaskListAttachLabels(TeaModel):
    def __init__(self, name=None, value=None):
        self.name = name  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHybridMonitorTaskListResponseBodyTaskListAttachLabels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHybridMonitorTaskListResponseBodyTaskListMatchExpress(TeaModel):
    def __init__(self, function=None, name=None, value=None):
        self.function = function  # type: str
        self.name = name  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHybridMonitorTaskListResponseBodyTaskListMatchExpress, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function is not None:
            result['Function'] = self.function
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Function') is not None:
            self.function = m.get('Function')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeHybridMonitorTaskListResponseBodyTaskList(TeaModel):
    def __init__(self, attach_labels=None, collect_interval=None, collect_target_endpoint=None,
                 collect_target_path=None, collect_target_type=None, collect_timout=None, create_time=None, description=None,
                 extra_info=None, group_id=None, instances=None, log_file_path=None, log_process=None, log_sample=None,
                 log_split=None, match_express=None, match_express_relation=None, namespace=None, network_type=None,
                 slsprocess=None, target_user_id=None, task_id=None, task_name=None, task_type=None, upload_region=None,
                 yarmconfig=None):
        self.attach_labels = attach_labels  # type: list[DescribeHybridMonitorTaskListResponseBodyTaskListAttachLabels]
        self.collect_interval = collect_interval  # type: int
        self.collect_target_endpoint = collect_target_endpoint  # type: str
        self.collect_target_path = collect_target_path  # type: str
        self.collect_target_type = collect_target_type  # type: str
        self.collect_timout = collect_timout  # type: int
        self.create_time = create_time  # type: str
        self.description = description  # type: str
        self.extra_info = extra_info  # type: str
        self.group_id = group_id  # type: str
        self.instances = instances  # type: list[str]
        self.log_file_path = log_file_path  # type: str
        self.log_process = log_process  # type: str
        self.log_sample = log_sample  # type: str
        self.log_split = log_split  # type: str
        self.match_express = match_express  # type: list[DescribeHybridMonitorTaskListResponseBodyTaskListMatchExpress]
        self.match_express_relation = match_express_relation  # type: str
        self.namespace = namespace  # type: str
        self.network_type = network_type  # type: str
        self.slsprocess = slsprocess  # type: str
        self.target_user_id = target_user_id  # type: str
        self.task_id = task_id  # type: str
        self.task_name = task_name  # type: str
        self.task_type = task_type  # type: str
        self.upload_region = upload_region  # type: str
        self.yarmconfig = yarmconfig  # type: str

    def validate(self):
        if self.attach_labels:
            for k in self.attach_labels:
                if k:
                    k.validate()
        if self.match_express:
            for k in self.match_express:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeHybridMonitorTaskListResponseBodyTaskList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AttachLabels'] = []
        if self.attach_labels is not None:
            for k in self.attach_labels:
                result['AttachLabels'].append(k.to_map() if k else None)
        if self.collect_interval is not None:
            result['CollectInterval'] = self.collect_interval
        if self.collect_target_endpoint is not None:
            result['CollectTargetEndpoint'] = self.collect_target_endpoint
        if self.collect_target_path is not None:
            result['CollectTargetPath'] = self.collect_target_path
        if self.collect_target_type is not None:
            result['CollectTargetType'] = self.collect_target_type
        if self.collect_timout is not None:
            result['CollectTimout'] = self.collect_timout
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.extra_info is not None:
            result['ExtraInfo'] = self.extra_info
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instances is not None:
            result['Instances'] = self.instances
        if self.log_file_path is not None:
            result['LogFilePath'] = self.log_file_path
        if self.log_process is not None:
            result['LogProcess'] = self.log_process
        if self.log_sample is not None:
            result['LogSample'] = self.log_sample
        if self.log_split is not None:
            result['LogSplit'] = self.log_split
        result['MatchExpress'] = []
        if self.match_express is not None:
            for k in self.match_express:
                result['MatchExpress'].append(k.to_map() if k else None)
        if self.match_express_relation is not None:
            result['MatchExpressRelation'] = self.match_express_relation
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.slsprocess is not None:
            result['SLSProcess'] = self.slsprocess
        if self.target_user_id is not None:
            result['TargetUserId'] = self.target_user_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.upload_region is not None:
            result['UploadRegion'] = self.upload_region
        if self.yarmconfig is not None:
            result['YARMConfig'] = self.yarmconfig
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.attach_labels = []
        if m.get('AttachLabels') is not None:
            for k in m.get('AttachLabels'):
                temp_model = DescribeHybridMonitorTaskListResponseBodyTaskListAttachLabels()
                self.attach_labels.append(temp_model.from_map(k))
        if m.get('CollectInterval') is not None:
            self.collect_interval = m.get('CollectInterval')
        if m.get('CollectTargetEndpoint') is not None:
            self.collect_target_endpoint = m.get('CollectTargetEndpoint')
        if m.get('CollectTargetPath') is not None:
            self.collect_target_path = m.get('CollectTargetPath')
        if m.get('CollectTargetType') is not None:
            self.collect_target_type = m.get('CollectTargetType')
        if m.get('CollectTimout') is not None:
            self.collect_timout = m.get('CollectTimout')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExtraInfo') is not None:
            self.extra_info = m.get('ExtraInfo')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Instances') is not None:
            self.instances = m.get('Instances')
        if m.get('LogFilePath') is not None:
            self.log_file_path = m.get('LogFilePath')
        if m.get('LogProcess') is not None:
            self.log_process = m.get('LogProcess')
        if m.get('LogSample') is not None:
            self.log_sample = m.get('LogSample')
        if m.get('LogSplit') is not None:
            self.log_split = m.get('LogSplit')
        self.match_express = []
        if m.get('MatchExpress') is not None:
            for k in m.get('MatchExpress'):
                temp_model = DescribeHybridMonitorTaskListResponseBodyTaskListMatchExpress()
                self.match_express.append(temp_model.from_map(k))
        if m.get('MatchExpressRelation') is not None:
            self.match_express_relation = m.get('MatchExpressRelation')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('SLSProcess') is not None:
            self.slsprocess = m.get('SLSProcess')
        if m.get('TargetUserId') is not None:
            self.target_user_id = m.get('TargetUserId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('UploadRegion') is not None:
            self.upload_region = m.get('UploadRegion')
        if m.get('YARMConfig') is not None:
            self.yarmconfig = m.get('YARMConfig')
        return self


class DescribeHybridMonitorTaskListResponseBody(TeaModel):
    def __init__(self, code=None, message=None, page_number=None, page_size=None, request_id=None, success=None,
                 task_list=None, total=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: str
        self.task_list = task_list  # type: list[DescribeHybridMonitorTaskListResponseBodyTaskList]
        self.total = total  # type: int

    def validate(self):
        if self.task_list:
            for k in self.task_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeHybridMonitorTaskListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        result['TaskList'] = []
        if self.task_list is not None:
            for k in self.task_list:
                result['TaskList'].append(k.to_map() if k else None)
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.task_list = []
        if m.get('TaskList') is not None:
            for k in m.get('TaskList'):
                temp_model = DescribeHybridMonitorTaskListResponseBodyTaskList()
                self.task_list.append(temp_model.from_map(k))
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeHybridMonitorTaskListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeHybridMonitorTaskListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeHybridMonitorTaskListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHybridMonitorTaskListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLogMonitorAttributeRequest(TeaModel):
    def __init__(self, metric_name=None, region_id=None):
        self.metric_name = metric_name  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLogMonitorAttributeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeLogMonitorAttributeResponseBodyLogMonitorAggregates(TeaModel):
    def __init__(self, alias=None, field_name=None, function=None, max=None, min=None):
        self.alias = alias  # type: str
        self.field_name = field_name  # type: str
        self.function = function  # type: str
        self.max = max  # type: str
        self.min = min  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLogMonitorAttributeResponseBodyLogMonitorAggregates, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.function is not None:
            result['Function'] = self.function
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('Function') is not None:
            self.function = m.get('Function')
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        return self


class DescribeLogMonitorAttributeResponseBodyLogMonitorValueFilter(TeaModel):
    def __init__(self, key=None, operator=None, value=None):
        self.key = key  # type: str
        self.operator = operator  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLogMonitorAttributeResponseBodyLogMonitorValueFilter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeLogMonitorAttributeResponseBodyLogMonitor(TeaModel):
    def __init__(self, aggregates=None, gmt_create=None, group_id=None, groupbys=None, log_id=None,
                 metric_express=None, metric_name=None, sls_logstore=None, sls_project=None, sls_region_id=None,
                 tumblingwindows=None, value_filter=None, value_filter_relation=None):
        self.aggregates = aggregates  # type: list[DescribeLogMonitorAttributeResponseBodyLogMonitorAggregates]
        self.gmt_create = gmt_create  # type: long
        self.group_id = group_id  # type: long
        self.groupbys = groupbys  # type: list[str]
        self.log_id = log_id  # type: long
        self.metric_express = metric_express  # type: str
        self.metric_name = metric_name  # type: str
        self.sls_logstore = sls_logstore  # type: str
        self.sls_project = sls_project  # type: str
        self.sls_region_id = sls_region_id  # type: str
        self.tumblingwindows = tumblingwindows  # type: list[str]
        self.value_filter = value_filter  # type: list[DescribeLogMonitorAttributeResponseBodyLogMonitorValueFilter]
        self.value_filter_relation = value_filter_relation  # type: str

    def validate(self):
        if self.aggregates:
            for k in self.aggregates:
                if k:
                    k.validate()
        if self.value_filter:
            for k in self.value_filter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLogMonitorAttributeResponseBodyLogMonitor, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Aggregates'] = []
        if self.aggregates is not None:
            for k in self.aggregates:
                result['Aggregates'].append(k.to_map() if k else None)
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.groupbys is not None:
            result['Groupbys'] = self.groupbys
        if self.log_id is not None:
            result['LogId'] = self.log_id
        if self.metric_express is not None:
            result['MetricExpress'] = self.metric_express
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.sls_logstore is not None:
            result['SlsLogstore'] = self.sls_logstore
        if self.sls_project is not None:
            result['SlsProject'] = self.sls_project
        if self.sls_region_id is not None:
            result['SlsRegionId'] = self.sls_region_id
        if self.tumblingwindows is not None:
            result['Tumblingwindows'] = self.tumblingwindows
        result['ValueFilter'] = []
        if self.value_filter is not None:
            for k in self.value_filter:
                result['ValueFilter'].append(k.to_map() if k else None)
        if self.value_filter_relation is not None:
            result['ValueFilterRelation'] = self.value_filter_relation
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.aggregates = []
        if m.get('Aggregates') is not None:
            for k in m.get('Aggregates'):
                temp_model = DescribeLogMonitorAttributeResponseBodyLogMonitorAggregates()
                self.aggregates.append(temp_model.from_map(k))
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Groupbys') is not None:
            self.groupbys = m.get('Groupbys')
        if m.get('LogId') is not None:
            self.log_id = m.get('LogId')
        if m.get('MetricExpress') is not None:
            self.metric_express = m.get('MetricExpress')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('SlsLogstore') is not None:
            self.sls_logstore = m.get('SlsLogstore')
        if m.get('SlsProject') is not None:
            self.sls_project = m.get('SlsProject')
        if m.get('SlsRegionId') is not None:
            self.sls_region_id = m.get('SlsRegionId')
        if m.get('Tumblingwindows') is not None:
            self.tumblingwindows = m.get('Tumblingwindows')
        self.value_filter = []
        if m.get('ValueFilter') is not None:
            for k in m.get('ValueFilter'):
                temp_model = DescribeLogMonitorAttributeResponseBodyLogMonitorValueFilter()
                self.value_filter.append(temp_model.from_map(k))
        if m.get('ValueFilterRelation') is not None:
            self.value_filter_relation = m.get('ValueFilterRelation')
        return self


class DescribeLogMonitorAttributeResponseBody(TeaModel):
    def __init__(self, code=None, log_monitor=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.log_monitor = log_monitor  # type: DescribeLogMonitorAttributeResponseBodyLogMonitor
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.log_monitor:
            self.log_monitor.validate()

    def to_map(self):
        _map = super(DescribeLogMonitorAttributeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.log_monitor is not None:
            result['LogMonitor'] = self.log_monitor.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('LogMonitor') is not None:
            temp_model = DescribeLogMonitorAttributeResponseBodyLogMonitor()
            self.log_monitor = temp_model.from_map(m['LogMonitor'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeLogMonitorAttributeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLogMonitorAttributeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLogMonitorAttributeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLogMonitorAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLogMonitorListRequest(TeaModel):
    def __init__(self, group_id=None, page_number=None, page_size=None, region_id=None, search_value=None):
        self.group_id = group_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.search_value = search_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLogMonitorListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.search_value is not None:
            result['SearchValue'] = self.search_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SearchValue') is not None:
            self.search_value = m.get('SearchValue')
        return self


class DescribeLogMonitorListResponseBodyLogMonitorListValueFilter(TeaModel):
    def __init__(self, key=None, operator=None, value=None):
        self.key = key  # type: str
        self.operator = operator  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLogMonitorListResponseBodyLogMonitorListValueFilter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeLogMonitorListResponseBodyLogMonitorList(TeaModel):
    def __init__(self, gmt_create=None, group_id=None, log_id=None, metric_name=None, sls_logstore=None,
                 sls_project=None, sls_region_id=None, value_filter=None, value_filter_relation=None):
        self.gmt_create = gmt_create  # type: long
        self.group_id = group_id  # type: long
        self.log_id = log_id  # type: long
        self.metric_name = metric_name  # type: str
        self.sls_logstore = sls_logstore  # type: str
        self.sls_project = sls_project  # type: str
        self.sls_region_id = sls_region_id  # type: str
        self.value_filter = value_filter  # type: list[DescribeLogMonitorListResponseBodyLogMonitorListValueFilter]
        self.value_filter_relation = value_filter_relation  # type: str

    def validate(self):
        if self.value_filter:
            for k in self.value_filter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLogMonitorListResponseBodyLogMonitorList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.log_id is not None:
            result['LogId'] = self.log_id
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.sls_logstore is not None:
            result['SlsLogstore'] = self.sls_logstore
        if self.sls_project is not None:
            result['SlsProject'] = self.sls_project
        if self.sls_region_id is not None:
            result['SlsRegionId'] = self.sls_region_id
        result['ValueFilter'] = []
        if self.value_filter is not None:
            for k in self.value_filter:
                result['ValueFilter'].append(k.to_map() if k else None)
        if self.value_filter_relation is not None:
            result['ValueFilterRelation'] = self.value_filter_relation
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('LogId') is not None:
            self.log_id = m.get('LogId')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('SlsLogstore') is not None:
            self.sls_logstore = m.get('SlsLogstore')
        if m.get('SlsProject') is not None:
            self.sls_project = m.get('SlsProject')
        if m.get('SlsRegionId') is not None:
            self.sls_region_id = m.get('SlsRegionId')
        self.value_filter = []
        if m.get('ValueFilter') is not None:
            for k in m.get('ValueFilter'):
                temp_model = DescribeLogMonitorListResponseBodyLogMonitorListValueFilter()
                self.value_filter.append(temp_model.from_map(k))
        if m.get('ValueFilterRelation') is not None:
            self.value_filter_relation = m.get('ValueFilterRelation')
        return self


class DescribeLogMonitorListResponseBody(TeaModel):
    def __init__(self, code=None, log_monitor_list=None, message=None, page_number=None, page_size=None,
                 request_id=None, success=None, total=None):
        self.code = code  # type: str
        self.log_monitor_list = log_monitor_list  # type: list[DescribeLogMonitorListResponseBodyLogMonitorList]
        self.message = message  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: long

    def validate(self):
        if self.log_monitor_list:
            for k in self.log_monitor_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLogMonitorListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['LogMonitorList'] = []
        if self.log_monitor_list is not None:
            for k in self.log_monitor_list:
                result['LogMonitorList'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.log_monitor_list = []
        if m.get('LogMonitorList') is not None:
            for k in m.get('LogMonitorList'):
                temp_model = DescribeLogMonitorListResponseBodyLogMonitorList()
                self.log_monitor_list.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeLogMonitorListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLogMonitorListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLogMonitorListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLogMonitorListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricDataRequest(TeaModel):
    def __init__(self, dimensions=None, end_time=None, express=None, length=None, metric_name=None, namespace=None,
                 period=None, region_id=None, start_time=None):
        self.dimensions = dimensions  # type: str
        self.end_time = end_time  # type: str
        self.express = express  # type: str
        self.length = length  # type: str
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.period = period  # type: str
        self.region_id = region_id  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.express is not None:
            result['Express'] = self.express
        if self.length is not None:
            result['Length'] = self.length
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Express') is not None:
            self.express = m.get('Express')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeMetricDataResponseBody(TeaModel):
    def __init__(self, code=None, datapoints=None, message=None, period=None, request_id=None):
        self.code = code  # type: str
        self.datapoints = datapoints  # type: str
        self.message = message  # type: str
        self.period = period  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints
        if self.message is not None:
            result['Message'] = self.message
        if self.period is not None:
            result['Period'] = self.period
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            self.datapoints = m.get('Datapoints')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMetricDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMetricDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMetricDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricLastRequest(TeaModel):
    def __init__(self, dimensions=None, end_time=None, express=None, length=None, metric_name=None, namespace=None,
                 next_token=None, period=None, region_id=None, start_time=None):
        self.dimensions = dimensions  # type: str
        self.end_time = end_time  # type: str
        self.express = express  # type: str
        self.length = length  # type: str
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.next_token = next_token  # type: str
        self.period = period  # type: str
        self.region_id = region_id  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricLastRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.express is not None:
            result['Express'] = self.express
        if self.length is not None:
            result['Length'] = self.length
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Express') is not None:
            self.express = m.get('Express')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeMetricLastResponseBody(TeaModel):
    def __init__(self, code=None, datapoints=None, message=None, next_token=None, period=None, request_id=None,
                 success=None):
        self.code = code  # type: str
        self.datapoints = datapoints  # type: str
        self.message = message  # type: str
        self.next_token = next_token  # type: str
        self.period = period  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricLastResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.period is not None:
            result['Period'] = self.period
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            self.datapoints = m.get('Datapoints')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMetricLastResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMetricLastResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMetricLastResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricLastResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricListRequest(TeaModel):
    def __init__(self, dimensions=None, end_time=None, express=None, length=None, metric_name=None, namespace=None,
                 next_token=None, period=None, region_id=None, start_time=None):
        self.dimensions = dimensions  # type: str
        self.end_time = end_time  # type: str
        self.express = express  # type: str
        self.length = length  # type: str
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.next_token = next_token  # type: str
        self.period = period  # type: str
        self.region_id = region_id  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.express is not None:
            result['Express'] = self.express
        if self.length is not None:
            result['Length'] = self.length
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Express') is not None:
            self.express = m.get('Express')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeMetricListResponseBody(TeaModel):
    def __init__(self, code=None, datapoints=None, message=None, next_token=None, period=None, request_id=None,
                 success=None):
        self.code = code  # type: str
        self.datapoints = datapoints  # type: str
        self.message = message  # type: str
        self.next_token = next_token  # type: str
        self.period = period  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.period is not None:
            result['Period'] = self.period
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            self.datapoints = m.get('Datapoints')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMetricListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMetricListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMetricListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricMetaListRequest(TeaModel):
    def __init__(self, labels=None, metric_name=None, namespace=None, page_number=None, page_size=None,
                 region_id=None):
        self.labels = labels  # type: str
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricMetaListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMetricMetaListResponseBodyResourcesResource(TeaModel):
    def __init__(self, description=None, dimensions=None, labels=None, metric_name=None, namespace=None,
                 periods=None, statistics=None, unit=None):
        self.description = description  # type: str
        self.dimensions = dimensions  # type: str
        self.labels = labels  # type: str
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.periods = periods  # type: str
        self.statistics = statistics  # type: str
        self.unit = unit  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricMetaListResponseBodyResourcesResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.periods is not None:
            result['Periods'] = self.periods
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.unit is not None:
            result['Unit'] = self.unit
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Periods') is not None:
            self.periods = m.get('Periods')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        return self


class DescribeMetricMetaListResponseBodyResources(TeaModel):
    def __init__(self, resource=None):
        self.resource = resource  # type: list[DescribeMetricMetaListResponseBodyResourcesResource]

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMetricMetaListResponseBodyResources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeMetricMetaListResponseBodyResourcesResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeMetricMetaListResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, resources=None, success=None, total_count=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.resources = resources  # type: DescribeMetricMetaListResponseBodyResources
        self.success = success  # type: bool
        self.total_count = total_count  # type: str

    def validate(self):
        if self.resources:
            self.resources.validate()

    def to_map(self):
        _map = super(DescribeMetricMetaListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resources') is not None:
            temp_model = DescribeMetricMetaListResponseBodyResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeMetricMetaListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMetricMetaListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMetricMetaListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricMetaListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricRuleCountRequest(TeaModel):
    def __init__(self, metric_name=None, namespace=None, region_id=None):
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricRuleCountRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMetricRuleCountResponseBodyMetricRuleCount(TeaModel):
    def __init__(self, alarm=None, disable=None, nodata=None, ok=None, total=None):
        self.alarm = alarm  # type: int
        self.disable = disable  # type: int
        self.nodata = nodata  # type: int
        self.ok = ok  # type: int
        self.total = total  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricRuleCountResponseBodyMetricRuleCount, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm is not None:
            result['Alarm'] = self.alarm
        if self.disable is not None:
            result['Disable'] = self.disable
        if self.nodata is not None:
            result['Nodata'] = self.nodata
        if self.ok is not None:
            result['Ok'] = self.ok
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Alarm') is not None:
            self.alarm = m.get('Alarm')
        if m.get('Disable') is not None:
            self.disable = m.get('Disable')
        if m.get('Nodata') is not None:
            self.nodata = m.get('Nodata')
        if m.get('Ok') is not None:
            self.ok = m.get('Ok')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeMetricRuleCountResponseBody(TeaModel):
    def __init__(self, code=None, message=None, metric_rule_count=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.metric_rule_count = metric_rule_count  # type: DescribeMetricRuleCountResponseBodyMetricRuleCount
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.metric_rule_count:
            self.metric_rule_count.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleCountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.metric_rule_count is not None:
            result['MetricRuleCount'] = self.metric_rule_count.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MetricRuleCount') is not None:
            temp_model = DescribeMetricRuleCountResponseBodyMetricRuleCount()
            self.metric_rule_count = temp_model.from_map(m['MetricRuleCount'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMetricRuleCountResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMetricRuleCountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleCountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricRuleCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricRuleListRequest(TeaModel):
    def __init__(self, alert_state=None, dimensions=None, enable_state=None, group_id=None, metric_name=None,
                 namespace=None, page=None, page_size=None, region_id=None, rule_ids=None, rule_name=None):
        self.alert_state = alert_state  # type: str
        self.dimensions = dimensions  # type: str
        self.enable_state = enable_state  # type: bool
        self.group_id = group_id  # type: str
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.rule_ids = rule_ids  # type: str
        self.rule_name = rule_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricRuleListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_state is not None:
            result['AlertState'] = self.alert_state
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.enable_state is not None:
            result['EnableState'] = self.enable_state
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_ids is not None:
            result['RuleIds'] = self.rule_ids
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertState') is not None:
            self.alert_state = m.get('AlertState')
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EnableState') is not None:
            self.enable_state = m.get('EnableState')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleIds') is not None:
            self.rule_ids = m.get('RuleIds')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpressionExpressionListExpressionList(TeaModel):
    def __init__(self, comparison_operator=None, metric_name=None, period=None, statistics=None, threshold=None):
        self.comparison_operator = comparison_operator  # type: str
        self.metric_name = metric_name  # type: str
        self.period = period  # type: int
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpressionExpressionListExpressionList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.period is not None:
            result['Period'] = self.period
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpressionExpressionList(TeaModel):
    def __init__(self, expression_list=None):
        self.expression_list = expression_list  # type: list[DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpressionExpressionListExpressionList]

    def validate(self):
        if self.expression_list:
            for k in self.expression_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpressionExpressionList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExpressionList'] = []
        if self.expression_list is not None:
            for k in self.expression_list:
                result['ExpressionList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.expression_list = []
        if m.get('ExpressionList') is not None:
            for k in m.get('ExpressionList'):
                temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpressionExpressionListExpressionList()
                self.expression_list.append(temp_model.from_map(k))
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpression(TeaModel):
    def __init__(self, expression_list=None, expression_list_join=None, expression_raw=None, level=None, times=None):
        self.expression_list = expression_list  # type: DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpressionExpressionList
        self.expression_list_join = expression_list_join  # type: str
        self.expression_raw = expression_raw  # type: str
        self.level = level  # type: str
        self.times = times  # type: int

    def validate(self):
        if self.expression_list:
            self.expression_list.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpression, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expression_list is not None:
            result['ExpressionList'] = self.expression_list.to_map()
        if self.expression_list_join is not None:
            result['ExpressionListJoin'] = self.expression_list_join
        if self.expression_raw is not None:
            result['ExpressionRaw'] = self.expression_raw
        if self.level is not None:
            result['Level'] = self.level
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExpressionList') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpressionExpressionList()
            self.expression_list = temp_model.from_map(m['ExpressionList'])
        if m.get('ExpressionListJoin') is not None:
            self.expression_list_join = m.get('ExpressionListJoin')
        if m.get('ExpressionRaw') is not None:
            self.expression_raw = m.get('ExpressionRaw')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsCritical(TeaModel):
    def __init__(self, comparison_operator=None, pre_condition=None, statistics=None, threshold=None, times=None):
        self.comparison_operator = comparison_operator  # type: str
        self.pre_condition = pre_condition  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str
        self.times = times  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsCritical, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.pre_condition is not None:
            result['PreCondition'] = self.pre_condition
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('PreCondition') is not None:
            self.pre_condition = m.get('PreCondition')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsInfo(TeaModel):
    def __init__(self, comparison_operator=None, pre_condition=None, statistics=None, threshold=None, times=None):
        self.comparison_operator = comparison_operator  # type: str
        self.pre_condition = pre_condition  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str
        self.times = times  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.pre_condition is not None:
            result['PreCondition'] = self.pre_condition
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('PreCondition') is not None:
            self.pre_condition = m.get('PreCondition')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsWarn(TeaModel):
    def __init__(self, comparison_operator=None, pre_condition=None, statistics=None, threshold=None, times=None):
        self.comparison_operator = comparison_operator  # type: str
        self.pre_condition = pre_condition  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str
        self.times = times  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsWarn, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.pre_condition is not None:
            result['PreCondition'] = self.pre_condition
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('PreCondition') is not None:
            self.pre_condition = m.get('PreCondition')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmEscalations(TeaModel):
    def __init__(self, critical=None, info=None, warn=None):
        self.critical = critical  # type: DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsCritical
        self.info = info  # type: DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsInfo
        self.warn = warn  # type: DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsWarn

    def validate(self):
        if self.critical:
            self.critical.validate()
        if self.info:
            self.info.validate()
        if self.warn:
            self.warn.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleListResponseBodyAlarmsAlarmEscalations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.critical is not None:
            result['Critical'] = self.critical.to_map()
        if self.info is not None:
            result['Info'] = self.info.to_map()
        if self.warn is not None:
            result['Warn'] = self.warn.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Critical') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsCritical()
            self.critical = temp_model.from_map(m['Critical'])
        if m.get('Info') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsInfo()
            self.info = temp_model.from_map(m['Info'])
        if m.get('Warn') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmEscalationsWarn()
            self.warn = temp_model.from_map(m['Warn'])
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmLabelsLabels(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricRuleListResponseBodyAlarmsAlarmLabelsLabels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmLabels(TeaModel):
    def __init__(self, labels=None):
        self.labels = labels  # type: list[DescribeMetricRuleListResponseBodyAlarmsAlarmLabelsLabels]

    def validate(self):
        if self.labels:
            for k in self.labels:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleListResponseBodyAlarmsAlarmLabels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Labels'] = []
        if self.labels is not None:
            for k in self.labels:
                result['Labels'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.labels = []
        if m.get('Labels') is not None:
            for k in m.get('Labels'):
                temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmLabelsLabels()
                self.labels.append(temp_model.from_map(k))
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheusAnnotationsAnnotations(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheusAnnotationsAnnotations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheusAnnotations(TeaModel):
    def __init__(self, annotations=None):
        self.annotations = annotations  # type: list[DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheusAnnotationsAnnotations]

    def validate(self):
        if self.annotations:
            for k in self.annotations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheusAnnotations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Annotations'] = []
        if self.annotations is not None:
            for k in self.annotations:
                result['Annotations'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.annotations = []
        if m.get('Annotations') is not None:
            for k in m.get('Annotations'):
                temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheusAnnotationsAnnotations()
                self.annotations.append(temp_model.from_map(k))
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheus(TeaModel):
    def __init__(self, annotations=None, level=None, prom_ql=None, times=None):
        self.annotations = annotations  # type: DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheusAnnotations
        self.level = level  # type: str
        self.prom_ql = prom_ql  # type: str
        self.times = times  # type: long

    def validate(self):
        if self.annotations:
            self.annotations.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheus, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.annotations is not None:
            result['Annotations'] = self.annotations.to_map()
        if self.level is not None:
            result['Level'] = self.level
        if self.prom_ql is not None:
            result['PromQL'] = self.prom_ql
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Annotations') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheusAnnotations()
            self.annotations = temp_model.from_map(m['Annotations'])
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('PromQL') is not None:
            self.prom_ql = m.get('PromQL')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeMetricRuleListResponseBodyAlarmsAlarm(TeaModel):
    def __init__(self, alert_state=None, composite_expression=None, contact_groups=None, dimensions=None,
                 effective_interval=None, enable_state=None, escalations=None, group_id=None, group_name=None, labels=None,
                 mail_subject=None, metric_name=None, namespace=None, no_data_policy=None, no_effective_interval=None,
                 period=None, prometheus=None, resources=None, rule_id=None, rule_name=None, silence_time=None,
                 source_type=None, webhook=None):
        self.alert_state = alert_state  # type: str
        self.composite_expression = composite_expression  # type: DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpression
        self.contact_groups = contact_groups  # type: str
        self.dimensions = dimensions  # type: str
        self.effective_interval = effective_interval  # type: str
        self.enable_state = enable_state  # type: bool
        self.escalations = escalations  # type: DescribeMetricRuleListResponseBodyAlarmsAlarmEscalations
        self.group_id = group_id  # type: str
        self.group_name = group_name  # type: str
        self.labels = labels  # type: DescribeMetricRuleListResponseBodyAlarmsAlarmLabels
        self.mail_subject = mail_subject  # type: str
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.no_data_policy = no_data_policy  # type: str
        self.no_effective_interval = no_effective_interval  # type: str
        self.period = period  # type: str
        self.prometheus = prometheus  # type: DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheus
        self.resources = resources  # type: str
        self.rule_id = rule_id  # type: str
        self.rule_name = rule_name  # type: str
        self.silence_time = silence_time  # type: int
        self.source_type = source_type  # type: str
        self.webhook = webhook  # type: str

    def validate(self):
        if self.composite_expression:
            self.composite_expression.validate()
        if self.escalations:
            self.escalations.validate()
        if self.labels:
            self.labels.validate()
        if self.prometheus:
            self.prometheus.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleListResponseBodyAlarmsAlarm, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_state is not None:
            result['AlertState'] = self.alert_state
        if self.composite_expression is not None:
            result['CompositeExpression'] = self.composite_expression.to_map()
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.effective_interval is not None:
            result['EffectiveInterval'] = self.effective_interval
        if self.enable_state is not None:
            result['EnableState'] = self.enable_state
        if self.escalations is not None:
            result['Escalations'] = self.escalations.to_map()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.labels is not None:
            result['Labels'] = self.labels.to_map()
        if self.mail_subject is not None:
            result['MailSubject'] = self.mail_subject
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.no_data_policy is not None:
            result['NoDataPolicy'] = self.no_data_policy
        if self.no_effective_interval is not None:
            result['NoEffectiveInterval'] = self.no_effective_interval
        if self.period is not None:
            result['Period'] = self.period
        if self.prometheus is not None:
            result['Prometheus'] = self.prometheus.to_map()
        if self.resources is not None:
            result['Resources'] = self.resources
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.silence_time is not None:
            result['SilenceTime'] = self.silence_time
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertState') is not None:
            self.alert_state = m.get('AlertState')
        if m.get('CompositeExpression') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmCompositeExpression()
            self.composite_expression = temp_model.from_map(m['CompositeExpression'])
        if m.get('ContactGroups') is not None:
            self.contact_groups = m.get('ContactGroups')
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EffectiveInterval') is not None:
            self.effective_interval = m.get('EffectiveInterval')
        if m.get('EnableState') is not None:
            self.enable_state = m.get('EnableState')
        if m.get('Escalations') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmEscalations()
            self.escalations = temp_model.from_map(m['Escalations'])
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Labels') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmLabels()
            self.labels = temp_model.from_map(m['Labels'])
        if m.get('MailSubject') is not None:
            self.mail_subject = m.get('MailSubject')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NoDataPolicy') is not None:
            self.no_data_policy = m.get('NoDataPolicy')
        if m.get('NoEffectiveInterval') is not None:
            self.no_effective_interval = m.get('NoEffectiveInterval')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Prometheus') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarmPrometheus()
            self.prometheus = temp_model.from_map(m['Prometheus'])
        if m.get('Resources') is not None:
            self.resources = m.get('Resources')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SilenceTime') is not None:
            self.silence_time = m.get('SilenceTime')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class DescribeMetricRuleListResponseBodyAlarms(TeaModel):
    def __init__(self, alarm=None):
        self.alarm = alarm  # type: list[DescribeMetricRuleListResponseBodyAlarmsAlarm]

    def validate(self):
        if self.alarm:
            for k in self.alarm:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleListResponseBodyAlarms, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Alarm'] = []
        if self.alarm is not None:
            for k in self.alarm:
                result['Alarm'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alarm = []
        if m.get('Alarm') is not None:
            for k in m.get('Alarm'):
                temp_model = DescribeMetricRuleListResponseBodyAlarmsAlarm()
                self.alarm.append(temp_model.from_map(k))
        return self


class DescribeMetricRuleListResponseBody(TeaModel):
    def __init__(self, alarms=None, code=None, message=None, request_id=None, success=None, total=None):
        self.alarms = alarms  # type: DescribeMetricRuleListResponseBodyAlarms
        self.code = code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: str

    def validate(self):
        if self.alarms:
            self.alarms.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarms is not None:
            result['Alarms'] = self.alarms.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Alarms') is not None:
            temp_model = DescribeMetricRuleListResponseBodyAlarms()
            self.alarms = temp_model.from_map(m['Alarms'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeMetricRuleListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMetricRuleListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricRuleListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricRuleTargetsRequest(TeaModel):
    def __init__(self, region_id=None, rule_id=None):
        self.region_id = region_id  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricRuleTargetsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DescribeMetricRuleTargetsResponseBodyTargetsTarget(TeaModel):
    def __init__(self, arn=None, id=None, json_params=None, level=None):
        self.arn = arn  # type: str
        self.id = id  # type: str
        self.json_params = json_params  # type: str
        self.level = level  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricRuleTargetsResponseBodyTargetsTarget, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arn is not None:
            result['Arn'] = self.arn
        if self.id is not None:
            result['Id'] = self.id
        if self.json_params is not None:
            result['JsonParams'] = self.json_params
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Arn') is not None:
            self.arn = m.get('Arn')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('JsonParams') is not None:
            self.json_params = m.get('JsonParams')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class DescribeMetricRuleTargetsResponseBodyTargets(TeaModel):
    def __init__(self, target=None):
        self.target = target  # type: list[DescribeMetricRuleTargetsResponseBodyTargetsTarget]

    def validate(self):
        if self.target:
            for k in self.target:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleTargetsResponseBodyTargets, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Target'] = []
        if self.target is not None:
            for k in self.target:
                result['Target'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.target = []
        if m.get('Target') is not None:
            for k in m.get('Target'):
                temp_model = DescribeMetricRuleTargetsResponseBodyTargetsTarget()
                self.target.append(temp_model.from_map(k))
        return self


class DescribeMetricRuleTargetsResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None, targets=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.targets = targets  # type: DescribeMetricRuleTargetsResponseBodyTargets

    def validate(self):
        if self.targets:
            self.targets.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleTargetsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.targets is not None:
            result['Targets'] = self.targets.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Targets') is not None:
            temp_model = DescribeMetricRuleTargetsResponseBodyTargets()
            self.targets = temp_model.from_map(m['Targets'])
        return self


class DescribeMetricRuleTargetsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMetricRuleTargetsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleTargetsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricRuleTargetsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricRuleTemplateAttributeRequest(TeaModel):
    def __init__(self, name=None, region_id=None, template_id=None):
        self.name = name  # type: str
        self.region_id = region_id  # type: str
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricRuleTemplateAttributeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsCritical(TeaModel):
    def __init__(self, comparison_operator=None, statistics=None, threshold=None, times=None):
        self.comparison_operator = comparison_operator  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str
        self.times = times  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsCritical, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsInfo(TeaModel):
    def __init__(self, comparison_operator=None, statistics=None, threshold=None, times=None):
        self.comparison_operator = comparison_operator  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str
        self.times = times  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsWarn(TeaModel):
    def __init__(self, comparison_operator=None, statistics=None, threshold=None, times=None):
        self.comparison_operator = comparison_operator  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str
        self.times = times  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsWarn, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.times is not None:
            result['Times'] = self.times
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Times') is not None:
            self.times = m.get('Times')
        return self


class DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalations(TeaModel):
    def __init__(self, critical=None, info=None, warn=None):
        self.critical = critical  # type: DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsCritical
        self.info = info  # type: DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsInfo
        self.warn = warn  # type: DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsWarn

    def validate(self):
        if self.critical:
            self.critical.validate()
        if self.info:
            self.info.validate()
        if self.warn:
            self.warn.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.critical is not None:
            result['Critical'] = self.critical.to_map()
        if self.info is not None:
            result['Info'] = self.info.to_map()
        if self.warn is not None:
            result['Warn'] = self.warn.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Critical') is not None:
            temp_model = DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsCritical()
            self.critical = temp_model.from_map(m['Critical'])
        if m.get('Info') is not None:
            temp_model = DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsInfo()
            self.info = temp_model.from_map(m['Info'])
        if m.get('Warn') is not None:
            temp_model = DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalationsWarn()
            self.warn = temp_model.from_map(m['Warn'])
        return self


class DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplate(TeaModel):
    def __init__(self, category=None, escalations=None, metric_name=None, namespace=None, no_data_policy=None,
                 rule_name=None, selector=None, webhook=None):
        self.category = category  # type: str
        self.escalations = escalations  # type: DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalations
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.no_data_policy = no_data_policy  # type: str
        self.rule_name = rule_name  # type: str
        self.selector = selector  # type: str
        self.webhook = webhook  # type: str

    def validate(self):
        if self.escalations:
            self.escalations.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplate, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.escalations is not None:
            result['Escalations'] = self.escalations.to_map()
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.no_data_policy is not None:
            result['NoDataPolicy'] = self.no_data_policy
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.selector is not None:
            result['Selector'] = self.selector
        if self.webhook is not None:
            result['Webhook'] = self.webhook
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Escalations') is not None:
            temp_model = DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplateEscalations()
            self.escalations = temp_model.from_map(m['Escalations'])
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NoDataPolicy') is not None:
            self.no_data_policy = m.get('NoDataPolicy')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('Selector') is not None:
            self.selector = m.get('Selector')
        if m.get('Webhook') is not None:
            self.webhook = m.get('Webhook')
        return self


class DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplates(TeaModel):
    def __init__(self, alert_template=None):
        self.alert_template = alert_template  # type: list[DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplate]

    def validate(self):
        if self.alert_template:
            for k in self.alert_template:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplates, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertTemplate'] = []
        if self.alert_template is not None:
            for k in self.alert_template:
                result['AlertTemplate'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alert_template = []
        if m.get('AlertTemplate') is not None:
            for k in m.get('AlertTemplate'):
                temp_model = DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplatesAlertTemplate()
                self.alert_template.append(temp_model.from_map(k))
        return self


class DescribeMetricRuleTemplateAttributeResponseBodyResource(TeaModel):
    def __init__(self, alert_templates=None, description=None, name=None, rest_version=None, template_id=None):
        self.alert_templates = alert_templates  # type: DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplates
        self.description = description  # type: str
        self.name = name  # type: str
        self.rest_version = rest_version  # type: str
        self.template_id = template_id  # type: str

    def validate(self):
        if self.alert_templates:
            self.alert_templates.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleTemplateAttributeResponseBodyResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_templates is not None:
            result['AlertTemplates'] = self.alert_templates.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.rest_version is not None:
            result['RestVersion'] = self.rest_version
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertTemplates') is not None:
            temp_model = DescribeMetricRuleTemplateAttributeResponseBodyResourceAlertTemplates()
            self.alert_templates = temp_model.from_map(m['AlertTemplates'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RestVersion') is not None:
            self.rest_version = m.get('RestVersion')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DescribeMetricRuleTemplateAttributeResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, resource=None, success=None):
        self.code = code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.resource = resource  # type: DescribeMetricRuleTemplateAttributeResponseBodyResource
        self.success = success  # type: bool

    def validate(self):
        if self.resource:
            self.resource.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleTemplateAttributeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource is not None:
            result['Resource'] = self.resource.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resource') is not None:
            temp_model = DescribeMetricRuleTemplateAttributeResponseBodyResource()
            self.resource = temp_model.from_map(m['Resource'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMetricRuleTemplateAttributeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMetricRuleTemplateAttributeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleTemplateAttributeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricRuleTemplateAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricRuleTemplateListRequest(TeaModel):
    def __init__(self, history=None, keyword=None, name=None, order=None, order_by=None, page_number=None,
                 page_size=None, region_id=None, template_id=None):
        self.history = history  # type: bool
        self.keyword = keyword  # type: str
        self.name = name  # type: str
        self.order = order  # type: bool
        self.order_by = order_by  # type: str
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.region_id = region_id  # type: str
        self.template_id = template_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricRuleTemplateListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.history is not None:
            result['History'] = self.history
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.name is not None:
            result['Name'] = self.name
        if self.order is not None:
            result['Order'] = self.order
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('History') is not None:
            self.history = m.get('History')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DescribeMetricRuleTemplateListResponseBodyTemplatesTemplateApplyHistoriesApplyHistory(TeaModel):
    def __init__(self, apply_time=None, group_id=None, group_name=None):
        self.apply_time = apply_time  # type: long
        self.group_id = group_id  # type: long
        self.group_name = group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricRuleTemplateListResponseBodyTemplatesTemplateApplyHistoriesApplyHistory, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_time is not None:
            result['ApplyTime'] = self.apply_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyTime') is not None:
            self.apply_time = m.get('ApplyTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class DescribeMetricRuleTemplateListResponseBodyTemplatesTemplateApplyHistories(TeaModel):
    def __init__(self, apply_history=None):
        self.apply_history = apply_history  # type: list[DescribeMetricRuleTemplateListResponseBodyTemplatesTemplateApplyHistoriesApplyHistory]

    def validate(self):
        if self.apply_history:
            for k in self.apply_history:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleTemplateListResponseBodyTemplatesTemplateApplyHistories, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ApplyHistory'] = []
        if self.apply_history is not None:
            for k in self.apply_history:
                result['ApplyHistory'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.apply_history = []
        if m.get('ApplyHistory') is not None:
            for k in m.get('ApplyHistory'):
                temp_model = DescribeMetricRuleTemplateListResponseBodyTemplatesTemplateApplyHistoriesApplyHistory()
                self.apply_history.append(temp_model.from_map(k))
        return self


class DescribeMetricRuleTemplateListResponseBodyTemplatesTemplate(TeaModel):
    def __init__(self, apply_histories=None, description=None, gmt_create=None, gmt_modified=None, name=None,
                 rest_version=None, template_id=None):
        self.apply_histories = apply_histories  # type: DescribeMetricRuleTemplateListResponseBodyTemplatesTemplateApplyHistories
        self.description = description  # type: str
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.name = name  # type: str
        self.rest_version = rest_version  # type: long
        self.template_id = template_id  # type: long

    def validate(self):
        if self.apply_histories:
            self.apply_histories.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleTemplateListResponseBodyTemplatesTemplate, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_histories is not None:
            result['ApplyHistories'] = self.apply_histories.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.name is not None:
            result['Name'] = self.name
        if self.rest_version is not None:
            result['RestVersion'] = self.rest_version
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyHistories') is not None:
            temp_model = DescribeMetricRuleTemplateListResponseBodyTemplatesTemplateApplyHistories()
            self.apply_histories = temp_model.from_map(m['ApplyHistories'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RestVersion') is not None:
            self.rest_version = m.get('RestVersion')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DescribeMetricRuleTemplateListResponseBodyTemplates(TeaModel):
    def __init__(self, template=None):
        self.template = template  # type: list[DescribeMetricRuleTemplateListResponseBodyTemplatesTemplate]

    def validate(self):
        if self.template:
            for k in self.template:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleTemplateListResponseBodyTemplates, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Template'] = []
        if self.template is not None:
            for k in self.template:
                result['Template'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.template = []
        if m.get('Template') is not None:
            for k in m.get('Template'):
                temp_model = DescribeMetricRuleTemplateListResponseBodyTemplatesTemplate()
                self.template.append(temp_model.from_map(k))
        return self


class DescribeMetricRuleTemplateListResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None, templates=None, total=None):
        self.code = code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.templates = templates  # type: DescribeMetricRuleTemplateListResponseBodyTemplates
        self.total = total  # type: long

    def validate(self):
        if self.templates:
            self.templates.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleTemplateListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.templates is not None:
            result['Templates'] = self.templates.to_map()
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Templates') is not None:
            temp_model = DescribeMetricRuleTemplateListResponseBodyTemplates()
            self.templates = temp_model.from_map(m['Templates'])
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeMetricRuleTemplateListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMetricRuleTemplateListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMetricRuleTemplateListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricRuleTemplateListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricTopRequest(TeaModel):
    def __init__(self, dimensions=None, end_time=None, express=None, length=None, metric_name=None, namespace=None,
                 order_desc=None, orderby=None, period=None, region_id=None, start_time=None):
        self.dimensions = dimensions  # type: str
        self.end_time = end_time  # type: str
        self.express = express  # type: str
        self.length = length  # type: str
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.order_desc = order_desc  # type: str
        self.orderby = orderby  # type: str
        self.period = period  # type: str
        self.region_id = region_id  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricTopRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.express is not None:
            result['Express'] = self.express
        if self.length is not None:
            result['Length'] = self.length
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.order_desc is not None:
            result['OrderDesc'] = self.order_desc
        if self.orderby is not None:
            result['Orderby'] = self.orderby
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Express') is not None:
            self.express = m.get('Express')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('OrderDesc') is not None:
            self.order_desc = m.get('OrderDesc')
        if m.get('Orderby') is not None:
            self.orderby = m.get('Orderby')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeMetricTopResponseBody(TeaModel):
    def __init__(self, code=None, datapoints=None, message=None, period=None, request_id=None):
        self.code = code  # type: str
        self.datapoints = datapoints  # type: str
        self.message = message  # type: str
        self.period = period  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMetricTopResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints
        if self.message is not None:
            result['Message'] = self.message
        if self.period is not None:
            result['Period'] = self.period
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            self.datapoints = m.get('Datapoints')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMetricTopResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMetricTopResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMetricTopResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricTopResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitorGroupCategoriesRequest(TeaModel):
    def __init__(self, group_id=None, region_id=None):
        self.group_id = group_id  # type: long
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorGroupCategoriesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategoriesMonitorGroupCategoryCategoryItem(TeaModel):
    def __init__(self, category=None, count=None):
        self.category = category  # type: str
        self.count = count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategoriesMonitorGroupCategoryCategoryItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategoriesMonitorGroupCategory(TeaModel):
    def __init__(self, category_item=None):
        self.category_item = category_item  # type: list[DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategoriesMonitorGroupCategoryCategoryItem]

    def validate(self):
        if self.category_item:
            for k in self.category_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategoriesMonitorGroupCategory, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CategoryItem'] = []
        if self.category_item is not None:
            for k in self.category_item:
                result['CategoryItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.category_item = []
        if m.get('CategoryItem') is not None:
            for k in m.get('CategoryItem'):
                temp_model = DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategoriesMonitorGroupCategoryCategoryItem()
                self.category_item.append(temp_model.from_map(k))
        return self


class DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategories(TeaModel):
    def __init__(self, group_id=None, monitor_group_category=None):
        self.group_id = group_id  # type: long
        self.monitor_group_category = monitor_group_category  # type: DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategoriesMonitorGroupCategory

    def validate(self):
        if self.monitor_group_category:
            self.monitor_group_category.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategories, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.monitor_group_category is not None:
            result['MonitorGroupCategory'] = self.monitor_group_category.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('MonitorGroupCategory') is not None:
            temp_model = DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategoriesMonitorGroupCategory()
            self.monitor_group_category = temp_model.from_map(m['MonitorGroupCategory'])
        return self


class DescribeMonitorGroupCategoriesResponseBody(TeaModel):
    def __init__(self, code=None, message=None, monitor_group_categories=None, request_id=None, success=None):
        self.code = code  # type: int
        self.message = message  # type: str
        self.monitor_group_categories = monitor_group_categories  # type: DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategories
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.monitor_group_categories:
            self.monitor_group_categories.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupCategoriesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.monitor_group_categories is not None:
            result['MonitorGroupCategories'] = self.monitor_group_categories.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MonitorGroupCategories') is not None:
            temp_model = DescribeMonitorGroupCategoriesResponseBodyMonitorGroupCategories()
            self.monitor_group_categories = temp_model.from_map(m['MonitorGroupCategories'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMonitorGroupCategoriesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMonitorGroupCategoriesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupCategoriesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitorGroupCategoriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitorGroupDynamicRulesRequest(TeaModel):
    def __init__(self, group_id=None, region_id=None):
        self.group_id = group_id  # type: long
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorGroupDynamicRulesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitorGroupDynamicRulesResponseBodyResourceResourceFiltersFilter(TeaModel):
    def __init__(self, function=None, name=None, value=None):
        self.function = function  # type: str
        self.name = name  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorGroupDynamicRulesResponseBodyResourceResourceFiltersFilter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.function is not None:
            result['Function'] = self.function
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Function') is not None:
            self.function = m.get('Function')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeMonitorGroupDynamicRulesResponseBodyResourceResourceFilters(TeaModel):
    def __init__(self, filter=None):
        self.filter = filter  # type: list[DescribeMonitorGroupDynamicRulesResponseBodyResourceResourceFiltersFilter]

    def validate(self):
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupDynamicRulesResponseBodyResourceResourceFilters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.filter = []
        if m.get('Filter') is not None:
            for k in m.get('Filter'):
                temp_model = DescribeMonitorGroupDynamicRulesResponseBodyResourceResourceFiltersFilter()
                self.filter.append(temp_model.from_map(k))
        return self


class DescribeMonitorGroupDynamicRulesResponseBodyResourceResource(TeaModel):
    def __init__(self, category=None, filter_relation=None, filters=None):
        self.category = category  # type: str
        self.filter_relation = filter_relation  # type: str
        self.filters = filters  # type: DescribeMonitorGroupDynamicRulesResponseBodyResourceResourceFilters

    def validate(self):
        if self.filters:
            self.filters.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupDynamicRulesResponseBodyResourceResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.filter_relation is not None:
            result['FilterRelation'] = self.filter_relation
        if self.filters is not None:
            result['Filters'] = self.filters.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('FilterRelation') is not None:
            self.filter_relation = m.get('FilterRelation')
        if m.get('Filters') is not None:
            temp_model = DescribeMonitorGroupDynamicRulesResponseBodyResourceResourceFilters()
            self.filters = temp_model.from_map(m['Filters'])
        return self


class DescribeMonitorGroupDynamicRulesResponseBodyResource(TeaModel):
    def __init__(self, resource=None):
        self.resource = resource  # type: list[DescribeMonitorGroupDynamicRulesResponseBodyResourceResource]

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupDynamicRulesResponseBodyResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeMonitorGroupDynamicRulesResponseBodyResourceResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeMonitorGroupDynamicRulesResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, resource=None, success=None):
        self.code = code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.resource = resource  # type: DescribeMonitorGroupDynamicRulesResponseBodyResource
        self.success = success  # type: bool

    def validate(self):
        if self.resource:
            self.resource.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupDynamicRulesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource is not None:
            result['Resource'] = self.resource.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resource') is not None:
            temp_model = DescribeMonitorGroupDynamicRulesResponseBodyResource()
            self.resource = temp_model.from_map(m['Resource'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMonitorGroupDynamicRulesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMonitorGroupDynamicRulesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupDynamicRulesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitorGroupDynamicRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitorGroupInstanceAttributeRequest(TeaModel):
    def __init__(self, category=None, group_id=None, instance_ids=None, keyword=None, page_number=None,
                 page_size=None, region_id=None, total=None):
        self.category = category  # type: str
        self.group_id = group_id  # type: long
        self.instance_ids = instance_ids  # type: str
        self.keyword = keyword  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.total = total  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorGroupInstanceAttributeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceRegion(TeaModel):
    def __init__(self, availability_zone=None, region_id=None):
        self.availability_zone = availability_zone  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceRegion, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.availability_zone is not None:
            result['AvailabilityZone'] = self.availability_zone
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvailabilityZone') is not None:
            self.availability_zone = m.get('AvailabilityZone')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceTagsTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceTagsTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceTagsTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceVpc(TeaModel):
    def __init__(self, vpc_instance_id=None, vswitch_instance_id=None):
        self.vpc_instance_id = vpc_instance_id  # type: str
        self.vswitch_instance_id = vswitch_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceVpc, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_instance_id is not None:
            result['VpcInstanceId'] = self.vpc_instance_id
        if self.vswitch_instance_id is not None:
            result['VswitchInstanceId'] = self.vswitch_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VpcInstanceId') is not None:
            self.vpc_instance_id = m.get('VpcInstanceId')
        if m.get('VswitchInstanceId') is not None:
            self.vswitch_instance_id = m.get('VswitchInstanceId')
        return self


class DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResource(TeaModel):
    def __init__(self, category=None, desc=None, dimension=None, instance_id=None, instance_name=None,
                 network_type=None, region=None, tags=None, vpc=None):
        self.category = category  # type: str
        self.desc = desc  # type: str
        self.dimension = dimension  # type: str
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.network_type = network_type  # type: str
        self.region = region  # type: DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceRegion
        self.tags = tags  # type: DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceTags
        self.vpc = vpc  # type: DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceVpc

    def validate(self):
        if self.region:
            self.region.validate()
        if self.tags:
            self.tags.validate()
        if self.vpc:
            self.vpc.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.region is not None:
            result['Region'] = self.region.to_map()
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.vpc is not None:
            result['Vpc'] = self.vpc.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('Region') is not None:
            temp_model = DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceRegion()
            self.region = temp_model.from_map(m['Region'])
        if m.get('Tags') is not None:
            temp_model = DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('Vpc') is not None:
            temp_model = DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResourceVpc()
            self.vpc = temp_model.from_map(m['Vpc'])
        return self


class DescribeMonitorGroupInstanceAttributeResponseBodyResources(TeaModel):
    def __init__(self, resource=None):
        self.resource = resource  # type: list[DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResource]

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupInstanceAttributeResponseBodyResources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeMonitorGroupInstanceAttributeResponseBodyResourcesResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeMonitorGroupInstanceAttributeResponseBody(TeaModel):
    def __init__(self, code=None, message=None, page_number=None, page_size=None, request_id=None, resources=None,
                 success=None, total=None):
        self.code = code  # type: int
        self.message = message  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.resources = resources  # type: DescribeMonitorGroupInstanceAttributeResponseBodyResources
        self.success = success  # type: bool
        self.total = total  # type: int

    def validate(self):
        if self.resources:
            self.resources.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupInstanceAttributeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resources') is not None:
            temp_model = DescribeMonitorGroupInstanceAttributeResponseBodyResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeMonitorGroupInstanceAttributeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMonitorGroupInstanceAttributeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupInstanceAttributeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitorGroupInstanceAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitorGroupInstancesRequest(TeaModel):
    def __init__(self, category=None, group_id=None, instance_ids=None, keyword=None, page_number=None,
                 page_size=None, region_id=None):
        self.category = category  # type: str
        self.group_id = group_id  # type: long
        self.instance_ids = instance_ids  # type: str
        self.keyword = keyword  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorGroupInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitorGroupInstancesResponseBodyResourcesResource(TeaModel):
    def __init__(self, category=None, id=None, instance_id=None, instance_name=None, region_id=None):
        self.category = category  # type: str
        self.id = id  # type: long
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorGroupInstancesResponseBodyResourcesResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitorGroupInstancesResponseBodyResources(TeaModel):
    def __init__(self, resource=None):
        self.resource = resource  # type: list[DescribeMonitorGroupInstancesResponseBodyResourcesResource]

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupInstancesResponseBodyResources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeMonitorGroupInstancesResponseBodyResourcesResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeMonitorGroupInstancesResponseBody(TeaModel):
    def __init__(self, code=None, message=None, page_number=None, page_size=None, request_id=None, resources=None,
                 success=None, total=None):
        self.code = code  # type: int
        self.message = message  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.resources = resources  # type: DescribeMonitorGroupInstancesResponseBodyResources
        self.success = success  # type: bool
        self.total = total  # type: int

    def validate(self):
        if self.resources:
            self.resources.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resources') is not None:
            temp_model = DescribeMonitorGroupInstancesResponseBodyResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeMonitorGroupInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMonitorGroupInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitorGroupInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitorGroupNotifyPolicyListRequest(TeaModel):
    def __init__(self, group_id=None, page_number=None, page_size=None, policy_type=None, region_id=None):
        self.group_id = group_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.policy_type = policy_type  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorGroupNotifyPolicyListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitorGroupNotifyPolicyListResponseBodyNotifyPolicyListNotifyPolicy(TeaModel):
    def __init__(self, end_time=None, group_id=None, id=None, start_time=None, type=None):
        self.end_time = end_time  # type: long
        self.group_id = group_id  # type: str
        self.id = id  # type: str
        self.start_time = start_time  # type: long
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorGroupNotifyPolicyListResponseBodyNotifyPolicyListNotifyPolicy, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.id is not None:
            result['Id'] = self.id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeMonitorGroupNotifyPolicyListResponseBodyNotifyPolicyList(TeaModel):
    def __init__(self, notify_policy=None):
        self.notify_policy = notify_policy  # type: list[DescribeMonitorGroupNotifyPolicyListResponseBodyNotifyPolicyListNotifyPolicy]

    def validate(self):
        if self.notify_policy:
            for k in self.notify_policy:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupNotifyPolicyListResponseBodyNotifyPolicyList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NotifyPolicy'] = []
        if self.notify_policy is not None:
            for k in self.notify_policy:
                result['NotifyPolicy'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.notify_policy = []
        if m.get('NotifyPolicy') is not None:
            for k in m.get('NotifyPolicy'):
                temp_model = DescribeMonitorGroupNotifyPolicyListResponseBodyNotifyPolicyListNotifyPolicy()
                self.notify_policy.append(temp_model.from_map(k))
        return self


class DescribeMonitorGroupNotifyPolicyListResponseBody(TeaModel):
    def __init__(self, code=None, message=None, notify_policy_list=None, request_id=None, success=None, total=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.notify_policy_list = notify_policy_list  # type: DescribeMonitorGroupNotifyPolicyListResponseBodyNotifyPolicyList
        self.request_id = request_id  # type: str
        self.success = success  # type: str
        self.total = total  # type: int

    def validate(self):
        if self.notify_policy_list:
            self.notify_policy_list.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupNotifyPolicyListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.notify_policy_list is not None:
            result['NotifyPolicyList'] = self.notify_policy_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NotifyPolicyList') is not None:
            temp_model = DescribeMonitorGroupNotifyPolicyListResponseBodyNotifyPolicyList()
            self.notify_policy_list = temp_model.from_map(m['NotifyPolicyList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeMonitorGroupNotifyPolicyListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMonitorGroupNotifyPolicyListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupNotifyPolicyListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitorGroupNotifyPolicyListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitorGroupsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorGroupsRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeMonitorGroupsRequest(TeaModel):
    def __init__(self, dynamic_tag_rule_id=None, group_founder_tag_key=None, group_founder_tag_value=None,
                 group_id=None, group_name=None, include_template_history=None, instance_id=None, keyword=None,
                 page_number=None, page_size=None, region_id=None, select_contact_groups=None, tag=None, type=None):
        self.dynamic_tag_rule_id = dynamic_tag_rule_id  # type: str
        self.group_founder_tag_key = group_founder_tag_key  # type: str
        self.group_founder_tag_value = group_founder_tag_value  # type: str
        self.group_id = group_id  # type: str
        self.group_name = group_name  # type: str
        self.include_template_history = include_template_history  # type: bool
        self.instance_id = instance_id  # type: str
        self.keyword = keyword  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.select_contact_groups = select_contact_groups  # type: bool
        self.tag = tag  # type: list[DescribeMonitorGroupsRequestTag]
        self.type = type  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dynamic_tag_rule_id is not None:
            result['DynamicTagRuleId'] = self.dynamic_tag_rule_id
        if self.group_founder_tag_key is not None:
            result['GroupFounderTagKey'] = self.group_founder_tag_key
        if self.group_founder_tag_value is not None:
            result['GroupFounderTagValue'] = self.group_founder_tag_value
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.include_template_history is not None:
            result['IncludeTemplateHistory'] = self.include_template_history
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.select_contact_groups is not None:
            result['SelectContactGroups'] = self.select_contact_groups
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DynamicTagRuleId') is not None:
            self.dynamic_tag_rule_id = m.get('DynamicTagRuleId')
        if m.get('GroupFounderTagKey') is not None:
            self.group_founder_tag_key = m.get('GroupFounderTagKey')
        if m.get('GroupFounderTagValue') is not None:
            self.group_founder_tag_value = m.get('GroupFounderTagValue')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('IncludeTemplateHistory') is not None:
            self.include_template_history = m.get('IncludeTemplateHistory')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SelectContactGroups') is not None:
            self.select_contact_groups = m.get('SelectContactGroups')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeMonitorGroupsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeMonitorGroupsResponseBodyResourcesResourceContactGroupsContactGroup(TeaModel):
    def __init__(self, name=None):
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorGroupsResponseBodyResourcesResourceContactGroupsContactGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeMonitorGroupsResponseBodyResourcesResourceContactGroups(TeaModel):
    def __init__(self, contact_group=None):
        self.contact_group = contact_group  # type: list[DescribeMonitorGroupsResponseBodyResourcesResourceContactGroupsContactGroup]

    def validate(self):
        if self.contact_group:
            for k in self.contact_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupsResponseBodyResourcesResourceContactGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ContactGroup'] = []
        if self.contact_group is not None:
            for k in self.contact_group:
                result['ContactGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.contact_group = []
        if m.get('ContactGroup') is not None:
            for k in m.get('ContactGroup'):
                temp_model = DescribeMonitorGroupsResponseBodyResourcesResourceContactGroupsContactGroup()
                self.contact_group.append(temp_model.from_map(k))
        return self


class DescribeMonitorGroupsResponseBodyResourcesResourceTagsTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorGroupsResponseBodyResourcesResourceTagsTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeMonitorGroupsResponseBodyResourcesResourceTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[DescribeMonitorGroupsResponseBodyResourcesResourceTagsTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupsResponseBodyResourcesResourceTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeMonitorGroupsResponseBodyResourcesResourceTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeMonitorGroupsResponseBodyResourcesResourceTemplateIds(TeaModel):
    def __init__(self, template_id=None):
        self.template_id = template_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorGroupsResponseBodyResourcesResourceTemplateIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DescribeMonitorGroupsResponseBodyResourcesResource(TeaModel):
    def __init__(self, bind_url=None, contact_groups=None, dynamic_tag_rule_id=None, gmt_create=None,
                 gmt_modified=None, group_founder_tag_key=None, group_founder_tag_value=None, group_id=None, group_name=None,
                 service_id=None, tags=None, template_ids=None, type=None):
        self.bind_url = bind_url  # type: str
        self.contact_groups = contact_groups  # type: DescribeMonitorGroupsResponseBodyResourcesResourceContactGroups
        self.dynamic_tag_rule_id = dynamic_tag_rule_id  # type: str
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.group_founder_tag_key = group_founder_tag_key  # type: str
        self.group_founder_tag_value = group_founder_tag_value  # type: str
        self.group_id = group_id  # type: long
        self.group_name = group_name  # type: str
        self.service_id = service_id  # type: str
        self.tags = tags  # type: DescribeMonitorGroupsResponseBodyResourcesResourceTags
        self.template_ids = template_ids  # type: DescribeMonitorGroupsResponseBodyResourcesResourceTemplateIds
        self.type = type  # type: str

    def validate(self):
        if self.contact_groups:
            self.contact_groups.validate()
        if self.tags:
            self.tags.validate()
        if self.template_ids:
            self.template_ids.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupsResponseBodyResourcesResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_url is not None:
            result['BindUrl'] = self.bind_url
        if self.contact_groups is not None:
            result['ContactGroups'] = self.contact_groups.to_map()
        if self.dynamic_tag_rule_id is not None:
            result['DynamicTagRuleId'] = self.dynamic_tag_rule_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.group_founder_tag_key is not None:
            result['GroupFounderTagKey'] = self.group_founder_tag_key
        if self.group_founder_tag_value is not None:
            result['GroupFounderTagValue'] = self.group_founder_tag_value
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.service_id is not None:
            result['ServiceId'] = self.service_id
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.template_ids is not None:
            result['TemplateIds'] = self.template_ids.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BindUrl') is not None:
            self.bind_url = m.get('BindUrl')
        if m.get('ContactGroups') is not None:
            temp_model = DescribeMonitorGroupsResponseBodyResourcesResourceContactGroups()
            self.contact_groups = temp_model.from_map(m['ContactGroups'])
        if m.get('DynamicTagRuleId') is not None:
            self.dynamic_tag_rule_id = m.get('DynamicTagRuleId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GroupFounderTagKey') is not None:
            self.group_founder_tag_key = m.get('GroupFounderTagKey')
        if m.get('GroupFounderTagValue') is not None:
            self.group_founder_tag_value = m.get('GroupFounderTagValue')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('ServiceId') is not None:
            self.service_id = m.get('ServiceId')
        if m.get('Tags') is not None:
            temp_model = DescribeMonitorGroupsResponseBodyResourcesResourceTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('TemplateIds') is not None:
            temp_model = DescribeMonitorGroupsResponseBodyResourcesResourceTemplateIds()
            self.template_ids = temp_model.from_map(m['TemplateIds'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeMonitorGroupsResponseBodyResources(TeaModel):
    def __init__(self, resource=None):
        self.resource = resource  # type: list[DescribeMonitorGroupsResponseBodyResourcesResource]

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupsResponseBodyResources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeMonitorGroupsResponseBodyResourcesResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeMonitorGroupsResponseBody(TeaModel):
    def __init__(self, code=None, message=None, page_number=None, page_size=None, request_id=None, resources=None,
                 success=None, total=None):
        self.code = code  # type: int
        self.message = message  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.resources = resources  # type: DescribeMonitorGroupsResponseBodyResources
        self.success = success  # type: bool
        self.total = total  # type: int

    def validate(self):
        if self.resources:
            self.resources.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resources') is not None:
            temp_model = DescribeMonitorGroupsResponseBodyResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeMonitorGroupsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMonitorGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMonitorGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitorGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitorResourceQuotaAttributeRequest(TeaModel):
    def __init__(self, region_id=None, show_used=None):
        self.region_id = region_id  # type: str
        self.show_used = show_used  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorResourceQuotaAttributeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.show_used is not None:
            result['ShowUsed'] = self.show_used
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ShowUsed') is not None:
            self.show_used = m.get('ShowUsed')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaApi(TeaModel):
    def __init__(self, quota_limit=None, quota_package=None, quota_used=None):
        self.quota_limit = quota_limit  # type: int
        self.quota_package = quota_package  # type: int
        self.quota_used = quota_used  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaApi, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_limit is not None:
            result['QuotaLimit'] = self.quota_limit
        if self.quota_package is not None:
            result['QuotaPackage'] = self.quota_package
        if self.quota_used is not None:
            result['QuotaUsed'] = self.quota_used
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('QuotaLimit') is not None:
            self.quota_limit = m.get('QuotaLimit')
        if m.get('QuotaPackage') is not None:
            self.quota_package = m.get('QuotaPackage')
        if m.get('QuotaUsed') is not None:
            self.quota_used = m.get('QuotaUsed')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaCustomMonitor(TeaModel):
    def __init__(self, quota_limit=None, quota_package=None, quota_used=None):
        self.quota_limit = quota_limit  # type: int
        self.quota_package = quota_package  # type: int
        self.quota_used = quota_used  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaCustomMonitor, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_limit is not None:
            result['QuotaLimit'] = self.quota_limit
        if self.quota_package is not None:
            result['QuotaPackage'] = self.quota_package
        if self.quota_used is not None:
            result['QuotaUsed'] = self.quota_used
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('QuotaLimit') is not None:
            self.quota_limit = m.get('QuotaLimit')
        if m.get('QuotaPackage') is not None:
            self.quota_package = m.get('QuotaPackage')
        if m.get('QuotaUsed') is not None:
            self.quota_used = m.get('QuotaUsed')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaEnterpriseQuota(TeaModel):
    def __init__(self, instance_id=None, suit_info=None):
        self.instance_id = instance_id  # type: str
        self.suit_info = suit_info  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaEnterpriseQuota, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.suit_info is not None:
            result['SuitInfo'] = self.suit_info
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SuitInfo') is not None:
            self.suit_info = m.get('SuitInfo')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaEventMonitor(TeaModel):
    def __init__(self, quota_limit=None, quota_package=None, quota_used=None):
        self.quota_limit = quota_limit  # type: int
        self.quota_package = quota_package  # type: int
        self.quota_used = quota_used  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaEventMonitor, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_limit is not None:
            result['QuotaLimit'] = self.quota_limit
        if self.quota_package is not None:
            result['QuotaPackage'] = self.quota_package
        if self.quota_used is not None:
            result['QuotaUsed'] = self.quota_used
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('QuotaLimit') is not None:
            self.quota_limit = m.get('QuotaLimit')
        if m.get('QuotaPackage') is not None:
            self.quota_package = m.get('QuotaPackage')
        if m.get('QuotaUsed') is not None:
            self.quota_used = m.get('QuotaUsed')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaLogMonitor(TeaModel):
    def __init__(self, quota_limit=None, quota_package=None, quota_used=None):
        self.quota_limit = quota_limit  # type: int
        self.quota_package = quota_package  # type: int
        self.quota_used = quota_used  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaLogMonitor, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_limit is not None:
            result['QuotaLimit'] = self.quota_limit
        if self.quota_package is not None:
            result['QuotaPackage'] = self.quota_package
        if self.quota_used is not None:
            result['QuotaUsed'] = self.quota_used
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('QuotaLimit') is not None:
            self.quota_limit = m.get('QuotaLimit')
        if m.get('QuotaPackage') is not None:
            self.quota_package = m.get('QuotaPackage')
        if m.get('QuotaUsed') is not None:
            self.quota_used = m.get('QuotaUsed')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaPhone(TeaModel):
    def __init__(self, quota_limit=None, quota_package=None, quota_used=None):
        self.quota_limit = quota_limit  # type: int
        self.quota_package = quota_package  # type: int
        self.quota_used = quota_used  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaPhone, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_limit is not None:
            result['QuotaLimit'] = self.quota_limit
        if self.quota_package is not None:
            result['QuotaPackage'] = self.quota_package
        if self.quota_used is not None:
            result['QuotaUsed'] = self.quota_used
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('QuotaLimit') is not None:
            self.quota_limit = m.get('QuotaLimit')
        if m.get('QuotaPackage') is not None:
            self.quota_package = m.get('QuotaPackage')
        if m.get('QuotaUsed') is not None:
            self.quota_used = m.get('QuotaUsed')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSMS(TeaModel):
    def __init__(self, quota_limit=None, quota_package=None, quota_used=None):
        self.quota_limit = quota_limit  # type: int
        self.quota_package = quota_package  # type: int
        self.quota_used = quota_used  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSMS, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_limit is not None:
            result['QuotaLimit'] = self.quota_limit
        if self.quota_package is not None:
            result['QuotaPackage'] = self.quota_package
        if self.quota_used is not None:
            result['QuotaUsed'] = self.quota_used
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('QuotaLimit') is not None:
            self.quota_limit = m.get('QuotaLimit')
        if m.get('QuotaPackage') is not None:
            self.quota_package = m.get('QuotaPackage')
        if m.get('QuotaUsed') is not None:
            self.quota_used = m.get('QuotaUsed')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorEcsProbe(TeaModel):
    def __init__(self, quota_limit=None, quota_package=None, quota_used=None):
        self.quota_limit = quota_limit  # type: int
        self.quota_package = quota_package  # type: int
        self.quota_used = quota_used  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorEcsProbe, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_limit is not None:
            result['QuotaLimit'] = self.quota_limit
        if self.quota_package is not None:
            result['QuotaPackage'] = self.quota_package
        if self.quota_used is not None:
            result['QuotaUsed'] = self.quota_used
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('QuotaLimit') is not None:
            self.quota_limit = m.get('QuotaLimit')
        if m.get('QuotaPackage') is not None:
            self.quota_package = m.get('QuotaPackage')
        if m.get('QuotaUsed') is not None:
            self.quota_used = m.get('QuotaUsed')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorOperatorProbe(TeaModel):
    def __init__(self, quota_limit=None, quota_package=None, quota_used=None):
        self.quota_limit = quota_limit  # type: int
        self.quota_package = quota_package  # type: int
        self.quota_used = quota_used  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorOperatorProbe, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_limit is not None:
            result['QuotaLimit'] = self.quota_limit
        if self.quota_package is not None:
            result['QuotaPackage'] = self.quota_package
        if self.quota_used is not None:
            result['QuotaUsed'] = self.quota_used
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('QuotaLimit') is not None:
            self.quota_limit = m.get('QuotaLimit')
        if m.get('QuotaPackage') is not None:
            self.quota_package = m.get('QuotaPackage')
        if m.get('QuotaUsed') is not None:
            self.quota_used = m.get('QuotaUsed')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorTask(TeaModel):
    def __init__(self, quota_limit=None, quota_package=None, quota_used=None):
        self.quota_limit = quota_limit  # type: int
        self.quota_package = quota_package  # type: int
        self.quota_used = quota_used  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorTask, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota_limit is not None:
            result['QuotaLimit'] = self.quota_limit
        if self.quota_package is not None:
            result['QuotaPackage'] = self.quota_package
        if self.quota_used is not None:
            result['QuotaUsed'] = self.quota_used
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('QuotaLimit') is not None:
            self.quota_limit = m.get('QuotaLimit')
        if m.get('QuotaPackage') is not None:
            self.quota_package = m.get('QuotaPackage')
        if m.get('QuotaUsed') is not None:
            self.quota_used = m.get('QuotaUsed')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuota(TeaModel):
    def __init__(self, api=None, custom_monitor=None, enterprise_quota=None, event_monitor=None, expire_time=None,
                 instance_id=None, log_monitor=None, phone=None, sms=None, site_monitor_ecs_probe=None,
                 site_monitor_operator_probe=None, site_monitor_task=None, suit_info=None):
        self.api = api  # type: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaApi
        self.custom_monitor = custom_monitor  # type: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaCustomMonitor
        self.enterprise_quota = enterprise_quota  # type: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaEnterpriseQuota
        self.event_monitor = event_monitor  # type: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaEventMonitor
        self.expire_time = expire_time  # type: str
        self.instance_id = instance_id  # type: str
        self.log_monitor = log_monitor  # type: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaLogMonitor
        self.phone = phone  # type: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaPhone
        self.sms = sms  # type: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSMS
        self.site_monitor_ecs_probe = site_monitor_ecs_probe  # type: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorEcsProbe
        self.site_monitor_operator_probe = site_monitor_operator_probe  # type: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorOperatorProbe
        self.site_monitor_task = site_monitor_task  # type: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorTask
        self.suit_info = suit_info  # type: str

    def validate(self):
        if self.api:
            self.api.validate()
        if self.custom_monitor:
            self.custom_monitor.validate()
        if self.enterprise_quota:
            self.enterprise_quota.validate()
        if self.event_monitor:
            self.event_monitor.validate()
        if self.log_monitor:
            self.log_monitor.validate()
        if self.phone:
            self.phone.validate()
        if self.sms:
            self.sms.validate()
        if self.site_monitor_ecs_probe:
            self.site_monitor_ecs_probe.validate()
        if self.site_monitor_operator_probe:
            self.site_monitor_operator_probe.validate()
        if self.site_monitor_task:
            self.site_monitor_task.validate()

    def to_map(self):
        _map = super(DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuota, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api is not None:
            result['Api'] = self.api.to_map()
        if self.custom_monitor is not None:
            result['CustomMonitor'] = self.custom_monitor.to_map()
        if self.enterprise_quota is not None:
            result['EnterpriseQuota'] = self.enterprise_quota.to_map()
        if self.event_monitor is not None:
            result['EventMonitor'] = self.event_monitor.to_map()
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.log_monitor is not None:
            result['LogMonitor'] = self.log_monitor.to_map()
        if self.phone is not None:
            result['Phone'] = self.phone.to_map()
        if self.sms is not None:
            result['SMS'] = self.sms.to_map()
        if self.site_monitor_ecs_probe is not None:
            result['SiteMonitorEcsProbe'] = self.site_monitor_ecs_probe.to_map()
        if self.site_monitor_operator_probe is not None:
            result['SiteMonitorOperatorProbe'] = self.site_monitor_operator_probe.to_map()
        if self.site_monitor_task is not None:
            result['SiteMonitorTask'] = self.site_monitor_task.to_map()
        if self.suit_info is not None:
            result['SuitInfo'] = self.suit_info
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Api') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaApi()
            self.api = temp_model.from_map(m['Api'])
        if m.get('CustomMonitor') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaCustomMonitor()
            self.custom_monitor = temp_model.from_map(m['CustomMonitor'])
        if m.get('EnterpriseQuota') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaEnterpriseQuota()
            self.enterprise_quota = temp_model.from_map(m['EnterpriseQuota'])
        if m.get('EventMonitor') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaEventMonitor()
            self.event_monitor = temp_model.from_map(m['EventMonitor'])
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LogMonitor') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaLogMonitor()
            self.log_monitor = temp_model.from_map(m['LogMonitor'])
        if m.get('Phone') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaPhone()
            self.phone = temp_model.from_map(m['Phone'])
        if m.get('SMS') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSMS()
            self.sms = temp_model.from_map(m['SMS'])
        if m.get('SiteMonitorEcsProbe') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorEcsProbe()
            self.site_monitor_ecs_probe = temp_model.from_map(m['SiteMonitorEcsProbe'])
        if m.get('SiteMonitorOperatorProbe') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorOperatorProbe()
            self.site_monitor_operator_probe = temp_model.from_map(m['SiteMonitorOperatorProbe'])
        if m.get('SiteMonitorTask') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuotaSiteMonitorTask()
            self.site_monitor_task = temp_model.from_map(m['SiteMonitorTask'])
        if m.get('SuitInfo') is not None:
            self.suit_info = m.get('SuitInfo')
        return self


class DescribeMonitorResourceQuotaAttributeResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, resource_quota=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.resource_quota = resource_quota  # type: DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuota

    def validate(self):
        if self.resource_quota:
            self.resource_quota.validate()

    def to_map(self):
        _map = super(DescribeMonitorResourceQuotaAttributeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_quota is not None:
            result['ResourceQuota'] = self.resource_quota.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceQuota') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBodyResourceQuota()
            self.resource_quota = temp_model.from_map(m['ResourceQuota'])
        return self


class DescribeMonitorResourceQuotaAttributeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMonitorResourceQuotaAttributeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMonitorResourceQuotaAttributeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitorResourceQuotaAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitoringAgentAccessKeyRequest(TeaModel):
    def __init__(self, region_id=None):
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitoringAgentAccessKeyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitoringAgentAccessKeyResponseBody(TeaModel):
    def __init__(self, access_key=None, code=None, message=None, request_id=None, secret_key=None, success=None):
        self.access_key = access_key  # type: str
        self.code = code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.secret_key = secret_key  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitoringAgentAccessKeyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key is not None:
            result['AccessKey'] = self.access_key
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.secret_key is not None:
            result['SecretKey'] = self.secret_key
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessKey') is not None:
            self.access_key = m.get('AccessKey')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecretKey') is not None:
            self.secret_key = m.get('SecretKey')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMonitoringAgentAccessKeyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMonitoringAgentAccessKeyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMonitoringAgentAccessKeyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitoringAgentAccessKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitoringAgentConfigRequest(TeaModel):
    def __init__(self, region_id=None):
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitoringAgentConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitoringAgentConfigResponseBody(TeaModel):
    def __init__(self, auto_install=None, code=None, enable_active_alert=None, enable_install_agent_new_ecs=None,
                 message=None, request_id=None, success=None):
        self.auto_install = auto_install  # type: bool
        self.code = code  # type: str
        self.enable_active_alert = enable_active_alert  # type: str
        self.enable_install_agent_new_ecs = enable_install_agent_new_ecs  # type: bool
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitoringAgentConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_install is not None:
            result['AutoInstall'] = self.auto_install
        if self.code is not None:
            result['Code'] = self.code
        if self.enable_active_alert is not None:
            result['EnableActiveAlert'] = self.enable_active_alert
        if self.enable_install_agent_new_ecs is not None:
            result['EnableInstallAgentNewECS'] = self.enable_install_agent_new_ecs
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoInstall') is not None:
            self.auto_install = m.get('AutoInstall')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EnableActiveAlert') is not None:
            self.enable_active_alert = m.get('EnableActiveAlert')
        if m.get('EnableInstallAgentNewECS') is not None:
            self.enable_install_agent_new_ecs = m.get('EnableInstallAgentNewECS')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMonitoringAgentConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMonitoringAgentConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMonitoringAgentConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitoringAgentConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitoringAgentHostsRequest(TeaModel):
    def __init__(self, aliyun_host=None, host_name=None, instance_ids=None, instance_region_id=None, key_word=None,
                 page_number=None, page_size=None, region_id=None, serial_numbers=None, status=None):
        self.aliyun_host = aliyun_host  # type: bool
        self.host_name = host_name  # type: str
        self.instance_ids = instance_ids  # type: str
        self.instance_region_id = instance_region_id  # type: str
        self.key_word = key_word  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.serial_numbers = serial_numbers  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitoringAgentHostsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aliyun_host is not None:
            result['AliyunHost'] = self.aliyun_host
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.instance_region_id is not None:
            result['InstanceRegionId'] = self.instance_region_id
        if self.key_word is not None:
            result['KeyWord'] = self.key_word
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.serial_numbers is not None:
            result['SerialNumbers'] = self.serial_numbers
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliyunHost') is not None:
            self.aliyun_host = m.get('AliyunHost')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('InstanceRegionId') is not None:
            self.instance_region_id = m.get('InstanceRegionId')
        if m.get('KeyWord') is not None:
            self.key_word = m.get('KeyWord')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SerialNumbers') is not None:
            self.serial_numbers = m.get('SerialNumbers')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeMonitoringAgentHostsResponseBodyHostsHost(TeaModel):
    def __init__(self, agent_version=None, ali_uid=None, eip_address=None, eip_id=None, host_name=None,
                 instance_id=None, instance_type_family=None, ip_group=None, nat_ip=None, network_type=None,
                 operating_system=None, region=None, serial_number=None, is_aliyun_host=None):
        self.agent_version = agent_version  # type: str
        self.ali_uid = ali_uid  # type: long
        self.eip_address = eip_address  # type: str
        self.eip_id = eip_id  # type: str
        self.host_name = host_name  # type: str
        self.instance_id = instance_id  # type: str
        self.instance_type_family = instance_type_family  # type: str
        self.ip_group = ip_group  # type: str
        self.nat_ip = nat_ip  # type: str
        self.network_type = network_type  # type: str
        self.operating_system = operating_system  # type: str
        self.region = region  # type: str
        self.serial_number = serial_number  # type: str
        self.is_aliyun_host = is_aliyun_host  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitoringAgentHostsResponseBodyHostsHost, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_version is not None:
            result['AgentVersion'] = self.agent_version
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.eip_address is not None:
            result['EipAddress'] = self.eip_address
        if self.eip_id is not None:
            result['EipId'] = self.eip_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type_family is not None:
            result['InstanceTypeFamily'] = self.instance_type_family
        if self.ip_group is not None:
            result['IpGroup'] = self.ip_group
        if self.nat_ip is not None:
            result['NatIp'] = self.nat_ip
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.operating_system is not None:
            result['OperatingSystem'] = self.operating_system
        if self.region is not None:
            result['Region'] = self.region
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.is_aliyun_host is not None:
            result['isAliyunHost'] = self.is_aliyun_host
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentVersion') is not None:
            self.agent_version = m.get('AgentVersion')
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('EipAddress') is not None:
            self.eip_address = m.get('EipAddress')
        if m.get('EipId') is not None:
            self.eip_id = m.get('EipId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceTypeFamily') is not None:
            self.instance_type_family = m.get('InstanceTypeFamily')
        if m.get('IpGroup') is not None:
            self.ip_group = m.get('IpGroup')
        if m.get('NatIp') is not None:
            self.nat_ip = m.get('NatIp')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('OperatingSystem') is not None:
            self.operating_system = m.get('OperatingSystem')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('isAliyunHost') is not None:
            self.is_aliyun_host = m.get('isAliyunHost')
        return self


class DescribeMonitoringAgentHostsResponseBodyHosts(TeaModel):
    def __init__(self, host=None):
        self.host = host  # type: list[DescribeMonitoringAgentHostsResponseBodyHostsHost]

    def validate(self):
        if self.host:
            for k in self.host:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMonitoringAgentHostsResponseBodyHosts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Host'] = []
        if self.host is not None:
            for k in self.host:
                result['Host'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.host = []
        if m.get('Host') is not None:
            for k in m.get('Host'):
                temp_model = DescribeMonitoringAgentHostsResponseBodyHostsHost()
                self.host.append(temp_model.from_map(k))
        return self


class DescribeMonitoringAgentHostsResponseBody(TeaModel):
    def __init__(self, code=None, hosts=None, message=None, page_number=None, page_size=None, page_total=None,
                 request_id=None, success=None, total=None):
        self.code = code  # type: str
        self.hosts = hosts  # type: DescribeMonitoringAgentHostsResponseBodyHosts
        self.message = message  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.page_total = page_total  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: int

    def validate(self):
        if self.hosts:
            self.hosts.validate()

    def to_map(self):
        _map = super(DescribeMonitoringAgentHostsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.hosts is not None:
            result['Hosts'] = self.hosts.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_total is not None:
            result['PageTotal'] = self.page_total
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Hosts') is not None:
            temp_model = DescribeMonitoringAgentHostsResponseBodyHosts()
            self.hosts = temp_model.from_map(m['Hosts'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageTotal') is not None:
            self.page_total = m.get('PageTotal')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeMonitoringAgentHostsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMonitoringAgentHostsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMonitoringAgentHostsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitoringAgentHostsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitoringAgentProcessesRequest(TeaModel):
    def __init__(self, instance_id=None, region_id=None):
        self.instance_id = instance_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitoringAgentProcessesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitoringAgentProcessesResponseBodyNodeProcessesNodeProcess(TeaModel):
    def __init__(self, command=None, group_id=None, instance_id=None, process_id=None, process_name=None,
                 process_user=None):
        self.command = command  # type: str
        self.group_id = group_id  # type: str
        self.instance_id = instance_id  # type: str
        self.process_id = process_id  # type: long
        self.process_name = process_name  # type: str
        self.process_user = process_user  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitoringAgentProcessesResponseBodyNodeProcessesNodeProcess, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command is not None:
            result['Command'] = self.command
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        if self.process_user is not None:
            result['ProcessUser'] = self.process_user
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        if m.get('ProcessUser') is not None:
            self.process_user = m.get('ProcessUser')
        return self


class DescribeMonitoringAgentProcessesResponseBodyNodeProcesses(TeaModel):
    def __init__(self, node_process=None):
        self.node_process = node_process  # type: list[DescribeMonitoringAgentProcessesResponseBodyNodeProcessesNodeProcess]

    def validate(self):
        if self.node_process:
            for k in self.node_process:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMonitoringAgentProcessesResponseBodyNodeProcesses, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NodeProcess'] = []
        if self.node_process is not None:
            for k in self.node_process:
                result['NodeProcess'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.node_process = []
        if m.get('NodeProcess') is not None:
            for k in m.get('NodeProcess'):
                temp_model = DescribeMonitoringAgentProcessesResponseBodyNodeProcessesNodeProcess()
                self.node_process.append(temp_model.from_map(k))
        return self


class DescribeMonitoringAgentProcessesResponseBody(TeaModel):
    def __init__(self, code=None, message=None, node_processes=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.node_processes = node_processes  # type: DescribeMonitoringAgentProcessesResponseBodyNodeProcesses
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.node_processes:
            self.node_processes.validate()

    def to_map(self):
        _map = super(DescribeMonitoringAgentProcessesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.node_processes is not None:
            result['NodeProcesses'] = self.node_processes.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NodeProcesses') is not None:
            temp_model = DescribeMonitoringAgentProcessesResponseBodyNodeProcesses()
            self.node_processes = temp_model.from_map(m['NodeProcesses'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMonitoringAgentProcessesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMonitoringAgentProcessesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMonitoringAgentProcessesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitoringAgentProcessesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitoringAgentStatusesRequest(TeaModel):
    def __init__(self, instance_ids=None, region_id=None):
        self.instance_ids = instance_ids  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitoringAgentStatusesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitoringAgentStatusesResponseBodyNodeStatusListNodeStatus(TeaModel):
    def __init__(self, auto_install=None, instance_id=None, status=None):
        self.auto_install = auto_install  # type: bool
        self.instance_id = instance_id  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitoringAgentStatusesResponseBodyNodeStatusListNodeStatus, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_install is not None:
            result['AutoInstall'] = self.auto_install
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoInstall') is not None:
            self.auto_install = m.get('AutoInstall')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeMonitoringAgentStatusesResponseBodyNodeStatusList(TeaModel):
    def __init__(self, node_status=None):
        self.node_status = node_status  # type: list[DescribeMonitoringAgentStatusesResponseBodyNodeStatusListNodeStatus]

    def validate(self):
        if self.node_status:
            for k in self.node_status:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeMonitoringAgentStatusesResponseBodyNodeStatusList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NodeStatus'] = []
        if self.node_status is not None:
            for k in self.node_status:
                result['NodeStatus'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.node_status = []
        if m.get('NodeStatus') is not None:
            for k in m.get('NodeStatus'):
                temp_model = DescribeMonitoringAgentStatusesResponseBodyNodeStatusListNodeStatus()
                self.node_status.append(temp_model.from_map(k))
        return self


class DescribeMonitoringAgentStatusesResponseBody(TeaModel):
    def __init__(self, code=None, message=None, node_status_list=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.node_status_list = node_status_list  # type: DescribeMonitoringAgentStatusesResponseBodyNodeStatusList
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.node_status_list:
            self.node_status_list.validate()

    def to_map(self):
        _map = super(DescribeMonitoringAgentStatusesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.node_status_list is not None:
            result['NodeStatusList'] = self.node_status_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NodeStatusList') is not None:
            temp_model = DescribeMonitoringAgentStatusesResponseBodyNodeStatusList()
            self.node_status_list = temp_model.from_map(m['NodeStatusList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMonitoringAgentStatusesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMonitoringAgentStatusesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMonitoringAgentStatusesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitoringAgentStatusesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMonitoringConfigRequest(TeaModel):
    def __init__(self, region_id=None):
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitoringConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeMonitoringConfigResponseBody(TeaModel):
    def __init__(self, auto_install=None, code=None, enable_install_agent_new_ecs=None, message=None,
                 request_id=None, success=None):
        self.auto_install = auto_install  # type: bool
        self.code = code  # type: str
        self.enable_install_agent_new_ecs = enable_install_agent_new_ecs  # type: bool
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeMonitoringConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_install is not None:
            result['AutoInstall'] = self.auto_install
        if self.code is not None:
            result['Code'] = self.code
        if self.enable_install_agent_new_ecs is not None:
            result['EnableInstallAgentNewECS'] = self.enable_install_agent_new_ecs
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoInstall') is not None:
            self.auto_install = m.get('AutoInstall')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EnableInstallAgentNewECS') is not None:
            self.enable_install_agent_new_ecs = m.get('EnableInstallAgentNewECS')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeMonitoringConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeMonitoringConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeMonitoringConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMonitoringConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeProductResourceTagKeyListRequest(TeaModel):
    def __init__(self, next_token=None, region_id=None):
        self.next_token = next_token  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeProductResourceTagKeyListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeProductResourceTagKeyListResponseBodyTagKeys(TeaModel):
    def __init__(self, tag_key=None):
        self.tag_key = tag_key  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeProductResourceTagKeyListResponseBodyTagKeys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class DescribeProductResourceTagKeyListResponseBody(TeaModel):
    def __init__(self, code=None, message=None, next_token=None, request_id=None, success=None, tag_keys=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.next_token = next_token  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.tag_keys = tag_keys  # type: DescribeProductResourceTagKeyListResponseBodyTagKeys

    def validate(self):
        if self.tag_keys:
            self.tag_keys.validate()

    def to_map(self):
        _map = super(DescribeProductResourceTagKeyListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.tag_keys is not None:
            result['TagKeys'] = self.tag_keys.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TagKeys') is not None:
            temp_model = DescribeProductResourceTagKeyListResponseBodyTagKeys()
            self.tag_keys = temp_model.from_map(m['TagKeys'])
        return self


class DescribeProductResourceTagKeyListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeProductResourceTagKeyListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeProductResourceTagKeyListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeProductResourceTagKeyListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeProductsOfActiveMetricRuleRequest(TeaModel):
    def __init__(self, region_id=None):
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeProductsOfActiveMetricRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRuleAlertInitConfigListAlertInitConfig(TeaModel):
    def __init__(self, evaluation_count=None, metric_name=None, namespace=None, period=None, statistics=None,
                 threshold=None):
        self.evaluation_count = evaluation_count  # type: str
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.period = period  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRuleAlertInitConfigListAlertInitConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.period is not None:
            result['Period'] = self.period
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRuleAlertInitConfigList(TeaModel):
    def __init__(self, alert_init_config=None):
        self.alert_init_config = alert_init_config  # type: list[DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRuleAlertInitConfigListAlertInitConfig]

    def validate(self):
        if self.alert_init_config:
            for k in self.alert_init_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRuleAlertInitConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertInitConfig'] = []
        if self.alert_init_config is not None:
            for k in self.alert_init_config:
                result['AlertInitConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.alert_init_config = []
        if m.get('AlertInitConfig') is not None:
            for k in m.get('AlertInitConfig'):
                temp_model = DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRuleAlertInitConfigListAlertInitConfig()
                self.alert_init_config.append(temp_model.from_map(k))
        return self


class DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRule(TeaModel):
    def __init__(self, alert_init_config_list=None, product=None):
        self.alert_init_config_list = alert_init_config_list  # type: DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRuleAlertInitConfigList
        self.product = product  # type: str

    def validate(self):
        if self.alert_init_config_list:
            self.alert_init_config_list.validate()

    def to_map(self):
        _map = super(DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_init_config_list is not None:
            result['AlertInitConfigList'] = self.alert_init_config_list.to_map()
        if self.product is not None:
            result['Product'] = self.product
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AlertInitConfigList') is not None:
            temp_model = DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRuleAlertInitConfigList()
            self.alert_init_config_list = temp_model.from_map(m['AlertInitConfigList'])
        if m.get('Product') is not None:
            self.product = m.get('Product')
        return self


class DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleList(TeaModel):
    def __init__(self, all_product_init_metric_rule=None):
        self.all_product_init_metric_rule = all_product_init_metric_rule  # type: list[DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRule]

    def validate(self):
        if self.all_product_init_metric_rule:
            for k in self.all_product_init_metric_rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AllProductInitMetricRule'] = []
        if self.all_product_init_metric_rule is not None:
            for k in self.all_product_init_metric_rule:
                result['AllProductInitMetricRule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.all_product_init_metric_rule = []
        if m.get('AllProductInitMetricRule') is not None:
            for k in m.get('AllProductInitMetricRule'):
                temp_model = DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleListAllProductInitMetricRule()
                self.all_product_init_metric_rule.append(temp_model.from_map(k))
        return self


class DescribeProductsOfActiveMetricRuleResponseBody(TeaModel):
    def __init__(self, all_product_init_metric_rule_list=None, code=None, datapoints=None, message=None,
                 request_id=None, success=None):
        self.all_product_init_metric_rule_list = all_product_init_metric_rule_list  # type: DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleList
        self.code = code  # type: int
        self.datapoints = datapoints  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.all_product_init_metric_rule_list:
            self.all_product_init_metric_rule_list.validate()

    def to_map(self):
        _map = super(DescribeProductsOfActiveMetricRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_product_init_metric_rule_list is not None:
            result['AllProductInitMetricRuleList'] = self.all_product_init_metric_rule_list.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.datapoints is not None:
            result['Datapoints'] = self.datapoints
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllProductInitMetricRuleList') is not None:
            temp_model = DescribeProductsOfActiveMetricRuleResponseBodyAllProductInitMetricRuleList()
            self.all_product_init_metric_rule_list = temp_model.from_map(m['AllProductInitMetricRuleList'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Datapoints') is not None:
            self.datapoints = m.get('Datapoints')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeProductsOfActiveMetricRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeProductsOfActiveMetricRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeProductsOfActiveMetricRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeProductsOfActiveMetricRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeProjectMetaRequest(TeaModel):
    def __init__(self, labels=None, page_number=None, page_size=None):
        self.labels = labels  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeProjectMetaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeProjectMetaResponseBodyResourcesResource(TeaModel):
    def __init__(self, description=None, labels=None, namespace=None):
        self.description = description  # type: str
        self.labels = labels  # type: str
        self.namespace = namespace  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeProjectMetaResponseBodyResourcesResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        return self


class DescribeProjectMetaResponseBodyResources(TeaModel):
    def __init__(self, resource=None):
        self.resource = resource  # type: list[DescribeProjectMetaResponseBodyResourcesResource]

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeProjectMetaResponseBodyResources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeProjectMetaResponseBodyResourcesResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeProjectMetaResponseBody(TeaModel):
    def __init__(self, code=None, message=None, page_number=None, page_size=None, request_id=None, resources=None,
                 success=None, total=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.request_id = request_id  # type: str
        self.resources = resources  # type: DescribeProjectMetaResponseBodyResources
        self.success = success  # type: bool
        self.total = total  # type: str

    def validate(self):
        if self.resources:
            self.resources.validate()

    def to_map(self):
        _map = super(DescribeProjectMetaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Resources') is not None:
            temp_model = DescribeProjectMetaResponseBodyResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeProjectMetaResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeProjectMetaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeProjectMetaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeProjectMetaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSiteMonitorAttributeRequest(TeaModel):
    def __init__(self, include_alert=None, region_id=None, task_id=None):
        self.include_alert = include_alert  # type: bool
        self.region_id = region_id  # type: str
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSiteMonitorAttributeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.include_alert is not None:
            result['IncludeAlert'] = self.include_alert
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IncludeAlert') is not None:
            self.include_alert = m.get('IncludeAlert')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeSiteMonitorAttributeResponseBodyMetricRulesMetricRule(TeaModel):
    def __init__(self, action_enable=None, alarm_actions=None, comparison_operator=None, dimensions=None,
                 evaluation_count=None, expression=None, level=None, metric_name=None, namespace=None, ok_actions=None, period=None,
                 rule_id=None, rule_name=None, state_value=None, statistics=None, threshold=None):
        self.action_enable = action_enable  # type: str
        self.alarm_actions = alarm_actions  # type: str
        self.comparison_operator = comparison_operator  # type: str
        self.dimensions = dimensions  # type: str
        self.evaluation_count = evaluation_count  # type: str
        self.expression = expression  # type: str
        self.level = level  # type: str
        self.metric_name = metric_name  # type: str
        self.namespace = namespace  # type: str
        self.ok_actions = ok_actions  # type: str
        self.period = period  # type: str
        self.rule_id = rule_id  # type: str
        self.rule_name = rule_name  # type: str
        self.state_value = state_value  # type: str
        self.statistics = statistics  # type: str
        self.threshold = threshold  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSiteMonitorAttributeResponseBodyMetricRulesMetricRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_enable is not None:
            result['ActionEnable'] = self.action_enable
        if self.alarm_actions is not None:
            result['AlarmActions'] = self.alarm_actions
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.dimensions is not None:
            result['Dimensions'] = self.dimensions
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.level is not None:
            result['Level'] = self.level
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.ok_actions is not None:
            result['OkActions'] = self.ok_actions
        if self.period is not None:
            result['Period'] = self.period
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.state_value is not None:
            result['StateValue'] = self.state_value
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActionEnable') is not None:
            self.action_enable = m.get('ActionEnable')
        if m.get('AlarmActions') is not None:
            self.alarm_actions = m.get('AlarmActions')
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Dimensions') is not None:
            self.dimensions = m.get('Dimensions')
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('OkActions') is not None:
            self.ok_actions = m.get('OkActions')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('StateValue') is not None:
            self.state_value = m.get('StateValue')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class DescribeSiteMonitorAttributeResponseBodyMetricRules(TeaModel):
    def __init__(self, metric_rule=None):
        self.metric_rule = metric_rule  # type: list[DescribeSiteMonitorAttributeResponseBodyMetricRulesMetricRule]

    def validate(self):
        if self.metric_rule:
            for k in self.metric_rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSiteMonitorAttributeResponseBodyMetricRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MetricRule'] = []
        if self.metric_rule is not None:
            for k in self.metric_rule:
                result['MetricRule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.metric_rule = []
        if m.get('MetricRule') is not None:
            for k in m.get('MetricRule'):
                temp_model = DescribeSiteMonitorAttributeResponseBodyMetricRulesMetricRule()
                self.metric_rule.append(temp_model.from_map(k))
        return self


class DescribeSiteMonitorAttributeResponseBodySiteMonitorsIspCitiesIspCity(TeaModel):
    def __init__(self, city=None, city_name=None, isp=None, isp_name=None):
        self.city = city  # type: str
        self.city_name = city_name  # type: str
        self.isp = isp  # type: str
        self.isp_name = isp_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSiteMonitorAttributeResponseBodySiteMonitorsIspCitiesIspCity, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city is not None:
            result['City'] = self.city
        if self.city_name is not None:
            result['CityName'] = self.city_name
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.isp_name is not None:
            result['IspName'] = self.isp_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('CityName') is not None:
            self.city_name = m.get('CityName')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('IspName') is not None:
            self.isp_name = m.get('IspName')
        return self


class DescribeSiteMonitorAttributeResponseBodySiteMonitorsIspCities(TeaModel):
    def __init__(self, isp_city=None):
        self.isp_city = isp_city  # type: list[DescribeSiteMonitorAttributeResponseBodySiteMonitorsIspCitiesIspCity]

    def validate(self):
        if self.isp_city:
            for k in self.isp_city:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSiteMonitorAttributeResponseBodySiteMonitorsIspCities, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['IspCity'] = []
        if self.isp_city is not None:
            for k in self.isp_city:
                result['IspCity'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.isp_city = []
        if m.get('IspCity') is not None:
            for k in m.get('IspCity'):
                temp_model = DescribeSiteMonitorAttributeResponseBodySiteMonitorsIspCitiesIspCity()
                self.isp_city.append(temp_model.from_map(k))
        return self


class DescribeSiteMonitorAttributeResponseBodySiteMonitorsOptionJson(TeaModel):
    def __init__(self, attempts=None, authentication=None, cookie=None, dns_match_rule=None, dns_server=None,
                 dns_type=None, expect_value=None, failure_rate=None, header=None, http_method=None, is_base_64encode=None,
                 match_rule=None, password=None, ping_num=None, port=None, protocol=None, request_content=None,
                 request_format=None, response_content=None, response_format=None, time_out=None, username=None):
        self.attempts = attempts  # type: long
        self.authentication = authentication  # type: int
        self.cookie = cookie  # type: str
        self.dns_match_rule = dns_match_rule  # type: str
        self.dns_server = dns_server  # type: str
        self.dns_type = dns_type  # type: str
        self.expect_value = expect_value  # type: str
        self.failure_rate = failure_rate  # type: float
        self.header = header  # type: str
        self.http_method = http_method  # type: str
        self.is_base_64encode = is_base_64encode  # type: str
        self.match_rule = match_rule  # type: int
        self.password = password  # type: str
        self.ping_num = ping_num  # type: int
        self.port = port  # type: int
        self.protocol = protocol  # type: str
        self.request_content = request_content  # type: str
        self.request_format = request_format  # type: str
        self.response_content = response_content  # type: str
        self.response_format = response_format  # type: str
        self.time_out = time_out  # type: long
        self.username = username  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSiteMonitorAttributeResponseBodySiteMonitorsOptionJson, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attempts is not None:
            result['attempts'] = self.attempts
        if self.authentication is not None:
            result['authentication'] = self.authentication
        if self.cookie is not None:
            result['cookie'] = self.cookie
        if self.dns_match_rule is not None:
            result['dns_match_rule'] = self.dns_match_rule
        if self.dns_server is not None:
            result['dns_server'] = self.dns_server
        if self.dns_type is not None:
            result['dns_type'] = self.dns_type
        if self.expect_value is not None:
            result['expect_value'] = self.expect_value
        if self.failure_rate is not None:
            result['failure_rate'] = self.failure_rate
        if self.header is not None:
            result['header'] = self.header
        if self.http_method is not None:
            result['http_method'] = self.http_method
        if self.is_base_64encode is not None:
            result['isBase64Encode'] = self.is_base_64encode
        if self.match_rule is not None:
            result['match_rule'] = self.match_rule
        if self.password is not None:
            result['password'] = self.password
        if self.ping_num is not None:
            result['ping_num'] = self.ping_num
        if self.port is not None:
            result['port'] = self.port
        if self.protocol is not None:
            result['protocol'] = self.protocol
        if self.request_content is not None:
            result['request_content'] = self.request_content
        if self.request_format is not None:
            result['request_format'] = self.request_format
        if self.response_content is not None:
            result['response_content'] = self.response_content
        if self.response_format is not None:
            result['response_format'] = self.response_format
        if self.time_out is not None:
            result['time_out'] = self.time_out
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('attempts') is not None:
            self.attempts = m.get('attempts')
        if m.get('authentication') is not None:
            self.authentication = m.get('authentication')
        if m.get('cookie') is not None:
            self.cookie = m.get('cookie')
        if m.get('dns_match_rule') is not None:
            self.dns_match_rule = m.get('dns_match_rule')
        if m.get('dns_server') is not None:
            self.dns_server = m.get('dns_server')
        if m.get('dns_type') is not None:
            self.dns_type = m.get('dns_type')
        if m.get('expect_value') is not None:
            self.expect_value = m.get('expect_value')
        if m.get('failure_rate') is not None:
            self.failure_rate = m.get('failure_rate')
        if m.get('header') is not None:
            self.header = m.get('header')
        if m.get('http_method') is not None:
            self.http_method = m.get('http_method')
        if m.get('isBase64Encode') is not None:
            self.is_base_64encode = m.get('isBase64Encode')
        if m.get('match_rule') is not None:
            self.match_rule = m.get('match_rule')
        if m.get('password') is not None:
            self.password = m.get('password')
        if m.get('ping_num') is not None:
            self.ping_num = m.get('ping_num')
        if m.get('port') is not None:
            self.port = m.get('port')
        if m.get('protocol') is not None:
            self.protocol = m.get('protocol')
        if m.get('request_content') is not None:
            self.request_content = m.get('request_content')
        if m.get('request_format') is not None:
            self.request_format = m.get('request_format')
        if m.get('response_content') is not None:
            self.response_content = m.get('response_content')
        if m.get('response_format') is not None:
            self.response_format = m.get('response_format')
        if m.get('time_out') is not None:
            self.time_out = m.get('time_out')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class DescribeSiteMonitorAttributeResponseBodySiteMonitors(TeaModel):
    def __init__(self, address=None, interval=None, isp_cities=None, option_json=None, task_id=None, task_name=None,
                 task_state=None, task_type=None):
        self.address = address  # type: str
        self.interval = interval  # type: str
        self.isp_cities = isp_cities  # type: DescribeSiteMonitorAttributeResponseBodySiteMonitorsIspCities
        self.option_json = option_json  # type: DescribeSiteMonitorAttributeResponseBodySiteMonitorsOptionJson
        self.task_id = task_id  # type: str
        self.task_name = task_name  # type: str
        self.task_state = task_state  # type: str
        self.task_type = task_type  # type: str

    def validate(self):
        if self.isp_cities:
            self.isp_cities.validate()
        if self.option_json:
            self.option_json.validate()

    def to_map(self):
        _map = super(DescribeSiteMonitorAttributeResponseBodySiteMonitors, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_cities is not None:
            result['IspCities'] = self.isp_cities.to_map()
        if self.option_json is not None:
            result['OptionJson'] = self.option_json.to_map()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspCities') is not None:
            temp_model = DescribeSiteMonitorAttributeResponseBodySiteMonitorsIspCities()
            self.isp_cities = temp_model.from_map(m['IspCities'])
        if m.get('OptionJson') is not None:
            temp_model = DescribeSiteMonitorAttributeResponseBodySiteMonitorsOptionJson()
            self.option_json = temp_model.from_map(m['OptionJson'])
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeSiteMonitorAttributeResponseBody(TeaModel):
    def __init__(self, code=None, message=None, metric_rules=None, request_id=None, site_monitors=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.metric_rules = metric_rules  # type: DescribeSiteMonitorAttributeResponseBodyMetricRules
        self.request_id = request_id  # type: str
        self.site_monitors = site_monitors  # type: DescribeSiteMonitorAttributeResponseBodySiteMonitors
        self.success = success  # type: bool

    def validate(self):
        if self.metric_rules:
            self.metric_rules.validate()
        if self.site_monitors:
            self.site_monitors.validate()

    def to_map(self):
        _map = super(DescribeSiteMonitorAttributeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.metric_rules is not None:
            result['MetricRules'] = self.metric_rules.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_monitors is not None:
            result['SiteMonitors'] = self.site_monitors.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MetricRules') is not None:
            temp_model = DescribeSiteMonitorAttributeResponseBodyMetricRules()
            self.metric_rules = temp_model.from_map(m['MetricRules'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteMonitors') is not None:
            temp_model = DescribeSiteMonitorAttributeResponseBodySiteMonitors()
            self.site_monitors = temp_model.from_map(m['SiteMonitors'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSiteMonitorAttributeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeSiteMonitorAttributeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSiteMonitorAttributeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSiteMonitorAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSiteMonitorDataRequest(TeaModel):
    def __init__(self, end_time=None, length=None, metric_name=None, next_token=None, period=None, region_id=None,
                 start_time=None, task_id=None, type=None):
        self.end_time = end_time  # type: str
        self.length = length  # type: int
        self.metric_name = metric_name  # type: str
        self.next_token = next_token  # type: str
        self.period = period  # type: str
        self.region_id = region_id  # type: str
        self.start_time = start_time  # type: str
        self.task_id = task_id  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSiteMonitorDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.length is not None:
            result['Length'] = self.length
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeSiteMonitorDataResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, next_token=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.next_token = next_token  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSiteMonitorDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSiteMonitorDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeSiteMonitorDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSiteMonitorDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSiteMonitorDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSiteMonitorISPCityListRequest(TeaModel):
    def __init__(self, city=None, ipv4=None, ipv6=None, isp=None, region_id=None):
        self.city = city  # type: str
        self.ipv4 = ipv4  # type: bool
        self.ipv6 = ipv6  # type: bool
        self.isp = isp  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSiteMonitorISPCityListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city is not None:
            result['City'] = self.city
        if self.ipv4 is not None:
            result['IPV4'] = self.ipv4
        if self.ipv6 is not None:
            result['IPV6'] = self.ipv6
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('IPV4') is not None:
            self.ipv4 = m.get('IPV4')
        if m.get('IPV6') is not None:
            self.ipv6 = m.get('IPV6')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeSiteMonitorISPCityListResponseBodyIspCityListIspCityIPPool(TeaModel):
    def __init__(self, ippool=None):
        self.ippool = ippool  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSiteMonitorISPCityListResponseBodyIspCityListIspCityIPPool, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ippool is not None:
            result['IPPool'] = self.ippool
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IPPool') is not None:
            self.ippool = m.get('IPPool')
        return self


class DescribeSiteMonitorISPCityListResponseBodyIspCityListIspCity(TeaModel):
    def __init__(self, area_en=None, area_zh_c_n=None, city=None, city_name_en=None, city_name_zh_c_n=None,
                 country=None, country_en=None, country_zh_c_n=None, ippool=None, ipv4probe_count=None,
                 ipv6probe_count=None, isp=None, isp_name_en=None, isp_name_zh_c_n=None, region=None, region_en=None,
                 region_zh_c_n=None):
        self.area_en = area_en  # type: str
        self.area_zh_c_n = area_zh_c_n  # type: str
        self.city = city  # type: str
        self.city_name_en = city_name_en  # type: str
        self.city_name_zh_c_n = city_name_zh_c_n  # type: str
        self.country = country  # type: str
        self.country_en = country_en  # type: str
        self.country_zh_c_n = country_zh_c_n  # type: str
        self.ippool = ippool  # type: DescribeSiteMonitorISPCityListResponseBodyIspCityListIspCityIPPool
        self.ipv4probe_count = ipv4probe_count  # type: str
        self.ipv6probe_count = ipv6probe_count  # type: str
        self.isp = isp  # type: str
        self.isp_name_en = isp_name_en  # type: str
        self.isp_name_zh_c_n = isp_name_zh_c_n  # type: str
        self.region = region  # type: str
        self.region_en = region_en  # type: str
        self.region_zh_c_n = region_zh_c_n  # type: str

    def validate(self):
        if self.ippool:
            self.ippool.validate()

    def to_map(self):
        _map = super(DescribeSiteMonitorISPCityListResponseBodyIspCityListIspCity, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.area_en is not None:
            result['Area.en'] = self.area_en
        if self.area_zh_c_n is not None:
            result['Area.zh_CN'] = self.area_zh_c_n
        if self.city is not None:
            result['City'] = self.city
        if self.city_name_en is not None:
            result['CityName.en'] = self.city_name_en
        if self.city_name_zh_c_n is not None:
            result['CityName.zh_CN'] = self.city_name_zh_c_n
        if self.country is not None:
            result['Country'] = self.country
        if self.country_en is not None:
            result['Country.en'] = self.country_en
        if self.country_zh_c_n is not None:
            result['Country.zh_CN'] = self.country_zh_c_n
        if self.ippool is not None:
            result['IPPool'] = self.ippool.to_map()
        if self.ipv4probe_count is not None:
            result['IPV4ProbeCount'] = self.ipv4probe_count
        if self.ipv6probe_count is not None:
            result['IPV6ProbeCount'] = self.ipv6probe_count
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.isp_name_en is not None:
            result['IspName.en'] = self.isp_name_en
        if self.isp_name_zh_c_n is not None:
            result['IspName.zh_CN'] = self.isp_name_zh_c_n
        if self.region is not None:
            result['Region'] = self.region
        if self.region_en is not None:
            result['Region.en'] = self.region_en
        if self.region_zh_c_n is not None:
            result['Region.zh_CN'] = self.region_zh_c_n
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Area.en') is not None:
            self.area_en = m.get('Area.en')
        if m.get('Area.zh_CN') is not None:
            self.area_zh_c_n = m.get('Area.zh_CN')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('CityName.en') is not None:
            self.city_name_en = m.get('CityName.en')
        if m.get('CityName.zh_CN') is not None:
            self.city_name_zh_c_n = m.get('CityName.zh_CN')
        if m.get('Country') is not None:
            self.country = m.get('Country')
        if m.get('Country.en') is not None:
            self.country_en = m.get('Country.en')
        if m.get('Country.zh_CN') is not None:
            self.country_zh_c_n = m.get('Country.zh_CN')
        if m.get('IPPool') is not None:
            temp_model = DescribeSiteMonitorISPCityListResponseBodyIspCityListIspCityIPPool()
            self.ippool = temp_model.from_map(m['IPPool'])
        if m.get('IPV4ProbeCount') is not None:
            self.ipv4probe_count = m.get('IPV4ProbeCount')
        if m.get('IPV6ProbeCount') is not None:
            self.ipv6probe_count = m.get('IPV6ProbeCount')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('IspName.en') is not None:
            self.isp_name_en = m.get('IspName.en')
        if m.get('IspName.zh_CN') is not None:
            self.isp_name_zh_c_n = m.get('IspName.zh_CN')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Region.en') is not None:
            self.region_en = m.get('Region.en')
        if m.get('Region.zh_CN') is not None:
            self.region_zh_c_n = m.get('Region.zh_CN')
        return self


class DescribeSiteMonitorISPCityListResponseBodyIspCityList(TeaModel):
    def __init__(self, isp_city=None):
        self.isp_city = isp_city  # type: list[DescribeSiteMonitorISPCityListResponseBodyIspCityListIspCity]

    def validate(self):
        if self.isp_city:
            for k in self.isp_city:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSiteMonitorISPCityListResponseBodyIspCityList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['IspCity'] = []
        if self.isp_city is not None:
            for k in self.isp_city:
                result['IspCity'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.isp_city = []
        if m.get('IspCity') is not None:
            for k in m.get('IspCity'):
                temp_model = DescribeSiteMonitorISPCityListResponseBodyIspCityListIspCity()
                self.isp_city.append(temp_model.from_map(k))
        return self


class DescribeSiteMonitorISPCityListResponseBody(TeaModel):
    def __init__(self, code=None, isp_city_list=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.isp_city_list = isp_city_list  # type: DescribeSiteMonitorISPCityListResponseBodyIspCityList
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.isp_city_list:
            self.isp_city_list.validate()

    def to_map(self):
        _map = super(DescribeSiteMonitorISPCityListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.isp_city_list is not None:
            result['IspCityList'] = self.isp_city_list.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('IspCityList') is not None:
            temp_model = DescribeSiteMonitorISPCityListResponseBodyIspCityList()
            self.isp_city_list = temp_model.from_map(m['IspCityList'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSiteMonitorISPCityListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeSiteMonitorISPCityListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSiteMonitorISPCityListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSiteMonitorISPCityListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSiteMonitorListRequest(TeaModel):
    def __init__(self, keyword=None, page=None, page_size=None, region_id=None, task_id=None, task_type=None):
        self.keyword = keyword  # type: str
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.task_id = task_id  # type: str
        self.task_type = task_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSiteMonitorListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeSiteMonitorListResponseBodySiteMonitorsSiteMonitorOptionsJson(TeaModel):
    def __init__(self, attempts=None, authentication=None, cookie=None, dns_match_rule=None, dns_server=None,
                 dns_type=None, failure_rate=None, header=None, http_method=None, match_rule=None, password=None,
                 ping_num=None, port=None, protocol=None, request_content=None, request_format=None, response_content=None,
                 response_format=None, time_out=None, username=None):
        self.attempts = attempts  # type: long
        self.authentication = authentication  # type: int
        self.cookie = cookie  # type: str
        self.dns_match_rule = dns_match_rule  # type: str
        self.dns_server = dns_server  # type: str
        self.dns_type = dns_type  # type: str
        self.failure_rate = failure_rate  # type: float
        self.header = header  # type: str
        self.http_method = http_method  # type: str
        self.match_rule = match_rule  # type: int
        self.password = password  # type: str
        self.ping_num = ping_num  # type: int
        self.port = port  # type: int
        self.protocol = protocol  # type: str
        self.request_content = request_content  # type: str
        self.request_format = request_format  # type: str
        self.response_content = response_content  # type: str
        self.response_format = response_format  # type: str
        self.time_out = time_out  # type: long
        self.username = username  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSiteMonitorListResponseBodySiteMonitorsSiteMonitorOptionsJson, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attempts is not None:
            result['attempts'] = self.attempts
        if self.authentication is not None:
            result['authentication'] = self.authentication
        if self.cookie is not None:
            result['cookie'] = self.cookie
        if self.dns_match_rule is not None:
            result['dns_match_rule'] = self.dns_match_rule
        if self.dns_server is not None:
            result['dns_server'] = self.dns_server
        if self.dns_type is not None:
            result['dns_type'] = self.dns_type
        if self.failure_rate is not None:
            result['failure_rate'] = self.failure_rate
        if self.header is not None:
            result['header'] = self.header
        if self.http_method is not None:
            result['http_method'] = self.http_method
        if self.match_rule is not None:
            result['match_rule'] = self.match_rule
        if self.password is not None:
            result['password'] = self.password
        if self.ping_num is not None:
            result['ping_num'] = self.ping_num
        if self.port is not None:
            result['port'] = self.port
        if self.protocol is not None:
            result['protocol'] = self.protocol
        if self.request_content is not None:
            result['request_content'] = self.request_content
        if self.request_format is not None:
            result['request_format'] = self.request_format
        if self.response_content is not None:
            result['response_content'] = self.response_content
        if self.response_format is not None:
            result['response_format'] = self.response_format
        if self.time_out is not None:
            result['time_out'] = self.time_out
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('attempts') is not None:
            self.attempts = m.get('attempts')
        if m.get('authentication') is not None:
            self.authentication = m.get('authentication')
        if m.get('cookie') is not None:
            self.cookie = m.get('cookie')
        if m.get('dns_match_rule') is not None:
            self.dns_match_rule = m.get('dns_match_rule')
        if m.get('dns_server') is not None:
            self.dns_server = m.get('dns_server')
        if m.get('dns_type') is not None:
            self.dns_type = m.get('dns_type')
        if m.get('failure_rate') is not None:
            self.failure_rate = m.get('failure_rate')
        if m.get('header') is not None:
            self.header = m.get('header')
        if m.get('http_method') is not None:
            self.http_method = m.get('http_method')
        if m.get('match_rule') is not None:
            self.match_rule = m.get('match_rule')
        if m.get('password') is not None:
            self.password = m.get('password')
        if m.get('ping_num') is not None:
            self.ping_num = m.get('ping_num')
        if m.get('port') is not None:
            self.port = m.get('port')
        if m.get('protocol') is not None:
            self.protocol = m.get('protocol')
        if m.get('request_content') is not None:
            self.request_content = m.get('request_content')
        if m.get('request_format') is not None:
            self.request_format = m.get('request_format')
        if m.get('response_content') is not None:
            self.response_content = m.get('response_content')
        if m.get('response_format') is not None:
            self.response_format = m.get('response_format')
        if m.get('time_out') is not None:
            self.time_out = m.get('time_out')
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class DescribeSiteMonitorListResponseBodySiteMonitorsSiteMonitor(TeaModel):
    def __init__(self, address=None, create_time=None, interval=None, options_json=None, task_id=None,
                 task_name=None, task_state=None, task_type=None, update_time=None):
        self.address = address  # type: str
        self.create_time = create_time  # type: str
        self.interval = interval  # type: str
        self.options_json = options_json  # type: DescribeSiteMonitorListResponseBodySiteMonitorsSiteMonitorOptionsJson
        self.task_id = task_id  # type: str
        self.task_name = task_name  # type: str
        self.task_state = task_state  # type: str
        self.task_type = task_type  # type: str
        self.update_time = update_time  # type: str

    def validate(self):
        if self.options_json:
            self.options_json.validate()

    def to_map(self):
        _map = super(DescribeSiteMonitorListResponseBodySiteMonitorsSiteMonitor, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.options_json is not None:
            result['OptionsJson'] = self.options_json.to_map()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OptionsJson') is not None:
            temp_model = DescribeSiteMonitorListResponseBodySiteMonitorsSiteMonitorOptionsJson()
            self.options_json = temp_model.from_map(m['OptionsJson'])
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeSiteMonitorListResponseBodySiteMonitors(TeaModel):
    def __init__(self, site_monitor=None):
        self.site_monitor = site_monitor  # type: list[DescribeSiteMonitorListResponseBodySiteMonitorsSiteMonitor]

    def validate(self):
        if self.site_monitor:
            for k in self.site_monitor:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSiteMonitorListResponseBodySiteMonitors, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SiteMonitor'] = []
        if self.site_monitor is not None:
            for k in self.site_monitor:
                result['SiteMonitor'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.site_monitor = []
        if m.get('SiteMonitor') is not None:
            for k in m.get('SiteMonitor'):
                temp_model = DescribeSiteMonitorListResponseBodySiteMonitorsSiteMonitor()
                self.site_monitor.append(temp_model.from_map(k))
        return self


class DescribeSiteMonitorListResponseBody(TeaModel):
    def __init__(self, code=None, message=None, page_number=None, page_size=None, request_id=None,
                 site_monitors=None, success=None, total_count=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.site_monitors = site_monitors  # type: DescribeSiteMonitorListResponseBodySiteMonitors
        self.success = success  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.site_monitors:
            self.site_monitors.validate()

    def to_map(self):
        _map = super(DescribeSiteMonitorListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.site_monitors is not None:
            result['SiteMonitors'] = self.site_monitors.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SiteMonitors') is not None:
            temp_model = DescribeSiteMonitorListResponseBodySiteMonitors()
            self.site_monitors = temp_model.from_map(m['SiteMonitors'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSiteMonitorListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeSiteMonitorListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSiteMonitorListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSiteMonitorListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSiteMonitorLogRequest(TeaModel):
    def __init__(self, city=None, end_time=None, filter=None, isp=None, length=None, metric_name=None,
                 next_token=None, region_id=None, start_time=None, task_ids=None):
        self.city = city  # type: str
        self.end_time = end_time  # type: str
        self.filter = filter  # type: str
        self.isp = isp  # type: str
        self.length = length  # type: int
        self.metric_name = metric_name  # type: str
        self.next_token = next_token  # type: str
        self.region_id = region_id  # type: str
        self.start_time = start_time  # type: str
        self.task_ids = task_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSiteMonitorLogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city is not None:
            result['City'] = self.city
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.filter is not None:
            result['Filter'] = self.filter
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.length is not None:
            result['Length'] = self.length
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.task_ids is not None:
            result['TaskIds'] = self.task_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Filter') is not None:
            self.filter = m.get('Filter')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TaskIds') is not None:
            self.task_ids = m.get('TaskIds')
        return self


class DescribeSiteMonitorLogResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, next_token=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.next_token = next_token  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSiteMonitorLogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSiteMonitorLogResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeSiteMonitorLogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSiteMonitorLogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSiteMonitorLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSiteMonitorQuotaRequest(TeaModel):
    def __init__(self, region_id=None):
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSiteMonitorQuotaRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeSiteMonitorQuotaResponseBodyData(TeaModel):
    def __init__(self, second_monitor=None, site_monitor_idc_quota=None, site_monitor_operator_quota_quota=None,
                 site_monitor_quota_task_used=None, site_monitor_task_quota=None, site_monitor_version=None):
        self.second_monitor = second_monitor  # type: bool
        self.site_monitor_idc_quota = site_monitor_idc_quota  # type: int
        self.site_monitor_operator_quota_quota = site_monitor_operator_quota_quota  # type: int
        self.site_monitor_quota_task_used = site_monitor_quota_task_used  # type: int
        self.site_monitor_task_quota = site_monitor_task_quota  # type: int
        self.site_monitor_version = site_monitor_version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSiteMonitorQuotaResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.second_monitor is not None:
            result['SecondMonitor'] = self.second_monitor
        if self.site_monitor_idc_quota is not None:
            result['SiteMonitorIdcQuota'] = self.site_monitor_idc_quota
        if self.site_monitor_operator_quota_quota is not None:
            result['SiteMonitorOperatorQuotaQuota'] = self.site_monitor_operator_quota_quota
        if self.site_monitor_quota_task_used is not None:
            result['SiteMonitorQuotaTaskUsed'] = self.site_monitor_quota_task_used
        if self.site_monitor_task_quota is not None:
            result['SiteMonitorTaskQuota'] = self.site_monitor_task_quota
        if self.site_monitor_version is not None:
            result['SiteMonitorVersion'] = self.site_monitor_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SecondMonitor') is not None:
            self.second_monitor = m.get('SecondMonitor')
        if m.get('SiteMonitorIdcQuota') is not None:
            self.site_monitor_idc_quota = m.get('SiteMonitorIdcQuota')
        if m.get('SiteMonitorOperatorQuotaQuota') is not None:
            self.site_monitor_operator_quota_quota = m.get('SiteMonitorOperatorQuotaQuota')
        if m.get('SiteMonitorQuotaTaskUsed') is not None:
            self.site_monitor_quota_task_used = m.get('SiteMonitorQuotaTaskUsed')
        if m.get('SiteMonitorTaskQuota') is not None:
            self.site_monitor_task_quota = m.get('SiteMonitorTaskQuota')
        if m.get('SiteMonitorVersion') is not None:
            self.site_monitor_version = m.get('SiteMonitorVersion')
        return self


class DescribeSiteMonitorQuotaResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: DescribeSiteMonitorQuotaResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeSiteMonitorQuotaResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeSiteMonitorQuotaResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSiteMonitorQuotaResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeSiteMonitorQuotaResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSiteMonitorQuotaResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSiteMonitorQuotaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSiteMonitorStatisticsRequest(TeaModel):
    def __init__(self, metric_name=None, region_id=None, start_time=None, task_id=None, time_range=None):
        self.metric_name = metric_name  # type: str
        self.region_id = region_id  # type: str
        self.start_time = start_time  # type: str
        self.task_id = task_id  # type: str
        self.time_range = time_range  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSiteMonitorStatisticsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.time_range is not None:
            result['TimeRange'] = self.time_range
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TimeRange') is not None:
            self.time_range = m.get('TimeRange')
        return self


class DescribeSiteMonitorStatisticsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSiteMonitorStatisticsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSiteMonitorStatisticsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeSiteMonitorStatisticsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSiteMonitorStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSiteMonitorStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSystemEventAttributeRequest(TeaModel):
    def __init__(self, end_time=None, event_type=None, group_id=None, level=None, name=None, page_number=None,
                 page_size=None, product=None, region_id=None, search_keywords=None, start_time=None, status=None):
        self.end_time = end_time  # type: str
        self.event_type = event_type  # type: str
        self.group_id = group_id  # type: str
        self.level = level  # type: str
        self.name = name  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.product = product  # type: str
        self.region_id = region_id  # type: str
        self.search_keywords = search_keywords  # type: str
        self.start_time = start_time  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSystemEventAttributeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.search_keywords is not None:
            result['SearchKeywords'] = self.search_keywords
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SearchKeywords') is not None:
            self.search_keywords = m.get('SearchKeywords')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeSystemEventAttributeResponseBodySystemEventsSystemEvent(TeaModel):
    def __init__(self, content=None, group_id=None, instance_name=None, level=None, name=None, product=None,
                 region_id=None, resource_id=None, status=None, time=None):
        self.content = content  # type: str
        self.group_id = group_id  # type: str
        self.instance_name = instance_name  # type: str
        self.level = level  # type: str
        self.name = name  # type: str
        self.product = product  # type: str
        self.region_id = region_id  # type: str
        self.resource_id = resource_id  # type: str
        self.status = status  # type: str
        self.time = time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSystemEventAttributeResponseBodySystemEventsSystemEvent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.status is not None:
            result['Status'] = self.status
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeSystemEventAttributeResponseBodySystemEvents(TeaModel):
    def __init__(self, system_event=None):
        self.system_event = system_event  # type: list[DescribeSystemEventAttributeResponseBodySystemEventsSystemEvent]

    def validate(self):
        if self.system_event:
            for k in self.system_event:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSystemEventAttributeResponseBodySystemEvents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SystemEvent'] = []
        if self.system_event is not None:
            for k in self.system_event:
                result['SystemEvent'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.system_event = []
        if m.get('SystemEvent') is not None:
            for k in m.get('SystemEvent'):
                temp_model = DescribeSystemEventAttributeResponseBodySystemEventsSystemEvent()
                self.system_event.append(temp_model.from_map(k))
        return self


class DescribeSystemEventAttributeResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None, system_events=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str
        self.system_events = system_events  # type: DescribeSystemEventAttributeResponseBodySystemEvents

    def validate(self):
        if self.system_events:
            self.system_events.validate()

    def to_map(self):
        _map = super(DescribeSystemEventAttributeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.system_events is not None:
            result['SystemEvents'] = self.system_events.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('SystemEvents') is not None:
            temp_model = DescribeSystemEventAttributeResponseBodySystemEvents()
            self.system_events = temp_model.from_map(m['SystemEvents'])
        return self


class DescribeSystemEventAttributeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeSystemEventAttributeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSystemEventAttributeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSystemEventAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSystemEventCountRequest(TeaModel):
    def __init__(self, end_time=None, event_type=None, group_id=None, level=None, name=None, product=None,
                 region_id=None, search_keywords=None, start_time=None, status=None):
        self.end_time = end_time  # type: str
        self.event_type = event_type  # type: str
        self.group_id = group_id  # type: str
        self.level = level  # type: str
        self.name = name  # type: str
        self.product = product  # type: str
        self.region_id = region_id  # type: str
        self.search_keywords = search_keywords  # type: str
        self.start_time = start_time  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSystemEventCountRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.search_keywords is not None:
            result['SearchKeywords'] = self.search_keywords
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SearchKeywords') is not None:
            self.search_keywords = m.get('SearchKeywords')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeSystemEventCountResponseBodySystemEventCountsSystemEventCount(TeaModel):
    def __init__(self, content=None, group_id=None, instance_name=None, level=None, name=None, num=None, product=None,
                 region_id=None, resource_id=None, status=None, time=None):
        self.content = content  # type: str
        self.group_id = group_id  # type: str
        self.instance_name = instance_name  # type: str
        self.level = level  # type: str
        self.name = name  # type: str
        self.num = num  # type: long
        self.product = product  # type: str
        self.region_id = region_id  # type: str
        self.resource_id = resource_id  # type: str
        self.status = status  # type: str
        self.time = time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSystemEventCountResponseBodySystemEventCountsSystemEventCount, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.num is not None:
            result['Num'] = self.num
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.status is not None:
            result['Status'] = self.status
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Num') is not None:
            self.num = m.get('Num')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeSystemEventCountResponseBodySystemEventCounts(TeaModel):
    def __init__(self, system_event_count=None):
        self.system_event_count = system_event_count  # type: list[DescribeSystemEventCountResponseBodySystemEventCountsSystemEventCount]

    def validate(self):
        if self.system_event_count:
            for k in self.system_event_count:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSystemEventCountResponseBodySystemEventCounts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SystemEventCount'] = []
        if self.system_event_count is not None:
            for k in self.system_event_count:
                result['SystemEventCount'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.system_event_count = []
        if m.get('SystemEventCount') is not None:
            for k in m.get('SystemEventCount'):
                temp_model = DescribeSystemEventCountResponseBodySystemEventCountsSystemEventCount()
                self.system_event_count.append(temp_model.from_map(k))
        return self


class DescribeSystemEventCountResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None, system_event_counts=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str
        self.system_event_counts = system_event_counts  # type: DescribeSystemEventCountResponseBodySystemEventCounts

    def validate(self):
        if self.system_event_counts:
            self.system_event_counts.validate()

    def to_map(self):
        _map = super(DescribeSystemEventCountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.system_event_counts is not None:
            result['SystemEventCounts'] = self.system_event_counts.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('SystemEventCounts') is not None:
            temp_model = DescribeSystemEventCountResponseBodySystemEventCounts()
            self.system_event_counts = temp_model.from_map(m['SystemEventCounts'])
        return self


class DescribeSystemEventCountResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeSystemEventCountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSystemEventCountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSystemEventCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSystemEventHistogramRequest(TeaModel):
    def __init__(self, end_time=None, event_type=None, group_id=None, level=None, name=None, product=None,
                 region_id=None, search_keywords=None, start_time=None, status=None):
        self.end_time = end_time  # type: str
        self.event_type = event_type  # type: str
        self.group_id = group_id  # type: str
        self.level = level  # type: str
        self.name = name  # type: str
        self.product = product  # type: str
        self.region_id = region_id  # type: str
        self.search_keywords = search_keywords  # type: str
        self.start_time = start_time  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSystemEventHistogramRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.product is not None:
            result['Product'] = self.product
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.search_keywords is not None:
            result['SearchKeywords'] = self.search_keywords
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SearchKeywords') is not None:
            self.search_keywords = m.get('SearchKeywords')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeSystemEventHistogramResponseBodySystemEventHistogramsSystemEventHistogram(TeaModel):
    def __init__(self, count=None, end_time=None, start_time=None):
        self.count = count  # type: long
        self.end_time = end_time  # type: long
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSystemEventHistogramResponseBodySystemEventHistogramsSystemEventHistogram, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeSystemEventHistogramResponseBodySystemEventHistograms(TeaModel):
    def __init__(self, system_event_histogram=None):
        self.system_event_histogram = system_event_histogram  # type: list[DescribeSystemEventHistogramResponseBodySystemEventHistogramsSystemEventHistogram]

    def validate(self):
        if self.system_event_histogram:
            for k in self.system_event_histogram:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSystemEventHistogramResponseBodySystemEventHistograms, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SystemEventHistogram'] = []
        if self.system_event_histogram is not None:
            for k in self.system_event_histogram:
                result['SystemEventHistogram'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.system_event_histogram = []
        if m.get('SystemEventHistogram') is not None:
            for k in m.get('SystemEventHistogram'):
                temp_model = DescribeSystemEventHistogramResponseBodySystemEventHistogramsSystemEventHistogram()
                self.system_event_histogram.append(temp_model.from_map(k))
        return self


class DescribeSystemEventHistogramResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None, system_event_histograms=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str
        self.system_event_histograms = system_event_histograms  # type: DescribeSystemEventHistogramResponseBodySystemEventHistograms

    def validate(self):
        if self.system_event_histograms:
            self.system_event_histograms.validate()

    def to_map(self):
        _map = super(DescribeSystemEventHistogramResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.system_event_histograms is not None:
            result['SystemEventHistograms'] = self.system_event_histograms.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('SystemEventHistograms') is not None:
            temp_model = DescribeSystemEventHistogramResponseBodySystemEventHistograms()
            self.system_event_histograms = temp_model.from_map(m['SystemEventHistograms'])
        return self


class DescribeSystemEventHistogramResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeSystemEventHistogramResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSystemEventHistogramResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSystemEventHistogramResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSystemEventMetaListRequest(TeaModel):
    def __init__(self, region_id=None):
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSystemEventMetaListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeSystemEventMetaListResponseBodyDataResource(TeaModel):
    def __init__(self, event_type=None, level=None, name=None, name_desc=None, name_desc_en=None, product=None,
                 status=None, status_desc=None):
        self.event_type = event_type  # type: str
        self.level = level  # type: str
        self.name = name  # type: str
        self.name_desc = name_desc  # type: str
        self.name_desc_en = name_desc_en  # type: str
        self.product = product  # type: str
        self.status = status  # type: str
        self.status_desc = status_desc  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSystemEventMetaListResponseBodyDataResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.name_desc is not None:
            result['NameDesc'] = self.name_desc
        if self.name_desc_en is not None:
            result['NameDesc.En'] = self.name_desc_en
        if self.product is not None:
            result['Product'] = self.product
        if self.status is not None:
            result['Status'] = self.status
        if self.status_desc is not None:
            result['StatusDesc'] = self.status_desc
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NameDesc') is not None:
            self.name_desc = m.get('NameDesc')
        if m.get('NameDesc.En') is not None:
            self.name_desc_en = m.get('NameDesc.En')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusDesc') is not None:
            self.status_desc = m.get('StatusDesc')
        return self


class DescribeSystemEventMetaListResponseBodyData(TeaModel):
    def __init__(self, resource=None):
        self.resource = resource  # type: list[DescribeSystemEventMetaListResponseBodyDataResource]

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSystemEventMetaListResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeSystemEventMetaListResponseBodyDataResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeSystemEventMetaListResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: int
        self.data = data  # type: DescribeSystemEventMetaListResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeSystemEventMetaListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeSystemEventMetaListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSystemEventMetaListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeSystemEventMetaListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSystemEventMetaListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSystemEventMetaListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeTagKeyListRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, region_id=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeTagKeyListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeTagKeyListResponseBodyTagKeys(TeaModel):
    def __init__(self, tag_key=None):
        self.tag_key = tag_key  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeTagKeyListResponseBodyTagKeys, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class DescribeTagKeyListResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None, tag_keys=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.tag_keys = tag_keys  # type: DescribeTagKeyListResponseBodyTagKeys

    def validate(self):
        if self.tag_keys:
            self.tag_keys.validate()

    def to_map(self):
        _map = super(DescribeTagKeyListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.tag_keys is not None:
            result['TagKeys'] = self.tag_keys.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TagKeys') is not None:
            temp_model = DescribeTagKeyListResponseBodyTagKeys()
            self.tag_keys = temp_model.from_map(m['TagKeys'])
        return self


class DescribeTagKeyListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeTagKeyListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeTagKeyListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeTagKeyListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeTagValueListRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, region_id=None, tag_key=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.tag_key = tag_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeTagValueListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class DescribeTagValueListResponseBodyTagValues(TeaModel):
    def __init__(self, tag_value=None):
        self.tag_value = tag_value  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeTagValueListResponseBodyTagValues, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeTagValueListResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None, tag_values=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.tag_values = tag_va