import { JavaProject, JavaProjectOptions } from "projen/lib/java";
/**
 * Configuration for the generated java client project
 */
export interface GeneratedJavaClientProjectOptions extends JavaProjectOptions {
    /**
     * The absolute path to the OpenAPI specification (spec.yaml) from which to generate code
     */
    readonly specPath: string;
    /**
     * Indicates whether the client generator needs to be invoked
     */
    readonly generateClient: boolean;
}
/**
 * Java project containing a java client (and lambda handler wrappers) generated using OpenAPI Generator CLI
 */
export declare class GeneratedJavaClientProject extends JavaProject {
    private synthed;
    constructor(options: GeneratedJavaClientProjectOptions);
    /**
     * @inheritDoc
     */
    synth(): void;
}
