"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyApiGatewayPythonProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const open_api_gateway_python_project_1 = require("./open-api-gateway-python-project");
const setup_smithy_build_1 = require("./smithy/setup-smithy-build");
/**
 * Synthesizes a Python Project with a Smithy model, generated clients, a CDK construct for deploying the API
 * with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.
 *
 * @pjid smithy-api-gateway-py
 */
class SmithyApiGatewayPythonProject extends open_api_gateway_python_project_1.OpenApiGatewayPythonProject {
    constructor(options) {
        super(options);
        /**
         * The directory in which the smithy model files reside
         */
        this.modelDir = "model";
    }
    preConstruct(options) {
        const { modelDir, generatedSpecFilePath } = setup_smithy_build_1.setupSmithyBuild(this, 
        // Options are the same as those in the constructor, so it is safe to cast to SmithyApiGatewayProjectOptions
        options);
        // @ts-ignore this method is called by the constructor
        this.modelDir = modelDir;
        return {
            ...options,
            specFile: generatedSpecFilePath,
        };
    }
}
exports.SmithyApiGatewayPythonProject = SmithyApiGatewayPythonProject;
_a = JSII_RTTI_SYMBOL_1;
SmithyApiGatewayPythonProject[_a] = { fqn: "@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject", version: "0.12.9" };
//# sourceMappingURL=data:application/json;base64,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