from collections.abc import Mapping, Sequence

from sqlalchemy import Column, ForeignKeyConstraint
from sqlalchemy.engine import URL
from sqlalchemy.sql.functions import Function
from typing_extensions import TypeAlias

from ..utils import starts_with as starts_with
from .orm import quote as quote
from typing import Union, Optional, Any

# Should be `_VT: TypeAlias = Union[int, float, str, Mapping[str, "_VT"], Sequence["_VT"]]`
# But recursive types are not yet fully supported by mypy. See https://github.com/python/mypy/issues/731
_VT: TypeAlias = Union[int, float, str, Mapping[str, Any], Sequence[Any]]

def escape_like(string: str, escape_char: str = ...) -> str: ...
def json_sql(value: _VT, scalars_to_json: bool = ...) -> Function[Any]: ...
def jsonb_sql(value: _VT, scalars_to_jsonb: bool = ...) -> Function[Any]: ...
def has_index(column_or_constraint: Union[Column[Any], ForeignKeyConstraint]) -> bool: ...
def has_unique_index(column_or_constraint: Union[Column[Any], ForeignKeyConstraint]) -> bool: ...
def is_auto_assigned_date_column(column: Column[Any]) -> bool: ...
def database_exists(url: Union[URL, str]) -> bool: ...
def create_database(url: Union[URL, str], encoding: str = ..., template: Optional[str] = ...) -> None: ...
def drop_database(url: Union[URL, str]) -> None: ...
