"""
    Delphix API Gateway

    Delphix API Gateway API  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.create_environment_response import CreateEnvironmentResponse
from delphix.api.gateway.model.delete_environment_response import DeleteEnvironmentResponse
from delphix.api.gateway.model.disable_environment_response import DisableEnvironmentResponse
from delphix.api.gateway.model.enable_environment_response import EnableEnvironmentResponse
from delphix.api.gateway.model.environment import Environment
from delphix.api.gateway.model.environment_create_parameters import EnvironmentCreateParameters
from delphix.api.gateway.model.environment_update_parameters import EnvironmentUpdateParameters
from delphix.api.gateway.model.list_environment_users import ListEnvironmentUsers
from delphix.api.gateway.model.list_environments_response import ListEnvironmentsResponse
from delphix.api.gateway.model.refresh_environment_response import RefreshEnvironmentResponse
from delphix.api.gateway.model.tags_request import TagsRequest
from delphix.api.gateway.model.tags_response import TagsResponse
from delphix.api.gateway.model.update_environment_response import UpdateEnvironmentResponse


class EnvironmentsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_environment_tags(
            self,
            environment_id,
            tags_request,
            **kwargs
        ):
            """Create tags for an Environment.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_environment_tags(environment_id, tags_request, async_req=True)
            >>> result = thread.get()

            Args:
                environment_id (str): The ID of the environment.
                tags_request (TagsRequest): Tags information for Environment.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['environment_id'] = \
                environment_id
            kwargs['tags_request'] = \
                tags_request
            return self.call_with_http_info(**kwargs)

        self.create_environment_tags = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/environments/{environmentId}/tags',
                'operation_id': 'create_environment_tags',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'environment_id',
                    'tags_request',
                ],
                'required': [
                    'environment_id',
                    'tags_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'environment_id',
                ]
            },
            root_map={
                'validations': {
                    ('environment_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'environment_id':
                        (str,),
                    'tags_request':
                        (TagsRequest,),
                },
                'attribute_map': {
                    'environment_id': 'environmentId',
                },
                'location_map': {
                    'environment_id': 'path',
                    'tags_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_environment_tags
        )

        def __create_environments(
            self,
            environment_create_parameters,
            **kwargs
        ):
            """Create an environment.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_environments(environment_create_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                environment_create_parameters (EnvironmentCreateParameters): The parameters to create an environment.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreateEnvironmentResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['environment_create_parameters'] = \
                environment_create_parameters
            return self.call_with_http_info(**kwargs)

        self.create_environments = _Endpoint(
            settings={
                'response_type': (CreateEnvironmentResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/environments',
                'operation_id': 'create_environments',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'environment_create_parameters',
                ],
                'required': [
                    'environment_create_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'environment_create_parameters':
                        (EnvironmentCreateParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'environment_create_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_environments
        )

        def __delete_environment(
            self,
            environment_id,
            **kwargs
        ):
            """Delete an environment by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_environment(environment_id, async_req=True)
            >>> result = thread.get()

            Args:
                environment_id (str): The ID of the environment.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DeleteEnvironmentResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['environment_id'] = \
                environment_id
            return self.call_with_http_info(**kwargs)

        self.delete_environment = _Endpoint(
            settings={
                'response_type': (DeleteEnvironmentResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/environments/{environmentId}',
                'operation_id': 'delete_environment',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'environment_id',
                ],
                'required': [
                    'environment_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'environment_id',
                ]
            },
            root_map={
                'validations': {
                    ('environment_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'environment_id':
                        (str,),
                },
                'attribute_map': {
                    'environment_id': 'environmentId',
                },
                'location_map': {
                    'environment_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_environment
        )

        def __disable_environment(
            self,
            environment_id,
            **kwargs
        ):
            """Disable environment.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.disable_environment(environment_id, async_req=True)
            >>> result = thread.get()

            Args:
                environment_id (str): The ID of the environment.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DisableEnvironmentResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['environment_id'] = \
                environment_id
            return self.call_with_http_info(**kwargs)

        self.disable_environment = _Endpoint(
            settings={
                'response_type': (DisableEnvironmentResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/environments/{environmentId}/disable',
                'operation_id': 'disable_environment',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'environment_id',
                ],
                'required': [
                    'environment_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'environment_id',
                ]
            },
            root_map={
                'validations': {
                    ('environment_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'environment_id':
                        (str,),
                },
                'attribute_map': {
                    'environment_id': 'environmentId',
                },
                'location_map': {
                    'environment_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__disable_environment
        )

        def __enable_environment(
            self,
            environment_id,
            **kwargs
        ):
            """Enable a disabled environment.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.enable_environment(environment_id, async_req=True)
            >>> result = thread.get()

            Args:
                environment_id (str): The ID of the environment.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EnableEnvironmentResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['environment_id'] = \
                environment_id
            return self.call_with_http_info(**kwargs)

        self.enable_environment = _Endpoint(
            settings={
                'response_type': (EnableEnvironmentResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/environments/{environmentId}/enable',
                'operation_id': 'enable_environment',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'environment_id',
                ],
                'required': [
                    'environment_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'environment_id',
                ]
            },
            root_map={
                'validations': {
                    ('environment_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'environment_id':
                        (str,),
                },
                'attribute_map': {
                    'environment_id': 'environmentId',
                },
                'location_map': {
                    'environment_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__enable_environment
        )

        def __get_environment_by_id(
            self,
            environment_id,
            **kwargs
        ):
            """Returns an environment by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_environment_by_id(environment_id, async_req=True)
            >>> result = thread.get()

            Args:
                environment_id (str): The ID of the environment.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Environment
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['environment_id'] = \
                environment_id
            return self.call_with_http_info(**kwargs)

        self.get_environment_by_id = _Endpoint(
            settings={
                'response_type': (Environment,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/environments/{environmentId}',
                'operation_id': 'get_environment_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'environment_id',
                ],
                'required': [
                    'environment_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'environment_id',
                ]
            },
            root_map={
                'validations': {
                    ('environment_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'environment_id':
                        (str,),
                },
                'attribute_map': {
                    'environment_id': 'environmentId',
                },
                'location_map': {
                    'environment_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_environment_by_id
        )

        def __get_environments(
            self,
            **kwargs
        ):
            """List all environments.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_environments(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): Maximum number of objects to return per query. The value must be between 1 and 1000. Default is 100.. [optional] if omitted the server will use the default value of 100
                cursor (str): Cursor to fetch the next or previous page of results.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListEnvironmentsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_environments = _Endpoint(
            settings={
                'response_type': (ListEnvironmentsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/environments',
                'operation_id': 'get_environments',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'cursor',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                    'cursor',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': 1,
                    },
                    ('cursor',): {
                        'max_length': 4096,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'cursor':
                        (str,),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'cursor': 'cursor',
                },
                'location_map': {
                    'limit': 'query',
                    'cursor': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_environments
        )

        def __get_tags_environment(
            self,
            environment_id,
            **kwargs
        ):
            """Get tags for an Environment.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_tags_environment(environment_id, async_req=True)
            >>> result = thread.get()

            Args:
                environment_id (str): The ID of the environment.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TagsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['environment_id'] = \
                environment_id
            return self.call_with_http_info(**kwargs)

        self.get_tags_environment = _Endpoint(
            settings={
                'response_type': (TagsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/environments/{environmentId}/tags',
                'operation_id': 'get_tags_environment',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'environment_id',
                ],
                'required': [
                    'environment_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'environment_id',
                ]
            },
            root_map={
                'validations': {
                    ('environment_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'environment_id':
                        (str,),
                },
                'attribute_map': {
                    'environment_id': 'environmentId',
                },
                'location_map': {
                    'environment_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_tags_environment
        )

        def __list_environment_users(
            self,
            environment_id,
            **kwargs
        ):
            """List environment users.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_environment_users(environment_id, async_req=True)
            >>> result = thread.get()

            Args:
                environment_id (str): List environment users.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListEnvironmentUsers
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['environment_id'] = \
                environment_id
            return self.call_with_http_info(**kwargs)

        self.list_environment_users = _Endpoint(
            settings={
                'response_type': (ListEnvironmentUsers,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/environments/{environmentId}/users',
                'operation_id': 'list_environment_users',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'environment_id',
                ],
                'required': [
                    'environment_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'environment_id',
                ]
            },
            root_map={
                'validations': {
                    ('environment_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'environment_id':
                        (str,),
                },
                'attribute_map': {
                    'environment_id': 'environmentId',
                },
                'location_map': {
                    'environment_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_environment_users
        )

        def __refresh_environment(
            self,
            environment_id,
            **kwargs
        ):
            """Refresh environment.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.refresh_environment(environment_id, async_req=True)
            >>> result = thread.get()

            Args:
                environment_id (str): The ID of the environment.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RefreshEnvironmentResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['environment_id'] = \
                environment_id
            return self.call_with_http_info(**kwargs)

        self.refresh_environment = _Endpoint(
            settings={
                'response_type': (RefreshEnvironmentResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/environments/{environmentId}/refresh',
                'operation_id': 'refresh_environment',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'environment_id',
                ],
                'required': [
                    'environment_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'environment_id',
                ]
            },
            root_map={
                'validations': {
                    ('environment_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'environment_id':
                        (str,),
                },
                'attribute_map': {
                    'environment_id': 'environmentId',
                },
                'location_map': {
                    'environment_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__refresh_environment
        )

        def __update_environment(
            self,
            environment_id,
            **kwargs
        ):
            """Update an environment by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_environment(environment_id, async_req=True)
            >>> result = thread.get()

            Args:
                environment_id (str): The ID of the environment.

            Keyword Args:
                environment_update_parameters (EnvironmentUpdateParameters): the parameters to update an environment. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpdateEnvironmentResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['environment_id'] = \
                environment_id
            return self.call_with_http_info(**kwargs)

        self.update_environment = _Endpoint(
            settings={
                'response_type': (UpdateEnvironmentResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/environments/{environmentId}',
                'operation_id': 'update_environment',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'environment_id',
                    'environment_update_parameters',
                ],
                'required': [
                    'environment_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'environment_id',
                ]
            },
            root_map={
                'validations': {
                    ('environment_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'environment_id':
                        (str,),
                    'environment_update_parameters':
                        (EnvironmentUpdateParameters,),
                },
                'attribute_map': {
                    'environment_id': 'environmentId',
                },
                'location_map': {
                    'environment_id': 'path',
                    'environment_update_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_environment
        )
