"""
    Delphix API Gateway

    Delphix API Gateway API  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.create_vdb_group_request import CreateVDBGroupRequest
from delphix.api.gateway.model.create_vdb_group_response import CreateVDBGroupResponse
from delphix.api.gateway.model.list_bookmarks_by_vdb_groups_response import ListBookmarksByVDBGroupsResponse
from delphix.api.gateway.model.list_vdb_groups_response import ListVDBGroupsResponse
from delphix.api.gateway.model.refresh_vdb_group_parameters import RefreshVDBGroupParameters
from delphix.api.gateway.model.refresh_vdb_group_response import RefreshVDBGroupResponse
from delphix.api.gateway.model.rollback_vdb_group_parameters import RollbackVDBGroupParameters
from delphix.api.gateway.model.rollback_vdb_group_response import RollbackVDBGroupResponse
from delphix.api.gateway.model.vdb_group import VDBGroup


class VDBGroupsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_vdb_group(
            self,
            create_vdb_group_request,
            **kwargs
        ):
            """Create a new VDBGroup.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_vdb_group(create_vdb_group_request, async_req=True)
            >>> result = thread.get()

            Args:
                create_vdb_group_request (CreateVDBGroupRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreateVDBGroupResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['create_vdb_group_request'] = \
                create_vdb_group_request
            return self.call_with_http_info(**kwargs)

        self.create_vdb_group = _Endpoint(
            settings={
                'response_type': (CreateVDBGroupResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdb-groups',
                'operation_id': 'create_vdb_group',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_vdb_group_request',
                ],
                'required': [
                    'create_vdb_group_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_vdb_group_request':
                        (CreateVDBGroupRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'create_vdb_group_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_vdb_group
        )

        def __delete_vdb_group(
            self,
            vdb_group_id,
            **kwargs
        ):
            """Delete a VDBGoup.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_vdb_group(vdb_group_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_group_id (str): The ID or name of the VDBGroup.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_group_id'] = \
                vdb_group_id
            return self.call_with_http_info(**kwargs)

        self.delete_vdb_group = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdb-groups/{vdbGroupId}',
                'operation_id': 'delete_vdb_group',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_group_id',
                ],
                'required': [
                    'vdb_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_group_id',): {
                        'max_length': 256,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_group_id':
                        (str,),
                },
                'attribute_map': {
                    'vdb_group_id': 'vdbGroupId',
                },
                'location_map': {
                    'vdb_group_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_vdb_group
        )

        def __get_bookmarks_by_vdb_group(
            self,
            vdb_group_id,
            **kwargs
        ):
            """List bookmarks compatible with this VDB Group.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_bookmarks_by_vdb_group(vdb_group_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_group_id (str): The ID or name of the VDBGroup.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListBookmarksByVDBGroupsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_group_id'] = \
                vdb_group_id
            return self.call_with_http_info(**kwargs)

        self.get_bookmarks_by_vdb_group = _Endpoint(
            settings={
                'response_type': (ListBookmarksByVDBGroupsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdb-groups/{vdbGroupId}/bookmarks',
                'operation_id': 'get_bookmarks_by_vdb_group',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_group_id',
                ],
                'required': [
                    'vdb_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_group_id',): {
                        'max_length': 256,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_group_id':
                        (str,),
                },
                'attribute_map': {
                    'vdb_group_id': 'vdbGroupId',
                },
                'location_map': {
                    'vdb_group_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_bookmarks_by_vdb_group
        )

        def __get_vdb_group(
            self,
            vdb_group_id,
            **kwargs
        ):
            """Get a VDBGroup by name.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_vdb_group(vdb_group_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_group_id (str): The ID or name of the VDBGroup.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VDBGroup
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_group_id'] = \
                vdb_group_id
            return self.call_with_http_info(**kwargs)

        self.get_vdb_group = _Endpoint(
            settings={
                'response_type': (VDBGroup,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdb-groups/{vdbGroupId}',
                'operation_id': 'get_vdb_group',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_group_id',
                ],
                'required': [
                    'vdb_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_group_id',): {
                        'max_length': 256,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_group_id':
                        (str,),
                },
                'attribute_map': {
                    'vdb_group_id': 'vdbGroupId',
                },
                'location_map': {
                    'vdb_group_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_vdb_group
        )

        def __get_vdb_groups(
            self,
            **kwargs
        ):
            """List all VDBGroups.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_vdb_groups(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListVDBGroupsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_vdb_groups = _Endpoint(
            settings={
                'response_type': (ListVDBGroupsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdb-groups',
                'operation_id': 'get_vdb_groups',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_vdb_groups
        )

        def __refresh_vdb_group(
            self,
            vdb_group_id,
            **kwargs
        ):
            """Refresh a VDBGroup.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.refresh_vdb_group(vdb_group_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_group_id (str): The ID or name of the VDBGroup.

            Keyword Args:
                refresh_vdb_group_parameters (RefreshVDBGroupParameters): The parameters to refresh a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RefreshVDBGroupResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_group_id'] = \
                vdb_group_id
            return self.call_with_http_info(**kwargs)

        self.refresh_vdb_group = _Endpoint(
            settings={
                'response_type': (RefreshVDBGroupResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdb-groups/{vdbGroupId}/refresh',
                'operation_id': 'refresh_vdb_group',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_group_id',
                    'refresh_vdb_group_parameters',
                ],
                'required': [
                    'vdb_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_group_id',): {
                        'max_length': 256,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_group_id':
                        (str,),
                    'refresh_vdb_group_parameters':
                        (RefreshVDBGroupParameters,),
                },
                'attribute_map': {
                    'vdb_group_id': 'vdbGroupId',
                },
                'location_map': {
                    'vdb_group_id': 'path',
                    'refresh_vdb_group_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__refresh_vdb_group
        )

        def __rollback_vdb_group(
            self,
            vdb_group_id,
            **kwargs
        ):
            """Rollback a VDBGroup.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.rollback_vdb_group(vdb_group_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_group_id (str): The ID or name of the VDBGroup.

            Keyword Args:
                rollback_vdb_group_parameters (RollbackVDBGroupParameters): The parameters to rollback a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RollbackVDBGroupResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_group_id'] = \
                vdb_group_id
            return self.call_with_http_info(**kwargs)

        self.rollback_vdb_group = _Endpoint(
            settings={
                'response_type': (RollbackVDBGroupResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdb-groups/{vdbGroupId}/rollback',
                'operation_id': 'rollback_vdb_group',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_group_id',
                    'rollback_vdb_group_parameters',
                ],
                'required': [
                    'vdb_group_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_group_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_group_id',): {
                        'max_length': 256,
                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_group_id':
                        (str,),
                    'rollback_vdb_group_parameters':
                        (RollbackVDBGroupParameters,),
                },
                'attribute_map': {
                    'vdb_group_id': 'vdbGroupId',
                },
                'location_map': {
                    'vdb_group_id': 'path',
                    'rollback_vdb_group_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__rollback_vdb_group
        )
