import datetime
import typing

import QuantConnect
import QuantConnect.Algorithm
import QuantConnect.Algorithm.Framework.Alphas
import QuantConnect.Algorithm.Framework.Execution
import QuantConnect.Algorithm.Framework.Portfolio
import QuantConnect.Algorithm.Framework.Risk
import QuantConnect.Algorithm.Framework.Selection
import QuantConnect.Benchmarks
import QuantConnect.Brokerages
import QuantConnect.Data
import QuantConnect.Data.Consolidators
import QuantConnect.Data.Fundamental
import QuantConnect.Data.Market
import QuantConnect.Data.UniverseSelection
import QuantConnect.Indicators
import QuantConnect.Indicators.CandlestickPatterns
import QuantConnect.Interfaces
import QuantConnect.Notifications
import QuantConnect.Orders
import QuantConnect.Python
import QuantConnect.Scheduling
import QuantConnect.Securities
import QuantConnect.Securities.Cfd
import QuantConnect.Securities.Crypto
import QuantConnect.Securities.Equity
import QuantConnect.Securities.Forex
import QuantConnect.Securities.Future
import QuantConnect.Securities.Index
import QuantConnect.Securities.Option
import QuantConnect.Storage
import System
import System.Collections.Concurrent
import System.Collections.Generic
import pandas

QuantConnect_Algorithm_QCAlgorithm_RegisterIndicator_T = typing.TypeVar("QuantConnect_Algorithm_QCAlgorithm_RegisterIndicator_T")
QuantConnect_Algorithm_QCAlgorithm_WarmUpIndicator_T = typing.TypeVar("QuantConnect_Algorithm_QCAlgorithm_WarmUpIndicator_T")
QuantConnect_Algorithm_QCAlgorithm_Consolidate_T = typing.TypeVar("QuantConnect_Algorithm_QCAlgorithm_Consolidate_T")
QuantConnect_Algorithm_QCAlgorithm_Plot_T = typing.TypeVar("QuantConnect_Algorithm_QCAlgorithm_Plot_T")
QuantConnect_Algorithm_QCAlgorithm_PlotIndicator_T = typing.TypeVar("QuantConnect_Algorithm_QCAlgorithm_PlotIndicator_T")
QuantConnect_Algorithm_QCAlgorithm_AddUniverse_T = typing.TypeVar("QuantConnect_Algorithm_QCAlgorithm_AddUniverse_T")
QuantConnect_Algorithm__EventContainer_Callable = typing.TypeVar("QuantConnect_Algorithm__EventContainer_Callable")
QuantConnect_Algorithm__EventContainer_ReturnType = typing.TypeVar("QuantConnect_Algorithm__EventContainer_ReturnType")


class IndexUniverseDefinitions(System.Object):
    """Provides helpers for defining universes based on index definitions"""

    @property
    def QC500(self) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new fine universe that contains the constituents of QC500 index based onthe company fundamentals
        The algorithm creates a default tradable and liquid universe containing 500 US equities
        which are chosen at the first trading day of each month.
        """
        ...

    def __init__(self, algorithm: QuantConnect.Algorithm.QCAlgorithm) -> None:
        """
        Initializes a new instance of the IndexUniverseDefinitions class
        
        :param algorithm: The algorithm instance, used for obtaining the default UniverseSettings
        """
        ...


class ConstituentUniverseDefinitions(System.Object):
    """
    Provides helpers for defining constituent universes based on the Morningstar
    asset classification AssetClassification https://www.morningstar.com/
    """

    def __init__(self, algorithm: QuantConnect.Interfaces.IAlgorithm) -> None:
        """
        Initializes a new instance of the ConstituentUniverseDefinitions class
        
        :param algorithm: The algorithm instance, used for obtaining the default UniverseSettings
        """
        ...

    def AerospaceAndDefense(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar AerospaceAndDefense industry group MorningstarIndustryGroupCode"""
        ...

    def AggressiveGrowth(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Universe which selects companies whose revenues and earnings have both been growing significantly faster than
        the general economy.
        """
        ...

    def Agriculture(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar Agriculture industry group MorningstarIndustryGroupCode"""
        ...

    def AssetManagement(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar AssetManagement industry group MorningstarIndustryGroupCode"""
        ...

    def Banks(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar Banks industry group MorningstarIndustryGroupCode"""
        ...

    def BeveragesAlcoholic(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar BeveragesAlcoholic industry group MorningstarIndustryGroupCode"""
        ...

    def BeveragesNonAlcoholic(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar BeveragesNonAlcoholic industry group MorningstarIndustryGroupCode"""
        ...

    def Biotechnology(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar Biotechnology industry group MorningstarIndustryGroupCode"""
        ...

    def BuildingMaterials(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar BuildingMaterials industry group MorningstarIndustryGroupCode"""
        ...

    def BusinessServices(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar BusinessServices industry group MorningstarIndustryGroupCode"""
        ...

    def CapitalMarkets(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar CapitalMarkets industry group MorningstarIndustryGroupCode"""
        ...

    def Chemicals(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar Chemicals industry group MorningstarIndustryGroupCode"""
        ...

    def ClassicGrowth(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Universe which selects companies that are growing respectably faster than the general economy, and often pay a
        steady dividend. They tend to be mature and solidly profitable businesses.
        """
        ...

    def Conglomerates(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar Conglomerates industry group MorningstarIndustryGroupCode"""
        ...

    def Construction(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar Construction industry group MorningstarIndustryGroupCode"""
        ...

    def ConsumerPackagedGoods(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar ConsumerPackagedGoods industry group MorningstarIndustryGroupCode"""
        ...

    def CreditServices(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar CreditServices industry group MorningstarIndustryGroupCode"""
        ...

    def Cyclicals(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Universe which selects companies in the cyclicals and durables sectors, except those in the three types below.
        The profits of cyclicals tend to rise and fall with the general economy.
        """
        ...

    def Distressed(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Universe which selects companies that have had consistently declining cash flows and earnings over the past
        three years, and/or very high debt.
        """
        ...

    def DiversifiedFinancialServices(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar DiversifiedFinancialServices industry group MorningstarIndustryGroupCode"""
        ...

    def DrugManufacturers(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar DrugManufacturers industry group MorningstarIndustryGroupCode"""
        ...

    def Education(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar Education industry group MorningstarIndustryGroupCode"""
        ...

    def FarmAndHeavyConstructionMachinery(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar FarmAndHeavyConstructionMachinery industry group MorningstarIndustryGroupCode"""
        ...

    def FixturesAndAppliances(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar FixturesAndAppliances industry group MorningstarIndustryGroupCode"""
        ...

    def ForestProducts(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar ForestProducts industry group MorningstarIndustryGroupCode"""
        ...

    def HardAsset(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Universe which selects companies that deal in assets such as oil, metals, and real estate, which tend to do
        well in inflationary environments.
        """
        ...

    def Hardware(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar Hardware industry group MorningstarIndustryGroupCode"""
        ...

    def HealthcarePlans(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar HealthcarePlans industry group MorningstarIndustryGroupCode"""
        ...

    def HealthcareProvidersAndServices(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar HealthcareProvidersAndServices industry group MorningstarIndustryGroupCode"""
        ...

    def HighYield(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Universe which selects companies that have dividend yields at least twice the average for large-cap stocks.
        They tend to be mature, slow-growing companies.
        """
        ...

    def HomebuildingAndConstruction(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar HomebuildingAndConstruction industry group MorningstarIndustryGroupCode"""
        ...

    def IndustrialDistribution(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar IndustrialDistribution industry group MorningstarIndustryGroupCode"""
        ...

    def IndustrialProducts(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar IndustrialProducts industry group MorningstarIndustryGroupCode"""
        ...

    def Insurance(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar Insurance industry group MorningstarIndustryGroupCode"""
        ...

    def InteractiveMedia(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar InteractiveMedia industry group MorningstarIndustryGroupCode"""
        ...

    def LargeCore(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Classifies securities according to market capitalization and growth and value factor"""
        ...

    def LargeGrowth(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Classifies securities according to market capitalization and growth and value factor"""
        ...

    def LargeValue(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Classifies securities according to market capitalization and growth and value factor"""
        ...

    def ManufacturingApparelAndAccessories(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar ManufacturingApparelAndAccessories industry group MorningstarIndustryGroupCode"""
        ...

    def MediaDiversified(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar MediaDiversified industry group MorningstarIndustryGroupCode"""
        ...

    def MedicalDevicesAndInstruments(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar MedicalDevicesAndInstruments industry group MorningstarIndustryGroupCode"""
        ...

    def MedicalDiagnosticsAndResearch(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar MedicalDiagnosticsAndResearch industry group MorningstarIndustryGroupCode"""
        ...

    def MedicalDistribution(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar MedicalDistribution industry group MorningstarIndustryGroupCode"""
        ...

    def MetalsAndMining(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar MetalsAndMining industry group MorningstarIndustryGroupCode"""
        ...

    def MidCore(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Classifies securities according to market capitalization and growth and value factor"""
        ...

    def MidGrowth(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Classifies securities according to market capitalization and growth and value factor"""
        ...

    def MidValue(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Classifies securities according to market capitalization and growth and value factor"""
        ...

    def OilAndGas(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar OilAndGas industry group MorningstarIndustryGroupCode"""
        ...

    def OtherEnergySources(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar OtherEnergySources industry group MorningstarIndustryGroupCode"""
        ...

    def PackagingAndContainers(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar PackagingAndContainers industry group MorningstarIndustryGroupCode"""
        ...

    def PersonalServices(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar PersonalServices industry group MorningstarIndustryGroupCode"""
        ...

    def RealEstate(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar RealEstate industry group MorningstarIndustryGroupCode"""
        ...

    def REITs(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar REITs industry group MorningstarIndustryGroupCode"""
        ...

    def Restaurants(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar Restaurants industry group MorningstarIndustryGroupCode"""
        ...

    def RetailCyclical(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar RetailCyclical industry group MorningstarIndustryGroupCode"""
        ...

    def RetailDefensive(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar RetailDefensive industry group MorningstarIndustryGroupCode"""
        ...

    def Semiconductors(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar Semiconductors industry group MorningstarIndustryGroupCode"""
        ...

    def SlowGrowth(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Universe which selects companies that have shown slow revenue and earnings growth (typically less than the rate
        of GDP growth) over at least three years.
        """
        ...

    def SmallCore(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Classifies securities according to market capitalization and growth and value factor"""
        ...

    def SmallGrowth(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Classifies securities according to market capitalization and growth and value factor"""
        ...

    def SmallValue(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Classifies securities according to market capitalization and growth and value factor"""
        ...

    def Software(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar Software industry group MorningstarIndustryGroupCode"""
        ...

    def SpeculativeGrowth(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Universe which selects companies that have shown strong revenue growth but slower or spotty earnings growth.
        Very small or young companies also tend to fall into this class.
        """
        ...

    def Steel(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar Steel industry group MorningstarIndustryGroupCode"""
        ...

    def TelecommunicationServices(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar TelecommunicationServices industry group MorningstarIndustryGroupCode"""
        ...

    def TobaccoProducts(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar TobaccoProducts industry group MorningstarIndustryGroupCode"""
        ...

    def Transportation(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar Transportation industry group MorningstarIndustryGroupCode"""
        ...

    def TravelAndLeisure(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar TravelAndLeisure industry group MorningstarIndustryGroupCode"""
        ...

    def UtilitiesIndependentPowerProducers(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar UtilitiesIndependentPowerProducers industry group MorningstarIndustryGroupCode"""
        ...

    def UtilitiesRegulated(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar UtilitiesRegulated industry group MorningstarIndustryGroupCode"""
        ...

    def VehiclesAndParts(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar VehiclesAndParts industry group MorningstarIndustryGroupCode"""
        ...

    def WasteManagement(self, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """Morningstar WasteManagement industry group MorningstarIndustryGroupCode"""
        ...


class UniverseDefinitions(System.Object):
    """Provides helpers for defining universes in algorithms"""

    @property
    def Unchanged(self) -> QuantConnect.Data.UniverseSelection.Universe.UnchangedUniverse:
        """Specifies that universe selection should not make changes on this iteration"""
        ...

    @property
    def DollarVolume(self) -> QuantConnect.Algorithm.DollarVolumeUniverseDefinitions:
        """Gets a helper that provides methods for creating universes based on daily dollar volumes"""
        ...

    @DollarVolume.setter
    def DollarVolume(self, value: QuantConnect.Algorithm.DollarVolumeUniverseDefinitions):
        """Gets a helper that provides methods for creating universes based on daily dollar volumes"""
        ...

    @property
    def Index(self) -> QuantConnect.Algorithm.IndexUniverseDefinitions:
        """Gets a helper that provides methods for creating universes based on index definitions"""
        ...

    @Index.setter
    def Index(self, value: QuantConnect.Algorithm.IndexUniverseDefinitions):
        """Gets a helper that provides methods for creating universes based on index definitions"""
        ...

    @property
    def Constituent(self) -> QuantConnect.Algorithm.ConstituentUniverseDefinitions:
        """Gets a helper that provides methods for creating constituent universes"""
        ...

    def __init__(self, algorithm: QuantConnect.Algorithm.QCAlgorithm) -> None:
        """
        Initializes a new instance of the UniverseDefinitions class
        
        :param algorithm: The algorithm instance, used for obtaining the default UniverseSettings
        """
        ...


class CandlestickPatterns(System.Object):
    """Provides helpers for using candlestick patterns"""

    def __init__(self, algorithm: QuantConnect.Algorithm.QCAlgorithm) -> None:
        """
        Initializes a new instance of the CandlestickPatterns class
        
        :param algorithm: The algorithm instance
        """
        ...

    def AbandonedBaby(self, symbol: typing.Union[QuantConnect.Symbol, str], penetration: float = 0.3, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.AbandonedBaby:
        """
        Creates a new Indicators.CandlestickPatterns.AbandonedBaby pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param penetration: Percentage of penetration of a candle within another candle
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def AdvanceBlock(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.AdvanceBlock:
        """
        Creates a new Indicators.CandlestickPatterns.AdvanceBlock pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def BeltHold(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.BeltHold:
        """
        Creates a new Indicators.CandlestickPatterns.BeltHold pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def Breakaway(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.Breakaway:
        """
        Creates a new Indicators.CandlestickPatterns.Breakaway pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def ClosingMarubozu(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.ClosingMarubozu:
        """
        Creates a new Indicators.CandlestickPatterns.ClosingMarubozu pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def ConcealedBabySwallow(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.ConcealedBabySwallow:
        """
        Creates a new Indicators.CandlestickPatterns.ConcealedBabySwallow pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def Counterattack(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.Counterattack:
        """
        Creates a new Indicators.CandlestickPatterns.Counterattack pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def DarkCloudCover(self, symbol: typing.Union[QuantConnect.Symbol, str], penetration: float = 0.5, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.DarkCloudCover:
        """
        Creates a new Indicators.CandlestickPatterns.DarkCloudCover pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param penetration: Percentage of penetration of a candle within another candle
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def Doji(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.Doji:
        """
        Creates a new Indicators.CandlestickPatterns.Doji pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def DojiStar(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.DojiStar:
        """
        Creates a new Indicators.CandlestickPatterns.DojiStar pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def DragonflyDoji(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.DragonflyDoji:
        """
        Creates a new Indicators.CandlestickPatterns.DragonflyDoji pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def Engulfing(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.Engulfing:
        """
        Creates a new Indicators.CandlestickPatterns.Engulfing pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def EveningDojiStar(self, symbol: typing.Union[QuantConnect.Symbol, str], penetration: float = 0.3, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.EveningDojiStar:
        """
        Creates a new Indicators.CandlestickPatterns.EveningDojiStar pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param penetration: Percentage of penetration of a candle within another candle
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def EveningStar(self, symbol: typing.Union[QuantConnect.Symbol, str], penetration: float = 0.3, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.EveningStar:
        """
        Creates a new Indicators.CandlestickPatterns.EveningStar pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param penetration: Percentage of penetration of a candle within another candle
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def GapSideBySideWhite(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.GapSideBySideWhite:
        """
        Creates a new Indicators.CandlestickPatterns.GapSideBySideWhite pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def GravestoneDoji(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.GravestoneDoji:
        """
        Creates a new Indicators.CandlestickPatterns.GravestoneDoji pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def Hammer(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.Hammer:
        """
        Creates a new Indicators.CandlestickPatterns.Hammer pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def HangingMan(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.HangingMan:
        """
        Creates a new Indicators.CandlestickPatterns.HangingMan pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def Harami(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.Harami:
        """
        Creates a new Indicators.CandlestickPatterns.Harami pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def HaramiCross(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.HaramiCross:
        """
        Creates a new Indicators.CandlestickPatterns.HaramiCross pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def HighWaveCandle(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.HighWaveCandle:
        """
        Creates a new Indicators.CandlestickPatterns.HighWaveCandle pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def Hikkake(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.Hikkake:
        """
        Creates a new Indicators.CandlestickPatterns.Hikkake pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def HikkakeModified(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.HikkakeModified:
        """
        Creates a new Indicators.CandlestickPatterns.HikkakeModified pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def HomingPigeon(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.HomingPigeon:
        """
        Creates a new Indicators.CandlestickPatterns.HomingPigeon pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def IdenticalThreeCrows(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.IdenticalThreeCrows:
        """
        Creates a new Indicators.CandlestickPatterns.IdenticalThreeCrows pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def InNeck(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.InNeck:
        """
        Creates a new Indicators.CandlestickPatterns.InNeck pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def InvertedHammer(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.InvertedHammer:
        """
        Creates a new Indicators.CandlestickPatterns.InvertedHammer pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def Kicking(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.Kicking:
        """
        Creates a new Indicators.CandlestickPatterns.Kicking pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def KickingByLength(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.KickingByLength:
        """
        Creates a new Indicators.CandlestickPatterns.KickingByLength pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def LadderBottom(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.LadderBottom:
        """
        Creates a new Indicators.CandlestickPatterns.LadderBottom pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def LongLeggedDoji(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.LongLeggedDoji:
        """
        Creates a new Indicators.CandlestickPatterns.LongLeggedDoji pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def LongLineCandle(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.LongLineCandle:
        """
        Creates a new Indicators.CandlestickPatterns.LongLineCandle pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def Marubozu(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.Marubozu:
        """
        Creates a new Indicators.CandlestickPatterns.Marubozu pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def MatchingLow(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.MatchingLow:
        """
        Creates a new Indicators.CandlestickPatterns.MatchingLow pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def MatHold(self, symbol: typing.Union[QuantConnect.Symbol, str], penetration: float = 0.5, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.MatHold:
        """
        Creates a new Indicators.CandlestickPatterns.MatHold pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param penetration: Percentage of penetration of a candle within another candle
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def MorningDojiStar(self, symbol: typing.Union[QuantConnect.Symbol, str], penetration: float = 0.3, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.MorningDojiStar:
        """
        Creates a new Indicators.CandlestickPatterns.MorningDojiStar pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param penetration: Percentage of penetration of a candle within another candle
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def MorningStar(self, symbol: typing.Union[QuantConnect.Symbol, str], penetration: float = 0.3, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.MorningStar:
        """
        Creates a new Indicators.CandlestickPatterns.MorningStar pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param penetration: Percentage of penetration of a candle within another candle
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def OnNeck(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.OnNeck:
        """
        Creates a new Indicators.CandlestickPatterns.OnNeck pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def Piercing(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.Piercing:
        """
        Creates a new Indicators.CandlestickPatterns.Piercing pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def RickshawMan(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.RickshawMan:
        """
        Creates a new Indicators.CandlestickPatterns.RickshawMan pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def RiseFallThreeMethods(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.RiseFallThreeMethods:
        """
        Creates a new Indicators.CandlestickPatterns.RiseFallThreeMethods pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def SeparatingLines(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.SeparatingLines:
        """
        Creates a new Indicators.CandlestickPatterns.SeparatingLines pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def ShootingStar(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.ShootingStar:
        """
        Creates a new Indicators.CandlestickPatterns.ShootingStar pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def ShortLineCandle(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.ShortLineCandle:
        """
        Creates a new Indicators.CandlestickPatterns.ShortLineCandle pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def SpinningTop(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.SpinningTop:
        """
        Creates a new Indicators.CandlestickPatterns.SpinningTop pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def StalledPattern(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.StalledPattern:
        """
        Creates a new Indicators.CandlestickPatterns.StalledPattern pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def StickSandwich(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.StickSandwich:
        """
        Creates a new Indicators.CandlestickPatterns.StickSandwich pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def Takuri(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.Takuri:
        """
        Creates a new Indicators.CandlestickPatterns.Takuri pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def TasukiGap(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.TasukiGap:
        """
        Creates a new Indicators.CandlestickPatterns.TasukiGap pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def ThreeBlackCrows(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.ThreeBlackCrows:
        """
        Creates a new Indicators.CandlestickPatterns.ThreeBlackCrows pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def ThreeInside(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.ThreeInside:
        """
        Creates a new Indicators.CandlestickPatterns.ThreeInside pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def ThreeLineStrike(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.ThreeLineStrike:
        """
        Creates a new Indicators.CandlestickPatterns.ThreeLineStrike pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def ThreeOutside(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.ThreeOutside:
        """
        Creates a new Indicators.CandlestickPatterns.ThreeOutside pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def ThreeStarsInSouth(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.ThreeStarsInSouth:
        """
        Creates a new Indicators.CandlestickPatterns.ThreeStarsInSouth pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def ThreeWhiteSoldiers(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.ThreeWhiteSoldiers:
        """
        Creates a new Indicators.CandlestickPatterns.ThreeWhiteSoldiers pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def Thrusting(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.Thrusting:
        """
        Creates a new Indicators.CandlestickPatterns.Thrusting pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def Tristar(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.Tristar:
        """
        Creates a new Indicators.CandlestickPatterns.Tristar pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def TwoCrows(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.TwoCrows:
        """
        Creates a new Indicators.CandlestickPatterns.TwoCrows pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def UniqueThreeRiver(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.UniqueThreeRiver:
        """
        Creates a new Indicators.CandlestickPatterns.UniqueThreeRiver pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def UpDownGapThreeMethods(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.UpDownGapThreeMethods:
        """
        Creates a new Indicators.CandlestickPatterns.UpDownGapThreeMethods pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...

    def UpsideGapTwoCrows(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CandlestickPatterns.UpsideGapTwoCrows:
        """
        Creates a new Indicators.CandlestickPatterns.UpsideGapTwoCrows pattern indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose pattern we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The pattern indicator for the requested symbol.
        """
        ...


class QCAlgorithm(System.MarshalByRefObject, QuantConnect.Interfaces.IAlgorithm):
    """
    QC Algorithm Base Class - Handle the basic requirements of a trading algorithm,
    allowing user to focus on event methods. The QCAlgorithm class implements Portfolio,
    Securities, Transactions and Data Subscription Management.
    """

    @property
    def PandasConverter(self) -> QuantConnect.Python.PandasConverter:
        """PandasConverter for this Algorithm"""
        ...

    @PandasConverter.setter
    def PandasConverter(self, value: QuantConnect.Python.PandasConverter):
        """PandasConverter for this Algorithm"""
        ...

    @property
    def Transactions(self) -> QuantConnect.Securities.SecurityTransactionManager:
        """Transaction Manager - Process transaction fills and order management."""
        ...

    @Transactions.setter
    def Transactions(self, value: QuantConnect.Securities.SecurityTransactionManager):
        """Transaction Manager - Process transaction fills and order management."""
        ...

    @property
    def UniverseManager(self) -> QuantConnect.Securities.UniverseManager:
        """Gets universe manager which holds universes keyed by their symbol"""
        ...

    @UniverseManager.setter
    def UniverseManager(self, value: QuantConnect.Securities.UniverseManager):
        """Gets universe manager which holds universes keyed by their symbol"""
        ...

    @property
    def UniverseSettings(self) -> QuantConnect.Data.UniverseSelection.UniverseSettings:
        """Gets the universe settings to be used when adding securities via universe selection"""
        ...

    @UniverseSettings.setter
    def UniverseSettings(self, value: QuantConnect.Data.UniverseSelection.UniverseSettings):
        """Gets the universe settings to be used when adding securities via universe selection"""
        ...

    @property
    def Universe(self) -> QuantConnect.Algorithm.UniverseDefinitions:
        """Gets a helper that provides pre-defined universe definitions, such as top dollar volume"""
        ...

    @Universe.setter
    def Universe(self, value: QuantConnect.Algorithm.UniverseDefinitions):
        """Gets a helper that provides pre-defined universe definitions, such as top dollar volume"""
        ...

    @property
    def DebugMode(self) -> bool:
        """
        Enables additional logging of framework models including:
        All insights, portfolio targets, order events, and any risk management altered targets
        """
        ...

    @DebugMode.setter
    def DebugMode(self, value: bool):
        """
        Enables additional logging of framework models including:
        All insights, portfolio targets, order events, and any risk management altered targets
        """
        ...

    @property
    def UniverseSelection(self) -> QuantConnect.Algorithm.Framework.Selection.IUniverseSelectionModel:
        """Gets or sets the universe selection model."""
        ...

    @UniverseSelection.setter
    def UniverseSelection(self, value: QuantConnect.Algorithm.Framework.Selection.IUniverseSelectionModel):
        """Gets or sets the universe selection model."""
        ...

    @property
    def Alpha(self) -> QuantConnect.Algorithm.Framework.Alphas.IAlphaModel:
        """Gets or sets the alpha model"""
        ...

    @Alpha.setter
    def Alpha(self, value: QuantConnect.Algorithm.Framework.Alphas.IAlphaModel):
        """Gets or sets the alpha model"""
        ...

    @property
    def PortfolioConstruction(self) -> QuantConnect.Algorithm.Framework.Portfolio.IPortfolioConstructionModel:
        """Gets or sets the portfolio construction model"""
        ...

    @PortfolioConstruction.setter
    def PortfolioConstruction(self, value: QuantConnect.Algorithm.Framework.Portfolio.IPortfolioConstructionModel):
        """Gets or sets the portfolio construction model"""
        ...

    @property
    def Execution(self) -> QuantConnect.Algorithm.Framework.Execution.IExecutionModel:
        """Gets or sets the execution model"""
        ...

    @Execution.setter
    def Execution(self, value: QuantConnect.Algorithm.Framework.Execution.IExecutionModel):
        """Gets or sets the execution model"""
        ...

    @property
    def RiskManagement(self) -> QuantConnect.Algorithm.Framework.Risk.IRiskManagementModel:
        """Gets or sets the risk management model"""
        ...

    @RiskManagement.setter
    def RiskManagement(self, value: QuantConnect.Algorithm.Framework.Risk.IRiskManagementModel):
        """Gets or sets the risk management model"""
        ...

    @property
    def EnableAutomaticIndicatorWarmUp(self) -> bool:
        """Gets whether or not WarmUpIndicator is allowed to warm up indicators/>"""
        ...

    @EnableAutomaticIndicatorWarmUp.setter
    def EnableAutomaticIndicatorWarmUp(self, value: bool):
        """Gets whether or not WarmUpIndicator is allowed to warm up indicators/>"""
        ...

    @property
    def HistoryProvider(self) -> QuantConnect.Interfaces.IHistoryProvider:
        """Gets or sets the history provider for the algorithm"""
        ...

    @HistoryProvider.setter
    def HistoryProvider(self, value: QuantConnect.Interfaces.IHistoryProvider):
        """Gets or sets the history provider for the algorithm"""
        ...

    @property
    def IsWarmingUp(self) -> bool:
        """Gets whether or not this algorithm is still warming up"""
        ...

    @IsWarmingUp.setter
    def IsWarmingUp(self, value: bool):
        """Gets whether or not this algorithm is still warming up"""
        ...

    @property
    def MarketHoursDatabase(self) -> QuantConnect.Securities.MarketHoursDatabase:
        """
        Gets the market hours database in use by this algorithm
        
        This property is protected.
        """
        ...

    @property
    def SymbolPropertiesDatabase(self) -> QuantConnect.Securities.SymbolPropertiesDatabase:
        """
        Gets the symbol properties database in use by this algorithm
        
        This property is protected.
        """
        ...

    @property
    def InsightsGenerated(self) -> _EventContainer[typing.Callable[[QuantConnect.Interfaces.IAlgorithm, QuantConnect.Algorithm.Framework.Alphas.GeneratedInsightsCollection], None], None]:
        """Event fired when the algorithm generates insights"""
        ...

    @InsightsGenerated.setter
    def InsightsGenerated(self, value: _EventContainer[typing.Callable[[QuantConnect.Interfaces.IAlgorithm, QuantConnect.Algorithm.Framework.Alphas.GeneratedInsightsCollection], None], None]):
        """Event fired when the algorithm generates insights"""
        ...

    @property
    def Securities(self) -> QuantConnect.Securities.SecurityManager:
        """
        Security collection is an array of the security objects such as Equities and FOREX. Securities data
        manages the properties of tradeable assets such as price, open and close time and holdings information.
        """
        ...

    @Securities.setter
    def Securities(self, value: QuantConnect.Securities.SecurityManager):
        """
        Security collection is an array of the security objects such as Equities and FOREX. Securities data
        manages the properties of tradeable assets such as price, open and close time and holdings information.
        """
        ...

    @property
    def ActiveSecurities(self) -> System.Collections.Generic.IReadOnlyDictionary[QuantConnect.Symbol, QuantConnect.Securities.Security]:
        """
        Read-only dictionary containing all active securities. An active security is
        a security that is currently selected by the universe or has holdings or open orders.
        """
        ...

    @property
    def Portfolio(self) -> QuantConnect.Securities.SecurityPortfolioManager:
        """
        Portfolio object provieds easy access to the underlying security-holding properties; summed together in a way to make them useful.
        This saves the user time by providing common portfolio requests in a single
        """
        ...

    @Portfolio.setter
    def Portfolio(self, value: QuantConnect.Securities.SecurityPortfolioManager):
        """
        Portfolio object provieds easy access to the underlying security-holding properties; summed together in a way to make them useful.
        This saves the user time by providing common portfolio requests in a single
        """
        ...

    @property
    def AccountCurrency(self) -> str:
        """Gets the account currency"""
        ...

    @property
    def TimeKeeper(self) -> QuantConnect.Interfaces.ITimeKeeper:
        """Gets the time keeper instance"""
        ...

    @property
    def SubscriptionManager(self) -> QuantConnect.Data.SubscriptionManager:
        """
        Generic Data Manager - Required for compiling all data feeds in order, and passing them into algorithm event methods.
        The subscription manager contains a list of the data feed's we're subscribed to and properties of each data feed.
        """
        ...

    @SubscriptionManager.setter
    def SubscriptionManager(self, value: QuantConnect.Data.SubscriptionManager):
        """
        Generic Data Manager - Required for compiling all data feeds in order, and passing them into algorithm event methods.
        The subscription manager contains a list of the data feed's we're subscribed to and properties of each data feed.
        """
        ...

    @property
    def BrokerageModel(self) -> QuantConnect.Brokerages.IBrokerageModel:
        """Gets the brokerage model - used to model interactions with specific brokerages."""
        ...

    @BrokerageModel.setter
    def BrokerageModel(self, value: QuantConnect.Brokerages.IBrokerageModel):
        """Gets the brokerage model - used to model interactions with specific brokerages."""
        ...

    @property
    def BrokerageMessageHandler(self) -> QuantConnect.Brokerages.IBrokerageMessageHandler:
        """
        Gets the brokerage message handler used to decide what to do
        with each message sent from the brokerage
        """
        ...

    @BrokerageMessageHandler.setter
    def BrokerageMessageHandler(self, value: QuantConnect.Brokerages.IBrokerageMessageHandler):
        """
        Gets the brokerage message handler used to decide what to do
        with each message sent from the brokerage
        """
        ...

    @property
    def Notify(self) -> QuantConnect.Notifications.NotificationManager:
        """Notification Manager for Sending Live Runtime Notifications to users about important events."""
        ...

    @Notify.setter
    def Notify(self, value: QuantConnect.Notifications.NotificationManager):
        """Notification Manager for Sending Live Runtime Notifications to users about important events."""
        ...

    @property
    def Schedule(self) -> QuantConnect.Scheduling.ScheduleManager:
        """Gets schedule manager for adding/removing scheduled events"""
        ...

    @Schedule.setter
    def Schedule(self, value: QuantConnect.Scheduling.ScheduleManager):
        """Gets schedule manager for adding/removing scheduled events"""
        ...

    @property
    def Status(self) -> int:
        """
        Gets or sets the current status of the algorithm
        
        This property contains the int value of a member of the QuantConnect.AlgorithmStatus enum.
        """
        ...

    @Status.setter
    def Status(self, value: int):
        """
        Gets or sets the current status of the algorithm
        
        This property contains the int value of a member of the QuantConnect.AlgorithmStatus enum.
        """
        ...

    @property
    def SecurityInitializer(self) -> QuantConnect.Securities.ISecurityInitializer:
        """Gets an instance that is to be used to initialize newly created securities."""
        ...

    @SecurityInitializer.setter
    def SecurityInitializer(self, value: QuantConnect.Securities.ISecurityInitializer):
        """Gets an instance that is to be used to initialize newly created securities."""
        ...

    @property
    def TradeBuilder(self) -> QuantConnect.Interfaces.ITradeBuilder:
        """Gets the Trade Builder to generate trades from executions"""
        ...

    @TradeBuilder.setter
    def TradeBuilder(self, value: QuantConnect.Interfaces.ITradeBuilder):
        """Gets the Trade Builder to generate trades from executions"""
        ...

    @property
    def CandlestickPatterns(self) -> QuantConnect.Algorithm.CandlestickPatterns:
        """Gets an instance to access the candlestick pattern helper methods"""
        ...

    @CandlestickPatterns.setter
    def CandlestickPatterns(self, value: QuantConnect.Algorithm.CandlestickPatterns):
        """Gets an instance to access the candlestick pattern helper methods"""
        ...

    @property
    def DateRules(self) -> QuantConnect.Scheduling.DateRules:
        """Gets the date rules helper object to make specifying dates for events easier"""
        ...

    @property
    def TimeRules(self) -> QuantConnect.Scheduling.TimeRules:
        """Gets the time rules helper object to make specifying times for events easier"""
        ...

    @property
    def TradingCalendar(self) -> QuantConnect.TradingCalendar:
        """Gets trading calendar populated with trading events"""
        ...

    @TradingCalendar.setter
    def TradingCalendar(self, value: QuantConnect.TradingCalendar):
        """Gets trading calendar populated with trading events"""
        ...

    @property
    def Settings(self) -> QuantConnect.Interfaces.IAlgorithmSettings:
        """Gets the user settings for the algorithm"""
        ...

    @Settings.setter
    def Settings(self, value: QuantConnect.Interfaces.IAlgorithmSettings):
        """Gets the user settings for the algorithm"""
        ...

    @property
    def OptionChainProvider(self) -> QuantConnect.Interfaces.IOptionChainProvider:
        """Gets the option chain provider, used to get the list of option contracts for an underlying symbol"""
        ...

    @OptionChainProvider.setter
    def OptionChainProvider(self, value: QuantConnect.Interfaces.IOptionChainProvider):
        """Gets the option chain provider, used to get the list of option contracts for an underlying symbol"""
        ...

    @property
    def FutureChainProvider(self) -> QuantConnect.Interfaces.IFutureChainProvider:
        """Gets the future chain provider, used to get the list of future contracts for an underlying symbol"""
        ...

    @FutureChainProvider.setter
    def FutureChainProvider(self, value: QuantConnect.Interfaces.IFutureChainProvider):
        """Gets the future chain provider, used to get the list of future contracts for an underlying symbol"""
        ...

    @property
    def DefaultOrderProperties(self) -> QuantConnect.Interfaces.IOrderProperties:
        """Gets the default order properties"""
        ...

    @DefaultOrderProperties.setter
    def DefaultOrderProperties(self, value: QuantConnect.Interfaces.IOrderProperties):
        """Gets the default order properties"""
        ...

    @property
    def Name(self) -> str:
        """
        Public name for the algorithm as automatically generated by the IDE. Intended for helping distinguish logs by noting
        the algorithm-id.
        """
        ...

    @Name.setter
    def Name(self, value: str):
        """
        Public name for the algorithm as automatically generated by the IDE. Intended for helping distinguish logs by noting
        the algorithm-id.
        """
        ...

    @property
    def Time(self) -> datetime.datetime:
        """Read-only value for current time frontier of the algorithm in terms of the TimeZone"""
        ...

    @property
    def UtcTime(self) -> datetime.datetime:
        """Current date/time in UTC."""
        ...

    @property
    def TimeZone(self) -> typing.Any:
        """
        Gets the time zone used for the Time property. The default value
        is TimeZones.NewYork
        """
        ...

    @property
    def StartDate(self) -> datetime.datetime:
        """Value of the user set start-date from the backtest."""
        ...

    @property
    def EndDate(self) -> datetime.datetime:
        """Value of the user set start-date from the backtest. Controls the period of the backtest."""
        ...

    @property
    def AlgorithmId(self) -> str:
        """Algorithm Id for this backtest or live algorithm."""
        ...

    @property
    def LiveMode(self) -> bool:
        """Boolean property indicating the algorithm is currently running in live mode."""
        ...

    @property
    def DebugMessages(self) -> System.Collections.Concurrent.ConcurrentQueue[str]:
        """Storage for debugging messages before the event handler has passed control back to the Lean Engine."""
        ...

    @DebugMessages.setter
    def DebugMessages(self, value: System.Collections.Concurrent.ConcurrentQueue[str]):
        """Storage for debugging messages before the event handler has passed control back to the Lean Engine."""
        ...

    @property
    def LogMessages(self) -> System.Collections.Concurrent.ConcurrentQueue[str]:
        """Storage for log messages before the event handlers have passed control back to the Lean Engine."""
        ...

    @LogMessages.setter
    def LogMessages(self, value: System.Collections.Concurrent.ConcurrentQueue[str]):
        """Storage for log messages before the event handlers have passed control back to the Lean Engine."""
        ...

    @property
    def RunTimeError(self) -> System.Exception:
        """Gets the run time error from the algorithm, or null if none was encountered."""
        ...

    @RunTimeError.setter
    def RunTimeError(self, value: System.Exception):
        """Gets the run time error from the algorithm, or null if none was encountered."""
        ...

    @property
    def ErrorMessages(self) -> System.Collections.Concurrent.ConcurrentQueue[str]:
        """List of error messages generated by the user's code calling the "Error" function."""
        ...

    @ErrorMessages.setter
    def ErrorMessages(self, value: System.Collections.Concurrent.ConcurrentQueue[str]):
        """List of error messages generated by the user's code calling the "Error" function."""
        ...

    @property
    def CurrentSlice(self) -> QuantConnect.Data.Slice:
        """Returns the current Slice object"""
        ...

    @CurrentSlice.setter
    def CurrentSlice(self, value: QuantConnect.Data.Slice):
        """Returns the current Slice object"""
        ...

    @property
    def ObjectStore(self) -> QuantConnect.Storage.ObjectStore:
        """Gets the object store, used for persistence"""
        ...

    @ObjectStore.setter
    def ObjectStore(self, value: QuantConnect.Storage.ObjectStore):
        """Gets the object store, used for persistence"""
        ...

    @property
    def Benchmark(self) -> QuantConnect.Benchmarks.IBenchmark:
        """Benchmark"""
        ...

    @Benchmark.setter
    def Benchmark(self, value: QuantConnect.Benchmarks.IBenchmark):
        """Benchmark"""
        ...

    @property
    def RuntimeStatistics(self) -> System.Collections.Concurrent.ConcurrentDictionary[str, str]:
        """Access to the runtime statistics property. User provided statistics."""
        ...

    def __init__(self) -> None:
        """
        QCAlgorithm Base Class Constructor - Initialize the underlying QCAlgorithm components.
        QCAlgorithm manages the transactions, portfolio, charting and security subscriptions for the users algorithms.
        """
        ...

    def ABANDS(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, width: float = 4, movingAverageType: QuantConnect.Indicators.MovingAverageType = ..., resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.TradeBar] = None) -> QuantConnect.Indicators.AccelerationBands:
        """
        Creates a new Acceleration Bands indicator.
        
        :param symbol: The symbol whose Acceleration Bands we want.
        :param period: The period of the three moving average (middle, upper and lower band).
        :param width: A coefficient specifying the distance between the middle band and upper or lower bands.
        :param movingAverageType: Type of the moving average.
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar.
        """
        ...

    def AD(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.TradeBar] = None) -> QuantConnect.Indicators.AccumulationDistribution:
        """
        Creates a new AccumulationDistribution indicator.
        
        :param symbol: The symbol whose AD we want
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The AccumulationDistribution indicator for the requested symbol over the speified period.
        """
        ...

    def AddAlpha(self, alpha: QuantConnect.Algorithm.Framework.Alphas.IAlphaModel) -> None:
        """
        Adds a new alpha model
        
        :param alpha: Model that generates alpha to add
        """
        ...

    def AddCfd(self, ticker: str, resolution: typing.Optional[QuantConnect.Resolution] = None, market: str = None, fillDataForward: bool = True, leverage: float = ...) -> QuantConnect.Securities.Cfd.Cfd:
        """
        Creates and adds a new Cfd security to the algorithm
        
        :param ticker: The currency pair
        :param resolution: The Resolution of market data, Tick, Second, Minute, Hour, or Daily. Default is Resolution.Minute
        :param market: The cfd trading market, . Default value is null and looked up using BrokerageModel.DefaultMarkets in AddSecurity{T}
        :param fillDataForward: If true, returns the last available data even if none in that timeslice. Default is true
        :param leverage: The requested leverage for this equity. Default is set by SecurityInitializer
        :returns: The new Cfd security.
        """
        ...

    def AddChart(self, chart: QuantConnect.Chart) -> None:
        """
        Add a Chart object to algorithm collection
        
        :param chart: Chart object to add to collection.
        """
        ...

    def AddCrypto(self, ticker: str, resolution: typing.Optional[QuantConnect.Resolution] = None, market: str = None, fillDataForward: bool = True, leverage: float = ...) -> QuantConnect.Securities.Crypto.Crypto:
        """
        Creates and adds a new Crypto security to the algorithm
        
        :param ticker: The currency pair
        :param resolution: The Resolution of market data, Tick, Second, Minute, Hour, or Daily. Default is Resolution.Minute
        :param market: The cfd trading market, . Default value is null and looked up using BrokerageModel.DefaultMarkets in AddSecurity{T}
        :param fillDataForward: If true, returns the last available data even if none in that timeslice. Default is true
        :param leverage: The requested leverage for this equity. Default is set by SecurityInitializer
        :returns: The new Crypto security.
        """
        ...

    @typing.overload
    def AddData(self, type: typing.Type, ticker: str, resolution: typing.Optional[QuantConnect.Resolution] = None) -> QuantConnect.Securities.Security:
        """
        AddData a new user defined data source, requiring only the minimum config options.
        The data is added with a default time zone of NewYork (Eastern Daylight Savings Time).
        This method is meant for custom data types that require a ticker, but have no underlying Symbol.
        Examples of data sources that meet this criteria are U.S. Treasury Yield Curve Rates and Trading Economics data
        
        :param type: Data source type
        :param ticker: Key/Ticker for data
        :param resolution: Resolution of the data
        :returns: The new Security.
        """
        ...

    @typing.overload
    def AddData(self, type: typing.Type, underlying: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None) -> QuantConnect.Securities.Security:
        """
        AddData a new user defined data source, requiring only the minimum config options.
        The data is added with a default time zone of NewYork (Eastern Daylight Savings Time).
        This adds a Symbol to the `Underlying` property in the custom data Symbol object.
        Use this method when adding custom data with a ticker from the past, such as "AOL"
        before it became "TWX", or if you need to filter using custom data and place trades on the
        Symbol associated with the custom data.
        
        :param type: Data source type
        :param underlying: The underlying symbol for the custom data
        :param resolution: Resolution of the data
        :returns: The new Security.
        """
        ...

    @typing.overload
    def AddData(self, type: typing.Type, ticker: str, resolution: typing.Optional[QuantConnect.Resolution], timeZone: typing.Any, fillDataForward: bool = False, leverage: float = 1.0) -> QuantConnect.Securities.Security:
        """
        AddData a new user defined data source, requiring only the minimum config options.
        This method is meant for custom data types that require a ticker, but have no underlying Symbol.
        Examples of data sources that meet this criteria are U.S. Treasury Yield Curve Rates and Trading Economics data
        
        :param type: Data source type
        :param ticker: Key/Ticker for data
        :param resolution: Resolution of the Data Required
        :param timeZone: Specifies the time zone of the raw data
        :param fillDataForward: When no data available on a tradebar, return the last data that was generated
        :param leverage: Custom leverage per security
        :returns: The new Security.
        """
        ...

    @typing.overload
    def AddData(self, type: typing.Type, underlying: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution], timeZone: typing.Any, fillDataForward: bool = False, leverage: float = 1.0) -> QuantConnect.Securities.Security:
        """
        AddData a new user defined data source, requiring only the minimum config options.
        This adds a Symbol to the `Underlying` property in the custom data Symbol object.
        Use this method when adding custom data with a ticker from the past, such as "AOL"
        before it became "TWX", or if you need to filter using custom data and place trades on the
        Symbol associated with the custom data.
        
        :param type: Data source type
        :param underlying: The underlying symbol for the custom data
        :param resolution: Resolution of the Data Required
        :param timeZone: Specifies the time zone of the raw data
        :param fillDataForward: When no data available on a tradebar, return the last data that was generated
        :param leverage: Custom leverage per security
        :returns: The new Security.
        """
        ...

    @typing.overload
    def AddData(self, dataType: typing.Type, ticker: str, resolution: typing.Optional[QuantConnect.Resolution], timeZone: typing.Any, fillDataForward: bool = False, leverage: float = 1.0) -> QuantConnect.Securities.Security:
        """
        AddData a new user defined data source, requiring only the minimum config options.
        This method is meant for custom data types that require a ticker, but have no underlying Symbol.
        Examples of data sources that meet this criteria are U.S. Treasury Yield Curve Rates and Trading Economics data
        
        :param dataType: Data source type
        :param ticker: Key/Ticker for data
        :param resolution: Resolution of the Data Required
        :param timeZone: Specifies the time zone of the raw data
        :param fillDataForward: When no data available on a tradebar, return the last data that was generated
        :param leverage: Custom leverage per security
        :returns: The new Security.
        """
        ...

    @typing.overload
    def AddData(self, dataType: typing.Type, underlying: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, timeZone: typing.Any = None, fillDataForward: bool = False, leverage: float = 1.0) -> QuantConnect.Securities.Security:
        """
        AddData a new user defined data source, requiring only the minimum config options.
        This adds a Symbol to the `Underlying` property in the custom data Symbol object.
        Use this method when adding custom data with a ticker from the past, such as "AOL"
        before it became "TWX", or if you need to filter using custom data and place trades on the
        Symbol associated with the custom data.
        
        :param dataType: Data source type
        :param resolution: Resolution of the Data Required
        :param timeZone: Specifies the time zone of the raw data
        :param fillDataForward: When no data available on a tradebar, return the last data that was generated
        :param leverage: Custom leverage per security
        :returns: The new Security.
        """
        ...

    @typing.overload
    def AddData(self, type: typing.Type, ticker: str, properties: QuantConnect.Securities.SymbolProperties, exchangeHours: QuantConnect.Securities.SecurityExchangeHours, resolution: typing.Optional[QuantConnect.Resolution] = None, fillDataForward: bool = False, leverage: float = 1.0) -> QuantConnect.Securities.Security:
        """
        AddData a new user defined data source including symbol properties and exchange hours,
        all other vars are not required and will use defaults.
        This overload reflects the C# equivalent for custom properties and market hours
        
        :param type: Data source type
        :param ticker: Key/Ticker for data
        :param properties: The properties of this new custom data
        :param exchangeHours: The Exchange hours of this symbol
        :param resolution: Resolution of the Data Required
        :param fillDataForward: When no data available on a tradebar, return the last data that was generated
        :param leverage: Custom leverage per security
        :returns: The new Security.
        """
        ...

    @typing.overload
    def AddData(self, ticker: str, resolution: typing.Optional[QuantConnect.Resolution] = None) -> QuantConnect.Securities.Security:
        """
        AddData a new user defined data source, requiring only the minimum config options.
        The data is added with a default time zone of NewYork (Eastern Daylight Savings Time)
        
        :param ticker: Key/Ticker for data
        :param resolution: Resolution of the data
        :returns: The new Security.
        """
        ...

    @typing.overload
    def AddData(self, underlying: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None) -> QuantConnect.Securities.Security:
        """
        AddData a new user defined data source, requiring only the minimum config options.
        The data is added with a default time zone of NewYork (Eastern Daylight Savings Time)
        
        :param underlying: The underlying symbol for the custom data
        :param resolution: Resolution of the data
        :returns: The new Security.
        """
        ...

    @typing.overload
    def AddData(self, ticker: str, resolution: typing.Optional[QuantConnect.Resolution], fillDataForward: bool, leverage: float = 1.0) -> QuantConnect.Securities.Security:
        """
        AddData a new user defined data source, requiring only the minimum config options.
        The data is added with a default time zone of NewYork (Eastern Daylight Savings Time)
        
        :param ticker: Key/Ticker for data
        :param resolution: Resolution of the Data Required
        :param fillDataForward: When no data available on a tradebar, return the last data that was generated
        :param leverage: Custom leverage per security
        :returns: The new Security.
        """
        ...

    @typing.overload
    def AddData(self, underlying: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution], fillDataForward: bool, leverage: float = 1.0) -> QuantConnect.Securities.Security:
        """
        AddData a new user defined data source, requiring only the minimum config options.
        The data is added with a default time zone of NewYork (Eastern Daylight Savings Time)
        
        :param underlying: The underlying symbol for the custom data
        :param resolution: Resolution of the Data Required
        :param fillDataForward: When no data available on a tradebar, return the last data that was generated
        :param leverage: Custom leverage per security
        :returns: The new Security.
        """
        ...

    @typing.overload
    def AddData(self, ticker: str, resolution: typing.Optional[QuantConnect.Resolution], timeZone: typing.Any, fillDataForward: bool = False, leverage: float = 1.0) -> QuantConnect.Securities.Security:
        """
        AddData a new user defined data source, requiring only the minimum config options.
        
        :param ticker: Key/Ticker for data
        :param resolution: Resolution of the Data Required
        :param timeZone: Specifies the time zone of the raw data
        :param fillDataForward: When no data available on a tradebar, return the last data that was generated
        :param leverage: Custom leverage per security
        :returns: The new Security.
        """
        ...

    @typing.overload
    def AddData(self, underlying: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution], timeZone: typing.Any, fillDataForward: bool = False, leverage: float = 1.0) -> QuantConnect.Securities.Security:
        """
        AddData a new user defined data source, requiring only the minimum config options.
        
        :param underlying: The underlying symbol for the custom data
        :param resolution: Resolution of the Data Required
        :param timeZone: Specifies the time zone of the raw data
        :param fillDataForward: When no data available on a tradebar, return the last data that was generated
        :param leverage: Custom leverage per security
        :returns: The new Security.
        """
        ...

    @typing.overload
    def AddData(self, ticker: str, properties: QuantConnect.Securities.SymbolProperties, exchangeHours: QuantConnect.Securities.SecurityExchangeHours, resolution: typing.Optional[QuantConnect.Resolution] = None, fillDataForward: bool = False, leverage: float = 1.0) -> QuantConnect.Securities.Security:
        """
        AddData a new user defined data source including symbol properties and exchange hours,
        all other vars are not required and will use defaults.
        
        :param ticker: Key/Ticker for data
        :param properties: The properties of this new custom data
        :param exchangeHours: The Exchange hours of this symbol
        :param resolution: Resolution of the Data Required
        :param fillDataForward: When no data available on a tradebar, return the last data that was generated
        :param leverage: Custom leverage per security
        :returns: The new Security.
        """
        ...

    def AddEquity(self, ticker: str, resolution: typing.Optional[QuantConnect.Resolution] = None, market: str = None, fillDataForward: bool = True, leverage: float = ..., extendedMarketHours: bool = False) -> QuantConnect.Securities.Equity.Equity:
        """
        Creates and adds a new Equity security to the algorithm
        
        :param ticker: The equity ticker symbol
        :param resolution: The Resolution of market data, Tick, Second, Minute, Hour, or Daily. Default is Resolution.Minute
        :param market: The equity's market, . Default value is null and looked up using BrokerageModel.DefaultMarkets in AddSecurity{T}
        :param fillDataForward: If true, returns the last available data even if none in that timeslice. Default is true
        :param leverage: The requested leverage for this equity. Default is set by SecurityInitializer
        :param extendedMarketHours: True to send data during pre and post market sessions. Default is false
        :returns: The new Equity security.
        """
        ...

    def AddForex(self, ticker: str, resolution: typing.Optional[QuantConnect.Resolution] = None, market: str = None, fillDataForward: bool = True, leverage: float = ...) -> QuantConnect.Securities.Forex.Forex:
        """
        Creates and adds a new Forex security to the algorithm
        
        :param ticker: The currency pair
        :param resolution: The Resolution of market data, Tick, Second, Minute, Hour, or Daily. Default is Resolution.Minute
        :param market: The foreign exchange trading market, . Default value is null and looked up using BrokerageModel.DefaultMarkets in AddSecurity{T}
        :param fillDataForward: If true, returns the last available data even if none in that timeslice. Default is true
        :param leverage: The requested leverage for this equity. Default is set by SecurityInitializer
        :returns: The new Forex security.
        """
        ...

    def AddFuture(self, ticker: str, resolution: typing.Optional[QuantConnect.Resolution] = None, market: str = None, fillDataForward: bool = True, leverage: float = ...) -> QuantConnect.Securities.Future.Future:
        """
        Creates and adds a new Future security to the algorithm
        
        :param ticker: The future ticker
        :param resolution: The Resolution of market data, Tick, Second, Minute, Hour, or Daily. Default is Resolution.Minute
        :param market: The futures market, . Default is value null and looked up using BrokerageModel.DefaultMarkets in AddSecurity{T}
        :param fillDataForward: If true, returns the last available data even if none in that timeslice. Default is true
        :param leverage: The requested leverage for this equity. Default is set by SecurityInitializer
        :returns: The new Future security.
        """
        ...

    def AddFutureContract(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, fillDataForward: bool = True, leverage: float = ...) -> QuantConnect.Securities.Future.Future:
        """
        Creates and adds a new single Future contract to the algorithm
        
        :param symbol: The futures contract symbol
        :param resolution: The Resolution of market data, Tick, Second, Minute, Hour, or Daily. Default is Resolution.Minute
        :param fillDataForward: If true, returns the last available data even if none in that timeslice. Default is true
        :param leverage: The requested leverage for this equity. Default is set by SecurityInitializer
        :returns: The new Future security.
        """
        ...

    def AddFutureOption(self, symbol: typing.Union[QuantConnect.Symbol, str], optionFilter: typing.Callable[[QuantConnect.Securities.OptionFilterUniverse], QuantConnect.Securities.OptionFilterUniverse] = None) -> None:
        """
        Creates and adds a new Future Option contract to the algorithm.
        
        :param symbol: The Future canonical symbol (i.e. Symbol returned from AddFuture)
        :param optionFilter: Filter to apply to option contracts loaded as part of the universe
        :returns: The new Option security, containing a Future as its underlying.
        """
        ...

    def AddFutureOptionContract(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, fillDataForward: bool = True, leverage: float = ...) -> QuantConnect.Securities.Option.Option:
        """
        Adds a future option contract to the algorithm.
        
        :param symbol: Option contract Symbol
        :param resolution: Resolution of the option contract, i.e. the granularity of the data
        :param fillDataForward: If true, this will fill in missing data points with the previous data point
        :param leverage: The leverage to apply to the option contract
        :returns: Option security.
        """
        ...

    def AddIndex(self, ticker: str, resolution: typing.Optional[QuantConnect.Resolution] = None, market: str = None, fillDataForward: bool = True) -> QuantConnect.Securities.Index.Index:
        """
        Creates and adds a new Index security to the algorithm
        
        :param ticker: The currency pair
        :param resolution: The Resolution of market data, Tick, Second, Minute, Hour, or Daily. Default is Resolution.Minute
        :param market: The index trading market, . Default value is null and looked up using BrokerageModel.DefaultMarkets in AddSecurity{T}
        :param fillDataForward: If true, returns the last available data even if none in that timeslice. Default is true
        :returns: The new Index security.
        """
        ...

    @typing.overload
    def AddIndexOption(self, ticker: str, resolution: typing.Optional[QuantConnect.Resolution] = None, market: str = ..., fillDataForward: bool = True) -> QuantConnect.Securities.Option.Option:
        """
        Creates and adds index options to the algorithm.
        
        :param ticker: The ticker of the Index Option
        :param resolution: Resolution of the index option contracts, i.e. the granularity of the data
        :param market: Market of the index option. If no market is provided, we default to Market.USA
        :param fillDataForward: If true, this will fill in missing data points with the previous data point
        :returns: Canonical Option security.
        """
        ...

    @typing.overload
    def AddIndexOption(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, fillDataForward: bool = True) -> QuantConnect.Securities.Option.Option:
        """
        Creates and adds index options to the algorithm.
        
        :param symbol: The Symbol of the Security returned from AddIndex
        :param resolution: Resolution of the index option contracts, i.e. the granularity of the data
        :param fillDataForward: If true, this will fill in missing data points with the previous data point
        :returns: Canonical Option security.
        """
        ...

    def AddIndexOptionContract(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, fillDataForward: bool = True) -> QuantConnect.Securities.Option.Option:
        """
        Adds an index option contract to the algorithm.
        
        :param symbol: Symbol of the index option contract
        :param resolution: Resolution of the index option contract, i.e. the granularity of the data
        :param fillDataForward: If true, this will fill in missing data points with the previous data point
        :returns: Index Option Contract.
        """
        ...

    @typing.overload
    def AddOption(self, underlying: str, resolution: typing.Optional[QuantConnect.Resolution] = None, market: str = None, fillDataForward: bool = True, leverage: float = ...) -> QuantConnect.Securities.Option.Option:
        """
        Creates and adds a new equity Option security to the algorithm
        
        :param underlying: The underlying equity ticker
        :param resolution: The Resolution of market data, Tick, Second, Minute, Hour, or Daily. Default is Resolution.Minute
        :param market: The equity's market, . Default is value null and looked up using BrokerageModel.DefaultMarkets in AddSecurity{T}
        :param fillDataForward: If true, returns the last available data even if none in that timeslice. Default is true
        :param leverage: The requested leverage for this equity. Default is set by SecurityInitializer
        :returns: The new Option security.
        """
        ...

    @typing.overload
    def AddOption(self, underlying: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, market: str = None, fillDataForward: bool = True, leverage: float = ...) -> QuantConnect.Securities.Option.Option:
        """
        Creates and adds a new Option security to the algorithm.
        This method can be used to add options with non-equity asset classes
        to the algorithm (e.g. Future Options).
        
        :param underlying: Underlying asset Symbol to use as the option's underlying
        :param resolution: The Resolution of market data, Tick, Second, Minute, Hour, or Daily. Default is Resolution.Minute
        :param market: The option's market, . Default value is null, but will be resolved using BrokerageModel.DefaultMarkets in AddSecurity{T}
        :param fillDataForward: If true, data will be provided to the algorithm every Second, Minute, Hour, or Day, while the asset is open and depending on the Resolution this option was configured to use.
        :param leverage: The requested leverage for the
        """
        ...

    def AddOptionContract(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, fillDataForward: bool = True, leverage: float = ...) -> QuantConnect.Securities.Option.Option:
        """
        Creates and adds a new single Option contract to the algorithm
        
        :param symbol: The option contract symbol
        :param resolution: The Resolution of market data, Tick, Second, Minute, Hour, or Daily. Default is Resolution.Minute
        :param fillDataForward: If true, returns the last available data even if none in that timeslice. Default is true
        :param leverage: The requested leverage for this equity. Default is set by SecurityInitializer
        :returns: The new Option security.
        """
        ...

    def AddRiskManagement(self, riskManagement: QuantConnect.Algorithm.Framework.Risk.IRiskManagementModel) -> None:
        """
        Adds a new risk management model
        
        :param riskManagement: Model defining how risk is managed to add
        """
        ...

    @typing.overload
    def AddSecurity(self, securityType: QuantConnect.SecurityType, ticker: str, resolution: typing.Optional[QuantConnect.Resolution] = None, fillDataForward: bool = True, extendedMarketHours: bool = False) -> QuantConnect.Securities.Security:
        """
        Add specified data to our data subscriptions. QuantConnect will funnel this data to the handle data routine.
        
        :param securityType: MarketType Type: Equity, Commodity, Future, FOREX or Crypto
        :param ticker: The security ticker
        :param resolution: Resolution of the Data Required
        :param fillDataForward: When no data available on a tradebar, return the last data that was generated
        :param extendedMarketHours: Show the after market data as well
        """
        ...

    @typing.overload
    def AddSecurity(self, securityType: QuantConnect.SecurityType, ticker: str, resolution: typing.Optional[QuantConnect.Resolution], fillDataForward: bool, leverage: float, extendedMarketHours: bool) -> QuantConnect.Securities.Security:
        """
        Add specified data to required list. QC will funnel this data to the handle data routine.
        
        :param securityType: MarketType Type: Equity, Commodity, Future, FOREX or Crypto
        :param ticker: The security ticker
        :param resolution: Resolution of the Data Required
        :param fillDataForward: When no data available on a tradebar, return the last data that was generated
        :param leverage: Custom leverage per security
        :param extendedMarketHours: Extended market hours
        """
        ...

    @typing.overload
    def AddSecurity(self, securityType: QuantConnect.SecurityType, ticker: str, resolution: typing.Optional[QuantConnect.Resolution], market: str, fillDataForward: bool, leverage: float, extendedMarketHours: bool) -> QuantConnect.Securities.Security:
        """
        Set a required SecurityType-symbol and resolution for algorithm
        
        :param securityType: MarketType Type: Equity, Commodity, Future, FOREX or Crypto
        :param ticker: The security ticker, e.g. AAPL
        :param resolution: Resolution of the MarketType required: MarketData, Second or Minute
        :param market: The market the requested security belongs to, such as 'usa' or 'fxcm'
        :param fillDataForward: If true, returns the last available data even if none in that timeslice.
        :param leverage: leverage for this security
        :param extendedMarketHours: ExtendedMarketHours send in data from 4am - 8pm, not used for FOREX
        """
        ...

    @typing.overload
    def AddSecurity(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, fillDataForward: bool = True, leverage: float = ..., extendedMarketHours: bool = False) -> QuantConnect.Securities.Security:
        """
        Set a required SecurityType-symbol and resolution for algorithm
        
        :param symbol: The security Symbol
        :param resolution: Resolution of the MarketType required: MarketData, Second or Minute
        :param fillDataForward: If true, returns the last available data even if none in that timeslice.
        :param leverage: leverage for this security
        :param extendedMarketHours: ExtendedMarketHours send in data from 4am - 8pm, not used for FOREX
        :returns: The new Security that was added to the algorithm.
        """
        ...

    def AddSeries(self, chart: str, series: str, seriesType: QuantConnect.SeriesType, unit: str = "$") -> None:
        """
        Add a series object for charting. This is useful when initializing charts with
        series other than type = line. If a series exists in the chart with the same name,
        then it is replaced.
        
        :param chart: The chart name
        :param series: The series name
        :param seriesType: The type of series, i.e, Scatter
        :param unit: The unit of the y axis, usually $
        """
        ...

    @typing.overload
    def AddUniverse(self, T: typing.Type, name: str, selector: typing.Any) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm. This will use the default universe settings
        specified via the UniverseSettings property. This universe will use the defaults
        of SecurityType.Equity, Resolution.Daily, Market.USA, and UniverseSettings
        
        :param T: The data type
        :param name: A unique name for this universe
        :param selector: Function delegate that performs selection on the universe data
        """
        ...

    @typing.overload
    def AddUniverse(self, T: typing.Type, name: str, resolution: QuantConnect.Resolution, selector: typing.Any) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm. This will use the default universe settings
        specified via the UniverseSettings property. This universe will use the defaults
        of SecurityType.Equity, Market.USA and UniverseSettings
        
        :param T: The data type
        :param name: A unique name for this universe
        :param resolution: The epected resolution of the universe data
        :param selector: Function delegate that performs selection on the universe data
        """
        ...

    @typing.overload
    def AddUniverse(self, T: typing.Type, name: str, resolution: QuantConnect.Resolution, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings, selector: typing.Any) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm. This will use the default universe settings
        specified via the UniverseSettings property. This universe will use the defaults
        of SecurityType.Equity, and Market.USA
        
        :param T: The data type
        :param name: A unique name for this universe
        :param resolution: The epected resolution of the universe data
        :param universeSettings: The settings used for securities added by this universe
        :param selector: Function delegate that performs selection on the universe data
        """
        ...

    @typing.overload
    def AddUniverse(self, T: typing.Type, name: str, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings, selector: typing.Any) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm. This will use the default universe settings
        specified via the UniverseSettings property. This universe will use the defaults
        of SecurityType.Equity, Resolution.Daily, and Market.USA
        
        :param T: The data type
        :param name: A unique name for this universe
        :param universeSettings: The settings used for securities added by this universe
        :param selector: Function delegate that performs selection on the universe data
        """
        ...

    @typing.overload
    def AddUniverse(self, T: typing.Type, securityType: QuantConnect.SecurityType, name: str, resolution: QuantConnect.Resolution, market: str, selector: typing.Any) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm. This will use the default universe settings
        specified via the UniverseSettings property.
        
        :param T: The data type
        :param securityType: The security type the universe produces
        :param name: A unique name for this universe
        :param resolution: The epected resolution of the universe data
        :param market: The market for selected symbols
        :param selector: Function delegate that performs selection on the universe data
        """
        ...

    @typing.overload
    def AddUniverse(self, T: typing.Type, securityType: QuantConnect.SecurityType, name: str, resolution: QuantConnect.Resolution, market: str, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings, selector: typing.Any) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm
        
        :param T: The data type
        :param securityType: The security type the universe produces
        :param name: A unique name for this universe
        :param resolution: The epected resolution of the universe data
        :param market: The market for selected symbols
        :param universeSettings: The subscription settings to use for newly created subscriptions
        :param selector: Function delegate that performs selection on the universe data
        """
        ...

    @typing.overload
    def AddUniverse(self, dataType: typing.Type, securityType: QuantConnect.SecurityType, name: str, resolution: QuantConnect.Resolution, market: str, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings, pySelector: typing.Any) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm
        
        :param dataType: The data type
        :param securityType: The security type the universe produces
        :param name: A unique name for this universe
        :param resolution: The epected resolution of the universe data
        :param market: The market for selected symbols
        :param universeSettings: The subscription settings to use for newly created subscriptions
        :param pySelector: Function delegate that performs selection on the universe data
        """
        ...

    @typing.overload
    def AddUniverse(self, universe: QuantConnect.Data.UniverseSelection.Universe) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Adds the universe to the algorithm
        
        :param universe: The universe to be added
        """
        ...

    @typing.overload
    def AddUniverse(self, name: str, selector: typing.Callable[[System.Collections.Generic.IEnumerable[QuantConnect_Algorithm_QCAlgorithm_AddUniverse_T]], System.Collections.Generic.IEnumerable[QuantConnect.Symbol]]) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm. This will use the default universe settings
        specified via the UniverseSettings property. This universe will use the defaults
        of SecurityType.Equity, Resolution.Daily, Market.USA, and UniverseSettings
        
        :param name: A unique name for this universe
        :param selector: Function delegate that performs selection on the universe data
        """
        ...

    @typing.overload
    def AddUniverse(self, name: str, selector: typing.Callable[[System.Collections.Generic.IEnumerable[QuantConnect_Algorithm_QCAlgorithm_AddUniverse_T]], System.Collections.Generic.IEnumerable[str]]) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm. This will use the default universe settings
        specified via the UniverseSettings property. This universe will use the defaults
        of SecurityType.Equity, Resolution.Daily, Market.USA, and UniverseSettings
        
        :param name: A unique name for this universe
        :param selector: Function delegate that performs selection on the universe data
        """
        ...

    @typing.overload
    def AddUniverse(self, name: str, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings, selector: typing.Callable[[System.Collections.Generic.IEnumerable[QuantConnect_Algorithm_QCAlgorithm_AddUniverse_T]], System.Collections.Generic.IEnumerable[QuantConnect.Symbol]]) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm. This will use the default universe settings
        specified via the UniverseSettings property. This universe will use the defaults
        of SecurityType.Equity, Resolution.Daily, and Market.USA
        
        :param name: A unique name for this universe
        :param universeSettings: The settings used for securities added by this universe
        :param selector: Function delegate that performs selection on the universe data
        """
        ...

    @typing.overload
    def AddUniverse(self, name: str, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings, selector: typing.Callable[[System.Collections.Generic.IEnumerable[QuantConnect_Algorithm_QCAlgorithm_AddUniverse_T]], System.Collections.Generic.IEnumerable[str]]) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm. This will use the default universe settings
        specified via the UniverseSettings property. This universe will use the defaults
        of SecurityType.Equity, Resolution.Daily, and Market.USA
        
        :param name: A unique name for this universe
        :param universeSettings: The settings used for securities added by this universe
        :param selector: Function delegate that performs selection on the universe data
        """
        ...

    @typing.overload
    def AddUniverse(self, name: str, resolution: QuantConnect.Resolution, selector: typing.Callable[[System.Collections.Generic.IEnumerable[QuantConnect_Algorithm_QCAlgorithm_AddUniverse_T]], System.Collections.Generic.IEnumerable[QuantConnect.Symbol]]) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm. This will use the default universe settings
        specified via the UniverseSettings property. This universe will use the defaults
        of SecurityType.Equity, Market.USA and UniverseSettings
        
        :param name: A unique name for this universe
        :param resolution: The epected resolution of the universe data
        :param selector: Function delegate that performs selection on the universe data
        """
        ...

    @typing.overload
    def AddUniverse(self, name: str, resolution: QuantConnect.Resolution, selector: typing.Callable[[System.Collections.Generic.IEnumerable[QuantConnect_Algorithm_QCAlgorithm_AddUniverse_T]], System.Collections.Generic.IEnumerable[str]]) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm. This will use the default universe settings
        specified via the UniverseSettings property. This universe will use the defaults
        of SecurityType.Equity, Market.USA and UniverseSettings
        
        :param name: A unique name for this universe
        :param resolution: The epected resolution of the universe data
        :param selector: Function delegate that performs selection on the universe data
        """
        ...

    @typing.overload
    def AddUniverse(self, name: str, resolution: QuantConnect.Resolution, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings, selector: typing.Callable[[System.Collections.Generic.IEnumerable[QuantConnect_Algorithm_QCAlgorithm_AddUniverse_T]], System.Collections.Generic.IEnumerable[QuantConnect.Symbol]]) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm. This will use the default universe settings
        specified via the UniverseSettings property. This universe will use the defaults
        of SecurityType.Equity, and Market.USA
        
        :param name: A unique name for this universe
        :param resolution: The epected resolution of the universe data
        :param universeSettings: The settings used for securities added by this universe
        :param selector: Function delegate that performs selection on the universe data
        """
        ...

    @typing.overload
    def AddUniverse(self, name: str, resolution: QuantConnect.Resolution, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings, selector: typing.Callable[[System.Collections.Generic.IEnumerable[QuantConnect_Algorithm_QCAlgorithm_AddUniverse_T]], System.Collections.Generic.IEnumerable[str]]) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm. This will use the default universe settings
        specified via the UniverseSettings property. This universe will use the defaults
        of SecurityType.Equity, and Market.USA
        
        :param name: A unique name for this universe
        :param resolution: The epected resolution of the universe data
        :param universeSettings: The settings used for securities added by this universe
        :param selector: Function delegate that performs selection on the universe data
        """
        ...

    @typing.overload
    def AddUniverse(self, securityType: QuantConnect.SecurityType, name: str, resolution: QuantConnect.Resolution, market: str, selector: typing.Callable[[System.Collections.Generic.IEnumerable[QuantConnect_Algorithm_QCAlgorithm_AddUniverse_T]], System.Collections.Generic.IEnumerable[QuantConnect.Symbol]]) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm. This will use the default universe settings
        specified via the UniverseSettings property.
        
        :param securityType: The security type the universe produces
        :param name: A unique name for this universe
        :param resolution: The epected resolution of the universe data
        :param market: The market for selected symbols
        :param selector: Function delegate that performs selection on the universe data
        """
        ...

    @typing.overload
    def AddUniverse(self, securityType: QuantConnect.SecurityType, name: str, resolution: QuantConnect.Resolution, market: str, selector: typing.Callable[[System.Collections.Generic.IEnumerable[QuantConnect_Algorithm_QCAlgorithm_AddUniverse_T]], System.Collections.Generic.IEnumerable[str]]) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm. This will use the default universe settings
        specified via the UniverseSettings property.
        
        :param securityType: The security type the universe produces
        :param name: A unique name for this universe
        :param resolution: The epected resolution of the universe data
        :param market: The market for selected symbols
        :param selector: Function delegate that performs selection on the universe data
        """
        ...

    @typing.overload
    def AddUniverse(self, securityType: QuantConnect.SecurityType, name: str, resolution: QuantConnect.Resolution, market: str, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings, selector: typing.Callable[[System.Collections.Generic.IEnumerable[QuantConnect_Algorithm_QCAlgorithm_AddUniverse_T]], System.Collections.Generic.IEnumerable[QuantConnect.Symbol]]) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm
        
        :param securityType: The security type the universe produces
        :param name: A unique name for this universe
        :param resolution: The epected resolution of the universe data
        :param market: The market for selected symbols
        :param universeSettings: The subscription settings to use for newly created subscriptions
        :param selector: Function delegate that performs selection on the universe data
        """
        ...

    @typing.overload
    def AddUniverse(self, securityType: QuantConnect.SecurityType, name: str, resolution: QuantConnect.Resolution, market: str, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings, selector: typing.Callable[[System.Collections.Generic.IEnumerable[QuantConnect_Algorithm_QCAlgorithm_AddUniverse_T]], System.Collections.Generic.IEnumerable[str]]) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm
        
        :param securityType: The security type the universe produces
        :param name: A unique name for this universe
        :param resolution: The epected resolution of the universe data
        :param market: The market for selected symbols
        :param universeSettings: The subscription settings to use for newly created subscriptions
        :param selector: Function delegate that performs selection on the universe data
        """
        ...

    @typing.overload
    def AddUniverse(self, selector: typing.Callable[[System.Collections.Generic.IEnumerable[QuantConnect.Data.UniverseSelection.CoarseFundamental]], System.Collections.Generic.IEnumerable[QuantConnect.Symbol]]) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm. This is for coarse fundamental US Equity data and
        will be executed on day changes in the NewYork time zone (TimeZones.NewYork
        
        :param selector: Defines an initial coarse selection
        """
        ...

    @typing.overload
    def AddUniverse(self, coarseSelector: typing.Callable[[System.Collections.Generic.IEnumerable[QuantConnect.Data.UniverseSelection.CoarseFundamental]], System.Collections.Generic.IEnumerable[QuantConnect.Symbol]], fineSelector: typing.Callable[[System.Collections.Generic.IEnumerable[QuantConnect.Data.Fundamental.FineFundamental]], System.Collections.Generic.IEnumerable[QuantConnect.Symbol]]) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm. This is for coarse and fine fundamental US Equity data and
        will be executed on day changes in the NewYork time zone (TimeZones.NewYork
        
        :param coarseSelector: Defines an initial coarse selection
        :param fineSelector: Defines a more detailed selection with access to more data
        """
        ...

    @typing.overload
    def AddUniverse(self, universe: QuantConnect.Data.UniverseSelection.Universe, fineSelector: typing.Callable[[System.Collections.Generic.IEnumerable[QuantConnect.Data.Fundamental.FineFundamental]], System.Collections.Generic.IEnumerable[QuantConnect.Symbol]]) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm. This is for fine fundamental US Equity data and
        will be executed on day changes in the NewYork time zone (TimeZones.NewYork
        
        :param universe: The universe to be filtered with fine fundamental selection
        :param fineSelector: Defines a more detailed selection with access to more data
        """
        ...

    @typing.overload
    def AddUniverse(self, name: str, selector: typing.Callable[[datetime.datetime], System.Collections.Generic.IEnumerable[str]]) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm. This can be used to return a list of string
        symbols retrieved from anywhere and will loads those symbols under the US Equity market.
        
        :param name: A unique name for this universe
        :param selector: Function delegate that accepts a DateTime and returns a collection of string symbols
        """
        ...

    @typing.overload
    def AddUniverse(self, name: str, resolution: QuantConnect.Resolution, selector: typing.Callable[[datetime.datetime], System.Collections.Generic.IEnumerable[str]]) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new universe and adds it to the algorithm. This can be used to return a list of string
        symbols retrieved from anywhere and will loads those symbols under the US Equity market.
        
        :param name: A unique name for this universe
        :param resolution: The resolution this universe should be triggered on
        :param selector: Function delegate that accepts a DateTime and returns a collection of string symbols
        """
        ...

    @typing.overload
    def AddUniverse(self, securityType: QuantConnect.SecurityType, name: str, resolution: QuantConnect.Resolution, market: str, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings, selector: typing.Callable[[datetime.datetime], System.Collections.Generic.IEnumerable[str]]) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new user defined universe that will fire on the requested resolution during market hours.
        
        :param securityType: The security type of the universe
        :param name: A unique name for this universe
        :param resolution: The resolution this universe should be triggered on
        :param market: The market of the universe
        :param universeSettings: The subscription settings used for securities added from this universe
        :param selector: Function delegate that accepts a DateTime and returns a collection of string symbols
        """
        ...

    @typing.overload
    def AddUniverseOptions(self, underlyingSymbol: typing.Union[QuantConnect.Symbol, str], optionFilter: typing.Callable[[QuantConnect.Securities.OptionFilterUniverse], QuantConnect.Securities.OptionFilterUniverse]) -> None:
        """
        Adds a new universe that creates options of the security by monitoring any changes in the Universe the provided security is in.
        Additionally, a filter can be applied to the options generated when the universe of the security changes.
        
        :param underlyingSymbol: Underlying Symbol to add as an option. For Futures, the option chain constructed will be per-contract, as long as a canonical Symbol is provided.
        :param optionFilter: User-defined filter used to select the options we want out of the option chain provided.
        """
        ...

    @typing.overload
    def AddUniverseOptions(self, universe: QuantConnect.Data.UniverseSelection.Universe, optionFilter: typing.Callable[[QuantConnect.Securities.OptionFilterUniverse], QuantConnect.Securities.OptionFilterUniverse]) -> None:
        """
        Creates a new universe selection model and adds it to the algorithm. This universe selection model will chain to the security
        changes of a given Universe selection output and create a new OptionChainUniverse for each of them
        
        :param universe: The universe we want to chain an option universe selection model too
        :param optionFilter: The option filter universe to use
        """
        ...

    def AddUniverseSelection(self, universeSelection: QuantConnect.Algorithm.Framework.Selection.IUniverseSelectionModel) -> None:
        """
        Adds a new universe selection model
        
        :param universeSelection: Model defining universes for the algorithm to add
        """
        ...

    def ADOSC(self, symbol: typing.Union[QuantConnect.Symbol, str], fastPeriod: int, slowPeriod: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.TradeBar] = None) -> QuantConnect.Indicators.AccumulationDistributionOscillator:
        """
        Creates a new AccumulationDistributionOscillator indicator.
        
        :param symbol: The symbol whose ADOSC we want
        :param fastPeriod: The fast moving average period
        :param slowPeriod: The slow moving average period
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The AccumulationDistributionOscillator indicator for the requested symbol over the speified period.
        """
        ...

    def ADR(self, symbols: System.Collections.Generic.IEnumerable[QuantConnect.Symbol], resolution: typing.Optional[QuantConnect.Resolution] = None) -> QuantConnect.Indicators.AdvanceDeclineRatio:
        """
        Creates a new Advance/Decline Ratio indicator
        
        :param symbols: The symbols whose A/D Ratio we want
        :param resolution: The resolution
        :returns: The Advance/Decline Ratio indicator for the requested symbol over the specified period.
        """
        ...

    def ADVR(self, symbols: System.Collections.Generic.IEnumerable[QuantConnect.Symbol], resolution: typing.Optional[QuantConnect.Resolution] = None) -> QuantConnect.Indicators.AdvanceDeclineVolumeRatio:
        """
        Creates a new Advance/Decline Volume Ratio indicator
        
        :param symbols: The symbol whose A/D Volume Rate we want
        :param resolution: The resolution
        :returns: The Advance/Decline Volume Ratio indicator for the requested symbol over the specified period.
        """
        ...

    def ADX(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.AverageDirectionalIndex:
        """
        Creates a new Average Directional Index indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose Average Directional Index we seek
        :param period: The period over which to compute the Average Directional Index
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The Average Directional Index indicator for the requested symbol.
        """
        ...

    def ADXR(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.AverageDirectionalMovementIndexRating:
        """
        Creates a new AverageDirectionalMovementIndexRating indicator.
        
        :param symbol: The symbol whose ADXR we want
        :param period: The period over which to compute the ADXR
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The AverageDirectionalMovementIndexRating indicator for the requested symbol over the specified period.
        """
        ...

    def AllShortableSymbols(self) -> System.Collections.Generic.Dictionary[QuantConnect.Symbol, int]:
        """
        Gets all Symbols that are shortable, as well as the quantity shortable for them
        
        :returns: All shortable Symbols, null if all Symbols are shortable.
        """
        ...

    def ALMA(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, sigma: int = 6, offset: float = 0.85, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.ArnaudLegouxMovingAverage:
        """
        Creates a new ArnaudLegouxMovingAverage indicator.
        
        :param symbol: The symbol whose ALMA we want
        :param period: int - the number of periods to calculate the ALMA
        :param sigma: int - this parameter is responsible for the shape of the curve coefficients.
        :param offset: decimal - This parameter allows regulating the smoothness and high sensitivity of the Moving Average. The range for this parameter is [0, 1].
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The ArnaudLegouxMovingAverage indicator for the requested symbol over the specified period.
        """
        ...

    def AO(self, symbol: typing.Union[QuantConnect.Symbol, str], slowPeriod: int, fastPeriod: int, type: QuantConnect.Indicators.MovingAverageType, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.AwesomeOscillator:
        """
        Creates a new Awesome Oscillator from the specified periods.
        
        :param symbol: The symbol whose Awesome Oscillator we seek
        :param slowPeriod: The period of the slow moving average associated with the AO
        :param fastPeriod: The period of the fast moving average associated with the AO
        :param type: The type of moving average used when computing the fast and slow term. Defaults to simple moving average.
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        """
        ...

    def APO(self, symbol: typing.Union[QuantConnect.Symbol, str], fastPeriod: int, slowPeriod: int, movingAverageType: QuantConnect.Indicators.MovingAverageType, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.AbsolutePriceOscillator:
        """
        Creates a new AbsolutePriceOscillator indicator.
        
        :param symbol: The symbol whose APO we want
        :param fastPeriod: The fast moving average period
        :param slowPeriod: The slow moving average period
        :param movingAverageType: The type of moving average to use
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The AbsolutePriceOscillator indicator for the requested symbol over the specified period.
        """
        ...

    def ARIMA(self, symbol: typing.Union[QuantConnect.Symbol, str], arOrder: int, diffOrder: int, maOrder: int, period: int, resolution: typing.Optional[QuantConnect.Resolution] = None) -> QuantConnect.Indicators.AutoRegressiveIntegratedMovingAverage:
        """
        Creates a new ARIMA indicator.
        
        :param symbol: The symbol whose ARIMA indicator we want
        :param arOrder: AR order (p) -- defines the number of past values to consider in the AR component of the model.
        :param diffOrder: Difference order (d) -- defines how many times to difference the model before fitting parameters.
        :param maOrder: MA order (q) -- defines the number of past values to consider in the MA component of the model.
        :param period: Size of the rolling series to fit onto
        :param resolution: The resolution
        :returns: The ARIMA indicator for the requested symbol over the specified period.
        """
        ...

    @typing.overload
    def AROON(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.AroonOscillator:
        """
        Creates a new AroonOscillator indicator which will compute the AroonUp and AroonDown (as well as the delta)
        
        :param symbol: The symbol whose Aroon we seek
        :param period: The look back period for computing number of periods since maximum and minimum
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: An AroonOscillator configured with the specied periods.
        """
        ...

    @typing.overload
    def AROON(self, symbol: typing.Union[QuantConnect.Symbol, str], upPeriod: int, downPeriod: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.AroonOscillator:
        """
        Creates a new AroonOscillator indicator which will compute the AroonUp and AroonDown (as well as the delta)
        
        :param symbol: The symbol whose Aroon we seek
        :param upPeriod: The look back period for computing number of periods since maximum
        :param downPeriod: The look back period for computing number of periods since minimum
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: An AroonOscillator configured with the specified periods.
        """
        ...

    def ASI(self, symbol: typing.Union[QuantConnect.Symbol, str], limitMove: float, resolution: typing.Optional[QuantConnect.Resolution] = ...) -> QuantConnect.Indicators.WilderAccumulativeSwingIndex:
        """
        Creates a Wilder Accumulative Swing Index (ASI) indicator for the symbol.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose ASI we want
        :param limitMove: The maximum daily change in price for the ASI
        :param resolution: The resolution
        :returns: The WilderAccumulativeSwingIndex for the given parameters.
        """
        ...

    def ATR(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, type: QuantConnect.Indicators.MovingAverageType = ..., resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.AverageTrueRange:
        """
        Creates a new AverageTrueRange indicator for the symbol. The indicator will be automatically
        updated on the given resolution.
        
        :param symbol: The symbol whose ATR we want
        :param period: The smoothing period used to smooth the computed TrueRange values
        :param type: The type of smoothing to use
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: A new AverageTrueRange indicator with the specified smoothing type and period.
        """
        ...

    def BB(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, k: float, movingAverageType: QuantConnect.Indicators.MovingAverageType = ..., resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.BollingerBands:
        """
        Creates a new BollingerBands indicator which will compute the MiddleBand, UpperBand, LowerBand, and StandardDeviation
        
        :param symbol: The symbol whose BollingerBands we seek
        :param period: The period of the standard deviation and moving average (middle band)
        :param k: The number of standard deviations specifying the distance between the middle band and upper or lower bands
        :param movingAverageType: The type of moving average to be used
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: A BollingerBands configured with the specified period.
        """
        ...

    def BOP(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.BalanceOfPower:
        """
        Creates a new Balance Of Power indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose Balance Of Power we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The Balance Of Power indicator for the requested symbol.
        """
        ...

    @typing.overload
    def Buy(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: int) -> QuantConnect.Orders.OrderTicket:
        """
        Buy Stock (Alias of Order)
        
        :param symbol: string Symbol of the asset to trade
        :param quantity: int Quantity of the asset to trade
        """
        ...

    @typing.overload
    def Buy(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float) -> QuantConnect.Orders.OrderTicket:
        """
        Buy Stock (Alias of Order)
        
        :param symbol: string Symbol of the asset to trade
        :param quantity: double Quantity of the asset to trade
        """
        ...

    @typing.overload
    def Buy(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float) -> QuantConnect.Orders.OrderTicket:
        """
        Buy Stock (Alias of Order)
        
        :param symbol: string Symbol of the asset to trade
        :param quantity: decimal Quantity of the asset to trade
        """
        ...

    @typing.overload
    def Buy(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float) -> QuantConnect.Orders.OrderTicket:
        """
        Buy Stock (Alias of Order)
        
        :param symbol: string Symbol of the asset to trade
        :param quantity: float Quantity of the asset to trade
        """
        ...

    @typing.overload
    def Buy(self, strategy: QuantConnect.Securities.Option.OptionStrategy, quantity: int) -> System.Collections.Generic.IEnumerable[QuantConnect.Orders.OrderTicket]:
        ...

    @typing.overload
    def CalculateOrderQuantity(self, symbol: typing.Union[QuantConnect.Symbol, str], target: float) -> float:
        """
        Calculate the order quantity to achieve target-percent holdings.
        
        :param symbol: Security object we're asking for
        :param target: Target percentage holdings
        :returns: Order quantity to achieve this percentage.
        """
        ...

    @typing.overload
    def CalculateOrderQuantity(self, symbol: typing.Union[QuantConnect.Symbol, str], target: float) -> float:
        """
        Calculate the order quantity to achieve target-percent holdings.
        
        :param symbol: Security object we're asking for
        :param target: Target percentage holdings, this is an unleveraged value, so if you have 2x leverage and request 100% holdings, it will utilize half of the available margin
        :returns: Order quantity to achieve this percentage.
        """
        ...

    def CC(self, symbol: typing.Union[QuantConnect.Symbol, str], shortRocPeriod: int = 11, longRocPeriod: int = 14, lwmaPeriod: int = 10, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.CoppockCurve:
        """
        Initializes a new instance of the CoppockCurve indicator
        
        :param symbol: The symbol whose Coppock Curve we want
        :param shortRocPeriod: The period for the short ROC
        :param longRocPeriod: The period for the long ROC
        :param lwmaPeriod: The period for the LWMA
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The Coppock Curve indicator for the requested symbol over the specified period.
        """
        ...

    def CCI(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, movingAverageType: QuantConnect.Indicators.MovingAverageType = ..., resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.CommodityChannelIndex:
        """
        Creates a new CommodityChannelIndex indicator. The indicator will be automatically
        updated on the given resolution.
        
        :param symbol: The symbol whose CCI we want
        :param period: The period over which to compute the CCI
        :param movingAverageType: The type of moving average to use in computing the typical price average
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The CommodityChannelIndex indicator for the requested symbol over the specified period.
        """
        ...

    def CMF(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.TradeBar] = None) -> QuantConnect.Indicators.ChaikinMoneyFlow:
        """
        Creates a new ChaikinMoneyFlow indicator.
        
        :param symbol: The symbol whose CMF we want
        :param period: The period over which to compute the CMF
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The ChaikinMoneyFlow indicator for the requested symbol over the specified period.
        """
        ...

    def CMO(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.ChandeMomentumOscillator:
        """
        Creates a new ChandeMomentumOscillator indicator.
        
        :param symbol: The symbol whose CMO we want
        :param period: The period over which to compute the CMO
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The ChandeMomentumOscillator indicator for the requested symbol over the specified period.
        """
        ...

    @typing.overload
    def Consolidate(self, symbol: typing.Union[QuantConnect.Symbol, str], period: QuantConnect.Resolution, handler: typing.Callable[[QuantConnect.Data.Market.TradeBar], None]) -> QuantConnect.Data.Consolidators.IDataConsolidator:
        """
        Registers the  to receive consolidated data for the specified symbol
        
        :param symbol: The symbol who's data is to be consolidated
        :param period: The consolidation period
        :param handler: Data handler receives new consolidated data when generated
        :returns: A new consolidator matching the requested parameters with the handler already registered.
        """
        ...

    @typing.overload
    def Consolidate(self, symbol: typing.Union[QuantConnect.Symbol, str], period: datetime.timedelta, handler: typing.Callable[[QuantConnect.Data.Market.TradeBar], None]) -> QuantConnect.Data.Consolidators.IDataConsolidator:
        """
        Registers the  to receive consolidated data for the specified symbol
        
        :param symbol: The symbol who's data is to be consolidated
        :param period: The consolidation period
        :param handler: Data handler receives new consolidated data when generated
        :returns: A new consolidator matching the requested parameters with the handler already registered.
        """
        ...

    @typing.overload
    def Consolidate(self, symbol: typing.Union[QuantConnect.Symbol, str], period: QuantConnect.Resolution, handler: typing.Callable[[QuantConnect.Data.Market.QuoteBar], None]) -> QuantConnect.Data.Consolidators.IDataConsolidator:
        """
        Registers the  to receive consolidated data for the specified symbol
        
        :param symbol: The symbol who's data is to be consolidated
        :param period: The consolidation period
        :param handler: Data handler receives new consolidated data when generated
        :returns: A new consolidator matching the requested parameters with the handler already registered.
        """
        ...

    @typing.overload
    def Consolidate(self, symbol: typing.Union[QuantConnect.Symbol, str], period: datetime.timedelta, handler: typing.Callable[[QuantConnect.Data.Market.QuoteBar], None]) -> QuantConnect.Data.Consolidators.IDataConsolidator:
        """
        Registers the  to receive consolidated data for the specified symbol
        
        :param symbol: The symbol who's data is to be consolidated
        :param period: The consolidation period
        :param handler: Data handler receives new consolidated data when generated
        :returns: A new consolidator matching the requested parameters with the handler already registered.
        """
        ...

    @typing.overload
    def Consolidate(self, symbol: typing.Union[QuantConnect.Symbol, str], period: datetime.timedelta, handler: typing.Callable[[QuantConnect_Algorithm_QCAlgorithm_Consolidate_T], None]) -> QuantConnect.Data.Consolidators.IDataConsolidator:
        """
        Registers the  to receive consolidated data for the specified symbol and tick type.
        The handler and tick type must match.
        
        :param symbol: The symbol who's data is to be consolidated
        :param period: The consolidation period
        :param handler: Data handler receives new consolidated data when generated
        :returns: A new consolidator matching the requested parameters with the handler already registered.
        """
        ...

    @typing.overload
    def Consolidate(self, symbol: typing.Union[QuantConnect.Symbol, str], period: QuantConnect.Resolution, tickType: typing.Optional[QuantConnect.TickType], handler: typing.Callable[[QuantConnect_Algorithm_QCAlgorithm_Consolidate_T], None]) -> QuantConnect.Data.Consolidators.IDataConsolidator:
        """
        Registers the  to receive consolidated data for the specified symbol and tick type.
        The handler and tick type must match.
        
        :param symbol: The symbol who's data is to be consolidated
        :param period: The consolidation period
        :param tickType: The tick type of subscription used as data source for consolidator. Specify null to use first subscription found.
        :param handler: Data handler receives new consolidated data when generated
        :returns: A new consolidator matching the requested parameters with the handler already registered.
        """
        ...

    @typing.overload
    def Consolidate(self, symbol: typing.Union[QuantConnect.Symbol, str], period: datetime.timedelta, tickType: typing.Optional[QuantConnect.TickType], handler: typing.Callable[[QuantConnect_Algorithm_QCAlgorithm_Consolidate_T], None]) -> QuantConnect.Data.Consolidators.IDataConsolidator:
        """
        Registers the  to receive consolidated data for the specified symbol and tick type.
        The handler and tick type must match.
        
        :param symbol: The symbol who's data is to be consolidated
        :param period: The consolidation period
        :param tickType: The tick type of subscription used as data source for consolidator. Specify null to use first subscription found.
        :param handler: Data handler receives new consolidated data when generated
        :returns: A new consolidator matching the requested parameters with the handler already registered.
        """
        ...

    @typing.overload
    def Consolidate(self, symbol: typing.Union[QuantConnect.Symbol, str], calendar: typing.Callable[[datetime.datetime], QuantConnect.Data.Consolidators.CalendarInfo], handler: typing.Callable[[QuantConnect.Data.Market.QuoteBar], None]) -> QuantConnect.Data.Consolidators.IDataConsolidator:
        """
        Registers the  to receive consolidated data for the specified symbol
        
        :param symbol: The symbol who's data is to be consolidated
        :param calendar: The consolidation calendar
        :param handler: Data handler receives new consolidated data when generated
        :returns: A new consolidator matching the requested parameters with the handler already registered.
        """
        ...

    @typing.overload
    def Consolidate(self, symbol: typing.Union[QuantConnect.Symbol, str], calendar: typing.Callable[[datetime.datetime], QuantConnect.Data.Consolidators.CalendarInfo], handler: typing.Callable[[QuantConnect.Data.Market.TradeBar], None]) -> QuantConnect.Data.Consolidators.IDataConsolidator:
        """
        Registers the  to receive consolidated data for the specified symbol
        
        :param symbol: The symbol who's data is to be consolidated
        :param calendar: The consolidation calendar
        :param handler: Data handler receives new consolidated data when generated
        :returns: A new consolidator matching the requested parameters with the handler already registered.
        """
        ...

    @typing.overload
    def Consolidate(self, symbol: typing.Union[QuantConnect.Symbol, str], calendar: typing.Callable[[datetime.datetime], QuantConnect.Data.Consolidators.CalendarInfo], handler: typing.Callable[[QuantConnect_Algorithm_QCAlgorithm_Consolidate_T], None]) -> QuantConnect.Data.Consolidators.IDataConsolidator:
        """
        Registers the  to receive consolidated data for the specified symbol and tick type.
        The handler and tick type must match.
        
        :param symbol: The symbol who's data is to be consolidated
        :param calendar: The consolidation calendar
        :param handler: Data handler receives new consolidated data when generated
        :returns: A new consolidator matching the requested parameters with the handler already registered.
        """
        ...

    @staticmethod
    def CreateConsolidator(period: datetime.timedelta, consolidatorInputType: typing.Type, tickType: typing.Optional[QuantConnect.TickType] = None) -> QuantConnect.Data.Consolidators.IDataConsolidator:
        """
        Creates a new consolidator for the specified period, generating the requested output type.
        
        :param period: The consolidation period
        :param consolidatorInputType: The desired input type of the consolidator, such as TradeBar or QuoteBar
        :param tickType: Trade or Quote. Optional, defaults to trade
        :returns: A new consolidator matching the requested parameters.
        """
        ...

    @typing.overload
    def CreateIndicatorName(self, symbol: typing.Union[QuantConnect.Symbol, str], type: System.FormattableString, resolution: typing.Optional[QuantConnect.Resolution]) -> str:
        """
        Creates a new name for an indicator created with the convenience functions (SMA, EMA, ect...)
        
        :param symbol: The symbol this indicator is registered to
        :param type: The indicator type, for example, 'SMA(5)'
        :param resolution: The resolution requested
        :returns: A unique for the given parameters.
        """
        ...

    @typing.overload
    def CreateIndicatorName(self, symbol: typing.Union[QuantConnect.Symbol, str], type: str, resolution: typing.Optional[QuantConnect.Resolution]) -> str:
        """
        Creates a new name for an indicator created with the convenience functions (SMA, EMA, ect...)
        
        :param symbol: The symbol this indicator is registered to
        :param type: The indicator type, for example, 'SMA(5)'
        :param resolution: The resolution requested
        :returns: A unique for the given parameters.
        """
        ...

    @typing.overload
    def DCH(self, symbol: typing.Union[QuantConnect.Symbol, str], upperPeriod: int, lowerPeriod: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.DonchianChannel:
        """
        Creates a new Donchian Channel indicator which will compute the Upper Band and Lower Band.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose Donchian Channel we seek.
        :param upperPeriod: The period over which to compute the upper Donchian Channel.
        :param lowerPeriod: The period over which to compute the lower Donchian Channel.
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The Donchian Channel indicator for the requested symbol.
        """
        ...

    @typing.overload
    def DCH(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.DonchianChannel:
        """
        Overload shorthand to create a new symmetric Donchian Channel indicator which
        has the upper and lower channels set to the same period length.
        
        :param symbol: The symbol whose Donchian Channel we seek.
        :param period: The period over which to compute the Donchian Channel.
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The Donchian Channel indicator for the requested symbol.
        """
        ...

    @typing.overload
    def Debug(self, message: typing.Any) -> None:
        """
        Send a debug message to the web console:
        
        :param message: Message to send to debug console
        """
        ...

    @typing.overload
    def Debug(self, message: str) -> None:
        """
        Send a debug message to the web console:
        
        :param message: Message to send to debug console
        """
        ...

    @typing.overload
    def Debug(self, message: int) -> None:
        """
        Send a debug message to the web console:
        
        :param message: Message to send to debug console
        """
        ...

    @typing.overload
    def Debug(self, message: float) -> None:
        """
        Send a debug message to the web console:
        
        :param message: Message to send to debug console
        """
        ...

    @typing.overload
    def Debug(self, message: float) -> None:
        """
        Send a debug message to the web console:
        
        :param message: Message to send to debug console
        """
        ...

    def DEM(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, type: QuantConnect.Indicators.MovingAverageType, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.TradeBar] = None) -> QuantConnect.Indicators.DeMarkerIndicator:
        """
        Creates a new DeMarker Indicator (DEM), an oscillator-type indicator measuring changes in terms of an asset's
        High and Low tradebar values.
        
        :param symbol: The symbol whose DEM we seek.
        :param period: The period of the moving average implemented
        :param type: Specifies the type of moving average to be used
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The DeMarker indicator for the requested symbol.
        """
        ...

    def DEMA(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.DoubleExponentialMovingAverage:
        """
        Creates a new DoubleExponentialMovingAverage indicator.
        
        :param symbol: The symbol whose DEMA we want
        :param period: The period over which to compute the DEMA
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The DoubleExponentialMovingAverage indicator for the requested symbol over the specified period.
        """
        ...

    @typing.overload
    def Download(self, address: str) -> str:
        """
        Downloads the requested resource as a string.
        The resource to download is specified as a string containing the URI.
        
        :param address: A string containing the URI to download
        :returns: The requested resource as a string.
        """
        ...

    @typing.overload
    def Download(self, address: str, headers: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[str, str]]) -> str:
        """
        Downloads the requested resource as a string.
        The resource to download is specified as a string containing the URI.
        
        :param address: A string containing the URI to download
        :param headers: Defines header values to add to the request
        :returns: The requested resource as a string.
        """
        ...

    @typing.overload
    def Download(self, address: str, headers: System.Collections.Generic.IEnumerable[System.Collections.Generic.KeyValuePair[str, str]], userName: str, password: str) -> str:
        """
        Downloads the requested resource as a string.
        The resource to download is specified as a string containing the URI.
        
        :param address: A string containing the URI to download
        :param headers: Defines header values to add to the request
        :param userName: The user name associated with the credentials
        :param password: The password for the user name associated with the credentials
        :returns: The requested resource as a string.
        """
        ...

    def DPO(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.DetrendedPriceOscillator:
        """
        Creates a new DetrendedPriceOscillator indicator.
        
        :param symbol: The symbol whose DPO we want
        :param period: The period over which to compute the DPO
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: A new registered DetrendedPriceOscillator indicator for the requested symbol over the specified period.
        """
        ...

    @typing.overload
    def EMA(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.ExponentialMovingAverage:
        """
        Creates an ExponentialMovingAverage indicator for the symbol. The indicator will be automatically
        updated on the given resolution.
        
        :param symbol: The symbol whose EMA we want
        :param period: The period of the EMA
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The ExponentialMovingAverage for the given parameters.
        """
        ...

    @typing.overload
    def EMA(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, smoothingFactor: float, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.ExponentialMovingAverage:
        """
        Creates an ExponentialMovingAverage indicator for the symbol. The indicator will be automatically
        updated on the given resolution.
        
        :param symbol: The symbol whose EMA we want
        :param period: The period of the EMA
        :param smoothingFactor: The percentage of data from the previous value to be carried into the next value
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The ExponentialMovingAverage for the given parameters.
        """
        ...

    @typing.overload
    def EmitInsights(self, *insights: QuantConnect.Algorithm.Framework.Alphas.Insight) -> None:
        """
        Manually emit insights from an algorithm.
        This is typically invoked before calls to submit orders in algorithms written against
        QCAlgorithm that have been ported into the algorithm framework.
        
        :param insights: The array of insights to be emitted
        """
        ...

    @typing.overload
    def EmitInsights(self, insight: QuantConnect.Algorithm.Framework.Alphas.Insight) -> None:
        """
        Manually emit insights from an algorithm.
        This is typically invoked before calls to submit orders in algorithms written against
        QCAlgorithm that have been ported into the algorithm framework.
        
        :param insight: The insight to be emitted
        """
        ...

    def EMV(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int = 1, scale: int = 10000, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.TradeBar] = None) -> QuantConnect.Indicators.EaseOfMovementValue:
        """
        Creates an EaseOfMovementValue indicator for the symbol. The indicator will be automatically
        updated on the given resolution.
        
        :param symbol: The symbol whose EMV we want
        :param period: The period of the EMV
        :param scale: The length of the outputed value
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The EaseOfMovementValue indicator for the given parameters.
        """
        ...

    @typing.overload
    def Error(self, message: typing.Any) -> None:
        """
        Send a string error message to the Console.
        
        :param message: Message to display in errors grid
        """
        ...

    @typing.overload
    def Error(self, message: str) -> None:
        """
        Send a string error message to the Console.
        
        :param message: Message to display in errors grid
        """
        ...

    @typing.overload
    def Error(self, message: int) -> None:
        """
        Send a int error message to the Console.
        
        :param message: Message to display in errors grid
        """
        ...

    @typing.overload
    def Error(self, message: float) -> None:
        """
        Send a double error message to the Console.
        
        :param message: Message to display in errors grid
        """
        ...

    @typing.overload
    def Error(self, message: float) -> None:
        """
        Send a decimal error message to the Console.
        
        :param message: Message to display in errors grid
        """
        ...

    @typing.overload
    def Error(self, error: System.Exception) -> None:
        """
        Send a string error message to the Console.
        
        :param error: Exception object captured from a try catch loop
        """
        ...

    def ExerciseOption(self, optionSymbol: typing.Union[QuantConnect.Symbol, str], quantity: int, asynchronous: bool = False, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Send an exercise order to the transaction handler
        
        :param optionSymbol: String symbol for the option position
        :param quantity: Quantity of options contracts
        :param asynchronous: Send the order asynchronously (false). Otherwise we'll block until it fills
        :param tag: String tag for the order (optional)
        """
        ...

    @typing.overload
    def FilteredIdentity(self, symbol: typing.Union[QuantConnect.Symbol, str], selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None, filter: typing.Callable[[QuantConnect.Data.IBaseData], bool] = None, fieldName: str = None) -> QuantConnect.Indicators.FilteredIdentity:
        """
        Creates a new FilteredIdentity indicator for the symbol The indicator will be automatically
        updated on the symbol's subscription resolution
        
        :param symbol: The symbol whose values we want as an indicator
        :param selector: Selects a value from the BaseData, if null defaults to the .Value property (x => x.Value)
        :param filter: Filters the IBaseData send into the indicator, if null defaults to true (x => true) which means no filter
        :param fieldName: The name of the field being selected
        :returns: A new FilteredIdentity indicator for the specified symbol and selector.
        """
        ...

    @typing.overload
    def FilteredIdentity(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: QuantConnect.Resolution, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None, filter: typing.Callable[[QuantConnect.Data.IBaseData], bool] = None, fieldName: str = None) -> QuantConnect.Indicators.FilteredIdentity:
        """
        Creates a new FilteredIdentity indicator for the symbol The indicator will be automatically
        updated on the symbol's subscription resolution
        
        :param symbol: The symbol whose values we want as an indicator
        :param resolution: The desired resolution of the data
        :param selector: Selects a value from the BaseData, if null defaults to the .Value property (x => x.Value)
        :param filter: Filters the IBaseData send into the indicator, if null defaults to true (x => true) which means no filter
        :param fieldName: The name of the field being selected
        :returns: A new FilteredIdentity indicator for the specified symbol and selector.
        """
        ...

    @typing.overload
    def FilteredIdentity(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: datetime.timedelta, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None, filter: typing.Callable[[QuantConnect.Data.IBaseData], bool] = None, fieldName: str = None) -> QuantConnect.Indicators.FilteredIdentity:
        """
        Creates a new FilteredIdentity indicator for the symbol The indicator will be automatically
        updated on the symbol's subscription resolution
        
        :param symbol: The symbol whose values we want as an indicator
        :param resolution: The desired resolution of the data
        :param selector: Selects a value from the BaseData, if null defaults to the .Value property (x => x.Value)
        :param filter: Filters the IBaseData send into the indicator, if null defaults to true (x => true) which means no filter
        :param fieldName: The name of the field being selected
        :returns: A new FilteredIdentity indicator for the specified symbol and selector.
        """
        ...

    def FISH(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.FisherTransform:
        """
        Creates an FisherTransform indicator for the symbol.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose FisherTransform we want
        :param period: The period of the FisherTransform
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The FisherTransform for the given parameters.
        """
        ...

    def FRAMA(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, longPeriod: int = 198, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.FractalAdaptiveMovingAverage:
        """
        Creates an FractalAdaptiveMovingAverage (FRAMA) indicator for the symbol. The indicator will be automatically
        updated on the given resolution.
        
        :param symbol: The symbol whose FRAMA we want
        :param period: The period of the FRAMA
        :param longPeriod: The long period of the FRAMA
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The FRAMA for the given parameters.
        """
        ...

    def FrameworkPostInitialize(self) -> None:
        """
        Called by setup handlers after Initialize and allows the algorithm a chance to organize
        the data gather in the Initialize method
        """
        ...

    def GetChartUpdates(self, clearChartData: bool = False) -> System.Collections.Generic.List[QuantConnect.Chart]:
        """
        Get the chart updates by fetch the recent points added and return for dynamic plotting.
        
        :returns: List of chart updates since the last request.
        """
        ...

    def GetLastKnownPrice(self, security: QuantConnect.Securities.Security) -> QuantConnect.Data.BaseData:
        """
        Get the last known price using the history provider.
        Useful for seeding securities with the correct price
        
        :param security: Security object for which to retrieve historical data
        :returns: A single BaseData object with the last known price.
        """
        ...

    def GetLocked(self) -> bool:
        """Gets whether or not this algorithm has been locked and fully initialized"""
        ...

    def GetParameter(self, name: str) -> str:
        """
        Gets the parameter with the specified name. If a parameter
        with the specified name does not exist, null is returned
        
        :param name: The name of the parameter to get
        :returns: The value of the specified parameter, or null if not found.
        """
        ...

    def GetParameters(self) -> System.Collections.Generic.IReadOnlyDictionary[str, str]:
        """Gets a read-only dictionary with all current parameters"""
        ...

    def GetWarmupHistoryRequests(self) -> System.Collections.Generic.IEnumerable[QuantConnect.Data.HistoryRequest]:
        """Gets the history requests required for provide warm up data for the algorithm"""
        ...

    def HeikinAshi(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.TradeBar] = None) -> QuantConnect.Indicators.HeikinAshi:
        """
        Creates a new Heikin-Ashi indicator.
        
        :param symbol: The symbol whose Heikin-Ashi we want
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The Heikin-Ashi indicator for the requested symbol over the specified period.
        """
        ...

    @typing.overload
    def History(self, type: typing.Type, tickers: typing.Any, start: typing.Union[datetime.datetime, datetime.date], end: typing.Union[datetime.datetime, datetime.date], resolution: typing.Optional[QuantConnect.Resolution] = None) -> pandas.DataFrame:
        """
        Gets the historical data for the specified symbols between the specified dates. The symbols must exist in the Securities collection.
        
        :param type: The data type of the symbols
        :param tickers: The symbols to retrieve historical data for
        :param start: The start time in the algorithm's time zone
        :param end: The end time in the algorithm's time zone
        :param resolution: The resolution to request
        :returns: pandas.DataFrame containing the requested historical data.
        """
        ...

    @typing.overload
    def History(self, type: typing.Type, tickers: typing.Any, periods: int, resolution: typing.Optional[QuantConnect.Resolution] = None) -> pandas.DataFrame:
        """
        Gets the historical data for the specified symbols. The exact number of bars will be returned for
        each symbol. This may result in some data start earlier/later than others due to when various
        exchanges are open. The symbols must exist in the Securities collection.
        
        :param type: The data type of the symbols
        :param tickers: The symbols to retrieve historical data for
        :param periods: The number of bars to request
        :param resolution: The resolution to request
        :returns: pandas.DataFrame containing the requested historical data.
        """
        ...

    @typing.overload
    def History(self, type: typing.Type, tickers: typing.Any, span: datetime.timedelta, resolution: typing.Optional[QuantConnect.Resolution] = None) -> pandas.DataFrame:
        """
        Gets the historical data for the specified symbols over the requested span.
        The symbols must exist in the Securities collection.
        
        :param type: The data type of the symbols
        :param tickers: The symbols to retrieve historical data for
        :param span: The span over which to retrieve recent historical data
        :param resolution: The resolution to request
        :returns: pandas.DataFrame containing the requested historical data.
        """
        ...

    @typing.overload
    def History(self, type: typing.Type, symbol: typing.Union[QuantConnect.Symbol, str], start: typing.Union[datetime.datetime, datetime.date], end: typing.Union[datetime.datetime, datetime.date], resolution: typing.Optional[QuantConnect.Resolution] = None) -> pandas.DataFrame:
        """
        Gets the historical data for the specified symbols between the specified dates. The symbols must exist in the Securities collection.
        
        :param type: The data type of the symbols
        :param symbol: The symbol to retrieve historical data for
        :param start: The start time in the algorithm's time zone
        :param end: The end time in the algorithm's time zone
        :param resolution: The resolution to request
        :returns: pandas.DataFrame containing the requested historical data.
        """
        ...

    @typing.overload
    def History(self, type: typing.Type, symbol: typing.Union[QuantConnect.Symbol, str], periods: int, resolution: typing.Optional[QuantConnect.Resolution] = None) -> pandas.DataFrame:
        """
        Gets the historical data for the specified symbols. The exact number of bars will be returned for
        each symbol. This may result in some data start earlier/later than others due to when various
        exchanges are open. The symbols must exist in the Securities collection.
        
        :param type: The data type of the symbols
        :param symbol: The symbol to retrieve historical data for
        :param periods: The number of bars to request
        :param resolution: The resolution to request
        :returns: pandas.DataFrame containing the requested historical data.
        """
        ...

    @typing.overload
    def History(self, type: typing.Type, symbol: typing.Union[QuantConnect.Symbol, str], span: datetime.timedelta, resolution: typing.Optional[QuantConnect.Resolution] = None) -> pandas.DataFrame:
        """
        Gets the historical data for the specified symbols over the requested span.
        The symbols must exist in the Securities collection.
        
        :param type: The data type of the symbols
        :param symbol: The symbol to retrieve historical data for
        :param span: The span over which to retrieve recent historical data
        :param resolution: The resolution to request
        :returns: pandas.DataFrame containing the requested historical data.
        """
        ...

    @typing.overload
    def History(self, span: datetime.timedelta, resolution: typing.Optional[QuantConnect.Resolution] = None) -> pandas.DataFrame:
        """
        Get the history for all configured securities over the requested span.
        This will use the resolution and other subscription settings for each security.
        The symbols must exist in the Securities collection.
        
        :param span: The span over which to request data. This is a calendar span, so take into consideration weekends and such
        :param resolution: The resolution to request
        :returns: An enumerable of slice containing data over the most recent span for all configured securities.
        """
        ...

    @typing.overload
    def History(self, periods: int, resolution: typing.Optional[QuantConnect.Resolution] = None) -> pandas.DataFrame:
        """
        Get the history for all configured securities over the requested span.
        This will use the resolution and other subscription settings for each security.
        The symbols must exist in the Securities collection.
        
        :param periods: The number of bars to request
        :param resolution: The resolution to request
        :returns: An enumerable of slice containing data over the most recent span for all configured securities.
        """
        ...

    @typing.overload
    def History(self, span: datetime.timedelta, resolution: typing.Optional[QuantConnect.Resolution] = None) -> pandas.DataFrame:
        """
        Gets the historical data for all symbols of the requested type over the requested span.
        The symbol's configured values for resolution and fill forward behavior will be used
        The symbols must exist in the Securities collection.
        
        :param span: The span over which to retrieve recent historical data
        :param resolution: The resolution to request
        :returns: An enumerable of slice containing the requested historical data.
        """
        ...

    @typing.overload
    def History(self, symbols: System.Collections.Generic.IEnumerable[QuantConnect.Symbol], span: datetime.timedelta, resolution: typing.Optional[QuantConnect.Resolution] = None) -> pandas.DataFrame:
        """
        Gets the historical data for the specified symbols over the requested span.
        The symbols must exist in the Securities collection.
        
        :param symbols: The symbols to retrieve historical data for
        :param span: The span over which to retrieve recent historical data
        :param resolution: The resolution to request
        :returns: An enumerable of slice containing the requested historical data.
        """
        ...

    @typing.overload
    def History(self, symbols: System.Collections.Generic.IEnumerable[QuantConnect.Symbol], periods: int, resolution: typing.Optional[QuantConnect.Resolution] = None) -> pandas.DataFrame:
        """
        Gets the historical data for the specified symbols. The exact number of bars will be returned for
        each symbol. This may result in some data start earlier/later than others due to when various
        exchanges are open. The symbols must exist in the Securities collection.
        
        :param symbols: The symbols to retrieve historical data for
        :param periods: The number of bars to request
        :param resolution: The resolution to request
        :returns: An enumerable of slice containing the requested historical data.
        """
        ...

    @typing.overload
    def History(self, symbols: System.Collections.Generic.IEnumerable[QuantConnect.Symbol], start: typing.Union[datetime.datetime, datetime.date], end: typing.Union[datetime.datetime, datetime.date], resolution: typing.Optional[QuantConnect.Resolution] = None) -> pandas.DataFrame:
        """
        Gets the historical data for the specified symbols between the specified dates. The symbols must exist in the Securities collection.
        
        :param symbols: The symbols to retrieve historical data for
        :param start: The start time in the algorithm's time zone
        :param end: The end time in the algorithm's time zone
        :param resolution: The resolution to request
        :returns: An enumerable of slice containing the requested historical data.
        """
        ...

    @typing.overload
    def History(self, symbol: typing.Union[QuantConnect.Symbol, str], span: datetime.timedelta, resolution: typing.Optional[QuantConnect.Resolution] = None) -> pandas.DataFrame:
        """
        Gets the historical data for the specified symbol over the request span. The symbol must exist in the Securities collection.
        
        :param symbol: The symbol to retrieve historical data for
        :param span: The span over which to retrieve recent historical data
        :param resolution: The resolution to request
        :returns: An enumerable of slice containing the requested historical data.
        """
        ...

    @typing.overload
    def History(self, symbol: typing.Union[QuantConnect.Symbol, str], periods: int, resolution: typing.Optional[QuantConnect.Resolution] = None) -> pandas.DataFrame:
        """
        Gets the historical data for the specified symbol. The exact number of bars will be returned.
        The symbol must exist in the Securities collection.
        
        :param symbol: The symbol to retrieve historical data for
        :param periods: The number of bars to request
        :param resolution: The resolution to request
        :returns: An enumerable of slice containing the requested historical data.
        """
        ...

    @typing.overload
    def History(self, symbol: typing.Union[QuantConnect.Symbol, str], periods: int, resolution: typing.Optional[QuantConnect.Resolution] = None) -> pandas.DataFrame:
        """
        Gets the historical data for the specified symbol. The exact number of bars will be returned.
        The symbol must exist in the Securities collection.
        
        :param symbol: The symbol to retrieve historical data for
        :param periods: The number of bars to request
        :param resolution: The resolution to request
        :returns: An enumerable of slice containing the requested historical data.
        """
        ...

    @typing.overload
    def History(self, symbol: typing.Union[QuantConnect.Symbol, str], start: typing.Union[datetime.datetime, datetime.date], end: typing.Union[datetime.datetime, datetime.date], resolution: typing.Optional[QuantConnect.Resolution] = None) -> pandas.DataFrame:
        """
        Gets the historical data for the specified symbol between the specified dates. The symbol must exist in the Securities collection.
        
        :param symbol: The symbol to retrieve historical data for
        :param start: The start time in the algorithm's time zone
        :param end: The end time in the algorithm's time zone
        :param resolution: The resolution to request
        :returns: An enumerable of slice containing the requested historical data.
        """
        ...

    @typing.overload
    def History(self, symbol: typing.Union[QuantConnect.Symbol, str], span: datetime.timedelta, resolution: typing.Optional[QuantConnect.Resolution] = None) -> pandas.DataFrame:
        """
        Gets the historical data for the specified symbol over the request span. The symbol must exist in the Securities collection.
        
        :param symbol: The symbol to retrieve historical data for
        :param span: The span over which to retrieve recent historical data
        :param resolution: The resolution to request
        :returns: An enumerable of slice containing the requested historical data.
        """
        ...

    @typing.overload
    def History(self, symbol: typing.Union[QuantConnect.Symbol, str], start: typing.Union[datetime.datetime, datetime.date], end: typing.Union[datetime.datetime, datetime.date], resolution: typing.Optional[QuantConnect.Resolution] = None) -> pandas.DataFrame:
        """
        Gets the historical data for the specified symbol over the request span. The symbol must exist in the Securities collection.
        
        :param symbol: The symbol to retrieve historical data for
        :param start: The start time in the algorithm's time zone
        :param end: The end time in the algorithm's time zone
        :param resolution: The resolution to request
        :returns: An enumerable of slice containing the requested historical data.
        """
        ...

    @typing.overload
    def History(self, symbols: System.Collections.Generic.IEnumerable[QuantConnect.Symbol], span: datetime.timedelta, resolution: typing.Optional[QuantConnect.Resolution] = None) -> pandas.DataFrame:
        """
        Gets the historical data for the specified symbols over the requested span.
        The symbol's configured values for resolution and fill forward behavior will be used
        The symbols must exist in the Securities collection.
        
        :param symbols: The symbols to retrieve historical data for
        :param span: The span over which to retrieve recent historical data
        :param resolution: The resolution to request
        :returns: An enumerable of slice containing the requested historical data.
        """
        ...

    @typing.overload
    def History(self, symbols: System.Collections.Generic.IEnumerable[QuantConnect.Symbol], periods: int, resolution: typing.Optional[QuantConnect.Resolution] = None) -> pandas.DataFrame:
        """
        Gets the historical data for the specified symbols. The exact number of bars will be returned for
        each symbol. This may result in some data start earlier/later than others due to when various
        exchanges are open. The symbols must exist in the Securities collection.
        
        :param symbols: The symbols to retrieve historical data for
        :param periods: The number of bars to request
        :param resolution: The resolution to request
        :returns: An enumerable of slice containing the requested historical data.
        """
        ...

    @typing.overload
    def History(self, symbols: System.Collections.Generic.IEnumerable[QuantConnect.Symbol], start: typing.Union[datetime.datetime, datetime.date], end: typing.Union[datetime.datetime, datetime.date], resolution: typing.Optional[QuantConnect.Resolution] = None, fillForward: typing.Optional[bool] = None, extendedMarket: typing.Optional[bool] = None) -> pandas.DataFrame:
        """
        Gets the historical data for the specified symbols between the specified dates. The symbols must exist in the Securities collection.
        
        :param symbols: The symbols to retrieve historical data for
        :param start: The start time in the algorithm's time zone
        :param end: The end time in the algorithm's time zone
        :param resolution: The resolution to request
        :param fillForward: True to fill forward missing data, false otherwise
        :param extendedMarket: True to include extended market hours data, false otherwise
        :returns: An enumerable of slice containing the requested historical data.
        """
        ...

    @typing.overload
    def History(self, request: QuantConnect.Data.HistoryRequest) -> pandas.DataFrame:
        """
        Executes the specified history request
        
        :param request: the history request to execute
        :returns: An enumerable of slice satisfying the specified history request.
        """
        ...

    @typing.overload
    def History(self, requests: System.Collections.Generic.IEnumerable[QuantConnect.Data.HistoryRequest]) -> pandas.DataFrame:
        """
        Executes the specified history requests
        
        :param requests: the history requests to execute
        :returns: An enumerable of slice satisfying the specified history request.
        """
        ...

    def HMA(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.HullMovingAverage:
        """
        Creates a new HullMovingAverage indicator. The Hull moving average is a series of nested weighted moving averages, is fast and smooth.
        
        :param symbol: The symbol whose Hull moving average we want
        :param period: The period over which to compute the Hull moving average
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        """
        ...

    def ICHIMOKU(self, symbol: typing.Union[QuantConnect.Symbol, str], tenkanPeriod: int, kijunPeriod: int, senkouAPeriod: int, senkouBPeriod: int, senkouADelayPeriod: int, senkouBDelayPeriod: int, resolution: typing.Optional[QuantConnect.Resolution] = None) -> QuantConnect.Indicators.IchimokuKinkoHyo:
        """
        Creates a new IchimokuKinkoHyo indicator for the symbol. The indicator will be automatically
        updated on the given resolution.
        
        :param symbol: The symbol whose ICHIMOKU we want
        :param tenkanPeriod: The period to calculate the Tenkan-sen period
        :param kijunPeriod: The period to calculate the Kijun-sen period
        :param senkouAPeriod: The period to calculate the Tenkan-sen period
        :param senkouBPeriod: The period to calculate the Tenkan-sen period
        :param senkouADelayPeriod: The period to calculate the Tenkan-sen period
        :param senkouBDelayPeriod: The period to calculate the Tenkan-sen period
        :param resolution: The resolution
        :returns: A new IchimokuKinkoHyo indicator with the specified periods and delays.
        """
        ...

    @typing.overload
    def Identity(self, symbol: typing.Union[QuantConnect.Symbol, str], selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None, fieldName: str = None) -> QuantConnect.Indicators.Identity:
        """
        Creates a new Identity indicator for the symbol The indicator will be automatically
        updated on the symbol's subscription resolution
        
        :param symbol: The symbol whose values we want as an indicator
        :param selector: Selects a value from the BaseData, if null defaults to the .Value property (x => x.Value)
        :param fieldName: The name of the field being selected
        :returns: A new Identity indicator for the specified symbol and selector.
        """
        ...

    @typing.overload
    def Identity(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: QuantConnect.Resolution, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None, fieldName: str = None) -> QuantConnect.Indicators.Identity:
        """
        Creates a new Identity indicator for the symbol The indicator will be automatically
        updated on the symbol's subscription resolution
        
        :param symbol: The symbol whose values we want as an indicator
        :param resolution: The desired resolution of the data
        :param selector: Selects a value from the BaseData, if null defaults to the .Value property (x => x.Value)
        :param fieldName: The name of the field being selected
        :returns: A new Identity indicator for the specified symbol and selector.
        """
        ...

    @typing.overload
    def Identity(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: datetime.timedelta, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None, fieldName: str = None) -> QuantConnect.Indicators.Identity:
        """
        Creates a new Identity indicator for the symbol The indicator will be automatically
        updated on the symbol's subscription resolution
        
        :param symbol: The symbol whose values we want as an indicator
        :param resolution: The desired resolution of the data
        :param selector: Selects a value from the BaseData, if null defaults to the .Value property (x => x.Value)
        :param fieldName: The name of the field being selected
        :returns: A new Identity indicator for the specified symbol and selector.
        """
        ...

    def Initialize(self) -> None:
        """Initialise the data and resolution required, as well as the cash and start-end dates for your algorithm. All algorithms must initialized."""
        ...

    def IsMarketOpen(self, symbol: typing.Union[QuantConnect.Symbol, str]) -> bool:
        """
        Determines if the exchange for the specified symbol is open at the current time.
        
        :param symbol: The symbol
        :returns: True if the exchange is considered open at the current time, false otherwise.
        """
        ...

    @typing.overload
    def KAMA(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.KaufmanAdaptiveMovingAverage:
        """
        Creates a new KaufmanAdaptiveMovingAverage indicator.
        
        :param symbol: The symbol whose KAMA we want
        :param period: The period of the Efficiency Ratio (ER) of KAMA
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The KaufmanAdaptiveMovingAverage indicator for the requested symbol over the specified period.
        """
        ...

    @typing.overload
    def KAMA(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, fastEmaPeriod: int, slowEmaPeriod: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.KaufmanAdaptiveMovingAverage:
        """
        Creates a new KaufmanAdaptiveMovingAverage indicator.
        
        :param symbol: The symbol whose KAMA we want
        :param period: The period of the Efficiency Ratio (ER)
        :param fastEmaPeriod: The period of the fast EMA used to calculate the Smoothing Constant (SC)
        :param slowEmaPeriod: The period of the slow EMA used to calculate the Smoothing Constant (SC)
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The KaufmanAdaptiveMovingAverage indicator for the requested symbol over the specified period.
        """
        ...

    def KCH(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, k: float, movingAverageType: QuantConnect.Indicators.MovingAverageType = ..., resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.KeltnerChannels:
        """
        Creates a new Keltner Channels indicator.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose Keltner Channel we seek
        :param period: The period over which to compute the Keltner Channels
        :param k: The number of multiples of the AverageTrueRange from the middle band of the Keltner Channels
        :param movingAverageType: Specifies the type of moving average to be used as the middle line of the Keltner Channel
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The Keltner Channel indicator for the requested symbol.
        """
        ...

    @typing.overload
    def LimitIfTouchedOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: int, triggerPrice: float, limitPrice: float, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Send a limit if touched order to the transaction handler:
        
        :param symbol: String symbol for the asset
        :param quantity: Quantity of shares for limit order
        :param triggerPrice: Trigger price for this order
        :param limitPrice: Limit price to fill this order
        :param tag: String tag for the order (optional)
        :returns: Order id.
        """
        ...

    @typing.overload
    def LimitIfTouchedOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float, triggerPrice: float, limitPrice: float, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Send a limit if touched order to the transaction handler:
        
        :param symbol: String symbol for the asset
        :param quantity: Quantity of shares for limit order
        :param triggerPrice: Trigger price for this order
        :param limitPrice: Limit price to fill this order
        :param tag: String tag for the order (optional)
        :returns: Order id.
        """
        ...

    @typing.overload
    def LimitIfTouchedOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float, triggerPrice: float, limitPrice: float, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Send a limit if touched order to the transaction handler:
        
        :param symbol: String symbol for the asset
        :param quantity: Quantity of shares for limit order
        :param triggerPrice: Trigger price for this order
        :param limitPrice: Limit price to fill this order
        :param tag: String tag for the order (optional)
        :returns: Order id.
        """
        ...

    @typing.overload
    def LimitOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: int, limitPrice: float, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Send a limit order to the transaction handler:
        
        :param symbol: String symbol for the asset
        :param quantity: Quantity of shares for limit order
        :param limitPrice: Limit price to fill this order
        :param tag: String tag for the order (optional)
        :returns: Order id.
        """
        ...

    @typing.overload
    def LimitOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float, limitPrice: float, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Send a limit order to the transaction handler:
        
        :param symbol: String symbol for the asset
        :param quantity: Quantity of shares for limit order
        :param limitPrice: Limit price to fill this order
        :param tag: String tag for the order (optional)
        :returns: Order id.
        """
        ...

    @typing.overload
    def LimitOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float, limitPrice: float, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Send a limit order to the transaction handler:
        
        :param symbol: String symbol for the asset
        :param quantity: Quantity of shares for limit order
        :param limitPrice: Limit price to fill this order
        :param tag: String tag for the order (optional)
        :returns: Order id.
        """
        ...

    def Liquidate(self, symbolToLiquidate: typing.Union[QuantConnect.Symbol, str] = None, tag: str = "Liquidated") -> System.Collections.Generic.List[int]:
        """
        Liquidate all holdings and cancel open orders. Called at the end of day for tick-strategies.
        
        :param symbolToLiquidate: Symbols we wish to liquidate
        :param tag: Custom tag to know who is calling this.
        :returns: Array of order ids for liquidated symbols.
        """
        ...

    @typing.overload
    def Log(self, message: typing.Any) -> None:
        """
        Added another method for logging if user guessed.
        
        :param message: String message to log.
        """
        ...

    @typing.overload
    def Log(self, message: str) -> None:
        """
        Added another method for logging if user guessed.
        
        :param message: String message to log.
        """
        ...

    @typing.overload
    def Log(self, message: int) -> None:
        """
        Added another method for logging if user guessed.
        
        :param message: Int message to log.
        """
        ...

    @typing.overload
    def Log(self, message: float) -> None:
        """
        Added another method for logging if user guessed.
        
        :param message: Double message to log.
        """
        ...

    @typing.overload
    def Log(self, message: float) -> None:
        """
        Added another method for logging if user guessed.
        
        :param message: Decimal message to log.
        """
        ...

    def LOGR(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.LogReturn:
        """
        Creates a new LogReturn indicator.
        
        :param symbol: The symbol whose log return we seek
        :param period: The period of the log return.
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar.
        :returns: log return indicator for the requested symbol.
        """
        ...

    def LSMA(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.LeastSquaresMovingAverage:
        """
        Creates and registers a new Least Squares Moving Average instance.
        
        :param symbol: The symbol whose LSMA we seek.
        :param period: The LSMA period. Normally 14.
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar.
        :returns: A LeastSquaredMovingAverage configured with the specified period.
        """
        ...

    def LWMA(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.LinearWeightedMovingAverage:
        """
        Creates a new LinearWeightedMovingAverage indicator.  This indicator will linearly distribute
        the weights across the periods.
        
        :param symbol: The symbol whose LWMA we want
        :param period: The period over which to compute the LWMA
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        """
        ...

    def MACD(self, symbol: typing.Union[QuantConnect.Symbol, str], fastPeriod: int, slowPeriod: int, signalPeriod: int, type: QuantConnect.Indicators.MovingAverageType = ..., resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.MovingAverageConvergenceDivergence:
        """
        Creates a MACD indicator for the symbol. The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose MACD we want
        :param fastPeriod: The period for the fast moving average
        :param slowPeriod: The period for the slow moving average
        :param signalPeriod: The period for the signal moving average
        :param type: The type of moving average to use for the MACD
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The moving average convergence divergence between the fast and slow averages.
        """
        ...

    def MAD(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.MeanAbsoluteDeviation:
        """
        Creates a new MeanAbsoluteDeviation indicator.
        
        :param symbol: The symbol whose MeanAbsoluteDeviation we want
        :param period: The period over which to compute the MeanAbsoluteDeviation
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The MeanAbsoluteDeviation indicator for the requested symbol over the specified period.
        """
        ...

    @typing.overload
    def MarketOnCloseOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: int, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Market on close order implementation: Send a market order when the exchange closes
        
        :param symbol: The symbol to be ordered
        :param quantity: The number of shares to required
        :param tag: Place a custom order property or tag (e.g. indicator data).
        :returns: The order ID.
        """
        ...

    @typing.overload
    def MarketOnCloseOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Market on close order implementation: Send a market order when the exchange closes
        
        :param symbol: The symbol to be ordered
        :param quantity: The number of shares to required
        :param tag: Place a custom order property or tag (e.g. indicator data).
        :returns: The order ID.
        """
        ...

    @typing.overload
    def MarketOnCloseOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Market on close order implementation: Send a market order when the exchange closes
        
        :param symbol: The symbol to be ordered
        :param quantity: The number of shares to required
        :param tag: Place a custom order property or tag (e.g. indicator data).
        :returns: The order ID.
        """
        ...

    @typing.overload
    def MarketOnOpenOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Market on open order implementation: Send a market order when the exchange opens
        
        :param symbol: The symbol to be ordered
        :param quantity: The number of shares to required
        :param tag: Place a custom order property or tag (e.g. indicator data).
        :returns: The order ID.
        """
        ...

    @typing.overload
    def MarketOnOpenOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: int, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Market on open order implementation: Send a market order when the exchange opens
        
        :param symbol: The symbol to be ordered
        :param quantity: The number of shares to required
        :param tag: Place a custom order property or tag (e.g. indicator data).
        :returns: The order ID.
        """
        ...

    @typing.overload
    def MarketOnOpenOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Market on open order implementation: Send a market order when the exchange opens
        
        :param symbol: The symbol to be ordered
        :param quantity: The number of shares to required
        :param tag: Place a custom order property or tag (e.g. indicator data).
        :returns: The order ID.
        """
        ...

    @typing.overload
    def MarketOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: int, asynchronous: bool = False, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Market order implementation: Send a market order and wait for it to be filled.
        
        :param symbol: Symbol of the MarketType Required.
        :param quantity: Number of shares to request.
        :param asynchronous: Send the order asynchronously (false). Otherwise we'll block until it fills
        :param tag: Place a custom order property or tag (e.g. indicator data).
        :returns: int Order id.
        """
        ...

    @typing.overload
    def MarketOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float, asynchronous: bool = False, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Market order implementation: Send a market order and wait for it to be filled.
        
        :param symbol: Symbol of the MarketType Required.
        :param quantity: Number of shares to request.
        :param asynchronous: Send the order asynchronously (false). Otherwise we'll block until it fills
        :param tag: Place a custom order property or tag (e.g. indicator data).
        :returns: int Order id.
        """
        ...

    @typing.overload
    def MarketOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float, asynchronous: bool = False, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Market order implementation: Send a market order and wait for it to be filled.
        
        :param symbol: Symbol of the MarketType Required.
        :param quantity: Number of shares to request.
        :param asynchronous: Send the order asynchronously (false). Otherwise we'll block until it fills
        :param tag: Place a custom order property or tag (e.g. indicator data).
        :returns: int Order id.
        """
        ...

    def MASS(self, symbol: typing.Union[QuantConnect.Symbol, str], emaPeriod: int = 9, sumPeriod: int = 25, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.TradeBar] = None) -> QuantConnect.Indicators.MassIndex:
        """
        Creates a new Mass Index indicator. The indicator will be automatically
        updated on the given resolution.
        
        :param symbol: The symbol whose Mass Index we want.
        :param emaPeriod: The period used by both EMA.
        :param sumPeriod: The sum period.
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The Mass Index indicator for the requested symbol over the specified period.
        """
        ...

    def MAX(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.Maximum:
        """
        Creates a new Maximum indicator to compute the maximum value
        
        :param symbol: The symbol whose max we want
        :param period: The look back period over which to compute the max value
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null and the symbol is of type TradeBar defaults to the High property, otherwise it defaults to Value property of BaseData (x => x.Value)
        :returns: A Maximum indicator that compute the max value and the periods since the max value.
        """
        ...

    def MFI(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.TradeBar] = None) -> QuantConnect.Indicators.MoneyFlowIndex:
        """
        Creates a new MoneyFlowIndex indicator. The indicator will be automatically
        updated on the given resolution.
        
        :param symbol: The symbol whose MFI we want
        :param period: The period over which to compute the MFI
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The MoneyFlowIndex indicator for the requested symbol over the specified period.
        """
        ...

    def MIDPOINT(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.MidPoint:
        """
        Creates a new MidPoint indicator.
        
        :param symbol: The symbol whose MIDPOINT we want
        :param period: The period over which to compute the MIDPOINT
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The MidPoint indicator for the requested symbol over the specified period.
        """
        ...

    def MIDPRICE(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.MidPrice:
        """
        Creates a new MidPrice indicator.
        
        :param symbol: The symbol whose MIDPRICE we want
        :param period: The period over which to compute the MIDPRICE
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The MidPrice indicator for the requested symbol over the specified period.
        """
        ...

    def MIN(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.Minimum:
        """
        Creates a new Minimum indicator to compute the minimum value
        
        :param symbol: The symbol whose min we want
        :param period: The look back period over which to compute the min value
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null and the symbol is of type TradeBar defaults to the Low property, otherwise it defaults to Value property of BaseData (x => x.Value)
        :returns: A Minimum indicator that compute the in value and the periods since the min value.
        """
        ...

    def MOM(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.Momentum:
        """
        Creates a new Momentum indicator. This will compute the absolute n-period change in the security.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose momentum we want
        :param period: The period over which to compute the momentum
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The momentum indicator for the requested symbol over the specified period.
        """
        ...

    def MOMERSION(self, symbol: typing.Union[QuantConnect.Symbol, str], minPeriod: typing.Optional[int], fullPeriod: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.MomersionIndicator:
        """
        Creates a new Momersion indicator.
        
        :param symbol: The symbol whose Momersion we want
        :param minPeriod: The minimum period over which to compute the Momersion. Must be greater than 3. If null, only full period will be used in computations.
        :param fullPeriod: The full period over which to compute the Momersion
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The Momersion indicator for the requested symbol over the specified period.
        """
        ...

    def MOMP(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.MomentumPercent:
        """
        Creates a new MomentumPercent indicator. This will compute the n-period percent change in the security.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose momentum we want
        :param period: The period over which to compute the momentum
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The momentum indicator for the requested symbol over the specified period.
        """
        ...

    def NATR(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.NormalizedAverageTrueRange:
        """
        Creates a new NormalizedAverageTrueRange indicator.
        
        :param symbol: The symbol whose NATR we want
        :param period: The period over which to compute the NATR
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The NormalizedAverageTrueRange indicator for the requested symbol over the specified period.
        """
        ...

    def OBV(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.TradeBar] = None) -> QuantConnect.Indicators.OnBalanceVolume:
        """
        Creates a new On Balance Volume indicator. This will compute the cumulative total volume
        based on whether the close price being higher or lower than the previous period.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose On Balance Volume we seek
        :param resolution: The resolution.
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: The On Balance Volume indicator for the requested symbol.
        """
        ...

    def OnAssignmentOrderEvent(self, assignmentEvent: QuantConnect.Orders.OrderEvent) -> None:
        """
        Option assignment event handler. On an option assignment event for short legs the resulting information is passed to this method.
        
        :param assignmentEvent: Option exercise event details containing details of the assignment
        """
        ...

    def OnBrokerageDisconnect(self) -> None:
        """Brokerage disconnected event handler. This method is called when the brokerage connection is lost."""
        ...

    def OnBrokerageMessage(self, messageEvent: QuantConnect.Brokerages.BrokerageMessageEvent) -> None:
        """Brokerage message event handler. This method is called for all types of brokerage messages."""
        ...

    def OnBrokerageReconnect(self) -> None:
        """Brokerage reconnected event handler. This method is called when the brokerage connection is restored after a disconnection."""
        ...

    def OnData(self, slice: QuantConnect.Data.Slice) -> None:
        """
        Event - v3.0 DATA EVENT HANDLER: (Pattern) Basic template for user to override for receiving all subscription data in a single event
        
        :param slice: The current slice of data keyed by symbol string
        """
        ...

    def OnEndOfAlgorithm(self) -> None:
        """End of algorithm run event handler. This method is called at the end of a backtest or live trading operation. Intended for closing out logs."""
        ...

    @typing.overload
    def OnEndOfDay(self, symbol: str) -> None:
        """
        End of a trading day event handler. This method is called at the end of the algorithm day (or multiple times if trading multiple assets).
        
        :param symbol: Asset symbol for this end of day event. Forex and equities have different closing hours.
        """
        ...

    @typing.overload
    def OnEndOfDay(self, symbol: typing.Union[QuantConnect.Symbol, str]) -> None:
        """
        End of a trading day event handler. This method is called at the end of the algorithm day (or multiple times if trading multiple assets).
        
        :param symbol: Asset symbol for this end of day event. Forex and equities have different closing hours.
        """
        ...

    @typing.overload
    def OnEndOfDay(self) -> None:
        """
        End of a trading day event handler. This method is called at the end of the algorithm day (or multiple times if trading multiple assets).
        
        This method is deprecated and will be removed after August 2021. Please use this overload: OnEndOfDay(Symbol symbol)
        """
        ...

    def OnEndOfTimeStep(self) -> None:
        """
        Invoked at the end of every time step. This allows the algorithm
        to process events before advancing to the next time step.
        """
        ...

    def OnFrameworkData(self, slice: QuantConnect.Data.Slice) -> None:
        """
        Used to send data updates to algorithm framework models
        
        :param slice: The current data slice
        """
        ...

    def OnFrameworkSecuritiesChanged(self, changes: QuantConnect.Data.UniverseSelection.SecurityChanges) -> None:
        """
        Used to send security changes to algorithm framework models
        
        :param changes: Security additions/removals for this time step
        """
        ...

    def OnMarginCall(self, requests: System.Collections.Generic.List[QuantConnect.Orders.SubmitOrderRequest]) -> None:
        ...

    def OnMarginCallWarning(self) -> None:
        """Margin call warning event handler. This method is called when Portfolio.MarginRemaining is under 5% of your Portfolio.TotalPortfolioValue"""
        ...

    def OnOrderEvent(self, orderEvent: QuantConnect.Orders.OrderEvent) -> None:
        """
        Order fill event handler. On an order fill update the resulting information is passed to this method.
        
        :param orderEvent: Order event details containing details of the evemts
        """
        ...

    def OnSecuritiesChanged(self, changes: QuantConnect.Data.UniverseSelection.SecurityChanges) -> None:
        """
        Event fired each time the we add/remove securities from the data feed
        
        :param changes: Security additions/removals for this time step
        """
        ...

    def OnWarmupFinished(self) -> None:
        """Called when the algorithm has completed initialization and warm up."""
        ...

    @typing.overload
    def Order(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float) -> QuantConnect.Orders.OrderTicket:
        """Issue an order/trade for asset: Alias wrapper for Order(string, int);"""
        ...

    @typing.overload
    def Order(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: int) -> QuantConnect.Orders.OrderTicket:
        """Issue an order/trade for asset"""
        ...

    @typing.overload
    def Order(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float) -> QuantConnect.Orders.OrderTicket:
        """Issue an order/trade for asset"""
        ...

    @typing.overload
    def Order(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float, asynchronous: bool = False, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Wrapper for market order method: submit a new order for quantity of symbol using type order.
        
        :param symbol: Symbol of the MarketType Required.
        :param quantity: Number of shares to request.
        :param asynchronous: Send the order asynchronously (false). Otherwise we'll block until it fills
        :param tag: Place a custom order property or tag (e.g. indicator data).
        """
        ...

    @typing.overload
    def Order(self, strategy: QuantConnect.Securities.Option.OptionStrategy, quantity: int) -> System.Collections.Generic.IEnumerable[QuantConnect.Orders.OrderTicket]:
        """
        Issue an order/trade for buying/selling an option strategy
        
        :param strategy: Specification of the strategy to trade
        :param quantity: Quantity of the strategy to trade
        :returns: Sequence of order ids.
        """
        ...

    @typing.overload
    def Order(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: int, type: QuantConnect.Orders.OrderType, asynchronous: bool = False, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Obsolete implementation of Order method accepting a OrderType. This was deprecated since it
        was impossible to generate other orders via this method. Any calls to this method will always default to a Market Order.
        
        This Order method has been made obsolete, use Order(string, int, bool, string) method instead. Calls to the obsolete method will only generate market orders.
        
        :param symbol: Symbol we want to purchase
        :param quantity: Quantity to buy, + is long, - short.
        :param type: Order Type
        :param asynchronous: Don't wait for the response, just submit order and move on.
        :param tag: Custom data for this order
        :returns: Integer Order ID.
        """
        ...

    @typing.overload
    def Order(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float, type: QuantConnect.Orders.OrderType) -> QuantConnect.Orders.OrderTicket:
        """
        Obsolete method for placing orders.
        
        This Order method has been made obsolete, use the specialized Order helper methods instead. Calls to the obsolete method will only generate market orders.
        """
        ...

    @typing.overload
    def Order(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: int, type: QuantConnect.Orders.OrderType) -> QuantConnect.Orders.OrderTicket:
        """
        Obsolete method for placing orders.
        
        This Order method has been made obsolete, use the specialized Order helper methods instead. Calls to the obsolete method will only generate market orders.
        """
        ...

    @typing.overload
    def Plot(self, series: str, value: float) -> None:
        """
        Plot a chart using string series name, with value.
        
        :param series: Name of the plot series
        :param value: Value to plot
        """
        ...

    @typing.overload
    def Plot(self, series: str, value: float) -> None:
        """Plot a chart using string series name, with double value."""
        ...

    @typing.overload
    def Plot(self, series: str, value: int) -> None:
        """Plot a chart using string series name, with int value."""
        ...

    @typing.overload
    def Plot(self, series: str, value: float) -> None:
        """Plot a chart using string series name, with float value."""
        ...

    @typing.overload
    def Plot(self, chart: str, series: str, value: float) -> None:
        """Plot a chart to string chart name, using string series name, with double value."""
        ...

    @typing.overload
    def Plot(self, chart: str, series: str, value: int) -> None:
        """Plot a chart to string chart name, using string series name, with int value"""
        ...

    @typing.overload
    def Plot(self, chart: str, series: str, value: float) -> None:
        """Plot a chart to string chart name, using string series name, with float value"""
        ...

    @typing.overload
    def Plot(self, chart: str, series: str, value: float) -> None:
        """
        Plot a value to a chart of string-chart name, with string series name, and decimal value. If chart does not exist, create it.
        
        :param chart: Chart name
        :param series: Series name
        :param value: Value of the point
        """
        ...

    @typing.overload
    def Plot(self, chart: str, *indicators: QuantConnect.Indicators.IndicatorBase[QuantConnect_Algorithm_QCAlgorithm_Plot_T]) -> None:
        """
        Plots the value of each indicator on the chart
        
        :param chart: The chart's name
        :param indicators: The indicatorsto plot
        """
        ...

    @typing.overload
    def PlotIndicator(self, chart: str, *indicators: QuantConnect.Indicators.IndicatorBase[QuantConnect_Algorithm_QCAlgorithm_PlotIndicator_T]) -> None:
        """Automatically plots each indicator when a new value is available"""
        ...

    @typing.overload
    def PlotIndicator(self, chart: str, waitForReady: bool, *indicators: QuantConnect.Indicators.IndicatorBase[QuantConnect_Algorithm_QCAlgorithm_PlotIndicator_T]) -> None:
        """Automatically plots each indicator when a new value is available, optionally waiting for indicator.IsReady to return true"""
        ...

    def PostInitialize(self) -> None:
        """
        Called by setup handlers after Initialize and allows the algorithm a chance to organize
        the data gather in the Initialize method
        """
        ...

    def PPHL(self, symbol: typing.Union[QuantConnect.Symbol, str], lengthHigh: int, lengthLow: int, lastStoredValues: int = 100, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.PivotPointsHighLow:
        """
        Creates a new PivotPointsHighLow indicator
        
        :param symbol: The symbol whose PPHL we seek
        :param lengthHigh: The number of surrounding bars whose high values should be less than the current bar's for the bar high to be marked as high pivot point
        :param lengthLow: The number of surrounding bars whose low values should be more than the current bar's for the bar low to be marked as low pivot point
        :param lastStoredValues: The number of last stored indicator values
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The PivotPointsHighLow indicator for the requested symbol.
        """
        ...

    def PPO(self, symbol: typing.Union[QuantConnect.Symbol, str], fastPeriod: int, slowPeriod: int, movingAverageType: QuantConnect.Indicators.MovingAverageType, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.PercentagePriceOscillator:
        """
        Creates a new PercentagePriceOscillator indicator.
        
        :param symbol: The symbol whose PPO we want
        :param fastPeriod: The fast moving average period
        :param slowPeriod: The slow moving average period
        :param movingAverageType: The type of moving average to use
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The PercentagePriceOscillator indicator for the requested symbol over the specified period.
        """
        ...

    def PSAR(self, symbol: typing.Union[QuantConnect.Symbol, str], afStart: float = 0.02, afIncrement: float = 0.02, afMax: float = 0.2, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.ParabolicStopAndReverse:
        """
        Creates a new Parabolic SAR indicator
        
        :param symbol: The symbol whose PSAR we seek
        :param afStart: Acceleration factor start value. Normally 0.02
        :param afIncrement: Acceleration factor increment value. Normally 0.02
        :param afMax: Acceleration factor max value. Normally 0.2
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to casting the input value to a TradeBar
        :returns: A ParabolicStopAndReverse configured with the specified periods.
        """
        ...

    @typing.overload
    def Quit(self, message: typing.Any) -> None:
        """
        Terminate the algorithm after processing the current event handler.
        
        :param message: Exit message to display on quitting
        """
        ...

    @typing.overload
    def Quit(self, message: str = ...) -> None:
        """
        Terminate the algorithm after processing the current event handler.
        
        :param message: Exit message to display on quitting
        """
        ...

    def RC(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, k: float, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.RegressionChannel:
        """
        Creates a new RegressionChannel indicator which will compute the LinearRegression, UpperChannel and LowerChannel lines, the intercept and slope
        
        :param symbol: The symbol whose RegressionChannel we seek
        :param period: The period of the standard deviation and least square moving average (linear regression line)
        :param k: The number of standard deviations specifying the distance between the linear regression and upper or lower channel lines
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: A Regression Channel configured with the specified period and number of standard deviation.
        """
        ...

    @typing.overload
    def Record(self, series: str, value: int) -> None:
        """Plot a chart using string series name, with int value. Alias of Plot();"""
        ...

    @typing.overload
    def Record(self, series: str, value: float) -> None:
        """Plot a chart using string series name, with double value. Alias of Plot();"""
        ...

    @typing.overload
    def Record(self, series: str, value: float) -> None:
        """Plot a chart using string series name, with decimal value. Alias of Plot();"""
        ...

    @typing.overload
    def RegisterIndicator(self, symbol: typing.Union[QuantConnect.Symbol, str], indicator: QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> None:
        """
        Creates and registers a new consolidator to receive automatic updates at the specified resolution as well as configures
        the indicator to receive updates from the consolidator.
        
        :param symbol: The symbol to register against
        :param indicator: The indicator to receive data from the consolidator
        :param resolution: The resolution at which to send data to the indicator, null to use the same resolution as the subscription
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        """
        ...

    @typing.overload
    def RegisterIndicator(self, symbol: typing.Union[QuantConnect.Symbol, str], indicator: QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint], resolution: typing.Optional[datetime.timedelta] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> None:
        """
        Creates and registers a new consolidator to receive automatic updates at the specified resolution as well as configures
        the indicator to receive updates from the consolidator.
        
        :param symbol: The symbol to register against
        :param indicator: The indicator to receive data from the consolidator
        :param resolution: The resolution at which to send data to the indicator, null to use the same resolution as the subscription
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        """
        ...

    @typing.overload
    def RegisterIndicator(self, symbol: typing.Union[QuantConnect.Symbol, str], indicator: QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint], consolidator: typing.Union[QuantConnect.Data.Consolidators.IDataConsolidator, QuantConnect.Python.PythonConsolidator, datetime.timedelta], selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> None:
        """
        Registers the consolidator to receive automatic updates as well as configures the indicator to receive updates
        from the consolidator.
        
        :param symbol: The symbol to register against
        :param indicator: The indicator to receive data from the consolidator
        :param consolidator: The consolidator to receive raw subscription data
        :param selector: Selects a value from the BaseData send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        """
        ...

    @typing.overload
    def RegisterIndicator(self, symbol: typing.Union[QuantConnect.Symbol, str], indicator: QuantConnect.Indicators.IndicatorBase[QuantConnect_Algorithm_QCAlgorithm_RegisterIndicator_T], resolution: typing.Optional[QuantConnect.Resolution] = None) -> None:
        """
        Registers the consolidator to receive automatic updates as well as configures the indicator to receive updates
        from the consolidator.
        
        :param symbol: The symbol to register against
        :param indicator: The indicator to receive data from the consolidator
        :param resolution: The resolution at which to send data to the indicator, null to use the same resolution as the subscription
        """
        ...

    @typing.overload
    def RegisterIndicator(self, symbol: typing.Union[QuantConnect.Symbol, str], indicator: QuantConnect.Indicators.IndicatorBase[QuantConnect_Algorithm_QCAlgorithm_RegisterIndicator_T], resolution: typing.Optional[QuantConnect.Resolution], selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect_Algorithm_QCAlgorithm_RegisterIndicator_T]) -> None:
        """
        Registers the consolidator to receive automatic updates as well as configures the indicator to receive updates
        from the consolidator.
        
        :param symbol: The symbol to register against
        :param indicator: The indicator to receive data from the consolidator
        :param resolution: The resolution at which to send data to the indicator, null to use the same resolution as the subscription
        :param selector: Selects a value from the BaseData send into the indicator, if null defaults to a cast (x => (T)x)
        """
        ...

    @typing.overload
    def RegisterIndicator(self, symbol: typing.Union[QuantConnect.Symbol, str], indicator: QuantConnect.Indicators.IndicatorBase[QuantConnect_Algorithm_QCAlgorithm_RegisterIndicator_T], resolution: typing.Optional[datetime.timedelta], selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect_Algorithm_QCAlgorithm_RegisterIndicator_T] = None) -> None:
        """
        Registers the consolidator to receive automatic updates as well as configures the indicator to receive updates
        from the consolidator.
        
        :param symbol: The symbol to register against
        :param indicator: The indicator to receive data from the consolidator
        :param resolution: The resolution at which to send data to the indicator, null to use the same resolution as the subscription
        :param selector: Selects a value from the BaseData send into the indicator, if null defaults to a cast (x => (T)x)
        """
        ...

    @typing.overload
    def RegisterIndicator(self, symbol: typing.Union[QuantConnect.Symbol, str], indicator: QuantConnect.Indicators.IndicatorBase[QuantConnect_Algorithm_QCAlgorithm_RegisterIndicator_T], consolidator: typing.Union[QuantConnect.Data.Consolidators.IDataConsolidator, QuantConnect.Python.PythonConsolidator, datetime.timedelta], selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect_Algorithm_QCAlgorithm_RegisterIndicator_T] = None) -> None:
        """
        Registers the consolidator to receive automatic updates as well as configures the indicator to receive updates
        from the consolidator.
        
        :param symbol: The symbol to register against
        :param indicator: The indicator to receive data from the consolidator
        :param consolidator: The consolidator to receive raw subscription data
        :param selector: Selects a value from the BaseData send into the indicator, if null defaults to a cast (x => (T)x)
        """
        ...

    def RemoveOptionContract(self, symbol: typing.Union[QuantConnect.Symbol, str]) -> bool:
        """
        Removes the security with the specified symbol. This will cancel all
        open orders and then liquidate any existing holdings
        
        :param symbol: The symbol of the security to be removed
        """
        ...

    def RemoveSecurity(self, symbol: typing.Union[QuantConnect.Symbol, str]) -> bool:
        """
        Removes the security with the specified symbol. This will cancel all
        open orders and then liquidate any existing holdings
        
        :param symbol: The symbol of the security to be removed
        """
        ...

    @typing.overload
    def ResolveConsolidator(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution], dataType: typing.Type = None) -> QuantConnect.Data.Consolidators.IDataConsolidator:
        """
        Gets the default consolidator for the specified symbol and resolution
        
        :param symbol: The symbol whose data is to be consolidated
        :param resolution: The resolution for the consolidator, if null, uses the resolution from subscription
        :param dataType: The data type for this consolidator, if null, uses TradeBar over QuoteBar if present
        :returns: The new default consolidator.
        """
        ...

    @typing.overload
    def ResolveConsolidator(self, symbol: typing.Union[QuantConnect.Symbol, str], timeSpan: typing.Optional[datetime.timedelta], dataType: typing.Type = None) -> QuantConnect.Data.Consolidators.IDataConsolidator:
        """
        Gets the default consolidator for the specified symbol and resolution
        
        :param symbol: The symbol whose data is to be consolidated
        :param timeSpan: The requested time span for the consolidator, if null, uses the resolution from subscription
        :param dataType: The data type for this consolidator, if null, uses TradeBar over QuoteBar if present
        :returns: The new default consolidator.
        """
        ...

    def ROC(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.RateOfChange:
        """
        Creates a new RateOfChange indicator. This will compute the n-period rate of change in the security.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose RateOfChange we want
        :param period: The period over which to compute the RateOfChange
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The RateOfChange indicator for the requested symbol over the specified period.
        """
        ...

    def ROCP(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.RateOfChangePercent:
        """
        Creates a new RateOfChangePercent indicator. This will compute the n-period percentage rate of change in the security.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose RateOfChangePercent we want
        :param period: The period over which to compute the RateOfChangePercent
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The RateOfChangePercent indicator for the requested symbol over the specified period.
        """
        ...

    def ROCR(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.RateOfChangeRatio:
        """
        Creates a new RateOfChangeRatio indicator.
        
        :param symbol: The symbol whose ROCR we want
        :param period: The period over which to compute the ROCR
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The RateOfChangeRatio indicator for the requested symbol over the specified period.
        """
        ...

    def RSI(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, movingAverageType: QuantConnect.Indicators.MovingAverageType = ..., resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.RelativeStrengthIndex:
        """
        Creates a new RelativeStrengthIndex indicator. This will produce an oscillator that ranges from 0 to 100 based
        on the ratio of average gains to average losses over the specified period.
        
        :param symbol: The symbol whose RSI we want
        :param period: The period over which to compute the RSI
        :param movingAverageType: The type of moving average to use in computing the average gain/loss values
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The RelativeStrengthIndex indicator for the requested symbol over the specified period.
        """
        ...

    def RVI(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, movingAverageType: QuantConnect.Indicators.MovingAverageType = ..., resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.TradeBar] = None) -> QuantConnect.Indicators.RelativeVigorIndex:
        """
        Creates a new RelativeVigorIndex indicator.
        
        :param symbol: The symbol whose RVI we want
        :param period: The period over which to compute the RVI
        :param movingAverageType: The type of moving average to use
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The RelativeVigorIndex indicator for the requested symbol over the specified period.
        """
        ...

    @typing.overload
    def Sell(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: int) -> QuantConnect.Orders.OrderTicket:
        """
        Sell stock (alias of Order)
        
        :param symbol: string Symbol of the asset to trade
        :param quantity: int Quantity of the asset to trade
        """
        ...

    @typing.overload
    def Sell(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float) -> QuantConnect.Orders.OrderTicket:
        """
        Sell stock (alias of Order)
        
        :param symbol: String symbol to sell
        :param quantity: Quantity to order
        :returns: int Order Id.
        """
        ...

    @typing.overload
    def Sell(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float) -> QuantConnect.Orders.OrderTicket:
        """
        Sell stock (alias of Order)
        
        :param symbol: String symbol
        :param quantity: Quantity to sell
        :returns: int order id.
        """
        ...

    @typing.overload
    def Sell(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float) -> QuantConnect.Orders.OrderTicket:
        """
        Sell stock (alias of Order)
        
        :param symbol: String symbol to sell
        :param quantity: Quantity to sell
        :returns: Int Order Id.
        """
        ...

    @typing.overload
    def Sell(self, strategy: QuantConnect.Securities.Option.OptionStrategy, quantity: int) -> System.Collections.Generic.IEnumerable[QuantConnect.Orders.OrderTicket]:
        """
        Sell Option Strategy (alias of Order)
        
        :param strategy: Specification of the strategy to trade
        :param quantity: Quantity of the strategy to trade
        :returns: Sequence of order ids.
        """
        ...

    def SetAccountCurrency(self, accountCurrency: str) -> None:
        """
        Sets the account currency cash symbol this algorithm is to manage.
        
        :param accountCurrency: The account currency cash symbol to set
        """
        ...

    def SetAlgorithmId(self, algorithmId: str) -> None:
        """
        Set the algorithm id (backtestId or live deployId for the algorithmm).
        
        :param algorithmId: String Algorithm Id
        """
        ...

    def SetAlpha(self, alpha: QuantConnect.Algorithm.Framework.Alphas.IAlphaModel) -> None:
        """
        Sets the alpha model
        
        :param alpha: Model that generates alpha
        """
        ...

    def SetApi(self, api: QuantConnect.Interfaces.IApi) -> None:
        """
        Provide the API for the algorithm.
        
        :param api: Initiated API
        """
        ...

    def SetAvailableDataTypes(self, availableDataTypes: System.Collections.Generic.Dictionary[QuantConnect.SecurityType, System.Collections.Generic.List[QuantConnect.TickType]]) -> None:
        """
        Set the available data feeds in the SecurityManager
        
        :param availableDataTypes: The different TickType each Security supports
        """
        ...

    @typing.overload
    def SetBenchmark(self, securityType: QuantConnect.SecurityType, symbol: str) -> None:
        """
        Sets the benchmark used for computing statistics of the algorithm to the specified symbol
        
        :param securityType: Is the symbol an equity, forex, base, etc. Default SecurityType.Equity
        :param symbol: symbol to use as the benchmark
        """
        ...

    @typing.overload
    def SetBenchmark(self, ticker: str) -> None:
        """
        Sets the benchmark used for computing statistics of the algorithm to the specified ticker, defaulting to SecurityType.Equity
        if the ticker doesn't exist in the algorithm
        
        :param ticker: Ticker to use as the benchmark
        """
        ...

    @typing.overload
    def SetBenchmark(self, symbol: typing.Union[QuantConnect.Symbol, str]) -> None:
        """
        Sets the benchmark used for computing statistics of the algorithm to the specified symbol
        
        :param symbol: symbol to use as the benchmark
        """
        ...

    @typing.overload
    def SetBenchmark(self, benchmark: typing.Callable[[datetime.datetime], float]) -> None:
        """
        Sets the specified function as the benchmark, this function provides the value of
        the benchmark at each date/time requested
        
        :param benchmark: The benchmark producing function
        """
        ...

    def SetBrokerageMessageHandler(self, handler: QuantConnect.Brokerages.IBrokerageMessageHandler) -> None:
        """
        Sets the implementation used to handle messages from the brokerage.
        The default implementation will forward messages to debug or error
        and when a BrokerageMessageType.Error occurs, the algorithm
        is stopped.
        
        :param handler: The message handler to use
        """
        ...

    @typing.overload
    def SetBrokerageModel(self, brokerage: QuantConnect.Brokerages.BrokerageName, accountType: QuantConnect.AccountType = ...) -> None:
        """
        Sets the brokerage to emulate in backtesting or paper trading.
        This can be used for brokerages that have been implemented in LEAN
        
        :param brokerage: The brokerage to emulate
        :param accountType: The account type (Cash or Margin)
        """
        ...

    @typing.overload
    def SetBrokerageModel(self, model: QuantConnect.Brokerages.IBrokerageModel) -> None:
        """
        Sets the brokerage to emulate in backtesting or paper trading.
        This can be used to set a custom brokerage model.
        
        :param model: The brokerage model to use
        """
        ...

    @typing.overload
    def SetCash(self, startingCash: float) -> None:
        """
        Set initial cash for the strategy while backtesting. During live mode this value is ignored
        and replaced with the actual cash of your brokerage account.
        
        :param startingCash: Starting cash for the strategy backtest
        """
        ...

    @typing.overload
    def SetCash(self, startingCash: int) -> None:
        """
        Set initial cash for the strategy while backtesting. During live mode this value is ignored
        and replaced with the actual cash of your brokerage account.
        
        :param startingCash: Starting cash for the strategy backtest
        """
        ...

    @typing.overload
    def SetCash(self, startingCash: float) -> None:
        """
        Set initial cash for the strategy while backtesting. During live mode this value is ignored
        and replaced with the actual cash of your brokerage account.
        
        :param startingCash: Starting cash for the strategy backtest
        """
        ...

    @typing.overload
    def SetCash(self, symbol: str, startingCash: float, conversionRate: float = 0) -> None:
        """
        Set the cash for the specified symbol
        
        :param symbol: The cash symbol to set
        :param startingCash: Decimal cash value of portfolio
        :param conversionRate: The current conversion rate for the
        """
        ...

    def SetCurrentSlice(self, slice: QuantConnect.Data.Slice) -> None:
        """
        Sets the current slice
        
        :param slice: The Slice object
        """
        ...

    def SetDateTime(self, frontier: typing.Union[datetime.datetime, datetime.date]) -> None:
        """
        Update the internal algorithm time frontier.
        
        :param frontier: Current utc datetime.
        """
        ...

    @typing.overload
    def SetEndDate(self, year: int, month: int, day: int) -> None:
        """
        Set the end date for a backtest run
        
        :param year: Int year end date
        :param month: Int month end date
        :param day: Int end date 1-30
        """
        ...

    @typing.overload
    def SetEndDate(self, end: typing.Union[datetime.datetime, datetime.date]) -> None:
        """
        Set the end date for a backtest.
        
        :param end: Datetime value for end date
        """
        ...

    def SetExecution(self, execution: QuantConnect.Algorithm.Framework.Execution.IExecutionModel) -> None:
        """
        Sets the execution model
        
        :param execution: Model defining how to execute trades to reach a portfolio target
        """
        ...

    def SetFinishedWarmingUp(self) -> None:
        """Sets IAlgorithm.IsWarmingUp to false to indicate this algorithm has finished its warm up"""
        ...

    def SetFutureChainProvider(self, futureChainProvider: QuantConnect.Interfaces.IFutureChainProvider) -> None:
        """
        Sets the future chain provider, used to get the list of future contracts for an underlying symbol
        
        :param futureChainProvider: The future chain provider
        """
        ...

    def SetHistoryProvider(self, historyProvider: QuantConnect.Interfaces.IHistoryProvider) -> None:
        """
        Set the historical data provider
        
        :param historyProvider: Historical data provider
        """
        ...

    @typing.overload
    def SetHoldings(self, targets: System.Collections.Generic.List[QuantConnect.Algorithm.Framework.Portfolio.PortfolioTarget], liquidateExistingHoldings: bool = False) -> None:
        """
        Sets holdings for a collection of targets.
        The implementation will order the provided targets executing first those that
        reduce a position, freeing margin.
        
        :param targets: The portfolio desired quantities as percentages
        :param liquidateExistingHoldings: True will liquidate existing holdings
        """
        ...

    @typing.overload
    def SetHoldings(self, symbol: typing.Union[QuantConnect.Symbol, str], percentage: float, liquidateExistingHoldings: bool = False) -> None:
        """
        Alias for SetHoldings to avoid the M-decimal errors.
        
        :param symbol: string symbol we wish to hold
        :param percentage: double percentage of holdings desired
        :param liquidateExistingHoldings: liquidate existing holdings if necessary to hold this stock
        """
        ...

    @typing.overload
    def SetHoldings(self, symbol: typing.Union[QuantConnect.Symbol, str], percentage: float, liquidateExistingHoldings: bool = False, tag: str = ...) -> None:
        """
        Alias for SetHoldings to avoid the M-decimal errors.
        
        :param symbol: string symbol we wish to hold
        :param percentage: float percentage of holdings desired
        :param liquidateExistingHoldings: bool liquidate existing holdings if necessary to hold this stock
        :param tag: Tag the order with a short string.
        """
        ...

    @typing.overload
    def SetHoldings(self, symbol: typing.Union[QuantConnect.Symbol, str], percentage: int, liquidateExistingHoldings: bool = False, tag: str = ...) -> None:
        """
        Alias for SetHoldings to avoid the M-decimal errors.
        
        :param symbol: string symbol we wish to hold
        :param percentage: float percentage of holdings desired
        :param liquidateExistingHoldings: bool liquidate existing holdings if necessary to hold this stock
        :param tag: Tag the order with a short string.
        """
        ...

    @typing.overload
    def SetHoldings(self, symbol: typing.Union[QuantConnect.Symbol, str], percentage: float, liquidateExistingHoldings: bool = False, tag: str = ...) -> None:
        """
        Automatically place a market order which will set the holdings to between 100% or -100% of *PORTFOLIO VALUE*.
        E.g. SetHoldings("AAPL", 0.1); SetHoldings("IBM", -0.2); -> Sets portfolio as long 10% APPL and short 20% IBM
        E.g. SetHoldings("AAPL", 2); -> Sets apple to 2x leveraged with all our cash.
        If the market is closed, place a market on open order.
        
        :param symbol: Symbol indexer
        :param percentage: decimal fraction of portfolio to set stock
        :param liquidateExistingHoldings: bool flag to clean all existing holdings before setting new faction.
        :param tag: Tag the order with a short string.
        """
        ...

    def SetLiveMode(self, live: bool) -> None:
        """Set live mode state of the algorithm run: Public setter for the algorithm property LiveMode."""
        ...

    def SetLocked(self) -> None:
        """Lock the algorithm initialization to avoid user modifiying cash and data stream subscriptions"""
        ...

    def SetMaximumOrders(self, max: int) -> None:
        """Maximum number of orders for the algorithm"""
        ...

    def SetObjectStore(self, objectStore: QuantConnect.Interfaces.IObjectStore) -> None:
        """
        Sets the object store
        
        :param objectStore: The object store
        """
        ...

    def SetOptionChainProvider(self, optionChainProvider: QuantConnect.Interfaces.IOptionChainProvider) -> None:
        """
        Sets the option chain provider, used to get the list of option contracts for an underlying symbol
        
        :param optionChainProvider: The option chain provider
        """
        ...

    def SetParameters(self, parameters: System.Collections.Generic.Dictionary[str, str]) -> None:
        """
        Sets the parameters from the dictionary
        
        :param parameters: Dictionary containing the parameter names to values
        """
        ...

    def SetPortfolioConstruction(self, portfolioConstruction: QuantConnect.Algorithm.Framework.Portfolio.IPortfolioConstructionModel) -> None:
        """
        Sets the portfolio construction model
        
        :param portfolioConstruction: Model defining how to build a portfolio from insights
        """
        ...

    def SetQuit(self, quit: bool) -> None:
        """
        Set the Quit flag property of the algorithm.
        
        :param quit: Boolean quit state
        """
        ...

    def SetRiskManagement(self, riskManagement: QuantConnect.Algorithm.Framework.Risk.IRiskManagementModel) -> None:
        """
        Sets the risk management model
        
        :param riskManagement: Model defining how risk is managed
        """
        ...

    def SetRunTimeError(self, exception: System.Exception) -> None:
        """
        Set the runtime error
        
        :param exception: Represents error that occur during execution
        """
        ...

    @typing.overload
    def SetRuntimeStatistic(self, name: str, value: str) -> None:
        """
        Set a runtime statistic for the algorithm. Runtime statistics are shown in the top banner of a live algorithm GUI.
        
        :param name: Name of your runtime statistic
        :param value: String value of your runtime statistic
        """
        ...

    @typing.overload
    def SetRuntimeStatistic(self, name: str, value: float) -> None:
        """
        Set a runtime statistic for the algorithm. Runtime statistics are shown in the top banner of a live algorithm GUI.
        
        :param name: Name of your runtime statistic
        :param value: Decimal value of your runtime statistic
        """
        ...

    @typing.overload
    def SetRuntimeStatistic(self, name: str, value: int) -> None:
        """
        Set a runtime statistic for the algorithm. Runtime statistics are shown in the top banner of a live algorithm GUI.
        
        :param name: Name of your runtime statistic
        :param value: Int value of your runtime statistic
        """
        ...

    @typing.overload
    def SetRuntimeStatistic(self, name: str, value: float) -> None:
        """
        Set a runtime statistic for the algorithm. Runtime statistics are shown in the top banner of a live algorithm GUI.
        
        :param name: Name of your runtime statistic
        :param value: Double value of your runtime statistic
        """
        ...

    @typing.overload
    def SetSecurityInitializer(self, securityInitializer: QuantConnect.Securities.ISecurityInitializer) -> None:
        """
        Sets the security initializer, used to initialize/configure securities after creation.
        The initializer will be applied to all universes and manually added securities.
        
        :param securityInitializer: The security initializer
        """
        ...

    @typing.overload
    def SetSecurityInitializer(self, securityInitializer: typing.Callable[[QuantConnect.Securities.Security], None]) -> None:
        """
        Sets the security initializer function, used to initialize/configure securities after creation.
        The initializer will be applied to all universes and manually added securities.
        
        :param securityInitializer: The security initializer function
        """
        ...

    @typing.overload
    def SetSecurityInitializer(self, securityInitializer: typing.Callable[[QuantConnect.Securities.Security, bool], None]) -> None:
        """
        Sets the security initializer function, used to initialize/configure securities after creation.
        The initializer will be applied to all universes and manually added securities.
        
        This method is deprecated. Please use this overload: SetSecurityInitializer(Action<Security> securityInitializer)
        
        :param securityInitializer: The security initializer function
        """
        ...

    @typing.overload
    def SetStartDate(self, year: int, month: int, day: int) -> None:
        """
        Set the start date for backtest.
        
        :param year: Int year starting date
        :param month: Int month starting date
        :param day: Int starting date 1-30
        """
        ...

    @typing.overload
    def SetStartDate(self, start: typing.Union[datetime.datetime, datetime.date]) -> None:
        """
        Set the start date for the backtest
        
        :param start: Datetime Start date for backtest
        """
        ...

    def SetStatus(self, status: QuantConnect.AlgorithmStatus) -> None:
        """
        Set the state of a live deployment
        
        :param status: Live deployment status
        """
        ...

    @typing.overload
    def SetTimeZone(self, timeZone: str) -> None:
        """
        Sets the time zone of the Time property in the algorithm
        
        :param timeZone: The desired time zone
        """
        ...

    @typing.overload
    def SetTimeZone(self, timeZone: typing.Any) -> None:
        """
        Sets the time zone of the Time property in the algorithm
        
        :param timeZone: The desired time zone
        """
        ...

    def SetTradeBuilder(self, tradeBuilder: QuantConnect.Interfaces.ITradeBuilder) -> None:
        """Set the ITradeBuilder implementation to generate trades from executions and market price updates"""
        ...

    def SetUniverseSelection(self, universeSelection: QuantConnect.Algorithm.Framework.Selection.IUniverseSelectionModel) -> None:
        """
        Sets the universe selection model
        
        :param universeSelection: Model defining universes for the algorithm
        """
        ...

    @typing.overload
    def SetWarmup(self, timeSpan: datetime.timedelta) -> None:
        """
        Sets the warm up period to the specified value
        
        :param timeSpan: The amount of time to warm up, this does not take into account market hours/weekends
        """
        ...

    @typing.overload
    def SetWarmup(self, timeSpan: datetime.timedelta, resolution: typing.Optional[QuantConnect.Resolution]) -> None:
        """
        Sets the warm up period to the specified value
        
        :param timeSpan: The amount of time to warm up, this does not take into account market hours/weekends
        :param resolution: The resolution to request
        """
        ...

    @typing.overload
    def SetWarmup(self, barCount: int) -> None:
        """
        Sets the warm up period by resolving a start date that would send that amount of data into
        the algorithm. The highest (smallest) resolution in the securities collection will be used.
        For example, if an algorithm has minute and daily data and 200 bars are requested, that would
        use 200 minute bars.
        
        :param barCount: The number of data points requested for warm up
        """
        ...

    @typing.overload
    def SetWarmup(self, barCount: int, resolution: typing.Optional[QuantConnect.Resolution]) -> None:
        """
        Sets the warm up period by resolving a start date that would send that amount of data into
        the algorithm.
        
        :param barCount: The number of data points requested for warm up
        :param resolution: The resolution to request
        """
        ...

    @typing.overload
    def SetWarmUp(self, timeSpan: datetime.timedelta) -> None:
        """
        Sets the warm up period to the specified value
        
        :param timeSpan: The amount of time to warm up, this does not take into account market hours/weekends
        """
        ...

    @typing.overload
    def SetWarmUp(self, timeSpan: datetime.timedelta, resolution: typing.Optional[QuantConnect.Resolution]) -> None:
        """
        Sets the warm up period to the specified value
        
        :param timeSpan: The amount of time to warm up, this does not take into account market hours/weekends
        :param resolution: The resolution to request
        """
        ...

    @typing.overload
    def SetWarmUp(self, barCount: int) -> None:
        """
        Sets the warm up period by resolving a start date that would send that amount of data into
        the algorithm. The highest (smallest) resolution in the securities collection will be used.
        For example, if an algorithm has minute and daily data and 200 bars are requested, that would
        use 200 minute bars.
        
        :param barCount: The number of data points requested for warm up
        """
        ...

    @typing.overload
    def SetWarmUp(self, barCount: int, resolution: typing.Optional[QuantConnect.Resolution]) -> None:
        """
        Sets the warm up period by resolving a start date that would send that amount of data into
        the algorithm.
        
        :param barCount: The number of data points requested for warm up
        :param resolution: The resolution to request
        """
        ...

    @typing.overload
    def Shortable(self, symbol: typing.Union[QuantConnect.Symbol, str]) -> bool:
        """
        Determines if the Symbol is shortable at the brokerage
        
        :param symbol: Symbol to check if shortable
        :returns: True if shortable.
        """
        ...

    @typing.overload
    def Shortable(self, symbol: typing.Union[QuantConnect.Symbol, str], shortQuantity: float) -> bool:
        """
        Determines if the Symbol is shortable at the brokerage
        
        :param symbol: Symbol to check if shortable
        :param shortQuantity: Order's quantity to check if it is currently shortable, taking into account current holdings and open orders
        :returns: True if shortable.
        """
        ...

    def ShortableQuantity(self, symbol: typing.Union[QuantConnect.Symbol, str]) -> int:
        """
        Gets the quantity shortable for the given asset
        
        :returns: Quantity shortable for the given asset. Zero if not shortable, or a number greater than zero if shortable.
        """
        ...

    def SI(self, symbol: typing.Union[QuantConnect.Symbol, str], limitMove: float, resolution: typing.Optional[QuantConnect.Resolution] = ...) -> QuantConnect.Indicators.WilderSwingIndex:
        """
        Creates a Wilder Swing Index (SI) indicator for the symbol.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose SI we want
        :param limitMove: The maximum daily change in price for the SI
        :param resolution: The resolution
        :returns: The WilderSwingIndex for the given parameters.
        """
        ...

    def SMA(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.SimpleMovingAverage:
        """
        Creates an SimpleMovingAverage indicator for the symbol. The indicator will be automatically
        updated on the given resolution.
        
        :param symbol: The symbol whose SMA we want
        :param period: The period of the SMA
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The SimpleMovingAverage for the given parameters.
        """
        ...

    def SR(self, symbol: typing.Union[QuantConnect.Symbol, str], sharpePeriod: int, riskFreeRate: float = 0.0, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.SharpeRatio:
        """
        Creates a new RollingSharpeRatio indicator.
        
        :param symbol: The symbol whose RSR we want
        :param sharpePeriod: Period of historical observation for sharpe ratio calculation
        :param riskFreeRate: Risk-free rate for sharpe ratio calculation
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The RollingSharpeRatio indicator for the requested symbol over the specified period.
        """
        ...

    def STC(self, symbol: typing.Union[QuantConnect.Symbol, str], cyclePeriod: int, fastPeriod: int, slowPeriod: int, movingAverageType: QuantConnect.Indicators.MovingAverageType = ..., resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.SchaffTrendCycle:
        """
        Creates a new Schaff Trend Cycle indicator
        
        :param symbol: The symbol for the indicator to track
        :param cyclePeriod: The signal period
        :param fastPeriod: The fast moving average period
        :param slowPeriod: The slow moving average period
        :param movingAverageType: The type of moving average to use
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The SchaffTrendCycle indicator for the requested symbol over the specified period.
        """
        ...

    def STD(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.StandardDeviation:
        """
        Creates a new StandardDeviation indicator. This will return the population standard deviation of samples over the specified period.
        
        :param symbol: The symbol whose STD we want
        :param period: The period over which to compute the STD
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The StandardDeviation indicator for the requested symbol over the specified period.
        """
        ...

    @typing.overload
    def STO(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, kPeriod: int, dPeriod: int, resolution: typing.Optional[QuantConnect.Resolution] = None) -> QuantConnect.Indicators.Stochastic:
        """
        Creates a new Stochastic indicator.
        
        :param symbol: The symbol whose stochastic we seek
        :param period: The period of the stochastic. Normally 14
        :param kPeriod: The sum period of the stochastic. Normally 14
        :param dPeriod: The sum period of the stochastic. Normally 3
        :param resolution: The resolution.
        :returns: Stochastic indicator for the requested symbol.
        """
        ...

    @typing.overload
    def STO(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None) -> QuantConnect.Indicators.Stochastic:
        """
        Overload short hand to create a new Stochastic indicator; defaulting to the 3 period for dStoch
        
        :param symbol: The symbol whose stochastic we seek
        :param period: The period of the stochastic. Normally 14
        :param resolution: The resolution.
        :returns: Stochastic indicator for the requested symbol.
        """
        ...

    @typing.overload
    def StopLimitOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: int, stopPrice: float, limitPrice: float, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Send a stop limit order to the transaction handler:
        
        :param symbol: String symbol for the asset
        :param quantity: Quantity of shares for limit order
        :param stopPrice: Stop price for this order
        :param limitPrice: Limit price to fill this order
        :param tag: String tag for the order (optional)
        :returns: Order id.
        """
        ...

    @typing.overload
    def StopLimitOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float, stopPrice: float, limitPrice: float, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Send a stop limit order to the transaction handler:
        
        :param symbol: String symbol for the asset
        :param quantity: Quantity of shares for limit order
        :param stopPrice: Stop price for this order
        :param limitPrice: Limit price to fill this order
        :param tag: String tag for the order (optional)
        :returns: Order id.
        """
        ...

    @typing.overload
    def StopLimitOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float, stopPrice: float, limitPrice: float, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Send a stop limit order to the transaction handler:
        
        :param symbol: String symbol for the asset
        :param quantity: Quantity of shares for limit order
        :param stopPrice: Stop price for this order
        :param limitPrice: Limit price to fill this order
        :param tag: String tag for the order (optional)
        :returns: Order id.
        """
        ...

    @typing.overload
    def StopMarketOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: int, stopPrice: float, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Create a stop market order and return the newly created order id; or negative if the order is invalid
        
        :param symbol: String symbol for the asset we're trading
        :param quantity: Quantity to be traded
        :param stopPrice: Price to fill the stop order
        :param tag: Optional string data tag for the order
        :returns: Int orderId for the new order.
        """
        ...

    @typing.overload
    def StopMarketOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float, stopPrice: float, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Create a stop market order and return the newly created order id; or negative if the order is invalid
        
        :param symbol: String symbol for the asset we're trading
        :param quantity: Quantity to be traded
        :param stopPrice: Price to fill the stop order
        :param tag: Optional string data tag for the order
        :returns: Int orderId for the new order.
        """
        ...

    @typing.overload
    def StopMarketOrder(self, symbol: typing.Union[QuantConnect.Symbol, str], quantity: float, stopPrice: float, tag: str = ...) -> QuantConnect.Orders.OrderTicket:
        """
        Create a stop market order and return the newly created order id; or negative if the order is invalid
        
        :param symbol: String symbol for the asset we're trading
        :param quantity: Quantity to be traded
        :param stopPrice: Price to fill the stop order
        :param tag: Optional string data tag for the order
        :returns: Int orderId for the new order.
        """
        ...

    def SUM(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.Sum:
        """
        Creates a new Sum indicator.
        
        :param symbol: The symbol whose Sum we want
        :param period: The period over which to compute the Sum
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The Sum indicator for the requested symbol over the specified period.
        """
        ...

    def SWISS(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, delta: float, tool: QuantConnect.Indicators.SwissArmyKnifeTool, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.SwissArmyKnife:
        """
        Creates Swiss Army Knife transformation for the symbol. The indicator will be automatically
        updated on the given resolution.
        
        :param symbol: The symbol to use for calculations
        :param period: The period of the calculation
        :param delta: The delta scale of the BandStop or BandPass
        :param tool: The tool os the Swiss Army Knife
        :param resolution: The resolution
        :param selector: elects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The calculation using the given tool.
        """
        ...

    def Symbol(self, ticker: str) -> QuantConnect.Symbol:
        """
        Converts the string 'ticker' symbol into a full Symbol object
        This requires that the string 'ticker' has been added to the algorithm
        
        :param ticker: The ticker symbol. This should be the ticker symbol as it was added to the algorithm
        :returns: The symbol object mapped to the specified ticker.
        """
        ...

    def T3(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, volumeFactor: float = 0.7, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.T3MovingAverage:
        """
        Creates a new T3MovingAverage indicator.
        
        :param symbol: The symbol whose T3 we want
        :param period: The period over which to compute the T3
        :param volumeFactor: The volume factor to be used for the T3 (value must be in the [0,1] range, defaults to 0.7)
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The T3MovingAverage indicator for the requested symbol over the specified period.
        """
        ...

    def TEMA(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.TripleExponentialMovingAverage:
        """
        Creates a new TripleExponentialMovingAverage indicator.
        
        :param symbol: The symbol whose TEMA we want
        :param period: The period over which to compute the TEMA
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The TripleExponentialMovingAverage indicator for the requested symbol over the specified period.
        """
        ...

    def TR(self, symbol: typing.Union[QuantConnect.Symbol, str], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.TrueRange:
        """
        Creates a new TrueRange indicator.
        
        :param symbol: The symbol whose TR we want
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The TrueRange indicator for the requested symbol.
        """
        ...

    @typing.overload
    def Train(self, trainingCode: typing.Callable[[], None]) -> QuantConnect.Scheduling.ScheduledEvent:
        """
        Schedules the provided training code to execute immediately
        
        :param trainingCode: The training code to be invoked
        """
        ...

    @typing.overload
    def Train(self, dateRule: QuantConnect.Scheduling.IDateRule, timeRule: QuantConnect.Scheduling.ITimeRule, trainingCode: typing.Callable[[], None]) -> QuantConnect.Scheduling.ScheduledEvent:
        """
        Schedules the training code to run using the specified date and time rules
        
        :param dateRule: Specifies what dates the event should run
        :param timeRule: Specifies the times on those dates the event should run
        :param trainingCode: The training code to be invoked
        """
        ...

    def TRIMA(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.TriangularMovingAverage:
        """
        Creates a new TriangularMovingAverage indicator.
        
        :param symbol: The symbol whose TRIMA we want
        :param period: The period over which to compute the TRIMA
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The TriangularMovingAverage indicator for the requested symbol over the specified period.
        """
        ...

    @typing.overload
    def TRIN(self, symbols: System.Collections.Generic.IEnumerable[QuantConnect.Symbol], resolution: typing.Optional[QuantConnect.Resolution] = None) -> QuantConnect.Indicators.ArmsIndex:
        """
        Creates a new Arms Index indicator
        
        :param symbols: The symbols whose Arms Index we want
        :param resolution: The resolution
        :returns: The Arms Index indicator for the requested symbol over the specified period.
        """
        ...

    @typing.overload
    def TRIN(self, symbols: typing.List[QuantConnect.Symbol], resolution: typing.Optional[QuantConnect.Resolution] = None) -> QuantConnect.Indicators.ArmsIndex:
        """
        Creates a new Arms Index indicator
        
        :param symbols: The symbols whose Arms Index we want
        :param resolution: The resolution
        :returns: The Arms Index indicator for the requested symbol over the specified period.
        """
        ...

    def TRIX(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.Trix:
        """
        Creates a new Trix indicator.
        
        :param symbol: The symbol whose TRIX we want
        :param period: The period over which to compute the TRIX
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The Trix indicator for the requested symbol over the specified period.
        """
        ...

    def ULTOSC(self, symbol: typing.Union[QuantConnect.Symbol, str], period1: int, period2: int, period3: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.UltimateOscillator:
        """
        Creates a new UltimateOscillator indicator.
        
        :param symbol: The symbol whose ULTOSC we want
        :param period1: The first period over which to compute the ULTOSC
        :param period2: The second period over which to compute the ULTOSC
        :param period3: The third period over which to compute the ULTOSC
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The UltimateOscillator indicator for the requested symbol over the specified period.
        """
        ...

    def VAR(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.Variance:
        """
        Creates a new Variance indicator. This will return the population variance of samples over the specified period.
        
        :param symbol: The symbol whose VAR we want
        :param period: The period over which to compute the VAR
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The Variance indicator for the requested symbol over the specified period.
        """
        ...

    @typing.overload
    def VWAP(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.TradeBar] = None) -> QuantConnect.Indicators.VolumeWeightedAveragePriceIndicator:
        """
        Creates an VolumeWeightedAveragePrice (VWAP) indicator for the symbol. The indicator will be automatically
        updated on the given resolution.
        
        :param symbol: The symbol whose VWAP we want
        :param period: The period of the VWAP
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The VolumeWeightedAveragePrice for the given parameters.
        """
        ...

    @typing.overload
    def VWAP(self, symbol: typing.Union[QuantConnect.Symbol, str]) -> QuantConnect.Indicators.IntradayVwap:
        """
        Creates the canonical VWAP indicator that resets each day. The indicator will be automatically
        updated on the security's configured resolution.
        
        :param symbol: The symbol whose VWAP we want
        :returns: The IntradayVWAP for the specified symbol.
        """
        ...

    @typing.overload
    def WarmUpIndicator(self, symbol: typing.Union[QuantConnect.Symbol, str], indicator: QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """
        Warms up a given indicator with historical data
        
        :param symbol: The symbol whose indicator we want
        :param indicator: The indicator we want to warm up
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The given indicator.
        """
        ...

    @typing.overload
    def WarmUpIndicator(self, symbol: typing.Union[QuantConnect.Symbol, str], indicator: QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint], period: datetime.timedelta, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """
        Warms up a given indicator with historical data
        
        :param symbol: The symbol whose indicator we want
        :param indicator: The indicator we want to warm up
        :param period: The necessary period to warm up the indicator
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The given indicator.
        """
        ...

    @typing.overload
    def WarmUpIndicator(self, symbol: typing.Union[QuantConnect.Symbol, str], indicator: QuantConnect.Indicators.IndicatorBase[QuantConnect_Algorithm_QCAlgorithm_WarmUpIndicator_T], resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect_Algorithm_QCAlgorithm_WarmUpIndicator_T] = None) -> QuantConnect.Indicators.IndicatorBase[QuantConnect_Algorithm_QCAlgorithm_WarmUpIndicator_T]:
        """
        Warms up a given indicator with historical data
        
        :param symbol: The symbol whose indicator we want
        :param indicator: The indicator we want to warm up
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The given indicator.
        """
        ...

    @typing.overload
    def WarmUpIndicator(self, symbol: typing.Union[QuantConnect.Symbol, str], indicator: QuantConnect.Indicators.IndicatorBase[QuantConnect_Algorithm_QCAlgorithm_WarmUpIndicator_T], period: datetime.timedelta, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect_Algorithm_QCAlgorithm_WarmUpIndicator_T] = None) -> QuantConnect.Indicators.IndicatorBase[QuantConnect_Algorithm_QCAlgorithm_WarmUpIndicator_T]:
        """
        Warms up a given indicator with historical data
        
        :param symbol: The symbol whose indicator we want
        :param indicator: The indicator we want to warm up
        :param period: The necessary period to warm up the indicator
        :param selector: Selects a value from the BaseData send into the indicator, if null defaults to a cast (x => (T)x)
        :returns: The given indicator.
        """
        ...

    def WILR(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], QuantConnect.Data.Market.IBaseDataBar] = None) -> QuantConnect.Indicators.WilliamsPercentR:
        """
        Creates a new Williams %R indicator. This will compute the percentage change of
        the current closing price in relation to the high and low of the past N periods.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose Williams %R we want
        :param period: The period over which to compute the Williams %R
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The Williams %R indicator for the requested symbol over the specified period.
        """
        ...

    def WWMA(self, symbol: typing.Union[QuantConnect.Symbol, str], period: int, resolution: typing.Optional[QuantConnect.Resolution] = None, selector: typing.Callable[[QuantConnect.Data.IBaseData], float] = None) -> QuantConnect.Indicators.WilderMovingAverage:
        """
        Creates a WilderMovingAverage indicator for the symbol.
        The indicator will be automatically updated on the given resolution.
        
        :param symbol: The symbol whose WMA we want
        :param period: The period of the WMA
        :param resolution: The resolution
        :param selector: Selects a value from the BaseData to send into the indicator, if null defaults to the Value property of BaseData (x => x.Value)
        :returns: The WilderMovingAverage for the given parameters.
        """
        ...


class DollarVolumeUniverseDefinitions(System.Object):
    """Provides helpers for defining universes based on the daily dollar volume"""

    def __init__(self, algorithm: QuantConnect.Algorithm.QCAlgorithm) -> None:
        """
        Initializes a new instance of the DollarVolumeUniverseDefinitions class
        
        :param algorithm: The algorithm instance, used for obtaining the default UniverseSettings
        """
        ...

    def Bottom(self, count: int, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new coarse universe that contains the bottom count of stocks
        by daily dollar volume
        
        :param count: The number of stock to select
        :param universeSettings: The settings for stocks added by this universe. Defaults to QCAlgorithm.UniverseSettings
        :returns: A new coarse universe for the bottom count of stocks by dollar volume.
        """
        ...

    @typing.overload
    def Percentile(self, percentile: float, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new coarse universe that contains stocks in the specified
        dollar volume percentile
        
        :param percentile: The desired dollar volume percentile (0 to 100 inclusive)
        :param universeSettings: The settings for stocks added by this universe. Defaults to QCAlgorithm.UniverseSettings
        :returns: A new coarse universe for the bottom count of stocks by dollar volume.
        """
        ...

    @typing.overload
    def Percentile(self, lowerPercentile: float, upperPercentile: float, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new coarse universe that contains stocks in the specified dollar volume percentile range,
        that is, this universe will produce stocks with dollar volumes between the lower percentile bound
        and the upper percentile bound
        
        :param lowerPercentile: The desired lower dollar volume  percentile bound (0 to 100 inclusive)
        :param upperPercentile: The desired upper dollar volume  percentile bound (0 to 100 inclusive)
        :param universeSettings: The settings for stocks added by this universe. Defaults to QCAlgorithm.UniverseSettings
        :returns: A new coarse universe for the bottom count of stocks by dollar volume.
        """
        ...

    def Top(self, count: int, universeSettings: QuantConnect.Data.UniverseSelection.UniverseSettings = None) -> QuantConnect.Data.UniverseSelection.Universe:
        """
        Creates a new coarse universe that contains the top count of stocks
        by daily dollar volume
        
        :param count: The number of stock to select
        :param universeSettings: The settings for stocks added by this universe. Defaults to QCAlgorithm.UniverseSettings
        :returns: A new coarse universe for the top count of stocks by dollar volume.
        """
        ...


class _EventContainer(typing.Generic[QuantConnect_Algorithm__EventContainer_Callable, QuantConnect_Algorithm__EventContainer_ReturnType]):
    """This class is used to provide accurate autocomplete on events and cannot be imported."""

    def __call__(self, *args: typing.Any, **kwargs: typing.Any) -> QuantConnect_Algorithm__EventContainer_ReturnType:
        """Fires the event."""
        ...

    def __iadd__(self, item: QuantConnect_Algorithm__EventContainer_Callable) -> None:
        """Registers an event handler."""
        ...

    def __isub__(self, item: QuantConnect_Algorithm__EventContainer_Callable) -> None:
        """Unregisters an event handler."""
        ...


