import abc
import typing
import warnings

import System
import System.Collections
import System.Collections.Generic
import System.Collections.ObjectModel
import System.ComponentModel
import System.ComponentModel.Design
import System.Diagnostics.CodeAnalysis
import System.Globalization
import System.Reflection
import System.Resources
import System.Runtime.Serialization

IServiceProvider = typing.Any

System_ComponentModel_BindingList_T = typing.TypeVar("System_ComponentModel_BindingList_T")
System_ComponentModel__EventContainer_Callable = typing.TypeVar("System_ComponentModel__EventContainer_Callable")
System_ComponentModel__EventContainer_ReturnType = typing.TypeVar("System_ComponentModel__EventContainer_ReturnType")


class DefaultValueAttribute(System.Attribute):
    """Specifies the default value for a property."""

    @property
    def Value(self) -> System.Object:
        """Gets the default value of the property this attribute is bound to."""
        ...

    @typing.overload
    def __init__(self, type: typing.Type, value: str) -> None:
        """
        Initializes a new instance of the System.ComponentModel.DefaultValueAttribute
        class, converting the specified value to the specified type, and using the U.S. English
        culture as the translation context.
        """
        ...

    @typing.overload
    def __init__(self, value: str) -> None:
        """
        Initializes a new instance of the System.ComponentModel.DefaultValueAttribute
        class using a Unicode character.
        """
        ...

    @typing.overload
    def __init__(self, value: int) -> None:
        """
        Initializes a new instance of the System.ComponentModel.DefaultValueAttribute
        class using an 8-bit unsigned integer.
        """
        ...

    @typing.overload
    def __init__(self, value: int) -> None:
        """
        Initializes a new instance of the System.ComponentModel.DefaultValueAttribute
        class using a 16-bit signed integer.
        """
        ...

    @typing.overload
    def __init__(self, value: int) -> None:
        """
        Initializes a new instance of the System.ComponentModel.DefaultValueAttribute
        class using a 32-bit signed integer.
        """
        ...

    @typing.overload
    def __init__(self, value: int) -> None:
        """
        Initializes a new instance of the System.ComponentModel.DefaultValueAttribute
        class using a 64-bit signed integer.
        """
        ...

    @typing.overload
    def __init__(self, value: float) -> None:
        """
        Initializes a new instance of the System.ComponentModel.DefaultValueAttribute
        class using a single-precision floating point number.
        """
        ...

    @typing.overload
    def __init__(self, value: float) -> None:
        """
        Initializes a new instance of the System.ComponentModel.DefaultValueAttribute
        class using a double-precision floating point number.
        """
        ...

    @typing.overload
    def __init__(self, value: bool) -> None:
        """
        Initializes a new instance of the System.ComponentModel.DefaultValueAttribute
        class using a bool value.
        """
        ...

    @typing.overload
    def __init__(self, value: str) -> None:
        """
        Initializes a new instance of the System.ComponentModel.DefaultValueAttribute
        class using a string.
        """
        ...

    @typing.overload
    def __init__(self, value: typing.Any) -> None:
        """
        Initializes a new instance of the System.ComponentModel.DefaultValueAttribute
        class.
        """
        ...

    @typing.overload
    def __init__(self, value: int) -> None:
        """
        Initializes a new instance of the System.ComponentModel.DefaultValueAttribute
        class using a sbyte value.
        """
        ...

    @typing.overload
    def __init__(self, value: int) -> None:
        """
        Initializes a new instance of the System.ComponentModel.DefaultValueAttribute
        class using a ushort value.
        """
        ...

    @typing.overload
    def __init__(self, value: int) -> None:
        """
        Initializes a new instance of the System.ComponentModel.DefaultValueAttribute
        class using a uint value.
        """
        ...

    @typing.overload
    def __init__(self, value: int) -> None:
        """
        Initializes a new instance of the System.ComponentModel.DefaultValueAttribute
        class using a ulong value.
        """
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        ...

    def SetValue(self, value: typing.Any) -> None:
        """This method is protected."""
        ...


class EditorBrowsableState(System.Enum):
    """This class has no documentation."""

    Always = 0

    Never = 1

    Advanced = 2


class EditorBrowsableAttribute(System.Attribute):
    """This class has no documentation."""

    @property
    def State(self) -> int:
        """This property contains the int value of a member of the System.ComponentModel.EditorBrowsableState enum."""
        ...

    @typing.overload
    def __init__(self, state: System.ComponentModel.EditorBrowsableState) -> None:
        ...

    @typing.overload
    def __init__(self) -> None:
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        ...


class PropertyChangingEventArgs(System.EventArgs):
    """Provides data for the PropertyChanging event."""

    @property
    def PropertyName(self) -> str:
        """Indicates the name of the property that is changing."""
        ...

    def __init__(self, propertyName: str) -> None:
        """
        Initializes a new instance of the System.ComponentModel.PropertyChangingEventArgs
        class.
        """
        ...


class INotifyPropertyChanging(metaclass=abc.ABCMeta):
    """This class has no documentation."""

    @property
    @abc.abstractmethod
    def PropertyChanging(self) -> _EventContainer[typing.Callable[[System.Object, System.ComponentModel.PropertyChangingEventArgs], None], None]:
        ...

    @PropertyChanging.setter
    @abc.abstractmethod
    def PropertyChanging(self, value: _EventContainer[typing.Callable[[System.Object, System.ComponentModel.PropertyChangingEventArgs], None], None]):
        ...


class DataErrorsChangedEventArgs(System.EventArgs):
    """Provides data for the ErrorsChanged event."""

    @property
    def PropertyName(self) -> str:
        """Indicates the name of the property whose errors changed."""
        ...

    def __init__(self, propertyName: str) -> None:
        """
        Initializes a new instance of the System.ComponentModel.DataErrorsChangedEventArgs
        class.
        """
        ...


class INotifyDataErrorInfo(metaclass=abc.ABCMeta):
    """This class has no documentation."""

    @property
    @abc.abstractmethod
    def HasErrors(self) -> bool:
        ...

    @property
    @abc.abstractmethod
    def ErrorsChanged(self) -> _EventContainer[typing.Callable[[System.Object, System.ComponentModel.DataErrorsChangedEventArgs], None], None]:
        ...

    @ErrorsChanged.setter
    @abc.abstractmethod
    def ErrorsChanged(self, value: _EventContainer[typing.Callable[[System.Object, System.ComponentModel.DataErrorsChangedEventArgs], None], None]):
        ...

    def GetErrors(self, propertyName: str) -> System.Collections.IEnumerable:
        ...


class PropertyChangedEventArgs(System.EventArgs):
    """Provides data for the PropertyChanged event."""

    @property
    def PropertyName(self) -> str:
        """Indicates the name of the property that changed."""
        ...

    def __init__(self, propertyName: str) -> None:
        """
        Initializes a new instance of the System.ComponentModel.PropertyChangedEventArgs
        class.
        """
        ...


class INotifyPropertyChanged(metaclass=abc.ABCMeta):
    """This class has no documentation."""

    @property
    @abc.abstractmethod
    def PropertyChanged(self) -> _EventContainer[typing.Callable[[System.Object, System.ComponentModel.PropertyChangedEventArgs], None], None]:
        ...

    @PropertyChanged.setter
    @abc.abstractmethod
    def PropertyChanged(self, value: _EventContainer[typing.Callable[[System.Object, System.ComponentModel.PropertyChangedEventArgs], None], None]):
        ...


class TypeDescriptionProviderAttribute(System.Attribute):
    """This class has no documentation."""

    @property
    def TypeName(self) -> str:
        """
        The TypeName property returns the assembly qualified type name
        for the type description provider.
        """
        ...

    @typing.overload
    def __init__(self, typeName: str) -> None:
        """Creates a new TypeDescriptionProviderAttribute object."""
        ...

    @typing.overload
    def __init__(self, type: typing.Type) -> None:
        """Creates a new TypeDescriptionProviderAttribute object."""
        ...


class TypeConverterAttribute(System.Attribute):
    """
    Specifies what type to use as a converter for the object this attribute is
    bound to. This class cannot be inherited.
    """

    Default: System.ComponentModel.TypeConverterAttribute = ...
    """
    Specifies the type to use as a converter for the object this attribute is
    bound to. This static field is read-only.
    """

    @property
    def ConverterTypeName(self) -> str:
        """
        Gets the fully qualified type name of the System.Type to use as a
        converter for the object this attribute is bound to.
        """
        ...

    @typing.overload
    def __init__(self) -> None:
        """
        Initializes a new instance of the System.ComponentModel.TypeConverterAttribute
        class with the default type converter, which is an empty string ("").
        """
        ...

    @typing.overload
    def __init__(self, type: typing.Type) -> None:
        """
        Initializes a new instance of the System.ComponentModel.TypeConverterAttribute
        class, using the specified type as the data converter for the object this attribute
        is bound to.
        """
        ...

    @typing.overload
    def __init__(self, typeName: str) -> None:
        """
        Initializes a new instance of the System.ComponentModel.TypeConverterAttribute
        class, using the specified type name as the data converter for the object this attribute
        is bound to.
        """
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        ...


class AttributeCollection(System.Object, System.Collections.ICollection):
    """Represents a collection of attributes."""

    FilterRequiresUnreferencedCodeMessage: str = "The public parameterless constructor or the 'Default' static field may be trimmed from the Attribute's Type."

    Empty: System.ComponentModel.AttributeCollection = ...
    """An empty AttributeCollection that can used instead of creating a new one."""

    @property
    def Attributes(self) -> typing.List[System.Attribute]:
        """
        Gets the attributes collection.
        
        This property is protected.
        """
        ...

    @property
    def Count(self) -> int:
        """Gets the number of attributes."""
        ...

    @property
    def IsSynchronized(self) -> bool:
        ...

    @property
    def SyncRoot(self) -> System.Object:
        ...

    @typing.overload
    def __getitem__(self, index: int) -> System.Attribute:
        """Gets the attribute with the specified index number."""
        ...

    @typing.overload
    def __getitem__(self, attributeType: typing.Type) -> System.Attribute:
        """Gets the attribute with the specified type."""
        ...

    @typing.overload
    def __init__(self, *attributes: System.Attribute) -> None:
        """Creates a new AttributeCollection."""
        ...

    @typing.overload
    def __init__(self) -> None:
        """This method is protected."""
        ...

    @typing.overload
    def Contains(self, attribute: System.Attribute) -> bool:
        """Determines if this collection of attributes has the specified attribute."""
        ...

    @typing.overload
    def Contains(self, attributes: typing.List[System.Attribute]) -> bool:
        """
        Determines if this attribute collection contains the all
        the specified attributes in the attribute array.
        """
        ...

    def CopyTo(self, array: System.Array, index: int) -> None:
        """Copies this collection to an array."""
        ...

    @staticmethod
    def FromExisting(existing: System.ComponentModel.AttributeCollection, *newAttributes: System.Attribute) -> System.ComponentModel.AttributeCollection:
        """Creates a new AttributeCollection from an existing AttributeCollection"""
        ...

    def GetDefaultAttribute(self, attributeType: typing.Type) -> System.Attribute:
        """
        Returns the default value for an attribute. This uses the following heuristic:
        1. It looks for a public static field named "Default".
        
        This method is protected.
        """
        ...

    @typing.overload
    def GetEnumerator(self) -> System.Collections.IEnumerator:
        """Gets an enumerator for this collection."""
        ...

    @typing.overload
    def GetEnumerator(self) -> System.Collections.IEnumerator:
        ...

    @typing.overload
    def Matches(self, attribute: System.Attribute) -> bool:
        """
        Determines if a specified attribute is the same as an attribute
        in the collection.
        """
        ...

    @typing.overload
    def Matches(self, attributes: typing.List[System.Attribute]) -> bool:
        """
        Determines if the attributes in the specified array are
        the same as the attributes in the collection.
        """
        ...


class MemberDescriptor(System.Object, metaclass=abc.ABCMeta):
    """
    Declares an array of attributes for a member and defines
    the properties and methods that give you access to the attributes in the array.
    All attributes must derive from System.Attribute.
    """

    @property
    def AttributeArray(self) -> typing.List[System.Attribute]:
        """
        Gets or sets an array of attributes.
        
        This property is protected.
        """
        ...

    @AttributeArray.setter
    def AttributeArray(self, value: typing.List[System.Attribute]):
        """
        Gets or sets an array of attributes.
        
        This property is protected.
        """
        ...

    @property
    def Attributes(self) -> System.ComponentModel.AttributeCollection:
        """Gets the collection of attributes for this member."""
        ...

    @property
    def Category(self) -> str:
        """
        Gets the name of the category that the member belongs to, as specified
        in the System.ComponentModel.CategoryAttribute.
        """
        ...

    @property
    def Description(self) -> str:
        """Gets the description of the member as specified in the System.ComponentModel.DescriptionAttribute."""
        ...

    @property
    def IsBrowsable(self) -> bool:
        """
        Gets a value indicating whether the member is browsable as specified in the
        System.ComponentModel.BrowsableAttribute.
        """
        ...

    @property
    def Name(self) -> str:
        """Gets the name of the member."""
        ...

    @property
    def NameHashCode(self) -> int:
        """
        Gets the hash code for the name of the member as specified in string.GetHashCode().
        
        This property is protected.
        """
        ...

    @property
    def DesignTimeOnly(self) -> bool:
        """
        Determines whether this member should be set only at
        design time as specified in the System.ComponentModel.DesignOnlyAttribute.
        """
        ...

    @property
    def DisplayName(self) -> str:
        """Gets the name that can be displayed in a window like a properties window."""
        ...

    @typing.overload
    def __init__(self, name: str) -> None:
        """
        Initializes a new instance of the System.ComponentModel.MemberDescriptor class with the specified  and no attributes.
        
        This method is protected.
        """
        ...

    @typing.overload
    def __init__(self, name: str, attributes: typing.List[System.Attribute]) -> None:
        """
        Initializes a new instance of the System.ComponentModel.MemberDescriptor class with the specified  and  array.
        
        This method is protected.
        """
        ...

    @typing.overload
    def __init__(self, descr: System.ComponentModel.MemberDescriptor) -> None:
        """
        Initializes a new instance of the System.ComponentModel.MemberDescriptor class with the specified System.ComponentModel.MemberDescriptor.
        
        This method is protected.
        """
        ...

    @typing.overload
    def __init__(self, oldMemberDescriptor: System.ComponentModel.MemberDescriptor, newAttributes: typing.List[System.Attribute]) -> None:
        """
        Initializes a new instance of the System.ComponentModel.MemberDescriptor class with the name in the specified
        System.ComponentModel.MemberDescriptor and the attributes
        in both the old System.ComponentModel.MemberDescriptor and the System.Attribute array.
        
        This method is protected.
        """
        ...

    def CreateAttributeCollection(self) -> System.ComponentModel.AttributeCollection:
        """
        Creates a collection of attributes using the
        array of attributes that you passed to the constructor.
        
        This method is protected.
        """
        ...

    def Equals(self, obj: typing.Any) -> bool:
        """
        Compares this instance to the specified System.ComponentModel.MemberDescriptor to see if they are equivalent.
        NOTE: If you make a change here, you likely need to change GetHashCode() as well.
        """
        ...

    def FillAttributes(self, attributeList: System.Collections.IList) -> None:
        """
        In an inheriting class, adds the attributes of the inheriting class to the
        specified list of attributes in the parent class. For duplicate attributes,
        the last one added to the list will be kept.
        
        This method is protected.
        """
        ...

    @staticmethod
    @typing.overload
    def FindMethod(componentClass: typing.Type, name: str, args: typing.List[typing.Type], returnType: typing.Type) -> System.Reflection.MethodInfo:
        """
        Finds the given method through reflection. This method only looks for public methods.
        
        This method is protected.
        """
        ...

    @staticmethod
    @typing.overload
    def FindMethod(componentClass: typing.Type, name: str, args: typing.List[typing.Type], returnType: typing.Type, publicOnly: bool) -> System.Reflection.MethodInfo:
        """
        Finds the given method through reflection.
        
        This method is protected.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Try to keep this reasonable in [....] with Equals(). Specifically,
        if A.Equals(B) returns true, A & B should have the same hash code.
        """
        ...

    def GetInvocationTarget(self, type: typing.Type, instance: typing.Any) -> System.Object:
        """
        This method returns the object that should be used during invocation of members.
        Normally the return value will be the same as the instance passed in. If
        someone associated another object with this instance, or if the instance is a
        custom type descriptor, GetInvocationTarget may return a different value.
        
        This method is protected.
        """
        ...

    @staticmethod
    def GetInvokee(componentClass: typing.Type, component: typing.Any) -> System.Object:
        """
        This method is protected.
        
        This method has been deprecated. Use GetInvocationTarget instead. https://go.microsoft.com/fwlink/?linkid=14202
        """
        warnings.warn("This method has been deprecated. Use GetInvocationTarget instead. https://go.microsoft.com/fwlink/?linkid=14202", DeprecationWarning)

    @staticmethod
    def GetSite(component: typing.Any) -> System.ComponentModel.ISite:
        """
        Gets a component site for the given component.
        
        This method is protected.
        """
        ...


class PropertyDescriptorCollection(System.Object, System.Collections.IList, System.Collections.IDictionary):
    """Represents a collection of properties."""

    Empty: System.ComponentModel.PropertyDescriptorCollection = ...
    """An empty PropertyDescriptorCollection that can used instead of creating a new one with no items."""

    @property
    def Count(self) -> int:
        """Gets the number of property descriptors in the  collection."""
        ...

    @Count.setter
    def Count(self, value: int):
        """Gets the number of property descriptors in the  collection."""
        ...

    @property
    def IsSynchronized(self) -> bool:
        ...

    @property
    def SyncRoot(self) -> System.Object:
        ...

    @property
    def IsFixedSize(self) -> bool:
        ...

    @property
    def IsReadOnly(self) -> bool:
        ...

    @property
    def Keys(self) -> System.Collections.ICollection:
        ...

    @property
    def Values(self) -> System.Collections.ICollection:
        ...

    @typing.overload
    def __getitem__(self, index: int) -> System.ComponentModel.PropertyDescriptor:
        """Gets the property with the specified index number."""
        ...

    @typing.overload
    def __getitem__(self, name: str) -> System.ComponentModel.PropertyDescriptor:
        """Gets the property with the specified name."""
        ...

    @typing.overload
    def __getitem__(self, key: typing.Any) -> typing.Any:
        ...

    @typing.overload
    def __getitem__(self, index: int) -> typing.Any:
        ...

    @typing.overload
    def __init__(self, properties: typing.List[System.ComponentModel.PropertyDescriptor]) -> None:
        """
        Initializes a new instance of the System.ComponentModel.PropertyDescriptorCollection
        class.
        """
        ...

    @typing.overload
    def __init__(self, properties: typing.List[System.ComponentModel.PropertyDescriptor], readOnly: bool) -> None:
        """
        Initializes a new instance of a property descriptor collection, and allows you to mark the
        collection as read-only so it cannot be modified.
        """
        ...

    @typing.overload
    def __setitem__(self, key: typing.Any, value: typing.Any) -> None:
        ...

    @typing.overload
    def __setitem__(self, index: int, value: typing.Any) -> None:
        ...

    @typing.overload
    def Add(self, value: System.ComponentModel.PropertyDescriptor) -> int:
        ...

    @typing.overload
    def Add(self, key: typing.Any, value: typing.Any) -> None:
        ...

    @typing.overload
    def Add(self, value: typing.Any) -> int:
        ...

    @typing.overload
    def Clear(self) -> None:
        ...

    @typing.overload
    def Clear(self) -> None:
        ...

    @typing.overload
    def Clear(self) -> None:
        ...

    @typing.overload
    def Contains(self, value: System.ComponentModel.PropertyDescriptor) -> bool:
        ...

    @typing.overload
    def Contains(self, key: typing.Any) -> bool:
        ...

    @typing.overload
    def Contains(self, value: typing.Any) -> bool:
        ...

    def CopyTo(self, array: System.Array, index: int) -> None:
        ...

    def Find(self, name: str, ignoreCase: bool) -> System.ComponentModel.PropertyDescriptor:
        """Gets the description of the property with the specified name."""
        ...

    @typing.overload
    def GetEnumerator(self) -> System.Collections.IEnumerator:
        """Gets an enumerator for this System.ComponentModel.PropertyDescriptorCollection."""
        ...

    @typing.overload
    def GetEnumerator(self) -> System.Collections.IEnumerator:
        ...

    @typing.overload
    def GetEnumerator(self) -> System.Collections.IDictionaryEnumerator:
        ...

    @typing.overload
    def IndexOf(self, value: System.ComponentModel.PropertyDescriptor) -> int:
        ...

    @typing.overload
    def IndexOf(self, value: typing.Any) -> int:
        ...

    @typing.overload
    def Insert(self, index: int, value: System.ComponentModel.PropertyDescriptor) -> None:
        ...

    @typing.overload
    def Insert(self, index: int, value: typing.Any) -> None:
        ...

    @typing.overload
    def InternalSort(self, names: typing.List[str]) -> None:
        """
        Sorts the members of this PropertyDescriptorCollection. Any specified NamedSort arguments will
        be applied first, followed by sort using the specified IComparer.
        
        This method is protected.
        """
        ...

    @typing.overload
    def InternalSort(self, sorter: System.Collections.IComparer) -> None:
        """
        Sorts the members of this PropertyDescriptorCollection using the specified IComparer.
        
        This method is protected.
        """
        ...

    @typing.overload
    def Remove(self, value: System.ComponentModel.PropertyDescriptor) -> None:
        ...

    @typing.overload
    def Remove(self, key: typing.Any) -> None:
        ...

    @typing.overload
    def Remove(self, value: typing.Any) -> None:
        ...

    @typing.overload
    def RemoveAt(self, index: int) -> None:
        ...

    @typing.overload
    def RemoveAt(self, index: int) -> None:
        ...

    @typing.overload
    def Sort(self) -> System.ComponentModel.PropertyDescriptorCollection:
        """
        Sorts the members of this PropertyDescriptorCollection, using the default sort for this collection,
        which is usually alphabetical.
        """
        ...

    @typing.overload
    def Sort(self, names: typing.List[str]) -> System.ComponentModel.PropertyDescriptorCollection:
        """
        Sorts the members of this PropertyDescriptorCollection. Any specified NamedSort arguments will
        be applied first, followed by sort using the specified IComparer.
        """
        ...

    @typing.overload
    def Sort(self, names: typing.List[str], comparer: System.Collections.IComparer) -> System.ComponentModel.PropertyDescriptorCollection:
        """
        Sorts the members of this PropertyDescriptorCollection. Any specified NamedSort arguments will
        be applied first, followed by sort using the specified IComparer.
        """
        ...

    @typing.overload
    def Sort(self, comparer: System.Collections.IComparer) -> System.ComponentModel.PropertyDescriptorCollection:
        """
        Sorts the members of this PropertyDescriptorCollection, using the specified IComparer to compare,
        the PropertyDescriptors contained in the collection.
        """
        ...


class TypeConverter(System.Object):
    """Converts the value of an object into a different data type."""

    class SimplePropertyDescriptor(System.ComponentModel.PropertyDescriptor, metaclass=abc.ABCMeta):
        """
        An abstract  class that provides properties for objects that do not have properties.
        
        This class is protected.
        """

        @property
        def ComponentType(self) -> typing.Type:
            """Gets the type of the component this property description is bound to."""
            ...

        @property
        def IsReadOnly(self) -> bool:
            """Gets a value indicating whether this property is read-only."""
            ...

        @property
        def PropertyType(self) -> typing.Type:
            """Gets the type of the property."""
            ...

        @typing.overload
        def __init__(self, componentType: typing.Type, name: str, propertyType: typing.Type) -> None:
            """
            Initializes a new instance of the System.ComponentModel.TypeConverter.SimplePropertyDescriptor class.
            
            This method is protected.
            """
            ...

        @typing.overload
        def __init__(self, componentType: typing.Type, name: str, propertyType: typing.Type, attributes: typing.List[System.Attribute]) -> None:
            """
            Initializes a new instance of the System.ComponentModel.TypeConverter.SimplePropertyDescriptor class.
            
            This method is protected.
            """
            ...

        def CanResetValue(self, component: typing.Any) -> bool:
            """Gets a value indicating whether resetting the component will change the value of the component."""
            ...

        def ResetValue(self, component: typing.Any) -> None:
            """Resets the value for this property of the component."""
            ...

        def ShouldSerializeValue(self, component: typing.Any) -> bool:
            """Gets a value indicating whether the value of this property needs to be persisted."""
            ...

    class StandardValuesCollection(System.Object, System.Collections.ICollection):
        """Represents a collection of values."""

        @property
        def Count(self) -> int:
            """Gets the number of objects in the collection."""
            ...

        @property
        def IsSynchronized(self) -> bool:
            """
            Determines if this collection is synchronized. The ValidatorCollection is not synchronized for
            speed. Also, since it is read-only, there is no need to synchronize it.
            """
            ...

        @property
        def SyncRoot(self) -> System.Object:
            """
            Retrieves the synchronization root for this collection. Because we are not synchronized,
            this returns null.
            """
            ...

        def __getitem__(self, index: int) -> typing.Any:
            """Gets the object at the specified index number."""
            ...

        def __init__(self, values: System.Collections.ICollection) -> None:
            """Initializes a new instance of the System.ComponentModel.TypeConverter.StandardValuesCollection class."""
            ...

        def CopyTo(self, array: System.Array, index: int) -> None:
            """Copies the contents of this collection to an array."""
            ...

        def GetEnumerator(self) -> System.Collections.IEnumerator:
            """Gets an enumerator for this collection."""
            ...

    RequiresUnreferencedCodeMessage: str = "Generic TypeConverters may require the generic types to be annotated. For example, NullableConverter requires the underlying type to be DynamicallyAccessedMembers All."

    @typing.overload
    def CanConvertFrom(self, sourceType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an object in the
        given source type to the native type of the converter.
        """
        ...

    @typing.overload
    def CanConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, sourceType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an object in the given
        source type to the native type of the converter using the context.
        """
        ...

    @typing.overload
    def CanConvertTo(self, destinationType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an object to the given
        destination type using the context.
        """
        ...

    @typing.overload
    def CanConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, destinationType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an object to the given
        destination type using the context.
        """
        ...

    @typing.overload
    def ConvertFrom(self, value: typing.Any) -> System.Object:
        """Converts the given value to the converter's native type."""
        ...

    @typing.overload
    def ConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any) -> System.Object:
        """Converts the given object to the converter's native type."""
        ...

    @typing.overload
    def ConvertFromInvariantString(self, text: str) -> System.Object:
        """Converts the given string to the converter's native type using the invariant culture."""
        ...

    @typing.overload
    def ConvertFromInvariantString(self, context: System.ComponentModel.ITypeDescriptorContext, text: str) -> System.Object:
        """Converts the given string to the converter's native type using the invariant culture."""
        ...

    @typing.overload
    def ConvertFromString(self, text: str) -> System.Object:
        """Converts the specified text into an object."""
        ...

    @typing.overload
    def ConvertFromString(self, context: System.ComponentModel.ITypeDescriptorContext, text: str) -> System.Object:
        """Converts the specified text into an object."""
        ...

    @typing.overload
    def ConvertFromString(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, text: str) -> System.Object:
        """Converts the specified text into an object."""
        ...

    @typing.overload
    def ConvertTo(self, value: typing.Any, destinationType: typing.Type) -> System.Object:
        """
        Converts the given
        value object to the specified destination type using the arguments.
        """
        ...

    @typing.overload
    def ConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any, destinationType: typing.Type) -> System.Object:
        """
        Converts the given value object to
        the specified destination type using the specified context and arguments.
        """
        ...

    @typing.overload
    def ConvertToInvariantString(self, value: typing.Any) -> str:
        """Converts the specified value to a culture-invariant string representation."""
        ...

    @typing.overload
    def ConvertToInvariantString(self, context: System.ComponentModel.ITypeDescriptorContext, value: typing.Any) -> str:
        """Converts the specified value to a culture-invariant string representation."""
        ...

    @typing.overload
    def ConvertToString(self, value: typing.Any) -> str:
        """Converts the specified value to a string representation."""
        ...

    @typing.overload
    def ConvertToString(self, context: System.ComponentModel.ITypeDescriptorContext, value: typing.Any) -> str:
        """Converts the specified value to a string representation."""
        ...

    @typing.overload
    def ConvertToString(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any) -> str:
        """Converts the specified value to a string representation."""
        ...

    @typing.overload
    def CreateInstance(self, propertyValues: System.Collections.IDictionary) -> System.Object:
        """Re-creates an object given a set of property values for the object."""
        ...

    @typing.overload
    def CreateInstance(self, context: System.ComponentModel.ITypeDescriptorContext, propertyValues: System.Collections.IDictionary) -> System.Object:
        """Re-creates an object given a set of property values for the object."""
        ...

    def GetConvertFromException(self, value: typing.Any) -> System.Exception:
        """
        Gets a suitable exception to throw when a conversion cannot be performed.
        
        This method is protected.
        """
        ...

    def GetConvertToException(self, value: typing.Any, destinationType: typing.Type) -> System.Exception:
        """
        Retrieves a suitable exception to throw when a conversion cannot
        be performed.
        
        This method is protected.
        """
        ...

    @typing.overload
    def GetCreateInstanceSupported(self) -> bool:
        """
        Gets a value indicating whether changing a value on this object requires a call to
        System.ComponentModel.TypeConverter.CreateInstance(IDictionary) to create a new value.
        """
        ...

    @typing.overload
    def GetCreateInstanceSupported(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """
        Gets a value indicating whether changing a value on this object requires a call to
        System.ComponentModel.TypeConverter.CreateInstance(IDictionary) to create a new value,
        using the specified context.
        """
        ...

    @typing.overload
    def GetProperties(self, value: typing.Any) -> System.ComponentModel.PropertyDescriptorCollection:
        """Gets a collection of properties for the type of array specified by the value parameter."""
        ...

    @typing.overload
    def GetProperties(self, context: System.ComponentModel.ITypeDescriptorContext, value: typing.Any) -> System.ComponentModel.PropertyDescriptorCollection:
        """
        Gets a collection of properties for the type of array specified by the value parameter using
        the specified context.
        """
        ...

    @typing.overload
    def GetProperties(self, context: System.ComponentModel.ITypeDescriptorContext, value: typing.Any, attributes: typing.List[System.Attribute]) -> System.ComponentModel.PropertyDescriptorCollection:
        """
        Gets a collection of properties for the type of array specified by the value parameter using
        the specified context and attributes.
        """
        ...

    @typing.overload
    def GetPropertiesSupported(self) -> bool:
        """Gets a value indicating whether this object supports properties."""
        ...

    @typing.overload
    def GetPropertiesSupported(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """Gets a value indicating whether this object supports properties using the specified context."""
        ...

    @typing.overload
    def GetStandardValues(self) -> System.Collections.ICollection:
        """Gets a collection of standard values for the data type this type converter is designed for."""
        ...

    @typing.overload
    def GetStandardValues(self, context: System.ComponentModel.ITypeDescriptorContext) -> System.ComponentModel.TypeConverter.StandardValuesCollection:
        """Gets a collection of standard values for the data type this type converter is designed for."""
        ...

    @typing.overload
    def GetStandardValuesExclusive(self) -> bool:
        """
        Gets a value indicating whether the collection of standard values returned from
        System.ComponentModel.TypeConverter.GetStandardValues() is an exclusive list.
        """
        ...

    @typing.overload
    def GetStandardValuesExclusive(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """
        Gets a value indicating whether the collection of standard values returned from
        System.ComponentModel.TypeConverter.GetStandardValues() is an exclusive
        list of possible values, using the specified context.
        """
        ...

    @typing.overload
    def GetStandardValuesSupported(self) -> bool:
        """
        Gets a value indicating whether this object supports a standard set of values
        that can be picked from a list.
        """
        ...

    @typing.overload
    def GetStandardValuesSupported(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """
        Gets a value indicating whether this object supports a standard set of values that can be picked
        from a list using the specified context.
        """
        ...

    @typing.overload
    def IsValid(self, value: typing.Any) -> bool:
        """Gets a value indicating whether the given value object is valid for this type."""
        ...

    @typing.overload
    def IsValid(self, context: System.ComponentModel.ITypeDescriptorContext, value: typing.Any) -> bool:
        """Gets a value indicating whether the given value object is valid for this type."""
        ...

    def SortProperties(self, props: System.ComponentModel.PropertyDescriptorCollection, names: typing.List[str]) -> System.ComponentModel.PropertyDescriptorCollection:
        """
        Sorts a collection of properties.
        
        This method is protected.
        """
        ...


class PropertyDescriptor(System.ComponentModel.MemberDescriptor, metaclass=abc.ABCMeta):
    """Provides a description of a property."""

    PropertyDescriptorPropertyTypeMessage: str = "PropertyDescriptor's PropertyType cannot be statically discovered."

    @property
    @abc.abstractmethod
    def ComponentType(self) -> typing.Type:
        """
        When overridden in a derived class, gets the type of the
        component this property is bound to.
        """
        ...

    @property
    def Converter(self) -> System.ComponentModel.TypeConverter:
        """Gets the type converter for this property."""
        ...

    @property
    def IsLocalizable(self) -> bool:
        """
        Gets a value
        indicating whether this property should be localized, as
        specified in the System.ComponentModel.LocalizableAttribute.
        """
        ...

    @property
    @abc.abstractmethod
    def IsReadOnly(self) -> bool:
        """
        When overridden in a derived class, gets a value indicating whether this
        property is read-only.
        """
        ...

    @property
    def SerializationVisibility(self) -> System.ComponentModel.DesignerSerializationVisibility:
        """
        Gets a value indicating whether this property should be serialized as specified
        in the System.ComponentModel.DesignerSerializationVisibilityAttribute.
        """
        ...

    @property
    @abc.abstractmethod
    def PropertyType(self) -> typing.Type:
        """When overridden in a derived class, gets the type of the property."""
        ...

    @property
    def SupportsChangeEvents(self) -> bool:
        """
        Indicates whether value change notifications for this property may originate from outside the property
        descriptor, such as from the component itself (value=true), or whether notifications will only originate
        from direct calls made to PropertyDescriptor.SetValue (value=false). For example, the component may
        implement the INotifyPropertyChanged interface, or may have an explicit '{name}Changed' event for this property.
        """
        ...

    @typing.overload
    def __init__(self, name: str, attrs: typing.List[System.Attribute]) -> None:
        """
        Initializes a new instance of the System.ComponentModel.PropertyDescriptor class with the specified name and
        attributes.
        
        This method is protected.
        """
        ...

    @typing.overload
    def __init__(self, descr: System.ComponentModel.MemberDescriptor) -> None:
        """
        Initializes a new instance of the System.ComponentModel.PropertyDescriptor class with
        the name and attributes in the specified System.ComponentModel.MemberDescriptor.
        
        This method is protected.
        """
        ...

    @typing.overload
    def __init__(self, descr: System.ComponentModel.MemberDescriptor, attrs: typing.List[System.Attribute]) -> None:
        """
        Initializes a new instance of the System.ComponentModel.PropertyDescriptor class with
        the name in the specified System.ComponentModel.MemberDescriptor and the
        attributes in both the System.ComponentModel.MemberDescriptor and the
        System.Attribute array.
        
        This method is protected.
        """
        ...

    def AddValueChanged(self, component: typing.Any, handler: typing.Callable[[System.Object, System.EventArgs], None]) -> None:
        """Allows interested objects to be notified when this property changes."""
        ...

    def CanResetValue(self, component: typing.Any) -> bool:
        """
        When overridden in a derived class, indicates whether
        resetting the will change the value of the
        .
        """
        ...

    def CreateInstance(self, type: typing.Type) -> System.Object:
        """
        Creates an instance of the specified type.
        
        This method is protected.
        """
        ...

    def Equals(self, obj: typing.Any) -> bool:
        """
        Compares this to another System.ComponentModel.PropertyDescriptor
        to see if they are equivalent.
        NOTE: If you make a change here, you likely need to change GetHashCode() as well.
        """
        ...

    def FillAttributes(self, attributeList: System.Collections.IList) -> None:
        """
        In an inheriting class, adds the attributes of the inheriting class to the
        specified list of attributes in the parent class. For duplicate attributes,
        the last one added to the list will be kept.
        
        This method is protected.
        """
        ...

    @typing.overload
    def GetChildProperties(self) -> System.ComponentModel.PropertyDescriptorCollection:
        ...

    @typing.overload
    def GetChildProperties(self, filter: typing.List[System.Attribute]) -> System.ComponentModel.PropertyDescriptorCollection:
        ...

    @typing.overload
    def GetChildProperties(self, instance: typing.Any) -> System.ComponentModel.PropertyDescriptorCollection:
        ...

    @typing.overload
    def GetChildProperties(self, instance: typing.Any, filter: typing.List[System.Attribute]) -> System.ComponentModel.PropertyDescriptorCollection:
        """Retrieves the properties"""
        ...

    def GetEditor(self, editorBaseType: typing.Type) -> System.Object:
        """Gets an editor of the specified type."""
        ...

    def GetHashCode(self) -> int:
        """
        Try to keep this reasonable in [....] with Equals(). Specifically,
        if A.Equals(B) returns true, A & B should have the same hash code.
        """
        ...

    def GetInvocationTarget(self, type: typing.Type, instance: typing.Any) -> System.Object:
        """
        This method returns the object that should be used during invocation of members.
        Normally the return value will be the same as the instance passed in. If
        someone associated another object with this instance, or if the instance is a
        custom type descriptor, GetInvocationTarget may return a different value.
        
        This method is protected.
        """
        ...

    def GetTypeFromName(self, typeName: str) -> typing.Type:
        """
        Gets a type using its name.
        
        This method is protected.
        """
        ...

    def GetValue(self, component: typing.Any) -> System.Object:
        """When overridden in a derived class, gets the current value of the property on a component."""
        ...

    def OnValueChanged(self, component: typing.Any, e: System.EventArgs) -> None:
        """
        This should be called by your property descriptor implementation
        when the property value has changed.
        
        This method is protected.
        """
        ...

    def RemoveValueChanged(self, component: typing.Any, handler: typing.Callable[[System.Object, System.EventArgs], None]) -> None:
        """Allows interested objects to be notified when this property changes."""
        ...

    def ResetValue(self, component: typing.Any) -> None:
        """When overridden in a derived class, resets the value for this property of the component."""
        ...

    def SetValue(self, component: typing.Any, value: typing.Any) -> None:
        """
        When overridden in a derived class, sets the value of
        the component to a different value.
        """
        ...

    def ShouldSerializeValue(self, component: typing.Any) -> bool:
        """
        When overridden in a derived class, indicates whether the
        value of this property needs to be persisted.
        """
        ...


class ITypeDescriptorContext(IServiceProvider, metaclass=abc.ABCMeta):
    """
    Provides information about a context to a type converter or a value editor,
    so that the type converter or editor can perform a conversion.
    """

    @property
    @abc.abstractmethod
    def Container(self) -> System.ComponentModel.IContainer:
        """Gets the container with the set of objects for this formatter."""
        ...

    @property
    @abc.abstractmethod
    def Instance(self) -> System.Object:
        """Gets the instance that is invoking the method on the formatter object."""
        ...

    @property
    @abc.abstractmethod
    def PropertyDescriptor(self) -> System.ComponentModel.PropertyDescriptor:
        """Retrieves the PropertyDescriptor that is surfacing the given context item."""
        ...

    def OnComponentChanged(self) -> None:
        """
        Raises the System.ComponentModel.Design.IComponentChangeService.ComponentChanged
        event.
        """
        ...

    def OnComponentChanging(self) -> bool:
        """Gets a value indicating whether this object can be changed."""
        ...


class InstanceCreationEditor(System.Object, metaclass=abc.ABCMeta):
    """
    An InstanceCreationEditor allows the user to create an instance of a particular type of property from a dropdown
    Within the PropertyGrid. Usually, the text specified by InstanceCreationEditor.Text will be displayed on the
    dropdown from the PropertyGrid as a link or button. When clicked, the InstanceCreationEditor.CreateInstance
    method will be called with the Type of the object to create.
    """

    @property
    def Text(self) -> str:
        ...

    def CreateInstance(self, context: System.ComponentModel.ITypeDescriptorContext, instanceType: typing.Type) -> System.Object:
        """
        This method is invoked when you user chooses the link displayed by the PropertyGrid for the InstanceCreationEditor.
        The object returned from this method must be an instance of the specified type, or null in which case the editor will do nothing.
        """
        ...


class ListChangedType(System.Enum):
    """This class has no documentation."""

    Reset = 0

    ItemAdded = 1

    ItemDeleted = 2

    ItemMoved = 3

    ItemChanged = 4

    PropertyDescriptorAdded = 5

    PropertyDescriptorDeleted = 6

    PropertyDescriptorChanged = 7


class IIntellisenseBuilder(metaclass=abc.ABCMeta):
    """This class has no documentation."""

    @property
    @abc.abstractmethod
    def Name(self) -> str:
        """Return a localized name."""
        ...

    def Show(self, language: str, value: str, newValue: str) -> bool:
        """
        Show the builder and return a boolean indicating whether value should be replaced with newValue
        - false if the user cancels for example
        
        language - indicates which language service is calling the builder
        value - expression being edited
        newValue - return the new value
        """
        ...


class EventDescriptor(System.ComponentModel.MemberDescriptor, metaclass=abc.ABCMeta):
    """Provides a description of an event."""

    RequiresUnreferencedCodeMessage: str = "The built-in EventDescriptor implementation uses Reflection which requires unreferenced code."

    @property
    @abc.abstractmethod
    def ComponentType(self) -> typing.Type:
        """When overridden in a derived class, gets the type of the component this event is bound to."""
        ...

    @property
    @abc.abstractmethod
    def EventType(self) -> typing.Type:
        """When overridden in a derived class, gets the type of delegate for the event."""
        ...

    @property
    @abc.abstractmethod
    def IsMulticast(self) -> bool:
        """
        When overridden in a derived class, gets a value indicating whether the event delegate is
        a multicast delegate.
        """
        ...

    @typing.overload
    def __init__(self, name: str, attrs: typing.List[System.Attribute]) -> None:
        """
        Initializes a new instance of the System.ComponentModel.EventDescriptor class with the
        specified name and attribute array.
        
        This method is protected.
        """
        ...

    @typing.overload
    def __init__(self, descr: System.ComponentModel.MemberDescriptor) -> None:
        """
        Initializes a new instance of the System.ComponentModel.EventDescriptor class with the name and attributes in
        the specified System.ComponentModel.MemberDescriptor.
        
        This method is protected.
        """
        ...

    @typing.overload
    def __init__(self, descr: System.ComponentModel.MemberDescriptor, attrs: typing.List[System.Attribute]) -> None:
        """
        Initializes a new instance of the System.ComponentModel.EventDescriptor class with
        the name in the specified System.ComponentModel.MemberDescriptor and the
        attributes in both the System.ComponentModel.MemberDescriptor and the System.Attribute array.
        
        This method is protected.
        """
        ...

    def AddEventHandler(self, component: typing.Any, value: System.Delegate) -> None:
        """When overridden in a derived class, binds the event to the component."""
        ...

    def RemoveEventHandler(self, component: typing.Any, value: System.Delegate) -> None:
        """
        When overridden in a derived class, unbinds the delegate from the component
        so that the delegate will no longer receive events from the component.
        """
        ...


class EventDescriptorCollection(System.Object, System.Collections.IList):
    """Represents a collection of events."""

    Empty: System.ComponentModel.EventDescriptorCollection = ...
    """An empty AttributeCollection that can used instead of creating a new one with no items."""

    @property
    def Count(self) -> int:
        """Gets the number of event descriptors in the collection."""
        ...

    @Count.setter
    def Count(self, value: int):
        """Gets the number of event descriptors in the collection."""
        ...

    @property
    def IsSynchronized(self) -> bool:
        ...

    @property
    def SyncRoot(self) -> System.Object:
        ...

    @property
    def IsReadOnly(self) -> bool:
        ...

    @property
    def IsFixedSize(self) -> bool:
        ...

    @typing.overload
    def __getitem__(self, index: int) -> System.ComponentModel.EventDescriptor:
        """Gets the event with the specified index number."""
        ...

    @typing.overload
    def __getitem__(self, name: str) -> System.ComponentModel.EventDescriptor:
        """Gets the event with the specified name."""
        ...

    @typing.overload
    def __getitem__(self, index: int) -> typing.Any:
        ...

    @typing.overload
    def __init__(self, events: typing.List[System.ComponentModel.EventDescriptor]) -> None:
        """Initializes a new instance of the System.ComponentModel.EventDescriptorCollection class."""
        ...

    @typing.overload
    def __init__(self, events: typing.List[System.ComponentModel.EventDescriptor], readOnly: bool) -> None:
        """
        Initializes a new instance of an event descriptor collection, and allows you to mark the
        collection as read-only so it cannot be modified.
        """
        ...

    def __setitem__(self, index: int, value: typing.Any) -> None:
        ...

    @typing.overload
    def Add(self, value: System.ComponentModel.EventDescriptor) -> int:
        ...

    @typing.overload
    def Add(self, value: typing.Any) -> int:
        ...

    @typing.overload
    def Clear(self) -> None:
        ...

    @typing.overload
    def Clear(self) -> None:
        ...

    @typing.overload
    def Contains(self, value: System.ComponentModel.EventDescriptor) -> bool:
        ...

    @typing.overload
    def Contains(self, value: typing.Any) -> bool:
        ...

    def CopyTo(self, array: System.Array, index: int) -> None:
        ...

    def Find(self, name: str, ignoreCase: bool) -> System.ComponentModel.EventDescriptor:
        """
        Gets the description of the event with the specified
        name in the collection.
        """
        ...

    @typing.overload
    def GetEnumerator(self) -> System.Collections.IEnumerator:
        """Gets an enumerator for this System.ComponentModel.EventDescriptorCollection."""
        ...

    @typing.overload
    def GetEnumerator(self) -> System.Collections.IEnumerator:
        ...

    @typing.overload
    def IndexOf(self, value: System.ComponentModel.EventDescriptor) -> int:
        ...

    @typing.overload
    def IndexOf(self, value: typing.Any) -> int:
        ...

    @typing.overload
    def Insert(self, index: int, value: System.ComponentModel.EventDescriptor) -> None:
        ...

    @typing.overload
    def Insert(self, index: int, value: typing.Any) -> None:
        ...

    @typing.overload
    def InternalSort(self, names: typing.List[str]) -> None:
        """
        Sorts the members of this EventDescriptorCollection. Any specified NamedSort arguments will
        be applied first, followed by sort using the specified IComparer.
        
        This method is protected.
        """
        ...

    @typing.overload
    def InternalSort(self, sorter: System.Collections.IComparer) -> None:
        """
        Sorts the members of this EventDescriptorCollection using the specified IComparer.
        
        This method is protected.
        """
        ...

    @typing.overload
    def Remove(self, value: System.ComponentModel.EventDescriptor) -> None:
        ...

    @typing.overload
    def Remove(self, value: typing.Any) -> None:
        ...

    @typing.overload
    def RemoveAt(self, index: int) -> None:
        ...

    @typing.overload
    def RemoveAt(self, index: int) -> None:
        ...

    @typing.overload
    def Sort(self) -> System.ComponentModel.EventDescriptorCollection:
        """
        Sorts the members of this EventDescriptorCollection, using the default sort for this collection,
        which is usually alphabetical.
        """
        ...

    @typing.overload
    def Sort(self, names: typing.List[str]) -> System.ComponentModel.EventDescriptorCollection:
        """
        Sorts the members of this EventDescriptorCollection. Any specified NamedSort arguments will
        be applied first, followed by sort using the specified IComparer.
        """
        ...

    @typing.overload
    def Sort(self, names: typing.List[str], comparer: System.Collections.IComparer) -> System.ComponentModel.EventDescriptorCollection:
        """
        Sorts the members of this EventDescriptorCollection. Any specified NamedSort arguments will
        be applied first, followed by sort using the specified IComparer.
        """
        ...

    @typing.overload
    def Sort(self, comparer: System.Collections.IComparer) -> System.ComponentModel.EventDescriptorCollection:
        """
        Sorts the members of this EventDescriptorCollection, using the specified IComparer to compare,
        the EventDescriptors contained in the collection.
        """
        ...


class ICustomTypeDescriptor(metaclass=abc.ABCMeta):
    """Provides an interface that provides custom type information for an object."""

    def GetAttributes(self) -> System.ComponentModel.AttributeCollection:
        """
        Gets a collection of type System.Attribute with the attributes
        for this object.
        """
        ...

    def GetClassName(self) -> str:
        """Gets the class name of this object."""
        ...

    def GetComponentName(self) -> str:
        """Gets the name of this object."""
        ...

    def GetConverter(self) -> System.ComponentModel.TypeConverter:
        """Gets a type converter for this object."""
        ...

    def GetDefaultEvent(self) -> System.ComponentModel.EventDescriptor:
        """Gets the default event for this object."""
        ...

    def GetDefaultProperty(self) -> System.ComponentModel.PropertyDescriptor:
        """Gets the default property for this object."""
        ...

    def GetEditor(self, editorBaseType: typing.Type) -> System.Object:
        """Gets an editor of the specified type for this object."""
        ...

    @typing.overload
    def GetEvents(self) -> System.ComponentModel.EventDescriptorCollection:
        """Gets the events for this instance of a component."""
        ...

    @typing.overload
    def GetEvents(self, attributes: typing.List[System.Attribute]) -> System.ComponentModel.EventDescriptorCollection:
        """
        Gets the events for this instance of a component using the attribute array as a
        filter.
        """
        ...

    @typing.overload
    def GetProperties(self) -> System.ComponentModel.PropertyDescriptorCollection:
        """Gets the properties for this instance of a component."""
        ...

    @typing.overload
    def GetProperties(self, attributes: typing.List[System.Attribute]) -> System.ComponentModel.PropertyDescriptorCollection:
        """Gets the properties for this instance of a component using the attribute array as a filter."""
        ...

    def GetPropertyOwner(self, pd: System.ComponentModel.PropertyDescriptor) -> System.Object:
        """Gets the object that directly depends on this value being edited."""
        ...


class TypeDescriptionProvider(System.Object, metaclass=abc.ABCMeta):
    """
    The TypeDescriptionProvider class can be thought of as a "plug-in" for
    TypeDescriptor. There can be multiple type description provider classes
    all offering metadata to TypeDescriptor
    """

    @typing.overload
    def __init__(self) -> None:
        """
        There are two versions of the constructor for this class. The empty
        constructor is identical to using TypeDescriptionProvider(null).
        If a child type description provider is passed into the constructor,
        the "base" versions of all methods will call to this parent provider.
        If no such provider is given, the base versions of the methods will
        return empty, but valid values.
        
        This method is protected.
        """
        ...

    @typing.overload
    def __init__(self, parent: System.ComponentModel.TypeDescriptionProvider) -> None:
        """
        There are two versions of the constructor for this class. The empty
        constructor is identical to using TypeDescriptionProvider(null).
        If a child type description provider is passed into the constructor,
        the "base" versions of all methods will call to this parent provider.
        If no such provider is given, the base versions of the methods will
        return empty, but valid values.
        
        This method is protected.
        """
        ...

    def CreateInstance(self, provider: typing.Any, objectType: typing.Type, argTypes: typing.List[typing.Type], args: typing.List[System.Object]) -> System.Object:
        """
        This method is used to create an instance that can substitute for another
        data type. If the method is not interested in providing a substitute
        instance, it should call base.
        
        This method is prototyped as virtual, and by default returns null if no
        parent provider was passed. If a parent provider was passed, this
        method will invoke the parent provider's CreateInstance method.
        """
        ...

    def GetCache(self, instance: typing.Any) -> System.Collections.IDictionary:
        """
        TypeDescriptor may need to perform complex operations on collections of metadata.
        Since types are not unloaded for the life of a domain, TypeDescriptor will
        automatically cache the results of these operations based on type. There are a
        number of operations that use live object instances, however. These operations
        cannot be cached within TypeDescriptor because caching them would prevent the
        object from garbage collecting. Instead, TypeDescriptor allows for a per-object
        cache, accessed as an IDictionary of key/value pairs, to exist on an object.
        The GetCache method returns an instance of this cache. GetCache will return
        null if there is no supported cache for an object.
        """
        ...

    def GetExtendedTypeDescriptor(self, instance: typing.Any) -> System.ComponentModel.ICustomTypeDescriptor:
        """
        This method returns an extended custom type descriptor for the given object.
        An extended type descriptor is a custom type descriptor that offers properties
        that other objects have added to this object, but are not actually defined on
        the object. For example, in the .NET Framework Component Model, objects that
        implement the interface IExtenderProvider can "attach" properties to other
        objects that reside in the same logical container. The GetTypeDescriptor
        method does not return a type descriptor that provides these extra extended
        properties. GetExtendedTypeDescriptor returns the set of these extended
        properties. TypeDescriptor will automatically merge the results of these
        two property collections. Note that while the .NET Framework component
        model only supports extended properties this API can be used for extended
        attributes and events as well, if the type description provider supports it.
        """
        ...

    def GetFullComponentName(self, component: typing.Any) -> str:
        """
        The name of the specified component, or null if the component has no name.
        In many cases this will return the same value as GetComponentName. If the
        component resides in a nested container or has other nested semantics, it may
        return a different fully qualified name.
        
        If not overridden, the default implementation of this method will call
        GetTypeDescriptor.GetComponentName.
        """
        ...

    @typing.overload
    def GetReflectionType(self, objectType: typing.Type) -> typing.Type:
        """
        The GetReflection method is a lower level version of GetTypeDescriptor.
        If no custom type descriptor can be located for an object, GetReflectionType
        is called to perform normal reflection against the object.
        """
        ...

    @typing.overload
    def GetReflectionType(self, instance: typing.Any) -> typing.Type:
        """
        The GetReflection method is a lower level version of GetTypeDescriptor.
        If no custom type descriptor can be located for an object, GetReflectionType
        is called to perform normal reflection against the object.
        
        This method is prototyped as virtual, and by default returns the
        object type if no parent provider was passed. If a parent provider was passed, this
        method will invoke the parent provider's GetReflectionType method.
        """
        ...

    @typing.overload
    def GetReflectionType(self, objectType: typing.Type, instance: typing.Any) -> typing.Type:
        """
        The GetReflection method is a lower level version of GetTypeDescriptor.
        If no custom type descriptor can be located for an object, GetReflectionType
        is called to perform normal reflection against the object.
        
        This method is prototyped as virtual, and by default returns the
        object type if no parent provider was passed. If a parent provider was passed, this
        method will invoke the parent provider's GetReflectionType method.
        """
        ...

    def GetRuntimeType(self, reflectionType: typing.Type) -> typing.Type:
        """
        The GetRuntimeType method reverses GetReflectionType to convert a reflection type
        back into a runtime type. Historically the Type.UnderlyingSystemType property has
        been used to return the runtime type. This isn't exactly correct, but it needs
        to be preserved unless all type description providers are revised.
        """
        ...

    @typing.overload
    def GetTypeDescriptor(self, objectType: typing.Type) -> System.ComponentModel.ICustomTypeDescriptor:
        """
        This method returns a custom type descriptor for the given type / object.
        The objectType parameter is always valid, but the instance parameter may
        be null if no instance was passed to TypeDescriptor. The method should
        return a custom type descriptor for the object. If the method is not
        interested in providing type information for the object it should
        return base.
        """
        ...

    @typing.overload
    def GetTypeDescriptor(self, instance: typing.Any) -> System.ComponentModel.ICustomTypeDescriptor:
        """
        This method returns a custom type descriptor for the given type / object.
        The objectType parameter is always valid, but the instance parameter may
        be null if no instance was passed to TypeDescriptor. The method should
        return a custom type descriptor for the object. If the method is not
        interested in providing type information for the object it should
        return base.
        """
        ...

    @typing.overload
    def GetTypeDescriptor(self, objectType: typing.Type, instance: typing.Any) -> System.ComponentModel.ICustomTypeDescriptor:
        """
        This method returns a custom type descriptor for the given type / object.
        The objectType parameter is always valid, but the instance parameter may
        be null if no instance was passed to TypeDescriptor. The method should
        return a custom type descriptor for the object. If the method is not
        interested in providing type information for the object it should
        return base.
        
        This method is prototyped as virtual, and by default returns a
        custom type descriptor that returns empty collections for all values
        if no parent provider was passed. If a parent provider was passed,
        this method will invoke the parent provider's GetTypeDescriptor
        method.
        """
        ...

    def IsSupportedType(self, type: typing.Type) -> bool:
        """
        This method returns true if the type is "supported" by the type descriptor
        and its chain of type description providers.
        """
        ...


class BaseNumberConverter(System.ComponentModel.TypeConverter, metaclass=abc.ABCMeta):
    """Provides a base type converter for integral types."""

    @property
    def AllowHex(self) -> bool:
        """Determines whether this editor will attempt to convert hex (0x or #) strings"""
        ...

    @property
    @abc.abstractmethod
    def TargetType(self) -> typing.Type:
        """The Type this converter is targeting (e.g. Int16, UInt32, etc.)"""
        ...

    def CanConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, sourceType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an object in the
        given source type to the TargetType object using the specified context.
        """
        ...

    def CanConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, destinationType: typing.Type) -> bool:
        ...

    def ConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any) -> System.Object:
        """Converts the given value object to an object of Type TargetType."""
        ...

    def ConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any, destinationType: typing.Type) -> System.Object:
        """Converts the given value object to the destination type."""
        ...


class DecimalConverter(System.ComponentModel.BaseNumberConverter):
    """
    Provides a type converter to convert decimal
    objects to and from various other representations.
    """

    @property
    def AllowHex(self) -> bool:
        """Determines whether this editor will attempt to convert hex (0x or #) strings"""
        ...

    @property
    def TargetType(self) -> typing.Type:
        """The Type this converter is targeting (e.g. Int16, UInt32, etc.)"""
        ...

    def CanConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, destinationType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an
        object to the given destination type using the context.
        """
        ...

    def ConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any, destinationType: typing.Type) -> System.Object:
        """
        Converts the given object to another type. The most common types to convert
        are to and from a string object. The default implementation will make a call
        to ToString on the object if the object is valid and if the destination
        type is string. If this cannot convert to the destination type, this will
        throw a NotSupportedException.
        """
        ...


class ProvidePropertyAttribute(System.Attribute):
    """Specifies which methods are extender properties."""

    @property
    def PropertyName(self) -> str:
        """Gets the name of a property that this class provides."""
        ...

    @property
    def ReceiverTypeName(self) -> str:
        """Gets the name of the data type this property can extend"""
        ...

    @property
    def TypeId(self) -> System.Object:
        ...

    @typing.overload
    def __init__(self, propertyName: str, receiverType: typing.Type) -> None:
        """Initializes a new instance of the System.ComponentModel.ProvidePropertyAttribute class."""
        ...

    @typing.overload
    def __init__(self, propertyName: str, receiverTypeName: str) -> None:
        """Initializes a new instance of the System.ComponentModel.ProvidePropertyAttribute class."""
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        ...


class ComponentResourceManager(System.Resources.ResourceManager):
    """
    The ComponentResourceManager is a resource manager object that
    provides simple functionality for enumerating resources for
    a component or object.
    """

    @typing.overload
    def __init__(self) -> None:
        ...

    @typing.overload
    def __init__(self, t: typing.Type) -> None:
        ...

    @typing.overload
    def ApplyResources(self, value: typing.Any, objectName: str) -> None:
        """
        This method examines all the resources for the current culture.
        When it finds a resource with a key in the format of
        "[objectName].[property name]" it will apply that resource's value
        to the corresponding property on the object. If there is no matching
        property the resource will be ignored.
        """
        ...

    @typing.overload
    def ApplyResources(self, value: typing.Any, objectName: str, culture: System.Globalization.CultureInfo) -> None:
        """
        This method examines all the resources for the provided culture.
        When it finds a resource with a key in the format of
        "[objectName].[property name]" or "[objectName]-[property name]" it will apply that resource's value
        to the corresponding property on the object. If there is no matching
        property the resource will be ignored.
        """
        ...


class HandledEventArgs(System.EventArgs):
    """
    Provides data for the System.ComponentModel.HandledEventArgs.Handled
    event.
    """

    @property
    def Handled(self) -> bool:
        """Gets or sets a value indicating whether the event was handled in the application's event handler."""
        ...

    @Handled.setter
    def Handled(self, value: bool):
        """Gets or sets a value indicating whether the event was handled in the application's event handler."""
        ...

    @typing.overload
    def __init__(self) -> None:
        """
        Initializes a new instance of the System.ComponentModel.HandledEventArgs class with
        handled set to false.
        """
        ...

    @typing.overload
    def __init__(self, defaultHandledValue: bool) -> None:
        """
        Initializes a new instance of the System.ComponentModel.HandledEventArgs class with
        handled set to the given value.
        """
        ...


class ListSortDirection(System.Enum):
    """Specifies the direction of a sort."""

    Ascending = 0
    """Sort in ascending order."""

    Descending = 1
    """Sort in descending order."""


class ListChangedEventArgs(System.EventArgs):
    """This class has no documentation."""

    @property
    def ListChangedType(self) -> int:
        """This property contains the int value of a member of the System.ComponentModel.ListChangedType enum."""
        ...

    @property
    def NewIndex(self) -> int:
        ...

    @property
    def OldIndex(self) -> int:
        ...

    @property
    def PropertyDescriptor(self) -> System.ComponentModel.PropertyDescriptor:
        ...

    @typing.overload
    def __init__(self, listChangedType: System.ComponentModel.ListChangedType, newIndex: int) -> None:
        ...

    @typing.overload
    def __init__(self, listChangedType: System.ComponentModel.ListChangedType, newIndex: int, propDesc: System.ComponentModel.PropertyDescriptor) -> None:
        ...

    @typing.overload
    def __init__(self, listChangedType: System.ComponentModel.ListChangedType, propDesc: System.ComponentModel.PropertyDescriptor) -> None:
        ...

    @typing.overload
    def __init__(self, listChangedType: System.ComponentModel.ListChangedType, newIndex: int, oldIndex: int) -> None:
        ...


class IBindingList(System.Collections.IList, metaclass=abc.ABCMeta):
    """This class has no documentation."""

    @property
    @abc.abstractmethod
    def AllowNew(self) -> bool:
        ...

    @property
    @abc.abstractmethod
    def AllowEdit(self) -> bool:
        ...

    @property
    @abc.abstractmethod
    def AllowRemove(self) -> bool:
        ...

    @property
    @abc.abstractmethod
    def SupportsChangeNotification(self) -> bool:
        ...

    @property
    @abc.abstractmethod
    def SupportsSearching(self) -> bool:
        ...

    @property
    @abc.abstractmethod
    def SupportsSorting(self) -> bool:
        ...

    @property
    @abc.abstractmethod
    def IsSorted(self) -> bool:
        ...

    @property
    @abc.abstractmethod
    def SortProperty(self) -> System.ComponentModel.PropertyDescriptor:
        ...

    @property
    @abc.abstractmethod
    def SortDirection(self) -> int:
        """This property contains the int value of a member of the System.ComponentModel.ListSortDirection enum."""
        ...

    @property
    @abc.abstractmethod
    def ListChanged(self) -> _EventContainer[typing.Callable[[System.Object, System.ComponentModel.ListChangedEventArgs], None], None]:
        ...

    @ListChanged.setter
    @abc.abstractmethod
    def ListChanged(self, value: _EventContainer[typing.Callable[[System.Object, System.ComponentModel.ListChangedEventArgs], None], None]):
        ...

    def AddIndex(self, property: System.ComponentModel.PropertyDescriptor) -> None:
        ...

    def AddNew(self) -> System.Object:
        ...

    def ApplySort(self, property: System.ComponentModel.PropertyDescriptor, direction: System.ComponentModel.ListSortDirection) -> None:
        ...

    def Find(self, property: System.ComponentModel.PropertyDescriptor, key: typing.Any) -> int:
        ...

    def RemoveIndex(self, property: System.ComponentModel.PropertyDescriptor) -> None:
        ...

    def RemoveSort(self) -> None:
        ...


class ListSortDescription(System.Object):
    """This class has no documentation."""

    @property
    def PropertyDescriptor(self) -> System.ComponentModel.PropertyDescriptor:
        ...

    @PropertyDescriptor.setter
    def PropertyDescriptor(self, value: System.ComponentModel.PropertyDescriptor):
        ...

    @property
    def SortDirection(self) -> int:
        """This property contains the int value of a member of the System.ComponentModel.ListSortDirection enum."""
        ...

    @SortDirection.setter
    def SortDirection(self, value: int):
        """This property contains the int value of a member of the System.ComponentModel.ListSortDirection enum."""
        ...

    def __init__(self, property: System.ComponentModel.PropertyDescriptor, direction: System.ComponentModel.ListSortDirection) -> None:
        ...


class ListSortDescriptionCollection(System.Object, System.Collections.IList):
    """This class has no documentation."""

    @property
    def IsFixedSize(self) -> bool:
        ...

    @property
    def IsReadOnly(self) -> bool:
        ...

    @property
    def Count(self) -> int:
        ...

    @property
    def IsSynchronized(self) -> bool:
        ...

    @property
    def SyncRoot(self) -> System.Object:
        ...

    @typing.overload
    def __getitem__(self, index: int) -> System.ComponentModel.ListSortDescription:
        ...

    @typing.overload
    def __getitem__(self, index: int) -> typing.Any:
        ...

    @typing.overload
    def __init__(self) -> None:
        ...

    @typing.overload
    def __init__(self, sorts: typing.List[System.ComponentModel.ListSortDescription]) -> None:
        ...

    @typing.overload
    def __setitem__(self, index: int, value: System.ComponentModel.ListSortDescription) -> None:
        ...

    @typing.overload
    def __setitem__(self, index: int, value: typing.Any) -> None:
        ...

    def Add(self, value: typing.Any) -> int:
        ...

    def Clear(self) -> None:
        ...

    def Contains(self, value: typing.Any) -> bool:
        ...

    def CopyTo(self, array: System.Array, index: int) -> None:
        ...

    def GetEnumerator(self) -> System.Collections.IEnumerator:
        ...

    def IndexOf(self, value: typing.Any) -> int:
        ...

    def Insert(self, index: int, value: typing.Any) -> None:
        ...

    def Remove(self, value: typing.Any) -> None:
        ...

    def RemoveAt(self, index: int) -> None:
        ...


class IBindingListView(System.ComponentModel.IBindingList, metaclass=abc.ABCMeta):
    """This class has no documentation."""

    @property
    @abc.abstractmethod
    def Filter(self) -> str:
        ...

    @Filter.setter
    @abc.abstractmethod
    def Filter(self, value: str):
        ...

    @property
    @abc.abstractmethod
    def SortDescriptions(self) -> System.ComponentModel.ListSortDescriptionCollection:
        ...

    @property
    @abc.abstractmethod
    def SupportsAdvancedSorting(self) -> bool:
        ...

    @property
    @abc.abstractmethod
    def SupportsFiltering(self) -> bool:
        ...

    def ApplySort(self, sorts: System.ComponentModel.ListSortDescriptionCollection) -> None:
        ...

    def RemoveFilter(self) -> None:
        ...


class ICancelAddNew(metaclass=abc.ABCMeta):
    """
    Interface implemented by a list that allows the addition of a new item
    to be either cancelled or committed.
    
    Note: In some scenarios, specifically Windows Forms complex data binding,
    the list may receive CancelNew or EndNew calls for items other than the
    new item. These calls should be ignored, ie. the new item should only be
    cancelled or committed when that item's index is specified.
    """

    def CancelNew(self, itemIndex: int) -> None:
        """
        If a new item has been added to the list, and  is the position of that item,
        then this method should remove it from the list and cancel the add operation.
        """
        ...

    def EndNew(self, itemIndex: int) -> None:
        """
        If a new item has been added to the list, and  is the position of that item,
        then this method should leave it in the list and complete the add operation.
        """
        ...


class IRaiseItemChangedEvents(metaclass=abc.ABCMeta):
    """This class has no documentation."""

    @property
    @abc.abstractmethod
    def RaisesItemChangedEvents(self) -> bool:
        ...


class AddingNewEventArgs(System.EventArgs):
    """
    Provides data for an event that signals the adding of a new object
    to a list, allowing any event handler to supply the new object. If
    no event handler supplies a new object to use, the list should create
    one itself.
    """

    @property
    def NewObject(self) -> System.Object:
        """Gets or sets the new object that will be added to the list."""
        ...

    @NewObject.setter
    def NewObject(self, value: System.Object):
        """Gets or sets the new object that will be added to the list."""
        ...

    @typing.overload
    def __init__(self) -> None:
        """
        Initializes a new instance of the System.ComponentModel.AddingNewEventArgs class,
        with no new object defined.
        """
        ...

    @typing.overload
    def __init__(self, newObject: typing.Any) -> None:
        """
        Initializes a new instance of the System.ComponentModel.AddingNewEventArgs class,
        with the specified object defined as the default new object.
        """
        ...


class BindingList(typing.Generic[System_ComponentModel_BindingList_T], System.Collections.ObjectModel.Collection[System_ComponentModel_BindingList_T], System.ComponentModel.IBindingList, System.ComponentModel.ICancelAddNew, System.ComponentModel.IRaiseItemChangedEvents):
    """This class has no documentation."""

    @property
    def AddingNew(self) -> _EventContainer[typing.Callable[[System.Object, System.ComponentModel.AddingNewEventArgs], None], None]:
        ...

    @AddingNew.setter
    def AddingNew(self, value: _EventContainer[typing.Callable[[System.Object, System.ComponentModel.AddingNewEventArgs], None], None]):
        ...

    @property
    def ListChanged(self) -> _EventContainer[typing.Callable[[System.Object, System.ComponentModel.ListChangedEventArgs], None], None]:
        ...

    @ListChanged.setter
    def ListChanged(self, value: _EventContainer[typing.Callable[[System.Object, System.ComponentModel.ListChangedEventArgs], None], None]):
        ...

    @property
    def RaiseListChangedEvents(self) -> bool:
        ...

    @RaiseListChangedEvents.setter
    def RaiseListChangedEvents(self, value: bool):
        ...

    @property
    def AllowNew(self) -> bool:
        ...

    @AllowNew.setter
    def AllowNew(self, value: bool):
        ...

    @property
    def AllowEdit(self) -> bool:
        ...

    @AllowEdit.setter
    def AllowEdit(self, value: bool):
        ...

    @property
    def AllowRemove(self) -> bool:
        ...

    @AllowRemove.setter
    def AllowRemove(self, value: bool):
        ...

    @property
    def SupportsChangeNotification(self) -> bool:
        ...

    @property
    def SupportsChangeNotificationCore(self) -> bool:
        """This property is protected."""
        ...

    @property
    def SupportsSearching(self) -> bool:
        ...

    @property
    def SupportsSearchingCore(self) -> bool:
        """This property is protected."""
        ...

    @property
    def SupportsSorting(self) -> bool:
        ...

    @property
    def SupportsSortingCore(self) -> bool:
        """This property is protected."""
        ...

    @property
    def IsSorted(self) -> bool:
        ...

    @property
    def IsSortedCore(self) -> bool:
        """This property is protected."""
        ...

    @property
    def SortProperty(self) -> System.ComponentModel.PropertyDescriptor:
        ...

    @property
    def SortPropertyCore(self) -> System.ComponentModel.PropertyDescriptor:
        """This property is protected."""
        ...

    @property
    def SortDirection(self) -> int:
        """This property contains the int value of a member of the System.ComponentModel.ListSortDirection enum."""
        ...

    @property
    def SortDirectionCore(self) -> int:
        """
        This property contains the int value of a member of the System.ComponentModel.ListSortDirection enum.
        
        This property is protected.
        """
        ...

    @property
    def RaisesItemChangedEvents(self) -> bool:
        ...

    @typing.overload
    def __init__(self) -> None:
        ...

    @typing.overload
    def __init__(self, list: System.Collections.Generic.IList[System_ComponentModel_BindingList_T]) -> None:
        """Constructor that allows substitution of the inner list with a custom list."""
        ...

    def AddIndex(self, prop: System.ComponentModel.PropertyDescriptor) -> None:
        ...

    @typing.overload
    def AddNew(self) -> System_ComponentModel_BindingList_T:
        ...

    @typing.overload
    def AddNew(self) -> System.Object:
        ...

    def AddNewCore(self) -> System.Object:
        """
        Creates a new item and adds it to the list.
        
        The base implementation raises the AddingNew event to allow an event handler to
        supply a custom item to add to the list. Otherwise an item of type T is created.
        The new item is then added to the end of the list.
        
        This method is protected.
        """
        ...

    def ApplySort(self, prop: System.ComponentModel.PropertyDescriptor, direction: System.ComponentModel.ListSortDirection) -> None:
        ...

    def ApplySortCore(self, prop: System.ComponentModel.PropertyDescriptor, direction: System.ComponentModel.ListSortDirection) -> None:
        """This method is protected."""
        ...

    def CancelNew(self, itemIndex: int) -> None:
        ...

    def ClearItems(self) -> None:
        """This method is protected."""
        ...

    def EndNew(self, itemIndex: int) -> None:
        """If item added using AddNew() is still cancellable, then commit that item."""
        ...

    def Find(self, prop: System.ComponentModel.PropertyDescriptor, key: typing.Any) -> int:
        ...

    def FindCore(self, prop: System.ComponentModel.PropertyDescriptor, key: typing.Any) -> int:
        """This method is protected."""
        ...

    def InsertItem(self, index: int, item: System_ComponentModel_BindingList_T) -> None:
        """This method is protected."""
        ...

    def OnAddingNew(self, e: System.ComponentModel.AddingNewEventArgs) -> None:
        """
        Raises the AddingNew event.
        
        This method is protected.
        """
        ...

    def OnListChanged(self, e: System.ComponentModel.ListChangedEventArgs) -> None:
        """
        Raises the ListChanged event.
        
        This method is protected.
        """
        ...

    def RemoveIndex(self, prop: System.ComponentModel.PropertyDescriptor) -> None:
        ...

    def RemoveItem(self, index: int) -> None:
        """This method is protected."""
        ...

    def RemoveSort(self) -> None:
        ...

    def RemoveSortCore(self) -> None:
        """This method is protected."""
        ...

    def ResetBindings(self) -> None:
        ...

    def ResetItem(self, position: int) -> None:
        ...

    def SetItem(self, index: int, item: System_ComponentModel_BindingList_T) -> None:
        """This method is protected."""
        ...


class TimeSpanConverter(System.ComponentModel.TypeConverter):
    """
    Provides a type converter to convert System.TimeSpan objects to and from
    various other representations.
    """

    def CanConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, sourceType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can
        convert an object in the given source type to a System.TimeSpan object using the
        specified context.
        """
        ...

    def CanConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, destinationType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an object to the given
        destination type using the context.
        """
        ...

    def ConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any) -> System.Object:
        """
        Converts the given object to a System.TimeSpan
        object.
        """
        ...

    def ConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any, destinationType: typing.Type) -> System.Object:
        """
        Converts the given object to another type. The most common types to convert
        are to and from a string object. The default implementation will make a call
        to ToString on the object if the object is valid and if the destination
        type is string. If this cannot convert to the destination type, this will
        throw a NotSupportedException.
        """
        ...


class DesignTimeVisibleAttribute(System.Attribute):
    """
    DesignTimeVisibileAttribute marks a component's visibility. If
    DesignTimeVisibileAttribute.Yes is present, a visual designer can show
    this component on a designer.
    """

    @property
    def Visible(self) -> bool:
        """
        True if this component should be shown at design time, or false
        if it shouldn't.
        """
        ...

    Yes: System.ComponentModel.DesignTimeVisibleAttribute = ...
    """Marks a component as visible in a visual designer."""

    No: System.ComponentModel.DesignTimeVisibleAttribute = ...
    """Marks a component as not visible in a visual designer."""

    Default: System.ComponentModel.DesignTimeVisibleAttribute = ...
    """The default visibility. (equal to Yes.)"""

    @typing.overload
    def __init__(self, visible: bool) -> None:
        """
        Creates a new DesignTimeVisibleAttribute with the visible
        property set to the given value.
        """
        ...

    @typing.overload
    def __init__(self) -> None:
        """
        Creates a new DesignTimeVisibleAttribute set to the default
        value of true.
        """
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        ...

    def IsDefaultAttribute(self) -> bool:
        ...


class ReferenceConverter(System.ComponentModel.TypeConverter):
    """
    Provides a type converter to convert object references to and from various
    other representations.
    """

    def __init__(self, type: typing.Type) -> None:
        """Initializes a new instance of the System.ComponentModel.ReferenceConverter class."""
        ...

    def CanConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, sourceType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an object in the
        given source type to a reference object using the specified context.
        """
        ...

    def ConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any) -> System.Object:
        """Converts the given object to the reference type."""
        ...

    def ConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any, destinationType: typing.Type) -> System.Object:
        """Converts the given value object to the reference type using the specified context and arguments."""
        ...

    def GetStandardValues(self, context: System.ComponentModel.ITypeDescriptorContext) -> System.ComponentModel.TypeConverter.StandardValuesCollection:
        """Gets a collection of standard values for the reference data type."""
        ...

    def GetStandardValuesExclusive(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """
        Gets a value indicating whether the list of standard values returned from
        System.ComponentModel.ReferenceConverter.GetStandardValues is an exclusive list.
        """
        ...

    def GetStandardValuesSupported(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """
        Gets a value indicating whether this object supports a standard set of values
        that can be picked from a list.
        """
        ...

    def IsValueAllowed(self, context: System.ComponentModel.ITypeDescriptorContext, value: typing.Any) -> bool:
        """
        Gets a value indicating whether a particular value can be added to
        the standard values collection.
        
        This method is protected.
        """
        ...


class ComponentEditor(System.Object, metaclass=abc.ABCMeta):
    """Provides the base class for a custom component editor."""

    @typing.overload
    def EditComponent(self, component: typing.Any) -> bool:
        """Gets a value indicating whether the component was modified."""
        ...

    @typing.overload
    def EditComponent(self, context: System.ComponentModel.ITypeDescriptorContext, component: typing.Any) -> bool:
        """Gets a value indicating whether the component was modified."""
        ...


class MultilineStringConverter(System.ComponentModel.TypeConverter):
    """Provides a type converter to convert multiline strings to a simple string."""

    def ConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any, destinationType: typing.Type) -> System.Object:
        """Converts the given value object to the specified destination type."""
        ...

    def GetProperties(self, context: System.ComponentModel.ITypeDescriptorContext, value: typing.Any, attributes: typing.List[System.Attribute]) -> System.ComponentModel.PropertyDescriptorCollection:
        """
        Gets a collection of properties for the type of array specified by the value
        parameter using the specified context and attributes.
        """
        ...

    def GetPropertiesSupported(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """Gets a value indicating whether this object supports properties."""
        ...


class IExtenderProvider(metaclass=abc.ABCMeta):
    """Defines the interface for extending properties to other components in a container."""

    def CanExtend(self, extendee: typing.Any) -> bool:
        """
        Specifies whether this object can provide its extender properties to
        the specified object.
        """
        ...


class ExtenderProvidedPropertyAttribute(System.Attribute):
    """
    ExtenderProvidedPropertyAttribute is an attribute that marks that a property
    was actually offered up by and extender provider.
    """

    @property
    def ExtenderProperty(self) -> System.ComponentModel.PropertyDescriptor:
        """PropertyDescriptor of the property that is being provided."""
        ...

    @ExtenderProperty.setter
    def ExtenderProperty(self, value: System.ComponentModel.PropertyDescriptor):
        """PropertyDescriptor of the property that is being provided."""
        ...

    @property
    def Provider(self) -> System.ComponentModel.IExtenderProvider:
        """Extender provider that is providing the property."""
        ...

    @Provider.setter
    def Provider(self, value: System.ComponentModel.IExtenderProvider):
        """Extender provider that is providing the property."""
        ...

    @property
    def ReceiverType(self) -> typing.Type:
        """The type of object that can receive these properties."""
        ...

    @ReceiverType.setter
    def ReceiverType(self, value: typing.Type):
        """The type of object that can receive these properties."""
        ...

    def __init__(self) -> None:
        """Creates an empty ExtenderProvidedPropertyAttribute."""
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        ...

    def IsDefaultAttribute(self) -> bool:
        ...


class License(System.Object, System.IDisposable, metaclass=abc.ABCMeta):
    """
    Provides the abstract base class for all licenses. A license is
    granted to a specific instance of a component.
    """

    @property
    @abc.abstractmethod
    def LicenseKey(self) -> str:
        """When overridden in a derived class, gets the license key granted to this component."""
        ...

    def Dispose(self) -> None:
        """When overridden in a derived class, releases the license."""
        ...


class LicenseException(System.SystemException):
    """Represents the exception thrown when a component cannot be granted a license."""

    @property
    def LicensedType(self) -> typing.Type:
        """Gets the type of the component that was not granted a license."""
        ...

    @typing.overload
    def __init__(self, type: typing.Type) -> None:
        """
        Initializes a new instance of the System.ComponentModel.LicenseException class for the
        specified type.
        """
        ...

    @typing.overload
    def __init__(self, type: typing.Type, instance: typing.Any) -> None:
        """
        Initializes a new instance of the System.ComponentModel.LicenseException class for the
        specified type and instance.
        """
        ...

    @typing.overload
    def __init__(self, type: typing.Type, instance: typing.Any, message: str) -> None:
        """
        Initializes a new instance of the System.ComponentModel.LicenseException class for the
        specified type and instance with the specified message.
        """
        ...

    @typing.overload
    def __init__(self, type: typing.Type, instance: typing.Any, message: str, innerException: System.Exception) -> None:
        """
        Initializes a new instance of the System.ComponentModel.LicenseException class for the
        specified innerException, type and instance with the specified message.
        """
        ...

    @typing.overload
    def __init__(self, info: System.Runtime.Serialization.SerializationInfo, context: System.Runtime.Serialization.StreamingContext) -> None:
        """
        Need this constructor since Exception implements ISerializable.
        
        This method is protected.
        """
        ...

    def GetObjectData(self, info: System.Runtime.Serialization.SerializationInfo, context: System.Runtime.Serialization.StreamingContext) -> None:
        """Need this since Exception implements ISerializable."""
        ...


class Container(System.Object, System.ComponentModel.IContainer):
    """Encapsulates zero or more components."""

    @property
    def Components(self) -> System.ComponentModel.ComponentCollection:
        """Gets all the components in the System.ComponentModel.Container."""
        ...

    @typing.overload
    def Add(self, component: System.ComponentModel.IComponent) -> None:
        """
        Adds the specified component to the System.ComponentModel.Container
        The component is unnamed.
        """
        ...

    @typing.overload
    def Add(self, component: System.ComponentModel.IComponent, name: str) -> None:
        ...

    def CreateSite(self, component: System.ComponentModel.IComponent, name: str) -> System.ComponentModel.ISite:
        """
        Creates a Site System.ComponentModel.ISite for the given System.ComponentModel.IComponent
        and assigns the given name to the site.
        
        This method is protected.
        """
        ...

    @typing.overload
    def Dispose(self) -> None:
        """
        Disposes of the container. A call to the Dispose method indicates that
        the user of the container has no further need for it.
        
        The implementation of Dispose must:
        
        (1) Remove any references the container is holding to other components.
        This is typically accomplished by assigning null to any fields that
        contain references to other components.
        
        (2) Release any system resources that are associated with the container,
        such as file handles, window handles, or database connections.
        
        (3) Dispose of child components by calling the Dispose method of each.
        
        Ideally, a call to Dispose will revert a container to the state it was
        in immediately after it was created. However, this is not a requirement.
        Following a call to its Dispose method, a container is permitted to raise
        exceptions for operations that cannot meaningfully be performed.
        """
        ...

    @typing.overload
    def Dispose(self, disposing: bool) -> None:
        """This method is protected."""
        ...

    def GetService(self, service: typing.Type) -> System.Object:
        """This method is protected."""
        ...

    def Remove(self, component: System.ComponentModel.IComponent) -> None:
        """Removes a component from the System.ComponentModel.Container."""
        ...

    def RemoveWithoutUnsiting(self, component: System.ComponentModel.IComponent) -> None:
        """This method is protected."""
        ...

    def ValidateName(self, component: System.ComponentModel.IComponent, name: str) -> None:
        """
        Validates that the given name is valid for a component. The default implementation
        verifies that name is either null or unique compared to the names of other
        components in the container.
        
        This method is protected.
        """
        ...


class INestedContainer(System.ComponentModel.IContainer, metaclass=abc.ABCMeta):
    """
    A "nested container" is an object that logically contains zero or more child
    components and is controlled (owned) by some parent component.
    
    In this context, "containment" refers to logical containment, not visual
    containment. Components and containers can be used in a variety of
    scenarios, including both visual and non-visual scenarios.
    """

    @property
    @abc.abstractmethod
    def Owner(self) -> System.ComponentModel.IComponent:
        """The component that owns this nested container."""
        ...


class NestedContainer(System.ComponentModel.Container, System.ComponentModel.INestedContainer):
    """
    A nested container is a container that is owned by another component. Nested
    containers can be found by querying a component site's services for NestedConainter.
    Nested containers are a useful tool to establish owner relationships among components.
    All components within a nested container are named with the owning component's name
    as a prefix.
    """

    @property
    def Owner(self) -> System.ComponentModel.IComponent:
        """The component that owns this nested container."""
        ...

    @property
    def OwnerName(self) -> str:
        """
        Retrieves the name of the owning component. This may be overridden to
        provide a custom owner name. The default searches the owner's site for
        INestedSite and calls FullName, or ISite.Name if there is no nested site.
        If neither is available, this returns null.
        
        This property is protected.
        """
        ...

    def __init__(self, owner: System.ComponentModel.IComponent) -> None:
        """Creates a new NestedContainer."""
        ...

    def CreateSite(self, component: System.ComponentModel.IComponent, name: str) -> System.ComponentModel.ISite:
        """
        Creates a site for the component within the container.
        
        This method is protected.
        """
        ...

    def Dispose(self, disposing: bool) -> None:
        """
        Override of Container's dispose.
        
        This method is protected.
        """
        ...

    def GetService(self, service: typing.Type) -> System.Object:
        """This method is protected."""
        ...


class UInt64Converter(System.ComponentModel.BaseNumberConverter):
    """
    Provides a type converter to convert 64-bit unsigned integer objects to and
    from various other representations.
    """

    @property
    def TargetType(self) -> typing.Type:
        """The Type this converter is targeting (e.g. Int16, UInt64, etc.)"""
        ...


class DataObjectMethodType(System.Enum):
    """This class has no documentation."""

    Fill = 0

    Select = 1

    Update = 2

    Insert = 3

    Delete = 4


class DataObjectMethodAttribute(System.Attribute):
    """This class has no documentation."""

    @property
    def IsDefault(self) -> bool:
        ...

    @property
    def MethodType(self) -> int:
        """This property contains the int value of a member of the System.ComponentModel.DataObjectMethodType enum."""
        ...

    @typing.overload
    def __init__(self, methodType: System.ComponentModel.DataObjectMethodType) -> None:
        ...

    @typing.overload
    def __init__(self, methodType: System.ComponentModel.DataObjectMethodType, isDefault: bool) -> None:
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        ...

    def Match(self, obj: typing.Any) -> bool:
        ...


class DefaultEventAttribute(System.Attribute):
    """Specifies the default event for a component."""

    @property
    def Name(self) -> str:
        """Gets the name of the default event for the component this attribute is bound to."""
        ...

    Default: System.ComponentModel.DefaultEventAttribute = ...
    """
    Specifies the default value for the System.ComponentModel.DefaultEventAttribute, which is
    null.
    This static field is read-only.
    """

    def __init__(self, name: str) -> None:
        """Initializes a new instance of the System.ComponentModel.DefaultEventAttribute class."""
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        ...


class DataObjectAttribute(System.Attribute):
    """This class has no documentation."""

    DataObject: System.ComponentModel.DataObjectAttribute = ...

    NonDataObject: System.ComponentModel.DataObjectAttribute = ...

    Default: System.ComponentModel.DataObjectAttribute = ...

    @property
    def IsDataObject(self) -> bool:
        ...

    @typing.overload
    def __init__(self) -> None:
        ...

    @typing.overload
    def __init__(self, isDataObject: bool) -> None:
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        ...

    def IsDefaultAttribute(self) -> bool:
        ...


class BindableSupport(System.Enum):
    """
    Specifies which values to say if property or event value can be bound to a data
    element or another property or event's value.
    """

    No = ...
    """The property or event is bindable."""

    Yes = ...
    """The property or event is not bindable."""

    Default = ...
    """The property or event is the default."""


class ListBindableAttribute(System.Attribute):
    """This class has no documentation."""

    Yes: System.ComponentModel.ListBindableAttribute = ...

    No: System.ComponentModel.ListBindableAttribute = ...

    Default: System.ComponentModel.ListBindableAttribute = ...

    @property
    def ListBindable(self) -> bool:
        ...

    @typing.overload
    def __init__(self, listBindable: bool) -> None:
        ...

    @typing.overload
    def __init__(self, flags: System.ComponentModel.BindableSupport) -> None:
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        """Returns the hashcode for this object."""
        ...

    def IsDefaultAttribute(self) -> bool:
        ...


class AttributeProviderAttribute(System.Attribute):
    """This class has no documentation."""

    @property
    def TypeName(self) -> str:
        """
        The TypeName property returns the assembly qualified type name
        passed into the constructor.
        """
        ...

    @property
    def PropertyName(self) -> str:
        """The TypeName property returns the property name that will be used to query attributes from."""
        ...

    @typing.overload
    def __init__(self, typeName: str) -> None:
        """Creates a new AttributeProviderAttribute object."""
        ...

    @typing.overload
    def __init__(self, typeName: str, propertyName: str) -> None:
        """Creates a new AttributeProviderAttribute object."""
        ...

    @typing.overload
    def __init__(self, type: typing.Type) -> None:
        """Creates a new AttributeProviderAttribute object."""
        ...


class CultureInfoConverter(System.ComponentModel.TypeConverter):
    """
    Provides a type converter to convert System.Globalization.CultureInfo
    objects to and from various other representations.
    """

    def CanConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, sourceType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an object in the given
        source type to a System.Globalization.CultureInfo object using the specified context.
        """
        ...

    def CanConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, destinationType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an object to
        the given destination type using the context.
        """
        ...

    def ConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any) -> System.Object:
        """
        Converts the specified value object to a System.Globalization.CultureInfo
        object.
        """
        ...

    def ConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any, destinationType: typing.Type) -> System.Object:
        """Converts the given value object to the specified destination type."""
        ...

    def GetCultureName(self, culture: System.Globalization.CultureInfo) -> str:
        """
        Retrieves the Name for a input CultureInfo.
        
        This method is protected.
        """
        ...

    def GetStandardValues(self, context: System.ComponentModel.ITypeDescriptorContext) -> System.ComponentModel.TypeConverter.StandardValuesCollection:
        """
        Gets a collection of standard values collection for a System.Globalization.CultureInfo
        object using the specified context.
        """
        ...

    def GetStandardValuesExclusive(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """
        Gets a value indicating whether the list of standard values returned from
        System.ComponentModel.CultureInfoConverter.GetStandardValues is an exclusive list.
        """
        ...

    def GetStandardValuesSupported(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """
        Gets a value indicating whether this object supports a standard set
        of values that can be picked from a list using the specified context.
        """
        ...


class DataObjectFieldAttribute(System.Attribute):
    """
    Represents a field of a DataObject. Use this attribute on a field to indicate
    properties such as primary key, identity, nullability, and length.
    """

    @property
    def IsIdentity(self) -> bool:
        ...

    @property
    def IsNullable(self) -> bool:
        ...

    @property
    def Length(self) -> int:
        ...

    @property
    def PrimaryKey(self) -> bool:
        ...

    @typing.overload
    def __init__(self, primaryKey: bool) -> None:
        ...

    @typing.overload
    def __init__(self, primaryKey: bool, isIdentity: bool) -> None:
        ...

    @typing.overload
    def __init__(self, primaryKey: bool, isIdentity: bool, isNullable: bool) -> None:
        ...

    @typing.overload
    def __init__(self, primaryKey: bool, isIdentity: bool, isNullable: bool, length: int) -> None:
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        ...


class DateTimeOffsetConverter(System.ComponentModel.TypeConverter):
    """
    Provides a type converter to convert System.DateTimeOffset
    objects to and from various other representations.
    """

    def CanConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, sourceType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an
        object in the given source type to a System.DateTimeOffset
        object using the specified context.
        """
        ...

    def CanConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, destinationType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an
        object to the given destination type using the context.
        """
        ...

    def ConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any) -> System.Object:
        """
        Converts the given value object to a System.DateTime
        object.
        """
        ...

    def ConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any, destinationType: typing.Type) -> System.Object:
        """
        Converts the given value object to a System.DateTimeOffset
        object using the arguments.
        """
        ...


class LicenseProviderAttribute(System.Attribute):
    """
    Specifies the System.ComponentModel.LicenseProvider
    to use with a class.
    """

    Default: System.ComponentModel.LicenseProviderAttribute = ...
    """Specifies the default value, which is no provider. This static field is read-only."""

    @property
    def LicenseProvider(self) -> typing.Type:
        """Gets the license provider to use with the associated class."""
        ...

    @property
    def TypeId(self) -> System.Object:
        """
        This defines a unique ID for this attribute type. It is used
        by filtering algorithms to identify two attributes that are
        the same type. For most attributes, this just returns the
        Type instance for the attribute. LicenseProviderAttribute overrides this to include the type name and the
        provider type name.
        """
        ...

    @typing.overload
    def __init__(self) -> None:
        """
        Initializes a new instance of the System.ComponentModel.LicenseProviderAttribute class without a license
        provider.
        """
        ...

    @typing.overload
    def __init__(self, typeName: str) -> None:
        """
        Initializes a new instance of the System.ComponentModel.LicenseProviderAttribute class with
        the specified type.
        """
        ...

    @typing.overload
    def __init__(self, type: typing.Type) -> None:
        """
        Initializes a new instance of the System.ComponentModel.LicenseProviderAttribute class with
        the specified type of license provider.
        """
        ...

    def Equals(self, value: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        """Returns the hashcode for this object."""
        ...


class CollectionConverter(System.ComponentModel.TypeConverter):
    """
    Provides a type converter to convert collection objects to and from various other
    representations.
    """

    def ConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any, destinationType: typing.Type) -> System.Object:
        """Converts the given value object to the specified destination type."""
        ...

    def GetProperties(self, context: System.ComponentModel.ITypeDescriptorContext, value: typing.Any, attributes: typing.List[System.Attribute]) -> System.ComponentModel.PropertyDescriptorCollection:
        """
        Gets a collection of properties for the type of array specified by the value
        parameter using the specified context and attributes.
        """
        ...


class ContainerFilterService(System.Object, metaclass=abc.ABCMeta):
    """
    The Container and NestedContainer classes will call GetService for ContainerFilterService
    each time they need to construct a Components collection for return to a caller.
    ContainerFilterService may return an updated collection of components. This allows
    an external service to modify the view of components that are returned from a container.
    """

    def __init__(self) -> None:
        """This method is protected."""
        ...

    def FilterComponents(self, components: System.ComponentModel.ComponentCollection) -> System.ComponentModel.ComponentCollection:
        """
        Filters the components collection by optionally returning a new, modified collection.
        The default implementation returns the input collection, thereby performing no filtering.
        """
        ...


class InstallerTypeAttribute(System.Attribute):
    """Specifies the installer to use for a type to install components."""

    @property
    def InstallerType(self) -> typing.Type:
        """Gets the type of installer associated with this attribute."""
        ...

    @typing.overload
    def __init__(self, installerType: typing.Type) -> None:
        """Initializes a new instance of the System.Windows.Forms.ComponentModel.InstallerTypeAttribute class."""
        ...

    @typing.overload
    def __init__(self, typeName: str) -> None:
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        ...


class LicenseContext(IServiceProvider):
    """Specifies when the licensed object can be used."""

    @property
    def UsageMode(self) -> int:
        """
        When overridden in a derived class, gets a value that specifies when a license can be used.
        
        This property contains the int value of a member of the System.ComponentModel.LicenseUsageMode enum.
        """
        ...

    def GetSavedLicenseKey(self, type: typing.Type, resourceAssembly: System.Reflection.Assembly) -> str:
        """
        When overridden in a derived class, gets a saved license
        key for the specified type, from the specified resource assembly.
        """
        ...

    def GetService(self, type: typing.Type) -> System.Object:
        """When overridden in a derived class, will return an object that implements the asked for service."""
        ...

    def SetSavedLicenseKey(self, type: typing.Type, key: str) -> None:
        """When overridden in a derived class, sets a license key for the specified type."""
        ...


class LicenseManager(System.Object):
    """
    Provides properties and methods to add a license
    to a component and to manage a System.ComponentModel.LicenseProvider. This class cannot be inherited.
    """

    CurrentContext: System.ComponentModel.LicenseContext
    """
    Gets or sets the current System.ComponentModel.LicenseContext which specifies when the licensed object can be
    used.
    """

    UsageMode: int
    """
    Gets the System.ComponentModel.LicenseUsageMode that
    specifies when the licensed object can be used, for the System.ComponentModel.LicenseManager.CurrentContext.
    
    This property contains the int value of a member of the System.ComponentModel.LicenseUsageMode enum.
    """

    @staticmethod
    @typing.overload
    def CreateWithContext(type: typing.Type, creationContext: System.ComponentModel.LicenseContext) -> System.Object:
        """
        Creates an instance of the specified type, using
        creationContext
        as the context in which the licensed instance can be used.
        """
        ...

    @staticmethod
    @typing.overload
    def CreateWithContext(type: typing.Type, creationContext: System.ComponentModel.LicenseContext, args: typing.List[System.Object]) -> System.Object:
        """
        Creates an instance of the specified type with the
        specified arguments, using creationContext as the context in which the licensed
        instance can be used.
        """
        ...

    @staticmethod
    def IsLicensed(type: typing.Type) -> bool:
        """Determines if the given type has a valid license or not."""
        ...

    @staticmethod
    @typing.overload
    def IsValid(type: typing.Type) -> bool:
        """Determines if a valid license can be granted for the specified type."""
        ...

    @staticmethod
    @typing.overload
    def IsValid(type: typing.Type, instance: typing.Any, license: typing.Optional[System.ComponentModel.License]) -> typing.Union[bool, System.ComponentModel.License]:
        """
        Determines if a valid license can be granted for the
        specified instance of the type. This method creates a valid System.ComponentModel.License.
        """
        ...

    @staticmethod
    def LockContext(contextUser: typing.Any) -> None:
        ...

    @staticmethod
    def UnlockContext(contextUser: typing.Any) -> None:
        ...

    @staticmethod
    @typing.overload
    def Validate(type: typing.Type) -> None:
        """Determines if a license can be granted for the specified type."""
        ...

    @staticmethod
    @typing.overload
    def Validate(type: typing.Type, instance: typing.Any) -> System.ComponentModel.License:
        """Determines if a license can be granted for the instance of the specified type."""
        ...


class ExpandableObjectConverter(System.ComponentModel.TypeConverter):
    """
    Provides a type converter to convert expandable objects to and from various
    other representations.
    """

    def __init__(self) -> None:
        """Initializes a new instance of the System.ComponentModel.ExpandableObjectConverter class."""
        ...

    def GetProperties(self, context: System.ComponentModel.ITypeDescriptorContext, value: typing.Any, attributes: typing.List[System.Attribute]) -> System.ComponentModel.PropertyDescriptorCollection:
        """
        Gets a collection of properties for the type of object
        specified by the value parameter.
        """
        ...

    def GetPropertiesSupported(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """
        Gets a value indicating whether this object supports properties using the
        specified context.
        """
        ...


class ISupportInitializeNotification(System.ComponentModel.ISupportInitialize, metaclass=abc.ABCMeta):
    """Extends ISupportInitialize to allow dependent components to be notified when initialization is complete."""

    @property
    @abc.abstractmethod
    def IsInitialized(self) -> bool:
        """Indicates whether initialization is complete yet."""
        ...

    @property
    @abc.abstractmethod
    def Initialized(self) -> _EventContainer[typing.Callable[[System.Object, System.EventArgs], None], None]:
        """Sent when initialization is complete."""
        ...

    @Initialized.setter
    @abc.abstractmethod
    def Initialized(self, value: _EventContainer[typing.Callable[[System.Object, System.EventArgs], None], None]):
        """Sent when initialization is complete."""
        ...


class TypeListConverter(System.ComponentModel.TypeConverter, metaclass=abc.ABCMeta):
    """Provides a type converter that can be used to populate a list box with available types."""

    def __init__(self, types: typing.List[typing.Type]) -> None:
        """
        Initializes a new instance of the System.ComponentModel.TypeListConverter class using
        the type array as the available types.
        
        This method is protected.
        """
        ...

    def CanConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, sourceType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter
        can convert an object in the given source type to an enumeration object using
        the specified context.
        """
        ...

    def CanConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, destinationType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an object
        to the given destination type using the context.
        """
        ...

    def ConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any) -> System.Object:
        """Converts the specified value object to an enumeration object."""
        ...

    def ConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any, destinationType: typing.Type) -> System.Object:
        """Converts the given value object to the specified destination type."""
        ...

    def GetStandardValues(self, context: System.ComponentModel.ITypeDescriptorContext) -> System.ComponentModel.TypeConverter.StandardValuesCollection:
        """Gets a collection of standard values for the data type this validator is designed for."""
        ...

    def GetStandardValuesExclusive(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """
        Gets a value indicating whether the list of standard values returned from
        System.ComponentModel.TypeListConverter.GetStandardValues is an exclusive list.
        """
        ...

    def GetStandardValuesSupported(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """
        Gets a value indicating whether this object supports a standard set of values that can be
        picked from a list using the specified context.
        """
        ...


class BindingDirection(System.Enum):
    """Specifies whether the template can be bound one-way or two-way."""

    OneWay = 0
    """The template can only accept property values. Used with a generic ITemplate."""

    TwoWay = 1
    """The template can accept and expose property values. Used with an IBindableTemplate."""


class BindableAttribute(System.Attribute):
    """Specifies whether a property is appropriate to bind data to."""

    Yes: System.ComponentModel.BindableAttribute = ...
    """
    Specifies that a property is appropriate to bind data to. This
    static field is read-only.
    """

    No: System.ComponentModel.BindableAttribute = ...
    """
    Specifies that a property is not appropriate to bind data to.
    This static field is read-only.
    """

    Default: System.ComponentModel.BindableAttribute = ...
    """
    Specifies the default value for the System.ComponentModel.BindableAttribute, which
    is System.ComponentModel.BindableAttribute.No. This static field is
    read-only.
    """

    @property
    def Bindable(self) -> bool:
        """Gets a value indicating whether a property is appropriate to bind data to."""
        ...

    @property
    def Direction(self) -> int:
        """
        Gets a value indicating the direction(s) this property be bound to data.
        
        This property contains the int value of a member of the System.ComponentModel.BindingDirection enum.
        """
        ...

    @typing.overload
    def __init__(self, bindable: bool) -> None:
        """Initializes a new instance of the System.ComponentModel.BindableAttribute class."""
        ...

    @typing.overload
    def __init__(self, bindable: bool, direction: System.ComponentModel.BindingDirection) -> None:
        """Initializes a new instance of the System.ComponentModel.BindableAttribute class."""
        ...

    @typing.overload
    def __init__(self, flags: System.ComponentModel.BindableSupport) -> None:
        """Initializes a new instance of the System.ComponentModel.BindableAttribute class."""
        ...

    @typing.overload
    def __init__(self, flags: System.ComponentModel.BindableSupport, direction: System.ComponentModel.BindingDirection) -> None:
        """Initializes a new instance of the System.ComponentModel.BindableAttribute class."""
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        ...

    def IsDefaultAttribute(self) -> bool:
        ...


class Int16Converter(System.ComponentModel.BaseNumberConverter):
    """
    Provides a type converter to convert 16-bit signed integer objects to and
    from various other representations.
    """

    @property
    def TargetType(self) -> typing.Type:
        """The Type this converter is targeting (e.g. Int16, UInt32, etc.)"""
        ...


class UInt16Converter(System.ComponentModel.BaseNumberConverter):
    """
    Provides a type converter to convert 16-bit unsigned integer objects to and
    from various other representations.
    """

    @property
    def TargetType(self) -> typing.Type:
        """The Type this converter is targeting (e.g. Int16, UInt32, etc.)"""
        ...


class DefaultPropertyAttribute(System.Attribute):
    """Specifies the default property for a component."""

    @property
    def Name(self) -> str:
        """
        Gets the name of the default property for the component this attribute is
        bound to.
        """
        ...

    Default: System.ComponentModel.DefaultPropertyAttribute = ...
    """
    Specifies the default value for the System.ComponentModel.DefaultPropertyAttribute, which is null. This
    static field is read-only.
    """

    def __init__(self, name: str) -> None:
        """Initializes a new instance of the System.ComponentModel.DefaultPropertyAttribute class."""
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        ...


class IComNativeDescriptorHandler(metaclass=abc.ABCMeta):
    """
    Top level mapping layer between a COM object and TypeDescriptor.
    
    This interface has been deprecated. Add a TypeDescriptionProvider to handle type TypeDescriptor.ComObjectType instead. https://go.microsoft.com/fwlink/?linkid=14202
    """

    def GetAttributes(self, component: typing.Any) -> System.ComponentModel.AttributeCollection:
        ...

    def GetClassName(self, component: typing.Any) -> str:
        ...

    def GetConverter(self, component: typing.Any) -> System.ComponentModel.TypeConverter:
        ...

    def GetDefaultEvent(self, component: typing.Any) -> System.ComponentModel.EventDescriptor:
        ...

    def GetDefaultProperty(self, component: typing.Any) -> System.ComponentModel.PropertyDescriptor:
        ...

    def GetEditor(self, component: typing.Any, baseEditorType: typing.Type) -> System.Object:
        ...

    @typing.overload
    def GetEvents(self, component: typing.Any) -> System.ComponentModel.EventDescriptorCollection:
        ...

    @typing.overload
    def GetEvents(self, component: typing.Any, attributes: typing.List[System.Attribute]) -> System.ComponentModel.EventDescriptorCollection:
        ...

    def GetName(self, component: typing.Any) -> str:
        ...

    def GetProperties(self, component: typing.Any, attributes: typing.List[System.Attribute]) -> System.ComponentModel.PropertyDescriptorCollection:
        ...

    @typing.overload
    def GetPropertyValue(self, component: typing.Any, propertyName: str, success: bool) -> System.Object:
        ...

    @typing.overload
    def GetPropertyValue(self, component: typing.Any, dispid: int, success: bool) -> System.Object:
        ...


class LicenseUsageMode(System.Enum):
    """Specifies when the license can be used."""

    Runtime = 0
    """Used during runtime."""

    Designtime = 1
    """Used during design time by a visual designer or the compiler."""


class Int64Converter(System.ComponentModel.BaseNumberConverter):
    """
    Provides a type converter to convert 64-bit signed integer objects to and
    from various other representations.
    """

    @property
    def TargetType(self) -> typing.Type:
        """The Type this converter is targeting (e.g. Int16, UInt32, etc.)"""
        ...


class CharConverter(System.ComponentModel.TypeConverter):
    """
    Provides a type converter to convert Unicode character objects to and from various
    other representations.
    """

    def CanConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, sourceType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an object in the given
        source type to a Unicode character object using the specified context.
        """
        ...

    def ConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any) -> System.Object:
        """Converts the given object to a Unicode character object."""
        ...

    def ConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any, destinationType: typing.Type) -> System.Object:
        """Converts the given object to another type."""
        ...


class CollectionChangeAction(System.Enum):
    """Specifies how the collection is changed."""

    Add = 1
    """Specifies that an element is added to the collection."""

    Remove = 2
    """Specifies that an element is removed from the collection."""

    Refresh = 3
    """Specifies that the entire collection has changed."""


class CollectionChangeEventArgs(System.EventArgs):
    """Provides data for the CollectionChange  event."""

    @property
    def Action(self) -> int:
        """
        Gets an action that specifies how the collection changed.
        
        This property contains the int value of a member of the System.ComponentModel.CollectionChangeAction enum.
        """
        ...

    @property
    def Element(self) -> System.Object:
        """Gets the instance of the collection with the change."""
        ...

    def __init__(self, action: System.ComponentModel.CollectionChangeAction, element: typing.Any) -> None:
        """Initializes a new instance of the System.ComponentModel.CollectionChangeEventArgs class."""
        ...


class ToolboxItemAttribute(System.Attribute):
    """Specifies attributes for a toolbox item."""

    Default: System.ComponentModel.ToolboxItemAttribute = ...
    """Initializes a new instance of ToolboxItemAttribute and sets the type to"""

    # Cannot convert to Python: None: System.ComponentModel.ToolboxItemAttribute = ...
    """
    Initializes a new instance of ToolboxItemAttribute and sets the type to
    null.
    """

    @property
    def ToolboxItemType(self) -> typing.Type:
        """Gets the toolbox item's type."""
        ...

    @property
    def ToolboxItemTypeName(self) -> str:
        ...

    @typing.overload
    def __init__(self, defaultType: bool) -> None:
        """Initializes a new instance of ToolboxItemAttribute and specifies if default values should be used."""
        ...

    @typing.overload
    def __init__(self, toolboxItemTypeName: str) -> None:
        """Initializes a new instance of ToolboxItemAttribute and specifies the name of the type."""
        ...

    @typing.overload
    def __init__(self, toolboxItemType: typing.Type) -> None:
        """Initializes a new instance of ToolboxItemAttribute and specifies the type of the toolbox item."""
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        ...

    def IsDefaultAttribute(self) -> bool:
        """Gets whether the attribute is the default attribute."""
        ...


class WarningException(System.SystemException):
    """Specifies an exception that is handled as a warning instead of an error."""

    @property
    def HelpUrl(self) -> str:
        """Specifies the Help file associated with the warning. This field is read-only."""
        ...

    @property
    def HelpTopic(self) -> str:
        """Specifies the Help topic associated with the warning. This field is read-only."""
        ...

    @typing.overload
    def __init__(self) -> None:
        """
        Initializes a new instance of the System.ComponentModel.WarningException class with the last Win32 error
        that occurred.
        """
        ...

    @typing.overload
    def __init__(self, message: str) -> None:
        """
        Initializes a new instance of the System.ComponentModel.WarningException class with
        the specified message and no Help file.
        """
        ...

    @typing.overload
    def __init__(self, message: str, helpUrl: str) -> None:
        """
        Initializes a new instance of the System.ComponentModel.WarningException class with
        the specified message, and with access to the specified Help file.
        """
        ...

    @typing.overload
    def __init__(self, message: str, innerException: System.Exception) -> None:
        """
        Initializes a new instance of the Exception class with a specified error message and a
        reference to the inner exception that is the cause of this exception.
        FxCop CA1032: Multiple constructors are required to correctly implement a custom exception.
        """
        ...

    @typing.overload
    def __init__(self, message: str, helpUrl: str, helpTopic: str) -> None:
        """
        Initializes a new instance of the System.ComponentModel.WarningException class with the
        specified message, and with access to the specified Help file and topic.
        """
        ...

    @typing.overload
    def __init__(self, info: System.Runtime.Serialization.SerializationInfo, context: System.Runtime.Serialization.StreamingContext) -> None:
        """
        Need this constructor since Exception implements ISerializable.
        
        This method is protected.
        """
        ...

    def GetObjectData(self, info: System.Runtime.Serialization.SerializationInfo, context: System.Runtime.Serialization.StreamingContext) -> None:
        ...


class MaskedTextResultHint(System.Enum):
    """Enum defining hints about the reason of the result of a particular operation."""

    Unknown = 0

    CharacterEscaped = 1

    NoEffect = 2

    SideEffect = 3

    Success = 4

    AsciiCharacterExpected = -1

    AlphanumericCharacterExpected = -2

    DigitExpected = -3

    LetterExpected = -4

    SignedDigitExpected = -5

    InvalidInput = -51

    PromptCharNotAllowed = -52

    UnavailableEditPosition = -53

    NonEditPosition = -54

    PositionOutOfRange = -55


class MaskedTextProvider(System.Object, System.ICloneable):
    """
    Provides functionality for formatting a test string against a mask string.
    MaskedTextProvider is stateful, it keeps information about the input characters so
    multiple call to Add/Remove will work in the same buffer.
    Most of the operations are performed on a virtual string containing the input characters as opposed
    to the test string itself, since mask literals cannot be modified (i.e: replacing on a literal position
    will actually replace on the nearest edit position forward).
    """

    @property
    def AllowPromptAsInput(self) -> bool:
        ...

    @property
    def AssignedEditPositionCount(self) -> int:
        """Retrieves the number of editable characters that have been set."""
        ...

    @AssignedEditPositionCount.setter
    def AssignedEditPositionCount(self, value: int):
        """Retrieves the number of editable characters that have been set."""
        ...

    @property
    def AvailableEditPositionCount(self) -> int:
        """Retrieves the number of editable characters that have been set."""
        ...

    @property
    def Culture(self) -> System.Globalization.CultureInfo:
        """The culture that determines the value of the localizable mask language separators and placeholders."""
        ...

    DefaultPasswordChar: str
    """The system password char."""

    @property
    def EditPositionCount(self) -> int:
        """The number of editable positions in the test string."""
        ...

    @property
    def EditPositions(self) -> System.Collections.IEnumerator:
        """Returns a new IEnumerator object containing the editable positions in the test string."""
        ...

    @property
    def IncludeLiterals(self) -> bool:
        """Specifies whether the formatted string should include literals."""
        ...

    @IncludeLiterals.setter
    def IncludeLiterals(self, value: bool):
        """Specifies whether the formatted string should include literals."""
        ...

    @property
    def IncludePrompt(self) -> bool:
        """
        Specifies whether or not the prompt character should be included in the formatted text when there are
        character slots available in the mask.
        """
        ...

    @IncludePrompt.setter
    def IncludePrompt(self, value: bool):
        """
        Specifies whether or not the prompt character should be included in the formatted text when there are
        character slots available in the mask.
        """
        ...

    @property
    def AsciiOnly(self) -> bool:
        """Specifies whether only ASCII characters are accepted as valid input."""
        ...

    @property
    def IsPassword(self) -> bool:
        """Specifies whether the user text is to be rendered as password characters."""
        ...

    @IsPassword.setter
    def IsPassword(self, value: bool):
        """Specifies whether the user text is to be rendered as password characters."""
        ...

    InvalidIndex: int
    """A negative value representing an index outside the test string."""

    @property
    def LastAssignedPosition(self) -> int:
        """
        The last edit position (relative to the origin not to time) in the test string where
        an input character has been placed. If no position has been assigned, InvalidIndex is returned.
        """
        ...

    @property
    def Length(self) -> int:
        """Specifies the length of the test string."""
        ...

    @property
    def Mask(self) -> str:
        """The mask to be applied to the test string."""
        ...

    @property
    def MaskCompleted(self) -> bool:
        """Specifies whether all required inputs have been provided into the mask successfully."""
        ...

    @property
    def MaskFull(self) -> bool:
        """Specifies whether all inputs (required and optional) have been provided into the mask successfully."""
        ...

    @property
    def PasswordChar(self) -> str:
        """
        Specifies the character to be used in the formatted string in place of editable characters.
        Use the null character '\\0' to reset this property.
        """
        ...

    @PasswordChar.setter
    def PasswordChar(self, value: str):
        """
        Specifies the character to be used in the formatted string in place of editable characters.
        Use the null character '\\0' to reset this property.
        """
        ...

    @property
    def PromptChar(self) -> str:
        """Specifies the prompt character to be used in the formatted string for unsupplied characters."""
        ...

    @PromptChar.setter
    def PromptChar(self, value: str):
        """Specifies the prompt character to be used in the formatted string for unsupplied characters."""
        ...

    @property
    def ResetOnPrompt(self) -> bool:
        """
        Specifies whether to reset and skip the current position if editable, when the input character has
        the same value as the prompt.
        
        This is useful when assigning text that was saved including the prompt; in this case
        we don't want to take the prompt character as valid input but don't want to fail the test either.
        """
        ...

    @ResetOnPrompt.setter
    def ResetOnPrompt(self, value: bool):
        """
        Specifies whether to reset and skip the current position if editable, when the input character has
        the same value as the prompt.
        
        This is useful when assigning text that was saved including the prompt; in this case
        we don't want to take the prompt character as valid input but don't want to fail the test either.
        """
        ...

    @property
    def ResetOnSpace(self) -> bool:
        """
        Specifies whether to reset and skip the current position if editable, when the input is the space character.
        
        This is useful when assigning text that was saved excluding the prompt (prompt replaced with spaces);
        in this case we don't want to take the space but instead, reset the position (or just skip it) so the
        next input character gets positioned correctly.
        """
        ...

    @ResetOnSpace.setter
    def ResetOnSpace(self, value: bool):
        """
        Specifies whether to reset and skip the current position if editable, when the input is the space character.
        
        This is useful when assigning text that was saved excluding the prompt (prompt replaced with spaces);
        in this case we don't want to take the space but instead, reset the position (or just skip it) so the
        next input character gets positioned correctly.
        """
        ...

    @property
    def SkipLiterals(self) -> bool:
        """
        Specifies whether to skip the current position if non-editable and the input character has the same
        value as the literal at that position.
        
        This is useful for round-tripping the text when saved with literals; when assigned back we don't want
        to treat literals as input.
        """
        ...

    @SkipLiterals.setter
    def SkipLiterals(self, value: bool):
        """
        Specifies whether to skip the current position if non-editable and the input character has the same
        value as the literal at that position.
        
        This is useful for round-tripping the text when saved with literals; when assigned back we don't want
        to treat literals as input.
        """
        ...

    def __getitem__(self, index: int) -> str:
        """Indexer."""
        ...

    @typing.overload
    def __init__(self, mask: str) -> None:
        ...

    @typing.overload
    def __init__(self, mask: str, restrictToAscii: bool) -> None:
        """
        Creates a MaskedTextProvider object from the specified mask.
        'restrictToAscii' specifies whether the input characters should be restricted to ASCII characters only.
        """
        ...

    @typing.overload
    def __init__(self, mask: str, culture: System.Globalization.CultureInfo) -> None:
        """
        Creates a MaskedTextProvider object from the specified mask.
        'culture' is used to set the separator characters to the corresponding locale character; if null, the current
             culture is used.
        """
        ...

    @typing.overload
    def __init__(self, mask: str, culture: System.Globalization.CultureInfo, restrictToAscii: bool) -> None:
        """
        Creates a MaskedTextProvider object from the specified mask.
        'culture' is used to set the separator characters to the corresponding locale character; if null, the current
             culture is used.
        'restrictToAscii' specifies whether the input characters should be restricted to ASCII characters only.
        """
        ...

    @typing.overload
    def __init__(self, mask: str, passwordChar: str, allowPromptAsInput: bool) -> None:
        """
        Creates a MaskedTextProvider object from the specified mask .
        'passwordChar' specifies the character to be used in the password string.
        'allowPromptAsInput' specifies whether the prompt character should be accepted as a valid input or not.
        """
        ...

    @typing.overload
    def __init__(self, mask: str, culture: System.Globalization.CultureInfo, passwordChar: str, allowPromptAsInput: bool) -> None:
        """
        Creates a MaskedTextProvider object from the specified mask .
        'passwordChar' specifies the character to be used in the password string.
        'allowPromptAsInput' specifies whether the prompt character should be accepted as a valid input or not.
        """
        ...

    @typing.overload
    def __init__(self, mask: str, culture: System.Globalization.CultureInfo, allowPromptAsInput: bool, promptChar: str, passwordChar: str, restrictToAscii: bool) -> None:
        """
        Creates a MaskedTextProvider object from the specified mask.
        'culture' is used to set the separator characters to the corresponding locale character; if null, the current
             culture is used.
        'allowPromptAsInput' specifies whether the prompt character should be accepted as a valid input or not.
        'promptChar' specifies the character to be used for the prompt.
        'passwordChar' specifies the character to be used in the password string.
        'restrictToAscii' specifies whether the input characters should be restricted to ASCII characters only.
        """
        ...

    @typing.overload
    def Add(self, input: str) -> bool:
        ...

    @typing.overload
    def Add(self, input: str, testPosition: typing.Optional[int], resultHint: typing.Optional[System.ComponentModel.MaskedTextResultHint]) -> typing.Union[bool, int, System.ComponentModel.MaskedTextResultHint]:
        """
        Attempts to add the specified charactert to the last unoccupied positions in the test string (append text to
        the virtual string).
        On exit the testPosition contains last position where the primary operation was actually performed if successful,
        otherwise the first position that made the test fail. This position is relative to the test string.
        The MaskedTextResultHint out param gives a hint about the operation result reason.
        Returns true on success, false otherwise.
        """
        ...

    @typing.overload
    def Add(self, input: str) -> bool:
        """
        Attempts to add the characters in the specified string to the last unoccupied positions in the test string
        (append text to the virtual string).
        Returns true on success, false otherwise.
        """
        ...

    @typing.overload
    def Add(self, input: str, testPosition: typing.Optional[int], resultHint: typing.Optional[System.ComponentModel.MaskedTextResultHint]) -> typing.Union[bool, int, System.ComponentModel.MaskedTextResultHint]:
        """
        Attempts to add the characters in the specified string to the last unoccupied positions in the test string
        (append text to the virtual string).
        On exit the testPosition contains last position where the primary operation was actually performed if successful,
        otherwise the first position that made the test fail. This position is relative to the test string.
        The MaskedTextResultHint out param gives a hint about the operation result reason.
        Returns true on success, false otherwise.
        """
        ...

    @typing.overload
    def Clear(self) -> None:
        """Resets the state of the test string edit chars. (Remove all characters from the virtual string)."""
        ...

    @typing.overload
    def Clear(self, resultHint: typing.Optional[System.ComponentModel.MaskedTextResultHint]) -> typing.Union[None, System.ComponentModel.MaskedTextResultHint]:
        """
        Resets the state of the test string edit chars. (Remove all characters from the virtual string).
        The MaskedTextResultHint out param gives more information about the operation result.
        """
        ...

    def Clone(self) -> System.Object:
        """
        Creates a 'clean' (no text assigned) MaskedTextProvider instance with the same property values as the
        current instance.
        Derived classes can override this method and call base.Clone to get proper cloning semantics but must
        implement the full-parameter constructor (passing parameters to the base constructor as well).
        """
        ...

    def FindAssignedEditPositionFrom(self, position: int, direction: bool) -> int:
        """
        Gets the position of the first edit char in the test string, the search starts from the specified
        position included.
        Returns InvalidIndex if it doesn't find one.
        """
        ...

    def FindAssignedEditPositionInRange(self, startPosition: int, endPosition: int, direction: bool) -> int:
        """
        Gets the position of the first edit char in the test string in the specified range, the search starts from
        the specified  position included.
        Returns InvalidIndex if it doesn't find one.
        """
        ...

    def FindEditPositionFrom(self, position: int, direction: bool) -> int:
        """
        Gets the position of the first assigned edit char in the test string, the search starts from the specified
        position included and in the direction specified (true == forward). The positions are relative to the test
        string.
        Returns InvalidIndex if it doesn't find one.
        """
        ...

    def FindEditPositionInRange(self, startPosition: int, endPosition: int, direction: bool) -> int:
        """
        Gets the position of the first assigned edit char in the test string; the search is performed in the specified
        positions range and in the specified direction.
        The positions are relative to the test string.
        Returns InvalidIndex if it doesn't find one.
        """
        ...

    def FindNonEditPositionFrom(self, position: int, direction: bool) -> int:
        """
        Gets the position of the first non edit position in the test string; the search is performed from the specified
        position and in the specified direction.
        The positions are relative to the test string.
        Returns InvalidIndex if it doesn't find one.
        """
        ...

    def FindNonEditPositionInRange(self, startPosition: int, endPosition: int, direction: bool) -> int:
        """
        Gets the position of the first non edit position in the test string; the search is performed in the specified
        positions range and in the specified direction.
        The positions are relative to the test string.
        Returns InvalidIndex if it doesn't find one.
        """
        ...

    def FindUnassignedEditPositionFrom(self, position: int, direction: bool) -> int:
        """
        Gets the position of the first edit char in the test string, the search starts from the specified
        position included.
        Returns InvalidIndex if it doesn't find one.
        """
        ...

    def FindUnassignedEditPositionInRange(self, startPosition: int, endPosition: int, direction: bool) -> int:
        """
        Gets the position of the first edit char in the test string in the specified range; the search starts
        from the specified position included.
        Returns InvalidIndex if it doesn't find one.
        """
        ...

    @staticmethod
    def GetOperationResultFromHint(hint: System.ComponentModel.MaskedTextResultHint) -> bool:
        """Specifies whether the specified MaskedTextResultHint denotes success or not."""
        ...

    @typing.overload
    def InsertAt(self, input: str, position: int) -> bool:
        """
        Attempts to insert the specified character at the specified position in the test string.
        (Insert character in the virtual string).
        Returns true on success, false otherwise.
        """
        ...

    @typing.overload
    def InsertAt(self, input: str, position: int, testPosition: typing.Optional[int], resultHint: typing.Optional[System.ComponentModel.MaskedTextResultHint]) -> typing.Union[bool, int, System.ComponentModel.MaskedTextResultHint]:
        """
        Attempts to insert the specified character at the specified position in the test string, shifting characters
        at upper positions (if any) to make room for the input.
        On exit the testPosition contains last position where the primary operation was actually performed if successful,
        otherwise the first position that made the test fail. This position is relative to the test string.
        The MaskedTextResultHint out param gives more information about the operation result.
        Returns true on success, false otherwise.
        """
        ...

    @typing.overload
    def InsertAt(self, input: str, position: int) -> bool:
        """
        Attempts to insert the characters in the specified string in at the specified position in the test string.
        (Insert characters in the virtual string).
        Returns true on success, false otherwise.
        """
        ...

    @typing.overload
    def InsertAt(self, input: str, position: int, testPosition: typing.Optional[int], resultHint: typing.Optional[System.ComponentModel.MaskedTextResultHint]) -> typing.Union[bool, int, System.ComponentModel.MaskedTextResultHint]:
        """
        Attempts to insert the characters in the specified string in at the specified position in the test string,
        shifting characters at upper positions (if any) to make room for the input.
        On exit the testPosition contains last position where the primary operation was actually performed if successful,
        otherwise the first position that made the test fail. This position is relative to the test string.
        The MaskedTextResultHint out param gives more information about the operation result.
        Returns true on success, false otherwise.
        """
        ...

    def IsAvailablePosition(self, position: int) -> bool:
        """
        Checks whether the specified position is available for assignment. Returns false if it is assigned
        or it is not editable, true otherwise.
        """
        ...

    def IsEditPosition(self, position: int) -> bool:
        """Checks whether the specified position in the test string is editable."""
        ...

    @staticmethod
    def IsValidInputChar(c: str) -> bool:
        """Checks whether the specified character is a valid input char."""
        ...

    @staticmethod
    def IsValidMaskChar(c: str) -> bool:
        """Checks whether the specified character is a valid input char."""
        ...

    @staticmethod
    def IsValidPasswordChar(c: str) -> bool:
        """Checks whether the specified character is a valid password char."""
        ...

    @typing.overload
    def Remove(self) -> bool:
        """Removes the last character from the formatted string. (Remove last character in virtual string)."""
        ...

    @typing.overload
    def Remove(self, testPosition: typing.Optional[int], resultHint: typing.Optional[System.ComponentModel.MaskedTextResultHint]) -> typing.Union[bool, int, System.ComponentModel.MaskedTextResultHint]:
        """
        Removes the last character from the formatted string. (Remove last character in virtual string).
        On exit the out param contains the position where the operation was actually performed.
        This position is relative to the test string.
        The MaskedTextResultHint out param gives more information about the operation result.
        Returns true on success, false otherwise.
        """
        ...

    @typing.overload
    def RemoveAt(self, position: int) -> bool:
        """
        Removes the character from the formatted string at the specified position and shifts characters
        left.
        True if character shifting is successful.
        """
        ...

    @typing.overload
    def RemoveAt(self, startPosition: int, endPosition: int) -> bool:
        """
        Removes all characters in edit position from in the test string at the specified start and end positions
        and shifts any remaining characters left. (Remove characters from the virtual string).
        Returns true on success, false otherwise.
        """
        ...

    @typing.overload
    def RemoveAt(self, startPosition: int, endPosition: int, testPosition: typing.Optional[int], resultHint: typing.Optional[System.ComponentModel.MaskedTextResultHint]) -> typing.Union[bool, int, System.ComponentModel.MaskedTextResultHint]:
        """
        Removes all characters in edit position from in the test string at the specified start and end positions
        and shifts any remaining characters left.
        On exit the testPosition contains last position where the primary operation was actually performed if successful,
        otherwise the first position that made the test fail. This position is relative to the test string.
        The MaskedTextResultHint out param gives more information about the operation result.
        Returns true on success, false otherwise.
        """
        ...

    @typing.overload
    def Replace(self, input: str, position: int) -> bool:
        """
        Replaces the first editable character in the test string from the specified position, with the specified
        character (Replace is performed in the virtual string), unless the character at the specified position
        is to be escaped.
        Returns true on success, false otherwise.
        """
        ...

    @typing.overload
    def Replace(self, input: str, position: int, testPosition: typing.Optional[int], resultHint: typing.Optional[System.ComponentModel.MaskedTextResultHint]) -> typing.Union[bool, int, System.ComponentModel.MaskedTextResultHint]:
        """
        Replaces the first editable character in the test string from the specified position, with the specified
        character, unless the character at the specified position is to be escaped.
        On exit the testPosition contains last position where the primary operation was actually performed if successful,
        otherwise the first position that made the test fail. This position is relative to the test string.
        The MaskedTextResultHint out param gives more information about the operation result.
        Returns true on success, false otherwise.
        """
        ...

    @typing.overload
    def Replace(self, input: str, startPosition: int, endPosition: int, testPosition: typing.Optional[int], resultHint: typing.Optional[System.ComponentModel.MaskedTextResultHint]) -> typing.Union[bool, int, System.ComponentModel.MaskedTextResultHint]:
        """
        Replaces the first editable character in the test string from the specified position, with the specified
        character and removes any remaining characters in the range unless the character at the specified position
        is to be escaped.
        If specified range covers more than one assigned edit character, shift-left is performed after replacing
        the first character. This is useful when in an edit box the user selects text and types a character to replace it.
        On exit the testPosition contains last position where the primary operation was actually performed if successful,
        otherwise the first position that made the test fail. This position is relative to the test string.
        The MaskedTextResultHint out param gives more information about the operation result.
        Returns true on success, false otherwise.
        """
        ...

    @typing.overload
    def Replace(self, input: str, position: int) -> bool:
        """
        Replaces the character at the first edit position from the one specified with the first character in the input;
        the rest of the characters in the input will be placed in the test string according to the InsertMode (insert/replace).
        (Replace is performed in the virtual text).
        Returns true on success, false otherwise.
        """
        ...

    @typing.overload
    def Replace(self, input: str, position: int, testPosition: typing.Optional[int], resultHint: typing.Optional[System.ComponentModel.MaskedTextResultHint]) -> typing.Union[bool, int, System.ComponentModel.MaskedTextResultHint]:
        """
        Replaces the character at the first edit position from the one specified with the first character in the input;
        the rest of the characters in the input will be placed in the test string according to the InsertMode (insert/replace),
        shifting characters at upper positions (if any) to make room for the entire input.
        On exit the testPosition contains last position where the primary operation was actually performed if successful,
        otherwise the first position that made the test fail. This position is relative to the test string.
        The MaskedTextResultHint out param gives more information about the operation result.
        Returns true on success, false otherwise.
        """
        ...

    @typing.overload
    def Replace(self, input: str, startPosition: int, endPosition: int, testPosition: typing.Optional[int], resultHint: typing.Optional[System.ComponentModel.MaskedTextResultHint]) -> typing.Union[bool, int, System.ComponentModel.MaskedTextResultHint]:
        """
        Replaces the characters in the specified range with the characters in the input string and shifts
        characters appropriately (removing or inserting characters according to whether the input string is
        shorter or larger than the specified range.
        On exit the testPosition contains last position where the primary operation was actually performed if successful,
        otherwise the first position that made the test fail. This position is relative to the test string.
        The MaskedTextResultHint out param gives more information about the operation result.
        Returns true on success, false otherwise.
        """
        ...

    @typing.overload
    def Set(self, input: str) -> bool:
        """
        Sets the edit characters in the test string to the ones specified in the input string if all characters
        are valid.
        If passwordChar is assigned, it is rendered in the output string instead of the user-supplied values.
        """
        ...

    @typing.overload
    def Set(self, input: str, testPosition: typing.Optional[int], resultHint: typing.Optional[System.ComponentModel.MaskedTextResultHint]) -> typing.Union[bool, int, System.ComponentModel.MaskedTextResultHint]:
        """
        Sets the edit characters in the test string to the ones specified in the input string if all characters
        are valid.
        On exit the testPosition contains last position where the primary operation was actually performed if successful,
        otherwise the first position that made the test fail. This position is relative to the test string.
        The MaskedTextResultHint out param gives more information about the operation result.
        If passwordChar is assigned, it is rendered in the output string instead of the user-supplied values.
        """
        ...

    def ToDisplayString(self) -> str:
        """
        Returns a formatted string based on the mask, honoring only the PasswordChar property. prompt character
        and literals are always included. This is the text to be shown in a control when it has the focus.
        """
        ...

    @typing.overload
    def ToString(self) -> str:
        """
        Returns a formatted string based on the mask, honoring  IncludePrompt and IncludeLiterals but ignoring
        PasswordChar.
        """
        ...

    @typing.overload
    def ToString(self, ignorePasswordChar: bool) -> str:
        """
        Returns a formatted string based on the mask, honoring the IncludePrompt and IncludeLiterals properties,
        and PasswordChar depending on the value of the 'ignorePasswordChar' parameter.
        """
        ...

    @typing.overload
    def ToString(self, startPosition: int, length: int) -> str:
        """
        Returns a formatted string starting at the specified position and for the specified number of character,
        based on the mask, honoring IncludePrompt and IncludeLiterals but ignoring PasswordChar.
        Parameters are relative to the test string.
        """
        ...

    @typing.overload
    def ToString(self, ignorePasswordChar: bool, startPosition: int, length: int) -> str:
        """
        Returns a formatted string starting at the specified position and for the specified number of character,
        based on the mask, honoring the IncludePrompt, IncludeLiterals properties and PasswordChar depending on
        the 'ignorePasswordChar' parameter.
        Parameters are relative to the test string.
        """
        ...

    @typing.overload
    def ToString(self, includePrompt: bool, includeLiterals: bool) -> str:
        """
        Returns a formatted string based on the mask, ignoring the PasswordChar and according to the includePrompt
        and includeLiterals parameters.
        """
        ...

    @typing.overload
    def ToString(self, includePrompt: bool, includeLiterals: bool, startPosition: int, length: int) -> str:
        """
        Returns a formatted string starting at the specified position and for the specified number of character,
        based on the mask, according to the ignorePasswordChar, includePrompt and includeLiterals parameters.
        Parameters are relative to the test string.
        """
        ...

    @typing.overload
    def ToString(self, ignorePasswordChar: bool, includePrompt: bool, includeLiterals: bool, startPosition: int, length: int) -> str:
        """
        Returns a formatted string starting at the specified position and for the specified number of character,
        based on the mask, according to the ignorePasswordChar, includePrompt and includeLiterals parameters.
        Parameters are relative to the test string.
        """
        ...

    def VerifyChar(self, input: str, position: int, hint: typing.Optional[System.ComponentModel.MaskedTextResultHint]) -> typing.Union[bool, System.ComponentModel.MaskedTextResultHint]:
        """Tests whether the specified character would be set successfully at the specified position."""
        ...

    def VerifyEscapeChar(self, input: str, position: int) -> bool:
        """Tests whether the specified character would be escaped at the specified position."""
        ...

    @typing.overload
    def VerifyString(self, input: str) -> bool:
        """Verifies the test string against the mask."""
        ...

    @typing.overload
    def VerifyString(self, input: str, testPosition: typing.Optional[int], resultHint: typing.Optional[System.ComponentModel.MaskedTextResultHint]) -> typing.Union[bool, int, System.ComponentModel.MaskedTextResultHint]:
        """
        Verifies the test string against the mask.
        On exit the testPosition contains last position where the primary operation was actually performed if successful,
        otherwise the first position that made the test fail. This position is relative to the test string.
        The MaskedTextResultHint out param gives more information about the operation result.
        Returns true on success, false otherwise.
        """
        ...


class SettingsBindableAttribute(System.Attribute):
    """
    Use this attribute to specify typical properties on components that can be bound
    to application settings.
    """

    Yes: System.ComponentModel.SettingsBindableAttribute = ...
    """Specifies that a property is appropriate to bind settings to."""

    No: System.ComponentModel.SettingsBindableAttribute = ...
    """Specifies that a property is not appropriate to bind settings to."""

    @property
    def Bindable(self) -> bool:
        """Gets a value indicating whether a property is appropriate to bind settings to."""
        ...

    def __init__(self, bindable: bool) -> None:
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        ...


class UInt32Converter(System.ComponentModel.BaseNumberConverter):
    """
    Provides a type converter to convert 32-bit unsigned integer objects to and
    from various other representations.
    """

    @property
    def TargetType(self) -> typing.Type:
        """The Type this converter is targeting (e.g. Int16, UInt32, etc.)"""
        ...


class SingleConverter(System.ComponentModel.BaseNumberConverter):
    """
    Provides a type converter to convert single-precision, floating point number objects to and
    from various other representations.
    """

    @property
    def AllowHex(self) -> bool:
        """Determines whether this editor will attempt to convert hex (0x or #) strings"""
        ...

    @property
    def TargetType(self) -> typing.Type:
        """The Type this converter is targeting (e.g. Int16, UInt32, etc.)"""
        ...


class SByteConverter(System.ComponentModel.BaseNumberConverter):
    """
    Provides a type converter to convert 8-bit unsigned integer objects to and from
    various other representations.
    """

    @property
    def TargetType(self) -> typing.Type:
        """The Type this converter is targeting (e.g. Int16, UInt32, etc.)"""
        ...


class LicenseProvider(System.Object, metaclass=abc.ABCMeta):
    """Provides the abstract base class for implementing a System.ComponentModel.LicenseProvider."""

    def GetLicense(self, context: System.ComponentModel.LicenseContext, type: typing.Type, instance: typing.Any, allowExceptions: bool) -> System.ComponentModel.License:
        """
        When overridden in a derived class, gets a license for an or 
        of component.
        """
        ...


class LicFileLicenseProvider(System.ComponentModel.LicenseProvider):
    """
    Provides an implementation of a System.ComponentModel.LicenseProvider. The provider works in
    a similar fashion to Microsoft .NET Framework standard licensing module.
    """

    def GetKey(self, type: typing.Type) -> str:
        """
        Creates a key for the specified type.
        
        This method is protected.
        """
        ...

    def GetLicense(self, context: System.ComponentModel.LicenseContext, type: typing.Type, instance: typing.Any, allowExceptions: bool) -> System.ComponentModel.License:
        """Gets a license for the instance of the component and determines if it is valid."""
        ...

    def IsKeyValid(self, key: str, type: typing.Type) -> bool:
        """
        Determines if the key retrieved by the System.ComponentModel.LicFileLicenseProvider.GetLicense method is valid
        for the specified type.
        
        This method is protected.
        """
        ...


class StringConverter(System.ComponentModel.TypeConverter):
    """
    Provides a type converter to convert string objects to and from various other
    representations.
    """

    def CanConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, sourceType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an object in the
        given source type to a string using the specified context.
        """
        ...

    def ConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any) -> System.Object:
        """Converts the specified value object to a string object."""
        ...


class GuidConverter(System.ComponentModel.TypeConverter):
    """
    Provides a type converter to convert globally unique identifier objects to and from various
    other representations.
    """

    def CanConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, sourceType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an object in the given source
        type to a globally unique identifier object using the context.
        """
        ...

    def CanConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, destinationType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an object to
        the given destination type using the context.
        """
        ...

    def ConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any) -> System.Object:
        """Converts the given object to a globally unique identifier object."""
        ...

    def ConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any, destinationType: typing.Type) -> System.Object:
        """
        Converts the given object to another type. The most common types to convert
        are to and from a string object. The default implementation will make a call
        to ToString on the object if the object is valid and if the destination
        type is string. If this cannot convert to the destination type, this will
        throw a NotSupportedException.
        """
        ...


class DoubleConverter(System.ComponentModel.BaseNumberConverter):
    """
    Provides a type converter to convert double-precision, floating point number objects
    to and from various other representations.
    """

    @property
    def AllowHex(self) -> bool:
        """Determines whether this editor will attempt to convert hex (0x or #) strings"""
        ...

    @property
    def TargetType(self) -> typing.Type:
        """The Type this converter is targeting (e.g. Int16, UInt32, etc.)"""
        ...


class VersionConverter(System.ComponentModel.TypeConverter):
    """
    Provides a type converter to convert Version objects to and
          from various other representations.
    """

    def CanConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, sourceType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an object in the
              given source type to a Version.
        """
        ...

    def CanConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, destinationType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can
              convert an object to the given destination type using the context.
        """
        ...

    def ConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any) -> System.Object:
        """Converts the given object to a Version."""
        ...

    def ConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any, destinationType: typing.Type) -> System.Object:
        """
        Converts the given value object to
              the specified destination type using the specified context and arguments.
        """
        ...

    def IsValid(self, context: System.ComponentModel.ITypeDescriptorContext, value: typing.Any) -> bool:
        ...


class ComplexBindingPropertiesAttribute(System.Attribute):
    """Specifies the data source and data member properties for a component."""

    @property
    def DataSource(self) -> str:
        """
        Gets the name of the data source property for the component this attribute is
        bound to.
        """
        ...

    @property
    def DataMember(self) -> str:
        """
        Gets the name of the data member property for the component this attribute is
        bound to.
        """
        ...

    Default: System.ComponentModel.ComplexBindingPropertiesAttribute = ...
    """
    Specifies the default value for the System.ComponentModel.ComplexBindingPropertiesAttribute, which is null. This
    static field is read-only.
    """

    @typing.overload
    def __init__(self) -> None:
        """Initializes a new instance of the System.ComponentModel.ComplexBindingPropertiesAttribute class."""
        ...

    @typing.overload
    def __init__(self, dataSource: str) -> None:
        """Initializes a new instance of the System.ComponentModel.ComplexBindingPropertiesAttribute class."""
        ...

    @typing.overload
    def __init__(self, dataSource: str, dataMember: str) -> None:
        """Initializes a new instance of the System.ComponentModel.ComplexBindingPropertiesAttribute class."""
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        ...


class ToolboxItemFilterType(System.Enum):
    """Specifies the type of filter in a ToolboxItemFilterAttribute."""

    Allow = 0
    """
    Specifies that a toolbox item filter string may be allowed. Allowed is typically used to
    specify that you support the filter string, but don't care if it is accepted or rejected.
    """

    Custom = 1
    """
    Specifies that a toolbox item filter string will require custom processing. This is generally
    specified on the root designer class to indicate that the designer wishes to accept or reject
    a toolbox item through code. The designer must implement IToolboxUser's IsSupported method.
    """

    Prevent = 2
    """
    Specifies that a toolbox item filter string should be rejected. If a designer and a component
    class both have the filter string and one has a type of Prevent, the toolbox item will not
    be available.
    """

    Require = 3
    """
    Specifies that a toolbox item filter string must be present for a toolbox item to be enabled.
    A designer and component class must both have the filter string, and neither may have a filter
    type of Prevent.
    """


class ToolboxItemFilterAttribute(System.Attribute):
    """
    This attribute allows you to configure a filter that is used enable or disable toolbox items
    from being used on particular designers. For example, you may have a class of components
    that can only be used on a certain type of designer. You can configure a toolbox item
    filter to enforce that rule. For example, take a report designer that uses a component
    base class of ReportElement. You may want to make ReportElement toolbox items enabled only
    when a ReportDesigner is the active designer. To do this, you would add the following
    ToolboxItemFilter attributes to each class:
    
    [ToolboxItemFilter("MyReportFilterString", ToolboxItemFilterType.Require)]
    public class ReportElement : Component {}
    
    [ToolboxItemFilter("MyReportFilterString", ToolboxItemFilterType.Require)]
    public class ReportDesigner : Component {}
    
    These two filters specify that ReportElement toolbox items will only be
    enabled when a ReportDesigner is visible. By specifying a filter type of
    Require on the report designer class, this will disable any toolbox items
    that are not report elements. If the report designer specified a filter type
    of "Allow" instead of "Require", other components would be enabled when the
    report designer was active. ReportElements would still be disabled when
    other designers were active, however, because ReportElement requires designers
    to have the given filter string.
    
    Toolbox item filtering is a useful way to restrict toolbox item visibility to
    cases where it is appropriate. This can help to avoid confusion for users, but
    you should use caution not to make items unusually restrictive. If you have a
    general purpose component, for example, you should allow the component to appear
    on any designer.
    
    The ASP.NET and Windows Forms designers both use filter attributes to prevent
    each other's components from being enabled. This is a useful restriction because,
    since each has several duplicate class names, it may be confusing to users and
    they may not know which controls to choose.
    """

    @property
    def FilterString(self) -> str:
        """
        Retrieves the filter string for this attribute. The filter string is a user-defined string that
        is used to identify matching attributes.
        """
        ...

    @property
    def FilterType(self) -> int:
        """
        Retrieves the filter type for this attribute. The filter type determines how the filter string should
        be applied.
        
        This property contains the int value of a member of the System.ComponentModel.ToolboxItemFilterType enum.
        """
        ...

    @property
    def TypeId(self) -> System.Object:
        """
        The unique identifier for this attribute. All ToolboxItemFilterAttributes with the same filter string
        are considered the same, so they return the same TypeId.
        """
        ...

    @typing.overload
    def __init__(self, filterString: str) -> None:
        """
        Initializes a new ToolboxItemFilterAttribute with the provide filter string and a filter type of
        "Allow".
        """
        ...

    @typing.overload
    def __init__(self, filterString: str, filterType: System.ComponentModel.ToolboxItemFilterType) -> None:
        """Initializes a new ToolboxItemFilterAttribute with the provide filter string and filter type."""
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        ...

    def Match(self, obj: typing.Any) -> bool:
        ...

    def ToString(self) -> str:
        ...


class ByteConverter(System.ComponentModel.BaseNumberConverter):
    """
    Provides a type converter to convert 8-bit unsigned integer objects
    to and from various other representations.
    """

    @property
    def TargetType(self) -> typing.Type:
        """The Type this converter is targeting (e.g. Int16, UInt32, etc.)"""
        ...


class EnumConverter(System.ComponentModel.TypeConverter):
    """
    Provides a type converter to convert System.Enum objects to and
    from various other representations
    """

    @property
    def EnumType(self) -> typing.Type:
        """This property is protected."""
        ...

    @property
    def Values(self) -> System.ComponentModel.TypeConverter.StandardValuesCollection:
        """This property is protected."""
        ...

    @Values.setter
    def Values(self, value: System.ComponentModel.TypeConverter.StandardValuesCollection):
        """This property is protected."""
        ...

    @property
    def Comparer(self) -> System.Collections.IComparer:
        """
        Gets an System.Collections.IComparer interface that can
        be used to sort the values of the enumerator.
        
        This property is protected.
        """
        ...

    def __init__(self, type: typing.Type) -> None:
        """
        Initializes a new instance of the System.ComponentModel.EnumConverter class for the given
        type.
        """
        ...

    def CanConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, sourceType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an object in the given
        source type to an enumeration object using the specified context.
        """
        ...

    def CanConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, destinationType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an object to the
        given destination type using the context.
        """
        ...

    def ConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any) -> System.Object:
        """Converts the specified value object to an enumeration object."""
        ...

    def ConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any, destinationType: typing.Type) -> System.Object:
        """Converts the given value object to the specified destination type."""
        ...

    def GetStandardValues(self, context: System.ComponentModel.ITypeDescriptorContext) -> System.ComponentModel.TypeConverter.StandardValuesCollection:
        """
        Gets a collection of standard values for the data type this validator is
        designed for.
        """
        ...

    def GetStandardValuesExclusive(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """
        Gets a value indicating whether the list of standard values returned from
        System.ComponentModel.TypeConverter.GetStandardValues()
        is an exclusive list using the specified context.
        """
        ...

    def GetStandardValuesSupported(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """
        Gets a value indicating whether this object supports a standard set of values
        that can be picked from a list using the specified context.
        """
        ...

    def IsValid(self, context: System.ComponentModel.ITypeDescriptorContext, value: typing.Any) -> bool:
        """Gets a value indicating whether the given object value is valid for this type."""
        ...


class AmbientValueAttribute(System.Attribute):
    """
    Specifies the ambient value for a property. The ambient value is the value you
    can set into a property to make it inherit its ambient.
    """

    @property
    def Value(self) -> System.Object:
        """Gets the ambient value of the property this attribute is bound to."""
        ...

    @typing.overload
    def __init__(self, type: typing.Type, value: str) -> None:
        """
        Initializes a new instance of the System.ComponentModel.AmbientValueAttribute class, converting the
        specified value to the specified type, and using the U.S. English culture as the
        translation context.
        """
        ...

    @typing.overload
    def __init__(self, value: str) -> None:
        """
        Initializes a new instance of the System.ComponentModel.AmbientValueAttribute class using a Unicode
        character.
        """
        ...

    @typing.overload
    def __init__(self, value: int) -> None:
        """
        Initializes a new instance of the System.ComponentModel.AmbientValueAttribute class using an 8-bit unsigned
        integer.
        """
        ...

    @typing.overload
    def __init__(self, value: int) -> None:
        """
        Initializes a new instance of the System.ComponentModel.AmbientValueAttribute class using a 16-bit signed
        integer.
        """
        ...

    @typing.overload
    def __init__(self, value: int) -> None:
        """
        Initializes a new instance of the System.ComponentModel.AmbientValueAttribute class using a 32-bit signed
        integer.
        """
        ...

    @typing.overload
    def __init__(self, value: int) -> None:
        """
        Initializes a new instance of the System.ComponentModel.AmbientValueAttribute class using a 64-bit signed
        integer.
        """
        ...

    @typing.overload
    def __init__(self, value: float) -> None:
        """
        Initializes a new instance of the System.ComponentModel.AmbientValueAttribute class using a
        single-precision floating point number.
        """
        ...

    @typing.overload
    def __init__(self, value: float) -> None:
        """
        Initializes a new instance of the System.ComponentModel.AmbientValueAttribute class using a
        double-precision floating point number.
        """
        ...

    @typing.overload
    def __init__(self, value: bool) -> None:
        """
        Initializes a new instance of the System.ComponentModel.AmbientValueAttribute class using a bool
        value.
        """
        ...

    @typing.overload
    def __init__(self, value: str) -> None:
        """Initializes a new instance of the System.ComponentModel.AmbientValueAttribute class using a string."""
        ...

    @typing.overload
    def __init__(self, value: typing.Any) -> None:
        """
        Initializes a new instance of the System.ComponentModel.AmbientValueAttribute
        class.
        """
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        ...


class LookupBindingPropertiesAttribute(System.Attribute):
    """Specifies the data source and data member properties for a component."""

    @property
    def DataSource(self) -> str:
        """
        Gets the name of the data source property for the component this attribute is
        bound to.
        """
        ...

    @property
    def DisplayMember(self) -> str:
        """
        Gets the name of the display member property for the component this attribute is
        bound to.
        """
        ...

    @property
    def ValueMember(self) -> str:
        """
        Gets the name of the value member property for the component this attribute is
        bound to.
        """
        ...

    @property
    def LookupMember(self) -> str:
        """
        Gets the name of the  member property for the component this attribute is
        bound to.
        """
        ...

    Default: System.ComponentModel.LookupBindingPropertiesAttribute = ...
    """
    Specifies the default value for the System.ComponentModel.LookupBindingPropertiesAttribute, which is null. This
    static field is read-only.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        Initializes a new instance of
        the System.ComponentModel.LookupBindingPropertiesAttribute class.
        """
        ...

    @typing.overload
    def __init__(self, dataSource: str, displayMember: str, valueMember: str, lookupMember: str) -> None:
        """
        Initializes a new instance of
        the System.ComponentModel.LookupBindingPropertiesAttribute class.
        """
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        ...


class RecommendedAsConfigurableAttribute(System.Attribute):
    """
    Specifies that the property can be used as an application setting.
    
    Use System.ComponentModel.SettingsBindableAttribute instead to work with the new settings model.
    """

    @property
    def RecommendedAsConfigurable(self) -> bool:
        """
        Gets a value indicating whether the property this
        attribute is bound to can be used as an application setting.
        """
        ...

    No: System.ComponentModel.RecommendedAsConfigurableAttribute = ...
    """
    Specifies that a property cannot be used as an application setting. This
    static field is read-only.
    """

    Yes: System.ComponentModel.RecommendedAsConfigurableAttribute = ...
    """
    Specifies
    that a property can be used as an application setting. This static field is read-only.
    """

    Default: System.ComponentModel.RecommendedAsConfigurableAttribute = ...
    """
    Specifies the default value for the System.ComponentModel.RecommendedAsConfigurableAttribute, which is System.ComponentModel.RecommendedAsConfigurableAttribute.No. This static field is
    read-only.
    """

    def __init__(self, recommendedAsConfigurable: bool) -> None:
        """
        Initializes a new instance of
        the System.ComponentModel.RecommendedAsConfigurableAttribute class.
        """
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        """Returns the hashcode for this object."""
        ...

    def IsDefaultAttribute(self) -> bool:
        ...


class InheritanceLevel(System.Enum):
    """Specifies numeric IDs for different inheritance levels."""

    Inherited = 1
    """Indicates that the object is inherited."""

    InheritedReadOnly = 2
    """Indicates that the object is inherited, but has read-only access."""

    NotInherited = 3
    """Indicates that the object is not inherited."""


class InheritanceAttribute(System.Attribute):
    """
    Marks instances of objects that are inherited from their base class. This
    class cannot be inherited.
    """

    Inherited: System.ComponentModel.InheritanceAttribute = ...
    """
    Specifies that the component is inherited. This field is
    read-only.
    """

    InheritedReadOnly: System.ComponentModel.InheritanceAttribute = ...
    """
    Specifies that
    the component is inherited and is read-only. This field is
    read-only.
    """

    NotInherited: System.ComponentModel.InheritanceAttribute = ...
    """
    Specifies that the component is not inherited. This field is
    read-only.
    """

    Default: System.ComponentModel.InheritanceAttribute = ...
    """
    Specifies the default value for
    the InheritanceAttribute as NotInherited.
    """

    @property
    def InheritanceLevel(self) -> int:
        """
        Gets or sets
        the current inheritance level stored in this attribute.
        
        This property contains the int value of a member of the System.ComponentModel.InheritanceLevel enum.
        """
        ...

    @typing.overload
    def __init__(self) -> None:
        """
        Initializes a new instance of the System.ComponentModel.Design.InheritanceAttribute
        class.
        """
        ...

    @typing.overload
    def __init__(self, inheritanceLevel: System.ComponentModel.InheritanceLevel) -> None:
        """
        Initializes a new instance of the System.ComponentModel.Design.InheritanceAttribute class
        with the specified inheritance
        level.
        """
        ...

    def Equals(self, value: typing.Any) -> bool:
        """Override to test for equality."""
        ...

    def GetHashCode(self) -> int:
        """Returns the hashcode for this object."""
        ...

    def IsDefaultAttribute(self) -> bool:
        """Gets whether this attribute is the default."""
        ...

    def ToString(self) -> str:
        """Converts this attribute to a string."""
        ...


class RefreshEventArgs(System.EventArgs):
    """Provides data for the System.ComponentModel.TypeDescriptor.Refresh(object) event."""

    @property
    def ComponentChanged(self) -> System.Object:
        """Gets the component that has changed its properties, events, or extenders."""
        ...

    @property
    def TypeChanged(self) -> typing.Type:
        """Gets the type that has changed its properties, or events."""
        ...

    @typing.overload
    def __init__(self, componentChanged: typing.Any) -> None:
        """
        Initializes a new instance of the System.ComponentModel.RefreshEventArgs class with
        the component that has changed.
        """
        ...

    @typing.overload
    def __init__(self, typeChanged: typing.Type) -> None:
        """
        Initializes a new instance of the System.ComponentModel.RefreshEventArgs class with
        the type of component that has changed.
        """
        ...


class TypeDescriptor(System.Object):
    """
    Provides information about the properties and events for a component.
    This class cannot be inherited.
    """

    ReflectTypesDynamicallyAccessedMembers: System.Diagnostics.CodeAnalysis.DynamicallyAccessedMemberTypes = ...

    EditorRequiresUnreferencedCode: str = "Editors registered in TypeDescriptor.AddEditorTable may be trimmed."

    InterfaceType: typing.Type
    """
    This property returns a Type object that can be passed to the various
    AddProvider methods to define a type description provider for interface types.
    """

    MetadataVersion: int
    """This value increments each time someone refreshes or changes metadata."""

    Refreshed: _EventContainer[typing.Callable[[System.ComponentModel.RefreshEventArgs], None], None]
    """Occurs when Refreshed is raised for a component."""

    ComObjectType: typing.Type

    ComNativeDescriptorHandler: System.ComponentModel.IComNativeDescriptorHandler
    """This property has been deprecated. Use a type description provider to supply type information for COM types instead. https://go.microsoft.com/fwlink/?linkid=14202"""

    @staticmethod
    @typing.overload
    def AddAttributes(type: typing.Type, *attributes: System.Attribute) -> System.ComponentModel.TypeDescriptionProvider:
        """
        The AddAttributes method allows you to add class-level attributes for a
        type or an instance. This method simply implements a type description provider
        that merges the provided attributes with the attributes that already exist on
        the class. This is a short cut for such a behavior. Adding additional
        attributes is common need for applications using the Windows Forms property
        window. The return value form AddAttributes is the TypeDescriptionProvider
        that was used to add the attributes. This provider can later be passed to
        RemoveProvider if the added attributes are no longer needed.
        """
        ...

    @staticmethod
    @typing.overload
    def AddAttributes(instance: typing.Any, *attributes: System.Attribute) -> System.ComponentModel.TypeDescriptionProvider:
        """
        The AddAttributes method allows you to add class-level attributes for a
        type or an instance. This method simply implements a type description provider
        that merges the provided attributes with the attributes that already exist on
        the class. This is a short cut for such a behavior. Adding additional
        attributes is common need for applications using the Windows Forms property
        window. The return value form AddAttributes is the TypeDescriptionProvider
        that was used to add the attributes. This provider can later be passed to
        RemoveProvider if the added attributes are no longer needed.
        """
        ...

    @staticmethod
    def AddEditorTable(editorBaseType: typing.Type, table: System.Collections.Hashtable) -> None:
        """
        Adds an editor table for the given editor base type. Typically, editors are
        specified as metadata on an object. If no metadata for a requested editor
        base type can be found on an object, however, the TypeDescriptor will search
        an editor table for the editor type, if one can be found.
        """
        ...

    @staticmethod
    @typing.overload
    def AddProvider(provider: System.ComponentModel.TypeDescriptionProvider, type: typing.Type) -> None:
        """
        Adds a type description provider that will be called on to provide
        type and instance information for any object that is of, or a subtype
        of, the provided type. Type can be any type, including interfaces.
        For example, to provide custom type and instance information for all
        components, you would pass typeof(IComponent). Passing typeof(object)
        will cause the provider to be called to provide type information for
        all types.
        """
        ...

    @staticmethod
    @typing.overload
    def AddProvider(provider: System.ComponentModel.TypeDescriptionProvider, instance: typing.Any) -> None:
        """
        Adds a type description provider that will be called on to provide
        type information for a single object instance. A provider added
        using this method will never have its CreateInstance method called
        because the instance already exists. This method does not prevent
        the object from finalizing.
        """
        ...

    @staticmethod
    @typing.overload
    def AddProviderTransparent(provider: System.ComponentModel.TypeDescriptionProvider, type: typing.Type) -> None:
        """
        Adds a type description provider that will be called on to provide
        type and instance information for any object that is of, or a subtype
        of, the provided type. Type can be any type, including interfaces.
        For example, to provide custom type and instance information for all
        components, you would pass typeof(IComponent). Passing typeof(object)
        will cause the provider to be called to provide type information for
        all types.
        """
        ...

    @staticmethod
    @typing.overload
    def AddProviderTransparent(provider: System.ComponentModel.TypeDescriptionProvider, instance: typing.Any) -> None:
        """
        Adds a type description provider that will be called on to provide
        type information for a single object instance. A provider added
        using this method will never have its CreateInstance method called
        because the instance already exists. This method does not prevent
        the object from finalizing.
        """
        ...

    @staticmethod
    def CreateAssociation(primary: typing.Any, secondary: typing.Any) -> None:
        """
        The CreateAssocation method creates an association between two objects.
        Once an association is created, a designer or other filtering mechanism
        can add properties that route to either object into the primary object's
        property set. When a property invocation is made against the primary
        object, GetAssocation will be called to resolve the actual object
        instance that is related to its type parameter.
        """
        ...

    @staticmethod
    def CreateDesigner(component: System.ComponentModel.IComponent, designerBaseType: typing.Type) -> System.ComponentModel.Design.IDesigner:
        ...

    @staticmethod
    @typing.overload
    def CreateEvent(componentType: typing.Type, name: str, type: typing.Type, *attributes: System.Attribute) -> System.ComponentModel.EventDescriptor:
        """This dynamically binds an EventDescriptor to a type."""
        ...

    @staticmethod
    @typing.overload
    def CreateEvent(componentType: typing.Type, oldEventDescriptor: System.ComponentModel.EventDescriptor, *attributes: System.Attribute) -> System.ComponentModel.EventDescriptor:
        """
        This creates a new event descriptor identical to an existing event descriptor. The new event descriptor
        has the specified metadata attributes merged with the existing metadata attributes.
        """
        ...

    @staticmethod
    def CreateInstance(provider: typing.Any, objectType: typing.Type, argTypes: typing.List[typing.Type], args: typing.List[System.Object]) -> System.Object:
        """
        This method will search internal tables within TypeDescriptor for
        a TypeDescriptionProvider object that is associated with the given
        data type. If it finds one, it will delegate the call to that object.
        """
        ...

    @staticmethod
    @typing.overload
    def CreateProperty(componentType: typing.Type, name: str, type: typing.Type, *attributes: System.Attribute) -> System.ComponentModel.PropertyDescriptor:
        """This dynamically binds a PropertyDescriptor to a type."""
        ...

    @staticmethod
    @typing.overload
    def CreateProperty(componentType: typing.Type, oldPropertyDescriptor: System.ComponentModel.PropertyDescriptor, *attributes: System.Attribute) -> System.ComponentModel.PropertyDescriptor:
        """
        This creates a new property descriptor identical to an existing property descriptor. The new property descriptor
        has the specified metadata attributes merged with the existing metadata attributes.
        """
        ...

    @staticmethod
    def GetAssociation(type: typing.Type, primary: typing.Any) -> System.Object:
        """
        The GetAssociation method returns the correct object to invoke
        for the requested type. It never returns null.
        """
        ...

    @staticmethod
    @typing.overload
    def GetAttributes(componentType: typing.Type) -> System.ComponentModel.AttributeCollection:
        """Gets a collection of attributes for the specified type of component."""
        ...

    @staticmethod
    @typing.overload
    def GetAttributes(component: typing.Any) -> System.ComponentModel.AttributeCollection:
        """Gets a collection of attributes for the specified component."""
        ...

    @staticmethod
    @typing.overload
    def GetAttributes(component: typing.Any, noCustomTypeDesc: bool) -> System.ComponentModel.AttributeCollection:
        """Gets a collection of attributes for the specified component."""
        ...

    @staticmethod
    @typing.overload
    def GetClassName(component: typing.Any) -> str:
        """Gets the name of the class for the specified component."""
        ...

    @staticmethod
    @typing.overload
    def GetClassName(component: typing.Any, noCustomTypeDesc: bool) -> str:
        """Gets the name of the class for the specified component."""
        ...

    @staticmethod
    @typing.overload
    def GetClassName(componentType: typing.Type) -> str:
        """Gets the name of the class for the specified type."""
        ...

    @staticmethod
    @typing.overload
    def GetComponentName(component: typing.Any) -> str:
        """The name of the class for the specified component."""
        ...

    @staticmethod
    @typing.overload
    def GetComponentName(component: typing.Any, noCustomTypeDesc: bool) -> str:
        """Gets the name of the class for the specified component."""
        ...

    @staticmethod
    @typing.overload
    def GetConverter(component: typing.Any) -> System.ComponentModel.TypeConverter:
        """Gets a type converter for the type of the specified component."""
        ...

    @staticmethod
    @typing.overload
    def GetConverter(component: typing.Any, noCustomTypeDesc: bool) -> System.ComponentModel.TypeConverter:
        """Gets a type converter for the type of the specified component."""
        ...

    @staticmethod
    @typing.overload
    def GetConverter(type: typing.Type) -> System.ComponentModel.TypeConverter:
        """Gets a type converter for the specified type."""
        ...

    @staticmethod
    @typing.overload
    def GetDefaultEvent(componentType: typing.Type) -> System.ComponentModel.EventDescriptor:
        """Gets the default event for the specified type of component."""
        ...

    @staticmethod
    @typing.overload
    def GetDefaultEvent(component: typing.Any) -> System.ComponentModel.EventDescriptor:
        """Gets the default event for the specified component."""
        ...

    @staticmethod
    @typing.overload
    def GetDefaultEvent(component: typing.Any, noCustomTypeDesc: bool) -> System.ComponentModel.EventDescriptor:
        """Gets the default event for a component."""
        ...

    @staticmethod
    @typing.overload
    def GetDefaultProperty(componentType: typing.Type) -> System.ComponentModel.PropertyDescriptor:
        """Gets the default property for the specified type of component."""
        ...

    @staticmethod
    @typing.overload
    def GetDefaultProperty(component: typing.Any) -> System.ComponentModel.PropertyDescriptor:
        """Gets the default property for the specified component."""
        ...

    @staticmethod
    @typing.overload
    def GetDefaultProperty(component: typing.Any, noCustomTypeDesc: bool) -> System.ComponentModel.PropertyDescriptor:
        """Gets the default property for the specified component."""
        ...

    @staticmethod
    @typing.overload
    def GetEditor(component: typing.Any, editorBaseType: typing.Type) -> System.Object:
        """
        Gets an editor with the specified base type for the
        specified component.
        """
        ...

    @staticmethod
    @typing.overload
    def GetEditor(component: typing.Any, editorBaseType: typing.Type, noCustomTypeDesc: bool) -> System.Object:
        """
        Gets an editor with the specified base type for the
        specified component.
        """
        ...

    @staticmethod
    @typing.overload
    def GetEditor(type: typing.Type, editorBaseType: typing.Type) -> System.Object:
        """Gets an editor with the specified base type for the specified type."""
        ...

    @staticmethod
    @typing.overload
    def GetEvents(componentType: typing.Type) -> System.ComponentModel.EventDescriptorCollection:
        """Gets a collection of events for a specified type of component."""
        ...

    @staticmethod
    @typing.overload
    def GetEvents(componentType: typing.Type, attributes: typing.List[System.Attribute]) -> System.ComponentModel.EventDescriptorCollection:
        """
        Gets a collection of events for a specified type of
        component using a specified array of attributes as a filter.
        """
        ...

    @staticmethod
    @typing.overload
    def GetEvents(component: typing.Any) -> System.ComponentModel.EventDescriptorCollection:
        """Gets a collection of events for a specified component."""
        ...

    @staticmethod
    @typing.overload
    def GetEvents(component: typing.Any, noCustomTypeDesc: bool) -> System.ComponentModel.EventDescriptorCollection:
        """Gets a collection of events for a specified component."""
        ...

    @staticmethod
    @typing.overload
    def GetEvents(component: typing.Any, attributes: typing.List[System.Attribute]) -> System.ComponentModel.EventDescriptorCollection:
        """
        Gets a collection of events for a specified component
        using a specified array of attributes as a filter.
        """
        ...

    @staticmethod
    @typing.overload
    def GetEvents(component: typing.Any, attributes: typing.List[System.Attribute], noCustomTypeDesc: bool) -> System.ComponentModel.EventDescriptorCollection:
        """
        Gets a collection of events for a specified component
        using a specified array of attributes as a filter.
        """
        ...

    @staticmethod
    def GetFullComponentName(component: typing.Any) -> str:
        """
        The name of the specified component, or null if the component has no name.
        In many cases this will return the same value as GetComponentName. If the
        component resides in a nested container or has other nested semantics, it may
        return a different fully qualified name.
        """
        ...

    @staticmethod
    @typing.overload
    def GetProperties(componentType: typing.Type) -> System.ComponentModel.PropertyDescriptorCollection:
        """Gets a collection of properties for a specified type of component."""
        ...

    @staticmethod
    @typing.overload
    def GetProperties(componentType: typing.Type, attributes: typing.List[System.Attribute]) -> System.ComponentModel.PropertyDescriptorCollection:
        """
        Gets a collection of properties for a specified type of
        component using a specified array of attributes as a filter.
        """
        ...

    @staticmethod
    @typing.overload
    def GetProperties(component: typing.Any) -> System.ComponentModel.PropertyDescriptorCollection:
        """Gets a collection of properties for a specified component."""
        ...

    @staticmethod
    @typing.overload
    def GetProperties(component: typing.Any, noCustomTypeDesc: bool) -> System.ComponentModel.PropertyDescriptorCollection:
        """Gets a collection of properties for a specified component."""
        ...

    @staticmethod
    @typing.overload
    def GetProperties(component: typing.Any, attributes: typing.List[System.Attribute]) -> System.ComponentModel.PropertyDescriptorCollection:
        """
        Gets a collection of properties for a specified
        component using a specified array of attributes
        as a filter.
        """
        ...

    @staticmethod
    @typing.overload
    def GetProperties(component: typing.Any, attributes: typing.List[System.Attribute], noCustomTypeDesc: bool) -> System.ComponentModel.PropertyDescriptorCollection:
        """
        Gets a collection of properties for a specified
        component using a specified array of attributes
        as a filter.
        """
        ...

    @staticmethod
    @typing.overload
    def GetProvider(type: typing.Type) -> System.ComponentModel.TypeDescriptionProvider:
        """
        The GetProvider method returns a type description provider for
        the given object or type. This will always return a type description
        provider. Even the default TypeDescriptor implementation is built on
        a TypeDescriptionProvider, and this will be returned unless there is
        another provider that someone else has added.
        """
        ...

    @staticmethod
    @typing.overload
    def GetProvider(instance: typing.Any) -> System.ComponentModel.TypeDescriptionProvider:
        """
        The GetProvider method returns a type description provider for
        the given object or type. This will always return a type description
        provider. Even the default TypeDescriptor implementation is built on
        a TypeDescriptionProvider, and this will be returned unless there is
        another provider that someone else has added.
        """
        ...

    @staticmethod
    @typing.overload
    def GetReflectionType(type: typing.Type) -> typing.Type:
        """Returns an Type instance that can be used to perform reflection."""
        ...

    @staticmethod
    @typing.overload
    def GetReflectionType(instance: typing.Any) -> typing.Type:
        """Returns an Type instance that can be used to perform reflection."""
        ...

    @staticmethod
    @typing.overload
    def Refresh(component: typing.Any) -> None:
        """
        Clears the properties and events for the specified
        component from the cache.
        """
        ...

    @staticmethod
    @typing.overload
    def Refresh(type: typing.Type) -> None:
        """
        Clears the properties and events for the specified type
        of component from the cache.
        """
        ...

    @staticmethod
    @typing.overload
    def Refresh(module: System.Reflection.Module) -> None:
        """
        Clears the properties and events for the specified
        module from the cache.
        """
        ...

    @staticmethod
    @typing.overload
    def Refresh(assembly: System.Reflection.Assembly) -> None:
        """
        Clears the properties and events for the specified
        assembly from the cache.
        """
        ...

    @staticmethod
    def RemoveAssociation(primary: typing.Any, secondary: typing.Any) -> None:
        """The RemoveAssociation method removes an association with an object."""
        ...

    @staticmethod
    def RemoveAssociations(primary: typing.Any) -> None:
        """The RemoveAssociations method removes all associations for a primary object."""
        ...

    @staticmethod
    @typing.overload
    def RemoveProvider(provider: System.ComponentModel.TypeDescriptionProvider, type: typing.Type) -> None:
        """
        The RemoveProvider method removes a previously added type
        description provider. Removing a provider causes a Refresh
        event to be raised for the object or type the provider is
        associated with.
        """
        ...

    @staticmethod
    @typing.overload
    def RemoveProvider(provider: System.ComponentModel.TypeDescriptionProvider, instance: typing.Any) -> None:
        """
        The RemoveProvider method removes a previously added type
        description provider. Removing a provider causes a Refresh
        event to be raised for the object or type the provider is
        associated with.
        """
        ...

    @staticmethod
    @typing.overload
    def RemoveProviderTransparent(provider: System.ComponentModel.TypeDescriptionProvider, type: typing.Type) -> None:
        """
        The RemoveProvider method removes a previously added type
        description provider. Removing a provider causes a Refresh
        event to be raised for the object or type the provider is
        associated with.
        """
        ...

    @staticmethod
    @typing.overload
    def RemoveProviderTransparent(provider: System.ComponentModel.TypeDescriptionProvider, instance: typing.Any) -> None:
        """
        The RemoveProvider method removes a previously added type
        description provider. Removing a provider causes a Refresh
        event to be raised for the object or type the provider is
        associated with.
        """
        ...

    @staticmethod
    def SortDescriptorArray(infos: System.Collections.IList) -> None:
        """Sorts descriptors by name of the descriptor."""
        ...


class BooleanConverter(System.ComponentModel.TypeConverter):
    """Provides a type converter to convert Boolean objects to and from various other representations."""

    def CanConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, sourceType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an object
        in the given source type to a Boolean object using the specified context.
        """
        ...

    def ConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any) -> System.Object:
        """
        Converts the given value
        object to a Boolean object.
        """
        ...

    def GetStandardValues(self, context: System.ComponentModel.ITypeDescriptorContext) -> System.ComponentModel.TypeConverter.StandardValuesCollection:
        """Gets a collection of standard values for the Boolean data type."""
        ...

    def GetStandardValuesExclusive(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """
        Gets a value indicating whether the list of standard values returned from
        System.ComponentModel.BooleanConverter.GetStandardValues is an exclusive list.
        """
        ...

    def GetStandardValuesSupported(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """
        Gets a value indicating whether this object supports a standard set of values that can
        be picked from a list.
        """
        ...


class RunInstallerAttribute(System.Attribute):
    """
    Specifies whether an installer should be invoked during
    installation of an assembly.
    """

    @property
    def RunInstaller(self) -> bool:
        """
        Gets a value indicating whether an installer should be
        invoked during installation of an assembly.
        """
        ...

    Yes: System.ComponentModel.RunInstallerAttribute = ...
    """
    Specifies that a
    component is visible in a visual designer. This static field is
    read-only.
    """

    No: System.ComponentModel.RunInstallerAttribute = ...
    """
    Specifies that a
    component
    is not visible in a visual designer. This static field is
    read-only.
    """

    Default: System.ComponentModel.RunInstallerAttribute = ...
    """
    Specifies the default visibility, which is System.ComponentModel.RunInstallerAttribute.No. This static field is
    read-only.
    """

    def __init__(self, runInstaller: bool) -> None:
        """
        Initializes a new instance of
        the System.ComponentModel.RunInstallerAttribute class.
        """
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        """Returns the hashcode for this object."""
        ...

    def IsDefaultAttribute(self) -> bool:
        ...


class PasswordPropertyTextAttribute(System.Attribute):
    """
    If this attribute is placed on a property or a type, its text representation in a property window
    will appear as dots or asterisks to indicate a password field. This indication in no way
    represents any type of encryption or security.
    """

    Yes: System.ComponentModel.PasswordPropertyTextAttribute = ...
    """
    Sets the System.ComponentModel.Design.PasswordPropertyText
    attribute by default to true.
    """

    No: System.ComponentModel.PasswordPropertyTextAttribute = ...
    """
    Sets the System.ComponentModel.Design.PasswordPropertyText
    attribute by default to false.
    """

    Default: System.ComponentModel.PasswordPropertyTextAttribute = ...
    """
    Sets the System.ComponentModel.Design.PasswordPropertyText
    attribute by default to false.
    """

    @property
    def Password(self) -> bool:
        """Gets a value indicating if the property this attribute is defined for should be shown as password text."""
        ...

    @typing.overload
    def __init__(self) -> None:
        """Creates a default PasswordPropertyTextAttribute."""
        ...

    @typing.overload
    def __init__(self, password: bool) -> None:
        """Creates a PasswordPropertyTextAttribute with the given password value."""
        ...

    def Equals(self, o: typing.Any) -> bool:
        """Overload for object equality"""
        ...

    def GetHashCode(self) -> int:
        """Returns the hashcode for this object."""
        ...

    def IsDefaultAttribute(self) -> bool:
        """Gets a value indicating whether this attribute is set to true by default."""
        ...


class MarshalByValueComponent(System.Object, System.ComponentModel.IComponent, IServiceProvider):
    """
    Provides the base implementation for System.ComponentModel.IComponent,
    which is the base class for all components in Win Forms.
    """

    @property
    def Disposed(self) -> _EventContainer[typing.Callable[[System.Object, System.EventArgs], None], None]:
        """Adds an event handler to listen to the Disposed event on the component."""
        ...

    @Disposed.setter
    def Disposed(self, value: _EventContainer[typing.Callable[[System.Object, System.EventArgs], None], None]):
        """Adds an event handler to listen to the Disposed event on the component."""
        ...

    @property
    def Events(self) -> System.ComponentModel.EventHandlerList:
        """
        Gets the list of event handlers that are attached to this component.
        
        This property is protected.
        """
        ...

    @property
    def Site(self) -> System.ComponentModel.ISite:
        """Gets or sets the site of the component."""
        ...

    @Site.setter
    def Site(self, value: System.ComponentModel.ISite):
        """Gets or sets the site of the component."""
        ...

    @property
    def Container(self) -> System.ComponentModel.IContainer:
        """Gets the container for the component."""
        ...

    @property
    def DesignMode(self) -> bool:
        """Gets a value indicating whether the component is currently in design mode."""
        ...

    def __init__(self) -> None:
        """Initializes a new instance of the System.ComponentModel.MarshalByValueComponent class."""
        ...

    @typing.overload
    def Dispose(self) -> None:
        """Disposes of the resources (other than memory) used by the component."""
        ...

    @typing.overload
    def Dispose(self, disposing: bool) -> None:
        """
        Disposes all the resources associated with this component.
        If disposing is false then you must never touch any other
        managed objects, as they may already be finalized. When
        in this state you should dispose any native resources
        that you have a reference to.
        
        
        When disposing is true then you should dispose all data
        and objects you have references to. The normal implementation
        of this method would look something like:
        
        
        public void Dispose() {
        Dispose(true);
        GC.SuppressFinalize(this);
        }
        
        protected virtual void Dispose(bool disposing) {
        if (disposing) {
          if (myobject != null) {
              myobject.Dispose();
              myobject = null;
          }
        }
        if (myhandle != IntPtr.Zero) {
          NativeMethods.Release(myhandle);
          myhandle = IntPtr.Zero;
        }
        }
        
        ~MyClass() {
        Dispose(false);
        }
        
        
        For base classes, you should never override the Finalizer (~Class in C#)
        or the Dispose method that takes no arguments, rather you should
        always override the Dispose method that takes a bool.
        
        
        protected override void Dispose(bool disposing) {
        if (disposing) {
          if (myobject != null) {
              myobject.Dispose();
              myobject = null;
          }
        }
        if (myhandle != IntPtr.Zero) {
          NativeMethods.Release(myhandle);
          myhandle = IntPtr.Zero;
        }
        base.Dispose(disposing);
        }
        
        This method is protected.
        """
        ...

    def GetService(self, service: typing.Type) -> System.Object:
        """Gets the implementer of the System.IServiceProvider."""
        ...

    def ToString(self) -> str:
        """
        Returns a string containing the name of the System.ComponentModel.Component , if any. This method should not be
        overridden. For
        internal use only.
        """
        ...


class ArrayConverter(System.ComponentModel.CollectionConverter):
    """
    Provides a type converter to convert System.Array
    objects to and from various other representations.
    """

    def ConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any, destinationType: typing.Type) -> System.Object:
        """Converts the given value object to the specified destination type."""
        ...

    def GetProperties(self, context: System.ComponentModel.ITypeDescriptorContext, value: typing.Any, attributes: typing.List[System.Attribute]) -> System.ComponentModel.PropertyDescriptorCollection:
        """Gets a collection of properties for the type of array specified by the value parameter."""
        ...

    def GetPropertiesSupported(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """Gets a value indicating whether this object supports properties."""
        ...


class IDataErrorInfo(metaclass=abc.ABCMeta):
    """
    Suppose that you have some data that can be indexed by use of string:
    then there are two types of errors:
    1. an error for each piece of data that can be indexed
    2. an error that is valid on the entire data
    """

    @property
    @abc.abstractmethod
    def Error(self) -> str:
        ...

    def __getitem__(self, columnName: str) -> str:
        ...


class SyntaxCheck(System.Object):
    """
    SyntaxCheck
    Helper class to check for path and machine name syntax.
    """

    @staticmethod
    def CheckMachineName(value: str) -> bool:
        """Checks the syntax of the machine name (no "\\" anywhere in it)."""
        ...

    @staticmethod
    def CheckPath(value: str) -> bool:
        """Checks the syntax of the path (must start with "\\\\")."""
        ...

    @staticmethod
    def CheckRootedPath(value: str) -> bool:
        """
        Checks the syntax of the path (must start with "\\" or drive letter "C:").
        NOTE:  These denote a file or directory path!!
        """
        ...


class ITypedList(metaclass=abc.ABCMeta):
    """This class has no documentation."""

    def GetItemProperties(self, listAccessors: typing.List[System.ComponentModel.PropertyDescriptor]) -> System.ComponentModel.PropertyDescriptorCollection:
        ...

    def GetListName(self, listAccessors: typing.List[System.ComponentModel.PropertyDescriptor]) -> str:
        ...


class ComponentConverter(System.ComponentModel.ReferenceConverter):
    """
    Provides a type converter to convert component objects to and
    from various other representations.
    """

    def __init__(self, type: typing.Type) -> None:
        """Initializes a new instance of the System.ComponentModel.ComponentConverter class."""
        ...

    def GetProperties(self, context: System.ComponentModel.ITypeDescriptorContext, value: typing.Any, attributes: typing.List[System.Attribute]) -> System.ComponentModel.PropertyDescriptorCollection:
        """
        Gets a collection of properties for the type of component
        specified by the value parameter.
        """
        ...

    def GetPropertiesSupported(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """
        Gets a value indicating whether this object supports properties using the
        specified context.
        """
        ...


class DefaultBindingPropertyAttribute(System.Attribute):
    """Specifies the default binding property for a component."""

    @property
    def Name(self) -> str:
        """
        Gets the name of the default binding property for the component this attribute is
        bound to.
        """
        ...

    Default: System.ComponentModel.DefaultBindingPropertyAttribute = ...
    """
    Specifies the default value for the System.ComponentModel.DefaultBindingPropertyAttribute, which is null. This
    static field is read-only.
    """

    @typing.overload
    def __init__(self) -> None:
        """Initializes a new instance of the System.ComponentModel.DefaultBindingPropertyAttribute class."""
        ...

    @typing.overload
    def __init__(self, name: str) -> None:
        """Initializes a new instance of the System.ComponentModel.DefaultBindingPropertyAttribute class."""
        ...

    def Equals(self, obj: typing.Any) -> bool:
        ...

    def GetHashCode(self) -> int:
        ...


class IListSource(metaclass=abc.ABCMeta):
    """This class has no documentation."""

    @property
    @abc.abstractmethod
    def ContainsListCollection(self) -> bool:
        ...

    def GetList(self) -> System.Collections.IList:
        ...


class NullableConverter(System.ComponentModel.TypeConverter):
    """TypeConverter to convert Nullable types to and from strings or the underlying simple type."""

    @property
    def NullableType(self) -> typing.Type:
        """The type this converter was initialized with."""
        ...

    @property
    def UnderlyingType(self) -> typing.Type:
        """The simple type that is represented as a nullable."""
        ...

    @property
    def UnderlyingTypeConverter(self) -> System.ComponentModel.TypeConverter:
        """Converter associated with the underlying simple type."""
        ...

    def __init__(self, type: typing.Type) -> None:
        """Nullable converter is initialized with the underlying simple type."""
        ...

    def CanConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, sourceType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an object in the
        given source type to the underlying simple type or a null.
        """
        ...

    def CanConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, destinationType: typing.Type) -> bool:
        """Gets a value indicating whether this converter can convert a value object to the destination type."""
        ...

    def ConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any) -> System.Object:
        """Converts the given value to the converter's underlying simple type or a null."""
        ...

    def ConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any, destinationType: typing.Type) -> System.Object:
        """Converts the given value object to the destination type."""
        ...

    def CreateInstance(self, context: System.ComponentModel.ITypeDescriptorContext, propertyValues: System.Collections.IDictionary) -> System.Object:
        """"""
        ...

    def GetCreateInstanceSupported(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """
        Gets a value indicating whether changing a value on this object requires a call to
        System.ComponentModel.TypeConverter.CreateInstance(IDictionary) to create a new value,
        using the specified context.
        """
        ...

    def GetProperties(self, context: System.ComponentModel.ITypeDescriptorContext, value: typing.Any, attributes: typing.List[System.Attribute]) -> System.ComponentModel.PropertyDescriptorCollection:
        """
        Gets a collection of properties for the type of array specified by the value
        parameter using the specified context and attributes.
        """
        ...

    def GetPropertiesSupported(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """Gets a value indicating whether this object supports properties using the specified context."""
        ...

    def GetStandardValues(self, context: System.ComponentModel.ITypeDescriptorContext) -> System.ComponentModel.TypeConverter.StandardValuesCollection:
        """Gets a collection of standard values for the data type this type converter is designed for."""
        ...

    def GetStandardValuesExclusive(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """
        Gets a value indicating whether the collection of standard values returned from
        System.ComponentModel.TypeConverter.GetStandardValues() is an exclusive
        list of possible values, using the specified context.
        """
        ...

    def GetStandardValuesSupported(self, context: System.ComponentModel.ITypeDescriptorContext) -> bool:
        """
        Gets a value indicating whether this object supports a standard set of values that can
        be picked from a list using the specified context.
        """
        ...

    def IsValid(self, context: System.ComponentModel.ITypeDescriptorContext, value: typing.Any) -> bool:
        """Gets a value indicating whether the given value object is valid for this type."""
        ...


class CustomTypeDescriptor(System.Object, System.ComponentModel.ICustomTypeDescriptor, metaclass=abc.ABCMeta):
    """This class has no documentation."""

    @typing.overload
    def __init__(self) -> None:
        """
        Creates a new CustomTypeDescriptor object. There are two versions
        of this constructor. The version that takes no parameters simply
        calls the version that takes a parent and passes null as the
        parent value. If the parent is null, CustomTypeDescriptor returns
        the defined default values for each method. If the parent is
        non-null, CustomTypeDescriptor calls the parent's version of
        the method.
        
        This method is protected.
        """
        ...

    @typing.overload
    def __init__(self, parent: System.ComponentModel.ICustomTypeDescriptor) -> None:
        """
        Creates a new CustomTypeDescriptor object. There are two versions
        of this constructor. The version that takes no parameters simply
        calls the version that takes a parent and passes null as the
        parent value. If the parent is null, CustomTypeDescriptor returns
        the defined default values for each method. If the parent is
        non-null, CustomTypeDescriptor calls the parent's version of
        the method.
        
        This method is protected.
        """
        ...

    def GetAttributes(self) -> System.ComponentModel.AttributeCollection:
        """
        The GetAttributes method returns the type-level attributes for
        the type this custom type descriptor is providing information for.
        You must always return a valid collection from this method.
        """
        ...

    def GetClassName(self) -> str:
        """
        The GetClassName method returns the fully qualified name of the
        class this type descriptor is representing. Returning null from
        this method causes the TypeDescriptor object to return the
        default class name.
        """
        ...

    def GetComponentName(self) -> str:
        """
        The GetComponentName method returns the name of the component instance
        this type descriptor is describing.
        """
        ...

    def GetConverter(self) -> System.ComponentModel.TypeConverter:
        """
        The GetConverter method returns a type converter for the type this type
        descriptor is representing.
        """
        ...

    def GetDefaultEvent(self) -> System.ComponentModel.EventDescriptor:
        """
        The GetDefaultEvent method returns the event descriptor for the default
        event on the object this type descriptor is representing.
        """
        ...

    def GetDefaultProperty(self) -> System.ComponentModel.PropertyDescriptor:
        """
        The GetDefaultProperty method returns the property descriptor for the
        default property on the object this type descriptor is representing.
        """
        ...

    def GetEditor(self, editorBaseType: typing.Type) -> System.Object:
        """
        The GetEditor method returns an editor of the given type that is
        to be associated with the class this type descriptor is representing.
        """
        ...

    @typing.overload
    def GetEvents(self) -> System.ComponentModel.EventDescriptorCollection:
        """
        The GetEvents method returns a collection of event descriptors
        for the object this type descriptor is representing. An optional
        attribute array may be provided to filter the collection that is
        returned. If no parent is provided,this will return an empty
        event collection.
        """
        ...

    @typing.overload
    def GetEvents(self, attributes: typing.List[System.Attribute]) -> System.ComponentModel.EventDescriptorCollection:
        """
        The GetEvents method returns a collection of event descriptors
        for the object this type descriptor is representing. An optional
        attribute array may be provided to filter the collection that is
        returned. If no parent is provided,this will return an empty
        event collection.
        """
        ...

    @typing.overload
    def GetProperties(self) -> System.ComponentModel.PropertyDescriptorCollection:
        """
        The GetProperties method returns a collection of property descriptors
        for the object this type descriptor is representing. An optional
        attribute array may be provided to filter the collection that is returned.
        If no parent is provided,this will return an empty
        property collection.
        """
        ...

    @typing.overload
    def GetProperties(self, attributes: typing.List[System.Attribute]) -> System.ComponentModel.PropertyDescriptorCollection:
        """
        The GetProperties method returns a collection of property descriptors
        for the object this type descriptor is representing. An optional
        attribute array may be provided to filter the collection that is returned.
        If no parent is provided,this will return an empty
        property collection.
        """
        ...

    def GetPropertyOwner(self, pd: System.ComponentModel.PropertyDescriptor) -> System.Object:
        """
        The GetPropertyOwner method returns an instance of an object that
        owns the given property for the object this type descriptor is representing.
        An optional attribute array may be provided to filter the collection that is
        returned. Returning null from this method causes the TypeDescriptor object
        to use its default type description services.
        """
        ...


class Int32Converter(System.ComponentModel.BaseNumberConverter):
    """
    Provides a type converter to convert 32-bit signed integer objects to and
    from various other representations.
    """

    @property
    def TargetType(self) -> typing.Type:
        """The Type this converter is targeting (e.g. Int16, UInt32, etc.)"""
        ...


class INestedSite(System.ComponentModel.ISite, metaclass=abc.ABCMeta):
    """
    Nested containers site objects using INestedSite. A nested site is simply a site with
    an additional property that can retrieve the full nested name of a component.
    """

    @property
    @abc.abstractmethod
    def FullName(self) -> str:
        """
        Returns the full name of the component in this site in the format of <owner>.<component>.
        If this component's site has a null name, FullName also returns null.
        """
        ...


class DateTimeConverter(System.ComponentModel.TypeConverter):
    """
    Provides a type converter to convert System.DateTime
    objects to and from various other representations.
    """

    def CanConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, sourceType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an
        object in the given source type to a System.DateTime
        object using the specified context.
        """
        ...

    def CanConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, destinationType: typing.Type) -> bool:
        """
        Gets a value indicating whether this converter can convert an object
        to the given destination type using the context.
        """
        ...

    def ConvertFrom(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any) -> System.Object:
        """Converts the given value object to a System.DateTime object."""
        ...

    def ConvertTo(self, context: System.ComponentModel.ITypeDescriptorContext, culture: System.Globalization.CultureInfo, value: typing.Any, destinationType: typing.Type) -> System.Object:
        """
        Converts the given value object to a System.DateTime
        object using the arguments.
        """
        ...


class PropertyTabScope(System.Enum):
    """Specifies the function scope of a tab in the properties window."""

    Static = 0
    """This tab will be added to the properties window and can never be removed."""

    Global = 1
    """
    This tab will be added to the properties window and can only be explicitly removed by a
    component outside the properties window.
    """

    Document = 2
    """
    This tab will be added to the properties window and will be removed when the currently selected document changes.
    This tab is relevant to items on the current document.
    """

    Component = 3
    """
    This tab will be added to the properties window for the current component only, and is
    removed when the component is no longer selected.
    """


class PropertyTabAttribute(System.Attribute):
    """
    Identifies the property tab or tabs that should be displayed for the
    specified class or classes.
    """

    @property
    def TabClasses(self) -> typing.List[typing.Type]:
        """Gets the types of tab that this attribute specifies."""
        ...

    @property
    def TabClassNames(self) -> typing.List[str]:
        """This property is protected."""
        ...

    @property
    def TabScopes(self) -> typing.List[System.ComponentModel.PropertyTabScope]:
        """Gets the scopes of tabs for this System.ComponentModel.Design.PropertyTabAttribute, from System.ComponentModel.Design.PropertyTabScope."""
        ...

    @TabScopes.setter
    def TabScopes(self, value: typing.List[System.ComponentModel.PropertyTabScope]):
        """Gets the scopes of tabs for this System.ComponentModel.Design.PropertyTabAttribute, from System.ComponentModel.Design.PropertyTabScope."""
        ...

    @typing.overload
    def __init__(self) -> None:
        """
        Basic constructor that creates a PropertyTabAttribute. Use this ctor to derive from this
        attribute and specify multiple tab types by calling InitializeArrays.
        """
        ...

    @typing.overload
    def __init__(self, tabClass: typing.Type) -> None:
        """
        Basic constructor that creates a property tab attribute that will create a tab
        of the specified type.
        """
        ...

    @typing.overload
    def __init__(self, tabClassName: str) -> None:
        """
        Basic constructor that creates a property tab attribute that will create a tab
        of the specified type.
        """
        ...

    @typing.overload
    def __init__(self, tabClass: typing.Type, tabScope: System.ComponentModel.PropertyTabScope) -> None:
        """
        Basic constructor that creates a property tab attribute that will create a tab
        of the specified type.
        """
        ...

    @typing.overload
    def __init__(self, tabClassName: str, tabScope: System.ComponentModel.PropertyTabScope) -> None:
        """
        Basic constructor that creates a property tab attribute that will create a tab
        of the specified type.
        """
        ...

    @typing.overload
    def Equals(self, other: typing.Any) -> bool:
        ...

    @typing.overload
    def Equals(self, other: System.ComponentModel.PropertyTabAttribute) -> bool:
        ...

    def GetHashCode(self) -> int:
        """Returns the hashcode for this object."""
        ...

    @typing.overload
    def InitializeArrays(self, tabClassNames: typing.List[str], tabScopes: typing.List[System.ComponentModel.PropertyTabScope]) -> None:
        """
        Utiliity function to set the types of tab classes this PropertyTabAttribute specifies.
        
        This method is protected.
        """
        ...

    @typing.overload
    def InitializeArrays(self, tabClasses: typing.List[typing.Type], tabScopes: typing.List[System.ComponentModel.PropertyTabScope]) -> None:
        """
        Utiliity function to set the types of tab classes this PropertyTabAttribute specifies.
        
        This method is protected.
        """
        ...


class _EventContainer(typing.Generic[System_ComponentModel__EventContainer_Callable, System_ComponentModel__EventContainer_ReturnType]):
    """This class is used to provide accurate autocomplete on events and cannot be imported."""

    def __call__(self, *args: typing.Any, **kwargs: typing.Any) -> System_ComponentModel__EventContainer_ReturnType:
        """Fires the event."""
        ...

    def __iadd__(self, item: System_ComponentModel__EventContainer_Callable) -> None:
        """Registers an event handler."""
        ...

    def __isub__(self, item: System_ComponentModel__EventContainer_Callable) -> None:
        """Unregisters an event handler."""
        ...


