# coding: utf-8

"""
    OAuth2 API

    OAuth2 Token Service (OAuth2)

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class AccessTokenResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'access_token': 'str',
        'token_type': 'str',
        'refresh_token': 'str',
        'expires_in': 'int',
        'scope': 'str',
        'refresh_token_expires_in': 'int',
        'client_status': 'str'
    }

    attribute_map = {
        'access_token': 'access_token',
        'token_type': 'token_type',
        'refresh_token': 'refresh_token',
        'expires_in': 'expires_in',
        'scope': 'scope',
        'refresh_token_expires_in': 'refresh_token_expires_in',
        'client_status': 'client_status'
    }

    def __init__(self, access_token=None, token_type=None, refresh_token=None, expires_in=None, scope=None, refresh_token_expires_in=None, client_status=None):
        """
        AccessTokenResponse - a model defined in Swagger
        """

        self._access_token = None
        self._token_type = None
        self._refresh_token = None
        self._expires_in = None
        self._scope = None
        self._refresh_token_expires_in = None
        self._client_status = None

        if access_token is not None:
          self.access_token = access_token
        if token_type is not None:
          self.token_type = token_type
        if refresh_token is not None:
          self.refresh_token = refresh_token
        if expires_in is not None:
          self.expires_in = expires_in
        if scope is not None:
          self.scope = scope
        if refresh_token_expires_in is not None:
          self.refresh_token_expires_in = refresh_token_expires_in
        if client_status is not None:
          self.client_status = client_status

    @property
    def access_token(self):
        """
        Gets the access_token of this AccessTokenResponse.
        Created JWT token.

        :return: The access_token of this AccessTokenResponse.
        :rtype: str
        """
        return self._access_token

    @access_token.setter
    def access_token(self, access_token):
        """
        Sets the access_token of this AccessTokenResponse.
        Created JWT token.

        :param access_token: The access_token of this AccessTokenResponse.
        :type: str
        """

        self._access_token = access_token

    @property
    def token_type(self):
        """
        Gets the token_type of this AccessTokenResponse.
        Bearer.

        :return: The token_type of this AccessTokenResponse.
        :rtype: str
        """
        return self._token_type

    @token_type.setter
    def token_type(self, token_type):
        """
        Sets the token_type of this AccessTokenResponse.
        Bearer.

        :param token_type: The token_type of this AccessTokenResponse.
        :type: str
        """

        self._token_type = token_type

    @property
    def refresh_token(self):
        """
        Gets the refresh_token of this AccessTokenResponse.
        Newly created JWT token for initial request or if refresh token expired, else the same refresh token as in the request.

        :return: The refresh_token of this AccessTokenResponse.
        :rtype: str
        """
        return self._refresh_token

    @refresh_token.setter
    def refresh_token(self, refresh_token):
        """
        Sets the refresh_token of this AccessTokenResponse.
        Newly created JWT token for initial request or if refresh token expired, else the same refresh token as in the request.

        :param refresh_token: The refresh_token of this AccessTokenResponse.
        :type: str
        """

        self._refresh_token = refresh_token

    @property
    def expires_in(self):
        """
        Gets the expires_in of this AccessTokenResponse.
        Number of seconds left till the access token gets expired.

        :return: The expires_in of this AccessTokenResponse.
        :rtype: int
        """
        return self._expires_in

    @expires_in.setter
    def expires_in(self, expires_in):
        """
        Sets the expires_in of this AccessTokenResponse.
        Number of seconds left till the access token gets expired.

        :param expires_in: The expires_in of this AccessTokenResponse.
        :type: int
        """

        self._expires_in = expires_in

    @property
    def scope(self):
        """
        Gets the scope of this AccessTokenResponse.
        List of permissions for APIs.

        :return: The scope of this AccessTokenResponse.
        :rtype: str
        """
        return self._scope

    @scope.setter
    def scope(self, scope):
        """
        Sets the scope of this AccessTokenResponse.
        List of permissions for APIs.

        :param scope: The scope of this AccessTokenResponse.
        :type: str
        """

        self._scope = scope

    @property
    def refresh_token_expires_in(self):
        """
        Gets the refresh_token_expires_in of this AccessTokenResponse.
        Number of seconds left till the refresh token gets expired.

        :return: The refresh_token_expires_in of this AccessTokenResponse.
        :rtype: int
        """
        return self._refresh_token_expires_in

    @refresh_token_expires_in.setter
    def refresh_token_expires_in(self, refresh_token_expires_in):
        """
        Sets the refresh_token_expires_in of this AccessTokenResponse.
        Number of seconds left till the refresh token gets expired.

        :param refresh_token_expires_in: The refresh_token_expires_in of this AccessTokenResponse.
        :type: int
        """

        self._refresh_token_expires_in = refresh_token_expires_in

    @property
    def client_status(self):
        """
        Gets the client_status of this AccessTokenResponse.
        Successful response can be returned only if client status is active.

        :return: The client_status of this AccessTokenResponse.
        :rtype: str
        """
        return self._client_status

    @client_status.setter
    def client_status(self, client_status):
        """
        Sets the client_status of this AccessTokenResponse.
        Successful response can be returned only if client status is active.

        :param client_status: The client_status of this AccessTokenResponse.
        :type: str
        """

        self._client_status = client_status

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, AccessTokenResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
