from collections import namedtuple, defaultdict

cfg = namedtuple("cfg", ["iso", "split", "num_shards"])

ALL_C4 = [
    cfg(iso="af", split="train", num_shards=64),
    cfg(iso="af", split="valid", num_shards=1),
    cfg(iso="am", split="train", num_shards=16),
    cfg(iso="am", split="valid", num_shards=1),
    cfg(iso="ar", split="train", num_shards=1024),
    cfg(iso="ar", split="valid", num_shards=4),
    cfg(iso="az", split="train", num_shards=256),
    cfg(iso="az", split="valid", num_shards=1),
    cfg(iso="be", split="train", num_shards=128),
    cfg(iso="be", split="valid", num_shards=1),
    cfg(iso="bg", split="train", num_shards=4),
    cfg(iso="bg", split="train", num_shards=1024),
    cfg(iso="bg", split="valid", num_shards=1),
    cfg(iso="bn", split="train", num_shards=512),
    cfg(iso="bn", split="valid", num_shards=1),
    cfg(iso="ca", split="train", num_shards=512),
    cfg(iso="ca", split="valid", num_shards=1),
    cfg(iso="ceb", split="train", num_shards=8),
    cfg(iso="ceb", split="valid", num_shards=1),
    cfg(iso="co", split="train", num_shards=8),
    cfg(iso="co", split="valid", num_shards=1),
    cfg(iso="cs", split="train", num_shards=1024),
    cfg(iso="cs", split="valid", num_shards=2),
    cfg(iso="cy", split="train", num_shards=256),
    cfg(iso="cy", split="valid", num_shards=1),
    cfg(iso="da", split="train", num_shards=1024),
    cfg(iso="da", split="valid", num_shards=1),
    cfg(iso="de", split="train", num_shards=2048),
    cfg(iso="de", split="valid", num_shards=16),
    cfg(iso="el", split="train", num_shards=16),
    cfg(iso="el", split="train", num_shards=1024),
    cfg(iso="el", split="valid", num_shards=1),
    cfg(iso="el", split="valid", num_shards=2),
    cfg(iso="en", split="train", num_shards=11264),
    cfg(iso="en", split="valid", num_shards=128),
    cfg(iso="eo", split="train", num_shards=32),
    cfg(iso="eo", split="valid", num_shards=1),
    cfg(iso="es", split="train", num_shards=2048),
    cfg(iso="es", split="valid", num_shards=16),
    cfg(iso="et", split="train", num_shards=256),
    cfg(iso="et", split="valid", num_shards=1),
    cfg(iso="eu", split="train", num_shards=64),
    cfg(iso="eu", split="valid", num_shards=1),
    cfg(iso="fa", split="train", num_shards=1024),
    cfg(iso="fa", split="valid", num_shards=2),
    cfg(iso="fi", split="train", num_shards=1024),
    cfg(iso="fi", split="valid", num_shards=1),
    cfg(iso="fil", split="train", num_shards=64),
    cfg(iso="fil", split="valid", num_shards=1),
    cfg(iso="fr", split="train", num_shards=2048),
    cfg(iso="fr", split="valid", num_shards=16),
    cfg(iso="fy", split="train", num_shards=16),
    cfg(iso="fy", split="valid", num_shards=1),
    cfg(iso="ga", split="train", num_shards=16),
    cfg(iso="ga", split="valid", num_shards=1),
    cfg(iso="gd", split="train", num_shards=16),
    cfg(iso="gd", split="valid", num_shards=1),
    cfg(iso="gl", split="train", num_shards=128),
    cfg(iso="gl", split="valid", num_shards=1),
    cfg(iso="gu", split="train", num_shards=64),
    cfg(iso="gu", split="valid", num_shards=1),
    cfg(iso="ha", split="train", num_shards=8),
    cfg(iso="ha", split="valid", num_shards=1),
    cfg(iso="haw", split="train", num_shards=2),
    cfg(iso="haw", split="valid", num_shards=1),
    cfg(iso="hi", split="train", num_shards=16),
    cfg(iso="hi", split="train", num_shards=1024),
    cfg(iso="hi", split="valid", num_shards=1),
    cfg(iso="hi", split="valid", num_shards=2),
    cfg(iso="hmn", split="train", num_shards=8),
    cfg(iso="hmn", split="valid", num_shards=1),
    cfg(iso="ht", split="train", num_shards=8),
    cfg(iso="ht", split="valid", num_shards=1),
    cfg(iso="hu", split="train", num_shards=1024),
    cfg(iso="hu", split="valid", num_shards=2),
    cfg(iso="hy", split="train", num_shards=128),
    cfg(iso="hy", split="valid", num_shards=1),
    cfg(iso="id", split="train", num_shards=1024),
    cfg(iso="id", split="valid", num_shards=4),
    cfg(iso="ig", split="train", num_shards=4),
    cfg(iso="ig", split="valid", num_shards=1),
    cfg(iso="is", split="train", num_shards=128),
    cfg(iso="is", split="valid", num_shards=1),
    cfg(iso="it", split="train", num_shards=1024),
    cfg(iso="it", split="valid", num_shards=8),
    cfg(iso="iw", split="train", num_shards=1024),
    cfg(iso="iw", split="valid", num_shards=1),
    cfg(iso="ja", split="train", num_shards=8),
    cfg(iso="ja", split="train", num_shards=1024),
    cfg(iso="ja", split="valid", num_shards=1),
    cfg(iso="ja", split="valid", num_shards=8),
    cfg(iso="jv", split="train", num_shards=8),
    cfg(iso="jv", split="valid", num_shards=1),
    cfg(iso="ka", split="train", num_shards=256),
    cfg(iso="ka", split="valid", num_shards=1),
    cfg(iso="kk", split="train", num_shards=256),
    cfg(iso="kk", split="valid", num_shards=1),
    cfg(iso="km", split="train", num_shards=64),
    cfg(iso="km", split="valid", num_shards=1),
    cfg(iso="kn", split="train", num_shards=64),
    cfg(iso="kn", split="valid", num_shards=1),
    cfg(iso="ko", split="train", num_shards=1024),
    cfg(iso="ko", split="valid", num_shards=1),
    cfg(iso="ku", split="train", num_shards=16),
    cfg(iso="ku", split="valid", num_shards=1),
    cfg(iso="ky", split="train", num_shards=64),
    cfg(iso="ky", split="valid", num_shards=1),
    cfg(iso="la", split="train", num_shards=64),
    cfg(iso="la", split="valid", num_shards=1),
    cfg(iso="lb", split="train", num_shards=32),
    cfg(iso="lb", split="valid", num_shards=1),
    cfg(iso="lo", split="train", num_shards=8),
    cfg(iso="lo", split="valid", num_shards=1),
    cfg(iso="lt", split="train", num_shards=512),
    cfg(iso="lt", split="valid", num_shards=1),
    cfg(iso="lv", split="train", num_shards=256),
    cfg(iso="lv", split="valid", num_shards=1),
    cfg(iso="mg", split="train", num_shards=8),
    cfg(iso="mg", split="valid", num_shards=1),
    cfg(iso="mi", split="train", num_shards=4),
    cfg(iso="mi", split="valid", num_shards=1),
    cfg(iso="mk", split="train", num_shards=128),
    cfg(iso="mk", split="valid", num_shards=1),
    cfg(iso="ml", split="train", num_shards=128),
    cfg(iso="ml", split="valid", num_shards=1),
    cfg(iso="mn", split="train", num_shards=128),
    cfg(iso="mn", split="valid", num_shards=1),
    cfg(iso="mr", split="train", num_shards=1024),
    cfg(iso="mr", split="valid", num_shards=1),
    cfg(iso="ms", split="train", num_shards=512),
    cfg(iso="ms", split="valid", num_shards=1),
    cfg(iso="mt", split="train", num_shards=128),
    cfg(iso="mt", split="valid", num_shards=1),
    cfg(iso="my", split="train", num_shards=64),
    cfg(iso="my", split="valid", num_shards=1),
    cfg(iso="ne", split="train", num_shards=256),
    cfg(iso="ne", split="valid", num_shards=1),
    cfg(iso="nl", split="train", num_shards=1024),
    cfg(iso="nl", split="valid", num_shards=4),
    cfg(iso="no", split="train", num_shards=1024),
    cfg(iso="no", split="valid", num_shards=1),
    cfg(iso="ny", split="train", num_shards=4),
    cfg(iso="ny", split="valid", num_shards=1),
    cfg(iso="pa", split="train", num_shards=32),
    cfg(iso="pa", split="valid", num_shards=1),
    cfg(iso="pl", split="train", num_shards=1024),
    cfg(iso="pl", split="valid", num_shards=4),
    cfg(iso="ps", split="train", num_shards=16),
    cfg(iso="ps", split="valid", num_shards=1),
    cfg(iso="pt", split="train", num_shards=1024),
    cfg(iso="pt", split="valid", num_shards=4),
    cfg(iso="ro", split="train", num_shards=1024),
    cfg(iso="ro", split="valid", num_shards=2),
    cfg(iso="ru", split="train", num_shards=32),
    cfg(iso="ru", split="train", num_shards=4096),
    cfg(iso="ru", split="valid", num_shards=1),
    cfg(iso="ru", split="valid", num_shards=32),
    cfg(iso="sd", split="train", num_shards=64),
    cfg(iso="sd", split="valid", num_shards=1),
    cfg(iso="si", split="train", num_shards=64),
    cfg(iso="si", split="valid", num_shards=1),
    cfg(iso="sk", split="train", num_shards=512),
    cfg(iso="sk", split="valid", num_shards=1),
    cfg(iso="sl", split="train", num_shards=256),
    cfg(iso="sl", split="valid", num_shards=1),
    cfg(iso="sm", split="train", num_shards=4),
    cfg(iso="sm", split="valid", num_shards=1),
    cfg(iso="sn", split="train", num_shards=8),
    cfg(iso="sn", split="valid", num_shards=1),
    cfg(iso="so", split="train", num_shards=64),
    cfg(iso="so", split="valid", num_shards=1),
    cfg(iso="sq", split="train", num_shards=128),
    cfg(iso="sq", split="valid", num_shards=1),
    cfg(iso="sr", split="train", num_shards=256),
    cfg(iso="sr", split="valid", num_shards=1),
    cfg(iso="st", split="train", num_shards=2),
    cfg(iso="st", split="valid", num_shards=1),
    cfg(iso="su", split="train", num_shards=4),
    cfg(iso="su", split="valid", num_shards=1),
    cfg(iso="sv", split="train", num_shards=1024),
    cfg(iso="sv", split="valid", num_shards=2),
    cfg(iso="sw", split="train", num_shards=32),
    cfg(iso="sw", split="valid", num_shards=1),
    cfg(iso="ta", split="train", num_shards=256),
    cfg(iso="ta", split="valid", num_shards=1),
    cfg(iso="te", split="train", num_shards=128),
    cfg(iso="te", split="valid", num_shards=1),
    cfg(iso="tg", split="train", num_shards=64),
    cfg(iso="tg", split="valid", num_shards=1),
    cfg(iso="th", split="train", num_shards=1024),
    cfg(iso="th", split="valid", num_shards=1),
    cfg(iso="tr", split="train", num_shards=1024),
    cfg(iso="tr", split="valid", num_shards=4),
    cfg(iso="uk", split="train", num_shards=1024),
    cfg(iso="uk", split="valid", num_shards=2),
    cfg(iso="und", split="train", num_shards=3072),
    cfg(iso="und", split="valid", num_shards=32),
    cfg(iso="ur", split="train", num_shards=128),
    cfg(iso="ur", split="valid", num_shards=1),
    cfg(iso="uz", split="train", num_shards=32),
    cfg(iso="uz", split="valid", num_shards=1),
    cfg(iso="vi", split="train", num_shards=1024),
    cfg(iso="vi", split="valid", num_shards=4),
    cfg(iso="xh", split="train", num_shards=2),
    cfg(iso="xh", split="valid", num_shards=1),
    cfg(iso="yi", split="train", num_shards=16),
    cfg(iso="yi", split="valid", num_shards=1),
    cfg(iso="yo", split="train", num_shards=2),
    cfg(iso="yo", split="valid", num_shards=1),
    cfg(iso="zh", split="train", num_shards=8),
    cfg(iso="zh", split="train", num_shards=1024),
    cfg(iso="zh", split="valid", num_shards=1),
    cfg(iso="zh", split="valid", num_shards=2),
    cfg(iso="zu", split="train", num_shards=8),
    cfg(iso="zu", split="valid", num_shards=1),
]

C4_MULTILINGUAL_CONFIG = defaultdict(dict)
GIT_LFS_SHA = "607bd4c8450a42878aa9ddc051a65a055450ef87"
BASE_URL = f"https://huggingface.co/datasets/allenai/c4/resolve/{GIT_LFS_SHA}/multilingual"
for conf in ALL_C4:
    if conf.split == "valid":
        files = [
            f"{BASE_URL}/c4-{conf.iso}-validation.tfrecord-{idx:05d}-of-{conf.num_shards:05d}.json.gz"
            for idx in range(conf.num_shards)
        ]
    elif conf.split == "train":
        files = [
            f"{BASE_URL}/c4-{conf.iso}.tfrecord-{idx:05d}-of-{conf.num_shards:05d}.json.gz"
            for idx in range(conf.num_shards)
        ]
    else:
        raise ValueError("no such split")

    C4_MULTILINGUAL_CONFIG[conf.iso][conf.split] = files
