/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2gss;

import com.teradata.tdgss.jgssp2gss.GssContext;
import com.teradata.tdgss.jgssspi.GSSMechanism;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class GssMechanism
implements GSSMechanism {
    private final TdgssLogger logger;
    private static Oid _mechOid;
    private static Oid _gssOid;
    private GSSManager mgr = null;
    protected static final Oid mechOid;
    protected static final Oid gssOid;
    protected static final short servicesAvailable = 127;

    public GssMechanism(TdgssLogger tdgssLogger) {
        this.logger = tdgssLogger;
        this.mgr = GSSManager.getInstance();
    }

    public boolean acceptable(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        byte[] byArray;
        if (object == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Token is null");
            }
            return false;
        }
        try {
            byArray = (byte[])object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return (byArray[8] & 1) == 1 && byArray[1] == 1;
    }

    public GSSContext getContextForAccept(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Getting an acceptable context ");
        }
        if (!this.acceptable(object, gSSCredential, objectArray)) {
            throw new TdgssException(10);
        }
        GSSContext gSSContext = this.mgr.createContext(gSSCredential);
        return new GssContext(gSSContext, mechOid, null, this.logger);
    }

    public GSSContext getContextForInit(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, short s) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Getting an initable context ");
        }
        if (!this.initable(gSSCredential, gSSName, n, objectArray, s)) {
            throw new TdgssException(10);
        }
        GSSContext gSSContext = this.mgr.createContext(gSSName, gssOid, gSSCredential, n);
        this.setServices(gSSContext, s);
        return new GssContext(gSSContext, mechOid, null, this.logger);
    }

    public boolean initable(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, short s) {
        if (gSSName == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("GSSException.BAD_NAME: target name cannot be null");
            }
            return false;
        }
        if ((0x7F & s) == s) {
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("unable to support requested services");
            this.logger.debug("servicesAvailable are 127");
            this.logger.debug("servicesRequested are " + s);
        }
        return false;
    }

    public GSSCredential createCredential(GSSName gSSName, int n, int n2) throws GSSException {
        return this.mgr.createCredential(gSSName, n, gssOid, n2);
    }

    public GSSName createName(byte[] byArray, Oid oid) throws GSSException {
        return this.mgr.createName(byArray, oid);
    }

    public Oid[] getNames() {
        Oid[] oidArray = null;
        try {
            oidArray = this.mgr.getNamesForMech(gssOid);
        }
        catch (GSSException gSSException) {
            this.logger.error(gSSException.getMessage());
        }
        return oidArray;
    }

    public Oid getMech() {
        return mechOid;
    }

    public short getServices() {
        return 127;
    }

    public void setServices(GSSContext gSSContext, short s) throws GSSException {
        if ((s & 1) != 0) {
            gSSContext.requestCredDeleg(true);
        }
        if ((s & 2) != 0) {
            gSSContext.requestMutualAuth(true);
        }
        if ((s & 4) != 0) {
            gSSContext.requestReplayDet(true);
        }
        if ((s & 8) != 0) {
            gSSContext.requestSequenceDet(true);
        }
        if ((s & 0x10) != 0) {
            gSSContext.requestAnonymity(true);
        }
        if ((s & 0x20) != 0) {
            gSSContext.requestConf(true);
        }
        if ((s & 0x40) != 0) {
            gSSContext.requestInteg(true);
        }
    }

    static {
        try {
            _mechOid = new Oid("1.3.6.1.4.1.191.1.1012.1.6");
            _gssOid = new Oid("1.2.840.113554.1.2.2");
        }
        catch (GSSException gSSException) {
            throw new ExceptionInInitializerError(gSSException);
        }
        mechOid = _mechOid;
        gssOid = _gssOid;
    }
}

