# coding: utf-8

"""
    Sharepoint REST V1

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from sharepoint_rest_api.api_client import ApiClient


class ListsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_list(self, **kwargs):  # noqa: E501
        """Get all list a specific site  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :param str skiptoken: Skips the first n results.
        :param int skip: Skip the first n items
        :param int top: Show only the first n items
        :param str filter: Filter items by property values
        :param str search: Search items by search phrases
        :param str orderby: Order items by property values
        :param bool count: Include count of items
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_list_with_http_info(self, **kwargs):  # noqa: E501
        """Get all list a specific site  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :param str skiptoken: Skips the first n results.
        :param int skip: Skip the first n items
        :param int top: Show only the first n items
        :param str filter: Filter items by property values
        :param str search: Search items by search phrases
        :param str orderby: Order items by property values
        :param bool count: Include count of items
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['accept', 'select', 'expand', 'skiptoken', 'skip', 'top', 'filter', 'search', 'orderby', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('$expand', params['expand']))  # noqa: E501
        if 'skiptoken' in params:
            query_params.append(('$skiptoken', params['skiptoken']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('$skip', params['skip']))  # noqa: E501
        if 'top' in params:
            query_params.append(('$top', params['top']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('$filter', params['filter']))  # noqa: E501
        if 'search' in params:
            query_params.append(('$search', params['search']))  # noqa: E501
        if 'orderby' in params:
            query_params.append(('$orderby', params['orderby']))  # noqa: E501
        if 'count' in params:
            query_params.append(('$count', params['count']))  # noqa: E501

        header_params = {}
        if 'accept' in params:
            header_params['accept'] = params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/_api/Lists', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SPOdataResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_list_by_id(self, list_id, **kwargs):  # noqa: E501
        """Get a specific List of site by Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_by_id(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: Id of a specific list (required)
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_by_id_with_http_info(list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_list_by_id_with_http_info(list_id, **kwargs)  # noqa: E501
            return data

    def get_list_by_id_with_http_info(self, list_id, **kwargs):  # noqa: E501
        """Get a specific List of site by Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_by_id_with_http_info(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: Id of a specific list (required)
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_id', 'accept', 'select', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `get_list_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_id' in params:
            path_params['listId'] = params['list_id']  # noqa: E501

        query_params = []
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('$expand', params['expand']))  # noqa: E501

        header_params = {}
        if 'accept' in params:
            header_params['accept'] = params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            "/_api/Lists(guid'{listId}')", 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SPOdataResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_list_by_id_fields(self, list_id, **kwargs):  # noqa: E501
        """Get all Fields of a specific list of site by Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_by_id_fields(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: Id of a specific list (required)
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_by_id_fields_with_http_info(list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_list_by_id_fields_with_http_info(list_id, **kwargs)  # noqa: E501
            return data

    def get_list_by_id_fields_with_http_info(self, list_id, **kwargs):  # noqa: E501
        """Get all Fields of a specific list of site by Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_by_id_fields_with_http_info(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: Id of a specific list (required)
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_id', 'accept', 'select', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_by_id_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `get_list_by_id_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_id' in params:
            path_params['listId'] = params['list_id']  # noqa: E501

        query_params = []
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('$expand', params['expand']))  # noqa: E501

        header_params = {}
        if 'accept' in params:
            header_params['accept'] = params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            "/_api/Lists(guid'{listId}')/Fields", 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SPOdataResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_list_by_id_item_by_id(self, list_id, list_item_id, **kwargs):  # noqa: E501
        """Get a specific Item by Id of a specific list of site by Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_by_id_item_by_id(list_id, list_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: Id of a specific list (required)
        :param str list_item_id: Item's Id of a specific list (required)
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_by_id_item_by_id_with_http_info(list_id, list_item_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_list_by_id_item_by_id_with_http_info(list_id, list_item_id, **kwargs)  # noqa: E501
            return data

    def get_list_by_id_item_by_id_with_http_info(self, list_id, list_item_id, **kwargs):  # noqa: E501
        """Get a specific Item by Id of a specific list of site by Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_by_id_item_by_id_with_http_info(list_id, list_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: Id of a specific list (required)
        :param str list_item_id: Item's Id of a specific list (required)
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_id', 'list_item_id', 'accept', 'select', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_by_id_item_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `get_list_by_id_item_by_id`")  # noqa: E501
        # verify the required parameter 'list_item_id' is set
        if ('list_item_id' not in params or
                params['list_item_id'] is None):
            raise ValueError("Missing the required parameter `list_item_id` when calling `get_list_by_id_item_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_id' in params:
            path_params['listId'] = params['list_id']  # noqa: E501
        if 'list_item_id' in params:
            path_params['listItemId'] = params['list_item_id']  # noqa: E501

        query_params = []
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('$expand', params['expand']))  # noqa: E501

        header_params = {}
        if 'accept' in params:
            header_params['accept'] = params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            "/_api/Lists(guid'{listId}')/Items({listItemId})", 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SPOdataResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_list_by_id_item_by_id_attachment_files(self, list_id, list_item_id, **kwargs):  # noqa: E501
        """Get AttachmentFiles of a specific Item by Id of a specific list of site by Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_by_id_item_by_id_attachment_files(list_id, list_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: Id of a specific list (required)
        :param str list_item_id: Item's Id of a specific list (required)
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :param str skiptoken: Skips the first n results.
        :param int skip: Skip the first n items
        :param int top: Show only the first n items
        :param str filter: Filter items by property values
        :param str search: Search items by search phrases
        :param str orderby: Order items by property values
        :param bool count: Include count of items
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_by_id_item_by_id_attachment_files_with_http_info(list_id, list_item_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_list_by_id_item_by_id_attachment_files_with_http_info(list_id, list_item_id, **kwargs)  # noqa: E501
            return data

    def get_list_by_id_item_by_id_attachment_files_with_http_info(self, list_id, list_item_id, **kwargs):  # noqa: E501
        """Get AttachmentFiles of a specific Item by Id of a specific list of site by Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_by_id_item_by_id_attachment_files_with_http_info(list_id, list_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: Id of a specific list (required)
        :param str list_item_id: Item's Id of a specific list (required)
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :param str skiptoken: Skips the first n results.
        :param int skip: Skip the first n items
        :param int top: Show only the first n items
        :param str filter: Filter items by property values
        :param str search: Search items by search phrases
        :param str orderby: Order items by property values
        :param bool count: Include count of items
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_id', 'list_item_id', 'accept', 'select', 'expand', 'skiptoken', 'skip', 'top', 'filter', 'search', 'orderby', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_by_id_item_by_id_attachment_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `get_list_by_id_item_by_id_attachment_files`")  # noqa: E501
        # verify the required parameter 'list_item_id' is set
        if ('list_item_id' not in params or
                params['list_item_id'] is None):
            raise ValueError("Missing the required parameter `list_item_id` when calling `get_list_by_id_item_by_id_attachment_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_id' in params:
            path_params['listId'] = params['list_id']  # noqa: E501
        if 'list_item_id' in params:
            path_params['listItemId'] = params['list_item_id']  # noqa: E501

        query_params = []
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('$expand', params['expand']))  # noqa: E501
        if 'skiptoken' in params:
            query_params.append(('$skiptoken', params['skiptoken']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('$skip', params['skip']))  # noqa: E501
        if 'top' in params:
            query_params.append(('$top', params['top']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('$filter', params['filter']))  # noqa: E501
        if 'search' in params:
            query_params.append(('$search', params['search']))  # noqa: E501
        if 'orderby' in params:
            query_params.append(('$orderby', params['orderby']))  # noqa: E501
        if 'count' in params:
            query_params.append(('$count', params['count']))  # noqa: E501

        header_params = {}
        if 'accept' in params:
            header_params['accept'] = params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            "/_api/Lists(guid'{listId}')/Items({listItemId})/AttachmentFiles", 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SPOdataResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_list_by_id_item_by_id_file(self, list_id, list_item_id, **kwargs):  # noqa: E501
        """Get File of a specific Item by Id of a specific list of site by Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_by_id_item_by_id_file(list_id, list_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: Id of a specific list (required)
        :param str list_item_id: Item's Id of a specific list (required)
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :param str skiptoken: Skips the first n results.
        :param int skip: Skip the first n items
        :param int top: Show only the first n items
        :param str filter: Filter items by property values
        :param str search: Search items by search phrases
        :param str orderby: Order items by property values
        :param bool count: Include count of items
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_by_id_item_by_id_file_with_http_info(list_id, list_item_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_list_by_id_item_by_id_file_with_http_info(list_id, list_item_id, **kwargs)  # noqa: E501
            return data

    def get_list_by_id_item_by_id_file_with_http_info(self, list_id, list_item_id, **kwargs):  # noqa: E501
        """Get File of a specific Item by Id of a specific list of site by Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_by_id_item_by_id_file_with_http_info(list_id, list_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: Id of a specific list (required)
        :param str list_item_id: Item's Id of a specific list (required)
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :param str skiptoken: Skips the first n results.
        :param int skip: Skip the first n items
        :param int top: Show only the first n items
        :param str filter: Filter items by property values
        :param str search: Search items by search phrases
        :param str orderby: Order items by property values
        :param bool count: Include count of items
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_id', 'list_item_id', 'accept', 'select', 'expand', 'skiptoken', 'skip', 'top', 'filter', 'search', 'orderby', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_by_id_item_by_id_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `get_list_by_id_item_by_id_file`")  # noqa: E501
        # verify the required parameter 'list_item_id' is set
        if ('list_item_id' not in params or
                params['list_item_id'] is None):
            raise ValueError("Missing the required parameter `list_item_id` when calling `get_list_by_id_item_by_id_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_id' in params:
            path_params['listId'] = params['list_id']  # noqa: E501
        if 'list_item_id' in params:
            path_params['listItemId'] = params['list_item_id']  # noqa: E501

        query_params = []
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('$expand', params['expand']))  # noqa: E501
        if 'skiptoken' in params:
            query_params.append(('$skiptoken', params['skiptoken']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('$skip', params['skip']))  # noqa: E501
        if 'top' in params:
            query_params.append(('$top', params['top']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('$filter', params['filter']))  # noqa: E501
        if 'search' in params:
            query_params.append(('$search', params['search']))  # noqa: E501
        if 'orderby' in params:
            query_params.append(('$orderby', params['orderby']))  # noqa: E501
        if 'count' in params:
            query_params.append(('$count', params['count']))  # noqa: E501

        header_params = {}
        if 'accept' in params:
            header_params['accept'] = params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            "/_api/Lists(guid'{listId}')/Items({listItemId})/File", 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SPOdataResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_list_by_id_item_by_id_folder(self, list_id, list_item_id, **kwargs):  # noqa: E501
        """Get Folder of a specific Item by Id of a specific list of site by Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_by_id_item_by_id_folder(list_id, list_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: Id of a specific list (required)
        :param str list_item_id: Item's Id of a specific list (required)
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :param str skiptoken: Skips the first n results.
        :param int skip: Skip the first n items
        :param int top: Show only the first n items
        :param str filter: Filter items by property values
        :param str search: Search items by search phrases
        :param str orderby: Order items by property values
        :param bool count: Include count of items
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_by_id_item_by_id_folder_with_http_info(list_id, list_item_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_list_by_id_item_by_id_folder_with_http_info(list_id, list_item_id, **kwargs)  # noqa: E501
            return data

    def get_list_by_id_item_by_id_folder_with_http_info(self, list_id, list_item_id, **kwargs):  # noqa: E501
        """Get Folder of a specific Item by Id of a specific list of site by Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_by_id_item_by_id_folder_with_http_info(list_id, list_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: Id of a specific list (required)
        :param str list_item_id: Item's Id of a specific list (required)
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :param str skiptoken: Skips the first n results.
        :param int skip: Skip the first n items
        :param int top: Show only the first n items
        :param str filter: Filter items by property values
        :param str search: Search items by search phrases
        :param str orderby: Order items by property values
        :param bool count: Include count of items
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_id', 'list_item_id', 'accept', 'select', 'expand', 'skiptoken', 'skip', 'top', 'filter', 'search', 'orderby', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_by_id_item_by_id_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `get_list_by_id_item_by_id_folder`")  # noqa: E501
        # verify the required parameter 'list_item_id' is set
        if ('list_item_id' not in params or
                params['list_item_id'] is None):
            raise ValueError("Missing the required parameter `list_item_id` when calling `get_list_by_id_item_by_id_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_id' in params:
            path_params['listId'] = params['list_id']  # noqa: E501
        if 'list_item_id' in params:
            path_params['listItemId'] = params['list_item_id']  # noqa: E501

        query_params = []
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('$expand', params['expand']))  # noqa: E501
        if 'skiptoken' in params:
            query_params.append(('$skiptoken', params['skiptoken']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('$skip', params['skip']))  # noqa: E501
        if 'top' in params:
            query_params.append(('$top', params['top']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('$filter', params['filter']))  # noqa: E501
        if 'search' in params:
            query_params.append(('$search', params['search']))  # noqa: E501
        if 'orderby' in params:
            query_params.append(('$orderby', params['orderby']))  # noqa: E501
        if 'count' in params:
            query_params.append(('$count', params['count']))  # noqa: E501

        header_params = {}
        if 'accept' in params:
            header_params['accept'] = params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            "/_api/Lists(guid'{listId}')/Items({listItemId})/Folder", 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SPOdataResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_list_by_id_items(self, list_id, **kwargs):  # noqa: E501
        """Get all Items of a specific list of site by Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_by_id_items(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: Id of a specific list (required)
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :param str skiptoken: Skips the first n results.
        :param int skip: Skip the first n items
        :param int top: Show only the first n items
        :param str filter: Filter items by property values
        :param str search: Search items by search phrases
        :param str orderby: Order items by property values
        :param bool count: Include count of items
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_by_id_items_with_http_info(list_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_list_by_id_items_with_http_info(list_id, **kwargs)  # noqa: E501
            return data

    def get_list_by_id_items_with_http_info(self, list_id, **kwargs):  # noqa: E501
        """Get all Items of a specific list of site by Id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_by_id_items_with_http_info(list_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_id: Id of a specific list (required)
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :param str skiptoken: Skips the first n results.
        :param int skip: Skip the first n items
        :param int top: Show only the first n items
        :param str filter: Filter items by property values
        :param str search: Search items by search phrases
        :param str orderby: Order items by property values
        :param bool count: Include count of items
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_id', 'accept', 'select', 'expand', 'skiptoken', 'skip', 'top', 'filter', 'search', 'orderby', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_by_id_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_id' is set
        if ('list_id' not in params or
                params['list_id'] is None):
            raise ValueError("Missing the required parameter `list_id` when calling `get_list_by_id_items`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_id' in params:
            path_params['listId'] = params['list_id']  # noqa: E501

        query_params = []
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('$expand', params['expand']))  # noqa: E501
        if 'skiptoken' in params:
            query_params.append(('$skiptoken', params['skiptoken']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('$skip', params['skip']))  # noqa: E501
        if 'top' in params:
            query_params.append(('$top', params['top']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('$filter', params['filter']))  # noqa: E501
        if 'search' in params:
            query_params.append(('$search', params['search']))  # noqa: E501
        if 'orderby' in params:
            query_params.append(('$orderby', params['orderby']))  # noqa: E501
        if 'count' in params:
            query_params.append(('$count', params['count']))  # noqa: E501

        header_params = {}
        if 'accept' in params:
            header_params['accept'] = params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            "/_api/Lists(guid'{listId}')/Items", 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SPOdataResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_list_by_title(self, list_title, **kwargs):  # noqa: E501
        """Get a specific List of site by title  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_by_title(list_title, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_title: Title of a specific list (required)
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_by_title_with_http_info(list_title, **kwargs)  # noqa: E501
        else:
            (data) = self.get_list_by_title_with_http_info(list_title, **kwargs)  # noqa: E501
            return data

    def get_list_by_title_with_http_info(self, list_title, **kwargs):  # noqa: E501
        """Get a specific List of site by title  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_by_title_with_http_info(list_title, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_title: Title of a specific list (required)
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_title', 'accept', 'select', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_by_title" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_title' is set
        if ('list_title' not in params or
                params['list_title'] is None):
            raise ValueError("Missing the required parameter `list_title` when calling `get_list_by_title`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_title' in params:
            path_params['listTitle'] = params['list_title']  # noqa: E501

        query_params = []
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('$expand', params['expand']))  # noqa: E501

        header_params = {}
        if 'accept' in params:
            header_params['accept'] = params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            "/_api/Lists/GetByTitle('{listTitle}')", 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SPOdataResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_list_by_title_fields(self, list_title, **kwargs):  # noqa: E501
        """Get all Fields of a specific list of site by title  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_by_title_fields(list_title, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_title: Title of a specific list (required)
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_by_title_fields_with_http_info(list_title, **kwargs)  # noqa: E501
        else:
            (data) = self.get_list_by_title_fields_with_http_info(list_title, **kwargs)  # noqa: E501
            return data

    def get_list_by_title_fields_with_http_info(self, list_title, **kwargs):  # noqa: E501
        """Get all Fields of a specific list of site by title  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_by_title_fields_with_http_info(list_title, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_title: Title of a specific list (required)
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_title', 'accept', 'select', 'expand']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_by_title_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_title' is set
        if ('list_title' not in params or
                params['list_title'] is None):
            raise ValueError("Missing the required parameter `list_title` when calling `get_list_by_title_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_title' in params:
            path_params['listTitle'] = params['list_title']  # noqa: E501

        query_params = []
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('$expand', params['expand']))  # noqa: E501

        header_params = {}
        if 'accept' in params:
            header_params['accept'] = params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            "/_api/Lists/GetByTitle('{listTitle}')/Fields", 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SPOdataResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_list_by_title_items(self, list_title, **kwargs):  # noqa: E501
        """Get all Items of a specific list of site by title  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_by_title_items(list_title, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_title: Title of a specific list (required)
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :param str skiptoken: Skips the first n results.
        :param int skip: Skip the first n items
        :param int top: Show only the first n items
        :param str filter: Filter items by property values
        :param str search: Search items by search phrases
        :param str orderby: Order items by property values
        :param bool count: Include count of items
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_list_by_title_items_with_http_info(list_title, **kwargs)  # noqa: E501
        else:
            (data) = self.get_list_by_title_items_with_http_info(list_title, **kwargs)  # noqa: E501
            return data

    def get_list_by_title_items_with_http_info(self, list_title, **kwargs):  # noqa: E501
        """Get all Items of a specific list of site by title  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_list_by_title_items_with_http_info(list_title, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str list_title: Title of a specific list (required)
        :param str accept:
        :param str select: Select items by property values
        :param str expand: Expand related entities
        :param str skiptoken: Skips the first n results.
        :param int skip: Skip the first n items
        :param int top: Show only the first n items
        :param str filter: Filter items by property values
        :param str search: Search items by search phrases
        :param str orderby: Order items by property values
        :param bool count: Include count of items
        :return: SPOdataResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['list_title', 'accept', 'select', 'expand', 'skiptoken', 'skip', 'top', 'filter', 'search', 'orderby', 'count']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_by_title_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'list_title' is set
        if ('list_title' not in params or
                params['list_title'] is None):
            raise ValueError("Missing the required parameter `list_title` when calling `get_list_by_title_items`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'list_title' in params:
            path_params['listTitle'] = params['list_title']  # noqa: E501

        query_params = []
        if 'select' in params:
            query_params.append(('$select', params['select']))  # noqa: E501
        if 'expand' in params:
            query_params.append(('$expand', params['expand']))  # noqa: E501
        if 'skiptoken' in params:
            query_params.append(('$skiptoken', params['skiptoken']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('$skip', params['skip']))  # noqa: E501
        if 'top' in params:
            query_params.append(('$top', params['top']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('$filter', params['filter']))  # noqa: E501
        if 'search' in params:
            query_params.append(('$search', params['search']))  # noqa: E501
        if 'orderby' in params:
            query_params.append(('$orderby', params['orderby']))  # noqa: E501
        if 'count' in params:
            query_params.append(('$count', params['count']))  # noqa: E501

        header_params = {}
        if 'accept' in params:
            header_params['accept'] = params['accept']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            "/_api/Lists/GetByTitle('{listTitle}')/Items", 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SPOdataResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
