/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
/**
 * Options for typescript sample code generation
 */
export interface TypescriptSampleCodeOptions {
    /**
     * The package name which exports the OpenApiGatewayLambdaApi construct (ie this pdk package!)
     */
    readonly openApiGatewayPackageName: string;
    /**
     * The name of the generated typescript client package
     */
    readonly typescriptClientPackageName: string;
    /**
     * Whether or not to generate sample code
     */
    readonly sampleCode?: boolean;
    /**
     * Source code directory
     */
    readonly srcdir: string;
}
/**
 * Return a map of file name to contents for the sample typescript source code
 */
export declare const getTypescriptSampleSource: (options: TypescriptSampleCodeOptions) => {
    [fileName: string]: string;
};
/**
 * Return a map of file name to contents for the sample typescript test code
 */
export declare const getTypescriptSampleTests: (options: TypescriptSampleCodeOptions) => {
    "api.test.ts": string;
};
