/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.types;

import com.datapps.linkoopdb.jdbc.HsqlDateTime;
import com.datapps.linkoopdb.jdbc.LdbSqlException;
import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.impl.JDBCSqlDate;
import com.datapps.linkoopdb.jdbc.lib.StringConverter;
import com.datapps.linkoopdb.jdbc.types.CharacterType;
import com.datapps.linkoopdb.jdbc.types.DTIType;
import com.datapps.linkoopdb.jdbc.types.IntervalMonthData;
import com.datapps.linkoopdb.jdbc.types.IntervalSecondData;
import com.datapps.linkoopdb.jdbc.types.IntervalType;
import com.datapps.linkoopdb.jdbc.types.NumberType;
import com.datapps.linkoopdb.jdbc.types.TimeData;
import com.datapps.linkoopdb.jdbc.types.TimestampData;
import com.datapps.linkoopdb.jdbc.types.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;

public final class DateTimeType
extends DTIType {
    public static final long epochSeconds = HsqlDateTime.getDateSeconds("1-01-01");
    public static final TimestampData epochTimestamp = new TimestampData(epochSeconds);
    public static final long limitSeconds = HsqlDateTime.getDateSeconds("10000-01-01");
    public final boolean withTimeZone;
    private String nameString;

    public DateTimeType(int typeGroup, int type, int scale) {
        super(typeGroup, type, 0L, scale);
        this.withTimeZone = type == 94 || type == 95;
        this.nameString = this.getNameStringPrivate();
    }

    public static long parse(String str) {
        String pattern = "yyyy-MM-dd HH:mm:ss";
        String pattern1 = "yyyy-MM-dd";
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        SimpleDateFormat df1 = new SimpleDateFormat(pattern1);
        try {
            return df.parse(str).getTime();
        }
        catch (Exception e) {
            try {
                return df1.parse(str).getTime();
            }
            catch (Exception ee) {
                throw Error.runtimeError(6609, str);
            }
        }
    }

    public static int normaliseTime(int seconds) {
        while (seconds < 0) {
            seconds += 86400;
        }
        if (seconds > 86400) {
            seconds %= 86400;
        }
        return seconds;
    }

    public static DateTimeType getDateTimeType(int type, int scale) {
        if (scale > 9) {
            throw Error.error(5592);
        }
        switch (type) {
            case 91: {
                return SQL_DATE;
            }
            case 92: {
                if (scale == 0) {
                    return SQL_TIME;
                }
                return new DateTimeType(92, type, scale);
            }
            case 94: {
                if (scale == 0) {
                    return SQL_TIME_WITH_TIME_ZONE;
                }
                return new DateTimeType(92, type, scale);
            }
            case 93: {
                if (scale == 6) {
                    return SQL_TIMESTAMP;
                }
                if (scale == 0) {
                    return SQL_TIMESTAMP_NO_FRACTION;
                }
                return new DateTimeType(93, type, scale);
            }
            case 95: {
                if (scale == 6) {
                    return SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
                return new DateTimeType(93, type, scale);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public static Type normalizeInput(SessionInterface session, Object[] a, Type[] ta, Object[] b, Type[] tb, boolean pointOfTime) {
        if (a == null || b == null) {
            return null;
        }
        if (a[0] == null || b[0] == null) {
            return null;
        }
        if (a[1] == null) {
            return null;
        }
        if (!pointOfTime && b[1] == null) {
            return null;
        }
        DateTimeType commonType = SQL_TIMESTAMP_WITH_TIME_ZONE;
        a[0] = commonType.castToType(session, a[0], ta[0]);
        b[0] = commonType.castToType(session, b[0], tb[0]);
        a[1] = ta[1].isIntervalType() ? ((Type)commonType).add(session, a[0], a[1], ta[1]) : commonType.castToType(session, a[1], ta[1]);
        b[1] = tb[1].isIntervalType() ? ((Type)commonType).add(session, b[0], b[1], tb[1]) : (pointOfTime ? b[0] : commonType.castToType(session, b[1], tb[1]));
        if (((Type)commonType).compare(session, a[0], a[1]) >= 0) {
            throw Error.error(3462);
        }
        if (!pointOfTime && ((Type)commonType).compare(session, b[0], b[1]) >= 0) {
            throw Error.error(3462);
        }
        return commonType;
    }

    public static Type normalizeInputRelaxed(SessionInterface session, Object[] a, Type[] ta, Object[] b, Type[] tb) {
        Object temp;
        if (a == null || b == null) {
            return null;
        }
        if (a[0] == null || b[0] == null) {
            return null;
        }
        if (a[1] == null) {
            a[1] = a[0];
        }
        if (b[1] == null) {
            b[1] = b[0];
        }
        Type commonType = ta[0].getCombinedType(session, tb[0], 40);
        a[0] = commonType.castToType(session, a[0], ta[0]);
        b[0] = commonType.castToType(session, b[0], tb[0]);
        a[1] = ta[1].isIntervalType() ? commonType.add(session, a[0], a[1], ta[1]) : commonType.castToType(session, a[1], ta[1]);
        b[1] = tb[1].isIntervalType() ? commonType.add(session, b[0], b[1], tb[1]) : commonType.castToType(session, b[1], tb[1]);
        if (commonType.compare(session, a[0], a[1]) > 0) {
            temp = a[0];
            a[0] = a[1];
            a[1] = temp;
        }
        if (commonType.compare(session, b[0], b[1]) > 0) {
            temp = b[0];
            b[0] = b[1];
            b[1] = temp;
        }
        return commonType;
    }

    public static Boolean overlaps(SessionInterface session, Object[] a, Type[] ta, Object[] b, Type[] tb) {
        Type commonType = DateTimeType.normalizeInput(session, a, ta, b, tb, false);
        if (commonType == null) {
            return null;
        }
        if (commonType.compare(session, a[0], b[0]) > 0) {
            Object[] temp = a;
            a = b;
            b = temp;
        }
        if (commonType.compare(session, a[1], b[0]) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean overlapsRelaxed(SessionInterface session, Object[] a, Type[] ta, Object[] b, Type[] tb) {
        Type commonType = DateTimeType.normalizeInputRelaxed(session, a, ta, b, tb);
        if (commonType == null) {
            return null;
        }
        if (commonType.compare(session, a[0], b[0]) > 0) {
            Object[] temp = a;
            a = b;
            b = temp;
        }
        if (commonType.compare(session, a[1], b[0]) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean precedes(SessionInterface session, Object[] a, Type[] ta, Object[] b, Type[] tb) {
        Type commonType = DateTimeType.normalizeInput(session, a, ta, b, tb, false);
        if (commonType == null) {
            return null;
        }
        if (commonType.compare(session, a[1], b[0]) <= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean immediatelyPrecedes(SessionInterface session, Object[] a, Type[] ta, Object[] b, Type[] tb) {
        Type commonType = DateTimeType.normalizeInput(session, a, ta, b, tb, false);
        if (commonType == null) {
            return null;
        }
        if (commonType.compare(session, a[1], b[0]) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean immediatelySucceeds(SessionInterface session, Object[] a, Type[] ta, Object[] b, Type[] tb) {
        Type commonType = DateTimeType.normalizeInput(session, a, ta, b, tb, false);
        if (commonType == null) {
            return null;
        }
        if (commonType.compare(session, a[0], b[1]) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean succeeds(SessionInterface session, Object[] a, Type[] ta, Object[] b, Type[] tb) {
        Type commonType = DateTimeType.normalizeInput(session, a, ta, b, tb, false);
        if (commonType == null) {
            return null;
        }
        if (commonType.compare(session, a[0], b[1]) >= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean equals(SessionInterface session, Object[] a, Type[] ta, Object[] b, Type[] tb) {
        Type commonType = DateTimeType.normalizeInput(session, a, ta, b, tb, false);
        if (commonType == null) {
            return null;
        }
        if (commonType.compare(session, a[0], b[0]) == 0 && commonType.compare(session, a[1], b[1]) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean contains(SessionInterface session, Object[] a, Type[] ta, Object[] b, Type[] tb, boolean pointOfTime) {
        Type commonType = DateTimeType.normalizeInput(session, a, ta, b, tb, pointOfTime);
        if (commonType == null) {
            return null;
        }
        int compareStart = commonType.compare(session, a[0], b[0]);
        int compareEnd = commonType.compare(session, a[1], b[1]);
        if (compareStart <= 0 && compareEnd >= 0) {
            if (pointOfTime && compareEnd == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static BigDecimal subtractMonthsSpecial(SessionInterface session, TimestampData a, TimestampData b) {
        long s1 = (a.getSeconds() + (long)a.getZone()) * 1000L;
        long s2 = (b.getSeconds() + (long)b.getZone()) * 1000L;
        boolean minus = false;
        if (s1 < s2) {
            minus = true;
            long temp = s1;
            s1 = s2;
            s2 = temp;
        }
        s1 = HsqlDateTime.getNormalisedDate(session.getCalendarGMT(), s1);
        s2 = HsqlDateTime.getNormalisedDate(session.getCalendarGMT(), s2);
        Calendar cal = session.getCalendarGMT();
        cal.setTimeInMillis(s1);
        int months1 = cal.get(2) + cal.get(1) * 12;
        int day1 = cal.get(5);
        cal.set(5, 1);
        long millis = cal.getTimeInMillis();
        cal.add(2, 1);
        millis = cal.getTimeInMillis();
        cal.add(5, -1);
        millis = cal.getTimeInMillis();
        int lastDay1 = cal.get(5);
        cal.setTimeInMillis(s2);
        int months2 = cal.get(2) + cal.get(1) * 12;
        int day2 = cal.get(5);
        cal.set(5, 1);
        millis = cal.getTimeInMillis();
        cal.add(2, 1);
        millis = cal.getTimeInMillis();
        cal.add(5, -1);
        millis = cal.getTimeInMillis();
        int lastDay2 = cal.get(5);
        if (day1 == day2 || day1 == lastDay1 && day2 == lastDay2) {
            double months = months1 - months2;
            if (minus) {
                months = -months;
            }
            return BigDecimal.valueOf(months);
        }
        if (day2 > day1) {
            double months = months1 - months2 - 1;
            double days = lastDay2 - day2 + day1;
            months += days / 31.0;
            if (minus) {
                months = -months;
            }
            return BigDecimal.valueOf(months);
        }
        double months = months1 - months2;
        double days = day1 - day2;
        months += days / 31.0;
        if (minus) {
            months = -months;
        }
        return BigDecimal.valueOf(months);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int subtractMonths(SessionInterface session, TimestampData a, TimestampData b, boolean isYear) {
        Calendar calendar;
        Calendar calendar2 = calendar = session.getCalendarGMT();
        synchronized (calendar2) {
            boolean negate = false;
            if (b.getSeconds() > a.getSeconds()) {
                negate = true;
                TimestampData temp = a;
                a = b;
                b = temp;
            }
            calendar.setTimeInMillis(a.getSeconds() * 1000L);
            int months = calendar.get(2);
            int years = calendar.get(1);
            calendar.setTimeInMillis(b.getSeconds() * 1000L);
            months -= calendar.get(2);
            years -= calendar.get(1);
            if (isYear) {
                months = years * 12;
            } else {
                if (months < 0) {
                    months += 12;
                    --years;
                }
                months += years * 12;
            }
            if (negate) {
                months = -months;
            }
            return months;
        }
    }

    public static TimeData addSeconds(TimeData source, long seconds, int nanos) {
        seconds += (long)((nanos += source.getNanos()) / 1000000000);
        if ((nanos %= 1000000000) < 0) {
            nanos += 1000000000;
            --seconds;
        }
        seconds += (long)source.getSeconds();
        TimeData ti = new TimeData((int)(seconds %= 86400L), nanos, source.getZone());
        return ti;
    }

    public static TimestampData addMonths(SessionInterface session, TimestampData source, int months) {
        int n = source.getNanos();
        Calendar cal = session.getCalendarGMT();
        HsqlDateTime.setTimeInMillis(cal, source.getSeconds() * 1000L);
        cal.add(2, months);
        TimestampData ts = new TimestampData(cal.getTimeInMillis() / 1000L, n, source.getZone());
        return ts;
    }

    public static TimestampData addSeconds(TimestampData source, long seconds, int nanos) {
        seconds += (long)((nanos += source.getNanos()) / 1000000000);
        if ((nanos %= 1000000000) < 0) {
            nanos += 1000000000;
            --seconds;
        }
        long newSeconds = source.getSeconds() + seconds;
        TimestampData ts = new TimestampData(newSeconds, nanos, source.getZone());
        return ts;
    }

    public static TimestampData convertToDatetimeSpecial(SessionInterface session, String s, DateTimeType type) {
        switch (type.typeCode) {
            case 93: {
                TimestampData timestampData = typeHelper.convertToDatetimeSpecial(session, s, type);
                if (timestampData == null) break;
                return timestampData;
            }
        }
        throw Error.error(3407);
    }

    public static TimestampData nextDayOfWeek(SessionInterface session, TimestampData d, int day) {
        Calendar cal = session.getCalendarGMT();
        cal.setTimeInMillis(d.getMillis());
        int start = cal.get(7);
        if (start >= day) {
            day += 7;
        }
        int diff = day - start;
        cal.add(5, diff);
        long millis = cal.getTimeInMillis();
        millis = HsqlDateTime.getNormalisedDate(cal, millis);
        return new TimestampData(millis / 1000L);
    }

    public static int getDayOfWeek(String name) {
        char c = Character.toUpperCase(name.charAt(0));
        switch (c) {
            case 'M': {
                return 2;
            }
            case 'T': {
                if (Character.toUpperCase(name.charAt(1)) == 'U') {
                    return 3;
                }
                if (Character.toUpperCase(name.charAt(1)) != 'H') break;
                return 5;
            }
            case 'W': {
                return 4;
            }
            case 'F': {
                return 6;
            }
            case 'S': {
                if (Character.toUpperCase(name.charAt(1)) == 'A') {
                    return 7;
                }
                if (Character.toUpperCase(name.charAt(1)) != 'U') break;
                return 1;
            }
        }
        throw Error.error(3407);
    }

    @Override
    public int displaySize() {
        switch (this.typeCode) {
            case 91: {
                return 10;
            }
            case 92: {
                return 8 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 94: {
                return 8 + (this.scale == 0 ? 0 : this.scale + 1) + 6;
            }
            case 93: {
                return 19 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 95: {
                return 19 + (this.scale == 0 ? 0 : this.scale + 1) + 6;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public int getJDBCTypeCode() {
        switch (this.typeCode) {
            case 94: {
                return 2013;
            }
            case 95: {
                return 2014;
            }
        }
        return this.typeCode;
    }

    @Override
    public Class getJDBCClass() {
        switch (this.typeCode) {
            case 91: {
                return Date.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case 94: {
                return OffsetTime.class;
            }
            case 95: {
                return OffsetDateTime.class;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String getJDBCClassName() {
        switch (this.typeCode) {
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case 94: {
                return "java.time.OffsetTime";
            }
            case 95: {
                return "java.time.OffsetDateTime";
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public int getJDBCPrecision() {
        return this.displaySize();
    }

    @Override
    public int getSQLGenericTypeCode() {
        return 9;
    }

    @Override
    public String getNameString() {
        return this.nameString;
    }

    @Override
    public boolean canCompareDirect(Type otherType) {
        return this.typeCode == otherType.typeCode;
    }

    private String getNameStringPrivate() {
        switch (this.typeCode) {
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 94: {
                return "TIME WITH TIME ZONE";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 95: {
                return "TIMESTAMP WITH TIME ZONE";
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String getDefinition() {
        String token;
        switch (this.typeCode) {
            case 91: {
                return "DATE";
            }
            case 92: 
            case 94: {
                if (this.scale == 0) {
                    return this.getNameString();
                }
                token = "TIME";
                break;
            }
            case 93: 
            case 95: {
                if (this.scale == 6) {
                    return this.getNameString();
                }
                token = "TIMESTAMP";
                break;
            }
            default: {
                throw Error.runtimeError(201, "DateTimeType");
            }
        }
        StringBuffer sb = new StringBuffer(16);
        sb.append(token);
        sb.append('(');
        sb.append(this.scale);
        sb.append(')');
        if (this.withTimeZone) {
            sb.append(" WITH TIME ZONE");
        }
        return sb.toString();
    }

    @Override
    public boolean isDateTimeType() {
        return true;
    }

    @Override
    public boolean isDateOrTimestampType() {
        switch (this.typeCode) {
            case 91: 
            case 93: 
            case 95: {
                return true;
            }
            case 92: 
            case 94: {
                return false;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean isTimestampType() {
        switch (this.typeCode) {
            case 93: 
            case 95: {
                return true;
            }
            case 91: 
            case 92: 
            case 94: {
                return false;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean isDateTimeTypeWithZone() {
        return this.withTimeZone;
    }

    @Override
    public boolean acceptsFractionalPrecision() {
        return this.typeCode != 91;
    }

    @Override
    public Type getAggregateType(Type other) {
        int startType;
        if (other == null) {
            return this;
        }
        if (other == SQL_ALL_TYPES) {
            return this;
        }
        if (this.typeCode == other.typeCode) {
            return this.scale >= other.scale ? this : other;
        }
        if (other.typeCode == 0) {
            return this;
        }
        if (other.isCharacterType()) {
            return other.getAggregateType(this);
        }
        if (!other.isDateTimeType()) {
            throw Error.error(5562);
        }
        DateTimeType otherType = (DateTimeType)other;
        if (otherType.startIntervalType > this.endIntervalType || this.startIntervalType > otherType.endIntervalType) {
            throw Error.error(5562);
        }
        int newType = this.typeCode;
        int scale = this.scale > otherType.scale ? this.scale : otherType.scale;
        boolean zone = this.withTimeZone || otherType.withTimeZone;
        int n = startType = otherType.startIntervalType > this.startIntervalType ? this.startIntervalType : otherType.startIntervalType;
        newType = startType == 104 ? (zone ? 94 : 92) : (zone ? 95 : 93);
        return DateTimeType.getDateTimeType(newType, scale);
    }

    @Override
    public Type getCombinedType(SessionInterface session, Type other, int operation) {
        switch (operation) {
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                int startType;
                if (this.typeCode == other.typeCode) {
                    return this;
                }
                if (other.typeCode == 0) {
                    return this;
                }
                if (!other.isDateTimeType()) {
                    throw Error.error(5562);
                }
                DateTimeType otherType = (DateTimeType)other;
                if (otherType.startIntervalType > this.endIntervalType || this.startIntervalType > otherType.endIntervalType) {
                    throw Error.error(5562);
                }
                int newType = this.typeCode;
                int scale = this.scale > otherType.scale ? this.scale : otherType.scale;
                boolean zone = this.withTimeZone || otherType.withTimeZone;
                int n = startType = otherType.startIntervalType > this.startIntervalType ? this.startIntervalType : otherType.startIntervalType;
                newType = startType == 104 ? (zone ? 94 : 92) : (zone ? 95 : 93);
                return DateTimeType.getDateTimeType(newType, scale);
            }
            case 32: 
            case 33: {
                if (other.isIntervalType()) {
                    if (this.typeCode != 91 && other.scale > this.scale) {
                        return DateTimeType.getDateTimeType(this.typeCode, other.scale);
                    }
                    return this;
                }
                if (other.isDateTimeType()) {
                    if (operation != 33 || other.typeComparisonGroup != this.typeComparisonGroup) break;
                    if (this.typeCode == 91) {
                        return Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                    }
                    return Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                }
                if (!other.isNumberType()) break;
                return this;
            }
        }
        throw Error.error(5562);
    }

    @Override
    public int compare(SessionInterface session, Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long diff = ((TimeData)a).getSeconds() - ((TimeData)b).getSeconds();
                if (diff == 0L) {
                    diff = ((TimeData)a).getNanos() - ((TimeData)b).getNanos();
                }
                return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
            }
            case 91: 
            case 93: 
            case 95: {
                long diff = ((TimestampData)a).getSeconds() - ((TimestampData)b).getSeconds();
                if (diff == 0L) {
                    diff = ((TimestampData)a).getNanos() - ((TimestampData)b).getNanos();
                }
                return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (this.scale == 9) {
            return a;
        }
        switch (this.typeCode) {
            case 91: {
                return a;
            }
            case 92: 
            case 94: {
                TimeData ti = (TimeData)a;
                int nanos = ti.getNanos();
                int newNanos = this.scaleNanos(nanos);
                if (newNanos == nanos) {
                    return ti;
                }
                return new TimeData(ti.getSeconds(), newNanos, ti.getZone());
            }
            case 93: 
            case 95: {
                TimestampData ts = (TimestampData)a;
                int nanos = ts.getNanos();
                int newNanos = this.scaleNanos(nanos);
                if (newNanos == nanos) {
                    return ts;
                }
                return new TimestampData(ts.getSeconds(), newNanos, ts.getZone());
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    int scaleNanos(int nanos) {
        int divisor = nanoScaleFactors[this.scale];
        return nanos / divisor * divisor;
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return a;
        }
        switch (otherType.typeCode) {
            case 40: {
                a = a.toString();
            }
            case 1: 
            case 12: {
                switch (this.typeCode) {
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        try {
                            return session.getScanner().convertToDatetimeInterval(session, (String)a, this);
                        }
                        catch (LdbSqlException e) {
                            return DateTimeType.convertToDatetimeSpecial(session, (String)a, this);
                        }
                    }
                }
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                break;
            }
            default: {
                throw Error.error(5561);
            }
        }
        switch (this.typeCode) {
            case 91: {
                switch (otherType.typeCode) {
                    case 91: {
                        return a;
                    }
                    case 95: {
                        long seconds = ((TimestampData)a).getSeconds() + (long)((TimestampData)a).getZone();
                        long millis = HsqlDateTime.getNormalisedDate(session.getCalendarGMT(), seconds * 1000L);
                        return new TimestampData(millis / 1000L);
                    }
                    case 93: {
                        long l = HsqlDateTime.getNormalisedDate(session.getCalendarGMT(), ((TimestampData)a).getSeconds() * 1000L);
                        return new TimestampData(l / 1000L);
                    }
                }
                throw Error.error(5561);
            }
            case 94: {
                switch (otherType.typeCode) {
                    case 94: {
                        return this.convertToTypeLimits(session, a);
                    }
                    case 92: {
                        TimeData ti = (TimeData)a;
                        return new TimeData(ti.getSeconds() - session.getZoneSeconds(), this.scaleNanos(ti.getNanos()), session.getZoneSeconds());
                    }
                    case 95: {
                        TimestampData ts = (TimestampData)a;
                        long seconds = HsqlDateTime.convertToNormalisedTime(ts.getSeconds() * 1000L) / 1000L;
                        return new TimeData((int)seconds, this.scaleNanos(ts.getNanos()), ts.getZone());
                    }
                    case 93: {
                        TimestampData ts = (TimestampData)a;
                        long seconds = ts.getSeconds() - (long)session.getZoneSeconds();
                        seconds = HsqlDateTime.convertToNormalisedTime(seconds * 1000L, session.getCalendarGMT()) / 1000L;
                        return new TimeData((int)seconds, this.scaleNanos(ts.getNanos()), session.getZoneSeconds());
                    }
                }
                throw Error.error(5561);
            }
            case 92: {
                switch (otherType.typeCode) {
                    case 94: {
                        TimeData ti = (TimeData)a;
                        return new TimeData(ti.getSeconds() + ti.getZone(), this.scaleNanos(ti.getNanos()), 0);
                    }
                    case 92: {
                        return this.convertToTypeLimits(session, a);
                    }
                    case 95: {
                        TimestampData ts = (TimestampData)a;
                        long seconds = ts.getSeconds() + (long)ts.getZone();
                        seconds = HsqlDateTime.convertToNormalisedTime(seconds * 1000L, session.getCalendarGMT()) / 1000L;
                        return new TimeData((int)seconds, this.scaleNanos(ts.getNanos()), 0);
                    }
                    case 93: {
                        TimestampData ts = (TimestampData)a;
                        long seconds = HsqlDateTime.convertToNormalisedTime(ts.getSeconds() * 1000L, session.getCalendarGMT()) / 1000L;
                        return new TimeData((int)seconds, this.scaleNanos(ts.getNanos()));
                    }
                }
                throw Error.error(5561);
            }
            case 95: {
                switch (otherType.typeCode) {
                    case 94: {
                        TimeData ti = (TimeData)a;
                        long seconds = session.getCurrentDate().getSeconds() + (long)ti.getSeconds();
                        return new TimestampData(seconds, this.scaleNanos(ti.getNanos()), ti.getZone());
                    }
                    case 92: {
                        TimeData ti = (TimeData)a;
                        long seconds = session.getCurrentDate().getSeconds() + (long)ti.getSeconds() - (long)session.getZoneSeconds();
                        return new TimestampData(seconds, this.scaleNanos(ti.getNanos()), session.getZoneSeconds());
                    }
                    case 95: {
                        return this.convertToTypeLimits(session, a);
                    }
                    case 93: {
                        TimestampData ts = (TimestampData)a;
                        long seconds = ts.getSeconds() - (long)session.getZoneSeconds();
                        return new TimestampData(seconds, this.scaleNanos(ts.getNanos()), session.getZoneSeconds());
                    }
                    case 91: {
                        TimestampData ts = (TimestampData)a;
                        return new TimestampData(ts.getSeconds(), 0, session.getZoneSeconds());
                    }
                }
                throw Error.error(5561);
            }
            case 93: {
                switch (otherType.typeCode) {
                    case 94: {
                        TimeData ti = (TimeData)a;
                        long seconds = session.getCurrentDate().getSeconds() + (long)ti.getSeconds() - (long)session.getZoneSeconds();
                        return new TimestampData(seconds, this.scaleNanos(ti.getNanos()), session.getZoneSeconds());
                    }
                    case 92: {
                        TimeData ti = (TimeData)a;
                        long seconds = session.getCurrentDate().getSeconds() + (long)ti.getSeconds();
                        return new TimestampData(seconds, this.scaleNanos(ti.getNanos()));
                    }
                    case 95: {
                        TimestampData ts = (TimestampData)a;
                        long seconds = ts.getSeconds() + (long)ts.getZone();
                        return new TimestampData(seconds, this.scaleNanos(ts.getNanos()));
                    }
                    case 93: {
                        return this.convertToTypeLimits(session, a);
                    }
                    case 91: {
                        return a;
                    }
                }
                throw Error.error(5561);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertToDefaultType(SessionInterface session, Object a) {
        DateTimeType otherType = a instanceof TimeData ? Type.SQL_TIME : Type.SQL_TIMESTAMP;
        return this.convertToType(session, a, otherType);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (a instanceof Date) break;
                if (a instanceof java.util.Date) {
                    long millis;
                    int nanos = 0;
                    int zoneSeconds = 0;
                    if (this.typeCode == 92) {
                        millis = HsqlDateTime.convertMillisFromCalendar(session.getCalendarGMT(), session.getCalendar(), ((java.util.Date)a).getTime());
                    } else {
                        millis = ((java.util.Date)a).getTime();
                        zoneSeconds = session.getZoneSeconds();
                    }
                    millis = HsqlDateTime.getNormalisedTime(session.getCalendarGMT(), millis);
                    if (a instanceof Timestamp) {
                        nanos = ((Timestamp)a).getNanos();
                        nanos = DateTimeType.normaliseFraction(nanos, this.scale);
                    }
                    return new TimeData((int)millis / 1000, nanos, zoneSeconds);
                }
                TimeData time = this.convertJavaTimeObject(session, a);
                if (time == null) break;
                return time;
            }
            case 91: {
                if (a instanceof Time) break;
                if (a instanceof String) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        a = format.parse((String)a);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                if (a instanceof java.util.Date) {
                    long millis = HsqlDateTime.convertMillisFromCalendar(session.getCalendarGMT(), session.getCalendar(), ((java.util.Date)a).getTime());
                    millis = HsqlDateTime.getNormalisedDate(session.getCalendarGMT(), millis);
                    long seconds = millis / 1000L;
                    if (session != null && session.isDataCheckStrict() && (seconds < epochSeconds || seconds > limitSeconds)) {
                        throw Error.error(3408);
                    }
                    return new TimestampData(seconds);
                }
                TimestampData timestamp = this.convertJavaTimeObject(session, a, false);
                if (timestamp == null) break;
                return timestamp;
            }
            case 93: 
            case 95: {
                if (a instanceof Time) break;
                if (a instanceof String) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    try {
                        a = format.parse((String)a);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                if (a instanceof java.util.Date) {
                    long millis;
                    int nanos = 0;
                    int zoneSeconds = 0;
                    if (this.typeCode == 93) {
                        millis = HsqlDateTime.convertMillisFromCalendar(session.getCalendarGMT(), session.getCalendar(), ((java.util.Date)a).getTime());
                    } else {
                        millis = ((java.util.Date)a).getTime();
                        zoneSeconds = HsqlDateTime.getZoneMillis(session.getCalendar(), millis) / 1000;
                    }
                    if (a instanceof Timestamp) {
                        nanos = ((Timestamp)a).getNanos();
                        nanos = DateTimeType.normaliseFraction(nanos, this.scale);
                    }
                    long seconds = millis / 1000L;
                    if (session != null && session.isDataCheckStrict() && (seconds < epochSeconds || seconds > limitSeconds)) {
                        throw Error.error(3408);
                    }
                    return new TimestampData(seconds, nanos, zoneSeconds);
                }
                TimestampData timestamp = this.convertJavaTimeObject(session, a, true);
                if (timestamp == null) break;
                return timestamp;
            }
        }
        throw Error.error(5561);
    }

    TimestampData convertJavaTimeObject(SessionInterface session, Object a, boolean timestamp) {
        if (a instanceof OffsetDateTime) {
            OffsetDateTime odt = (OffsetDateTime)a;
            long seconds = odt.toEpochSecond();
            int nanos = 0;
            int zoneSeconds = 0;
            if (timestamp) {
                nanos = odt.getNano();
                nanos = DateTimeType.normaliseFraction(nanos, this.scale);
                if (this.withTimeZone) {
                    zoneSeconds = odt.get(ChronoField.OFFSET_SECONDS);
                }
            } else {
                seconds = HsqlDateTime.getNormalisedDate(session.getCalendarGMT(), seconds * 1000L) / 1000L;
            }
            return new TimestampData(seconds, nanos, zoneSeconds);
        }
        if (a instanceof LocalDateTime) {
            LocalDateTime odt = (LocalDateTime)a;
            int year = odt.getYear();
            int month = odt.getMonthValue() - 1;
            int day = odt.getDayOfMonth();
            int hour = 0;
            int minute = 0;
            int second = 0;
            int nanos = 0;
            int zoneSeconds = 0;
            if (timestamp) {
                hour = odt.getHour();
                minute = odt.getMinute();
                second = odt.getSecond();
                nanos = odt.getNano();
                nanos = DateTimeType.normaliseFraction(nanos, this.scale);
                if (this.withTimeZone) {
                    zoneSeconds = session.getZoneSeconds();
                }
            }
            Calendar cal = session.getCalendarGMT();
            cal.clear();
            cal.set(year, month, day, hour, minute, second);
            long seconds = cal.getTimeInMillis() / 1000L;
            return new TimestampData(seconds, nanos, zoneSeconds);
        }
        if (a instanceof LocalDate) {
            LocalDate odt = (LocalDate)a;
            int year = odt.getYear();
            int month = odt.getMonthValue() - 1;
            int day = odt.getDayOfMonth();
            int zoneSeconds = 0;
            if (timestamp && this.withTimeZone) {
                zoneSeconds = session.getZoneSeconds();
            }
            Calendar cal = session.getCalendarGMT();
            cal.clear();
            cal.set(year, month, day);
            long milis = cal.getTimeInMillis();
            return new TimestampData(milis, 0, zoneSeconds);
        }
        return null;
    }

    TimeData convertJavaTimeObject(SessionInterface session, Object a) {
        if (a instanceof OffsetTime) {
            OffsetTime odt = (OffsetTime)a;
            int zoneSeconds = 0;
            int hour = odt.getHour();
            int minute = odt.getMinute();
            int second = odt.getSecond();
            int nanos = odt.getNano();
            nanos = DateTimeType.normaliseFraction(nanos, this.scale);
            if (this.withTimeZone) {
                zoneSeconds = odt.get(ChronoField.OFFSET_SECONDS);
            }
            Calendar cal = session.getCalendarGMT();
            cal.clear();
            cal.set(1970, 1, 1, hour, minute, second);
            int seconds = (int)cal.getTimeInMillis() / 1000;
            return new TimeData(seconds, nanos, zoneSeconds);
        }
        if (a instanceof LocalTime) {
            LocalTime odt = (LocalTime)a;
            int zoneSeconds = 0;
            int hour = odt.getHour();
            int minute = odt.getMinute();
            int second = odt.getSecond();
            int nanos = odt.getNano();
            nanos = DateTimeType.normaliseFraction(nanos, this.scale);
            if (this.withTimeZone) {
                zoneSeconds = session.getZoneSeconds();
            }
            Calendar cal = session.getCalendarGMT();
            cal.clear();
            cal.set(1970, 1, 1, hour, minute, second);
            int seconds = (int)cal.getTimeInMillis() / 1000;
            return new TimeData(seconds, nanos, zoneSeconds);
        }
        return null;
    }

    public Object convertSQLToJavaGMT(SessionInterface session, Object a) {
        switch (this.typeCode) {
            case 92: 
            case 94: {
                long millis = (long)((TimeData)a).getSeconds() * 1000L;
                return new Time(millis += (long)(((TimeData)a).getNanos() / 1000000));
            }
            case 91: {
                long millis = ((TimestampData)a).getSeconds() * 1000L;
                return new Date(millis);
            }
            case 93: 
            case 95: {
                long millis = ((TimestampData)a).getSeconds() * 1000L;
                Timestamp value = new Timestamp(millis);
                value.setNanos(((TimestampData)a).getNanos());
                return value;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertSQLToJava(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        switch (this.typeCode) {
            case 92: {
                Calendar cal = session.getCalendar();
                long millis = HsqlDateTime.convertMillisToCalendar(cal, ((TimeData)a).getMillis());
                millis = HsqlDateTime.getNormalisedTime(cal, millis);
                Time value = new Time(millis);
                return value;
            }
            case 94: {
                long millis = ((TimeData)a).getMillis();
                return new Time(millis);
            }
            case 91: {
                Calendar cal = session.getCalendar();
                long millis = HsqlDateTime.convertMillisToCalendar(cal, ((TimestampData)a).getMillis());
                JDBCSqlDate value = new JDBCSqlDate(millis);
                return value;
            }
            case 93: {
                Calendar cal = session.getCalendar();
                long millis = HsqlDateTime.convertMillisToCalendar(cal, ((TimestampData)a).getMillis());
                Timestamp value = new Timestamp(millis);
                value.setNanos(((TimestampData)a).getNanos());
                return value;
            }
            case 95: {
                long millis = ((TimestampData)a).getMillis();
                Timestamp value = new Timestamp(millis);
                value.setNanos(((TimestampData)a).getNanos());
                return value;
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object convertDbToWorker(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof String) {
            long l = DateTimeType.parse(a.toString());
            if (this.isTimestampType()) {
                return new Timestamp(l);
            }
            if (this.isDateOrTimestampType()) {
                return new Date(l);
            }
            return this.convertToType(session, a, CharacterType.getCharacterType(12, 100L));
        }
        return this.convertSQLToJava(session, a);
    }

    @Override
    public Object convertWorkerToDb(SessionInterface session, Object a, Type type) {
        if (a == null) {
            return null;
        }
        a = this.convertJavaToSQL(session, a);
        return a;
    }

    @Override
    public String convertToString(Object a) {
        boolean zone = false;
        if (a == null) {
            return null;
        }
        switch (this.typeCode) {
            case 91: {
                return HsqlDateTime.getDateString(((TimestampData)a).getSeconds());
            }
            case 92: 
            case 94: {
                TimeData t = (TimeData)a;
                int seconds = DateTimeType.normaliseTime(t.getSeconds() + t.getZone());
                String s = this.intervalSecondToString(seconds, t.getNanos(), false);
                if (!this.withTimeZone) {
                    return s;
                }
                StringBuffer sb = new StringBuffer(s);
                s = Type.SQL_INTERVAL_HOUR_TO_MINUTE.intervalSecondToString(((TimeData)a).getZone(), 0, true);
                sb.append(s);
                return sb.toString();
            }
            case 93: 
            case 95: {
                TimestampData ts = (TimestampData)a;
                StringBuffer sb = new StringBuffer();
                HsqlDateTime.getTimestampString(sb, ts.getSeconds() + (long)ts.getZone(), ts.getNanos(), this.scale);
                if (!this.withTimeZone) {
                    return sb.toString();
                }
                String s = Type.SQL_INTERVAL_HOUR_TO_MINUTE.intervalSecondToString(((TimestampData)a).getZone(), 0, true);
                sb.append(s);
                return sb.toString();
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        StringBuffer sb = new StringBuffer(32);
        if (Type.dbLinkType.get() != null && Type.dbLinkType.get() == 3) {
            return StringConverter.toQuotedString(this.convertToString(a), '\'', false);
        }
        if (Type.dbLinkType.get() != null && Type.dbLinkType.get() == 1) {
            return StringConverter.toQuotedString(this.convertToString(a), '\'', false);
        }
        switch (this.typeCode) {
            case 91: {
                sb.append("DATE");
                break;
            }
            case 92: 
            case 94: {
                sb.append("TIME");
                break;
            }
            case 93: 
            case 95: {
                sb.append("TIMESTAMP");
            }
        }
        sb.append(StringConverter.toQuotedString(this.convertToString(a), '\'', false));
        return sb.toString();
    }

    @Override
    public boolean canConvertFrom(Type otherType) {
        if (otherType.typeCode == 0) {
            return true;
        }
        if (otherType.isCharacterType()) {
            return true;
        }
        if (!otherType.isDateTimeType()) {
            return false;
        }
        if (otherType.typeCode == 91) {
            return this.typeCode != 92;
        }
        if (otherType.typeCode == 92) {
            return this.typeCode != 91;
        }
        return true;
    }

    @Override
    public int canMoveFrom(Type otherType) {
        if (otherType == this) {
            return 0;
        }
        if (this.typeCode == otherType.typeCode) {
            return this.scale >= otherType.scale ? 0 : -1;
        }
        return -1;
    }

    @Override
    public Object add(SessionInterface session, Object a, Object b, Type otherType) {
        if (a == null || b == null) {
            return null;
        }
        if (otherType.isNumberType()) {
            if (this.typeCode == 91) {
                b = ((NumberType)otherType).floor(b);
            }
            b = Type.SQL_INTERVAL_SECOND_MAX_PRECISION.multiply(IntervalSecondData.oneDay, b);
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (b instanceof IntervalMonthData) {
                    throw Error.runtimeError(201, "DateTimeType");
                }
                if (!(b instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimeData)a, ((IntervalSecondData)b).units, ((IntervalSecondData)b).nanos);
            }
            case 91: 
            case 93: 
            case 95: {
                if (b instanceof IntervalMonthData) {
                    return DateTimeType.addMonths(session, (TimestampData)a, ((IntervalMonthData)b).units);
                }
                if (!(b instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimestampData)a, ((IntervalSecondData)b).units, ((IntervalSecondData)b).nanos);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public Object subtract(SessionInterface session, Object a, Object b, Type otherType) {
        if (a == null || b == null) {
            return null;
        }
        if (otherType.isNumberType()) {
            if (this.typeCode == 91) {
                b = ((NumberType)otherType).floor(b);
            }
            b = Type.SQL_INTERVAL_SECOND_MAX_PRECISION.multiply(IntervalSecondData.oneDay, b);
        }
        switch (this.typeCode) {
            case 92: 
            case 94: {
                if (b instanceof IntervalMonthData) {
                    throw Error.runtimeError(201, "DateTimeType");
                }
                if (!(b instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimeData)a, -((IntervalSecondData)b).units, -((IntervalSecondData)b).nanos);
            }
            case 91: 
            case 93: 
            case 95: {
                if (b instanceof IntervalMonthData) {
                    return DateTimeType.addMonths(session, (TimestampData)a, -((IntervalMonthData)b).units);
                }
                if (!(b instanceof IntervalSecondData)) break;
                return DateTimeType.addSeconds((TimestampData)a, -((IntervalSecondData)b).units, -((IntervalSecondData)b).nanos);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public Object truncate(Object a, int part) {
        if (a == null) {
            return null;
        }
        long millis = this.getMillis(a);
        millis = HsqlDateTime.getTruncatedPart(millis, part);
        millis -= this.getZoneMillis(a);
        switch (this.typeCode) {
            case 94: {
                millis = HsqlDateTime.getNormalisedTime(millis);
            }
            case 92: {
                return new TimeData((int)(millis / 1000L), 0, ((TimeData)a).getZone());
            }
            case 91: 
            case 93: 
            case 95: {
                return new TimestampData(millis / 1000L, 0, ((TimestampData)a).getZone());
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public Object round(Object a, int part) {
        if (a == null) {
            return null;
        }
        long millis = this.getMillis(a);
        millis = HsqlDateTime.getRoundedPart(millis, part);
        millis -= this.getZoneMillis(a);
        switch (this.typeCode) {
            case 92: 
            case 94: {
                millis = HsqlDateTime.getNormalisedTime(millis);
                return new TimeData((int)(millis / 1000L), 0, ((TimeData)a).getZone());
            }
            case 91: 
            case 93: 
            case 95: {
                return new TimestampData(millis / 1000L, 0, ((TimestampData)a).getZone());
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DateTimeType) {
            return super.equals(other) && ((DateTimeType)other).withTimeZone == this.withTimeZone;
        }
        return false;
    }

    @Override
    public int getPart(SessionInterface session, Object dateTime, int part) {
        int calendarPart;
        int increment = 0;
        int divisor = 1;
        switch (part) {
            case 101: {
                calendarPart = 1;
                break;
            }
            case 102: {
                increment = 1;
                calendarPart = 2;
                break;
            }
            case 103: 
            case 260: {
                calendarPart = 5;
                break;
            }
            case 104: {
                calendarPart = 11;
                break;
            }
            case 105: {
                calendarPart = 12;
                break;
            }
            case 106: {
                calendarPart = 13;
                break;
            }
            case 259: {
                calendarPart = 7;
                break;
            }
            case 262: {
                calendarPart = 3;
                break;
            }
            case 266: {
                if (this.typeCode != 92 && this.typeCode != 94) {
                    try {
                        DateTimeType target = this.withTimeZone ? Type.SQL_TIME_WITH_TIME_ZONE : Type.SQL_TIME;
                        dateTime = target.castToType(session, dateTime, this);
                    }
                    catch (LdbSqlException target) {
                        // empty catch block
                    }
                }
                return ((TimeData)dateTime).getSeconds();
            }
            case 257: {
                if (this.typeCode == 95) {
                    return ((TimestampData)dateTime).getZone() / 3600;
                }
                return ((TimeData)dateTime).getZone() / 3600;
            }
            case 258: {
                if (this.typeCode == 95) {
                    return ((TimestampData)dateTime).getZone() / 60 % 60;
                }
                return ((TimeData)dateTime).getZone() / 60 % 60;
            }
            case 271: {
                if (this.typeCode == 95) {
                    return ((TimestampData)dateTime).getZone() / 60;
                }
                return ((TimeData)dateTime).getZone() / 60;
            }
            case 263: {
                increment = 1;
                divisor = 3;
                calendarPart = 2;
                break;
            }
            case 261: {
                calendarPart = 6;
                break;
            }
            case 268: {
                if (this.isDateOrTimestampType()) {
                    return ((TimestampData)dateTime).getNanos() / 1000000;
                }
                return ((TimeData)dateTime).getNanos() / 1000000;
            }
            case 270: {
                if (this.isDateOrTimestampType()) {
                    return ((TimestampData)dateTime).getNanos();
                }
                return ((TimeData)dateTime).getNanos();
            }
            default: {
                throw Error.runtimeError(201, "DateTimeType - " + part);
            }
        }
        long millis = this.getMillis(dateTime);
        return HsqlDateTime.getDateTimePart(millis, calendarPart) / divisor + increment;
    }

    public Object addMonthsSpecial(SessionInterface session, Object dateTime, int months) {
        TimestampData ts = (TimestampData)dateTime;
        Calendar cal = session.getCalendarGMT();
        long millis = (ts.getSeconds() + (long)ts.getZone()) * 1000L;
        HsqlDateTime.setTimeInMillis(cal, millis);
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        boolean lastDay = millis == cal.getTimeInMillis();
        HsqlDateTime.setTimeInMillis(cal, millis);
        cal.add(2, months);
        if (lastDay) {
            cal.set(5, 1);
            cal.add(2, 1);
            cal.add(5, -1);
        }
        millis = cal.getTimeInMillis();
        return new TimestampData(millis / 1000L, 0, 0);
    }

    public Object getLastDayOfMonth(SessionInterface session, Object dateTime) {
        TimestampData ts = (TimestampData)dateTime;
        Calendar cal = session.getCalendarGMT();
        long millis = (ts.getSeconds() + (long)ts.getZone()) * 1000L;
        HsqlDateTime.setTimeInMillis(cal, millis);
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        millis = cal.getTimeInMillis();
        return new TimestampData(millis / 1000L, 0, 0);
    }

    long getMillis(Object dateTime) {
        long millis = this.typeCode == 92 || this.typeCode == 94 ? (long)(((TimeData)dateTime).getSeconds() + ((TimeData)dateTime).getZone()) * 1000L : (((TimestampData)dateTime).getSeconds() + (long)((TimestampData)dateTime).getZone()) * 1000L;
        return millis;
    }

    long getZoneMillis(Object dateTime) {
        long millis = this.typeCode == 92 || this.typeCode == 94 ? (long)((TimeData)dateTime).getZone() * 1000L : (long)((TimestampData)dateTime).getZone() * 1000L;
        return millis;
    }

    @Override
    public BigDecimal getSecondPart(Object dateTime) {
        long seconds = this.getPart(null, dateTime, 106);
        int nanos = 0;
        if (this.typeCode == 93 || this.typeCode == 95) {
            nanos = ((TimestampData)dateTime).getNanos();
        } else if (this.typeCode == 92 || this.typeCode == 94) {
            nanos = ((TimeData)dateTime).getNanos();
        }
        return this.getSecondPart(seconds, nanos);
    }

    public String getPartString(SessionInterface session, Object dateTime, int part) {
        String javaPattern = "";
        switch (part) {
            case 264: {
                javaPattern = "EEEE";
                break;
            }
            case 265: {
                javaPattern = "MMMM";
            }
        }
        SimpleDateFormat format = session.getSimpleDateFormatGMT();
        try {
            format.applyPattern(javaPattern);
        }
        catch (Exception exception) {
            // empty catch block
        }
        java.util.Date date = (java.util.Date)this.convertSQLToJavaGMT(session, dateTime);
        return format.format(date);
    }

    public Object getValue(long seconds, int nanos, int zoneSeconds) {
        switch (this.typeCode) {
            case 91: {
                seconds = HsqlDateTime.getNormalisedDate((seconds + (long)zoneSeconds) * 1000L) / 1000L;
                return new TimestampData(seconds);
            }
            case 94: {
                seconds = HsqlDateTime.getNormalisedDate(seconds * 1000L) / 1000L;
                return new TimeData((int)seconds, nanos, zoneSeconds);
            }
            case 92: {
                seconds = HsqlDateTime.getNormalisedTime((seconds + (long)zoneSeconds) * 1000L) / 1000L;
                return new TimeData((int)seconds, nanos);
            }
            case 95: {
                return new TimestampData(seconds, nanos, zoneSeconds);
            }
            case 93: {
                return new TimestampData(seconds + (long)zoneSeconds, nanos);
            }
        }
        throw Error.runtimeError(201, "DateTimeType");
    }

    public DateTimeType getDateTimeTypeWithoutZone() {
        if (this.withTimeZone) {
            DateTimeType type;
            switch (this.typeCode) {
                case 94: {
                    type = new DateTimeType(92, 92, this.scale);
                    break;
                }
                case 95: {
                    type = new DateTimeType(93, 93, this.scale);
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "DateTimeType");
                }
            }
            type.nameString = this.nameString;
            return type;
        }
        return this;
    }

    public Object changeZone(Object a, Type otherType, int targetZone, int localZone) {
        if (a == null) {
            return null;
        }
        if (targetZone > 50400 || -targetZone > 50400) {
            throw Error.error(3409);
        }
        switch (this.typeCode) {
            case 94: {
                TimeData value = (TimeData)a;
                if (otherType.isDateTimeTypeWithZone()) {
                    if (value.zone == targetZone) break;
                    return new TimeData(value.getSeconds(), value.getNanos(), targetZone);
                }
                int seconds = value.getSeconds() - localZone;
                seconds = (int)(HsqlDateTime.getNormalisedTime((long)seconds * 1000L) / 1000L);
                return new TimeData(seconds, value.getNanos(), targetZone);
            }
            case 95: {
                TimestampData value = (TimestampData)a;
                long seconds = value.getSeconds();
                if (!otherType.isDateTimeTypeWithZone()) {
                    seconds -= (long)localZone;
                }
                if (value.getSeconds() == seconds && value.zone == targetZone) break;
                return new TimestampData(seconds, value.getNanos(), targetZone);
            }
        }
        return a;
    }

    public boolean canAdd(IntervalType other) {
        return other.startPartIndex >= this.startPartIndex && other.endPartIndex <= this.endPartIndex;
    }

    public int getSqlDateTimeSub() {
        switch (this.typeCode) {
            case 91: {
                return 1;
            }
            case 92: {
                return 2;
            }
            case 93: {
                return 3;
            }
        }
        return 0;
    }
}

