import platform
from .flag import make_flag

bits = platform.architecture()[0]
bitness =  int(bits[:2])

NATIVE_WORD_MAX_VALUE = 0xffffffff if bitness == 32 else 0xffffffffffffffff
from .ntstatus import *
from .winerror import *
BG_JOB_ENUM_ALL_USERS = make_flag("BG_JOB_ENUM_ALL_USERS", 0x0001)
BG_NOTIFY_JOB_TRANSFERRED = make_flag("BG_NOTIFY_JOB_TRANSFERRED", 0x0001)
BG_NOTIFY_JOB_ERROR = make_flag("BG_NOTIFY_JOB_ERROR", 0x0002)
BG_NOTIFY_DISABLE = make_flag("BG_NOTIFY_DISABLE", 0x0004)
BG_NOTIFY_JOB_MODIFICATION = make_flag("BG_NOTIFY_JOB_MODIFICATION", 0x0008)
BG_NOTIFY_FILE_TRANSFERRED = make_flag("BG_NOTIFY_FILE_TRANSFERRED", 0x0010)
HKEY_CLASSES_ROOT = make_flag("HKEY_CLASSES_ROOT", ( 0x80000000 ))
HKEY_CURRENT_USER = make_flag("HKEY_CURRENT_USER", ( 0x80000001 ))
HKEY_LOCAL_MACHINE = make_flag("HKEY_LOCAL_MACHINE", ( 0x80000002 ))
HKEY_USERS = make_flag("HKEY_USERS", ( 0x80000003 ))
HKEY_PERFORMANCE_DATA = make_flag("HKEY_PERFORMANCE_DATA", ( 0x80000004 ))
HKEY_PERFORMANCE_TEXT = make_flag("HKEY_PERFORMANCE_TEXT", ( 0x80000050 ))
HKEY_PERFORMANCE_NLSTEXT = make_flag("HKEY_PERFORMANCE_NLSTEXT", ( 0x80000060 ))
HKEY_CURRENT_CONFIG = make_flag("HKEY_CURRENT_CONFIG", ( 0x80000005 ))
HKEY_DYN_DATA = make_flag("HKEY_DYN_DATA", ( 0x80000006 ))
HKEY_CURRENT_USER_LOCAL_SETTINGS = make_flag("HKEY_CURRENT_USER_LOCAL_SETTINGS", ( 0x80000007 ))
RPC_REQUEST_TYPE_CALL = make_flag("RPC_REQUEST_TYPE_CALL", 0)
RPC_REQUEST_TYPE_BIND = make_flag("RPC_REQUEST_TYPE_BIND", 1)
RPC_RESPONSE_TYPE_BIND_OK = make_flag("RPC_RESPONSE_TYPE_BIND_OK", 1)
RPC_RESPONSE_TYPE_FAIL = make_flag("RPC_RESPONSE_TYPE_FAIL", 2)
RPC_RESPONSE_TYPE_SUCCESS = make_flag("RPC_RESPONSE_TYPE_SUCCESS", 3)
BIND_IF_SYNTAX_NDR32 = make_flag("BIND_IF_SYNTAX_NDR32", 1)
BIND_IF_SYNTAX_NDR64 = make_flag("BIND_IF_SYNTAX_NDR64", 2)
BIND_IF_SYNTAX_UNKNOWN = make_flag("BIND_IF_SYNTAX_UNKNOWN", 4)
MAX_DEVICE_ID_LEN = make_flag("MAX_DEVICE_ID_LEN", 200)
MAX_DEVNODE_ID_LEN = make_flag("MAX_DEVNODE_ID_LEN", MAX_DEVICE_ID_LEN)
MAX_GUID_STRING_LEN = make_flag("MAX_GUID_STRING_LEN", 39)
MAX_CLASS_NAME_LEN = make_flag("MAX_CLASS_NAME_LEN", 32)
MAX_PROFILE_LEN = make_flag("MAX_PROFILE_LEN", 80)
MAX_CONFIG_VALUE = make_flag("MAX_CONFIG_VALUE", 9999)
MAX_INSTANCE_VALUE = make_flag("MAX_INSTANCE_VALUE", 9999)
MAX_MEM_REGISTERS = make_flag("MAX_MEM_REGISTERS", 9)
MAX_IO_PORTS = make_flag("MAX_IO_PORTS", 20)
MAX_IRQS = make_flag("MAX_IRQS", 7)
MAX_DMA_CHANNELS = make_flag("MAX_DMA_CHANNELS", 7)
DWORD_MAX = make_flag("DWORD_MAX", 0xffffffff)
DWORDLONG_MAX = make_flag("DWORDLONG_MAX", 0xffffffffffffffff)
CM_DEVCAP_LOCKSUPPORTED = make_flag("CM_DEVCAP_LOCKSUPPORTED", ( 0x00000001 ))
CM_DEVCAP_EJECTSUPPORTED = make_flag("CM_DEVCAP_EJECTSUPPORTED", ( 0x00000002 ))
CM_DEVCAP_REMOVABLE = make_flag("CM_DEVCAP_REMOVABLE", ( 0x00000004 ))
CM_DEVCAP_DOCKDEVICE = make_flag("CM_DEVCAP_DOCKDEVICE", ( 0x00000008 ))
CM_DEVCAP_UNIQUEID = make_flag("CM_DEVCAP_UNIQUEID", ( 0x00000010 ))
CM_DEVCAP_SILENTINSTALL = make_flag("CM_DEVCAP_SILENTINSTALL", ( 0x00000020 ))
CM_DEVCAP_RAWDEVICEOK = make_flag("CM_DEVCAP_RAWDEVICEOK", ( 0x00000040 ))
CM_DEVCAP_SURPRISEREMOVALOK = make_flag("CM_DEVCAP_SURPRISEREMOVALOK", ( 0x00000080 ))
CM_DEVCAP_HARDWAREDISABLED = make_flag("CM_DEVCAP_HARDWAREDISABLED", ( 0x00000100 ))
CM_DEVCAP_NONDYNAMIC = make_flag("CM_DEVCAP_NONDYNAMIC", ( 0x00000200 ))
ResType_All = make_flag("ResType_All", ( 0x00000000 ))
ResType_None = make_flag("ResType_None", ( 0x00000000 ))
ResType_Mem = make_flag("ResType_Mem", ( 0x00000001 ))
ResType_IO = make_flag("ResType_IO", ( 0x00000002 ))
ResType_DMA = make_flag("ResType_DMA", ( 0x00000003 ))
ResType_IRQ = make_flag("ResType_IRQ", ( 0x00000004 ))
ResType_DoNotUse = make_flag("ResType_DoNotUse", ( 0x00000005 ))
ResType_BusNumber = make_flag("ResType_BusNumber", ( 0x00000006 ))
ResType_MemLarge = make_flag("ResType_MemLarge", ( 0x00000007 ))
ResType_MAX = make_flag("ResType_MAX", ( 0x00000007 ))
ResType_Ignored_Bit = make_flag("ResType_Ignored_Bit", ( 0x00008000 ))
ResType_ClassSpecific = make_flag("ResType_ClassSpecific", ( 0x0000FFFF ))
ResType_Reserved = make_flag("ResType_Reserved", ( 0x00008000 ))
ResType_DevicePrivate = make_flag("ResType_DevicePrivate", ( 0x00008001 ))
ResType_PcCardConfig = make_flag("ResType_PcCardConfig", ( 0x00008002 ))
ResType_MfCardConfig = make_flag("ResType_MfCardConfig", ( 0x00008003 ))
ResType_Connection = make_flag("ResType_Connection", ( 0x00008004 ))
BASIC_LOG_CONF = make_flag("BASIC_LOG_CONF", 0x00000000)
FILTERED_LOG_CONF = make_flag("FILTERED_LOG_CONF", 0x00000001)
ALLOC_LOG_CONF = make_flag("ALLOC_LOG_CONF", 0x00000002)
BOOT_LOG_CONF = make_flag("BOOT_LOG_CONF", 0x00000003)
FORCED_LOG_CONF = make_flag("FORCED_LOG_CONF", 0x00000004)
OVERRIDE_LOG_CONF = make_flag("OVERRIDE_LOG_CONF", 0x00000005)
NUM_LOG_CONF = make_flag("NUM_LOG_CONF", 0x00000006)
LOG_CONF_BITS = make_flag("LOG_CONF_BITS", 0x00000007)
PRIORITY_EQUAL_FIRST = make_flag("PRIORITY_EQUAL_FIRST", ( 0x00000008 ))
PRIORITY_EQUAL_LAST = make_flag("PRIORITY_EQUAL_LAST", ( 0x00000000 ))
PRIORITY_BIT = make_flag("PRIORITY_BIT", ( 0x00000008 ))
CR_SUCCESS = make_flag("CR_SUCCESS", ( 0x00000000 ))
CR_DEFAULT = make_flag("CR_DEFAULT", ( 0x00000001 ))
CR_OUT_OF_MEMORY = make_flag("CR_OUT_OF_MEMORY", ( 0x00000002 ))
CR_INVALID_POINTER = make_flag("CR_INVALID_POINTER", ( 0x00000003 ))
CR_INVALID_FLAG = make_flag("CR_INVALID_FLAG", ( 0x00000004 ))
CR_INVALID_DEVNODE = make_flag("CR_INVALID_DEVNODE", ( 0x00000005 ))
CR_INVALID_DEVINST = make_flag("CR_INVALID_DEVINST", CR_INVALID_DEVNODE)
CR_INVALID_RES_DES = make_flag("CR_INVALID_RES_DES", ( 0x00000006 ))
CR_INVALID_LOG_CONF = make_flag("CR_INVALID_LOG_CONF", ( 0x00000007 ))
CR_INVALID_ARBITRATOR = make_flag("CR_INVALID_ARBITRATOR", ( 0x00000008 ))
CR_INVALID_NODELIST = make_flag("CR_INVALID_NODELIST", ( 0x00000009 ))
CR_DEVNODE_HAS_REQS = make_flag("CR_DEVNODE_HAS_REQS", ( 0x0000000A ))
CR_DEVINST_HAS_REQS = make_flag("CR_DEVINST_HAS_REQS", CR_DEVNODE_HAS_REQS)
CR_INVALID_RESOURCEID = make_flag("CR_INVALID_RESOURCEID", ( 0x0000000B ))
CR_DLVXD_NOT_FOUND = make_flag("CR_DLVXD_NOT_FOUND", ( 0x0000000C ))
CR_NO_SUCH_DEVNODE = make_flag("CR_NO_SUCH_DEVNODE", ( 0x0000000D ))
CR_NO_SUCH_DEVINST = make_flag("CR_NO_SUCH_DEVINST", CR_NO_SUCH_DEVNODE)
CR_NO_MORE_LOG_CONF = make_flag("CR_NO_MORE_LOG_CONF", ( 0x0000000E ))
CR_NO_MORE_RES_DES = make_flag("CR_NO_MORE_RES_DES", ( 0x0000000F ))
CR_ALREADY_SUCH_DEVNODE = make_flag("CR_ALREADY_SUCH_DEVNODE", ( 0x00000010 ))
CR_ALREADY_SUCH_DEVINST = make_flag("CR_ALREADY_SUCH_DEVINST", CR_ALREADY_SUCH_DEVNODE)
CR_INVALID_RANGE_LIST = make_flag("CR_INVALID_RANGE_LIST", ( 0x00000011 ))
CR_INVALID_RANGE = make_flag("CR_INVALID_RANGE", ( 0x00000012 ))
CR_FAILURE = make_flag("CR_FAILURE", ( 0x00000013 ))
CR_NO_SUCH_LOGICAL_DEV = make_flag("CR_NO_SUCH_LOGICAL_DEV", ( 0x00000014 ))
CR_CREATE_BLOCKED = make_flag("CR_CREATE_BLOCKED", ( 0x00000015 ))
CR_NOT_SYSTEM_VM = make_flag("CR_NOT_SYSTEM_VM", ( 0x00000016 ))
CR_REMOVE_VETOED = make_flag("CR_REMOVE_VETOED", ( 0x00000017 ))
CR_APM_VETOED = make_flag("CR_APM_VETOED", ( 0x00000018 ))
CR_INVALID_LOAD_TYPE = make_flag("CR_INVALID_LOAD_TYPE", ( 0x00000019 ))
CR_BUFFER_SMALL = make_flag("CR_BUFFER_SMALL", ( 0x0000001A ))
CR_NO_ARBITRATOR = make_flag("CR_NO_ARBITRATOR", ( 0x0000001B ))
CR_NO_REGISTRY_HANDLE = make_flag("CR_NO_REGISTRY_HANDLE", ( 0x0000001C ))
CR_REGISTRY_ERROR = make_flag("CR_REGISTRY_ERROR", ( 0x0000001D ))
CR_INVALID_DEVICE_ID = make_flag("CR_INVALID_DEVICE_ID", ( 0x0000001E ))
CR_INVALID_DATA = make_flag("CR_INVALID_DATA", ( 0x0000001F ))
CR_INVALID_API = make_flag("CR_INVALID_API", ( 0x00000020 ))
CR_DEVLOADER_NOT_READY = make_flag("CR_DEVLOADER_NOT_READY", ( 0x00000021 ))
CR_NEED_RESTART = make_flag("CR_NEED_RESTART", ( 0x00000022 ))
CR_NO_MORE_HW_PROFILES = make_flag("CR_NO_MORE_HW_PROFILES", ( 0x00000023 ))
CR_DEVICE_NOT_THERE = make_flag("CR_DEVICE_NOT_THERE", ( 0x00000024 ))
CR_NO_SUCH_VALUE = make_flag("CR_NO_SUCH_VALUE", ( 0x00000025 ))
CR_WRONG_TYPE = make_flag("CR_WRONG_TYPE", ( 0x00000026 ))
CR_INVALID_PRIORITY = make_flag("CR_INVALID_PRIORITY", ( 0x00000027 ))
CR_NOT_DISABLEABLE = make_flag("CR_NOT_DISABLEABLE", ( 0x00000028 ))
CR_FREE_RESOURCES = make_flag("CR_FREE_RESOURCES", ( 0x00000029 ))
CR_QUERY_VETOED = make_flag("CR_QUERY_VETOED", ( 0x0000002A ))
CR_CANT_SHARE_IRQ = make_flag("CR_CANT_SHARE_IRQ", ( 0x0000002B ))
CR_NO_DEPENDENT = make_flag("CR_NO_DEPENDENT", ( 0x0000002C ))
CR_SAME_RESOURCES = make_flag("CR_SAME_RESOURCES", ( 0x0000002D ))
CR_NO_SUCH_REGISTRY_KEY = make_flag("CR_NO_SUCH_REGISTRY_KEY", ( 0x0000002E ))
CR_INVALID_MACHINENAME = make_flag("CR_INVALID_MACHINENAME", ( 0x0000002F ))
CR_REMOTE_COMM_FAILURE = make_flag("CR_REMOTE_COMM_FAILURE", ( 0x00000030 ))
CR_MACHINE_UNAVAILABLE = make_flag("CR_MACHINE_UNAVAILABLE", ( 0x00000031 ))
CR_NO_CM_SERVICES = make_flag("CR_NO_CM_SERVICES", ( 0x00000032 ))
CR_ACCESS_DENIED = make_flag("CR_ACCESS_DENIED", ( 0x00000033 ))
CR_CALL_NOT_IMPLEMENTED = make_flag("CR_CALL_NOT_IMPLEMENTED", ( 0x00000034 ))
CR_INVALID_PROPERTY = make_flag("CR_INVALID_PROPERTY", ( 0x00000035 ))
CR_DEVICE_INTERFACE_ACTIVE = make_flag("CR_DEVICE_INTERFACE_ACTIVE", ( 0x00000036 ))
CR_NO_SUCH_DEVICE_INTERFACE = make_flag("CR_NO_SUCH_DEVICE_INTERFACE", ( 0x00000037 ))
CR_INVALID_REFERENCE_STRING = make_flag("CR_INVALID_REFERENCE_STRING", ( 0x00000038 ))
CR_INVALID_CONFLICT_LIST = make_flag("CR_INVALID_CONFLICT_LIST", ( 0x00000039 ))
CR_INVALID_INDEX = make_flag("CR_INVALID_INDEX", ( 0x0000003A ))
CR_INVALID_STRUCTURE_SIZE = make_flag("CR_INVALID_STRUCTURE_SIZE", ( 0x0000003B ))
NUM_CR_RESULTS = make_flag("NUM_CR_RESULTS", ( 0x0000003C ))
PCD_MAX_MEMORY = make_flag("PCD_MAX_MEMORY", 2)
PCD_MAX_IO = make_flag("PCD_MAX_IO", 2)
ATM_E164 = make_flag("ATM_E164", 0x01)
ATM_NSAP = make_flag("ATM_NSAP", 0x02)
ATM_AESA = make_flag("ATM_AESA", 0x02)
ATM_ADDR_SIZE = make_flag("ATM_ADDR_SIZE", 20)
DNS_ATMA_FORMAT_E164 = make_flag("DNS_ATMA_FORMAT_E164", ATM_E164)
DNS_ATMA_FORMAT_AESA = make_flag("DNS_ATMA_FORMAT_AESA", ATM_AESA)
DNS_ATMA_MAX_ADDR_LENGTH = make_flag("DNS_ATMA_MAX_ADDR_LENGTH", ATM_ADDR_SIZE)
DNS_TYPE_ZERO = make_flag("DNS_TYPE_ZERO", 0x0000)
DNS_TYPE_A = make_flag("DNS_TYPE_A", 0x0001)
DNS_TYPE_NS = make_flag("DNS_TYPE_NS", 0x0002)
DNS_TYPE_MD = make_flag("DNS_TYPE_MD", 0x0003)
DNS_TYPE_MF = make_flag("DNS_TYPE_MF", 0x0004)
DNS_TYPE_CNAME = make_flag("DNS_TYPE_CNAME", 0x0005)
DNS_TYPE_SOA = make_flag("DNS_TYPE_SOA", 0x0006)
DNS_TYPE_MB = make_flag("DNS_TYPE_MB", 0x0007)
DNS_TYPE_MG = make_flag("DNS_TYPE_MG", 0x0008)
DNS_TYPE_MR = make_flag("DNS_TYPE_MR", 0x0009)
DNS_TYPE_NULL = make_flag("DNS_TYPE_NULL", 0x000a)
DNS_TYPE_WKS = make_flag("DNS_TYPE_WKS", 0x000b)
DNS_TYPE_PTR = make_flag("DNS_TYPE_PTR", 0x000c)
DNS_TYPE_HINFO = make_flag("DNS_TYPE_HINFO", 0x000d)
DNS_TYPE_MINFO = make_flag("DNS_TYPE_MINFO", 0x000e)
DNS_TYPE_MX = make_flag("DNS_TYPE_MX", 0x000f)
DNS_TYPE_TEXT = make_flag("DNS_TYPE_TEXT", 0x0010)
DNS_TYPE_RP = make_flag("DNS_TYPE_RP", 0x0011)
DNS_TYPE_AFSDB = make_flag("DNS_TYPE_AFSDB", 0x0012)
DNS_TYPE_X25 = make_flag("DNS_TYPE_X25", 0x0013)
DNS_TYPE_ISDN = make_flag("DNS_TYPE_ISDN", 0x0014)
DNS_TYPE_RT = make_flag("DNS_TYPE_RT", 0x0015)
DNS_TYPE_NSAP = make_flag("DNS_TYPE_NSAP", 0x0016)
DNS_TYPE_NSAPPTR = make_flag("DNS_TYPE_NSAPPTR", 0x0017)
DNS_TYPE_SIG = make_flag("DNS_TYPE_SIG", 0x0018)
DNS_TYPE_KEY = make_flag("DNS_TYPE_KEY", 0x0019)
DNS_TYPE_PX = make_flag("DNS_TYPE_PX", 0x001a)
DNS_TYPE_GPOS = make_flag("DNS_TYPE_GPOS", 0x001b)
DNS_TYPE_AAAA = make_flag("DNS_TYPE_AAAA", 0x001c)
DNS_TYPE_LOC = make_flag("DNS_TYPE_LOC", 0x001d)
DNS_TYPE_NXT = make_flag("DNS_TYPE_NXT", 0x001e)
DNS_TYPE_EID = make_flag("DNS_TYPE_EID", 0x001f)
DNS_TYPE_NIMLOC = make_flag("DNS_TYPE_NIMLOC", 0x0020)
DNS_TYPE_SRV = make_flag("DNS_TYPE_SRV", 0x0021)
DNS_TYPE_ATMA = make_flag("DNS_TYPE_ATMA", 0x0022)
DNS_TYPE_NAPTR = make_flag("DNS_TYPE_NAPTR", 0x0023)
DNS_TYPE_KX = make_flag("DNS_TYPE_KX", 0x0024)
DNS_TYPE_CERT = make_flag("DNS_TYPE_CERT", 0x0025)
DNS_TYPE_A6 = make_flag("DNS_TYPE_A6", 0x0026)
DNS_TYPE_DNAME = make_flag("DNS_TYPE_DNAME", 0x0027)
DNS_TYPE_SINK = make_flag("DNS_TYPE_SINK", 0x0028)
DNS_TYPE_OPT = make_flag("DNS_TYPE_OPT", 0x0029)
DNS_TYPE_DS = make_flag("DNS_TYPE_DS", 0x002b)
DNS_TYPE_RRSIG = make_flag("DNS_TYPE_RRSIG", 0x002e)
DNS_TYPE_NSEC = make_flag("DNS_TYPE_NSEC", 0x002f)
DNS_TYPE_DNSKEY = make_flag("DNS_TYPE_DNSKEY", 0x0030)
DNS_TYPE_DHCID = make_flag("DNS_TYPE_DHCID", 0x0031)
DNS_TYPE_NSEC3 = make_flag("DNS_TYPE_NSEC3", 0x0032)
DNS_TYPE_NSEC3PARAM = make_flag("DNS_TYPE_NSEC3PARAM", 0x0033)
DNS_TYPE_UINFO = make_flag("DNS_TYPE_UINFO", 0x0064)
DNS_TYPE_UID = make_flag("DNS_TYPE_UID", 0x0065)
DNS_TYPE_GID = make_flag("DNS_TYPE_GID", 0x0066)
DNS_TYPE_UNSPEC = make_flag("DNS_TYPE_UNSPEC", 0x0067)
DNS_TYPE_ADDRS = make_flag("DNS_TYPE_ADDRS", 0x00f8)
DNS_TYPE_TKEY = make_flag("DNS_TYPE_TKEY", 0x00f9)
DNS_TYPE_TSIG = make_flag("DNS_TYPE_TSIG", 0x00fa)
DNS_TYPE_IXFR = make_flag("DNS_TYPE_IXFR", 0x00fb)
DNS_TYPE_AXFR = make_flag("DNS_TYPE_AXFR", 0x00fc)
DNS_TYPE_MAILB = make_flag("DNS_TYPE_MAILB", 0x00fd)
DNS_TYPE_MAILA = make_flag("DNS_TYPE_MAILA", 0x00fe)
DNS_TYPE_ALL = make_flag("DNS_TYPE_ALL", 0x00ff)
DNS_TYPE_ANY = make_flag("DNS_TYPE_ANY", 0x00ff)
DNS_TYPE_WINS = make_flag("DNS_TYPE_WINS", 0xff01)
DNS_TYPE_WINSR = make_flag("DNS_TYPE_WINSR", 0xff02)
DNS_TYPE_NBSTAT = make_flag("DNS_TYPE_NBSTAT", ( DNS_TYPE_WINSR ))
DNS_QUERY_STANDARD = make_flag("DNS_QUERY_STANDARD", 0x00000000)
DNS_QUERY_ACCEPT_TRUNCATED_RESPONSE = make_flag("DNS_QUERY_ACCEPT_TRUNCATED_RESPONSE", 0x00000001)
DNS_QUERY_USE_TCP_ONLY = make_flag("DNS_QUERY_USE_TCP_ONLY", 0x00000002)
DNS_QUERY_NO_RECURSION = make_flag("DNS_QUERY_NO_RECURSION", 0x00000004)
DNS_QUERY_BYPASS_CACHE = make_flag("DNS_QUERY_BYPASS_CACHE", 0x00000008)
DNS_QUERY_NO_WIRE_QUERY = make_flag("DNS_QUERY_NO_WIRE_QUERY", 0x00000010)
DNS_QUERY_NO_LOCAL_NAME = make_flag("DNS_QUERY_NO_LOCAL_NAME", 0x00000020)
DNS_QUERY_NO_HOSTS_FILE = make_flag("DNS_QUERY_NO_HOSTS_FILE", 0x00000040)
DNS_QUERY_NO_NETBT = make_flag("DNS_QUERY_NO_NETBT", 0x00000080)
DNS_QUERY_WIRE_ONLY = make_flag("DNS_QUERY_WIRE_ONLY", 0x00000100)
DNS_QUERY_RETURN_MESSAGE = make_flag("DNS_QUERY_RETURN_MESSAGE", 0x00000200)
DNS_QUERY_MULTICAST_ONLY = make_flag("DNS_QUERY_MULTICAST_ONLY", 0x00000400)
DNS_QUERY_NO_MULTICAST = make_flag("DNS_QUERY_NO_MULTICAST", 0x00000800)
DNS_QUERY_TREAT_AS_FQDN = make_flag("DNS_QUERY_TREAT_AS_FQDN", 0x00001000)
DNS_QUERY_ADDRCONFIG = make_flag("DNS_QUERY_ADDRCONFIG", 0x00002000)
DNS_QUERY_DUAL_ADDR = make_flag("DNS_QUERY_DUAL_ADDR", 0x00004000)
DNS_QUERY_DONT_RESET_TTL_VALUES = make_flag("DNS_QUERY_DONT_RESET_TTL_VALUES", 0x00100000)
DNS_QUERY_DISABLE_IDN_ENCODING = make_flag("DNS_QUERY_DISABLE_IDN_ENCODING", 0x00200000)
DNS_QUERY_APPEND_MULTILABEL = make_flag("DNS_QUERY_APPEND_MULTILABEL", 0x00800000)
DNS_QUERY_DNSSEC_OK = make_flag("DNS_QUERY_DNSSEC_OK", 0x01000000)
DNS_QUERY_DNSSEC_CHECKING_DISABLED = make_flag("DNS_QUERY_DNSSEC_CHECKING_DISABLED", 0x02000000)
DNS_QUERY_RESERVED = make_flag("DNS_QUERY_RESERVED", 0xf0000000)
EVENT_TRACE_FLAG_DISPATCHER = make_flag("EVENT_TRACE_FLAG_DISPATCHER", 0x00000800)
EVENT_TRACE_FLAG_VIRTUAL_ALLOC = make_flag("EVENT_TRACE_FLAG_VIRTUAL_ALLOC", 0x00004000)
EVENT_TRACE_FLAG_VAMAP = make_flag("EVENT_TRACE_FLAG_VAMAP", 0x00008000)
EVENT_TRACE_FLAG_NO_SYSCONFIG = make_flag("EVENT_TRACE_FLAG_NO_SYSCONFIG", 0x10000000)
EVENT_TRACE_FLAG_EXTENSION = make_flag("EVENT_TRACE_FLAG_EXTENSION", 0x80000000)
EVENT_TRACE_FLAG_FORWARD_WMI = make_flag("EVENT_TRACE_FLAG_FORWARD_WMI", 0x40000000)
EVENT_TRACE_FLAG_ENABLE_RESERVE = make_flag("EVENT_TRACE_FLAG_ENABLE_RESERVE", 0x20000000)
EVENT_TRACE_FILE_MODE_NONE = make_flag("EVENT_TRACE_FILE_MODE_NONE", 0x00000000)
EVENT_TRACE_FILE_MODE_SEQUENTIAL = make_flag("EVENT_TRACE_FILE_MODE_SEQUENTIAL", 0x00000001)
EVENT_TRACE_FILE_MODE_CIRCULAR = make_flag("EVENT_TRACE_FILE_MODE_CIRCULAR", 0x00000002)
EVENT_TRACE_FILE_MODE_APPEND = make_flag("EVENT_TRACE_FILE_MODE_APPEND", 0x00000004)
EVENT_TRACE_REAL_TIME_MODE = make_flag("EVENT_TRACE_REAL_TIME_MODE", 0x00000100)
EVENT_TRACE_DELAY_OPEN_FILE_MODE = make_flag("EVENT_TRACE_DELAY_OPEN_FILE_MODE", 0x00000200)
EVENT_TRACE_BUFFERING_MODE = make_flag("EVENT_TRACE_BUFFERING_MODE", 0x00000400)
EVENT_TRACE_PRIVATE_LOGGER_MODE = make_flag("EVENT_TRACE_PRIVATE_LOGGER_MODE", 0x00000800)
EVENT_TRACE_ADD_HEADER_MODE = make_flag("EVENT_TRACE_ADD_HEADER_MODE", 0x00001000)
EVENT_TRACE_USE_GLOBAL_SEQUENCE = make_flag("EVENT_TRACE_USE_GLOBAL_SEQUENCE", 0x00004000)
EVENT_TRACE_USE_LOCAL_SEQUENCE = make_flag("EVENT_TRACE_USE_LOCAL_SEQUENCE", 0x00008000)
EVENT_TRACE_RELOG_MODE = make_flag("EVENT_TRACE_RELOG_MODE", 0x00010000)
EVENT_TRACE_USE_PAGED_MEMORY = make_flag("EVENT_TRACE_USE_PAGED_MEMORY", 0x01000000)
EVENT_TRACE_FILE_MODE_NEWFILE = make_flag("EVENT_TRACE_FILE_MODE_NEWFILE", 0x00000008)
EVENT_TRACE_FILE_MODE_PREALLOCATE = make_flag("EVENT_TRACE_FILE_MODE_PREALLOCATE", 0x00000020)
EVENT_TRACE_CONTROL_QUERY = make_flag("EVENT_TRACE_CONTROL_QUERY", 0)
EVENT_TRACE_CONTROL_STOP = make_flag("EVENT_TRACE_CONTROL_STOP", 1)
EVENT_TRACE_CONTROL_UPDATE = make_flag("EVENT_TRACE_CONTROL_UPDATE", 2)
EVENT_TRACE_CONTROL_FLUSH = make_flag("EVENT_TRACE_CONTROL_FLUSH", 3)
PROCESS_TRACE_MODE_REAL_TIME = make_flag("PROCESS_TRACE_MODE_REAL_TIME", 0x00000100)
PROCESS_TRACE_MODE_RAW_TIMESTAMP = make_flag("PROCESS_TRACE_MODE_RAW_TIMESTAMP", 0x00001000)
PROCESS_TRACE_MODE_EVENT_RECORD = make_flag("PROCESS_TRACE_MODE_EVENT_RECORD", 0x10000000)
EVENT_HEADER_PROPERTY_XML = make_flag("EVENT_HEADER_PROPERTY_XML", 0x0001)
EVENT_HEADER_PROPERTY_FORWARDED_XML = make_flag("EVENT_HEADER_PROPERTY_FORWARDED_XML", 0x0002)
EVENT_HEADER_PROPERTY_LEGACY_EVENTLOG = make_flag("EVENT_HEADER_PROPERTY_LEGACY_EVENTLOG", 0x0004)
EVENT_HEADER_FLAG_EXTENDED_INFO = make_flag("EVENT_HEADER_FLAG_EXTENDED_INFO", 0x0001)
EVENT_HEADER_FLAG_PRIVATE_SESSION = make_flag("EVENT_HEADER_FLAG_PRIVATE_SESSION", 0x0002)
EVENT_HEADER_FLAG_STRING_ONLY = make_flag("EVENT_HEADER_FLAG_STRING_ONLY", 0x0004)
EVENT_HEADER_FLAG_TRACE_MESSAGE = make_flag("EVENT_HEADER_FLAG_TRACE_MESSAGE", 0x0008)
EVENT_HEADER_FLAG_NO_CPUTIME = make_flag("EVENT_HEADER_FLAG_NO_CPUTIME", 0x0010)
EVENT_HEADER_FLAG_32_BIT_HEADER = make_flag("EVENT_HEADER_FLAG_32_BIT_HEADER", 0x0020)
EVENT_HEADER_FLAG_64_BIT_HEADER = make_flag("EVENT_HEADER_FLAG_64_BIT_HEADER", 0x0040)
EVENT_HEADER_FLAG_CLASSIC_HEADER = make_flag("EVENT_HEADER_FLAG_CLASSIC_HEADER", 0x0100)
EVENT_HEADER_FLAG_PROCESSOR_INDEX = make_flag("EVENT_HEADER_FLAG_PROCESSOR_INDEX", 0x0200)
EVENT_TRACE_TYPE_CONFIG_CPU = make_flag("EVENT_TRACE_TYPE_CONFIG_CPU", 0x0A)
EVENT_TRACE_TYPE_CONFIG_PHYSICALDISK = make_flag("EVENT_TRACE_TYPE_CONFIG_PHYSICALDISK", 0x0B)
EVENT_TRACE_TYPE_CONFIG_LOGICALDISK = make_flag("EVENT_TRACE_TYPE_CONFIG_LOGICALDISK", 0x0C)
EVENT_TRACE_TYPE_CONFIG_NIC = make_flag("EVENT_TRACE_TYPE_CONFIG_NIC", 0x0D)
EVENT_TRACE_TYPE_CONFIG_VIDEO = make_flag("EVENT_TRACE_TYPE_CONFIG_VIDEO", 0x0E)
EVENT_TRACE_TYPE_CONFIG_SERVICES = make_flag("EVENT_TRACE_TYPE_CONFIG_SERVICES", 0x0F)
EVENT_TRACE_TYPE_CONFIG_POWER = make_flag("EVENT_TRACE_TYPE_CONFIG_POWER", 0x10)
EVENT_TRACE_TYPE_CONFIG_NETINFO = make_flag("EVENT_TRACE_TYPE_CONFIG_NETINFO", 0x11)
EVENT_TRACE_FLAG_PROCESS = make_flag("EVENT_TRACE_FLAG_PROCESS", 0x00000001)
EVENT_TRACE_FLAG_THREAD = make_flag("EVENT_TRACE_FLAG_THREAD", 0x00000002)
EVENT_TRACE_FLAG_IMAGE_LOAD = make_flag("EVENT_TRACE_FLAG_IMAGE_LOAD", 0x00000004)
EVENT_TRACE_FLAG_DISK_IO = make_flag("EVENT_TRACE_FLAG_DISK_IO", 0x00000100)
EVENT_TRACE_FLAG_DISK_FILE_IO = make_flag("EVENT_TRACE_FLAG_DISK_FILE_IO", 0x00000200)
EVENT_TRACE_FLAG_MEMORY_PAGE_FAULTS = make_flag("EVENT_TRACE_FLAG_MEMORY_PAGE_FAULTS", 0x00001000)
EVENT_TRACE_FLAG_MEMORY_HARD_FAULTS = make_flag("EVENT_TRACE_FLAG_MEMORY_HARD_FAULTS", 0x00002000)
EVENT_TRACE_FLAG_NETWORK_TCPIP = make_flag("EVENT_TRACE_FLAG_NETWORK_TCPIP", 0x00010000)
EVENT_TRACE_FLAG_REGISTRY = make_flag("EVENT_TRACE_FLAG_REGISTRY", 0x00020000)
EVENT_TRACE_FLAG_DBGPRINT = make_flag("EVENT_TRACE_FLAG_DBGPRINT", 0x00040000)
EVENT_TRACE_FLAG_VOLMGR = make_flag("EVENT_TRACE_FLAG_VOLMGR", 0x00200000)
FC_ALLOCATE_ALL_NODES = make_flag("FC_ALLOCATE_ALL_NODES", 0x01)
FC_DONT_FREE = make_flag("FC_DONT_FREE", 0x02)
FC_ALLOCED_ON_STACK = make_flag("FC_ALLOCED_ON_STACK", 0x04)
FC_SIMPLE_POINTER = make_flag("FC_SIMPLE_POINTER", 0x08)
FC_POINTER_DEREF = make_flag("FC_POINTER_DEREF", 0x10)
ACCESS_MIN_MS_ACE_TYPE = make_flag("ACCESS_MIN_MS_ACE_TYPE", ( 0x0 ))
ACCESS_ALLOWED_ACE_TYPE = make_flag("ACCESS_ALLOWED_ACE_TYPE", ( 0x0 ))
ACCESS_DENIED_ACE_TYPE = make_flag("ACCESS_DENIED_ACE_TYPE", ( 0x1 ))
SYSTEM_AUDIT_ACE_TYPE = make_flag("SYSTEM_AUDIT_ACE_TYPE", ( 0x2 ))
SYSTEM_ALARM_ACE_TYPE = make_flag("SYSTEM_ALARM_ACE_TYPE", ( 0x3 ))
ACCESS_MAX_MS_V2_ACE_TYPE = make_flag("ACCESS_MAX_MS_V2_ACE_TYPE", ( 0x3 ))
ACCESS_ALLOWED_COMPOUND_ACE_TYPE = make_flag("ACCESS_ALLOWED_COMPOUND_ACE_TYPE", ( 0x4 ))
ACCESS_MAX_MS_V3_ACE_TYPE = make_flag("ACCESS_MAX_MS_V3_ACE_TYPE", ( 0x4 ))
ACCESS_MIN_MS_OBJECT_ACE_TYPE = make_flag("ACCESS_MIN_MS_OBJECT_ACE_TYPE", ( 0x5 ))
ACCESS_ALLOWED_OBJECT_ACE_TYPE = make_flag("ACCESS_ALLOWED_OBJECT_ACE_TYPE", ( 0x5 ))
ACCESS_DENIED_OBJECT_ACE_TYPE = make_flag("ACCESS_DENIED_OBJECT_ACE_TYPE", ( 0x6 ))
SYSTEM_AUDIT_OBJECT_ACE_TYPE = make_flag("SYSTEM_AUDIT_OBJECT_ACE_TYPE", ( 0x7 ))
SYSTEM_ALARM_OBJECT_ACE_TYPE = make_flag("SYSTEM_ALARM_OBJECT_ACE_TYPE", ( 0x8 ))
ACCESS_MAX_MS_OBJECT_ACE_TYPE = make_flag("ACCESS_MAX_MS_OBJECT_ACE_TYPE", ( 0x8 ))
ACCESS_MAX_MS_V4_ACE_TYPE = make_flag("ACCESS_MAX_MS_V4_ACE_TYPE", ( 0x8 ))
ACCESS_MAX_MS_ACE_TYPE = make_flag("ACCESS_MAX_MS_ACE_TYPE", ( 0x8 ))
ACCESS_ALLOWED_CALLBACK_ACE_TYPE = make_flag("ACCESS_ALLOWED_CALLBACK_ACE_TYPE", ( 0x9 ))
ACCESS_DENIED_CALLBACK_ACE_TYPE = make_flag("ACCESS_DENIED_CALLBACK_ACE_TYPE", ( 0xA ))
ACCESS_ALLOWED_CALLBACK_OBJECT_ACE_TYPE = make_flag("ACCESS_ALLOWED_CALLBACK_OBJECT_ACE_TYPE", ( 0xB ))
ACCESS_DENIED_CALLBACK_OBJECT_ACE_TYPE = make_flag("ACCESS_DENIED_CALLBACK_OBJECT_ACE_TYPE", ( 0xC ))
SYSTEM_AUDIT_CALLBACK_ACE_TYPE = make_flag("SYSTEM_AUDIT_CALLBACK_ACE_TYPE", ( 0xD ))
SYSTEM_ALARM_CALLBACK_ACE_TYPE = make_flag("SYSTEM_ALARM_CALLBACK_ACE_TYPE", ( 0xE ))
SYSTEM_AUDIT_CALLBACK_OBJECT_ACE_TYPE = make_flag("SYSTEM_AUDIT_CALLBACK_OBJECT_ACE_TYPE", ( 0xF ))
SYSTEM_ALARM_CALLBACK_OBJECT_ACE_TYPE = make_flag("SYSTEM_ALARM_CALLBACK_OBJECT_ACE_TYPE", ( 0x10 ))
SYSTEM_MANDATORY_LABEL_ACE_TYPE = make_flag("SYSTEM_MANDATORY_LABEL_ACE_TYPE", ( 0x11 ))
ACCESS_MAX_MS_V5_ACE_TYPE = make_flag("ACCESS_MAX_MS_V5_ACE_TYPE", ( 0x11 ))
SYSTEM_RESOURCE_ATTRIBUTE_ACE_TYPE = make_flag("SYSTEM_RESOURCE_ATTRIBUTE_ACE_TYPE", ( 0x12 ))
SYSTEM_SCOPED_POLICY_ID_ACE_TYPE = make_flag("SYSTEM_SCOPED_POLICY_ID_ACE_TYPE", ( 0x13 ))
SYSTEM_PROCESS_TRUST_LABEL_ACE_TYPE = make_flag("SYSTEM_PROCESS_TRUST_LABEL_ACE_TYPE", ( 0x14 ))
ACCESS_MAX_MS_V5_ACE_TYPE = make_flag("ACCESS_MAX_MS_V5_ACE_TYPE", ( 0x14 ))
SEC_WINNT_AUTH_IDENTITY_ANSI = make_flag("SEC_WINNT_AUTH_IDENTITY_ANSI", 0x1)
SEC_WINNT_AUTH_IDENTITY_UNICODE = make_flag("SEC_WINNT_AUTH_IDENTITY_UNICODE", 0x2)
SE_OWNER_DEFAULTED = make_flag("SE_OWNER_DEFAULTED", 0x00000001)
SE_GROUP_DEFAULTED = make_flag("SE_GROUP_DEFAULTED", 0x00000002)
SE_DACL_PRESENT = make_flag("SE_DACL_PRESENT", 0x00000004)
SE_DACL_DEFAULTED = make_flag("SE_DACL_DEFAULTED", 0x00000008)
SE_SACL_PRESENT = make_flag("SE_SACL_PRESENT", 0x00000010)
SE_SACL_DEFAULTED = make_flag("SE_SACL_DEFAULTED", 0x00000020)
SE_DACL_UNTRUSTED = make_flag("SE_DACL_UNTRUSTED", ( 0x0040 ))
SE_SERVER_SECURITY = make_flag("SE_SERVER_SECURITY", ( 0x0080 ))
SE_DACL_AUTO_INHERIT_REQ = make_flag("SE_DACL_AUTO_INHERIT_REQ", 0x00000100)
SE_SACL_AUTO_INHERIT_REQ = make_flag("SE_SACL_AUTO_INHERIT_REQ", 0x00000200)
SE_DACL_AUTO_INHERITED = make_flag("SE_DACL_AUTO_INHERITED", 0x00000400)
SE_SACL_AUTO_INHERITED = make_flag("SE_SACL_AUTO_INHERITED", 0x00000800)
SE_DACL_PROTECTED = make_flag("SE_DACL_PROTECTED", 0x00001000)
SE_SACL_PROTECTED = make_flag("SE_SACL_PROTECTED", 0x00002000)
SE_RM_CONTROL_VALID = make_flag("SE_RM_CONTROL_VALID", 0x00004000)
SE_SELF_RELATIVE = make_flag("SE_SELF_RELATIVE", 0x00008000)
SDDL_REVISION_1 = make_flag("SDDL_REVISION_1", 0x1)
ACE_OBJECT_TYPE_PRESENT = make_flag("ACE_OBJECT_TYPE_PRESENT", 0x1)
ACE_INHERITED_OBJECT_TYPE_PRESENT = make_flag("ACE_INHERITED_OBJECT_TYPE_PRESENT", 0x2)
OBJECT_INHERIT_ACE = make_flag("OBJECT_INHERIT_ACE", ( 0x1 ))
CONTAINER_INHERIT_ACE = make_flag("CONTAINER_INHERIT_ACE", ( 0x2 ))
NO_PROPAGATE_INHERIT_ACE = make_flag("NO_PROPAGATE_INHERIT_ACE", ( 0x4 ))
INHERIT_ONLY_ACE = make_flag("INHERIT_ONLY_ACE", ( 0x8 ))
INHERITED_ACE = make_flag("INHERITED_ACE", ( 0x10 ))
VALID_INHERIT_FLAGS = make_flag("VALID_INHERIT_FLAGS", ( 0x1F ))
SUCCESSFUL_ACCESS_ACE_FLAG = make_flag("SUCCESSFUL_ACCESS_ACE_FLAG", ( 0x40 ))
FAILED_ACCESS_ACE_FLAG = make_flag("FAILED_ACCESS_ACE_FLAG", ( 0x80 ))
SYSTEM_MANDATORY_LABEL_NO_WRITE_UP = make_flag("SYSTEM_MANDATORY_LABEL_NO_WRITE_UP", 0x1)
SYSTEM_MANDATORY_LABEL_NO_READ_UP = make_flag("SYSTEM_MANDATORY_LABEL_NO_READ_UP", 0x2)
SYSTEM_MANDATORY_LABEL_NO_EXECUTE_UP = make_flag("SYSTEM_MANDATORY_LABEL_NO_EXECUTE_UP", 0x4)
SYSTEM_PROCESS_TRUST_LABEL_VALID_MASK = make_flag("SYSTEM_PROCESS_TRUST_LABEL_VALID_MASK", 0x00ffffff)
SYSTEM_PROCESS_TRUST_NOCONSTRAINT_MASK = make_flag("SYSTEM_PROCESS_TRUST_NOCONSTRAINT_MASK", 0xffffffff)
CLAIM_SECURITY_ATTRIBUTE_TYPE_INVALID = make_flag("CLAIM_SECURITY_ATTRIBUTE_TYPE_INVALID", 0x00)
CLAIM_SECURITY_ATTRIBUTE_TYPE_INT64 = make_flag("CLAIM_SECURITY_ATTRIBUTE_TYPE_INT64", 0x01)
CLAIM_SECURITY_ATTRIBUTE_TYPE_UINT64 = make_flag("CLAIM_SECURITY_ATTRIBUTE_TYPE_UINT64", 0x02)
CLAIM_SECURITY_ATTRIBUTE_TYPE_STRING = make_flag("CLAIM_SECURITY_ATTRIBUTE_TYPE_STRING", 0x03)
CLAIM_SECURITY_ATTRIBUTE_TYPE_FQBN = make_flag("CLAIM_SECURITY_ATTRIBUTE_TYPE_FQBN", 0x04)
CLAIM_SECURITY_ATTRIBUTE_TYPE_SID = make_flag("CLAIM_SECURITY_ATTRIBUTE_TYPE_SID", 0x05)
CLAIM_SECURITY_ATTRIBUTE_TYPE_BOOLEAN = make_flag("CLAIM_SECURITY_ATTRIBUTE_TYPE_BOOLEAN", 0x06)
CLAIM_SECURITY_ATTRIBUTE_TYPE_OCTET_STRING = make_flag("CLAIM_SECURITY_ATTRIBUTE_TYPE_OCTET_STRING", 0x10)
SE_GROUP_MANDATORY = make_flag("SE_GROUP_MANDATORY", ( 0x00000001 ))
SE_GROUP_ENABLED_BY_DEFAULT = make_flag("SE_GROUP_ENABLED_BY_DEFAULT", ( 0x00000002 ))
SE_GROUP_ENABLED = make_flag("SE_GROUP_ENABLED", ( 0x00000004 ))
SE_GROUP_OWNER = make_flag("SE_GROUP_OWNER", ( 0x00000008 ))
SE_GROUP_USE_FOR_DENY_ONLY = make_flag("SE_GROUP_USE_FOR_DENY_ONLY", ( 0x00000010 ))
SE_GROUP_INTEGRITY = make_flag("SE_GROUP_INTEGRITY", ( 0x00000020 ))
SE_GROUP_INTEGRITY_ENABLED = make_flag("SE_GROUP_INTEGRITY_ENABLED", ( 0x00000040 ))
SE_GROUP_LOGON_ID = make_flag("SE_GROUP_LOGON_ID", ( 0xC0000000 ))
SE_GROUP_RESOURCE = make_flag("SE_GROUP_RESOURCE", ( 0x20000000 ))
SE_GROUP_VALID_ATTRIBUTES = make_flag("SE_GROUP_VALID_ATTRIBUTES", ( SE_GROUP_MANDATORY | SE_GROUP_ENABLED_BY_DEFAULT | SE_GROUP_ENABLED | SE_GROUP_OWNER | SE_GROUP_USE_FOR_DENY_ONLY | SE_GROUP_LOGON_ID | SE_GROUP_RESOURCE | SE_GROUP_INTEGRITY | SE_GROUP_INTEGRITY_ENABLED ))
OWNER_SECURITY_INFORMATION = make_flag("OWNER_SECURITY_INFORMATION", ( 0x00000001 ))
GROUP_SECURITY_INFORMATION = make_flag("GROUP_SECURITY_INFORMATION", ( 0x00000002 ))
DACL_SECURITY_INFORMATION = make_flag("DACL_SECURITY_INFORMATION", ( 0x00000004 ))
SACL_SECURITY_INFORMATION = make_flag("SACL_SECURITY_INFORMATION", ( 0x00000008 ))
LABEL_SECURITY_INFORMATION = make_flag("LABEL_SECURITY_INFORMATION", ( 0x00000010 ))
ATTRIBUTE_SECURITY_INFORMATION = make_flag("ATTRIBUTE_SECURITY_INFORMATION", ( 0x00000020 ))
SCOPE_SECURITY_INFORMATION = make_flag("SCOPE_SECURITY_INFORMATION", ( 0x00000040 ))
PROCESS_TRUST_LABEL_SECURITY_INFORMATION = make_flag("PROCESS_TRUST_LABEL_SECURITY_INFORMATION", ( 0x00000080 ))
BACKUP_SECURITY_INFORMATION = make_flag("BACKUP_SECURITY_INFORMATION", ( 0x00010000 ))
PROTECTED_DACL_SECURITY_INFORMATION = make_flag("PROTECTED_DACL_SECURITY_INFORMATION", ( 0x80000000 ))
PROTECTED_SACL_SECURITY_INFORMATION = make_flag("PROTECTED_SACL_SECURITY_INFORMATION", ( 0x40000000 ))
UNPROTECTED_DACL_SECURITY_INFORMATION = make_flag("UNPROTECTED_DACL_SECURITY_INFORMATION", ( 0x20000000 ))
UNPROTECTED_SACL_SECURITY_INFORMATION = make_flag("UNPROTECTED_SACL_SECURITY_INFORMATION", ( 0x10000000 ))
EVENTLOG_SUCCESS = make_flag("EVENTLOG_SUCCESS", 0x0000)
EVENTLOG_ERROR_TYPE = make_flag("EVENTLOG_ERROR_TYPE", 0x0001)
EVENTLOG_WARNING_TYPE = make_flag("EVENTLOG_WARNING_TYPE", 0x0002)
EVENTLOG_INFORMATION_TYPE = make_flag("EVENTLOG_INFORMATION_TYPE", 0x0004)
EVENTLOG_AUDIT_SUCCESS = make_flag("EVENTLOG_AUDIT_SUCCESS", 0x0008)
EVENTLOG_AUDIT_FAILURE = make_flag("EVENTLOG_AUDIT_FAILURE", 0x0010)
EVENTLOG_SEQUENTIAL_READ = make_flag("EVENTLOG_SEQUENTIAL_READ", 0x0001)
EVENTLOG_SEEK_READ = make_flag("EVENTLOG_SEEK_READ", 0x0002)
EVENTLOG_FORWARDS_READ = make_flag("EVENTLOG_FORWARDS_READ", 0x0004)
EVENTLOG_BACKWARDS_READ = make_flag("EVENTLOG_BACKWARDS_READ", 0x0008)
EVT_VARIANT_TYPE_MASK = make_flag("EVT_VARIANT_TYPE_MASK", 0x7f)
EVT_VARIANT_TYPE_ARRAY = make_flag("EVT_VARIANT_TYPE_ARRAY", 128)
PRODUCT_UNDEFINED = make_flag("PRODUCT_UNDEFINED", 0x00000000)
PRODUCT_ULTIMATE = make_flag("PRODUCT_ULTIMATE", 0x00000001)
PRODUCT_HOME_BASIC = make_flag("PRODUCT_HOME_BASIC", 0x00000002)
PRODUCT_HOME_PREMIUM = make_flag("PRODUCT_HOME_PREMIUM", 0x00000003)
PRODUCT_ENTERPRISE = make_flag("PRODUCT_ENTERPRISE", 0x00000004)
PRODUCT_HOME_BASIC_N = make_flag("PRODUCT_HOME_BASIC_N", 0x00000005)
PRODUCT_BUSINESS = make_flag("PRODUCT_BUSINESS", 0x00000006)
PRODUCT_STANDARD_SERVER = make_flag("PRODUCT_STANDARD_SERVER", 0x00000007)
PRODUCT_DATACENTER_SERVER = make_flag("PRODUCT_DATACENTER_SERVER", 0x00000008)
PRODUCT_SMALLBUSINESS_SERVER = make_flag("PRODUCT_SMALLBUSINESS_SERVER", 0x00000009)
PRODUCT_ENTERPRISE_SERVER = make_flag("PRODUCT_ENTERPRISE_SERVER", 0x0000000A)
PRODUCT_STARTER = make_flag("PRODUCT_STARTER", 0x0000000B)
PRODUCT_DATACENTER_SERVER_CORE = make_flag("PRODUCT_DATACENTER_SERVER_CORE", 0x0000000C)
PRODUCT_STANDARD_SERVER_CORE = make_flag("PRODUCT_STANDARD_SERVER_CORE", 0x0000000D)
PRODUCT_ENTERPRISE_SERVER_CORE = make_flag("PRODUCT_ENTERPRISE_SERVER_CORE", 0x0000000E)
PRODUCT_ENTERPRISE_SERVER_IA64 = make_flag("PRODUCT_ENTERPRISE_SERVER_IA64", 0x0000000F)
PRODUCT_BUSINESS_N = make_flag("PRODUCT_BUSINESS_N", 0x00000010)
PRODUCT_WEB_SERVER = make_flag("PRODUCT_WEB_SERVER", 0x00000011)
PRODUCT_CLUSTER_SERVER = make_flag("PRODUCT_CLUSTER_SERVER", 0x00000012)
PRODUCT_HOME_SERVER = make_flag("PRODUCT_HOME_SERVER", 0x00000013)
PRODUCT_STORAGE_EXPRESS_SERVER = make_flag("PRODUCT_STORAGE_EXPRESS_SERVER", 0x00000014)
PRODUCT_STORAGE_STANDARD_SERVER = make_flag("PRODUCT_STORAGE_STANDARD_SERVER", 0x00000015)
PRODUCT_STORAGE_WORKGROUP_SERVER = make_flag("PRODUCT_STORAGE_WORKGROUP_SERVER", 0x00000016)
PRODUCT_STORAGE_ENTERPRISE_SERVER = make_flag("PRODUCT_STORAGE_ENTERPRISE_SERVER", 0x00000017)
PRODUCT_SERVER_FOR_SMALLBUSINESS = make_flag("PRODUCT_SERVER_FOR_SMALLBUSINESS", 0x00000018)
PRODUCT_SMALLBUSINESS_SERVER_PREMIUM = make_flag("PRODUCT_SMALLBUSINESS_SERVER_PREMIUM", 0x00000019)
PRODUCT_HOME_PREMIUM_N = make_flag("PRODUCT_HOME_PREMIUM_N", 0x0000001A)
PRODUCT_ENTERPRISE_N = make_flag("PRODUCT_ENTERPRISE_N", 0x0000001B)
PRODUCT_ULTIMATE_N = make_flag("PRODUCT_ULTIMATE_N", 0x0000001C)
PRODUCT_WEB_SERVER_CORE = make_flag("PRODUCT_WEB_SERVER_CORE", 0x0000001D)
PRODUCT_MEDIUMBUSINESS_SERVER_MANAGEMENT = make_flag("PRODUCT_MEDIUMBUSINESS_SERVER_MANAGEMENT", 0x0000001E)
PRODUCT_MEDIUMBUSINESS_SERVER_SECURITY = make_flag("PRODUCT_MEDIUMBUSINESS_SERVER_SECURITY", 0x0000001F)
PRODUCT_MEDIUMBUSINESS_SERVER_MESSAGING = make_flag("PRODUCT_MEDIUMBUSINESS_SERVER_MESSAGING", 0x00000020)
PRODUCT_SERVER_FOUNDATION = make_flag("PRODUCT_SERVER_FOUNDATION", 0x00000021)
PRODUCT_HOME_PREMIUM_SERVER = make_flag("PRODUCT_HOME_PREMIUM_SERVER", 0x00000022)
PRODUCT_SERVER_FOR_SMALLBUSINESS_V = make_flag("PRODUCT_SERVER_FOR_SMALLBUSINESS_V", 0x00000023)
PRODUCT_STANDARD_SERVER_V = make_flag("PRODUCT_STANDARD_SERVER_V", 0x00000024)
PRODUCT_DATACENTER_SERVER_V = make_flag("PRODUCT_DATACENTER_SERVER_V", 0x00000025)
PRODUCT_ENTERPRISE_SERVER_V = make_flag("PRODUCT_ENTERPRISE_SERVER_V", 0x00000026)
PRODUCT_DATACENTER_SERVER_CORE_V = make_flag("PRODUCT_DATACENTER_SERVER_CORE_V", 0x00000027)
PRODUCT_STANDARD_SERVER_CORE_V = make_flag("PRODUCT_STANDARD_SERVER_CORE_V", 0x00000028)
PRODUCT_ENTERPRISE_SERVER_CORE_V = make_flag("PRODUCT_ENTERPRISE_SERVER_CORE_V", 0x00000029)
PRODUCT_HYPERV = make_flag("PRODUCT_HYPERV", 0x0000002A)
PRODUCT_STORAGE_EXPRESS_SERVER_CORE = make_flag("PRODUCT_STORAGE_EXPRESS_SERVER_CORE", 0x0000002B)
PRODUCT_STORAGE_STANDARD_SERVER_CORE = make_flag("PRODUCT_STORAGE_STANDARD_SERVER_CORE", 0x0000002C)
PRODUCT_STORAGE_WORKGROUP_SERVER_CORE = make_flag("PRODUCT_STORAGE_WORKGROUP_SERVER_CORE", 0x0000002D)
PRODUCT_STORAGE_ENTERPRISE_SERVER_CORE = make_flag("PRODUCT_STORAGE_ENTERPRISE_SERVER_CORE", 0x0000002E)
PRODUCT_STARTER_N = make_flag("PRODUCT_STARTER_N", 0x0000002F)
PRODUCT_PROFESSIONAL = make_flag("PRODUCT_PROFESSIONAL", 0x00000030)
PRODUCT_PROFESSIONAL_N = make_flag("PRODUCT_PROFESSIONAL_N", 0x00000031)
PRODUCT_SB_SOLUTION_SERVER = make_flag("PRODUCT_SB_SOLUTION_SERVER", 0x00000032)
PRODUCT_SERVER_FOR_SB_SOLUTIONS = make_flag("PRODUCT_SERVER_FOR_SB_SOLUTIONS", 0x00000033)
PRODUCT_STANDARD_SERVER_SOLUTIONS = make_flag("PRODUCT_STANDARD_SERVER_SOLUTIONS", 0x00000034)
PRODUCT_STANDARD_SERVER_SOLUTIONS_CORE = make_flag("PRODUCT_STANDARD_SERVER_SOLUTIONS_CORE", 0x00000035)
PRODUCT_SB_SOLUTION_SERVER_EM = make_flag("PRODUCT_SB_SOLUTION_SERVER_EM", 0x00000036)
PRODUCT_SERVER_FOR_SB_SOLUTIONS_EM = make_flag("PRODUCT_SERVER_FOR_SB_SOLUTIONS_EM", 0x00000037)
PRODUCT_SOLUTION_EMBEDDEDSERVER = make_flag("PRODUCT_SOLUTION_EMBEDDEDSERVER", 0x00000038)
PRODUCT_SOLUTION_EMBEDDEDSERVER_CORE = make_flag("PRODUCT_SOLUTION_EMBEDDEDSERVER_CORE", 0x00000039)
PRODUCT_SMALLBUSINESS_SERVER_PREMIUM_CORE = make_flag("PRODUCT_SMALLBUSINESS_SERVER_PREMIUM_CORE", 0x0000003F)
PRODUCT_ESSENTIALBUSINESS_SERVER_MGMT = make_flag("PRODUCT_ESSENTIALBUSINESS_SERVER_MGMT", 0x0000003B)
PRODUCT_ESSENTIALBUSINESS_SERVER_ADDL = make_flag("PRODUCT_ESSENTIALBUSINESS_SERVER_ADDL", 0x0000003C)
PRODUCT_ESSENTIALBUSINESS_SERVER_MGMTSVC = make_flag("PRODUCT_ESSENTIALBUSINESS_SERVER_MGMTSVC", 0x0000003D)
PRODUCT_ESSENTIALBUSINESS_SERVER_ADDLSVC = make_flag("PRODUCT_ESSENTIALBUSINESS_SERVER_ADDLSVC", 0x0000003E)
PRODUCT_CLUSTER_SERVER_V = make_flag("PRODUCT_CLUSTER_SERVER_V", 0x00000040)
PRODUCT_EMBEDDED = make_flag("PRODUCT_EMBEDDED", 0x00000041)
PRODUCT_STARTER_E = make_flag("PRODUCT_STARTER_E", 0x00000042)
PRODUCT_HOME_BASIC_E = make_flag("PRODUCT_HOME_BASIC_E", 0x00000043)
PRODUCT_HOME_PREMIUM_E = make_flag("PRODUCT_HOME_PREMIUM_E", 0x00000044)
PRODUCT_PROFESSIONAL_E = make_flag("PRODUCT_PROFESSIONAL_E", 0x00000045)
PRODUCT_ENTERPRISE_E = make_flag("PRODUCT_ENTERPRISE_E", 0x00000046)
PRODUCT_ULTIMATE_E = make_flag("PRODUCT_ULTIMATE_E", 0x00000047)
PRODUCT_ENTERPRISE_EVALUATION = make_flag("PRODUCT_ENTERPRISE_EVALUATION", 0x00000048)
PRODUCT_MULTIPOINT_STANDARD_SERVER = make_flag("PRODUCT_MULTIPOINT_STANDARD_SERVER", 0x0000004C)
PRODUCT_MULTIPOINT_PREMIUM_SERVER = make_flag("PRODUCT_MULTIPOINT_PREMIUM_SERVER", 0x0000004D)
PRODUCT_STANDARD_EVALUATION_SERVER = make_flag("PRODUCT_STANDARD_EVALUATION_SERVER", 0x0000004F)
PRODUCT_DATACENTER_EVALUATION_SERVER = make_flag("PRODUCT_DATACENTER_EVALUATION_SERVER", 0x00000050)
PRODUCT_ENTERPRISE_N_EVALUATION = make_flag("PRODUCT_ENTERPRISE_N_EVALUATION", 0x00000054)
PRODUCT_STORAGE_WORKGROUP_EVALUATION_SERVER = make_flag("PRODUCT_STORAGE_WORKGROUP_EVALUATION_SERVER", 0x0000005F)
PRODUCT_STORAGE_STANDARD_EVALUATION_SERVER = make_flag("PRODUCT_STORAGE_STANDARD_EVALUATION_SERVER", 0x00000060)
PRODUCT_CORE_ARM = make_flag("PRODUCT_CORE_ARM", 0x00000061)
PRODUCT_CORE_N = make_flag("PRODUCT_CORE_N", 0x00000062)
PRODUCT_CORE_COUNTRYSPECIFIC = make_flag("PRODUCT_CORE_COUNTRYSPECIFIC", 0x00000063)
PRODUCT_CORE_LANGUAGESPECIFIC = make_flag("PRODUCT_CORE_LANGUAGESPECIFIC", 0x00000064)
PRODUCT_CORE = make_flag("PRODUCT_CORE", 0x00000065)
PRODUCT_PROFESSIONAL_WMC = make_flag("PRODUCT_PROFESSIONAL_WMC", 0x00000067)
PRODUCT_UNLICENSED = make_flag("PRODUCT_UNLICENSED", 0xABCDABCD)
X86_KGDT_NULL = make_flag("X86_KGDT_NULL", 0)
X86_KGDT_R0_CODE = make_flag("X86_KGDT_R0_CODE", 8)
X86_KGDT_R0_DATA = make_flag("X86_KGDT_R0_DATA", 16)
X86_KGDT_R3_CODE = make_flag("X86_KGDT_R3_CODE", 24)
X86_KGDT_R3_DATA = make_flag("X86_KGDT_R3_DATA", 32)
X86_KGDT_TSS = make_flag("X86_KGDT_TSS", 40)
X86_KGDT_R0_PCR = make_flag("X86_KGDT_R0_PCR", 48)
X86_KGDT_R3_TEB = make_flag("X86_KGDT_R3_TEB", 56)
X86_KGDT_VDM_TILE = make_flag("X86_KGDT_VDM_TILE", 64)
X86_KGDT_LDT = make_flag("X86_KGDT_LDT", 72)
X86_KGDT_DF_TSS = make_flag("X86_KGDT_DF_TSS", 80)
X86_KGDT_NMI_TSS = make_flag("X86_KGDT_NMI_TSS", 88)
X86_FRAME_EDITED = make_flag("X86_FRAME_EDITED", 0xfff8)
X86_MODE_MASK = make_flag("X86_MODE_MASK", 1)
X86_EFLAGS_V86_MASK = make_flag("X86_EFLAGS_V86_MASK", 0x00020000)
AMD64_KGDT64_NULL = make_flag("AMD64_KGDT64_NULL", ( 0 * 16 ))
AMD64_KGDT64_R0_CODE = make_flag("AMD64_KGDT64_R0_CODE", ( 1 * 16 ))
AMD64_KGDT64_R0_DATA = make_flag("AMD64_KGDT64_R0_DATA", ( 1 * 16 ) + 8)
AMD64_KGDT64_R3_CMCODE = make_flag("AMD64_KGDT64_R3_CMCODE", ( 2 * 16 ))
AMD64_KGDT64_R3_DATA = make_flag("AMD64_KGDT64_R3_DATA", ( 2 * 16 ) + 8)
AMD64_KGDT64_R3_CODE = make_flag("AMD64_KGDT64_R3_CODE", ( 3 * 16 ))
AMD64_KGDT64_SYS_TSS = make_flag("AMD64_KGDT64_SYS_TSS", ( 4 * 16 ))
AMD64_KGDT64_R3_CMTEB = make_flag("AMD64_KGDT64_R3_CMTEB", ( 5 * 16 ))
AMD64_KGDT64_LAST = make_flag("AMD64_KGDT64_LAST", ( 6 * 16 ))
MODE_BIT = make_flag("MODE_BIT", 0)
MODE_MASK = make_flag("MODE_MASK", 1)
RPL_MASK = make_flag("RPL_MASK", 3)
CS_USER_32B = make_flag("CS_USER_32B", ( AMD64_KGDT64_R3_CMCODE | RPL_MASK ))
CS_USER_64B = make_flag("CS_USER_64B", ( AMD64_KGDT64_R3_CODE | RPL_MASK ))
OS_WINDOWS = make_flag("OS_WINDOWS", 0)
OS_NT = make_flag("OS_NT", 1)
OS_WIN95ORGREATER = make_flag("OS_WIN95ORGREATER", 2)
OS_NT4ORGREATER = make_flag("OS_NT4ORGREATER", 3)
OS_WIN98ORGREATER = make_flag("OS_WIN98ORGREATER", 5)
OS_WIN98_GOLD = make_flag("OS_WIN98_GOLD", 6)
OS_WIN2000ORGREATER = make_flag("OS_WIN2000ORGREATER", 7)
OS_WIN2000PRO = make_flag("OS_WIN2000PRO", 8)
OS_WIN2000SERVER = make_flag("OS_WIN2000SERVER", 9)
OS_WIN2000ADVSERVER = make_flag("OS_WIN2000ADVSERVER", 10)
OS_WIN2000DATACENTER = make_flag("OS_WIN2000DATACENTER", 11)
OS_WIN2000TERMINAL = make_flag("OS_WIN2000TERMINAL", 12)
OS_EMBEDDED = make_flag("OS_EMBEDDED", 13)
OS_TERMINALCLIENT = make_flag("OS_TERMINALCLIENT", 14)
OS_TERMINALREMOTEADMIN = make_flag("OS_TERMINALREMOTEADMIN", 15)
OS_WIN95_GOLD = make_flag("OS_WIN95_GOLD", 16)
OS_MEORGREATER = make_flag("OS_MEORGREATER", 17)
OS_XPORGREATER = make_flag("OS_XPORGREATER", 18)
OS_HOME = make_flag("OS_HOME", 19)
OS_PROFESSIONAL = make_flag("OS_PROFESSIONAL", 20)
OS_DATACENTER = make_flag("OS_DATACENTER", 21)
OS_ADVSERVER = make_flag("OS_ADVSERVER", 22)
OS_SERVER = make_flag("OS_SERVER", 23)
OS_TERMINALSERVER = make_flag("OS_TERMINALSERVER", 24)
OS_PERSONALTERMINALSERVER = make_flag("OS_PERSONALTERMINALSERVER", 25)
OS_FASTUSERSWITCHING = make_flag("OS_FASTUSERSWITCHING", 26)
OS_WELCOMELOGONUI = make_flag("OS_WELCOMELOGONUI", 27)
OS_DOMAINMEMBER = make_flag("OS_DOMAINMEMBER", 28)
OS_ANYSERVER = make_flag("OS_ANYSERVER", 29)
OS_WOW6432 = make_flag("OS_WOW6432", 30)
OS_WEBSERVER = make_flag("OS_WEBSERVER", 31)
OS_SMALLBUSINESSSERVER = make_flag("OS_SMALLBUSINESSSERVER", 32)
OS_TABLETPC = make_flag("OS_TABLETPC", 33)
OS_SERVERADMINUI = make_flag("OS_SERVERADMINUI", 34)
OS_MEDIACENTER = make_flag("OS_MEDIACENTER", 35)
OS_APPLIANCE = make_flag("OS_APPLIANCE", 36)
APPLICATION_ERROR_MASK = make_flag("APPLICATION_ERROR_MASK", 0x20000000)
ERROR_SEVERITY_SUCCESS = make_flag("ERROR_SEVERITY_SUCCESS", 0x00000000)
ERROR_SEVERITY_INFORMATIONAL = make_flag("ERROR_SEVERITY_INFORMATIONAL", 0x40000000)
ERROR_SEVERITY_WARNING = make_flag("ERROR_SEVERITY_WARNING", 0x80000000)
ERROR_SEVERITY_ERROR = make_flag("ERROR_SEVERITY_ERROR", 0xC0000000)
SPDRP_DEVICEDESC = make_flag("SPDRP_DEVICEDESC", ( 0x00000000 ))
SPDRP_HARDWAREID = make_flag("SPDRP_HARDWAREID", ( 0x00000001 ))
SPDRP_COMPATIBLEIDS = make_flag("SPDRP_COMPATIBLEIDS", ( 0x00000002 ))
SPDRP_UNUSED0 = make_flag("SPDRP_UNUSED0", ( 0x00000003 ))
SPDRP_SERVICE = make_flag("SPDRP_SERVICE", ( 0x00000004 ))
SPDRP_UNUSED1 = make_flag("SPDRP_UNUSED1", ( 0x00000005 ))
SPDRP_UNUSED2 = make_flag("SPDRP_UNUSED2", ( 0x00000006 ))
SPDRP_CLASS = make_flag("SPDRP_CLASS", ( 0x00000007 ))
SPDRP_CLASSGUID = make_flag("SPDRP_CLASSGUID", ( 0x00000008 ))
SPDRP_DRIVER = make_flag("SPDRP_DRIVER", ( 0x00000009 ))
SPDRP_CONFIGFLAGS = make_flag("SPDRP_CONFIGFLAGS", ( 0x0000000A ))
SPDRP_MFG = make_flag("SPDRP_MFG", ( 0x0000000B ))
SPDRP_FRIENDLYNAME = make_flag("SPDRP_FRIENDLYNAME", ( 0x0000000C ))
SPDRP_LOCATION_INFORMATION = make_flag("SPDRP_LOCATION_INFORMATION", ( 0x0000000D ))
SPDRP_PHYSICAL_DEVICE_OBJECT_NAME = make_flag("SPDRP_PHYSICAL_DEVICE_OBJECT_NAME", ( 0x0000000E ))
SPDRP_CAPABILITIES = make_flag("SPDRP_CAPABILITIES", ( 0x0000000F ))
SPDRP_UI_NUMBER = make_flag("SPDRP_UI_NUMBER", ( 0x00000010 ))
SPDRP_UPPERFILTERS = make_flag("SPDRP_UPPERFILTERS", ( 0x00000011 ))
SPDRP_LOWERFILTERS = make_flag("SPDRP_LOWERFILTERS", ( 0x00000012 ))
SPDRP_BUSTYPEGUID = make_flag("SPDRP_BUSTYPEGUID", ( 0x00000013 ))
SPDRP_LEGACYBUSTYPE = make_flag("SPDRP_LEGACYBUSTYPE", ( 0x00000014 ))
SPDRP_BUSNUMBER = make_flag("SPDRP_BUSNUMBER", ( 0x00000015 ))
SPDRP_ENUMERATOR_NAME = make_flag("SPDRP_ENUMERATOR_NAME", ( 0x00000016 ))
SPDRP_SECURITY = make_flag("SPDRP_SECURITY", ( 0x00000017 ))
SPDRP_SECURITY_SDS = make_flag("SPDRP_SECURITY_SDS", ( 0x00000018 ))
SPDRP_DEVTYPE = make_flag("SPDRP_DEVTYPE", ( 0x00000019 ))
SPDRP_EXCLUSIVE = make_flag("SPDRP_EXCLUSIVE", ( 0x0000001A ))
SPDRP_CHARACTERISTICS = make_flag("SPDRP_CHARACTERISTICS", ( 0x0000001B ))
SPDRP_ADDRESS = make_flag("SPDRP_ADDRESS", ( 0x0000001C ))
SPDRP_UI_NUMBER_DESC_FORMAT = make_flag("SPDRP_UI_NUMBER_DESC_FORMAT", ( 0X0000001D ))
SPDRP_DEVICE_POWER_DATA = make_flag("SPDRP_DEVICE_POWER_DATA", ( 0x0000001E ))
SPDRP_REMOVAL_POLICY = make_flag("SPDRP_REMOVAL_POLICY", ( 0x0000001F ))
SPDRP_REMOVAL_POLICY_HW_DEFAULT = make_flag("SPDRP_REMOVAL_POLICY_HW_DEFAULT", ( 0x00000020 ))
SPDRP_REMOVAL_POLICY_OVERRIDE = make_flag("SPDRP_REMOVAL_POLICY_OVERRIDE", ( 0x00000021 ))
SPDRP_INSTALL_STATE = make_flag("SPDRP_INSTALL_STATE", ( 0x00000022 ))
SPDRP_LOCATION_PATHS = make_flag("SPDRP_LOCATION_PATHS", ( 0x00000023 ))
SPDRP_BASE_CONTAINERID = make_flag("SPDRP_BASE_CONTAINERID", ( 0x00000024 ))
SPDRP_MAXIMUM_PROPERTY = make_flag("SPDRP_MAXIMUM_PROPERTY", ( 0x00000025 ))
ERROR_EXPECTED_SECTION_NAME = make_flag("ERROR_EXPECTED_SECTION_NAME", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0 ))
ERROR_BAD_SECTION_NAME_LINE = make_flag("ERROR_BAD_SECTION_NAME_LINE", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|1 ))
ERROR_SECTION_NAME_TOO_LONG = make_flag("ERROR_SECTION_NAME_TOO_LONG", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|2 ))
ERROR_GENERAL_SYNTAX = make_flag("ERROR_GENERAL_SYNTAX", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|3 ))
ERROR_WRONG_INF_STYLE = make_flag("ERROR_WRONG_INF_STYLE", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x100 ))
ERROR_SECTION_NOT_FOUND = make_flag("ERROR_SECTION_NOT_FOUND", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x101 ))
ERROR_LINE_NOT_FOUND = make_flag("ERROR_LINE_NOT_FOUND", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x102 ))
ERROR_NO_BACKUP = make_flag("ERROR_NO_BACKUP", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x103 ))
ERROR_NO_ASSOCIATED_CLASS = make_flag("ERROR_NO_ASSOCIATED_CLASS", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x200 ))
ERROR_CLASS_MISMATCH = make_flag("ERROR_CLASS_MISMATCH", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x201 ))
ERROR_DUPLICATE_FOUND = make_flag("ERROR_DUPLICATE_FOUND", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x202 ))
ERROR_NO_DRIVER_SELECTED = make_flag("ERROR_NO_DRIVER_SELECTED", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x203 ))
ERROR_KEY_DOES_NOT_EXIST = make_flag("ERROR_KEY_DOES_NOT_EXIST", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x204 ))
ERROR_INVALID_DEVINST_NAME = make_flag("ERROR_INVALID_DEVINST_NAME", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x205 ))
ERROR_INVALID_CLASS = make_flag("ERROR_INVALID_CLASS", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x206 ))
ERROR_DEVINST_ALREADY_EXISTS = make_flag("ERROR_DEVINST_ALREADY_EXISTS", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x207 ))
ERROR_DEVINFO_NOT_REGISTERED = make_flag("ERROR_DEVINFO_NOT_REGISTERED", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x208 ))
ERROR_INVALID_REG_PROPERTY = make_flag("ERROR_INVALID_REG_PROPERTY", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x209 ))
ERROR_NO_INF = make_flag("ERROR_NO_INF", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x20A ))
ERROR_NO_SUCH_DEVINST = make_flag("ERROR_NO_SUCH_DEVINST", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x20B ))
ERROR_CANT_LOAD_CLASS_ICON = make_flag("ERROR_CANT_LOAD_CLASS_ICON", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x20C ))
ERROR_INVALID_CLASS_INSTALLER = make_flag("ERROR_INVALID_CLASS_INSTALLER", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x20D ))
ERROR_DI_DO_DEFAULT = make_flag("ERROR_DI_DO_DEFAULT", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x20E ))
ERROR_DI_NOFILECOPY = make_flag("ERROR_DI_NOFILECOPY", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x20F ))
ERROR_INVALID_HWPROFILE = make_flag("ERROR_INVALID_HWPROFILE", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x210 ))
ERROR_NO_DEVICE_SELECTED = make_flag("ERROR_NO_DEVICE_SELECTED", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x211 ))
ERROR_DEVINFO_LIST_LOCKED = make_flag("ERROR_DEVINFO_LIST_LOCKED", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x212 ))
ERROR_DEVINFO_DATA_LOCKED = make_flag("ERROR_DEVINFO_DATA_LOCKED", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x213 ))
ERROR_DI_BAD_PATH = make_flag("ERROR_DI_BAD_PATH", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x214 ))
ERROR_NO_CLASSINSTALL_PARAMS = make_flag("ERROR_NO_CLASSINSTALL_PARAMS", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x215 ))
ERROR_FILEQUEUE_LOCKED = make_flag("ERROR_FILEQUEUE_LOCKED", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x216 ))
ERROR_BAD_SERVICE_INSTALLSECT = make_flag("ERROR_BAD_SERVICE_INSTALLSECT", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x217 ))
ERROR_NO_CLASS_DRIVER_LIST = make_flag("ERROR_NO_CLASS_DRIVER_LIST", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x218 ))
ERROR_NO_ASSOCIATED_SERVICE = make_flag("ERROR_NO_ASSOCIATED_SERVICE", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x219 ))
ERROR_NO_DEFAULT_DEVICE_INTERFACE = make_flag("ERROR_NO_DEFAULT_DEVICE_INTERFACE", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x21A ))
ERROR_DEVICE_INTERFACE_ACTIVE = make_flag("ERROR_DEVICE_INTERFACE_ACTIVE", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x21B ))
ERROR_DEVICE_INTERFACE_REMOVED = make_flag("ERROR_DEVICE_INTERFACE_REMOVED", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x21C ))
ERROR_BAD_INTERFACE_INSTALLSECT = make_flag("ERROR_BAD_INTERFACE_INSTALLSECT", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x21D ))
ERROR_NO_SUCH_INTERFACE_CLASS = make_flag("ERROR_NO_SUCH_INTERFACE_CLASS", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x21E ))
ERROR_INVALID_REFERENCE_STRING = make_flag("ERROR_INVALID_REFERENCE_STRING", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x21F ))
ERROR_INVALID_MACHINENAME = make_flag("ERROR_INVALID_MACHINENAME", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x220 ))
ERROR_REMOTE_COMM_FAILURE = make_flag("ERROR_REMOTE_COMM_FAILURE", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x221 ))
ERROR_MACHINE_UNAVAILABLE = make_flag("ERROR_MACHINE_UNAVAILABLE", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x222 ))
ERROR_NO_CONFIGMGR_SERVICES = make_flag("ERROR_NO_CONFIGMGR_SERVICES", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x223 ))
ERROR_INVALID_PROPPAGE_PROVIDER = make_flag("ERROR_INVALID_PROPPAGE_PROVIDER", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x224 ))
ERROR_NO_SUCH_DEVICE_INTERFACE = make_flag("ERROR_NO_SUCH_DEVICE_INTERFACE", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x225 ))
ERROR_DI_POSTPROCESSING_REQUIRED = make_flag("ERROR_DI_POSTPROCESSING_REQUIRED", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x226 ))
ERROR_INVALID_COINSTALLER = make_flag("ERROR_INVALID_COINSTALLER", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x227 ))
ERROR_NO_COMPAT_DRIVERS = make_flag("ERROR_NO_COMPAT_DRIVERS", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x228 ))
ERROR_NO_DEVICE_ICON = make_flag("ERROR_NO_DEVICE_ICON", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x229 ))
ERROR_INVALID_INF_LOGCONFIG = make_flag("ERROR_INVALID_INF_LOGCONFIG", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x22A ))
ERROR_DI_DONT_INSTALL = make_flag("ERROR_DI_DONT_INSTALL", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x22B ))
ERROR_INVALID_FILTER_DRIVER = make_flag("ERROR_INVALID_FILTER_DRIVER", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x22C ))
ERROR_NON_WINDOWS_NT_DRIVER = make_flag("ERROR_NON_WINDOWS_NT_DRIVER", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x22D ))
ERROR_NON_WINDOWS_DRIVER = make_flag("ERROR_NON_WINDOWS_DRIVER", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x22E ))
ERROR_NO_CATALOG_FOR_OEM_INF = make_flag("ERROR_NO_CATALOG_FOR_OEM_INF", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x22F ))
ERROR_DEVINSTALL_QUEUE_NONNATIVE = make_flag("ERROR_DEVINSTALL_QUEUE_NONNATIVE", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x230 ))
ERROR_NOT_DISABLEABLE = make_flag("ERROR_NOT_DISABLEABLE", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x231 ))
ERROR_CANT_REMOVE_DEVINST = make_flag("ERROR_CANT_REMOVE_DEVINST", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x232 ))
ERROR_INVALID_TARGET = make_flag("ERROR_INVALID_TARGET", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x233 ))
ERROR_DRIVER_NONNATIVE = make_flag("ERROR_DRIVER_NONNATIVE", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x234 ))
ERROR_IN_WOW64 = make_flag("ERROR_IN_WOW64", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x235 ))
ERROR_SET_SYSTEM_RESTORE_POINT = make_flag("ERROR_SET_SYSTEM_RESTORE_POINT", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x236 ))
ERROR_SCE_DISABLED = make_flag("ERROR_SCE_DISABLED", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x238 ))
ERROR_UNKNOWN_EXCEPTION = make_flag("ERROR_UNKNOWN_EXCEPTION", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x239 ))
ERROR_PNP_REGISTRY_ERROR = make_flag("ERROR_PNP_REGISTRY_ERROR", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x23A ))
ERROR_REMOTE_REQUEST_UNSUPPORTED = make_flag("ERROR_REMOTE_REQUEST_UNSUPPORTED", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x23B ))
ERROR_NOT_AN_INSTALLED_OEM_INF = make_flag("ERROR_NOT_AN_INSTALLED_OEM_INF", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x23C ))
ERROR_INF_IN_USE_BY_DEVICES = make_flag("ERROR_INF_IN_USE_BY_DEVICES", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x23D ))
ERROR_DI_FUNCTION_OBSOLETE = make_flag("ERROR_DI_FUNCTION_OBSOLETE", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x23E ))
ERROR_NO_AUTHENTICODE_CATALOG = make_flag("ERROR_NO_AUTHENTICODE_CATALOG", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x23F ))
ERROR_AUTHENTICODE_DISALLOWED = make_flag("ERROR_AUTHENTICODE_DISALLOWED", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x240 ))
ERROR_AUTHENTICODE_TRUSTED_PUBLISHER = make_flag("ERROR_AUTHENTICODE_TRUSTED_PUBLISHER", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x241 ))
ERROR_AUTHENTICODE_TRUST_NOT_ESTABLISHED = make_flag("ERROR_AUTHENTICODE_TRUST_NOT_ESTABLISHED", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x242 ))
ERROR_AUTHENTICODE_PUBLISHER_NOT_TRUSTED = make_flag("ERROR_AUTHENTICODE_PUBLISHER_NOT_TRUSTED", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x243 ))
ERROR_SIGNATURE_OSATTRIBUTE_MISMATCH = make_flag("ERROR_SIGNATURE_OSATTRIBUTE_MISMATCH", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x244 ))
ERROR_ONLY_VALIDATE_VIA_AUTHENTICODE = make_flag("ERROR_ONLY_VALIDATE_VIA_AUTHENTICODE", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x245 ))
ERROR_DEVICE_INSTALLER_NOT_READY = make_flag("ERROR_DEVICE_INSTALLER_NOT_READY", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x246 ))
ERROR_DRIVER_STORE_ADD_FAILED = make_flag("ERROR_DRIVER_STORE_ADD_FAILED", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x247 ))
ERROR_DEVICE_INSTALL_BLOCKED = make_flag("ERROR_DEVICE_INSTALL_BLOCKED", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x248 ))
ERROR_DRIVER_INSTALL_BLOCKED = make_flag("ERROR_DRIVER_INSTALL_BLOCKED", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x249 ))
ERROR_WRONG_INF_TYPE = make_flag("ERROR_WRONG_INF_TYPE", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x24A ))
ERROR_FILE_HASH_NOT_IN_CATALOG = make_flag("ERROR_FILE_HASH_NOT_IN_CATALOG", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x24B ))
ERROR_DRIVER_STORE_DELETE_FAILED = make_flag("ERROR_DRIVER_STORE_DELETE_FAILED", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x24C ))
ERROR_UNRECOVERABLE_STACK_OVERFLOW = make_flag("ERROR_UNRECOVERABLE_STACK_OVERFLOW", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x300 ))
EXCEPTION_SPAPI_UNRECOVERABLE_STACK_OVERFLOW = make_flag("EXCEPTION_SPAPI_UNRECOVERABLE_STACK_OVERFLOW", ERROR_UNRECOVERABLE_STACK_OVERFLOW)
ERROR_NO_DEFAULT_INTERFACE_DEVICE = make_flag("ERROR_NO_DEFAULT_INTERFACE_DEVICE", ERROR_NO_DEFAULT_DEVICE_INTERFACE)
ERROR_INTERFACE_DEVICE_ACTIVE = make_flag("ERROR_INTERFACE_DEVICE_ACTIVE", ERROR_DEVICE_INTERFACE_ACTIVE)
ERROR_INTERFACE_DEVICE_REMOVED = make_flag("ERROR_INTERFACE_DEVICE_REMOVED", ERROR_DEVICE_INTERFACE_REMOVED)
ERROR_NO_SUCH_INTERFACE_DEVICE = make_flag("ERROR_NO_SUCH_INTERFACE_DEVICE", ERROR_NO_SUCH_DEVICE_INTERFACE)
ERROR_NOT_INSTALLED = make_flag("ERROR_NOT_INSTALLED", ( APPLICATION_ERROR_MASK|ERROR_SEVERITY_ERROR|0x1000 ))
PIPE_ACCESS_INBOUND = make_flag("PIPE_ACCESS_INBOUND", 0x00000001)
PIPE_ACCESS_OUTBOUND = make_flag("PIPE_ACCESS_OUTBOUND", 0x00000002)
PIPE_ACCESS_DUPLEX = make_flag("PIPE_ACCESS_DUPLEX", 0x00000003)
PIPE_CLIENT_END = make_flag("PIPE_CLIENT_END", 0x00000000)
PIPE_SERVER_END = make_flag("PIPE_SERVER_END", 0x00000001)
PIPE_WAIT = make_flag("PIPE_WAIT", 0x00000000)
PIPE_NOWAIT = make_flag("PIPE_NOWAIT", 0x00000001)
PIPE_READMODE_BYTE = make_flag("PIPE_READMODE_BYTE", 0x00000000)
PIPE_READMODE_MESSAGE = make_flag("PIPE_READMODE_MESSAGE", 0x00000002)
PIPE_TYPE_BYTE = make_flag("PIPE_TYPE_BYTE", 0x00000000)
PIPE_TYPE_MESSAGE = make_flag("PIPE_TYPE_MESSAGE", 0x00000004)
PIPE_ACCEPT_REMOTE_CLIENTS = make_flag("PIPE_ACCEPT_REMOTE_CLIENTS", 0x00000000)
PIPE_REJECT_REMOTE_CLIENTS = make_flag("PIPE_REJECT_REMOTE_CLIENTS", 0x00000008)
PIPE_UNLIMITED_INSTANCES = make_flag("PIPE_UNLIMITED_INSTANCES", 255)
NMPWAIT_WAIT_FOREVER = make_flag("NMPWAIT_WAIT_FOREVER", 0xffffffff)
NMPWAIT_NOWAIT = make_flag("NMPWAIT_NOWAIT", 0x00000001)
NMPWAIT_USE_DEFAULT_WAIT = make_flag("NMPWAIT_USE_DEFAULT_WAIT", 0x00000000)
SYMSEARCH_MASKOBJS = make_flag("SYMSEARCH_MASKOBJS", 0x01)
SYMSEARCH_RECURSE = make_flag("SYMSEARCH_RECURSE", 0X02)
SYMSEARCH_GLOBALSONLY = make_flag("SYMSEARCH_GLOBALSONLY", 0X04)
SYMSEARCH_ALLITEMS = make_flag("SYMSEARCH_ALLITEMS", 0X08)
CBA_DEFERRED_SYMBOL_LOAD_START = make_flag("CBA_DEFERRED_SYMBOL_LOAD_START", 0x00000001)
CBA_DEFERRED_SYMBOL_LOAD_COMPLETE = make_flag("CBA_DEFERRED_SYMBOL_LOAD_COMPLETE", 0x00000002)
CBA_DEFERRED_SYMBOL_LOAD_FAILURE = make_flag("CBA_DEFERRED_SYMBOL_LOAD_FAILURE", 0x00000003)
CBA_SYMBOLS_UNLOADED = make_flag("CBA_SYMBOLS_UNLOADED", 0x00000004)
CBA_DUPLICATE_SYMBOL = make_flag("CBA_DUPLICATE_SYMBOL", 0x00000005)
CBA_READ_MEMORY = make_flag("CBA_READ_MEMORY", 0x00000006)
CBA_DEFERRED_SYMBOL_LOAD_CANCEL = make_flag("CBA_DEFERRED_SYMBOL_LOAD_CANCEL", 0x00000007)
CBA_SET_OPTIONS = make_flag("CBA_SET_OPTIONS", 0x00000008)
CBA_EVENT = make_flag("CBA_EVENT", 0x00000010)
CBA_DEFERRED_SYMBOL_LOAD_PARTIAL = make_flag("CBA_DEFERRED_SYMBOL_LOAD_PARTIAL", 0x00000020)
CBA_DEBUG_INFO = make_flag("CBA_DEBUG_INFO", 0x10000000)
CBA_SRCSRV_INFO = make_flag("CBA_SRCSRV_INFO", 0x20000000)
CBA_SRCSRV_EVENT = make_flag("CBA_SRCSRV_EVENT", 0x40000000)
CBA_UPDATE_STATUS_BAR = make_flag("CBA_UPDATE_STATUS_BAR", 0x50000000)
CBA_ENGINE_PRESENT = make_flag("CBA_ENGINE_PRESENT", 0x60000000)
CBA_CHECK_ENGOPT_DISALLOW_NETWORK_PATHS = make_flag("CBA_CHECK_ENGOPT_DISALLOW_NETWORK_PATHS", 0x70000000)
EVENT_SRCSPEW_START = make_flag("EVENT_SRCSPEW_START", 100)
EVENT_SRCSPEW = make_flag("EVENT_SRCSPEW", 100)
EVENT_SRCSPEW_END = make_flag("EVENT_SRCSPEW_END", 199)
DSLFLAG_MISMATCHED_PDB = make_flag("DSLFLAG_MISMATCHED_PDB", 0x1)
DSLFLAG_MISMATCHED_DBG = make_flag("DSLFLAG_MISMATCHED_DBG", 0x2)
FLAG_ENGINE_PRESENT = make_flag("FLAG_ENGINE_PRESENT", 0x4)
FLAG_ENGOPT_DISALLOW_NETWORK_PATHS = make_flag("FLAG_ENGOPT_DISALLOW_NETWORK_PATHS", 0x8)
SYMOPT_CASE_INSENSITIVE = make_flag("SYMOPT_CASE_INSENSITIVE", 0x00000001)
SYMOPT_UNDNAME = make_flag("SYMOPT_UNDNAME", 0x00000002)
SYMOPT_DEFERRED_LOADS = make_flag("SYMOPT_DEFERRED_LOADS", 0x00000004)
SYMOPT_NO_CPP = make_flag("SYMOPT_NO_CPP", 0x00000008)
SYMOPT_LOAD_LINES = make_flag("SYMOPT_LOAD_LINES", 0x00000010)
SYMOPT_OMAP_FIND_NEAREST = make_flag("SYMOPT_OMAP_FIND_NEAREST", 0x00000020)
SYMOPT_LOAD_ANYTHING = make_flag("SYMOPT_LOAD_ANYTHING", 0x00000040)
SYMOPT_IGNORE_CVREC = make_flag("SYMOPT_IGNORE_CVREC", 0x00000080)
SYMOPT_NO_UNQUALIFIED_LOADS = make_flag("SYMOPT_NO_UNQUALIFIED_LOADS", 0x00000100)
SYMOPT_FAIL_CRITICAL_ERRORS = make_flag("SYMOPT_FAIL_CRITICAL_ERRORS", 0x00000200)
SYMOPT_EXACT_SYMBOLS = make_flag("SYMOPT_EXACT_SYMBOLS", 0x00000400)
SYMOPT_ALLOW_ABSOLUTE_SYMBOLS = make_flag("SYMOPT_ALLOW_ABSOLUTE_SYMBOLS", 0x00000800)
SYMOPT_IGNORE_NT_SYMPATH = make_flag("SYMOPT_IGNORE_NT_SYMPATH", 0x00001000)
SYMOPT_INCLUDE_32BIT_MODULES = make_flag("SYMOPT_INCLUDE_32BIT_MODULES", 0x00002000)
SYMOPT_PUBLICS_ONLY = make_flag("SYMOPT_PUBLICS_ONLY", 0x00004000)
SYMOPT_NO_PUBLICS = make_flag("SYMOPT_NO_PUBLICS", 0x00008000)
SYMOPT_AUTO_PUBLICS = make_flag("SYMOPT_AUTO_PUBLICS", 0x00010000)
SYMOPT_NO_IMAGE_SEARCH = make_flag("SYMOPT_NO_IMAGE_SEARCH", 0x00020000)
SYMOPT_SECURE = make_flag("SYMOPT_SECURE", 0x00040000)
SYMOPT_NO_PROMPTS = make_flag("SYMOPT_NO_PROMPTS", 0x00080000)
SYMOPT_OVERWRITE = make_flag("SYMOPT_OVERWRITE", 0x00100000)
SYMOPT_IGNORE_IMAGEDIR = make_flag("SYMOPT_IGNORE_IMAGEDIR", 0x00200000)
SYMOPT_FLAT_DIRECTORY = make_flag("SYMOPT_FLAT_DIRECTORY", 0x00400000)
SYMOPT_FAVOR_COMPRESSED = make_flag("SYMOPT_FAVOR_COMPRESSED", 0x00800000)
SYMOPT_ALLOW_ZERO_ADDRESS = make_flag("SYMOPT_ALLOW_ZERO_ADDRESS", 0x01000000)
SYMOPT_DISABLE_SYMSRV_AUTODETECT = make_flag("SYMOPT_DISABLE_SYMSRV_AUTODETECT", 0x02000000)
SYMOPT_READONLY_CACHE = make_flag("SYMOPT_READONLY_CACHE", 0x04000000)
SYMOPT_SYMPATH_LAST = make_flag("SYMOPT_SYMPATH_LAST", 0x08000000)
SYMOPT_DISABLE_FAST_SYMBOLS = make_flag("SYMOPT_DISABLE_FAST_SYMBOLS", 0x10000000)
SYMOPT_DISABLE_SYMSRV_TIMEOUT = make_flag("SYMOPT_DISABLE_SYMSRV_TIMEOUT", 0x20000000)
SYMOPT_DISABLE_SRVSTAR_ON_STARTUP = make_flag("SYMOPT_DISABLE_SRVSTAR_ON_STARTUP", 0x40000000)
SYMOPT_DEBUG = make_flag("SYMOPT_DEBUG", 0x80000000)
VIRTUAL_STORAGE_TYPE_DEVICE_UNKNOWN = make_flag("VIRTUAL_STORAGE_TYPE_DEVICE_UNKNOWN", 0)
VIRTUAL_STORAGE_TYPE_DEVICE_ISO = make_flag("VIRTUAL_STORAGE_TYPE_DEVICE_ISO", 1)
VIRTUAL_STORAGE_TYPE_DEVICE_VHD = make_flag("VIRTUAL_STORAGE_TYPE_DEVICE_VHD", 2)
VIRTUAL_STORAGE_TYPE_DEVICE_VHDX = make_flag("VIRTUAL_STORAGE_TYPE_DEVICE_VHDX", 3)
FILE_DEVICE_8042_PORT = make_flag("FILE_DEVICE_8042_PORT", 0x00000027)
FILE_DEVICE_ACPI = make_flag("FILE_DEVICE_ACPI", 0x00000032)
FILE_DEVICE_BATTERY = make_flag("FILE_DEVICE_BATTERY", 0x00000029)
FILE_DEVICE_BEEP = make_flag("FILE_DEVICE_BEEP", 0x00000001)
FILE_DEVICE_BUS_EXTENDER = make_flag("FILE_DEVICE_BUS_EXTENDER", 0x0000002a)
FILE_DEVICE_CD_ROM = make_flag("FILE_DEVICE_CD_ROM", 0x00000002)
FILE_DEVICE_CD_ROM_FILE_SYSTEM = make_flag("FILE_DEVICE_CD_ROM_FILE_SYSTEM", 0x00000003)
FILE_DEVICE_CHANGER = make_flag("FILE_DEVICE_CHANGER", 0x00000030)
FILE_DEVICE_CONTROLLER = make_flag("FILE_DEVICE_CONTROLLER", 0x00000004)
FILE_DEVICE_DATALINK = make_flag("FILE_DEVICE_DATALINK", 0x00000005)
FILE_DEVICE_DFS = make_flag("FILE_DEVICE_DFS", 0x00000006)
FILE_DEVICE_DFS_FILE_SYSTEM = make_flag("FILE_DEVICE_DFS_FILE_SYSTEM", 0x00000035)
FILE_DEVICE_DFS_VOLUME = make_flag("FILE_DEVICE_DFS_VOLUME", 0x00000036)
FILE_DEVICE_DISK = make_flag("FILE_DEVICE_DISK", 0x00000007)
FILE_DEVICE_DISK_FILE_SYSTEM = make_flag("FILE_DEVICE_DISK_FILE_SYSTEM", 0x00000008)
FILE_DEVICE_DVD = make_flag("FILE_DEVICE_DVD", 0x00000033)
FILE_DEVICE_FILE_SYSTEM = make_flag("FILE_DEVICE_FILE_SYSTEM", 0x00000009)
FILE_DEVICE_FIPS = make_flag("FILE_DEVICE_FIPS", 0x0000003a)
FILE_DEVICE_FULLSCREEN_VIDEO = make_flag("FILE_DEVICE_FULLSCREEN_VIDEO", 0x00000034)
FILE_DEVICE_INPORT_PORT = make_flag("FILE_DEVICE_INPORT_PORT", 0x0000000a)
FILE_DEVICE_KEYBOARD = make_flag("FILE_DEVICE_KEYBOARD", 0x0000000b)
FILE_DEVICE_KS = make_flag("FILE_DEVICE_KS", 0x0000002f)
FILE_DEVICE_KSEC = make_flag("FILE_DEVICE_KSEC", 0x00000039)
FILE_DEVICE_MAILSLOT = make_flag("FILE_DEVICE_MAILSLOT", 0x0000000c)
FILE_DEVICE_MASS_STORAGE = make_flag("FILE_DEVICE_MASS_STORAGE", 0x0000002d)
FILE_DEVICE_MIDI_IN = make_flag("FILE_DEVICE_MIDI_IN", 0x0000000d)
FILE_DEVICE_MIDI_OUT = make_flag("FILE_DEVICE_MIDI_OUT", 0x0000000e)
FILE_DEVICE_MODEM = make_flag("FILE_DEVICE_MODEM", 0x0000002b)
FILE_DEVICE_MOUSE = make_flag("FILE_DEVICE_MOUSE", 0x0000000f)
FILE_DEVICE_MULTI_UNC_PROVIDER = make_flag("FILE_DEVICE_MULTI_UNC_PROVIDER", 0x00000010)
FILE_DEVICE_NAMED_PIPE = make_flag("FILE_DEVICE_NAMED_PIPE", 0x00000011)
FILE_DEVICE_NETWORK = make_flag("FILE_DEVICE_NETWORK", 0x00000012)
FILE_DEVICE_NETWORK_BROWSER = make_flag("FILE_DEVICE_NETWORK_BROWSER", 0x00000013)
FILE_DEVICE_NETWORK_FILE_SYSTEM = make_flag("FILE_DEVICE_NETWORK_FILE_SYSTEM", 0x00000014)
FILE_DEVICE_NETWORK_REDIRECTOR = make_flag("FILE_DEVICE_NETWORK_REDIRECTOR", 0x00000028)
FILE_DEVICE_NULL = make_flag("FILE_DEVICE_NULL", 0x00000015)
FILE_DEVICE_PARALLEL_PORT = make_flag("FILE_DEVICE_PARALLEL_PORT", 0x00000016)
FILE_DEVICE_PHYSICAL_NETCARD = make_flag("FILE_DEVICE_PHYSICAL_NETCARD", 0x00000017)
FILE_DEVICE_PRINTER = make_flag("FILE_DEVICE_PRINTER", 0x00000018)
FILE_DEVICE_SCANNER = make_flag("FILE_DEVICE_SCANNER", 0x00000019)
FILE_DEVICE_SCREEN = make_flag("FILE_DEVICE_SCREEN", 0x0000001c)
FILE_DEVICE_SERENUM = make_flag("FILE_DEVICE_SERENUM", 0x00000037)
FILE_DEVICE_SERIAL_MOUSE_PORT = make_flag("FILE_DEVICE_SERIAL_MOUSE_PORT", 0x0000001a)
FILE_DEVICE_SERIAL_PORT = make_flag("FILE_DEVICE_SERIAL_PORT", 0x0000001b)
FILE_DEVICE_SMARTCARD = make_flag("FILE_DEVICE_SMARTCARD", 0x00000031)
FILE_DEVICE_SMB = make_flag("FILE_DEVICE_SMB", 0x0000002e)
FILE_DEVICE_SOUND = make_flag("FILE_DEVICE_SOUND", 0x0000001d)
FILE_DEVICE_STREAMS = make_flag("FILE_DEVICE_STREAMS", 0x0000001e)
FILE_DEVICE_TAPE = make_flag("FILE_DEVICE_TAPE", 0x0000001f)
FILE_DEVICE_TAPE_FILE_SYSTEM = make_flag("FILE_DEVICE_TAPE_FILE_SYSTEM", 0x00000020)
FILE_DEVICE_TERMSRV = make_flag("FILE_DEVICE_TERMSRV", 0x00000038)
FILE_DEVICE_TRANSPORT = make_flag("FILE_DEVICE_TRANSPORT", 0x00000021)
FILE_DEVICE_UNKNOWN = make_flag("FILE_DEVICE_UNKNOWN", 0x00000022)
FILE_DEVICE_VDM = make_flag("FILE_DEVICE_VDM", 0x0000002c)
FILE_DEVICE_VIDEO = make_flag("FILE_DEVICE_VIDEO", 0x00000023)
FILE_DEVICE_VIRTUAL_DISK = make_flag("FILE_DEVICE_VIRTUAL_DISK", 0x00000024)
FILE_DEVICE_WAVE_IN = make_flag("FILE_DEVICE_WAVE_IN", 0x00000025)
FILE_DEVICE_WAVE_OUT = make_flag("FILE_DEVICE_WAVE_OUT", 0x00000026)
CERT_QUERY_OBJECT_FILE = make_flag("CERT_QUERY_OBJECT_FILE", 0x00000001)
CERT_QUERY_OBJECT_BLOB = make_flag("CERT_QUERY_OBJECT_BLOB", 0x00000002)
CERT_QUERY_CONTENT_CERT = make_flag("CERT_QUERY_CONTENT_CERT", 1)
CERT_QUERY_CONTENT_CTL = make_flag("CERT_QUERY_CONTENT_CTL", 2)
CERT_QUERY_CONTENT_CRL = make_flag("CERT_QUERY_CONTENT_CRL", 3)
CERT_QUERY_CONTENT_SERIALIZED_STORE = make_flag("CERT_QUERY_CONTENT_SERIALIZED_STORE", 4)
CERT_QUERY_CONTENT_SERIALIZED_CERT = make_flag("CERT_QUERY_CONTENT_SERIALIZED_CERT", 5)
CERT_QUERY_CONTENT_SERIALIZED_CTL = make_flag("CERT_QUERY_CONTENT_SERIALIZED_CTL", 6)
CERT_QUERY_CONTENT_SERIALIZED_CRL = make_flag("CERT_QUERY_CONTENT_SERIALIZED_CRL", 7)
CERT_QUERY_CONTENT_PKCS7_SIGNED = make_flag("CERT_QUERY_CONTENT_PKCS7_SIGNED", 8)
CERT_QUERY_CONTENT_PKCS7_UNSIGNED = make_flag("CERT_QUERY_CONTENT_PKCS7_UNSIGNED", 9)
CERT_QUERY_CONTENT_PKCS7_SIGNED_EMBED = make_flag("CERT_QUERY_CONTENT_PKCS7_SIGNED_EMBED", 10)
CERT_QUERY_CONTENT_PKCS10 = make_flag("CERT_QUERY_CONTENT_PKCS10", 11)
CERT_QUERY_CONTENT_PFX = make_flag("CERT_QUERY_CONTENT_PFX", 12)
CERT_QUERY_CONTENT_CERT_PAIR = make_flag("CERT_QUERY_CONTENT_CERT_PAIR", 13)
CERT_QUERY_CONTENT_PFX_AND_LOAD = make_flag("CERT_QUERY_CONTENT_PFX_AND_LOAD", 14)
CERT_QUERY_FORMAT_BINARY = make_flag("CERT_QUERY_FORMAT_BINARY", 1)
CERT_QUERY_FORMAT_BASE64_ENCODED = make_flag("CERT_QUERY_FORMAT_BASE64_ENCODED", 2)
CERT_QUERY_FORMAT_ASN_ASCII_HEX_ENCODED = make_flag("CERT_QUERY_FORMAT_ASN_ASCII_HEX_ENCODED", 3)
CERT_QUERY_FORMAT_FLAG_BINARY = make_flag("CERT_QUERY_FORMAT_FLAG_BINARY", ( 1 << CERT_QUERY_FORMAT_BINARY ))
CERT_QUERY_FORMAT_FLAG_BASE64_ENCODED = make_flag("CERT_QUERY_FORMAT_FLAG_BASE64_ENCODED", ( 1 << CERT_QUERY_FORMAT_BASE64_ENCODED ))
CERT_QUERY_FORMAT_FLAG_ASN_ASCII_HEX_ENCODED = make_flag("CERT_QUERY_FORMAT_FLAG_ASN_ASCII_HEX_ENCODED", ( 1 << CERT_QUERY_FORMAT_ASN_ASCII_HEX_ENCODED ))
CERT_QUERY_FORMAT_FLAG_ALL = make_flag("CERT_QUERY_FORMAT_FLAG_ALL", ( CERT_QUERY_FORMAT_FLAG_BINARY | CERT_QUERY_FORMAT_FLAG_BASE64_ENCODED | CERT_QUERY_FORMAT_FLAG_ASN_ASCII_HEX_ENCODED ))
CERT_QUERY_CONTENT_FLAG_CERT = make_flag("CERT_QUERY_CONTENT_FLAG_CERT", ( 1 << CERT_QUERY_CONTENT_CERT ))
CERT_QUERY_CONTENT_FLAG_CTL = make_flag("CERT_QUERY_CONTENT_FLAG_CTL", ( 1 << CERT_QUERY_CONTENT_CTL ))
CERT_QUERY_CONTENT_FLAG_CRL = make_flag("CERT_QUERY_CONTENT_FLAG_CRL", ( 1 << CERT_QUERY_CONTENT_CRL ))
CERT_QUERY_CONTENT_FLAG_SERIALIZED_STORE = make_flag("CERT_QUERY_CONTENT_FLAG_SERIALIZED_STORE", ( 1 << CERT_QUERY_CONTENT_SERIALIZED_STORE ))
CERT_QUERY_CONTENT_FLAG_SERIALIZED_CERT = make_flag("CERT_QUERY_CONTENT_FLAG_SERIALIZED_CERT", ( 1 << CERT_QUERY_CONTENT_SERIALIZED_CERT ))
CERT_QUERY_CONTENT_FLAG_SERIALIZED_CTL = make_flag("CERT_QUERY_CONTENT_FLAG_SERIALIZED_CTL", ( 1 << CERT_QUERY_CONTENT_SERIALIZED_CTL ))
CERT_QUERY_CONTENT_FLAG_SERIALIZED_CRL = make_flag("CERT_QUERY_CONTENT_FLAG_SERIALIZED_CRL", ( 1 << CERT_QUERY_CONTENT_SERIALIZED_CRL ))
CERT_QUERY_CONTENT_FLAG_PKCS7_SIGNED = make_flag("CERT_QUERY_CONTENT_FLAG_PKCS7_SIGNED", ( 1 << CERT_QUERY_CONTENT_PKCS7_SIGNED ))
CERT_QUERY_CONTENT_FLAG_PKCS7_UNSIGNED = make_flag("CERT_QUERY_CONTENT_FLAG_PKCS7_UNSIGNED", ( 1 << CERT_QUERY_CONTENT_PKCS7_UNSIGNED ))
CERT_QUERY_CONTENT_FLAG_PKCS7_SIGNED_EMBED = make_flag("CERT_QUERY_CONTENT_FLAG_PKCS7_SIGNED_EMBED", ( 1 << CERT_QUERY_CONTENT_PKCS7_SIGNED_EMBED ))
CERT_QUERY_CONTENT_FLAG_PKCS10 = make_flag("CERT_QUERY_CONTENT_FLAG_PKCS10", ( 1 << CERT_QUERY_CONTENT_PKCS10 ))
CERT_QUERY_CONTENT_FLAG_PFX = make_flag("CERT_QUERY_CONTENT_FLAG_PFX", ( 1 << CERT_QUERY_CONTENT_PFX ))
CERT_QUERY_CONTENT_FLAG_CERT_PAIR = make_flag("CERT_QUERY_CONTENT_FLAG_CERT_PAIR", ( 1 << CERT_QUERY_CONTENT_CERT_PAIR ))
CERT_QUERY_CONTENT_FLAG_PFX_AND_LOAD = make_flag("CERT_QUERY_CONTENT_FLAG_PFX_AND_LOAD", ( 1 << CERT_QUERY_CONTENT_PFX_AND_LOAD ))
CERT_QUERY_CONTENT_FLAG_ALL = make_flag("CERT_QUERY_CONTENT_FLAG_ALL", ( CERT_QUERY_CONTENT_FLAG_CERT | CERT_QUERY_CONTENT_FLAG_CTL | CERT_QUERY_CONTENT_FLAG_CRL | CERT_QUERY_CONTENT_FLAG_SERIALIZED_STORE | CERT_QUERY_CONTENT_FLAG_SERIALIZED_CERT | CERT_QUERY_CONTENT_FLAG_SERIALIZED_CTL | CERT_QUERY_CONTENT_FLAG_SERIALIZED_CRL | CERT_QUERY_CONTENT_FLAG_PKCS7_SIGNED | CERT_QUERY_CONTENT_FLAG_PKCS7_UNSIGNED | CERT_QUERY_CONTENT_FLAG_PKCS7_SIGNED_EMBED | CERT_QUERY_CONTENT_FLAG_PKCS10 | CERT_QUERY_CONTENT_FLAG_PFX | CERT_QUERY_CONTENT_FLAG_CERT_PAIR ))
CRYPT_ASN_ENCODING = make_flag("CRYPT_ASN_ENCODING", 0x00000001)
CRYPT_NDR_ENCODING = make_flag("CRYPT_NDR_ENCODING", 0x00000002)
X509_ASN_ENCODING = make_flag("X509_ASN_ENCODING", 0x00000001)
X509_NDR_ENCODING = make_flag("X509_NDR_ENCODING", 0x00000002)
PKCS_7_ASN_ENCODING = make_flag("PKCS_7_ASN_ENCODING", 0x00010000)
PKCS_7_NDR_ENCODING = make_flag("PKCS_7_NDR_ENCODING", 0x00020000)
CERT_ENCODING_TYPE_MASK = make_flag("CERT_ENCODING_TYPE_MASK", 0x0000FFFF)
CMSG_ENCODING_TYPE_MASK = make_flag("CMSG_ENCODING_TYPE_MASK", 0xFFFF0000)
CERT_COMPARE_MASK = make_flag("CERT_COMPARE_MASK", 0xFFFF)
CERT_COMPARE_SHIFT = make_flag("CERT_COMPARE_SHIFT", 16)
CERT_COMPARE_ANY = make_flag("CERT_COMPARE_ANY", 0)
CERT_COMPARE_SHA1_HASH = make_flag("CERT_COMPARE_SHA1_HASH", 1)
CERT_COMPARE_NAME = make_flag("CERT_COMPARE_NAME", 2)
CERT_COMPARE_ATTR = make_flag("CERT_COMPARE_ATTR", 3)
CERT_COMPARE_MD5_HASH = make_flag("CERT_COMPARE_MD5_HASH", 4)
CERT_COMPARE_PROPERTY = make_flag("CERT_COMPARE_PROPERTY", 5)
CERT_COMPARE_PUBLIC_KEY = make_flag("CERT_COMPARE_PUBLIC_KEY", 6)
CERT_COMPARE_HASH = make_flag("CERT_COMPARE_HASH", CERT_COMPARE_SHA1_HASH)
CERT_COMPARE_NAME_STR_A = make_flag("CERT_COMPARE_NAME_STR_A", 7)
CERT_COMPARE_NAME_STR_W = make_flag("CERT_COMPARE_NAME_STR_W", 8)
CERT_COMPARE_KEY_SPEC = make_flag("CERT_COMPARE_KEY_SPEC", 9)
CERT_COMPARE_ENHKEY_USAGE = make_flag("CERT_COMPARE_ENHKEY_USAGE", 10)
CERT_COMPARE_CTL_USAGE = make_flag("CERT_COMPARE_CTL_USAGE", CERT_COMPARE_ENHKEY_USAGE)
CERT_COMPARE_SUBJECT_CERT = make_flag("CERT_COMPARE_SUBJECT_CERT", 11)
CERT_COMPARE_ISSUER_OF = make_flag("CERT_COMPARE_ISSUER_OF", 12)
CERT_COMPARE_EXISTING = make_flag("CERT_COMPARE_EXISTING", 13)
CERT_COMPARE_SIGNATURE_HASH = make_flag("CERT_COMPARE_SIGNATURE_HASH", 14)
CERT_COMPARE_KEY_IDENTIFIER = make_flag("CERT_COMPARE_KEY_IDENTIFIER", 15)
CERT_COMPARE_CERT_ID = make_flag("CERT_COMPARE_CERT_ID", 16)
CERT_COMPARE_CROSS_CERT_DIST_POINTS = make_flag("CERT_COMPARE_CROSS_CERT_DIST_POINTS", 17)
CERT_COMPARE_PUBKEY_MD5_HASH = make_flag("CERT_COMPARE_PUBKEY_MD5_HASH", 18)
CERT_COMPARE_SUBJECT_INFO_ACCESS = make_flag("CERT_COMPARE_SUBJECT_INFO_ACCESS", 19)
CERT_NAME_ISSUER_FLAG = make_flag("CERT_NAME_ISSUER_FLAG", 0x1)
CERT_NAME_DISABLE_IE4_UTF8_FLAG = make_flag("CERT_NAME_DISABLE_IE4_UTF8_FLAG", 0x00010000)
USAGE_MATCH_TYPE_AND = make_flag("USAGE_MATCH_TYPE_AND", 0x00000000)
USAGE_MATCH_TYPE_OR = make_flag("USAGE_MATCH_TYPE_OR", 0x00000001)
CERT_CHAIN_REVOCATION_CHECK_END_CERT = make_flag("CERT_CHAIN_REVOCATION_CHECK_END_CERT", 0x10000000)
CERT_CHAIN_REVOCATION_CHECK_CHAIN = make_flag("CERT_CHAIN_REVOCATION_CHECK_CHAIN", 0x20000000)
CERT_CHAIN_REVOCATION_CHECK_CHAIN_EXCLUDE_ROOT = make_flag("CERT_CHAIN_REVOCATION_CHECK_CHAIN_EXCLUDE_ROOT", 0x40000000)
CERT_CHAIN_REVOCATION_CHECK_CACHE_ONLY = make_flag("CERT_CHAIN_REVOCATION_CHECK_CACHE_ONLY", 0x80000000)
CERT_TRUST_NO_ERROR = make_flag("CERT_TRUST_NO_ERROR", 0x00000000)
CERT_TRUST_IS_NOT_TIME_VALID = make_flag("CERT_TRUST_IS_NOT_TIME_VALID", 0x00000001)
CERT_TRUST_IS_NOT_TIME_NESTED = make_flag("CERT_TRUST_IS_NOT_TIME_NESTED", 0x00000002)
CERT_TRUST_IS_REVOKED = make_flag("CERT_TRUST_IS_REVOKED", 0x00000004)
CERT_TRUST_IS_NOT_SIGNATURE_VALID = make_flag("CERT_TRUST_IS_NOT_SIGNATURE_VALID", 0x00000008)
CERT_TRUST_IS_NOT_VALID_FOR_USAGE = make_flag("CERT_TRUST_IS_NOT_VALID_FOR_USAGE", 0x00000010)
CERT_TRUST_IS_UNTRUSTED_ROOT = make_flag("CERT_TRUST_IS_UNTRUSTED_ROOT", 0x00000020)
CERT_TRUST_REVOCATION_STATUS_UNKNOWN = make_flag("CERT_TRUST_REVOCATION_STATUS_UNKNOWN", 0x00000040)
CERT_TRUST_IS_CYCLIC = make_flag("CERT_TRUST_IS_CYCLIC", 0x00000080)
CERT_TRUST_INVALID_EXTENSION = make_flag("CERT_TRUST_INVALID_EXTENSION", 0x00000100)
CERT_TRUST_INVALID_POLICY_CONSTRAINTS = make_flag("CERT_TRUST_INVALID_POLICY_CONSTRAINTS", 0x00000200)
CERT_TRUST_INVALID_BASIC_CONSTRAINTS = make_flag("CERT_TRUST_INVALID_BASIC_CONSTRAINTS", 0x00000400)
CERT_TRUST_INVALID_NAME_CONSTRAINTS = make_flag("CERT_TRUST_INVALID_NAME_CONSTRAINTS", 0x00000800)
CERT_TRUST_HAS_NOT_SUPPORTED_NAME_CONSTRAINT = make_flag("CERT_TRUST_HAS_NOT_SUPPORTED_NAME_CONSTRAINT", 0x00001000)
CERT_TRUST_HAS_NOT_DEFINED_NAME_CONSTRAINT = make_flag("CERT_TRUST_HAS_NOT_DEFINED_NAME_CONSTRAINT", 0x00002000)
CERT_TRUST_HAS_NOT_PERMITTED_NAME_CONSTRAINT = make_flag("CERT_TRUST_HAS_NOT_PERMITTED_NAME_CONSTRAINT", 0x00004000)
CERT_TRUST_HAS_EXCLUDED_NAME_CONSTRAINT = make_flag("CERT_TRUST_HAS_EXCLUDED_NAME_CONSTRAINT", 0x00008000)
CERT_TRUST_IS_OFFLINE_REVOCATION = make_flag("CERT_TRUST_IS_OFFLINE_REVOCATION", 0x01000000)
CERT_TRUST_NO_ISSUANCE_CHAIN_POLICY = make_flag("CERT_TRUST_NO_ISSUANCE_CHAIN_POLICY", 0x02000000)
CERT_TRUST_IS_EXPLICIT_DISTRUST = make_flag("CERT_TRUST_IS_EXPLICIT_DISTRUST", 0x04000000)
CERT_TRUST_HAS_NOT_SUPPORTED_CRITICAL_EXT = make_flag("CERT_TRUST_HAS_NOT_SUPPORTED_CRITICAL_EXT", 0x08000000)
CERT_TRUST_IS_PARTIAL_CHAIN = make_flag("CERT_TRUST_IS_PARTIAL_CHAIN", 0x00010000)
CERT_TRUST_CTL_IS_NOT_TIME_VALID = make_flag("CERT_TRUST_CTL_IS_NOT_TIME_VALID", 0x00020000)
CERT_TRUST_CTL_IS_NOT_SIGNATURE_VALID = make_flag("CERT_TRUST_CTL_IS_NOT_SIGNATURE_VALID", 0x00040000)
CERT_TRUST_CTL_IS_NOT_VALID_FOR_USAGE = make_flag("CERT_TRUST_CTL_IS_NOT_VALID_FOR_USAGE", 0x00080000)
CERT_TRUST_HAS_EXACT_MATCH_ISSUER = make_flag("CERT_TRUST_HAS_EXACT_MATCH_ISSUER", 0x00000001)
CERT_TRUST_HAS_KEY_MATCH_ISSUER = make_flag("CERT_TRUST_HAS_KEY_MATCH_ISSUER", 0x00000002)
CERT_TRUST_HAS_NAME_MATCH_ISSUER = make_flag("CERT_TRUST_HAS_NAME_MATCH_ISSUER", 0x00000004)
CERT_TRUST_IS_SELF_SIGNED = make_flag("CERT_TRUST_IS_SELF_SIGNED", 0x00000008)
CERT_TRUST_HAS_PREFERRED_ISSUER = make_flag("CERT_TRUST_HAS_PREFERRED_ISSUER", 0x00000100)
CERT_TRUST_HAS_ISSUANCE_CHAIN_POLICY = make_flag("CERT_TRUST_HAS_ISSUANCE_CHAIN_POLICY", 0x00000200)
CERT_TRUST_HAS_VALID_NAME_CONSTRAINTS = make_flag("CERT_TRUST_HAS_VALID_NAME_CONSTRAINTS", 0x00000400)
CERT_TRUST_IS_PEER_TRUSTED = make_flag("CERT_TRUST_IS_PEER_TRUSTED", 0x00000800)
CERT_TRUST_HAS_CRL_VALIDITY_EXTENDED = make_flag("CERT_TRUST_HAS_CRL_VALIDITY_EXTENDED", 0x00001000)
CERT_TRUST_IS_FROM_EXCLUSIVE_TRUST_STORE = make_flag("CERT_TRUST_IS_FROM_EXCLUSIVE_TRUST_STORE", 0x00002000)
CERT_TRUST_IS_COMPLEX_CHAIN = make_flag("CERT_TRUST_IS_COMPLEX_CHAIN", 0x00010000)
CMSG_TYPE_PARAM = make_flag("CMSG_TYPE_PARAM", 1)
CMSG_CONTENT_PARAM = make_flag("CMSG_CONTENT_PARAM", 2)
CMSG_BARE_CONTENT_PARAM = make_flag("CMSG_BARE_CONTENT_PARAM", 3)
CMSG_INNER_CONTENT_TYPE_PARAM = make_flag("CMSG_INNER_CONTENT_TYPE_PARAM", 4)
CMSG_SIGNER_COUNT_PARAM = make_flag("CMSG_SIGNER_COUNT_PARAM", 5)
CMSG_SIGNER_INFO_PARAM = make_flag("CMSG_SIGNER_INFO_PARAM", 6)
CMSG_SIGNER_CERT_INFO_PARAM = make_flag("CMSG_SIGNER_CERT_INFO_PARAM", 7)
CMSG_SIGNER_HASH_ALGORITHM_PARAM = make_flag("CMSG_SIGNER_HASH_ALGORITHM_PARAM", 8)
CMSG_SIGNER_AUTH_ATTR_PARAM = make_flag("CMSG_SIGNER_AUTH_ATTR_PARAM", 9)
CMSG_SIGNER_UNAUTH_ATTR_PARAM = make_flag("CMSG_SIGNER_UNAUTH_ATTR_PARAM", 10)
CMSG_CERT_COUNT_PARAM = make_flag("CMSG_CERT_COUNT_PARAM", 11)
CMSG_CERT_PARAM = make_flag("CMSG_CERT_PARAM", 12)
CMSG_CRL_COUNT_PARAM = make_flag("CMSG_CRL_COUNT_PARAM", 13)
CMSG_CRL_PARAM = make_flag("CMSG_CRL_PARAM", 14)
CMSG_ENVELOPE_ALGORITHM_PARAM = make_flag("CMSG_ENVELOPE_ALGORITHM_PARAM", 15)
CMSG_RECIPIENT_COUNT_PARAM = make_flag("CMSG_RECIPIENT_COUNT_PARAM", 17)
CMSG_RECIPIENT_INDEX_PARAM = make_flag("CMSG_RECIPIENT_INDEX_PARAM", 18)
CMSG_RECIPIENT_INFO_PARAM = make_flag("CMSG_RECIPIENT_INFO_PARAM", 19)
CMSG_HASH_ALGORITHM_PARAM = make_flag("CMSG_HASH_ALGORITHM_PARAM", 20)
CMSG_HASH_DATA_PARAM = make_flag("CMSG_HASH_DATA_PARAM", 21)
CMSG_COMPUTED_HASH_PARAM = make_flag("CMSG_COMPUTED_HASH_PARAM", 22)
CMSG_ENCRYPT_PARAM = make_flag("CMSG_ENCRYPT_PARAM", 26)
CMSG_ENCRYPTED_DIGEST = make_flag("CMSG_ENCRYPTED_DIGEST", 27)
CMSG_ENCODED_SIGNER = make_flag("CMSG_ENCODED_SIGNER", 28)
CMSG_ENCODED_MESSAGE = make_flag("CMSG_ENCODED_MESSAGE", 29)
CMSG_VERSION_PARAM = make_flag("CMSG_VERSION_PARAM", 30)
CMSG_ATTR_CERT_COUNT_PARAM = make_flag("CMSG_ATTR_CERT_COUNT_PARAM", 31)
CMSG_ATTR_CERT_PARAM = make_flag("CMSG_ATTR_CERT_PARAM", 32)
CMSG_CMS_RECIPIENT_COUNT_PARAM = make_flag("CMSG_CMS_RECIPIENT_COUNT_PARAM", 33)
CMSG_CMS_RECIPIENT_INDEX_PARAM = make_flag("CMSG_CMS_RECIPIENT_INDEX_PARAM", 34)
CMSG_CMS_RECIPIENT_ENCRYPTED_KEY_INDEX_PARAM = make_flag("CMSG_CMS_RECIPIENT_ENCRYPTED_KEY_INDEX_PARAM", 35)
CMSG_CMS_RECIPIENT_INFO_PARAM = make_flag("CMSG_CMS_RECIPIENT_INFO_PARAM", 36)
CMSG_UNPROTECTED_ATTR_PARAM = make_flag("CMSG_UNPROTECTED_ATTR_PARAM", 37)
CMSG_SIGNER_CERT_ID_PARAM = make_flag("CMSG_SIGNER_CERT_ID_PARAM", 38)
CMSG_CMS_SIGNER_INFO_PARAM = make_flag("CMSG_CMS_SIGNER_INFO_PARAM", 39)
CERT_INFO_VERSION_FLAG = make_flag("CERT_INFO_VERSION_FLAG", 1)
CERT_INFO_SERIAL_NUMBER_FLAG = make_flag("CERT_INFO_SERIAL_NUMBER_FLAG", 2)
CERT_INFO_SIGNATURE_ALGORITHM_FLAG = make_flag("CERT_INFO_SIGNATURE_ALGORITHM_FLAG", 3)
CERT_INFO_ISSUER_FLAG = make_flag("CERT_INFO_ISSUER_FLAG", 4)
CERT_INFO_NOT_BEFORE_FLAG = make_flag("CERT_INFO_NOT_BEFORE_FLAG", 5)
CERT_INFO_NOT_AFTER_FLAG = make_flag("CERT_INFO_NOT_AFTER_FLAG", 6)
CERT_INFO_SUBJECT_FLAG = make_flag("CERT_INFO_SUBJECT_FLAG", 7)
CERT_INFO_SUBJECT_PUBLIC_KEY_INFO_FLAG = make_flag("CERT_INFO_SUBJECT_PUBLIC_KEY_INFO_FLAG", 8)
CERT_INFO_ISSUER_UNIQUE_ID_FLAG = make_flag("CERT_INFO_ISSUER_UNIQUE_ID_FLAG", 9)
CERT_INFO_SUBJECT_UNIQUE_ID_FLAG = make_flag("CERT_INFO_SUBJECT_UNIQUE_ID_FLAG", 10)
CERT_INFO_EXTENSION_FLAG = make_flag("CERT_INFO_EXTENSION_FLAG", 11)
CERT_FIND_ANY = make_flag("CERT_FIND_ANY", ( CERT_COMPARE_ANY << CERT_COMPARE_SHIFT ))
CERT_FIND_SHA1_HASH = make_flag("CERT_FIND_SHA1_HASH", ( CERT_COMPARE_SHA1_HASH << CERT_COMPARE_SHIFT ))
CERT_FIND_MD5_HASH = make_flag("CERT_FIND_MD5_HASH", ( CERT_COMPARE_MD5_HASH << CERT_COMPARE_SHIFT ))
CERT_FIND_SIGNATURE_HASH = make_flag("CERT_FIND_SIGNATURE_HASH", ( CERT_COMPARE_SIGNATURE_HASH << CERT_COMPARE_SHIFT ))
CERT_FIND_KEY_IDENTIFIER = make_flag("CERT_FIND_KEY_IDENTIFIER", ( CERT_COMPARE_KEY_IDENTIFIER << CERT_COMPARE_SHIFT ))
CERT_FIND_HASH = make_flag("CERT_FIND_HASH", CERT_FIND_SHA1_HASH)
CERT_FIND_PROPERTY = make_flag("CERT_FIND_PROPERTY", ( CERT_COMPARE_PROPERTY << CERT_COMPARE_SHIFT ))
CERT_FIND_PUBLIC_KEY = make_flag("CERT_FIND_PUBLIC_KEY", ( CERT_COMPARE_PUBLIC_KEY << CERT_COMPARE_SHIFT ))
CERT_FIND_SUBJECT_NAME = make_flag("CERT_FIND_SUBJECT_NAME", ( CERT_COMPARE_NAME << CERT_COMPARE_SHIFT | CERT_INFO_SUBJECT_FLAG ))
CERT_FIND_SUBJECT_ATTR = make_flag("CERT_FIND_SUBJECT_ATTR", ( CERT_COMPARE_ATTR << CERT_COMPARE_SHIFT | CERT_INFO_SUBJECT_FLAG ))
CERT_FIND_ISSUER_NAME = make_flag("CERT_FIND_ISSUER_NAME", ( CERT_COMPARE_NAME << CERT_COMPARE_SHIFT | CERT_INFO_ISSUER_FLAG ))
CERT_FIND_ISSUER_ATTR = make_flag("CERT_FIND_ISSUER_ATTR", ( CERT_COMPARE_ATTR << CERT_COMPARE_SHIFT | CERT_INFO_ISSUER_FLAG ))
CERT_FIND_SUBJECT_STR_A = make_flag("CERT_FIND_SUBJECT_STR_A", ( CERT_COMPARE_NAME_STR_A << CERT_COMPARE_SHIFT | CERT_INFO_SUBJECT_FLAG ))
CERT_FIND_SUBJECT_STR_W = make_flag("CERT_FIND_SUBJECT_STR_W", ( CERT_COMPARE_NAME_STR_W << CERT_COMPARE_SHIFT | CERT_INFO_SUBJECT_FLAG ))
CERT_FIND_SUBJECT_STR = make_flag("CERT_FIND_SUBJECT_STR", CERT_FIND_SUBJECT_STR_W)
CERT_FIND_ISSUER_STR_A = make_flag("CERT_FIND_ISSUER_STR_A", ( CERT_COMPARE_NAME_STR_A << CERT_COMPARE_SHIFT | CERT_INFO_ISSUER_FLAG ))
CERT_FIND_ISSUER_STR_W = make_flag("CERT_FIND_ISSUER_STR_W", ( CERT_COMPARE_NAME_STR_W << CERT_COMPARE_SHIFT | CERT_INFO_ISSUER_FLAG ))
CERT_FIND_ISSUER_STR = make_flag("CERT_FIND_ISSUER_STR", CERT_FIND_ISSUER_STR_W)
CERT_FIND_KEY_SPEC = make_flag("CERT_FIND_KEY_SPEC", ( CERT_COMPARE_KEY_SPEC << CERT_COMPARE_SHIFT ))
CERT_FIND_ENHKEY_USAGE = make_flag("CERT_FIND_ENHKEY_USAGE", ( CERT_COMPARE_ENHKEY_USAGE << CERT_COMPARE_SHIFT ))
CERT_FIND_CTL_USAGE = make_flag("CERT_FIND_CTL_USAGE", CERT_FIND_ENHKEY_USAGE)
CERT_FIND_SUBJECT_CERT = make_flag("CERT_FIND_SUBJECT_CERT", ( CERT_COMPARE_SUBJECT_CERT << CERT_COMPARE_SHIFT ))
CERT_FIND_ISSUER_OF = make_flag("CERT_FIND_ISSUER_OF", ( CERT_COMPARE_ISSUER_OF << CERT_COMPARE_SHIFT ))
CERT_FIND_EXISTING = make_flag("CERT_FIND_EXISTING", ( CERT_COMPARE_EXISTING << CERT_COMPARE_SHIFT ))
CERT_FIND_CERT_ID = make_flag("CERT_FIND_CERT_ID", ( CERT_COMPARE_CERT_ID << CERT_COMPARE_SHIFT ))
CERT_FIND_CROSS_CERT_DIST_POINTS = make_flag("CERT_FIND_CROSS_CERT_DIST_POINTS", ( CERT_COMPARE_CROSS_CERT_DIST_POINTS << CERT_COMPARE_SHIFT ))
CERT_FIND_PUBKEY_MD5_HASH = make_flag("CERT_FIND_PUBKEY_MD5_HASH", ( CERT_COMPARE_PUBKEY_MD5_HASH << CERT_COMPARE_SHIFT ))
CERT_FIND_SUBJECT_INFO_ACCESS = make_flag("CERT_FIND_SUBJECT_INFO_ACCESS", ( CERT_COMPARE_SUBJECT_INFO_ACCESS << CERT_COMPARE_SHIFT ))
CERT_NAME_EMAIL_TYPE = make_flag("CERT_NAME_EMAIL_TYPE", 1)
CERT_NAME_RDN_TYPE = make_flag("CERT_NAME_RDN_TYPE", 2)
CERT_NAME_ATTR_TYPE = make_flag("CERT_NAME_ATTR_TYPE", 3)
CERT_NAME_SIMPLE_DISPLAY_TYPE = make_flag("CERT_NAME_SIMPLE_DISPLAY_TYPE", 4)
CERT_NAME_FRIENDLY_DISPLAY_TYPE = make_flag("CERT_NAME_FRIENDLY_DISPLAY_TYPE", 5)
CERT_NAME_DNS_TYPE = make_flag("CERT_NAME_DNS_TYPE", 6)
CERT_NAME_URL_TYPE = make_flag("CERT_NAME_URL_TYPE", 7)
CERT_NAME_UPN_TYPE = make_flag("CERT_NAME_UPN_TYPE", 8)
CERT_KEY_PROV_HANDLE_PROP_ID = make_flag("CERT_KEY_PROV_HANDLE_PROP_ID", 1)
CERT_KEY_PROV_INFO_PROP_ID = make_flag("CERT_KEY_PROV_INFO_PROP_ID", 2)
CERT_SHA1_HASH_PROP_ID = make_flag("CERT_SHA1_HASH_PROP_ID", 3)
CERT_MD5_HASH_PROP_ID = make_flag("CERT_MD5_HASH_PROP_ID", 4)
CERT_HASH_PROP_ID = make_flag("CERT_HASH_PROP_ID", CERT_SHA1_HASH_PROP_ID)
CERT_KEY_CONTEXT_PROP_ID = make_flag("CERT_KEY_CONTEXT_PROP_ID", 5)
CERT_KEY_SPEC_PROP_ID = make_flag("CERT_KEY_SPEC_PROP_ID", 6)
CERT_IE30_RESERVED_PROP_ID = make_flag("CERT_IE30_RESERVED_PROP_ID", 7)
CERT_PUBKEY_HASH_RESERVED_PROP_ID = make_flag("CERT_PUBKEY_HASH_RESERVED_PROP_ID", 8)
CERT_ENHKEY_USAGE_PROP_ID = make_flag("CERT_ENHKEY_USAGE_PROP_ID", 9)
CERT_CTL_USAGE_PROP_ID = make_flag("CERT_CTL_USAGE_PROP_ID", CERT_ENHKEY_USAGE_PROP_ID)
CERT_NEXT_UPDATE_LOCATION_PROP_ID = make_flag("CERT_NEXT_UPDATE_LOCATION_PROP_ID", 10)
CERT_FRIENDLY_NAME_PROP_ID = make_flag("CERT_FRIENDLY_NAME_PROP_ID", 11)
CERT_PVK_FILE_PROP_ID = make_flag("CERT_PVK_FILE_PROP_ID", 12)
CERT_DESCRIPTION_PROP_ID = make_flag("CERT_DESCRIPTION_PROP_ID", 13)
CERT_ACCESS_STATE_PROP_ID = make_flag("CERT_ACCESS_STATE_PROP_ID", 14)
CERT_SIGNATURE_HASH_PROP_ID = make_flag("CERT_SIGNATURE_HASH_PROP_ID", 15)
CERT_SMART_CARD_DATA_PROP_ID = make_flag("CERT_SMART_CARD_DATA_PROP_ID", 16)
CERT_EFS_PROP_ID = make_flag("CERT_EFS_PROP_ID", 17)
CERT_FORTEZZA_DATA_PROP_ID = make_flag("CERT_FORTEZZA_DATA_PROP_ID", 18)
CERT_ARCHIVED_PROP_ID = make_flag("CERT_ARCHIVED_PROP_ID", 19)
CERT_KEY_IDENTIFIER_PROP_ID = make_flag("CERT_KEY_IDENTIFIER_PROP_ID", 20)
CERT_AUTO_ENROLL_PROP_ID = make_flag("CERT_AUTO_ENROLL_PROP_ID", 21)
CERT_PUBKEY_ALG_PARA_PROP_ID = make_flag("CERT_PUBKEY_ALG_PARA_PROP_ID", 22)
CERT_CROSS_CERT_DIST_POINTS_PROP_ID = make_flag("CERT_CROSS_CERT_DIST_POINTS_PROP_ID", 23)
CERT_ISSUER_PUBLIC_KEY_MD5_HASH_PROP_ID = make_flag("CERT_ISSUER_PUBLIC_KEY_MD5_HASH_PROP_ID", 24)
CERT_SUBJECT_PUBLIC_KEY_MD5_HASH_PROP_ID = make_flag("CERT_SUBJECT_PUBLIC_KEY_MD5_HASH_PROP_ID", 25)
CERT_ENROLLMENT_PROP_ID = make_flag("CERT_ENROLLMENT_PROP_ID", 26)
CERT_DATE_STAMP_PROP_ID = make_flag("CERT_DATE_STAMP_PROP_ID", 27)
CERT_ISSUER_SERIAL_NUMBER_MD5_HASH_PROP_ID = make_flag("CERT_ISSUER_SERIAL_NUMBER_MD5_HASH_PROP_ID", 28)
CERT_SUBJECT_NAME_MD5_HASH_PROP_ID = make_flag("CERT_SUBJECT_NAME_MD5_HASH_PROP_ID", 29)
CERT_EXTENDED_ERROR_INFO_PROP_ID = make_flag("CERT_EXTENDED_ERROR_INFO_PROP_ID", 30)
CERT_RENEWAL_PROP_ID = make_flag("CERT_RENEWAL_PROP_ID", 64)
CERT_ARCHIVED_KEY_HASH_PROP_ID = make_flag("CERT_ARCHIVED_KEY_HASH_PROP_ID", 65)
CERT_AUTO_ENROLL_RETRY_PROP_ID = make_flag("CERT_AUTO_ENROLL_RETRY_PROP_ID", 66)
CERT_AIA_URL_RETRIEVED_PROP_ID = make_flag("CERT_AIA_URL_RETRIEVED_PROP_ID", 67)
CERT_AUTHORITY_INFO_ACCESS_PROP_ID = make_flag("CERT_AUTHORITY_INFO_ACCESS_PROP_ID", 68)
CERT_BACKED_UP_PROP_ID = make_flag("CERT_BACKED_UP_PROP_ID", 69)
CERT_OCSP_RESPONSE_PROP_ID = make_flag("CERT_OCSP_RESPONSE_PROP_ID", 70)
CERT_REQUEST_ORIGINATOR_PROP_ID = make_flag("CERT_REQUEST_ORIGINATOR_PROP_ID", 71)
CERT_SOURCE_LOCATION_PROP_ID = make_flag("CERT_SOURCE_LOCATION_PROP_ID", 72)
CRYPT_ACQUIRE_CACHE_FLAG = make_flag("CRYPT_ACQUIRE_CACHE_FLAG", 0x00000001)
CRYPT_ACQUIRE_USE_PROV_INFO_FLAG = make_flag("CRYPT_ACQUIRE_USE_PROV_INFO_FLAG", 0x00000002)
CRYPT_ACQUIRE_COMPARE_KEY_FLAG = make_flag("CRYPT_ACQUIRE_COMPARE_KEY_FLAG", 0x00000004)
CRYPT_ACQUIRE_NO_HEALING = make_flag("CRYPT_ACQUIRE_NO_HEALING", 0x00000008)
CRYPT_ACQUIRE_SILENT_FLAG = make_flag("CRYPT_ACQUIRE_SILENT_FLAG", 0x00000040)
CRYPT_ACQUIRE_NCRYPT_KEY_FLAGS_MASK = make_flag("CRYPT_ACQUIRE_NCRYPT_KEY_FLAGS_MASK", 0x00070000)
CRYPT_ACQUIRE_ALLOW_NCRYPT_KEY_FLAG = make_flag("CRYPT_ACQUIRE_ALLOW_NCRYPT_KEY_FLAG", 0x00010000)
CRYPT_ACQUIRE_PREFER_NCRYPT_KEY_FLAG = make_flag("CRYPT_ACQUIRE_PREFER_NCRYPT_KEY_FLAG", 0x00020000)
CRYPT_ACQUIRE_ONLY_NCRYPT_KEY_FLAG = make_flag("CRYPT_ACQUIRE_ONLY_NCRYPT_KEY_FLAG", 0x00040000)
CERT_STORE_PROV_MSG = make_flag("CERT_STORE_PROV_MSG", ( 1 ))
CERT_STORE_PROV_MEMORY = make_flag("CERT_STORE_PROV_MEMORY", ( 2 ))
CERT_STORE_PROV_FILE = make_flag("CERT_STORE_PROV_FILE", ( 3 ))
CERT_STORE_PROV_REG = make_flag("CERT_STORE_PROV_REG", ( 4 ))
CERT_STORE_PROV_PKCS7 = make_flag("CERT_STORE_PROV_PKCS7", ( 5 ))
CERT_STORE_PROV_SERIALIZED = make_flag("CERT_STORE_PROV_SERIALIZED", ( 6 ))
CERT_STORE_PROV_FILENAME_A = make_flag("CERT_STORE_PROV_FILENAME_A", ( 7 ))
CERT_STORE_PROV_FILENAME_W = make_flag("CERT_STORE_PROV_FILENAME_W", ( 8 ))
CERT_STORE_PROV_FILENAME = make_flag("CERT_STORE_PROV_FILENAME", CERT_STORE_PROV_FILENAME_W)
CERT_STORE_PROV_SYSTEM_A = make_flag("CERT_STORE_PROV_SYSTEM_A", ( 9 ))
CERT_STORE_PROV_SYSTEM_W = make_flag("CERT_STORE_PROV_SYSTEM_W", ( 10 ))
CERT_STORE_PROV_SYSTEM = make_flag("CERT_STORE_PROV_SYSTEM", CERT_STORE_PROV_SYSTEM_W)
CERT_STORE_PROV_COLLECTION = make_flag("CERT_STORE_PROV_COLLECTION", ( 11 ))
CERT_STORE_PROV_SYSTEM_REGISTRY_A = make_flag("CERT_STORE_PROV_SYSTEM_REGISTRY_A", ( 12 ))
CERT_STORE_PROV_SYSTEM_REGISTRY_W = make_flag("CERT_STORE_PROV_SYSTEM_REGISTRY_W", ( 13 ))
CERT_STORE_PROV_SYSTEM_REGISTRY = make_flag("CERT_STORE_PROV_SYSTEM_REGISTRY", CERT_STORE_PROV_SYSTEM_REGISTRY_W)
CERT_STORE_PROV_PHYSICAL_W = make_flag("CERT_STORE_PROV_PHYSICAL_W", ( 14 ))
CERT_STORE_PROV_PHYSICAL = make_flag("CERT_STORE_PROV_PHYSICAL", CERT_STORE_PROV_PHYSICAL_W)
CERT_STORE_PROV_SMART_CARD_W = make_flag("CERT_STORE_PROV_SMART_CARD_W", ( 15 ))
CERT_STORE_PROV_SMART_CARD = make_flag("CERT_STORE_PROV_SMART_CARD", CERT_STORE_PROV_SMART_CARD_W)
CERT_STORE_PROV_LDAP_W = make_flag("CERT_STORE_PROV_LDAP_W", ( 16 ))
CERT_STORE_PROV_LDAP = make_flag("CERT_STORE_PROV_LDAP", CERT_STORE_PROV_LDAP_W)
CERT_STORE_PROV_PKCS12 = make_flag("CERT_STORE_PROV_PKCS12", ( 17 ))
CERT_STORE_NO_CRYPT_RELEASE_FLAG = make_flag("CERT_STORE_NO_CRYPT_RELEASE_FLAG", 0x00000001)
CERT_STORE_SET_LOCALIZED_NAME_FLAG = make_flag("CERT_STORE_SET_LOCALIZED_NAME_FLAG", 0x00000002)
CERT_STORE_DEFER_CLOSE_UNTIL_LAST_FREE_FLAG = make_flag("CERT_STORE_DEFER_CLOSE_UNTIL_LAST_FREE_FLAG", 0x00000004)
CERT_STORE_DELETE_FLAG = make_flag("CERT_STORE_DELETE_FLAG", 0x00000010)
CERT_STORE_UNSAFE_PHYSICAL_FLAG = make_flag("CERT_STORE_UNSAFE_PHYSICAL_FLAG", 0x00000020)
CERT_STORE_SHARE_STORE_FLAG = make_flag("CERT_STORE_SHARE_STORE_FLAG", 0x00000040)
CERT_STORE_SHARE_CONTEXT_FLAG = make_flag("CERT_STORE_SHARE_CONTEXT_FLAG", 0x00000080)
CERT_STORE_MANIFOLD_FLAG = make_flag("CERT_STORE_MANIFOLD_FLAG", 0x00000100)
CERT_STORE_ENUM_ARCHIVED_FLAG = make_flag("CERT_STORE_ENUM_ARCHIVED_FLAG", 0x00000200)
CERT_STORE_UPDATE_KEYID_FLAG = make_flag("CERT_STORE_UPDATE_KEYID_FLAG", 0x00000400)
CERT_STORE_BACKUP_RESTORE_FLAG = make_flag("CERT_STORE_BACKUP_RESTORE_FLAG", 0x00000800)
CERT_STORE_READONLY_FLAG = make_flag("CERT_STORE_READONLY_FLAG", 0x00008000)
CERT_STORE_OPEN_EXISTING_FLAG = make_flag("CERT_STORE_OPEN_EXISTING_FLAG", 0x00004000)
CERT_STORE_CREATE_NEW_FLAG = make_flag("CERT_STORE_CREATE_NEW_FLAG", 0x00002000)
CERT_STORE_MAXIMUM_ALLOWED_FLAG = make_flag("CERT_STORE_MAXIMUM_ALLOWED_FLAG", 0x00001000)
CRYPT_USER_KEYSET = make_flag("CRYPT_USER_KEYSET", 0x00001000)
PKCS12_PREFER_CNG_KSP = make_flag("PKCS12_PREFER_CNG_KSP", 0x00000100)
PKCS12_ALWAYS_CNG_KSP = make_flag("PKCS12_ALWAYS_CNG_KSP", 0x00000200)
PKCS12_ALLOW_OVERWRITE_KEY = make_flag("PKCS12_ALLOW_OVERWRITE_KEY", 0x00004000)
PKCS12_NO_PERSIST_KEY = make_flag("PKCS12_NO_PERSIST_KEY", 0x00008000)
CRYPT_VERIFYCONTEXT = make_flag("CRYPT_VERIFYCONTEXT", 0xF0000000)
CRYPT_NEWKEYSET = make_flag("CRYPT_NEWKEYSET", 0x00000008)
CRYPT_DELETEKEYSET = make_flag("CRYPT_DELETEKEYSET", 0x00000010)
CRYPT_MACHINE_KEYSET = make_flag("CRYPT_MACHINE_KEYSET", 0x00000020)
CRYPT_SILENT = make_flag("CRYPT_SILENT", 0x00000040)
CRYPT_DEFAULT_CONTAINER_OPTIONAL = make_flag("CRYPT_DEFAULT_CONTAINER_OPTIONAL", 0x00000080)
CRYPT_EXPORTABLE = make_flag("CRYPT_EXPORTABLE", 0x00000001)
CRYPT_USER_PROTECTED = make_flag("CRYPT_USER_PROTECTED", 0x00000002)
CRYPT_CREATE_SALT = make_flag("CRYPT_CREATE_SALT", 0x00000004)
CRYPT_UPDATE_KEY = make_flag("CRYPT_UPDATE_KEY", 0x00000008)
CRYPT_NO_SALT = make_flag("CRYPT_NO_SALT", 0x00000010)
CRYPT_PREGEN = make_flag("CRYPT_PREGEN", 0x00000040)
CRYPT_RECIPIENT = make_flag("CRYPT_RECIPIENT", 0x00000010)
CRYPT_INITIATOR = make_flag("CRYPT_INITIATOR", 0x00000040)
CRYPT_ONLINE = make_flag("CRYPT_ONLINE", 0x00000080)
CRYPT_SF = make_flag("CRYPT_SF", 0x00000100)
CRYPT_CREATE_IV = make_flag("CRYPT_CREATE_IV", 0x00000200)
CRYPT_KEK = make_flag("CRYPT_KEK", 0x00000400)
CRYPT_DATA_KEY = make_flag("CRYPT_DATA_KEY", 0x00000800)
CRYPT_VOLATILE = make_flag("CRYPT_VOLATILE", 0x00001000)
CRYPT_SGCKEY = make_flag("CRYPT_SGCKEY", 0x00002000)
CRYPT_ARCHIVABLE = make_flag("CRYPT_ARCHIVABLE", 0x00004000)
CRYPT_FORCE_KEY_PROTECTION_HIGH = make_flag("CRYPT_FORCE_KEY_PROTECTION_HIGH", 0x00008000)
CRYPT_ENCODE_DECODE_NONE = make_flag("CRYPT_ENCODE_DECODE_NONE", 0)
X509_CERT = make_flag("X509_CERT", ( 1 ))
X509_CERT_TO_BE_SIGNED = make_flag("X509_CERT_TO_BE_SIGNED", ( 2 ))
X509_CERT_CRL_TO_BE_SIGNED = make_flag("X509_CERT_CRL_TO_BE_SIGNED", ( 3 ))
X509_CERT_REQUEST_TO_BE_SIGNED = make_flag("X509_CERT_REQUEST_TO_BE_SIGNED", ( 4 ))
X509_EXTENSIONS = make_flag("X509_EXTENSIONS", ( 5 ))
X509_NAME_VALUE = make_flag("X509_NAME_VALUE", ( 6 ))
X509_NAME = make_flag("X509_NAME", ( 7 ))
X509_PUBLIC_KEY_INFO = make_flag("X509_PUBLIC_KEY_INFO", ( 8 ))
X509_AUTHORITY_KEY_ID = make_flag("X509_AUTHORITY_KEY_ID", ( 9 ))
X509_KEY_ATTRIBUTES = make_flag("X509_KEY_ATTRIBUTES", ( 10 ))
X509_KEY_USAGE_RESTRICTION = make_flag("X509_KEY_USAGE_RESTRICTION", ( 11 ))
X509_ALTERNATE_NAME = make_flag("X509_ALTERNATE_NAME", ( 12 ))
X509_BASIC_CONSTRAINTS = make_flag("X509_BASIC_CONSTRAINTS", ( 13 ))
X509_KEY_USAGE = make_flag("X509_KEY_USAGE", ( 14 ))
X509_BASIC_CONSTRAINTS2 = make_flag("X509_BASIC_CONSTRAINTS2", ( 15 ))
X509_CERT_POLICIES = make_flag("X509_CERT_POLICIES", ( 16 ))
PKCS_UTC_TIME = make_flag("PKCS_UTC_TIME", ( 17 ))
PKCS_TIME_REQUEST = make_flag("PKCS_TIME_REQUEST", ( 18 ))
RSA_CSP_PUBLICKEYBLOB = make_flag("RSA_CSP_PUBLICKEYBLOB", ( 19 ))
X509_UNICODE_NAME = make_flag("X509_UNICODE_NAME", ( 20 ))
X509_KEYGEN_REQUEST_TO_BE_SIGNED = make_flag("X509_KEYGEN_REQUEST_TO_BE_SIGNED", ( 21 ))
PKCS_ATTRIBUTE = make_flag("PKCS_ATTRIBUTE", ( 22 ))
PKCS_CONTENT_INFO_SEQUENCE_OF_ANY = make_flag("PKCS_CONTENT_INFO_SEQUENCE_OF_ANY", ( 23 ))
X509_UNICODE_NAME_VALUE = make_flag("X509_UNICODE_NAME_VALUE", ( 24 ))
X509_ANY_STRING = make_flag("X509_ANY_STRING", X509_NAME_VALUE)
X509_UNICODE_ANY_STRING = make_flag("X509_UNICODE_ANY_STRING", X509_UNICODE_NAME_VALUE)
X509_OCTET_STRING = make_flag("X509_OCTET_STRING", ( 25 ))
X509_BITS = make_flag("X509_BITS", ( 26 ))
X509_INTEGER = make_flag("X509_INTEGER", ( 27 ))
X509_MULTI_BYTE_INTEGER = make_flag("X509_MULTI_BYTE_INTEGER", ( 28 ))
X509_ENUMERATED = make_flag("X509_ENUMERATED", ( 29 ))
X509_CHOICE_OF_TIME = make_flag("X509_CHOICE_OF_TIME", ( 30 ))
CERT_SIMPLE_NAME_STR = make_flag("CERT_SIMPLE_NAME_STR", 1)
CERT_OID_NAME_STR = make_flag("CERT_OID_NAME_STR", 2)
CERT_X500_NAME_STR = make_flag("CERT_X500_NAME_STR", 3)
CERT_XML_NAME_STR = make_flag("CERT_XML_NAME_STR", 4)
AT_KEYEXCHANGE = make_flag("AT_KEYEXCHANGE", 1)
AT_SIGNATURE = make_flag("AT_SIGNATURE", 2)
MS_DEF_PROV_A = make_flag("MS_DEF_PROV_A", "Microsoft Base Cryptographic Provider v1.0")
MS_DEF_PROV_W = make_flag("MS_DEF_PROV_W", u"Microsoft Base Cryptographic Provider v1.0")
MS_DEF_PROV = make_flag("MS_DEF_PROV", MS_DEF_PROV_A)
MS_ENHANCED_PROV_A = make_flag("MS_ENHANCED_PROV_A", "Microsoft Enhanced Cryptographic Provider v1.0")
MS_ENHANCED_PROV_W = make_flag("MS_ENHANCED_PROV_W", u"Microsoft Enhanced Cryptographic Provider v1.0")
MS_ENHANCED_PROV = make_flag("MS_ENHANCED_PROV", MS_ENHANCED_PROV_A)
MS_STRONG_PROV_A = make_flag("MS_STRONG_PROV_A", "Microsoft Strong Cryptographic Provider")
MS_STRONG_PROV_W = make_flag("MS_STRONG_PROV_W", u"Microsoft Strong Cryptographic Provider")
MS_STRONG_PROV = make_flag("MS_STRONG_PROV", MS_STRONG_PROV_A)
MS_DEF_RSA_SIG_PROV_A = make_flag("MS_DEF_RSA_SIG_PROV_A", "Microsoft RSA Signature Cryptographic Provider")
MS_DEF_RSA_SIG_PROV_W = make_flag("MS_DEF_RSA_SIG_PROV_W", u"Microsoft RSA Signature Cryptographic Provider")
MS_DEF_RSA_SIG_PROV = make_flag("MS_DEF_RSA_SIG_PROV", MS_DEF_RSA_SIG_PROV_A)
MS_ENH_RSA_AES_PROV_A = make_flag("MS_ENH_RSA_AES_PROV_A", "Microsoft Enhanced RSA and AES Cryptographic Provider")
MS_ENH_RSA_AES_PROV_W = make_flag("MS_ENH_RSA_AES_PROV_W", u"Microsoft Enhanced RSA and AES Cryptographic Provider")
MS_ENH_RSA_AES_PROV_XP_A = make_flag("MS_ENH_RSA_AES_PROV_XP_A", "Microsoft Enhanced RSA and AES Cryptographic Provider ( Prototype ) ")
MS_ENH_RSA_AES_PROV_XP_W = make_flag("MS_ENH_RSA_AES_PROV_XP_W", u"Microsoft Enhanced RSA and AES Cryptographic Provider ( Prototype ) ")
CERT_STORE_ADD_NEW = make_flag("CERT_STORE_ADD_NEW", 1)
CERT_STORE_ADD_USE_EXISTING = make_flag("CERT_STORE_ADD_USE_EXISTING", 2)
CERT_STORE_ADD_REPLACE_EXISTING = make_flag("CERT_STORE_ADD_REPLACE_EXISTING", 3)
CERT_STORE_ADD_ALWAYS = make_flag("CERT_STORE_ADD_ALWAYS", 4)
CERT_STORE_ADD_REPLACE_EXISTING_INHERIT_PROPERTIES = make_flag("CERT_STORE_ADD_REPLACE_EXISTING_INHERIT_PROPERTIES", 5)
CERT_STORE_ADD_NEWER = make_flag("CERT_STORE_ADD_NEWER", 6)
CERT_STORE_ADD_NEWER_INHERIT_PROPERTIES = make_flag("CERT_STORE_ADD_NEWER_INHERIT_PROPERTIES", 7)
PROV_RSA_FULL = make_flag("PROV_RSA_FULL", 1)
PROV_RSA_SIG = make_flag("PROV_RSA_SIG", 2)
PROV_DSS = make_flag("PROV_DSS", 3)
PROV_FORTEZZA = make_flag("PROV_FORTEZZA", 4)
PROV_MS_EXCHANGE = make_flag("PROV_MS_EXCHANGE", 5)
PROV_SSL = make_flag("PROV_SSL", 6)
PROV_RSA_SCHANNEL = make_flag("PROV_RSA_SCHANNEL", 12)
PROV_DSS_DH = make_flag("PROV_DSS_DH", 13)
PROV_EC_ECDSA_SIG = make_flag("PROV_EC_ECDSA_SIG", 14)
PROV_EC_ECNRA_SIG = make_flag("PROV_EC_ECNRA_SIG", 15)
PROV_EC_ECDSA_FULL = make_flag("PROV_EC_ECDSA_FULL", 16)
PROV_EC_ECNRA_FULL = make_flag("PROV_EC_ECNRA_FULL", 17)
PROV_DH_SCHANNEL = make_flag("PROV_DH_SCHANNEL", 18)
PROV_SPYRUS_LYNKS = make_flag("PROV_SPYRUS_LYNKS", 20)
PROV_RNG = make_flag("PROV_RNG", 21)
PROV_INTEL_SEC = make_flag("PROV_INTEL_SEC", 22)
PROV_REPLACE_OWF = make_flag("PROV_REPLACE_OWF", 23)
PROV_RSA_AES = make_flag("PROV_RSA_AES", 24)
REPORT_NO_PRIVATE_KEY = make_flag("REPORT_NO_PRIVATE_KEY", 0x0001)
REPORT_NOT_ABLE_TO_EXPORT_PRIVATE_KEY = make_flag("REPORT_NOT_ABLE_TO_EXPORT_PRIVATE_KEY", 0x0002)
EXPORT_PRIVATE_KEYS = make_flag("EXPORT_PRIVATE_KEYS", 0x0004)
PKCS12_INCLUDE_EXTENDED_PROPERTIES = make_flag("PKCS12_INCLUDE_EXTENDED_PROPERTIES", 0x0010)
PKCS12_EXPORT_RESERVED_MASK = make_flag("PKCS12_EXPORT_RESERVED_MASK", 0xffff0000)
CERT_SYSTEM_STORE_UNPROTECTED_FLAG = make_flag("CERT_SYSTEM_STORE_UNPROTECTED_FLAG", 0x40000000)
CERT_SYSTEM_STORE_LOCATION_MASK = make_flag("CERT_SYSTEM_STORE_LOCATION_MASK", 0x00FF0000)
CERT_SYSTEM_STORE_LOCATION_SHIFT = make_flag("CERT_SYSTEM_STORE_LOCATION_SHIFT", 16)
CERT_SYSTEM_STORE_CURRENT_USER_ID = make_flag("CERT_SYSTEM_STORE_CURRENT_USER_ID", 1)
CERT_SYSTEM_STORE_LOCAL_MACHINE_ID = make_flag("CERT_SYSTEM_STORE_LOCAL_MACHINE_ID", 2)
CERT_SYSTEM_STORE_CURRENT_SERVICE_ID = make_flag("CERT_SYSTEM_STORE_CURRENT_SERVICE_ID", 4)
CERT_SYSTEM_STORE_SERVICES_ID = make_flag("CERT_SYSTEM_STORE_SERVICES_ID", 5)
CERT_SYSTEM_STORE_USERS_ID = make_flag("CERT_SYSTEM_STORE_USERS_ID", 6)
CERT_SYSTEM_STORE_CURRENT_USER_GROUP_POLICY_ID = make_flag("CERT_SYSTEM_STORE_CURRENT_USER_GROUP_POLICY_ID", 7)
CERT_SYSTEM_STORE_LOCAL_MACHINE_GROUP_POLICY_ID = make_flag("CERT_SYSTEM_STORE_LOCAL_MACHINE_GROUP_POLICY_ID", 8)
CERT_SYSTEM_STORE_LOCAL_MACHINE_ENTERPRISE_ID = make_flag("CERT_SYSTEM_STORE_LOCAL_MACHINE_ENTERPRISE_ID", 9)
CERT_SYSTEM_STORE_CURRENT_USER = make_flag("CERT_SYSTEM_STORE_CURRENT_USER", ( CERT_SYSTEM_STORE_CURRENT_USER_ID << CERT_SYSTEM_STORE_LOCATION_SHIFT ))
CERT_SYSTEM_STORE_LOCAL_MACHINE = make_flag("CERT_SYSTEM_STORE_LOCAL_MACHINE", ( CERT_SYSTEM_STORE_LOCAL_MACHINE_ID << CERT_SYSTEM_STORE_LOCATION_SHIFT ))
CERT_SYSTEM_STORE_CURRENT_SERVICE = make_flag("CERT_SYSTEM_STORE_CURRENT_SERVICE", ( CERT_SYSTEM_STORE_CURRENT_SERVICE_ID << CERT_SYSTEM_STORE_LOCATION_SHIFT ))
CERT_SYSTEM_STORE_SERVICES = make_flag("CERT_SYSTEM_STORE_SERVICES", ( CERT_SYSTEM_STORE_SERVICES_ID << CERT_SYSTEM_STORE_LOCATION_SHIFT ))
CERT_SYSTEM_STORE_USERS = make_flag("CERT_SYSTEM_STORE_USERS", ( CERT_SYSTEM_STORE_USERS_ID << CERT_SYSTEM_STORE_LOCATION_SHIFT ))
CERT_SYSTEM_STORE_CURRENT_USER_GROUP_POLICY = make_flag("CERT_SYSTEM_STORE_CURRENT_USER_GROUP_POLICY", ( CERT_SYSTEM_STORE_CURRENT_USER_GROUP_POLICY_ID << CERT_SYSTEM_STORE_LOCATION_SHIFT ))
CERT_SYSTEM_STORE_LOCAL_MACHINE_GROUP_POLICY = make_flag("CERT_SYSTEM_STORE_LOCAL_MACHINE_GROUP_POLICY", ( CERT_SYSTEM_STORE_LOCAL_MACHINE_GROUP_POLICY_ID << CERT_SYSTEM_STORE_LOCATION_SHIFT ))
CERT_SYSTEM_STORE_LOCAL_MACHINE_ENTERPRISE = make_flag("CERT_SYSTEM_STORE_LOCAL_MACHINE_ENTERPRISE", ( CERT_SYSTEM_STORE_LOCAL_MACHINE_ENTERPRISE_ID << CERT_SYSTEM_STORE_LOCATION_SHIFT ))
CMSG_DATA = make_flag("CMSG_DATA", 1)
CMSG_SIGNED = make_flag("CMSG_SIGNED", 2)
CMSG_ENVELOPED = make_flag("CMSG_ENVELOPED", 3)
CMSG_SIGNED_AND_ENVELOPED = make_flag("CMSG_SIGNED_AND_ENVELOPED", 4)
CMSG_HASHED = make_flag("CMSG_HASHED", 5)
CMSG_ENCRYPTED = make_flag("CMSG_ENCRYPTED", 6)
CMSG_BARE_CONTENT_FLAG = make_flag("CMSG_BARE_CONTENT_FLAG", 0x00000001)
CMSG_LENGTH_ONLY_FLAG = make_flag("CMSG_LENGTH_ONLY_FLAG", 0x00000002)
CMSG_DETACHED_FLAG = make_flag("CMSG_DETACHED_FLAG", 0x00000004)
CMSG_AUTHENTICATED_ATTRIBUTES_FLAG = make_flag("CMSG_AUTHENTICATED_ATTRIBUTES_FLAG", 0x00000008)
CMSG_CONTENTS_OCTETS_FLAG = make_flag("CMSG_CONTENTS_OCTETS_FLAG", 0x00000010)
CMSG_MAX_LENGTH_FLAG = make_flag("CMSG_MAX_LENGTH_FLAG", 0x00000020)
CMSG_CMS_ENCAPSULATED_CONTENT_FLAG = make_flag("CMSG_CMS_ENCAPSULATED_CONTENT_FLAG", 0x00000040)
CMSG_CRYPT_RELEASE_CONTEXT_FLAG = make_flag("CMSG_CRYPT_RELEASE_CONTEXT_FLAG", 0x00008000)
CMSG_INDEFINITE_LENGTH = make_flag("CMSG_INDEFINITE_LENGTH", ( 0xFFFFFFFF ))
CMSG_CTRL_VERIFY_SIGNATURE = make_flag("CMSG_CTRL_VERIFY_SIGNATURE", 1)
CMSG_CTRL_DECRYPT = make_flag("CMSG_CTRL_DECRYPT", 2)
CMSG_CTRL_VERIFY_HASH = make_flag("CMSG_CTRL_VERIFY_HASH", 5)
CMSG_CTRL_ADD_SIGNER = make_flag("CMSG_CTRL_ADD_SIGNER", 6)
CMSG_CTRL_DEL_SIGNER = make_flag("CMSG_CTRL_DEL_SIGNER", 7)
CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR = make_flag("CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR", 8)
CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR = make_flag("CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR", 9)
CMSG_CTRL_ADD_CERT = make_flag("CMSG_CTRL_ADD_CERT", 10)
CMSG_CTRL_DEL_CERT = make_flag("CMSG_CTRL_DEL_CERT", 11)
CMSG_CTRL_ADD_CRL = make_flag("CMSG_CTRL_ADD_CRL", 12)
CMSG_CTRL_DEL_CRL = make_flag("CMSG_CTRL_DEL_CRL", 13)
CMSG_CTRL_ADD_ATTR_CERT = make_flag("CMSG_CTRL_ADD_ATTR_CERT", 14)
CMSG_CTRL_DEL_ATTR_CERT = make_flag("CMSG_CTRL_DEL_ATTR_CERT", 15)
CMSG_CTRL_KEY_TRANS_DECRYPT = make_flag("CMSG_CTRL_KEY_TRANS_DECRYPT", 16)
CMSG_CTRL_KEY_AGREE_DECRYPT = make_flag("CMSG_CTRL_KEY_AGREE_DECRYPT", 17)
CMSG_CTRL_MAIL_LIST_DECRYPT = make_flag("CMSG_CTRL_MAIL_LIST_DECRYPT", 18)
CMSG_CTRL_VERIFY_SIGNATURE_EX = make_flag("CMSG_CTRL_VERIFY_SIGNATURE_EX", 19)
CMSG_CTRL_ADD_CMS_SIGNER_INFO = make_flag("CMSG_CTRL_ADD_CMS_SIGNER_INFO", 20)
CMSG_CTRL_ENABLE_STRONG_SIGNATURE = make_flag("CMSG_CTRL_ENABLE_STRONG_SIGNATURE", 21)
INVALID_HANDLE_VALUE = make_flag("INVALID_HANDLE_VALUE", ( ( -1 ) & NATIVE_WORD_MAX_VALUE ))
NULL = make_flag("NULL", 0)
MAX_PATH = make_flag("MAX_PATH", 260)
ANYSIZE_ARRAY = make_flag("ANYSIZE_ARRAY", 1)
ANY_SIZE = make_flag("ANY_SIZE", 1)
IMAGE_SIZEOF_SHORT_NAME = make_flag("IMAGE_SIZEOF_SHORT_NAME", 8)
IMAGE_NUMBEROF_DIRECTORY_ENTRIES = make_flag("IMAGE_NUMBEROF_DIRECTORY_ENTRIES", 16)
INFINITE = make_flag("INFINITE", 0xFFFFFFFF)
STD_INPUT_HANDLE = make_flag("STD_INPUT_HANDLE", -10)
STD_OUTPUT_HANDLE = make_flag("STD_OUTPUT_HANDLE", -11)
STD_ERROR_HANDLE = make_flag("STD_ERROR_HANDLE", -12)
WARMING_NOT_SAME_FLAG_FOR_WINXP = make_flag("WARMING_NOT_SAME_FLAG_FOR_WINXP", 0)
STARTF_USESHOWWINDOW = make_flag("STARTF_USESHOWWINDOW", 0x00000001)
STARTF_USESIZE = make_flag("STARTF_USESIZE", 0x00000002)
STARTF_USEPOSITION = make_flag("STARTF_USEPOSITION", 0x00000004)
STARTF_USECOUNTCHARS = make_flag("STARTF_USECOUNTCHARS", 0x00000008)
STARTF_USEFILLATTRIBUTE = make_flag("STARTF_USEFILLATTRIBUTE", 0x00000010)
STARTF_RUNFULLSCREEN = make_flag("STARTF_RUNFULLSCREEN", 0x00000020)
STARTF_FORCEONFEEDBACK = make_flag("STARTF_FORCEONFEEDBACK", 0x00000040)
STARTF_FORCEOFFFEEDBACK = make_flag("STARTF_FORCEOFFFEEDBACK", 0x00000080)
STARTF_USESTDHANDLES = make_flag("STARTF_USESTDHANDLES", 0x00000100)
SW_HIDE = make_flag("SW_HIDE", 0)
SW_SHOWNORMAL = make_flag("SW_SHOWNORMAL", 1)
SW_NORMAL = make_flag("SW_NORMAL", 1)
SW_SHOWMINIMIZED = make_flag("SW_SHOWMINIMIZED", 2)
SW_SHOWMAXIMIZED = make_flag("SW_SHOWMAXIMIZED", 3)
SW_MAXIMIZE = make_flag("SW_MAXIMIZE", 3)
SW_SHOWNOACTIVATE = make_flag("SW_SHOWNOACTIVATE", 4)
SW_SHOW = make_flag("SW_SHOW", 5)
SW_MINIMIZE = make_flag("SW_MINIMIZE", 6)
SW_SHOWMINNOACTIVE = make_flag("SW_SHOWMINNOACTIVE", 7)
SW_SHOWNA = make_flag("SW_SHOWNA", 8)
SW_RESTORE = make_flag("SW_RESTORE", 9)
SW_SHOWDEFAULT = make_flag("SW_SHOWDEFAULT", 10)
SW_FORCEMINIMIZE = make_flag("SW_FORCEMINIMIZE", 11)
SW_MAX = make_flag("SW_MAX", 11)
DEBUG_PROCESS = make_flag("DEBUG_PROCESS", 0x00000001)
DEBUG_ONLY_THIS_PROCESS = make_flag("DEBUG_ONLY_THIS_PROCESS", 0x00000002)
CREATE_SUSPENDED = make_flag("CREATE_SUSPENDED", 0x00000004)
DETACHED_PROCESS = make_flag("DETACHED_PROCESS", 0x00000008)
CREATE_NEW_CONSOLE = make_flag("CREATE_NEW_CONSOLE", 0x00000010)
NORMAL_PRIORITY_CLASS = make_flag("NORMAL_PRIORITY_CLASS", 0x00000020)
IDLE_PRIORITY_CLASS = make_flag("IDLE_PRIORITY_CLASS", 0x00000040)
HIGH_PRIORITY_CLASS = make_flag("HIGH_PRIORITY_CLASS", 0x00000080)
REALTIME_PRIORITY_CLASS = make_flag("REALTIME_PRIORITY_CLASS", 0x00000100)
CREATE_NEW_PROCESS_GROUP = make_flag("CREATE_NEW_PROCESS_GROUP", 0x00000200)
CREATE_UNICODE_ENVIRONMENT = make_flag("CREATE_UNICODE_ENVIRONMENT", 0x00000400)
CREATE_SEPARATE_WOW_VDM = make_flag("CREATE_SEPARATE_WOW_VDM", 0x00000800)
CREATE_SHARED_WOW_VDM = make_flag("CREATE_SHARED_WOW_VDM", 0x00001000)
CREATE_FORCEDOS = make_flag("CREATE_FORCEDOS", 0x00002000)
BELOW_NORMAL_PRIORITY_CLASS = make_flag("BELOW_NORMAL_PRIORITY_CLASS", 0x00004000)
ABOVE_NORMAL_PRIORITY_CLASS = make_flag("ABOVE_NORMAL_PRIORITY_CLASS", 0x00008000)
INHERIT_PARENT_AFFINITY = make_flag("INHERIT_PARENT_AFFINITY", 0x00010000)
INHERIT_CALLER_PRIORITY = make_flag("INHERIT_CALLER_PRIORITY", 0x00020000)
CREATE_PROTECTED_PROCESS = make_flag("CREATE_PROTECTED_PROCESS", 0x00040000)
EXTENDED_STARTUPINFO_PRESENT = make_flag("EXTENDED_STARTUPINFO_PRESENT", 0x00080000)
PROCESS_MODE_BACKGROUND_BEGIN = make_flag("PROCESS_MODE_BACKGROUND_BEGIN", 0x00100000)
PROCESS_MODE_BACKGROUND_END = make_flag("PROCESS_MODE_BACKGROUND_END", 0x00200000)
CREATE_BREAKAWAY_FROM_JOB = make_flag("CREATE_BREAKAWAY_FROM_JOB", 0x01000000)
CREATE_PRESERVE_CODE_AUTHZ_LEVEL = make_flag("CREATE_PRESERVE_CODE_AUTHZ_LEVEL", 0x02000000)
CREATE_DEFAULT_ERROR_MODE = make_flag("CREATE_DEFAULT_ERROR_MODE", 0x04000000)
CREATE_NO_WINDOW = make_flag("CREATE_NO_WINDOW", 0x08000000)
PROFILE_USER = make_flag("PROFILE_USER", 0x10000000)
PROFILE_KERNEL = make_flag("PROFILE_KERNEL", 0x20000000)
PROFILE_SERVER = make_flag("PROFILE_SERVER", 0x40000000)
CREATE_IGNORE_SYSTEM_DEFAULT = make_flag("CREATE_IGNORE_SYSTEM_DEFAULT", 0x80000000)
WAIT_IO_COMPLETION = make_flag("WAIT_IO_COMPLETION", STATUS_USER_APC)
STILL_ACTIVE = make_flag("STILL_ACTIVE", STATUS_PENDING)
EXCEPTION_ACCESS_VIOLATION = make_flag("EXCEPTION_ACCESS_VIOLATION", STATUS_ACCESS_VIOLATION)
EXCEPTION_DATATYPE_MISALIGNMENT = make_flag("EXCEPTION_DATATYPE_MISALIGNMENT", STATUS_DATATYPE_MISALIGNMENT)
EXCEPTION_BREAKPOINT = make_flag("EXCEPTION_BREAKPOINT", STATUS_BREAKPOINT)
EXCEPTION_SINGLE_STEP = make_flag("EXCEPTION_SINGLE_STEP", STATUS_SINGLE_STEP)
EXCEPTION_ARRAY_BOUNDS_EXCEEDED = make_flag("EXCEPTION_ARRAY_BOUNDS_EXCEEDED", STATUS_ARRAY_BOUNDS_EXCEEDED)
EXCEPTION_FLT_DENORMAL_OPERAND = make_flag("EXCEPTION_FLT_DENORMAL_OPERAND", STATUS_FLOAT_DENORMAL_OPERAND)
EXCEPTION_FLT_DIVIDE_BY_ZERO = make_flag("EXCEPTION_FLT_DIVIDE_BY_ZERO", STATUS_FLOAT_DIVIDE_BY_ZERO)
EXCEPTION_FLT_INEXACT_RESULT = make_flag("EXCEPTION_FLT_INEXACT_RESULT", STATUS_FLOAT_INEXACT_RESULT)
EXCEPTION_FLT_INVALID_OPERATION = make_flag("EXCEPTION_FLT_INVALID_OPERATION", STATUS_FLOAT_INVALID_OPERATION)
EXCEPTION_FLT_OVERFLOW = make_flag("EXCEPTION_FLT_OVERFLOW", STATUS_FLOAT_OVERFLOW)
EXCEPTION_FLT_STACK_CHECK = make_flag("EXCEPTION_FLT_STACK_CHECK", STATUS_FLOAT_STACK_CHECK)
EXCEPTION_FLT_UNDERFLOW = make_flag("EXCEPTION_FLT_UNDERFLOW", STATUS_FLOAT_UNDERFLOW)
EXCEPTION_INT_DIVIDE_BY_ZERO = make_flag("EXCEPTION_INT_DIVIDE_BY_ZERO", STATUS_INTEGER_DIVIDE_BY_ZERO)
EXCEPTION_INT_OVERFLOW = make_flag("EXCEPTION_INT_OVERFLOW", STATUS_INTEGER_OVERFLOW)
EXCEPTION_PRIV_INSTRUCTION = make_flag("EXCEPTION_PRIV_INSTRUCTION", STATUS_PRIVILEGED_INSTRUCTION)
EXCEPTION_IN_PAGE_ERROR = make_flag("EXCEPTION_IN_PAGE_ERROR", STATUS_IN_PAGE_ERROR)
EXCEPTION_ILLEGAL_INSTRUCTION = make_flag("EXCEPTION_ILLEGAL_INSTRUCTION", STATUS_ILLEGAL_INSTRUCTION)
EXCEPTION_NONCONTINUABLE_EXCEPTION = make_flag("EXCEPTION_NONCONTINUABLE_EXCEPTION", STATUS_NONCONTINUABLE_EXCEPTION)
EXCEPTION_STACK_OVERFLOW = make_flag("EXCEPTION_STACK_OVERFLOW", STATUS_STACK_OVERFLOW)
EXCEPTION_INVALID_DISPOSITION = make_flag("EXCEPTION_INVALID_DISPOSITION", STATUS_INVALID_DISPOSITION)
EXCEPTION_GUARD_PAGE = make_flag("EXCEPTION_GUARD_PAGE", STATUS_GUARD_PAGE_VIOLATION)
EXCEPTION_INVALID_HANDLE = make_flag("EXCEPTION_INVALID_HANDLE", STATUS_INVALID_HANDLE)
EXCEPTION_POSSIBLE_DEADLOCK = make_flag("EXCEPTION_POSSIBLE_DEADLOCK", STATUS_POSSIBLE_DEADLOCK)
CONTROL_C_EXIT = make_flag("CONTROL_C_EXIT", STATUS_CONTROL_C_EXIT)
EXCEPTION_DEBUG_EVENT = make_flag("EXCEPTION_DEBUG_EVENT", 1)
CREATE_THREAD_DEBUG_EVENT = make_flag("CREATE_THREAD_DEBUG_EVENT", 2)
CREATE_PROCESS_DEBUG_EVENT = make_flag("CREATE_PROCESS_DEBUG_EVENT", 3)
EXIT_THREAD_DEBUG_EVENT = make_flag("EXIT_THREAD_DEBUG_EVENT", 4)
EXIT_PROCESS_DEBUG_EVENT = make_flag("EXIT_PROCESS_DEBUG_EVENT", 5)
LOAD_DLL_DEBUG_EVENT = make_flag("LOAD_DLL_DEBUG_EVENT", 6)
UNLOAD_DLL_DEBUG_EVENT = make_flag("UNLOAD_DLL_DEBUG_EVENT", 7)
OUTPUT_DEBUG_STRING_EVENT = make_flag("OUTPUT_DEBUG_STRING_EVENT", 8)
RIP_EVENT = make_flag("RIP_EVENT", 9)
TH32CS_SNAPHEAPLIST = make_flag("TH32CS_SNAPHEAPLIST", 0x00000001)
TH32CS_SNAPPROCESS = make_flag("TH32CS_SNAPPROCESS", 0x00000002)
TH32CS_SNAPTHREAD = make_flag("TH32CS_SNAPTHREAD", 0x00000004)
TH32CS_SNAPMODULE = make_flag("TH32CS_SNAPMODULE", 0x00000008)
TH32CS_SNAPMODULE32 = make_flag("TH32CS_SNAPMODULE32", 0x00000010)
TH32CS_SNAPALL = make_flag("TH32CS_SNAPALL", ( TH32CS_SNAPHEAPLIST | TH32CS_SNAPPROCESS | TH32CS_SNAPTHREAD | TH32CS_SNAPMODULE ))
TH32CS_INHERIT = make_flag("TH32CS_INHERIT", 0x80000000)
CONTEXT_I386 = make_flag("CONTEXT_I386", 0x00010000)
CONTEXT_CONTROL = make_flag("CONTEXT_CONTROL", 0x00000001)
CONTEXT_INTEGER = make_flag("CONTEXT_INTEGER", 0x00000002)
CONTEXT_SEGMENTS = make_flag("CONTEXT_SEGMENTS", 0x00000004)
CONTEXT_FLOATING_POINT = make_flag("CONTEXT_FLOATING_POINT", 0x00000008)
CONTEXT_DEBUG_REGISTERS = make_flag("CONTEXT_DEBUG_REGISTERS", 0x00000010)
CONTEXT_EXTENDED_REGISTERS = make_flag("CONTEXT_EXTENDED_REGISTERS", 0x00000020)
CONTEXT_FULL = make_flag("CONTEXT_FULL", ( CONTEXT_CONTROL | CONTEXT_INTEGER | CONTEXT_SEGMENTS ))
CONTEXT_ALL = make_flag("CONTEXT_ALL", ( CONTEXT_FULL | CONTEXT_FLOATING_POINT | CONTEXT_DEBUG_REGISTERS | CONTEXT_EXTENDED_REGISTERS ))
CONTEXT_FULL = make_flag("CONTEXT_FULL", CONTEXT_I386 | CONTEXT_FULL)
CONTEXT_ALL = make_flag("CONTEXT_ALL", CONTEXT_I386 | CONTEXT_ALL)
CONTEXT_XSTATE = make_flag("CONTEXT_XSTATE", ( CONTEXT_I386 | 0x00000040 ))
PAGE_NOACCESS = make_flag("PAGE_NOACCESS", 0x01)
PAGE_READONLY = make_flag("PAGE_READONLY", 0x02)
PAGE_READWRITE = make_flag("PAGE_READWRITE", 0x04)
PAGE_WRITECOPY = make_flag("PAGE_WRITECOPY", 0x08)
PAGE_EXECUTE = make_flag("PAGE_EXECUTE", 0x10)
PAGE_EXECUTE_READ = make_flag("PAGE_EXECUTE_READ", 0x20)
PAGE_EXECUTE_READWRITE = make_flag("PAGE_EXECUTE_READWRITE", 0x40)
PAGE_EXECUTE_WRITECOPY = make_flag("PAGE_EXECUTE_WRITECOPY", 0x80)
PAGE_GUARD = make_flag("PAGE_GUARD", 0x100)
PAGE_NOCACHE = make_flag("PAGE_NOCACHE", 0x200)
PAGE_WRITECOMBINE = make_flag("PAGE_WRITECOMBINE", 0x400)
MEM_COMMIT = make_flag("MEM_COMMIT", 0x1000)
MEM_RESERVE = make_flag("MEM_RESERVE", 0x2000)
MEM_DECOMMIT = make_flag("MEM_DECOMMIT", 0x4000)
MEM_RELEASE = make_flag("MEM_RELEASE", 0x8000)
MEM_FREE = make_flag("MEM_FREE", 0x10000)
MEM_PRIVATE = make_flag("MEM_PRIVATE", 0x20000)
MEM_MAPPED = make_flag("MEM_MAPPED", 0x40000)
MEM_RESET = make_flag("MEM_RESET", 0x80000)
MEM_TOP_DOWN = make_flag("MEM_TOP_DOWN", 0x100000)
MEM_WRITE_WATCH = make_flag("MEM_WRITE_WATCH", 0x200000)
MEM_PHYSICAL = make_flag("MEM_PHYSICAL", 0x400000)
MEM_ROTATE = make_flag("MEM_ROTATE", 0x800000)
MEM_LARGE_PAGES = make_flag("MEM_LARGE_PAGES", 0x20000000)
MEM_4MB_PAGES = make_flag("MEM_4MB_PAGES", 0x80000000)
SEC_FILE = make_flag("SEC_FILE", 0x800000)
SEC_IMAGE = make_flag("SEC_IMAGE", 0x1000000)
SEC_PROTECTED_IMAGE = make_flag("SEC_PROTECTED_IMAGE", 0x2000000)
SEC_RESERVE = make_flag("SEC_RESERVE", 0x4000000)
SEC_COMMIT = make_flag("SEC_COMMIT", 0x8000000)
SEC_NOCACHE = make_flag("SEC_NOCACHE", 0x10000000)
SEC_WRITECOMBINE = make_flag("SEC_WRITECOMBINE", 0x40000000)
SEC_LARGE_PAGES = make_flag("SEC_LARGE_PAGES", 0x80000000)
MEM_IMAGE = make_flag("MEM_IMAGE", SEC_IMAGE)
WRITE_WATCH_FLAG_RESET = make_flag("WRITE_WATCH_FLAG_RESET", 0x01)
DELETE = make_flag("DELETE", ( 0x00010000 ))
READ_CONTROL = make_flag("READ_CONTROL", ( 0x00020000 ))
WRITE_DAC = make_flag("WRITE_DAC", ( 0x00040000 ))
WRITE_OWNER = make_flag("WRITE_OWNER", ( 0x00080000 ))
SYNCHRONIZE = make_flag("SYNCHRONIZE", ( 0x00100000 ))
STANDARD_RIGHTS_REQUIRED = make_flag("STANDARD_RIGHTS_REQUIRED", ( 0x000F0000 ))
STANDARD_RIGHTS_READ = make_flag("STANDARD_RIGHTS_READ", ( READ_CONTROL ))
STANDARD_RIGHTS_WRITE = make_flag("STANDARD_RIGHTS_WRITE", ( READ_CONTROL ))
STANDARD_RIGHTS_EXECUTE = make_flag("STANDARD_RIGHTS_EXECUTE", ( READ_CONTROL ))
STANDARD_RIGHTS_ALL = make_flag("STANDARD_RIGHTS_ALL", ( 0x001F0000 ))
SPECIFIC_RIGHTS_ALL = make_flag("SPECIFIC_RIGHTS_ALL", ( 0x0000FFFF ))
AF_UNSPEC = make_flag("AF_UNSPEC", 0)
AF_UNIX = make_flag("AF_UNIX", 1)
AF_INET = make_flag("AF_INET", 2)
AF_IMPLINK = make_flag("AF_IMPLINK", 3)
AF_PUP = make_flag("AF_PUP", 4)
AF_CHAOS = make_flag("AF_CHAOS", 5)
AF_NS = make_flag("AF_NS", 6)
AF_IPX = make_flag("AF_IPX", AF_NS)
AF_ISO = make_flag("AF_ISO", 7)
AF_OSI = make_flag("AF_OSI", AF_ISO)
AF_ECMA = make_flag("AF_ECMA", 8)
AF_DATAKIT = make_flag("AF_DATAKIT", 9)
AF_CCITT = make_flag("AF_CCITT", 10)
AF_SNA = make_flag("AF_SNA", 11)
AF_DECnet = make_flag("AF_DECnet", 12)
AF_DLI = make_flag("AF_DLI", 13)
AF_LAT = make_flag("AF_LAT", 14)
AF_HYLINK = make_flag("AF_HYLINK", 15)
AF_APPLETALK = make_flag("AF_APPLETALK", 16)
AF_NETBIOS = make_flag("AF_NETBIOS", 17)
AF_VOICEVIEW = make_flag("AF_VOICEVIEW", 18)
AF_FIREFOX = make_flag("AF_FIREFOX", 19)
AF_UNKNOWN1 = make_flag("AF_UNKNOWN1", 20)
AF_BAN = make_flag("AF_BAN", 21)
AF_ATM = make_flag("AF_ATM", 22)
AF_INET6 = make_flag("AF_INET6", 23)
AF_CLUSTER = make_flag("AF_CLUSTER", 24)
AF_12844 = make_flag("AF_12844", 25)
AF_IRDA = make_flag("AF_IRDA", 26)
AF_NETDES = make_flag("AF_NETDES", 28)
EXCEPTION_NONCONTINUABLE = make_flag("EXCEPTION_NONCONTINUABLE", 0x1)
EXCEPTION_MAXIMUM_PARAMETERS = make_flag("EXCEPTION_MAXIMUM_PARAMETERS", 15)
EXCEPTION_EXECUTE_HANDLER = make_flag("EXCEPTION_EXECUTE_HANDLER", 1)
EXCEPTION_CONTINUE_SEARCH = make_flag("EXCEPTION_CONTINUE_SEARCH", 0)
EXCEPTION_CONTINUE_EXECUTION = make_flag("EXCEPTION_CONTINUE_EXECUTION", -1)
GENERIC_READ = make_flag("GENERIC_READ", ( 0x80000000 ))
GENERIC_WRITE = make_flag("GENERIC_WRITE", ( 0x40000000 ))
GENERIC_EXECUTE = make_flag("GENERIC_EXECUTE", ( 0x20000000 ))
GENERIC_ALL = make_flag("GENERIC_ALL", ( 0x10000000 ))
FILE_FLAG_WRITE_THROUGH = make_flag("FILE_FLAG_WRITE_THROUGH", 0x80000000)
FILE_FLAG_OVERLAPPED = make_flag("FILE_FLAG_OVERLAPPED", 0x40000000)
FILE_FLAG_NO_BUFFERING = make_flag("FILE_FLAG_NO_BUFFERING", 0x20000000)
FILE_FLAG_RANDOM_ACCESS = make_flag("FILE_FLAG_RANDOM_ACCESS", 0x10000000)
FILE_FLAG_SEQUENTIAL_SCAN = make_flag("FILE_FLAG_SEQUENTIAL_SCAN", 0x08000000)
FILE_FLAG_DELETE_ON_CLOSE = make_flag("FILE_FLAG_DELETE_ON_CLOSE", 0x04000000)
FILE_FLAG_BACKUP_SEMANTICS = make_flag("FILE_FLAG_BACKUP_SEMANTICS", 0x02000000)
FILE_FLAG_POSIX_SEMANTICS = make_flag("FILE_FLAG_POSIX_SEMANTICS", 0x01000000)
FILE_FLAG_OPEN_REPARSE_POINT = make_flag("FILE_FLAG_OPEN_REPARSE_POINT", 0x00200000)
FILE_FLAG_OPEN_NO_RECALL = make_flag("FILE_FLAG_OPEN_NO_RECALL", 0x00100000)
FILE_FLAG_FIRST_PIPE_INSTANCE = make_flag("FILE_FLAG_FIRST_PIPE_INSTANCE", 0x00080000)
CREATE_NEW = make_flag("CREATE_NEW", 1)
CREATE_ALWAYS = make_flag("CREATE_ALWAYS", 2)
OPEN_EXISTING = make_flag("OPEN_EXISTING", 3)
OPEN_ALWAYS = make_flag("OPEN_ALWAYS", 4)
TRUNCATE_EXISTING = make_flag("TRUNCATE_EXISTING", 5)
FILE_SHARE_READ = make_flag("FILE_SHARE_READ", 0x00000001)
FILE_SHARE_WRITE = make_flag("FILE_SHARE_WRITE", 0x00000002)
FILE_SHARE_DELETE = make_flag("FILE_SHARE_DELETE", 0x00000004)
FILE_ATTRIBUTE_READONLY = make_flag("FILE_ATTRIBUTE_READONLY", 0x00000001)
FILE_ATTRIBUTE_HIDDEN = make_flag("FILE_ATTRIBUTE_HIDDEN", 0x00000002)
FILE_ATTRIBUTE_SYSTEM = make_flag("FILE_ATTRIBUTE_SYSTEM", 0x00000004)
FILE_ATTRIBUTE_DIRECTORY = make_flag("FILE_ATTRIBUTE_DIRECTORY", 0x00000010)
FILE_ATTRIBUTE_ARCHIVE = make_flag("FILE_ATTRIBUTE_ARCHIVE", 0x00000020)
FILE_ATTRIBUTE_DEVICE = make_flag("FILE_ATTRIBUTE_DEVICE", 0x00000040)
FILE_ATTRIBUTE_NORMAL = make_flag("FILE_ATTRIBUTE_NORMAL", 0x00000080)
FILE_ATTRIBUTE_TEMPORARY = make_flag("FILE_ATTRIBUTE_TEMPORARY", 0x00000100)
FILE_ATTRIBUTE_SPARSE_FILE = make_flag("FILE_ATTRIBUTE_SPARSE_FILE", 0x00000200)
FILE_ATTRIBUTE_REPARSE_POINT = make_flag("FILE_ATTRIBUTE_REPARSE_POINT", 0x00000400)
FILE_ATTRIBUTE_COMPRESSED = make_flag("FILE_ATTRIBUTE_COMPRESSED", 0x00000800)
FILE_ATTRIBUTE_OFFLINE = make_flag("FILE_ATTRIBUTE_OFFLINE", 0x00001000)
FILE_ATTRIBUTE_NOT_CONTENT_INDEXED = make_flag("FILE_ATTRIBUTE_NOT_CONTENT_INDEXED", 0x00002000)
FILE_ATTRIBUTE_ENCRYPTED = make_flag("FILE_ATTRIBUTE_ENCRYPTED", 0x00004000)
FILE_ATTRIBUTE_VIRTUAL = make_flag("FILE_ATTRIBUTE_VIRTUAL", 0x00010000)
FILE_NOTIFY_CHANGE_FILE_NAME = make_flag("FILE_NOTIFY_CHANGE_FILE_NAME", 0x00000001)
FILE_NOTIFY_CHANGE_DIR_NAME = make_flag("FILE_NOTIFY_CHANGE_DIR_NAME", 0x00000002)
FILE_NOTIFY_CHANGE_ATTRIBUTES = make_flag("FILE_NOTIFY_CHANGE_ATTRIBUTES", 0x00000004)
FILE_NOTIFY_CHANGE_SIZE = make_flag("FILE_NOTIFY_CHANGE_SIZE", 0x00000008)
FILE_NOTIFY_CHANGE_LAST_WRITE = make_flag("FILE_NOTIFY_CHANGE_LAST_WRITE", 0x00000010)
FILE_NOTIFY_CHANGE_LAST_ACCESS = make_flag("FILE_NOTIFY_CHANGE_LAST_ACCESS", 0x00000020)
FILE_NOTIFY_CHANGE_CREATION = make_flag("FILE_NOTIFY_CHANGE_CREATION", 0x00000040)
FILE_NOTIFY_CHANGE_SECURITY = make_flag("FILE_NOTIFY_CHANGE_SECURITY", 0x00000100)
FILE_ACTION_ADDED = make_flag("FILE_ACTION_ADDED", 0x00000001)
FILE_ACTION_REMOVED = make_flag("FILE_ACTION_REMOVED", 0x00000002)
FILE_ACTION_MODIFIED = make_flag("FILE_ACTION_MODIFIED", 0x00000003)
FILE_ACTION_RENAMED_OLD_NAME = make_flag("FILE_ACTION_RENAMED_OLD_NAME", 0x00000004)
FILE_ACTION_RENAMED_NEW_NAME = make_flag("FILE_ACTION_RENAMED_NEW_NAME", 0x00000005)
MAILSLOT_NO_MESSAGE = make_flag("MAILSLOT_NO_MESSAGE", ( -1 ))
MAILSLOT_WAIT_FOREVER = make_flag("MAILSLOT_WAIT_FOREVER", ( -1 ))
FILE_CASE_SENSITIVE_SEARCH = make_flag("FILE_CASE_SENSITIVE_SEARCH", 0x00000001)
FILE_CASE_PRESERVED_NAMES = make_flag("FILE_CASE_PRESERVED_NAMES", 0x00000002)
FILE_UNICODE_ON_DISK = make_flag("FILE_UNICODE_ON_DISK", 0x00000004)
FILE_PERSISTENT_ACLS = make_flag("FILE_PERSISTENT_ACLS", 0x00000008)
FILE_FILE_COMPRESSION = make_flag("FILE_FILE_COMPRESSION", 0x00000010)
FILE_VOLUME_QUOTAS = make_flag("FILE_VOLUME_QUOTAS", 0x00000020)
FILE_SUPPORTS_SPARSE_FILES = make_flag("FILE_SUPPORTS_SPARSE_FILES", 0x00000040)
FILE_SUPPORTS_REPARSE_POINTS = make_flag("FILE_SUPPORTS_REPARSE_POINTS", 0x00000080)
FILE_SUPPORTS_REMOTE_STORAGE = make_flag("FILE_SUPPORTS_REMOTE_STORAGE", 0x00000100)
FILE_VOLUME_IS_COMPRESSED = make_flag("FILE_VOLUME_IS_COMPRESSED", 0x00008000)
FILE_SUPPORTS_OBJECT_IDS = make_flag("FILE_SUPPORTS_OBJECT_IDS", 0x00010000)
FILE_SUPPORTS_ENCRYPTION = make_flag("FILE_SUPPORTS_ENCRYPTION", 0x00020000)
FILE_NAMED_STREAMS = make_flag("FILE_NAMED_STREAMS", 0x00040000)
FILE_READ_ONLY_VOLUME = make_flag("FILE_READ_ONLY_VOLUME", 0x00080000)
FILE_SEQUENTIAL_WRITE_ONCE = make_flag("FILE_SEQUENTIAL_WRITE_ONCE", 0x00100000)
FILE_SUPPORTS_TRANSACTIONS = make_flag("FILE_SUPPORTS_TRANSACTIONS", 0x00200000)
FILE_SUPPORTS_HARD_LINKS = make_flag("FILE_SUPPORTS_HARD_LINKS", 0x00400000)
FILE_SUPPORTS_EXTENDED_ATTRIBUTES = make_flag("FILE_SUPPORTS_EXTENDED_ATTRIBUTES", 0x00800000)
FILE_SUPPORTS_OPEN_BY_FILE_ID = make_flag("FILE_SUPPORTS_OPEN_BY_FILE_ID", 0x01000000)
FILE_SUPPORTS_USN_JOURNAL = make_flag("FILE_SUPPORTS_USN_JOURNAL", 0x02000000)
RRF_RT_REG_NONE = make_flag("RRF_RT_REG_NONE", 0x00000001)
RRF_RT_REG_SZ = make_flag("RRF_RT_REG_SZ", 0x00000002)
RRF_RT_REG_EXPAND_SZ = make_flag("RRF_RT_REG_EXPAND_SZ", 0x00000004)
RRF_RT_REG_BINARY = make_flag("RRF_RT_REG_BINARY", 0x00000008)
RRF_RT_REG_DWORD = make_flag("RRF_RT_REG_DWORD", 0x00000010)
RRF_RT_REG_MULTI_SZ = make_flag("RRF_RT_REG_MULTI_SZ", 0x00000020)
RRF_RT_REG_QWORD = make_flag("RRF_RT_REG_QWORD", 0x00000040)
RRF_RT_DWORD = make_flag("RRF_RT_DWORD", ( RRF_RT_REG_BINARY | RRF_RT_REG_DWORD ))
RRF_RT_QWORD = make_flag("RRF_RT_QWORD", ( RRF_RT_REG_BINARY | RRF_RT_REG_QWORD ))
RRF_RT_ANY = make_flag("RRF_RT_ANY", 0x0000ffff)
RRF_NOEXPAND = make_flag("RRF_NOEXPAND", 0x10000000)
RRF_ZEROONFAILURE = make_flag("RRF_ZEROONFAILURE", 0x20000000)
DEBUG_EVENT_BREAKPOINT = make_flag("DEBUG_EVENT_BREAKPOINT", 0x00000001)
DEBUG_EVENT_EXCEPTION = make_flag("DEBUG_EVENT_EXCEPTION", 0x00000002)
DEBUG_EVENT_CREATE_THREAD = make_flag("DEBUG_EVENT_CREATE_THREAD", 0x00000004)
DEBUG_EVENT_EXIT_THREAD = make_flag("DEBUG_EVENT_EXIT_THREAD", 0x00000008)
DEBUG_EVENT_CREATE_PROCESS = make_flag("DEBUG_EVENT_CREATE_PROCESS", 0x00000010)
DEBUG_EVENT_EXIT_PROCESS = make_flag("DEBUG_EVENT_EXIT_PROCESS", 0x00000020)
DEBUG_EVENT_LOAD_MODULE = make_flag("DEBUG_EVENT_LOAD_MODULE", 0x00000040)
DEBUG_EVENT_UNLOAD_MODULE = make_flag("DEBUG_EVENT_UNLOAD_MODULE", 0x00000080)
DEBUG_EVENT_SYSTEM_ERROR = make_flag("DEBUG_EVENT_SYSTEM_ERROR", 0x00000100)
DEBUG_EVENT_SESSION_STATUS = make_flag("DEBUG_EVENT_SESSION_STATUS", 0x00000200)
DEBUG_EVENT_CHANGE_DEBUGGEE_STATE = make_flag("DEBUG_EVENT_CHANGE_DEBUGGEE_STATE", 0x00000400)
DEBUG_EVENT_CHANGE_ENGINE_STATE = make_flag("DEBUG_EVENT_CHANGE_ENGINE_STATE", 0x00000800)
DEBUG_EVENT_CHANGE_SYMBOL_STATE = make_flag("DEBUG_EVENT_CHANGE_SYMBOL_STATE", 0x00001000)
WOW64_MAXIMUM_SUPPORTED_EXTENSION = make_flag("WOW64_MAXIMUM_SUPPORTED_EXTENSION", 512)
WOW64_SIZE_OF_80387_REGISTERS = make_flag("WOW64_SIZE_OF_80387_REGISTERS", 80)
REG_NONE = make_flag("REG_NONE", ( 0 ))
REG_SZ = make_flag("REG_SZ", ( 1 ))
REG_EXPAND_SZ = make_flag("REG_EXPAND_SZ", ( 2 ))
REG_BINARY = make_flag("REG_BINARY", ( 3 ))
REG_DWORD = make_flag("REG_DWORD", ( 4 ))
REG_DWORD_LITTLE_ENDIAN = make_flag("REG_DWORD_LITTLE_ENDIAN", ( 4 ))
REG_DWORD_BIG_ENDIAN = make_flag("REG_DWORD_BIG_ENDIAN", ( 5 ))
REG_LINK = make_flag("REG_LINK", ( 6 ))
REG_MULTI_SZ = make_flag("REG_MULTI_SZ", ( 7 ))
REG_RESOURCE_LIST = make_flag("REG_RESOURCE_LIST", ( 8 ))
REG_FULL_RESOURCE_DESCRIPTOR = make_flag("REG_FULL_RESOURCE_DESCRIPTOR", ( 9 ))
REG_RESOURCE_REQUIREMENTS_LIST = make_flag("REG_RESOURCE_REQUIREMENTS_LIST", ( 10 ))
REG_QWORD = make_flag("REG_QWORD", ( 11 ))
REG_QWORD_LITTLE_ENDIAN = make_flag("REG_QWORD_LITTLE_ENDIAN", ( 11 ))
IMAGE_FILE_RELOCS_STRIPPED = make_flag("IMAGE_FILE_RELOCS_STRIPPED", 0x0001)
IMAGE_FILE_EXECUTABLE_IMAGE = make_flag("IMAGE_FILE_EXECUTABLE_IMAGE", 0x0002)
IMAGE_FILE_LINE_NUMS_STRIPPED = make_flag("IMAGE_FILE_LINE_NUMS_STRIPPED", 0x0004)
IMAGE_FILE_LOCAL_SYMS_STRIPPED = make_flag("IMAGE_FILE_LOCAL_SYMS_STRIPPED", 0x0008)
IMAGE_FILE_AGGRESIVE_WS_TRIM = make_flag("IMAGE_FILE_AGGRESIVE_WS_TRIM", 0x0010)
IMAGE_FILE_LARGE_ADDRESS_AWARE = make_flag("IMAGE_FILE_LARGE_ADDRESS_AWARE", 0x0020)
IMAGE_FILE_BYTES_REVERSED_LO = make_flag("IMAGE_FILE_BYTES_REVERSED_LO", 0x0080)
IMAGE_FILE_32BIT_MACHINE = make_flag("IMAGE_FILE_32BIT_MACHINE", 0x0100)
IMAGE_FILE_DEBUG_STRIPPED = make_flag("IMAGE_FILE_DEBUG_STRIPPED", 0x0200)
IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP = make_flag("IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP", 0x0400)
IMAGE_FILE_NET_RUN_FROM_SWAP = make_flag("IMAGE_FILE_NET_RUN_FROM_SWAP", 0x0800)
IMAGE_FILE_SYSTEM = make_flag("IMAGE_FILE_SYSTEM", 0x1000)
IMAGE_FILE_DLL = make_flag("IMAGE_FILE_DLL", 0x2000)
IMAGE_FILE_UP_SYSTEM_ONLY = make_flag("IMAGE_FILE_UP_SYSTEM_ONLY", 0x4000)
IMAGE_FILE_BYTES_REVERSED_HI = make_flag("IMAGE_FILE_BYTES_REVERSED_HI", 0x8000)
IMAGE_FILE_MACHINE_UNKNOWN = make_flag("IMAGE_FILE_MACHINE_UNKNOWN", 0)
IMAGE_FILE_MACHINE_I386 = make_flag("IMAGE_FILE_MACHINE_I386", 0x014c)
IMAGE_FILE_MACHINE_R3000 = make_flag("IMAGE_FILE_MACHINE_R3000", 0x0162)
IMAGE_FILE_MACHINE_R4000 = make_flag("IMAGE_FILE_MACHINE_R4000", 0x0166)
IMAGE_FILE_MACHINE_R10000 = make_flag("IMAGE_FILE_MACHINE_R10000", 0x0168)
IMAGE_FILE_MACHINE_WCEMIPSV2 = make_flag("IMAGE_FILE_MACHINE_WCEMIPSV2", 0x0169)
IMAGE_FILE_MACHINE_ALPHA = make_flag("IMAGE_FILE_MACHINE_ALPHA", 0x0184)
IMAGE_FILE_MACHINE_SH3 = make_flag("IMAGE_FILE_MACHINE_SH3", 0x01a2)
IMAGE_FILE_MACHINE_SH3DSP = make_flag("IMAGE_FILE_MACHINE_SH3DSP", 0x01a3)
IMAGE_FILE_MACHINE_SH3E = make_flag("IMAGE_FILE_MACHINE_SH3E", 0x01a4)
IMAGE_FILE_MACHINE_SH4 = make_flag("IMAGE_FILE_MACHINE_SH4", 0x01a6)
IMAGE_FILE_MACHINE_SH5 = make_flag("IMAGE_FILE_MACHINE_SH5", 0x01a8)
IMAGE_FILE_MACHINE_ARM = make_flag("IMAGE_FILE_MACHINE_ARM", 0x01c0)
IMAGE_FILE_MACHINE_THUMB = make_flag("IMAGE_FILE_MACHINE_THUMB", 0x01c2)
IMAGE_FILE_MACHINE_ARMNT = make_flag("IMAGE_FILE_MACHINE_ARMNT", 0x01c4)
IMAGE_FILE_MACHINE_AM33 = make_flag("IMAGE_FILE_MACHINE_AM33", 0x01d3)
IMAGE_FILE_MACHINE_POWERPC = make_flag("IMAGE_FILE_MACHINE_POWERPC", 0x01F0)
IMAGE_FILE_MACHINE_POWERPCFP = make_flag("IMAGE_FILE_MACHINE_POWERPCFP", 0x01f1)
IMAGE_FILE_MACHINE_IA64 = make_flag("IMAGE_FILE_MACHINE_IA64", 0x0200)
IMAGE_FILE_MACHINE_MIPS16 = make_flag("IMAGE_FILE_MACHINE_MIPS16", 0x0266)
IMAGE_FILE_MACHINE_ALPHA64 = make_flag("IMAGE_FILE_MACHINE_ALPHA64", 0x0284)
IMAGE_FILE_MACHINE_MIPSFPU = make_flag("IMAGE_FILE_MACHINE_MIPSFPU", 0x0366)
IMAGE_FILE_MACHINE_MIPSFPU16 = make_flag("IMAGE_FILE_MACHINE_MIPSFPU16", 0x0466)
IMAGE_FILE_MACHINE_AXP64 = make_flag("IMAGE_FILE_MACHINE_AXP64", IMAGE_FILE_MACHINE_ALPHA64)
IMAGE_FILE_MACHINE_TRICORE = make_flag("IMAGE_FILE_MACHINE_TRICORE", 0x0520)
IMAGE_FILE_MACHINE_CEF = make_flag("IMAGE_FILE_MACHINE_CEF", 0x0CEF)
IMAGE_FILE_MACHINE_EBC = make_flag("IMAGE_FILE_MACHINE_EBC", 0x0EBC)
IMAGE_FILE_MACHINE_AMD64 = make_flag("IMAGE_FILE_MACHINE_AMD64", 0x8664)
IMAGE_FILE_MACHINE_M32R = make_flag("IMAGE_FILE_MACHINE_M32R", 0x9041)
IMAGE_FILE_MACHINE_CEE = make_flag("IMAGE_FILE_MACHINE_CEE", 0xC0EE)
SECURITY_MANDATORY_UNTRUSTED_RID = make_flag("SECURITY_MANDATORY_UNTRUSTED_RID", ( 0x00000000 ))
SECURITY_MANDATORY_LOW_RID = make_flag("SECURITY_MANDATORY_LOW_RID", ( 0x00001000 ))
SECURITY_MANDATORY_MEDIUM_RID = make_flag("SECURITY_MANDATORY_MEDIUM_RID", ( 0x00002000 ))
SECURITY_MANDATORY_MEDIUM_PLUS_RID = make_flag("SECURITY_MANDATORY_MEDIUM_PLUS_RID", ( SECURITY_MANDATORY_MEDIUM_RID + 0x100 ))
SECURITY_MANDATORY_HIGH_RID = make_flag("SECURITY_MANDATORY_HIGH_RID", ( 0x00003000 ))
SECURITY_MANDATORY_SYSTEM_RID = make_flag("SECURITY_MANDATORY_SYSTEM_RID", ( 0x00004000 ))
SECURITY_MANDATORY_PROTECTED_PROCESS_RID = make_flag("SECURITY_MANDATORY_PROTECTED_PROCESS_RID", ( 0x00005000 ))
DRIVE_UNKNOWN = make_flag("DRIVE_UNKNOWN", 0)
DRIVE_NO_ROOT_DIR = make_flag("DRIVE_NO_ROOT_DIR", 1)
DRIVE_REMOVABLE = make_flag("DRIVE_REMOVABLE", 2)
DRIVE_FIXED = make_flag("DRIVE_FIXED", 3)
DRIVE_REMOTE = make_flag("DRIVE_REMOTE", 4)
DRIVE_CDROM = make_flag("DRIVE_CDROM", 5)
DRIVE_RAMDISK = make_flag("DRIVE_RAMDISK", 6)
DUPLICATE_CLOSE_SOURCE = make_flag("DUPLICATE_CLOSE_SOURCE", 0x00000001)
DUPLICATE_SAME_ACCESS = make_flag("DUPLICATE_SAME_ACCESS", 0x00000002)
VER_NT_WORKSTATION = make_flag("VER_NT_WORKSTATION", 0x0000001)
VER_NT_DOMAIN_CONTROLLER = make_flag("VER_NT_DOMAIN_CONTROLLER", 0x0000002)
VER_NT_SERVER = make_flag("VER_NT_SERVER", 0x0000003)
SM_CXSCREEN = make_flag("SM_CXSCREEN", 0)
SM_CYSCREEN = make_flag("SM_CYSCREEN", 1)
SM_CXVSCROLL = make_flag("SM_CXVSCROLL", 2)
SM_CYHSCROLL = make_flag("SM_CYHSCROLL", 3)
SM_CYCAPTION = make_flag("SM_CYCAPTION", 4)
SM_CXBORDER = make_flag("SM_CXBORDER", 5)
SM_CYBORDER = make_flag("SM_CYBORDER", 6)
SM_CXDLGFRAME = make_flag("SM_CXDLGFRAME", 7)
SM_CYDLGFRAME = make_flag("SM_CYDLGFRAME", 8)
SM_CYVTHUMB = make_flag("SM_CYVTHUMB", 9)
SM_CXHTHUMB = make_flag("SM_CXHTHUMB", 10)
SM_CXICON = make_flag("SM_CXICON", 11)
SM_CYICON = make_flag("SM_CYICON", 12)
SM_CXCURSOR = make_flag("SM_CXCURSOR", 13)
SM_CYCURSOR = make_flag("SM_CYCURSOR", 14)
SM_CYMENU = make_flag("SM_CYMENU", 15)
SM_CXFULLSCREEN = make_flag("SM_CXFULLSCREEN", 16)
SM_CYFULLSCREEN = make_flag("SM_CYFULLSCREEN", 17)
SM_CYKANJIWINDOW = make_flag("SM_CYKANJIWINDOW", 18)
SM_MOUSEPRESENT = make_flag("SM_MOUSEPRESENT", 19)
SM_CYVSCROLL = make_flag("SM_CYVSCROLL", 20)
SM_CXHSCROLL = make_flag("SM_CXHSCROLL", 21)
SM_DEBUG = make_flag("SM_DEBUG", 22)
SM_SWAPBUTTON = make_flag("SM_SWAPBUTTON", 23)
SM_RESERVED1 = make_flag("SM_RESERVED1", 24)
SM_RESERVED2 = make_flag("SM_RESERVED2", 25)
SM_RESERVED3 = make_flag("SM_RESERVED3", 26)
SM_RESERVED4 = make_flag("SM_RESERVED4", 27)
SM_CXMIN = make_flag("SM_CXMIN", 28)
SM_CYMIN = make_flag("SM_CYMIN", 29)
SM_CXSIZE = make_flag("SM_CXSIZE", 30)
SM_CYSIZE = make_flag("SM_CYSIZE", 31)
SM_CXFRAME = make_flag("SM_CXFRAME", 32)
SM_CYFRAME = make_flag("SM_CYFRAME", 33)
SM_CXMINTRACK = make_flag("SM_CXMINTRACK", 34)
SM_CYMINTRACK = make_flag("SM_CYMINTRACK", 35)
SM_CXDOUBLECLK = make_flag("SM_CXDOUBLECLK", 36)
SM_CYDOUBLECLK = make_flag("SM_CYDOUBLECLK", 37)
SM_CXICONSPACING = make_flag("SM_CXICONSPACING", 38)
SM_CYICONSPACING = make_flag("SM_CYICONSPACING", 39)
SM_MENUDROPALIGNMENT = make_flag("SM_MENUDROPALIGNMENT", 40)
SM_PENWINDOWS = make_flag("SM_PENWINDOWS", 41)
SM_DBCSENABLED = make_flag("SM_DBCSENABLED", 42)
SM_CMOUSEBUTTONS = make_flag("SM_CMOUSEBUTTONS", 43)
SM_CXFIXEDFRAME = make_flag("SM_CXFIXEDFRAME", SM_CXDLGFRAME)
SM_CYFIXEDFRAME = make_flag("SM_CYFIXEDFRAME", SM_CYDLGFRAME)
SM_CXSIZEFRAME = make_flag("SM_CXSIZEFRAME", SM_CXFRAME)
SM_CYSIZEFRAME = make_flag("SM_CYSIZEFRAME", SM_CYFRAME)
SM_SECURE = make_flag("SM_SECURE", 44)
SM_CXEDGE = make_flag("SM_CXEDGE", 45)
SM_CYEDGE = make_flag("SM_CYEDGE", 46)
SM_CXMINSPACING = make_flag("SM_CXMINSPACING", 47)
SM_CYMINSPACING = make_flag("SM_CYMINSPACING", 48)
SM_CXSMICON = make_flag("SM_CXSMICON", 49)
SM_CYSMICON = make_flag("SM_CYSMICON", 50)
SM_CYSMCAPTION = make_flag("SM_CYSMCAPTION", 51)
SM_CXSMSIZE = make_flag("SM_CXSMSIZE", 52)
SM_CYSMSIZE = make_flag("SM_CYSMSIZE", 53)
SM_CXMENUSIZE = make_flag("SM_CXMENUSIZE", 54)
SM_CYMENUSIZE = make_flag("SM_CYMENUSIZE", 55)
SM_ARRANGE = make_flag("SM_ARRANGE", 56)
SM_CXMINIMIZED = make_flag("SM_CXMINIMIZED", 57)
SM_CYMINIMIZED = make_flag("SM_CYMINIMIZED", 58)
SM_CXMAXTRACK = make_flag("SM_CXMAXTRACK", 59)
SM_CYMAXTRACK = make_flag("SM_CYMAXTRACK", 60)
SM_CXMAXIMIZED = make_flag("SM_CXMAXIMIZED", 61)
SM_CYMAXIMIZED = make_flag("SM_CYMAXIMIZED", 62)
SM_NETWORK = make_flag("SM_NETWORK", 63)
SM_CLEANBOOT = make_flag("SM_CLEANBOOT", 67)
SM_CXDRAG = make_flag("SM_CXDRAG", 68)
SM_CYDRAG = make_flag("SM_CYDRAG", 69)
SM_SHOWSOUNDS = make_flag("SM_SHOWSOUNDS", 70)
SM_CXMENUCHECK = make_flag("SM_CXMENUCHECK", 71)
SM_CYMENUCHECK = make_flag("SM_CYMENUCHECK", 72)
SM_SLOWMACHINE = make_flag("SM_SLOWMACHINE", 73)
SM_MIDEASTENABLED = make_flag("SM_MIDEASTENABLED", 74)
SM_MOUSEWHEELPRESENT = make_flag("SM_MOUSEWHEELPRESENT", 75)
SM_XVIRTUALSCREEN = make_flag("SM_XVIRTUALSCREEN", 76)
SM_YVIRTUALSCREEN = make_flag("SM_YVIRTUALSCREEN", 77)
SM_CXVIRTUALSCREEN = make_flag("SM_CXVIRTUALSCREEN", 78)
SM_CYVIRTUALSCREEN = make_flag("SM_CYVIRTUALSCREEN", 79)
SM_CMONITORS = make_flag("SM_CMONITORS", 80)
SM_SAMEDISPLAYFORMAT = make_flag("SM_SAMEDISPLAYFORMAT", 81)
SM_IMMENABLED = make_flag("SM_IMMENABLED", 82)
SM_CXFOCUSBORDER = make_flag("SM_CXFOCUSBORDER", 83)
SM_CYFOCUSBORDER = make_flag("SM_CYFOCUSBORDER", 84)
SM_TABLETPC = make_flag("SM_TABLETPC", 86)
SM_MEDIACENTER = make_flag("SM_MEDIACENTER", 87)
SM_STARTER = make_flag("SM_STARTER", 88)
SM_SERVERR2 = make_flag("SM_SERVERR2", 89)
SM_MOUSEHORIZONTALWHEELPRESENT = make_flag("SM_MOUSEHORIZONTALWHEELPRESENT", 91)
SM_CXPADDEDBORDER = make_flag("SM_CXPADDEDBORDER", 92)
SM_DIGITIZER = make_flag("SM_DIGITIZER", 94)
SM_MAXIMUMTOUCHES = make_flag("SM_MAXIMUMTOUCHES", 95)
SM_REMOTESESSION = make_flag("SM_REMOTESESSION", 0x1000)
SM_SHUTTINGDOWN = make_flag("SM_SHUTTINGDOWN", 0x2000)
SM_REMOTECONTROL = make_flag("SM_REMOTECONTROL", 0x2001)
SM_CARETBLINKINGENABLED = make_flag("SM_CARETBLINKINGENABLED", 0x2002)
RPC_C_AUTHN_LEVEL_DEFAULT = make_flag("RPC_C_AUTHN_LEVEL_DEFAULT", 0)
RPC_C_AUTHN_LEVEL_NONE = make_flag("RPC_C_AUTHN_LEVEL_NONE", 1)
RPC_C_AUTHN_LEVEL_CONNECT = make_flag("RPC_C_AUTHN_LEVEL_CONNECT", 2)
RPC_C_AUTHN_LEVEL_CALL = make_flag("RPC_C_AUTHN_LEVEL_CALL", 3)
RPC_C_AUTHN_LEVEL_PKT = make_flag("RPC_C_AUTHN_LEVEL_PKT", 4)
RPC_C_AUTHN_LEVEL_PKT_INTEGRITY = make_flag("RPC_C_AUTHN_LEVEL_PKT_INTEGRITY", 5)
RPC_C_AUTHN_LEVEL_PKT_PRIVACY = make_flag("RPC_C_AUTHN_LEVEL_PKT_PRIVACY", 6)
RPC_C_IMP_LEVEL_DEFAULT = make_flag("RPC_C_IMP_LEVEL_DEFAULT", 0)
RPC_C_IMP_LEVEL_ANONYMOUS = make_flag("RPC_C_IMP_LEVEL_ANONYMOUS", 1)
RPC_C_IMP_LEVEL_IDENTIFY = make_flag("RPC_C_IMP_LEVEL_IDENTIFY", 2)
RPC_C_IMP_LEVEL_IMPERSONATE = make_flag("RPC_C_IMP_LEVEL_IMPERSONATE", 3)
RPC_C_IMP_LEVEL_DELEGATE = make_flag("RPC_C_IMP_LEVEL_DELEGATE", 4)
RPC_C_QOS_IDENTITY_STATIC = make_flag("RPC_C_QOS_IDENTITY_STATIC", 0)
RPC_C_QOS_IDENTITY_DYNAMIC = make_flag("RPC_C_QOS_IDENTITY_DYNAMIC", 1)
RPC_C_QOS_CAPABILITIES_DEFAULT = make_flag("RPC_C_QOS_CAPABILITIES_DEFAULT", 0x0)
RPC_C_QOS_CAPABILITIES_MUTUAL_AUTH = make_flag("RPC_C_QOS_CAPABILITIES_MUTUAL_AUTH", 0x1)
RPC_C_QOS_CAPABILITIES_MAKE_FULLSIC = make_flag("RPC_C_QOS_CAPABILITIES_MAKE_FULLSIC", 0x2)
RPC_C_QOS_CAPABILITIES_ANY_AUTHORITY = make_flag("RPC_C_QOS_CAPABILITIES_ANY_AUTHORITY", 0x4)
MAX_ADAPTER_NAME = make_flag("MAX_ADAPTER_NAME", 128)
MAXLEN_PHYSADDR = make_flag("MAXLEN_PHYSADDR", 8)
MAXLEN_IFDESCR = make_flag("MAXLEN_IFDESCR", 256)
MAX_INTERFACE_NAME_LEN = make_flag("MAX_INTERFACE_NAME_LEN", 256)
OBJ_INHERIT = make_flag("OBJ_INHERIT", 0x00000002)
OBJ_PERMANENT = make_flag("OBJ_PERMANENT", 0x00000010)
OBJ_EXCLUSIVE = make_flag("OBJ_EXCLUSIVE", 0x00000020)
OBJ_CASE_INSENSITIVE = make_flag("OBJ_CASE_INSENSITIVE", 0x00000040)
OBJ_OPENIF = make_flag("OBJ_OPENIF", 0x00000080)
OBJ_OPENLINK = make_flag("OBJ_OPENLINK", 0x00000100)
OBJ_KERNEL_HANDLE = make_flag("OBJ_KERNEL_HANDLE", 0x00000200)
OBJ_FORCE_ACCESS_CHECK = make_flag("OBJ_FORCE_ACCESS_CHECK", 0x00000400)
OBJ_VALID_ATTRIBUTES = make_flag("OBJ_VALID_ATTRIBUTES", 0x000007F2)
FILE_SUPERSEDE = make_flag("FILE_SUPERSEDE", 0x00000000)
FILE_OPEN = make_flag("FILE_OPEN", 0x00000001)
FILE_CREATE = make_flag("FILE_CREATE", 0x00000002)
FILE_OPEN_IF = make_flag("FILE_OPEN_IF", 0x00000003)
FILE_OVERWRITE = make_flag("FILE_OVERWRITE", 0x00000004)
FILE_OVERWRITE_IF = make_flag("FILE_OVERWRITE_IF", 0x00000005)
FILE_MAXIMUM_DISPOSITION = make_flag("FILE_MAXIMUM_DISPOSITION", 0x00000005)
IMAGE_SCN_TYPE_REG = make_flag("IMAGE_SCN_TYPE_REG", 0x00000000)
IMAGE_SCN_TYPE_DSECT = make_flag("IMAGE_SCN_TYPE_DSECT", 0x00000001)
IMAGE_SCN_TYPE_NOLOAD = make_flag("IMAGE_SCN_TYPE_NOLOAD", 0x00000002)
IMAGE_SCN_TYPE_GROUP = make_flag("IMAGE_SCN_TYPE_GROUP", 0x00000004)
IMAGE_SCN_TYPE_NO_PAD = make_flag("IMAGE_SCN_TYPE_NO_PAD", 0x00000008)
IMAGE_SCN_TYPE_COPY = make_flag("IMAGE_SCN_TYPE_COPY", 0x00000010)
IMAGE_SCN_CNT_CODE = make_flag("IMAGE_SCN_CNT_CODE", 0x00000020)
IMAGE_SCN_CNT_INITIALIZED_DATA = make_flag("IMAGE_SCN_CNT_INITIALIZED_DATA", 0x00000040)
IMAGE_SCN_CNT_UNINITIALIZED_DATA = make_flag("IMAGE_SCN_CNT_UNINITIALIZED_DATA", 0x00000080)
IMAGE_SCN_LNK_OTHER = make_flag("IMAGE_SCN_LNK_OTHER", 0x00000100)
IMAGE_SCN_LNK_INFO = make_flag("IMAGE_SCN_LNK_INFO", 0x00000200)
IMAGE_SCN_TYPE_OVER = make_flag("IMAGE_SCN_TYPE_OVER", 0x00000400)
IMAGE_SCN_LNK_REMOVE = make_flag("IMAGE_SCN_LNK_REMOVE", 0x00000800)
IMAGE_SCN_LNK_COMDAT = make_flag("IMAGE_SCN_LNK_COMDAT", 0x00001000)
IMAGE_SCN_NO_DEFER_SPEC_EXC = make_flag("IMAGE_SCN_NO_DEFER_SPEC_EXC", 0x00004000)
IMAGE_SCN_GPREL = make_flag("IMAGE_SCN_GPREL", 0x00008000)
IMAGE_SCN_MEM_FARDATA = make_flag("IMAGE_SCN_MEM_FARDATA", 0x00008000)
IMAGE_SCN_MEM_PURGEABLE = make_flag("IMAGE_SCN_MEM_PURGEABLE", 0x00020000)
IMAGE_SCN_MEM_16BIT = make_flag("IMAGE_SCN_MEM_16BIT", 0x00020000)
IMAGE_SCN_MEM_LOCKED = make_flag("IMAGE_SCN_MEM_LOCKED", 0x00040000)
IMAGE_SCN_MEM_PRELOAD = make_flag("IMAGE_SCN_MEM_PRELOAD", 0x00080000)
IMAGE_SCN_ALIGN_1BYTES = make_flag("IMAGE_SCN_ALIGN_1BYTES", 0x00100000)
IMAGE_SCN_ALIGN_2BYTES = make_flag("IMAGE_SCN_ALIGN_2BYTES", 0x00200000)
IMAGE_SCN_ALIGN_4BYTES = make_flag("IMAGE_SCN_ALIGN_4BYTES", 0x00300000)
IMAGE_SCN_ALIGN_8BYTES = make_flag("IMAGE_SCN_ALIGN_8BYTES", 0x00400000)
IMAGE_SCN_ALIGN_16BYTES = make_flag("IMAGE_SCN_ALIGN_16BYTES", 0x00500000)
IMAGE_SCN_ALIGN_32BYTES = make_flag("IMAGE_SCN_ALIGN_32BYTES", 0x00600000)
IMAGE_SCN_ALIGN_64BYTES = make_flag("IMAGE_SCN_ALIGN_64BYTES", 0x00700000)
IMAGE_SCN_ALIGN_128BYTES = make_flag("IMAGE_SCN_ALIGN_128BYTES", 0x00800000)
IMAGE_SCN_ALIGN_256BYTES = make_flag("IMAGE_SCN_ALIGN_256BYTES", 0x00900000)
IMAGE_SCN_ALIGN_512BYTES = make_flag("IMAGE_SCN_ALIGN_512BYTES", 0x00A00000)
IMAGE_SCN_ALIGN_1024BYTES = make_flag("IMAGE_SCN_ALIGN_1024BYTES", 0x00B00000)
IMAGE_SCN_ALIGN_2048BYTES = make_flag("IMAGE_SCN_ALIGN_2048BYTES", 0x00C00000)
IMAGE_SCN_ALIGN_4096BYTES = make_flag("IMAGE_SCN_ALIGN_4096BYTES", 0x00D00000)
IMAGE_SCN_ALIGN_8192BYTES = make_flag("IMAGE_SCN_ALIGN_8192BYTES", 0x00E00000)
IMAGE_SCN_ALIGN_MASK = make_flag("IMAGE_SCN_ALIGN_MASK", 0x00F00000)
IMAGE_SCN_LNK_NRELOC_OVFL = make_flag("IMAGE_SCN_LNK_NRELOC_OVFL", 0x01000000)
IMAGE_SCN_MEM_DISCARDABLE = make_flag("IMAGE_SCN_MEM_DISCARDABLE", 0x02000000)
IMAGE_SCN_MEM_NOT_CACHED = make_flag("IMAGE_SCN_MEM_NOT_CACHED", 0x04000000)
IMAGE_SCN_MEM_NOT_PAGED = make_flag("IMAGE_SCN_MEM_NOT_PAGED", 0x08000000)
IMAGE_SCN_MEM_SHARED = make_flag("IMAGE_SCN_MEM_SHARED", 0x10000000)
IMAGE_SCN_MEM_EXECUTE = make_flag("IMAGE_SCN_MEM_EXECUTE", 0x20000000)
IMAGE_SCN_MEM_READ = make_flag("IMAGE_SCN_MEM_READ", 0x40000000)
IMAGE_SCN_MEM_WRITE = make_flag("IMAGE_SCN_MEM_WRITE", 0x80000000)
LPC_REQUEST = make_flag("LPC_REQUEST", 1)
LPC_REPLY = make_flag("LPC_REPLY", 2)
LPC_DATAGRAM = make_flag("LPC_DATAGRAM", 3)
LPC_LOST_REPLY = make_flag("LPC_LOST_REPLY", 4)
LPC_PORT_CLOSED = make_flag("LPC_PORT_CLOSED", 5)
LPC_CLIENT_DIED = make_flag("LPC_CLIENT_DIED", 6)
LPC_EXCEPTION = make_flag("LPC_EXCEPTION", 7)
LPC_DEBUG_EVENT = make_flag("LPC_DEBUG_EVENT", 8)
LPC_ERROR_EVENT = make_flag("LPC_ERROR_EVENT", 9)
LPC_CONNECTION_REQUEST = make_flag("LPC_CONNECTION_REQUEST", 10)
ALPC_MESSAGE_SECURITY_ATTRIBUTE = make_flag("ALPC_MESSAGE_SECURITY_ATTRIBUTE", 0x80000000)
ALPC_MESSAGE_VIEW_ATTRIBUTE = make_flag("ALPC_MESSAGE_VIEW_ATTRIBUTE", 0x40000000)
ALPC_MESSAGE_CONTEXT_ATTRIBUTE = make_flag("ALPC_MESSAGE_CONTEXT_ATTRIBUTE", 0x20000000)
ALPC_MESSAGE_HANDLE_ATTRIBUTE = make_flag("ALPC_MESSAGE_HANDLE_ATTRIBUTE", 0x10000000)
ALPC_MESSAGE_TOKEN_ATTRIBUTE = make_flag("ALPC_MESSAGE_TOKEN_ATTRIBUTE", 0x8000000)
ALPC_MESSAGE_DIRECT_ATTRIBUTE = make_flag("ALPC_MESSAGE_DIRECT_ATTRIBUTE", 0x4000000)
ALPC_MESSAGE_WORK_ON_BEHALF_ATTRIBUTE = make_flag("ALPC_MESSAGE_WORK_ON_BEHALF_ATTRIBUTE", 0x2000000)
ALPC_MSGFLG_REPLY_MESSAGE = make_flag("ALPC_MSGFLG_REPLY_MESSAGE", 0x1)
ALPC_MSGFLG_LPC_MODE = make_flag("ALPC_MSGFLG_LPC_MODE", 0x2)
ALPC_MSGFLG_RELEASE_MESSAGE = make_flag("ALPC_MSGFLG_RELEASE_MESSAGE", 0x10000)
ALPC_MSGFLG_SYNC_REQUEST = make_flag("ALPC_MSGFLG_SYNC_REQUEST", 0x20000)
ALPC_MSGFLG_WAIT_USER_MODE = make_flag("ALPC_MSGFLG_WAIT_USER_MODE", 0x100000)
ALPC_MSGFLG_WAIT_ALERTABLE = make_flag("ALPC_MSGFLG_WAIT_ALERTABLE", 0x200000)
ALPC_MSGFLG_WOW64_CALL = make_flag("ALPC_MSGFLG_WOW64_CALL", 0x80000000)
ALPC_PORFLG_ALLOW_LPC_REQUESTS = make_flag("ALPC_PORFLG_ALLOW_LPC_REQUESTS", 0x20000)
ALPC_PORFLG_WAITABLE_PORT = make_flag("ALPC_PORFLG_WAITABLE_PORT", 0x40000)
ALPC_PORFLG_SYSTEM_PROCESS = make_flag("ALPC_PORFLG_SYSTEM_PROCESS", 0x100000)
ALPC_CANCELFLG_TRY_CANCEL = make_flag("ALPC_CANCELFLG_TRY_CANCEL", 0x1)
ALPC_CANCELFLG_NO_CONTEXT_CHECK = make_flag("ALPC_CANCELFLG_NO_CONTEXT_CHECK", 0x8)
ALPC_CANCELFLGP_FLUSH = make_flag("ALPC_CANCELFLGP_FLUSH", 0x10000)
ALPC_HANDLEFLG_DUPLICATE_SAME_ACCESS = make_flag("ALPC_HANDLEFLG_DUPLICATE_SAME_ACCESS", 0x10000)
ALPC_HANDLEFLG_DUPLICATE_SAME_ATTRIBUTES = make_flag("ALPC_HANDLEFLG_DUPLICATE_SAME_ATTRIBUTES", 0x20000)
ALPC_HANDLEFLG_DUPLICATE_INHERIT = make_flag("ALPC_HANDLEFLG_DUPLICATE_INHERIT", 0x80000)
ALPC_SECFLG_CREATE_HANDLE = make_flag("ALPC_SECFLG_CREATE_HANDLE", 0x20000)
ALPC_VIEWFLG_NOT_SECURE = make_flag("ALPC_VIEWFLG_NOT_SECURE", 0x40000)
CERT_STORE_CERTIFICATE_CONTEXT = make_flag("CERT_STORE_CERTIFICATE_CONTEXT", 1)
CERT_STORE_CRL_CONTEXT = make_flag("CERT_STORE_CRL_CONTEXT", 2)
CERT_STORE_CTL_CONTEXT = make_flag("CERT_STORE_CTL_CONTEXT", 3)
WTD_UI_ALL = make_flag("WTD_UI_ALL", 1)
WTD_UI_NONE = make_flag("WTD_UI_NONE", 2)
WTD_UI_NOBAD = make_flag("WTD_UI_NOBAD", 3)
WTD_UI_NOGOOD = make_flag("WTD_UI_NOGOOD", 4)
WTD_REVOKE_NONE = make_flag("WTD_REVOKE_NONE", 0x00000000)
WTD_REVOKE_WHOLECHAIN = make_flag("WTD_REVOKE_WHOLECHAIN", 0x00000001)
WTD_CHOICE_FILE = make_flag("WTD_CHOICE_FILE", 1)
WTD_CHOICE_CATALOG = make_flag("WTD_CHOICE_CATALOG", 2)
WTD_CHOICE_BLOB = make_flag("WTD_CHOICE_BLOB", 3)
WTD_CHOICE_SIGNER = make_flag("WTD_CHOICE_SIGNER", 4)
WTD_CHOICE_CERT = make_flag("WTD_CHOICE_CERT", 5)
WTD_STATEACTION_IGNORE = make_flag("WTD_STATEACTION_IGNORE", 0x00000000)
WTD_STATEACTION_VERIFY = make_flag("WTD_STATEACTION_VERIFY", 0x00000001)
WTD_STATEACTION_CLOSE = make_flag("WTD_STATEACTION_CLOSE", 0x00000002)
WTD_STATEACTION_AUTO_CACHE = make_flag("WTD_STATEACTION_AUTO_CACHE", 0x00000003)
WTD_STATEACTION_AUTO_CACHE_FLUSH = make_flag("WTD_STATEACTION_AUTO_CACHE_FLUSH", 0x00000004)
COMPRESSION_FORMAT_NONE = make_flag("COMPRESSION_FORMAT_NONE", ( 0x0000 ))
COMPRESSION_FORMAT_DEFAULT = make_flag("COMPRESSION_FORMAT_DEFAULT", ( 0x0001 ))
COMPRESSION_FORMAT_LZNT1 = make_flag("COMPRESSION_FORMAT_LZNT1", ( 0x0002 ))
COMPRESSION_FORMAT_XPRESS = make_flag("COMPRESSION_FORMAT_XPRESS", ( 0x0003 ))
COMPRESSION_FORMAT_XPRESS_HUFF = make_flag("COMPRESSION_FORMAT_XPRESS_HUFF", ( 0x0004 ))
COMPRESSION_ENGINE_STANDARD = make_flag("COMPRESSION_ENGINE_STANDARD", ( 0x0000 ))
COMPRESSION_ENGINE_MAXIMUM = make_flag("COMPRESSION_ENGINE_MAXIMUM", ( 0x0100 ))
COMPRESSION_ENGINE_HIBER = make_flag("COMPRESSION_ENGINE_HIBER", ( 0x0200 ))
FILE_DIRECTORY_FILE = make_flag("FILE_DIRECTORY_FILE", 0x00000001)
FILE_WRITE_THROUGH = make_flag("FILE_WRITE_THROUGH", 0x00000002)
FILE_SEQUENTIAL_ONLY = make_flag("FILE_SEQUENTIAL_ONLY", 0x00000004)
FILE_NO_INTERMEDIATE_BUFFERING = make_flag("FILE_NO_INTERMEDIATE_BUFFERING", 0x00000008)
FILE_SYNCHRONOUS_IO_ALERT = make_flag("FILE_SYNCHRONOUS_IO_ALERT", 0x00000010)
FILE_SYNCHRONOUS_IO_NONALERT = make_flag("FILE_SYNCHRONOUS_IO_NONALERT", 0x00000020)
FILE_NON_DIRECTORY_FILE = make_flag("FILE_NON_DIRECTORY_FILE", 0x00000040)
FILE_CREATE_TREE_CONNECTION = make_flag("FILE_CREATE_TREE_CONNECTION", 0x00000080)
FILE_COMPLETE_IF_OPLOCKED = make_flag("FILE_COMPLETE_IF_OPLOCKED", 0x00000100)
FILE_NO_EA_KNOWLEDGE = make_flag("FILE_NO_EA_KNOWLEDGE", 0x00000200)
FILE_OPEN_REMOTE_INSTANCE = make_flag("FILE_OPEN_REMOTE_INSTANCE", 0x00000400)
FILE_RANDOM_ACCESS = make_flag("FILE_RANDOM_ACCESS", 0x00000800)
FILE_DELETE_ON_CLOSE = make_flag("FILE_DELETE_ON_CLOSE", 0x00001000)
FILE_OPEN_BY_FILE_ID = make_flag("FILE_OPEN_BY_FILE_ID", 0x00002000)
FILE_OPEN_FOR_BACKUP_INTENT = make_flag("FILE_OPEN_FOR_BACKUP_INTENT", 0x00004000)
FILE_NO_COMPRESSION = make_flag("FILE_NO_COMPRESSION", 0x00008000)
FILE_OPEN_REQUIRING_OPLOCK = make_flag("FILE_OPEN_REQUIRING_OPLOCK", 0x00010000)
FILE_RESERVE_OPFILTER = make_flag("FILE_RESERVE_OPFILTER", 0x00100000)
FILE_OPEN_REPARSE_POINT = make_flag("FILE_OPEN_REPARSE_POINT", 0x00200000)
FILE_OPEN_NO_RECALL = make_flag("FILE_OPEN_NO_RECALL", 0x00400000)
FILE_OPEN_FOR_FREE_SPACE_QUERY = make_flag("FILE_OPEN_FOR_FREE_SPACE_QUERY", 0x00800000)
FILE_VALID_OPTION_FLAGS = make_flag("FILE_VALID_OPTION_FLAGS", 0x00ffffff)
FILE_VALID_PIPE_OPTION_FLAGS = make_flag("FILE_VALID_PIPE_OPTION_FLAGS", 0x00000032)
FILE_VALID_MAILSLOT_OPTION_FLAGS = make_flag("FILE_VALID_MAILSLOT_OPTION_FLAGS", 0x00000032)
FILE_VALID_SET_FLAGS = make_flag("FILE_VALID_SET_FLAGS", 0x00000036)
FILE_SUPERSEDED = make_flag("FILE_SUPERSEDED", 0x00000000)
FILE_OPENED = make_flag("FILE_OPENED", 0x00000001)
FILE_CREATED = make_flag("FILE_CREATED", 0x00000002)
FILE_OVERWRITTEN = make_flag("FILE_OVERWRITTEN", 0x00000003)
FILE_EXISTS = make_flag("FILE_EXISTS", 0x00000004)
FILE_DOES_NOT_EXIST = make_flag("FILE_DOES_NOT_EXIST", 0x00000005)
API_SET_SCHEMA_VERSION_V2 = make_flag("API_SET_SCHEMA_VERSION_V2", 0x00000002)
API_SET_SCHEMA_VERSION_V3 = make_flag("API_SET_SCHEMA_VERSION_V3", 0x00000003)
API_SET_SCHEMA_VERSION_V4 = make_flag("API_SET_SCHEMA_VERSION_V4", 0x00000004)
API_SET_LOAD_SCHEMA_ORDINAL = make_flag("API_SET_LOAD_SCHEMA_ORDINAL", 1)
API_SET_LOOKUP_ORDINAL = make_flag("API_SET_LOOKUP_ORDINAL", 2)
API_SET_RELEASE_SCHEMA_ORDINAL = make_flag("API_SET_RELEASE_SCHEMA_ORDINAL", 3)
API_SET_SCHEMA_FLAGS_SEALED = make_flag("API_SET_SCHEMA_FLAGS_SEALED", 0x00000001)
API_SET_SCHEMA_FLAGS_HOST_EXTENSION = make_flag("API_SET_SCHEMA_FLAGS_HOST_EXTENSION", 0x00000002)
API_SET_SCHEMA_ENTRY_FLAGS_SEALED = make_flag("API_SET_SCHEMA_ENTRY_FLAGS_SEALED", 0x00000001)
API_SET_SCHEMA_ENTRY_FLAGS_EXTENSION = make_flag("API_SET_SCHEMA_ENTRY_FLAGS_EXTENSION", 0x00000002)
CMSG_VERIFY_SIGNER_PUBKEY = make_flag("CMSG_VERIFY_SIGNER_PUBKEY", 1)
CMSG_VERIFY_SIGNER_CERT = make_flag("CMSG_VERIFY_SIGNER_CERT", 2)
CMSG_VERIFY_SIGNER_CHAIN = make_flag("CMSG_VERIFY_SIGNER_CHAIN", 3)
CMSG_VERIFY_SIGNER_NULL = make_flag("CMSG_VERIFY_SIGNER_NULL", 4)
TXFS_MINIVERSION_COMMITTED_VIEW = make_flag("TXFS_MINIVERSION_COMMITTED_VIEW", ( 0x0000 ))
TXFS_MINIVERSION_DIRTY_VIEW = make_flag("TXFS_MINIVERSION_DIRTY_VIEW", ( 0xFFFF ))
TXFS_MINIVERSION_DEFAULT_VIEW = make_flag("TXFS_MINIVERSION_DEFAULT_VIEW", ( 0xFFFE ))
TOKEN_SOURCE_LENGTH = make_flag("TOKEN_SOURCE_LENGTH", 8)
SID_HASH_SIZE = make_flag("SID_HASH_SIZE", 32)
TOKEN_MANDATORY_POLICY_OFF = make_flag("TOKEN_MANDATORY_POLICY_OFF", 0x0)
TOKEN_MANDATORY_POLICY_NO_WRITE_UP = make_flag("TOKEN_MANDATORY_POLICY_NO_WRITE_UP", 0x1)
TOKEN_MANDATORY_POLICY_NEW_PROCESS_MIN = make_flag("TOKEN_MANDATORY_POLICY_NEW_PROCESS_MIN", 0x2)
TOKEN_MANDATORY_POLICY_VALID_MASK = make_flag("TOKEN_MANDATORY_POLICY_VALID_MASK", ( TOKEN_MANDATORY_POLICY_NO_WRITE_UP | TOKEN_MANDATORY_POLICY_NEW_PROCESS_MIN ))
TOKEN_SECURITY_ATTRIBUTE_TYPE_INVALID = make_flag("TOKEN_SECURITY_ATTRIBUTE_TYPE_INVALID", 0x00)
TOKEN_SECURITY_ATTRIBUTE_TYPE_INT64 = make_flag("TOKEN_SECURITY_ATTRIBUTE_TYPE_INT64", 0x01)
TOKEN_SECURITY_ATTRIBUTE_TYPE_UINT64 = make_flag("TOKEN_SECURITY_ATTRIBUTE_TYPE_UINT64", 0x02)
TOKEN_SECURITY_ATTRIBUTE_TYPE_STRING = make_flag("TOKEN_SECURITY_ATTRIBUTE_TYPE_STRING", 0x03)
TOKEN_SECURITY_ATTRIBUTE_TYPE_FQBN = make_flag("TOKEN_SECURITY_ATTRIBUTE_TYPE_FQBN", 0x04)
TOKEN_SECURITY_ATTRIBUTE_TYPE_SID = make_flag("TOKEN_SECURITY_ATTRIBUTE_TYPE_SID", 0x05)
TOKEN_SECURITY_ATTRIBUTE_TYPE_BOOLEAN = make_flag("TOKEN_SECURITY_ATTRIBUTE_TYPE_BOOLEAN", 0x06)
TOKEN_SECURITY_ATTRIBUTE_TYPE_OCTET_STRING = make_flag("TOKEN_SECURITY_ATTRIBUTE_TYPE_OCTET_STRING", 0x10)
TOKEN_SECURITY_ATTRIBUTE_NON_INHERITABLE = make_flag("TOKEN_SECURITY_ATTRIBUTE_NON_INHERITABLE", 0x0001)
TOKEN_SECURITY_ATTRIBUTE_VALUE_CASE_SENSITIVE = make_flag("TOKEN_SECURITY_ATTRIBUTE_VALUE_CASE_SENSITIVE", 0x0002)
TOKEN_SECURITY_ATTRIBUTE_USE_FOR_DENY_ONLY = make_flag("TOKEN_SECURITY_ATTRIBUTE_USE_FOR_DENY_ONLY", 0x0004)
TOKEN_SECURITY_ATTRIBUTE_DISABLED_BY_DEFAULT = make_flag("TOKEN_SECURITY_ATTRIBUTE_DISABLED_BY_DEFAULT", 0x0008)
TOKEN_SECURITY_ATTRIBUTE_DISABLED = make_flag("TOKEN_SECURITY_ATTRIBUTE_DISABLED", 0x0010)
TOKEN_SECURITY_ATTRIBUTE_MANDATORY = make_flag("TOKEN_SECURITY_ATTRIBUTE_MANDATORY", 0x0020)
TOKEN_SECURITY_ATTRIBUTE_VALID_FLAGS = make_flag("TOKEN_SECURITY_ATTRIBUTE_VALID_FLAGS", ( TOKEN_SECURITY_ATTRIBUTE_NON_INHERITABLE | TOKEN_SECURITY_ATTRIBUTE_VALUE_CASE_SENSITIVE | TOKEN_SECURITY_ATTRIBUTE_USE_FOR_DENY_ONLY | TOKEN_SECURITY_ATTRIBUTE_DISABLED_BY_DEFAULT | TOKEN_SECURITY_ATTRIBUTE_DISABLED | TOKEN_SECURITY_ATTRIBUTE_MANDATORY ))
TOKEN_SECURITY_ATTRIBUTE_CUSTOM_FLAGS = make_flag("TOKEN_SECURITY_ATTRIBUTE_CUSTOM_FLAGS", 0xffff0000)
TOKEN_ASSIGN_PRIMARY = make_flag("TOKEN_ASSIGN_PRIMARY", ( 0x0001 ))
TOKEN_DUPLICATE = make_flag("TOKEN_DUPLICATE", ( 0x0002 ))
TOKEN_IMPERSONATE = make_flag("TOKEN_IMPERSONATE", ( 0x0004 ))
TOKEN_QUERY = make_flag("TOKEN_QUERY", ( 0x0008 ))
TOKEN_QUERY_SOURCE = make_flag("TOKEN_QUERY_SOURCE", ( 0x0010 ))
TOKEN_ADJUST_PRIVILEGES = make_flag("TOKEN_ADJUST_PRIVILEGES", ( 0x0020 ))
TOKEN_ADJUST_GROUPS = make_flag("TOKEN_ADJUST_GROUPS", ( 0x0040 ))
TOKEN_ADJUST_DEFAULT = make_flag("TOKEN_ADJUST_DEFAULT", ( 0x0080 ))
TOKEN_ADJUST_SESSIONID = make_flag("TOKEN_ADJUST_SESSIONID", ( 0x0100 ))
TOKEN_ALL_ACCESS_P = make_flag("TOKEN_ALL_ACCESS_P", ( STANDARD_RIGHTS_REQUIRED | TOKEN_ASSIGN_PRIMARY | TOKEN_DUPLICATE | TOKEN_IMPERSONATE | TOKEN_QUERY | TOKEN_QUERY_SOURCE | TOKEN_ADJUST_PRIVILEGES | TOKEN_ADJUST_GROUPS | TOKEN_ADJUST_DEFAULT ))
TOKEN_ALL_ACCESS = make_flag("TOKEN_ALL_ACCESS", ( TOKEN_ALL_ACCESS_P | TOKEN_ADJUST_SESSIONID ))
SE_PRIVILEGE_ENABLED_BY_DEFAULT = make_flag("SE_PRIVILEGE_ENABLED_BY_DEFAULT", ( 0x00000001 ))
SE_PRIVILEGE_ENABLED = make_flag("SE_PRIVILEGE_ENABLED", ( 0x00000002 ))
SE_PRIVILEGE_REMOVED = make_flag("SE_PRIVILEGE_REMOVED", ( 0X00000004 ))
SE_PRIVILEGE_USED_FOR_ACCESS = make_flag("SE_PRIVILEGE_USED_FOR_ACCESS", ( 0x80000000 ))
SE_CREATE_TOKEN_NAME = make_flag("SE_CREATE_TOKEN_NAME", ( "SeCreateTokenPrivilege" ))
SE_ASSIGNPRIMARYTOKEN_NAME = make_flag("SE_ASSIGNPRIMARYTOKEN_NAME", ( "SeAssignPrimaryTokenPrivilege" ))
SE_LOCK_MEMORY_NAME = make_flag("SE_LOCK_MEMORY_NAME", ( "SeLockMemoryPrivilege" ))
SE_INCREASE_QUOTA_NAME = make_flag("SE_INCREASE_QUOTA_NAME", ( "SeIncreaseQuotaPrivilege" ))
SE_UNSOLICITED_INPUT_NAME = make_flag("SE_UNSOLICITED_INPUT_NAME", ( "SeUnsolicitedInputPrivilege" ))
SE_MACHINE_ACCOUNT_NAME = make_flag("SE_MACHINE_ACCOUNT_NAME", ( "SeMachineAccountPrivilege" ))
SE_TCB_NAME = make_flag("SE_TCB_NAME", ( "SeTcbPrivilege" ))
SE_SECURITY_NAME = make_flag("SE_SECURITY_NAME", ( "SeSecurityPrivilege" ))
SE_TAKE_OWNERSHIP_NAME = make_flag("SE_TAKE_OWNERSHIP_NAME", ( "SeTakeOwnershipPrivilege" ))
SE_LOAD_DRIVER_NAME = make_flag("SE_LOAD_DRIVER_NAME", ( "SeLoadDriverPrivilege" ))
SE_SYSTEM_PROFILE_NAME = make_flag("SE_SYSTEM_PROFILE_NAME", ( "SeSystemProfilePrivilege" ))
SE_SYSTEMTIME_NAME = make_flag("SE_SYSTEMTIME_NAME", ( "SeSystemtimePrivilege" ))
SE_PROF_SINGLE_PROCESS_NAME = make_flag("SE_PROF_SINGLE_PROCESS_NAME", ( "SeProfileSingleProcessPrivilege" ))
SE_INC_BASE_PRIORITY_NAME = make_flag("SE_INC_BASE_PRIORITY_NAME", ( "SeIncreaseBasePriorityPrivilege" ))
SE_CREATE_PAGEFILE_NAME = make_flag("SE_CREATE_PAGEFILE_NAME", ( "SeCreatePagefilePrivilege" ))
SE_CREATE_PERMANENT_NAME = make_flag("SE_CREATE_PERMANENT_NAME", ( "SeCreatePermanentPrivilege" ))
SE_BACKUP_NAME = make_flag("SE_BACKUP_NAME", ( "SeBackupPrivilege" ))
SE_RESTORE_NAME = make_flag("SE_RESTORE_NAME", ( "SeRestorePrivilege" ))
SE_SHUTDOWN_NAME = make_flag("SE_SHUTDOWN_NAME", ( "SeShutdownPrivilege" ))
SE_DEBUG_NAME = make_flag("SE_DEBUG_NAME", ( "SeDebugPrivilege" ))
SE_AUDIT_NAME = make_flag("SE_AUDIT_NAME", ( "SeAuditPrivilege" ))
SE_SYSTEM_ENVIRONMENT_NAME = make_flag("SE_SYSTEM_ENVIRONMENT_NAME", ( "SeSystemEnvironmentPrivilege" ))
SE_CHANGE_NOTIFY_NAME = make_flag("SE_CHANGE_NOTIFY_NAME", ( "SeChangeNotifyPrivilege" ))
SE_REMOTE_SHUTDOWN_NAME = make_flag("SE_REMOTE_SHUTDOWN_NAME", ( "SeRemoteShutdownPrivilege" ))
SE_UNDOCK_NAME = make_flag("SE_UNDOCK_NAME", ( "SeUndockPrivilege" ))
SE_SYNC_AGENT_NAME = make_flag("SE_SYNC_AGENT_NAME", ( "SeSyncAgentPrivilege" ))
SE_ENABLE_DELEGATION_NAME = make_flag("SE_ENABLE_DELEGATION_NAME", ( "SeEnableDelegationPrivilege" ))
SE_MANAGE_VOLUME_NAME = make_flag("SE_MANAGE_VOLUME_NAME", ( "SeManageVolumePrivilege" ))
SE_IMPERSONATE_NAME = make_flag("SE_IMPERSONATE_NAME", ( "SeImpersonatePrivilege" ))
SE_CREATE_GLOBAL_NAME = make_flag("SE_CREATE_GLOBAL_NAME", ( "SeCreateGlobalPrivilege" ))
SE_TRUSTED_CREDMAN_ACCESS_NAME = make_flag("SE_TRUSTED_CREDMAN_ACCESS_NAME", ( "SeTrustedCredManAccessPrivilege" ))
SE_RELABEL_NAME = make_flag("SE_RELABEL_NAME", ( "SeRelabelPrivilege" ))
SE_INC_WORKING_SET_NAME = make_flag("SE_INC_WORKING_SET_NAME", ( "SeIncreaseWorkingSetPrivilege" ))
SE_TIME_ZONE_NAME = make_flag("SE_TIME_ZONE_NAME", ( "SeTimeZonePrivilege" ))
SE_CREATE_SYMBOLIC_LINK_NAME = make_flag("SE_CREATE_SYMBOLIC_LINK_NAME", ( "SeCreateSymbolicLinkPrivilege" ))
ACCESS_SYSTEM_SECURITY = make_flag("ACCESS_SYSTEM_SECURITY", ( 0x01000000 ))
MAXIMUM_ALLOWED = make_flag("MAXIMUM_ALLOWED", ( 0x02000000 ))
FILE_READ_DATA = make_flag("FILE_READ_DATA", ( 0x0001 ))
FILE_LIST_DIRECTORY = make_flag("FILE_LIST_DIRECTORY", ( 0x0001 ))
FILE_WRITE_DATA = make_flag("FILE_WRITE_DATA", ( 0x0002 ))
FILE_ADD_FILE = make_flag("FILE_ADD_FILE", ( 0x0002 ))
FILE_APPEND_DATA = make_flag("FILE_APPEND_DATA", ( 0x0004 ))
FILE_ADD_SUBDIRECTORY = make_flag("FILE_ADD_SUBDIRECTORY", ( 0x0004 ))
FILE_CREATE_PIPE_INSTANCE = make_flag("FILE_CREATE_PIPE_INSTANCE", ( 0x0004 ))
FILE_READ_EA = make_flag("FILE_READ_EA", ( 0x0008 ))
FILE_WRITE_EA = make_flag("FILE_WRITE_EA", ( 0x0010 ))
FILE_EXECUTE = make_flag("FILE_EXECUTE", ( 0x0020 ))
FILE_TRAVERSE = make_flag("FILE_TRAVERSE", ( 0x0020 ))
FILE_DELETE_CHILD = make_flag("FILE_DELETE_CHILD", ( 0x0040 ))
FILE_READ_ATTRIBUTES = make_flag("FILE_READ_ATTRIBUTES", ( 0x0080 ))
FILE_WRITE_ATTRIBUTES = make_flag("FILE_WRITE_ATTRIBUTES", ( 0x0100 ))
FILE_ALL_ACCESS = make_flag("FILE_ALL_ACCESS", ( STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x1FF ))
FILE_GENERIC_READ = make_flag("FILE_GENERIC_READ", ( STANDARD_RIGHTS_READ | FILE_READ_DATA | FILE_READ_ATTRIBUTES | FILE_READ_EA | SYNCHRONIZE ))
FILE_GENERIC_WRITE = make_flag("FILE_GENERIC_WRITE", ( STANDARD_RIGHTS_WRITE | FILE_WRITE_DATA | FILE_WRITE_ATTRIBUTES | FILE_WRITE_EA | FILE_APPEND_DATA | SYNCHRONIZE ))
FILE_GENERIC_EXECUTE = make_flag("FILE_GENERIC_EXECUTE", ( STANDARD_RIGHTS_EXECUTE | FILE_READ_ATTRIBUTES | FILE_EXECUTE | SYNCHRONIZE ))
CALLBACK_MODIFY_STATE = make_flag("CALLBACK_MODIFY_STATE", 0x0001)
CALLBACK_ALL_ACCESS = make_flag("CALLBACK_ALL_ACCESS", ( STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE| CALLBACK_MODIFY_STATE ))
EVENT_QUERY_STATE = make_flag("EVENT_QUERY_STATE", 0x0001)
EVENT_MODIFY_STATE = make_flag("EVENT_MODIFY_STATE", 0x0002)
EVENT_ALL_ACCESS = make_flag("EVENT_ALL_ACCESS", ( STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE|0x3 ))
MUTANT_QUERY_STATE = make_flag("MUTANT_QUERY_STATE", 0x0001)
MUTANT_ALL_ACCESS = make_flag("MUTANT_ALL_ACCESS", ( STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE| MUTANT_QUERY_STATE ))
SEMAPHORE_QUERY_STATE = make_flag("SEMAPHORE_QUERY_STATE", 0x0001)
SEMAPHORE_MODIFY_STATE = make_flag("SEMAPHORE_MODIFY_STATE", 0x0002)
SEMAPHORE_ALL_ACCESS = make_flag("SEMAPHORE_ALL_ACCESS", ( STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE|0x3 ))
TIMER_QUERY_STATE = make_flag("TIMER_QUERY_STATE", 0x0001)
TIMER_MODIFY_STATE = make_flag("TIMER_MODIFY_STATE", 0x0002)
TIMER_ALL_ACCESS = make_flag("TIMER_ALL_ACCESS", ( STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE| TIMER_QUERY_STATE|TIMER_MODIFY_STATE ))
IO_COMPLETION_QUERY_STATE = make_flag("IO_COMPLETION_QUERY_STATE", 0x0001)
IO_COMPLETION_MODIFY_STATE = make_flag("IO_COMPLETION_MODIFY_STATE", 0x0002)
IO_COMPLETION_ALL_ACCESS = make_flag("IO_COMPLETION_ALL_ACCESS", ( STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE|0x3 ))
PORT_CONNECT = make_flag("PORT_CONNECT", ( 0x0001 ))
PORT_ALL_ACCESS = make_flag("PORT_ALL_ACCESS", ( STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x1 ))
OBJECT_TYPE_CREATE = make_flag("OBJECT_TYPE_CREATE", ( 0x0001 ))
OBJECT_TYPE_ALL_ACCESS = make_flag("OBJECT_TYPE_ALL_ACCESS", ( STANDARD_RIGHTS_REQUIRED | 0x1 ))
DIRECTORY_QUERY = make_flag("DIRECTORY_QUERY", ( 0x0001 ))
DIRECTORY_TRAVERSE = make_flag("DIRECTORY_TRAVERSE", ( 0x0002 ))
DIRECTORY_CREATE_OBJECT = make_flag("DIRECTORY_CREATE_OBJECT", ( 0x0004 ))
DIRECTORY_CREATE_SUBDIRECTORY = make_flag("DIRECTORY_CREATE_SUBDIRECTORY", ( 0x0008 ))
DIRECTORY_ALL_ACCESS = make_flag("DIRECTORY_ALL_ACCESS", ( STANDARD_RIGHTS_REQUIRED | 0xF ))
SYMBOLIC_LINK_QUERY = make_flag("SYMBOLIC_LINK_QUERY", ( 0x0001 ))
SYMBOLIC_LINK_ALL_ACCESS = make_flag("SYMBOLIC_LINK_ALL_ACCESS", ( STANDARD_RIGHTS_REQUIRED | 0x1 ))
PROCESS_TERMINATE = make_flag("PROCESS_TERMINATE", ( 0x0001 ))
PROCESS_CREATE_THREAD = make_flag("PROCESS_CREATE_THREAD", ( 0x0002 ))
PROCESS_SET_SESSIONID = make_flag("PROCESS_SET_SESSIONID", ( 0x0004 ))
PROCESS_VM_OPERATION = make_flag("PROCESS_VM_OPERATION", ( 0x0008 ))
PROCESS_VM_READ = make_flag("PROCESS_VM_READ", ( 0x0010 ))
PROCESS_VM_WRITE = make_flag("PROCESS_VM_WRITE", ( 0x0020 ))
PROCESS_DUP_HANDLE = make_flag("PROCESS_DUP_HANDLE", ( 0x0040 ))
PROCESS_CREATE_PROCESS = make_flag("PROCESS_CREATE_PROCESS", ( 0x0080 ))
PROCESS_SET_QUOTA = make_flag("PROCESS_SET_QUOTA", ( 0x0100 ))
PROCESS_SET_INFORMATION = make_flag("PROCESS_SET_INFORMATION", ( 0x0200 ))
PROCESS_QUERY_INFORMATION = make_flag("PROCESS_QUERY_INFORMATION", ( 0x0400 ))
PROCESS_SUSPEND_RESUME = make_flag("PROCESS_SUSPEND_RESUME", ( 0x0800 ))
PROCESS_QUERY_LIMITED_INFORMATION = make_flag("PROCESS_QUERY_LIMITED_INFORMATION", ( 0x1000 ))
PROCESS_SET_LIMITED_INFORMATION = make_flag("PROCESS_SET_LIMITED_INFORMATION", ( 0x2000 ))
PROCESS_ALL_ACCESS = make_flag("PROCESS_ALL_ACCESS", ( STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0xFFF ))
THREAD_TERMINATE = make_flag("THREAD_TERMINATE", ( 0x0001 ))
THREAD_SUSPEND_RESUME = make_flag("THREAD_SUSPEND_RESUME", ( 0x0002 ))
THREAD_GET_CONTEXT = make_flag("THREAD_GET_CONTEXT", ( 0x0008 ))
THREAD_SET_CONTEXT = make_flag("THREAD_SET_CONTEXT", ( 0x0010 ))
THREAD_QUERY_INFORMATION = make_flag("THREAD_QUERY_INFORMATION", ( 0x0040 ))
THREAD_SET_INFORMATION = make_flag("THREAD_SET_INFORMATION", ( 0x0020 ))
THREAD_SET_THREAD_TOKEN = make_flag("THREAD_SET_THREAD_TOKEN", ( 0x0080 ))
THREAD_IMPERSONATE = make_flag("THREAD_IMPERSONATE", ( 0x0100 ))
THREAD_DIRECT_IMPERSONATION = make_flag("THREAD_DIRECT_IMPERSONATION", ( 0x0200 ))
THREAD_ALL_ACCESS = make_flag("THREAD_ALL_ACCESS", 0x001F03FF)
JOB_OBJECT_ASSIGN_PROCESS = make_flag("JOB_OBJECT_ASSIGN_PROCESS", ( 0x0001 ))
JOB_OBJECT_SET_ATTRIBUTES = make_flag("JOB_OBJECT_SET_ATTRIBUTES", ( 0x0002 ))
JOB_OBJECT_QUERY = make_flag("JOB_OBJECT_QUERY", ( 0x0004 ))
JOB_OBJECT_TERMINATE = make_flag("JOB_OBJECT_TERMINATE", ( 0x0008 ))
JOB_OBJECT_SET_SECURITY_ATTRIBUTES = make_flag("JOB_OBJECT_SET_SECURITY_ATTRIBUTES", ( 0x0010 ))
JOB_OBJECT_ALL_ACCESS = make_flag("JOB_OBJECT_ALL_ACCESS", ( STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x1F ))
KEY_QUERY_VALUE = make_flag("KEY_QUERY_VALUE", ( 0x0001 ))
KEY_SET_VALUE = make_flag("KEY_SET_VALUE", ( 0x0002 ))
KEY_CREATE_SUB_KEY = make_flag("KEY_CREATE_SUB_KEY", ( 0x0004 ))
KEY_ENUMERATE_SUB_KEYS = make_flag("KEY_ENUMERATE_SUB_KEYS", ( 0x0008 ))
KEY_NOTIFY = make_flag("KEY_NOTIFY", ( 0x0010 ))
KEY_CREATE_LINK = make_flag("KEY_CREATE_LINK", ( 0x0020 ))
KEY_WOW64_32KEY = make_flag("KEY_WOW64_32KEY", ( 0x0200 ))
KEY_WOW64_64KEY = make_flag("KEY_WOW64_64KEY", ( 0x0100 ))
KEY_WOW64_RES = make_flag("KEY_WOW64_RES", ( 0x0300 ))
KEY_READ = make_flag("KEY_READ", ( ( STANDARD_RIGHTS_READ|KEY_QUERY_VALUE|KEY_ENUMERATE_SUB_KEYS|KEY_NOTIFY ) & ( ~SYNCHRONIZE ) ))
KEY_WRITE = make_flag("KEY_WRITE", ( ( STANDARD_RIGHTS_WRITE|KEY_SET_VALUE|KEY_CREATE_SUB_KEY ) & ( ~SYNCHRONIZE ) ))
KEY_EXECUTE = make_flag("KEY_EXECUTE", ( ( KEY_READ ) & ( ~SYNCHRONIZE ) ))
KEY_ALL_ACCESS = make_flag("KEY_ALL_ACCESS", ( ( STANDARD_RIGHTS_ALL|KEY_QUERY_VALUE|KEY_SET_VALUE|KEY_CREATE_SUB_KEY|KEY_ENUMERATE_SUB_KEYS|KEY_NOTIFY|KEY_CREATE_LINK ) & ( ~SYNCHRONIZE ) ))
CLUSAPI_READ_ACCESS = make_flag("CLUSAPI_READ_ACCESS", 0x00000001)
CLUSAPI_CHANGE_ACCESS = make_flag("CLUSAPI_CHANGE_ACCESS", 0x00000002)
CLUSAPI_NO_ACCESS = make_flag("CLUSAPI_NO_ACCESS", 0x00000004)
CLUSAPI_ALL_ACCESS = make_flag("CLUSAPI_ALL_ACCESS", ( CLUSAPI_READ_ACCESS | CLUSAPI_CHANGE_ACCESS ))
FAX_JOB_SUBMIT = make_flag("FAX_JOB_SUBMIT", ( 0x0001 ))
FAX_JOB_QUERY = make_flag("FAX_JOB_QUERY", ( 0x0002 ))
FAX_CONFIG_QUERY = make_flag("FAX_CONFIG_QUERY", ( 0x0004 ))
FAX_CONFIG_SET = make_flag("FAX_CONFIG_SET", ( 0x0008 ))
FAX_PORT_QUERY = make_flag("FAX_PORT_QUERY", ( 0x0010 ))
FAX_PORT_SET = make_flag("FAX_PORT_SET", ( 0x0020 ))
FAX_JOB_MANAGE = make_flag("FAX_JOB_MANAGE", ( 0x0040 ))
COM_EXECUTE = make_flag("COM_EXECUTE", ( 0x0001 ))
COM_EXECUTE_LOCAL = make_flag("COM_EXECUTE_LOCAL", ( 0x0002 ))
COM_EXECUTE_REMOTE = make_flag("COM_EXECUTE_REMOTE", ( 0x0004 ))
COM_ACTIVATE_LOCAL = make_flag("COM_ACTIVATE_LOCAL", ( 0x0008 ))
COM_ACTIVATE_REMOTE = make_flag("COM_ACTIVATE_REMOTE", ( 0x0010 ))
SECTION_QUERY = make_flag("SECTION_QUERY", 0x0001)
SECTION_MAP_WRITE = make_flag("SECTION_MAP_WRITE", 0x0002)
SECTION_MAP_READ = make_flag("SECTION_MAP_READ", 0x0004)
SECTION_MAP_EXECUTE = make_flag("SECTION_MAP_EXECUTE", 0x0008)
SECTION_EXTEND_SIZE = make_flag("SECTION_EXTEND_SIZE", 0x0010)
SECTION_MAP_EXECUTE_EXPLICIT = make_flag("SECTION_MAP_EXECUTE_EXPLICIT", 0x0020)
SECTION_ALL_ACCESS = make_flag("SECTION_ALL_ACCESS", ( STANDARD_RIGHTS_REQUIRED|SECTION_QUERY| SECTION_MAP_WRITE |SECTION_MAP_READ |SECTION_MAP_EXECUTE |SECTION_EXTEND_SIZE ))
FILE_MAP_COPY = make_flag("FILE_MAP_COPY", SECTION_QUERY)
FILE_MAP_WRITE = make_flag("FILE_MAP_WRITE", SECTION_MAP_WRITE)
FILE_MAP_READ = make_flag("FILE_MAP_READ", SECTION_MAP_READ)
FILE_MAP_ALL_ACCESS = make_flag("FILE_MAP_ALL_ACCESS", SECTION_ALL_ACCESS)
FILE_MAP_EXECUTE = make_flag("FILE_MAP_EXECUTE", SECTION_MAP_EXECUTE_EXPLICIT)
SERVICE_QUERY_CONFIG = make_flag("SERVICE_QUERY_CONFIG", 0x0001)
SERVICE_CHANGE_CONFIG = make_flag("SERVICE_CHANGE_CONFIG", 0x0002)
SERVICE_QUERY_STATUS = make_flag("SERVICE_QUERY_STATUS", 0x0004)
SERVICE_ENUMERATE_DEPENDENTS = make_flag("SERVICE_ENUMERATE_DEPENDENTS", 0x0008)
SERVICE_START = make_flag("SERVICE_START", 0x0010)
SERVICE_STOP = make_flag("SERVICE_STOP", 0x0020)
SERVICE_PAUSE_CONTINUE = make_flag("SERVICE_PAUSE_CONTINUE", 0x0040)
SERVICE_INTERROGATE = make_flag("SERVICE_INTERROGATE", 0x0080)
SERVICE_USER_DEFINED_CONTROL = make_flag("SERVICE_USER_DEFINED_CONTROL", 0x0100)
SERVICE_ALL_ACCESS = make_flag("SERVICE_ALL_ACCESS", ( STANDARD_RIGHTS_REQUIRED | SERVICE_QUERY_CONFIG | SERVICE_CHANGE_CONFIG | SERVICE_QUERY_STATUS | SERVICE_ENUMERATE_DEPENDENTS | SERVICE_START | SERVICE_STOP | SERVICE_PAUSE_CONTINUE | SERVICE_INTERROGATE | SERVICE_USER_DEFINED_CONTROL ))
SC_MANAGER_CONNECT = make_flag("SC_MANAGER_CONNECT", 0x0001)
SC_MANAGER_CREATE_SERVICE = make_flag("SC_MANAGER_CREATE_SERVICE", 0x0002)
SC_MANAGER_ENUMERATE_SERVICE = make_flag("SC_MANAGER_ENUMERATE_SERVICE", 0x0004)
SC_MANAGER_LOCK = make_flag("SC_MANAGER_LOCK", 0x0008)
SC_MANAGER_QUERY_LOCK_STATUS = make_flag("SC_MANAGER_QUERY_LOCK_STATUS", 0x0010)
SC_MANAGER_MODIFY_BOOT_CONFIG = make_flag("SC_MANAGER_MODIFY_BOOT_CONFIG", 0x0020)
SC_MANAGER_ALL_ACCESS = make_flag("SC_MANAGER_ALL_ACCESS", ( STANDARD_RIGHTS_REQUIRED | SC_MANAGER_CONNECT | SC_MANAGER_CREATE_SERVICE | SC_MANAGER_ENUMERATE_SERVICE | SC_MANAGER_LOCK | SC_MANAGER_QUERY_LOCK_STATUS | SC_MANAGER_MODIFY_BOOT_CONFIG ))
ADS_RIGHT_DELETE = make_flag("ADS_RIGHT_DELETE", 0x10000)
ADS_RIGHT_READ_CONTROL = make_flag("ADS_RIGHT_READ_CONTROL", 0x20000)
ADS_RIGHT_WRITE_DAC = make_flag("ADS_RIGHT_WRITE_DAC", 0x40000)
ADS_RIGHT_WRITE_OWNER = make_flag("ADS_RIGHT_WRITE_OWNER", 0x80000)
ADS_RIGHT_SYNCHRONIZE = make_flag("ADS_RIGHT_SYNCHRONIZE", 0x100000)
ADS_RIGHT_ACCESS_SYSTEM_SECURITY = make_flag("ADS_RIGHT_ACCESS_SYSTEM_SECURITY", 0x1000000)
ADS_RIGHT_GENERIC_READ = make_flag("ADS_RIGHT_GENERIC_READ", 0x80000000)
ADS_RIGHT_GENERIC_WRITE = make_flag("ADS_RIGHT_GENERIC_WRITE", 0x40000000)
ADS_RIGHT_GENERIC_EXECUTE = make_flag("ADS_RIGHT_GENERIC_EXECUTE", 0x20000000)
ADS_RIGHT_GENERIC_ALL = make_flag("ADS_RIGHT_GENERIC_ALL", 0x10000000)
ADS_RIGHT_DS_CREATE_CHILD = make_flag("ADS_RIGHT_DS_CREATE_CHILD", 0x1)
ADS_RIGHT_DS_DELETE_CHILD = make_flag("ADS_RIGHT_DS_DELETE_CHILD", 0x2)
ADS_RIGHT_ACTRL_DS_LIST = make_flag("ADS_RIGHT_ACTRL_DS_LIST", 0x4)
ADS_RIGHT_DS_SELF = make_flag("ADS_RIGHT_DS_SELF", 0x8)
ADS_RIGHT_DS_READ_PROP = make_flag("ADS_RIGHT_DS_READ_PROP", 0x10)
ADS_RIGHT_DS_WRITE_PROP = make_flag("ADS_RIGHT_DS_WRITE_PROP", 0x20)
ADS_RIGHT_DS_DELETE_TREE = make_flag("ADS_RIGHT_DS_DELETE_TREE", 0x40)
ADS_RIGHT_DS_LIST_OBJECT = make_flag("ADS_RIGHT_DS_LIST_OBJECT", 0x80)
ADS_RIGHT_DS_CONTROL_ACCESS = make_flag("ADS_RIGHT_DS_CONTROL_ACCESS", 0x100)
POLICY_VIEW_LOCAL_INFORMATION = make_flag("POLICY_VIEW_LOCAL_INFORMATION", 0x00000001)
POLICY_VIEW_AUDIT_INFORMATION = make_flag("POLICY_VIEW_AUDIT_INFORMATION", 0x00000002)
POLICY_GET_PRIVATE_INFORMATION = make_flag("POLICY_GET_PRIVATE_INFORMATION", 0x00000004)
POLICY_TRUST_ADMIN = make_flag("POLICY_TRUST_ADMIN", 0x00000008)
POLICY_CREATE_ACCOUNT = make_flag("POLICY_CREATE_ACCOUNT", 0x00000010)
POLICY_CREATE_SECRET = make_flag("POLICY_CREATE_SECRET", 0x00000020)
POLICY_CREATE_PRIVILEGE = make_flag("POLICY_CREATE_PRIVILEGE", 0x00000040)
POLICY_SET_DEFAULT_QUOTA_LIMITS = make_flag("POLICY_SET_DEFAULT_QUOTA_LIMITS", 0x00000080)
POLICY_SET_AUDIT_REQUIREMENTS = make_flag("POLICY_SET_AUDIT_REQUIREMENTS", 0x00000100)
POLICY_AUDIT_LOG_ADMIN = make_flag("POLICY_AUDIT_LOG_ADMIN", 0x00000200)
POLICY_SERVER_ADMIN = make_flag("POLICY_SERVER_ADMIN", 0x00000400)
POLICY_LOOKUP_NAMES = make_flag("POLICY_LOOKUP_NAMES", 0x00000800)
POLICY_NOTIFICATION = make_flag("POLICY_NOTIFICATION", 0x00001000)
POLICY_ALL_ACCESS = make_flag("POLICY_ALL_ACCESS", ( STANDARD_RIGHTS_REQUIRED | POLICY_VIEW_LOCAL_INFORMATION | POLICY_VIEW_AUDIT_INFORMATION | POLICY_GET_PRIVATE_INFORMATION | POLICY_TRUST_ADMIN | POLICY_CREATE_ACCOUNT | POLICY_CREATE_SECRET | POLICY_CREATE_PRIVILEGE | POLICY_SET_DEFAULT_QUOTA_LIMITS | POLICY_SET_AUDIT_REQUIREMENTS | POLICY_AUDIT_LOG_ADMIN | POLICY_SERVER_ADMIN | POLICY_LOOKUP_NAMES ))
IMAGE_DLLCHARACTERISTICS_HIGH_ENTROPY_VA = make_flag("IMAGE_DLLCHARACTERISTICS_HIGH_ENTROPY_VA", 0x0020)
IMAGE_DLLCHARACTERISTICS_DYNAMIC_BASE = make_flag("IMAGE_DLLCHARACTERISTICS_DYNAMIC_BASE", 0x0040)
IMAGE_DLLCHARACTERISTICS_FORCE_INTEGRITY = make_flag("IMAGE_DLLCHARACTERISTICS_FORCE_INTEGRITY", 0x0080)
IMAGE_DLLCHARACTERISTICS_NX_COMPAT = make_flag("IMAGE_DLLCHARACTERISTICS_NX_COMPAT", 0x0100)
IMAGE_DLLCHARACTERISTICS_NO_ISOLATION = make_flag("IMAGE_DLLCHARACTERISTICS_NO_ISOLATION", 0x0200)
IMAGE_DLLCHARACTERISTICS_NO_SEH = make_flag("IMAGE_DLLCHARACTERISTICS_NO_SEH", 0x0400)
IMAGE_DLLCHARACTERISTICS_NO_BIND = make_flag("IMAGE_DLLCHARACTERISTICS_NO_BIND", 0x0800)
IMAGE_DLLCHARACTERISTICS_APPCONTAINER = make_flag("IMAGE_DLLCHARACTERISTICS_APPCONTAINER", 0x1000)
IMAGE_DLLCHARACTERISTICS_WDM_DRIVER = make_flag("IMAGE_DLLCHARACTERISTICS_WDM_DRIVER", 0x2000)
IMAGE_DLLCHARACTERISTICS_GUARD_CF = make_flag("IMAGE_DLLCHARACTERISTICS_GUARD_CF", 0x4000)
IMAGE_DLLCHARACTERISTICS_TERMINAL_SERVER_AWARE = make_flag("IMAGE_DLLCHARACTERISTICS_TERMINAL_SERVER_AWARE", 0x8000)
IMAGE_DIRECTORY_ENTRY_EXPORT = make_flag("IMAGE_DIRECTORY_ENTRY_EXPORT", 0)
IMAGE_DIRECTORY_ENTRY_IMPORT = make_flag("IMAGE_DIRECTORY_ENTRY_IMPORT", 1)
IMAGE_DIRECTORY_ENTRY_RESOURCE = make_flag("IMAGE_DIRECTORY_ENTRY_RESOURCE", 2)
IMAGE_DIRECTORY_ENTRY_EXCEPTION = make_flag("IMAGE_DIRECTORY_ENTRY_EXCEPTION", 3)
IMAGE_DIRECTORY_ENTRY_SECURITY = make_flag("IMAGE_DIRECTORY_ENTRY_SECURITY", 4)
IMAGE_DIRECTORY_ENTRY_BASERELOC = make_flag("IMAGE_DIRECTORY_ENTRY_BASERELOC", 5)
IMAGE_DIRECTORY_ENTRY_DEBUG = make_flag("IMAGE_DIRECTORY_ENTRY_DEBUG", 6)
IMAGE_DIRECTORY_ENTRY_ARCHITECTURE = make_flag("IMAGE_DIRECTORY_ENTRY_ARCHITECTURE", 7)
IMAGE_DIRECTORY_ENTRY_GLOBALPTR = make_flag("IMAGE_DIRECTORY_ENTRY_GLOBALPTR", 8)
IMAGE_DIRECTORY_ENTRY_TLS = make_flag("IMAGE_DIRECTORY_ENTRY_TLS", 9)
IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG = make_flag("IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG", 10)
IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT = make_flag("IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT", 11)
IMAGE_DIRECTORY_ENTRY_IAT = make_flag("IMAGE_DIRECTORY_ENTRY_IAT", 12)
IMAGE_DIRECTORY_ENTRY_DELAY_IMPORT = make_flag("IMAGE_DIRECTORY_ENTRY_DELAY_IMPORT", 13)
IMAGE_DIRECTORY_ENTRY_COM_DESCRIPTOR = make_flag("IMAGE_DIRECTORY_ENTRY_COM_DESCRIPTOR", 14)
IMAGE_REL_BASED_ABSOLUTE = make_flag("IMAGE_REL_BASED_ABSOLUTE", 0)
IMAGE_REL_BASED_HIGH = make_flag("IMAGE_REL_BASED_HIGH", 1)
IMAGE_REL_BASED_LOW = make_flag("IMAGE_REL_BASED_LOW", 2)
IMAGE_REL_BASED_HIGHLOW = make_flag("IMAGE_REL_BASED_HIGHLOW", 3)
IMAGE_REL_BASED_HIGHADJ = make_flag("IMAGE_REL_BASED_HIGHADJ", 4)
IMAGE_REL_BASED_MACHINE_SPECIFIC_5 = make_flag("IMAGE_REL_BASED_MACHINE_SPECIFIC_5", 5)
IMAGE_REL_BASED_RESERVED = make_flag("IMAGE_REL_BASED_RESERVED", 6)
IMAGE_REL_BASED_MACHINE_SPECIFIC_7 = make_flag("IMAGE_REL_BASED_MACHINE_SPECIFIC_7", 7)
IMAGE_REL_BASED_MACHINE_SPECIFIC_8 = make_flag("IMAGE_REL_BASED_MACHINE_SPECIFIC_8", 8)
IMAGE_REL_BASED_MACHINE_SPECIFIC_9 = make_flag("IMAGE_REL_BASED_MACHINE_SPECIFIC_9", 9)
IMAGE_REL_BASED_DIR64 = make_flag("IMAGE_REL_BASED_DIR64", 10)
SERVICE_TRIGGER_TYPE_DEVICE_INTERFACE_ARRIVAL = make_flag("SERVICE_TRIGGER_TYPE_DEVICE_INTERFACE_ARRIVAL", 1)
SERVICE_TRIGGER_TYPE_IP_ADDRESS_AVAILABILITY = make_flag("SERVICE_TRIGGER_TYPE_IP_ADDRESS_AVAILABILITY", 2)
SERVICE_TRIGGER_TYPE_DOMAIN_JOIN = make_flag("SERVICE_TRIGGER_TYPE_DOMAIN_JOIN", 3)
SERVICE_TRIGGER_TYPE_FIREWALL_PORT_EVENT = make_flag("SERVICE_TRIGGER_TYPE_FIREWALL_PORT_EVENT", 4)
SERVICE_TRIGGER_TYPE_GROUP_POLICY = make_flag("SERVICE_TRIGGER_TYPE_GROUP_POLICY", 5)
SERVICE_TRIGGER_TYPE_NETWORK_ENDPOINT = make_flag("SERVICE_TRIGGER_TYPE_NETWORK_ENDPOINT", 6)
SERVICE_TRIGGER_TYPE_CUSTOM_SYSTEM_STATE_CHANGE = make_flag("SERVICE_TRIGGER_TYPE_CUSTOM_SYSTEM_STATE_CHANGE", 7)
SERVICE_TRIGGER_TYPE_CUSTOM = make_flag("SERVICE_TRIGGER_TYPE_CUSTOM", 20)
SERVICE_TRIGGER_DATA_TYPE_BINARY = make_flag("SERVICE_TRIGGER_DATA_TYPE_BINARY", 1)
SERVICE_TRIGGER_DATA_TYPE_STRING = make_flag("SERVICE_TRIGGER_DATA_TYPE_STRING", 2)
SERVICE_TRIGGER_DATA_TYPE_LEVEL = make_flag("SERVICE_TRIGGER_DATA_TYPE_LEVEL", 3)
SERVICE_TRIGGER_DATA_TYPE_KEYWORD_ANY = make_flag("SERVICE_TRIGGER_DATA_TYPE_KEYWORD_ANY", 4)
SERVICE_TRIGGER_DATA_TYPE_KEYWORD_ALL = make_flag("SERVICE_TRIGGER_DATA_TYPE_KEYWORD_ALL", 5)
SERVICE_RUNS_IN_SYSTEM_PROCESS = make_flag("SERVICE_RUNS_IN_SYSTEM_PROCESS", 0x00000001)
SERVICE_KERNEL_DRIVER = make_flag("SERVICE_KERNEL_DRIVER", 0x00000001)
SERVICE_FILE_SYSTEM_DRIVER = make_flag("SERVICE_FILE_SYSTEM_DRIVER", 0x00000002)
SERVICE_ADAPTER = make_flag("SERVICE_ADAPTER", 0x00000004)
SERVICE_RECOGNIZER_DRIVER = make_flag("SERVICE_RECOGNIZER_DRIVER", 0x00000008)
SERVICE_DRIVER = make_flag("SERVICE_DRIVER", ( SERVICE_KERNEL_DRIVER | SERVICE_FILE_SYSTEM_DRIVER | SERVICE_RECOGNIZER_DRIVER ))
SERVICE_WIN32_OWN_PROCESS = make_flag("SERVICE_WIN32_OWN_PROCESS", 0x00000010)
SERVICE_WIN32_SHARE_PROCESS = make_flag("SERVICE_WIN32_SHARE_PROCESS", 0x00000020)
SERVICE_USER_OWN_PROCESS = make_flag("SERVICE_USER_OWN_PROCESS", 0x00000050)
SERVICE_USER_SHARE_PROCESS = make_flag("SERVICE_USER_SHARE_PROCESS", 0x00000060)
SERVICE_WIN32 = make_flag("SERVICE_WIN32", ( SERVICE_WIN32_OWN_PROCESS | SERVICE_WIN32_SHARE_PROCESS ))
SERVICE_INTERACTIVE_PROCESS = make_flag("SERVICE_INTERACTIVE_PROCESS", 0x00000100)
SERVICE_TYPE_ALL = make_flag("SERVICE_TYPE_ALL", ( SERVICE_WIN32 | SERVICE_ADAPTER | SERVICE_DRIVER | SERVICE_INTERACTIVE_PROCESS ))
SERVICE_BOOT_START = make_flag("SERVICE_BOOT_START", 0x00000000)
SERVICE_SYSTEM_START = make_flag("SERVICE_SYSTEM_START", 0x00000001)
SERVICE_AUTO_START = make_flag("SERVICE_AUTO_START", 0x00000002)
SERVICE_DEMAND_START = make_flag("SERVICE_DEMAND_START", 0x00000003)
SERVICE_DISABLED = make_flag("SERVICE_DISABLED", 0x00000004)
SERVICE_ERROR_IGNORE = make_flag("SERVICE_ERROR_IGNORE", 0x00000000)
SERVICE_ERROR_NORMAL = make_flag("SERVICE_ERROR_NORMAL", 0x00000001)
SERVICE_ERROR_SEVERE = make_flag("SERVICE_ERROR_SEVERE", 0x00000002)
SERVICE_ERROR_CRITICAL = make_flag("SERVICE_ERROR_CRITICAL", 0x00000003)
SERVICE_ACTIVE = make_flag("SERVICE_ACTIVE", 0x00000001)
SERVICE_INACTIVE = make_flag("SERVICE_INACTIVE", 0x00000002)
SERVICE_STATE_ALL = make_flag("SERVICE_STATE_ALL", ( SERVICE_ACTIVE | SERVICE_INACTIVE ))
SERVICE_CONTROL_STOP = make_flag("SERVICE_CONTROL_STOP", 0x00000001)
SERVICE_CONTROL_PAUSE = make_flag("SERVICE_CONTROL_PAUSE", 0x00000002)
SERVICE_CONTROL_CONTINUE = make_flag("SERVICE_CONTROL_CONTINUE", 0x00000003)
SERVICE_CONTROL_INTERROGATE = make_flag("SERVICE_CONTROL_INTERROGATE", 0x00000004)
SERVICE_CONTROL_SHUTDOWN = make_flag("SERVICE_CONTROL_SHUTDOWN", 0x00000005)
SERVICE_CONTROL_PARAMCHANGE = make_flag("SERVICE_CONTROL_PARAMCHANGE", 0x00000006)
SERVICE_CONTROL_NETBINDADD = make_flag("SERVICE_CONTROL_NETBINDADD", 0x00000007)
SERVICE_CONTROL_NETBINDREMOVE = make_flag("SERVICE_CONTROL_NETBINDREMOVE", 0x00000008)
SERVICE_CONTROL_NETBINDENABLE = make_flag("SERVICE_CONTROL_NETBINDENABLE", 0x00000009)
SERVICE_CONTROL_NETBINDDISABLE = make_flag("SERVICE_CONTROL_NETBINDDISABLE", 0x0000000A)
SERVICE_CONTROL_DEVICEEVENT = make_flag("SERVICE_CONTROL_DEVICEEVENT", 0x0000000B)
SERVICE_CONTROL_HARDWAREPROFILECHANGE = make_flag("SERVICE_CONTROL_HARDWAREPROFILECHANGE", 0x0000000C)
SERVICE_CONTROL_POWEREVENT = make_flag("SERVICE_CONTROL_POWEREVENT", 0x0000000D)
SERVICE_CONTROL_SESSIONCHANGE = make_flag("SERVICE_CONTROL_SESSIONCHANGE", 0x0000000E)
SERVICE_CONTROL_PRESHUTDOWN = make_flag("SERVICE_CONTROL_PRESHUTDOWN", 0x0000000F)
SERVICE_CONTROL_TIMECHANGE = make_flag("SERVICE_CONTROL_TIMECHANGE", 0x00000010)
SERVICE_CONTROL_TRIGGEREVENT = make_flag("SERVICE_CONTROL_TRIGGEREVENT", 0x00000020)
SERVICE_STOPPED = make_flag("SERVICE_STOPPED", 0x00000001)
SERVICE_START_PENDING = make_flag("SERVICE_START_PENDING", 0x00000002)
SERVICE_STOP_PENDING = make_flag("SERVICE_STOP_PENDING", 0x00000003)
SERVICE_RUNNING = make_flag("SERVICE_RUNNING", 0x00000004)
SERVICE_CONTINUE_PENDING = make_flag("SERVICE_CONTINUE_PENDING", 0x00000005)
SERVICE_PAUSE_PENDING = make_flag("SERVICE_PAUSE_PENDING", 0x00000006)
SERVICE_PAUSED = make_flag("SERVICE_PAUSED", 0x00000007)
SERVICE_ACCEPT_STOP = make_flag("SERVICE_ACCEPT_STOP", 0x00000001)
SERVICE_ACCEPT_PAUSE_CONTINUE = make_flag("SERVICE_ACCEPT_PAUSE_CONTINUE", 0x00000002)
SERVICE_ACCEPT_SHUTDOWN = make_flag("SERVICE_ACCEPT_SHUTDOWN", 0x00000004)
SERVICE_ACCEPT_PARAMCHANGE = make_flag("SERVICE_ACCEPT_PARAMCHANGE", 0x00000008)
SERVICE_ACCEPT_NETBINDCHANGE = make_flag("SERVICE_ACCEPT_NETBINDCHANGE", 0x00000010)
SERVICE_ACCEPT_HARDWAREPROFILECHANGE = make_flag("SERVICE_ACCEPT_HARDWAREPROFILECHANGE", 0x00000020)
SERVICE_ACCEPT_POWEREVENT = make_flag("SERVICE_ACCEPT_POWEREVENT", 0x00000040)
SERVICE_ACCEPT_SESSIONCHANGE = make_flag("SERVICE_ACCEPT_SESSIONCHANGE", 0x00000080)
SERVICE_ACCEPT_PRESHUTDOWN = make_flag("SERVICE_ACCEPT_PRESHUTDOWN", 0x00000100)
SERVICE_ACCEPT_TIMECHANGE = make_flag("SERVICE_ACCEPT_TIMECHANGE", 0x00000200)
SERVICE_ACCEPT_TRIGGEREVENT = make_flag("SERVICE_ACCEPT_TRIGGEREVENT", 0x00000400)
CWCSTORAGENAME = make_flag("CWCSTORAGENAME", 32)
STGM_DIRECT = make_flag("STGM_DIRECT", 0x00000000)
STGM_TRANSACTED = make_flag("STGM_TRANSACTED", 0x00010000)
STGM_SIMPLE = make_flag("STGM_SIMPLE", 0x08000000)
STGM_READ = make_flag("STGM_READ", 0x00000000)
STGM_WRITE = make_flag("STGM_WRITE", 0x00000001)
STGM_READWRITE = make_flag("STGM_READWRITE", 0x00000002)
STGM_SHARE_DENY_NONE = make_flag("STGM_SHARE_DENY_NONE", 0x00000040)
STGM_SHARE_DENY_READ = make_flag("STGM_SHARE_DENY_READ", 0x00000030)
STGM_SHARE_DENY_WRITE = make_flag("STGM_SHARE_DENY_WRITE", 0x00000020)
STGM_SHARE_EXCLUSIVE = make_flag("STGM_SHARE_EXCLUSIVE", 0x00000010)
STGM_PRIORITY = make_flag("STGM_PRIORITY", 0x00040000)
STGM_DELETEONRELEASE = make_flag("STGM_DELETEONRELEASE", 0x04000000)
STGM_NOSCRATCH = make_flag("STGM_NOSCRATCH", 0x00100000)
STGM_CREATE = make_flag("STGM_CREATE", 0x00001000)
STGM_CONVERT = make_flag("STGM_CONVERT", 0x00020000)
STGM_FAILIFTHERE = make_flag("STGM_FAILIFTHERE", 0x00000000)
STGM_NOSNAPSHOT = make_flag("STGM_NOSNAPSHOT", 0x00200000)
STGM_DIRECT_SWMR = make_flag("STGM_DIRECT_SWMR", 0x00400000)
ASYNC_MODE_COMPATIBILITY = make_flag("ASYNC_MODE_COMPATIBILITY", 0x00000001)
ASYNC_MODE_DEFAULT = make_flag("ASYNC_MODE_DEFAULT", 0x00000000)
STGTY_REPEAT = make_flag("STGTY_REPEAT", 0x00000100)
STG_TOEND = make_flag("STG_TOEND", 0xFFFFFFFF)
STG_LAYOUT_SEQUENTIAL = make_flag("STG_LAYOUT_SEQUENTIAL", 0x00000000)
STG_LAYOUT_INTERLEAVED = make_flag("STG_LAYOUT_INTERLEAVED", 0x00000001)
STGFMT_STORAGE = make_flag("STGFMT_STORAGE", 0)
STGFMT_NATIVE = make_flag("STGFMT_NATIVE", 1)
STGFMT_FILE = make_flag("STGFMT_FILE", 3)
STGFMT_ANY = make_flag("STGFMT_ANY", 4)
STGFMT_DOCFILE = make_flag("STGFMT_DOCFILE", 5)
STGFMT_DOCUMENT = make_flag("STGFMT_DOCUMENT", 0)
FILE_VER_GET_LOCALISED = make_flag("FILE_VER_GET_LOCALISED", 0x01)
FILE_VER_GET_NEUTRAL = make_flag("FILE_VER_GET_NEUTRAL", 0x02)
FILE_VER_GET_PREFETCHED = make_flag("FILE_VER_GET_PREFETCHED", 0x04)
szOID_TRUSTED_CODESIGNING_CA_LIST = make_flag("szOID_TRUSTED_CODESIGNING_CA_LIST", "1.3.6.1.4.1.311.2.2.1")
szOID_TRUSTED_CLIENT_AUTH_CA_LIST = make_flag("szOID_TRUSTED_CLIENT_AUTH_CA_LIST", "1.3.6.1.4.1.311.2.2.2")
szOID_TRUSTED_SERVER_AUTH_CA_LIST = make_flag("szOID_TRUSTED_SERVER_AUTH_CA_LIST", "1.3.6.1.4.1.311.2.2.3")
szOID_RSA = make_flag("szOID_RSA", "1.2.840.113549")
szOID_PKCS = make_flag("szOID_PKCS", "1.2.840.113549.1")
szOID_RSA_HASH = make_flag("szOID_RSA_HASH", "1.2.840.113549.2")
szOID_RSA_ENCRYPT = make_flag("szOID_RSA_ENCRYPT", "1.2.840.113549.3")
szOID_PKCS_1 = make_flag("szOID_PKCS_1", "1.2.840.113549.1.1")
szOID_PKCS_2 = make_flag("szOID_PKCS_2", "1.2.840.113549.1.2")
szOID_PKCS_3 = make_flag("szOID_PKCS_3", "1.2.840.113549.1.3")
szOID_PKCS_4 = make_flag("szOID_PKCS_4", "1.2.840.113549.1.4")
szOID_PKCS_5 = make_flag("szOID_PKCS_5", "1.2.840.113549.1.5")
szOID_PKCS_6 = make_flag("szOID_PKCS_6", "1.2.840.113549.1.6")
szOID_PKCS_7 = make_flag("szOID_PKCS_7", "1.2.840.113549.1.7")
szOID_PKCS_8 = make_flag("szOID_PKCS_8", "1.2.840.113549.1.8")
szOID_PKCS_9 = make_flag("szOID_PKCS_9", "1.2.840.113549.1.9")
szOID_PKCS_10 = make_flag("szOID_PKCS_10", "1.2.840.113549.1.10")
szOID_PKCS_12 = make_flag("szOID_PKCS_12", "1.2.840.113549.1.12")
szOID_RSA_RSA = make_flag("szOID_RSA_RSA", "1.2.840.113549.1.1.1")
szOID_RSA_MD2RSA = make_flag("szOID_RSA_MD2RSA", "1.2.840.113549.1.1.2")
szOID_RSA_MD4RSA = make_flag("szOID_RSA_MD4RSA", "1.2.840.113549.1.1.3")
szOID_RSA_MD5RSA = make_flag("szOID_RSA_MD5RSA", "1.2.840.113549.1.1.4")
szOID_RSA_SHA1RSA = make_flag("szOID_RSA_SHA1RSA", "1.2.840.113549.1.1.5")
szOID_RSA_SETOAEP_RSA = make_flag("szOID_RSA_SETOAEP_RSA", "1.2.840.113549.1.1.6")
szOID_RSAES_OAEP = make_flag("szOID_RSAES_OAEP", "1.2.840.113549.1.1.7")
szOID_RSA_MGF1 = make_flag("szOID_RSA_MGF1", "1.2.840.113549.1.1.8")
szOID_RSA_PSPECIFIED = make_flag("szOID_RSA_PSPECIFIED", "1.2.840.113549.1.1.9")
szOID_RSA_SSA_PSS = make_flag("szOID_RSA_SSA_PSS", "1.2.840.113549.1.1.10")
szOID_RSA_SHA256RSA = make_flag("szOID_RSA_SHA256RSA", "1.2.840.113549.1.1.11")
szOID_RSA_SHA384RSA = make_flag("szOID_RSA_SHA384RSA", "1.2.840.113549.1.1.12")
szOID_RSA_SHA512RSA = make_flag("szOID_RSA_SHA512RSA", "1.2.840.113549.1.1.13")
szOID_RSA_DH = make_flag("szOID_RSA_DH", "1.2.840.113549.1.3.1")
szOID_RSA_data = make_flag("szOID_RSA_data", "1.2.840.113549.1.7.1")
szOID_RSA_signedData = make_flag("szOID_RSA_signedData", "1.2.840.113549.1.7.2")
szOID_RSA_envelopedData = make_flag("szOID_RSA_envelopedData", "1.2.840.113549.1.7.3")
szOID_RSA_signEnvData = make_flag("szOID_RSA_signEnvData", "1.2.840.113549.1.7.4")
szOID_RSA_digestedData = make_flag("szOID_RSA_digestedData", "1.2.840.113549.1.7.5")
szOID_RSA_hashedData = make_flag("szOID_RSA_hashedData", "1.2.840.113549.1.7.5")
szOID_RSA_encryptedData = make_flag("szOID_RSA_encryptedData", "1.2.840.113549.1.7.6")
szOID_RSA_emailAddr = make_flag("szOID_RSA_emailAddr", "1.2.840.113549.1.9.1")
szOID_RSA_unstructName = make_flag("szOID_RSA_unstructName", "1.2.840.113549.1.9.2")
szOID_RSA_contentType = make_flag("szOID_RSA_contentType", "1.2.840.113549.1.9.3")
szOID_RSA_messageDigest = make_flag("szOID_RSA_messageDigest", "1.2.840.113549.1.9.4")
szOID_RSA_signingTime = make_flag("szOID_RSA_signingTime", "1.2.840.113549.1.9.5")
szOID_RSA_counterSign = make_flag("szOID_RSA_counterSign", "1.2.840.113549.1.9.6")
szOID_RSA_challengePwd = make_flag("szOID_RSA_challengePwd", "1.2.840.113549.1.9.7")
szOID_RSA_unstructAddr = make_flag("szOID_RSA_unstructAddr", "1.2.840.113549.1.9.8")
szOID_RSA_extCertAttrs = make_flag("szOID_RSA_extCertAttrs", "1.2.840.113549.1.9.9")
szOID_RSA_certExtensions = make_flag("szOID_RSA_certExtensions", "1.2.840.113549.1.9.14")
szOID_RSA_SMIMECapabilities = make_flag("szOID_RSA_SMIMECapabilities", "1.2.840.113549.1.9.15")
szOID_RSA_preferSignedData = make_flag("szOID_RSA_preferSignedData", "1.2.840.113549.1.9.15.1")
szOID_TIMESTAMP_TOKEN = make_flag("szOID_TIMESTAMP_TOKEN", "1.2.840.113549.1.9.16.1.4")
szOID_RFC3161_counterSign = make_flag("szOID_RFC3161_counterSign", "1.3.6.1.4.1.311.3.3.1")
szOID_RSA_SMIMEalg = make_flag("szOID_RSA_SMIMEalg", "1.2.840.113549.1.9.16.3")
szOID_RSA_SMIMEalgESDH = make_flag("szOID_RSA_SMIMEalgESDH", "1.2.840.113549.1.9.16.3.5")
szOID_RSA_SMIMEalgCMS3DESwrap = make_flag("szOID_RSA_SMIMEalgCMS3DESwrap", "1.2.840.113549.1.9.16.3.6")
szOID_RSA_SMIMEalgCMSRC2wrap = make_flag("szOID_RSA_SMIMEalgCMSRC2wrap", "1.2.840.113549.1.9.16.3.7")
szOID_RSA_MD2 = make_flag("szOID_RSA_MD2", "1.2.840.113549.2.2")
szOID_RSA_MD4 = make_flag("szOID_RSA_MD4", "1.2.840.113549.2.4")
szOID_RSA_MD5 = make_flag("szOID_RSA_MD5", "1.2.840.113549.2.5")
szOID_RSA_RC2CBC = make_flag("szOID_RSA_RC2CBC", "1.2.840.113549.3.2")
szOID_RSA_RC4 = make_flag("szOID_RSA_RC4", "1.2.840.113549.3.4")
szOID_RSA_DES_EDE3_CBC = make_flag("szOID_RSA_DES_EDE3_CBC", "1.2.840.113549.3.7")
szOID_RSA_RC5_CBCPad = make_flag("szOID_RSA_RC5_CBCPad", "1.2.840.113549.3.9")
szOID_ANSI_X942 = make_flag("szOID_ANSI_X942", "1.2.840.10046")
szOID_ANSI_X942_DH = make_flag("szOID_ANSI_X942_DH", "1.2.840.10046.2.1")
szOID_X957 = make_flag("szOID_X957", "1.2.840.10040")
szOID_X957_DSA = make_flag("szOID_X957_DSA", "1.2.840.10040.4.1")
szOID_X957_SHA1DSA = make_flag("szOID_X957_SHA1DSA", "1.2.840.10040.4.3")
szOID_ECC_PUBLIC_KEY = make_flag("szOID_ECC_PUBLIC_KEY", "1.2.840.10045.2.1")
szOID_ECC_CURVE_P256 = make_flag("szOID_ECC_CURVE_P256", "1.2.840.10045.3.1.7")
szOID_ECC_CURVE_P384 = make_flag("szOID_ECC_CURVE_P384", "1.3.132.0.34")
szOID_ECC_CURVE_P521 = make_flag("szOID_ECC_CURVE_P521", "1.3.132.0.35")
szOID_ECDSA_SHA1 = make_flag("szOID_ECDSA_SHA1", "1.2.840.10045.4.1")
szOID_ECDSA_SPECIFIED = make_flag("szOID_ECDSA_SPECIFIED", "1.2.840.10045.4.3")
szOID_ECDSA_SHA256 = make_flag("szOID_ECDSA_SHA256", "1.2.840.10045.4.3.2")
szOID_ECDSA_SHA384 = make_flag("szOID_ECDSA_SHA384", "1.2.840.10045.4.3.3")
szOID_ECDSA_SHA512 = make_flag("szOID_ECDSA_SHA512", "1.2.840.10045.4.3.4")
szOID_NIST_AES128_CBC = make_flag("szOID_NIST_AES128_CBC", "2.16.840.1.101.3.4.1.2")
szOID_NIST_AES192_CBC = make_flag("szOID_NIST_AES192_CBC", "2.16.840.1.101.3.4.1.22")
szOID_NIST_AES256_CBC = make_flag("szOID_NIST_AES256_CBC", "2.16.840.1.101.3.4.1.42")
szOID_NIST_AES128_WRAP = make_flag("szOID_NIST_AES128_WRAP", "2.16.840.1.101.3.4.1.5")
szOID_NIST_AES192_WRAP = make_flag("szOID_NIST_AES192_WRAP", "2.16.840.1.101.3.4.1.25")
szOID_NIST_AES256_WRAP = make_flag("szOID_NIST_AES256_WRAP", "2.16.840.1.101.3.4.1.45")
szOID_DH_SINGLE_PASS_STDDH_SHA1_KDF = make_flag("szOID_DH_SINGLE_PASS_STDDH_SHA1_KDF", "1.3.133.16.840.63.0.2")
szOID_DH_SINGLE_PASS_STDDH_SHA256_KDF = make_flag("szOID_DH_SINGLE_PASS_STDDH_SHA256_KDF", "1.3.132.1.11.1")
szOID_DH_SINGLE_PASS_STDDH_SHA384_KDF = make_flag("szOID_DH_SINGLE_PASS_STDDH_SHA384_KDF", "1.3.132.1.11.2")
szOID_DS = make_flag("szOID_DS", "2.5")
szOID_DSALG = make_flag("szOID_DSALG", "2.5.8")
szOID_DSALG_CRPT = make_flag("szOID_DSALG_CRPT", "2.5.8.1")
szOID_DSALG_HASH = make_flag("szOID_DSALG_HASH", "2.5.8.2")
szOID_DSALG_SIGN = make_flag("szOID_DSALG_SIGN", "2.5.8.3")
szOID_DSALG_RSA = make_flag("szOID_DSALG_RSA", "2.5.8.1.1")
szOID_OIW = make_flag("szOID_OIW", "1.3.14")
szOID_OIWSEC = make_flag("szOID_OIWSEC", "1.3.14.3.2")
szOID_OIWSEC_md4RSA = make_flag("szOID_OIWSEC_md4RSA", "1.3.14.3.2.2")
szOID_OIWSEC_md5RSA = make_flag("szOID_OIWSEC_md5RSA", "1.3.14.3.2.3")
szOID_OIWSEC_md4RSA2 = make_flag("szOID_OIWSEC_md4RSA2", "1.3.14.3.2.4")
szOID_OIWSEC_desECB = make_flag("szOID_OIWSEC_desECB", "1.3.14.3.2.6")
szOID_OIWSEC_desCBC = make_flag("szOID_OIWSEC_desCBC", "1.3.14.3.2.7")
szOID_OIWSEC_desOFB = make_flag("szOID_OIWSEC_desOFB", "1.3.14.3.2.8")
szOID_OIWSEC_desCFB = make_flag("szOID_OIWSEC_desCFB", "1.3.14.3.2.9")
szOID_OIWSEC_desMAC = make_flag("szOID_OIWSEC_desMAC", "1.3.14.3.2.10")
szOID_OIWSEC_rsaSign = make_flag("szOID_OIWSEC_rsaSign", "1.3.14.3.2.11")
szOID_OIWSEC_dsa = make_flag("szOID_OIWSEC_dsa", "1.3.14.3.2.12")
szOID_OIWSEC_shaDSA = make_flag("szOID_OIWSEC_shaDSA", "1.3.14.3.2.13")
szOID_OIWSEC_mdc2RSA = make_flag("szOID_OIWSEC_mdc2RSA", "1.3.14.3.2.14")
szOID_OIWSEC_shaRSA = make_flag("szOID_OIWSEC_shaRSA", "1.3.14.3.2.15")
szOID_OIWSEC_dhCommMod = make_flag("szOID_OIWSEC_dhCommMod", "1.3.14.3.2.16")
szOID_OIWSEC_desEDE = make_flag("szOID_OIWSEC_desEDE", "1.3.14.3.2.17")
szOID_OIWSEC_sha = make_flag("szOID_OIWSEC_sha", "1.3.14.3.2.18")
szOID_OIWSEC_mdc2 = make_flag("szOID_OIWSEC_mdc2", "1.3.14.3.2.19")
szOID_OIWSEC_dsaComm = make_flag("szOID_OIWSEC_dsaComm", "1.3.14.3.2.20")
szOID_OIWSEC_dsaCommSHA = make_flag("szOID_OIWSEC_dsaCommSHA", "1.3.14.3.2.21")
szOID_OIWSEC_rsaXchg = make_flag("szOID_OIWSEC_rsaXchg", "1.3.14.3.2.22")
szOID_OIWSEC_keyHashSeal = make_flag("szOID_OIWSEC_keyHashSeal", "1.3.14.3.2.23")
szOID_OIWSEC_md2RSASign = make_flag("szOID_OIWSEC_md2RSASign", "1.3.14.3.2.24")
szOID_OIWSEC_md5RSASign = make_flag("szOID_OIWSEC_md5RSASign", "1.3.14.3.2.25")
szOID_OIWSEC_sha1 = make_flag("szOID_OIWSEC_sha1", "1.3.14.3.2.26")
szOID_OIWSEC_dsaSHA1 = make_flag("szOID_OIWSEC_dsaSHA1", "1.3.14.3.2.27")
szOID_OIWSEC_dsaCommSHA1 = make_flag("szOID_OIWSEC_dsaCommSHA1", "1.3.14.3.2.28")
szOID_OIWSEC_sha1RSASign = make_flag("szOID_OIWSEC_sha1RSASign", "1.3.14.3.2.29")
szOID_OIWDIR = make_flag("szOID_OIWDIR", "1.3.14.7.2")
szOID_OIWDIR_CRPT = make_flag("szOID_OIWDIR_CRPT", "1.3.14.7.2.1")
szOID_OIWDIR_HASH = make_flag("szOID_OIWDIR_HASH", "1.3.14.7.2.2")
szOID_OIWDIR_SIGN = make_flag("szOID_OIWDIR_SIGN", "1.3.14.7.2.3")
szOID_OIWDIR_md2 = make_flag("szOID_OIWDIR_md2", "1.3.14.7.2.2.1")
szOID_OIWDIR_md2RSA = make_flag("szOID_OIWDIR_md2RSA", "1.3.14.7.2.3.1")
szOID_INFOSEC = make_flag("szOID_INFOSEC", "2.16.840.1.101.2.1")
szOID_INFOSEC_sdnsSignature = make_flag("szOID_INFOSEC_sdnsSignature", "2.16.840.1.101.2.1.1.1")
szOID_INFOSEC_mosaicSignature = make_flag("szOID_INFOSEC_mosaicSignature", "2.16.840.1.101.2.1.1.2")
szOID_INFOSEC_sdnsConfidentiality = make_flag("szOID_INFOSEC_sdnsConfidentiality", "2.16.840.1.101.2.1.1.3")
szOID_INFOSEC_mosaicConfidentiality = make_flag("szOID_INFOSEC_mosaicConfidentiality", "2.16.840.1.101.2.1.1.4")
szOID_INFOSEC_sdnsIntegrity = make_flag("szOID_INFOSEC_sdnsIntegrity", "2.16.840.1.101.2.1.1.5")
szOID_INFOSEC_mosaicIntegrity = make_flag("szOID_INFOSEC_mosaicIntegrity", "2.16.840.1.101.2.1.1.6")
szOID_INFOSEC_sdnsTokenProtection = make_flag("szOID_INFOSEC_sdnsTokenProtection", "2.16.840.1.101.2.1.1.7")
szOID_INFOSEC_mosaicTokenProtection = make_flag("szOID_INFOSEC_mosaicTokenProtection", "2.16.840.1.101.2.1.1.8")
szOID_INFOSEC_sdnsKeyManagement = make_flag("szOID_INFOSEC_sdnsKeyManagement", "2.16.840.1.101.2.1.1.9")
szOID_INFOSEC_mosaicKeyManagement = make_flag("szOID_INFOSEC_mosaicKeyManagement", "2.16.840.1.101.2.1.1.10")
szOID_INFOSEC_sdnsKMandSig = make_flag("szOID_INFOSEC_sdnsKMandSig", "2.16.840.1.101.2.1.1.11")
szOID_INFOSEC_mosaicKMandSig = make_flag("szOID_INFOSEC_mosaicKMandSig", "2.16.840.1.101.2.1.1.12")
szOID_INFOSEC_SuiteASignature = make_flag("szOID_INFOSEC_SuiteASignature", "2.16.840.1.101.2.1.1.13")
szOID_INFOSEC_SuiteAConfidentiality = make_flag("szOID_INFOSEC_SuiteAConfidentiality", "2.16.840.1.101.2.1.1.14")
szOID_INFOSEC_SuiteAIntegrity = make_flag("szOID_INFOSEC_SuiteAIntegrity", "2.16.840.1.101.2.1.1.15")
szOID_INFOSEC_SuiteATokenProtection = make_flag("szOID_INFOSEC_SuiteATokenProtection", "2.16.840.1.101.2.1.1.16")
szOID_INFOSEC_SuiteAKeyManagement = make_flag("szOID_INFOSEC_SuiteAKeyManagement", "2.16.840.1.101.2.1.1.17")
szOID_INFOSEC_SuiteAKMandSig = make_flag("szOID_INFOSEC_SuiteAKMandSig", "2.16.840.1.101.2.1.1.18")
szOID_INFOSEC_mosaicUpdatedSig = make_flag("szOID_INFOSEC_mosaicUpdatedSig", "2.16.840.1.101.2.1.1.19")
szOID_INFOSEC_mosaicKMandUpdSig = make_flag("szOID_INFOSEC_mosaicKMandUpdSig", "2.16.840.1.101.2.1.1.20")
szOID_INFOSEC_mosaicUpdatedInteg = make_flag("szOID_INFOSEC_mosaicUpdatedInteg", "2.16.840.1.101.2.1.1.21")
szOID_NIST_sha256 = make_flag("szOID_NIST_sha256", "2.16.840.1.101.3.4.2.1")
szOID_NIST_sha384 = make_flag("szOID_NIST_sha384", "2.16.840.1.101.3.4.2.2")
szOID_NIST_sha512 = make_flag("szOID_NIST_sha512", "2.16.840.1.101.3.4.2.3")
SPC_PE_IMAGE_PAGE_HASHES_V1_OBJID = make_flag("SPC_PE_IMAGE_PAGE_HASHES_V1_OBJID", "1.3.6.1.4.1.311.2.3.1")
SPC_PE_IMAGE_PAGE_HASHES_V2_OBJID = make_flag("SPC_PE_IMAGE_PAGE_HASHES_V2_OBJID", "1.3.6.1.4.1.311.2.3.2")
szOID_NESTED_SIGNATURE = make_flag("szOID_NESTED_SIGNATURE", "1.3.6.1.4.1.311.2.4.1")
szOID_INTENT_TO_SEAL = make_flag("szOID_INTENT_TO_SEAL", "1.3.6.1.4.1.311.2.4.2")
szOID_SEALING_SIGNATURE = make_flag("szOID_SEALING_SIGNATURE", "1.3.6.1.4.1.311.2.4.3")
szOID_SEALING_TIMESTAMP = make_flag("szOID_SEALING_TIMESTAMP", "1.3.6.1.4.1.311.2.4.4")
szOID_ENHANCED_HASH = make_flag("szOID_ENHANCED_HASH", "1.3.6.1.4.1.311.2.5.1")
szOID_PKCS_9_SEQUENCE_NUMBER = make_flag("szOID_PKCS_9_SEQUENCE_NUMBER", "1.2.840.113549.1.9.25.4")
CAT_NAMEVALUE_OBJID = make_flag("CAT_NAMEVALUE_OBJID", "1.3.6.1.4.1.311.12.2.1")
CAT_MEMBERINFO_OBJID = make_flag("CAT_MEMBERINFO_OBJID", "1.3.6.1.4.1.311.12.2.2")
CAT_MEMBERINFO2_OBJID = make_flag("CAT_MEMBERINFO2_OBJID", "1.3.6.1.4.1.311.12.2.3")
szOID_COMMON_NAME = make_flag("szOID_COMMON_NAME", "2.5.4.3")
SPC_COMMON_NAME_OBJID = make_flag("SPC_COMMON_NAME_OBJID", szOID_COMMON_NAME)
SPC_TIME_STAMP_REQUEST_OBJID = make_flag("SPC_TIME_STAMP_REQUEST_OBJID", "1.3.6.1.4.1.311.3.2.1")
SPC_INDIRECT_DATA_OBJID = make_flag("SPC_INDIRECT_DATA_OBJID", "1.3.6.1.4.1.311.2.1.4")
SPC_SP_AGENCY_INFO_OBJID = make_flag("SPC_SP_AGENCY_INFO_OBJID", "1.3.6.1.4.1.311.2.1.10")
SPC_STATEMENT_TYPE_OBJID = make_flag("SPC_STATEMENT_TYPE_OBJID", "1.3.6.1.4.1.311.2.1.11")
SPC_SP_OPUS_INFO_OBJID = make_flag("SPC_SP_OPUS_INFO_OBJID", "1.3.6.1.4.1.311.2.1.12")
SPC_CERT_EXTENSIONS_OBJID = make_flag("SPC_CERT_EXTENSIONS_OBJID", "1.3.6.1.4.1.311.2.1.14")
SPC_PE_IMAGE_DATA_OBJID = make_flag("SPC_PE_IMAGE_DATA_OBJID", "1.3.6.1.4.1.311.2.1.15")
SPC_RAW_FILE_DATA_OBJID = make_flag("SPC_RAW_FILE_DATA_OBJID", "1.3.6.1.4.1.311.2.1.18")
SPC_STRUCTURED_STORAGE_DATA_OBJID = make_flag("SPC_STRUCTURED_STORAGE_DATA_OBJID", "1.3.6.1.4.1.311.2.1.19")
SPC_JAVA_CLASS_DATA_OBJID = make_flag("SPC_JAVA_CLASS_DATA_OBJID", "1.3.6.1.4.1.311.2.1.20")
SPC_INDIVIDUAL_SP_KEY_PURPOSE_OBJID = make_flag("SPC_INDIVIDUAL_SP_KEY_PURPOSE_OBJID", "1.3.6.1.4.1.311.2.1.21")
SPC_COMMERCIAL_SP_KEY_PURPOSE_OBJID = make_flag("SPC_COMMERCIAL_SP_KEY_PURPOSE_OBJID", "1.3.6.1.4.1.311.2.1.22")
SPC_CAB_DATA_OBJID = make_flag("SPC_CAB_DATA_OBJID", "1.3.6.1.4.1.311.2.1.25")
SPC_GLUE_RDN_OBJID = make_flag("SPC_GLUE_RDN_OBJID", "1.3.6.1.4.1.311.2.1.25")
SPC_MINIMAL_CRITERIA_OBJID = make_flag("SPC_MINIMAL_CRITERIA_OBJID", "1.3.6.1.4.1.311.2.1.26")
SPC_FINANCIAL_CRITERIA_OBJID = make_flag("SPC_FINANCIAL_CRITERIA_OBJID", "1.3.6.1.4.1.311.2.1.27")
SPC_LINK_OBJID = make_flag("SPC_LINK_OBJID", "1.3.6.1.4.1.311.2.1.28")
SPC_SIGINFO_OBJID = make_flag("SPC_SIGINFO_OBJID", "1.3.6.1.4.1.311.2.1.30")
