from os.path import abspath, dirname, join, normpath

from setuptools import setup


setup(

    # Basic package information:
    name = 'django-heroku-postgresify',
    version = '0.4.1',
    py_modules = ('postgresify',),

    # Packaging options:
    zip_safe = False,
    include_package_data = True,

    # Package dependencies:
    install_requires = ['Django>=1.2', 'dj-database-url>=0.3.0'],

    # Metadata for PyPI:
    author = 'Randall Degges',
    author_email = 'rdegges@gmail.com',
    license = 'UNLICENSE',
    url = 'https://github.com/rdegges/django-heroku-postgresify',
    keywords = 'django heroku cloud postgresql postgres db database awesome epic',
    description = 'Automatic Django database configuration on Heroku.',
    long_description = open(normpath(join(dirname(abspath(__file__)), 'README.md'))).read(),
    long_description_content_type='text/markdown'

)
