# coding: utf-8

"""
    Selling Partner API for Reports

    The Selling Partner API for Reports lets you retrieve and manage a variety of reports that can help selling partners manage their businesses.  # noqa: E501

    OpenAPI spec version: 2020-09-04
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class CreateReportSpecification(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'report_options': 'ReportOptions',
        'report_type': 'str',
        'data_start_time': 'datetime',
        'data_end_time': 'datetime',
        'marketplace_ids': 'list[str]'
    }

    attribute_map = {
        'report_options': 'reportOptions',
        'report_type': 'reportType',
        'data_start_time': 'dataStartTime',
        'data_end_time': 'dataEndTime',
        'marketplace_ids': 'marketplaceIds'
    }

    def __init__(self, report_options=None, report_type=None, data_start_time=None, data_end_time=None, marketplace_ids=None):  # noqa: E501
        """CreateReportSpecification - a model defined in Swagger"""  # noqa: E501
        self._report_options = None
        self._report_type = None
        self._data_start_time = None
        self._data_end_time = None
        self._marketplace_ids = None
        self.discriminator = None
        if report_options is not None:
            self.report_options = report_options
        self.report_type = report_type
        if data_start_time is not None:
            self.data_start_time = data_start_time
        if data_end_time is not None:
            self.data_end_time = data_end_time
        self.marketplace_ids = marketplace_ids

    @property
    def report_options(self):
        """Gets the report_options of this CreateReportSpecification.  # noqa: E501


        :return: The report_options of this CreateReportSpecification.  # noqa: E501
        :rtype: ReportOptions
        """
        return self._report_options

    @report_options.setter
    def report_options(self, report_options):
        """Sets the report_options of this CreateReportSpecification.


        :param report_options: The report_options of this CreateReportSpecification.  # noqa: E501
        :type: ReportOptions
        """

        self._report_options = report_options

    @property
    def report_type(self):
        """Gets the report_type of this CreateReportSpecification.  # noqa: E501

        The report type.  # noqa: E501

        :return: The report_type of this CreateReportSpecification.  # noqa: E501
        :rtype: str
        """
        return self._report_type

    @report_type.setter
    def report_type(self, report_type):
        """Sets the report_type of this CreateReportSpecification.

        The report type.  # noqa: E501

        :param report_type: The report_type of this CreateReportSpecification.  # noqa: E501
        :type: str
        """
        if report_type is None:
            raise ValueError("Invalid value for `report_type`, must not be `None`")  # noqa: E501

        self._report_type = report_type

    @property
    def data_start_time(self):
        """Gets the data_start_time of this CreateReportSpecification.  # noqa: E501

        The start of a date and time range, in ISO 8601 date time format, used for selecting the data to report. The default is now. The value must be prior to or equal to the current date and time. Not all report types make use of this.  # noqa: E501

        :return: The data_start_time of this CreateReportSpecification.  # noqa: E501
        :rtype: datetime
        """
        return self._data_start_time

    @data_start_time.setter
    def data_start_time(self, data_start_time):
        """Sets the data_start_time of this CreateReportSpecification.

        The start of a date and time range, in ISO 8601 date time format, used for selecting the data to report. The default is now. The value must be prior to or equal to the current date and time. Not all report types make use of this.  # noqa: E501

        :param data_start_time: The data_start_time of this CreateReportSpecification.  # noqa: E501
        :type: datetime
        """

        self._data_start_time = data_start_time

    @property
    def data_end_time(self):
        """Gets the data_end_time of this CreateReportSpecification.  # noqa: E501

        The end of a date and time range, in ISO 8601 date time format, used for selecting the data to report. The default is now. The value must be prior to or equal to the current date and time. Not all report types make use of this.  # noqa: E501

        :return: The data_end_time of this CreateReportSpecification.  # noqa: E501
        :rtype: datetime
        """
        return self._data_end_time

    @data_end_time.setter
    def data_end_time(self, data_end_time):
        """Sets the data_end_time of this CreateReportSpecification.

        The end of a date and time range, in ISO 8601 date time format, used for selecting the data to report. The default is now. The value must be prior to or equal to the current date and time. Not all report types make use of this.  # noqa: E501

        :param data_end_time: The data_end_time of this CreateReportSpecification.  # noqa: E501
        :type: datetime
        """

        self._data_end_time = data_end_time

    @property
    def marketplace_ids(self):
        """Gets the marketplace_ids of this CreateReportSpecification.  # noqa: E501

        A list of marketplace identifiers. The report document's contents will contain data for all of the specified marketplaces, unless the report type indicates otherwise.  # noqa: E501

        :return: The marketplace_ids of this CreateReportSpecification.  # noqa: E501
        :rtype: list[str]
        """
        return self._marketplace_ids

    @marketplace_ids.setter
    def marketplace_ids(self, marketplace_ids):
        """Sets the marketplace_ids of this CreateReportSpecification.

        A list of marketplace identifiers. The report document's contents will contain data for all of the specified marketplaces, unless the report type indicates otherwise.  # noqa: E501

        :param marketplace_ids: The marketplace_ids of this CreateReportSpecification.  # noqa: E501
        :type: list[str]
        """
        if marketplace_ids is None:
            raise ValueError("Invalid value for `marketplace_ids`, must not be `None`")  # noqa: E501

        self._marketplace_ids = marketplace_ids

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateReportSpecification, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateReportSpecification):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
