# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ncbi.datasets.api_client import ApiClient
from ncbi.datasets.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class GeneDatasetDescriptorsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def gene_descriptors_by_accession(self, accessions, **kwargs):  # noqa: E501
        """Retrieve list of descriptions of genes by RefSeq accession  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_descriptors_by_accession(accessions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] accessions: RNA or Protein accessions. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1GeneDescriptors
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gene_descriptors_by_accession_with_http_info(accessions, **kwargs)  # noqa: E501

    def gene_descriptors_by_accession_with_http_info(self, accessions, **kwargs):  # noqa: E501
        """Retrieve list of descriptions of genes by RefSeq accession  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_descriptors_by_accession_with_http_info(accessions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] accessions: RNA or Protein accessions. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1GeneDescriptors, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'accessions'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gene_descriptors_by_accession" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'accessions' is set
        if self.api_client.client_side_validation and ('accessions' not in local_var_params or  # noqa: E501
                                                        local_var_params['accessions'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `accessions` when calling `gene_descriptors_by_accession`")  # noqa: E501

        if self.api_client.client_side_validation and ('accessions' in local_var_params and  # noqa: E501
                                                        len(local_var_params['accessions']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `accessions` when calling `gene_descriptors_by_accession`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'accessions' in local_var_params:
            path_params['accessions'] = local_var_params['accessions']  # noqa: E501
            collection_formats['accessions'] = 'csv'  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/accessions/{accessions}/descriptors', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1GeneDescriptors',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gene_descriptors_by_id(self, gene_ids, **kwargs):  # noqa: E501
        """Retrieve list of descriptions of genes by gene ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_descriptors_by_id(gene_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[int] gene_ids: NCBI Gene ID (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1GeneDescriptors
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gene_descriptors_by_id_with_http_info(gene_ids, **kwargs)  # noqa: E501

    def gene_descriptors_by_id_with_http_info(self, gene_ids, **kwargs):  # noqa: E501
        """Retrieve list of descriptions of genes by gene ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_descriptors_by_id_with_http_info(gene_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[int] gene_ids: NCBI Gene ID (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1GeneDescriptors, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'gene_ids'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gene_descriptors_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'gene_ids' is set
        if self.api_client.client_side_validation and ('gene_ids' not in local_var_params or  # noqa: E501
                                                        local_var_params['gene_ids'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `gene_ids` when calling `gene_descriptors_by_id`")  # noqa: E501

        if self.api_client.client_side_validation and ('gene_ids' in local_var_params and  # noqa: E501
                                                        len(local_var_params['gene_ids']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `gene_ids` when calling `gene_descriptors_by_id`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'gene_ids' in local_var_params:
            path_params['gene_ids'] = local_var_params['gene_ids']  # noqa: E501
            collection_formats['gene_ids'] = 'csv'  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/id/{gene_ids}/descriptors', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1GeneDescriptors',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gene_descriptors_by_tax_and_symbol(self, symbol, tax_token, **kwargs):  # noqa: E501
        """Retrieve list of descriptions of genes by taxonomy and gene symbol  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_descriptors_by_tax_and_symbol(symbol, tax_token, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] symbol: Symbol must also have a tax-token specified (required)
        :param str tax_token: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1GeneDescriptors
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gene_descriptors_by_tax_and_symbol_with_http_info(symbol, tax_token, **kwargs)  # noqa: E501

    def gene_descriptors_by_tax_and_symbol_with_http_info(self, symbol, tax_token, **kwargs):  # noqa: E501
        """Retrieve list of descriptions of genes by taxonomy and gene symbol  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_descriptors_by_tax_and_symbol_with_http_info(symbol, tax_token, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] symbol: Symbol must also have a tax-token specified (required)
        :param str tax_token: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1GeneDescriptors, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'tax_token'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gene_descriptors_by_tax_and_symbol" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `gene_descriptors_by_tax_and_symbol`")  # noqa: E501
        # verify the required parameter 'tax_token' is set
        if self.api_client.client_side_validation and ('tax_token' not in local_var_params or  # noqa: E501
                                                        local_var_params['tax_token'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tax_token` when calling `gene_descriptors_by_tax_and_symbol`")  # noqa: E501

        if self.api_client.client_side_validation and ('symbol' in local_var_params and  # noqa: E501
                                                        len(local_var_params['symbol']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `symbol` when calling `gene_descriptors_by_tax_and_symbol`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'symbol' in local_var_params:
            path_params['symbol'] = local_var_params['symbol']  # noqa: E501
            collection_formats['symbol'] = 'csv'  # noqa: E501
        if 'tax_token' in local_var_params:
            path_params['tax_token'] = local_var_params['tax_token']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/symbol/{symbol}/taxonomy/{tax_token}/descriptors', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1GeneDescriptors',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gene_descriptors_post(self, body, **kwargs):  # noqa: E501
        """Retrieve list of descriptions of genes by POST  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_descriptors_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param V1alpha1GeneDatasetRequest body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1GeneDescriptors
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gene_descriptors_post_with_http_info(body, **kwargs)  # noqa: E501

    def gene_descriptors_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Retrieve list of descriptions of genes by POST  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_descriptors_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param V1alpha1GeneDatasetRequest body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1GeneDescriptors, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gene_descriptors_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `gene_descriptors_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/descriptors', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1GeneDescriptors',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gene_summary_by_accession(self, accessions, **kwargs):  # noqa: E501
        """Summary of gene dataset, including options to download package by RefSeq accession  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_summary_by_accession(accessions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] accessions: RNA or Protein accessions. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1DownloadSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gene_summary_by_accession_with_http_info(accessions, **kwargs)  # noqa: E501

    def gene_summary_by_accession_with_http_info(self, accessions, **kwargs):  # noqa: E501
        """Summary of gene dataset, including options to download package by RefSeq accession  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_summary_by_accession_with_http_info(accessions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] accessions: RNA or Protein accessions. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1DownloadSummary, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'accessions'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gene_summary_by_accession" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'accessions' is set
        if self.api_client.client_side_validation and ('accessions' not in local_var_params or  # noqa: E501
                                                        local_var_params['accessions'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `accessions` when calling `gene_summary_by_accession`")  # noqa: E501

        if self.api_client.client_side_validation and ('accessions' in local_var_params and  # noqa: E501
                                                        len(local_var_params['accessions']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `accessions` when calling `gene_summary_by_accession`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'accessions' in local_var_params:
            path_params['accessions'] = local_var_params['accessions']  # noqa: E501
            collection_formats['accessions'] = 'csv'  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/accessions/{accessions}/summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1DownloadSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gene_summary_by_id(self, gene_ids, **kwargs):  # noqa: E501
        """Summary of gene dataset, including options to download package by gene ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_summary_by_id(gene_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[int] gene_ids: NCBI Gene ID (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1DownloadSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gene_summary_by_id_with_http_info(gene_ids, **kwargs)  # noqa: E501

    def gene_summary_by_id_with_http_info(self, gene_ids, **kwargs):  # noqa: E501
        """Summary of gene dataset, including options to download package by gene ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_summary_by_id_with_http_info(gene_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[int] gene_ids: NCBI Gene ID (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1DownloadSummary, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'gene_ids'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gene_summary_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'gene_ids' is set
        if self.api_client.client_side_validation and ('gene_ids' not in local_var_params or  # noqa: E501
                                                        local_var_params['gene_ids'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `gene_ids` when calling `gene_summary_by_id`")  # noqa: E501

        if self.api_client.client_side_validation and ('gene_ids' in local_var_params and  # noqa: E501
                                                        len(local_var_params['gene_ids']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `gene_ids` when calling `gene_summary_by_id`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'gene_ids' in local_var_params:
            path_params['gene_ids'] = local_var_params['gene_ids']  # noqa: E501
            collection_formats['gene_ids'] = 'csv'  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/id/{gene_ids}/summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1DownloadSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gene_summary_by_tax_and_symbol(self, symbol, tax_token, **kwargs):  # noqa: E501
        """Summary of gene dataset, including options to download package by taxonomy and gene symbol  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_summary_by_tax_and_symbol(symbol, tax_token, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] symbol: Symbol must also have a tax-token specified (required)
        :param str tax_token: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1DownloadSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gene_summary_by_tax_and_symbol_with_http_info(symbol, tax_token, **kwargs)  # noqa: E501

    def gene_summary_by_tax_and_symbol_with_http_info(self, symbol, tax_token, **kwargs):  # noqa: E501
        """Summary of gene dataset, including options to download package by taxonomy and gene symbol  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_summary_by_tax_and_symbol_with_http_info(symbol, tax_token, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] symbol: Symbol must also have a tax-token specified (required)
        :param str tax_token: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1DownloadSummary, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'tax_token'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gene_summary_by_tax_and_symbol" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `gene_summary_by_tax_and_symbol`")  # noqa: E501
        # verify the required parameter 'tax_token' is set
        if self.api_client.client_side_validation and ('tax_token' not in local_var_params or  # noqa: E501
                                                        local_var_params['tax_token'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tax_token` when calling `gene_summary_by_tax_and_symbol`")  # noqa: E501

        if self.api_client.client_side_validation and ('symbol' in local_var_params and  # noqa: E501
                                                        len(local_var_params['symbol']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `symbol` when calling `gene_summary_by_tax_and_symbol`, number of items must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'symbol' in local_var_params:
            path_params['symbol'] = local_var_params['symbol']  # noqa: E501
            collection_formats['symbol'] = 'csv'  # noqa: E501
        if 'tax_token' in local_var_params:
            path_params['tax_token'] = local_var_params['tax_token']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/symbol/{symbol}/taxonomy/{tax_token}/summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1DownloadSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gene_summary_post(self, body, **kwargs):  # noqa: E501
        """Summary of gene dataset, including options to download package by POST  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_summary_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param V1alpha1GeneDatasetRequest body: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1DownloadSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gene_summary_post_with_http_info(body, **kwargs)  # noqa: E501

    def gene_summary_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Summary of gene dataset, including options to download package by POST  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_summary_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param V1alpha1GeneDatasetRequest body: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1DownloadSummary, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gene_summary_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `gene_summary_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/summary', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1DownloadSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gene_tax_name_query(self, organism_query, **kwargs):  # noqa: E501
        """Retrieve list of taxonomy names and is for OrganismQuery  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_tax_name_query(organism_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organism_query: Prefix of organism name (common or scientific) to search (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1SciNameAndIds
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gene_tax_name_query_with_http_info(organism_query, **kwargs)  # noqa: E501

    def gene_tax_name_query_with_http_info(self, organism_query, **kwargs):  # noqa: E501
        """Retrieve list of taxonomy names and is for OrganismQuery  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_tax_name_query_with_http_info(organism_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str organism_query: Prefix of organism name (common or scientific) to search (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1SciNameAndIds, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'organism_query'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gene_tax_name_query" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organism_query' is set
        if self.api_client.client_side_validation and ('organism_query' not in local_var_params or  # noqa: E501
                                                        local_var_params['organism_query'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organism_query` when calling `gene_tax_name_query`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organism_query' in local_var_params:
            path_params['organism_query'] = local_var_params['organism_query']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/tax_name_query/{organism_query}/names', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1SciNameAndIds',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def gene_tax_tree(self, tax_token, **kwargs):  # noqa: E501
        """Retrieve tax tree  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_tax_tree(tax_token, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tax_token: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1Organism
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.gene_tax_tree_with_http_info(tax_token, **kwargs)  # noqa: E501

    def gene_tax_tree_with_http_info(self, tax_token, **kwargs):  # noqa: E501
        """Retrieve tax tree  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.gene_tax_tree_with_http_info(tax_token, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tax_token: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1Organism, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'tax_token'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method gene_tax_tree" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tax_token' is set
        if self.api_client.client_side_validation and ('tax_token' not in local_var_params or  # noqa: E501
                                                        local_var_params['tax_token'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tax_token` when calling `gene_tax_tree`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tax_token' in local_var_params:
            path_params['tax_token'] = local_var_params['tax_token']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/gene/taxonomy/{tax_token}/tree', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1Organism',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
