/**
 * Version of CloudWatch Lambda Insights.
 *
 * @stability stable
 */
export declare abstract class LambdaInsightsVersion {
    /**
     * Version 1.0.54.0.
     *
     * @stability stable
     */
    static readonly VERSION_1_0_54_0: LambdaInsightsVersion;
    /**
     * Version 1.0.86.0.
     *
     * @stability stable
     */
    static readonly VERSION_1_0_86_0: LambdaInsightsVersion;
    /**
     * Version 1.0.89.0.
     *
     * @stability stable
     */
    static readonly VERSION_1_0_89_0: LambdaInsightsVersion;
    /**
     * Version 1.0.98.0.
     *
     * @stability stable
     */
    static readonly VERSION_1_0_98_0: LambdaInsightsVersion;
    /**
     * Use the insights extension associated with the provided ARN.
     *
     * Make sure the ARN is associated
     * with same region as your function
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-extension-versions.html
     * @stability stable
     */
    static fromInsightVersionArn(arn: string): LambdaInsightsVersion;
    private static fromInsightsVersion;
    /**
     * The arn of the Lambda Insights extension.
     *
     * @stability stable
     */
    readonly layerVersionArn: string;
}
