import { BundlingDockerImage, DockerImage } from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface LambdaRuntimeProps {
    /**
     * Whether the ``ZipFile`` (aka inline code) property can be used with this runtime.
     *
     * @default false
     * @stability stable
     */
    readonly supportsInlineCode?: boolean;
    /**
     * The Docker image name to be used for bundling in this runtime.
     *
     * @default - the latest docker image "amazon/public.ecr.aws/sam/build-<runtime>" from https://gallery.ecr.aws
     * @stability stable
     */
    readonly bundlingDockerImage?: string;
    /**
     * Whether this runtime is integrated with and supported for profiling using Amazon CodeGuru Profiler.
     *
     * @default false
     * @stability stable
     */
    readonly supportsCodeGuruProfiling?: boolean;
}
/**
 * @stability stable
 */
export declare enum RuntimeFamily {
    /**
     * @stability stable
     */
    NODEJS = 0,
    /**
     * @stability stable
     */
    JAVA = 1,
    /**
     * @stability stable
     */
    PYTHON = 2,
    /**
     * @stability stable
     */
    DOTNET_CORE = 3,
    /**
     * @stability stable
     */
    GO = 4,
    /**
     * @stability stable
     */
    RUBY = 5,
    /**
     * @stability stable
     */
    OTHER = 6
}
/**
 * Lambda function runtime environment.
 *
 * If you need to use a runtime name that doesn't exist as a static member, you
 * can instantiate a `Runtime` object, e.g: `new Runtime('nodejs99.99')`.
 *
 * @stability stable
 */
export declare class Runtime {
    /**
     * A list of all known `Runtime`'s.
     *
     * @stability stable
     */
    static readonly ALL: Runtime[];
    /**
     * The NodeJS runtime (nodejs) Legacy runtime no longer supported by AWS Lambda.
     *
     * @stability stable
     */
    static readonly NODEJS: Runtime;
    /**
     * The NodeJS 4.3 runtime (nodejs4.3) Legacy runtime no longer supported by AWS Lambda.
     *
     * @stability stable
     */
    static readonly NODEJS_4_3: Runtime;
    /**
     * The NodeJS 6.10 runtime (nodejs6.10) Legacy runtime no longer supported by AWS Lambda.
     *
     * @stability stable
     */
    static readonly NODEJS_6_10: Runtime;
    /**
     * The NodeJS 8.10 runtime (nodejs8.10) Legacy runtime no longer supported by AWS Lambda.
     *
     * @stability stable
     */
    static readonly NODEJS_8_10: Runtime;
    /**
     * The NodeJS 10.x runtime (nodejs10.x).
     *
     * @stability stable
     */
    static readonly NODEJS_10_X: Runtime;
    /**
     * The NodeJS 12.x runtime (nodejs12.x).
     *
     * @stability stable
     */
    static readonly NODEJS_12_X: Runtime;
    /**
     * The NodeJS 14.x runtime (nodejs14.x).
     *
     * @stability stable
     */
    static readonly NODEJS_14_X: Runtime;
    /**
     * The Python 2.7 runtime (python2.7).
     *
     * @stability stable
     */
    static readonly PYTHON_2_7: Runtime;
    /**
     * The Python 3.6 runtime (python3.6).
     *
     * @stability stable
     */
    static readonly PYTHON_3_6: Runtime;
    /**
     * The Python 3.7 runtime (python3.7).
     *
     * @stability stable
     */
    static readonly PYTHON_3_7: Runtime;
    /**
     * The Python 3.8 runtime (python3.8).
     *
     * @stability stable
     */
    static readonly PYTHON_3_8: Runtime;
    /**
     * The Java 8 runtime (java8).
     *
     * @stability stable
     */
    static readonly JAVA_8: Runtime;
    /**
     * The Java 8 Corretto runtime (java8.al2).
     *
     * @stability stable
     */
    static readonly JAVA_8_CORRETTO: Runtime;
    /**
     * The Java 11 runtime (java11).
     *
     * @stability stable
     */
    static readonly JAVA_11: Runtime;
    /**
     * The .NET Core 1.0 runtime (dotnetcore1.0) Legacy runtime no longer supported by AWS Lambda.
     *
     * @stability stable
     */
    static readonly DOTNET_CORE_1: Runtime;
    /**
     * The .NET Core 2.0 runtime (dotnetcore2.0) Legacy runtime no longer supported by AWS Lambda.
     *
     * @stability stable
     */
    static readonly DOTNET_CORE_2: Runtime;
    /**
     * The .NET Core 2.1 runtime (dotnetcore2.1).
     *
     * @stability stable
     */
    static readonly DOTNET_CORE_2_1: Runtime;
    /**
     * The .NET Core 3.1 runtime (dotnetcore3.1).
     *
     * @stability stable
     */
    static readonly DOTNET_CORE_3_1: Runtime;
    /**
     * The Go 1.x runtime (go1.x).
     *
     * @stability stable
     */
    static readonly GO_1_X: Runtime;
    /**
     * The Ruby 2.5 runtime (ruby2.5).
     *
     * @stability stable
     */
    static readonly RUBY_2_5: Runtime;
    /**
     * The Ruby 2.7 runtime (ruby2.7).
     *
     * @stability stable
     */
    static readonly RUBY_2_7: Runtime;
    /**
     * The custom provided runtime (provided).
     *
     * @stability stable
     */
    static readonly PROVIDED: Runtime;
    /**
     * The custom provided runtime (provided).
     *
     * @stability stable
     */
    static readonly PROVIDED_AL2: Runtime;
    /**
     * A special runtime entry to be used when function is using a docker image.
     *
     * @stability stable
     */
    static readonly FROM_IMAGE: Runtime;
    /**
     * The name of this runtime, as expected by the Lambda resource.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Whether the ``ZipFile`` (aka inline code) property can be used with this runtime.
     *
     * @stability stable
     */
    readonly supportsInlineCode: boolean;
    /**
     * Whether this runtime is integrated with and supported for profiling using Amazon CodeGuru Profiler.
     *
     * @stability stable
     */
    readonly supportsCodeGuruProfiling: boolean;
    /**
     * The runtime family.
     *
     * @stability stable
     */
    readonly family?: RuntimeFamily;
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `bundlingImage`
     */
    readonly bundlingDockerImage: BundlingDockerImage;
    /**
     * The bundling Docker image for this runtime.
     *
     * @stability stable
     */
    readonly bundlingImage: DockerImage;
    /**
     * @stability stable
     */
    constructor(name: string, family?: RuntimeFamily, props?: LambdaRuntimeProps);
    /**
     * @stability stable
     */
    toString(): string;
    /**
     * @stability stable
     */
    runtimeEquals(other: Runtime): boolean;
}
