"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.functionInvocationUri = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Generate the lambda function invocation uri for the given lambda within the given scope
 * @param scope scope in which the lambda is deployed
 * @param lambdaFunction the lambda function to be invoked
 */
exports.functionInvocationUri = (scope, lambdaFunction) => {
    const stack = aws_cdk_lib_1.Stack.of(scope);
    return `arn:${stack.partition}:apigateway:${stack.region}:lambda:path/2015-03-31/functions/${lambdaFunction.functionArn}/invocations`;
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvY29uc3RydWN0L3NwZWMvdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUE7c0NBQ3NDO0FBQ3RDLDZDQUFvQztBQUlwQzs7OztHQUlHO0FBQ1UsUUFBQSxxQkFBcUIsR0FBRyxDQUNuQyxLQUFnQixFQUNoQixjQUF5QixFQUNqQixFQUFFO0lBQ1YsTUFBTSxLQUFLLEdBQUcsbUJBQUssQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDOUIsT0FBTyxPQUFPLEtBQUssQ0FBQyxTQUFTLGVBQWUsS0FBSyxDQUFDLE1BQU0scUNBQXFDLGNBQWMsQ0FBQyxXQUFXLGNBQWMsQ0FBQztBQUN4SSxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKiEgQ29weXJpZ2h0IFtBbWF6b24uY29tXShodHRwOi8vYW1hem9uLmNvbS8pLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjAgKi9cbmltcG9ydCB7IFN0YWNrIH0gZnJvbSBcImF3cy1jZGstbGliXCI7XG5pbXBvcnQgeyBJRnVuY3Rpb24gfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWxhbWJkYVwiO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcImNvbnN0cnVjdHNcIjtcblxuLyoqXG4gKiBHZW5lcmF0ZSB0aGUgbGFtYmRhIGZ1bmN0aW9uIGludm9jYXRpb24gdXJpIGZvciB0aGUgZ2l2ZW4gbGFtYmRhIHdpdGhpbiB0aGUgZ2l2ZW4gc2NvcGVcbiAqIEBwYXJhbSBzY29wZSBzY29wZSBpbiB3aGljaCB0aGUgbGFtYmRhIGlzIGRlcGxveWVkXG4gKiBAcGFyYW0gbGFtYmRhRnVuY3Rpb24gdGhlIGxhbWJkYSBmdW5jdGlvbiB0byBiZSBpbnZva2VkXG4gKi9cbmV4cG9ydCBjb25zdCBmdW5jdGlvbkludm9jYXRpb25VcmkgPSAoXG4gIHNjb3BlOiBDb25zdHJ1Y3QsXG4gIGxhbWJkYUZ1bmN0aW9uOiBJRnVuY3Rpb25cbik6IHN0cmluZyA9PiB7XG4gIGNvbnN0IHN0YWNrID0gU3RhY2sub2Yoc2NvcGUpO1xuICByZXR1cm4gYGFybjoke3N0YWNrLnBhcnRpdGlvbn06YXBpZ2F0ZXdheToke3N0YWNrLnJlZ2lvbn06bGFtYmRhOnBhdGgvMjAxNS0wMy0zMS9mdW5jdGlvbnMvJHtsYW1iZGFGdW5jdGlvbi5mdW5jdGlvbkFybn0vaW52b2NhdGlvbnNgO1xufTtcbiJdfQ==