/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { TypeScriptProjectOptions } from "projen/lib/typescript";
import { OpenApiGatewayTsProject, OpenApiGatewayTsProjectOptions } from "./open-api-gateway-ts-project";
import { SmithyApiGatewayProjectOptions } from "./types";
/**
 * Configuration for the SmithyApiGatewayTsProject
 */
export interface SmithyApiGatewayTsProjectOptions extends TypeScriptProjectOptions, SmithyApiGatewayProjectOptions {
}
/**
 * Synthesizes a Typescript Project with a Smithy model, generated clients, a CDK construct for deploying the API
 * with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.
 *
 * @pjid smithy-api-gateway-ts
 */
export declare class SmithyApiGatewayTsProject extends OpenApiGatewayTsProject {
    /**
     * The directory in which the smithy model files reside
     */
    readonly modelDir: string;
    constructor(options: SmithyApiGatewayTsProjectOptions);
    protected preConstruct(options: OpenApiGatewayTsProjectOptions): OpenApiGatewayTsProjectOptions;
}
