"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupSmithyBuild = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const smithy_build_project_1 = require("./smithy-build-project");
/**
 * Adds the common subprojects for building a Smithy model into an OpenAPI spec
 */
exports.setupSmithyBuild = (project, options) => {
    const modelDir = options.modelDir ?? "model";
    const { serviceName } = options.serviceName;
    const smithyBuildDir = "smithy";
    const smithyBuildOutputSubDir = "output";
    // Create the smithy build project, responsible for transforming the model into an OpenAPI spec
    const smithyBuild = new smithy_build_project_1.SmithyBuildProject({
        name: `${project.name}-smithy-build`,
        parent: project,
        outdir: smithyBuildDir,
        serviceName: options.serviceName,
        smithyBuildOptions: options.smithyBuildOptions,
        buildOutputDir: smithyBuildOutputSubDir,
    });
    smithyBuild.synth();
    const smithyBuildOutputDir = path.join(smithyBuildDir, smithyBuildOutputSubDir);
    // Ignore smithy build output by default
    if (options.ignoreSmithyBuildOutput ?? true) {
        project.gitignore.addPatterns(smithyBuildOutputDir);
    }
    // Ignore gradle wrapper by default
    if (options.ignoreGradleWrapper ?? true) {
        project.gitignore.addPatterns(path.join(smithyBuildDir, "gradle"));
        project.gitignore.addPatterns(path.join(smithyBuildDir, "gradlew"));
        project.gitignore.addPatterns(path.join(smithyBuildDir, "gradlew.bat"));
    }
    // Ignore the .gradle directory
    project.gitignore.addPatterns(path.join(smithyBuildDir, ".gradle"));
    project.gitignore.addPatterns(path.join(smithyBuildDir, "build"));
    return {
        modelDir,
        // Generated spec is written to output/<projection id>/<plugin id>/<service name>.openapi.json
        generatedSpecFilePath: path.join(smithyBuild.smithyBuildOutputPath, "openapi", "openapi", `${serviceName}.openapi.json`),
    };
};
//# sourceMappingURL=data:application/json;base64,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