partitioning
============

Пакет содержит набор утилит для применения секционирования.

В настоящее время поддерживается только помесячное разбиение таблиц БД на
разделы.

Для использования секционирования таблиц необходимо выполнить следующие
шаги:

1. Проинициализировать средства секционирования для базы данных. Для
   этого следует выполнить функцию ``init``. Функция должна выполняться
   ОДИН раз для КАЖДОЙ базы данных, используемых системой. В результате
   выполнения функции в указанной БД будут созданы необходимые функции
   для поддержки секционирования.
2. Включить секционирование для конкретных таблиц с помощью функции
   ``set_partitioning``. В результате для указанной таблицы будут созданы
   необходимые триггеры. После этого при добавлении/редактировании записей
   секционированной таблицы записи будут размещаться в разделах таблицы.
   Если соответствующие разделы отсутствуют, то они будут создаваться
   автоматически.
3. При необходимости, можно выполнить перенос записей из родительской таблицы в
   ее разделы. Для этого предназначена функция ``split_table``. Для снижения
   нагрузки на СУБД записи переносятся по отдельности, при этом можно задать
   время ожидания между переносом каждой записи.

После выполнения указанных действий с секционированной таблицей можно
продолжать работать как с обычной таблицей.

Подробнее о секционировании можно почитать в документации PostgreSQL
https://postgrespro.ru/docs/postgrespro/9.5/ddl-partitioning.

management-команды
==================

Пакет также содержит management-команды, которые позволяют упростить процесс
применения секционирования.

Зависимости
-----------

* Django 2.2+

Установка
---------

Необходимо добавить ``django_postgres_partitioning`` в ``settings.INSTALLED_APPS``.

Инициализация и применение секционирования
------------------------------------------

Проинициализировать, если это необходимо, средства секционирования и включить
секционирования для конкретной таблицы можно с помощью команды ``apply_partitioning``:

```bash
$ ./manage.py apply_partitioning app_label model_name field_name
```

где ``app_label`` -- лейбл приложения, ``model_name`` -- имя модели, а ``field_label`` -- название поля.
``field_name`` выступает в качестве ключа секционирования.

Перенос записей из родительской таблицы в ее разделы
----------------------------------------------------

Разбить все данные в родительской таблице по ключу секционирования и перенести в соответствующие
секции можно с помощью management-команды ``split_table``:

```bash
$ ./manage.py split_table app_label model_name field_name --timeout 5
```

``--timeout`` задает время ожидания между переносом каждой записи из родительской таблицы
в соответствующую секцию.
