"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateName = exports.renderAutoRollbackConfiguration = exports.renderAlarmConfiguration = exports.arnForDeploymentConfig = exports.arnForDeploymentGroup = exports.arnForApplication = void 0;
const core_1 = require("@aws-cdk/core");
function arnForApplication(applicationName) {
    return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:application:${applicationName}`;
}
exports.arnForApplication = arnForApplication;
function arnForDeploymentGroup(applicationName, deploymentGroupName) {
    return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:deploymentgroup:${applicationName}/${deploymentGroupName}`;
}
exports.arnForDeploymentGroup = arnForDeploymentGroup;
function arnForDeploymentConfig(name) {
    return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:deploymentconfig:${name}`;
}
exports.arnForDeploymentConfig = arnForDeploymentConfig;
function renderAlarmConfiguration(alarms, ignorePollAlarmFailure) {
    return alarms.length === 0
        ? undefined
        : {
            alarms: alarms.map(a => ({ name: a.alarmName })),
            enabled: true,
            ignorePollAlarmFailure,
        };
}
exports.renderAlarmConfiguration = renderAlarmConfiguration;
var AutoRollbackEvent;
(function (AutoRollbackEvent) {
    AutoRollbackEvent["DEPLOYMENT_FAILURE"] = "DEPLOYMENT_FAILURE";
    AutoRollbackEvent["DEPLOYMENT_STOP_ON_ALARM"] = "DEPLOYMENT_STOP_ON_ALARM";
    AutoRollbackEvent["DEPLOYMENT_STOP_ON_REQUEST"] = "DEPLOYMENT_STOP_ON_REQUEST";
})(AutoRollbackEvent || (AutoRollbackEvent = {}));
function renderAutoRollbackConfiguration(alarms, autoRollbackConfig = {}) {
    const events = new Array();
    // we roll back failed deployments by default
    if (autoRollbackConfig.failedDeployment !== false) {
        events.push(AutoRollbackEvent.DEPLOYMENT_FAILURE);
    }
    // we _do not_ roll back stopped deployments by default
    if (autoRollbackConfig.stoppedDeployment === true) {
        events.push(AutoRollbackEvent.DEPLOYMENT_STOP_ON_REQUEST);
    }
    // we _do not_ roll back alarm-triggering deployments by default
    // unless the Deployment Group has at least one alarm
    if (autoRollbackConfig.deploymentInAlarm !== false) {
        if (alarms.length > 0) {
            events.push(AutoRollbackEvent.DEPLOYMENT_STOP_ON_ALARM);
        }
        else if (autoRollbackConfig.deploymentInAlarm === true) {
            throw new Error("The auto-rollback setting 'deploymentInAlarm' does not have any effect unless you associate " +
                'at least one CloudWatch alarm with the Deployment Group');
        }
    }
    return events.length > 0
        ? {
            enabled: true,
            events,
        }
        : undefined;
}
exports.renderAutoRollbackConfiguration = renderAutoRollbackConfiguration;
function validateName(type, name) {
    const ret = [];
    if (!core_1.Token.isUnresolved(name) && name !== undefined) {
        if (name.length > 100) {
            ret.push(`${type} name: "${name}" can be a max of 100 characters.`);
        }
        if (!/^[a-z0-9._+=,@-]+$/i.test(name)) {
            ret.push(`${type} name: "${name}" can only contain letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), + (plus signs), = (equals signs), , (commas), @ (at signs), - (minus signs).`);
        }
    }
    return ret;
}
exports.validateName = validateName;
//# sourceMappingURL=data:application/json;base64,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