import datetime
from typing import Any, Dict, Type, TypeVar, Union

import attr
from dateutil.parser import isoparse

from ..types import UNSET, Unset

T = TypeVar("T", bound="SamlRoleMappingDto")


@attr.s(auto_attribs=True)
class SamlRoleMappingDto:
    """ """

    id: Union[Unset, None, str] = UNSET
    created_at: Union[Unset, datetime.datetime] = UNSET
    updated_at: Union[Unset, datetime.datetime] = UNSET
    service_provider_role: Union[Unset, None, str] = UNSET
    identity_provider_role: Union[Unset, None, str] = UNSET

    def to_dict(self) -> Dict[str, Any]:
        id = self.id
        created_at: Union[Unset, str] = UNSET
        if not isinstance(self.created_at, Unset):
            created_at = self.created_at.isoformat()

        updated_at: Union[Unset, str] = UNSET
        if not isinstance(self.updated_at, Unset):
            updated_at = self.updated_at.isoformat()

        service_provider_role = self.service_provider_role
        identity_provider_role = self.identity_provider_role

        field_dict: Dict[str, Any] = {}
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if created_at is not UNSET:
            field_dict["createdAt"] = created_at
        if updated_at is not UNSET:
            field_dict["updatedAt"] = updated_at
        if service_provider_role is not UNSET:
            field_dict["serviceProviderRole"] = service_provider_role
        if identity_provider_role is not UNSET:
            field_dict["identityProviderRole"] = identity_provider_role

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        id = d.pop("id", UNSET)

        _created_at = d.pop("createdAt", UNSET)
        created_at: Union[Unset, datetime.datetime]
        if isinstance(_created_at, Unset):
            created_at = UNSET
        else:
            created_at = isoparse(_created_at)

        _updated_at = d.pop("updatedAt", UNSET)
        updated_at: Union[Unset, datetime.datetime]
        if isinstance(_updated_at, Unset):
            updated_at = UNSET
        else:
            updated_at = isoparse(_updated_at)

        service_provider_role = d.pop("serviceProviderRole", UNSET)

        identity_provider_role = d.pop("identityProviderRole", UNSET)

        saml_role_mapping_dto = cls(
            id=id,
            created_at=created_at,
            updated_at=updated_at,
            service_provider_role=service_provider_role,
            identity_provider_role=identity_provider_role,
        )

        return saml_role_mapping_dto
