/// <reference types="node" />
import { AssetCode, Runtime } from '@aws-cdk/aws-lambda';
import * as cdk from '@aws-cdk/core';
import { BundlingOptions } from './types';
/**
 * Bundling properties
 */
export interface BundlingProps extends BundlingOptions {
    /**
     * Path to lock file
     */
    readonly depsLockFilePath: string;
    /**
     * Entry file
     */
    readonly entry: string;
    /**
     * The runtime of the lambda function
     */
    readonly runtime: Runtime;
}
/**
 * Bundling with esbuild
 */
export declare class Bundling implements cdk.BundlingOptions {
    private readonly props;
    /**
     * esbuild bundled Lambda asset code
     */
    static bundle(options: BundlingProps): AssetCode;
    static clearRunsLocallyCache(): void;
    private static runsLocally?;
    readonly image: cdk.BundlingDockerImage;
    readonly command: string[];
    readonly environment?: {
        [key: string]: string;
    };
    readonly workingDirectory: string;
    readonly local?: cdk.ILocalBundling;
    private readonly relativeEntryPath;
    private readonly relativeTsconfigPath?;
    private readonly externals;
    constructor(props: BundlingProps);
    createBundlingCommand(inputDir: string, outputDir: string, osPlatform?: NodeJS.Platform): string;
}
