"""
    Fink SQL Rest API

    Flink SQL Rest API  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from flink_sql_gateway_client.api_client import ApiClient, Endpoint as _Endpoint
from flink_sql_gateway_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)
from flink_sql_gateway_client.model.create_session_request import CreateSessionRequest
from flink_sql_gateway_client.model.create_session_response import CreateSessionResponse
from flink_sql_gateway_client.model.execute_statement_request import (
    ExecuteStatementRequest,
)
from flink_sql_gateway_client.model.execute_statement_response import (
    ExecuteStatementResponse,
)
from flink_sql_gateway_client.model.job_status_response import JobStatusResponse
from flink_sql_gateway_client.model.result_fetch_request import ResultFetchRequest
from flink_sql_gateway_client.model.result_fetch_response import ResultFetchResponse
from flink_sql_gateway_client.model.session_status_response import SessionStatusResponse


class FlinkSqlApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __cancel_job(self, session_id, job_id, **kwargs):
            """Cancel Flink SQL job in session.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.cancel_job(session_id, job_id, async_req=True)
            >>> result = thread.get()

            Args:
                session_id (str): String value that identifies a session.  Create using /session post commang
                job_id (str): String value that identifies a job.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JobStatusResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["session_id"] = session_id
            kwargs["job_id"] = job_id
            return self.call_with_http_info(**kwargs)

        self.cancel_job = _Endpoint(
            settings={
                "response_type": (JobStatusResponse,),
                "auth": [],
                "endpoint_path": "/sessions/{session_id}/jobs/{job_id}",
                "operation_id": "cancel_job",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "session_id",
                    "job_id",
                ],
                "required": [
                    "session_id",
                    "job_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "session_id": (str,),
                    "job_id": (str,),
                },
                "attribute_map": {
                    "session_id": "session_id",
                    "job_id": "job_id",
                },
                "location_map": {
                    "session_id": "path",
                    "job_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__cancel_job,
        )

        def __cancel_session(self, session_id, **kwargs):
            """Cancel Flink SQL job in session.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.cancel_session(session_id, async_req=True)
            >>> result = thread.get()

            Args:
                session_id (str): String value that identifies a session.  Create using /session post commang

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SessionStatusResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["session_id"] = session_id
            return self.call_with_http_info(**kwargs)

        self.cancel_session = _Endpoint(
            settings={
                "response_type": (SessionStatusResponse,),
                "auth": [],
                "endpoint_path": "/sessions/{session_id}",
                "operation_id": "cancel_session",
                "http_method": "DELETE",
                "servers": None,
            },
            params_map={
                "all": [
                    "session_id",
                ],
                "required": [
                    "session_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "session_id": (str,),
                },
                "attribute_map": {
                    "session_id": "session_id",
                },
                "location_map": {
                    "session_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__cancel_session,
        )

        def __create_session(self, create_session_request, **kwargs):
            """Creates a session to run flink sql jobs  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_session(create_session_request, async_req=True)
            >>> result = thread.get()

            Args:
                create_session_request (CreateSessionRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreateSessionResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["create_session_request"] = create_session_request
            return self.call_with_http_info(**kwargs)

        self.create_session = _Endpoint(
            settings={
                "response_type": (CreateSessionResponse,),
                "auth": [],
                "endpoint_path": "/sessions",
                "operation_id": "create_session",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "create_session_request",
                ],
                "required": [
                    "create_session_request",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "create_session_request": (CreateSessionRequest,),
                },
                "attribute_map": {},
                "location_map": {
                    "create_session_request": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
            callable=__create_session,
        )

        def __execute_statement(self, session_id, execute_statement_request, **kwargs):
            """Executes Flink SQL statement in session.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.execute_statement(session_id, execute_statement_request, async_req=True)
            >>> result = thread.get()

            Args:
                session_id (str): String value that identifies a session.  Create using /session post commang
                execute_statement_request (ExecuteStatementRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ExecuteStatementResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["session_id"] = session_id
            kwargs["execute_statement_request"] = execute_statement_request
            return self.call_with_http_info(**kwargs)

        self.execute_statement = _Endpoint(
            settings={
                "response_type": (ExecuteStatementResponse,),
                "auth": [],
                "endpoint_path": "/sessions/{session_id}/statements",
                "operation_id": "execute_statement",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "session_id",
                    "execute_statement_request",
                ],
                "required": [
                    "session_id",
                    "execute_statement_request",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "session_id": (str,),
                    "execute_statement_request": (ExecuteStatementRequest,),
                },
                "attribute_map": {
                    "session_id": "session_id",
                },
                "location_map": {
                    "session_id": "path",
                    "execute_statement_request": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
            callable=__execute_statement,
        )

        def __get_job_results(
            self, session_id, job_id, token, result_fetch_request, **kwargs
        ):
            """Get results of a Flink SQL job.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_job_results(session_id, job_id, token, result_fetch_request, async_req=True)
            >>> result = thread.get()

            Args:
                session_id (str): String value that identifies a session.  Create using /session post commang
                job_id (str): String value that identifies a job.
                token (int): Token value to get results, If it's the first time the token value must be 0. To fetch the next part of the result, increase token by 1 and call this API again.
                result_fetch_request (ResultFetchRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ResultFetchResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["session_id"] = session_id
            kwargs["job_id"] = job_id
            kwargs["token"] = token
            kwargs["result_fetch_request"] = result_fetch_request
            return self.call_with_http_info(**kwargs)

        self.get_job_results = _Endpoint(
            settings={
                "response_type": (ResultFetchResponse,),
                "auth": [],
                "endpoint_path": "/sessions/{session_id}/jobs/{job_id}/result/{token}",
                "operation_id": "get_job_results",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "session_id",
                    "job_id",
                    "token",
                    "result_fetch_request",
                ],
                "required": [
                    "session_id",
                    "job_id",
                    "token",
                    "result_fetch_request",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "session_id": (str,),
                    "job_id": (str,),
                    "token": (int,),
                    "result_fetch_request": (ResultFetchRequest,),
                },
                "attribute_map": {
                    "session_id": "session_id",
                    "job_id": "job_id",
                    "token": "token",
                },
                "location_map": {
                    "session_id": "path",
                    "job_id": "path",
                    "token": "path",
                    "result_fetch_request": "body",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": ["application/json"],
            },
            api_client=api_client,
            callable=__get_job_results,
        )

        def __get_job_status(self, session_id, job_id, **kwargs):
            """Get Flink SQL job status in session.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_job_status(session_id, job_id, async_req=True)
            >>> result = thread.get()

            Args:
                session_id (str): String value that identifies a session.  Create using /session post commang
                job_id (str): String value that identifies a job.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JobStatusResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["session_id"] = session_id
            kwargs["job_id"] = job_id
            return self.call_with_http_info(**kwargs)

        self.get_job_status = _Endpoint(
            settings={
                "response_type": (JobStatusResponse,),
                "auth": [],
                "endpoint_path": "/sessions/{session_id}/jobs/{job_id}/status",
                "operation_id": "get_job_status",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "session_id",
                    "job_id",
                ],
                "required": [
                    "session_id",
                    "job_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "session_id": (str,),
                    "job_id": (str,),
                },
                "attribute_map": {
                    "session_id": "session_id",
                    "job_id": "job_id",
                },
                "location_map": {
                    "session_id": "path",
                    "job_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
            callable=__get_job_status,
        )

        def __heartbeat_session(self, session_id, **kwargs):
            """Executes Flink SQL heartbeat to keep session alive.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.heartbeat_session(session_id, async_req=True)
            >>> result = thread.get()

            Args:
                session_id (str): String value that identifies a session.  Create using /session post commang

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs["async_req"] = kwargs.get("async_req", False)
            kwargs["_return_http_data_only"] = kwargs.get(
                "_return_http_data_only", True
            )
            kwargs["_preload_content"] = kwargs.get("_preload_content", True)
            kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
            kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
            kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
            kwargs["_host_index"] = kwargs.get("_host_index")
            kwargs["session_id"] = session_id
            return self.call_with_http_info(**kwargs)

        self.heartbeat_session = _Endpoint(
            settings={
                "response_type": None,
                "auth": [],
                "endpoint_path": "/sessions/{session_id}/heartbeat",
                "operation_id": "heartbeat_session",
                "http_method": "POST",
                "servers": None,
            },
            params_map={
                "all": [
                    "session_id",
                ],
                "required": [
                    "session_id",
                ],
                "nullable": [],
                "enum": [],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {},
                "openapi_types": {
                    "session_id": (str,),
                },
                "attribute_map": {
                    "session_id": "session_id",
                },
                "location_map": {
                    "session_id": "path",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": [],
                "content_type": [],
            },
            api_client=api_client,
            callable=__heartbeat_session,
        )
